#include "Master.h"
#include "mbed.h"

#include "../../System/Using.h"

uint8_t masterSendBuffer[MASTER_RS485_SEND_DATA_SIZE+6] = {0};
uint8_t masterReceiveBuffer[MASTER_RS485_RECEIVE_DATA_SIZE+1] = {0};

MasterSendData masterSend;
MasterReceiveData masterReceive;

namespace MASTER
{
    void Master::Initialize() {
        masterSend.data0 = 0x00;
        masterSend.data1 = 0x00;
        masterReceive.data0 = 0x00;
        masterReceive.data1 = 0x00;

        Update();
    }

    void Master::Update() {
        masterSendBuffer[0] = '*';
        masterSendBuffer[1] = masterSend.data0;
        masterSendBuffer[2] = masterSend.data1;
        masterSendBuffer[3] = masterSend.data0 + masterSend.data1;
        masterSendBuffer[4] = '\r';
        masterSendBuffer[5] = 0;
        masterSendBuffer[6] = 0;
        masterSendBuffer[7] = 0;

        masterReceive.data0 = masterReceiveBuffer[0];
        masterReceive.data1 = masterReceiveBuffer[1];
    }
}
