#include "Mu.h"

namespace MU {
    Serial MuUart(MU_TX, MU_RX);

    namespace {
        char Group[][4]     = {"01", "02", "03", "04"};
        char Channel[][4]   = {"08", "14", "1F", "2E"};
        char DI[][4]        = {"10", "20", "40", "80"};
        char EI[][4]        = {"01", "02", "04", "08"};
    }

    void Mu::SendCommand(char *command, char *value, uint8_t valueLength) {
        MuUart.putc('@');
        MuUart.putc(command[0]);
        MuUart.putc(command[1]);
        while(valueLength--) {
            MuUart.putc(*value);
            value++;
        }
        MuUart.putc('\r');
        MuUart.putc('\n');
    }

    void Mu::Initialize(uint8_t select) {
        MuUart.baud(19200);

        Mu::SendCommand("GI",Group[select],2);
        Mu::SendCommand("CH",Channel[select],2);
        Mu::SendCommand("DI",DI[select],2);
        Mu::SendCommand("EI",EI[select],2);
    }
}