/*
* RingBuffer.cpp
*
* Created: 2016/08/10 12:14:47
*  Author: masuk
*/

#include "mbed.h"
#include "RingBuffer.h"

namespace RINGBUFFER
{

    RingBuffer::RingBuffer(char *bufPtr, int size)
    {
        Buffer.data = bufPtr;
        Buffer.size = size;
        Buffer.top = 0;
        Buffer.bottom = 0;
        Buffer.fullup = false;
    }

    void RingBuffer::PutData(char data, bool ASCIItoNum /* = false */)
    {
        __disable_irq();
        if(!Buffer.fullup)
        {
            if(ASCIItoNum) Buffer.data[Buffer.top] = data+48;
            else           Buffer.data[Buffer.top] = data;
            Buffer.length++;
            Buffer.top++;
            Buffer.top %= Buffer.size;
            Buffer.fullup = false;
            if(Buffer.length>=Buffer.size) Buffer.fullup = true;
        }
        __enable_irq();
    }

    void RingBuffer::PutData(char *data, int length)
    {
        __disable_irq();
        for(int i=0; i<length; i++)
        {
            if(!Buffer.fullup)
            {
                Buffer.data[Buffer.top] = data[i];
                Buffer.length++;
                Buffer.top++;
                Buffer.top %= Buffer.size;
                Buffer.fullup = false;
                if(Buffer.length>=Buffer.size) Buffer.fullup = true;
            }
        }
        __enable_irq();
    }

    void RingBuffer::PutData(const char *str)
    {
        __disable_irq();
        for( ; *str!='\0'; str++)
        {
            if(!Buffer.fullup)
            {
                Buffer.data[Buffer.top] = *str;
                Buffer.length++;
                Buffer.top++;
                Buffer.top %= Buffer.size;
                if(Buffer.length>=Buffer.size) Buffer.fullup = true;
                else                           Buffer.fullup = false;
            }
        }
        __enable_irq();
    }

    char RingBuffer::GetData()
    {
        __disable_irq();
        char data;
        if(Buffer.length > 0)
        {
            data = Buffer.data[Buffer.bottom];
            Buffer.length--;
            Buffer.bottom++;
            Buffer.bottom %= Buffer.size;
            if(Buffer.length<Buffer.size) Buffer.fullup = false;
        }
        else data = '\0';
        __enable_irq();
        return data;
    }

    bool RingBuffer::IsFullup()
    {
        return Buffer.fullup;
    }

    bool RingBuffer::InAnyData()
    {
        if(Buffer.length > 0) return true;
        else return false;
    }

}
