
/*
                                #############           #
                                            #           #
                                            #           #
                                            #           #
                        まじ    #########################
                                #           #
                                #           #
                                #           #
                                #           #############
*/

#include "RS485.h"
#include "mbed.h"
#include "ActuatorHub/ActuatorHub.h"
#include "Master/Master.h"
#include "../../LED/LED.h"
#include "../../System/Using.h"

namespace RS485 {
    DigitalOut MasterSelectBit(MASTER_SELECTBIT_PIN);
    DigitalOut HubSelectBit(HUB_SELECTBIT_PIN);
    Serial MasterRS485Uart(MASTER_RS485UART_TX, MASTER_RS485UART_RX);
    Serial HubRS485Uart(HUB_RS485UART_TX,HUB_RS485UART_RX);
    Ticker LostTimer;
    Timeout sendTimer;

    //Serial pc(USBTX, USBRX, 38400);

    void HubTransmit();
    void MasterReceive();
    void MasterTransmit();
    void LostTimer_func();
    void SendTimer_func();

    namespace
    {
        volatile char buf[MASTER_RS485_RECEIVE_DATA_SIZE+1];
        bool communicationLost = true;
        uint8_t timerCount = 0;

        uint8_t sendCnt = 0;
    }

    void RS485::Initialize() {
        HubSelectBit = 1;
        HubRS485Uart.baud(38400);
        HubRS485Uart.attach(HubTransmit,Serial::TxIrq);
        
        MasterSelectBit = 1;    //送信からスタート
        MasterRS485Uart.baud(38400);
        MasterRS485Uart.attach(NULL, Serial::RxIrq);
        MasterRS485Uart.attach(MasterTransmit, Serial::TxIrq);
        LostTimer.attach(LostTimer_func, 0.01);
    }
    
    void HubTransmit() {
        //__disable_irq();
        HubRS485Uart.putc(HubRS485SendBuffer.GetData());
        //__enable_irq();
    }

    bool RS485::IsCommunicationLost() {return communicationLost;}

    void MasterReceive() {
        __disable_irq();
        static Phase phase = ReceiveWait;
        static uint8_t count = 0;
        static uint8_t checkSum = 0;

        uint8_t data = MasterRS485Uart.getc();

        switch(phase)
        {
            case DataReceive :
                if(count < MASTER_RS485_RECEIVE_DATA_SIZE+1) {
                    buf[count] = data;
                    if(count < MASTER_RS485_RECEIVE_DATA_SIZE) checkSum += data;
                    count++;
                } else {
                    if(count == MASTER_RS485_RECEIVE_DATA_SIZE+1 && data == '\r' && checkSum == buf[count-1]) {
                        for(uint8_t i=0; i<count-1; i++) masterReceiveBuffer[i] = buf[i];
                        static uint8_t cnt = 0;
                        if(cnt >= 0x0f) {
                            LED_DEBUG1 = !LED_DEBUG1;
                            cnt = 0;
                        } else cnt++;
                        communicationLost = false;
                    }
                    phase = ReceiveWait;
                    MasterSelectBit = 1;    //送信
                    MasterRS485Uart.attach(NULL, Serial::RxIrq);
                    MasterRS485Uart.attach(MasterTransmit, Serial::TxIrq);
                    //sendTimer.attach(SendTimer_func, 0.01);
                    timerCount = 0;
                }
                break;

            case ReceiveWait :
                if(data == '*') {
                    phase = DataReceive;
                    count = 0;
                    checkSum = 0;
                }
                break;

            default:
                phase = ReceiveWait;
                break;
        }

         //pc.putc(data);

        __enable_irq();
     }

     void MasterTransmit() {
        __disable_irq();
        timerCount = 0;

        MasterRS485Uart.putc(masterSendBuffer[sendCnt]);
        //pc.putc(masterSendBuffer[sendCnt]);

        if(sendCnt == MASTER_RS485_SEND_DATA_SIZE+4) {
            MasterSelectBit = 0;
            MasterRS485Uart.attach(NULL, Serial::TxIrq);
            MasterRS485Uart.attach(MasterReceive, Serial::RxIrq);
            sendCnt = 0;
       } else sendCnt++;
       __enable_irq();
     }

     void LostTimer_func() {
        timerCount++;
        if(timerCount >= 2 && timerCount < 20) {
            MasterSelectBit = 1;
            sendCnt = 0;
            MasterRS485Uart.attach(NULL, Serial::RxIrq);
            MasterRS485Uart.attach(MasterTransmit, Serial::TxIrq);
        }
        if(timerCount >= 80) {
            timerCount = 0;
            MasterSelectBit = 1;
            sendCnt = 0;
            MasterRS485Uart.attach(NULL, Serial::RxIrq);
            MasterRS485Uart.attach(MasterTransmit, Serial::TxIrq);
            communicationLost = true;
        }
 
     }

     void SendTimer_func() {
        MasterRS485Uart.attach(MasterTransmit, Serial::TxIrq);
     }
}
