#ifndef MASTER_H_
#define MASTER_H_

#include <stdint.h>

typedef struct
{
    union
    {
        struct
        {
            uint8_t processNum : 4;
            uint8_t rollerHeight : 2;
            bool lowerRoller : 1;
            bool higherRoller : 1;
        };
        uint8_t data0;
    };
    union
    {
        struct
        {
            bool launch : 1;
            bool flagJ : 1;
            bool flagK : 1;
            bool flagL : 1;
            bool flagM : 1;
            bool flagN : 1;
            bool flagO : 1;
            bool flagP : 1;
        };
        uint8_t data1;
    };
} MasterSendData;

typedef struct
{
    union
    {
        struct
        {
            bool ems : 1;
            bool startSw : 1;
            bool zoneIsRed : 1;
            bool position : 1;
            bool flagE : 1;
            bool flagF : 1;
            bool flagG : 1;
            bool flagH : 1;
        };
        uint8_t data0;
    };
    union
    {
        struct
        {
            bool flagI : 1;
            bool flagJ : 1;
            bool flagK : 1;
            bool flagL : 1;
            bool flagM : 1;
            bool flagN : 1;
            bool flagO : 1;
            bool flagP : 1;
        };
        uint8_t data1;
    };
} MasterReceiveData;

namespace MASTER
{
    class Master
    {
        public :
        static void Initialize();
        static void Update();
    };
}

extern uint8_t masterSendBuffer[];
extern uint8_t masterReceiveBuffer[];

extern MasterSendData masterSend;
extern MasterReceiveData masterReceive;

#endif
