/*
 * RingBuffer.h
 *
 * Created: 2016/08/10 12:15:08
 *  Author: masuk
 */ 


#ifndef RINGBUFFER_H_
#define RINGBUFFER_H_

#include <stdint.h>

namespace RINGBUFFER
{
    //循環型バッファ　使用するバッファの配列と大きさを指定してください
    class RingBuffer
    {
        struct
        {
            char *data;
            int size;
            uint8_t top;
            uint8_t bottom;
            uint8_t length;
            bool fullup;
        }Buffer;
        
        public:
        RingBuffer(char *bufPtr, int size);
        
        //バッファにデータを追加
        void PutData(char data, bool ASCIItoNum = false);
        void PutData(char *data, int length);
        void PutData(const char *str);
        
        //バッファからデータを1byte読み出し
        char GetData(); 
        
        //バッファが飽和しているか確認
        bool IsFullup();
        //バッファにデータが存在するか確認
        bool InAnyData();
    };
}



#endif /* RINGBUFFER_H_ */