/*
** 位相一致法の計算をする
** 2018/07/04
*/

#ifndef _PHASEMETHOD_H
#define _PHASEMETHOD_H

#include "mbed.h"
#include "Adc.h"
#include "Thermometer.h"

#define INT_WINDOW    1500                 // 積分窓:1ms分のデータ(AD変換が1.5MHzのため)
#define REF_VALUE     2500.0               // 積分窓を開始する闘値
#define M_PI          3.141592653589793    // 円周率
#define SYNCHRO_DELAY 255.0 / 1000000.0    // Nucleo同士の同期遅れ 255µs (平均 (誤差最大5µs))
#define SAMPLING 1.0 / (1.5 * 1000000.0)   // サンプリング 1.5MHz を秒に変換
#define PERIOD   2.0 / 1000.0              // syncPatternの周期
#define TX_SYNC  1.0 / 1000.0              // 送信側で生成したsyncPatternの中心の時間

class PhaseMethod{
private:
    Adc* adc;
    Thermometer* thermometer;

    double sinc(double x);  // 標本化関数
    
public:
    void init(Adc* adc, Thermometer* thermometer);
    void selectSync();
    void calculation();
    
    double epoch;
    double TxTime;         // 伝播時間
    double arriveTime;     // 到達時間
    double distance;       // 距離
    double I1;
    double I2;
    double Q1;
    double Q2;
    
    int calAdcVal[INT_WINDOW];   // 位相一致で使う値を格納
};
#endif
