/* Simpler prog based on the serial passthrough code to enable a command line driven test of esp8266
* wifi modules.
* NB this uses the mbed sleep() command to form a low power system but on some MCUs this is a problem
* this works fine on an lpc1768 but not as yet on the KL25Z
*/

#include "mbed.h"
#include "DS1820.h"

Serial pc(USBTX, USBRX); // serial terminal for the pc connection
Serial dev(PTE0,PTE1);  // for KL25Z... asuming one can't use the PTA1 version which is the stdio
DigitalOut led1(LED1); // two leds
DigitalOut led2(LED2); // to allow visual check of bidirectional comms
DigitalOut led3(LED3); //third led to check status of loading
DigitalOut rst(PTD7); // single digital pin to drive the esp8266 reset line


PwmOut Lights(PTE31); // Output to the lighting system
AnalogIn V1(PTB0);    // Input from the LDR voltage level telling us brightness information

const int MAX_PROBES = 1;
DS1820* probe[MAX_PROBES];
DigitalOut fan(PTB11);

bool AUTO = false;      //Sets whether we are sending data to the server or not
float Temp = 0;
int Dummy = 0;
float intensity = 0;
int LightStatus = 0;
int START = 0;

// subroutine to run anytime a serial interrupt arrives from the device
// this basically passes everything thatthe device produces on to the pc terminal screen
/*void dev_recv()
{

    led1 = !led1;
    while(dev.readable()) {
        pc.putc(dev.getc());

    }
}*/
// subroutine to service the serial interrupt on the pc connection
// this is a bit more complex - it takes what the use sends on the pc and copies it on to the device
// the esp should echo these straight back to the the pc if all is well
// this also detects the end of command character which is ascii 13 (0x0d) adn adds a linefeed after it =asscii 10 (0x0a)
/*void pc_recv()
{
    char c;
    led2 = !led2;
    while(pc.readable()) {
        c = pc.getc();
        dev.putc(c);
        //   pc.putc(c); // echo back
        if(c==13) {
            dev.putc(10); // send the linefeed to complement the carriage return generated by return key on the pc
            pc.putc(10);
        }
    }
}
*/
void NEWMESSAGE()
{
    char message;
    pc.putc('#');
    while (dev.readable()) {
        message= (char)dev.getc();
        pc.putc(message);
        if(message==':') {
            message= (char)dev.getc();
            break;
        }
    }
    if(message == 'G') {
        START = 1;
    }
    if(message == 'Q') {
        AUTO=!AUTO;
        pc.printf("AUTO=!AUTO\r\n",AUTO);
        pc.putc(message);
    }
    if(message == 'K') {
        fan = 1;
        pc.putc(message);
    }
    if(message == 'L') {
        fan = 0;
        pc.putc(message);
    }
    if(message == 'Z') {
        Lights = 0;
        LightStatus = 0;
        pc.putc(message);
    }
    if(message == 'X') {
        Lights = 0.1;
        LightStatus = 1;
        pc.putc(message);
    }
    if(message == 'Y') {
        Lights = 0.5;
        LightStatus = 2;
        pc.putc(message);
    }
    if(message == 'W') {
        Lights = 1;
        LightStatus = 3;
        pc.putc(message);
    }
}

int main()
{
    pc.baud(115200);
    dev.baud(115200);
    printf("Start \r\n");
    rst=0;
    wait(3);
    rst = 1; // send the esp8266 reset
    wait(1);


    // pc.attach(&pc_recv, Serial::RxIrq); // attach the two interrupt services
    // dev.attach(&dev_recv, Serial::RxIrq);
    wait(5);
    dev.printf("AT+RST\r\n");
    wait(10);
    dev.printf("AT+CWJAP=\"BTHub3-WXWX\",\"fdd6f7c682\"\r\n"); //Don't necessarily need this line as it already should connect
    wait(10);
    dev.printf("AT+CIPMUX=1\r\n");
    wait(1);
    dev.printf("AT+CIPSTART=4,\"TCP\",\"192.168.1.95\",333\r\n");
    wait(2);
    /*dev.printf("AT+CIPSEND=4,4\r\n");
    wait(1);
    dev.printf("TEST\r\n");
    wait(1);*/

    dev.attach(&NEWMESSAGE);        //Interrupts and tells us to carry on sending data or not





    while(1) {
        if(START == 0) {
            Dummy = 1 - Dummy;
            //pc.printf("Off");
        }

        else if(START == 1) {
            pc.printf("Start = 1\r\n");

            if(AUTO) {//***************AUTOMATIC MODE***********************//

                pc.printf("AUTO\r\n");
                //Code which reads temperature and sets fan on/off accordingly
                int i;
                int devices_found=0;
                // Initialize the probe array to DS1820 objects
                for (i = 0; i < MAX_PROBES; i++)
                    probe[i] = new DS1820(D0);
                // Initialize global state variables
                probe[0]->search_Rom_setup();
                // Loop to find all devices on the data line
                while (probe[devices_found]->search_Rom() and devices_found<MAX_PROBES-1)
                    devices_found++;
                // If maximum number of probes are found,
                // bump the counter to include the last array entry
                if (probe[devices_found]->Rom[0] != 0xFF)
                    devices_found++;

                if (devices_found==0)
                    printf("No devices found");
                else {

                    probe[0]->convert_temperature(DS1820::all_devices);
                    for (i=0; i<devices_found; i++) {
                        Temp = probe[i]->temperature('c');
                        if(Temp>27) {
                            fan = 1;
                        } else {
                            fan = 0;
                        }
                    }
                }



                // Code reads a voltage from an LDR and sets brightness of inside lighting accordingly

                float v = 3.3*V1.read();

                if(v<1) {
                    intensity = 0.1;
                    LightStatus = 1;
                } else if(v<1.6) {
                    intensity = 0.5;
                    LightStatus = 2;
                } else if(v<2.2) {
                    intensity = 1;
                    LightStatus = 3;
                } else {
                    intensity = 0;
                    LightStatus = 0;
                }
                Lights = intensity;

                pc.printf("reached here");


                // if(AUTO) { //This is here to make sure that we're still on AutoMode before sending back data
                pc.printf("ALights = %d\r\n",LightStatus);
                pc.printf("ATemp = %3.1f\r\n",Temp);
                pc.printf("AFan = %d\r\n",fan.read());
       
                char msg[80];
                sprintf(msg,"Temp %3.1f\r\nFan %d\r\nLights %d\r\n",Temp,fan.read(),LightStatus);
                 dev.printf("AT+CIPSEND=4,%d\r\n",strlen(msg));
                wait(0.2);
                dev.printf("%s",msg);
                wait(5);
                // }


            } else { //***********************MANUAL MODE**************************//
                Dummy = 1-Dummy;
                pc.printf("MANUAL\r\n");

                int i;
                int devices_found=0;
                // Initialize the probe array to DS1820 objects
                for (i = 0; i < MAX_PROBES; i++)
                    probe[i] = new DS1820(D0);
                // Initialize global state variables
                probe[0]->search_Rom_setup();
                // Loop to find all devices on the data line
                while (probe[devices_found]->search_Rom() and devices_found<MAX_PROBES-1)
                    devices_found++;
                // If maximum number of probes are found,
                // bump the counter to include the last array entry
                if (probe[devices_found]->Rom[0] != 0xFF)
                    devices_found++;
                if (devices_found==0)
                    printf("No devices found");
                else {
                    probe[0]->convert_temperature(DS1820::all_devices);
                    for (i=0; i<devices_found; i++) {
                        Temp = probe[i]->temperature('c');
                    }
                }
                pc.printf("mLights = %d\r\n",LightStatus);
                pc.printf("mTemp = %3.1f\r\n",Temp);
                pc.printf("mFan = %d\r\n",fan.read());
       
                char msg[80];
                sprintf(msg,"Temp %3.1f\r\nFan %d\r\nLights %d\r\n",Temp,fan.read(),LightStatus);
                 dev.printf("AT+CIPSEND=4,%d\r\n",strlen(msg));
                wait(0.2);
                dev.printf("%s",msg);
                wait(5);
            }
        }

    }
}