#include "mbed.h"
#include "uLCD_4DGL.h"

// connect mbed to Pi USB
RawSerial  pi(USBTX, USBRX);
uLCD_4DGL uLCD(p28,p27,p30); // serial tx, serial rx, reset pin;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
 
void dev_recv()
{
    char temp = 0;
    led1 = !led1;
    uLCD.cls();
    while(pi.readable()) {
        temp = pi.getc();
        pi.putc(temp);
        if (temp=='1') led2 = 1;
        if (temp=='0') led2 = 0;
        uLCD.printf("%c", temp);
    }
}
int main()
{
    pi.baud(9600);
    pi.attach(&dev_recv, Serial::RxIrq);
    while(1) {
        sleep();
    }
}