#ifndef MCP4XXX_H
#define MCP4XXX_H

#include "mbed.h"

#define P0_ADDR 0x00
#define P1_ADDR 0x10

class MCP4XXX {

    public:    
        MCP4XXX(PinName miso, PinName mosi, PinName clk, PinName cs);
        ~MCP4XXX();
        void setLevel(unsigned char lvl, bool isP0 = true); // MCP42XX is a dual pot IC
        unsigned char getLevel();
    private:
        SPI *_spi;
        DigitalOut *_cs;
        unsigned char _lvl;
};

#endif