#include "MCP4XXX.h"

MCP4XXX::MCP4XXX(PinName miso, PinName mosi, PinName clk, PinName cs) {
    _cs = new DigitalOut(cs);
    _spi = new SPI(miso, mosi, clk);
    _spi->format(8,0);
    _spi->frequency(1000000);
    _lvl = 0x00;
}

MCP4XXX::~MCP4XXX()
{
    delete _cs;
    delete _spi;
}

void MCP4XXX::setLevel(unsigned char lvl, bool isP0) {
    *_cs = 0;
    if (isP0)
        _spi->write(P0_ADDR);
    else 
        _spi->write(P1_ADDR);
    _spi->write(lvl);
    *_cs = 1;
    _lvl = lvl;
}

unsigned char MCP4XXX::getLevel() {
    return _lvl;
}