#include "mbed.h"

DigitalOut ce(p14);
SPI spi(p11, p12, p13);
Serial pc(USBTX, USBRX); // tx, rx
InterruptIn ir(p15);
//DigitalIn alm(p15);
DigitalOut myled(LED1);


void detect() {
   pc.printf("Interrupt received\n");
   myled = 0;
  // exit(0);
}

int main() {
    myled = 1;
    ir.fall(&detect);
    unsigned char response;
    ce=0;
    pc.printf("Start\n");   
    spi.format(8,3);    // DS1306 RTC supports mode 3 and 1
    spi.frequency(1000000);
    
    // set control register to enable write and enable alarm interrupts
    ce = 1;
    spi.write(0x8f);
    spi.write(0x07);
    ce = 0;
    wait(1);
    
    // set time to 4:44:30PM
    
    // set seconds to 30
    ce = 1;
    spi.write(0x80);
    spi.write(0x30);
    ce = 0;
    wait(1);
    
    // set minutes to 44
    ce = 1;
    spi.write(0x81);
    spi.write(0x44);
    ce = 0;
    wait(1);
    
    // set to 12-hr mode, PM, and hour to 4
    ce = 1;
    spi.write(0x82);
    spi.write(0x64);
    ce = 0;
    wait(1);
    
    // read seconds
    ce = 1;
    spi.write(0x00);
    response = spi.write(0x00);
    ce = 0;
    wait(1);
    printf("seconds: %x\n", response);
    
    // read minutes
    ce = 1;
    spi.write(0x01);
    response = spi.write(0x01);
    ce = 0;
    wait(1);
    printf("minute: %x\n", response);
    
    // read what u wrote at that location (0x64: 12-hr mode, PM, and hour to 4)
    ce = 1;
    spi.write(0x02);
    response = spi.write(0x02);
    ce = 0;
    wait(1);
    printf("%x\n", response);
    
    // read seconds again (see if time incremented)
    ce = 1;
    spi.write(0x00);
    response = spi.write(0x00);
    ce = 0;
    wait(1);
    printf("seconds: %x\n", response);
    
    // set alarm to 4:44:44PM
    
    // set seconds to 44
    ce = 1;
    spi.write(0x87);
    spi.write(0x44);
    ce = 0;
    wait(1);
    
    // set minutes to 44
    ce = 1;
    spi.write(0x88);
    spi.write(0x44);
    ce = 0;
    wait(1);
    
    // set to 12-hr mode, PM, and hour to 4
    ce = 1;
    spi.write(0x89);
    spi.write(0x64);
    ce = 0;
    wait(1);
    
    // set alarm to not match day
    ce = 1;
    spi.write(0x8a);
    spi.write(0x80);
    ce = 0;
    wait(1);
    
    // read time seconds
    ce = 1;
    spi.write(0x00);
    response = spi.write(0x00);
    ce = 0;
    wait(1);
    printf("seconds: %x\n", response);
    
    // enable alarm
    ce = 1;
    spi.write(0x8f);
    spi.write(0x07);
    ce = 0;
    wait(1);
    
    while (true) {
       // read time seconds
        ce = 1;
        spi.write(0x00);
        response = spi.write(0x00);
        ce = 0;
        printf("seconds: %x\n", response);
        wait(1);
    }
    
    return 0;
}
