#include "mbed.h"
//Emic 2 Hello Speech World Demo

DigitalOut myled(LED1);
#include "emic2.h"

emic2 myTTS(PB_6, PB_7); //serial RX,TX pins to emic

int main()
{
    myTTS.volume(18); //max volume
    while(1) {
        myled = 1;
        //Plain text demo
        myTTS.speakf("S");//Speak command starts with "S"
        myTTS.speakf("Hello. My name is the Emic 2 Text-to-Speech module. I would like to sing you a song on m bed.");  // Send the desired string to convert to speech
        myTTS.speakf("\r"); //marks end of speak command
        myTTS.ready(); //ready waits for speech to finish from last command with a ":" response
        myled = 0;
        myled = 1;
        //Song Demo
        myTTS.speakf("D1\r");//Sing Song Demo
        myTTS.ready(); //member function wait
        myled = 0;
        //Voice Demo
        for (int i=0; i<9 ; i++) { //demo different voices
            myTTS.voice(i);
            myTTS.speakf("SHello this is a sample of voice number, %D\r",i);
            myTTS.ready();
        }
        myTTS.voice(0); //back to default voice
        //Number demo
        for (int i=10; i>=0 ; i--) { //demo different numbers
            myTTS.speakf("S%D.\r",i);
            myTTS.ready();
        }
        //Read Time (RTC) demo
        set_time(1256729737);  // Set RTC time to Wed, 28 Oct 2009 11:35:37
        wait(2); //let RTC advance two seconds after setting to confirm it works
        time_t seconds = time(NULL);//read current time
        myTTS.speakf("STime in seconds since January 1, 1970 =, %d\r", seconds);
        myTTS.ready();
        myTTS.speakf("STime as a basic string = %s\r", ctime(&seconds));
        myTTS.ready();
        char buffer[32];
        strftime(buffer, 32, "%I:%M %p\n", localtime(&seconds));
        myTTS.speakf("SThe current time is %s\r", buffer);
        myTTS.ready();

    }
}
