#include "mbed.h"
#include "PinDetect.h"

// Define buttons
PinDetect pb1(p19);
PinDetect pb2(p15);

PinDetect dip1(p10);
PinDetect dip2(p11);
PinDetect dip3(p12);

DigitalOut pin(p14);

class RGBLed
{
public:
    RGBLed(PinName redpin, PinName greenpin, PinName bluepin);
    void write(float red,float green, float blue);
private:
    PwmOut _redpin;
    PwmOut _greenpin;
    PwmOut _bluepin;
};

RGBLed::RGBLed (PinName redpin, PinName greenpin, PinName bluepin)
    : _redpin(redpin), _greenpin(greenpin), _bluepin(bluepin)
{
    //50Hz PWM clock default a bit too low, go to 2000Hz (less flicker)
    _redpin.period(0.0005);
}
 
void RGBLed::write(float red,float green, float blue)
{
    _redpin = red;
    _greenpin = green;
    _bluepin = blue;
}
//class could be moved to include file
 
 
//Setup RGB led using PWM pins and class
RGBLed myRGBled(p21,p22,p23); //RGB PWM pins

float pwm = 0.5f;

void inc_led() {
    
    // Read in current PWM value and increment it
    pwm += 0.1f;
    if (pwm > 1.0f) {
        pwm = 0.0f;
    }
}

void dec_led() {
    
    // Read in current PWM value and increment it
    pwm -= 0.1f;
    if (pwm < 0.0f) {
        pwm = 0.0f;
    }
}

void dip_red() {
    myRGBled.write(pwm,0.0,0.0); //red
    wait(2.0);
}

void dip_green() {
    myRGBled.write(0.0,pwm,0.0); //green
    wait(2.0);
}

void dip_blue() {
    myRGBled.write(0.0,0.0,pwm); //blue
    wait(2.0);
}

int main() {
    
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    dip1.mode(PullUp);
    dip2.mode(PullUp);
    dip3.mode(PullUp);

    wait(.001);
    
    pb1.attach_deasserted(&inc_led);
    pb2.attach_deasserted(&dec_led);
    
    dip1.attach_deasserted(&dip_red);
    dip2.attach_deasserted(&dip_green);
    dip3.attach_deasserted(&dip_blue);
    
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    
    while(1) {
        pin = 1;

    }
}