#include "mbed.h"

Serial bluetooth(PTC15, PTC14); // pins to connect on HC-06
int mydata=0;


DigitalOut led_r(LED1); // on board LED
DigitalOut Relay1(PTC17);
DigitalOut Relay2(PTB9);
DigitalOut Relay3(PTA1);
DigitalOut Relay4(PTB23);
DigitalOut Relay5(PTA2);

int main()

{
    Relay1 = 0;
    Relay2 = 0;
    Relay3 = 0;
    Relay4 = 0;
    Relay5 = 0;
    led_r = 1;
    
    bluetooth.baud(9600);
    bluetooth.printf("\nSTM32 bluetooth\n");
    printf("\r\nready\r\n");
    while(1) 
    {

        if(bluetooth.readable()) 
        {
            mydata=bluetooth.getc();
            bluetooth.putc(mydata);
            printf("mydata = %c\r\n",mydata);
        } // end if

        switch(mydata)
        {
            case 'a':
                Relay1 = 0;
                break;
            case 'A':
                Relay1 = 1;
                break;
            case 'b':
                Relay2 = 0;
                break;
            case 'B':
                Relay2 = 1;
                break;
            case 'c':
                Relay3 = 0;
                break;
            case 'C':
                Relay3 = 1;
                break;
            case 'd':
                Relay4 = 0;
                break;
            case 'D':
                Relay4 = 1;
                break;
            case 'e':
                Relay5 = 0;
                break;
            case 'E':
                Relay5 = 1;
                break;
            default:
                led_r = 0;
        } // end switch
        
        //wait(1.0f);
        //printf("one second has elapsed.\r\n");
                
    } // end while
    
} // end main
