/*
 * Copyright (c) 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_USB_REGISTERS_H__
#define __HW_USB_REGISTERS_H__

#include "regs.h"

/*
 * MK64F12 USB
 *
 * Universal Serial Bus, OTG Capable Controller
 *
 * Registers defined in this header file:
 * - HW_USB_PERID - Peripheral ID register
 * - HW_USB_IDCOMP - Peripheral ID Complement register
 * - HW_USB_REV - Peripheral Revision register
 * - HW_USB_ADDINFO - Peripheral Additional Info register
 * - HW_USB_OTGISTAT - OTG Interrupt Status register
 * - HW_USB_OTGICR - OTG Interrupt Control register
 * - HW_USB_OTGSTAT - OTG Status register
 * - HW_USB_OTGCTL - OTG Control register
 * - HW_USB_ISTAT - Interrupt Status register
 * - HW_USB_INTEN - Interrupt Enable register
 * - HW_USB_ERRSTAT - Error Interrupt Status register
 * - HW_USB_ERREN - Error Interrupt Enable register
 * - HW_USB_STAT - Status register
 * - HW_USB_CTL - Control register
 * - HW_USB_ADDR - Address register
 * - HW_USB_BDTPAGE1 - BDT Page register 1
 * - HW_USB_FRMNUML - Frame Number register Low
 * - HW_USB_FRMNUMH - Frame Number register High
 * - HW_USB_TOKEN - Token register
 * - HW_USB_SOFTHLD - SOF Threshold register
 * - HW_USB_BDTPAGE2 - BDT Page Register 2
 * - HW_USB_BDTPAGE3 - BDT Page Register 3
 * - HW_USB_ENDPTn - Endpoint Control register
 * - HW_USB_USBCTRL - USB Control register
 * - HW_USB_OBSERVE - USB OTG Observe register
 * - HW_USB_CONTROL - USB OTG Control register
 * - HW_USB_USBTRC0 - USB Transceiver Control register 0
 * - HW_USB_USBFRMADJUST - Frame Adjust Register
 * - HW_USB_CLK_RECOVER_CTRL - USB Clock recovery control
 * - HW_USB_CLK_RECOVER_IRC_EN - IRC48M oscillator enable register
 * - HW_USB_CLK_RECOVER_INT_STATUS - Clock recovery separated interrupt status
 *
 * - hw_usb_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_USB_BASE
#define HW_USB_INSTANCE_COUNT (1U) //!< Number of instances of the USB module.
#define REGS_USB_BASE (0x40072000U) //!< Base address for USB0.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_PERID - Peripheral ID register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_PERID - Peripheral ID register (RO)
 *
 * Reset value: 0x04U
 *
 * Reads back the value of 0x04. This value is defined for the USB peripheral.
 */
typedef union _hw_usb_perid
{
    uint8_t U;
    struct _hw_usb_perid_bitfields
    {
        uint8_t ID : 6;                //!< [5:0] Peripheral Identification
        uint8_t RESERVED0 : 2;         //!< [7:6]
    } B;
} hw_usb_perid_t;
#endif

/*!
 * @name Constants and macros for entire USB_PERID register
 */
//@{
#define HW_USB_PERID_ADDR        (REGS_USB_BASE + 0x0U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_PERID             (*(__I hw_usb_perid_t *) HW_USB_PERID_ADDR)
#define HW_USB_PERID_RD()        (HW_USB_PERID.U)
#endif
//@}

/*
 * Constants & macros for individual USB_PERID bitfields
 */

/*!
 * @name Register USB_PERID, field ID[5:0] (RO)
 *
 * This field always reads 0x4h.
 */
//@{
#define BP_USB_PERID_ID      (0U)          //!< Bit position for USB_PERID_ID.
#define BM_USB_PERID_ID      (0x3FU)       //!< Bit mask for USB_PERID_ID.
#define BS_USB_PERID_ID      (6U)          //!< Bit field size in bits for USB_PERID_ID.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_PERID_ID field.
#define BR_USB_PERID_ID      (HW_USB_PERID.B.ID)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_IDCOMP - Peripheral ID Complement register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_IDCOMP - Peripheral ID Complement register (RO)
 *
 * Reset value: 0xFBU
 *
 * Reads back the complement of the Peripheral ID register. For the USB
 * peripheral, the value is 0xFB.
 */
typedef union _hw_usb_idcomp
{
    uint8_t U;
    struct _hw_usb_idcomp_bitfields
    {
        uint8_t NID : 6;               //!< [5:0]
        uint8_t RESERVED0 : 2;         //!< [7:6]
    } B;
} hw_usb_idcomp_t;
#endif

/*!
 * @name Constants and macros for entire USB_IDCOMP register
 */
//@{
#define HW_USB_IDCOMP_ADDR       (REGS_USB_BASE + 0x4U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_IDCOMP            (*(__I hw_usb_idcomp_t *) HW_USB_IDCOMP_ADDR)
#define HW_USB_IDCOMP_RD()       (HW_USB_IDCOMP.U)
#endif
//@}

/*
 * Constants & macros for individual USB_IDCOMP bitfields
 */

/*!
 * @name Register USB_IDCOMP, field NID[5:0] (RO)
 *
 * Ones' complement of PERID[ID]. bits.
 */
//@{
#define BP_USB_IDCOMP_NID    (0U)          //!< Bit position for USB_IDCOMP_NID.
#define BM_USB_IDCOMP_NID    (0x3FU)       //!< Bit mask for USB_IDCOMP_NID.
#define BS_USB_IDCOMP_NID    (6U)          //!< Bit field size in bits for USB_IDCOMP_NID.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_IDCOMP_NID field.
#define BR_USB_IDCOMP_NID    (HW_USB_IDCOMP.B.NID)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_REV - Peripheral Revision register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_REV - Peripheral Revision register (RO)
 *
 * Reset value: 0x33U
 *
 * Contains the revision number of the USB module.
 */
typedef union _hw_usb_rev
{
    uint8_t U;
    struct _hw_usb_rev_bitfields
    {
        uint8_t REV : 8;               //!< [7:0] Revision
    } B;
} hw_usb_rev_t;
#endif

/*!
 * @name Constants and macros for entire USB_REV register
 */
//@{
#define HW_USB_REV_ADDR          (REGS_USB_BASE + 0x8U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_REV               (*(__I hw_usb_rev_t *) HW_USB_REV_ADDR)
#define HW_USB_REV_RD()          (HW_USB_REV.U)
#endif
//@}

/*
 * Constants & macros for individual USB_REV bitfields
 */

/*!
 * @name Register USB_REV, field REV[7:0] (RO)
 *
 * Indicates the revision number of the USB Core.
 */
//@{
#define BP_USB_REV_REV       (0U)          //!< Bit position for USB_REV_REV.
#define BM_USB_REV_REV       (0xFFU)       //!< Bit mask for USB_REV_REV.
#define BS_USB_REV_REV       (8U)          //!< Bit field size in bits for USB_REV_REV.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_REV_REV field.
#define BR_USB_REV_REV       (HW_USB_REV.U)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_ADDINFO - Peripheral Additional Info register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_ADDINFO - Peripheral Additional Info register (RO)
 *
 * Reset value: 0x01U
 *
 * Reads back the value of the fixed Interrupt Request Level (IRQNUM) along with
 * the Host Enable bit.
 */
typedef union _hw_usb_addinfo
{
    uint8_t U;
    struct _hw_usb_addinfo_bitfields
    {
        uint8_t IEHOST : 1;            //!< [0]
        uint8_t RESERVED0 : 2;         //!< [2:1]
        uint8_t IRQNUM : 5;            //!< [7:3] Assigned Interrupt Request Number
    } B;
} hw_usb_addinfo_t;
#endif

/*!
 * @name Constants and macros for entire USB_ADDINFO register
 */
//@{
#define HW_USB_ADDINFO_ADDR      (REGS_USB_BASE + 0xCU)

#ifndef __LANGUAGE_ASM__
#define HW_USB_ADDINFO           (*(__I hw_usb_addinfo_t *) HW_USB_ADDINFO_ADDR)
#define HW_USB_ADDINFO_RD()      (HW_USB_ADDINFO.U)
#endif
//@}

/*
 * Constants & macros for individual USB_ADDINFO bitfields
 */

/*!
 * @name Register USB_ADDINFO, field IEHOST[0] (RO)
 *
 * This bit is set if host mode is enabled.
 */
//@{
#define BP_USB_ADDINFO_IEHOST (0U)         //!< Bit position for USB_ADDINFO_IEHOST.
#define BM_USB_ADDINFO_IEHOST (0x01U)      //!< Bit mask for USB_ADDINFO_IEHOST.
#define BS_USB_ADDINFO_IEHOST (1U)         //!< Bit field size in bits for USB_ADDINFO_IEHOST.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ADDINFO_IEHOST field.
#define BR_USB_ADDINFO_IEHOST (BITBAND_ACCESS8(HW_USB_ADDINFO_ADDR, BP_USB_ADDINFO_IEHOST))
#endif
//@}

/*!
 * @name Register USB_ADDINFO, field IRQNUM[7:3] (RO)
 */
//@{
#define BP_USB_ADDINFO_IRQNUM (3U)         //!< Bit position for USB_ADDINFO_IRQNUM.
#define BM_USB_ADDINFO_IRQNUM (0xF8U)      //!< Bit mask for USB_ADDINFO_IRQNUM.
#define BS_USB_ADDINFO_IRQNUM (5U)         //!< Bit field size in bits for USB_ADDINFO_IRQNUM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ADDINFO_IRQNUM field.
#define BR_USB_ADDINFO_IRQNUM (HW_USB_ADDINFO.B.IRQNUM)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_OTGISTAT - OTG Interrupt Status register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_OTGISTAT - OTG Interrupt Status register (RW)
 *
 * Reset value: 0x00U
 *
 * Records changes of the ID sense and VBUS signals. Software can read this
 * register to determine the event that triggers an interrupt. Only bits that have
 * changed since the last software read are set. Writing a one to a bit clears the
 * associated interrupt.
 */
typedef union _hw_usb_otgistat
{
    uint8_t U;
    struct _hw_usb_otgistat_bitfields
    {
        uint8_t AVBUSCHG : 1;          //!< [0]
        uint8_t RESERVED0 : 1;         //!< [1]
        uint8_t B_SESS_CHG : 1;        //!< [2]
        uint8_t SESSVLDCHG : 1;        //!< [3]
        uint8_t RESERVED1 : 1;         //!< [4]
        uint8_t LINE_STATE_CHG : 1;    //!< [5]
        uint8_t ONEMSEC : 1;           //!< [6]
        uint8_t IDCHG : 1;             //!< [7]
    } B;
} hw_usb_otgistat_t;
#endif

/*!
 * @name Constants and macros for entire USB_OTGISTAT register
 */
//@{
#define HW_USB_OTGISTAT_ADDR     (REGS_USB_BASE + 0x10U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_OTGISTAT          (*(__IO hw_usb_otgistat_t *) HW_USB_OTGISTAT_ADDR)
#define HW_USB_OTGISTAT_RD()     (HW_USB_OTGISTAT.U)
#define HW_USB_OTGISTAT_WR(v)    (HW_USB_OTGISTAT.U = (v))
#define HW_USB_OTGISTAT_SET(v)   (HW_USB_OTGISTAT_WR(HW_USB_OTGISTAT_RD() |  (v)))
#define HW_USB_OTGISTAT_CLR(v)   (HW_USB_OTGISTAT_WR(HW_USB_OTGISTAT_RD() & ~(v)))
#define HW_USB_OTGISTAT_TOG(v)   (HW_USB_OTGISTAT_WR(HW_USB_OTGISTAT_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_OTGISTAT bitfields
 */

/*!
 * @name Register USB_OTGISTAT, field AVBUSCHG[0] (RW)
 *
 * This bit is set when a change in VBUS is detected on an A device.
 */
//@{
#define BP_USB_OTGISTAT_AVBUSCHG (0U)      //!< Bit position for USB_OTGISTAT_AVBUSCHG.
#define BM_USB_OTGISTAT_AVBUSCHG (0x01U)   //!< Bit mask for USB_OTGISTAT_AVBUSCHG.
#define BS_USB_OTGISTAT_AVBUSCHG (1U)      //!< Bit field size in bits for USB_OTGISTAT_AVBUSCHG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGISTAT_AVBUSCHG field.
#define BR_USB_OTGISTAT_AVBUSCHG (BITBAND_ACCESS8(HW_USB_OTGISTAT_ADDR, BP_USB_OTGISTAT_AVBUSCHG))
#endif

//! @brief Format value for bitfield USB_OTGISTAT_AVBUSCHG.
#define BF_USB_OTGISTAT_AVBUSCHG(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGISTAT_AVBUSCHG), uint8_t) & BM_USB_OTGISTAT_AVBUSCHG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AVBUSCHG field to a new value.
#define BW_USB_OTGISTAT_AVBUSCHG(v) (BITBAND_ACCESS8(HW_USB_OTGISTAT_ADDR, BP_USB_OTGISTAT_AVBUSCHG) = (v))
#endif
//@}

/*!
 * @name Register USB_OTGISTAT, field B_SESS_CHG[2] (RW)
 *
 * This bit is set when a change in VBUS is detected on a B device.
 */
//@{
#define BP_USB_OTGISTAT_B_SESS_CHG (2U)    //!< Bit position for USB_OTGISTAT_B_SESS_CHG.
#define BM_USB_OTGISTAT_B_SESS_CHG (0x04U) //!< Bit mask for USB_OTGISTAT_B_SESS_CHG.
#define BS_USB_OTGISTAT_B_SESS_CHG (1U)    //!< Bit field size in bits for USB_OTGISTAT_B_SESS_CHG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGISTAT_B_SESS_CHG field.
#define BR_USB_OTGISTAT_B_SESS_CHG (BITBAND_ACCESS8(HW_USB_OTGISTAT_ADDR, BP_USB_OTGISTAT_B_SESS_CHG))
#endif

//! @brief Format value for bitfield USB_OTGISTAT_B_SESS_CHG.
#define BF_USB_OTGISTAT_B_SESS_CHG(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGISTAT_B_SESS_CHG), uint8_t) & BM_USB_OTGISTAT_B_SESS_CHG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the B_SESS_CHG field to a new value.
#define BW_USB_OTGISTAT_B_SESS_CHG(v) (BITBAND_ACCESS8(HW_USB_OTGISTAT_ADDR, BP_USB_OTGISTAT_B_SESS_CHG) = (v))
#endif
//@}

/*!
 * @name Register USB_OTGISTAT, field SESSVLDCHG[3] (RW)
 *
 * This bit is set when a change in VBUS is detected indicating a session valid
 * or a session no longer valid.
 */
//@{
#define BP_USB_OTGISTAT_SESSVLDCHG (3U)    //!< Bit position for USB_OTGISTAT_SESSVLDCHG.
#define BM_USB_OTGISTAT_SESSVLDCHG (0x08U) //!< Bit mask for USB_OTGISTAT_SESSVLDCHG.
#define BS_USB_OTGISTAT_SESSVLDCHG (1U)    //!< Bit field size in bits for USB_OTGISTAT_SESSVLDCHG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGISTAT_SESSVLDCHG field.
#define BR_USB_OTGISTAT_SESSVLDCHG (BITBAND_ACCESS8(HW_USB_OTGISTAT_ADDR, BP_USB_OTGISTAT_SESSVLDCHG))
#endif

//! @brief Format value for bitfield USB_OTGISTAT_SESSVLDCHG.
#define BF_USB_OTGISTAT_SESSVLDCHG(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGISTAT_SESSVLDCHG), uint8_t) & BM_USB_OTGISTAT_SESSVLDCHG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SESSVLDCHG field to a new value.
#define BW_USB_OTGISTAT_SESSVLDCHG(v) (BITBAND_ACCESS8(HW_USB_OTGISTAT_ADDR, BP_USB_OTGISTAT_SESSVLDCHG) = (v))
#endif
//@}

/*!
 * @name Register USB_OTGISTAT, field LINE_STATE_CHG[5] (RW)
 *
 * This interrupt is set when the USB line state (CTL[SE0] and CTL[JSTATE] bits)
 * are stable without change for 1 millisecond, and the value of the line state
 * is different from the last time when the line state was stable. It is set on
 * transitions between SE0 and J-state, SE0 and K-state, and J-state and K-state.
 * Changes in J-state while SE0 is true do not cause an interrupt. This interrupt
 * can be used in detecting Reset, Resume, Connect, and Data Line Pulse
 * signaling.
 */
//@{
#define BP_USB_OTGISTAT_LINE_STATE_CHG (5U) //!< Bit position for USB_OTGISTAT_LINE_STATE_CHG.
#define BM_USB_OTGISTAT_LINE_STATE_CHG (0x20U) //!< Bit mask for USB_OTGISTAT_LINE_STATE_CHG.
#define BS_USB_OTGISTAT_LINE_STATE_CHG (1U) //!< Bit field size in bits for USB_OTGISTAT_LINE_STATE_CHG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGISTAT_LINE_STATE_CHG field.
#define BR_USB_OTGISTAT_LINE_STATE_CHG (BITBAND_ACCESS8(HW_USB_OTGISTAT_ADDR, BP_USB_OTGISTAT_LINE_STATE_CHG))
#endif

//! @brief Format value for bitfield USB_OTGISTAT_LINE_STATE_CHG.
#define BF_USB_OTGISTAT_LINE_STATE_CHG(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGISTAT_LINE_STATE_CHG), uint8_t) & BM_USB_OTGISTAT_LINE_STATE_CHG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LINE_STATE_CHG field to a new value.
#define BW_USB_OTGISTAT_LINE_STATE_CHG(v) (BITBAND_ACCESS8(HW_USB_OTGISTAT_ADDR, BP_USB_OTGISTAT_LINE_STATE_CHG) = (v))
#endif
//@}

/*!
 * @name Register USB_OTGISTAT, field ONEMSEC[6] (RW)
 *
 * This bit is set when the 1 millisecond timer expires. This bit stays asserted
 * until cleared by software. The interrupt must be serviced every millisecond
 * to avoid losing 1msec counts.
 */
//@{
#define BP_USB_OTGISTAT_ONEMSEC (6U)       //!< Bit position for USB_OTGISTAT_ONEMSEC.
#define BM_USB_OTGISTAT_ONEMSEC (0x40U)    //!< Bit mask for USB_OTGISTAT_ONEMSEC.
#define BS_USB_OTGISTAT_ONEMSEC (1U)       //!< Bit field size in bits for USB_OTGISTAT_ONEMSEC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGISTAT_ONEMSEC field.
#define BR_USB_OTGISTAT_ONEMSEC (BITBAND_ACCESS8(HW_USB_OTGISTAT_ADDR, BP_USB_OTGISTAT_ONEMSEC))
#endif

//! @brief Format value for bitfield USB_OTGISTAT_ONEMSEC.
#define BF_USB_OTGISTAT_ONEMSEC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGISTAT_ONEMSEC), uint8_t) & BM_USB_OTGISTAT_ONEMSEC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ONEMSEC field to a new value.
#define BW_USB_OTGISTAT_ONEMSEC(v) (BITBAND_ACCESS8(HW_USB_OTGISTAT_ADDR, BP_USB_OTGISTAT_ONEMSEC) = (v))
#endif
//@}

/*!
 * @name Register USB_OTGISTAT, field IDCHG[7] (RW)
 *
 * This bit is set when a change in the ID Signal from the USB connector is
 * sensed.
 */
//@{
#define BP_USB_OTGISTAT_IDCHG (7U)         //!< Bit position for USB_OTGISTAT_IDCHG.
#define BM_USB_OTGISTAT_IDCHG (0x80U)      //!< Bit mask for USB_OTGISTAT_IDCHG.
#define BS_USB_OTGISTAT_IDCHG (1U)         //!< Bit field size in bits for USB_OTGISTAT_IDCHG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGISTAT_IDCHG field.
#define BR_USB_OTGISTAT_IDCHG (BITBAND_ACCESS8(HW_USB_OTGISTAT_ADDR, BP_USB_OTGISTAT_IDCHG))
#endif

//! @brief Format value for bitfield USB_OTGISTAT_IDCHG.
#define BF_USB_OTGISTAT_IDCHG(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGISTAT_IDCHG), uint8_t) & BM_USB_OTGISTAT_IDCHG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDCHG field to a new value.
#define BW_USB_OTGISTAT_IDCHG(v) (BITBAND_ACCESS8(HW_USB_OTGISTAT_ADDR, BP_USB_OTGISTAT_IDCHG) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_OTGICR - OTG Interrupt Control register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_OTGICR - OTG Interrupt Control register (RW)
 *
 * Reset value: 0x00U
 *
 * Enables the corresponding interrupt status bits defined in the OTG Interrupt
 * Status Register.
 */
typedef union _hw_usb_otgicr
{
    uint8_t U;
    struct _hw_usb_otgicr_bitfields
    {
        uint8_t AVBUSEN : 1;           //!< [0] A VBUS Valid Interrupt Enable
        uint8_t RESERVED0 : 1;         //!< [1]
        uint8_t BSESSEN : 1;           //!< [2] B Session END Interrupt Enable
        uint8_t SESSVLDEN : 1;         //!< [3] Session Valid Interrupt Enable
        uint8_t RESERVED1 : 1;         //!< [4]
        uint8_t LINESTATEEN : 1;       //!< [5] Line State Change Interrupt Enable
        uint8_t ONEMSECEN : 1;         //!< [6] One Millisecond Interrupt Enable
        uint8_t IDEN : 1;              //!< [7] ID Interrupt Enable
    } B;
} hw_usb_otgicr_t;
#endif

/*!
 * @name Constants and macros for entire USB_OTGICR register
 */
//@{
#define HW_USB_OTGICR_ADDR       (REGS_USB_BASE + 0x14U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_OTGICR            (*(__IO hw_usb_otgicr_t *) HW_USB_OTGICR_ADDR)
#define HW_USB_OTGICR_RD()       (HW_USB_OTGICR.U)
#define HW_USB_OTGICR_WR(v)      (HW_USB_OTGICR.U = (v))
#define HW_USB_OTGICR_SET(v)     (HW_USB_OTGICR_WR(HW_USB_OTGICR_RD() |  (v)))
#define HW_USB_OTGICR_CLR(v)     (HW_USB_OTGICR_WR(HW_USB_OTGICR_RD() & ~(v)))
#define HW_USB_OTGICR_TOG(v)     (HW_USB_OTGICR_WR(HW_USB_OTGICR_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_OTGICR bitfields
 */

/*!
 * @name Register USB_OTGICR, field AVBUSEN[0] (RW)
 *
 * Values:
 * - 0 - Disables the AVBUSCHG interrupt.
 * - 1 - Enables the AVBUSCHG interrupt.
 */
//@{
#define BP_USB_OTGICR_AVBUSEN (0U)         //!< Bit position for USB_OTGICR_AVBUSEN.
#define BM_USB_OTGICR_AVBUSEN (0x01U)      //!< Bit mask for USB_OTGICR_AVBUSEN.
#define BS_USB_OTGICR_AVBUSEN (1U)         //!< Bit field size in bits for USB_OTGICR_AVBUSEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGICR_AVBUSEN field.
#define BR_USB_OTGICR_AVBUSEN (BITBAND_ACCESS8(HW_USB_OTGICR_ADDR, BP_USB_OTGICR_AVBUSEN))
#endif

//! @brief Format value for bitfield USB_OTGICR_AVBUSEN.
#define BF_USB_OTGICR_AVBUSEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGICR_AVBUSEN), uint8_t) & BM_USB_OTGICR_AVBUSEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AVBUSEN field to a new value.
#define BW_USB_OTGICR_AVBUSEN(v) (BITBAND_ACCESS8(HW_USB_OTGICR_ADDR, BP_USB_OTGICR_AVBUSEN) = (v))
#endif
//@}

/*!
 * @name Register USB_OTGICR, field BSESSEN[2] (RW)
 *
 * Values:
 * - 0 - Disables the B_SESS_CHG interrupt.
 * - 1 - Enables the B_SESS_CHG interrupt.
 */
//@{
#define BP_USB_OTGICR_BSESSEN (2U)         //!< Bit position for USB_OTGICR_BSESSEN.
#define BM_USB_OTGICR_BSESSEN (0x04U)      //!< Bit mask for USB_OTGICR_BSESSEN.
#define BS_USB_OTGICR_BSESSEN (1U)         //!< Bit field size in bits for USB_OTGICR_BSESSEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGICR_BSESSEN field.
#define BR_USB_OTGICR_BSESSEN (BITBAND_ACCESS8(HW_USB_OTGICR_ADDR, BP_USB_OTGICR_BSESSEN))
#endif

//! @brief Format value for bitfield USB_OTGICR_BSESSEN.
#define BF_USB_OTGICR_BSESSEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGICR_BSESSEN), uint8_t) & BM_USB_OTGICR_BSESSEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BSESSEN field to a new value.
#define BW_USB_OTGICR_BSESSEN(v) (BITBAND_ACCESS8(HW_USB_OTGICR_ADDR, BP_USB_OTGICR_BSESSEN) = (v))
#endif
//@}

/*!
 * @name Register USB_OTGICR, field SESSVLDEN[3] (RW)
 *
 * Values:
 * - 0 - Disables the SESSVLDCHG interrupt.
 * - 1 - Enables the SESSVLDCHG interrupt.
 */
//@{
#define BP_USB_OTGICR_SESSVLDEN (3U)       //!< Bit position for USB_OTGICR_SESSVLDEN.
#define BM_USB_OTGICR_SESSVLDEN (0x08U)    //!< Bit mask for USB_OTGICR_SESSVLDEN.
#define BS_USB_OTGICR_SESSVLDEN (1U)       //!< Bit field size in bits for USB_OTGICR_SESSVLDEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGICR_SESSVLDEN field.
#define BR_USB_OTGICR_SESSVLDEN (BITBAND_ACCESS8(HW_USB_OTGICR_ADDR, BP_USB_OTGICR_SESSVLDEN))
#endif

//! @brief Format value for bitfield USB_OTGICR_SESSVLDEN.
#define BF_USB_OTGICR_SESSVLDEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGICR_SESSVLDEN), uint8_t) & BM_USB_OTGICR_SESSVLDEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SESSVLDEN field to a new value.
#define BW_USB_OTGICR_SESSVLDEN(v) (BITBAND_ACCESS8(HW_USB_OTGICR_ADDR, BP_USB_OTGICR_SESSVLDEN) = (v))
#endif
//@}

/*!
 * @name Register USB_OTGICR, field LINESTATEEN[5] (RW)
 *
 * Values:
 * - 0 - Disables the LINE_STAT_CHG interrupt.
 * - 1 - Enables the LINE_STAT_CHG interrupt.
 */
//@{
#define BP_USB_OTGICR_LINESTATEEN (5U)     //!< Bit position for USB_OTGICR_LINESTATEEN.
#define BM_USB_OTGICR_LINESTATEEN (0x20U)  //!< Bit mask for USB_OTGICR_LINESTATEEN.
#define BS_USB_OTGICR_LINESTATEEN (1U)     //!< Bit field size in bits for USB_OTGICR_LINESTATEEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGICR_LINESTATEEN field.
#define BR_USB_OTGICR_LINESTATEEN (BITBAND_ACCESS8(HW_USB_OTGICR_ADDR, BP_USB_OTGICR_LINESTATEEN))
#endif

//! @brief Format value for bitfield USB_OTGICR_LINESTATEEN.
#define BF_USB_OTGICR_LINESTATEEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGICR_LINESTATEEN), uint8_t) & BM_USB_OTGICR_LINESTATEEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LINESTATEEN field to a new value.
#define BW_USB_OTGICR_LINESTATEEN(v) (BITBAND_ACCESS8(HW_USB_OTGICR_ADDR, BP_USB_OTGICR_LINESTATEEN) = (v))
#endif
//@}

/*!
 * @name Register USB_OTGICR, field ONEMSECEN[6] (RW)
 *
 * Values:
 * - 0 - Diables the 1ms timer interrupt.
 * - 1 - Enables the 1ms timer interrupt.
 */
//@{
#define BP_USB_OTGICR_ONEMSECEN (6U)       //!< Bit position for USB_OTGICR_ONEMSECEN.
#define BM_USB_OTGICR_ONEMSECEN (0x40U)    //!< Bit mask for USB_OTGICR_ONEMSECEN.
#define BS_USB_OTGICR_ONEMSECEN (1U)       //!< Bit field size in bits for USB_OTGICR_ONEMSECEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGICR_ONEMSECEN field.
#define BR_USB_OTGICR_ONEMSECEN (BITBAND_ACCESS8(HW_USB_OTGICR_ADDR, BP_USB_OTGICR_ONEMSECEN))
#endif

//! @brief Format value for bitfield USB_OTGICR_ONEMSECEN.
#define BF_USB_OTGICR_ONEMSECEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGICR_ONEMSECEN), uint8_t) & BM_USB_OTGICR_ONEMSECEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ONEMSECEN field to a new value.
#define BW_USB_OTGICR_ONEMSECEN(v) (BITBAND_ACCESS8(HW_USB_OTGICR_ADDR, BP_USB_OTGICR_ONEMSECEN) = (v))
#endif
//@}

/*!
 * @name Register USB_OTGICR, field IDEN[7] (RW)
 *
 * Values:
 * - 0 - The ID interrupt is disabled
 * - 1 - The ID interrupt is enabled
 */
//@{
#define BP_USB_OTGICR_IDEN   (7U)          //!< Bit position for USB_OTGICR_IDEN.
#define BM_USB_OTGICR_IDEN   (0x80U)       //!< Bit mask for USB_OTGICR_IDEN.
#define BS_USB_OTGICR_IDEN   (1U)          //!< Bit field size in bits for USB_OTGICR_IDEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGICR_IDEN field.
#define BR_USB_OTGICR_IDEN   (BITBAND_ACCESS8(HW_USB_OTGICR_ADDR, BP_USB_OTGICR_IDEN))
#endif

//! @brief Format value for bitfield USB_OTGICR_IDEN.
#define BF_USB_OTGICR_IDEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGICR_IDEN), uint8_t) & BM_USB_OTGICR_IDEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDEN field to a new value.
#define BW_USB_OTGICR_IDEN(v) (BITBAND_ACCESS8(HW_USB_OTGICR_ADDR, BP_USB_OTGICR_IDEN) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_OTGSTAT - OTG Status register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_OTGSTAT - OTG Status register (RW)
 *
 * Reset value: 0x00U
 *
 * Displays the actual value from the external comparator outputs of the ID pin
 * and VBUS.
 */
typedef union _hw_usb_otgstat
{
    uint8_t U;
    struct _hw_usb_otgstat_bitfields
    {
        uint8_t AVBUSVLD : 1;          //!< [0] A VBUS Valid
        uint8_t RESERVED0 : 1;         //!< [1]
        uint8_t BSESSEND : 1;          //!< [2] B Session End
        uint8_t SESS_VLD : 1;          //!< [3] Session Valid
        uint8_t RESERVED1 : 1;         //!< [4]
        uint8_t LINESTATESTABLE : 1;   //!< [5]
        uint8_t ONEMSECEN : 1;         //!< [6]
        uint8_t ID : 1;                //!< [7]
    } B;
} hw_usb_otgstat_t;
#endif

/*!
 * @name Constants and macros for entire USB_OTGSTAT register
 */
//@{
#define HW_USB_OTGSTAT_ADDR      (REGS_USB_BASE + 0x18U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_OTGSTAT           (*(__IO hw_usb_otgstat_t *) HW_USB_OTGSTAT_ADDR)
#define HW_USB_OTGSTAT_RD()      (HW_USB_OTGSTAT.U)
#define HW_USB_OTGSTAT_WR(v)     (HW_USB_OTGSTAT.U = (v))
#define HW_USB_OTGSTAT_SET(v)    (HW_USB_OTGSTAT_WR(HW_USB_OTGSTAT_RD() |  (v)))
#define HW_USB_OTGSTAT_CLR(v)    (HW_USB_OTGSTAT_WR(HW_USB_OTGSTAT_RD() & ~(v)))
#define HW_USB_OTGSTAT_TOG(v)    (HW_USB_OTGSTAT_WR(HW_USB_OTGSTAT_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_OTGSTAT bitfields
 */

/*!
 * @name Register USB_OTGSTAT, field AVBUSVLD[0] (RW)
 *
 * Values:
 * - 0 - The VBUS voltage is below the A VBUS Valid threshold.
 * - 1 - The VBUS voltage is above the A VBUS Valid threshold.
 */
//@{
#define BP_USB_OTGSTAT_AVBUSVLD (0U)       //!< Bit position for USB_OTGSTAT_AVBUSVLD.
#define BM_USB_OTGSTAT_AVBUSVLD (0x01U)    //!< Bit mask for USB_OTGSTAT_AVBUSVLD.
#define BS_USB_OTGSTAT_AVBUSVLD (1U)       //!< Bit field size in bits for USB_OTGSTAT_AVBUSVLD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGSTAT_AVBUSVLD field.
#define BR_USB_OTGSTAT_AVBUSVLD (BITBAND_ACCESS8(HW_USB_OTGSTAT_ADDR, BP_USB_OTGSTAT_AVBUSVLD))
#endif

//! @brief Format value for bitfield USB_OTGSTAT_AVBUSVLD.
#define BF_USB_OTGSTAT_AVBUSVLD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGSTAT_AVBUSVLD), uint8_t) & BM_USB_OTGSTAT_AVBUSVLD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AVBUSVLD field to a new value.
#define BW_USB_OTGSTAT_AVBUSVLD(v) (BITBAND_ACCESS8(HW_USB_OTGSTAT_ADDR, BP_USB_OTGSTAT_AVBUSVLD) = (v))
#endif
//@}

/*!
 * @name Register USB_OTGSTAT, field BSESSEND[2] (RW)
 *
 * Values:
 * - 0 - The VBUS voltage is above the B session end threshold.
 * - 1 - The VBUS voltage is below the B session end threshold.
 */
//@{
#define BP_USB_OTGSTAT_BSESSEND (2U)       //!< Bit position for USB_OTGSTAT_BSESSEND.
#define BM_USB_OTGSTAT_BSESSEND (0x04U)    //!< Bit mask for USB_OTGSTAT_BSESSEND.
#define BS_USB_OTGSTAT_BSESSEND (1U)       //!< Bit field size in bits for USB_OTGSTAT_BSESSEND.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGSTAT_BSESSEND field.
#define BR_USB_OTGSTAT_BSESSEND (BITBAND_ACCESS8(HW_USB_OTGSTAT_ADDR, BP_USB_OTGSTAT_BSESSEND))
#endif

//! @brief Format value for bitfield USB_OTGSTAT_BSESSEND.
#define BF_USB_OTGSTAT_BSESSEND(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGSTAT_BSESSEND), uint8_t) & BM_USB_OTGSTAT_BSESSEND)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BSESSEND field to a new value.
#define BW_USB_OTGSTAT_BSESSEND(v) (BITBAND_ACCESS8(HW_USB_OTGSTAT_ADDR, BP_USB_OTGSTAT_BSESSEND) = (v))
#endif
//@}

/*!
 * @name Register USB_OTGSTAT, field SESS_VLD[3] (RW)
 *
 * Values:
 * - 0 - The VBUS voltage is below the B session valid threshold
 * - 1 - The VBUS voltage is above the B session valid threshold.
 */
//@{
#define BP_USB_OTGSTAT_SESS_VLD (3U)       //!< Bit position for USB_OTGSTAT_SESS_VLD.
#define BM_USB_OTGSTAT_SESS_VLD (0x08U)    //!< Bit mask for USB_OTGSTAT_SESS_VLD.
#define BS_USB_OTGSTAT_SESS_VLD (1U)       //!< Bit field size in bits for USB_OTGSTAT_SESS_VLD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGSTAT_SESS_VLD field.
#define BR_USB_OTGSTAT_SESS_VLD (BITBAND_ACCESS8(HW_USB_OTGSTAT_ADDR, BP_USB_OTGSTAT_SESS_VLD))
#endif

//! @brief Format value for bitfield USB_OTGSTAT_SESS_VLD.
#define BF_USB_OTGSTAT_SESS_VLD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGSTAT_SESS_VLD), uint8_t) & BM_USB_OTGSTAT_SESS_VLD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SESS_VLD field to a new value.
#define BW_USB_OTGSTAT_SESS_VLD(v) (BITBAND_ACCESS8(HW_USB_OTGSTAT_ADDR, BP_USB_OTGSTAT_SESS_VLD) = (v))
#endif
//@}

/*!
 * @name Register USB_OTGSTAT, field LINESTATESTABLE[5] (RW)
 *
 * Indicates that the internal signals that control the LINE_STATE_CHG field of
 * OTGISTAT are stable for at least 1 millisecond. First read LINE_STATE_CHG
 * field and then read this field. If this field reads as 1, then the value of
 * LINE_STATE_CHG can be considered stable.
 *
 * Values:
 * - 0 - The LINE_STAT_CHG bit is not yet stable.
 * - 1 - The LINE_STAT_CHG bit has been debounced and is stable.
 */
//@{
#define BP_USB_OTGSTAT_LINESTATESTABLE (5U) //!< Bit position for USB_OTGSTAT_LINESTATESTABLE.
#define BM_USB_OTGSTAT_LINESTATESTABLE (0x20U) //!< Bit mask for USB_OTGSTAT_LINESTATESTABLE.
#define BS_USB_OTGSTAT_LINESTATESTABLE (1U) //!< Bit field size in bits for USB_OTGSTAT_LINESTATESTABLE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGSTAT_LINESTATESTABLE field.
#define BR_USB_OTGSTAT_LINESTATESTABLE (BITBAND_ACCESS8(HW_USB_OTGSTAT_ADDR, BP_USB_OTGSTAT_LINESTATESTABLE))
#endif

//! @brief Format value for bitfield USB_OTGSTAT_LINESTATESTABLE.
#define BF_USB_OTGSTAT_LINESTATESTABLE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGSTAT_LINESTATESTABLE), uint8_t) & BM_USB_OTGSTAT_LINESTATESTABLE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LINESTATESTABLE field to a new value.
#define BW_USB_OTGSTAT_LINESTATESTABLE(v) (BITBAND_ACCESS8(HW_USB_OTGSTAT_ADDR, BP_USB_OTGSTAT_LINESTATESTABLE) = (v))
#endif
//@}

/*!
 * @name Register USB_OTGSTAT, field ONEMSECEN[6] (RW)
 *
 * This bit is reserved for the 1ms count, but it is not useful to software.
 */
//@{
#define BP_USB_OTGSTAT_ONEMSECEN (6U)      //!< Bit position for USB_OTGSTAT_ONEMSECEN.
#define BM_USB_OTGSTAT_ONEMSECEN (0x40U)   //!< Bit mask for USB_OTGSTAT_ONEMSECEN.
#define BS_USB_OTGSTAT_ONEMSECEN (1U)      //!< Bit field size in bits for USB_OTGSTAT_ONEMSECEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGSTAT_ONEMSECEN field.
#define BR_USB_OTGSTAT_ONEMSECEN (BITBAND_ACCESS8(HW_USB_OTGSTAT_ADDR, BP_USB_OTGSTAT_ONEMSECEN))
#endif

//! @brief Format value for bitfield USB_OTGSTAT_ONEMSECEN.
#define BF_USB_OTGSTAT_ONEMSECEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGSTAT_ONEMSECEN), uint8_t) & BM_USB_OTGSTAT_ONEMSECEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ONEMSECEN field to a new value.
#define BW_USB_OTGSTAT_ONEMSECEN(v) (BITBAND_ACCESS8(HW_USB_OTGSTAT_ADDR, BP_USB_OTGSTAT_ONEMSECEN) = (v))
#endif
//@}

/*!
 * @name Register USB_OTGSTAT, field ID[7] (RW)
 *
 * Indicates the current state of the ID pin on the USB connector
 *
 * Values:
 * - 0 - Indicates a Type A cable is plugged into the USB connector.
 * - 1 - Indicates no cable is attached or a Type B cable is plugged into the
 *     USB connector.
 */
//@{
#define BP_USB_OTGSTAT_ID    (7U)          //!< Bit position for USB_OTGSTAT_ID.
#define BM_USB_OTGSTAT_ID    (0x80U)       //!< Bit mask for USB_OTGSTAT_ID.
#define BS_USB_OTGSTAT_ID    (1U)          //!< Bit field size in bits for USB_OTGSTAT_ID.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGSTAT_ID field.
#define BR_USB_OTGSTAT_ID    (BITBAND_ACCESS8(HW_USB_OTGSTAT_ADDR, BP_USB_OTGSTAT_ID))
#endif

//! @brief Format value for bitfield USB_OTGSTAT_ID.
#define BF_USB_OTGSTAT_ID(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGSTAT_ID), uint8_t) & BM_USB_OTGSTAT_ID)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ID field to a new value.
#define BW_USB_OTGSTAT_ID(v) (BITBAND_ACCESS8(HW_USB_OTGSTAT_ADDR, BP_USB_OTGSTAT_ID) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_OTGCTL - OTG Control register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_OTGCTL - OTG Control register (RW)
 *
 * Reset value: 0x00U
 *
 * Controls the operation of VBUS and Data Line termination resistors.
 */
typedef union _hw_usb_otgctl
{
    uint8_t U;
    struct _hw_usb_otgctl_bitfields
    {
        uint8_t RESERVED0 : 2;         //!< [1:0]
        uint8_t OTGEN : 1;             //!< [2] On-The-Go pullup/pulldown resistor enable
        uint8_t RESERVED1 : 1;         //!< [3]
        uint8_t DMLOW : 1;             //!< [4] D- Data Line pull-down resistor enable
        uint8_t DPLOW : 1;             //!< [5] D+ Data Line pull-down resistor enable
        uint8_t RESERVED2 : 1;         //!< [6]
        uint8_t DPHIGH : 1;            //!< [7] D+ Data Line pullup resistor enable
    } B;
} hw_usb_otgctl_t;
#endif

/*!
 * @name Constants and macros for entire USB_OTGCTL register
 */
//@{
#define HW_USB_OTGCTL_ADDR       (REGS_USB_BASE + 0x1CU)

#ifndef __LANGUAGE_ASM__
#define HW_USB_OTGCTL            (*(__IO hw_usb_otgctl_t *) HW_USB_OTGCTL_ADDR)
#define HW_USB_OTGCTL_RD()       (HW_USB_OTGCTL.U)
#define HW_USB_OTGCTL_WR(v)      (HW_USB_OTGCTL.U = (v))
#define HW_USB_OTGCTL_SET(v)     (HW_USB_OTGCTL_WR(HW_USB_OTGCTL_RD() |  (v)))
#define HW_USB_OTGCTL_CLR(v)     (HW_USB_OTGCTL_WR(HW_USB_OTGCTL_RD() & ~(v)))
#define HW_USB_OTGCTL_TOG(v)     (HW_USB_OTGCTL_WR(HW_USB_OTGCTL_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_OTGCTL bitfields
 */

/*!
 * @name Register USB_OTGCTL, field OTGEN[2] (RW)
 *
 * Values:
 * - 0 - If USB_EN is 1 and HOST_MODE is 0 in the Control Register (CTL), then
 *     the D+ Data Line pull-up resistors are enabled. If HOST_MODE is 1 the D+
 *     and D- Data Line pull-down resistors are engaged.
 * - 1 - The pull-up and pull-down controls in this register are used.
 */
//@{
#define BP_USB_OTGCTL_OTGEN  (2U)          //!< Bit position for USB_OTGCTL_OTGEN.
#define BM_USB_OTGCTL_OTGEN  (0x04U)       //!< Bit mask for USB_OTGCTL_OTGEN.
#define BS_USB_OTGCTL_OTGEN  (1U)          //!< Bit field size in bits for USB_OTGCTL_OTGEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGCTL_OTGEN field.
#define BR_USB_OTGCTL_OTGEN  (BITBAND_ACCESS8(HW_USB_OTGCTL_ADDR, BP_USB_OTGCTL_OTGEN))
#endif

//! @brief Format value for bitfield USB_OTGCTL_OTGEN.
#define BF_USB_OTGCTL_OTGEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGCTL_OTGEN), uint8_t) & BM_USB_OTGCTL_OTGEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OTGEN field to a new value.
#define BW_USB_OTGCTL_OTGEN(v) (BITBAND_ACCESS8(HW_USB_OTGCTL_ADDR, BP_USB_OTGCTL_OTGEN) = (v))
#endif
//@}

/*!
 * @name Register USB_OTGCTL, field DMLOW[4] (RW)
 *
 * Values:
 * - 0 - D- pulldown resistor is not enabled.
 * - 1 - D- pulldown resistor is enabled.
 */
//@{
#define BP_USB_OTGCTL_DMLOW  (4U)          //!< Bit position for USB_OTGCTL_DMLOW.
#define BM_USB_OTGCTL_DMLOW  (0x10U)       //!< Bit mask for USB_OTGCTL_DMLOW.
#define BS_USB_OTGCTL_DMLOW  (1U)          //!< Bit field size in bits for USB_OTGCTL_DMLOW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGCTL_DMLOW field.
#define BR_USB_OTGCTL_DMLOW  (BITBAND_ACCESS8(HW_USB_OTGCTL_ADDR, BP_USB_OTGCTL_DMLOW))
#endif

//! @brief Format value for bitfield USB_OTGCTL_DMLOW.
#define BF_USB_OTGCTL_DMLOW(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGCTL_DMLOW), uint8_t) & BM_USB_OTGCTL_DMLOW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMLOW field to a new value.
#define BW_USB_OTGCTL_DMLOW(v) (BITBAND_ACCESS8(HW_USB_OTGCTL_ADDR, BP_USB_OTGCTL_DMLOW) = (v))
#endif
//@}

/*!
 * @name Register USB_OTGCTL, field DPLOW[5] (RW)
 *
 * This bit should always be enabled together with bit 4 (DMLOW)
 *
 * Values:
 * - 0 - D+ pulldown resistor is not enabled.
 * - 1 - D+ pulldown resistor is enabled.
 */
//@{
#define BP_USB_OTGCTL_DPLOW  (5U)          //!< Bit position for USB_OTGCTL_DPLOW.
#define BM_USB_OTGCTL_DPLOW  (0x20U)       //!< Bit mask for USB_OTGCTL_DPLOW.
#define BS_USB_OTGCTL_DPLOW  (1U)          //!< Bit field size in bits for USB_OTGCTL_DPLOW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGCTL_DPLOW field.
#define BR_USB_OTGCTL_DPLOW  (BITBAND_ACCESS8(HW_USB_OTGCTL_ADDR, BP_USB_OTGCTL_DPLOW))
#endif

//! @brief Format value for bitfield USB_OTGCTL_DPLOW.
#define BF_USB_OTGCTL_DPLOW(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGCTL_DPLOW), uint8_t) & BM_USB_OTGCTL_DPLOW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DPLOW field to a new value.
#define BW_USB_OTGCTL_DPLOW(v) (BITBAND_ACCESS8(HW_USB_OTGCTL_ADDR, BP_USB_OTGCTL_DPLOW) = (v))
#endif
//@}

/*!
 * @name Register USB_OTGCTL, field DPHIGH[7] (RW)
 *
 * Values:
 * - 0 - D+ pullup resistor is not enabled
 * - 1 - D+ pullup resistor is enabled
 */
//@{
#define BP_USB_OTGCTL_DPHIGH (7U)          //!< Bit position for USB_OTGCTL_DPHIGH.
#define BM_USB_OTGCTL_DPHIGH (0x80U)       //!< Bit mask for USB_OTGCTL_DPHIGH.
#define BS_USB_OTGCTL_DPHIGH (1U)          //!< Bit field size in bits for USB_OTGCTL_DPHIGH.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OTGCTL_DPHIGH field.
#define BR_USB_OTGCTL_DPHIGH (BITBAND_ACCESS8(HW_USB_OTGCTL_ADDR, BP_USB_OTGCTL_DPHIGH))
#endif

//! @brief Format value for bitfield USB_OTGCTL_DPHIGH.
#define BF_USB_OTGCTL_DPHIGH(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_OTGCTL_DPHIGH), uint8_t) & BM_USB_OTGCTL_DPHIGH)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DPHIGH field to a new value.
#define BW_USB_OTGCTL_DPHIGH(v) (BITBAND_ACCESS8(HW_USB_OTGCTL_ADDR, BP_USB_OTGCTL_DPHIGH) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_ISTAT - Interrupt Status register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_ISTAT - Interrupt Status register (W1C)
 *
 * Reset value: 0x00U
 *
 * Contains fields for each of the interrupt sources within the USB Module. Each
 * of these fields are qualified with their respective interrupt enable bits.
 * All fields of this register are logically OR'd together along with the OTG
 * Interrupt Status Register (OTGSTAT) to form a single interrupt source for the
 * processor's interrupt controller. After an interrupt bit has been set it may only
 * be cleared by writing a one to the respective interrupt bit. This register
 * contains the value of 0x00 after a reset.
 */
typedef union _hw_usb_istat
{
    uint8_t U;
    struct _hw_usb_istat_bitfields
    {
        uint8_t USBRST : 1;            //!< [0]
        uint8_t ERROR : 1;             //!< [1]
        uint8_t SOFTOK : 1;            //!< [2]
        uint8_t TOKDNE : 1;            //!< [3]
        uint8_t SLEEP : 1;             //!< [4]
        uint8_t RESUME : 1;            //!< [5]
        uint8_t ATTACH : 1;            //!< [6] Attach Interrupt
        uint8_t STALL : 1;             //!< [7] Stall Interrupt
    } B;
} hw_usb_istat_t;
#endif

/*!
 * @name Constants and macros for entire USB_ISTAT register
 */
//@{
#define HW_USB_ISTAT_ADDR        (REGS_USB_BASE + 0x80U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_ISTAT             (*(__IO hw_usb_istat_t *) HW_USB_ISTAT_ADDR)
#define HW_USB_ISTAT_RD()        (HW_USB_ISTAT.U)
#define HW_USB_ISTAT_WR(v)       (HW_USB_ISTAT.U = (v))
#define HW_USB_ISTAT_SET(v)      (HW_USB_ISTAT_WR(HW_USB_ISTAT_RD() |  (v)))
#define HW_USB_ISTAT_CLR(v)      (HW_USB_ISTAT_WR(HW_USB_ISTAT_RD() & ~(v)))
#define HW_USB_ISTAT_TOG(v)      (HW_USB_ISTAT_WR(HW_USB_ISTAT_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_ISTAT bitfields
 */

/*!
 * @name Register USB_ISTAT, field USBRST[0] (W1C)
 *
 * This bit is set when the USB Module has decoded a valid USB reset. This
 * informs the processor that it should write 0x00 into the address register and
 * enable endpoint 0. USBRST is set after a USB reset has been detected for 2.5
 * microseconds. It is not asserted again until the USB reset condition has been
 * removed and then reasserted.
 */
//@{
#define BP_USB_ISTAT_USBRST  (0U)          //!< Bit position for USB_ISTAT_USBRST.
#define BM_USB_ISTAT_USBRST  (0x01U)       //!< Bit mask for USB_ISTAT_USBRST.
#define BS_USB_ISTAT_USBRST  (1U)          //!< Bit field size in bits for USB_ISTAT_USBRST.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ISTAT_USBRST field.
#define BR_USB_ISTAT_USBRST  (BITBAND_ACCESS8(HW_USB_ISTAT_ADDR, BP_USB_ISTAT_USBRST))
#endif

//! @brief Format value for bitfield USB_ISTAT_USBRST.
#define BF_USB_ISTAT_USBRST(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ISTAT_USBRST), uint8_t) & BM_USB_ISTAT_USBRST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the USBRST field to a new value.
#define BW_USB_ISTAT_USBRST(v) (BITBAND_ACCESS8(HW_USB_ISTAT_ADDR, BP_USB_ISTAT_USBRST) = (v))
#endif
//@}

/*!
 * @name Register USB_ISTAT, field ERROR[1] (W1C)
 *
 * This bit is set when any of the error conditions within Error Interrupt
 * Status (ERRSTAT) register occur. The processor must then read the ERRSTAT register
 * to determine the source of the error.
 */
//@{
#define BP_USB_ISTAT_ERROR   (1U)          //!< Bit position for USB_ISTAT_ERROR.
#define BM_USB_ISTAT_ERROR   (0x02U)       //!< Bit mask for USB_ISTAT_ERROR.
#define BS_USB_ISTAT_ERROR   (1U)          //!< Bit field size in bits for USB_ISTAT_ERROR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ISTAT_ERROR field.
#define BR_USB_ISTAT_ERROR   (BITBAND_ACCESS8(HW_USB_ISTAT_ADDR, BP_USB_ISTAT_ERROR))
#endif

//! @brief Format value for bitfield USB_ISTAT_ERROR.
#define BF_USB_ISTAT_ERROR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ISTAT_ERROR), uint8_t) & BM_USB_ISTAT_ERROR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ERROR field to a new value.
#define BW_USB_ISTAT_ERROR(v) (BITBAND_ACCESS8(HW_USB_ISTAT_ADDR, BP_USB_ISTAT_ERROR) = (v))
#endif
//@}

/*!
 * @name Register USB_ISTAT, field SOFTOK[2] (W1C)
 *
 * This bit is set when the USB Module receives a Start Of Frame (SOF) token. In
 * Host mode this field is set when the SOF threshold is reached, so that
 * software can prepare for the next SOF.
 */
//@{
#define BP_USB_ISTAT_SOFTOK  (2U)          //!< Bit position for USB_ISTAT_SOFTOK.
#define BM_USB_ISTAT_SOFTOK  (0x04U)       //!< Bit mask for USB_ISTAT_SOFTOK.
#define BS_USB_ISTAT_SOFTOK  (1U)          //!< Bit field size in bits for USB_ISTAT_SOFTOK.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ISTAT_SOFTOK field.
#define BR_USB_ISTAT_SOFTOK  (BITBAND_ACCESS8(HW_USB_ISTAT_ADDR, BP_USB_ISTAT_SOFTOK))
#endif

//! @brief Format value for bitfield USB_ISTAT_SOFTOK.
#define BF_USB_ISTAT_SOFTOK(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ISTAT_SOFTOK), uint8_t) & BM_USB_ISTAT_SOFTOK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SOFTOK field to a new value.
#define BW_USB_ISTAT_SOFTOK(v) (BITBAND_ACCESS8(HW_USB_ISTAT_ADDR, BP_USB_ISTAT_SOFTOK) = (v))
#endif
//@}

/*!
 * @name Register USB_ISTAT, field TOKDNE[3] (W1C)
 *
 * This bit is set when the current token being processed has completed. The
 * processor must immediately read the STATUS (STAT) register to determine the
 * EndPoint and BD used for this token. Clearing this bit (by writing a one) causes
 * STAT to be cleared or the STAT holding register to be loaded into the STAT
 * register.
 */
//@{
#define BP_USB_ISTAT_TOKDNE  (3U)          //!< Bit position for USB_ISTAT_TOKDNE.
#define BM_USB_ISTAT_TOKDNE  (0x08U)       //!< Bit mask for USB_ISTAT_TOKDNE.
#define BS_USB_ISTAT_TOKDNE  (1U)          //!< Bit field size in bits for USB_ISTAT_TOKDNE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ISTAT_TOKDNE field.
#define BR_USB_ISTAT_TOKDNE  (BITBAND_ACCESS8(HW_USB_ISTAT_ADDR, BP_USB_ISTAT_TOKDNE))
#endif

//! @brief Format value for bitfield USB_ISTAT_TOKDNE.
#define BF_USB_ISTAT_TOKDNE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ISTAT_TOKDNE), uint8_t) & BM_USB_ISTAT_TOKDNE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TOKDNE field to a new value.
#define BW_USB_ISTAT_TOKDNE(v) (BITBAND_ACCESS8(HW_USB_ISTAT_ADDR, BP_USB_ISTAT_TOKDNE) = (v))
#endif
//@}

/*!
 * @name Register USB_ISTAT, field SLEEP[4] (W1C)
 *
 * This bit is set when the USB Module detects a constant idle on the USB bus
 * for 3 ms. The sleep timer is reset by activity on the USB bus.
 */
//@{
#define BP_USB_ISTAT_SLEEP   (4U)          //!< Bit position for USB_ISTAT_SLEEP.
#define BM_USB_ISTAT_SLEEP   (0x10U)       //!< Bit mask for USB_ISTAT_SLEEP.
#define BS_USB_ISTAT_SLEEP   (1U)          //!< Bit field size in bits for USB_ISTAT_SLEEP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ISTAT_SLEEP field.
#define BR_USB_ISTAT_SLEEP   (BITBAND_ACCESS8(HW_USB_ISTAT_ADDR, BP_USB_ISTAT_SLEEP))
#endif

//! @brief Format value for bitfield USB_ISTAT_SLEEP.
#define BF_USB_ISTAT_SLEEP(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ISTAT_SLEEP), uint8_t) & BM_USB_ISTAT_SLEEP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SLEEP field to a new value.
#define BW_USB_ISTAT_SLEEP(v) (BITBAND_ACCESS8(HW_USB_ISTAT_ADDR, BP_USB_ISTAT_SLEEP) = (v))
#endif
//@}

/*!
 * @name Register USB_ISTAT, field RESUME[5] (W1C)
 *
 * This bit is set when a K-state is observed on the DP/DM signals for 2.5 us.
 * When not in suspend mode this interrupt must be disabled.
 */
//@{
#define BP_USB_ISTAT_RESUME  (5U)          //!< Bit position for USB_ISTAT_RESUME.
#define BM_USB_ISTAT_RESUME  (0x20U)       //!< Bit mask for USB_ISTAT_RESUME.
#define BS_USB_ISTAT_RESUME  (1U)          //!< Bit field size in bits for USB_ISTAT_RESUME.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ISTAT_RESUME field.
#define BR_USB_ISTAT_RESUME  (BITBAND_ACCESS8(HW_USB_ISTAT_ADDR, BP_USB_ISTAT_RESUME))
#endif

//! @brief Format value for bitfield USB_ISTAT_RESUME.
#define BF_USB_ISTAT_RESUME(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ISTAT_RESUME), uint8_t) & BM_USB_ISTAT_RESUME)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RESUME field to a new value.
#define BW_USB_ISTAT_RESUME(v) (BITBAND_ACCESS8(HW_USB_ISTAT_ADDR, BP_USB_ISTAT_RESUME) = (v))
#endif
//@}

/*!
 * @name Register USB_ISTAT, field ATTACH[6] (W1C)
 *
 * This bit is set when the USB Module detects an attach of a USB device. This
 * signal is only valid if HOSTMODEEN is true. This interrupt signifies that a
 * peripheral is now present and must be configured; it is asserted if there have
 * been no transitions on the USB for 2.5 us and the current bus state is not SE0."
 */
//@{
#define BP_USB_ISTAT_ATTACH  (6U)          //!< Bit position for USB_ISTAT_ATTACH.
#define BM_USB_ISTAT_ATTACH  (0x40U)       //!< Bit mask for USB_ISTAT_ATTACH.
#define BS_USB_ISTAT_ATTACH  (1U)          //!< Bit field size in bits for USB_ISTAT_ATTACH.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ISTAT_ATTACH field.
#define BR_USB_ISTAT_ATTACH  (BITBAND_ACCESS8(HW_USB_ISTAT_ADDR, BP_USB_ISTAT_ATTACH))
#endif

//! @brief Format value for bitfield USB_ISTAT_ATTACH.
#define BF_USB_ISTAT_ATTACH(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ISTAT_ATTACH), uint8_t) & BM_USB_ISTAT_ATTACH)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ATTACH field to a new value.
#define BW_USB_ISTAT_ATTACH(v) (BITBAND_ACCESS8(HW_USB_ISTAT_ADDR, BP_USB_ISTAT_ATTACH) = (v))
#endif
//@}

/*!
 * @name Register USB_ISTAT, field STALL[7] (W1C)
 *
 * In Target mode this bit is asserted when a STALL handshake is sent by the
 * SIE. In Host mode this bit is set when the USB Module detects a STALL acknowledge
 * during the handshake phase of a USB transaction.This interrupt can be used to
 * determine whether the last USB transaction was completed successfully or
 * stalled.
 */
//@{
#define BP_USB_ISTAT_STALL   (7U)          //!< Bit position for USB_ISTAT_STALL.
#define BM_USB_ISTAT_STALL   (0x80U)       //!< Bit mask for USB_ISTAT_STALL.
#define BS_USB_ISTAT_STALL   (1U)          //!< Bit field size in bits for USB_ISTAT_STALL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ISTAT_STALL field.
#define BR_USB_ISTAT_STALL   (BITBAND_ACCESS8(HW_USB_ISTAT_ADDR, BP_USB_ISTAT_STALL))
#endif

//! @brief Format value for bitfield USB_ISTAT_STALL.
#define BF_USB_ISTAT_STALL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ISTAT_STALL), uint8_t) & BM_USB_ISTAT_STALL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the STALL field to a new value.
#define BW_USB_ISTAT_STALL(v) (BITBAND_ACCESS8(HW_USB_ISTAT_ADDR, BP_USB_ISTAT_STALL) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_INTEN - Interrupt Enable register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_INTEN - Interrupt Enable register (RW)
 *
 * Reset value: 0x00U
 *
 * Contains enable fields for each of the interrupt sources within the USB
 * Module. Setting any of these bits enables the respective interrupt source in the
 * ISTAT register. This register contains the value of 0x00 after a reset.
 */
typedef union _hw_usb_inten
{
    uint8_t U;
    struct _hw_usb_inten_bitfields
    {
        uint8_t USBRSTEN : 1;          //!< [0] USBRST Interrupt Enable
        uint8_t ERROREN : 1;           //!< [1] ERROR Interrupt Enable
        uint8_t SOFTOKEN : 1;          //!< [2] SOFTOK Interrupt Enable
        uint8_t TOKDNEEN : 1;          //!< [3] TOKDNE Interrupt Enable
        uint8_t SLEEPEN : 1;           //!< [4] SLEEP Interrupt Enable
        uint8_t RESUMEEN : 1;          //!< [5] RESUME Interrupt Enable
        uint8_t ATTACHEN : 1;          //!< [6] ATTACH Interrupt Enable
        uint8_t STALLEN : 1;           //!< [7] STALL Interrupt Enable
    } B;
} hw_usb_inten_t;
#endif

/*!
 * @name Constants and macros for entire USB_INTEN register
 */
//@{
#define HW_USB_INTEN_ADDR        (REGS_USB_BASE + 0x84U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_INTEN             (*(__IO hw_usb_inten_t *) HW_USB_INTEN_ADDR)
#define HW_USB_INTEN_RD()        (HW_USB_INTEN.U)
#define HW_USB_INTEN_WR(v)       (HW_USB_INTEN.U = (v))
#define HW_USB_INTEN_SET(v)      (HW_USB_INTEN_WR(HW_USB_INTEN_RD() |  (v)))
#define HW_USB_INTEN_CLR(v)      (HW_USB_INTEN_WR(HW_USB_INTEN_RD() & ~(v)))
#define HW_USB_INTEN_TOG(v)      (HW_USB_INTEN_WR(HW_USB_INTEN_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_INTEN bitfields
 */

/*!
 * @name Register USB_INTEN, field USBRSTEN[0] (RW)
 *
 * Values:
 * - 0 - Disables the USBRST interrupt.
 * - 1 - Enables the USBRST interrupt.
 */
//@{
#define BP_USB_INTEN_USBRSTEN (0U)         //!< Bit position for USB_INTEN_USBRSTEN.
#define BM_USB_INTEN_USBRSTEN (0x01U)      //!< Bit mask for USB_INTEN_USBRSTEN.
#define BS_USB_INTEN_USBRSTEN (1U)         //!< Bit field size in bits for USB_INTEN_USBRSTEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_INTEN_USBRSTEN field.
#define BR_USB_INTEN_USBRSTEN (BITBAND_ACCESS8(HW_USB_INTEN_ADDR, BP_USB_INTEN_USBRSTEN))
#endif

//! @brief Format value for bitfield USB_INTEN_USBRSTEN.
#define BF_USB_INTEN_USBRSTEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_INTEN_USBRSTEN), uint8_t) & BM_USB_INTEN_USBRSTEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the USBRSTEN field to a new value.
#define BW_USB_INTEN_USBRSTEN(v) (BITBAND_ACCESS8(HW_USB_INTEN_ADDR, BP_USB_INTEN_USBRSTEN) = (v))
#endif
//@}

/*!
 * @name Register USB_INTEN, field ERROREN[1] (RW)
 *
 * Values:
 * - 0 - Disables the ERROR interrupt.
 * - 1 - Enables the ERROR interrupt.
 */
//@{
#define BP_USB_INTEN_ERROREN (1U)          //!< Bit position for USB_INTEN_ERROREN.
#define BM_USB_INTEN_ERROREN (0x02U)       //!< Bit mask for USB_INTEN_ERROREN.
#define BS_USB_INTEN_ERROREN (1U)          //!< Bit field size in bits for USB_INTEN_ERROREN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_INTEN_ERROREN field.
#define BR_USB_INTEN_ERROREN (BITBAND_ACCESS8(HW_USB_INTEN_ADDR, BP_USB_INTEN_ERROREN))
#endif

//! @brief Format value for bitfield USB_INTEN_ERROREN.
#define BF_USB_INTEN_ERROREN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_INTEN_ERROREN), uint8_t) & BM_USB_INTEN_ERROREN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ERROREN field to a new value.
#define BW_USB_INTEN_ERROREN(v) (BITBAND_ACCESS8(HW_USB_INTEN_ADDR, BP_USB_INTEN_ERROREN) = (v))
#endif
//@}

/*!
 * @name Register USB_INTEN, field SOFTOKEN[2] (RW)
 *
 * Values:
 * - 0 - Disbles the SOFTOK interrupt.
 * - 1 - Enables the SOFTOK interrupt.
 */
//@{
#define BP_USB_INTEN_SOFTOKEN (2U)         //!< Bit position for USB_INTEN_SOFTOKEN.
#define BM_USB_INTEN_SOFTOKEN (0x04U)      //!< Bit mask for USB_INTEN_SOFTOKEN.
#define BS_USB_INTEN_SOFTOKEN (1U)         //!< Bit field size in bits for USB_INTEN_SOFTOKEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_INTEN_SOFTOKEN field.
#define BR_USB_INTEN_SOFTOKEN (BITBAND_ACCESS8(HW_USB_INTEN_ADDR, BP_USB_INTEN_SOFTOKEN))
#endif

//! @brief Format value for bitfield USB_INTEN_SOFTOKEN.
#define BF_USB_INTEN_SOFTOKEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_INTEN_SOFTOKEN), uint8_t) & BM_USB_INTEN_SOFTOKEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SOFTOKEN field to a new value.
#define BW_USB_INTEN_SOFTOKEN(v) (BITBAND_ACCESS8(HW_USB_INTEN_ADDR, BP_USB_INTEN_SOFTOKEN) = (v))
#endif
//@}

/*!
 * @name Register USB_INTEN, field TOKDNEEN[3] (RW)
 *
 * Values:
 * - 0 - Disables the TOKDNE interrupt.
 * - 1 - Enables the TOKDNE interrupt.
 */
//@{
#define BP_USB_INTEN_TOKDNEEN (3U)         //!< Bit position for USB_INTEN_TOKDNEEN.
#define BM_USB_INTEN_TOKDNEEN (0x08U)      //!< Bit mask for USB_INTEN_TOKDNEEN.
#define BS_USB_INTEN_TOKDNEEN (1U)         //!< Bit field size in bits for USB_INTEN_TOKDNEEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_INTEN_TOKDNEEN field.
#define BR_USB_INTEN_TOKDNEEN (BITBAND_ACCESS8(HW_USB_INTEN_ADDR, BP_USB_INTEN_TOKDNEEN))
#endif

//! @brief Format value for bitfield USB_INTEN_TOKDNEEN.
#define BF_USB_INTEN_TOKDNEEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_INTEN_TOKDNEEN), uint8_t) & BM_USB_INTEN_TOKDNEEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TOKDNEEN field to a new value.
#define BW_USB_INTEN_TOKDNEEN(v) (BITBAND_ACCESS8(HW_USB_INTEN_ADDR, BP_USB_INTEN_TOKDNEEN) = (v))
#endif
//@}

/*!
 * @name Register USB_INTEN, field SLEEPEN[4] (RW)
 *
 * Values:
 * - 0 - Disables the SLEEP interrupt.
 * - 1 - Enables the SLEEP interrupt.
 */
//@{
#define BP_USB_INTEN_SLEEPEN (4U)          //!< Bit position for USB_INTEN_SLEEPEN.
#define BM_USB_INTEN_SLEEPEN (0x10U)       //!< Bit mask for USB_INTEN_SLEEPEN.
#define BS_USB_INTEN_SLEEPEN (1U)          //!< Bit field size in bits for USB_INTEN_SLEEPEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_INTEN_SLEEPEN field.
#define BR_USB_INTEN_SLEEPEN (BITBAND_ACCESS8(HW_USB_INTEN_ADDR, BP_USB_INTEN_SLEEPEN))
#endif

//! @brief Format value for bitfield USB_INTEN_SLEEPEN.
#define BF_USB_INTEN_SLEEPEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_INTEN_SLEEPEN), uint8_t) & BM_USB_INTEN_SLEEPEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SLEEPEN field to a new value.
#define BW_USB_INTEN_SLEEPEN(v) (BITBAND_ACCESS8(HW_USB_INTEN_ADDR, BP_USB_INTEN_SLEEPEN) = (v))
#endif
//@}

/*!
 * @name Register USB_INTEN, field RESUMEEN[5] (RW)
 *
 * Values:
 * - 0 - Disables the RESUME interrupt.
 * - 1 - Enables the RESUME interrupt.
 */
//@{
#define BP_USB_INTEN_RESUMEEN (5U)         //!< Bit position for USB_INTEN_RESUMEEN.
#define BM_USB_INTEN_RESUMEEN (0x20U)      //!< Bit mask for USB_INTEN_RESUMEEN.
#define BS_USB_INTEN_RESUMEEN (1U)         //!< Bit field size in bits for USB_INTEN_RESUMEEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_INTEN_RESUMEEN field.
#define BR_USB_INTEN_RESUMEEN (BITBAND_ACCESS8(HW_USB_INTEN_ADDR, BP_USB_INTEN_RESUMEEN))
#endif

//! @brief Format value for bitfield USB_INTEN_RESUMEEN.
#define BF_USB_INTEN_RESUMEEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_INTEN_RESUMEEN), uint8_t) & BM_USB_INTEN_RESUMEEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RESUMEEN field to a new value.
#define BW_USB_INTEN_RESUMEEN(v) (BITBAND_ACCESS8(HW_USB_INTEN_ADDR, BP_USB_INTEN_RESUMEEN) = (v))
#endif
//@}

/*!
 * @name Register USB_INTEN, field ATTACHEN[6] (RW)
 *
 * Values:
 * - 0 - Disables the ATTACH interrupt.
 * - 1 - Enables the ATTACH interrupt.
 */
//@{
#define BP_USB_INTEN_ATTACHEN (6U)         //!< Bit position for USB_INTEN_ATTACHEN.
#define BM_USB_INTEN_ATTACHEN (0x40U)      //!< Bit mask for USB_INTEN_ATTACHEN.
#define BS_USB_INTEN_ATTACHEN (1U)         //!< Bit field size in bits for USB_INTEN_ATTACHEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_INTEN_ATTACHEN field.
#define BR_USB_INTEN_ATTACHEN (BITBAND_ACCESS8(HW_USB_INTEN_ADDR, BP_USB_INTEN_ATTACHEN))
#endif

//! @brief Format value for bitfield USB_INTEN_ATTACHEN.
#define BF_USB_INTEN_ATTACHEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_INTEN_ATTACHEN), uint8_t) & BM_USB_INTEN_ATTACHEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ATTACHEN field to a new value.
#define BW_USB_INTEN_ATTACHEN(v) (BITBAND_ACCESS8(HW_USB_INTEN_ADDR, BP_USB_INTEN_ATTACHEN) = (v))
#endif
//@}

/*!
 * @name Register USB_INTEN, field STALLEN[7] (RW)
 *
 * Values:
 * - 0 - Diasbles the STALL interrupt.
 * - 1 - Enables the STALL interrupt.
 */
//@{
#define BP_USB_INTEN_STALLEN (7U)          //!< Bit position for USB_INTEN_STALLEN.
#define BM_USB_INTEN_STALLEN (0x80U)       //!< Bit mask for USB_INTEN_STALLEN.
#define BS_USB_INTEN_STALLEN (1U)          //!< Bit field size in bits for USB_INTEN_STALLEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_INTEN_STALLEN field.
#define BR_USB_INTEN_STALLEN (BITBAND_ACCESS8(HW_USB_INTEN_ADDR, BP_USB_INTEN_STALLEN))
#endif

//! @brief Format value for bitfield USB_INTEN_STALLEN.
#define BF_USB_INTEN_STALLEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_INTEN_STALLEN), uint8_t) & BM_USB_INTEN_STALLEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the STALLEN field to a new value.
#define BW_USB_INTEN_STALLEN(v) (BITBAND_ACCESS8(HW_USB_INTEN_ADDR, BP_USB_INTEN_STALLEN) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_ERRSTAT - Error Interrupt Status register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_ERRSTAT - Error Interrupt Status register (RW)
 *
 * Reset value: 0x00U
 *
 * Contains enable bits for each of the error sources within the USB Module.
 * Each of these bits are qualified with their respective error enable bits. All
 * bits of this register are logically OR'd together and the result placed in the
 * ERROR bit of the ISTAT register. After an interrupt bit has been set it may only
 * be cleared by writing a one to the respective interrupt bit. Each bit is set
 * as soon as the error condition is detected. Therefore, the interrupt does not
 * typically correspond with the end of a token being processed. This register
 * contains the value of 0x00 after a reset.
 */
typedef union _hw_usb_errstat
{
    uint8_t U;
    struct _hw_usb_errstat_bitfields
    {
        uint8_t PIDERR : 1;            //!< [0]
        uint8_t CRC5EOF : 1;           //!< [1]
        uint8_t CRC16 : 1;             //!< [2]
        uint8_t DFN8 : 1;              //!< [3]
        uint8_t BTOERR : 1;            //!< [4]
        uint8_t DMAERR : 1;            //!< [5]
        uint8_t RESERVED0 : 1;         //!< [6]
        uint8_t BTSERR : 1;            //!< [7]
    } B;
} hw_usb_errstat_t;
#endif

/*!
 * @name Constants and macros for entire USB_ERRSTAT register
 */
//@{
#define HW_USB_ERRSTAT_ADDR      (REGS_USB_BASE + 0x88U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_ERRSTAT           (*(__IO hw_usb_errstat_t *) HW_USB_ERRSTAT_ADDR)
#define HW_USB_ERRSTAT_RD()      (HW_USB_ERRSTAT.U)
#define HW_USB_ERRSTAT_WR(v)     (HW_USB_ERRSTAT.U = (v))
#define HW_USB_ERRSTAT_SET(v)    (HW_USB_ERRSTAT_WR(HW_USB_ERRSTAT_RD() |  (v)))
#define HW_USB_ERRSTAT_CLR(v)    (HW_USB_ERRSTAT_WR(HW_USB_ERRSTAT_RD() & ~(v)))
#define HW_USB_ERRSTAT_TOG(v)    (HW_USB_ERRSTAT_WR(HW_USB_ERRSTAT_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_ERRSTAT bitfields
 */

/*!
 * @name Register USB_ERRSTAT, field PIDERR[0] (W1C)
 *
 * This bit is set when the PID check field fails.
 */
//@{
#define BP_USB_ERRSTAT_PIDERR (0U)         //!< Bit position for USB_ERRSTAT_PIDERR.
#define BM_USB_ERRSTAT_PIDERR (0x01U)      //!< Bit mask for USB_ERRSTAT_PIDERR.
#define BS_USB_ERRSTAT_PIDERR (1U)         //!< Bit field size in bits for USB_ERRSTAT_PIDERR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ERRSTAT_PIDERR field.
#define BR_USB_ERRSTAT_PIDERR (BITBAND_ACCESS8(HW_USB_ERRSTAT_ADDR, BP_USB_ERRSTAT_PIDERR))
#endif

//! @brief Format value for bitfield USB_ERRSTAT_PIDERR.
#define BF_USB_ERRSTAT_PIDERR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ERRSTAT_PIDERR), uint8_t) & BM_USB_ERRSTAT_PIDERR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PIDERR field to a new value.
#define BW_USB_ERRSTAT_PIDERR(v) (BITBAND_ACCESS8(HW_USB_ERRSTAT_ADDR, BP_USB_ERRSTAT_PIDERR) = (v))
#endif
//@}

/*!
 * @name Register USB_ERRSTAT, field CRC5EOF[1] (W1C)
 *
 * This error interrupt has two functions. When the USB Module is operating in
 * peripheral mode (HOSTMODEEN=0), this interrupt detects CRC5 errors in the token
 * packets generated by the host. If set the token packet was rejected due to a
 * CRC5 error. When the USB Module is operating in host mode (HOSTMODEEN=1), this
 * interrupt detects End Of Frame (EOF) error conditions. This occurs when the
 * USB Module is transmitting or receiving data and the SOF counter reaches zero.
 * This interrupt is useful when developing USB packet scheduling software to
 * ensure that no USB transactions cross the start of the next frame.
 */
//@{
#define BP_USB_ERRSTAT_CRC5EOF (1U)        //!< Bit position for USB_ERRSTAT_CRC5EOF.
#define BM_USB_ERRSTAT_CRC5EOF (0x02U)     //!< Bit mask for USB_ERRSTAT_CRC5EOF.
#define BS_USB_ERRSTAT_CRC5EOF (1U)        //!< Bit field size in bits for USB_ERRSTAT_CRC5EOF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ERRSTAT_CRC5EOF field.
#define BR_USB_ERRSTAT_CRC5EOF (BITBAND_ACCESS8(HW_USB_ERRSTAT_ADDR, BP_USB_ERRSTAT_CRC5EOF))
#endif

//! @brief Format value for bitfield USB_ERRSTAT_CRC5EOF.
#define BF_USB_ERRSTAT_CRC5EOF(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ERRSTAT_CRC5EOF), uint8_t) & BM_USB_ERRSTAT_CRC5EOF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CRC5EOF field to a new value.
#define BW_USB_ERRSTAT_CRC5EOF(v) (BITBAND_ACCESS8(HW_USB_ERRSTAT_ADDR, BP_USB_ERRSTAT_CRC5EOF) = (v))
#endif
//@}

/*!
 * @name Register USB_ERRSTAT, field CRC16[2] (W1C)
 *
 * This bit is set when a data packet is rejected due to a CRC16 error.
 */
//@{
#define BP_USB_ERRSTAT_CRC16 (2U)          //!< Bit position for USB_ERRSTAT_CRC16.
#define BM_USB_ERRSTAT_CRC16 (0x04U)       //!< Bit mask for USB_ERRSTAT_CRC16.
#define BS_USB_ERRSTAT_CRC16 (1U)          //!< Bit field size in bits for USB_ERRSTAT_CRC16.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ERRSTAT_CRC16 field.
#define BR_USB_ERRSTAT_CRC16 (BITBAND_ACCESS8(HW_USB_ERRSTAT_ADDR, BP_USB_ERRSTAT_CRC16))
#endif

//! @brief Format value for bitfield USB_ERRSTAT_CRC16.
#define BF_USB_ERRSTAT_CRC16(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ERRSTAT_CRC16), uint8_t) & BM_USB_ERRSTAT_CRC16)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CRC16 field to a new value.
#define BW_USB_ERRSTAT_CRC16(v) (BITBAND_ACCESS8(HW_USB_ERRSTAT_ADDR, BP_USB_ERRSTAT_CRC16) = (v))
#endif
//@}

/*!
 * @name Register USB_ERRSTAT, field DFN8[3] (W1C)
 *
 * This bit is set if the data field received was not 8 bits in length. USB
 * Specification 1.0 requires that data fields be an integral number of bytes. If the
 * data field was not an integral number of bytes, this bit is set.
 */
//@{
#define BP_USB_ERRSTAT_DFN8  (3U)          //!< Bit position for USB_ERRSTAT_DFN8.
#define BM_USB_ERRSTAT_DFN8  (0x08U)       //!< Bit mask for USB_ERRSTAT_DFN8.
#define BS_USB_ERRSTAT_DFN8  (1U)          //!< Bit field size in bits for USB_ERRSTAT_DFN8.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ERRSTAT_DFN8 field.
#define BR_USB_ERRSTAT_DFN8  (BITBAND_ACCESS8(HW_USB_ERRSTAT_ADDR, BP_USB_ERRSTAT_DFN8))
#endif

//! @brief Format value for bitfield USB_ERRSTAT_DFN8.
#define BF_USB_ERRSTAT_DFN8(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ERRSTAT_DFN8), uint8_t) & BM_USB_ERRSTAT_DFN8)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DFN8 field to a new value.
#define BW_USB_ERRSTAT_DFN8(v) (BITBAND_ACCESS8(HW_USB_ERRSTAT_ADDR, BP_USB_ERRSTAT_DFN8) = (v))
#endif
//@}

/*!
 * @name Register USB_ERRSTAT, field BTOERR[4] (W1C)
 *
 * This bit is set when a bus turnaround timeout error occurs. The USB module
 * contains a bus turnaround timer that keeps track of the amount of time elapsed
 * between the token and data phases of a SETUP or OUT TOKEN or the data and
 * handshake phases of a IN TOKEN. If more than 16 bit times are counted from the
 * previous EOP before a transition from IDLE, a bus turnaround timeout error occurs.
 */
//@{
#define BP_USB_ERRSTAT_BTOERR (4U)         //!< Bit position for USB_ERRSTAT_BTOERR.
#define BM_USB_ERRSTAT_BTOERR (0x10U)      //!< Bit mask for USB_ERRSTAT_BTOERR.
#define BS_USB_ERRSTAT_BTOERR (1U)         //!< Bit field size in bits for USB_ERRSTAT_BTOERR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ERRSTAT_BTOERR field.
#define BR_USB_ERRSTAT_BTOERR (BITBAND_ACCESS8(HW_USB_ERRSTAT_ADDR, BP_USB_ERRSTAT_BTOERR))
#endif

//! @brief Format value for bitfield USB_ERRSTAT_BTOERR.
#define BF_USB_ERRSTAT_BTOERR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ERRSTAT_BTOERR), uint8_t) & BM_USB_ERRSTAT_BTOERR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BTOERR field to a new value.
#define BW_USB_ERRSTAT_BTOERR(v) (BITBAND_ACCESS8(HW_USB_ERRSTAT_ADDR, BP_USB_ERRSTAT_BTOERR) = (v))
#endif
//@}

/*!
 * @name Register USB_ERRSTAT, field DMAERR[5] (W1C)
 *
 * This bit is set if the USB Module has requested a DMA access to read a new
 * BDT but has not been given the bus before it needs to receive or transmit data.
 * If processing a TX transfer this would cause a transmit data underflow
 * condition. If processing a RX transfer this would cause a receive data overflow
 * condition. This interrupt is useful when developing device arbitration hardware for
 * the microprocessor and the USB module to minimize bus request and bus grant
 * latency. This bit is also set if a data packet to or from the host is larger
 * than the buffer size allocated in the BDT. In this case the data packet is
 * truncated as it is put in buffer memory.
 */
//@{
#define BP_USB_ERRSTAT_DMAERR (5U)         //!< Bit position for USB_ERRSTAT_DMAERR.
#define BM_USB_ERRSTAT_DMAERR (0x20U)      //!< Bit mask for USB_ERRSTAT_DMAERR.
#define BS_USB_ERRSTAT_DMAERR (1U)         //!< Bit field size in bits for USB_ERRSTAT_DMAERR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ERRSTAT_DMAERR field.
#define BR_USB_ERRSTAT_DMAERR (BITBAND_ACCESS8(HW_USB_ERRSTAT_ADDR, BP_USB_ERRSTAT_DMAERR))
#endif

//! @brief Format value for bitfield USB_ERRSTAT_DMAERR.
#define BF_USB_ERRSTAT_DMAERR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ERRSTAT_DMAERR), uint8_t) & BM_USB_ERRSTAT_DMAERR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMAERR field to a new value.
#define BW_USB_ERRSTAT_DMAERR(v) (BITBAND_ACCESS8(HW_USB_ERRSTAT_ADDR, BP_USB_ERRSTAT_DMAERR) = (v))
#endif
//@}

/*!
 * @name Register USB_ERRSTAT, field BTSERR[7] (W1C)
 *
 * This bit is set when a bit stuff error is detected. If set, the corresponding
 * packet is rejected due to the error.
 */
//@{
#define BP_USB_ERRSTAT_BTSERR (7U)         //!< Bit position for USB_ERRSTAT_BTSERR.
#define BM_USB_ERRSTAT_BTSERR (0x80U)      //!< Bit mask for USB_ERRSTAT_BTSERR.
#define BS_USB_ERRSTAT_BTSERR (1U)         //!< Bit field size in bits for USB_ERRSTAT_BTSERR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ERRSTAT_BTSERR field.
#define BR_USB_ERRSTAT_BTSERR (BITBAND_ACCESS8(HW_USB_ERRSTAT_ADDR, BP_USB_ERRSTAT_BTSERR))
#endif

//! @brief Format value for bitfield USB_ERRSTAT_BTSERR.
#define BF_USB_ERRSTAT_BTSERR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ERRSTAT_BTSERR), uint8_t) & BM_USB_ERRSTAT_BTSERR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BTSERR field to a new value.
#define BW_USB_ERRSTAT_BTSERR(v) (BITBAND_ACCESS8(HW_USB_ERRSTAT_ADDR, BP_USB_ERRSTAT_BTSERR) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_ERREN - Error Interrupt Enable register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_ERREN - Error Interrupt Enable register (RW)
 *
 * Reset value: 0x00U
 *
 * Contains enable bits for each of the error interrupt sources within the USB
 * module. Setting any of these bits enables the respective interrupt source in
 * ERRSTAT. Each bit is set as soon as the error condition is detected. Therefore,
 * the interrupt does not typically correspond with the end of a token being
 * processed. This register contains the value of 0x00 after a reset.
 */
typedef union _hw_usb_erren
{
    uint8_t U;
    struct _hw_usb_erren_bitfields
    {
        uint8_t PIDERREN : 1;          //!< [0] PIDERR Interrupt Enable
        uint8_t CRC5EOFEN : 1;         //!< [1] CRC5/EOF Interrupt Enable
        uint8_t CRC16EN : 1;           //!< [2] CRC16 Interrupt Enable
        uint8_t DFN8EN : 1;            //!< [3] DFN8 Interrupt Enable
        uint8_t BTOERREN : 1;          //!< [4] BTOERR Interrupt Enable
        uint8_t DMAERREN : 1;          //!< [5] DMAERR Interrupt Enable
        uint8_t RESERVED0 : 1;         //!< [6]
        uint8_t BTSERREN : 1;          //!< [7] BTSERR Interrupt Enable
    } B;
} hw_usb_erren_t;
#endif

/*!
 * @name Constants and macros for entire USB_ERREN register
 */
//@{
#define HW_USB_ERREN_ADDR        (REGS_USB_BASE + 0x8CU)

#ifndef __LANGUAGE_ASM__
#define HW_USB_ERREN             (*(__IO hw_usb_erren_t *) HW_USB_ERREN_ADDR)
#define HW_USB_ERREN_RD()        (HW_USB_ERREN.U)
#define HW_USB_ERREN_WR(v)       (HW_USB_ERREN.U = (v))
#define HW_USB_ERREN_SET(v)      (HW_USB_ERREN_WR(HW_USB_ERREN_RD() |  (v)))
#define HW_USB_ERREN_CLR(v)      (HW_USB_ERREN_WR(HW_USB_ERREN_RD() & ~(v)))
#define HW_USB_ERREN_TOG(v)      (HW_USB_ERREN_WR(HW_USB_ERREN_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_ERREN bitfields
 */

/*!
 * @name Register USB_ERREN, field PIDERREN[0] (RW)
 *
 * Values:
 * - 0 - Disables the PIDERR interrupt.
 * - 1 - Enters the PIDERR interrupt.
 */
//@{
#define BP_USB_ERREN_PIDERREN (0U)         //!< Bit position for USB_ERREN_PIDERREN.
#define BM_USB_ERREN_PIDERREN (0x01U)      //!< Bit mask for USB_ERREN_PIDERREN.
#define BS_USB_ERREN_PIDERREN (1U)         //!< Bit field size in bits for USB_ERREN_PIDERREN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ERREN_PIDERREN field.
#define BR_USB_ERREN_PIDERREN (BITBAND_ACCESS8(HW_USB_ERREN_ADDR, BP_USB_ERREN_PIDERREN))
#endif

//! @brief Format value for bitfield USB_ERREN_PIDERREN.
#define BF_USB_ERREN_PIDERREN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ERREN_PIDERREN), uint8_t) & BM_USB_ERREN_PIDERREN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PIDERREN field to a new value.
#define BW_USB_ERREN_PIDERREN(v) (BITBAND_ACCESS8(HW_USB_ERREN_ADDR, BP_USB_ERREN_PIDERREN) = (v))
#endif
//@}

/*!
 * @name Register USB_ERREN, field CRC5EOFEN[1] (RW)
 *
 * Values:
 * - 0 - Disables the CRC5/EOF interrupt.
 * - 1 - Enables the CRC5/EOF interrupt.
 */
//@{
#define BP_USB_ERREN_CRC5EOFEN (1U)        //!< Bit position for USB_ERREN_CRC5EOFEN.
#define BM_USB_ERREN_CRC5EOFEN (0x02U)     //!< Bit mask for USB_ERREN_CRC5EOFEN.
#define BS_USB_ERREN_CRC5EOFEN (1U)        //!< Bit field size in bits for USB_ERREN_CRC5EOFEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ERREN_CRC5EOFEN field.
#define BR_USB_ERREN_CRC5EOFEN (BITBAND_ACCESS8(HW_USB_ERREN_ADDR, BP_USB_ERREN_CRC5EOFEN))
#endif

//! @brief Format value for bitfield USB_ERREN_CRC5EOFEN.
#define BF_USB_ERREN_CRC5EOFEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ERREN_CRC5EOFEN), uint8_t) & BM_USB_ERREN_CRC5EOFEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CRC5EOFEN field to a new value.
#define BW_USB_ERREN_CRC5EOFEN(v) (BITBAND_ACCESS8(HW_USB_ERREN_ADDR, BP_USB_ERREN_CRC5EOFEN) = (v))
#endif
//@}

/*!
 * @name Register USB_ERREN, field CRC16EN[2] (RW)
 *
 * Values:
 * - 0 - Disables the CRC16 interrupt.
 * - 1 - Enables the CRC16 interrupt.
 */
//@{
#define BP_USB_ERREN_CRC16EN (2U)          //!< Bit position for USB_ERREN_CRC16EN.
#define BM_USB_ERREN_CRC16EN (0x04U)       //!< Bit mask for USB_ERREN_CRC16EN.
#define BS_USB_ERREN_CRC16EN (1U)          //!< Bit field size in bits for USB_ERREN_CRC16EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ERREN_CRC16EN field.
#define BR_USB_ERREN_CRC16EN (BITBAND_ACCESS8(HW_USB_ERREN_ADDR, BP_USB_ERREN_CRC16EN))
#endif

//! @brief Format value for bitfield USB_ERREN_CRC16EN.
#define BF_USB_ERREN_CRC16EN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ERREN_CRC16EN), uint8_t) & BM_USB_ERREN_CRC16EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CRC16EN field to a new value.
#define BW_USB_ERREN_CRC16EN(v) (BITBAND_ACCESS8(HW_USB_ERREN_ADDR, BP_USB_ERREN_CRC16EN) = (v))
#endif
//@}

/*!
 * @name Register USB_ERREN, field DFN8EN[3] (RW)
 *
 * Values:
 * - 0 - Disables the DFN8 interrupt.
 * - 1 - Enables the DFN8 interrupt.
 */
//@{
#define BP_USB_ERREN_DFN8EN  (3U)          //!< Bit position for USB_ERREN_DFN8EN.
#define BM_USB_ERREN_DFN8EN  (0x08U)       //!< Bit mask for USB_ERREN_DFN8EN.
#define BS_USB_ERREN_DFN8EN  (1U)          //!< Bit field size in bits for USB_ERREN_DFN8EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ERREN_DFN8EN field.
#define BR_USB_ERREN_DFN8EN  (BITBAND_ACCESS8(HW_USB_ERREN_ADDR, BP_USB_ERREN_DFN8EN))
#endif

//! @brief Format value for bitfield USB_ERREN_DFN8EN.
#define BF_USB_ERREN_DFN8EN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ERREN_DFN8EN), uint8_t) & BM_USB_ERREN_DFN8EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DFN8EN field to a new value.
#define BW_USB_ERREN_DFN8EN(v) (BITBAND_ACCESS8(HW_USB_ERREN_ADDR, BP_USB_ERREN_DFN8EN) = (v))
#endif
//@}

/*!
 * @name Register USB_ERREN, field BTOERREN[4] (RW)
 *
 * Values:
 * - 0 - Disables the BTOERR interrupt.
 * - 1 - Enables the BTOERR interrupt.
 */
//@{
#define BP_USB_ERREN_BTOERREN (4U)         //!< Bit position for USB_ERREN_BTOERREN.
#define BM_USB_ERREN_BTOERREN (0x10U)      //!< Bit mask for USB_ERREN_BTOERREN.
#define BS_USB_ERREN_BTOERREN (1U)         //!< Bit field size in bits for USB_ERREN_BTOERREN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ERREN_BTOERREN field.
#define BR_USB_ERREN_BTOERREN (BITBAND_ACCESS8(HW_USB_ERREN_ADDR, BP_USB_ERREN_BTOERREN))
#endif

//! @brief Format value for bitfield USB_ERREN_BTOERREN.
#define BF_USB_ERREN_BTOERREN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ERREN_BTOERREN), uint8_t) & BM_USB_ERREN_BTOERREN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BTOERREN field to a new value.
#define BW_USB_ERREN_BTOERREN(v) (BITBAND_ACCESS8(HW_USB_ERREN_ADDR, BP_USB_ERREN_BTOERREN) = (v))
#endif
//@}

/*!
 * @name Register USB_ERREN, field DMAERREN[5] (RW)
 *
 * Values:
 * - 0 - Disables the DMAERR interrupt.
 * - 1 - Enables the DMAERR interrupt.
 */
//@{
#define BP_USB_ERREN_DMAERREN (5U)         //!< Bit position for USB_ERREN_DMAERREN.
#define BM_USB_ERREN_DMAERREN (0x20U)      //!< Bit mask for USB_ERREN_DMAERREN.
#define BS_USB_ERREN_DMAERREN (1U)         //!< Bit field size in bits for USB_ERREN_DMAERREN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ERREN_DMAERREN field.
#define BR_USB_ERREN_DMAERREN (BITBAND_ACCESS8(HW_USB_ERREN_ADDR, BP_USB_ERREN_DMAERREN))
#endif

//! @brief Format value for bitfield USB_ERREN_DMAERREN.
#define BF_USB_ERREN_DMAERREN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ERREN_DMAERREN), uint8_t) & BM_USB_ERREN_DMAERREN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMAERREN field to a new value.
#define BW_USB_ERREN_DMAERREN(v) (BITBAND_ACCESS8(HW_USB_ERREN_ADDR, BP_USB_ERREN_DMAERREN) = (v))
#endif
//@}

/*!
 * @name Register USB_ERREN, field BTSERREN[7] (RW)
 *
 * Values:
 * - 0 - Disables the BTSERR interrupt.
 * - 1 - Enables the BTSERR interrupt.
 */
//@{
#define BP_USB_ERREN_BTSERREN (7U)         //!< Bit position for USB_ERREN_BTSERREN.
#define BM_USB_ERREN_BTSERREN (0x80U)      //!< Bit mask for USB_ERREN_BTSERREN.
#define BS_USB_ERREN_BTSERREN (1U)         //!< Bit field size in bits for USB_ERREN_BTSERREN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ERREN_BTSERREN field.
#define BR_USB_ERREN_BTSERREN (BITBAND_ACCESS8(HW_USB_ERREN_ADDR, BP_USB_ERREN_BTSERREN))
#endif

//! @brief Format value for bitfield USB_ERREN_BTSERREN.
#define BF_USB_ERREN_BTSERREN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ERREN_BTSERREN), uint8_t) & BM_USB_ERREN_BTSERREN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BTSERREN field to a new value.
#define BW_USB_ERREN_BTSERREN(v) (BITBAND_ACCESS8(HW_USB_ERREN_ADDR, BP_USB_ERREN_BTSERREN) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_STAT - Status register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_STAT - Status register (RO)
 *
 * Reset value: 0x00U
 *
 * Reports the transaction status within the USB module. When the processor's
 * interrupt controller has received a TOKDNE, interrupt the Status Register must
 * be read to determine the status of the previous endpoint communication. The
 * data in the status register is valid when TOKDNE interrupt is asserted. The
 * Status register is actually a read window into a status FIFO maintained by the USB
 * module. When the USB module uses a BD, it updates the Status register. If
 * another USB transaction is performed before the TOKDNE interrupt is serviced, the
 * USB module stores the status of the next transaction in the STAT FIFO. Thus
 * STAT is actually a four byte FIFO that allows the processor core to process one
 * transaction while the SIE is processing the next transaction. Clearing the
 * TOKDNE bit in the ISTAT register causes the SIE to update STAT with the contents
 * of the next STAT value. If the data in the STAT holding register is valid, the
 * SIE immediately reasserts to TOKDNE interrupt.
 */
typedef union _hw_usb_stat
{
    uint8_t U;
    struct _hw_usb_stat_bitfields
    {
        uint8_t RESERVED0 : 2;         //!< [1:0]
        uint8_t ODD : 1;               //!< [2]
        uint8_t TX : 1;                //!< [3] Transmit Indicator
        uint8_t ENDP : 4;              //!< [7:4]
    } B;
} hw_usb_stat_t;
#endif

/*!
 * @name Constants and macros for entire USB_STAT register
 */
//@{
#define HW_USB_STAT_ADDR         (REGS_USB_BASE + 0x90U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_STAT              (*(__I hw_usb_stat_t *) HW_USB_STAT_ADDR)
#define HW_USB_STAT_RD()         (HW_USB_STAT.U)
#endif
//@}

/*
 * Constants & macros for individual USB_STAT bitfields
 */

/*!
 * @name Register USB_STAT, field ODD[2] (RO)
 *
 * This bit is set if the last buffer descriptor updated was in the odd bank of
 * the BDT.
 */
//@{
#define BP_USB_STAT_ODD      (2U)          //!< Bit position for USB_STAT_ODD.
#define BM_USB_STAT_ODD      (0x04U)       //!< Bit mask for USB_STAT_ODD.
#define BS_USB_STAT_ODD      (1U)          //!< Bit field size in bits for USB_STAT_ODD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_STAT_ODD field.
#define BR_USB_STAT_ODD      (BITBAND_ACCESS8(HW_USB_STAT_ADDR, BP_USB_STAT_ODD))
#endif
//@}

/*!
 * @name Register USB_STAT, field TX[3] (RO)
 *
 * Values:
 * - 0 - The most recent transaction was a receive operation.
 * - 1 - The most recent transaction was a transmit operation.
 */
//@{
#define BP_USB_STAT_TX       (3U)          //!< Bit position for USB_STAT_TX.
#define BM_USB_STAT_TX       (0x08U)       //!< Bit mask for USB_STAT_TX.
#define BS_USB_STAT_TX       (1U)          //!< Bit field size in bits for USB_STAT_TX.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_STAT_TX field.
#define BR_USB_STAT_TX       (BITBAND_ACCESS8(HW_USB_STAT_ADDR, BP_USB_STAT_TX))
#endif
//@}

/*!
 * @name Register USB_STAT, field ENDP[7:4] (RO)
 *
 * This four-bit field encodes the endpoint address that received or transmitted
 * the previous token. This allows the processor core to determine the BDT entry
 * that was updated by the last USB transaction.
 */
//@{
#define BP_USB_STAT_ENDP     (4U)          //!< Bit position for USB_STAT_ENDP.
#define BM_USB_STAT_ENDP     (0xF0U)       //!< Bit mask for USB_STAT_ENDP.
#define BS_USB_STAT_ENDP     (4U)          //!< Bit field size in bits for USB_STAT_ENDP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_STAT_ENDP field.
#define BR_USB_STAT_ENDP     (HW_USB_STAT.B.ENDP)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_CTL - Control register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_CTL - Control register (RW)
 *
 * Reset value: 0x00U
 *
 * Provides various control and configuration information for the USB module.
 */
typedef union _hw_usb_ctl
{
    uint8_t U;
    struct _hw_usb_ctl_bitfields
    {
        uint8_t USBENSOFEN : 1;        //!< [0] USB Enable
        uint8_t ODDRST : 1;            //!< [1]
        uint8_t RESUME : 1;            //!< [2]
        uint8_t HOSTMODEEN : 1;        //!< [3]
        uint8_t RESET : 1;             //!< [4]
        uint8_t TXSUSPENDTOKENBUSY : 1; //!< [5]
        uint8_t SE0 : 1;               //!< [6] Live USB Single Ended Zero signal
        uint8_t JSTATE : 1;            //!< [7] Live USB differential receiver JSTATE
                                       //! signal
    } B;
} hw_usb_ctl_t;
#endif

/*!
 * @name Constants and macros for entire USB_CTL register
 */
//@{
#define HW_USB_CTL_ADDR          (REGS_USB_BASE + 0x94U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_CTL               (*(__IO hw_usb_ctl_t *) HW_USB_CTL_ADDR)
#define HW_USB_CTL_RD()          (HW_USB_CTL.U)
#define HW_USB_CTL_WR(v)         (HW_USB_CTL.U = (v))
#define HW_USB_CTL_SET(v)        (HW_USB_CTL_WR(HW_USB_CTL_RD() |  (v)))
#define HW_USB_CTL_CLR(v)        (HW_USB_CTL_WR(HW_USB_CTL_RD() & ~(v)))
#define HW_USB_CTL_TOG(v)        (HW_USB_CTL_WR(HW_USB_CTL_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_CTL bitfields
 */

/*!
 * @name Register USB_CTL, field USBENSOFEN[0] (RW)
 *
 * Setting this bit enables the USB-FS to operate; clearing it disables the
 * USB-FS. Setting the bit causes the SIE to reset all of its ODD bits to the BDTs.
 * Therefore, setting this bit resets much of the logic in the SIE. When host mode
 * is enabled, clearing this bit causes the SIE to stop sending SOF tokens.
 *
 * Values:
 * - 0 - Disables the USB Module.
 * - 1 - Enables the USB Module.
 */
//@{
#define BP_USB_CTL_USBENSOFEN (0U)         //!< Bit position for USB_CTL_USBENSOFEN.
#define BM_USB_CTL_USBENSOFEN (0x01U)      //!< Bit mask for USB_CTL_USBENSOFEN.
#define BS_USB_CTL_USBENSOFEN (1U)         //!< Bit field size in bits for USB_CTL_USBENSOFEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_CTL_USBENSOFEN field.
#define BR_USB_CTL_USBENSOFEN (BITBAND_ACCESS8(HW_USB_CTL_ADDR, BP_USB_CTL_USBENSOFEN))
#endif

//! @brief Format value for bitfield USB_CTL_USBENSOFEN.
#define BF_USB_CTL_USBENSOFEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_CTL_USBENSOFEN), uint8_t) & BM_USB_CTL_USBENSOFEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the USBENSOFEN field to a new value.
#define BW_USB_CTL_USBENSOFEN(v) (BITBAND_ACCESS8(HW_USB_CTL_ADDR, BP_USB_CTL_USBENSOFEN) = (v))
#endif
//@}

/*!
 * @name Register USB_CTL, field ODDRST[1] (RW)
 *
 * Setting this bit to 1 resets all the BDT ODD ping/pong fields to 0, which
 * then specifies the EVEN BDT bank.
 */
//@{
#define BP_USB_CTL_ODDRST    (1U)          //!< Bit position for USB_CTL_ODDRST.
#define BM_USB_CTL_ODDRST    (0x02U)       //!< Bit mask for USB_CTL_ODDRST.
#define BS_USB_CTL_ODDRST    (1U)          //!< Bit field size in bits for USB_CTL_ODDRST.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_CTL_ODDRST field.
#define BR_USB_CTL_ODDRST    (BITBAND_ACCESS8(HW_USB_CTL_ADDR, BP_USB_CTL_ODDRST))
#endif

//! @brief Format value for bitfield USB_CTL_ODDRST.
#define BF_USB_CTL_ODDRST(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_CTL_ODDRST), uint8_t) & BM_USB_CTL_ODDRST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ODDRST field to a new value.
#define BW_USB_CTL_ODDRST(v) (BITBAND_ACCESS8(HW_USB_CTL_ADDR, BP_USB_CTL_ODDRST) = (v))
#endif
//@}

/*!
 * @name Register USB_CTL, field RESUME[2] (RW)
 *
 * When set to 1 this bit enables the USB Module to execute resume signaling.
 * This allows the USB Module to perform remote wake-up. Software must set RESUME
 * to 1 for the required amount of time and then clear it to 0. If the HOSTMODEEN
 * bit is set, the USB module appends a Low Speed End of Packet to the Resume
 * signaling when the RESUME bit is cleared. For more information on RESUME
 * signaling see Section 7.1.4.5 of the USB specification version 1.0.
 */
//@{
#define BP_USB_CTL_RESUME    (2U)          //!< Bit position for USB_CTL_RESUME.
#define BM_USB_CTL_RESUME    (0x04U)       //!< Bit mask for USB_CTL_RESUME.
#define BS_USB_CTL_RESUME    (1U)          //!< Bit field size in bits for USB_CTL_RESUME.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_CTL_RESUME field.
#define BR_USB_CTL_RESUME    (BITBAND_ACCESS8(HW_USB_CTL_ADDR, BP_USB_CTL_RESUME))
#endif

//! @brief Format value for bitfield USB_CTL_RESUME.
#define BF_USB_CTL_RESUME(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_CTL_RESUME), uint8_t) & BM_USB_CTL_RESUME)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RESUME field to a new value.
#define BW_USB_CTL_RESUME(v) (BITBAND_ACCESS8(HW_USB_CTL_ADDR, BP_USB_CTL_RESUME) = (v))
#endif
//@}

/*!
 * @name Register USB_CTL, field HOSTMODEEN[3] (RW)
 *
 * When set to 1, this bit enables the USB Module to operate in Host mode. In
 * host mode, the USB module performs USB transactions under the programmed control
 * of the host processor.
 */
//@{
#define BP_USB_CTL_HOSTMODEEN (3U)         //!< Bit position for USB_CTL_HOSTMODEEN.
#define BM_USB_CTL_HOSTMODEEN (0x08U)      //!< Bit mask for USB_CTL_HOSTMODEEN.
#define BS_USB_CTL_HOSTMODEEN (1U)         //!< Bit field size in bits for USB_CTL_HOSTMODEEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_CTL_HOSTMODEEN field.
#define BR_USB_CTL_HOSTMODEEN (BITBAND_ACCESS8(HW_USB_CTL_ADDR, BP_USB_CTL_HOSTMODEEN))
#endif

//! @brief Format value for bitfield USB_CTL_HOSTMODEEN.
#define BF_USB_CTL_HOSTMODEEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_CTL_HOSTMODEEN), uint8_t) & BM_USB_CTL_HOSTMODEEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HOSTMODEEN field to a new value.
#define BW_USB_CTL_HOSTMODEEN(v) (BITBAND_ACCESS8(HW_USB_CTL_ADDR, BP_USB_CTL_HOSTMODEEN) = (v))
#endif
//@}

/*!
 * @name Register USB_CTL, field RESET[4] (RW)
 *
 * Setting this bit enables the USB Module to generate USB reset signaling. This
 * allows the USB Module to reset USB peripherals. This control signal is only
 * valid in Host mode (HOSTMODEEN=1). Software must set RESET to 1 for the
 * required amount of time and then clear it to 0 to end reset signaling. For more
 * information on reset signaling see Section 7.1.4.3 of the USB specification version
 * 1.0.
 */
//@{
#define BP_USB_CTL_RESET     (4U)          //!< Bit position for USB_CTL_RESET.
#define BM_USB_CTL_RESET     (0x10U)       //!< Bit mask for USB_CTL_RESET.
#define BS_USB_CTL_RESET     (1U)          //!< Bit field size in bits for USB_CTL_RESET.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_CTL_RESET field.
#define BR_USB_CTL_RESET     (BITBAND_ACCESS8(HW_USB_CTL_ADDR, BP_USB_CTL_RESET))
#endif

//! @brief Format value for bitfield USB_CTL_RESET.
#define BF_USB_CTL_RESET(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_CTL_RESET), uint8_t) & BM_USB_CTL_RESET)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RESET field to a new value.
#define BW_USB_CTL_RESET(v)  (BITBAND_ACCESS8(HW_USB_CTL_ADDR, BP_USB_CTL_RESET) = (v))
#endif
//@}

/*!
 * @name Register USB_CTL, field TXSUSPENDTOKENBUSY[5] (RW)
 *
 * In Host mode, TOKEN_BUSY is set when the USB module is busy executing a USB
 * token. Software must not write more token commands to the Token Register when
 * TOKEN_BUSY is set. Software should check this field before writing any tokens
 * to the Token Register to ensure that token commands are not lost. In Target
 * mode, TXD_SUSPEND is set when the SIE has disabled packet transmission and
 * reception. Clearing this bit allows the SIE to continue token processing. This bit
 * is set by the SIE when a SETUP Token is received allowing software to dequeue
 * any pending packet transactions in the BDT before resuming token processing.
 */
//@{
#define BP_USB_CTL_TXSUSPENDTOKENBUSY (5U) //!< Bit position for USB_CTL_TXSUSPENDTOKENBUSY.
#define BM_USB_CTL_TXSUSPENDTOKENBUSY (0x20U) //!< Bit mask for USB_CTL_TXSUSPENDTOKENBUSY.
#define BS_USB_CTL_TXSUSPENDTOKENBUSY (1U) //!< Bit field size in bits for USB_CTL_TXSUSPENDTOKENBUSY.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_CTL_TXSUSPENDTOKENBUSY field.
#define BR_USB_CTL_TXSUSPENDTOKENBUSY (BITBAND_ACCESS8(HW_USB_CTL_ADDR, BP_USB_CTL_TXSUSPENDTOKENBUSY))
#endif

//! @brief Format value for bitfield USB_CTL_TXSUSPENDTOKENBUSY.
#define BF_USB_CTL_TXSUSPENDTOKENBUSY(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_CTL_TXSUSPENDTOKENBUSY), uint8_t) & BM_USB_CTL_TXSUSPENDTOKENBUSY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TXSUSPENDTOKENBUSY field to a new value.
#define BW_USB_CTL_TXSUSPENDTOKENBUSY(v) (BITBAND_ACCESS8(HW_USB_CTL_ADDR, BP_USB_CTL_TXSUSPENDTOKENBUSY) = (v))
#endif
//@}

/*!
 * @name Register USB_CTL, field SE0[6] (RW)
 */
//@{
#define BP_USB_CTL_SE0       (6U)          //!< Bit position for USB_CTL_SE0.
#define BM_USB_CTL_SE0       (0x40U)       //!< Bit mask for USB_CTL_SE0.
#define BS_USB_CTL_SE0       (1U)          //!< Bit field size in bits for USB_CTL_SE0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_CTL_SE0 field.
#define BR_USB_CTL_SE0       (BITBAND_ACCESS8(HW_USB_CTL_ADDR, BP_USB_CTL_SE0))
#endif

//! @brief Format value for bitfield USB_CTL_SE0.
#define BF_USB_CTL_SE0(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_CTL_SE0), uint8_t) & BM_USB_CTL_SE0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SE0 field to a new value.
#define BW_USB_CTL_SE0(v)    (BITBAND_ACCESS8(HW_USB_CTL_ADDR, BP_USB_CTL_SE0) = (v))
#endif
//@}

/*!
 * @name Register USB_CTL, field JSTATE[7] (RW)
 *
 * The polarity of this signal is affected by the current state of LSEN .
 */
//@{
#define BP_USB_CTL_JSTATE    (7U)          //!< Bit position for USB_CTL_JSTATE.
#define BM_USB_CTL_JSTATE    (0x80U)       //!< Bit mask for USB_CTL_JSTATE.
#define BS_USB_CTL_JSTATE    (1U)          //!< Bit field size in bits for USB_CTL_JSTATE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_CTL_JSTATE field.
#define BR_USB_CTL_JSTATE    (BITBAND_ACCESS8(HW_USB_CTL_ADDR, BP_USB_CTL_JSTATE))
#endif

//! @brief Format value for bitfield USB_CTL_JSTATE.
#define BF_USB_CTL_JSTATE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_CTL_JSTATE), uint8_t) & BM_USB_CTL_JSTATE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the JSTATE field to a new value.
#define BW_USB_CTL_JSTATE(v) (BITBAND_ACCESS8(HW_USB_CTL_ADDR, BP_USB_CTL_JSTATE) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_ADDR - Address register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_ADDR - Address register (RW)
 *
 * Reset value: 0x00U
 *
 * Holds the unique USB address that the USB module decodes when in Peripheral
 * mode (HOSTMODEEN=0). When operating in Host mode (HOSTMODEEN=1) the USB module
 * transmits this address with a TOKEN packet. This enables the USB module to
 * uniquely address any USB peripheral. In either mode, CTL[USBENSOFEN] must be 1.
 * The Address register is reset to 0x00 after the reset input becomes active or
 * the USB module decodes a USB reset signal. This action initializes the Address
 * register to decode address 0x00 as required by the USB specification.
 */
typedef union _hw_usb_addr
{
    uint8_t U;
    struct _hw_usb_addr_bitfields
    {
        uint8_t ADDR : 7;              //!< [6:0] USB Address
        uint8_t LSEN : 1;              //!< [7] Low Speed Enable bit
    } B;
} hw_usb_addr_t;
#endif

/*!
 * @name Constants and macros for entire USB_ADDR register
 */
//@{
#define HW_USB_ADDR_ADDR         (REGS_USB_BASE + 0x98U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_ADDR              (*(__IO hw_usb_addr_t *) HW_USB_ADDR_ADDR)
#define HW_USB_ADDR_RD()         (HW_USB_ADDR.U)
#define HW_USB_ADDR_WR(v)        (HW_USB_ADDR.U = (v))
#define HW_USB_ADDR_SET(v)       (HW_USB_ADDR_WR(HW_USB_ADDR_RD() |  (v)))
#define HW_USB_ADDR_CLR(v)       (HW_USB_ADDR_WR(HW_USB_ADDR_RD() & ~(v)))
#define HW_USB_ADDR_TOG(v)       (HW_USB_ADDR_WR(HW_USB_ADDR_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_ADDR bitfields
 */

/*!
 * @name Register USB_ADDR, field ADDR[6:0] (RW)
 *
 * Defines the USB address that the USB module decodes in peripheral mode, or
 * transmits when in host mode.
 */
//@{
#define BP_USB_ADDR_ADDR     (0U)          //!< Bit position for USB_ADDR_ADDR.
#define BM_USB_ADDR_ADDR     (0x7FU)       //!< Bit mask for USB_ADDR_ADDR.
#define BS_USB_ADDR_ADDR     (7U)          //!< Bit field size in bits for USB_ADDR_ADDR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ADDR_ADDR field.
#define BR_USB_ADDR_ADDR     (HW_USB_ADDR.B.ADDR)
#endif

//! @brief Format value for bitfield USB_ADDR_ADDR.
#define BF_USB_ADDR_ADDR(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ADDR_ADDR), uint8_t) & BM_USB_ADDR_ADDR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADDR field to a new value.
#define BW_USB_ADDR_ADDR(v)  (HW_USB_ADDR_WR((HW_USB_ADDR_RD() & ~BM_USB_ADDR_ADDR) | BF_USB_ADDR_ADDR(v)))
#endif
//@}

/*!
 * @name Register USB_ADDR, field LSEN[7] (RW)
 *
 * Informs the USB module that the next token command written to the token
 * register must be performed at low speed. This enables the USB module to perform the
 * necessary preamble required for low-speed data transmissions.
 */
//@{
#define BP_USB_ADDR_LSEN     (7U)          //!< Bit position for USB_ADDR_LSEN.
#define BM_USB_ADDR_LSEN     (0x80U)       //!< Bit mask for USB_ADDR_LSEN.
#define BS_USB_ADDR_LSEN     (1U)          //!< Bit field size in bits for USB_ADDR_LSEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ADDR_LSEN field.
#define BR_USB_ADDR_LSEN     (BITBAND_ACCESS8(HW_USB_ADDR_ADDR, BP_USB_ADDR_LSEN))
#endif

//! @brief Format value for bitfield USB_ADDR_LSEN.
#define BF_USB_ADDR_LSEN(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ADDR_LSEN), uint8_t) & BM_USB_ADDR_LSEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LSEN field to a new value.
#define BW_USB_ADDR_LSEN(v)  (BITBAND_ACCESS8(HW_USB_ADDR_ADDR, BP_USB_ADDR_LSEN) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_BDTPAGE1 - BDT Page register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_BDTPAGE1 - BDT Page register 1 (RW)
 *
 * Reset value: 0x00U
 *
 * Provides address bits 15 through 9 of the base address where the current
 * Buffer Descriptor Table (BDT) resides in system memory. See Buffer Descriptor
 * Table. The 32-bit BDT Base Address is always aligned on 512-byte boundaries, so
 * bits 8 through 0 of the base address are always zero.
 */
typedef union _hw_usb_bdtpage1
{
    uint8_t U;
    struct _hw_usb_bdtpage1_bitfields
    {
        uint8_t RESERVED0 : 1;         //!< [0]
        uint8_t BDTBA : 7;             //!< [7:1]
    } B;
} hw_usb_bdtpage1_t;
#endif

/*!
 * @name Constants and macros for entire USB_BDTPAGE1 register
 */
//@{
#define HW_USB_BDTPAGE1_ADDR     (REGS_USB_BASE + 0x9CU)

#ifndef __LANGUAGE_ASM__
#define HW_USB_BDTPAGE1          (*(__IO hw_usb_bdtpage1_t *) HW_USB_BDTPAGE1_ADDR)
#define HW_USB_BDTPAGE1_RD()     (HW_USB_BDTPAGE1.U)
#define HW_USB_BDTPAGE1_WR(v)    (HW_USB_BDTPAGE1.U = (v))
#define HW_USB_BDTPAGE1_SET(v)   (HW_USB_BDTPAGE1_WR(HW_USB_BDTPAGE1_RD() |  (v)))
#define HW_USB_BDTPAGE1_CLR(v)   (HW_USB_BDTPAGE1_WR(HW_USB_BDTPAGE1_RD() & ~(v)))
#define HW_USB_BDTPAGE1_TOG(v)   (HW_USB_BDTPAGE1_WR(HW_USB_BDTPAGE1_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_BDTPAGE1 bitfields
 */

/*!
 * @name Register USB_BDTPAGE1, field BDTBA[7:1] (RW)
 *
 * Provides address bits 15 through 9 of the BDT base address.
 */
//@{
#define BP_USB_BDTPAGE1_BDTBA (1U)         //!< Bit position for USB_BDTPAGE1_BDTBA.
#define BM_USB_BDTPAGE1_BDTBA (0xFEU)      //!< Bit mask for USB_BDTPAGE1_BDTBA.
#define BS_USB_BDTPAGE1_BDTBA (7U)         //!< Bit field size in bits for USB_BDTPAGE1_BDTBA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_BDTPAGE1_BDTBA field.
#define BR_USB_BDTPAGE1_BDTBA (HW_USB_BDTPAGE1.B.BDTBA)
#endif

//! @brief Format value for bitfield USB_BDTPAGE1_BDTBA.
#define BF_USB_BDTPAGE1_BDTBA(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_BDTPAGE1_BDTBA), uint8_t) & BM_USB_BDTPAGE1_BDTBA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BDTBA field to a new value.
#define BW_USB_BDTPAGE1_BDTBA(v) (HW_USB_BDTPAGE1_WR((HW_USB_BDTPAGE1_RD() & ~BM_USB_BDTPAGE1_BDTBA) | BF_USB_BDTPAGE1_BDTBA(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_FRMNUML - Frame Number register Low
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_FRMNUML - Frame Number register Low (RW)
 *
 * Reset value: 0x00U
 *
 * The Frame Number registers (low and high) contain the 11-bit frame number.
 * These registers are updated with the current frame number whenever a SOF TOKEN
 * is received.
 */
typedef union _hw_usb_frmnuml
{
    uint8_t U;
    struct _hw_usb_frmnuml_bitfields
    {
        uint8_t FRM : 8;               //!< [7:0]
    } B;
} hw_usb_frmnuml_t;
#endif

/*!
 * @name Constants and macros for entire USB_FRMNUML register
 */
//@{
#define HW_USB_FRMNUML_ADDR      (REGS_USB_BASE + 0xA0U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_FRMNUML           (*(__IO hw_usb_frmnuml_t *) HW_USB_FRMNUML_ADDR)
#define HW_USB_FRMNUML_RD()      (HW_USB_FRMNUML.U)
#define HW_USB_FRMNUML_WR(v)     (HW_USB_FRMNUML.U = (v))
#define HW_USB_FRMNUML_SET(v)    (HW_USB_FRMNUML_WR(HW_USB_FRMNUML_RD() |  (v)))
#define HW_USB_FRMNUML_CLR(v)    (HW_USB_FRMNUML_WR(HW_USB_FRMNUML_RD() & ~(v)))
#define HW_USB_FRMNUML_TOG(v)    (HW_USB_FRMNUML_WR(HW_USB_FRMNUML_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_FRMNUML bitfields
 */

/*!
 * @name Register USB_FRMNUML, field FRM[7:0] (RW)
 *
 * This 8-bit field and the 3-bit field in the Frame Number Register High are
 * used to compute the address where the current Buffer Descriptor Table (BDT)
 * resides in system memory.
 */
//@{
#define BP_USB_FRMNUML_FRM   (0U)          //!< Bit position for USB_FRMNUML_FRM.
#define BM_USB_FRMNUML_FRM   (0xFFU)       //!< Bit mask for USB_FRMNUML_FRM.
#define BS_USB_FRMNUML_FRM   (8U)          //!< Bit field size in bits for USB_FRMNUML_FRM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_FRMNUML_FRM field.
#define BR_USB_FRMNUML_FRM   (HW_USB_FRMNUML.U)
#endif

//! @brief Format value for bitfield USB_FRMNUML_FRM.
#define BF_USB_FRMNUML_FRM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_FRMNUML_FRM), uint8_t) & BM_USB_FRMNUML_FRM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FRM field to a new value.
#define BW_USB_FRMNUML_FRM(v) (HW_USB_FRMNUML_WR(v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_FRMNUMH - Frame Number register High
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_FRMNUMH - Frame Number register High (RW)
 *
 * Reset value: 0x00U
 *
 * The Frame Number registers (low and high) contain the 11-bit frame number.
 * These registers are updated with the current frame number whenever a SOF TOKEN
 * is received.
 */
typedef union _hw_usb_frmnumh
{
    uint8_t U;
    struct _hw_usb_frmnumh_bitfields
    {
        uint8_t FRM : 3;               //!< [2:0]
        uint8_t RESERVED0 : 5;         //!< [7:3]
    } B;
} hw_usb_frmnumh_t;
#endif

/*!
 * @name Constants and macros for entire USB_FRMNUMH register
 */
//@{
#define HW_USB_FRMNUMH_ADDR      (REGS_USB_BASE + 0xA4U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_FRMNUMH           (*(__IO hw_usb_frmnumh_t *) HW_USB_FRMNUMH_ADDR)
#define HW_USB_FRMNUMH_RD()      (HW_USB_FRMNUMH.U)
#define HW_USB_FRMNUMH_WR(v)     (HW_USB_FRMNUMH.U = (v))
#define HW_USB_FRMNUMH_SET(v)    (HW_USB_FRMNUMH_WR(HW_USB_FRMNUMH_RD() |  (v)))
#define HW_USB_FRMNUMH_CLR(v)    (HW_USB_FRMNUMH_WR(HW_USB_FRMNUMH_RD() & ~(v)))
#define HW_USB_FRMNUMH_TOG(v)    (HW_USB_FRMNUMH_WR(HW_USB_FRMNUMH_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_FRMNUMH bitfields
 */

/*!
 * @name Register USB_FRMNUMH, field FRM[2:0] (RW)
 *
 * This 3-bit field and the 8-bit field in the Frame Number Register Low are
 * used to compute the address where the current Buffer Descriptor Table (BDT)
 * resides in system memory.
 */
//@{
#define BP_USB_FRMNUMH_FRM   (0U)          //!< Bit position for USB_FRMNUMH_FRM.
#define BM_USB_FRMNUMH_FRM   (0x07U)       //!< Bit mask for USB_FRMNUMH_FRM.
#define BS_USB_FRMNUMH_FRM   (3U)          //!< Bit field size in bits for USB_FRMNUMH_FRM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_FRMNUMH_FRM field.
#define BR_USB_FRMNUMH_FRM   (HW_USB_FRMNUMH.B.FRM)
#endif

//! @brief Format value for bitfield USB_FRMNUMH_FRM.
#define BF_USB_FRMNUMH_FRM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_FRMNUMH_FRM), uint8_t) & BM_USB_FRMNUMH_FRM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FRM field to a new value.
#define BW_USB_FRMNUMH_FRM(v) (HW_USB_FRMNUMH_WR((HW_USB_FRMNUMH_RD() & ~BM_USB_FRMNUMH_FRM) | BF_USB_FRMNUMH_FRM(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_TOKEN - Token register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_TOKEN - Token register (RW)
 *
 * Reset value: 0x00U
 *
 * Used to initiate USB transactions when in host mode (HOSTMODEEN=1). When the
 * software needs to execute a USB transaction to a peripheral, it writes the
 * TOKEN type and endpoint to this register. After this register has been written,
 * the USB module begins the specified USB transaction to the address contained in
 * the address register. The processor core must always check that the
 * TOKEN_BUSY bit in the control register is not 1 before writing to the Token Register.
 * This ensures that the token commands are not overwritten before they can be
 * executed. The address register and endpoint control register 0 are also used when
 * performing a token command and therefore must also be written before the
 * Token Register. The address register is used to select the USB peripheral address
 * transmitted by the token command. The endpoint control register determines the
 * handshake and retry policies used during the transfer.
 */
typedef union _hw_usb_token
{
    uint8_t U;
    struct _hw_usb_token_bitfields
    {
        uint8_t TOKENENDPT : 4;        //!< [3:0]
        uint8_t TOKENPID : 4;          //!< [7:4]
    } B;
} hw_usb_token_t;
#endif

/*!
 * @name Constants and macros for entire USB_TOKEN register
 */
//@{
#define HW_USB_TOKEN_ADDR        (REGS_USB_BASE + 0xA8U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_TOKEN             (*(__IO hw_usb_token_t *) HW_USB_TOKEN_ADDR)
#define HW_USB_TOKEN_RD()        (HW_USB_TOKEN.U)
#define HW_USB_TOKEN_WR(v)       (HW_USB_TOKEN.U = (v))
#define HW_USB_TOKEN_SET(v)      (HW_USB_TOKEN_WR(HW_USB_TOKEN_RD() |  (v)))
#define HW_USB_TOKEN_CLR(v)      (HW_USB_TOKEN_WR(HW_USB_TOKEN_RD() & ~(v)))
#define HW_USB_TOKEN_TOG(v)      (HW_USB_TOKEN_WR(HW_USB_TOKEN_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_TOKEN bitfields
 */

/*!
 * @name Register USB_TOKEN, field TOKENENDPT[3:0] (RW)
 *
 * Holds the Endpoint address for the token command. The four bit value written
 * must be a valid endpoint.
 */
//@{
#define BP_USB_TOKEN_TOKENENDPT (0U)       //!< Bit position for USB_TOKEN_TOKENENDPT.
#define BM_USB_TOKEN_TOKENENDPT (0x0FU)    //!< Bit mask for USB_TOKEN_TOKENENDPT.
#define BS_USB_TOKEN_TOKENENDPT (4U)       //!< Bit field size in bits for USB_TOKEN_TOKENENDPT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_TOKEN_TOKENENDPT field.
#define BR_USB_TOKEN_TOKENENDPT (HW_USB_TOKEN.B.TOKENENDPT)
#endif

//! @brief Format value for bitfield USB_TOKEN_TOKENENDPT.
#define BF_USB_TOKEN_TOKENENDPT(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_TOKEN_TOKENENDPT), uint8_t) & BM_USB_TOKEN_TOKENENDPT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TOKENENDPT field to a new value.
#define BW_USB_TOKEN_TOKENENDPT(v) (HW_USB_TOKEN_WR((HW_USB_TOKEN_RD() & ~BM_USB_TOKEN_TOKENENDPT) | BF_USB_TOKEN_TOKENENDPT(v)))
#endif
//@}

/*!
 * @name Register USB_TOKEN, field TOKENPID[7:4] (RW)
 *
 * Contains the token type executed by the USB module.
 *
 * Values:
 * - 0001 - OUT Token. USB Module performs an OUT (TX) transaction.
 * - 1001 - IN Token. USB Module performs an In (RX) transaction.
 * - 1101 - SETUP Token. USB Module performs a SETUP (TX) transaction
 */
//@{
#define BP_USB_TOKEN_TOKENPID (4U)         //!< Bit position for USB_TOKEN_TOKENPID.
#define BM_USB_TOKEN_TOKENPID (0xF0U)      //!< Bit mask for USB_TOKEN_TOKENPID.
#define BS_USB_TOKEN_TOKENPID (4U)         //!< Bit field size in bits for USB_TOKEN_TOKENPID.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_TOKEN_TOKENPID field.
#define BR_USB_TOKEN_TOKENPID (HW_USB_TOKEN.B.TOKENPID)
#endif

//! @brief Format value for bitfield USB_TOKEN_TOKENPID.
#define BF_USB_TOKEN_TOKENPID(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_TOKEN_TOKENPID), uint8_t) & BM_USB_TOKEN_TOKENPID)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TOKENPID field to a new value.
#define BW_USB_TOKEN_TOKENPID(v) (HW_USB_TOKEN_WR((HW_USB_TOKEN_RD() & ~BM_USB_TOKEN_TOKENPID) | BF_USB_TOKEN_TOKENPID(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_SOFTHLD - SOF Threshold register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_SOFTHLD - SOF Threshold register (RW)
 *
 * Reset value: 0x00U
 *
 * The SOF Threshold Register is used only in Host mode (HOSTMODEEN=1). When in
 * Host mode, the 14-bit SOF counter counts the interval between SOF frames. The
 * SOF must be transmitted every 1ms so therefore the SOF counter is loaded with
 * a value of 12000. When the SOF counter reaches zero, a Start Of Frame (SOF)
 * token is transmitted. The SOF threshold register is used to program the number
 * of USB byte times before the SOF to stop initiating token packet transactions.
 * This register must be set to a value that ensures that other packets are not
 * actively being transmitted when the SOF time counts to zero. When the SOF
 * counter reaches the threshold value, no more tokens are transmitted until after the
 * SOF has been transmitted. The value programmed into the threshold register
 * must reserve enough time to ensure the worst case transaction completes. In
 * general the worst case transaction is an IN token followed by a data packet from
 * the target followed by the response from the host. The actual time required is
 * a function of the maximum packet size on the bus. Typical values for the SOF
 * threshold are: 64-byte packets=74; 32-byte packets=42; 16-byte packets=26;
 * 8-byte packets=18.
 */
typedef union _hw_usb_softhld
{
    uint8_t U;
    struct _hw_usb_softhld_bitfields
    {
        uint8_t CNT : 8;               //!< [7:0]
    } B;
} hw_usb_softhld_t;
#endif

/*!
 * @name Constants and macros for entire USB_SOFTHLD register
 */
//@{
#define HW_USB_SOFTHLD_ADDR      (REGS_USB_BASE + 0xACU)

#ifndef __LANGUAGE_ASM__
#define HW_USB_SOFTHLD           (*(__IO hw_usb_softhld_t *) HW_USB_SOFTHLD_ADDR)
#define HW_USB_SOFTHLD_RD()      (HW_USB_SOFTHLD.U)
#define HW_USB_SOFTHLD_WR(v)     (HW_USB_SOFTHLD.U = (v))
#define HW_USB_SOFTHLD_SET(v)    (HW_USB_SOFTHLD_WR(HW_USB_SOFTHLD_RD() |  (v)))
#define HW_USB_SOFTHLD_CLR(v)    (HW_USB_SOFTHLD_WR(HW_USB_SOFTHLD_RD() & ~(v)))
#define HW_USB_SOFTHLD_TOG(v)    (HW_USB_SOFTHLD_WR(HW_USB_SOFTHLD_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_SOFTHLD bitfields
 */

/*!
 * @name Register USB_SOFTHLD, field CNT[7:0] (RW)
 *
 * Represents the SOF count threshold in byte times.
 */
//@{
#define BP_USB_SOFTHLD_CNT   (0U)          //!< Bit position for USB_SOFTHLD_CNT.
#define BM_USB_SOFTHLD_CNT   (0xFFU)       //!< Bit mask for USB_SOFTHLD_CNT.
#define BS_USB_SOFTHLD_CNT   (8U)          //!< Bit field size in bits for USB_SOFTHLD_CNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_SOFTHLD_CNT field.
#define BR_USB_SOFTHLD_CNT   (HW_USB_SOFTHLD.U)
#endif

//! @brief Format value for bitfield USB_SOFTHLD_CNT.
#define BF_USB_SOFTHLD_CNT(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_SOFTHLD_CNT), uint8_t) & BM_USB_SOFTHLD_CNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CNT field to a new value.
#define BW_USB_SOFTHLD_CNT(v) (HW_USB_SOFTHLD_WR(v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_BDTPAGE2 - BDT Page Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_BDTPAGE2 - BDT Page Register 2 (RW)
 *
 * Reset value: 0x00U
 *
 * Contains an 8-bit value used to compute the address where the current Buffer
 * Descriptor Table (BDT) resides in system memory. See Buffer Descriptor Table.
 */
typedef union _hw_usb_bdtpage2
{
    uint8_t U;
    struct _hw_usb_bdtpage2_bitfields
    {
        uint8_t BDTBA : 8;             //!< [7:0]
    } B;
} hw_usb_bdtpage2_t;
#endif

/*!
 * @name Constants and macros for entire USB_BDTPAGE2 register
 */
//@{
#define HW_USB_BDTPAGE2_ADDR     (REGS_USB_BASE + 0xB0U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_BDTPAGE2          (*(__IO hw_usb_bdtpage2_t *) HW_USB_BDTPAGE2_ADDR)
#define HW_USB_BDTPAGE2_RD()     (HW_USB_BDTPAGE2.U)
#define HW_USB_BDTPAGE2_WR(v)    (HW_USB_BDTPAGE2.U = (v))
#define HW_USB_BDTPAGE2_SET(v)   (HW_USB_BDTPAGE2_WR(HW_USB_BDTPAGE2_RD() |  (v)))
#define HW_USB_BDTPAGE2_CLR(v)   (HW_USB_BDTPAGE2_WR(HW_USB_BDTPAGE2_RD() & ~(v)))
#define HW_USB_BDTPAGE2_TOG(v)   (HW_USB_BDTPAGE2_WR(HW_USB_BDTPAGE2_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_BDTPAGE2 bitfields
 */

/*!
 * @name Register USB_BDTPAGE2, field BDTBA[7:0] (RW)
 *
 * Provides address bits 23 through 16 of the BDT base address that defines the
 * location of Buffer Descriptor Table resides in system memory.
 */
//@{
#define BP_USB_BDTPAGE2_BDTBA (0U)         //!< Bit position for USB_BDTPAGE2_BDTBA.
#define BM_USB_BDTPAGE2_BDTBA (0xFFU)      //!< Bit mask for USB_BDTPAGE2_BDTBA.
#define BS_USB_BDTPAGE2_BDTBA (8U)         //!< Bit field size in bits for USB_BDTPAGE2_BDTBA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_BDTPAGE2_BDTBA field.
#define BR_USB_BDTPAGE2_BDTBA (HW_USB_BDTPAGE2.U)
#endif

//! @brief Format value for bitfield USB_BDTPAGE2_BDTBA.
#define BF_USB_BDTPAGE2_BDTBA(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_BDTPAGE2_BDTBA), uint8_t) & BM_USB_BDTPAGE2_BDTBA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BDTBA field to a new value.
#define BW_USB_BDTPAGE2_BDTBA(v) (HW_USB_BDTPAGE2_WR(v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_BDTPAGE3 - BDT Page Register 3
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_BDTPAGE3 - BDT Page Register 3 (RW)
 *
 * Reset value: 0x00U
 *
 * Contains an 8-bit value used to compute the address where the current Buffer
 * Descriptor Table (BDT) resides in system memory. See Buffer Descriptor Table.
 */
typedef union _hw_usb_bdtpage3
{
    uint8_t U;
    struct _hw_usb_bdtpage3_bitfields
    {
        uint8_t BDTBA : 8;             //!< [7:0]
    } B;
} hw_usb_bdtpage3_t;
#endif

/*!
 * @name Constants and macros for entire USB_BDTPAGE3 register
 */
//@{
#define HW_USB_BDTPAGE3_ADDR     (REGS_USB_BASE + 0xB4U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_BDTPAGE3          (*(__IO hw_usb_bdtpage3_t *) HW_USB_BDTPAGE3_ADDR)
#define HW_USB_BDTPAGE3_RD()     (HW_USB_BDTPAGE3.U)
#define HW_USB_BDTPAGE3_WR(v)    (HW_USB_BDTPAGE3.U = (v))
#define HW_USB_BDTPAGE3_SET(v)   (HW_USB_BDTPAGE3_WR(HW_USB_BDTPAGE3_RD() |  (v)))
#define HW_USB_BDTPAGE3_CLR(v)   (HW_USB_BDTPAGE3_WR(HW_USB_BDTPAGE3_RD() & ~(v)))
#define HW_USB_BDTPAGE3_TOG(v)   (HW_USB_BDTPAGE3_WR(HW_USB_BDTPAGE3_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_BDTPAGE3 bitfields
 */

/*!
 * @name Register USB_BDTPAGE3, field BDTBA[7:0] (RW)
 *
 * Provides address bits 31 through 24 of the BDT base address that defines the
 * location of Buffer Descriptor Table resides in system memory.
 */
//@{
#define BP_USB_BDTPAGE3_BDTBA (0U)         //!< Bit position for USB_BDTPAGE3_BDTBA.
#define BM_USB_BDTPAGE3_BDTBA (0xFFU)      //!< Bit mask for USB_BDTPAGE3_BDTBA.
#define BS_USB_BDTPAGE3_BDTBA (8U)         //!< Bit field size in bits for USB_BDTPAGE3_BDTBA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_BDTPAGE3_BDTBA field.
#define BR_USB_BDTPAGE3_BDTBA (HW_USB_BDTPAGE3.U)
#endif

//! @brief Format value for bitfield USB_BDTPAGE3_BDTBA.
#define BF_USB_BDTPAGE3_BDTBA(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_BDTPAGE3_BDTBA), uint8_t) & BM_USB_BDTPAGE3_BDTBA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BDTBA field to a new value.
#define BW_USB_BDTPAGE3_BDTBA(v) (HW_USB_BDTPAGE3_WR(v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_ENDPTn - Endpoint Control register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_ENDPTn - Endpoint Control register (RW)
 *
 * Reset value: 0x00U
 *
 * Contains the endpoint control bits for each of the 16 endpoints available
 * within the USB module for a decoded address. The format for these registers is
 * shown in the following figure. Endpoint 0 (ENDPT0) is associated with control
 * pipe 0, which is required for all USB functions. Therefore, after a USBRST
 * interrupt occurs the processor core should set ENDPT0 to contain 0x0D. In Host mode
 * ENDPT0 is used to determine the handshake, retry and low speed
 * characteristics of the host transfer. For Control, Bulk and Interrupt transfers, the EPHSHK
 * bit should be 1. For Isochronous transfers it should be 0. Common values to
 * use for ENDPT0 in host mode are 0x4D for Control, Bulk, and Interrupt transfers,
 * and 0x4C for Isochronous transfers. The three bits EPCTLDIS, EPRXEN, and
 * EPTXEN define if an endpoint is enabled and define the direction of the endpoint.
 * The endpoint enable/direction control is defined in the following table.
 * Endpoint enable and direction control EPCTLDIS EPRXEN EPTXEN Endpoint
 * enable/direction control X 0 0 Disable endpoint X 0 1 Enable endpoint for Tx transfers only
 * X 1 0 Enable endpoint for Rx transfers only 1 1 1 Enable endpoint for Rx and
 * Tx transfers 0 1 1 Enable Endpoint for RX and TX as well as control (SETUP)
 * transfers.
 */
typedef union _hw_usb_endptn
{
    uint8_t U;
    struct _hw_usb_endptn_bitfields
    {
        uint8_t EPHSHK : 1;            //!< [0]
        uint8_t EPSTALL : 1;           //!< [1]
        uint8_t EPTXEN : 1;            //!< [2]
        uint8_t EPRXEN : 1;            //!< [3]
        uint8_t EPCTLDIS : 1;          //!< [4]
        uint8_t RESERVED0 : 1;         //!< [5]
        uint8_t RETRYDIS : 1;          //!< [6]
        uint8_t HOSTWOHUB : 1;         //!< [7]
    } B;
} hw_usb_endptn_t;
#endif

/*!
 * @name Constants and macros for entire USB_ENDPTn register
 */
//@{
#define HW_USB_ENDPTn_COUNT (16U)

#define HW_USB_ENDPTn_ADDR(n)    (REGS_USB_BASE + 0xC0U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_USB_ENDPTn(n)         (*(__IO hw_usb_endptn_t *) HW_USB_ENDPTn_ADDR(n))
#define HW_USB_ENDPTn_RD(n)      (HW_USB_ENDPTn(n).U)
#define HW_USB_ENDPTn_WR(n, v)   (HW_USB_ENDPTn(n).U = (v))
#define HW_USB_ENDPTn_SET(n, v)  (HW_USB_ENDPTn_WR(n, HW_USB_ENDPTn_RD(n) |  (v)))
#define HW_USB_ENDPTn_CLR(n, v)  (HW_USB_ENDPTn_WR(n, HW_USB_ENDPTn_RD(n) & ~(v)))
#define HW_USB_ENDPTn_TOG(n, v)  (HW_USB_ENDPTn_WR(n, HW_USB_ENDPTn_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_ENDPTn bitfields
 */

/*!
 * @name Register USB_ENDPTn, field EPHSHK[0] (RW)
 *
 * When set this bit enables an endpoint to perform handshaking during a
 * transaction to this endpoint. This bit is generally 1 unless the endpoint is
 * Isochronous.
 */
//@{
#define BP_USB_ENDPTn_EPHSHK (0U)          //!< Bit position for USB_ENDPTn_EPHSHK.
#define BM_USB_ENDPTn_EPHSHK (0x01U)       //!< Bit mask for USB_ENDPTn_EPHSHK.
#define BS_USB_ENDPTn_EPHSHK (1U)          //!< Bit field size in bits for USB_ENDPTn_EPHSHK.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ENDPTn_EPHSHK field.
#define BR_USB_ENDPTn_EPHSHK(n) (BITBAND_ACCESS8(HW_USB_ENDPTn_ADDR(n), BP_USB_ENDPTn_EPHSHK))
#endif

//! @brief Format value for bitfield USB_ENDPTn_EPHSHK.
#define BF_USB_ENDPTn_EPHSHK(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ENDPTn_EPHSHK), uint8_t) & BM_USB_ENDPTn_EPHSHK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EPHSHK field to a new value.
#define BW_USB_ENDPTn_EPHSHK(n, v) (BITBAND_ACCESS8(HW_USB_ENDPTn_ADDR(n), BP_USB_ENDPTn_EPHSHK) = (v))
#endif
//@}

/*!
 * @name Register USB_ENDPTn, field EPSTALL[1] (RW)
 *
 * When set this bit indicates that the endpoint is called. This bit has
 * priority over all other control bits in the EndPoint Enable Register, but it is only
 * valid if EPTXEN=1 or EPRXEN=1. Any access to this endpoint causes the USB
 * Module to return a STALL handshake. After an endpoint is stalled it requires
 * intervention from the Host Controller.
 */
//@{
#define BP_USB_ENDPTn_EPSTALL (1U)         //!< Bit position for USB_ENDPTn_EPSTALL.
#define BM_USB_ENDPTn_EPSTALL (0x02U)      //!< Bit mask for USB_ENDPTn_EPSTALL.
#define BS_USB_ENDPTn_EPSTALL (1U)         //!< Bit field size in bits for USB_ENDPTn_EPSTALL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ENDPTn_EPSTALL field.
#define BR_USB_ENDPTn_EPSTALL(n) (BITBAND_ACCESS8(HW_USB_ENDPTn_ADDR(n), BP_USB_ENDPTn_EPSTALL))
#endif

//! @brief Format value for bitfield USB_ENDPTn_EPSTALL.
#define BF_USB_ENDPTn_EPSTALL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ENDPTn_EPSTALL), uint8_t) & BM_USB_ENDPTn_EPSTALL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EPSTALL field to a new value.
#define BW_USB_ENDPTn_EPSTALL(n, v) (BITBAND_ACCESS8(HW_USB_ENDPTn_ADDR(n), BP_USB_ENDPTn_EPSTALL) = (v))
#endif
//@}

/*!
 * @name Register USB_ENDPTn, field EPTXEN[2] (RW)
 *
 * This bit, when set, enables the endpoint for TX transfers.
 */
//@{
#define BP_USB_ENDPTn_EPTXEN (2U)          //!< Bit position for USB_ENDPTn_EPTXEN.
#define BM_USB_ENDPTn_EPTXEN (0x04U)       //!< Bit mask for USB_ENDPTn_EPTXEN.
#define BS_USB_ENDPTn_EPTXEN (1U)          //!< Bit field size in bits for USB_ENDPTn_EPTXEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ENDPTn_EPTXEN field.
#define BR_USB_ENDPTn_EPTXEN(n) (BITBAND_ACCESS8(HW_USB_ENDPTn_ADDR(n), BP_USB_ENDPTn_EPTXEN))
#endif

//! @brief Format value for bitfield USB_ENDPTn_EPTXEN.
#define BF_USB_ENDPTn_EPTXEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ENDPTn_EPTXEN), uint8_t) & BM_USB_ENDPTn_EPTXEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EPTXEN field to a new value.
#define BW_USB_ENDPTn_EPTXEN(n, v) (BITBAND_ACCESS8(HW_USB_ENDPTn_ADDR(n), BP_USB_ENDPTn_EPTXEN) = (v))
#endif
//@}

/*!
 * @name Register USB_ENDPTn, field EPRXEN[3] (RW)
 *
 * This bit, when set, enables the endpoint for RX transfers.
 */
//@{
#define BP_USB_ENDPTn_EPRXEN (3U)          //!< Bit position for USB_ENDPTn_EPRXEN.
#define BM_USB_ENDPTn_EPRXEN (0x08U)       //!< Bit mask for USB_ENDPTn_EPRXEN.
#define BS_USB_ENDPTn_EPRXEN (1U)          //!< Bit field size in bits for USB_ENDPTn_EPRXEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ENDPTn_EPRXEN field.
#define BR_USB_ENDPTn_EPRXEN(n) (BITBAND_ACCESS8(HW_USB_ENDPTn_ADDR(n), BP_USB_ENDPTn_EPRXEN))
#endif

//! @brief Format value for bitfield USB_ENDPTn_EPRXEN.
#define BF_USB_ENDPTn_EPRXEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ENDPTn_EPRXEN), uint8_t) & BM_USB_ENDPTn_EPRXEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EPRXEN field to a new value.
#define BW_USB_ENDPTn_EPRXEN(n, v) (BITBAND_ACCESS8(HW_USB_ENDPTn_ADDR(n), BP_USB_ENDPTn_EPRXEN) = (v))
#endif
//@}

/*!
 * @name Register USB_ENDPTn, field EPCTLDIS[4] (RW)
 *
 * This bit, when set, disables control (SETUP) transfers. When cleared, control
 * transfers are enabled. This applies if and only if the EPRXEN and EPTXEN bits
 * are also set.
 */
//@{
#define BP_USB_ENDPTn_EPCTLDIS (4U)        //!< Bit position for USB_ENDPTn_EPCTLDIS.
#define BM_USB_ENDPTn_EPCTLDIS (0x10U)     //!< Bit mask for USB_ENDPTn_EPCTLDIS.
#define BS_USB_ENDPTn_EPCTLDIS (1U)        //!< Bit field size in bits for USB_ENDPTn_EPCTLDIS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ENDPTn_EPCTLDIS field.
#define BR_USB_ENDPTn_EPCTLDIS(n) (BITBAND_ACCESS8(HW_USB_ENDPTn_ADDR(n), BP_USB_ENDPTn_EPCTLDIS))
#endif

//! @brief Format value for bitfield USB_ENDPTn_EPCTLDIS.
#define BF_USB_ENDPTn_EPCTLDIS(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ENDPTn_EPCTLDIS), uint8_t) & BM_USB_ENDPTn_EPCTLDIS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EPCTLDIS field to a new value.
#define BW_USB_ENDPTn_EPCTLDIS(n, v) (BITBAND_ACCESS8(HW_USB_ENDPTn_ADDR(n), BP_USB_ENDPTn_EPCTLDIS) = (v))
#endif
//@}

/*!
 * @name Register USB_ENDPTn, field RETRYDIS[6] (RW)
 *
 * This is a Host mode only bit and is present in the control register for
 * endpoint 0 (ENDPT0) only. When set this bit causes the host to not retry NAK'ed
 * (Negative Acknowledgement) transactions. When a transaction is NAKed, the BDT PID
 * field is updated with the NAK PID, and the TOKEN_DNE interrupt is set. When
 * this bit is cleared, NAKed transactions are retried in hardware. This bit must
 * be set when the host is attempting to poll an interrupt endpoint.
 */
//@{
#define BP_USB_ENDPTn_RETRYDIS (6U)        //!< Bit position for USB_ENDPTn_RETRYDIS.
#define BM_USB_ENDPTn_RETRYDIS (0x40U)     //!< Bit mask for USB_ENDPTn_RETRYDIS.
#define BS_USB_ENDPTn_RETRYDIS (1U)        //!< Bit field size in bits for USB_ENDPTn_RETRYDIS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ENDPTn_RETRYDIS field.
#define BR_USB_ENDPTn_RETRYDIS(n) (BITBAND_ACCESS8(HW_USB_ENDPTn_ADDR(n), BP_USB_ENDPTn_RETRYDIS))
#endif

//! @brief Format value for bitfield USB_ENDPTn_RETRYDIS.
#define BF_USB_ENDPTn_RETRYDIS(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ENDPTn_RETRYDIS), uint8_t) & BM_USB_ENDPTn_RETRYDIS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RETRYDIS field to a new value.
#define BW_USB_ENDPTn_RETRYDIS(n, v) (BITBAND_ACCESS8(HW_USB_ENDPTn_ADDR(n), BP_USB_ENDPTn_RETRYDIS) = (v))
#endif
//@}

/*!
 * @name Register USB_ENDPTn, field HOSTWOHUB[7] (RW)
 *
 * This is a Host mode only field and is present in the control register for
 * endpoint 0 (ENDPT0) only. When set this bit allows the host to communicate to a
 * directly connected low speed device. When cleared, the host produces the
 * PRE_PID. It then switches to low-speed signaling when sending a token to a low speed
 * device as required to communicate with a low speed device through a hub.
 */
//@{
#define BP_USB_ENDPTn_HOSTWOHUB (7U)       //!< Bit position for USB_ENDPTn_HOSTWOHUB.
#define BM_USB_ENDPTn_HOSTWOHUB (0x80U)    //!< Bit mask for USB_ENDPTn_HOSTWOHUB.
#define BS_USB_ENDPTn_HOSTWOHUB (1U)       //!< Bit field size in bits for USB_ENDPTn_HOSTWOHUB.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_ENDPTn_HOSTWOHUB field.
#define BR_USB_ENDPTn_HOSTWOHUB(n) (BITBAND_ACCESS8(HW_USB_ENDPTn_ADDR(n), BP_USB_ENDPTn_HOSTWOHUB))
#endif

//! @brief Format value for bitfield USB_ENDPTn_HOSTWOHUB.
#define BF_USB_ENDPTn_HOSTWOHUB(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_ENDPTn_HOSTWOHUB), uint8_t) & BM_USB_ENDPTn_HOSTWOHUB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HOSTWOHUB field to a new value.
#define BW_USB_ENDPTn_HOSTWOHUB(n, v) (BITBAND_ACCESS8(HW_USB_ENDPTn_ADDR(n), BP_USB_ENDPTn_HOSTWOHUB) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_USBCTRL - USB Control register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_USBCTRL - USB Control register (RW)
 *
 * Reset value: 0xC0U
 */
typedef union _hw_usb_usbctrl
{
    uint8_t U;
    struct _hw_usb_usbctrl_bitfields
    {
        uint8_t RESERVED0 : 6;         //!< [5:0]
        uint8_t PDE : 1;               //!< [6]
        uint8_t SUSP : 1;              //!< [7]
    } B;
} hw_usb_usbctrl_t;
#endif

/*!
 * @name Constants and macros for entire USB_USBCTRL register
 */
//@{
#define HW_USB_USBCTRL_ADDR      (REGS_USB_BASE + 0x100U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_USBCTRL           (*(__IO hw_usb_usbctrl_t *) HW_USB_USBCTRL_ADDR)
#define HW_USB_USBCTRL_RD()      (HW_USB_USBCTRL.U)
#define HW_USB_USBCTRL_WR(v)     (HW_USB_USBCTRL.U = (v))
#define HW_USB_USBCTRL_SET(v)    (HW_USB_USBCTRL_WR(HW_USB_USBCTRL_RD() |  (v)))
#define HW_USB_USBCTRL_CLR(v)    (HW_USB_USBCTRL_WR(HW_USB_USBCTRL_RD() & ~(v)))
#define HW_USB_USBCTRL_TOG(v)    (HW_USB_USBCTRL_WR(HW_USB_USBCTRL_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_USBCTRL bitfields
 */

/*!
 * @name Register USB_USBCTRL, field PDE[6] (RW)
 *
 * Enables the weak pulldowns on the USB transceiver.
 *
 * Values:
 * - 0 - Weak pulldowns are disabled on D+ and D-.
 * - 1 - Weak pulldowns are enabled on D+ and D-.
 */
//@{
#define BP_USB_USBCTRL_PDE   (6U)          //!< Bit position for USB_USBCTRL_PDE.
#define BM_USB_USBCTRL_PDE   (0x40U)       //!< Bit mask for USB_USBCTRL_PDE.
#define BS_USB_USBCTRL_PDE   (1U)          //!< Bit field size in bits for USB_USBCTRL_PDE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_USBCTRL_PDE field.
#define BR_USB_USBCTRL_PDE   (BITBAND_ACCESS8(HW_USB_USBCTRL_ADDR, BP_USB_USBCTRL_PDE))
#endif

//! @brief Format value for bitfield USB_USBCTRL_PDE.
#define BF_USB_USBCTRL_PDE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_USBCTRL_PDE), uint8_t) & BM_USB_USBCTRL_PDE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PDE field to a new value.
#define BW_USB_USBCTRL_PDE(v) (BITBAND_ACCESS8(HW_USB_USBCTRL_ADDR, BP_USB_USBCTRL_PDE) = (v))
#endif
//@}

/*!
 * @name Register USB_USBCTRL, field SUSP[7] (RW)
 *
 * Places the USB transceiver into the suspend state.
 *
 * Values:
 * - 0 - USB transceiver is not in suspend state.
 * - 1 - USB transceiver is in suspend state.
 */
//@{
#define BP_USB_USBCTRL_SUSP  (7U)          //!< Bit position for USB_USBCTRL_SUSP.
#define BM_USB_USBCTRL_SUSP  (0x80U)       //!< Bit mask for USB_USBCTRL_SUSP.
#define BS_USB_USBCTRL_SUSP  (1U)          //!< Bit field size in bits for USB_USBCTRL_SUSP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_USBCTRL_SUSP field.
#define BR_USB_USBCTRL_SUSP  (BITBAND_ACCESS8(HW_USB_USBCTRL_ADDR, BP_USB_USBCTRL_SUSP))
#endif

//! @brief Format value for bitfield USB_USBCTRL_SUSP.
#define BF_USB_USBCTRL_SUSP(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_USBCTRL_SUSP), uint8_t) & BM_USB_USBCTRL_SUSP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SUSP field to a new value.
#define BW_USB_USBCTRL_SUSP(v) (BITBAND_ACCESS8(HW_USB_USBCTRL_ADDR, BP_USB_USBCTRL_SUSP) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_OBSERVE - USB OTG Observe register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_OBSERVE - USB OTG Observe register (RO)
 *
 * Reset value: 0x50U
 *
 * Provides visibility on the state of the pull-ups and pull-downs at the
 * transceiver. Useful when interfacing to an external OTG control module via a serial
 * interface.
 */
typedef union _hw_usb_observe
{
    uint8_t U;
    struct _hw_usb_observe_bitfields
    {
        uint8_t RESERVED0 : 4;         //!< [3:0]
        uint8_t DMPD : 1;              //!< [4]
        uint8_t RESERVED1 : 1;         //!< [5]
        uint8_t DPPD : 1;              //!< [6]
        uint8_t DPPU : 1;              //!< [7]
    } B;
} hw_usb_observe_t;
#endif

/*!
 * @name Constants and macros for entire USB_OBSERVE register
 */
//@{
#define HW_USB_OBSERVE_ADDR      (REGS_USB_BASE + 0x104U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_OBSERVE           (*(__I hw_usb_observe_t *) HW_USB_OBSERVE_ADDR)
#define HW_USB_OBSERVE_RD()      (HW_USB_OBSERVE.U)
#endif
//@}

/*
 * Constants & macros for individual USB_OBSERVE bitfields
 */

/*!
 * @name Register USB_OBSERVE, field DMPD[4] (RO)
 *
 * Provides observability of the D- Pulldown enable at the USB transceiver.
 *
 * Values:
 * - 0 - D- pulldown disabled.
 * - 1 - D- pulldown enabled.
 */
//@{
#define BP_USB_OBSERVE_DMPD  (4U)          //!< Bit position for USB_OBSERVE_DMPD.
#define BM_USB_OBSERVE_DMPD  (0x10U)       //!< Bit mask for USB_OBSERVE_DMPD.
#define BS_USB_OBSERVE_DMPD  (1U)          //!< Bit field size in bits for USB_OBSERVE_DMPD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OBSERVE_DMPD field.
#define BR_USB_OBSERVE_DMPD  (BITBAND_ACCESS8(HW_USB_OBSERVE_ADDR, BP_USB_OBSERVE_DMPD))
#endif
//@}

/*!
 * @name Register USB_OBSERVE, field DPPD[6] (RO)
 *
 * Provides observability of the D+ Pulldown enable at the USB transceiver.
 *
 * Values:
 * - 0 - D+ pulldown disabled.
 * - 1 - D+ pulldown enabled.
 */
//@{
#define BP_USB_OBSERVE_DPPD  (6U)          //!< Bit position for USB_OBSERVE_DPPD.
#define BM_USB_OBSERVE_DPPD  (0x40U)       //!< Bit mask for USB_OBSERVE_DPPD.
#define BS_USB_OBSERVE_DPPD  (1U)          //!< Bit field size in bits for USB_OBSERVE_DPPD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OBSERVE_DPPD field.
#define BR_USB_OBSERVE_DPPD  (BITBAND_ACCESS8(HW_USB_OBSERVE_ADDR, BP_USB_OBSERVE_DPPD))
#endif
//@}

/*!
 * @name Register USB_OBSERVE, field DPPU[7] (RO)
 *
 * Provides observability of the D+ Pullup enable at the USB transceiver.
 *
 * Values:
 * - 0 - D+ pullup disabled.
 * - 1 - D+ pullup enabled.
 */
//@{
#define BP_USB_OBSERVE_DPPU  (7U)          //!< Bit position for USB_OBSERVE_DPPU.
#define BM_USB_OBSERVE_DPPU  (0x80U)       //!< Bit mask for USB_OBSERVE_DPPU.
#define BS_USB_OBSERVE_DPPU  (1U)          //!< Bit field size in bits for USB_OBSERVE_DPPU.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_OBSERVE_DPPU field.
#define BR_USB_OBSERVE_DPPU  (BITBAND_ACCESS8(HW_USB_OBSERVE_ADDR, BP_USB_OBSERVE_DPPU))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_CONTROL - USB OTG Control register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_CONTROL - USB OTG Control register (RW)
 *
 * Reset value: 0x00U
 */
typedef union _hw_usb_control
{
    uint8_t U;
    struct _hw_usb_control_bitfields
    {
        uint8_t RESERVED0 : 4;         //!< [3:0]
        uint8_t DPPULLUPNONOTG : 1;    //!< [4]
        uint8_t RESERVED1 : 3;         //!< [7:5]
    } B;
} hw_usb_control_t;
#endif

/*!
 * @name Constants and macros for entire USB_CONTROL register
 */
//@{
#define HW_USB_CONTROL_ADDR      (REGS_USB_BASE + 0x108U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_CONTROL           (*(__IO hw_usb_control_t *) HW_USB_CONTROL_ADDR)
#define HW_USB_CONTROL_RD()      (HW_USB_CONTROL.U)
#define HW_USB_CONTROL_WR(v)     (HW_USB_CONTROL.U = (v))
#define HW_USB_CONTROL_SET(v)    (HW_USB_CONTROL_WR(HW_USB_CONTROL_RD() |  (v)))
#define HW_USB_CONTROL_CLR(v)    (HW_USB_CONTROL_WR(HW_USB_CONTROL_RD() & ~(v)))
#define HW_USB_CONTROL_TOG(v)    (HW_USB_CONTROL_WR(HW_USB_CONTROL_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_CONTROL bitfields
 */

/*!
 * @name Register USB_CONTROL, field DPPULLUPNONOTG[4] (RW)
 *
 * Provides control of the DP Pullup in USBOTG, if USB is configured in non-OTG
 * device mode.
 *
 * Values:
 * - 0 - DP Pullup in non-OTG device mode is not enabled.
 * - 1 - DP Pullup in non-OTG device mode is enabled.
 */
//@{
#define BP_USB_CONTROL_DPPULLUPNONOTG (4U) //!< Bit position for USB_CONTROL_DPPULLUPNONOTG.
#define BM_USB_CONTROL_DPPULLUPNONOTG (0x10U) //!< Bit mask for USB_CONTROL_DPPULLUPNONOTG.
#define BS_USB_CONTROL_DPPULLUPNONOTG (1U) //!< Bit field size in bits for USB_CONTROL_DPPULLUPNONOTG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_CONTROL_DPPULLUPNONOTG field.
#define BR_USB_CONTROL_DPPULLUPNONOTG (BITBAND_ACCESS8(HW_USB_CONTROL_ADDR, BP_USB_CONTROL_DPPULLUPNONOTG))
#endif

//! @brief Format value for bitfield USB_CONTROL_DPPULLUPNONOTG.
#define BF_USB_CONTROL_DPPULLUPNONOTG(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_CONTROL_DPPULLUPNONOTG), uint8_t) & BM_USB_CONTROL_DPPULLUPNONOTG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DPPULLUPNONOTG field to a new value.
#define BW_USB_CONTROL_DPPULLUPNONOTG(v) (BITBAND_ACCESS8(HW_USB_CONTROL_ADDR, BP_USB_CONTROL_DPPULLUPNONOTG) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_USBTRC0 - USB Transceiver Control register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_USBTRC0 - USB Transceiver Control register 0 (RW)
 *
 * Reset value: 0x00U
 *
 * Includes signals for basic operation of the on-chip USB Full Speed
 * transceiver and configuration of the USB data connection that are not otherwise included
 * in the USB Full Speed controller registers.
 */
typedef union _hw_usb_usbtrc0
{
    uint8_t U;
    struct _hw_usb_usbtrc0_bitfields
    {
        uint8_t USB_RESUME_INT : 1;    //!< [0] USB Asynchronous Interrupt
        uint8_t SYNC_DET : 1;          //!< [1] Synchronous USB Interrupt Detect
        uint8_t USB_CLK_RECOVERY_INT : 1; //!< [2] Combined USB Clock
                                       //! Recovery interrupt status
        uint8_t RESERVED0 : 2;         //!< [4:3]
        uint8_t USBRESMEN : 1;         //!< [5] Asynchronous Resume Interrupt Enable
        uint8_t RESERVED1 : 1;         //!< [6]
        uint8_t USBRESET : 1;          //!< [7] USB Reset
    } B;
} hw_usb_usbtrc0_t;
#endif

/*!
 * @name Constants and macros for entire USB_USBTRC0 register
 */
//@{
#define HW_USB_USBTRC0_ADDR      (REGS_USB_BASE + 0x10CU)

#ifndef __LANGUAGE_ASM__
#define HW_USB_USBTRC0           (*(__IO hw_usb_usbtrc0_t *) HW_USB_USBTRC0_ADDR)
#define HW_USB_USBTRC0_RD()      (HW_USB_USBTRC0.U)
#define HW_USB_USBTRC0_WR(v)     (HW_USB_USBTRC0.U = (v))
#define HW_USB_USBTRC0_SET(v)    (HW_USB_USBTRC0_WR(HW_USB_USBTRC0_RD() |  (v)))
#define HW_USB_USBTRC0_CLR(v)    (HW_USB_USBTRC0_WR(HW_USB_USBTRC0_RD() & ~(v)))
#define HW_USB_USBTRC0_TOG(v)    (HW_USB_USBTRC0_WR(HW_USB_USBTRC0_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_USBTRC0 bitfields
 */

/*!
 * @name Register USB_USBTRC0, field USB_RESUME_INT[0] (RO)
 *
 * Values:
 * - 0 - No interrupt was generated.
 * - 1 - Interrupt was generated because of the USB asynchronous interrupt.
 */
//@{
#define BP_USB_USBTRC0_USB_RESUME_INT (0U) //!< Bit position for USB_USBTRC0_USB_RESUME_INT.
#define BM_USB_USBTRC0_USB_RESUME_INT (0x01U) //!< Bit mask for USB_USBTRC0_USB_RESUME_INT.
#define BS_USB_USBTRC0_USB_RESUME_INT (1U) //!< Bit field size in bits for USB_USBTRC0_USB_RESUME_INT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_USBTRC0_USB_RESUME_INT field.
#define BR_USB_USBTRC0_USB_RESUME_INT (BITBAND_ACCESS8(HW_USB_USBTRC0_ADDR, BP_USB_USBTRC0_USB_RESUME_INT))
#endif
//@}

/*!
 * @name Register USB_USBTRC0, field SYNC_DET[1] (RO)
 *
 * Values:
 * - 0 - Synchronous interrupt has not been detected.
 * - 1 - Synchronous interrupt has been detected.
 */
//@{
#define BP_USB_USBTRC0_SYNC_DET (1U)       //!< Bit position for USB_USBTRC0_SYNC_DET.
#define BM_USB_USBTRC0_SYNC_DET (0x02U)    //!< Bit mask for USB_USBTRC0_SYNC_DET.
#define BS_USB_USBTRC0_SYNC_DET (1U)       //!< Bit field size in bits for USB_USBTRC0_SYNC_DET.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_USBTRC0_SYNC_DET field.
#define BR_USB_USBTRC0_SYNC_DET (BITBAND_ACCESS8(HW_USB_USBTRC0_ADDR, BP_USB_USBTRC0_SYNC_DET))
#endif
//@}

/*!
 * @name Register USB_USBTRC0, field USB_CLK_RECOVERY_INT[2] (RO)
 *
 * This read-only field will be set to value high at 1'b1 when any of USB clock
 * recovery interrupt conditions are detected and those interrupts are unmasked.
 * For customer use the only unmasked USB clock recovery interrupt condition
 * results from an overflow of the frequency trim setting values indicating that the
 * frequency trim calculated is out of the adjustment range of the IRC48M output
 * clock. To clear this bit after it has been set, Write 0xFF to register
 * USB_CLK_RECOVER_INT_STATUS.
 */
//@{
#define BP_USB_USBTRC0_USB_CLK_RECOVERY_INT (2U) //!< Bit position for USB_USBTRC0_USB_CLK_RECOVERY_INT.
#define BM_USB_USBTRC0_USB_CLK_RECOVERY_INT (0x04U) //!< Bit mask for USB_USBTRC0_USB_CLK_RECOVERY_INT.
#define BS_USB_USBTRC0_USB_CLK_RECOVERY_INT (1U) //!< Bit field size in bits for USB_USBTRC0_USB_CLK_RECOVERY_INT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_USBTRC0_USB_CLK_RECOVERY_INT field.
#define BR_USB_USBTRC0_USB_CLK_RECOVERY_INT (BITBAND_ACCESS8(HW_USB_USBTRC0_ADDR, BP_USB_USBTRC0_USB_CLK_RECOVERY_INT))
#endif
//@}

/*!
 * @name Register USB_USBTRC0, field USBRESMEN[5] (RW)
 *
 * This bit, when set, allows the USB module to send an asynchronous wakeup
 * event to the MCU upon detection of resume signaling on the USB bus. The MCU then
 * re-enables clocks to the USB module. It is used for low-power suspend mode when
 * USB module clocks are stopped or the USB transceiver is in Suspend mode.
 * Async wakeup only works in device mode.
 *
 * Values:
 * - 0 - USB asynchronous wakeup from suspend mode disabled.
 * - 1 - USB asynchronous wakeup from suspend mode enabled. The asynchronous
 *     resume interrupt differs from the synchronous resume interrupt in that it
 *     asynchronously detects K-state using the unfiltered state of the D+ and D-
 *     pins. This interrupt should only be enabled when the Transceiver is
 *     suspended.
 */
//@{
#define BP_USB_USBTRC0_USBRESMEN (5U)      //!< Bit position for USB_USBTRC0_USBRESMEN.
#define BM_USB_USBTRC0_USBRESMEN (0x20U)   //!< Bit mask for USB_USBTRC0_USBRESMEN.
#define BS_USB_USBTRC0_USBRESMEN (1U)      //!< Bit field size in bits for USB_USBTRC0_USBRESMEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_USBTRC0_USBRESMEN field.
#define BR_USB_USBTRC0_USBRESMEN (BITBAND_ACCESS8(HW_USB_USBTRC0_ADDR, BP_USB_USBTRC0_USBRESMEN))
#endif

//! @brief Format value for bitfield USB_USBTRC0_USBRESMEN.
#define BF_USB_USBTRC0_USBRESMEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_USBTRC0_USBRESMEN), uint8_t) & BM_USB_USBTRC0_USBRESMEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the USBRESMEN field to a new value.
#define BW_USB_USBTRC0_USBRESMEN(v) (BITBAND_ACCESS8(HW_USB_USBTRC0_ADDR, BP_USB_USBTRC0_USBRESMEN) = (v))
#endif
//@}

/*!
 * @name Register USB_USBTRC0, field USBRESET[7] (WO)
 *
 * Generates a hard reset to USBOTG. After this bit is set and the reset occurs,
 * this bit is automatically cleared. This bit is always read as zero. Wait two
 * USB clock cycles after setting this bit.
 *
 * Values:
 * - 0 - Normal USB module operation.
 * - 1 - Returns the USB module to its reset state.
 */
//@{
#define BP_USB_USBTRC0_USBRESET (7U)       //!< Bit position for USB_USBTRC0_USBRESET.
#define BM_USB_USBTRC0_USBRESET (0x80U)    //!< Bit mask for USB_USBTRC0_USBRESET.
#define BS_USB_USBTRC0_USBRESET (1U)       //!< Bit field size in bits for USB_USBTRC0_USBRESET.

//! @brief Format value for bitfield USB_USBTRC0_USBRESET.
#define BF_USB_USBTRC0_USBRESET(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_USBTRC0_USBRESET), uint8_t) & BM_USB_USBTRC0_USBRESET)
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_USBFRMADJUST - Frame Adjust Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_USBFRMADJUST - Frame Adjust Register (RW)
 *
 * Reset value: 0x00U
 */
typedef union _hw_usb_usbfrmadjust
{
    uint8_t U;
    struct _hw_usb_usbfrmadjust_bitfields
    {
        uint8_t ADJ : 8;               //!< [7:0] Frame Adjustment
    } B;
} hw_usb_usbfrmadjust_t;
#endif

/*!
 * @name Constants and macros for entire USB_USBFRMADJUST register
 */
//@{
#define HW_USB_USBFRMADJUST_ADDR (REGS_USB_BASE + 0x114U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_USBFRMADJUST      (*(__IO hw_usb_usbfrmadjust_t *) HW_USB_USBFRMADJUST_ADDR)
#define HW_USB_USBFRMADJUST_RD() (HW_USB_USBFRMADJUST.U)
#define HW_USB_USBFRMADJUST_WR(v) (HW_USB_USBFRMADJUST.U = (v))
#define HW_USB_USBFRMADJUST_SET(v) (HW_USB_USBFRMADJUST_WR(HW_USB_USBFRMADJUST_RD() |  (v)))
#define HW_USB_USBFRMADJUST_CLR(v) (HW_USB_USBFRMADJUST_WR(HW_USB_USBFRMADJUST_RD() & ~(v)))
#define HW_USB_USBFRMADJUST_TOG(v) (HW_USB_USBFRMADJUST_WR(HW_USB_USBFRMADJUST_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_USBFRMADJUST bitfields
 */

/*!
 * @name Register USB_USBFRMADJUST, field ADJ[7:0] (RW)
 *
 * In Host mode, the frame adjustment is a twos complement number that adjusts
 * the period of each USB frame in 12-MHz clock periods. A SOF is normally
 * generated every 12,000 12-MHz clock cycles. The Frame Adjust Register can adjust this
 * by -128 to +127 to compensate for inaccuracies in the USB 48-MHz clock.
 * Changes to the ADJ bit take effect at the next start of the next frame.
 */
//@{
#define BP_USB_USBFRMADJUST_ADJ (0U)       //!< Bit position for USB_USBFRMADJUST_ADJ.
#define BM_USB_USBFRMADJUST_ADJ (0xFFU)    //!< Bit mask for USB_USBFRMADJUST_ADJ.
#define BS_USB_USBFRMADJUST_ADJ (8U)       //!< Bit field size in bits for USB_USBFRMADJUST_ADJ.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_USBFRMADJUST_ADJ field.
#define BR_USB_USBFRMADJUST_ADJ (HW_USB_USBFRMADJUST.U)
#endif

//! @brief Format value for bitfield USB_USBFRMADJUST_ADJ.
#define BF_USB_USBFRMADJUST_ADJ(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_USBFRMADJUST_ADJ), uint8_t) & BM_USB_USBFRMADJUST_ADJ)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADJ field to a new value.
#define BW_USB_USBFRMADJUST_ADJ(v) (HW_USB_USBFRMADJUST_WR(v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_CLK_RECOVER_CTRL - USB Clock recovery control
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_CLK_RECOVER_CTRL - USB Clock recovery control (RW)
 *
 * Reset value: 0x00U
 *
 * Signals in this register control the crystal-less USB clock mode in which the
 * internal IRC48M oscillator is tuned to match the clock extracted from the
 * incoming USB data stream. The IRC48M internal oscillator module must be enabled
 * in register USB_CLK_RECOVER_IRC_EN for this mode.
 */
typedef union _hw_usb_clk_recover_ctrl
{
    uint8_t U;
    struct _hw_usb_clk_recover_ctrl_bitfields
    {
        uint8_t RESERVED0 : 5;         //!< [4:0]
        uint8_t RESTART_IFRTRIM_EN : 1; //!< [5] Restart from IFR trim value
        uint8_t RESET_RESUME_ROUGH_EN : 1; //!< [6] Reset/resume to rough
                                       //! phase enable
        uint8_t CLOCK_RECOVER_EN : 1;  //!< [7] Crystal-less USB enable
    } B;
} hw_usb_clk_recover_ctrl_t;
#endif

/*!
 * @name Constants and macros for entire USB_CLK_RECOVER_CTRL register
 */
//@{
#define HW_USB_CLK_RECOVER_CTRL_ADDR (REGS_USB_BASE + 0x140U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_CLK_RECOVER_CTRL  (*(__IO hw_usb_clk_recover_ctrl_t *) HW_USB_CLK_RECOVER_CTRL_ADDR)
#define HW_USB_CLK_RECOVER_CTRL_RD() (HW_USB_CLK_RECOVER_CTRL.U)
#define HW_USB_CLK_RECOVER_CTRL_WR(v) (HW_USB_CLK_RECOVER_CTRL.U = (v))
#define HW_USB_CLK_RECOVER_CTRL_SET(v) (HW_USB_CLK_RECOVER_CTRL_WR(HW_USB_CLK_RECOVER_CTRL_RD() |  (v)))
#define HW_USB_CLK_RECOVER_CTRL_CLR(v) (HW_USB_CLK_RECOVER_CTRL_WR(HW_USB_CLK_RECOVER_CTRL_RD() & ~(v)))
#define HW_USB_CLK_RECOVER_CTRL_TOG(v) (HW_USB_CLK_RECOVER_CTRL_WR(HW_USB_CLK_RECOVER_CTRL_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_CLK_RECOVER_CTRL bitfields
 */

/*!
 * @name Register USB_CLK_RECOVER_CTRL, field RESTART_IFRTRIM_EN[5] (RW)
 *
 * IRC48 has a default trim fine value whose default value is factory trimmed
 * (the IFR trim value). Clock recover block tracks the accuracy of the clock 48Mhz
 * and keeps updating the trim fine value accordingly
 *
 * Values:
 * - 0 - Trim fine adjustment always works based on the previous updated trim
 *     fine value (default)
 * - 1 - Trim fine restarts from the IFR trim value whenever
 *     bus_reset/bus_resume is detected or module enable is desasserted
 */
//@{
#define BP_USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN (5U) //!< Bit position for USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN.
#define BM_USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN (0x20U) //!< Bit mask for USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN.
#define BS_USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN (1U) //!< Bit field size in bits for USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN field.
#define BR_USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN (BITBAND_ACCESS8(HW_USB_CLK_RECOVER_CTRL_ADDR, BP_USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN))
#endif

//! @brief Format value for bitfield USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN.
#define BF_USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN), uint8_t) & BM_USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RESTART_IFRTRIM_EN field to a new value.
#define BW_USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN(v) (BITBAND_ACCESS8(HW_USB_CLK_RECOVER_CTRL_ADDR, BP_USB_CLK_RECOVER_CTRL_RESTART_IFRTRIM_EN) = (v))
#endif
//@}

/*!
 * @name Register USB_CLK_RECOVER_CTRL, field RESET_RESUME_ROUGH_EN[6] (RW)
 *
 * The clock recovery block tracks the IRC48Mhz to get an accurate 48Mhz clock.
 * It has two phases after user enables clock_recover_en bit, rough phase and
 * tracking phase. The step to fine tune the IRC 48Mhz by adjusting the trim fine
 * value is different during these two phases. The step in rough phase is larger
 * than that in tracking phase. Switch back to rough stage whenever USB bus reset
 * or bus resume occurs.
 *
 * Values:
 * - 0 - Always works in tracking phase after the 1st time rough to track
 *     transition (default)
 * - 1 - Go back to rough stage whenever bus reset or bus resume occurs
 */
//@{
#define BP_USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN (6U) //!< Bit position for USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN.
#define BM_USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN (0x40U) //!< Bit mask for USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN.
#define BS_USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN (1U) //!< Bit field size in bits for USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN field.
#define BR_USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN (BITBAND_ACCESS8(HW_USB_CLK_RECOVER_CTRL_ADDR, BP_USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN))
#endif

//! @brief Format value for bitfield USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN.
#define BF_USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN), uint8_t) & BM_USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RESET_RESUME_ROUGH_EN field to a new value.
#define BW_USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN(v) (BITBAND_ACCESS8(HW_USB_CLK_RECOVER_CTRL_ADDR, BP_USB_CLK_RECOVER_CTRL_RESET_RESUME_ROUGH_EN) = (v))
#endif
//@}

/*!
 * @name Register USB_CLK_RECOVER_CTRL, field CLOCK_RECOVER_EN[7] (RW)
 *
 * This bit must be enabled if user wants to use the crystal-less USB mode for
 * the Full Speed USB controller and transceiver. This bit should not be set for
 * USB host mode or OTG.
 *
 * Values:
 * - 0 - Disable clock recovery block (default)
 * - 1 - Enable clock recovery block
 */
//@{
#define BP_USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN (7U) //!< Bit position for USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN.
#define BM_USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN (0x80U) //!< Bit mask for USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN.
#define BS_USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN (1U) //!< Bit field size in bits for USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN field.
#define BR_USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN (BITBAND_ACCESS8(HW_USB_CLK_RECOVER_CTRL_ADDR, BP_USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN))
#endif

//! @brief Format value for bitfield USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN.
#define BF_USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN), uint8_t) & BM_USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLOCK_RECOVER_EN field to a new value.
#define BW_USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN(v) (BITBAND_ACCESS8(HW_USB_CLK_RECOVER_CTRL_ADDR, BP_USB_CLK_RECOVER_CTRL_CLOCK_RECOVER_EN) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_CLK_RECOVER_IRC_EN - IRC48M oscillator enable register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_CLK_RECOVER_IRC_EN - IRC48M oscillator enable register (RW)
 *
 * Reset value: 0x01U
 *
 * Controls basic operation of the on-chip IRC48M module used to produce nominal
 * 48MHz clocks for USB crystal-less operation and other functions. See
 * additional information about the IRC48M operation in the Clock Distribution chapter.
 */
typedef union _hw_usb_clk_recover_irc_en
{
    uint8_t U;
    struct _hw_usb_clk_recover_irc_en_bitfields
    {
        uint8_t REG_EN : 1;            //!< [0] IRC48M regulator enable
        uint8_t IRC_EN : 1;            //!< [1] IRC48M enable
        uint8_t RESERVED0 : 6;         //!< [7:2]
    } B;
} hw_usb_clk_recover_irc_en_t;
#endif

/*!
 * @name Constants and macros for entire USB_CLK_RECOVER_IRC_EN register
 */
//@{
#define HW_USB_CLK_RECOVER_IRC_EN_ADDR (REGS_USB_BASE + 0x144U)

#ifndef __LANGUAGE_ASM__
#define HW_USB_CLK_RECOVER_IRC_EN (*(__IO hw_usb_clk_recover_irc_en_t *) HW_USB_CLK_RECOVER_IRC_EN_ADDR)
#define HW_USB_CLK_RECOVER_IRC_EN_RD() (HW_USB_CLK_RECOVER_IRC_EN.U)
#define HW_USB_CLK_RECOVER_IRC_EN_WR(v) (HW_USB_CLK_RECOVER_IRC_EN.U = (v))
#define HW_USB_CLK_RECOVER_IRC_EN_SET(v) (HW_USB_CLK_RECOVER_IRC_EN_WR(HW_USB_CLK_RECOVER_IRC_EN_RD() |  (v)))
#define HW_USB_CLK_RECOVER_IRC_EN_CLR(v) (HW_USB_CLK_RECOVER_IRC_EN_WR(HW_USB_CLK_RECOVER_IRC_EN_RD() & ~(v)))
#define HW_USB_CLK_RECOVER_IRC_EN_TOG(v) (HW_USB_CLK_RECOVER_IRC_EN_WR(HW_USB_CLK_RECOVER_IRC_EN_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_CLK_RECOVER_IRC_EN bitfields
 */

/*!
 * @name Register USB_CLK_RECOVER_IRC_EN, field REG_EN[0] (RW)
 *
 * This bit is used to enable the local analog regulator for IRC48Mhz module.
 * This bit must be set if user wants to use the crystal-less USB clock
 * configuration.
 *
 * Values:
 * - 0 - IRC48M local regulator is disabled
 * - 1 - IRC48M local regulator is enabled (default)
 */
//@{
#define BP_USB_CLK_RECOVER_IRC_EN_REG_EN (0U) //!< Bit position for USB_CLK_RECOVER_IRC_EN_REG_EN.
#define BM_USB_CLK_RECOVER_IRC_EN_REG_EN (0x01U) //!< Bit mask for USB_CLK_RECOVER_IRC_EN_REG_EN.
#define BS_USB_CLK_RECOVER_IRC_EN_REG_EN (1U) //!< Bit field size in bits for USB_CLK_RECOVER_IRC_EN_REG_EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_CLK_RECOVER_IRC_EN_REG_EN field.
#define BR_USB_CLK_RECOVER_IRC_EN_REG_EN (BITBAND_ACCESS8(HW_USB_CLK_RECOVER_IRC_EN_ADDR, BP_USB_CLK_RECOVER_IRC_EN_REG_EN))
#endif

//! @brief Format value for bitfield USB_CLK_RECOVER_IRC_EN_REG_EN.
#define BF_USB_CLK_RECOVER_IRC_EN_REG_EN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_CLK_RECOVER_IRC_EN_REG_EN), uint8_t) & BM_USB_CLK_RECOVER_IRC_EN_REG_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the REG_EN field to a new value.
#define BW_USB_CLK_RECOVER_IRC_EN_REG_EN(v) (BITBAND_ACCESS8(HW_USB_CLK_RECOVER_IRC_EN_ADDR, BP_USB_CLK_RECOVER_IRC_EN_REG_EN) = (v))
#endif
//@}

/*!
 * @name Register USB_CLK_RECOVER_IRC_EN, field IRC_EN[1] (RW)
 *
 * This bit is used to enable the on-chip IRC48Mhz module to generate clocks for
 * crystal-less USB. It can only be used for FS USB device mode operation. This
 * bit must be set before using the crystal-less USB clock configuration.
 *
 * Values:
 * - 0 - Disable the IRC48M module (default)
 * - 1 - Enable the IRC48M module
 */
//@{
#define BP_USB_CLK_RECOVER_IRC_EN_IRC_EN (1U) //!< Bit position for USB_CLK_RECOVER_IRC_EN_IRC_EN.
#define BM_USB_CLK_RECOVER_IRC_EN_IRC_EN (0x02U) //!< Bit mask for USB_CLK_RECOVER_IRC_EN_IRC_EN.
#define BS_USB_CLK_RECOVER_IRC_EN_IRC_EN (1U) //!< Bit field size in bits for USB_CLK_RECOVER_IRC_EN_IRC_EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_CLK_RECOVER_IRC_EN_IRC_EN field.
#define BR_USB_CLK_RECOVER_IRC_EN_IRC_EN (BITBAND_ACCESS8(HW_USB_CLK_RECOVER_IRC_EN_ADDR, BP_USB_CLK_RECOVER_IRC_EN_IRC_EN))
#endif

//! @brief Format value for bitfield USB_CLK_RECOVER_IRC_EN_IRC_EN.
#define BF_USB_CLK_RECOVER_IRC_EN_IRC_EN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_CLK_RECOVER_IRC_EN_IRC_EN), uint8_t) & BM_USB_CLK_RECOVER_IRC_EN_IRC_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IRC_EN field to a new value.
#define BW_USB_CLK_RECOVER_IRC_EN_IRC_EN(v) (BITBAND_ACCESS8(HW_USB_CLK_RECOVER_IRC_EN_ADDR, BP_USB_CLK_RECOVER_IRC_EN_IRC_EN) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_USB_CLK_RECOVER_INT_STATUS - Clock recovery separated interrupt status
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_USB_CLK_RECOVER_INT_STATUS - Clock recovery separated interrupt status (W1C)
 *
 * Reset value: 0x00U
 *
 * A Write operation with value high at 1'b1 on any combination of individual
 * bits will clear those bits.
 */
typedef union _hw_usb_clk_recover_int_status
{
    uint8_t U;
    struct _hw_usb_clk_recover_int_status_bitfields
    {
        uint8_t RESERVED0 : 4;         //!< [3:0]
        uint8_t OVF_ERROR : 1;         //!< [4]
        uint8_t RESERVED1 : 3;         //!< [7:5]
    } B;
} hw_usb_clk_recover_int_status_t;
#endif

/*!
 * @name Constants and macros for entire USB_CLK_RECOVER_INT_STATUS register
 */
//@{
#define HW_USB_CLK_RECOVER_INT_STATUS_ADDR (REGS_USB_BASE + 0x15CU)

#ifndef __LANGUAGE_ASM__
#define HW_USB_CLK_RECOVER_INT_STATUS (*(__IO hw_usb_clk_recover_int_status_t *) HW_USB_CLK_RECOVER_INT_STATUS_ADDR)
#define HW_USB_CLK_RECOVER_INT_STATUS_RD() (HW_USB_CLK_RECOVER_INT_STATUS.U)
#define HW_USB_CLK_RECOVER_INT_STATUS_WR(v) (HW_USB_CLK_RECOVER_INT_STATUS.U = (v))
#define HW_USB_CLK_RECOVER_INT_STATUS_SET(v) (HW_USB_CLK_RECOVER_INT_STATUS_WR(HW_USB_CLK_RECOVER_INT_STATUS_RD() |  (v)))
#define HW_USB_CLK_RECOVER_INT_STATUS_CLR(v) (HW_USB_CLK_RECOVER_INT_STATUS_WR(HW_USB_CLK_RECOVER_INT_STATUS_RD() & ~(v)))
#define HW_USB_CLK_RECOVER_INT_STATUS_TOG(v) (HW_USB_CLK_RECOVER_INT_STATUS_WR(HW_USB_CLK_RECOVER_INT_STATUS_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual USB_CLK_RECOVER_INT_STATUS bitfields
 */

/*!
 * @name Register USB_CLK_RECOVER_INT_STATUS, field OVF_ERROR[4] (W1C)
 *
 * Indicates that the USB clock recovery algorithm has detected that the
 * frequency trim adjustment needed for the IRC48M output clock is outside the available
 * TRIM_FINE adjustment range for the IRC48M module.
 *
 * Values:
 * - 0 - No interrupt is reported
 * - 1 - Unmasked interrupt has been generated
 */
//@{
#define BP_USB_CLK_RECOVER_INT_STATUS_OVF_ERROR (4U) //!< Bit position for USB_CLK_RECOVER_INT_STATUS_OVF_ERROR.
#define BM_USB_CLK_RECOVER_INT_STATUS_OVF_ERROR (0x10U) //!< Bit mask for USB_CLK_RECOVER_INT_STATUS_OVF_ERROR.
#define BS_USB_CLK_RECOVER_INT_STATUS_OVF_ERROR (1U) //!< Bit field size in bits for USB_CLK_RECOVER_INT_STATUS_OVF_ERROR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the USB_CLK_RECOVER_INT_STATUS_OVF_ERROR field.
#define BR_USB_CLK_RECOVER_INT_STATUS_OVF_ERROR (BITBAND_ACCESS8(HW_USB_CLK_RECOVER_INT_STATUS_ADDR, BP_USB_CLK_RECOVER_INT_STATUS_OVF_ERROR))
#endif

//! @brief Format value for bitfield USB_CLK_RECOVER_INT_STATUS_OVF_ERROR.
#define BF_USB_CLK_RECOVER_INT_STATUS_OVF_ERROR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_USB_CLK_RECOVER_INT_STATUS_OVF_ERROR), uint8_t) & BM_USB_CLK_RECOVER_INT_STATUS_OVF_ERROR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OVF_ERROR field to a new value.
#define BW_USB_CLK_RECOVER_INT_STATUS_OVF_ERROR(v) (BITBAND_ACCESS8(HW_USB_CLK_RECOVER_INT_STATUS_ADDR, BP_USB_CLK_RECOVER_INT_STATUS_OVF_ERROR) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_usb_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All USB module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_usb
{
    __I hw_usb_perid_t PERID;              //!< [0x0] Peripheral ID register
    uint8_t _reserved0[3];
    __I hw_usb_idcomp_t IDCOMP;            //!< [0x4] Peripheral ID Complement register
    uint8_t _reserved1[3];
    __I hw_usb_rev_t REV;                  //!< [0x8] Peripheral Revision register
    uint8_t _reserved2[3];
    __I hw_usb_addinfo_t ADDINFO;          //!< [0xC] Peripheral Additional Info register
    uint8_t _reserved3[3];
    __IO hw_usb_otgistat_t OTGISTAT;       //!< [0x10] OTG Interrupt Status register
    uint8_t _reserved4[3];
    __IO hw_usb_otgicr_t OTGICR;           //!< [0x14] OTG Interrupt Control register
    uint8_t _reserved5[3];
    __IO hw_usb_otgstat_t OTGSTAT;         //!< [0x18] OTG Status register
    uint8_t _reserved6[3];
    __IO hw_usb_otgctl_t OTGCTL;           //!< [0x1C] OTG Control register
    uint8_t _reserved7[99];
    __IO hw_usb_istat_t ISTAT;             //!< [0x80] Interrupt Status register
    uint8_t _reserved8[3];
    __IO hw_usb_inten_t INTEN;             //!< [0x84] Interrupt Enable register
    uint8_t _reserved9[3];
    __IO hw_usb_errstat_t ERRSTAT;         //!< [0x88] Error Interrupt Status register
    uint8_t _reserved10[3];
    __IO hw_usb_erren_t ERREN;             //!< [0x8C] Error Interrupt Enable register
    uint8_t _reserved11[3];
    __I hw_usb_stat_t STAT;                //!< [0x90] Status register
    uint8_t _reserved12[3];
    __IO hw_usb_ctl_t CTL;                 //!< [0x94] Control register
    uint8_t _reserved13[3];
    __IO hw_usb_addr_t ADDR;               //!< [0x98] Address register
    uint8_t _reserved14[3];
    __IO hw_usb_bdtpage1_t BDTPAGE1;       //!< [0x9C] BDT Page register 1
    uint8_t _reserved15[3];
    __IO hw_usb_frmnuml_t FRMNUML;         //!< [0xA0] Frame Number register Low
    uint8_t _reserved16[3];
    __IO hw_usb_frmnumh_t FRMNUMH;         //!< [0xA4] Frame Number register High
    uint8_t _reserved17[3];
    __IO hw_usb_token_t TOKEN;             //!< [0xA8] Token register
    uint8_t _reserved18[3];
    __IO hw_usb_softhld_t SOFTHLD;         //!< [0xAC] SOF Threshold register
    uint8_t _reserved19[3];
    __IO hw_usb_bdtpage2_t BDTPAGE2;       //!< [0xB0] BDT Page Register 2
    uint8_t _reserved20[3];
    __IO hw_usb_bdtpage3_t BDTPAGE3;       //!< [0xB4] BDT Page Register 3
    uint8_t _reserved21[11];
    struct {
        __IO hw_usb_endptn_t ENDPTn;       //!< [0xC0] Endpoint Control register
        uint8_t _reserved0[3];
    } ENDPOINT[16];
    __IO hw_usb_usbctrl_t USBCTRL;         //!< [0x100] USB Control register
    uint8_t _reserved22[3];
    __I hw_usb_observe_t OBSERVE;          //!< [0x104] USB OTG Observe register
    uint8_t _reserved23[3];
    __IO hw_usb_control_t CONTROL;         //!< [0x108] USB OTG Control register
    uint8_t _reserved24[3];
    __IO hw_usb_usbtrc0_t USBTRC0;         //!< [0x10C] USB Transceiver Control register 0
    uint8_t _reserved25[7];
    __IO hw_usb_usbfrmadjust_t USBFRMADJUST; //!< [0x114] Frame Adjust Register
    uint8_t _reserved26[43];
    __IO hw_usb_clk_recover_ctrl_t CLK_RECOVER_CTRL; //!< [0x140] USB Clock recovery control
    uint8_t _reserved27[3];
    __IO hw_usb_clk_recover_irc_en_t CLK_RECOVER_IRC_EN; //!< [0x144] IRC48M oscillator enable register
    uint8_t _reserved28[23];
    __IO hw_usb_clk_recover_int_status_t CLK_RECOVER_INT_STATUS; //!< [0x15C] Clock recovery separated interrupt status
} hw_usb_t;
#pragma pack()

//! @brief Macro to access all USB registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_USB</code>.
#define HW_USB         (*(hw_usb_t *) REGS_USB_BASE)
#endif

#endif // __HW_USB_REGISTERS_H__
// v22/130726/0.9
// EOF

