/*
 * Copyright (c) 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_SIM_REGISTERS_H__
#define __HW_SIM_REGISTERS_H__

#include "regs.h"

/*
 * MK64F12 SIM
 *
 * System Integration Module
 *
 * Registers defined in this header file:
 * - HW_SIM_SOPT1 - System Options Register 1
 * - HW_SIM_SOPT1CFG - SOPT1 Configuration Register
 * - HW_SIM_SOPT2 - System Options Register 2
 * - HW_SIM_SOPT4 - System Options Register 4
 * - HW_SIM_SOPT5 - System Options Register 5
 * - HW_SIM_SOPT7 - System Options Register 7
 * - HW_SIM_SDID - System Device Identification Register
 * - HW_SIM_SCGC1 - System Clock Gating Control Register 1
 * - HW_SIM_SCGC2 - System Clock Gating Control Register 2
 * - HW_SIM_SCGC3 - System Clock Gating Control Register 3
 * - HW_SIM_SCGC4 - System Clock Gating Control Register 4
 * - HW_SIM_SCGC5 - System Clock Gating Control Register 5
 * - HW_SIM_SCGC6 - System Clock Gating Control Register 6
 * - HW_SIM_SCGC7 - System Clock Gating Control Register 7
 * - HW_SIM_CLKDIV1 - System Clock Divider Register 1
 * - HW_SIM_CLKDIV2 - System Clock Divider Register 2
 * - HW_SIM_FCFG1 - Flash Configuration Register 1
 * - HW_SIM_FCFG2 - Flash Configuration Register 2
 * - HW_SIM_UIDH - Unique Identification Register High
 * - HW_SIM_UIDMH - Unique Identification Register Mid-High
 * - HW_SIM_UIDML - Unique Identification Register Mid Low
 * - HW_SIM_UIDL - Unique Identification Register Low
 *
 * - hw_sim_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_SIM_BASE
#define HW_SIM_INSTANCE_COUNT (1U) //!< Number of instances of the SIM module.
#define REGS_SIM_BASE (0x40047000U) //!< Base address for SIM.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_SOPT1 - System Options Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_SOPT1 - System Options Register 1 (RW)
 *
 * Reset value: 0x80000000U
 *
 * The SOPT1 register is only reset on POR or LVD.
 */
typedef union _hw_sim_sopt1
{
    uint32_t U;
    struct _hw_sim_sopt1_bitfields
    {
        uint32_t RESERVED0 : 12;       //!< [11:0]
        uint32_t RAMSIZE : 4;          //!< [15:12] RAM size
        uint32_t RESERVED1 : 2;        //!< [17:16]
        uint32_t OSC32KSEL : 2;        //!< [19:18] 32K oscillator clock select
        uint32_t RESERVED2 : 9;        //!< [28:20]
        uint32_t USBVSTBY : 1;         //!< [29] USB voltage regulator in standby
                                       //! mode during VLPR and VLPW modes
        uint32_t USBSSTBY : 1;         //!< [30] USB voltage regulator in standby
                                       //! mode during Stop, VLPS, LLS and VLLS modes.
        uint32_t USBREGEN : 1;         //!< [31] USB voltage regulator enable
    } B;
} hw_sim_sopt1_t;
#endif

/*!
 * @name Constants and macros for entire SIM_SOPT1 register
 */
//@{
#define HW_SIM_SOPT1_ADDR        (REGS_SIM_BASE + 0x0U)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_SOPT1             (*(__IO hw_sim_sopt1_t *) HW_SIM_SOPT1_ADDR)
#define HW_SIM_SOPT1_RD()        (HW_SIM_SOPT1.U)
#define HW_SIM_SOPT1_WR(v)       (HW_SIM_SOPT1.U = (v))
#define HW_SIM_SOPT1_SET(v)      (HW_SIM_SOPT1_WR(HW_SIM_SOPT1_RD() |  (v)))
#define HW_SIM_SOPT1_CLR(v)      (HW_SIM_SOPT1_WR(HW_SIM_SOPT1_RD() & ~(v)))
#define HW_SIM_SOPT1_TOG(v)      (HW_SIM_SOPT1_WR(HW_SIM_SOPT1_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SIM_SOPT1 bitfields
 */

/*!
 * @name Register SIM_SOPT1, field RAMSIZE[15:12] (RO)
 *
 * This field specifies the amount of system RAM available on the device.
 *
 * Values:
 * - 0001 - 8 KB
 * - 0011 - 16 KB
 * - 0100 - 24 KB
 * - 0101 - 32 KB
 * - 0110 - 48 KB
 * - 0111 - 64 KB
 * - 1000 - 96 KB
 * - 1001 - 128 KB
 * - 1011 - 256 KB
 */
//@{
#define BP_SIM_SOPT1_RAMSIZE (12U)         //!< Bit position for SIM_SOPT1_RAMSIZE.
#define BM_SIM_SOPT1_RAMSIZE (0x0000F000U) //!< Bit mask for SIM_SOPT1_RAMSIZE.
#define BS_SIM_SOPT1_RAMSIZE (4U)          //!< Bit field size in bits for SIM_SOPT1_RAMSIZE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT1_RAMSIZE field.
#define BR_SIM_SOPT1_RAMSIZE (HW_SIM_SOPT1.B.RAMSIZE)
#endif
//@}

/*!
 * @name Register SIM_SOPT1, field OSC32KSEL[19:18] (RW)
 *
 * Selects the 32 kHz clock source (ERCLK32K) for LPTMR. This field is reset
 * only on POR/LVD.
 *
 * Values:
 * - 00 - System oscillator (OSC32KCLK)
 * - 01 - Reserved
 * - 10 - RTC 32.768kHz oscillator
 * - 11 - LPO 1 kHz
 */
//@{
#define BP_SIM_SOPT1_OSC32KSEL (18U)       //!< Bit position for SIM_SOPT1_OSC32KSEL.
#define BM_SIM_SOPT1_OSC32KSEL (0x000C0000U) //!< Bit mask for SIM_SOPT1_OSC32KSEL.
#define BS_SIM_SOPT1_OSC32KSEL (2U)        //!< Bit field size in bits for SIM_SOPT1_OSC32KSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT1_OSC32KSEL field.
#define BR_SIM_SOPT1_OSC32KSEL (HW_SIM_SOPT1.B.OSC32KSEL)
#endif

//! @brief Format value for bitfield SIM_SOPT1_OSC32KSEL.
#define BF_SIM_SOPT1_OSC32KSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT1_OSC32KSEL), uint32_t) & BM_SIM_SOPT1_OSC32KSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OSC32KSEL field to a new value.
#define BW_SIM_SOPT1_OSC32KSEL(v) (HW_SIM_SOPT1_WR((HW_SIM_SOPT1_RD() & ~BM_SIM_SOPT1_OSC32KSEL) | BF_SIM_SOPT1_OSC32KSEL(v)))
#endif
//@}

/*!
 * @name Register SIM_SOPT1, field USBVSTBY[29] (RW)
 *
 * Controls whether the USB voltage regulator is placed in standby mode during
 * VLPR and VLPW modes.
 *
 * Values:
 * - 0 - USB voltage regulator not in standby during VLPR and VLPW modes.
 * - 1 - USB voltage regulator in standby during VLPR and VLPW modes.
 */
//@{
#define BP_SIM_SOPT1_USBVSTBY (29U)        //!< Bit position for SIM_SOPT1_USBVSTBY.
#define BM_SIM_SOPT1_USBVSTBY (0x20000000U) //!< Bit mask for SIM_SOPT1_USBVSTBY.
#define BS_SIM_SOPT1_USBVSTBY (1U)         //!< Bit field size in bits for SIM_SOPT1_USBVSTBY.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT1_USBVSTBY field.
#define BR_SIM_SOPT1_USBVSTBY (BITBAND_ACCESS32(HW_SIM_SOPT1_ADDR, BP_SIM_SOPT1_USBVSTBY))
#endif

//! @brief Format value for bitfield SIM_SOPT1_USBVSTBY.
#define BF_SIM_SOPT1_USBVSTBY(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT1_USBVSTBY), uint32_t) & BM_SIM_SOPT1_USBVSTBY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the USBVSTBY field to a new value.
#define BW_SIM_SOPT1_USBVSTBY(v) (BITBAND_ACCESS32(HW_SIM_SOPT1_ADDR, BP_SIM_SOPT1_USBVSTBY) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT1, field USBSSTBY[30] (RW)
 *
 * Controls whether the USB voltage regulator is placed in standby mode during
 * Stop, VLPS, LLS and VLLS modes.
 *
 * Values:
 * - 0 - USB voltage regulator not in standby during Stop, VLPS, LLS and VLLS
 *     modes.
 * - 1 - USB voltage regulator in standby during Stop, VLPS, LLS and VLLS modes.
 */
//@{
#define BP_SIM_SOPT1_USBSSTBY (30U)        //!< Bit position for SIM_SOPT1_USBSSTBY.
#define BM_SIM_SOPT1_USBSSTBY (0x40000000U) //!< Bit mask for SIM_SOPT1_USBSSTBY.
#define BS_SIM_SOPT1_USBSSTBY (1U)         //!< Bit field size in bits for SIM_SOPT1_USBSSTBY.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT1_USBSSTBY field.
#define BR_SIM_SOPT1_USBSSTBY (BITBAND_ACCESS32(HW_SIM_SOPT1_ADDR, BP_SIM_SOPT1_USBSSTBY))
#endif

//! @brief Format value for bitfield SIM_SOPT1_USBSSTBY.
#define BF_SIM_SOPT1_USBSSTBY(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT1_USBSSTBY), uint32_t) & BM_SIM_SOPT1_USBSSTBY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the USBSSTBY field to a new value.
#define BW_SIM_SOPT1_USBSSTBY(v) (BITBAND_ACCESS32(HW_SIM_SOPT1_ADDR, BP_SIM_SOPT1_USBSSTBY) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT1, field USBREGEN[31] (RW)
 *
 * Controls whether the USB voltage regulator is enabled.
 *
 * Values:
 * - 0 - USB voltage regulator is disabled.
 * - 1 - USB voltage regulator is enabled.
 */
//@{
#define BP_SIM_SOPT1_USBREGEN (31U)        //!< Bit position for SIM_SOPT1_USBREGEN.
#define BM_SIM_SOPT1_USBREGEN (0x80000000U) //!< Bit mask for SIM_SOPT1_USBREGEN.
#define BS_SIM_SOPT1_USBREGEN (1U)         //!< Bit field size in bits for SIM_SOPT1_USBREGEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT1_USBREGEN field.
#define BR_SIM_SOPT1_USBREGEN (BITBAND_ACCESS32(HW_SIM_SOPT1_ADDR, BP_SIM_SOPT1_USBREGEN))
#endif

//! @brief Format value for bitfield SIM_SOPT1_USBREGEN.
#define BF_SIM_SOPT1_USBREGEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT1_USBREGEN), uint32_t) & BM_SIM_SOPT1_USBREGEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the USBREGEN field to a new value.
#define BW_SIM_SOPT1_USBREGEN(v) (BITBAND_ACCESS32(HW_SIM_SOPT1_ADDR, BP_SIM_SOPT1_USBREGEN) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_SOPT1CFG - SOPT1 Configuration Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_SOPT1CFG - SOPT1 Configuration Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The SOPT1CFG register is reset on System Reset not VLLS.
 */
typedef union _hw_sim_sopt1cfg
{
    uint32_t U;
    struct _hw_sim_sopt1cfg_bitfields
    {
        uint32_t RESERVED0 : 24;       //!< [23:0]
        uint32_t URWE : 1;             //!< [24] USB voltage regulator enable write enable
        uint32_t UVSWE : 1;            //!< [25] USB voltage regulator VLP standby write
                                       //! enable
        uint32_t USSWE : 1;            //!< [26] USB voltage regulator stop standby
                                       //! write enable
        uint32_t RESERVED1 : 5;        //!< [31:27]
    } B;
} hw_sim_sopt1cfg_t;
#endif

/*!
 * @name Constants and macros for entire SIM_SOPT1CFG register
 */
//@{
#define HW_SIM_SOPT1CFG_ADDR     (REGS_SIM_BASE + 0x4U)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_SOPT1CFG          (*(__IO hw_sim_sopt1cfg_t *) HW_SIM_SOPT1CFG_ADDR)
#define HW_SIM_SOPT1CFG_RD()     (HW_SIM_SOPT1CFG.U)
#define HW_SIM_SOPT1CFG_WR(v)    (HW_SIM_SOPT1CFG.U = (v))
#define HW_SIM_SOPT1CFG_SET(v)   (HW_SIM_SOPT1CFG_WR(HW_SIM_SOPT1CFG_RD() |  (v)))
#define HW_SIM_SOPT1CFG_CLR(v)   (HW_SIM_SOPT1CFG_WR(HW_SIM_SOPT1CFG_RD() & ~(v)))
#define HW_SIM_SOPT1CFG_TOG(v)   (HW_SIM_SOPT1CFG_WR(HW_SIM_SOPT1CFG_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SIM_SOPT1CFG bitfields
 */

/*!
 * @name Register SIM_SOPT1CFG, field URWE[24] (RW)
 *
 * Writing one to the URWE bit allows the SOPT1 USBREGEN bit to be written. This
 * register bit clears after a write to USBREGEN.
 *
 * Values:
 * - 0 - SOPT1 USBREGEN cannot be written.
 * - 1 - SOPT1 USBREGEN can be written.
 */
//@{
#define BP_SIM_SOPT1CFG_URWE (24U)         //!< Bit position for SIM_SOPT1CFG_URWE.
#define BM_SIM_SOPT1CFG_URWE (0x01000000U) //!< Bit mask for SIM_SOPT1CFG_URWE.
#define BS_SIM_SOPT1CFG_URWE (1U)          //!< Bit field size in bits for SIM_SOPT1CFG_URWE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT1CFG_URWE field.
#define BR_SIM_SOPT1CFG_URWE (BITBAND_ACCESS32(HW_SIM_SOPT1CFG_ADDR, BP_SIM_SOPT1CFG_URWE))
#endif

//! @brief Format value for bitfield SIM_SOPT1CFG_URWE.
#define BF_SIM_SOPT1CFG_URWE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT1CFG_URWE), uint32_t) & BM_SIM_SOPT1CFG_URWE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the URWE field to a new value.
#define BW_SIM_SOPT1CFG_URWE(v) (BITBAND_ACCESS32(HW_SIM_SOPT1CFG_ADDR, BP_SIM_SOPT1CFG_URWE) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT1CFG, field UVSWE[25] (RW)
 *
 * Writing one to the UVSWE bit allows the SOPT1 USBVSTBY bit to be written.
 * This register bit clears after a write to USBVSTBY.
 *
 * Values:
 * - 0 - SOPT1 USBVSTBY cannot be written.
 * - 1 - SOPT1 USBVSTBY can be written.
 */
//@{
#define BP_SIM_SOPT1CFG_UVSWE (25U)        //!< Bit position for SIM_SOPT1CFG_UVSWE.
#define BM_SIM_SOPT1CFG_UVSWE (0x02000000U) //!< Bit mask for SIM_SOPT1CFG_UVSWE.
#define BS_SIM_SOPT1CFG_UVSWE (1U)         //!< Bit field size in bits for SIM_SOPT1CFG_UVSWE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT1CFG_UVSWE field.
#define BR_SIM_SOPT1CFG_UVSWE (BITBAND_ACCESS32(HW_SIM_SOPT1CFG_ADDR, BP_SIM_SOPT1CFG_UVSWE))
#endif

//! @brief Format value for bitfield SIM_SOPT1CFG_UVSWE.
#define BF_SIM_SOPT1CFG_UVSWE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT1CFG_UVSWE), uint32_t) & BM_SIM_SOPT1CFG_UVSWE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the UVSWE field to a new value.
#define BW_SIM_SOPT1CFG_UVSWE(v) (BITBAND_ACCESS32(HW_SIM_SOPT1CFG_ADDR, BP_SIM_SOPT1CFG_UVSWE) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT1CFG, field USSWE[26] (RW)
 *
 * Writing one to the USSWE bit allows the SOPT1 USBSSTBY bit to be written.
 * This register bit clears after a write to USBSSTBY.
 *
 * Values:
 * - 0 - SOPT1 USBSSTBY cannot be written.
 * - 1 - SOPT1 USBSSTBY can be written.
 */
//@{
#define BP_SIM_SOPT1CFG_USSWE (26U)        //!< Bit position for SIM_SOPT1CFG_USSWE.
#define BM_SIM_SOPT1CFG_USSWE (0x04000000U) //!< Bit mask for SIM_SOPT1CFG_USSWE.
#define BS_SIM_SOPT1CFG_USSWE (1U)         //!< Bit field size in bits for SIM_SOPT1CFG_USSWE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT1CFG_USSWE field.
#define BR_SIM_SOPT1CFG_USSWE (BITBAND_ACCESS32(HW_SIM_SOPT1CFG_ADDR, BP_SIM_SOPT1CFG_USSWE))
#endif

//! @brief Format value for bitfield SIM_SOPT1CFG_USSWE.
#define BF_SIM_SOPT1CFG_USSWE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT1CFG_USSWE), uint32_t) & BM_SIM_SOPT1CFG_USSWE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the USSWE field to a new value.
#define BW_SIM_SOPT1CFG_USSWE(v) (BITBAND_ACCESS32(HW_SIM_SOPT1CFG_ADDR, BP_SIM_SOPT1CFG_USSWE) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_SOPT2 - System Options Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_SOPT2 - System Options Register 2 (RW)
 *
 * Reset value: 0x00001000U
 *
 * SOPT2 contains the controls for selecting many of the module clock source
 * options on this device. See the Clock Distribution chapter for more information
 * including clocking diagrams and definitions of device clocks.
 */
typedef union _hw_sim_sopt2
{
    uint32_t U;
    struct _hw_sim_sopt2_bitfields
    {
        uint32_t RESERVED0 : 4;        //!< [3:0]
        uint32_t RTCCLKOUTSEL : 1;     //!< [4] RTC clock out select
        uint32_t CLKOUTSEL : 3;        //!< [7:5] CLKOUT select
        uint32_t FBSL : 2;             //!< [9:8] FlexBus security level
        uint32_t RESERVED1 : 1;        //!< [10]
        uint32_t PTD7PAD : 1;          //!< [11] PTD7 pad drive strength
        uint32_t TRACECLKSEL : 1;      //!< [12] Debug trace clock select
        uint32_t RESERVED2 : 3;        //!< [15:13]
        uint32_t PLLFLLSEL : 2;        //!< [17:16] PLL/FLL clock select
        uint32_t USBSRC : 1;           //!< [18] USB clock source select
        uint32_t RMIISRC : 1;          //!< [19] RMII clock source select
        uint32_t TIMESRC : 2;          //!< [21:20] IEEE 1588 timestamp clock source
                                       //! select
        uint32_t RESERVED3 : 6;        //!< [27:22]
        uint32_t SDHCSRC : 2;          //!< [29:28] SDHC clock source select
        uint32_t RESERVED4 : 2;        //!< [31:30]
    } B;
} hw_sim_sopt2_t;
#endif

/*!
 * @name Constants and macros for entire SIM_SOPT2 register
 */
//@{
#define HW_SIM_SOPT2_ADDR        (REGS_SIM_BASE + 0x1004U)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_SOPT2             (*(__IO hw_sim_sopt2_t *) HW_SIM_SOPT2_ADDR)
#define HW_SIM_SOPT2_RD()        (HW_SIM_SOPT2.U)
#define HW_SIM_SOPT2_WR(v)       (HW_SIM_SOPT2.U = (v))
#define HW_SIM_SOPT2_SET(v)      (HW_SIM_SOPT2_WR(HW_SIM_SOPT2_RD() |  (v)))
#define HW_SIM_SOPT2_CLR(v)      (HW_SIM_SOPT2_WR(HW_SIM_SOPT2_RD() & ~(v)))
#define HW_SIM_SOPT2_TOG(v)      (HW_SIM_SOPT2_WR(HW_SIM_SOPT2_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SIM_SOPT2 bitfields
 */

/*!
 * @name Register SIM_SOPT2, field RTCCLKOUTSEL[4] (RW)
 *
 * Selects either the RTC 1 Hz clock or the 32.768kHz clock to be output on the
 * RTC_CLKOUT pin.
 *
 * Values:
 * - 0 - RTC 1 Hz clock is output on the RTC_CLKOUT pin.
 * - 1 - RTC 32.768kHz clock is output on the RTC_CLKOUT pin.
 */
//@{
#define BP_SIM_SOPT2_RTCCLKOUTSEL (4U)     //!< Bit position for SIM_SOPT2_RTCCLKOUTSEL.
#define BM_SIM_SOPT2_RTCCLKOUTSEL (0x00000010U) //!< Bit mask for SIM_SOPT2_RTCCLKOUTSEL.
#define BS_SIM_SOPT2_RTCCLKOUTSEL (1U)     //!< Bit field size in bits for SIM_SOPT2_RTCCLKOUTSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT2_RTCCLKOUTSEL field.
#define BR_SIM_SOPT2_RTCCLKOUTSEL (BITBAND_ACCESS32(HW_SIM_SOPT2_ADDR, BP_SIM_SOPT2_RTCCLKOUTSEL))
#endif

//! @brief Format value for bitfield SIM_SOPT2_RTCCLKOUTSEL.
#define BF_SIM_SOPT2_RTCCLKOUTSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT2_RTCCLKOUTSEL), uint32_t) & BM_SIM_SOPT2_RTCCLKOUTSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RTCCLKOUTSEL field to a new value.
#define BW_SIM_SOPT2_RTCCLKOUTSEL(v) (BITBAND_ACCESS32(HW_SIM_SOPT2_ADDR, BP_SIM_SOPT2_RTCCLKOUTSEL) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT2, field CLKOUTSEL[7:5] (RW)
 *
 * Selects the clock to output on the CLKOUT pin.
 *
 * Values:
 * - 000 - FlexBus CLKOUT
 * - 001 - Reserved
 * - 010 - Flash clock
 * - 011 - LPO clock (1 kHz)
 * - 100 - MCGIRCLK
 * - 101 - RTC 32.768kHz clock
 * - 110 - OSCERCLK0
 * - 111 - IRC 48 MHz clock
 */
//@{
#define BP_SIM_SOPT2_CLKOUTSEL (5U)        //!< Bit position for SIM_SOPT2_CLKOUTSEL.
#define BM_SIM_SOPT2_CLKOUTSEL (0x000000E0U) //!< Bit mask for SIM_SOPT2_CLKOUTSEL.
#define BS_SIM_SOPT2_CLKOUTSEL (3U)        //!< Bit field size in bits for SIM_SOPT2_CLKOUTSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT2_CLKOUTSEL field.
#define BR_SIM_SOPT2_CLKOUTSEL (HW_SIM_SOPT2.B.CLKOUTSEL)
#endif

//! @brief Format value for bitfield SIM_SOPT2_CLKOUTSEL.
#define BF_SIM_SOPT2_CLKOUTSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT2_CLKOUTSEL), uint32_t) & BM_SIM_SOPT2_CLKOUTSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLKOUTSEL field to a new value.
#define BW_SIM_SOPT2_CLKOUTSEL(v) (HW_SIM_SOPT2_WR((HW_SIM_SOPT2_RD() & ~BM_SIM_SOPT2_CLKOUTSEL) | BF_SIM_SOPT2_CLKOUTSEL(v)))
#endif
//@}

/*!
 * @name Register SIM_SOPT2, field FBSL[9:8] (RW)
 *
 * If flash security is enabled, then this field affects what CPU operations can
 * access off-chip via the FlexBus interface. This field has no effect if flash
 * security is not enabled.
 *
 * Values:
 * - 00 - All off-chip accesses (instruction and data) via the FlexBus are
 *     disallowed.
 * - 01 - All off-chip accesses (instruction and data) via the FlexBus are
 *     disallowed.
 * - 10 - Off-chip instruction accesses are disallowed. Data accesses are
 *     allowed.
 * - 11 - Off-chip instruction accesses and data accesses are allowed.
 */
//@{
#define BP_SIM_SOPT2_FBSL    (8U)          //!< Bit position for SIM_SOPT2_FBSL.
#define BM_SIM_SOPT2_FBSL    (0x00000300U) //!< Bit mask for SIM_SOPT2_FBSL.
#define BS_SIM_SOPT2_FBSL    (2U)          //!< Bit field size in bits for SIM_SOPT2_FBSL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT2_FBSL field.
#define BR_SIM_SOPT2_FBSL    (HW_SIM_SOPT2.B.FBSL)
#endif

//! @brief Format value for bitfield SIM_SOPT2_FBSL.
#define BF_SIM_SOPT2_FBSL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT2_FBSL), uint32_t) & BM_SIM_SOPT2_FBSL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FBSL field to a new value.
#define BW_SIM_SOPT2_FBSL(v) (HW_SIM_SOPT2_WR((HW_SIM_SOPT2_RD() & ~BM_SIM_SOPT2_FBSL) | BF_SIM_SOPT2_FBSL(v)))
#endif
//@}

/*!
 * @name Register SIM_SOPT2, field PTD7PAD[11] (RW)
 *
 * Controls the output drive strength of the PTD7 pin by selecting either one or
 * two pads to drive it.
 *
 * Values:
 * - 0 - Single-pad drive strength for PTD7.
 * - 1 - Double pad drive strength for PTD7.
 */
//@{
#define BP_SIM_SOPT2_PTD7PAD (11U)         //!< Bit position for SIM_SOPT2_PTD7PAD.
#define BM_SIM_SOPT2_PTD7PAD (0x00000800U) //!< Bit mask for SIM_SOPT2_PTD7PAD.
#define BS_SIM_SOPT2_PTD7PAD (1U)          //!< Bit field size in bits for SIM_SOPT2_PTD7PAD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT2_PTD7PAD field.
#define BR_SIM_SOPT2_PTD7PAD (BITBAND_ACCESS32(HW_SIM_SOPT2_ADDR, BP_SIM_SOPT2_PTD7PAD))
#endif

//! @brief Format value for bitfield SIM_SOPT2_PTD7PAD.
#define BF_SIM_SOPT2_PTD7PAD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT2_PTD7PAD), uint32_t) & BM_SIM_SOPT2_PTD7PAD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PTD7PAD field to a new value.
#define BW_SIM_SOPT2_PTD7PAD(v) (BITBAND_ACCESS32(HW_SIM_SOPT2_ADDR, BP_SIM_SOPT2_PTD7PAD) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT2, field TRACECLKSEL[12] (RW)
 *
 * Selects the core/system clock or MCG output clock (MCGOUTCLK) as the trace
 * clock source.
 *
 * Values:
 * - 0 - MCGOUTCLK
 * - 1 - Core/system clock
 */
//@{
#define BP_SIM_SOPT2_TRACECLKSEL (12U)     //!< Bit position for SIM_SOPT2_TRACECLKSEL.
#define BM_SIM_SOPT2_TRACECLKSEL (0x00001000U) //!< Bit mask for SIM_SOPT2_TRACECLKSEL.
#define BS_SIM_SOPT2_TRACECLKSEL (1U)      //!< Bit field size in bits for SIM_SOPT2_TRACECLKSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT2_TRACECLKSEL field.
#define BR_SIM_SOPT2_TRACECLKSEL (BITBAND_ACCESS32(HW_SIM_SOPT2_ADDR, BP_SIM_SOPT2_TRACECLKSEL))
#endif

//! @brief Format value for bitfield SIM_SOPT2_TRACECLKSEL.
#define BF_SIM_SOPT2_TRACECLKSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT2_TRACECLKSEL), uint32_t) & BM_SIM_SOPT2_TRACECLKSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TRACECLKSEL field to a new value.
#define BW_SIM_SOPT2_TRACECLKSEL(v) (BITBAND_ACCESS32(HW_SIM_SOPT2_ADDR, BP_SIM_SOPT2_TRACECLKSEL) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT2, field PLLFLLSEL[17:16] (RW)
 *
 * Selects the high frequency clock for various peripheral clocking options.
 *
 * Values:
 * - 00 - MCGFLLCLK clock
 * - 01 - MCGPLLCLK clock
 * - 10 - Reserved
 * - 11 - IRC48 MHz clock
 */
//@{
#define BP_SIM_SOPT2_PLLFLLSEL (16U)       //!< Bit position for SIM_SOPT2_PLLFLLSEL.
#define BM_SIM_SOPT2_PLLFLLSEL (0x00030000U) //!< Bit mask for SIM_SOPT2_PLLFLLSEL.
#define BS_SIM_SOPT2_PLLFLLSEL (2U)        //!< Bit field size in bits for SIM_SOPT2_PLLFLLSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT2_PLLFLLSEL field.
#define BR_SIM_SOPT2_PLLFLLSEL (HW_SIM_SOPT2.B.PLLFLLSEL)
#endif

//! @brief Format value for bitfield SIM_SOPT2_PLLFLLSEL.
#define BF_SIM_SOPT2_PLLFLLSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT2_PLLFLLSEL), uint32_t) & BM_SIM_SOPT2_PLLFLLSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PLLFLLSEL field to a new value.
#define BW_SIM_SOPT2_PLLFLLSEL(v) (HW_SIM_SOPT2_WR((HW_SIM_SOPT2_RD() & ~BM_SIM_SOPT2_PLLFLLSEL) | BF_SIM_SOPT2_PLLFLLSEL(v)))
#endif
//@}

/*!
 * @name Register SIM_SOPT2, field USBSRC[18] (RW)
 *
 * Selects the clock source for the USB 48 MHz clock.
 *
 * Values:
 * - 0 - External bypass clock (USB_CLKIN).
 * - 1 - MCGFLLCLK , or MCGPLLCLK , or IRC48M clock as selected by
 *     SOPT2[PLLFLLSEL], and then divided by the USB fractional divider as configured by
 *     SIM_CLKDIV2[USBFRAC, USBDIV].
 */
//@{
#define BP_SIM_SOPT2_USBSRC  (18U)         //!< Bit position for SIM_SOPT2_USBSRC.
#define BM_SIM_SOPT2_USBSRC  (0x00040000U) //!< Bit mask for SIM_SOPT2_USBSRC.
#define BS_SIM_SOPT2_USBSRC  (1U)          //!< Bit field size in bits for SIM_SOPT2_USBSRC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT2_USBSRC field.
#define BR_SIM_SOPT2_USBSRC  (BITBAND_ACCESS32(HW_SIM_SOPT2_ADDR, BP_SIM_SOPT2_USBSRC))
#endif

//! @brief Format value for bitfield SIM_SOPT2_USBSRC.
#define BF_SIM_SOPT2_USBSRC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT2_USBSRC), uint32_t) & BM_SIM_SOPT2_USBSRC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the USBSRC field to a new value.
#define BW_SIM_SOPT2_USBSRC(v) (BITBAND_ACCESS32(HW_SIM_SOPT2_ADDR, BP_SIM_SOPT2_USBSRC) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT2, field RMIISRC[19] (RW)
 *
 * Selects the clock source for the Ethernet RMII interface
 *
 * Values:
 * - 0 - EXTAL clock
 * - 1 - External bypass clock (ENET_1588_CLKIN).
 */
//@{
#define BP_SIM_SOPT2_RMIISRC (19U)         //!< Bit position for SIM_SOPT2_RMIISRC.
#define BM_SIM_SOPT2_RMIISRC (0x00080000U) //!< Bit mask for SIM_SOPT2_RMIISRC.
#define BS_SIM_SOPT2_RMIISRC (1U)          //!< Bit field size in bits for SIM_SOPT2_RMIISRC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT2_RMIISRC field.
#define BR_SIM_SOPT2_RMIISRC (BITBAND_ACCESS32(HW_SIM_SOPT2_ADDR, BP_SIM_SOPT2_RMIISRC))
#endif

//! @brief Format value for bitfield SIM_SOPT2_RMIISRC.
#define BF_SIM_SOPT2_RMIISRC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT2_RMIISRC), uint32_t) & BM_SIM_SOPT2_RMIISRC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RMIISRC field to a new value.
#define BW_SIM_SOPT2_RMIISRC(v) (BITBAND_ACCESS32(HW_SIM_SOPT2_ADDR, BP_SIM_SOPT2_RMIISRC) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT2, field TIMESRC[21:20] (RW)
 *
 * Selects the clock source for the Ethernet timestamp clock.
 *
 * Values:
 * - 00 - Core/system clock.
 * - 01 - MCGFLLCLK , or MCGPLLCLK , or IRC48M clock as selected by
 *     SOPT2[PLLFLLSEL].
 * - 10 - OSCERCLK clock
 * - 11 - External bypass clock (ENET_1588_CLKIN).
 */
//@{
#define BP_SIM_SOPT2_TIMESRC (20U)         //!< Bit position for SIM_SOPT2_TIMESRC.
#define BM_SIM_SOPT2_TIMESRC (0x00300000U) //!< Bit mask for SIM_SOPT2_TIMESRC.
#define BS_SIM_SOPT2_TIMESRC (2U)          //!< Bit field size in bits for SIM_SOPT2_TIMESRC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT2_TIMESRC field.
#define BR_SIM_SOPT2_TIMESRC (HW_SIM_SOPT2.B.TIMESRC)
#endif

//! @brief Format value for bitfield SIM_SOPT2_TIMESRC.
#define BF_SIM_SOPT2_TIMESRC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT2_TIMESRC), uint32_t) & BM_SIM_SOPT2_TIMESRC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TIMESRC field to a new value.
#define BW_SIM_SOPT2_TIMESRC(v) (HW_SIM_SOPT2_WR((HW_SIM_SOPT2_RD() & ~BM_SIM_SOPT2_TIMESRC) | BF_SIM_SOPT2_TIMESRC(v)))
#endif
//@}

/*!
 * @name Register SIM_SOPT2, field SDHCSRC[29:28] (RW)
 *
 * Selects the clock source for the SDHC clock .
 *
 * Values:
 * - 00 - Core/system clock.
 * - 01 - MCGFLLCLK, or MCGPLLCLK , or IRC48M clock as selected by
 *     SOPT2[PLLFLLSEL].
 * - 10 - OSCERCLK clock
 * - 11 - External bypass clock (SDHC0_CLKIN)
 */
//@{
#define BP_SIM_SOPT2_SDHCSRC (28U)         //!< Bit position for SIM_SOPT2_SDHCSRC.
#define BM_SIM_SOPT2_SDHCSRC (0x30000000U) //!< Bit mask for SIM_SOPT2_SDHCSRC.
#define BS_SIM_SOPT2_SDHCSRC (2U)          //!< Bit field size in bits for SIM_SOPT2_SDHCSRC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT2_SDHCSRC field.
#define BR_SIM_SOPT2_SDHCSRC (HW_SIM_SOPT2.B.SDHCSRC)
#endif

//! @brief Format value for bitfield SIM_SOPT2_SDHCSRC.
#define BF_SIM_SOPT2_SDHCSRC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT2_SDHCSRC), uint32_t) & BM_SIM_SOPT2_SDHCSRC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SDHCSRC field to a new value.
#define BW_SIM_SOPT2_SDHCSRC(v) (HW_SIM_SOPT2_WR((HW_SIM_SOPT2_RD() & ~BM_SIM_SOPT2_SDHCSRC) | BF_SIM_SOPT2_SDHCSRC(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_SOPT4 - System Options Register 4
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_SOPT4 - System Options Register 4 (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_sim_sopt4
{
    uint32_t U;
    struct _hw_sim_sopt4_bitfields
    {
        uint32_t FTM0FLT0 : 1;         //!< [0] FTM0 Fault 0 Select
        uint32_t FTM0FLT1 : 1;         //!< [1] FTM0 Fault 1 Select
        uint32_t FTM0FLT2 : 1;         //!< [2] FTM0 Fault 2 Select
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t FTM1FLT0 : 1;         //!< [4] FTM1 Fault 0 Select
        uint32_t RESERVED1 : 3;        //!< [7:5]
        uint32_t FTM2FLT0 : 1;         //!< [8] FTM2 Fault 0 Select
        uint32_t RESERVED2 : 3;        //!< [11:9]
        uint32_t FTM3FLT0 : 1;         //!< [12] FTM3 Fault 0 Select
        uint32_t RESERVED3 : 5;        //!< [17:13]
        uint32_t FTM1CH0SRC : 2;       //!< [19:18] FTM1 channel 0 input capture
                                       //! source select
        uint32_t FTM2CH0SRC : 2;       //!< [21:20] FTM2 channel 0 input capture
                                       //! source select
        uint32_t RESERVED4 : 2;        //!< [23:22]
        uint32_t FTM0CLKSEL : 1;       //!< [24] FlexTimer 0 External Clock Pin
                                       //! Select
        uint32_t FTM1CLKSEL : 1;       //!< [25] FTM1 External Clock Pin Select
        uint32_t FTM2CLKSEL : 1;       //!< [26] FlexTimer 2 External Clock Pin
                                       //! Select
        uint32_t FTM3CLKSEL : 1;       //!< [27] FlexTimer 3 External Clock Pin
                                       //! Select
        uint32_t FTM0TRG0SRC : 1;      //!< [28] FlexTimer 0 Hardware Trigger 0
                                       //! Source Select
        uint32_t FTM0TRG1SRC : 1;      //!< [29] FlexTimer 0 Hardware Trigger 1
                                       //! Source Select
        uint32_t FTM3TRG0SRC : 1;      //!< [30] FlexTimer 3 Hardware Trigger 0
                                       //! Source Select
        uint32_t FTM3TRG1SRC : 1;      //!< [31] FlexTimer 3 Hardware Trigger 1
                                       //! Source Select
    } B;
} hw_sim_sopt4_t;
#endif

/*!
 * @name Constants and macros for entire SIM_SOPT4 register
 */
//@{
#define HW_SIM_SOPT4_ADDR        (REGS_SIM_BASE + 0x100CU)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_SOPT4             (*(__IO hw_sim_sopt4_t *) HW_SIM_SOPT4_ADDR)
#define HW_SIM_SOPT4_RD()        (HW_SIM_SOPT4.U)
#define HW_SIM_SOPT4_WR(v)       (HW_SIM_SOPT4.U = (v))
#define HW_SIM_SOPT4_SET(v)      (HW_SIM_SOPT4_WR(HW_SIM_SOPT4_RD() |  (v)))
#define HW_SIM_SOPT4_CLR(v)      (HW_SIM_SOPT4_WR(HW_SIM_SOPT4_RD() & ~(v)))
#define HW_SIM_SOPT4_TOG(v)      (HW_SIM_SOPT4_WR(HW_SIM_SOPT4_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SIM_SOPT4 bitfields
 */

/*!
 * @name Register SIM_SOPT4, field FTM0FLT0[0] (RW)
 *
 * Selects the source of FTM0 fault 0. The pin source for fault 0 must be
 * configured for the FTM module fault function through the appropriate pin control
 * register in the port control module.
 *
 * Values:
 * - 0 - FTM0_FLT0 pin
 * - 1 - CMP0 out
 */
//@{
#define BP_SIM_SOPT4_FTM0FLT0 (0U)         //!< Bit position for SIM_SOPT4_FTM0FLT0.
#define BM_SIM_SOPT4_FTM0FLT0 (0x00000001U) //!< Bit mask for SIM_SOPT4_FTM0FLT0.
#define BS_SIM_SOPT4_FTM0FLT0 (1U)         //!< Bit field size in bits for SIM_SOPT4_FTM0FLT0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT4_FTM0FLT0 field.
#define BR_SIM_SOPT4_FTM0FLT0 (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM0FLT0))
#endif

//! @brief Format value for bitfield SIM_SOPT4_FTM0FLT0.
#define BF_SIM_SOPT4_FTM0FLT0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT4_FTM0FLT0), uint32_t) & BM_SIM_SOPT4_FTM0FLT0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM0FLT0 field to a new value.
#define BW_SIM_SOPT4_FTM0FLT0(v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM0FLT0) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT4, field FTM0FLT1[1] (RW)
 *
 * Selects the source of FTM0 fault 1. The pin source for fault 1 must be
 * configured for the FTM module fault function through the appropriate pin control
 * register in the port control module.
 *
 * Values:
 * - 0 - FTM0_FLT1 pin
 * - 1 - CMP1 out
 */
//@{
#define BP_SIM_SOPT4_FTM0FLT1 (1U)         //!< Bit position for SIM_SOPT4_FTM0FLT1.
#define BM_SIM_SOPT4_FTM0FLT1 (0x00000002U) //!< Bit mask for SIM_SOPT4_FTM0FLT1.
#define BS_SIM_SOPT4_FTM0FLT1 (1U)         //!< Bit field size in bits for SIM_SOPT4_FTM0FLT1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT4_FTM0FLT1 field.
#define BR_SIM_SOPT4_FTM0FLT1 (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM0FLT1))
#endif

//! @brief Format value for bitfield SIM_SOPT4_FTM0FLT1.
#define BF_SIM_SOPT4_FTM0FLT1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT4_FTM0FLT1), uint32_t) & BM_SIM_SOPT4_FTM0FLT1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM0FLT1 field to a new value.
#define BW_SIM_SOPT4_FTM0FLT1(v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM0FLT1) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT4, field FTM0FLT2[2] (RW)
 *
 * Selects the source of FTM0 fault 2. The pin source for fault 2 must be
 * configured for the FTM module fault function through the appropriate pin control
 * register in the port control module.
 *
 * Values:
 * - 0 - FTM0_FLT2 pin
 * - 1 - CMP2 out
 */
//@{
#define BP_SIM_SOPT4_FTM0FLT2 (2U)         //!< Bit position for SIM_SOPT4_FTM0FLT2.
#define BM_SIM_SOPT4_FTM0FLT2 (0x00000004U) //!< Bit mask for SIM_SOPT4_FTM0FLT2.
#define BS_SIM_SOPT4_FTM0FLT2 (1U)         //!< Bit field size in bits for SIM_SOPT4_FTM0FLT2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT4_FTM0FLT2 field.
#define BR_SIM_SOPT4_FTM0FLT2 (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM0FLT2))
#endif

//! @brief Format value for bitfield SIM_SOPT4_FTM0FLT2.
#define BF_SIM_SOPT4_FTM0FLT2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT4_FTM0FLT2), uint32_t) & BM_SIM_SOPT4_FTM0FLT2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM0FLT2 field to a new value.
#define BW_SIM_SOPT4_FTM0FLT2(v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM0FLT2) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT4, field FTM1FLT0[4] (RW)
 *
 * Selects the source of FTM1 fault 0. The pin source for fault 0 must be
 * configured for the FTM module fault function through the appropriate pin control
 * register in the port control module.
 *
 * Values:
 * - 0 - FTM1_FLT0 pin
 * - 1 - CMP0 out
 */
//@{
#define BP_SIM_SOPT4_FTM1FLT0 (4U)         //!< Bit position for SIM_SOPT4_FTM1FLT0.
#define BM_SIM_SOPT4_FTM1FLT0 (0x00000010U) //!< Bit mask for SIM_SOPT4_FTM1FLT0.
#define BS_SIM_SOPT4_FTM1FLT0 (1U)         //!< Bit field size in bits for SIM_SOPT4_FTM1FLT0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT4_FTM1FLT0 field.
#define BR_SIM_SOPT4_FTM1FLT0 (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM1FLT0))
#endif

//! @brief Format value for bitfield SIM_SOPT4_FTM1FLT0.
#define BF_SIM_SOPT4_FTM1FLT0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT4_FTM1FLT0), uint32_t) & BM_SIM_SOPT4_FTM1FLT0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM1FLT0 field to a new value.
#define BW_SIM_SOPT4_FTM1FLT0(v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM1FLT0) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT4, field FTM2FLT0[8] (RW)
 *
 * Selects the source of FTM2 fault 0. The pin source for fault 0 must be
 * configured for the FTM module fault function through the appropriate PORTx pin
 * control register.
 *
 * Values:
 * - 0 - FTM2_FLT0 pin
 * - 1 - CMP0 out
 */
//@{
#define BP_SIM_SOPT4_FTM2FLT0 (8U)         //!< Bit position for SIM_SOPT4_FTM2FLT0.
#define BM_SIM_SOPT4_FTM2FLT0 (0x00000100U) //!< Bit mask for SIM_SOPT4_FTM2FLT0.
#define BS_SIM_SOPT4_FTM2FLT0 (1U)         //!< Bit field size in bits for SIM_SOPT4_FTM2FLT0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT4_FTM2FLT0 field.
#define BR_SIM_SOPT4_FTM2FLT0 (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM2FLT0))
#endif

//! @brief Format value for bitfield SIM_SOPT4_FTM2FLT0.
#define BF_SIM_SOPT4_FTM2FLT0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT4_FTM2FLT0), uint32_t) & BM_SIM_SOPT4_FTM2FLT0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM2FLT0 field to a new value.
#define BW_SIM_SOPT4_FTM2FLT0(v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM2FLT0) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT4, field FTM3FLT0[12] (RW)
 *
 * Selects the source of FTM3 fault 0. The pin source for fault 0 must be
 * configured for the FTM module fault function through the appropriate PORTx pin
 * control register.
 *
 * Values:
 * - 0 - FTM3_FLT0 pin
 * - 1 - CMP0 out
 */
//@{
#define BP_SIM_SOPT4_FTM3FLT0 (12U)        //!< Bit position for SIM_SOPT4_FTM3FLT0.
#define BM_SIM_SOPT4_FTM3FLT0 (0x00001000U) //!< Bit mask for SIM_SOPT4_FTM3FLT0.
#define BS_SIM_SOPT4_FTM3FLT0 (1U)         //!< Bit field size in bits for SIM_SOPT4_FTM3FLT0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT4_FTM3FLT0 field.
#define BR_SIM_SOPT4_FTM3FLT0 (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM3FLT0))
#endif

//! @brief Format value for bitfield SIM_SOPT4_FTM3FLT0.
#define BF_SIM_SOPT4_FTM3FLT0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT4_FTM3FLT0), uint32_t) & BM_SIM_SOPT4_FTM3FLT0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM3FLT0 field to a new value.
#define BW_SIM_SOPT4_FTM3FLT0(v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM3FLT0) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT4, field FTM1CH0SRC[19:18] (RW)
 *
 * Selects the source for FTM1 channel 0 input capture. When the FTM is not in
 * input capture mode, clear this field.
 *
 * Values:
 * - 00 - FTM1_CH0 signal
 * - 01 - CMP0 output
 * - 10 - CMP1 output
 * - 11 - USB start of frame pulse
 */
//@{
#define BP_SIM_SOPT4_FTM1CH0SRC (18U)      //!< Bit position for SIM_SOPT4_FTM1CH0SRC.
#define BM_SIM_SOPT4_FTM1CH0SRC (0x000C0000U) //!< Bit mask for SIM_SOPT4_FTM1CH0SRC.
#define BS_SIM_SOPT4_FTM1CH0SRC (2U)       //!< Bit field size in bits for SIM_SOPT4_FTM1CH0SRC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT4_FTM1CH0SRC field.
#define BR_SIM_SOPT4_FTM1CH0SRC (HW_SIM_SOPT4.B.FTM1CH0SRC)
#endif

//! @brief Format value for bitfield SIM_SOPT4_FTM1CH0SRC.
#define BF_SIM_SOPT4_FTM1CH0SRC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT4_FTM1CH0SRC), uint32_t) & BM_SIM_SOPT4_FTM1CH0SRC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM1CH0SRC field to a new value.
#define BW_SIM_SOPT4_FTM1CH0SRC(v) (HW_SIM_SOPT4_WR((HW_SIM_SOPT4_RD() & ~BM_SIM_SOPT4_FTM1CH0SRC) | BF_SIM_SOPT4_FTM1CH0SRC(v)))
#endif
//@}

/*!
 * @name Register SIM_SOPT4, field FTM2CH0SRC[21:20] (RW)
 *
 * Selects the source for FTM2 channel 0 input capture. When the FTM is not in
 * input capture mode, clear this field.
 *
 * Values:
 * - 00 - FTM2_CH0 signal
 * - 01 - CMP0 output
 * - 10 - CMP1 output
 * - 11 - Reserved
 */
//@{
#define BP_SIM_SOPT4_FTM2CH0SRC (20U)      //!< Bit position for SIM_SOPT4_FTM2CH0SRC.
#define BM_SIM_SOPT4_FTM2CH0SRC (0x00300000U) //!< Bit mask for SIM_SOPT4_FTM2CH0SRC.
#define BS_SIM_SOPT4_FTM2CH0SRC (2U)       //!< Bit field size in bits for SIM_SOPT4_FTM2CH0SRC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT4_FTM2CH0SRC field.
#define BR_SIM_SOPT4_FTM2CH0SRC (HW_SIM_SOPT4.B.FTM2CH0SRC)
#endif

//! @brief Format value for bitfield SIM_SOPT4_FTM2CH0SRC.
#define BF_SIM_SOPT4_FTM2CH0SRC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT4_FTM2CH0SRC), uint32_t) & BM_SIM_SOPT4_FTM2CH0SRC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM2CH0SRC field to a new value.
#define BW_SIM_SOPT4_FTM2CH0SRC(v) (HW_SIM_SOPT4_WR((HW_SIM_SOPT4_RD() & ~BM_SIM_SOPT4_FTM2CH0SRC) | BF_SIM_SOPT4_FTM2CH0SRC(v)))
#endif
//@}

/*!
 * @name Register SIM_SOPT4, field FTM0CLKSEL[24] (RW)
 *
 * Selects the external pin used to drive the clock to the FTM0 module. The
 * selected pin must also be configured for the FTM external clock function through
 * the appropriate pin control register in the port control module.
 *
 * Values:
 * - 0 - FTM_CLK0 pin
 * - 1 - FTM_CLK1 pin
 */
//@{
#define BP_SIM_SOPT4_FTM0CLKSEL (24U)      //!< Bit position for SIM_SOPT4_FTM0CLKSEL.
#define BM_SIM_SOPT4_FTM0CLKSEL (0x01000000U) //!< Bit mask for SIM_SOPT4_FTM0CLKSEL.
#define BS_SIM_SOPT4_FTM0CLKSEL (1U)       //!< Bit field size in bits for SIM_SOPT4_FTM0CLKSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT4_FTM0CLKSEL field.
#define BR_SIM_SOPT4_FTM0CLKSEL (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM0CLKSEL))
#endif

//! @brief Format value for bitfield SIM_SOPT4_FTM0CLKSEL.
#define BF_SIM_SOPT4_FTM0CLKSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT4_FTM0CLKSEL), uint32_t) & BM_SIM_SOPT4_FTM0CLKSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM0CLKSEL field to a new value.
#define BW_SIM_SOPT4_FTM0CLKSEL(v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM0CLKSEL) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT4, field FTM1CLKSEL[25] (RW)
 *
 * Selects the external pin used to drive the clock to the FTM1 module. The
 * selected pin must also be configured for the FTM external clock function through
 * the appropriate pin control register in the port control module.
 *
 * Values:
 * - 0 - FTM_CLK0 pin
 * - 1 - FTM_CLK1 pin
 */
//@{
#define BP_SIM_SOPT4_FTM1CLKSEL (25U)      //!< Bit position for SIM_SOPT4_FTM1CLKSEL.
#define BM_SIM_SOPT4_FTM1CLKSEL (0x02000000U) //!< Bit mask for SIM_SOPT4_FTM1CLKSEL.
#define BS_SIM_SOPT4_FTM1CLKSEL (1U)       //!< Bit field size in bits for SIM_SOPT4_FTM1CLKSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT4_FTM1CLKSEL field.
#define BR_SIM_SOPT4_FTM1CLKSEL (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM1CLKSEL))
#endif

//! @brief Format value for bitfield SIM_SOPT4_FTM1CLKSEL.
#define BF_SIM_SOPT4_FTM1CLKSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT4_FTM1CLKSEL), uint32_t) & BM_SIM_SOPT4_FTM1CLKSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM1CLKSEL field to a new value.
#define BW_SIM_SOPT4_FTM1CLKSEL(v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM1CLKSEL) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT4, field FTM2CLKSEL[26] (RW)
 *
 * Selects the external pin used to drive the clock to the FTM2 module. The
 * selected pin must also be configured for the FTM2 module external clock function
 * through the appropriate pin control register in the port control module.
 *
 * Values:
 * - 0 - FTM2 external clock driven by FTM_CLK0 pin.
 * - 1 - FTM2 external clock driven by FTM_CLK1 pin.
 */
//@{
#define BP_SIM_SOPT4_FTM2CLKSEL (26U)      //!< Bit position for SIM_SOPT4_FTM2CLKSEL.
#define BM_SIM_SOPT4_FTM2CLKSEL (0x04000000U) //!< Bit mask for SIM_SOPT4_FTM2CLKSEL.
#define BS_SIM_SOPT4_FTM2CLKSEL (1U)       //!< Bit field size in bits for SIM_SOPT4_FTM2CLKSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT4_FTM2CLKSEL field.
#define BR_SIM_SOPT4_FTM2CLKSEL (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM2CLKSEL))
#endif

//! @brief Format value for bitfield SIM_SOPT4_FTM2CLKSEL.
#define BF_SIM_SOPT4_FTM2CLKSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT4_FTM2CLKSEL), uint32_t) & BM_SIM_SOPT4_FTM2CLKSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM2CLKSEL field to a new value.
#define BW_SIM_SOPT4_FTM2CLKSEL(v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM2CLKSEL) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT4, field FTM3CLKSEL[27] (RW)
 *
 * Selects the external pin used to drive the clock to the FTM3 module. The
 * selected pin must also be configured for the FTM3 module external clock function
 * through the appropriate pin control register in the port control module.
 *
 * Values:
 * - 0 - FTM3 external clock driven by FTM_CLK0 pin.
 * - 1 - FTM3 external clock driven by FTM_CLK1 pin.
 */
//@{
#define BP_SIM_SOPT4_FTM3CLKSEL (27U)      //!< Bit position for SIM_SOPT4_FTM3CLKSEL.
#define BM_SIM_SOPT4_FTM3CLKSEL (0x08000000U) //!< Bit mask for SIM_SOPT4_FTM3CLKSEL.
#define BS_SIM_SOPT4_FTM3CLKSEL (1U)       //!< Bit field size in bits for SIM_SOPT4_FTM3CLKSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT4_FTM3CLKSEL field.
#define BR_SIM_SOPT4_FTM3CLKSEL (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM3CLKSEL))
#endif

//! @brief Format value for bitfield SIM_SOPT4_FTM3CLKSEL.
#define BF_SIM_SOPT4_FTM3CLKSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT4_FTM3CLKSEL), uint32_t) & BM_SIM_SOPT4_FTM3CLKSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM3CLKSEL field to a new value.
#define BW_SIM_SOPT4_FTM3CLKSEL(v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM3CLKSEL) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT4, field FTM0TRG0SRC[28] (RW)
 *
 * Selects the source of FTM0 hardware trigger 0.
 *
 * Values:
 * - 0 - HSCMP0 output drives FTM0 hardware trigger 0
 * - 1 - FTM1 channel match drives FTM0 hardware trigger 0
 */
//@{
#define BP_SIM_SOPT4_FTM0TRG0SRC (28U)     //!< Bit position for SIM_SOPT4_FTM0TRG0SRC.
#define BM_SIM_SOPT4_FTM0TRG0SRC (0x10000000U) //!< Bit mask for SIM_SOPT4_FTM0TRG0SRC.
#define BS_SIM_SOPT4_FTM0TRG0SRC (1U)      //!< Bit field size in bits for SIM_SOPT4_FTM0TRG0SRC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT4_FTM0TRG0SRC field.
#define BR_SIM_SOPT4_FTM0TRG0SRC (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM0TRG0SRC))
#endif

//! @brief Format value for bitfield SIM_SOPT4_FTM0TRG0SRC.
#define BF_SIM_SOPT4_FTM0TRG0SRC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT4_FTM0TRG0SRC), uint32_t) & BM_SIM_SOPT4_FTM0TRG0SRC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM0TRG0SRC field to a new value.
#define BW_SIM_SOPT4_FTM0TRG0SRC(v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM0TRG0SRC) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT4, field FTM0TRG1SRC[29] (RW)
 *
 * Selects the source of FTM0 hardware trigger 1.
 *
 * Values:
 * - 0 - PDB output trigger 1 drives FTM0 hardware trigger 1
 * - 1 - FTM2 channel match drives FTM0 hardware trigger 1
 */
//@{
#define BP_SIM_SOPT4_FTM0TRG1SRC (29U)     //!< Bit position for SIM_SOPT4_FTM0TRG1SRC.
#define BM_SIM_SOPT4_FTM0TRG1SRC (0x20000000U) //!< Bit mask for SIM_SOPT4_FTM0TRG1SRC.
#define BS_SIM_SOPT4_FTM0TRG1SRC (1U)      //!< Bit field size in bits for SIM_SOPT4_FTM0TRG1SRC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT4_FTM0TRG1SRC field.
#define BR_SIM_SOPT4_FTM0TRG1SRC (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM0TRG1SRC))
#endif

//! @brief Format value for bitfield SIM_SOPT4_FTM0TRG1SRC.
#define BF_SIM_SOPT4_FTM0TRG1SRC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT4_FTM0TRG1SRC), uint32_t) & BM_SIM_SOPT4_FTM0TRG1SRC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM0TRG1SRC field to a new value.
#define BW_SIM_SOPT4_FTM0TRG1SRC(v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM0TRG1SRC) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT4, field FTM3TRG0SRC[30] (RW)
 *
 * Selects the source of FTM3 hardware trigger 0.
 *
 * Values:
 * - 0 - Reserved
 * - 1 - FTM1 channel match drives FTM3 hardware trigger 0
 */
//@{
#define BP_SIM_SOPT4_FTM3TRG0SRC (30U)     //!< Bit position for SIM_SOPT4_FTM3TRG0SRC.
#define BM_SIM_SOPT4_FTM3TRG0SRC (0x40000000U) //!< Bit mask for SIM_SOPT4_FTM3TRG0SRC.
#define BS_SIM_SOPT4_FTM3TRG0SRC (1U)      //!< Bit field size in bits for SIM_SOPT4_FTM3TRG0SRC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT4_FTM3TRG0SRC field.
#define BR_SIM_SOPT4_FTM3TRG0SRC (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM3TRG0SRC))
#endif

//! @brief Format value for bitfield SIM_SOPT4_FTM3TRG0SRC.
#define BF_SIM_SOPT4_FTM3TRG0SRC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT4_FTM3TRG0SRC), uint32_t) & BM_SIM_SOPT4_FTM3TRG0SRC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM3TRG0SRC field to a new value.
#define BW_SIM_SOPT4_FTM3TRG0SRC(v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM3TRG0SRC) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT4, field FTM3TRG1SRC[31] (RW)
 *
 * Selects the source of FTM3 hardware trigger 1.
 *
 * Values:
 * - 0 - Reserved
 * - 1 - FTM2 channel match drives FTM3 hardware trigger 1
 */
//@{
#define BP_SIM_SOPT4_FTM3TRG1SRC (31U)     //!< Bit position for SIM_SOPT4_FTM3TRG1SRC.
#define BM_SIM_SOPT4_FTM3TRG1SRC (0x80000000U) //!< Bit mask for SIM_SOPT4_FTM3TRG1SRC.
#define BS_SIM_SOPT4_FTM3TRG1SRC (1U)      //!< Bit field size in bits for SIM_SOPT4_FTM3TRG1SRC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT4_FTM3TRG1SRC field.
#define BR_SIM_SOPT4_FTM3TRG1SRC (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM3TRG1SRC))
#endif

//! @brief Format value for bitfield SIM_SOPT4_FTM3TRG1SRC.
#define BF_SIM_SOPT4_FTM3TRG1SRC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT4_FTM3TRG1SRC), uint32_t) & BM_SIM_SOPT4_FTM3TRG1SRC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM3TRG1SRC field to a new value.
#define BW_SIM_SOPT4_FTM3TRG1SRC(v) (BITBAND_ACCESS32(HW_SIM_SOPT4_ADDR, BP_SIM_SOPT4_FTM3TRG1SRC) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_SOPT5 - System Options Register 5
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_SOPT5 - System Options Register 5 (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_sim_sopt5
{
    uint32_t U;
    struct _hw_sim_sopt5_bitfields
    {
        uint32_t UART0TXSRC : 2;       //!< [1:0] UART 0 transmit data source select
        uint32_t UART0RXSRC : 2;       //!< [3:2] UART 0 receive data source select
        uint32_t UART1TXSRC : 2;       //!< [5:4] UART 1 transmit data source select
        uint32_t UART1RXSRC : 2;       //!< [7:6] UART 1 receive data source select
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_sim_sopt5_t;
#endif

/*!
 * @name Constants and macros for entire SIM_SOPT5 register
 */
//@{
#define HW_SIM_SOPT5_ADDR        (REGS_SIM_BASE + 0x1010U)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_SOPT5             (*(__IO hw_sim_sopt5_t *) HW_SIM_SOPT5_ADDR)
#define HW_SIM_SOPT5_RD()        (HW_SIM_SOPT5.U)
#define HW_SIM_SOPT5_WR(v)       (HW_SIM_SOPT5.U = (v))
#define HW_SIM_SOPT5_SET(v)      (HW_SIM_SOPT5_WR(HW_SIM_SOPT5_RD() |  (v)))
#define HW_SIM_SOPT5_CLR(v)      (HW_SIM_SOPT5_WR(HW_SIM_SOPT5_RD() & ~(v)))
#define HW_SIM_SOPT5_TOG(v)      (HW_SIM_SOPT5_WR(HW_SIM_SOPT5_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SIM_SOPT5 bitfields
 */

/*!
 * @name Register SIM_SOPT5, field UART0TXSRC[1:0] (RW)
 *
 * Selects the source for the UART 0 transmit data.
 *
 * Values:
 * - 00 - UART0_TX pin
 * - 01 - UART0_TX pin modulated with FTM1 channel 0 output
 * - 10 - UART0_TX pin modulated with FTM2 channel 0 output
 * - 11 - Reserved
 */
//@{
#define BP_SIM_SOPT5_UART0TXSRC (0U)       //!< Bit position for SIM_SOPT5_UART0TXSRC.
#define BM_SIM_SOPT5_UART0TXSRC (0x00000003U) //!< Bit mask for SIM_SOPT5_UART0TXSRC.
#define BS_SIM_SOPT5_UART0TXSRC (2U)       //!< Bit field size in bits for SIM_SOPT5_UART0TXSRC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT5_UART0TXSRC field.
#define BR_SIM_SOPT5_UART0TXSRC (HW_SIM_SOPT5.B.UART0TXSRC)
#endif

//! @brief Format value for bitfield SIM_SOPT5_UART0TXSRC.
#define BF_SIM_SOPT5_UART0TXSRC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT5_UART0TXSRC), uint32_t) & BM_SIM_SOPT5_UART0TXSRC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the UART0TXSRC field to a new value.
#define BW_SIM_SOPT5_UART0TXSRC(v) (HW_SIM_SOPT5_WR((HW_SIM_SOPT5_RD() & ~BM_SIM_SOPT5_UART0TXSRC) | BF_SIM_SOPT5_UART0TXSRC(v)))
#endif
//@}

/*!
 * @name Register SIM_SOPT5, field UART0RXSRC[3:2] (RW)
 *
 * Selects the source for the UART 0 receive data.
 *
 * Values:
 * - 00 - UART0_RX pin
 * - 01 - CMP0
 * - 10 - CMP1
 * - 11 - Reserved
 */
//@{
#define BP_SIM_SOPT5_UART0RXSRC (2U)       //!< Bit position for SIM_SOPT5_UART0RXSRC.
#define BM_SIM_SOPT5_UART0RXSRC (0x0000000CU) //!< Bit mask for SIM_SOPT5_UART0RXSRC.
#define BS_SIM_SOPT5_UART0RXSRC (2U)       //!< Bit field size in bits for SIM_SOPT5_UART0RXSRC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT5_UART0RXSRC field.
#define BR_SIM_SOPT5_UART0RXSRC (HW_SIM_SOPT5.B.UART0RXSRC)
#endif

//! @brief Format value for bitfield SIM_SOPT5_UART0RXSRC.
#define BF_SIM_SOPT5_UART0RXSRC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT5_UART0RXSRC), uint32_t) & BM_SIM_SOPT5_UART0RXSRC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the UART0RXSRC field to a new value.
#define BW_SIM_SOPT5_UART0RXSRC(v) (HW_SIM_SOPT5_WR((HW_SIM_SOPT5_RD() & ~BM_SIM_SOPT5_UART0RXSRC) | BF_SIM_SOPT5_UART0RXSRC(v)))
#endif
//@}

/*!
 * @name Register SIM_SOPT5, field UART1TXSRC[5:4] (RW)
 *
 * Selects the source for the UART 1 transmit data.
 *
 * Values:
 * - 00 - UART1_TX pin
 * - 01 - UART1_TX pin modulated with FTM1 channel 0 output
 * - 10 - UART1_TX pin modulated with FTM2 channel 0 output
 * - 11 - Reserved
 */
//@{
#define BP_SIM_SOPT5_UART1TXSRC (4U)       //!< Bit position for SIM_SOPT5_UART1TXSRC.
#define BM_SIM_SOPT5_UART1TXSRC (0x00000030U) //!< Bit mask for SIM_SOPT5_UART1TXSRC.
#define BS_SIM_SOPT5_UART1TXSRC (2U)       //!< Bit field size in bits for SIM_SOPT5_UART1TXSRC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT5_UART1TXSRC field.
#define BR_SIM_SOPT5_UART1TXSRC (HW_SIM_SOPT5.B.UART1TXSRC)
#endif

//! @brief Format value for bitfield SIM_SOPT5_UART1TXSRC.
#define BF_SIM_SOPT5_UART1TXSRC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT5_UART1TXSRC), uint32_t) & BM_SIM_SOPT5_UART1TXSRC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the UART1TXSRC field to a new value.
#define BW_SIM_SOPT5_UART1TXSRC(v) (HW_SIM_SOPT5_WR((HW_SIM_SOPT5_RD() & ~BM_SIM_SOPT5_UART1TXSRC) | BF_SIM_SOPT5_UART1TXSRC(v)))
#endif
//@}

/*!
 * @name Register SIM_SOPT5, field UART1RXSRC[7:6] (RW)
 *
 * Selects the source for the UART 1 receive data.
 *
 * Values:
 * - 00 - UART1_RX pin
 * - 01 - CMP0
 * - 10 - CMP1
 * - 11 - Reserved
 */
//@{
#define BP_SIM_SOPT5_UART1RXSRC (6U)       //!< Bit position for SIM_SOPT5_UART1RXSRC.
#define BM_SIM_SOPT5_UART1RXSRC (0x000000C0U) //!< Bit mask for SIM_SOPT5_UART1RXSRC.
#define BS_SIM_SOPT5_UART1RXSRC (2U)       //!< Bit field size in bits for SIM_SOPT5_UART1RXSRC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT5_UART1RXSRC field.
#define BR_SIM_SOPT5_UART1RXSRC (HW_SIM_SOPT5.B.UART1RXSRC)
#endif

//! @brief Format value for bitfield SIM_SOPT5_UART1RXSRC.
#define BF_SIM_SOPT5_UART1RXSRC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT5_UART1RXSRC), uint32_t) & BM_SIM_SOPT5_UART1RXSRC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the UART1RXSRC field to a new value.
#define BW_SIM_SOPT5_UART1RXSRC(v) (HW_SIM_SOPT5_WR((HW_SIM_SOPT5_RD() & ~BM_SIM_SOPT5_UART1RXSRC) | BF_SIM_SOPT5_UART1RXSRC(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_SOPT7 - System Options Register 7
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_SOPT7 - System Options Register 7 (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_sim_sopt7
{
    uint32_t U;
    struct _hw_sim_sopt7_bitfields
    {
        uint32_t ADC0TRGSEL : 4;       //!< [3:0] ADC0 trigger select
        uint32_t ADC0PRETRGSEL : 1;    //!< [4] ADC0 pretrigger select
        uint32_t RESERVED0 : 2;        //!< [6:5]
        uint32_t ADC0ALTTRGEN : 1;     //!< [7] ADC0 alternate trigger enable
        uint32_t ADC1TRGSEL : 4;       //!< [11:8] ADC1 trigger select
        uint32_t ADC1PRETRGSEL : 1;    //!< [12] ADC1 pre-trigger select
        uint32_t RESERVED1 : 2;        //!< [14:13]
        uint32_t ADC1ALTTRGEN : 1;     //!< [15] ADC1 alternate trigger enable
        uint32_t RESERVED2 : 16;       //!< [31:16]
    } B;
} hw_sim_sopt7_t;
#endif

/*!
 * @name Constants and macros for entire SIM_SOPT7 register
 */
//@{
#define HW_SIM_SOPT7_ADDR        (REGS_SIM_BASE + 0x1018U)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_SOPT7             (*(__IO hw_sim_sopt7_t *) HW_SIM_SOPT7_ADDR)
#define HW_SIM_SOPT7_RD()        (HW_SIM_SOPT7.U)
#define HW_SIM_SOPT7_WR(v)       (HW_SIM_SOPT7.U = (v))
#define HW_SIM_SOPT7_SET(v)      (HW_SIM_SOPT7_WR(HW_SIM_SOPT7_RD() |  (v)))
#define HW_SIM_SOPT7_CLR(v)      (HW_SIM_SOPT7_WR(HW_SIM_SOPT7_RD() & ~(v)))
#define HW_SIM_SOPT7_TOG(v)      (HW_SIM_SOPT7_WR(HW_SIM_SOPT7_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SIM_SOPT7 bitfields
 */

/*!
 * @name Register SIM_SOPT7, field ADC0TRGSEL[3:0] (RW)
 *
 * Selects the ADC0 trigger source when alternative triggers are functional in
 * stop and VLPS modes. .
 *
 * Values:
 * - 0000 - PDB external trigger pin input (PDB0_EXTRG)
 * - 0001 - High speed comparator 0 output
 * - 0010 - High speed comparator 1 output
 * - 0011 - High speed comparator 2 output
 * - 0100 - PIT trigger 0
 * - 0101 - PIT trigger 1
 * - 0110 - PIT trigger 2
 * - 0111 - PIT trigger 3
 * - 1000 - FTM0 trigger
 * - 1001 - FTM1 trigger
 * - 1010 - FTM2 trigger
 * - 1011 - FTM3 trigger
 * - 1100 - RTC alarm
 * - 1101 - RTC seconds
 * - 1110 - Low-power timer (LPTMR) trigger
 * - 1111 - Reserved
 */
//@{
#define BP_SIM_SOPT7_ADC0TRGSEL (0U)       //!< Bit position for SIM_SOPT7_ADC0TRGSEL.
#define BM_SIM_SOPT7_ADC0TRGSEL (0x0000000FU) //!< Bit mask for SIM_SOPT7_ADC0TRGSEL.
#define BS_SIM_SOPT7_ADC0TRGSEL (4U)       //!< Bit field size in bits for SIM_SOPT7_ADC0TRGSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT7_ADC0TRGSEL field.
#define BR_SIM_SOPT7_ADC0TRGSEL (HW_SIM_SOPT7.B.ADC0TRGSEL)
#endif

//! @brief Format value for bitfield SIM_SOPT7_ADC0TRGSEL.
#define BF_SIM_SOPT7_ADC0TRGSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT7_ADC0TRGSEL), uint32_t) & BM_SIM_SOPT7_ADC0TRGSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADC0TRGSEL field to a new value.
#define BW_SIM_SOPT7_ADC0TRGSEL(v) (HW_SIM_SOPT7_WR((HW_SIM_SOPT7_RD() & ~BM_SIM_SOPT7_ADC0TRGSEL) | BF_SIM_SOPT7_ADC0TRGSEL(v)))
#endif
//@}

/*!
 * @name Register SIM_SOPT7, field ADC0PRETRGSEL[4] (RW)
 *
 * Selects the ADC0 pre-trigger source when alternative triggers are enabled
 * through ADC0ALTTRGEN.
 *
 * Values:
 * - 0 - Pre-trigger A
 * - 1 - Pre-trigger B
 */
//@{
#define BP_SIM_SOPT7_ADC0PRETRGSEL (4U)    //!< Bit position for SIM_SOPT7_ADC0PRETRGSEL.
#define BM_SIM_SOPT7_ADC0PRETRGSEL (0x00000010U) //!< Bit mask for SIM_SOPT7_ADC0PRETRGSEL.
#define BS_SIM_SOPT7_ADC0PRETRGSEL (1U)    //!< Bit field size in bits for SIM_SOPT7_ADC0PRETRGSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT7_ADC0PRETRGSEL field.
#define BR_SIM_SOPT7_ADC0PRETRGSEL (BITBAND_ACCESS32(HW_SIM_SOPT7_ADDR, BP_SIM_SOPT7_ADC0PRETRGSEL))
#endif

//! @brief Format value for bitfield SIM_SOPT7_ADC0PRETRGSEL.
#define BF_SIM_SOPT7_ADC0PRETRGSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT7_ADC0PRETRGSEL), uint32_t) & BM_SIM_SOPT7_ADC0PRETRGSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADC0PRETRGSEL field to a new value.
#define BW_SIM_SOPT7_ADC0PRETRGSEL(v) (BITBAND_ACCESS32(HW_SIM_SOPT7_ADDR, BP_SIM_SOPT7_ADC0PRETRGSEL) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT7, field ADC0ALTTRGEN[7] (RW)
 *
 * Enable alternative conversion triggers for ADC0.
 *
 * Values:
 * - 0 - PDB trigger selected for ADC0.
 * - 1 - Alternate trigger selected for ADC0.
 */
//@{
#define BP_SIM_SOPT7_ADC0ALTTRGEN (7U)     //!< Bit position for SIM_SOPT7_ADC0ALTTRGEN.
#define BM_SIM_SOPT7_ADC0ALTTRGEN (0x00000080U) //!< Bit mask for SIM_SOPT7_ADC0ALTTRGEN.
#define BS_SIM_SOPT7_ADC0ALTTRGEN (1U)     //!< Bit field size in bits for SIM_SOPT7_ADC0ALTTRGEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT7_ADC0ALTTRGEN field.
#define BR_SIM_SOPT7_ADC0ALTTRGEN (BITBAND_ACCESS32(HW_SIM_SOPT7_ADDR, BP_SIM_SOPT7_ADC0ALTTRGEN))
#endif

//! @brief Format value for bitfield SIM_SOPT7_ADC0ALTTRGEN.
#define BF_SIM_SOPT7_ADC0ALTTRGEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT7_ADC0ALTTRGEN), uint32_t) & BM_SIM_SOPT7_ADC0ALTTRGEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADC0ALTTRGEN field to a new value.
#define BW_SIM_SOPT7_ADC0ALTTRGEN(v) (BITBAND_ACCESS32(HW_SIM_SOPT7_ADDR, BP_SIM_SOPT7_ADC0ALTTRGEN) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT7, field ADC1TRGSEL[11:8] (RW)
 *
 * Selects the ADC1 trigger source when alternative triggers are functional in
 * stop and VLPS modes.
 *
 * Values:
 * - 0000 - PDB external trigger pin input (PDB0_EXTRG)
 * - 0001 - High speed comparator 0 output
 * - 0010 - High speed comparator 1 output
 * - 0011 - High speed comparator 2 output
 * - 0100 - PIT trigger 0
 * - 0101 - PIT trigger 1
 * - 0110 - PIT trigger 2
 * - 0111 - PIT trigger 3
 * - 1000 - FTM0 trigger
 * - 1001 - FTM1 trigger
 * - 1010 - FTM2 trigger
 * - 1011 - FTM3 trigger
 * - 1100 - RTC alarm
 * - 1101 - RTC seconds
 * - 1110 - Low-power timer (LPTMR) trigger
 * - 1111 - Reserved
 */
//@{
#define BP_SIM_SOPT7_ADC1TRGSEL (8U)       //!< Bit position for SIM_SOPT7_ADC1TRGSEL.
#define BM_SIM_SOPT7_ADC1TRGSEL (0x00000F00U) //!< Bit mask for SIM_SOPT7_ADC1TRGSEL.
#define BS_SIM_SOPT7_ADC1TRGSEL (4U)       //!< Bit field size in bits for SIM_SOPT7_ADC1TRGSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT7_ADC1TRGSEL field.
#define BR_SIM_SOPT7_ADC1TRGSEL (HW_SIM_SOPT7.B.ADC1TRGSEL)
#endif

//! @brief Format value for bitfield SIM_SOPT7_ADC1TRGSEL.
#define BF_SIM_SOPT7_ADC1TRGSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT7_ADC1TRGSEL), uint32_t) & BM_SIM_SOPT7_ADC1TRGSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADC1TRGSEL field to a new value.
#define BW_SIM_SOPT7_ADC1TRGSEL(v) (HW_SIM_SOPT7_WR((HW_SIM_SOPT7_RD() & ~BM_SIM_SOPT7_ADC1TRGSEL) | BF_SIM_SOPT7_ADC1TRGSEL(v)))
#endif
//@}

/*!
 * @name Register SIM_SOPT7, field ADC1PRETRGSEL[12] (RW)
 *
 * Selects the ADC1 pre-trigger source when alternative triggers are enabled
 * through ADC1ALTTRGEN.
 *
 * Values:
 * - 0 - Pre-trigger A selected for ADC1.
 * - 1 - Pre-trigger B selected for ADC1.
 */
//@{
#define BP_SIM_SOPT7_ADC1PRETRGSEL (12U)   //!< Bit position for SIM_SOPT7_ADC1PRETRGSEL.
#define BM_SIM_SOPT7_ADC1PRETRGSEL (0x00001000U) //!< Bit mask for SIM_SOPT7_ADC1PRETRGSEL.
#define BS_SIM_SOPT7_ADC1PRETRGSEL (1U)    //!< Bit field size in bits for SIM_SOPT7_ADC1PRETRGSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT7_ADC1PRETRGSEL field.
#define BR_SIM_SOPT7_ADC1PRETRGSEL (BITBAND_ACCESS32(HW_SIM_SOPT7_ADDR, BP_SIM_SOPT7_ADC1PRETRGSEL))
#endif

//! @brief Format value for bitfield SIM_SOPT7_ADC1PRETRGSEL.
#define BF_SIM_SOPT7_ADC1PRETRGSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT7_ADC1PRETRGSEL), uint32_t) & BM_SIM_SOPT7_ADC1PRETRGSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADC1PRETRGSEL field to a new value.
#define BW_SIM_SOPT7_ADC1PRETRGSEL(v) (BITBAND_ACCESS32(HW_SIM_SOPT7_ADDR, BP_SIM_SOPT7_ADC1PRETRGSEL) = (v))
#endif
//@}

/*!
 * @name Register SIM_SOPT7, field ADC1ALTTRGEN[15] (RW)
 *
 * Enable alternative conversion triggers for ADC1.
 *
 * Values:
 * - 0 - PDB trigger selected for ADC1
 * - 1 - Alternate trigger selected for ADC1 as defined by ADC1TRGSEL.
 */
//@{
#define BP_SIM_SOPT7_ADC1ALTTRGEN (15U)    //!< Bit position for SIM_SOPT7_ADC1ALTTRGEN.
#define BM_SIM_SOPT7_ADC1ALTTRGEN (0x00008000U) //!< Bit mask for SIM_SOPT7_ADC1ALTTRGEN.
#define BS_SIM_SOPT7_ADC1ALTTRGEN (1U)     //!< Bit field size in bits for SIM_SOPT7_ADC1ALTTRGEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SOPT7_ADC1ALTTRGEN field.
#define BR_SIM_SOPT7_ADC1ALTTRGEN (BITBAND_ACCESS32(HW_SIM_SOPT7_ADDR, BP_SIM_SOPT7_ADC1ALTTRGEN))
#endif

//! @brief Format value for bitfield SIM_SOPT7_ADC1ALTTRGEN.
#define BF_SIM_SOPT7_ADC1ALTTRGEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SOPT7_ADC1ALTTRGEN), uint32_t) & BM_SIM_SOPT7_ADC1ALTTRGEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADC1ALTTRGEN field to a new value.
#define BW_SIM_SOPT7_ADC1ALTTRGEN(v) (BITBAND_ACCESS32(HW_SIM_SOPT7_ADDR, BP_SIM_SOPT7_ADC1ALTTRGEN) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_SDID - System Device Identification Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_SDID - System Device Identification Register (RO)
 *
 * Reset value: 0x00000380U
 */
typedef union _hw_sim_sdid
{
    uint32_t U;
    struct _hw_sim_sdid_bitfields
    {
        uint32_t PINID : 4;            //!< [3:0] Pincount identification
        uint32_t FAMID : 3;            //!< [6:4] Kinetis family identification
        uint32_t DIEID : 5;            //!< [11:7] Device Die ID
        uint32_t REVID : 4;            //!< [15:12] Device revision number
        uint32_t RESERVED0 : 4;        //!< [19:16]
        uint32_t SERIESID : 4;         //!< [23:20] Kinetis Series ID
        uint32_t SUBFAMID : 4;         //!< [27:24] Kinetis Sub-Family ID
        uint32_t FAMILYID : 4;         //!< [31:28] Kinetis Family ID
    } B;
} hw_sim_sdid_t;
#endif

/*!
 * @name Constants and macros for entire SIM_SDID register
 */
//@{
#define HW_SIM_SDID_ADDR         (REGS_SIM_BASE + 0x1024U)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_SDID              (*(__I hw_sim_sdid_t *) HW_SIM_SDID_ADDR)
#define HW_SIM_SDID_RD()         (HW_SIM_SDID.U)
#endif
//@}

/*
 * Constants & macros for individual SIM_SDID bitfields
 */

/*!
 * @name Register SIM_SDID, field PINID[3:0] (RO)
 *
 * Specifies the pincount of the device.
 *
 * Values:
 * - 0000 - Reserved
 * - 0001 - Reserved
 * - 0010 - 32-pin
 * - 0011 - Reserved
 * - 0100 - 48-pin
 * - 0101 - 64-pin
 * - 0110 - 80-pin
 * - 0111 - 81-pin or 121-pin
 * - 1000 - 100-pin
 * - 1001 - 121-pin
 * - 1010 - 144-pin
 * - 1011 - Custom pinout (WLCSP)
 * - 1100 - 169-pin
 * - 1101 - Reserved
 * - 1110 - 256-pin
 * - 1111 - Reserved
 */
//@{
#define BP_SIM_SDID_PINID    (0U)          //!< Bit position for SIM_SDID_PINID.
#define BM_SIM_SDID_PINID    (0x0000000FU) //!< Bit mask for SIM_SDID_PINID.
#define BS_SIM_SDID_PINID    (4U)          //!< Bit field size in bits for SIM_SDID_PINID.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SDID_PINID field.
#define BR_SIM_SDID_PINID    (HW_SIM_SDID.B.PINID)
#endif
//@}

/*!
 * @name Register SIM_SDID, field FAMID[6:4] (RO)
 *
 * This field is maintained for compatibility only, but has been superceded by
 * the SERIESID, FAMILYID and SUBFAMID fields in this register.
 *
 * Values:
 * - 000 - K1x Family (without tamper)
 * - 001 - K2x Family (without tamper)
 * - 010 - K3x Family or K1x/K6x Family (with tamper)
 * - 011 - K4x Family or K2x Family (with tamper)
 * - 100 - K6x Family (without tamper)
 * - 101 - K7x Family
 * - 110 - Reserved
 * - 111 - Reserved
 */
//@{
#define BP_SIM_SDID_FAMID    (4U)          //!< Bit position for SIM_SDID_FAMID.
#define BM_SIM_SDID_FAMID    (0x00000070U) //!< Bit mask for SIM_SDID_FAMID.
#define BS_SIM_SDID_FAMID    (3U)          //!< Bit field size in bits for SIM_SDID_FAMID.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SDID_FAMID field.
#define BR_SIM_SDID_FAMID    (HW_SIM_SDID.B.FAMID)
#endif
//@}

/*!
 * @name Register SIM_SDID, field DIEID[11:7] (RO)
 *
 * Specifies the silicon feature set identication number for the device.
 */
//@{
#define BP_SIM_SDID_DIEID    (7U)          //!< Bit position for SIM_SDID_DIEID.
#define BM_SIM_SDID_DIEID    (0x00000F80U) //!< Bit mask for SIM_SDID_DIEID.
#define BS_SIM_SDID_DIEID    (5U)          //!< Bit field size in bits for SIM_SDID_DIEID.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SDID_DIEID field.
#define BR_SIM_SDID_DIEID    (HW_SIM_SDID.B.DIEID)
#endif
//@}

/*!
 * @name Register SIM_SDID, field REVID[15:12] (RO)
 *
 * Specifies the silicon implementation number for the device.
 */
//@{
#define BP_SIM_SDID_REVID    (12U)         //!< Bit position for SIM_SDID_REVID.
#define BM_SIM_SDID_REVID    (0x0000F000U) //!< Bit mask for SIM_SDID_REVID.
#define BS_SIM_SDID_REVID    (4U)          //!< Bit field size in bits for SIM_SDID_REVID.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SDID_REVID field.
#define BR_SIM_SDID_REVID    (HW_SIM_SDID.B.REVID)
#endif
//@}

/*!
 * @name Register SIM_SDID, field SERIESID[23:20] (RO)
 *
 * Specifies the Kinetis series of the device.
 *
 * Values:
 * - 0000 - Kinetis K series
 * - 0001 - Kinetis L series
 * - 0101 - Kinetis W series
 * - 0110 - Kinetis V series
 */
//@{
#define BP_SIM_SDID_SERIESID (20U)         //!< Bit position for SIM_SDID_SERIESID.
#define BM_SIM_SDID_SERIESID (0x00F00000U) //!< Bit mask for SIM_SDID_SERIESID.
#define BS_SIM_SDID_SERIESID (4U)          //!< Bit field size in bits for SIM_SDID_SERIESID.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SDID_SERIESID field.
#define BR_SIM_SDID_SERIESID (HW_SIM_SDID.B.SERIESID)
#endif
//@}

/*!
 * @name Register SIM_SDID, field SUBFAMID[27:24] (RO)
 *
 * Specifies the Kinetis sub-family of the device.
 *
 * Values:
 * - 0000 - Kx0 Subfamily
 * - 0001 - Kx1 Subfamily (tamper detect)
 * - 0010 - Kx2 Subfamily
 * - 0011 - Kx3 Subfamily (tamper detect)
 * - 0100 - Kx4 Subfamily
 * - 0101 - Kx5 Subfamily (tamper detect)
 * - 0110 - Kx6 Subfamily
 */
//@{
#define BP_SIM_SDID_SUBFAMID (24U)         //!< Bit position for SIM_SDID_SUBFAMID.
#define BM_SIM_SDID_SUBFAMID (0x0F000000U) //!< Bit mask for SIM_SDID_SUBFAMID.
#define BS_SIM_SDID_SUBFAMID (4U)          //!< Bit field size in bits for SIM_SDID_SUBFAMID.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SDID_SUBFAMID field.
#define BR_SIM_SDID_SUBFAMID (HW_SIM_SDID.B.SUBFAMID)
#endif
//@}

/*!
 * @name Register SIM_SDID, field FAMILYID[31:28] (RO)
 *
 * Specifies the Kinetis family of the device.
 *
 * Values:
 * - 0001 - K1x Family
 * - 0010 - K2x Family
 * - 0011 - K3x Family
 * - 0100 - K4x Family
 * - 0110 - K6x Family
 * - 0111 - K7x Family
 */
//@{
#define BP_SIM_SDID_FAMILYID (28U)         //!< Bit position for SIM_SDID_FAMILYID.
#define BM_SIM_SDID_FAMILYID (0xF0000000U) //!< Bit mask for SIM_SDID_FAMILYID.
#define BS_SIM_SDID_FAMILYID (4U)          //!< Bit field size in bits for SIM_SDID_FAMILYID.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SDID_FAMILYID field.
#define BR_SIM_SDID_FAMILYID (HW_SIM_SDID.B.FAMILYID)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_SCGC1 - System Clock Gating Control Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_SCGC1 - System Clock Gating Control Register 1 (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_sim_scgc1
{
    uint32_t U;
    struct _hw_sim_scgc1_bitfields
    {
        uint32_t RESERVED0 : 6;        //!< [5:0]
        uint32_t I2C2b : 1;            //!< [6] I2C2 Clock Gate Control
        uint32_t RESERVED1 : 3;        //!< [9:7]
        uint32_t UART4b : 1;           //!< [10] UART4 Clock Gate Control
        uint32_t UART5b : 1;           //!< [11] UART5 Clock Gate Control
        uint32_t RESERVED2 : 20;       //!< [31:12]
    } B;
} hw_sim_scgc1_t;
#endif

/*!
 * @name Constants and macros for entire SIM_SCGC1 register
 */
//@{
#define HW_SIM_SCGC1_ADDR        (REGS_SIM_BASE + 0x1028U)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_SCGC1             (*(__IO hw_sim_scgc1_t *) HW_SIM_SCGC1_ADDR)
#define HW_SIM_SCGC1_RD()        (HW_SIM_SCGC1.U)
#define HW_SIM_SCGC1_WR(v)       (HW_SIM_SCGC1.U = (v))
#define HW_SIM_SCGC1_SET(v)      (HW_SIM_SCGC1_WR(HW_SIM_SCGC1_RD() |  (v)))
#define HW_SIM_SCGC1_CLR(v)      (HW_SIM_SCGC1_WR(HW_SIM_SCGC1_RD() & ~(v)))
#define HW_SIM_SCGC1_TOG(v)      (HW_SIM_SCGC1_WR(HW_SIM_SCGC1_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SIM_SCGC1 bitfields
 */

/*!
 * @name Register SIM_SCGC1, field I2C2[6] (RW)
 *
 * This bit controls the clock gate to the I2C2 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC1_I2C2    (6U)          //!< Bit position for SIM_SCGC1_I2C2.
#define BM_SIM_SCGC1_I2C2    (0x00000040U) //!< Bit mask for SIM_SCGC1_I2C2.
#define BS_SIM_SCGC1_I2C2    (1U)          //!< Bit field size in bits for SIM_SCGC1_I2C2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC1_I2C2 field.
#define BR_SIM_SCGC1_I2C2    (BITBAND_ACCESS32(HW_SIM_SCGC1_ADDR, BP_SIM_SCGC1_I2C2))
#endif

//! @brief Format value for bitfield SIM_SCGC1_I2C2.
#define BF_SIM_SCGC1_I2C2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC1_I2C2), uint32_t) & BM_SIM_SCGC1_I2C2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2C2 field to a new value.
#define BW_SIM_SCGC1_I2C2(v) (BITBAND_ACCESS32(HW_SIM_SCGC1_ADDR, BP_SIM_SCGC1_I2C2) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC1, field UART4[10] (RW)
 *
 * This bit controls the clock gate to the UART4 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC1_UART4   (10U)         //!< Bit position for SIM_SCGC1_UART4.
#define BM_SIM_SCGC1_UART4   (0x00000400U) //!< Bit mask for SIM_SCGC1_UART4.
#define BS_SIM_SCGC1_UART4   (1U)          //!< Bit field size in bits for SIM_SCGC1_UART4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC1_UART4 field.
#define BR_SIM_SCGC1_UART4   (BITBAND_ACCESS32(HW_SIM_SCGC1_ADDR, BP_SIM_SCGC1_UART4))
#endif

//! @brief Format value for bitfield SIM_SCGC1_UART4.
#define BF_SIM_SCGC1_UART4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC1_UART4), uint32_t) & BM_SIM_SCGC1_UART4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the UART4 field to a new value.
#define BW_SIM_SCGC1_UART4(v) (BITBAND_ACCESS32(HW_SIM_SCGC1_ADDR, BP_SIM_SCGC1_UART4) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC1, field UART5[11] (RW)
 *
 * This bit controls the clock gate to the UART5 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC1_UART5   (11U)         //!< Bit position for SIM_SCGC1_UART5.
#define BM_SIM_SCGC1_UART5   (0x00000800U) //!< Bit mask for SIM_SCGC1_UART5.
#define BS_SIM_SCGC1_UART5   (1U)          //!< Bit field size in bits for SIM_SCGC1_UART5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC1_UART5 field.
#define BR_SIM_SCGC1_UART5   (BITBAND_ACCESS32(HW_SIM_SCGC1_ADDR, BP_SIM_SCGC1_UART5))
#endif

//! @brief Format value for bitfield SIM_SCGC1_UART5.
#define BF_SIM_SCGC1_UART5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC1_UART5), uint32_t) & BM_SIM_SCGC1_UART5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the UART5 field to a new value.
#define BW_SIM_SCGC1_UART5(v) (BITBAND_ACCESS32(HW_SIM_SCGC1_ADDR, BP_SIM_SCGC1_UART5) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_SCGC2 - System Clock Gating Control Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_SCGC2 - System Clock Gating Control Register 2 (RW)
 *
 * Reset value: 0x00000000U
 *
 * DAC0 can be accessed through both AIPS0 and AIPS1. When accessing through
 * AIPS1, define the clock gate control bits in the SCGC2. When accessing through
 * AIPS0, define the clock gate control bits in SCGC6.
 */
typedef union _hw_sim_scgc2
{
    uint32_t U;
    struct _hw_sim_scgc2_bitfields
    {
        uint32_t ENETb : 1;            //!< [0] ENET Clock Gate Control
        uint32_t RESERVED0 : 11;       //!< [11:1]
        uint32_t DAC0b : 1;            //!< [12] DAC0 Clock Gate Control
        uint32_t DAC1b : 1;            //!< [13] DAC1 Clock Gate Control
        uint32_t RESERVED1 : 18;       //!< [31:14]
    } B;
} hw_sim_scgc2_t;
#endif

/*!
 * @name Constants and macros for entire SIM_SCGC2 register
 */
//@{
#define HW_SIM_SCGC2_ADDR        (REGS_SIM_BASE + 0x102CU)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_SCGC2             (*(__IO hw_sim_scgc2_t *) HW_SIM_SCGC2_ADDR)
#define HW_SIM_SCGC2_RD()        (HW_SIM_SCGC2.U)
#define HW_SIM_SCGC2_WR(v)       (HW_SIM_SCGC2.U = (v))
#define HW_SIM_SCGC2_SET(v)      (HW_SIM_SCGC2_WR(HW_SIM_SCGC2_RD() |  (v)))
#define HW_SIM_SCGC2_CLR(v)      (HW_SIM_SCGC2_WR(HW_SIM_SCGC2_RD() & ~(v)))
#define HW_SIM_SCGC2_TOG(v)      (HW_SIM_SCGC2_WR(HW_SIM_SCGC2_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SIM_SCGC2 bitfields
 */

/*!
 * @name Register SIM_SCGC2, field ENET[0] (RW)
 *
 * This bit controls the clock gate to the ENET module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC2_ENET    (0U)          //!< Bit position for SIM_SCGC2_ENET.
#define BM_SIM_SCGC2_ENET    (0x00000001U) //!< Bit mask for SIM_SCGC2_ENET.
#define BS_SIM_SCGC2_ENET    (1U)          //!< Bit field size in bits for SIM_SCGC2_ENET.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC2_ENET field.
#define BR_SIM_SCGC2_ENET    (BITBAND_ACCESS32(HW_SIM_SCGC2_ADDR, BP_SIM_SCGC2_ENET))
#endif

//! @brief Format value for bitfield SIM_SCGC2_ENET.
#define BF_SIM_SCGC2_ENET(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC2_ENET), uint32_t) & BM_SIM_SCGC2_ENET)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ENET field to a new value.
#define BW_SIM_SCGC2_ENET(v) (BITBAND_ACCESS32(HW_SIM_SCGC2_ADDR, BP_SIM_SCGC2_ENET) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC2, field DAC0[12] (RW)
 *
 * This bit controls the clock gate to the DAC0 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC2_DAC0    (12U)         //!< Bit position for SIM_SCGC2_DAC0.
#define BM_SIM_SCGC2_DAC0    (0x00001000U) //!< Bit mask for SIM_SCGC2_DAC0.
#define BS_SIM_SCGC2_DAC0    (1U)          //!< Bit field size in bits for SIM_SCGC2_DAC0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC2_DAC0 field.
#define BR_SIM_SCGC2_DAC0    (BITBAND_ACCESS32(HW_SIM_SCGC2_ADDR, BP_SIM_SCGC2_DAC0))
#endif

//! @brief Format value for bitfield SIM_SCGC2_DAC0.
#define BF_SIM_SCGC2_DAC0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC2_DAC0), uint32_t) & BM_SIM_SCGC2_DAC0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DAC0 field to a new value.
#define BW_SIM_SCGC2_DAC0(v) (BITBAND_ACCESS32(HW_SIM_SCGC2_ADDR, BP_SIM_SCGC2_DAC0) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC2, field DAC1[13] (RW)
 *
 * This bit controls the clock gate to the DAC1 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC2_DAC1    (13U)         //!< Bit position for SIM_SCGC2_DAC1.
#define BM_SIM_SCGC2_DAC1    (0x00002000U) //!< Bit mask for SIM_SCGC2_DAC1.
#define BS_SIM_SCGC2_DAC1    (1U)          //!< Bit field size in bits for SIM_SCGC2_DAC1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC2_DAC1 field.
#define BR_SIM_SCGC2_DAC1    (BITBAND_ACCESS32(HW_SIM_SCGC2_ADDR, BP_SIM_SCGC2_DAC1))
#endif

//! @brief Format value for bitfield SIM_SCGC2_DAC1.
#define BF_SIM_SCGC2_DAC1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC2_DAC1), uint32_t) & BM_SIM_SCGC2_DAC1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DAC1 field to a new value.
#define BW_SIM_SCGC2_DAC1(v) (BITBAND_ACCESS32(HW_SIM_SCGC2_ADDR, BP_SIM_SCGC2_DAC1) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_SCGC3 - System Clock Gating Control Register 3
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_SCGC3 - System Clock Gating Control Register 3 (RW)
 *
 * Reset value: 0x00000000U
 *
 * FTM2 and RNGA can be accessed through both AIPS0 and AIPS1. When accessing
 * through AIPS1, define the clock gate control bits in the SCGC3. When accessing
 * through AIPS0, define the clock gate control bits in SCGC6.
 */
typedef union _hw_sim_scgc3
{
    uint32_t U;
    struct _hw_sim_scgc3_bitfields
    {
        uint32_t RNGA : 1;             //!< [0] RNGA Clock Gate Control
        uint32_t RESERVED0 : 11;       //!< [11:1]
        uint32_t SPI2b : 1;            //!< [12] SPI2 Clock Gate Control
        uint32_t RESERVED1 : 4;        //!< [16:13]
        uint32_t SDHCb : 1;            //!< [17] SDHC Clock Gate Control
        uint32_t RESERVED2 : 6;        //!< [23:18]
        uint32_t FTM2b : 1;            //!< [24] FTM2 Clock Gate Control
        uint32_t FTM3b : 1;            //!< [25] FTM3 Clock Gate Control
        uint32_t RESERVED3 : 1;        //!< [26]
        uint32_t ADC1b : 1;            //!< [27] ADC1 Clock Gate Control
        uint32_t RESERVED4 : 4;        //!< [31:28]
    } B;
} hw_sim_scgc3_t;
#endif

/*!
 * @name Constants and macros for entire SIM_SCGC3 register
 */
//@{
#define HW_SIM_SCGC3_ADDR        (REGS_SIM_BASE + 0x1030U)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_SCGC3             (*(__IO hw_sim_scgc3_t *) HW_SIM_SCGC3_ADDR)
#define HW_SIM_SCGC3_RD()        (HW_SIM_SCGC3.U)
#define HW_SIM_SCGC3_WR(v)       (HW_SIM_SCGC3.U = (v))
#define HW_SIM_SCGC3_SET(v)      (HW_SIM_SCGC3_WR(HW_SIM_SCGC3_RD() |  (v)))
#define HW_SIM_SCGC3_CLR(v)      (HW_SIM_SCGC3_WR(HW_SIM_SCGC3_RD() & ~(v)))
#define HW_SIM_SCGC3_TOG(v)      (HW_SIM_SCGC3_WR(HW_SIM_SCGC3_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SIM_SCGC3 bitfields
 */

/*!
 * @name Register SIM_SCGC3, field RNGA[0] (RW)
 *
 * This bit controls the clock gate to the RNGA module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC3_RNGA    (0U)          //!< Bit position for SIM_SCGC3_RNGA.
#define BM_SIM_SCGC3_RNGA    (0x00000001U) //!< Bit mask for SIM_SCGC3_RNGA.
#define BS_SIM_SCGC3_RNGA    (1U)          //!< Bit field size in bits for SIM_SCGC3_RNGA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC3_RNGA field.
#define BR_SIM_SCGC3_RNGA    (BITBAND_ACCESS32(HW_SIM_SCGC3_ADDR, BP_SIM_SCGC3_RNGA))
#endif

//! @brief Format value for bitfield SIM_SCGC3_RNGA.
#define BF_SIM_SCGC3_RNGA(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC3_RNGA), uint32_t) & BM_SIM_SCGC3_RNGA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RNGA field to a new value.
#define BW_SIM_SCGC3_RNGA(v) (BITBAND_ACCESS32(HW_SIM_SCGC3_ADDR, BP_SIM_SCGC3_RNGA) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC3, field SPI2[12] (RW)
 *
 * This bit controls the clock gate to the SPI2 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC3_SPI2    (12U)         //!< Bit position for SIM_SCGC3_SPI2.
#define BM_SIM_SCGC3_SPI2    (0x00001000U) //!< Bit mask for SIM_SCGC3_SPI2.
#define BS_SIM_SCGC3_SPI2    (1U)          //!< Bit field size in bits for SIM_SCGC3_SPI2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC3_SPI2 field.
#define BR_SIM_SCGC3_SPI2    (BITBAND_ACCESS32(HW_SIM_SCGC3_ADDR, BP_SIM_SCGC3_SPI2))
#endif

//! @brief Format value for bitfield SIM_SCGC3_SPI2.
#define BF_SIM_SCGC3_SPI2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC3_SPI2), uint32_t) & BM_SIM_SCGC3_SPI2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SPI2 field to a new value.
#define BW_SIM_SCGC3_SPI2(v) (BITBAND_ACCESS32(HW_SIM_SCGC3_ADDR, BP_SIM_SCGC3_SPI2) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC3, field SDHC[17] (RW)
 *
 * This bit controls the clock gate to the SDHC module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC3_SDHC    (17U)         //!< Bit position for SIM_SCGC3_SDHC.
#define BM_SIM_SCGC3_SDHC    (0x00020000U) //!< Bit mask for SIM_SCGC3_SDHC.
#define BS_SIM_SCGC3_SDHC    (1U)          //!< Bit field size in bits for SIM_SCGC3_SDHC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC3_SDHC field.
#define BR_SIM_SCGC3_SDHC    (BITBAND_ACCESS32(HW_SIM_SCGC3_ADDR, BP_SIM_SCGC3_SDHC))
#endif

//! @brief Format value for bitfield SIM_SCGC3_SDHC.
#define BF_SIM_SCGC3_SDHC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC3_SDHC), uint32_t) & BM_SIM_SCGC3_SDHC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SDHC field to a new value.
#define BW_SIM_SCGC3_SDHC(v) (BITBAND_ACCESS32(HW_SIM_SCGC3_ADDR, BP_SIM_SCGC3_SDHC) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC3, field FTM2[24] (RW)
 *
 * This bit controls the clock gate to the FTM2 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC3_FTM2    (24U)         //!< Bit position for SIM_SCGC3_FTM2.
#define BM_SIM_SCGC3_FTM2    (0x01000000U) //!< Bit mask for SIM_SCGC3_FTM2.
#define BS_SIM_SCGC3_FTM2    (1U)          //!< Bit field size in bits for SIM_SCGC3_FTM2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC3_FTM2 field.
#define BR_SIM_SCGC3_FTM2    (BITBAND_ACCESS32(HW_SIM_SCGC3_ADDR, BP_SIM_SCGC3_FTM2))
#endif

//! @brief Format value for bitfield SIM_SCGC3_FTM2.
#define BF_SIM_SCGC3_FTM2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC3_FTM2), uint32_t) & BM_SIM_SCGC3_FTM2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM2 field to a new value.
#define BW_SIM_SCGC3_FTM2(v) (BITBAND_ACCESS32(HW_SIM_SCGC3_ADDR, BP_SIM_SCGC3_FTM2) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC3, field FTM3[25] (RW)
 *
 * This bit controls the clock gate to the FTM3 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC3_FTM3    (25U)         //!< Bit position for SIM_SCGC3_FTM3.
#define BM_SIM_SCGC3_FTM3    (0x02000000U) //!< Bit mask for SIM_SCGC3_FTM3.
#define BS_SIM_SCGC3_FTM3    (1U)          //!< Bit field size in bits for SIM_SCGC3_FTM3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC3_FTM3 field.
#define BR_SIM_SCGC3_FTM3    (BITBAND_ACCESS32(HW_SIM_SCGC3_ADDR, BP_SIM_SCGC3_FTM3))
#endif

//! @brief Format value for bitfield SIM_SCGC3_FTM3.
#define BF_SIM_SCGC3_FTM3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC3_FTM3), uint32_t) & BM_SIM_SCGC3_FTM3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM3 field to a new value.
#define BW_SIM_SCGC3_FTM3(v) (BITBAND_ACCESS32(HW_SIM_SCGC3_ADDR, BP_SIM_SCGC3_FTM3) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC3, field ADC1[27] (RW)
 *
 * This bit controls the clock gate to the ADC1 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC3_ADC1    (27U)         //!< Bit position for SIM_SCGC3_ADC1.
#define BM_SIM_SCGC3_ADC1    (0x08000000U) //!< Bit mask for SIM_SCGC3_ADC1.
#define BS_SIM_SCGC3_ADC1    (1U)          //!< Bit field size in bits for SIM_SCGC3_ADC1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC3_ADC1 field.
#define BR_SIM_SCGC3_ADC1    (BITBAND_ACCESS32(HW_SIM_SCGC3_ADDR, BP_SIM_SCGC3_ADC1))
#endif

//! @brief Format value for bitfield SIM_SCGC3_ADC1.
#define BF_SIM_SCGC3_ADC1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC3_ADC1), uint32_t) & BM_SIM_SCGC3_ADC1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADC1 field to a new value.
#define BW_SIM_SCGC3_ADC1(v) (BITBAND_ACCESS32(HW_SIM_SCGC3_ADDR, BP_SIM_SCGC3_ADC1) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_SCGC4 - System Clock Gating Control Register 4
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_SCGC4 - System Clock Gating Control Register 4 (RW)
 *
 * Reset value: 0xF0100030U
 */
typedef union _hw_sim_scgc4
{
    uint32_t U;
    struct _hw_sim_scgc4_bitfields
    {
        uint32_t RESERVED0 : 1;        //!< [0]
        uint32_t EWMb : 1;             //!< [1] EWM Clock Gate Control
        uint32_t CMTb : 1;             //!< [2] CMT Clock Gate Control
        uint32_t RESERVED1 : 3;        //!< [5:3]
        uint32_t I2C0b : 1;            //!< [6] I2C0 Clock Gate Control
        uint32_t I2C1b : 1;            //!< [7] I2C1 Clock Gate Control
        uint32_t RESERVED2 : 2;        //!< [9:8]
        uint32_t UART0b : 1;           //!< [10] UART0 Clock Gate Control
        uint32_t UART1b : 1;           //!< [11] UART1 Clock Gate Control
        uint32_t UART2b : 1;           //!< [12] UART2 Clock Gate Control
        uint32_t UART3b : 1;           //!< [13] UART3 Clock Gate Control
        uint32_t RESERVED3 : 4;        //!< [17:14]
        uint32_t USBOTG : 1;           //!< [18] USB Clock Gate Control
        uint32_t CMP : 1;              //!< [19] Comparator Clock Gate Control
        uint32_t VREFb : 1;            //!< [20] VREF Clock Gate Control
        uint32_t RESERVED4 : 11;       //!< [31:21]
    } B;
} hw_sim_scgc4_t;
#endif

/*!
 * @name Constants and macros for entire SIM_SCGC4 register
 */
//@{
#define HW_SIM_SCGC4_ADDR        (REGS_SIM_BASE + 0x1034U)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_SCGC4             (*(__IO hw_sim_scgc4_t *) HW_SIM_SCGC4_ADDR)
#define HW_SIM_SCGC4_RD()        (HW_SIM_SCGC4.U)
#define HW_SIM_SCGC4_WR(v)       (HW_SIM_SCGC4.U = (v))
#define HW_SIM_SCGC4_SET(v)      (HW_SIM_SCGC4_WR(HW_SIM_SCGC4_RD() |  (v)))
#define HW_SIM_SCGC4_CLR(v)      (HW_SIM_SCGC4_WR(HW_SIM_SCGC4_RD() & ~(v)))
#define HW_SIM_SCGC4_TOG(v)      (HW_SIM_SCGC4_WR(HW_SIM_SCGC4_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SIM_SCGC4 bitfields
 */

/*!
 * @name Register SIM_SCGC4, field EWM[1] (RW)
 *
 * This bit controls the clock gate to the EWM module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC4_EWM     (1U)          //!< Bit position for SIM_SCGC4_EWM.
#define BM_SIM_SCGC4_EWM     (0x00000002U) //!< Bit mask for SIM_SCGC4_EWM.
#define BS_SIM_SCGC4_EWM     (1U)          //!< Bit field size in bits for SIM_SCGC4_EWM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC4_EWM field.
#define BR_SIM_SCGC4_EWM     (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_EWM))
#endif

//! @brief Format value for bitfield SIM_SCGC4_EWM.
#define BF_SIM_SCGC4_EWM(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC4_EWM), uint32_t) & BM_SIM_SCGC4_EWM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EWM field to a new value.
#define BW_SIM_SCGC4_EWM(v)  (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_EWM) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC4, field CMT[2] (RW)
 *
 * This bit controls the clock gate to the CMT module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC4_CMT     (2U)          //!< Bit position for SIM_SCGC4_CMT.
#define BM_SIM_SCGC4_CMT     (0x00000004U) //!< Bit mask for SIM_SCGC4_CMT.
#define BS_SIM_SCGC4_CMT     (1U)          //!< Bit field size in bits for SIM_SCGC4_CMT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC4_CMT field.
#define BR_SIM_SCGC4_CMT     (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_CMT))
#endif

//! @brief Format value for bitfield SIM_SCGC4_CMT.
#define BF_SIM_SCGC4_CMT(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC4_CMT), uint32_t) & BM_SIM_SCGC4_CMT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CMT field to a new value.
#define BW_SIM_SCGC4_CMT(v)  (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_CMT) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC4, field I2C0[6] (RW)
 *
 * This bit controls the clock gate to the I 2 C0 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC4_I2C0    (6U)          //!< Bit position for SIM_SCGC4_I2C0.
#define BM_SIM_SCGC4_I2C0    (0x00000040U) //!< Bit mask for SIM_SCGC4_I2C0.
#define BS_SIM_SCGC4_I2C0    (1U)          //!< Bit field size in bits for SIM_SCGC4_I2C0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC4_I2C0 field.
#define BR_SIM_SCGC4_I2C0    (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_I2C0))
#endif

//! @brief Format value for bitfield SIM_SCGC4_I2C0.
#define BF_SIM_SCGC4_I2C0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC4_I2C0), uint32_t) & BM_SIM_SCGC4_I2C0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2C0 field to a new value.
#define BW_SIM_SCGC4_I2C0(v) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_I2C0) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC4, field I2C1[7] (RW)
 *
 * This bit controls the clock gate to the I 2 C1 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC4_I2C1    (7U)          //!< Bit position for SIM_SCGC4_I2C1.
#define BM_SIM_SCGC4_I2C1    (0x00000080U) //!< Bit mask for SIM_SCGC4_I2C1.
#define BS_SIM_SCGC4_I2C1    (1U)          //!< Bit field size in bits for SIM_SCGC4_I2C1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC4_I2C1 field.
#define BR_SIM_SCGC4_I2C1    (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_I2C1))
#endif

//! @brief Format value for bitfield SIM_SCGC4_I2C1.
#define BF_SIM_SCGC4_I2C1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC4_I2C1), uint32_t) & BM_SIM_SCGC4_I2C1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2C1 field to a new value.
#define BW_SIM_SCGC4_I2C1(v) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_I2C1) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC4, field UART0[10] (RW)
 *
 * This bit controls the clock gate to the UART0 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC4_UART0   (10U)         //!< Bit position for SIM_SCGC4_UART0.
#define BM_SIM_SCGC4_UART0   (0x00000400U) //!< Bit mask for SIM_SCGC4_UART0.
#define BS_SIM_SCGC4_UART0   (1U)          //!< Bit field size in bits for SIM_SCGC4_UART0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC4_UART0 field.
#define BR_SIM_SCGC4_UART0   (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_UART0))
#endif

//! @brief Format value for bitfield SIM_SCGC4_UART0.
#define BF_SIM_SCGC4_UART0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC4_UART0), uint32_t) & BM_SIM_SCGC4_UART0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the UART0 field to a new value.
#define BW_SIM_SCGC4_UART0(v) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_UART0) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC4, field UART1[11] (RW)
 *
 * This bit controls the clock gate to the UART1 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC4_UART1   (11U)         //!< Bit position for SIM_SCGC4_UART1.
#define BM_SIM_SCGC4_UART1   (0x00000800U) //!< Bit mask for SIM_SCGC4_UART1.
#define BS_SIM_SCGC4_UART1   (1U)          //!< Bit field size in bits for SIM_SCGC4_UART1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC4_UART1 field.
#define BR_SIM_SCGC4_UART1   (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_UART1))
#endif

//! @brief Format value for bitfield SIM_SCGC4_UART1.
#define BF_SIM_SCGC4_UART1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC4_UART1), uint32_t) & BM_SIM_SCGC4_UART1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the UART1 field to a new value.
#define BW_SIM_SCGC4_UART1(v) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_UART1) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC4, field UART2[12] (RW)
 *
 * This bit controls the clock gate to the UART2 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC4_UART2   (12U)         //!< Bit position for SIM_SCGC4_UART2.
#define BM_SIM_SCGC4_UART2   (0x00001000U) //!< Bit mask for SIM_SCGC4_UART2.
#define BS_SIM_SCGC4_UART2   (1U)          //!< Bit field size in bits for SIM_SCGC4_UART2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC4_UART2 field.
#define BR_SIM_SCGC4_UART2   (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_UART2))
#endif

//! @brief Format value for bitfield SIM_SCGC4_UART2.
#define BF_SIM_SCGC4_UART2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC4_UART2), uint32_t) & BM_SIM_SCGC4_UART2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the UART2 field to a new value.
#define BW_SIM_SCGC4_UART2(v) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_UART2) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC4, field UART3[13] (RW)
 *
 * This bit controls the clock gate to the UART3 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC4_UART3   (13U)         //!< Bit position for SIM_SCGC4_UART3.
#define BM_SIM_SCGC4_UART3   (0x00002000U) //!< Bit mask for SIM_SCGC4_UART3.
#define BS_SIM_SCGC4_UART3   (1U)          //!< Bit field size in bits for SIM_SCGC4_UART3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC4_UART3 field.
#define BR_SIM_SCGC4_UART3   (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_UART3))
#endif

//! @brief Format value for bitfield SIM_SCGC4_UART3.
#define BF_SIM_SCGC4_UART3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC4_UART3), uint32_t) & BM_SIM_SCGC4_UART3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the UART3 field to a new value.
#define BW_SIM_SCGC4_UART3(v) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_UART3) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC4, field USBOTG[18] (RW)
 *
 * This bit controls the clock gate to the USB module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC4_USBOTG  (18U)         //!< Bit position for SIM_SCGC4_USBOTG.
#define BM_SIM_SCGC4_USBOTG  (0x00040000U) //!< Bit mask for SIM_SCGC4_USBOTG.
#define BS_SIM_SCGC4_USBOTG  (1U)          //!< Bit field size in bits for SIM_SCGC4_USBOTG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC4_USBOTG field.
#define BR_SIM_SCGC4_USBOTG  (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_USBOTG))
#endif

//! @brief Format value for bitfield SIM_SCGC4_USBOTG.
#define BF_SIM_SCGC4_USBOTG(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC4_USBOTG), uint32_t) & BM_SIM_SCGC4_USBOTG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the USBOTG field to a new value.
#define BW_SIM_SCGC4_USBOTG(v) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_USBOTG) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC4, field CMP[19] (RW)
 *
 * This bit controls the clock gate to the comparator module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC4_CMP     (19U)         //!< Bit position for SIM_SCGC4_CMP.
#define BM_SIM_SCGC4_CMP     (0x00080000U) //!< Bit mask for SIM_SCGC4_CMP.
#define BS_SIM_SCGC4_CMP     (1U)          //!< Bit field size in bits for SIM_SCGC4_CMP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC4_CMP field.
#define BR_SIM_SCGC4_CMP     (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_CMP))
#endif

//! @brief Format value for bitfield SIM_SCGC4_CMP.
#define BF_SIM_SCGC4_CMP(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC4_CMP), uint32_t) & BM_SIM_SCGC4_CMP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CMP field to a new value.
#define BW_SIM_SCGC4_CMP(v)  (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_CMP) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC4, field VREF[20] (RW)
 *
 * This bit controls the clock gate to the VREF module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC4_VREF    (20U)         //!< Bit position for SIM_SCGC4_VREF.
#define BM_SIM_SCGC4_VREF    (0x00100000U) //!< Bit mask for SIM_SCGC4_VREF.
#define BS_SIM_SCGC4_VREF    (1U)          //!< Bit field size in bits for SIM_SCGC4_VREF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC4_VREF field.
#define BR_SIM_SCGC4_VREF    (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_VREF))
#endif

//! @brief Format value for bitfield SIM_SCGC4_VREF.
#define BF_SIM_SCGC4_VREF(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC4_VREF), uint32_t) & BM_SIM_SCGC4_VREF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VREF field to a new value.
#define BW_SIM_SCGC4_VREF(v) (BITBAND_ACCESS32(HW_SIM_SCGC4_ADDR, BP_SIM_SCGC4_VREF) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_SCGC5 - System Clock Gating Control Register 5
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_SCGC5 - System Clock Gating Control Register 5 (RW)
 *
 * Reset value: 0x00040182U
 */
typedef union _hw_sim_scgc5
{
    uint32_t U;
    struct _hw_sim_scgc5_bitfields
    {
        uint32_t LPTMR : 1;            //!< [0] Low Power Timer Access Control
        uint32_t RESERVED0 : 8;        //!< [8:1]
        uint32_t PORTAb : 1;           //!< [9] Port A Clock Gate Control
        uint32_t PORTBb : 1;           //!< [10] Port B Clock Gate Control
        uint32_t PORTCb : 1;           //!< [11] Port C Clock Gate Control
        uint32_t PORTDb : 1;           //!< [12] Port D Clock Gate Control
        uint32_t PORTEb : 1;           //!< [13] Port E Clock Gate Control
        uint32_t RESERVED1 : 18;       //!< [31:14]
    } B;
} hw_sim_scgc5_t;
#endif

/*!
 * @name Constants and macros for entire SIM_SCGC5 register
 */
//@{
#define HW_SIM_SCGC5_ADDR        (REGS_SIM_BASE + 0x1038U)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_SCGC5             (*(__IO hw_sim_scgc5_t *) HW_SIM_SCGC5_ADDR)
#define HW_SIM_SCGC5_RD()        (HW_SIM_SCGC5.U)
#define HW_SIM_SCGC5_WR(v)       (HW_SIM_SCGC5.U = (v))
#define HW_SIM_SCGC5_SET(v)      (HW_SIM_SCGC5_WR(HW_SIM_SCGC5_RD() |  (v)))
#define HW_SIM_SCGC5_CLR(v)      (HW_SIM_SCGC5_WR(HW_SIM_SCGC5_RD() & ~(v)))
#define HW_SIM_SCGC5_TOG(v)      (HW_SIM_SCGC5_WR(HW_SIM_SCGC5_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SIM_SCGC5 bitfields
 */

/*!
 * @name Register SIM_SCGC5, field LPTMR[0] (RW)
 *
 * This bit controls software access to the Low Power Timer module.
 *
 * Values:
 * - 0 - Access disabled
 * - 1 - Access enabled
 */
//@{
#define BP_SIM_SCGC5_LPTMR   (0U)          //!< Bit position for SIM_SCGC5_LPTMR.
#define BM_SIM_SCGC5_LPTMR   (0x00000001U) //!< Bit mask for SIM_SCGC5_LPTMR.
#define BS_SIM_SCGC5_LPTMR   (1U)          //!< Bit field size in bits for SIM_SCGC5_LPTMR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC5_LPTMR field.
#define BR_SIM_SCGC5_LPTMR   (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR, BP_SIM_SCGC5_LPTMR))
#endif

//! @brief Format value for bitfield SIM_SCGC5_LPTMR.
#define BF_SIM_SCGC5_LPTMR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC5_LPTMR), uint32_t) & BM_SIM_SCGC5_LPTMR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LPTMR field to a new value.
#define BW_SIM_SCGC5_LPTMR(v) (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR, BP_SIM_SCGC5_LPTMR) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC5, field PORTA[9] (RW)
 *
 * This bit controls the clock gate to the Port A module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC5_PORTA   (9U)          //!< Bit position for SIM_SCGC5_PORTA.
#define BM_SIM_SCGC5_PORTA   (0x00000200U) //!< Bit mask for SIM_SCGC5_PORTA.
#define BS_SIM_SCGC5_PORTA   (1U)          //!< Bit field size in bits for SIM_SCGC5_PORTA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC5_PORTA field.
#define BR_SIM_SCGC5_PORTA   (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR, BP_SIM_SCGC5_PORTA))
#endif

//! @brief Format value for bitfield SIM_SCGC5_PORTA.
#define BF_SIM_SCGC5_PORTA(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC5_PORTA), uint32_t) & BM_SIM_SCGC5_PORTA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PORTA field to a new value.
#define BW_SIM_SCGC5_PORTA(v) (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR, BP_SIM_SCGC5_PORTA) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC5, field PORTB[10] (RW)
 *
 * This bit controls the clock gate to the Port B module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC5_PORTB   (10U)         //!< Bit position for SIM_SCGC5_PORTB.
#define BM_SIM_SCGC5_PORTB   (0x00000400U) //!< Bit mask for SIM_SCGC5_PORTB.
#define BS_SIM_SCGC5_PORTB   (1U)          //!< Bit field size in bits for SIM_SCGC5_PORTB.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC5_PORTB field.
#define BR_SIM_SCGC5_PORTB   (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR, BP_SIM_SCGC5_PORTB))
#endif

//! @brief Format value for bitfield SIM_SCGC5_PORTB.
#define BF_SIM_SCGC5_PORTB(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC5_PORTB), uint32_t) & BM_SIM_SCGC5_PORTB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PORTB field to a new value.
#define BW_SIM_SCGC5_PORTB(v) (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR, BP_SIM_SCGC5_PORTB) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC5, field PORTC[11] (RW)
 *
 * This bit controls the clock gate to the Port C module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC5_PORTC   (11U)         //!< Bit position for SIM_SCGC5_PORTC.
#define BM_SIM_SCGC5_PORTC   (0x00000800U) //!< Bit mask for SIM_SCGC5_PORTC.
#define BS_SIM_SCGC5_PORTC   (1U)          //!< Bit field size in bits for SIM_SCGC5_PORTC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC5_PORTC field.
#define BR_SIM_SCGC5_PORTC   (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR, BP_SIM_SCGC5_PORTC))
#endif

//! @brief Format value for bitfield SIM_SCGC5_PORTC.
#define BF_SIM_SCGC5_PORTC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC5_PORTC), uint32_t) & BM_SIM_SCGC5_PORTC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PORTC field to a new value.
#define BW_SIM_SCGC5_PORTC(v) (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR, BP_SIM_SCGC5_PORTC) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC5, field PORTD[12] (RW)
 *
 * This bit controls the clock gate to the Port D module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC5_PORTD   (12U)         //!< Bit position for SIM_SCGC5_PORTD.
#define BM_SIM_SCGC5_PORTD   (0x00001000U) //!< Bit mask for SIM_SCGC5_PORTD.
#define BS_SIM_SCGC5_PORTD   (1U)          //!< Bit field size in bits for SIM_SCGC5_PORTD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC5_PORTD field.
#define BR_SIM_SCGC5_PORTD   (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR, BP_SIM_SCGC5_PORTD))
#endif

//! @brief Format value for bitfield SIM_SCGC5_PORTD.
#define BF_SIM_SCGC5_PORTD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC5_PORTD), uint32_t) & BM_SIM_SCGC5_PORTD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PORTD field to a new value.
#define BW_SIM_SCGC5_PORTD(v) (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR, BP_SIM_SCGC5_PORTD) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC5, field PORTE[13] (RW)
 *
 * This bit controls the clock gate to the Port E module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC5_PORTE   (13U)         //!< Bit position for SIM_SCGC5_PORTE.
#define BM_SIM_SCGC5_PORTE   (0x00002000U) //!< Bit mask for SIM_SCGC5_PORTE.
#define BS_SIM_SCGC5_PORTE   (1U)          //!< Bit field size in bits for SIM_SCGC5_PORTE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC5_PORTE field.
#define BR_SIM_SCGC5_PORTE   (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR, BP_SIM_SCGC5_PORTE))
#endif

//! @brief Format value for bitfield SIM_SCGC5_PORTE.
#define BF_SIM_SCGC5_PORTE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC5_PORTE), uint32_t) & BM_SIM_SCGC5_PORTE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PORTE field to a new value.
#define BW_SIM_SCGC5_PORTE(v) (BITBAND_ACCESS32(HW_SIM_SCGC5_ADDR, BP_SIM_SCGC5_PORTE) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_SCGC6 - System Clock Gating Control Register 6
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_SCGC6 - System Clock Gating Control Register 6 (RW)
 *
 * Reset value: 0x40000001U
 *
 * DAC0, FTM2, and RNGA can be accessed through both AIPS0 and AIPS1. When
 * accessing through AIPS1, define the clock gate control bits in the SCGC2 and SCGC3.
 * When accessing through AIPS0, define the clock gate control bits in SCGC6.
 */
typedef union _hw_sim_scgc6
{
    uint32_t U;
    struct _hw_sim_scgc6_bitfields
    {
        uint32_t FTF : 1;              //!< [0] Flash Memory Clock Gate Control
        uint32_t DMAMUXb : 1;          //!< [1] DMA Mux Clock Gate Control
        uint32_t RESERVED0 : 2;        //!< [3:2]
        uint32_t FLEXCAN0 : 1;         //!< [4] FlexCAN0 Clock Gate Control
        uint32_t RESERVED1 : 4;        //!< [8:5]
        uint32_t RNGA : 1;             //!< [9] RNGA Clock Gate Control
        uint32_t RESERVED2 : 2;        //!< [11:10]
        uint32_t SPI0b : 1;            //!< [12] SPI0 Clock Gate Control
        uint32_t SPI1b : 1;            //!< [13] SPI1 Clock Gate Control
        uint32_t RESERVED3 : 1;        //!< [14]
        uint32_t I2S : 1;              //!< [15] I2S Clock Gate Control
        uint32_t RESERVED4 : 2;        //!< [17:16]
        uint32_t CRCb : 1;             //!< [18] CRC Clock Gate Control
        uint32_t RESERVED5 : 2;        //!< [20:19]
        uint32_t USBDCDb : 1;          //!< [21] USB DCD Clock Gate Control
        uint32_t PDB : 1;              //!< [22] PDB Clock Gate Control
        uint32_t PITb : 1;             //!< [23] PIT Clock Gate Control
        uint32_t FTM0b : 1;            //!< [24] FTM0 Clock Gate Control
        uint32_t FTM1b : 1;            //!< [25] FTM1 Clock Gate Control
        uint32_t FTM2b : 1;            //!< [26] FTM2 Clock Gate Control
        uint32_t ADC0b : 1;            //!< [27] ADC0 Clock Gate Control
        uint32_t RESERVED6 : 1;        //!< [28]
        uint32_t RTCb : 1;             //!< [29] RTC Access Control
        uint32_t RESERVED7 : 1;        //!< [30]
        uint32_t DAC0b : 1;            //!< [31] DAC0 Clock Gate Control
    } B;
} hw_sim_scgc6_t;
#endif

/*!
 * @name Constants and macros for entire SIM_SCGC6 register
 */
//@{
#define HW_SIM_SCGC6_ADDR        (REGS_SIM_BASE + 0x103CU)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_SCGC6             (*(__IO hw_sim_scgc6_t *) HW_SIM_SCGC6_ADDR)
#define HW_SIM_SCGC6_RD()        (HW_SIM_SCGC6.U)
#define HW_SIM_SCGC6_WR(v)       (HW_SIM_SCGC6.U = (v))
#define HW_SIM_SCGC6_SET(v)      (HW_SIM_SCGC6_WR(HW_SIM_SCGC6_RD() |  (v)))
#define HW_SIM_SCGC6_CLR(v)      (HW_SIM_SCGC6_WR(HW_SIM_SCGC6_RD() & ~(v)))
#define HW_SIM_SCGC6_TOG(v)      (HW_SIM_SCGC6_WR(HW_SIM_SCGC6_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SIM_SCGC6 bitfields
 */

/*!
 * @name Register SIM_SCGC6, field FTF[0] (RW)
 *
 * This bit controls the clock gate to the flash memory. Flash reads are still
 * supported while the flash memory is clock gated, but entry into low power modes
 * is blocked.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC6_FTF     (0U)          //!< Bit position for SIM_SCGC6_FTF.
#define BM_SIM_SCGC6_FTF     (0x00000001U) //!< Bit mask for SIM_SCGC6_FTF.
#define BS_SIM_SCGC6_FTF     (1U)          //!< Bit field size in bits for SIM_SCGC6_FTF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC6_FTF field.
#define BR_SIM_SCGC6_FTF     (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_FTF))
#endif

//! @brief Format value for bitfield SIM_SCGC6_FTF.
#define BF_SIM_SCGC6_FTF(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC6_FTF), uint32_t) & BM_SIM_SCGC6_FTF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTF field to a new value.
#define BW_SIM_SCGC6_FTF(v)  (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_FTF) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC6, field DMAMUX[1] (RW)
 *
 * This bit controls the clock gate to the DMA Mux module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC6_DMAMUX  (1U)          //!< Bit position for SIM_SCGC6_DMAMUX.
#define BM_SIM_SCGC6_DMAMUX  (0x00000002U) //!< Bit mask for SIM_SCGC6_DMAMUX.
#define BS_SIM_SCGC6_DMAMUX  (1U)          //!< Bit field size in bits for SIM_SCGC6_DMAMUX.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC6_DMAMUX field.
#define BR_SIM_SCGC6_DMAMUX  (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_DMAMUX))
#endif

//! @brief Format value for bitfield SIM_SCGC6_DMAMUX.
#define BF_SIM_SCGC6_DMAMUX(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC6_DMAMUX), uint32_t) & BM_SIM_SCGC6_DMAMUX)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMAMUX field to a new value.
#define BW_SIM_SCGC6_DMAMUX(v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_DMAMUX) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC6, field FLEXCAN0[4] (RW)
 *
 * This bit controls the clock gate to the FlexCAN0 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC6_FLEXCAN0 (4U)         //!< Bit position for SIM_SCGC6_FLEXCAN0.
#define BM_SIM_SCGC6_FLEXCAN0 (0x00000010U) //!< Bit mask for SIM_SCGC6_FLEXCAN0.
#define BS_SIM_SCGC6_FLEXCAN0 (1U)         //!< Bit field size in bits for SIM_SCGC6_FLEXCAN0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC6_FLEXCAN0 field.
#define BR_SIM_SCGC6_FLEXCAN0 (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_FLEXCAN0))
#endif

//! @brief Format value for bitfield SIM_SCGC6_FLEXCAN0.
#define BF_SIM_SCGC6_FLEXCAN0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC6_FLEXCAN0), uint32_t) & BM_SIM_SCGC6_FLEXCAN0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FLEXCAN0 field to a new value.
#define BW_SIM_SCGC6_FLEXCAN0(v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_FLEXCAN0) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC6, field RNGA[9] (RW)
 *
 * This bit controls the clock gate to the RNGA module.
 */
//@{
#define BP_SIM_SCGC6_RNGA    (9U)          //!< Bit position for SIM_SCGC6_RNGA.
#define BM_SIM_SCGC6_RNGA    (0x00000200U) //!< Bit mask for SIM_SCGC6_RNGA.
#define BS_SIM_SCGC6_RNGA    (1U)          //!< Bit field size in bits for SIM_SCGC6_RNGA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC6_RNGA field.
#define BR_SIM_SCGC6_RNGA    (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_RNGA))
#endif

//! @brief Format value for bitfield SIM_SCGC6_RNGA.
#define BF_SIM_SCGC6_RNGA(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC6_RNGA), uint32_t) & BM_SIM_SCGC6_RNGA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RNGA field to a new value.
#define BW_SIM_SCGC6_RNGA(v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_RNGA) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC6, field SPI0[12] (RW)
 *
 * This bit controls the clock gate to the SPI0 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC6_SPI0    (12U)         //!< Bit position for SIM_SCGC6_SPI0.
#define BM_SIM_SCGC6_SPI0    (0x00001000U) //!< Bit mask for SIM_SCGC6_SPI0.
#define BS_SIM_SCGC6_SPI0    (1U)          //!< Bit field size in bits for SIM_SCGC6_SPI0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC6_SPI0 field.
#define BR_SIM_SCGC6_SPI0    (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_SPI0))
#endif

//! @brief Format value for bitfield SIM_SCGC6_SPI0.
#define BF_SIM_SCGC6_SPI0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC6_SPI0), uint32_t) & BM_SIM_SCGC6_SPI0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SPI0 field to a new value.
#define BW_SIM_SCGC6_SPI0(v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_SPI0) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC6, field SPI1[13] (RW)
 *
 * This bit controls the clock gate to the SPI1 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC6_SPI1    (13U)         //!< Bit position for SIM_SCGC6_SPI1.
#define BM_SIM_SCGC6_SPI1    (0x00002000U) //!< Bit mask for SIM_SCGC6_SPI1.
#define BS_SIM_SCGC6_SPI1    (1U)          //!< Bit field size in bits for SIM_SCGC6_SPI1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC6_SPI1 field.
#define BR_SIM_SCGC6_SPI1    (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_SPI1))
#endif

//! @brief Format value for bitfield SIM_SCGC6_SPI1.
#define BF_SIM_SCGC6_SPI1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC6_SPI1), uint32_t) & BM_SIM_SCGC6_SPI1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SPI1 field to a new value.
#define BW_SIM_SCGC6_SPI1(v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_SPI1) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC6, field I2S[15] (RW)
 *
 * This bit controls the clock gate to the I 2 S module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC6_I2S     (15U)         //!< Bit position for SIM_SCGC6_I2S.
#define BM_SIM_SCGC6_I2S     (0x00008000U) //!< Bit mask for SIM_SCGC6_I2S.
#define BS_SIM_SCGC6_I2S     (1U)          //!< Bit field size in bits for SIM_SCGC6_I2S.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC6_I2S field.
#define BR_SIM_SCGC6_I2S     (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_I2S))
#endif

//! @brief Format value for bitfield SIM_SCGC6_I2S.
#define BF_SIM_SCGC6_I2S(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC6_I2S), uint32_t) & BM_SIM_SCGC6_I2S)

#ifndef __LANGUAGE_ASM__
//! @brief Set the I2S field to a new value.
#define BW_SIM_SCGC6_I2S(v)  (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_I2S) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC6, field CRC[18] (RW)
 *
 * This bit controls the clock gate to the CRC module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC6_CRC     (18U)         //!< Bit position for SIM_SCGC6_CRC.
#define BM_SIM_SCGC6_CRC     (0x00040000U) //!< Bit mask for SIM_SCGC6_CRC.
#define BS_SIM_SCGC6_CRC     (1U)          //!< Bit field size in bits for SIM_SCGC6_CRC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC6_CRC field.
#define BR_SIM_SCGC6_CRC     (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_CRC))
#endif

//! @brief Format value for bitfield SIM_SCGC6_CRC.
#define BF_SIM_SCGC6_CRC(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC6_CRC), uint32_t) & BM_SIM_SCGC6_CRC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CRC field to a new value.
#define BW_SIM_SCGC6_CRC(v)  (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_CRC) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC6, field USBDCD[21] (RW)
 *
 * This bit controls the clock gate to the USB DCD module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC6_USBDCD  (21U)         //!< Bit position for SIM_SCGC6_USBDCD.
#define BM_SIM_SCGC6_USBDCD  (0x00200000U) //!< Bit mask for SIM_SCGC6_USBDCD.
#define BS_SIM_SCGC6_USBDCD  (1U)          //!< Bit field size in bits for SIM_SCGC6_USBDCD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC6_USBDCD field.
#define BR_SIM_SCGC6_USBDCD  (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_USBDCD))
#endif

//! @brief Format value for bitfield SIM_SCGC6_USBDCD.
#define BF_SIM_SCGC6_USBDCD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC6_USBDCD), uint32_t) & BM_SIM_SCGC6_USBDCD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the USBDCD field to a new value.
#define BW_SIM_SCGC6_USBDCD(v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_USBDCD) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC6, field PDB[22] (RW)
 *
 * This bit controls the clock gate to the PDB module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC6_PDB     (22U)         //!< Bit position for SIM_SCGC6_PDB.
#define BM_SIM_SCGC6_PDB     (0x00400000U) //!< Bit mask for SIM_SCGC6_PDB.
#define BS_SIM_SCGC6_PDB     (1U)          //!< Bit field size in bits for SIM_SCGC6_PDB.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC6_PDB field.
#define BR_SIM_SCGC6_PDB     (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_PDB))
#endif

//! @brief Format value for bitfield SIM_SCGC6_PDB.
#define BF_SIM_SCGC6_PDB(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC6_PDB), uint32_t) & BM_SIM_SCGC6_PDB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PDB field to a new value.
#define BW_SIM_SCGC6_PDB(v)  (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_PDB) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC6, field PIT[23] (RW)
 *
 * This bit controls the clock gate to the PIT module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC6_PIT     (23U)         //!< Bit position for SIM_SCGC6_PIT.
#define BM_SIM_SCGC6_PIT     (0x00800000U) //!< Bit mask for SIM_SCGC6_PIT.
#define BS_SIM_SCGC6_PIT     (1U)          //!< Bit field size in bits for SIM_SCGC6_PIT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC6_PIT field.
#define BR_SIM_SCGC6_PIT     (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_PIT))
#endif

//! @brief Format value for bitfield SIM_SCGC6_PIT.
#define BF_SIM_SCGC6_PIT(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC6_PIT), uint32_t) & BM_SIM_SCGC6_PIT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PIT field to a new value.
#define BW_SIM_SCGC6_PIT(v)  (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_PIT) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC6, field FTM0[24] (RW)
 *
 * This bit controls the clock gate to the FTM0 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC6_FTM0    (24U)         //!< Bit position for SIM_SCGC6_FTM0.
#define BM_SIM_SCGC6_FTM0    (0x01000000U) //!< Bit mask for SIM_SCGC6_FTM0.
#define BS_SIM_SCGC6_FTM0    (1U)          //!< Bit field size in bits for SIM_SCGC6_FTM0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC6_FTM0 field.
#define BR_SIM_SCGC6_FTM0    (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_FTM0))
#endif

//! @brief Format value for bitfield SIM_SCGC6_FTM0.
#define BF_SIM_SCGC6_FTM0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC6_FTM0), uint32_t) & BM_SIM_SCGC6_FTM0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM0 field to a new value.
#define BW_SIM_SCGC6_FTM0(v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_FTM0) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC6, field FTM1[25] (RW)
 *
 * This bit controls the clock gate to the FTM1 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC6_FTM1    (25U)         //!< Bit position for SIM_SCGC6_FTM1.
#define BM_SIM_SCGC6_FTM1    (0x02000000U) //!< Bit mask for SIM_SCGC6_FTM1.
#define BS_SIM_SCGC6_FTM1    (1U)          //!< Bit field size in bits for SIM_SCGC6_FTM1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC6_FTM1 field.
#define BR_SIM_SCGC6_FTM1    (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_FTM1))
#endif

//! @brief Format value for bitfield SIM_SCGC6_FTM1.
#define BF_SIM_SCGC6_FTM1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC6_FTM1), uint32_t) & BM_SIM_SCGC6_FTM1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM1 field to a new value.
#define BW_SIM_SCGC6_FTM1(v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_FTM1) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC6, field FTM2[26] (RW)
 *
 * This bit controls the clock gate to the FTM2 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC6_FTM2    (26U)         //!< Bit position for SIM_SCGC6_FTM2.
#define BM_SIM_SCGC6_FTM2    (0x04000000U) //!< Bit mask for SIM_SCGC6_FTM2.
#define BS_SIM_SCGC6_FTM2    (1U)          //!< Bit field size in bits for SIM_SCGC6_FTM2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC6_FTM2 field.
#define BR_SIM_SCGC6_FTM2    (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_FTM2))
#endif

//! @brief Format value for bitfield SIM_SCGC6_FTM2.
#define BF_SIM_SCGC6_FTM2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC6_FTM2), uint32_t) & BM_SIM_SCGC6_FTM2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FTM2 field to a new value.
#define BW_SIM_SCGC6_FTM2(v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_FTM2) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC6, field ADC0[27] (RW)
 *
 * This bit controls the clock gate to the ADC0 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC6_ADC0    (27U)         //!< Bit position for SIM_SCGC6_ADC0.
#define BM_SIM_SCGC6_ADC0    (0x08000000U) //!< Bit mask for SIM_SCGC6_ADC0.
#define BS_SIM_SCGC6_ADC0    (1U)          //!< Bit field size in bits for SIM_SCGC6_ADC0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC6_ADC0 field.
#define BR_SIM_SCGC6_ADC0    (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_ADC0))
#endif

//! @brief Format value for bitfield SIM_SCGC6_ADC0.
#define BF_SIM_SCGC6_ADC0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC6_ADC0), uint32_t) & BM_SIM_SCGC6_ADC0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADC0 field to a new value.
#define BW_SIM_SCGC6_ADC0(v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_ADC0) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC6, field RTC[29] (RW)
 *
 * This bit controls software access and interrupts to the RTC module.
 *
 * Values:
 * - 0 - Access and interrupts disabled
 * - 1 - Access and interrupts enabled
 */
//@{
#define BP_SIM_SCGC6_RTC     (29U)         //!< Bit position for SIM_SCGC6_RTC.
#define BM_SIM_SCGC6_RTC     (0x20000000U) //!< Bit mask for SIM_SCGC6_RTC.
#define BS_SIM_SCGC6_RTC     (1U)          //!< Bit field size in bits for SIM_SCGC6_RTC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC6_RTC field.
#define BR_SIM_SCGC6_RTC     (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_RTC))
#endif

//! @brief Format value for bitfield SIM_SCGC6_RTC.
#define BF_SIM_SCGC6_RTC(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC6_RTC), uint32_t) & BM_SIM_SCGC6_RTC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RTC field to a new value.
#define BW_SIM_SCGC6_RTC(v)  (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_RTC) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC6, field DAC0[31] (RW)
 *
 * This bit controls the clock gate to the DAC0 module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC6_DAC0    (31U)         //!< Bit position for SIM_SCGC6_DAC0.
#define BM_SIM_SCGC6_DAC0    (0x80000000U) //!< Bit mask for SIM_SCGC6_DAC0.
#define BS_SIM_SCGC6_DAC0    (1U)          //!< Bit field size in bits for SIM_SCGC6_DAC0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC6_DAC0 field.
#define BR_SIM_SCGC6_DAC0    (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_DAC0))
#endif

//! @brief Format value for bitfield SIM_SCGC6_DAC0.
#define BF_SIM_SCGC6_DAC0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC6_DAC0), uint32_t) & BM_SIM_SCGC6_DAC0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DAC0 field to a new value.
#define BW_SIM_SCGC6_DAC0(v) (BITBAND_ACCESS32(HW_SIM_SCGC6_ADDR, BP_SIM_SCGC6_DAC0) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_SCGC7 - System Clock Gating Control Register 7
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_SCGC7 - System Clock Gating Control Register 7 (RW)
 *
 * Reset value: 0x00000006U
 */
typedef union _hw_sim_scgc7
{
    uint32_t U;
    struct _hw_sim_scgc7_bitfields
    {
        uint32_t FLEXBUS : 1;          //!< [0] FlexBus Clock Gate Control
        uint32_t DMAb : 1;             //!< [1] DMA Clock Gate Control
        uint32_t MPUb : 1;             //!< [2] MPU Clock Gate Control
        uint32_t RESERVED0 : 29;       //!< [31:3]
    } B;
} hw_sim_scgc7_t;
#endif

/*!
 * @name Constants and macros for entire SIM_SCGC7 register
 */
//@{
#define HW_SIM_SCGC7_ADDR        (REGS_SIM_BASE + 0x1040U)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_SCGC7             (*(__IO hw_sim_scgc7_t *) HW_SIM_SCGC7_ADDR)
#define HW_SIM_SCGC7_RD()        (HW_SIM_SCGC7.U)
#define HW_SIM_SCGC7_WR(v)       (HW_SIM_SCGC7.U = (v))
#define HW_SIM_SCGC7_SET(v)      (HW_SIM_SCGC7_WR(HW_SIM_SCGC7_RD() |  (v)))
#define HW_SIM_SCGC7_CLR(v)      (HW_SIM_SCGC7_WR(HW_SIM_SCGC7_RD() & ~(v)))
#define HW_SIM_SCGC7_TOG(v)      (HW_SIM_SCGC7_WR(HW_SIM_SCGC7_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SIM_SCGC7 bitfields
 */

/*!
 * @name Register SIM_SCGC7, field FLEXBUS[0] (RW)
 *
 * This bit controls the clock gate to the FlexBus module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC7_FLEXBUS (0U)          //!< Bit position for SIM_SCGC7_FLEXBUS.
#define BM_SIM_SCGC7_FLEXBUS (0x00000001U) //!< Bit mask for SIM_SCGC7_FLEXBUS.
#define BS_SIM_SCGC7_FLEXBUS (1U)          //!< Bit field size in bits for SIM_SCGC7_FLEXBUS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC7_FLEXBUS field.
#define BR_SIM_SCGC7_FLEXBUS (BITBAND_ACCESS32(HW_SIM_SCGC7_ADDR, BP_SIM_SCGC7_FLEXBUS))
#endif

//! @brief Format value for bitfield SIM_SCGC7_FLEXBUS.
#define BF_SIM_SCGC7_FLEXBUS(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC7_FLEXBUS), uint32_t) & BM_SIM_SCGC7_FLEXBUS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FLEXBUS field to a new value.
#define BW_SIM_SCGC7_FLEXBUS(v) (BITBAND_ACCESS32(HW_SIM_SCGC7_ADDR, BP_SIM_SCGC7_FLEXBUS) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC7, field DMA[1] (RW)
 *
 * This bit controls the clock gate to the DMA module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC7_DMA     (1U)          //!< Bit position for SIM_SCGC7_DMA.
#define BM_SIM_SCGC7_DMA     (0x00000002U) //!< Bit mask for SIM_SCGC7_DMA.
#define BS_SIM_SCGC7_DMA     (1U)          //!< Bit field size in bits for SIM_SCGC7_DMA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC7_DMA field.
#define BR_SIM_SCGC7_DMA     (BITBAND_ACCESS32(HW_SIM_SCGC7_ADDR, BP_SIM_SCGC7_DMA))
#endif

//! @brief Format value for bitfield SIM_SCGC7_DMA.
#define BF_SIM_SCGC7_DMA(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC7_DMA), uint32_t) & BM_SIM_SCGC7_DMA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMA field to a new value.
#define BW_SIM_SCGC7_DMA(v)  (BITBAND_ACCESS32(HW_SIM_SCGC7_ADDR, BP_SIM_SCGC7_DMA) = (v))
#endif
//@}

/*!
 * @name Register SIM_SCGC7, field MPU[2] (RW)
 *
 * This bit controls the clock gate to the MPU module.
 *
 * Values:
 * - 0 - Clock disabled
 * - 1 - Clock enabled
 */
//@{
#define BP_SIM_SCGC7_MPU     (2U)          //!< Bit position for SIM_SCGC7_MPU.
#define BM_SIM_SCGC7_MPU     (0x00000004U) //!< Bit mask for SIM_SCGC7_MPU.
#define BS_SIM_SCGC7_MPU     (1U)          //!< Bit field size in bits for SIM_SCGC7_MPU.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_SCGC7_MPU field.
#define BR_SIM_SCGC7_MPU     (BITBAND_ACCESS32(HW_SIM_SCGC7_ADDR, BP_SIM_SCGC7_MPU))
#endif

//! @brief Format value for bitfield SIM_SCGC7_MPU.
#define BF_SIM_SCGC7_MPU(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_SCGC7_MPU), uint32_t) & BM_SIM_SCGC7_MPU)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MPU field to a new value.
#define BW_SIM_SCGC7_MPU(v)  (BITBAND_ACCESS32(HW_SIM_SCGC7_ADDR, BP_SIM_SCGC7_MPU) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_CLKDIV1 - System Clock Divider Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_CLKDIV1 - System Clock Divider Register 1 (RW)
 *
 * Reset value: 0x00010000U
 *
 * When updating CLKDIV1, update all fields using the one write command.
 * Attempting to write an invalid clock ratio to the CLKDIV1 register will cause the
 * write to be ignored. The maximum divide ratio that can be programmed between
 * core/system clock and the other divided clocks is divide by 8. When OUTDIV1 equals
 * 0000 (divide by 1), the other dividers cannot be set higher than 0111 (divide
 * by 8). The CLKDIV1 register cannot be written to when the device is in VLPR
 * mode.
 */
typedef union _hw_sim_clkdiv1
{
    uint32_t U;
    struct _hw_sim_clkdiv1_bitfields
    {
        uint32_t RESERVED0 : 16;       //!< [15:0]
        uint32_t OUTDIV4 : 4;          //!< [19:16] Clock 4 output divider value
        uint32_t OUTDIV3 : 4;          //!< [23:20] Clock 3 output divider value
        uint32_t OUTDIV2 : 4;          //!< [27:24] Clock 2 output divider value
        uint32_t OUTDIV1 : 4;          //!< [31:28] Clock 1 output divider value
    } B;
} hw_sim_clkdiv1_t;
#endif

/*!
 * @name Constants and macros for entire SIM_CLKDIV1 register
 */
//@{
#define HW_SIM_CLKDIV1_ADDR      (REGS_SIM_BASE + 0x1044U)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_CLKDIV1           (*(__IO hw_sim_clkdiv1_t *) HW_SIM_CLKDIV1_ADDR)
#define HW_SIM_CLKDIV1_RD()      (HW_SIM_CLKDIV1.U)
#define HW_SIM_CLKDIV1_WR(v)     (HW_SIM_CLKDIV1.U = (v))
#define HW_SIM_CLKDIV1_SET(v)    (HW_SIM_CLKDIV1_WR(HW_SIM_CLKDIV1_RD() |  (v)))
#define HW_SIM_CLKDIV1_CLR(v)    (HW_SIM_CLKDIV1_WR(HW_SIM_CLKDIV1_RD() & ~(v)))
#define HW_SIM_CLKDIV1_TOG(v)    (HW_SIM_CLKDIV1_WR(HW_SIM_CLKDIV1_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SIM_CLKDIV1 bitfields
 */

/*!
 * @name Register SIM_CLKDIV1, field OUTDIV4[19:16] (RW)
 *
 * This field sets the divide value for the flash clock from MCGOUTCLK. At the
 * end of reset, it is loaded with either 0001 or 1111 depending on
 * FTF_FOPT[LPBOOT]. The flash clock frequency must be an integer divide of the system clock
 * frequency.
 *
 * Values:
 * - 0000 - Divide-by-1.
 * - 0001 - Divide-by-2.
 * - 0010 - Divide-by-3.
 * - 0011 - Divide-by-4.
 * - 0100 - Divide-by-5.
 * - 0101 - Divide-by-6.
 * - 0110 - Divide-by-7.
 * - 0111 - Divide-by-8.
 * - 1000 - Divide-by-9.
 * - 1001 - Divide-by-10.
 * - 1010 - Divide-by-11.
 * - 1011 - Divide-by-12.
 * - 1100 - Divide-by-13.
 * - 1101 - Divide-by-14.
 * - 1110 - Divide-by-15.
 * - 1111 - Divide-by-16.
 */
//@{
#define BP_SIM_CLKDIV1_OUTDIV4 (16U)       //!< Bit position for SIM_CLKDIV1_OUTDIV4.
#define BM_SIM_CLKDIV1_OUTDIV4 (0x000F0000U) //!< Bit mask for SIM_CLKDIV1_OUTDIV4.
#define BS_SIM_CLKDIV1_OUTDIV4 (4U)        //!< Bit field size in bits for SIM_CLKDIV1_OUTDIV4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_CLKDIV1_OUTDIV4 field.
#define BR_SIM_CLKDIV1_OUTDIV4 (HW_SIM_CLKDIV1.B.OUTDIV4)
#endif

//! @brief Format value for bitfield SIM_CLKDIV1_OUTDIV4.
#define BF_SIM_CLKDIV1_OUTDIV4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_CLKDIV1_OUTDIV4), uint32_t) & BM_SIM_CLKDIV1_OUTDIV4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OUTDIV4 field to a new value.
#define BW_SIM_CLKDIV1_OUTDIV4(v) (HW_SIM_CLKDIV1_WR((HW_SIM_CLKDIV1_RD() & ~BM_SIM_CLKDIV1_OUTDIV4) | BF_SIM_CLKDIV1_OUTDIV4(v)))
#endif
//@}

/*!
 * @name Register SIM_CLKDIV1, field OUTDIV3[23:20] (RW)
 *
 * This field sets the divide value for the FlexBus clock (external pin FB_CLK)
 * from MCGOUTCLK. At the end of reset, it is loaded with either 0001 or 1111
 * depending on FTF_FOPT[LPBOOT]. The FlexBus clock frequency must be an integer
 * divide of the system clock frequency.
 *
 * Values:
 * - 0000 - Divide-by-1.
 * - 0001 - Divide-by-2.
 * - 0010 - Divide-by-3.
 * - 0011 - Divide-by-4.
 * - 0100 - Divide-by-5.
 * - 0101 - Divide-by-6.
 * - 0110 - Divide-by-7.
 * - 0111 - Divide-by-8.
 * - 1000 - Divide-by-9.
 * - 1001 - Divide-by-10.
 * - 1010 - Divide-by-11.
 * - 1011 - Divide-by-12.
 * - 1100 - Divide-by-13.
 * - 1101 - Divide-by-14.
 * - 1110 - Divide-by-15.
 * - 1111 - Divide-by-16.
 */
//@{
#define BP_SIM_CLKDIV1_OUTDIV3 (20U)       //!< Bit position for SIM_CLKDIV1_OUTDIV3.
#define BM_SIM_CLKDIV1_OUTDIV3 (0x00F00000U) //!< Bit mask for SIM_CLKDIV1_OUTDIV3.
#define BS_SIM_CLKDIV1_OUTDIV3 (4U)        //!< Bit field size in bits for SIM_CLKDIV1_OUTDIV3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_CLKDIV1_OUTDIV3 field.
#define BR_SIM_CLKDIV1_OUTDIV3 (HW_SIM_CLKDIV1.B.OUTDIV3)
#endif

//! @brief Format value for bitfield SIM_CLKDIV1_OUTDIV3.
#define BF_SIM_CLKDIV1_OUTDIV3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_CLKDIV1_OUTDIV3), uint32_t) & BM_SIM_CLKDIV1_OUTDIV3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OUTDIV3 field to a new value.
#define BW_SIM_CLKDIV1_OUTDIV3(v) (HW_SIM_CLKDIV1_WR((HW_SIM_CLKDIV1_RD() & ~BM_SIM_CLKDIV1_OUTDIV3) | BF_SIM_CLKDIV1_OUTDIV3(v)))
#endif
//@}

/*!
 * @name Register SIM_CLKDIV1, field OUTDIV2[27:24] (RW)
 *
 * This field sets the divide value for the bus clock from MCGOUTCLK. At the end
 * of reset, it is loaded with either 0000 or 0111 depending on
 * FTF_FOPT[LPBOOT]. The bus clock frequency must be an integer divide of the core/system clock
 * frequency.
 *
 * Values:
 * - 0000 - Divide-by-1.
 * - 0001 - Divide-by-2.
 * - 0010 - Divide-by-3.
 * - 0011 - Divide-by-4.
 * - 0100 - Divide-by-5.
 * - 0101 - Divide-by-6.
 * - 0110 - Divide-by-7.
 * - 0111 - Divide-by-8.
 * - 1000 - Divide-by-9.
 * - 1001 - Divide-by-10.
 * - 1010 - Divide-by-11.
 * - 1011 - Divide-by-12.
 * - 1100 - Divide-by-13.
 * - 1101 - Divide-by-14.
 * - 1110 - Divide-by-15.
 * - 1111 - Divide-by-16.
 */
//@{
#define BP_SIM_CLKDIV1_OUTDIV2 (24U)       //!< Bit position for SIM_CLKDIV1_OUTDIV2.
#define BM_SIM_CLKDIV1_OUTDIV2 (0x0F000000U) //!< Bit mask for SIM_CLKDIV1_OUTDIV2.
#define BS_SIM_CLKDIV1_OUTDIV2 (4U)        //!< Bit field size in bits for SIM_CLKDIV1_OUTDIV2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_CLKDIV1_OUTDIV2 field.
#define BR_SIM_CLKDIV1_OUTDIV2 (HW_SIM_CLKDIV1.B.OUTDIV2)
#endif

//! @brief Format value for bitfield SIM_CLKDIV1_OUTDIV2.
#define BF_SIM_CLKDIV1_OUTDIV2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_CLKDIV1_OUTDIV2), uint32_t) & BM_SIM_CLKDIV1_OUTDIV2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OUTDIV2 field to a new value.
#define BW_SIM_CLKDIV1_OUTDIV2(v) (HW_SIM_CLKDIV1_WR((HW_SIM_CLKDIV1_RD() & ~BM_SIM_CLKDIV1_OUTDIV2) | BF_SIM_CLKDIV1_OUTDIV2(v)))
#endif
//@}

/*!
 * @name Register SIM_CLKDIV1, field OUTDIV1[31:28] (RW)
 *
 * This field sets the divide value for the core/system clock from MCGOUTCLK. At
 * the end of reset, it is loaded with either 0000 or 0111 depending on
 * FTF_FOPT[LPBOOT].
 *
 * Values:
 * - 0000 - Divide-by-1.
 * - 0001 - Divide-by-2.
 * - 0010 - Divide-by-3.
 * - 0011 - Divide-by-4.
 * - 0100 - Divide-by-5.
 * - 0101 - Divide-by-6.
 * - 0110 - Divide-by-7.
 * - 0111 - Divide-by-8.
 * - 1000 - Divide-by-9.
 * - 1001 - Divide-by-10.
 * - 1010 - Divide-by-11.
 * - 1011 - Divide-by-12.
 * - 1100 - Divide-by-13.
 * - 1101 - Divide-by-14.
 * - 1110 - Divide-by-15.
 * - 1111 - Divide-by-16.
 */
//@{
#define BP_SIM_CLKDIV1_OUTDIV1 (28U)       //!< Bit position for SIM_CLKDIV1_OUTDIV1.
#define BM_SIM_CLKDIV1_OUTDIV1 (0xF0000000U) //!< Bit mask for SIM_CLKDIV1_OUTDIV1.
#define BS_SIM_CLKDIV1_OUTDIV1 (4U)        //!< Bit field size in bits for SIM_CLKDIV1_OUTDIV1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_CLKDIV1_OUTDIV1 field.
#define BR_SIM_CLKDIV1_OUTDIV1 (HW_SIM_CLKDIV1.B.OUTDIV1)
#endif

//! @brief Format value for bitfield SIM_CLKDIV1_OUTDIV1.
#define BF_SIM_CLKDIV1_OUTDIV1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_CLKDIV1_OUTDIV1), uint32_t) & BM_SIM_CLKDIV1_OUTDIV1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OUTDIV1 field to a new value.
#define BW_SIM_CLKDIV1_OUTDIV1(v) (HW_SIM_CLKDIV1_WR((HW_SIM_CLKDIV1_RD() & ~BM_SIM_CLKDIV1_OUTDIV1) | BF_SIM_CLKDIV1_OUTDIV1(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_CLKDIV2 - System Clock Divider Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_CLKDIV2 - System Clock Divider Register 2 (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_sim_clkdiv2
{
    uint32_t U;
    struct _hw_sim_clkdiv2_bitfields
    {
        uint32_t USBFRAC : 1;          //!< [0] USB clock divider fraction
        uint32_t USBDIV : 3;           //!< [3:1] USB clock divider divisor
        uint32_t RESERVED0 : 28;       //!< [31:4]
    } B;
} hw_sim_clkdiv2_t;
#endif

/*!
 * @name Constants and macros for entire SIM_CLKDIV2 register
 */
//@{
#define HW_SIM_CLKDIV2_ADDR      (REGS_SIM_BASE + 0x1048U)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_CLKDIV2           (*(__IO hw_sim_clkdiv2_t *) HW_SIM_CLKDIV2_ADDR)
#define HW_SIM_CLKDIV2_RD()      (HW_SIM_CLKDIV2.U)
#define HW_SIM_CLKDIV2_WR(v)     (HW_SIM_CLKDIV2.U = (v))
#define HW_SIM_CLKDIV2_SET(v)    (HW_SIM_CLKDIV2_WR(HW_SIM_CLKDIV2_RD() |  (v)))
#define HW_SIM_CLKDIV2_CLR(v)    (HW_SIM_CLKDIV2_WR(HW_SIM_CLKDIV2_RD() & ~(v)))
#define HW_SIM_CLKDIV2_TOG(v)    (HW_SIM_CLKDIV2_WR(HW_SIM_CLKDIV2_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SIM_CLKDIV2 bitfields
 */

/*!
 * @name Register SIM_CLKDIV2, field USBFRAC[0] (RW)
 *
 * This field sets the fraction multiply value for the fractional clock divider
 * when the MCGFLLCLK/MCGPLLCLK clock is the USB clock source (SOPT2[USBSRC] =
 * 1). Divider output clock = Divider input clock * [ (USBFRAC+1) / (USBDIV+1) ]
 */
//@{
#define BP_SIM_CLKDIV2_USBFRAC (0U)        //!< Bit position for SIM_CLKDIV2_USBFRAC.
#define BM_SIM_CLKDIV2_USBFRAC (0x00000001U) //!< Bit mask for SIM_CLKDIV2_USBFRAC.
#define BS_SIM_CLKDIV2_USBFRAC (1U)        //!< Bit field size in bits for SIM_CLKDIV2_USBFRAC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_CLKDIV2_USBFRAC field.
#define BR_SIM_CLKDIV2_USBFRAC (BITBAND_ACCESS32(HW_SIM_CLKDIV2_ADDR, BP_SIM_CLKDIV2_USBFRAC))
#endif

//! @brief Format value for bitfield SIM_CLKDIV2_USBFRAC.
#define BF_SIM_CLKDIV2_USBFRAC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_CLKDIV2_USBFRAC), uint32_t) & BM_SIM_CLKDIV2_USBFRAC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the USBFRAC field to a new value.
#define BW_SIM_CLKDIV2_USBFRAC(v) (BITBAND_ACCESS32(HW_SIM_CLKDIV2_ADDR, BP_SIM_CLKDIV2_USBFRAC) = (v))
#endif
//@}

/*!
 * @name Register SIM_CLKDIV2, field USBDIV[3:1] (RW)
 *
 * This field sets the divide value for the fractional clock divider when the
 * MCGFLLCLK/MCGPLLCLK clock is the USB clock source (SOPT2[USBSRC] = 1). Divider
 * output clock = Divider input clock * [ (USBFRAC+1) / (USBDIV+1) ]
 */
//@{
#define BP_SIM_CLKDIV2_USBDIV (1U)         //!< Bit position for SIM_CLKDIV2_USBDIV.
#define BM_SIM_CLKDIV2_USBDIV (0x0000000EU) //!< Bit mask for SIM_CLKDIV2_USBDIV.
#define BS_SIM_CLKDIV2_USBDIV (3U)         //!< Bit field size in bits for SIM_CLKDIV2_USBDIV.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_CLKDIV2_USBDIV field.
#define BR_SIM_CLKDIV2_USBDIV (HW_SIM_CLKDIV2.B.USBDIV)
#endif

//! @brief Format value for bitfield SIM_CLKDIV2_USBDIV.
#define BF_SIM_CLKDIV2_USBDIV(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_CLKDIV2_USBDIV), uint32_t) & BM_SIM_CLKDIV2_USBDIV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the USBDIV field to a new value.
#define BW_SIM_CLKDIV2_USBDIV(v) (HW_SIM_CLKDIV2_WR((HW_SIM_CLKDIV2_RD() & ~BM_SIM_CLKDIV2_USBDIV) | BF_SIM_CLKDIV2_USBDIV(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_FCFG1 - Flash Configuration Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_FCFG1 - Flash Configuration Register 1 (RW)
 *
 * Reset value: 0xFF0F0F00U
 *
 * For devices with FlexNVM: The reset value of EESIZE and DEPART are based on
 * user programming in user IFR via the PGMPART flash command. For devices with
 * program flash only:
 */
typedef union _hw_sim_fcfg1
{
    uint32_t U;
    struct _hw_sim_fcfg1_bitfields
    {
        uint32_t FLASHDIS : 1;         //!< [0] Flash Disable
        uint32_t FLASHDOZE : 1;        //!< [1] Flash Doze
        uint32_t RESERVED0 : 6;        //!< [7:2]
        uint32_t DEPART : 4;           //!< [11:8] FlexNVM partition
        uint32_t RESERVED1 : 4;        //!< [15:12]
        uint32_t EESIZE : 4;           //!< [19:16] EEPROM size
        uint32_t RESERVED2 : 4;        //!< [23:20]
        uint32_t PFSIZE : 4;           //!< [27:24] Program flash size
        uint32_t NVMSIZE : 4;          //!< [31:28] FlexNVM size
    } B;
} hw_sim_fcfg1_t;
#endif

/*!
 * @name Constants and macros for entire SIM_FCFG1 register
 */
//@{
#define HW_SIM_FCFG1_ADDR        (REGS_SIM_BASE + 0x104CU)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_FCFG1             (*(__IO hw_sim_fcfg1_t *) HW_SIM_FCFG1_ADDR)
#define HW_SIM_FCFG1_RD()        (HW_SIM_FCFG1.U)
#define HW_SIM_FCFG1_WR(v)       (HW_SIM_FCFG1.U = (v))
#define HW_SIM_FCFG1_SET(v)      (HW_SIM_FCFG1_WR(HW_SIM_FCFG1_RD() |  (v)))
#define HW_SIM_FCFG1_CLR(v)      (HW_SIM_FCFG1_WR(HW_SIM_FCFG1_RD() & ~(v)))
#define HW_SIM_FCFG1_TOG(v)      (HW_SIM_FCFG1_WR(HW_SIM_FCFG1_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SIM_FCFG1 bitfields
 */

/*!
 * @name Register SIM_FCFG1, field FLASHDIS[0] (RW)
 *
 * Flash accesses are disabled (and generate a bus error) and the Flash memory
 * is placed in a low power state. This bit should not be changed during VLP
 * modes. Relocate the interrupt vectors out of Flash memory before disabling the
 * Flash.
 *
 * Values:
 * - 0 - Flash is enabled
 * - 1 - Flash is disabled
 */
//@{
#define BP_SIM_FCFG1_FLASHDIS (0U)         //!< Bit position for SIM_FCFG1_FLASHDIS.
#define BM_SIM_FCFG1_FLASHDIS (0x00000001U) //!< Bit mask for SIM_FCFG1_FLASHDIS.
#define BS_SIM_FCFG1_FLASHDIS (1U)         //!< Bit field size in bits for SIM_FCFG1_FLASHDIS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_FCFG1_FLASHDIS field.
#define BR_SIM_FCFG1_FLASHDIS (BITBAND_ACCESS32(HW_SIM_FCFG1_ADDR, BP_SIM_FCFG1_FLASHDIS))
#endif

//! @brief Format value for bitfield SIM_FCFG1_FLASHDIS.
#define BF_SIM_FCFG1_FLASHDIS(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_FCFG1_FLASHDIS), uint32_t) & BM_SIM_FCFG1_FLASHDIS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FLASHDIS field to a new value.
#define BW_SIM_FCFG1_FLASHDIS(v) (BITBAND_ACCESS32(HW_SIM_FCFG1_ADDR, BP_SIM_FCFG1_FLASHDIS) = (v))
#endif
//@}

/*!
 * @name Register SIM_FCFG1, field FLASHDOZE[1] (RW)
 *
 * When set, Flash memory is disabled for the duration of Wait mode. An attempt
 * by the DMA or other bus master to access the Flash when the Flash is disabled
 * will result in a bus error. This bit should be clear during VLP modes. The
 * Flash will be automatically enabled again at the end of Wait mode so interrupt
 * vectors do not need to be relocated out of Flash memory. The wakeup time from
 * Wait mode is extended when this bit is set.
 *
 * Values:
 * - 0 - Flash remains enabled during Wait mode
 * - 1 - Flash is disabled for the duration of Wait mode
 */
//@{
#define BP_SIM_FCFG1_FLASHDOZE (1U)        //!< Bit position for SIM_FCFG1_FLASHDOZE.
#define BM_SIM_FCFG1_FLASHDOZE (0x00000002U) //!< Bit mask for SIM_FCFG1_FLASHDOZE.
#define BS_SIM_FCFG1_FLASHDOZE (1U)        //!< Bit field size in bits for SIM_FCFG1_FLASHDOZE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_FCFG1_FLASHDOZE field.
#define BR_SIM_FCFG1_FLASHDOZE (BITBAND_ACCESS32(HW_SIM_FCFG1_ADDR, BP_SIM_FCFG1_FLASHDOZE))
#endif

//! @brief Format value for bitfield SIM_FCFG1_FLASHDOZE.
#define BF_SIM_FCFG1_FLASHDOZE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SIM_FCFG1_FLASHDOZE), uint32_t) & BM_SIM_FCFG1_FLASHDOZE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FLASHDOZE field to a new value.
#define BW_SIM_FCFG1_FLASHDOZE(v) (BITBAND_ACCESS32(HW_SIM_FCFG1_ADDR, BP_SIM_FCFG1_FLASHDOZE) = (v))
#endif
//@}

/*!
 * @name Register SIM_FCFG1, field DEPART[11:8] (RO)
 *
 * For devices with FlexNVM: Data flash / EEPROM backup split . See DEPART bit
 * description in FTFE chapter. For devices without FlexNVM: Reserved
 */
//@{
#define BP_SIM_FCFG1_DEPART  (8U)          //!< Bit position for SIM_FCFG1_DEPART.
#define BM_SIM_FCFG1_DEPART  (0x00000F00U) //!< Bit mask for SIM_FCFG1_DEPART.
#define BS_SIM_FCFG1_DEPART  (4U)          //!< Bit field size in bits for SIM_FCFG1_DEPART.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_FCFG1_DEPART field.
#define BR_SIM_FCFG1_DEPART  (HW_SIM_FCFG1.B.DEPART)
#endif
//@}

/*!
 * @name Register SIM_FCFG1, field EESIZE[19:16] (RO)
 *
 * EEPROM data size .
 *
 * Values:
 * - 0000 - 16 KB
 * - 0001 - 8 KB
 * - 0010 - 4 KB
 * - 0011 - 2 KB
 * - 0100 - 1 KB
 * - 0101 - 512 Bytes
 * - 0110 - 256 Bytes
 * - 0111 - 128 Bytes
 * - 1000 - 64 Bytes
 * - 1001 - 32 Bytes
 * - 1111 - 0 Bytes
 */
//@{
#define BP_SIM_FCFG1_EESIZE  (16U)         //!< Bit position for SIM_FCFG1_EESIZE.
#define BM_SIM_FCFG1_EESIZE  (0x000F0000U) //!< Bit mask for SIM_FCFG1_EESIZE.
#define BS_SIM_FCFG1_EESIZE  (4U)          //!< Bit field size in bits for SIM_FCFG1_EESIZE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_FCFG1_EESIZE field.
#define BR_SIM_FCFG1_EESIZE  (HW_SIM_FCFG1.B.EESIZE)
#endif
//@}

/*!
 * @name Register SIM_FCFG1, field PFSIZE[27:24] (RO)
 *
 * This field specifies the amount of program flash memory available on the
 * device . Undefined values are reserved.
 *
 * Values:
 * - 0011 - 32 KB of program flash memory
 * - 0101 - 64 KB of program flash memory
 * - 0111 - 128 KB of program flash memory
 * - 1001 - 256 KB of program flash memory
 * - 1011 - 512 KB of program flash memory
 * - 1101 - 1024 KB of program flash memory
 * - 1111 - 1024 KB of program flash memory
 */
//@{
#define BP_SIM_FCFG1_PFSIZE  (24U)         //!< Bit position for SIM_FCFG1_PFSIZE.
#define BM_SIM_FCFG1_PFSIZE  (0x0F000000U) //!< Bit mask for SIM_FCFG1_PFSIZE.
#define BS_SIM_FCFG1_PFSIZE  (4U)          //!< Bit field size in bits for SIM_FCFG1_PFSIZE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_FCFG1_PFSIZE field.
#define BR_SIM_FCFG1_PFSIZE  (HW_SIM_FCFG1.B.PFSIZE)
#endif
//@}

/*!
 * @name Register SIM_FCFG1, field NVMSIZE[31:28] (RO)
 *
 * This field specifies the amount of FlexNVM memory available on the device .
 * Undefined values are reserved.
 *
 * Values:
 * - 0000 - 0 KB of FlexNVM
 * - 0011 - 32 KB of FlexNVM
 * - 0101 - 64 KB of FlexNVM
 * - 0111 - 128 KB of FlexNVM
 * - 1001 - 256 KB of FlexNVM
 * - 1011 - 512 KB of FlexNVM
 * - 1111 - 512 KB of FlexNVM
 */
//@{
#define BP_SIM_FCFG1_NVMSIZE (28U)         //!< Bit position for SIM_FCFG1_NVMSIZE.
#define BM_SIM_FCFG1_NVMSIZE (0xF0000000U) //!< Bit mask for SIM_FCFG1_NVMSIZE.
#define BS_SIM_FCFG1_NVMSIZE (4U)          //!< Bit field size in bits for SIM_FCFG1_NVMSIZE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_FCFG1_NVMSIZE field.
#define BR_SIM_FCFG1_NVMSIZE (HW_SIM_FCFG1.B.NVMSIZE)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_FCFG2 - Flash Configuration Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_FCFG2 - Flash Configuration Register 2 (RO)
 *
 * Reset value: 0x7F7F0000U
 */
typedef union _hw_sim_fcfg2
{
    uint32_t U;
    struct _hw_sim_fcfg2_bitfields
    {
        uint32_t RESERVED0 : 16;       //!< [15:0]
        uint32_t MAXADDR1 : 7;         //!< [22:16] Max address block 1
        uint32_t PFLSH : 1;            //!< [23] Program flash only
        uint32_t MAXADDR0 : 7;         //!< [30:24] Max address block 0
        uint32_t RESERVED1 : 1;        //!< [31]
    } B;
} hw_sim_fcfg2_t;
#endif

/*!
 * @name Constants and macros for entire SIM_FCFG2 register
 */
//@{
#define HW_SIM_FCFG2_ADDR        (REGS_SIM_BASE + 0x1050U)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_FCFG2             (*(__I hw_sim_fcfg2_t *) HW_SIM_FCFG2_ADDR)
#define HW_SIM_FCFG2_RD()        (HW_SIM_FCFG2.U)
#endif
//@}

/*
 * Constants & macros for individual SIM_FCFG2 bitfields
 */

/*!
 * @name Register SIM_FCFG2, field MAXADDR1[22:16] (RO)
 *
 * For devices with FlexNVM: This field concatenated with 13 trailing zeros plus
 * the FlexNVM base address indicates the first invalid address of the FlexNVM
 * flash block. For example, if MAXADDR1 = 0x20 the first invalid address of
 * FlexNVM flash block is 0x4_0000 + 0x1000_0000 . This would be the MAXADDR1 value
 * for a device with 256 KB FlexNVM. For devices with program flash only: This
 * field equals zero if there is only one program flash block, otherwise it equals
 * the value of the MAXADDR0 field. For example, with MAXADDR0 = MAXADDR1 = 0x20
 * the first invalid address of flash block 1 is 0x4_0000 + 0x4_0000. This would be
 * the MAXADDR1 value for a device with 512 KB program flash memory across two
 * flash blocks and no FlexNVM.
 */
//@{
#define BP_SIM_FCFG2_MAXADDR1 (16U)        //!< Bit position for SIM_FCFG2_MAXADDR1.
#define BM_SIM_FCFG2_MAXADDR1 (0x007F0000U) //!< Bit mask for SIM_FCFG2_MAXADDR1.
#define BS_SIM_FCFG2_MAXADDR1 (7U)         //!< Bit field size in bits for SIM_FCFG2_MAXADDR1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_FCFG2_MAXADDR1 field.
#define BR_SIM_FCFG2_MAXADDR1 (HW_SIM_FCFG2.B.MAXADDR1)
#endif
//@}

/*!
 * @name Register SIM_FCFG2, field PFLSH[23] (RO)
 *
 * For devices with FlexNVM, this bit is always clear. For devices without
 * FlexNVM, this bit is always set.
 *
 * Values:
 * - 0 - Device supports FlexNVM
 * - 1 - Program Flash only, device does not support FlexNVM
 */
//@{
#define BP_SIM_FCFG2_PFLSH   (23U)         //!< Bit position for SIM_FCFG2_PFLSH.
#define BM_SIM_FCFG2_PFLSH   (0x00800000U) //!< Bit mask for SIM_FCFG2_PFLSH.
#define BS_SIM_FCFG2_PFLSH   (1U)          //!< Bit field size in bits for SIM_FCFG2_PFLSH.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_FCFG2_PFLSH field.
#define BR_SIM_FCFG2_PFLSH   (BITBAND_ACCESS32(HW_SIM_FCFG2_ADDR, BP_SIM_FCFG2_PFLSH))
#endif
//@}

/*!
 * @name Register SIM_FCFG2, field MAXADDR0[30:24] (RO)
 *
 * This field concatenated with 13 trailing zeros indicates the first invalid
 * address of each program flash block. For example, if MAXADDR0 = 0x20 the first
 * invalid address of flash block 0 is 0x0004_0000. This would be the MAXADDR0
 * value for a device with 256 KB program flash in flash block 0.
 */
//@{
#define BP_SIM_FCFG2_MAXADDR0 (24U)        //!< Bit position for SIM_FCFG2_MAXADDR0.
#define BM_SIM_FCFG2_MAXADDR0 (0x7F000000U) //!< Bit mask for SIM_FCFG2_MAXADDR0.
#define BS_SIM_FCFG2_MAXADDR0 (7U)         //!< Bit field size in bits for SIM_FCFG2_MAXADDR0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_FCFG2_MAXADDR0 field.
#define BR_SIM_FCFG2_MAXADDR0 (HW_SIM_FCFG2.B.MAXADDR0)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_UIDH - Unique Identification Register High
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_UIDH - Unique Identification Register High (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_sim_uidh
{
    uint32_t U;
    struct _hw_sim_uidh_bitfields
    {
        uint32_t UID : 32;             //!< [31:0] Unique Identification
    } B;
} hw_sim_uidh_t;
#endif

/*!
 * @name Constants and macros for entire SIM_UIDH register
 */
//@{
#define HW_SIM_UIDH_ADDR         (REGS_SIM_BASE + 0x1054U)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_UIDH              (*(__I hw_sim_uidh_t *) HW_SIM_UIDH_ADDR)
#define HW_SIM_UIDH_RD()         (HW_SIM_UIDH.U)
#endif
//@}

/*
 * Constants & macros for individual SIM_UIDH bitfields
 */

/*!
 * @name Register SIM_UIDH, field UID[31:0] (RO)
 *
 * Unique identification for the device.
 */
//@{
#define BP_SIM_UIDH_UID      (0U)          //!< Bit position for SIM_UIDH_UID.
#define BM_SIM_UIDH_UID      (0xFFFFFFFFU) //!< Bit mask for SIM_UIDH_UID.
#define BS_SIM_UIDH_UID      (32U)         //!< Bit field size in bits for SIM_UIDH_UID.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_UIDH_UID field.
#define BR_SIM_UIDH_UID      (HW_SIM_UIDH.U)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_UIDMH - Unique Identification Register Mid-High
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_UIDMH - Unique Identification Register Mid-High (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_sim_uidmh
{
    uint32_t U;
    struct _hw_sim_uidmh_bitfields
    {
        uint32_t UID : 32;             //!< [31:0] Unique Identification
    } B;
} hw_sim_uidmh_t;
#endif

/*!
 * @name Constants and macros for entire SIM_UIDMH register
 */
//@{
#define HW_SIM_UIDMH_ADDR        (REGS_SIM_BASE + 0x1058U)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_UIDMH             (*(__I hw_sim_uidmh_t *) HW_SIM_UIDMH_ADDR)
#define HW_SIM_UIDMH_RD()        (HW_SIM_UIDMH.U)
#endif
//@}

/*
 * Constants & macros for individual SIM_UIDMH bitfields
 */

/*!
 * @name Register SIM_UIDMH, field UID[31:0] (RO)
 *
 * Unique identification for the device.
 */
//@{
#define BP_SIM_UIDMH_UID     (0U)          //!< Bit position for SIM_UIDMH_UID.
#define BM_SIM_UIDMH_UID     (0xFFFFFFFFU) //!< Bit mask for SIM_UIDMH_UID.
#define BS_SIM_UIDMH_UID     (32U)         //!< Bit field size in bits for SIM_UIDMH_UID.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_UIDMH_UID field.
#define BR_SIM_UIDMH_UID     (HW_SIM_UIDMH.U)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_UIDML - Unique Identification Register Mid Low
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_UIDML - Unique Identification Register Mid Low (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_sim_uidml
{
    uint32_t U;
    struct _hw_sim_uidml_bitfields
    {
        uint32_t UID : 32;             //!< [31:0] Unique Identification
    } B;
} hw_sim_uidml_t;
#endif

/*!
 * @name Constants and macros for entire SIM_UIDML register
 */
//@{
#define HW_SIM_UIDML_ADDR        (REGS_SIM_BASE + 0x105CU)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_UIDML             (*(__I hw_sim_uidml_t *) HW_SIM_UIDML_ADDR)
#define HW_SIM_UIDML_RD()        (HW_SIM_UIDML.U)
#endif
//@}

/*
 * Constants & macros for individual SIM_UIDML bitfields
 */

/*!
 * @name Register SIM_UIDML, field UID[31:0] (RO)
 *
 * Unique identification for the device.
 */
//@{
#define BP_SIM_UIDML_UID     (0U)          //!< Bit position for SIM_UIDML_UID.
#define BM_SIM_UIDML_UID     (0xFFFFFFFFU) //!< Bit mask for SIM_UIDML_UID.
#define BS_SIM_UIDML_UID     (32U)         //!< Bit field size in bits for SIM_UIDML_UID.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_UIDML_UID field.
#define BR_SIM_UIDML_UID     (HW_SIM_UIDML.U)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SIM_UIDL - Unique Identification Register Low
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SIM_UIDL - Unique Identification Register Low (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_sim_uidl
{
    uint32_t U;
    struct _hw_sim_uidl_bitfields
    {
        uint32_t UID : 32;             //!< [31:0] Unique Identification
    } B;
} hw_sim_uidl_t;
#endif

/*!
 * @name Constants and macros for entire SIM_UIDL register
 */
//@{
#define HW_SIM_UIDL_ADDR         (REGS_SIM_BASE + 0x1060U)

#ifndef __LANGUAGE_ASM__
#define HW_SIM_UIDL              (*(__I hw_sim_uidl_t *) HW_SIM_UIDL_ADDR)
#define HW_SIM_UIDL_RD()         (HW_SIM_UIDL.U)
#endif
//@}

/*
 * Constants & macros for individual SIM_UIDL bitfields
 */

/*!
 * @name Register SIM_UIDL, field UID[31:0] (RO)
 *
 * Unique identification for the device.
 */
//@{
#define BP_SIM_UIDL_UID      (0U)          //!< Bit position for SIM_UIDL_UID.
#define BM_SIM_UIDL_UID      (0xFFFFFFFFU) //!< Bit mask for SIM_UIDL_UID.
#define BS_SIM_UIDL_UID      (32U)         //!< Bit field size in bits for SIM_UIDL_UID.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SIM_UIDL_UID field.
#define BR_SIM_UIDL_UID      (HW_SIM_UIDL.U)
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_sim_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All SIM module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_sim
{
    __IO hw_sim_sopt1_t SOPT1;             //!< [0x0] System Options Register 1
    __IO hw_sim_sopt1cfg_t SOPT1CFG;       //!< [0x4] SOPT1 Configuration Register
    uint8_t _reserved0[4092];
    __IO hw_sim_sopt2_t SOPT2;             //!< [0x1004] System Options Register 2
    uint8_t _reserved1[4];
    __IO hw_sim_sopt4_t SOPT4;             //!< [0x100C] System Options Register 4
    __IO hw_sim_sopt5_t SOPT5;             //!< [0x1010] System Options Register 5
    uint8_t _reserved2[4];
    __IO hw_sim_sopt7_t SOPT7;             //!< [0x1018] System Options Register 7
    uint8_t _reserved3[8];
    __I hw_sim_sdid_t SDID;                //!< [0x1024] System Device Identification Register
    __IO hw_sim_scgc1_t SCGC1;             //!< [0x1028] System Clock Gating Control Register 1
    __IO hw_sim_scgc2_t SCGC2;             //!< [0x102C] System Clock Gating Control Register 2
    __IO hw_sim_scgc3_t SCGC3;             //!< [0x1030] System Clock Gating Control Register 3
    __IO hw_sim_scgc4_t SCGC4;             //!< [0x1034] System Clock Gating Control Register 4
    __IO hw_sim_scgc5_t SCGC5;             //!< [0x1038] System Clock Gating Control Register 5
    __IO hw_sim_scgc6_t SCGC6;             //!< [0x103C] System Clock Gating Control Register 6
    __IO hw_sim_scgc7_t SCGC7;             //!< [0x1040] System Clock Gating Control Register 7
    __IO hw_sim_clkdiv1_t CLKDIV1;         //!< [0x1044] System Clock Divider Register 1
    __IO hw_sim_clkdiv2_t CLKDIV2;         //!< [0x1048] System Clock Divider Register 2
    __IO hw_sim_fcfg1_t FCFG1;             //!< [0x104C] Flash Configuration Register 1
    __I hw_sim_fcfg2_t FCFG2;              //!< [0x1050] Flash Configuration Register 2
    __I hw_sim_uidh_t UIDH;                //!< [0x1054] Unique Identification Register High
    __I hw_sim_uidmh_t UIDMH;              //!< [0x1058] Unique Identification Register Mid-High
    __I hw_sim_uidml_t UIDML;              //!< [0x105C] Unique Identification Register Mid Low
    __I hw_sim_uidl_t UIDL;                //!< [0x1060] Unique Identification Register Low
} hw_sim_t;
#pragma pack()

//! @brief Macro to access all SIM registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_SIM</code>.
#define HW_SIM         (*(hw_sim_t *) REGS_SIM_BASE)
#endif

#endif // __HW_SIM_REGISTERS_H__
// v22/130726/0.9
// EOF

