/*
 * Copyright (c) 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_PDB_REGISTERS_H__
#define __HW_PDB_REGISTERS_H__

#include "regs.h"

/*
 * MK64F12 PDB
 *
 * Programmable Delay Block
 *
 * Registers defined in this header file:
 * - HW_PDB_SC - Status and Control register
 * - HW_PDB_MOD - Modulus register
 * - HW_PDB_CNT - Counter register
 * - HW_PDB_IDLY - Interrupt Delay register
 * - HW_PDB_CHnC1 - Channel n Control register 1
 * - HW_PDB_CHnS - Channel n Status register
 * - HW_PDB_CHnDLY0 - Channel n Delay 0 register
 * - HW_PDB_CHnDLY1 - Channel n Delay 1 register
 * - HW_PDB_DACINTCn - DAC Interval Trigger n Control register
 * - HW_PDB_DACINTn - DAC Interval n register
 * - HW_PDB_POEN - Pulse-Out n Enable register
 * - HW_PDB_POnDLY - Pulse-Out n Delay register
 *
 * - hw_pdb_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_PDB_BASE
#define HW_PDB_INSTANCE_COUNT (1U) //!< Number of instances of the PDB module.
#define REGS_PDB_BASE (0x40036000U) //!< Base address for PDB0.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PDB_SC - Status and Control register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PDB_SC - Status and Control register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_pdb_sc
{
    uint32_t U;
    struct _hw_pdb_sc_bitfields
    {
        uint32_t LDOK : 1;             //!< [0] Load OK
        uint32_t CONT : 1;             //!< [1] Continuous Mode Enable
        uint32_t MULT : 2;             //!< [3:2] Multiplication Factor Select for
                                       //! Prescaler
        uint32_t RESERVED0 : 1;        //!< [4]
        uint32_t PDBIE : 1;            //!< [5] PDB Interrupt Enable
        uint32_t PDBIF : 1;            //!< [6] PDB Interrupt Flag
        uint32_t PDBEN : 1;            //!< [7] PDB Enable
        uint32_t TRGSEL : 4;           //!< [11:8] Trigger Input Source Select
        uint32_t PRESCALER : 3;        //!< [14:12] Prescaler Divider Select
        uint32_t DMAEN : 1;            //!< [15] DMA Enable
        uint32_t SWTRIG : 1;           //!< [16] Software Trigger
        uint32_t PDBEIE : 1;           //!< [17] PDB Sequence Error Interrupt Enable
        uint32_t LDMOD : 2;            //!< [19:18] Load Mode Select
        uint32_t RESERVED1 : 12;       //!< [31:20]
    } B;
} hw_pdb_sc_t;
#endif

/*!
 * @name Constants and macros for entire PDB_SC register
 */
//@{
#define HW_PDB_SC_ADDR           (REGS_PDB_BASE + 0x0U)

#ifndef __LANGUAGE_ASM__
#define HW_PDB_SC                (*(__IO hw_pdb_sc_t *) HW_PDB_SC_ADDR)
#define HW_PDB_SC_RD()           (HW_PDB_SC.U)
#define HW_PDB_SC_WR(v)          (HW_PDB_SC.U = (v))
#define HW_PDB_SC_SET(v)         (HW_PDB_SC_WR(HW_PDB_SC_RD() |  (v)))
#define HW_PDB_SC_CLR(v)         (HW_PDB_SC_WR(HW_PDB_SC_RD() & ~(v)))
#define HW_PDB_SC_TOG(v)         (HW_PDB_SC_WR(HW_PDB_SC_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual PDB_SC bitfields
 */

/*!
 * @name Register PDB_SC, field LDOK[0] (RW)
 *
 * Writing 1 to this bit updates the internal registers of MOD, IDLY, CHnDLYm,
 * DACINTx,and POyDLY with the values written to their buffers. The MOD, IDLY,
 * CHnDLYm, DACINTx, and POyDLY will take effect according to the LDMOD. After 1 is
 * written to the LDOK field, the values in the buffers of above registers are
 * not effective and the buffers cannot be written until the values in buffers are
 * loaded into their internal registers. LDOK can be written only when PDBEN is
 * set or it can be written at the same time with PDBEN being written to 1. It is
 * automatically cleared when the values in buffers are loaded into the internal
 * registers or the PDBEN is cleared. Writing 0 to it has no effect.
 */
//@{
#define BP_PDB_SC_LDOK       (0U)          //!< Bit position for PDB_SC_LDOK.
#define BM_PDB_SC_LDOK       (0x00000001U) //!< Bit mask for PDB_SC_LDOK.
#define BS_PDB_SC_LDOK       (1U)          //!< Bit field size in bits for PDB_SC_LDOK.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_SC_LDOK field.
#define BR_PDB_SC_LDOK       (BITBAND_ACCESS32(HW_PDB_SC_ADDR, BP_PDB_SC_LDOK))
#endif

//! @brief Format value for bitfield PDB_SC_LDOK.
#define BF_PDB_SC_LDOK(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_SC_LDOK), uint32_t) & BM_PDB_SC_LDOK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LDOK field to a new value.
#define BW_PDB_SC_LDOK(v)    (BITBAND_ACCESS32(HW_PDB_SC_ADDR, BP_PDB_SC_LDOK) = (v))
#endif
//@}

/*!
 * @name Register PDB_SC, field CONT[1] (RW)
 *
 * Enables the PDB operation in Continuous mode.
 *
 * Values:
 * - 0 - PDB operation in One-Shot mode
 * - 1 - PDB operation in Continuous mode
 */
//@{
#define BP_PDB_SC_CONT       (1U)          //!< Bit position for PDB_SC_CONT.
#define BM_PDB_SC_CONT       (0x00000002U) //!< Bit mask for PDB_SC_CONT.
#define BS_PDB_SC_CONT       (1U)          //!< Bit field size in bits for PDB_SC_CONT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_SC_CONT field.
#define BR_PDB_SC_CONT       (BITBAND_ACCESS32(HW_PDB_SC_ADDR, BP_PDB_SC_CONT))
#endif

//! @brief Format value for bitfield PDB_SC_CONT.
#define BF_PDB_SC_CONT(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_SC_CONT), uint32_t) & BM_PDB_SC_CONT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CONT field to a new value.
#define BW_PDB_SC_CONT(v)    (BITBAND_ACCESS32(HW_PDB_SC_ADDR, BP_PDB_SC_CONT) = (v))
#endif
//@}

/*!
 * @name Register PDB_SC, field MULT[3:2] (RW)
 *
 * Selects the multiplication factor of the prescaler divider for the counter
 * clock.
 *
 * Values:
 * - 00 - Multiplication factor is 1.
 * - 01 - Multiplication factor is 10.
 * - 10 - Multiplication factor is 20.
 * - 11 - Multiplication factor is 40.
 */
//@{
#define BP_PDB_SC_MULT       (2U)          //!< Bit position for PDB_SC_MULT.
#define BM_PDB_SC_MULT       (0x0000000CU) //!< Bit mask for PDB_SC_MULT.
#define BS_PDB_SC_MULT       (2U)          //!< Bit field size in bits for PDB_SC_MULT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_SC_MULT field.
#define BR_PDB_SC_MULT       (HW_PDB_SC.B.MULT)
#endif

//! @brief Format value for bitfield PDB_SC_MULT.
#define BF_PDB_SC_MULT(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_SC_MULT), uint32_t) & BM_PDB_SC_MULT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MULT field to a new value.
#define BW_PDB_SC_MULT(v)    (HW_PDB_SC_WR((HW_PDB_SC_RD() & ~BM_PDB_SC_MULT) | BF_PDB_SC_MULT(v)))
#endif
//@}

/*!
 * @name Register PDB_SC, field PDBIE[5] (RW)
 *
 * Enables the PDB interrupt. When this field is set and DMAEN is cleared, PDBIF
 * generates a PDB interrupt.
 *
 * Values:
 * - 0 - PDB interrupt disabled.
 * - 1 - PDB interrupt enabled.
 */
//@{
#define BP_PDB_SC_PDBIE      (5U)          //!< Bit position for PDB_SC_PDBIE.
#define BM_PDB_SC_PDBIE      (0x00000020U) //!< Bit mask for PDB_SC_PDBIE.
#define BS_PDB_SC_PDBIE      (1U)          //!< Bit field size in bits for PDB_SC_PDBIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_SC_PDBIE field.
#define BR_PDB_SC_PDBIE      (BITBAND_ACCESS32(HW_PDB_SC_ADDR, BP_PDB_SC_PDBIE))
#endif

//! @brief Format value for bitfield PDB_SC_PDBIE.
#define BF_PDB_SC_PDBIE(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_SC_PDBIE), uint32_t) & BM_PDB_SC_PDBIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PDBIE field to a new value.
#define BW_PDB_SC_PDBIE(v)   (BITBAND_ACCESS32(HW_PDB_SC_ADDR, BP_PDB_SC_PDBIE) = (v))
#endif
//@}

/*!
 * @name Register PDB_SC, field PDBIF[6] (RW)
 *
 * This field is set when the counter value is equal to the IDLY register.
 * Writing zero clears this field.
 */
//@{
#define BP_PDB_SC_PDBIF      (6U)          //!< Bit position for PDB_SC_PDBIF.
#define BM_PDB_SC_PDBIF      (0x00000040U) //!< Bit mask for PDB_SC_PDBIF.
#define BS_PDB_SC_PDBIF      (1U)          //!< Bit field size in bits for PDB_SC_PDBIF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_SC_PDBIF field.
#define BR_PDB_SC_PDBIF      (BITBAND_ACCESS32(HW_PDB_SC_ADDR, BP_PDB_SC_PDBIF))
#endif

//! @brief Format value for bitfield PDB_SC_PDBIF.
#define BF_PDB_SC_PDBIF(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_SC_PDBIF), uint32_t) & BM_PDB_SC_PDBIF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PDBIF field to a new value.
#define BW_PDB_SC_PDBIF(v)   (BITBAND_ACCESS32(HW_PDB_SC_ADDR, BP_PDB_SC_PDBIF) = (v))
#endif
//@}

/*!
 * @name Register PDB_SC, field PDBEN[7] (RW)
 *
 * Values:
 * - 0 - PDB disabled. Counter is off.
 * - 1 - PDB enabled.
 */
//@{
#define BP_PDB_SC_PDBEN      (7U)          //!< Bit position for PDB_SC_PDBEN.
#define BM_PDB_SC_PDBEN      (0x00000080U) //!< Bit mask for PDB_SC_PDBEN.
#define BS_PDB_SC_PDBEN      (1U)          //!< Bit field size in bits for PDB_SC_PDBEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_SC_PDBEN field.
#define BR_PDB_SC_PDBEN      (BITBAND_ACCESS32(HW_PDB_SC_ADDR, BP_PDB_SC_PDBEN))
#endif

//! @brief Format value for bitfield PDB_SC_PDBEN.
#define BF_PDB_SC_PDBEN(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_SC_PDBEN), uint32_t) & BM_PDB_SC_PDBEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PDBEN field to a new value.
#define BW_PDB_SC_PDBEN(v)   (BITBAND_ACCESS32(HW_PDB_SC_ADDR, BP_PDB_SC_PDBEN) = (v))
#endif
//@}

/*!
 * @name Register PDB_SC, field TRGSEL[11:8] (RW)
 *
 * Selects the trigger input source for the PDB. The trigger input source can be
 * internal or external (EXTRG pin), or the software trigger. Refer to chip
 * configuration details for the actual PDB input trigger connections.
 *
 * Values:
 * - 0000 - Trigger-In 0 is selected.
 * - 0001 - Trigger-In 1 is selected.
 * - 0010 - Trigger-In 2 is selected.
 * - 0011 - Trigger-In 3 is selected.
 * - 0100 - Trigger-In 4 is selected.
 * - 0101 - Trigger-In 5 is selected.
 * - 0110 - Trigger-In 6 is selected.
 * - 0111 - Trigger-In 7 is selected.
 * - 1000 - Trigger-In 8 is selected.
 * - 1001 - Trigger-In 9 is selected.
 * - 1010 - Trigger-In 10 is selected.
 * - 1011 - Trigger-In 11 is selected.
 * - 1100 - Trigger-In 12 is selected.
 * - 1101 - Trigger-In 13 is selected.
 * - 1110 - Trigger-In 14 is selected.
 * - 1111 - Software trigger is selected.
 */
//@{
#define BP_PDB_SC_TRGSEL     (8U)          //!< Bit position for PDB_SC_TRGSEL.
#define BM_PDB_SC_TRGSEL     (0x00000F00U) //!< Bit mask for PDB_SC_TRGSEL.
#define BS_PDB_SC_TRGSEL     (4U)          //!< Bit field size in bits for PDB_SC_TRGSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_SC_TRGSEL field.
#define BR_PDB_SC_TRGSEL     (HW_PDB_SC.B.TRGSEL)
#endif

//! @brief Format value for bitfield PDB_SC_TRGSEL.
#define BF_PDB_SC_TRGSEL(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_SC_TRGSEL), uint32_t) & BM_PDB_SC_TRGSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TRGSEL field to a new value.
#define BW_PDB_SC_TRGSEL(v)  (HW_PDB_SC_WR((HW_PDB_SC_RD() & ~BM_PDB_SC_TRGSEL) | BF_PDB_SC_TRGSEL(v)))
#endif
//@}

/*!
 * @name Register PDB_SC, field PRESCALER[14:12] (RW)
 *
 * Values:
 * - 000 - Counting uses the peripheral clock divided by multiplication factor
 *     selected by MULT.
 * - 001 - Counting uses the peripheral clock divided by twice of the
 *     multiplication factor selected by MULT.
 * - 010 - Counting uses the peripheral clock divided by four times of the
 *     multiplication factor selected by MULT.
 * - 011 - Counting uses the peripheral clock divided by eight times of the
 *     multiplication factor selected by MULT.
 * - 100 - Counting uses the peripheral clock divided by 16 times of the
 *     multiplication factor selected by MULT.
 * - 101 - Counting uses the peripheral clock divided by 32 times of the
 *     multiplication factor selected by MULT.
 * - 110 - Counting uses the peripheral clock divided by 64 times of the
 *     multiplication factor selected by MULT.
 * - 111 - Counting uses the peripheral clock divided by 128 times of the
 *     multiplication factor selected by MULT.
 */
//@{
#define BP_PDB_SC_PRESCALER  (12U)         //!< Bit position for PDB_SC_PRESCALER.
#define BM_PDB_SC_PRESCALER  (0x00007000U) //!< Bit mask for PDB_SC_PRESCALER.
#define BS_PDB_SC_PRESCALER  (3U)          //!< Bit field size in bits for PDB_SC_PRESCALER.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_SC_PRESCALER field.
#define BR_PDB_SC_PRESCALER  (HW_PDB_SC.B.PRESCALER)
#endif

//! @brief Format value for bitfield PDB_SC_PRESCALER.
#define BF_PDB_SC_PRESCALER(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_SC_PRESCALER), uint32_t) & BM_PDB_SC_PRESCALER)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PRESCALER field to a new value.
#define BW_PDB_SC_PRESCALER(v) (HW_PDB_SC_WR((HW_PDB_SC_RD() & ~BM_PDB_SC_PRESCALER) | BF_PDB_SC_PRESCALER(v)))
#endif
//@}

/*!
 * @name Register PDB_SC, field DMAEN[15] (RW)
 *
 * When DMA is enabled, the PDBIF flag generates a DMA request instead of an
 * interrupt.
 *
 * Values:
 * - 0 - DMA disabled.
 * - 1 - DMA enabled.
 */
//@{
#define BP_PDB_SC_DMAEN      (15U)         //!< Bit position for PDB_SC_DMAEN.
#define BM_PDB_SC_DMAEN      (0x00008000U) //!< Bit mask for PDB_SC_DMAEN.
#define BS_PDB_SC_DMAEN      (1U)          //!< Bit field size in bits for PDB_SC_DMAEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_SC_DMAEN field.
#define BR_PDB_SC_DMAEN      (BITBAND_ACCESS32(HW_PDB_SC_ADDR, BP_PDB_SC_DMAEN))
#endif

//! @brief Format value for bitfield PDB_SC_DMAEN.
#define BF_PDB_SC_DMAEN(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_SC_DMAEN), uint32_t) & BM_PDB_SC_DMAEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMAEN field to a new value.
#define BW_PDB_SC_DMAEN(v)   (BITBAND_ACCESS32(HW_PDB_SC_ADDR, BP_PDB_SC_DMAEN) = (v))
#endif
//@}

/*!
 * @name Register PDB_SC, field SWTRIG[16] (WORZ)
 *
 * When PDB is enabled and the software trigger is selected as the trigger input
 * source, writing 1 to this field resets and restarts the counter. Writing 0 to
 * this field has no effect. Reading this field results 0.
 */
//@{
#define BP_PDB_SC_SWTRIG     (16U)         //!< Bit position for PDB_SC_SWTRIG.
#define BM_PDB_SC_SWTRIG     (0x00010000U) //!< Bit mask for PDB_SC_SWTRIG.
#define BS_PDB_SC_SWTRIG     (1U)          //!< Bit field size in bits for PDB_SC_SWTRIG.

//! @brief Format value for bitfield PDB_SC_SWTRIG.
#define BF_PDB_SC_SWTRIG(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_SC_SWTRIG), uint32_t) & BM_PDB_SC_SWTRIG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SWTRIG field to a new value.
#define BW_PDB_SC_SWTRIG(v)  (BITBAND_ACCESS32(HW_PDB_SC_ADDR, BP_PDB_SC_SWTRIG) = (v))
#endif
//@}

/*!
 * @name Register PDB_SC, field PDBEIE[17] (RW)
 *
 * Enables the PDB sequence error interrupt. When this field is set, any of the
 * PDB channel sequence error flags generates a PDB sequence error interrupt.
 *
 * Values:
 * - 0 - PDB sequence error interrupt disabled.
 * - 1 - PDB sequence error interrupt enabled.
 */
//@{
#define BP_PDB_SC_PDBEIE     (17U)         //!< Bit position for PDB_SC_PDBEIE.
#define BM_PDB_SC_PDBEIE     (0x00020000U) //!< Bit mask for PDB_SC_PDBEIE.
#define BS_PDB_SC_PDBEIE     (1U)          //!< Bit field size in bits for PDB_SC_PDBEIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_SC_PDBEIE field.
#define BR_PDB_SC_PDBEIE     (BITBAND_ACCESS32(HW_PDB_SC_ADDR, BP_PDB_SC_PDBEIE))
#endif

//! @brief Format value for bitfield PDB_SC_PDBEIE.
#define BF_PDB_SC_PDBEIE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_SC_PDBEIE), uint32_t) & BM_PDB_SC_PDBEIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PDBEIE field to a new value.
#define BW_PDB_SC_PDBEIE(v)  (BITBAND_ACCESS32(HW_PDB_SC_ADDR, BP_PDB_SC_PDBEIE) = (v))
#endif
//@}

/*!
 * @name Register PDB_SC, field LDMOD[19:18] (RW)
 *
 * Selects the mode to load the MOD, IDLY, CHnDLYm, INTx, and POyDLY registers,
 * after 1 is written to LDOK.
 *
 * Values:
 * - 00 - The internal registers are loaded with the values from their buffers
 *     immediately after 1 is written to LDOK.
 * - 01 - The internal registers are loaded with the values from their buffers
 *     when the PDB counter reaches the MOD register value after 1 is written to
 *     LDOK.
 * - 10 - The internal registers are loaded with the values from their buffers
 *     when a trigger input event is detected after 1 is written to LDOK.
 * - 11 - The internal registers are loaded with the values from their buffers
 *     when either the PDB counter reaches the MOD register value or a trigger
 *     input event is detected, after 1 is written to LDOK.
 */
//@{
#define BP_PDB_SC_LDMOD      (18U)         //!< Bit position for PDB_SC_LDMOD.
#define BM_PDB_SC_LDMOD      (0x000C0000U) //!< Bit mask for PDB_SC_LDMOD.
#define BS_PDB_SC_LDMOD      (2U)          //!< Bit field size in bits for PDB_SC_LDMOD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_SC_LDMOD field.
#define BR_PDB_SC_LDMOD      (HW_PDB_SC.B.LDMOD)
#endif

//! @brief Format value for bitfield PDB_SC_LDMOD.
#define BF_PDB_SC_LDMOD(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_SC_LDMOD), uint32_t) & BM_PDB_SC_LDMOD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LDMOD field to a new value.
#define BW_PDB_SC_LDMOD(v)   (HW_PDB_SC_WR((HW_PDB_SC_RD() & ~BM_PDB_SC_LDMOD) | BF_PDB_SC_LDMOD(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PDB_MOD - Modulus register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PDB_MOD - Modulus register (RW)
 *
 * Reset value: 0x0000FFFFU
 */
typedef union _hw_pdb_mod
{
    uint32_t U;
    struct _hw_pdb_mod_bitfields
    {
        uint32_t MOD : 16;             //!< [15:0] PDB Modulus
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_pdb_mod_t;
#endif

/*!
 * @name Constants and macros for entire PDB_MOD register
 */
//@{
#define HW_PDB_MOD_ADDR          (REGS_PDB_BASE + 0x4U)

#ifndef __LANGUAGE_ASM__
#define HW_PDB_MOD               (*(__IO hw_pdb_mod_t *) HW_PDB_MOD_ADDR)
#define HW_PDB_MOD_RD()          (HW_PDB_MOD.U)
#define HW_PDB_MOD_WR(v)         (HW_PDB_MOD.U = (v))
#define HW_PDB_MOD_SET(v)        (HW_PDB_MOD_WR(HW_PDB_MOD_RD() |  (v)))
#define HW_PDB_MOD_CLR(v)        (HW_PDB_MOD_WR(HW_PDB_MOD_RD() & ~(v)))
#define HW_PDB_MOD_TOG(v)        (HW_PDB_MOD_WR(HW_PDB_MOD_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual PDB_MOD bitfields
 */

/*!
 * @name Register PDB_MOD, field MOD[15:0] (RW)
 *
 * Specifies the period of the counter. When the counter reaches this value, it
 * will be reset back to zero. If the PDB is in Continuous mode, the count begins
 * anew. Reading this field returns the value of the internal register that is
 * effective for the current cycle of PDB.
 */
//@{
#define BP_PDB_MOD_MOD       (0U)          //!< Bit position for PDB_MOD_MOD.
#define BM_PDB_MOD_MOD       (0x0000FFFFU) //!< Bit mask for PDB_MOD_MOD.
#define BS_PDB_MOD_MOD       (16U)         //!< Bit field size in bits for PDB_MOD_MOD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_MOD_MOD field.
#define BR_PDB_MOD_MOD       (HW_PDB_MOD.B.MOD)
#endif

//! @brief Format value for bitfield PDB_MOD_MOD.
#define BF_PDB_MOD_MOD(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_MOD_MOD), uint32_t) & BM_PDB_MOD_MOD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MOD field to a new value.
#define BW_PDB_MOD_MOD(v)    (HW_PDB_MOD_WR((HW_PDB_MOD_RD() & ~BM_PDB_MOD_MOD) | BF_PDB_MOD_MOD(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PDB_CNT - Counter register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PDB_CNT - Counter register (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_pdb_cnt
{
    uint32_t U;
    struct _hw_pdb_cnt_bitfields
    {
        uint32_t CNT : 16;             //!< [15:0] PDB Counter
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_pdb_cnt_t;
#endif

/*!
 * @name Constants and macros for entire PDB_CNT register
 */
//@{
#define HW_PDB_CNT_ADDR          (REGS_PDB_BASE + 0x8U)

#ifndef __LANGUAGE_ASM__
#define HW_PDB_CNT               (*(__I hw_pdb_cnt_t *) HW_PDB_CNT_ADDR)
#define HW_PDB_CNT_RD()          (HW_PDB_CNT.U)
#endif
//@}

/*
 * Constants & macros for individual PDB_CNT bitfields
 */

/*!
 * @name Register PDB_CNT, field CNT[15:0] (RO)
 *
 * Contains the current value of the counter.
 */
//@{
#define BP_PDB_CNT_CNT       (0U)          //!< Bit position for PDB_CNT_CNT.
#define BM_PDB_CNT_CNT       (0x0000FFFFU) //!< Bit mask for PDB_CNT_CNT.
#define BS_PDB_CNT_CNT       (16U)         //!< Bit field size in bits for PDB_CNT_CNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_CNT_CNT field.
#define BR_PDB_CNT_CNT       (HW_PDB_CNT.B.CNT)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PDB_IDLY - Interrupt Delay register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PDB_IDLY - Interrupt Delay register (RW)
 *
 * Reset value: 0x0000FFFFU
 */
typedef union _hw_pdb_idly
{
    uint32_t U;
    struct _hw_pdb_idly_bitfields
    {
        uint32_t IDLY : 16;            //!< [15:0] PDB Interrupt Delay
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_pdb_idly_t;
#endif

/*!
 * @name Constants and macros for entire PDB_IDLY register
 */
//@{
#define HW_PDB_IDLY_ADDR         (REGS_PDB_BASE + 0xCU)

#ifndef __LANGUAGE_ASM__
#define HW_PDB_IDLY              (*(__IO hw_pdb_idly_t *) HW_PDB_IDLY_ADDR)
#define HW_PDB_IDLY_RD()         (HW_PDB_IDLY.U)
#define HW_PDB_IDLY_WR(v)        (HW_PDB_IDLY.U = (v))
#define HW_PDB_IDLY_SET(v)       (HW_PDB_IDLY_WR(HW_PDB_IDLY_RD() |  (v)))
#define HW_PDB_IDLY_CLR(v)       (HW_PDB_IDLY_WR(HW_PDB_IDLY_RD() & ~(v)))
#define HW_PDB_IDLY_TOG(v)       (HW_PDB_IDLY_WR(HW_PDB_IDLY_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual PDB_IDLY bitfields
 */

/*!
 * @name Register PDB_IDLY, field IDLY[15:0] (RW)
 *
 * Specifies the delay value to schedule the PDB interrupt. It can be used to
 * schedule an independent interrupt at some point in the PDB cycle. If enabled, a
 * PDB interrupt is generated, when the counter is equal to the IDLY. Reading
 * this field returns the value of internal register that is effective for the
 * current cycle of the PDB.
 */
//@{
#define BP_PDB_IDLY_IDLY     (0U)          //!< Bit position for PDB_IDLY_IDLY.
#define BM_PDB_IDLY_IDLY     (0x0000FFFFU) //!< Bit mask for PDB_IDLY_IDLY.
#define BS_PDB_IDLY_IDLY     (16U)         //!< Bit field size in bits for PDB_IDLY_IDLY.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_IDLY_IDLY field.
#define BR_PDB_IDLY_IDLY     (HW_PDB_IDLY.B.IDLY)
#endif

//! @brief Format value for bitfield PDB_IDLY_IDLY.
#define BF_PDB_IDLY_IDLY(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_IDLY_IDLY), uint32_t) & BM_PDB_IDLY_IDLY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IDLY field to a new value.
#define BW_PDB_IDLY_IDLY(v)  (HW_PDB_IDLY_WR((HW_PDB_IDLY_RD() & ~BM_PDB_IDLY_IDLY) | BF_PDB_IDLY_IDLY(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PDB_CHnC1 - Channel n Control register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PDB_CHnC1 - Channel n Control register 1 (RW)
 *
 * Reset value: 0x00000000U
 *
 * Each PDB channel has one control register, CHnC1. The bits in this register
 * control the functionality of each PDB channel operation.
 */
typedef union _hw_pdb_chnc1
{
    uint32_t U;
    struct _hw_pdb_chnc1_bitfields
    {
        uint32_t EN : 8;               //!< [7:0] PDB Channel Pre-Trigger Enable
        uint32_t TOS : 8;              //!< [15:8] PDB Channel Pre-Trigger Output Select
        uint32_t BB : 8;               //!< [23:16] PDB Channel Pre-Trigger Back-to-Back
                                       //! Operation Enable
        uint32_t RESERVED0 : 8;        //!< [31:24]
    } B;
} hw_pdb_chnc1_t;
#endif

/*!
 * @name Constants and macros for entire PDB_CHnC1 register
 */
//@{
#define HW_PDB_CHnC1_COUNT (2U)

#define HW_PDB_CHnC1_ADDR(n)     (REGS_PDB_BASE + 0x10U + (0x28U * n))

#ifndef __LANGUAGE_ASM__
#define HW_PDB_CHnC1(n)          (*(__IO hw_pdb_chnc1_t *) HW_PDB_CHnC1_ADDR(n))
#define HW_PDB_CHnC1_RD(n)       (HW_PDB_CHnC1(n).U)
#define HW_PDB_CHnC1_WR(n, v)    (HW_PDB_CHnC1(n).U = (v))
#define HW_PDB_CHnC1_SET(n, v)   (HW_PDB_CHnC1_WR(n, HW_PDB_CHnC1_RD(n) |  (v)))
#define HW_PDB_CHnC1_CLR(n, v)   (HW_PDB_CHnC1_WR(n, HW_PDB_CHnC1_RD(n) & ~(v)))
#define HW_PDB_CHnC1_TOG(n, v)   (HW_PDB_CHnC1_WR(n, HW_PDB_CHnC1_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual PDB_CHnC1 bitfields
 */

/*!
 * @name Register PDB_CHnC1, field EN[7:0] (RW)
 *
 * These bits enable the PDB ADC pre-trigger outputs. Only lower M pre-trigger
 * bits are implemented in this MCU.
 *
 * Values:
 * - 0 - PDB channel's corresponding pre-trigger disabled.
 * - 1 - PDB channel's corresponding pre-trigger enabled.
 */
//@{
#define BP_PDB_CHnC1_EN      (0U)          //!< Bit position for PDB_CHnC1_EN.
#define BM_PDB_CHnC1_EN      (0x000000FFU) //!< Bit mask for PDB_CHnC1_EN.
#define BS_PDB_CHnC1_EN      (8U)          //!< Bit field size in bits for PDB_CHnC1_EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_CHnC1_EN field.
#define BR_PDB_CHnC1_EN(n)   (HW_PDB_CHnC1(n).B.EN)
#endif

//! @brief Format value for bitfield PDB_CHnC1_EN.
#define BF_PDB_CHnC1_EN(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_CHnC1_EN), uint32_t) & BM_PDB_CHnC1_EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EN field to a new value.
#define BW_PDB_CHnC1_EN(n, v) (HW_PDB_CHnC1_WR(n, (HW_PDB_CHnC1_RD(n) & ~BM_PDB_CHnC1_EN) | BF_PDB_CHnC1_EN(v)))
#endif
//@}

/*!
 * @name Register PDB_CHnC1, field TOS[15:8] (RW)
 *
 * Selects the PDB ADC pre-trigger outputs. Only lower M pre-trigger fields are
 * implemented in this MCU.
 *
 * Values:
 * - 0 - PDB channel's corresponding pre-trigger is in bypassed mode. The
 *     pre-trigger asserts one peripheral clock cycle after a rising edge is detected
 *     on selected trigger input source or software trigger is selected and SWTRIG
 *     is written with 1.
 * - 1 - PDB channel's corresponding pre-trigger asserts when the counter
 *     reaches the channel delay register and one peripheral clock cycle after a rising
 *     edge is detected on selected trigger input source or software trigger is
 *     selected and SETRIG is written with 1.
 */
//@{
#define BP_PDB_CHnC1_TOS     (8U)          //!< Bit position for PDB_CHnC1_TOS.
#define BM_PDB_CHnC1_TOS     (0x0000FF00U) //!< Bit mask for PDB_CHnC1_TOS.
#define BS_PDB_CHnC1_TOS     (8U)          //!< Bit field size in bits for PDB_CHnC1_TOS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_CHnC1_TOS field.
#define BR_PDB_CHnC1_TOS(n)  (HW_PDB_CHnC1(n).B.TOS)
#endif

//! @brief Format value for bitfield PDB_CHnC1_TOS.
#define BF_PDB_CHnC1_TOS(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_CHnC1_TOS), uint32_t) & BM_PDB_CHnC1_TOS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TOS field to a new value.
#define BW_PDB_CHnC1_TOS(n, v) (HW_PDB_CHnC1_WR(n, (HW_PDB_CHnC1_RD(n) & ~BM_PDB_CHnC1_TOS) | BF_PDB_CHnC1_TOS(v)))
#endif
//@}

/*!
 * @name Register PDB_CHnC1, field BB[23:16] (RW)
 *
 * These bits enable the PDB ADC pre-trigger operation as back-to-back mode.
 * Only lower M pre-trigger bits are implemented in this MCU. Back-to-back operation
 * enables the ADC conversions complete to trigger the next PDB channel
 * pre-trigger and trigger output, so that the ADC conversions can be triggered on next
 * set of configuration and results registers. Application code must only enable
 * the back-to-back operation of the PDB pre-triggers at the leading of the
 * back-to-back connection chain.
 *
 * Values:
 * - 0 - PDB channel's corresponding pre-trigger back-to-back operation disabled.
 * - 1 - PDB channel's corresponding pre-trigger back-to-back operation enabled.
 */
//@{
#define BP_PDB_CHnC1_BB      (16U)         //!< Bit position for PDB_CHnC1_BB.
#define BM_PDB_CHnC1_BB      (0x00FF0000U) //!< Bit mask for PDB_CHnC1_BB.
#define BS_PDB_CHnC1_BB      (8U)          //!< Bit field size in bits for PDB_CHnC1_BB.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_CHnC1_BB field.
#define BR_PDB_CHnC1_BB(n)   (HW_PDB_CHnC1(n).B.BB)
#endif

//! @brief Format value for bitfield PDB_CHnC1_BB.
#define BF_PDB_CHnC1_BB(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_CHnC1_BB), uint32_t) & BM_PDB_CHnC1_BB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BB field to a new value.
#define BW_PDB_CHnC1_BB(n, v) (HW_PDB_CHnC1_WR(n, (HW_PDB_CHnC1_RD(n) & ~BM_PDB_CHnC1_BB) | BF_PDB_CHnC1_BB(v)))
#endif
//@}
//-------------------------------------------------------------------------------------------
// HW_PDB_CHnS - Channel n Status register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PDB_CHnS - Channel n Status register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_pdb_chns
{
    uint32_t U;
    struct _hw_pdb_chns_bitfields
    {
        uint32_t ERR : 8;              //!< [7:0] PDB Channel Sequence Error Flags
        uint32_t RESERVED0 : 8;        //!< [15:8]
        uint32_t CF : 8;               //!< [23:16] PDB Channel Flags
        uint32_t RESERVED1 : 8;        //!< [31:24]
    } B;
} hw_pdb_chns_t;
#endif

/*!
 * @name Constants and macros for entire PDB_CHnS register
 */
//@{
#define HW_PDB_CHnS_COUNT (2U)

#define HW_PDB_CHnS_ADDR(n)      (REGS_PDB_BASE + 0x14U + (0x28U * n))

#ifndef __LANGUAGE_ASM__
#define HW_PDB_CHnS(n)           (*(__IO hw_pdb_chns_t *) HW_PDB_CHnS_ADDR(n))
#define HW_PDB_CHnS_RD(n)        (HW_PDB_CHnS(n).U)
#define HW_PDB_CHnS_WR(n, v)     (HW_PDB_CHnS(n).U = (v))
#define HW_PDB_CHnS_SET(n, v)    (HW_PDB_CHnS_WR(n, HW_PDB_CHnS_RD(n) |  (v)))
#define HW_PDB_CHnS_CLR(n, v)    (HW_PDB_CHnS_WR(n, HW_PDB_CHnS_RD(n) & ~(v)))
#define HW_PDB_CHnS_TOG(n, v)    (HW_PDB_CHnS_WR(n, HW_PDB_CHnS_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual PDB_CHnS bitfields
 */

/*!
 * @name Register PDB_CHnS, field ERR[7:0] (RW)
 *
 * Only the lower M bits are implemented in this MCU.
 *
 * Values:
 * - 0 - Sequence error not detected on PDB channel's corresponding pre-trigger.
 * - 1 - Sequence error detected on PDB channel's corresponding pre-trigger.
 *     ADCn block can be triggered for a conversion by one pre-trigger from PDB
 *     channel n. When one conversion, which is triggered by one of the pre-triggers
 *     from PDB channel n, is in progress, new trigger from PDB channel's
 *     corresponding pre-trigger m cannot be accepted by ADCn, and ERR[m] is set.
 *     Writing 0's to clear the sequence error flags.
 */
//@{
#define BP_PDB_CHnS_ERR      (0U)          //!< Bit position for PDB_CHnS_ERR.
#define BM_PDB_CHnS_ERR      (0x000000FFU) //!< Bit mask for PDB_CHnS_ERR.
#define BS_PDB_CHnS_ERR      (8U)          //!< Bit field size in bits for PDB_CHnS_ERR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_CHnS_ERR field.
#define BR_PDB_CHnS_ERR(n)   (HW_PDB_CHnS(n).B.ERR)
#endif

//! @brief Format value for bitfield PDB_CHnS_ERR.
#define BF_PDB_CHnS_ERR(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_CHnS_ERR), uint32_t) & BM_PDB_CHnS_ERR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ERR field to a new value.
#define BW_PDB_CHnS_ERR(n, v) (HW_PDB_CHnS_WR(n, (HW_PDB_CHnS_RD(n) & ~BM_PDB_CHnS_ERR) | BF_PDB_CHnS_ERR(v)))
#endif
//@}

/*!
 * @name Register PDB_CHnS, field CF[23:16] (RW)
 *
 * The CF[m] bit is set when the PDB counter matches the CHnDLYm. Write 0 to
 * clear these bits.
 */
//@{
#define BP_PDB_CHnS_CF       (16U)         //!< Bit position for PDB_CHnS_CF.
#define BM_PDB_CHnS_CF       (0x00FF0000U) //!< Bit mask for PDB_CHnS_CF.
#define BS_PDB_CHnS_CF       (8U)          //!< Bit field size in bits for PDB_CHnS_CF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_CHnS_CF field.
#define BR_PDB_CHnS_CF(n)    (HW_PDB_CHnS(n).B.CF)
#endif

//! @brief Format value for bitfield PDB_CHnS_CF.
#define BF_PDB_CHnS_CF(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_CHnS_CF), uint32_t) & BM_PDB_CHnS_CF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CF field to a new value.
#define BW_PDB_CHnS_CF(n, v) (HW_PDB_CHnS_WR(n, (HW_PDB_CHnS_RD(n) & ~BM_PDB_CHnS_CF) | BF_PDB_CHnS_CF(v)))
#endif
//@}
//-------------------------------------------------------------------------------------------
// HW_PDB_CHnDLY0 - Channel n Delay 0 register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PDB_CHnDLY0 - Channel n Delay 0 register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_pdb_chndly0
{
    uint32_t U;
    struct _hw_pdb_chndly0_bitfields
    {
        uint32_t DLY : 16;             //!< [15:0] PDB Channel Delay
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_pdb_chndly0_t;
#endif

/*!
 * @name Constants and macros for entire PDB_CHnDLY0 register
 */
//@{
#define HW_PDB_CHnDLY0_COUNT (2U)

#define HW_PDB_CHnDLY0_ADDR(n)   (REGS_PDB_BASE + 0x18U + (0x28U * n))

#ifndef __LANGUAGE_ASM__
#define HW_PDB_CHnDLY0(n)        (*(__IO hw_pdb_chndly0_t *) HW_PDB_CHnDLY0_ADDR(n))
#define HW_PDB_CHnDLY0_RD(n)     (HW_PDB_CHnDLY0(n).U)
#define HW_PDB_CHnDLY0_WR(n, v)  (HW_PDB_CHnDLY0(n).U = (v))
#define HW_PDB_CHnDLY0_SET(n, v) (HW_PDB_CHnDLY0_WR(n, HW_PDB_CHnDLY0_RD(n) |  (v)))
#define HW_PDB_CHnDLY0_CLR(n, v) (HW_PDB_CHnDLY0_WR(n, HW_PDB_CHnDLY0_RD(n) & ~(v)))
#define HW_PDB_CHnDLY0_TOG(n, v) (HW_PDB_CHnDLY0_WR(n, HW_PDB_CHnDLY0_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual PDB_CHnDLY0 bitfields
 */

/*!
 * @name Register PDB_CHnDLY0, field DLY[15:0] (RW)
 *
 * Specifies the delay value for the channel's corresponding pre-trigger. The
 * pre-trigger asserts when the counter is equal to DLY. Reading this field returns
 * the value of internal register that is effective for the current PDB cycle.
 */
//@{
#define BP_PDB_CHnDLY0_DLY   (0U)          //!< Bit position for PDB_CHnDLY0_DLY.
#define BM_PDB_CHnDLY0_DLY   (0x0000FFFFU) //!< Bit mask for PDB_CHnDLY0_DLY.
#define BS_PDB_CHnDLY0_DLY   (16U)         //!< Bit field size in bits for PDB_CHnDLY0_DLY.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_CHnDLY0_DLY field.
#define BR_PDB_CHnDLY0_DLY(n) (HW_PDB_CHnDLY0(n).B.DLY)
#endif

//! @brief Format value for bitfield PDB_CHnDLY0_DLY.
#define BF_PDB_CHnDLY0_DLY(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_CHnDLY0_DLY), uint32_t) & BM_PDB_CHnDLY0_DLY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DLY field to a new value.
#define BW_PDB_CHnDLY0_DLY(n, v) (HW_PDB_CHnDLY0_WR(n, (HW_PDB_CHnDLY0_RD(n) & ~BM_PDB_CHnDLY0_DLY) | BF_PDB_CHnDLY0_DLY(v)))
#endif
//@}
//-------------------------------------------------------------------------------------------
// HW_PDB_CHnDLY1 - Channel n Delay 1 register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PDB_CHnDLY1 - Channel n Delay 1 register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_pdb_chndly1
{
    uint32_t U;
    struct _hw_pdb_chndly1_bitfields
    {
        uint32_t DLY : 16;             //!< [15:0] PDB Channel Delay
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_pdb_chndly1_t;
#endif

/*!
 * @name Constants and macros for entire PDB_CHnDLY1 register
 */
//@{
#define HW_PDB_CHnDLY1_COUNT (2U)

#define HW_PDB_CHnDLY1_ADDR(n)   (REGS_PDB_BASE + 0x1CU + (0x28U * n))

#ifndef __LANGUAGE_ASM__
#define HW_PDB_CHnDLY1(n)        (*(__IO hw_pdb_chndly1_t *) HW_PDB_CHnDLY1_ADDR(n))
#define HW_PDB_CHnDLY1_RD(n)     (HW_PDB_CHnDLY1(n).U)
#define HW_PDB_CHnDLY1_WR(n, v)  (HW_PDB_CHnDLY1(n).U = (v))
#define HW_PDB_CHnDLY1_SET(n, v) (HW_PDB_CHnDLY1_WR(n, HW_PDB_CHnDLY1_RD(n) |  (v)))
#define HW_PDB_CHnDLY1_CLR(n, v) (HW_PDB_CHnDLY1_WR(n, HW_PDB_CHnDLY1_RD(n) & ~(v)))
#define HW_PDB_CHnDLY1_TOG(n, v) (HW_PDB_CHnDLY1_WR(n, HW_PDB_CHnDLY1_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual PDB_CHnDLY1 bitfields
 */

/*!
 * @name Register PDB_CHnDLY1, field DLY[15:0] (RW)
 *
 * These bits specify the delay value for the channel's corresponding
 * pre-trigger. The pre-trigger asserts when the counter is equal to DLY. Reading these
 * bits returns the value of internal register that is effective for the current PDB
 * cycle.
 */
//@{
#define BP_PDB_CHnDLY1_DLY   (0U)          //!< Bit position for PDB_CHnDLY1_DLY.
#define BM_PDB_CHnDLY1_DLY   (0x0000FFFFU) //!< Bit mask for PDB_CHnDLY1_DLY.
#define BS_PDB_CHnDLY1_DLY   (16U)         //!< Bit field size in bits for PDB_CHnDLY1_DLY.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_CHnDLY1_DLY field.
#define BR_PDB_CHnDLY1_DLY(n) (HW_PDB_CHnDLY1(n).B.DLY)
#endif

//! @brief Format value for bitfield PDB_CHnDLY1_DLY.
#define BF_PDB_CHnDLY1_DLY(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_CHnDLY1_DLY), uint32_t) & BM_PDB_CHnDLY1_DLY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DLY field to a new value.
#define BW_PDB_CHnDLY1_DLY(n, v) (HW_PDB_CHnDLY1_WR(n, (HW_PDB_CHnDLY1_RD(n) & ~BM_PDB_CHnDLY1_DLY) | BF_PDB_CHnDLY1_DLY(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PDB_DACINTCn - DAC Interval Trigger n Control register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PDB_DACINTCn - DAC Interval Trigger n Control register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_pdb_dacintcn
{
    uint32_t U;
    struct _hw_pdb_dacintcn_bitfields
    {
        uint32_t TOE : 1;              //!< [0] DAC Interval Trigger Enable
        uint32_t EXT : 1;              //!< [1] DAC External Trigger Input Enable
        uint32_t RESERVED0 : 30;       //!< [31:2]
    } B;
} hw_pdb_dacintcn_t;
#endif

/*!
 * @name Constants and macros for entire PDB_DACINTCn register
 */
//@{
#define HW_PDB_DACINTCn_COUNT (2U)

#define HW_PDB_DACINTCn_ADDR(n)  (REGS_PDB_BASE + 0x150U + (0x8U * n))

#ifndef __LANGUAGE_ASM__
#define HW_PDB_DACINTCn(n)       (*(__IO hw_pdb_dacintcn_t *) HW_PDB_DACINTCn_ADDR(n))
#define HW_PDB_DACINTCn_RD(n)    (HW_PDB_DACINTCn(n).U)
#define HW_PDB_DACINTCn_WR(n, v) (HW_PDB_DACINTCn(n).U = (v))
#define HW_PDB_DACINTCn_SET(n, v) (HW_PDB_DACINTCn_WR(n, HW_PDB_DACINTCn_RD(n) |  (v)))
#define HW_PDB_DACINTCn_CLR(n, v) (HW_PDB_DACINTCn_WR(n, HW_PDB_DACINTCn_RD(n) & ~(v)))
#define HW_PDB_DACINTCn_TOG(n, v) (HW_PDB_DACINTCn_WR(n, HW_PDB_DACINTCn_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual PDB_DACINTCn bitfields
 */

/*!
 * @name Register PDB_DACINTCn, field TOE[0] (RW)
 *
 * This bit enables the DAC interval trigger.
 *
 * Values:
 * - 0 - DAC interval trigger disabled.
 * - 1 - DAC interval trigger enabled.
 */
//@{
#define BP_PDB_DACINTCn_TOE  (0U)          //!< Bit position for PDB_DACINTCn_TOE.
#define BM_PDB_DACINTCn_TOE  (0x00000001U) //!< Bit mask for PDB_DACINTCn_TOE.
#define BS_PDB_DACINTCn_TOE  (1U)          //!< Bit field size in bits for PDB_DACINTCn_TOE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_DACINTCn_TOE field.
#define BR_PDB_DACINTCn_TOE(n) (BITBAND_ACCESS32(HW_PDB_DACINTCn_ADDR(n), BP_PDB_DACINTCn_TOE))
#endif

//! @brief Format value for bitfield PDB_DACINTCn_TOE.
#define BF_PDB_DACINTCn_TOE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_DACINTCn_TOE), uint32_t) & BM_PDB_DACINTCn_TOE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TOE field to a new value.
#define BW_PDB_DACINTCn_TOE(n, v) (BITBAND_ACCESS32(HW_PDB_DACINTCn_ADDR(n), BP_PDB_DACINTCn_TOE) = (v))
#endif
//@}

/*!
 * @name Register PDB_DACINTCn, field EXT[1] (RW)
 *
 * Enables the external trigger for DAC interval counter.
 *
 * Values:
 * - 0 - DAC external trigger input disabled. DAC interval counter is reset and
 *     counting starts when a rising edge is detected on selected trigger input
 *     source or software trigger is selected and SWTRIG is written with 1.
 * - 1 - DAC external trigger input enabled. DAC interval counter is bypassed
 *     and DAC external trigger input triggers the DAC interval trigger.
 */
//@{
#define BP_PDB_DACINTCn_EXT  (1U)          //!< Bit position for PDB_DACINTCn_EXT.
#define BM_PDB_DACINTCn_EXT  (0x00000002U) //!< Bit mask for PDB_DACINTCn_EXT.
#define BS_PDB_DACINTCn_EXT  (1U)          //!< Bit field size in bits for PDB_DACINTCn_EXT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_DACINTCn_EXT field.
#define BR_PDB_DACINTCn_EXT(n) (BITBAND_ACCESS32(HW_PDB_DACINTCn_ADDR(n), BP_PDB_DACINTCn_EXT))
#endif

//! @brief Format value for bitfield PDB_DACINTCn_EXT.
#define BF_PDB_DACINTCn_EXT(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_DACINTCn_EXT), uint32_t) & BM_PDB_DACINTCn_EXT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EXT field to a new value.
#define BW_PDB_DACINTCn_EXT(n, v) (BITBAND_ACCESS32(HW_PDB_DACINTCn_ADDR(n), BP_PDB_DACINTCn_EXT) = (v))
#endif
//@}
//-------------------------------------------------------------------------------------------
// HW_PDB_DACINTn - DAC Interval n register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PDB_DACINTn - DAC Interval n register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_pdb_dacintn
{
    uint32_t U;
    struct _hw_pdb_dacintn_bitfields
    {
        uint32_t INT : 16;             //!< [15:0] DAC Interval
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_pdb_dacintn_t;
#endif

/*!
 * @name Constants and macros for entire PDB_DACINTn register
 */
//@{
#define HW_PDB_DACINTn_COUNT (2U)

#define HW_PDB_DACINTn_ADDR(n)   (REGS_PDB_BASE + 0x154U + (0x8U * n))

#ifndef __LANGUAGE_ASM__
#define HW_PDB_DACINTn(n)        (*(__IO hw_pdb_dacintn_t *) HW_PDB_DACINTn_ADDR(n))
#define HW_PDB_DACINTn_RD(n)     (HW_PDB_DACINTn(n).U)
#define HW_PDB_DACINTn_WR(n, v)  (HW_PDB_DACINTn(n).U = (v))
#define HW_PDB_DACINTn_SET(n, v) (HW_PDB_DACINTn_WR(n, HW_PDB_DACINTn_RD(n) |  (v)))
#define HW_PDB_DACINTn_CLR(n, v) (HW_PDB_DACINTn_WR(n, HW_PDB_DACINTn_RD(n) & ~(v)))
#define HW_PDB_DACINTn_TOG(n, v) (HW_PDB_DACINTn_WR(n, HW_PDB_DACINTn_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual PDB_DACINTn bitfields
 */

/*!
 * @name Register PDB_DACINTn, field INT[15:0] (RW)
 *
 * Specifies the interval value for DAC interval trigger. DAC interval trigger
 * triggers DAC[1:0] update when the DAC interval counter is equal to the DACINT.
 * Reading this field returns the value of internal register that is effective
 * for the current PDB cycle.
 */
//@{
#define BP_PDB_DACINTn_INT   (0U)          //!< Bit position for PDB_DACINTn_INT.
#define BM_PDB_DACINTn_INT   (0x0000FFFFU) //!< Bit mask for PDB_DACINTn_INT.
#define BS_PDB_DACINTn_INT   (16U)         //!< Bit field size in bits for PDB_DACINTn_INT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_DACINTn_INT field.
#define BR_PDB_DACINTn_INT(n) (HW_PDB_DACINTn(n).B.INT)
#endif

//! @brief Format value for bitfield PDB_DACINTn_INT.
#define BF_PDB_DACINTn_INT(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_DACINTn_INT), uint32_t) & BM_PDB_DACINTn_INT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INT field to a new value.
#define BW_PDB_DACINTn_INT(n, v) (HW_PDB_DACINTn_WR(n, (HW_PDB_DACINTn_RD(n) & ~BM_PDB_DACINTn_INT) | BF_PDB_DACINTn_INT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PDB_POEN - Pulse-Out n Enable register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PDB_POEN - Pulse-Out n Enable register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_pdb_poen
{
    uint32_t U;
    struct _hw_pdb_poen_bitfields
    {
        uint32_t POEN : 8;             //!< [7:0] PDB Pulse-Out Enable
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_pdb_poen_t;
#endif

/*!
 * @name Constants and macros for entire PDB_POEN register
 */
//@{
#define HW_PDB_POEN_ADDR         (REGS_PDB_BASE + 0x190U)

#ifndef __LANGUAGE_ASM__
#define HW_PDB_POEN              (*(__IO hw_pdb_poen_t *) HW_PDB_POEN_ADDR)
#define HW_PDB_POEN_RD()         (HW_PDB_POEN.U)
#define HW_PDB_POEN_WR(v)        (HW_PDB_POEN.U = (v))
#define HW_PDB_POEN_SET(v)       (HW_PDB_POEN_WR(HW_PDB_POEN_RD() |  (v)))
#define HW_PDB_POEN_CLR(v)       (HW_PDB_POEN_WR(HW_PDB_POEN_RD() & ~(v)))
#define HW_PDB_POEN_TOG(v)       (HW_PDB_POEN_WR(HW_PDB_POEN_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual PDB_POEN bitfields
 */

/*!
 * @name Register PDB_POEN, field POEN[7:0] (RW)
 *
 * Enables the pulse output. Only lower Y bits are implemented in this MCU.
 *
 * Values:
 * - 0 - PDB Pulse-Out disabled
 * - 1 - PDB Pulse-Out enabled
 */
//@{
#define BP_PDB_POEN_POEN     (0U)          //!< Bit position for PDB_POEN_POEN.
#define BM_PDB_POEN_POEN     (0x000000FFU) //!< Bit mask for PDB_POEN_POEN.
#define BS_PDB_POEN_POEN     (8U)          //!< Bit field size in bits for PDB_POEN_POEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_POEN_POEN field.
#define BR_PDB_POEN_POEN     (HW_PDB_POEN.B.POEN)
#endif

//! @brief Format value for bitfield PDB_POEN_POEN.
#define BF_PDB_POEN_POEN(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_POEN_POEN), uint32_t) & BM_PDB_POEN_POEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the POEN field to a new value.
#define BW_PDB_POEN_POEN(v)  (HW_PDB_POEN_WR((HW_PDB_POEN_RD() & ~BM_PDB_POEN_POEN) | BF_PDB_POEN_POEN(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_PDB_POnDLY - Pulse-Out n Delay register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_PDB_POnDLY - Pulse-Out n Delay register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_pdb_pondly
{
    uint32_t U;
    struct _hw_pdb_pondly_bitfields
    {
        uint32_t DLY2 : 16;            //!< [15:0] PDB Pulse-Out Delay 2
        uint32_t DLY1 : 16;            //!< [31:16] PDB Pulse-Out Delay 1
    } B;
} hw_pdb_pondly_t;
#endif

/*!
 * @name Constants and macros for entire PDB_POnDLY register
 */
//@{
#define HW_PDB_POnDLY_COUNT (3U)

#define HW_PDB_POnDLY_ADDR(n)    (REGS_PDB_BASE + 0x194U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_PDB_POnDLY(n)         (*(__IO hw_pdb_pondly_t *) HW_PDB_POnDLY_ADDR(n))
#define HW_PDB_POnDLY_RD(n)      (HW_PDB_POnDLY(n).U)
#define HW_PDB_POnDLY_WR(n, v)   (HW_PDB_POnDLY(n).U = (v))
#define HW_PDB_POnDLY_SET(n, v)  (HW_PDB_POnDLY_WR(n, HW_PDB_POnDLY_RD(n) |  (v)))
#define HW_PDB_POnDLY_CLR(n, v)  (HW_PDB_POnDLY_WR(n, HW_PDB_POnDLY_RD(n) & ~(v)))
#define HW_PDB_POnDLY_TOG(n, v)  (HW_PDB_POnDLY_WR(n, HW_PDB_POnDLY_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual PDB_POnDLY bitfields
 */

/*!
 * @name Register PDB_POnDLY, field DLY2[15:0] (RW)
 *
 * These bits specify the delay 2 value for the PDB Pulse-Out. Pulse-Out goes
 * low when the PDB counter is equal to the DLY2. Reading these bits returns the
 * value of internal register that is effective for the current PDB cycle.
 */
//@{
#define BP_PDB_POnDLY_DLY2   (0U)          //!< Bit position for PDB_POnDLY_DLY2.
#define BM_PDB_POnDLY_DLY2   (0x0000FFFFU) //!< Bit mask for PDB_POnDLY_DLY2.
#define BS_PDB_POnDLY_DLY2   (16U)         //!< Bit field size in bits for PDB_POnDLY_DLY2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_POnDLY_DLY2 field.
#define BR_PDB_POnDLY_DLY2(n) (HW_PDB_POnDLY(n).B.DLY2)
#endif

//! @brief Format value for bitfield PDB_POnDLY_DLY2.
#define BF_PDB_POnDLY_DLY2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_POnDLY_DLY2), uint32_t) & BM_PDB_POnDLY_DLY2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DLY2 field to a new value.
#define BW_PDB_POnDLY_DLY2(n, v) (HW_PDB_POnDLY_WR(n, (HW_PDB_POnDLY_RD(n) & ~BM_PDB_POnDLY_DLY2) | BF_PDB_POnDLY_DLY2(v)))
#endif
//@}

/*!
 * @name Register PDB_POnDLY, field DLY1[31:16] (RW)
 *
 * These bits specify the delay 1 value for the PDB Pulse-Out. Pulse-Out goes
 * high when the PDB counter is equal to the DLY1. Reading these bits returns the
 * value of internal register that is effective for the current PDB cycle.
 */
//@{
#define BP_PDB_POnDLY_DLY1   (16U)         //!< Bit position for PDB_POnDLY_DLY1.
#define BM_PDB_POnDLY_DLY1   (0xFFFF0000U) //!< Bit mask for PDB_POnDLY_DLY1.
#define BS_PDB_POnDLY_DLY1   (16U)         //!< Bit field size in bits for PDB_POnDLY_DLY1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the PDB_POnDLY_DLY1 field.
#define BR_PDB_POnDLY_DLY1(n) (HW_PDB_POnDLY(n).B.DLY1)
#endif

//! @brief Format value for bitfield PDB_POnDLY_DLY1.
#define BF_PDB_POnDLY_DLY1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_PDB_POnDLY_DLY1), uint32_t) & BM_PDB_POnDLY_DLY1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DLY1 field to a new value.
#define BW_PDB_POnDLY_DLY1(n, v) (HW_PDB_POnDLY_WR(n, (HW_PDB_POnDLY_RD(n) & ~BM_PDB_POnDLY_DLY1) | BF_PDB_POnDLY_DLY1(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_pdb_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All PDB module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_pdb
{
    __IO hw_pdb_sc_t SC;                   //!< [0x0] Status and Control register
    __IO hw_pdb_mod_t MOD;                 //!< [0x4] Modulus register
    __I hw_pdb_cnt_t CNT;                  //!< [0x8] Counter register
    __IO hw_pdb_idly_t IDLY;               //!< [0xC] Interrupt Delay register
    struct {
        __IO hw_pdb_chnc1_t CHnC1;         //!< [0x10] Channel n Control register 1
        __IO hw_pdb_chns_t CHnS;           //!< [0x14] Channel n Status register
        __IO hw_pdb_chndly0_t CHnDLY0;     //!< [0x18] Channel n Delay 0 register
        __IO hw_pdb_chndly1_t CHnDLY1;     //!< [0x1C] Channel n Delay 1 register
        uint8_t _reserved0[24];
    } CH[2];
    uint8_t _reserved0[240];
    struct {
        __IO hw_pdb_dacintcn_t DACINTCn;   //!< [0x150] DAC Interval Trigger n Control register
        __IO hw_pdb_dacintn_t DACINTn;     //!< [0x154] DAC Interval n register
    } DAC[2];
    uint8_t _reserved1[48];
    __IO hw_pdb_poen_t POEN;               //!< [0x190] Pulse-Out n Enable register
    __IO hw_pdb_pondly_t POnDLY[3];        //!< [0x194] Pulse-Out n Delay register
} hw_pdb_t;
#pragma pack()

//! @brief Macro to access all PDB registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_PDB</code>.
#define HW_PDB         (*(hw_pdb_t *) REGS_PDB_BASE)
#endif

#endif // __HW_PDB_REGISTERS_H__
// v22/130726/0.9
// EOF

