/*
 * Copyright (c) 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_I2C_REGISTERS_H__
#define __HW_I2C_REGISTERS_H__

#include "regs.h"

/*
 * MK64F12 I2C
 *
 * Inter-Integrated Circuit
 *
 * Registers defined in this header file:
 * - HW_I2C_A1 - I2C Address Register 1
 * - HW_I2C_F - I2C Frequency Divider register
 * - HW_I2C_C1 - I2C Control Register 1
 * - HW_I2C_S - I2C Status register
 * - HW_I2C_D - I2C Data I/O register
 * - HW_I2C_C2 - I2C Control Register 2
 * - HW_I2C_FLT - I2C Programmable Input Glitch Filter register
 * - HW_I2C_RA - I2C Range Address register
 * - HW_I2C_SMB - I2C SMBus Control and Status register
 * - HW_I2C_A2 - I2C Address Register 2
 * - HW_I2C_SLTH - I2C SCL Low Timeout Register High
 * - HW_I2C_SLTL - I2C SCL Low Timeout Register Low
 *
 * - hw_i2c_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_I2C_BASE
#define HW_I2C_INSTANCE_COUNT (3U) //!< Number of instances of the I2C module.
#define HW_I2C0 (0U) //!< Instance number for I2C0.
#define HW_I2C1 (1U) //!< Instance number for I2C1.
#define HW_I2C2 (2U) //!< Instance number for I2C2.
#define REGS_I2C0_BASE (0x40066000U) //!< Base address for I2C0.
#define REGS_I2C1_BASE (0x40067000U) //!< Base address for I2C1.
#define REGS_I2C2_BASE (0x400E6000U) //!< Base address for I2C2.

//! @brief Table of base addresses for I2C instances.
static const uint32_t __g_regs_I2C_base_addresses[] = {
        REGS_I2C0_BASE,
        REGS_I2C1_BASE,
        REGS_I2C2_BASE,
    };

//! @brief Get the base address of I2C by instance number.
//! @param x I2C instance number, from 0 through 2.
#define REGS_I2C_BASE(x) (__g_regs_I2C_base_addresses[(x)])

//! @brief Get the instance number given a base address.
//! @param b Base address for an instance of I2C.
#define REGS_I2C_INSTANCE(b) ((b) == REGS_I2C0_BASE ? HW_I2C0 : (b) == REGS_I2C1_BASE ? HW_I2C1 : (b) == REGS_I2C2_BASE ? HW_I2C2 : 0)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2C_A1 - I2C Address Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2C_A1 - I2C Address Register 1 (RW)
 *
 * Reset value: 0x00U
 *
 * This register contains the slave address to be used by the I2C module.
 */
typedef union _hw_i2c_a1
{
    uint8_t U;
    struct _hw_i2c_a1_bitfields
    {
        uint8_t RESERVED0 : 1;         //!< [0]
        uint8_t AD : 7;                //!< [7:1] Address
    } B;
} hw_i2c_a1_t;
#endif

/*!
 * @name Constants and macros for entire I2C_A1 register
 */
//@{
#define HW_I2C_A1_ADDR(x)        (REGS_I2C_BASE(x) + 0x0U)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_A1(x)             (*(__IO hw_i2c_a1_t *) HW_I2C_A1_ADDR(x))
#define HW_I2C_A1_RD(x)          (HW_I2C_A1(x).U)
#define HW_I2C_A1_WR(x, v)       (HW_I2C_A1(x).U = (v))
#define HW_I2C_A1_SET(x, v)      (HW_I2C_A1_WR(x, HW_I2C_A1_RD(x) |  (v)))
#define HW_I2C_A1_CLR(x, v)      (HW_I2C_A1_WR(x, HW_I2C_A1_RD(x) & ~(v)))
#define HW_I2C_A1_TOG(x, v)      (HW_I2C_A1_WR(x, HW_I2C_A1_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2C_A1 bitfields
 */

/*!
 * @name Register I2C_A1, field AD[7:1] (RW)
 *
 * Contains the primary slave address used by the I2C module when it is
 * addressed as a slave. This field is used in the 7-bit address scheme and the lower
 * seven bits in the 10-bit address scheme.
 */
//@{
#define BP_I2C_A1_AD         (1U)          //!< Bit position for I2C_A1_AD.
#define BM_I2C_A1_AD         (0xFEU)       //!< Bit mask for I2C_A1_AD.
#define BS_I2C_A1_AD         (7U)          //!< Bit field size in bits for I2C_A1_AD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_A1_AD field.
#define BR_I2C_A1_AD(x)      (HW_I2C_A1(x).B.AD)
#endif

//! @brief Format value for bitfield I2C_A1_AD.
#define BF_I2C_A1_AD(v)      (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_A1_AD), uint8_t) & BM_I2C_A1_AD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AD field to a new value.
#define BW_I2C_A1_AD(x, v)   (HW_I2C_A1_WR(x, (HW_I2C_A1_RD(x) & ~BM_I2C_A1_AD) | BF_I2C_A1_AD(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2C_F - I2C Frequency Divider register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2C_F - I2C Frequency Divider register (RW)
 *
 * Reset value: 0x00U
 */
typedef union _hw_i2c_f
{
    uint8_t U;
    struct _hw_i2c_f_bitfields
    {
        uint8_t ICR : 6;               //!< [5:0] ClockRate
        uint8_t MULT : 2;              //!< [7:6] Multiplier Factor
    } B;
} hw_i2c_f_t;
#endif

/*!
 * @name Constants and macros for entire I2C_F register
 */
//@{
#define HW_I2C_F_ADDR(x)         (REGS_I2C_BASE(x) + 0x1U)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_F(x)              (*(__IO hw_i2c_f_t *) HW_I2C_F_ADDR(x))
#define HW_I2C_F_RD(x)           (HW_I2C_F(x).U)
#define HW_I2C_F_WR(x, v)        (HW_I2C_F(x).U = (v))
#define HW_I2C_F_SET(x, v)       (HW_I2C_F_WR(x, HW_I2C_F_RD(x) |  (v)))
#define HW_I2C_F_CLR(x, v)       (HW_I2C_F_WR(x, HW_I2C_F_RD(x) & ~(v)))
#define HW_I2C_F_TOG(x, v)       (HW_I2C_F_WR(x, HW_I2C_F_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2C_F bitfields
 */

/*!
 * @name Register I2C_F, field ICR[5:0] (RW)
 *
 * Prescales the I2C module clock for bit rate selection. This field and the
 * MULT field determine the I2C baud rate, the SDA hold time, the SCL start hold
 * time, and the SCL stop hold time. For a list of values corresponding to each ICR
 * setting, see I2C divider and hold values. The SCL divider multiplied by
 * multiplier factor (mul) determines the I2C baud rate. I2C baud rate = I2C module
 * clock speed (Hz)/(mul * SCL divider) The SDA hold time is the delay from the
 * falling edge of SCL (I2C clock) to the changing of SDA (I2C data). SDA hold time =
 * I2C module clock period (s) * mul * SDA hold value The SCL start hold time is
 * the delay from the falling edge of SDA (I2C data) while SCL is high (start
 * condition) to the falling edge of SCL (I2C clock). SCL start hold time = I2C
 * module clock period (s) * mul * SCL start hold value The SCL stop hold time is
 * the delay from the rising edge of SCL (I2C clock) to the rising edge of SDA (I2C
 * data) while SCL is high (stop condition). SCL stop hold time = I2C module
 * clock period (s) * mul * SCL stop hold value For example, if the I2C module clock
 * speed is 8 MHz, the following table shows the possible hold time values with
 * different ICR and MULT selections to achieve an I2C baud rate of 100 kbit/s.
 * MULT ICR Hold times (μs) SDA SCL Start SCL Stop 2h 00h 3.500 3.000 5.500 1h
 * 07h 2.500 4.000 5.250 1h 0Bh 2.250 4.000 5.250 0h 14h 2.125 4.250 5.125 0h 18h
 * 1.125 4.750 5.125
 */
//@{
#define BP_I2C_F_ICR         (0U)          //!< Bit position for I2C_F_ICR.
#define BM_I2C_F_ICR         (0x3FU)       //!< Bit mask for I2C_F_ICR.
#define BS_I2C_F_ICR         (6U)          //!< Bit field size in bits for I2C_F_ICR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_F_ICR field.
#define BR_I2C_F_ICR(x)      (HW_I2C_F(x).B.ICR)
#endif

//! @brief Format value for bitfield I2C_F_ICR.
#define BF_I2C_F_ICR(v)      (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_F_ICR), uint8_t) & BM_I2C_F_ICR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ICR field to a new value.
#define BW_I2C_F_ICR(x, v)   (HW_I2C_F_WR(x, (HW_I2C_F_RD(x) & ~BM_I2C_F_ICR) | BF_I2C_F_ICR(v)))
#endif
//@}

/*!
 * @name Register I2C_F, field MULT[7:6] (RW)
 *
 * Defines the multiplier factor (mul). This factor is used along with the SCL
 * divider to generate the I2C baud rate.
 *
 * Values:
 * - 00 - mul = 1
 * - 01 - mul = 2
 * - 10 - mul = 4
 * - 11 - Reserved
 */
//@{
#define BP_I2C_F_MULT        (6U)          //!< Bit position for I2C_F_MULT.
#define BM_I2C_F_MULT        (0xC0U)       //!< Bit mask for I2C_F_MULT.
#define BS_I2C_F_MULT        (2U)          //!< Bit field size in bits for I2C_F_MULT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_F_MULT field.
#define BR_I2C_F_MULT(x)     (HW_I2C_F(x).B.MULT)
#endif

//! @brief Format value for bitfield I2C_F_MULT.
#define BF_I2C_F_MULT(v)     (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_F_MULT), uint8_t) & BM_I2C_F_MULT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MULT field to a new value.
#define BW_I2C_F_MULT(x, v)  (HW_I2C_F_WR(x, (HW_I2C_F_RD(x) & ~BM_I2C_F_MULT) | BF_I2C_F_MULT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2C_C1 - I2C Control Register 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2C_C1 - I2C Control Register 1 (RW)
 *
 * Reset value: 0x00U
 */
typedef union _hw_i2c_c1
{
    uint8_t U;
    struct _hw_i2c_c1_bitfields
    {
        uint8_t DMAEN : 1;             //!< [0] DMA Enable
        uint8_t WUEN : 1;              //!< [1] Wakeup Enable
        uint8_t RSTA : 1;              //!< [2] Repeat START
        uint8_t TXAK : 1;              //!< [3] Transmit Acknowledge Enable
        uint8_t TX : 1;                //!< [4] Transmit Mode Select
        uint8_t MST : 1;               //!< [5] Master Mode Select
        uint8_t IICIE : 1;             //!< [6] I2C Interrupt Enable
        uint8_t IICEN : 1;             //!< [7] I2C Enable
    } B;
} hw_i2c_c1_t;
#endif

/*!
 * @name Constants and macros for entire I2C_C1 register
 */
//@{
#define HW_I2C_C1_ADDR(x)        (REGS_I2C_BASE(x) + 0x2U)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_C1(x)             (*(__IO hw_i2c_c1_t *) HW_I2C_C1_ADDR(x))
#define HW_I2C_C1_RD(x)          (HW_I2C_C1(x).U)
#define HW_I2C_C1_WR(x, v)       (HW_I2C_C1(x).U = (v))
#define HW_I2C_C1_SET(x, v)      (HW_I2C_C1_WR(x, HW_I2C_C1_RD(x) |  (v)))
#define HW_I2C_C1_CLR(x, v)      (HW_I2C_C1_WR(x, HW_I2C_C1_RD(x) & ~(v)))
#define HW_I2C_C1_TOG(x, v)      (HW_I2C_C1_WR(x, HW_I2C_C1_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2C_C1 bitfields
 */

/*!
 * @name Register I2C_C1, field DMAEN[0] (RW)
 *
 * Enables or disables the DMA function.
 *
 * Values:
 * - 0 - All DMA signalling disabled.
 * - 1 - DMA transfer is enabled. While SMB[FACK] = 0, the following conditions
 *     trigger the DMA request: a data byte is received, and either address or
 *     data is transmitted. (ACK/NACK is automatic) the first byte received matches
 *     the A1 register or is a general call address. If any address matching
 *     occurs, S[IAAS] and S[TCF] are set. If the direction of transfer is known
 *     from master to slave, then it is not required to check S[SRW]. With this
 *     assumption, DMA can also be used in this case. In other cases, if the master
 *     reads data from the slave, then it is required to rewrite the C1 register
 *     operation. With this assumption, DMA cannot be used. When FACK = 1, an
 *     address or a data byte is transmitted.
 */
//@{
#define BP_I2C_C1_DMAEN      (0U)          //!< Bit position for I2C_C1_DMAEN.
#define BM_I2C_C1_DMAEN      (0x01U)       //!< Bit mask for I2C_C1_DMAEN.
#define BS_I2C_C1_DMAEN      (1U)          //!< Bit field size in bits for I2C_C1_DMAEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_C1_DMAEN field.
#define BR_I2C_C1_DMAEN(x)   (BITBAND_ACCESS8(HW_I2C_C1_ADDR(x), BP_I2C_C1_DMAEN))
#endif

//! @brief Format value for bitfield I2C_C1_DMAEN.
#define BF_I2C_C1_DMAEN(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_C1_DMAEN), uint8_t) & BM_I2C_C1_DMAEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMAEN field to a new value.
#define BW_I2C_C1_DMAEN(x, v) (BITBAND_ACCESS8(HW_I2C_C1_ADDR(x), BP_I2C_C1_DMAEN) = (v))
#endif
//@}

/*!
 * @name Register I2C_C1, field WUEN[1] (RW)
 *
 * The I2C module can wake the MCU from low power mode with no peripheral bus
 * running when slave address matching occurs.
 *
 * Values:
 * - 0 - Normal operation. No interrupt generated when address matching in low
 *     power mode.
 * - 1 - Enables the wakeup function in low power mode.
 */
//@{
#define BP_I2C_C1_WUEN       (1U)          //!< Bit position for I2C_C1_WUEN.
#define BM_I2C_C1_WUEN       (0x02U)       //!< Bit mask for I2C_C1_WUEN.
#define BS_I2C_C1_WUEN       (1U)          //!< Bit field size in bits for I2C_C1_WUEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_C1_WUEN field.
#define BR_I2C_C1_WUEN(x)    (BITBAND_ACCESS8(HW_I2C_C1_ADDR(x), BP_I2C_C1_WUEN))
#endif

//! @brief Format value for bitfield I2C_C1_WUEN.
#define BF_I2C_C1_WUEN(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_C1_WUEN), uint8_t) & BM_I2C_C1_WUEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WUEN field to a new value.
#define BW_I2C_C1_WUEN(x, v) (BITBAND_ACCESS8(HW_I2C_C1_ADDR(x), BP_I2C_C1_WUEN) = (v))
#endif
//@}

/*!
 * @name Register I2C_C1, field RSTA[2] (WORZ)
 *
 * Writing 1 to this bit generates a repeated START condition provided it is the
 * current master. This bit will always be read as 0. Attempting a repeat at the
 * wrong time results in loss of arbitration.
 */
//@{
#define BP_I2C_C1_RSTA       (2U)          //!< Bit position for I2C_C1_RSTA.
#define BM_I2C_C1_RSTA       (0x04U)       //!< Bit mask for I2C_C1_RSTA.
#define BS_I2C_C1_RSTA       (1U)          //!< Bit field size in bits for I2C_C1_RSTA.

//! @brief Format value for bitfield I2C_C1_RSTA.
#define BF_I2C_C1_RSTA(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_C1_RSTA), uint8_t) & BM_I2C_C1_RSTA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RSTA field to a new value.
#define BW_I2C_C1_RSTA(x, v) (BITBAND_ACCESS8(HW_I2C_C1_ADDR(x), BP_I2C_C1_RSTA) = (v))
#endif
//@}

/*!
 * @name Register I2C_C1, field TXAK[3] (RW)
 *
 * Specifies the value driven onto the SDA during data acknowledge cycles for
 * both master and slave receivers. The value of SMB[FACK] affects NACK/ACK
 * generation. SCL is held low until TXAK is written.
 *
 * Values:
 * - 0 - An acknowledge signal is sent to the bus on the following receiving
 *     byte (if FACK is cleared) or the current receiving byte (if FACK is set).
 * - 1 - No acknowledge signal is sent to the bus on the following receiving
 *     data byte (if FACK is cleared) or the current receiving data byte (if FACK is
 *     set).
 */
//@{
#define BP_I2C_C1_TXAK       (3U)          //!< Bit position for I2C_C1_TXAK.
#define BM_I2C_C1_TXAK       (0x08U)       //!< Bit mask for I2C_C1_TXAK.
#define BS_I2C_C1_TXAK       (1U)          //!< Bit field size in bits for I2C_C1_TXAK.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_C1_TXAK field.
#define BR_I2C_C1_TXAK(x)    (BITBAND_ACCESS8(HW_I2C_C1_ADDR(x), BP_I2C_C1_TXAK))
#endif

//! @brief Format value for bitfield I2C_C1_TXAK.
#define BF_I2C_C1_TXAK(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_C1_TXAK), uint8_t) & BM_I2C_C1_TXAK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TXAK field to a new value.
#define BW_I2C_C1_TXAK(x, v) (BITBAND_ACCESS8(HW_I2C_C1_ADDR(x), BP_I2C_C1_TXAK) = (v))
#endif
//@}

/*!
 * @name Register I2C_C1, field TX[4] (RW)
 *
 * Selects the direction of master and slave transfers. In master mode this bit
 * must be set according to the type of transfer required. Therefore, for address
 * cycles, this bit is always set. When addressed as a slave this bit must be
 * set by software according to the SRW bit in the status register.
 *
 * Values:
 * - 0 - Receive
 * - 1 - Transmit
 */
//@{
#define BP_I2C_C1_TX         (4U)          //!< Bit position for I2C_C1_TX.
#define BM_I2C_C1_TX         (0x10U)       //!< Bit mask for I2C_C1_TX.
#define BS_I2C_C1_TX         (1U)          //!< Bit field size in bits for I2C_C1_TX.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_C1_TX field.
#define BR_I2C_C1_TX(x)      (BITBAND_ACCESS8(HW_I2C_C1_ADDR(x), BP_I2C_C1_TX))
#endif

//! @brief Format value for bitfield I2C_C1_TX.
#define BF_I2C_C1_TX(v)      (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_C1_TX), uint8_t) & BM_I2C_C1_TX)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TX field to a new value.
#define BW_I2C_C1_TX(x, v)   (BITBAND_ACCESS8(HW_I2C_C1_ADDR(x), BP_I2C_C1_TX) = (v))
#endif
//@}

/*!
 * @name Register I2C_C1, field MST[5] (RW)
 *
 * When MST is changed from 0 to 1, a START signal is generated on the bus and
 * master mode is selected. When this bit changes from 1 to 0, a STOP signal is
 * generated and the mode of operation changes from master to slave.
 *
 * Values:
 * - 0 - Slave mode
 * - 1 - Master mode
 */
//@{
#define BP_I2C_C1_MST        (5U)          //!< Bit position for I2C_C1_MST.
#define BM_I2C_C1_MST        (0x20U)       //!< Bit mask for I2C_C1_MST.
#define BS_I2C_C1_MST        (1U)          //!< Bit field size in bits for I2C_C1_MST.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_C1_MST field.
#define BR_I2C_C1_MST(x)     (BITBAND_ACCESS8(HW_I2C_C1_ADDR(x), BP_I2C_C1_MST))
#endif

//! @brief Format value for bitfield I2C_C1_MST.
#define BF_I2C_C1_MST(v)     (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_C1_MST), uint8_t) & BM_I2C_C1_MST)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MST field to a new value.
#define BW_I2C_C1_MST(x, v)  (BITBAND_ACCESS8(HW_I2C_C1_ADDR(x), BP_I2C_C1_MST) = (v))
#endif
//@}

/*!
 * @name Register I2C_C1, field IICIE[6] (RW)
 *
 * Enables I2C interrupt requests.
 *
 * Values:
 * - 0 - Disabled
 * - 1 - Enabled
 */
//@{
#define BP_I2C_C1_IICIE      (6U)          //!< Bit position for I2C_C1_IICIE.
#define BM_I2C_C1_IICIE      (0x40U)       //!< Bit mask for I2C_C1_IICIE.
#define BS_I2C_C1_IICIE      (1U)          //!< Bit field size in bits for I2C_C1_IICIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_C1_IICIE field.
#define BR_I2C_C1_IICIE(x)   (BITBAND_ACCESS8(HW_I2C_C1_ADDR(x), BP_I2C_C1_IICIE))
#endif

//! @brief Format value for bitfield I2C_C1_IICIE.
#define BF_I2C_C1_IICIE(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_C1_IICIE), uint8_t) & BM_I2C_C1_IICIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IICIE field to a new value.
#define BW_I2C_C1_IICIE(x, v) (BITBAND_ACCESS8(HW_I2C_C1_ADDR(x), BP_I2C_C1_IICIE) = (v))
#endif
//@}

/*!
 * @name Register I2C_C1, field IICEN[7] (RW)
 *
 * Enables I2C module operation.
 *
 * Values:
 * - 0 - Disabled
 * - 1 - Enabled
 */
//@{
#define BP_I2C_C1_IICEN      (7U)          //!< Bit position for I2C_C1_IICEN.
#define BM_I2C_C1_IICEN      (0x80U)       //!< Bit mask for I2C_C1_IICEN.
#define BS_I2C_C1_IICEN      (1U)          //!< Bit field size in bits for I2C_C1_IICEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_C1_IICEN field.
#define BR_I2C_C1_IICEN(x)   (BITBAND_ACCESS8(HW_I2C_C1_ADDR(x), BP_I2C_C1_IICEN))
#endif

//! @brief Format value for bitfield I2C_C1_IICEN.
#define BF_I2C_C1_IICEN(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_C1_IICEN), uint8_t) & BM_I2C_C1_IICEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IICEN field to a new value.
#define BW_I2C_C1_IICEN(x, v) (BITBAND_ACCESS8(HW_I2C_C1_ADDR(x), BP_I2C_C1_IICEN) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2C_S - I2C Status register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2C_S - I2C Status register (RW)
 *
 * Reset value: 0x80U
 */
typedef union _hw_i2c_s
{
    uint8_t U;
    struct _hw_i2c_s_bitfields
    {
        uint8_t RXAK : 1;              //!< [0] Receive Acknowledge
        uint8_t IICIF : 1;             //!< [1] Interrupt Flag
        uint8_t SRW : 1;               //!< [2] Slave Read/Write
        uint8_t RAM : 1;               //!< [3] Range Address Match
        uint8_t ARBL : 1;              //!< [4] Arbitration Lost
        uint8_t BUSY : 1;              //!< [5] Bus Busy
        uint8_t IAAS : 1;              //!< [6] Addressed As A Slave
        uint8_t TCF : 1;               //!< [7] Transfer Complete Flag
    } B;
} hw_i2c_s_t;
#endif

/*!
 * @name Constants and macros for entire I2C_S register
 */
//@{
#define HW_I2C_S_ADDR(x)         (REGS_I2C_BASE(x) + 0x3U)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_S(x)              (*(__IO hw_i2c_s_t *) HW_I2C_S_ADDR(x))
#define HW_I2C_S_RD(x)           (HW_I2C_S(x).U)
#define HW_I2C_S_WR(x, v)        (HW_I2C_S(x).U = (v))
#define HW_I2C_S_SET(x, v)       (HW_I2C_S_WR(x, HW_I2C_S_RD(x) |  (v)))
#define HW_I2C_S_CLR(x, v)       (HW_I2C_S_WR(x, HW_I2C_S_RD(x) & ~(v)))
#define HW_I2C_S_TOG(x, v)       (HW_I2C_S_WR(x, HW_I2C_S_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2C_S bitfields
 */

/*!
 * @name Register I2C_S, field RXAK[0] (RO)
 *
 * Values:
 * - 0 - Acknowledge signal was received after the completion of one byte of
 *     data transmission on the bus
 * - 1 - No acknowledge signal detected
 */
//@{
#define BP_I2C_S_RXAK        (0U)          //!< Bit position for I2C_S_RXAK.
#define BM_I2C_S_RXAK        (0x01U)       //!< Bit mask for I2C_S_RXAK.
#define BS_I2C_S_RXAK        (1U)          //!< Bit field size in bits for I2C_S_RXAK.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_S_RXAK field.
#define BR_I2C_S_RXAK(x)     (BITBAND_ACCESS8(HW_I2C_S_ADDR(x), BP_I2C_S_RXAK))
#endif
//@}

/*!
 * @name Register I2C_S, field IICIF[1] (W1C)
 *
 * This bit sets when an interrupt is pending. This bit must be cleared by
 * software by writing 1 to it, such as in the interrupt routine. One of the following
 * events can set this bit: One byte transfer, including ACK/NACK bit, completes
 * if FACK is 0. An ACK or NACK is sent on the bus by writing 0 or 1 to TXAK
 * after this bit is set in receive mode. One byte transfer, excluding ACK/NACK bit,
 * completes if FACK is 1. Match of slave address to calling address including
 * primary slave address, range slave address , alert response address, second
 * slave address, or general call address. Arbitration lost In SMBus mode, any
 * timeouts except SCL and SDA high timeouts I2C bus stop or start detection if the
 * SSIE bit in the Input Glitch Filter register is 1 To clear the I2C bus stop or
 * start detection interrupt: In the interrupt service routine, first clear the
 * STOPF or STARTF bit in the Input Glitch Filter register by writing 1 to it, and
 * then clear the IICIF bit. If this sequence is reversed, the IICIF bit is
 * asserted again.
 *
 * Values:
 * - 0 - No interrupt pending
 * - 1 - Interrupt pending
 */
//@{
#define BP_I2C_S_IICIF       (1U)          //!< Bit position for I2C_S_IICIF.
#define BM_I2C_S_IICIF       (0x02U)       //!< Bit mask for I2C_S_IICIF.
#define BS_I2C_S_IICIF       (1U)          //!< Bit field size in bits for I2C_S_IICIF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_S_IICIF field.
#define BR_I2C_S_IICIF(x)    (BITBAND_ACCESS8(HW_I2C_S_ADDR(x), BP_I2C_S_IICIF))
#endif

//! @brief Format value for bitfield I2C_S_IICIF.
#define BF_I2C_S_IICIF(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_S_IICIF), uint8_t) & BM_I2C_S_IICIF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IICIF field to a new value.
#define BW_I2C_S_IICIF(x, v) (BITBAND_ACCESS8(HW_I2C_S_ADDR(x), BP_I2C_S_IICIF) = (v))
#endif
//@}

/*!
 * @name Register I2C_S, field SRW[2] (RO)
 *
 * When addressed as a slave, SRW indicates the value of the R/W command bit of
 * the calling address sent to the master.
 *
 * Values:
 * - 0 - Slave receive, master writing to slave
 * - 1 - Slave transmit, master reading from slave
 */
//@{
#define BP_I2C_S_SRW         (2U)          //!< Bit position for I2C_S_SRW.
#define BM_I2C_S_SRW         (0x04U)       //!< Bit mask for I2C_S_SRW.
#define BS_I2C_S_SRW         (1U)          //!< Bit field size in bits for I2C_S_SRW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_S_SRW field.
#define BR_I2C_S_SRW(x)      (BITBAND_ACCESS8(HW_I2C_S_ADDR(x), BP_I2C_S_SRW))
#endif
//@}

/*!
 * @name Register I2C_S, field RAM[3] (RW)
 *
 * This bit is set to 1 by any of the following conditions, if I2C_C2[RMEN] = 1:
 * Any nonzero calling address is received that matches the address in the RA
 * register. The calling address is within the range of values of the A1 and RA
 * registers. For the RAM bit to be set to 1 correctly, C1[IICIE] must be set to 1.
 * Writing the C1 register with any value clears this bit to 0.
 *
 * Values:
 * - 0 - Not addressed
 * - 1 - Addressed as a slave
 */
//@{
#define BP_I2C_S_RAM         (3U)          //!< Bit position for I2C_S_RAM.
#define BM_I2C_S_RAM         (0x08U)       //!< Bit mask for I2C_S_RAM.
#define BS_I2C_S_RAM         (1U)          //!< Bit field size in bits for I2C_S_RAM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_S_RAM field.
#define BR_I2C_S_RAM(x)      (BITBAND_ACCESS8(HW_I2C_S_ADDR(x), BP_I2C_S_RAM))
#endif

//! @brief Format value for bitfield I2C_S_RAM.
#define BF_I2C_S_RAM(v)      (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_S_RAM), uint8_t) & BM_I2C_S_RAM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RAM field to a new value.
#define BW_I2C_S_RAM(x, v)   (BITBAND_ACCESS8(HW_I2C_S_ADDR(x), BP_I2C_S_RAM) = (v))
#endif
//@}

/*!
 * @name Register I2C_S, field ARBL[4] (W1C)
 *
 * This bit is set by hardware when the arbitration procedure is lost. The ARBL
 * bit must be cleared by software, by writing 1 to it.
 *
 * Values:
 * - 0 - Standard bus operation.
 * - 1 - Loss of arbitration.
 */
//@{
#define BP_I2C_S_ARBL        (4U)          //!< Bit position for I2C_S_ARBL.
#define BM_I2C_S_ARBL        (0x10U)       //!< Bit mask for I2C_S_ARBL.
#define BS_I2C_S_ARBL        (1U)          //!< Bit field size in bits for I2C_S_ARBL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_S_ARBL field.
#define BR_I2C_S_ARBL(x)     (BITBAND_ACCESS8(HW_I2C_S_ADDR(x), BP_I2C_S_ARBL))
#endif

//! @brief Format value for bitfield I2C_S_ARBL.
#define BF_I2C_S_ARBL(v)     (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_S_ARBL), uint8_t) & BM_I2C_S_ARBL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ARBL field to a new value.
#define BW_I2C_S_ARBL(x, v)  (BITBAND_ACCESS8(HW_I2C_S_ADDR(x), BP_I2C_S_ARBL) = (v))
#endif
//@}

/*!
 * @name Register I2C_S, field BUSY[5] (RO)
 *
 * Indicates the status of the bus regardless of slave or master mode. This bit
 * is set when a START signal is detected and cleared when a STOP signal is
 * detected.
 *
 * Values:
 * - 0 - Bus is idle
 * - 1 - Bus is busy
 */
//@{
#define BP_I2C_S_BUSY        (5U)          //!< Bit position for I2C_S_BUSY.
#define BM_I2C_S_BUSY        (0x20U)       //!< Bit mask for I2C_S_BUSY.
#define BS_I2C_S_BUSY        (1U)          //!< Bit field size in bits for I2C_S_BUSY.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_S_BUSY field.
#define BR_I2C_S_BUSY(x)     (BITBAND_ACCESS8(HW_I2C_S_ADDR(x), BP_I2C_S_BUSY))
#endif
//@}

/*!
 * @name Register I2C_S, field IAAS[6] (RW)
 *
 * This bit is set by one of the following conditions: The calling address
 * matches the programmed primary slave address in the A1 register, or matches the
 * range address in the RA register (which must be set to a nonzero value and under
 * the condition I2C_C2[RMEN] = 1). C2[GCAEN] is set and a general call is
 * received. SMB[SIICAEN] is set and the calling address matches the second programmed
 * slave address. ALERTEN is set and an SMBus alert response address is received
 * RMEN is set and an address is received that is within the range between the
 * values of the A1 and RA registers. IAAS sets before the ACK bit. The CPU must
 * check the SRW bit and set TX/RX accordingly. Writing the C1 register with any
 * value clears this bit.
 *
 * Values:
 * - 0 - Not addressed
 * - 1 - Addressed as a slave
 */
//@{
#define BP_I2C_S_IAAS        (6U)          //!< Bit position for I2C_S_IAAS.
#define BM_I2C_S_IAAS        (0x40U)       //!< Bit mask for I2C_S_IAAS.
#define BS_I2C_S_IAAS        (1U)          //!< Bit field size in bits for I2C_S_IAAS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_S_IAAS field.
#define BR_I2C_S_IAAS(x)     (BITBAND_ACCESS8(HW_I2C_S_ADDR(x), BP_I2C_S_IAAS))
#endif

//! @brief Format value for bitfield I2C_S_IAAS.
#define BF_I2C_S_IAAS(v)     (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_S_IAAS), uint8_t) & BM_I2C_S_IAAS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IAAS field to a new value.
#define BW_I2C_S_IAAS(x, v)  (BITBAND_ACCESS8(HW_I2C_S_ADDR(x), BP_I2C_S_IAAS) = (v))
#endif
//@}

/*!
 * @name Register I2C_S, field TCF[7] (RO)
 *
 * Acknowledges a byte transfer; TCF sets on the completion of a byte transfer.
 * This bit is valid only during or immediately following a transfer to or from
 * the I2C module. TCF is cleared by reading the I2C data register in receive mode
 * or by writing to the I2C data register in transmit mode.
 *
 * Values:
 * - 0 - Transfer in progress
 * - 1 - Transfer complete
 */
//@{
#define BP_I2C_S_TCF         (7U)          //!< Bit position for I2C_S_TCF.
#define BM_I2C_S_TCF         (0x80U)       //!< Bit mask for I2C_S_TCF.
#define BS_I2C_S_TCF         (1U)          //!< Bit field size in bits for I2C_S_TCF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_S_TCF field.
#define BR_I2C_S_TCF(x)      (BITBAND_ACCESS8(HW_I2C_S_ADDR(x), BP_I2C_S_TCF))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2C_D - I2C Data I/O register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2C_D - I2C Data I/O register (RW)
 *
 * Reset value: 0x00U
 */
typedef union _hw_i2c_d
{
    uint8_t U;
    struct _hw_i2c_d_bitfields
    {
        uint8_t DATA : 8;              //!< [7:0] Data
    } B;
} hw_i2c_d_t;
#endif

/*!
 * @name Constants and macros for entire I2C_D register
 */
//@{
#define HW_I2C_D_ADDR(x)         (REGS_I2C_BASE(x) + 0x4U)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_D(x)              (*(__IO hw_i2c_d_t *) HW_I2C_D_ADDR(x))
#define HW_I2C_D_RD(x)           (HW_I2C_D(x).U)
#define HW_I2C_D_WR(x, v)        (HW_I2C_D(x).U = (v))
#define HW_I2C_D_SET(x, v)       (HW_I2C_D_WR(x, HW_I2C_D_RD(x) |  (v)))
#define HW_I2C_D_CLR(x, v)       (HW_I2C_D_WR(x, HW_I2C_D_RD(x) & ~(v)))
#define HW_I2C_D_TOG(x, v)       (HW_I2C_D_WR(x, HW_I2C_D_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2C_D bitfields
 */

/*!
 * @name Register I2C_D, field DATA[7:0] (RW)
 *
 * In master transmit mode, when data is written to this register, a data
 * transfer is initiated. The most significant bit is sent first. In master receive
 * mode, reading this register initiates receiving of the next byte of data. When
 * making the transition out of master receive mode, switch the I2C mode before
 * reading the Data register to prevent an inadvertent initiation of a master
 * receive data transfer. In slave mode, the same functions are available after an
 * address match occurs. The C1[TX] bit must correctly reflect the desired direction
 * of transfer in master and slave modes for the transmission to begin. For
 * example, if the I2C module is configured for master transmit but a master receive
 * is desired, reading the Data register does not initiate the receive. Reading
 * the Data register returns the last byte received while the I2C module is
 * configured in master receive or slave receive mode. The Data register does not
 * reflect every byte that is transmitted on the I2C bus, and neither can software
 * verify that a byte has been written to the Data register correctly by reading it
 * back. In master transmit mode, the first byte of data written to the Data
 * register following assertion of MST (start bit) or assertion of RSTA (repeated
 * start bit) is used for the address transfer and must consist of the calling
 * address (in bits 7-1) concatenated with the required R/W bit (in position bit 0).
 */
//@{
#define BP_I2C_D_DATA        (0U)          //!< Bit position for I2C_D_DATA.
#define BM_I2C_D_DATA        (0xFFU)       //!< Bit mask for I2C_D_DATA.
#define BS_I2C_D_DATA        (8U)          //!< Bit field size in bits for I2C_D_DATA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_D_DATA field.
#define BR_I2C_D_DATA(x)     (HW_I2C_D(x).U)
#endif

//! @brief Format value for bitfield I2C_D_DATA.
#define BF_I2C_D_DATA(v)     (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_D_DATA), uint8_t) & BM_I2C_D_DATA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATA field to a new value.
#define BW_I2C_D_DATA(x, v)  (HW_I2C_D_WR(x, v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2C_C2 - I2C Control Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2C_C2 - I2C Control Register 2 (RW)
 *
 * Reset value: 0x00U
 */
typedef union _hw_i2c_c2
{
    uint8_t U;
    struct _hw_i2c_c2_bitfields
    {
        uint8_t AD : 3;                //!< [2:0] Slave Address
        uint8_t RMEN : 1;              //!< [3] Range Address Matching Enable
        uint8_t SBRC : 1;              //!< [4] Slave Baud Rate Control
        uint8_t HDRS : 1;              //!< [5] High Drive Select
        uint8_t ADEXT : 1;             //!< [6] Address Extension
        uint8_t GCAEN : 1;             //!< [7] General Call Address Enable
    } B;
} hw_i2c_c2_t;
#endif

/*!
 * @name Constants and macros for entire I2C_C2 register
 */
//@{
#define HW_I2C_C2_ADDR(x)        (REGS_I2C_BASE(x) + 0x5U)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_C2(x)             (*(__IO hw_i2c_c2_t *) HW_I2C_C2_ADDR(x))
#define HW_I2C_C2_RD(x)          (HW_I2C_C2(x).U)
#define HW_I2C_C2_WR(x, v)       (HW_I2C_C2(x).U = (v))
#define HW_I2C_C2_SET(x, v)      (HW_I2C_C2_WR(x, HW_I2C_C2_RD(x) |  (v)))
#define HW_I2C_C2_CLR(x, v)      (HW_I2C_C2_WR(x, HW_I2C_C2_RD(x) & ~(v)))
#define HW_I2C_C2_TOG(x, v)      (HW_I2C_C2_WR(x, HW_I2C_C2_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2C_C2 bitfields
 */

/*!
 * @name Register I2C_C2, field AD[2:0] (RW)
 *
 * Contains the upper three bits of the slave address in the 10-bit address
 * scheme. This field is valid only while the ADEXT bit is set.
 */
//@{
#define BP_I2C_C2_AD         (0U)          //!< Bit position for I2C_C2_AD.
#define BM_I2C_C2_AD         (0x07U)       //!< Bit mask for I2C_C2_AD.
#define BS_I2C_C2_AD         (3U)          //!< Bit field size in bits for I2C_C2_AD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_C2_AD field.
#define BR_I2C_C2_AD(x)      (HW_I2C_C2(x).B.AD)
#endif

//! @brief Format value for bitfield I2C_C2_AD.
#define BF_I2C_C2_AD(v)      (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_C2_AD), uint8_t) & BM_I2C_C2_AD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AD field to a new value.
#define BW_I2C_C2_AD(x, v)   (HW_I2C_C2_WR(x, (HW_I2C_C2_RD(x) & ~BM_I2C_C2_AD) | BF_I2C_C2_AD(v)))
#endif
//@}

/*!
 * @name Register I2C_C2, field RMEN[3] (RW)
 *
 * This bit controls the slave address matching for addresses between the values
 * of the A1 and RA registers. When this bit is set, a slave address matching
 * occurs for any address greater than the value of the A1 register and less than
 * or equal to the value of the RA register.
 *
 * Values:
 * - 0 - Range mode disabled. No address matching occurs for an address within
 *     the range of values of the A1 and RA registers.
 * - 1 - Range mode enabled. Address matching occurs when a slave receives an
 *     address within the range of values of the A1 and RA registers.
 */
//@{
#define BP_I2C_C2_RMEN       (3U)          //!< Bit position for I2C_C2_RMEN.
#define BM_I2C_C2_RMEN       (0x08U)       //!< Bit mask for I2C_C2_RMEN.
#define BS_I2C_C2_RMEN       (1U)          //!< Bit field size in bits for I2C_C2_RMEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_C2_RMEN field.
#define BR_I2C_C2_RMEN(x)    (BITBAND_ACCESS8(HW_I2C_C2_ADDR(x), BP_I2C_C2_RMEN))
#endif

//! @brief Format value for bitfield I2C_C2_RMEN.
#define BF_I2C_C2_RMEN(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_C2_RMEN), uint8_t) & BM_I2C_C2_RMEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RMEN field to a new value.
#define BW_I2C_C2_RMEN(x, v) (BITBAND_ACCESS8(HW_I2C_C2_ADDR(x), BP_I2C_C2_RMEN) = (v))
#endif
//@}

/*!
 * @name Register I2C_C2, field SBRC[4] (RW)
 *
 * Enables independent slave mode baud rate at maximum frequency, which forces
 * clock stretching on SCL in very fast I2C modes. To a slave, an example of a
 * "very fast" mode is when the master transfers at 40 kbit/s but the slave can
 * capture the master's data at only 10 kbit/s.
 *
 * Values:
 * - 0 - The slave baud rate follows the master baud rate and clock stretching
 *     may occur
 * - 1 - Slave baud rate is independent of the master baud rate
 */
//@{
#define BP_I2C_C2_SBRC       (4U)          //!< Bit position for I2C_C2_SBRC.
#define BM_I2C_C2_SBRC       (0x10U)       //!< Bit mask for I2C_C2_SBRC.
#define BS_I2C_C2_SBRC       (1U)          //!< Bit field size in bits for I2C_C2_SBRC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_C2_SBRC field.
#define BR_I2C_C2_SBRC(x)    (BITBAND_ACCESS8(HW_I2C_C2_ADDR(x), BP_I2C_C2_SBRC))
#endif

//! @brief Format value for bitfield I2C_C2_SBRC.
#define BF_I2C_C2_SBRC(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_C2_SBRC), uint8_t) & BM_I2C_C2_SBRC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SBRC field to a new value.
#define BW_I2C_C2_SBRC(x, v) (BITBAND_ACCESS8(HW_I2C_C2_ADDR(x), BP_I2C_C2_SBRC) = (v))
#endif
//@}

/*!
 * @name Register I2C_C2, field HDRS[5] (RW)
 *
 * Controls the drive capability of the I2C pads.
 *
 * Values:
 * - 0 - Normal drive mode
 * - 1 - High drive mode
 */
//@{
#define BP_I2C_C2_HDRS       (5U)          //!< Bit position for I2C_C2_HDRS.
#define BM_I2C_C2_HDRS       (0x20U)       //!< Bit mask for I2C_C2_HDRS.
#define BS_I2C_C2_HDRS       (1U)          //!< Bit field size in bits for I2C_C2_HDRS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_C2_HDRS field.
#define BR_I2C_C2_HDRS(x)    (BITBAND_ACCESS8(HW_I2C_C2_ADDR(x), BP_I2C_C2_HDRS))
#endif

//! @brief Format value for bitfield I2C_C2_HDRS.
#define BF_I2C_C2_HDRS(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_C2_HDRS), uint8_t) & BM_I2C_C2_HDRS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HDRS field to a new value.
#define BW_I2C_C2_HDRS(x, v) (BITBAND_ACCESS8(HW_I2C_C2_ADDR(x), BP_I2C_C2_HDRS) = (v))
#endif
//@}

/*!
 * @name Register I2C_C2, field ADEXT[6] (RW)
 *
 * Controls the number of bits used for the slave address.
 *
 * Values:
 * - 0 - 7-bit address scheme
 * - 1 - 10-bit address scheme
 */
//@{
#define BP_I2C_C2_ADEXT      (6U)          //!< Bit position for I2C_C2_ADEXT.
#define BM_I2C_C2_ADEXT      (0x40U)       //!< Bit mask for I2C_C2_ADEXT.
#define BS_I2C_C2_ADEXT      (1U)          //!< Bit field size in bits for I2C_C2_ADEXT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_C2_ADEXT field.
#define BR_I2C_C2_ADEXT(x)   (BITBAND_ACCESS8(HW_I2C_C2_ADDR(x), BP_I2C_C2_ADEXT))
#endif

//! @brief Format value for bitfield I2C_C2_ADEXT.
#define BF_I2C_C2_ADEXT(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_C2_ADEXT), uint8_t) & BM_I2C_C2_ADEXT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADEXT field to a new value.
#define BW_I2C_C2_ADEXT(x, v) (BITBAND_ACCESS8(HW_I2C_C2_ADDR(x), BP_I2C_C2_ADEXT) = (v))
#endif
//@}

/*!
 * @name Register I2C_C2, field GCAEN[7] (RW)
 *
 * Enables general call address.
 *
 * Values:
 * - 0 - Disabled
 * - 1 - Enabled
 */
//@{
#define BP_I2C_C2_GCAEN      (7U)          //!< Bit position for I2C_C2_GCAEN.
#define BM_I2C_C2_GCAEN      (0x80U)       //!< Bit mask for I2C_C2_GCAEN.
#define BS_I2C_C2_GCAEN      (1U)          //!< Bit field size in bits for I2C_C2_GCAEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_C2_GCAEN field.
#define BR_I2C_C2_GCAEN(x)   (BITBAND_ACCESS8(HW_I2C_C2_ADDR(x), BP_I2C_C2_GCAEN))
#endif

//! @brief Format value for bitfield I2C_C2_GCAEN.
#define BF_I2C_C2_GCAEN(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_C2_GCAEN), uint8_t) & BM_I2C_C2_GCAEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the GCAEN field to a new value.
#define BW_I2C_C2_GCAEN(x, v) (BITBAND_ACCESS8(HW_I2C_C2_ADDR(x), BP_I2C_C2_GCAEN) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2C_FLT - I2C Programmable Input Glitch Filter register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2C_FLT - I2C Programmable Input Glitch Filter register (RW)
 *
 * Reset value: 0x00U
 */
typedef union _hw_i2c_flt
{
    uint8_t U;
    struct _hw_i2c_flt_bitfields
    {
        uint8_t FLT : 4;               //!< [3:0] I2C Programmable Filter Factor
        uint8_t STARTF : 1;            //!< [4] I2C Bus Start Detect Flag
        uint8_t SSIE : 1;              //!< [5] I2C Bus Stop or Start Interrupt Enable
        uint8_t STOPF : 1;             //!< [6] I2C Bus Stop Detect Flag
        uint8_t SHEN : 1;              //!< [7] Stop Hold Enable
    } B;
} hw_i2c_flt_t;
#endif

/*!
 * @name Constants and macros for entire I2C_FLT register
 */
//@{
#define HW_I2C_FLT_ADDR(x)       (REGS_I2C_BASE(x) + 0x6U)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_FLT(x)            (*(__IO hw_i2c_flt_t *) HW_I2C_FLT_ADDR(x))
#define HW_I2C_FLT_RD(x)         (HW_I2C_FLT(x).U)
#define HW_I2C_FLT_WR(x, v)      (HW_I2C_FLT(x).U = (v))
#define HW_I2C_FLT_SET(x, v)     (HW_I2C_FLT_WR(x, HW_I2C_FLT_RD(x) |  (v)))
#define HW_I2C_FLT_CLR(x, v)     (HW_I2C_FLT_WR(x, HW_I2C_FLT_RD(x) & ~(v)))
#define HW_I2C_FLT_TOG(x, v)     (HW_I2C_FLT_WR(x, HW_I2C_FLT_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2C_FLT bitfields
 */

/*!
 * @name Register I2C_FLT, field FLT[3:0] (RW)
 *
 * Controls the width of the glitch, in terms of I2C module clock cycles, that
 * the filter must absorb. For any glitch whose size is less than or equal to this
 * width setting, the filter does not allow the glitch to pass.
 *
 * Values:
 * - 0 - No filter/bypass
 */
//@{
#define BP_I2C_FLT_FLT       (0U)          //!< Bit position for I2C_FLT_FLT.
#define BM_I2C_FLT_FLT       (0x0FU)       //!< Bit mask for I2C_FLT_FLT.
#define BS_I2C_FLT_FLT       (4U)          //!< Bit field size in bits for I2C_FLT_FLT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_FLT_FLT field.
#define BR_I2C_FLT_FLT(x)    (HW_I2C_FLT(x).B.FLT)
#endif

//! @brief Format value for bitfield I2C_FLT_FLT.
#define BF_I2C_FLT_FLT(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_FLT_FLT), uint8_t) & BM_I2C_FLT_FLT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FLT field to a new value.
#define BW_I2C_FLT_FLT(x, v) (HW_I2C_FLT_WR(x, (HW_I2C_FLT_RD(x) & ~BM_I2C_FLT_FLT) | BF_I2C_FLT_FLT(v)))
#endif
//@}

/*!
 * @name Register I2C_FLT, field STARTF[4] (W1C)
 *
 * Hardware sets this bit when the I2C bus's start status is detected. The
 * STARTF bit must be cleared by writing 1 to it.
 *
 * Values:
 * - 0 - No start happens on I2C bus
 * - 1 - Start detected on I2C bus
 */
//@{
#define BP_I2C_FLT_STARTF    (4U)          //!< Bit position for I2C_FLT_STARTF.
#define BM_I2C_FLT_STARTF    (0x10U)       //!< Bit mask for I2C_FLT_STARTF.
#define BS_I2C_FLT_STARTF    (1U)          //!< Bit field size in bits for I2C_FLT_STARTF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_FLT_STARTF field.
#define BR_I2C_FLT_STARTF(x) (BITBAND_ACCESS8(HW_I2C_FLT_ADDR(x), BP_I2C_FLT_STARTF))
#endif

//! @brief Format value for bitfield I2C_FLT_STARTF.
#define BF_I2C_FLT_STARTF(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_FLT_STARTF), uint8_t) & BM_I2C_FLT_STARTF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the STARTF field to a new value.
#define BW_I2C_FLT_STARTF(x, v) (BITBAND_ACCESS8(HW_I2C_FLT_ADDR(x), BP_I2C_FLT_STARTF) = (v))
#endif
//@}

/*!
 * @name Register I2C_FLT, field SSIE[5] (RW)
 *
 * This bit enables the interrupt for I2C bus stop or start detection. To clear
 * the I2C bus stop or start detection interrupt: In the interrupt service
 * routine, first clear the STOPF or STARTF bit by writing 1 to it, and then clear the
 * IICIF bit in the status register. If this sequence is reversed, the IICIF bit
 * is asserted again.
 *
 * Values:
 * - 0 - Stop or start detection interrupt is disabled
 * - 1 - Stop or start detection interrupt is enabled
 */
//@{
#define BP_I2C_FLT_SSIE      (5U)          //!< Bit position for I2C_FLT_SSIE.
#define BM_I2C_FLT_SSIE      (0x20U)       //!< Bit mask for I2C_FLT_SSIE.
#define BS_I2C_FLT_SSIE      (1U)          //!< Bit field size in bits for I2C_FLT_SSIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_FLT_SSIE field.
#define BR_I2C_FLT_SSIE(x)   (BITBAND_ACCESS8(HW_I2C_FLT_ADDR(x), BP_I2C_FLT_SSIE))
#endif

//! @brief Format value for bitfield I2C_FLT_SSIE.
#define BF_I2C_FLT_SSIE(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_FLT_SSIE), uint8_t) & BM_I2C_FLT_SSIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SSIE field to a new value.
#define BW_I2C_FLT_SSIE(x, v) (BITBAND_ACCESS8(HW_I2C_FLT_ADDR(x), BP_I2C_FLT_SSIE) = (v))
#endif
//@}

/*!
 * @name Register I2C_FLT, field STOPF[6] (W1C)
 *
 * Hardware sets this bit when the I2C bus's stop status is detected. The STOPF
 * bit must be cleared by writing 1 to it.
 *
 * Values:
 * - 0 - No stop happens on I2C bus
 * - 1 - Stop detected on I2C bus
 */
//@{
#define BP_I2C_FLT_STOPF     (6U)          //!< Bit position for I2C_FLT_STOPF.
#define BM_I2C_FLT_STOPF     (0x40U)       //!< Bit mask for I2C_FLT_STOPF.
#define BS_I2C_FLT_STOPF     (1U)          //!< Bit field size in bits for I2C_FLT_STOPF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_FLT_STOPF field.
#define BR_I2C_FLT_STOPF(x)  (BITBAND_ACCESS8(HW_I2C_FLT_ADDR(x), BP_I2C_FLT_STOPF))
#endif

//! @brief Format value for bitfield I2C_FLT_STOPF.
#define BF_I2C_FLT_STOPF(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_FLT_STOPF), uint8_t) & BM_I2C_FLT_STOPF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the STOPF field to a new value.
#define BW_I2C_FLT_STOPF(x, v) (BITBAND_ACCESS8(HW_I2C_FLT_ADDR(x), BP_I2C_FLT_STOPF) = (v))
#endif
//@}

/*!
 * @name Register I2C_FLT, field SHEN[7] (RW)
 *
 * Set this bit to hold off entry to stop mode when any data transmission or
 * reception is occurring. The following scenario explains the holdoff
 * functionality: The I2C module is configured for a basic transfer, and the SHEN bit is set
 * to 1. A transfer begins. The MCU signals the I2C module to enter stop mode. The
 * byte currently being transferred, including both address and data, completes
 * its transfer. The I2C slave or master acknowledges that the in-transfer byte
 * completed its transfer and acknowledges the request to enter stop mode. After
 * receiving the I2C module's acknowledgment of the request to enter stop mode,
 * the MCU determines whether to shut off the I2C module's clock. If the SHEN bit
 * is set to 1 and the I2C module is in an idle or disabled state when the MCU
 * signals to enter stop mode, the module immediately acknowledges the request to
 * enter stop mode. If SHEN is cleared to 0 and the overall data transmission or
 * reception that was suspended by stop mode entry was incomplete: To resume the
 * overall transmission or reception after the MCU exits stop mode, software must
 * reinitialize the transfer by resending the address of the slave. If the I2C
 * Control Register 1's IICIE bit was set to 1 before the MCU entered stop mode,
 * system software will receive the interrupt triggered by the I2C Status Register's
 * TCF bit after the MCU wakes from the stop mode.
 *
 * Values:
 * - 0 - Stop holdoff is disabled. The MCU's entry to stop mode is not gated.
 * - 1 - Stop holdoff is enabled.
 */
//@{
#define BP_I2C_FLT_SHEN      (7U)          //!< Bit position for I2C_FLT_SHEN.
#define BM_I2C_FLT_SHEN      (0x80U)       //!< Bit mask for I2C_FLT_SHEN.
#define BS_I2C_FLT_SHEN      (1U)          //!< Bit field size in bits for I2C_FLT_SHEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_FLT_SHEN field.
#define BR_I2C_FLT_SHEN(x)   (BITBAND_ACCESS8(HW_I2C_FLT_ADDR(x), BP_I2C_FLT_SHEN))
#endif

//! @brief Format value for bitfield I2C_FLT_SHEN.
#define BF_I2C_FLT_SHEN(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_FLT_SHEN), uint8_t) & BM_I2C_FLT_SHEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SHEN field to a new value.
#define BW_I2C_FLT_SHEN(x, v) (BITBAND_ACCESS8(HW_I2C_FLT_ADDR(x), BP_I2C_FLT_SHEN) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2C_RA - I2C Range Address register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2C_RA - I2C Range Address register (RW)
 *
 * Reset value: 0x00U
 */
typedef union _hw_i2c_ra
{
    uint8_t U;
    struct _hw_i2c_ra_bitfields
    {
        uint8_t RESERVED0 : 1;         //!< [0]
        uint8_t RAD : 7;               //!< [7:1] Range Slave Address
    } B;
} hw_i2c_ra_t;
#endif

/*!
 * @name Constants and macros for entire I2C_RA register
 */
//@{
#define HW_I2C_RA_ADDR(x)        (REGS_I2C_BASE(x) + 0x7U)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_RA(x)             (*(__IO hw_i2c_ra_t *) HW_I2C_RA_ADDR(x))
#define HW_I2C_RA_RD(x)          (HW_I2C_RA(x).U)
#define HW_I2C_RA_WR(x, v)       (HW_I2C_RA(x).U = (v))
#define HW_I2C_RA_SET(x, v)      (HW_I2C_RA_WR(x, HW_I2C_RA_RD(x) |  (v)))
#define HW_I2C_RA_CLR(x, v)      (HW_I2C_RA_WR(x, HW_I2C_RA_RD(x) & ~(v)))
#define HW_I2C_RA_TOG(x, v)      (HW_I2C_RA_WR(x, HW_I2C_RA_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2C_RA bitfields
 */

/*!
 * @name Register I2C_RA, field RAD[7:1] (RW)
 *
 * This field contains the slave address to be used by the I2C module. The field
 * is used in the 7-bit address scheme. If I2C_C2[RMEN] is set to 1, any nonzero
 * value write enables this register. This register value can be considered as a
 * maximum boundary in the range matching mode.
 */
//@{
#define BP_I2C_RA_RAD        (1U)          //!< Bit position for I2C_RA_RAD.
#define BM_I2C_RA_RAD        (0xFEU)       //!< Bit mask for I2C_RA_RAD.
#define BS_I2C_RA_RAD        (7U)          //!< Bit field size in bits for I2C_RA_RAD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_RA_RAD field.
#define BR_I2C_RA_RAD(x)     (HW_I2C_RA(x).B.RAD)
#endif

//! @brief Format value for bitfield I2C_RA_RAD.
#define BF_I2C_RA_RAD(v)     (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_RA_RAD), uint8_t) & BM_I2C_RA_RAD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RAD field to a new value.
#define BW_I2C_RA_RAD(x, v)  (HW_I2C_RA_WR(x, (HW_I2C_RA_RD(x) & ~BM_I2C_RA_RAD) | BF_I2C_RA_RAD(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2C_SMB - I2C SMBus Control and Status register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2C_SMB - I2C SMBus Control and Status register (RW)
 *
 * Reset value: 0x00U
 *
 * When the SCL and SDA signals are held high for a length of time greater than
 * the high timeout period, the SHTF1 flag sets. Before reaching this threshold,
 * while the system is detecting how long these signals are being held high, a
 * master assumes that the bus is free. However, the SHTF1 bit is set to 1 in the
 * bus transmission process with the idle bus state. When the TCKSEL bit is set,
 * there is no need to monitor the SHTF1 bit because the bus speed is too high to
 * match the protocol of SMBus.
 */
typedef union _hw_i2c_smb
{
    uint8_t U;
    struct _hw_i2c_smb_bitfields
    {
        uint8_t SHTF2IE : 1;           //!< [0] SHTF2 Interrupt Enable
        uint8_t SHTF2 : 1;             //!< [1] SCL High Timeout Flag 2
        uint8_t SHTF1 : 1;             //!< [2] SCL High Timeout Flag 1
        uint8_t SLTF : 1;              //!< [3] SCL Low Timeout Flag
        uint8_t TCKSEL : 1;            //!< [4] Timeout Counter Clock Select
        uint8_t SIICAEN : 1;           //!< [5] Second I2C Address Enable
        uint8_t ALERTEN : 1;           //!< [6] SMBus Alert Response Address Enable
        uint8_t FACK : 1;              //!< [7] Fast NACK/ACK Enable
    } B;
} hw_i2c_smb_t;
#endif

/*!
 * @name Constants and macros for entire I2C_SMB register
 */
//@{
#define HW_I2C_SMB_ADDR(x)       (REGS_I2C_BASE(x) + 0x8U)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_SMB(x)            (*(__IO hw_i2c_smb_t *) HW_I2C_SMB_ADDR(x))
#define HW_I2C_SMB_RD(x)         (HW_I2C_SMB(x).U)
#define HW_I2C_SMB_WR(x, v)      (HW_I2C_SMB(x).U = (v))
#define HW_I2C_SMB_SET(x, v)     (HW_I2C_SMB_WR(x, HW_I2C_SMB_RD(x) |  (v)))
#define HW_I2C_SMB_CLR(x, v)     (HW_I2C_SMB_WR(x, HW_I2C_SMB_RD(x) & ~(v)))
#define HW_I2C_SMB_TOG(x, v)     (HW_I2C_SMB_WR(x, HW_I2C_SMB_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2C_SMB bitfields
 */

/*!
 * @name Register I2C_SMB, field SHTF2IE[0] (RW)
 *
 * Enables SCL high and SDA low timeout interrupt.
 *
 * Values:
 * - 0 - SHTF2 interrupt is disabled
 * - 1 - SHTF2 interrupt is enabled
 */
//@{
#define BP_I2C_SMB_SHTF2IE   (0U)          //!< Bit position for I2C_SMB_SHTF2IE.
#define BM_I2C_SMB_SHTF2IE   (0x01U)       //!< Bit mask for I2C_SMB_SHTF2IE.
#define BS_I2C_SMB_SHTF2IE   (1U)          //!< Bit field size in bits for I2C_SMB_SHTF2IE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_SMB_SHTF2IE field.
#define BR_I2C_SMB_SHTF2IE(x) (BITBAND_ACCESS8(HW_I2C_SMB_ADDR(x), BP_I2C_SMB_SHTF2IE))
#endif

//! @brief Format value for bitfield I2C_SMB_SHTF2IE.
#define BF_I2C_SMB_SHTF2IE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_SMB_SHTF2IE), uint8_t) & BM_I2C_SMB_SHTF2IE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SHTF2IE field to a new value.
#define BW_I2C_SMB_SHTF2IE(x, v) (BITBAND_ACCESS8(HW_I2C_SMB_ADDR(x), BP_I2C_SMB_SHTF2IE) = (v))
#endif
//@}

/*!
 * @name Register I2C_SMB, field SHTF2[1] (W1C)
 *
 * This bit sets when SCL is held high and SDA is held low more than clock *
 * LoValue / 512. Software clears this bit by writing 1 to it.
 *
 * Values:
 * - 0 - No SCL high and SDA low timeout occurs
 * - 1 - SCL high and SDA low timeout occurs
 */
//@{
#define BP_I2C_SMB_SHTF2     (1U)          //!< Bit position for I2C_SMB_SHTF2.
#define BM_I2C_SMB_SHTF2     (0x02U)       //!< Bit mask for I2C_SMB_SHTF2.
#define BS_I2C_SMB_SHTF2     (1U)          //!< Bit field size in bits for I2C_SMB_SHTF2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_SMB_SHTF2 field.
#define BR_I2C_SMB_SHTF2(x)  (BITBAND_ACCESS8(HW_I2C_SMB_ADDR(x), BP_I2C_SMB_SHTF2))
#endif

//! @brief Format value for bitfield I2C_SMB_SHTF2.
#define BF_I2C_SMB_SHTF2(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_SMB_SHTF2), uint8_t) & BM_I2C_SMB_SHTF2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SHTF2 field to a new value.
#define BW_I2C_SMB_SHTF2(x, v) (BITBAND_ACCESS8(HW_I2C_SMB_ADDR(x), BP_I2C_SMB_SHTF2) = (v))
#endif
//@}

/*!
 * @name Register I2C_SMB, field SHTF1[2] (RO)
 *
 * This read-only bit sets when SCL and SDA are held high more than clock *
 * LoValue / 512, which indicates the bus is free. This bit is cleared automatically.
 *
 * Values:
 * - 0 - No SCL high and SDA high timeout occurs
 * - 1 - SCL high and SDA high timeout occurs
 */
//@{
#define BP_I2C_SMB_SHTF1     (2U)          //!< Bit position for I2C_SMB_SHTF1.
#define BM_I2C_SMB_SHTF1     (0x04U)       //!< Bit mask for I2C_SMB_SHTF1.
#define BS_I2C_SMB_SHTF1     (1U)          //!< Bit field size in bits for I2C_SMB_SHTF1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_SMB_SHTF1 field.
#define BR_I2C_SMB_SHTF1(x)  (BITBAND_ACCESS8(HW_I2C_SMB_ADDR(x), BP_I2C_SMB_SHTF1))
#endif
//@}

/*!
 * @name Register I2C_SMB, field SLTF[3] (W1C)
 *
 * This bit is set when the SLT register (consisting of the SLTH and SLTL
 * registers) is loaded with a non-zero value (LoValue) and an SCL low timeout occurs.
 * Software clears this bit by writing a logic 1 to it. The low timeout function
 * is disabled when the SLT register's value is 0.
 *
 * Values:
 * - 0 - No low timeout occurs
 * - 1 - Low timeout occurs
 */
//@{
#define BP_I2C_SMB_SLTF      (3U)          //!< Bit position for I2C_SMB_SLTF.
#define BM_I2C_SMB_SLTF      (0x08U)       //!< Bit mask for I2C_SMB_SLTF.
#define BS_I2C_SMB_SLTF      (1U)          //!< Bit field size in bits for I2C_SMB_SLTF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_SMB_SLTF field.
#define BR_I2C_SMB_SLTF(x)   (BITBAND_ACCESS8(HW_I2C_SMB_ADDR(x), BP_I2C_SMB_SLTF))
#endif

//! @brief Format value for bitfield I2C_SMB_SLTF.
#define BF_I2C_SMB_SLTF(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_SMB_SLTF), uint8_t) & BM_I2C_SMB_SLTF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SLTF field to a new value.
#define BW_I2C_SMB_SLTF(x, v) (BITBAND_ACCESS8(HW_I2C_SMB_ADDR(x), BP_I2C_SMB_SLTF) = (v))
#endif
//@}

/*!
 * @name Register I2C_SMB, field TCKSEL[4] (RW)
 *
 * Selects the clock source of the timeout counter.
 *
 * Values:
 * - 0 - Timeout counter counts at the frequency of the I2C module clock / 64
 * - 1 - Timeout counter counts at the frequency of the I2C module clock
 */
//@{
#define BP_I2C_SMB_TCKSEL    (4U)          //!< Bit position for I2C_SMB_TCKSEL.
#define BM_I2C_SMB_TCKSEL    (0x10U)       //!< Bit mask for I2C_SMB_TCKSEL.
#define BS_I2C_SMB_TCKSEL    (1U)          //!< Bit field size in bits for I2C_SMB_TCKSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_SMB_TCKSEL field.
#define BR_I2C_SMB_TCKSEL(x) (BITBAND_ACCESS8(HW_I2C_SMB_ADDR(x), BP_I2C_SMB_TCKSEL))
#endif

//! @brief Format value for bitfield I2C_SMB_TCKSEL.
#define BF_I2C_SMB_TCKSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_SMB_TCKSEL), uint8_t) & BM_I2C_SMB_TCKSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TCKSEL field to a new value.
#define BW_I2C_SMB_TCKSEL(x, v) (BITBAND_ACCESS8(HW_I2C_SMB_ADDR(x), BP_I2C_SMB_TCKSEL) = (v))
#endif
//@}

/*!
 * @name Register I2C_SMB, field SIICAEN[5] (RW)
 *
 * Enables or disables SMBus device default address.
 *
 * Values:
 * - 0 - I2C address register 2 matching is disabled
 * - 1 - I2C address register 2 matching is enabled
 */
//@{
#define BP_I2C_SMB_SIICAEN   (5U)          //!< Bit position for I2C_SMB_SIICAEN.
#define BM_I2C_SMB_SIICAEN   (0x20U)       //!< Bit mask for I2C_SMB_SIICAEN.
#define BS_I2C_SMB_SIICAEN   (1U)          //!< Bit field size in bits for I2C_SMB_SIICAEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_SMB_SIICAEN field.
#define BR_I2C_SMB_SIICAEN(x) (BITBAND_ACCESS8(HW_I2C_SMB_ADDR(x), BP_I2C_SMB_SIICAEN))
#endif

//! @brief Format value for bitfield I2C_SMB_SIICAEN.
#define BF_I2C_SMB_SIICAEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_SMB_SIICAEN), uint8_t) & BM_I2C_SMB_SIICAEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SIICAEN field to a new value.
#define BW_I2C_SMB_SIICAEN(x, v) (BITBAND_ACCESS8(HW_I2C_SMB_ADDR(x), BP_I2C_SMB_SIICAEN) = (v))
#endif
//@}

/*!
 * @name Register I2C_SMB, field ALERTEN[6] (RW)
 *
 * Enables or disables SMBus alert response address matching. After the host
 * responds to a device that used the alert response address, you must use software
 * to put the device's address on the bus. The alert protocol is described in the
 * SMBus specification.
 *
 * Values:
 * - 0 - SMBus alert response address matching is disabled
 * - 1 - SMBus alert response address matching is enabled
 */
//@{
#define BP_I2C_SMB_ALERTEN   (6U)          //!< Bit position for I2C_SMB_ALERTEN.
#define BM_I2C_SMB_ALERTEN   (0x40U)       //!< Bit mask for I2C_SMB_ALERTEN.
#define BS_I2C_SMB_ALERTEN   (1U)          //!< Bit field size in bits for I2C_SMB_ALERTEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_SMB_ALERTEN field.
#define BR_I2C_SMB_ALERTEN(x) (BITBAND_ACCESS8(HW_I2C_SMB_ADDR(x), BP_I2C_SMB_ALERTEN))
#endif

//! @brief Format value for bitfield I2C_SMB_ALERTEN.
#define BF_I2C_SMB_ALERTEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_SMB_ALERTEN), uint8_t) & BM_I2C_SMB_ALERTEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ALERTEN field to a new value.
#define BW_I2C_SMB_ALERTEN(x, v) (BITBAND_ACCESS8(HW_I2C_SMB_ADDR(x), BP_I2C_SMB_ALERTEN) = (v))
#endif
//@}

/*!
 * @name Register I2C_SMB, field FACK[7] (RW)
 *
 * For SMBus packet error checking, the CPU must be able to issue an ACK or NACK
 * according to the result of receiving data byte.
 *
 * Values:
 * - 0 - An ACK or NACK is sent on the following receiving data byte
 * - 1 - Writing 0 to TXAK after receiving a data byte generates an ACK. Writing
 *     1 to TXAK after receiving a data byte generates a NACK.
 */
//@{
#define BP_I2C_SMB_FACK      (7U)          //!< Bit position for I2C_SMB_FACK.
#define BM_I2C_SMB_FACK      (0x80U)       //!< Bit mask for I2C_SMB_FACK.
#define BS_I2C_SMB_FACK      (1U)          //!< Bit field size in bits for I2C_SMB_FACK.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_SMB_FACK field.
#define BR_I2C_SMB_FACK(x)   (BITBAND_ACCESS8(HW_I2C_SMB_ADDR(x), BP_I2C_SMB_FACK))
#endif

//! @brief Format value for bitfield I2C_SMB_FACK.
#define BF_I2C_SMB_FACK(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_SMB_FACK), uint8_t) & BM_I2C_SMB_FACK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FACK field to a new value.
#define BW_I2C_SMB_FACK(x, v) (BITBAND_ACCESS8(HW_I2C_SMB_ADDR(x), BP_I2C_SMB_FACK) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2C_A2 - I2C Address Register 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2C_A2 - I2C Address Register 2 (RW)
 *
 * Reset value: 0xC2U
 */
typedef union _hw_i2c_a2
{
    uint8_t U;
    struct _hw_i2c_a2_bitfields
    {
        uint8_t RESERVED0 : 1;         //!< [0]
        uint8_t SAD : 7;               //!< [7:1] SMBus Address
    } B;
} hw_i2c_a2_t;
#endif

/*!
 * @name Constants and macros for entire I2C_A2 register
 */
//@{
#define HW_I2C_A2_ADDR(x)        (REGS_I2C_BASE(x) + 0x9U)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_A2(x)             (*(__IO hw_i2c_a2_t *) HW_I2C_A2_ADDR(x))
#define HW_I2C_A2_RD(x)          (HW_I2C_A2(x).U)
#define HW_I2C_A2_WR(x, v)       (HW_I2C_A2(x).U = (v))
#define HW_I2C_A2_SET(x, v)      (HW_I2C_A2_WR(x, HW_I2C_A2_RD(x) |  (v)))
#define HW_I2C_A2_CLR(x, v)      (HW_I2C_A2_WR(x, HW_I2C_A2_RD(x) & ~(v)))
#define HW_I2C_A2_TOG(x, v)      (HW_I2C_A2_WR(x, HW_I2C_A2_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2C_A2 bitfields
 */

/*!
 * @name Register I2C_A2, field SAD[7:1] (RW)
 *
 * Contains the slave address used by the SMBus. This field is used on the
 * device default address or other related addresses.
 */
//@{
#define BP_I2C_A2_SAD        (1U)          //!< Bit position for I2C_A2_SAD.
#define BM_I2C_A2_SAD        (0xFEU)       //!< Bit mask for I2C_A2_SAD.
#define BS_I2C_A2_SAD        (7U)          //!< Bit field size in bits for I2C_A2_SAD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_A2_SAD field.
#define BR_I2C_A2_SAD(x)     (HW_I2C_A2(x).B.SAD)
#endif

//! @brief Format value for bitfield I2C_A2_SAD.
#define BF_I2C_A2_SAD(v)     (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_A2_SAD), uint8_t) & BM_I2C_A2_SAD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SAD field to a new value.
#define BW_I2C_A2_SAD(x, v)  (HW_I2C_A2_WR(x, (HW_I2C_A2_RD(x) & ~BM_I2C_A2_SAD) | BF_I2C_A2_SAD(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2C_SLTH - I2C SCL Low Timeout Register High
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2C_SLTH - I2C SCL Low Timeout Register High (RW)
 *
 * Reset value: 0x00U
 */
typedef union _hw_i2c_slth
{
    uint8_t U;
    struct _hw_i2c_slth_bitfields
    {
        uint8_t SSLT : 8;              //!< [7:0]
    } B;
} hw_i2c_slth_t;
#endif

/*!
 * @name Constants and macros for entire I2C_SLTH register
 */
//@{
#define HW_I2C_SLTH_ADDR(x)      (REGS_I2C_BASE(x) + 0xAU)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_SLTH(x)           (*(__IO hw_i2c_slth_t *) HW_I2C_SLTH_ADDR(x))
#define HW_I2C_SLTH_RD(x)        (HW_I2C_SLTH(x).U)
#define HW_I2C_SLTH_WR(x, v)     (HW_I2C_SLTH(x).U = (v))
#define HW_I2C_SLTH_SET(x, v)    (HW_I2C_SLTH_WR(x, HW_I2C_SLTH_RD(x) |  (v)))
#define HW_I2C_SLTH_CLR(x, v)    (HW_I2C_SLTH_WR(x, HW_I2C_SLTH_RD(x) & ~(v)))
#define HW_I2C_SLTH_TOG(x, v)    (HW_I2C_SLTH_WR(x, HW_I2C_SLTH_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2C_SLTH bitfields
 */

/*!
 * @name Register I2C_SLTH, field SSLT[7:0] (RW)
 *
 * Most significant byte of SCL low timeout value that determines the timeout
 * period of SCL low.
 */
//@{
#define BP_I2C_SLTH_SSLT     (0U)          //!< Bit position for I2C_SLTH_SSLT.
#define BM_I2C_SLTH_SSLT     (0xFFU)       //!< Bit mask for I2C_SLTH_SSLT.
#define BS_I2C_SLTH_SSLT     (8U)          //!< Bit field size in bits for I2C_SLTH_SSLT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_SLTH_SSLT field.
#define BR_I2C_SLTH_SSLT(x)  (HW_I2C_SLTH(x).U)
#endif

//! @brief Format value for bitfield I2C_SLTH_SSLT.
#define BF_I2C_SLTH_SSLT(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_SLTH_SSLT), uint8_t) & BM_I2C_SLTH_SSLT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SSLT field to a new value.
#define BW_I2C_SLTH_SSLT(x, v) (HW_I2C_SLTH_WR(x, v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2C_SLTL - I2C SCL Low Timeout Register Low
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2C_SLTL - I2C SCL Low Timeout Register Low (RW)
 *
 * Reset value: 0x00U
 */
typedef union _hw_i2c_sltl
{
    uint8_t U;
    struct _hw_i2c_sltl_bitfields
    {
        uint8_t SSLT : 8;              //!< [7:0]
    } B;
} hw_i2c_sltl_t;
#endif

/*!
 * @name Constants and macros for entire I2C_SLTL register
 */
//@{
#define HW_I2C_SLTL_ADDR(x)      (REGS_I2C_BASE(x) + 0xBU)

#ifndef __LANGUAGE_ASM__
#define HW_I2C_SLTL(x)           (*(__IO hw_i2c_sltl_t *) HW_I2C_SLTL_ADDR(x))
#define HW_I2C_SLTL_RD(x)        (HW_I2C_SLTL(x).U)
#define HW_I2C_SLTL_WR(x, v)     (HW_I2C_SLTL(x).U = (v))
#define HW_I2C_SLTL_SET(x, v)    (HW_I2C_SLTL_WR(x, HW_I2C_SLTL_RD(x) |  (v)))
#define HW_I2C_SLTL_CLR(x, v)    (HW_I2C_SLTL_WR(x, HW_I2C_SLTL_RD(x) & ~(v)))
#define HW_I2C_SLTL_TOG(x, v)    (HW_I2C_SLTL_WR(x, HW_I2C_SLTL_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2C_SLTL bitfields
 */

/*!
 * @name Register I2C_SLTL, field SSLT[7:0] (RW)
 *
 * Least significant byte of SCL low timeout value that determines the timeout
 * period of SCL low.
 */
//@{
#define BP_I2C_SLTL_SSLT     (0U)          //!< Bit position for I2C_SLTL_SSLT.
#define BM_I2C_SLTL_SSLT     (0xFFU)       //!< Bit mask for I2C_SLTL_SSLT.
#define BS_I2C_SLTL_SSLT     (8U)          //!< Bit field size in bits for I2C_SLTL_SSLT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2C_SLTL_SSLT field.
#define BR_I2C_SLTL_SSLT(x)  (HW_I2C_SLTL(x).U)
#endif

//! @brief Format value for bitfield I2C_SLTL_SSLT.
#define BF_I2C_SLTL_SSLT(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint8_t) << BP_I2C_SLTL_SSLT), uint8_t) & BM_I2C_SLTL_SSLT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SSLT field to a new value.
#define BW_I2C_SLTL_SSLT(x, v) (HW_I2C_SLTL_WR(x, v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_i2c_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All I2C module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_i2c
{
    __IO hw_i2c_a1_t A1;                   //!< [0x0] I2C Address Register 1
    __IO hw_i2c_f_t F;                     //!< [0x1] I2C Frequency Divider register
    __IO hw_i2c_c1_t C1;                   //!< [0x2] I2C Control Register 1
    __IO hw_i2c_s_t S;                     //!< [0x3] I2C Status register
    __IO hw_i2c_d_t D;                     //!< [0x4] I2C Data I/O register
    __IO hw_i2c_c2_t C2;                   //!< [0x5] I2C Control Register 2
    __IO hw_i2c_flt_t FLT;                 //!< [0x6] I2C Programmable Input Glitch Filter register
    __IO hw_i2c_ra_t RA;                   //!< [0x7] I2C Range Address register
    __IO hw_i2c_smb_t SMB;                 //!< [0x8] I2C SMBus Control and Status register
    __IO hw_i2c_a2_t A2;                   //!< [0x9] I2C Address Register 2
    __IO hw_i2c_slth_t SLTH;               //!< [0xA] I2C SCL Low Timeout Register High
    __IO hw_i2c_sltl_t SLTL;               //!< [0xB] I2C SCL Low Timeout Register Low
} hw_i2c_t;
#pragma pack()

//! @brief Macro to access all I2C registers.
//! @param x I2C instance number.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_I2C(0)</code>.
#define HW_I2C(x)      (*(hw_i2c_t *) REGS_I2C_BASE(x))
#endif

#endif // __HW_I2C_REGISTERS_H__
// v22/130726/0.9
// EOF

