/*
 * Copyright (c) 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_FMC_REGISTERS_H__
#define __HW_FMC_REGISTERS_H__

#include "regs.h"

/*
 * MK64F12 FMC
 *
 * Flash Memory Controller
 *
 * Registers defined in this header file:
 * - HW_FMC_PFAPR - Flash Access Protection Register
 * - HW_FMC_PFB0CR - Flash Bank 0 Control Register
 * - HW_FMC_PFB1CR - Flash Bank 1 Control Register
 * - HW_FMC_TAGVDW0Sn - Cache Tag Storage
 * - HW_FMC_TAGVDW1Sn - Cache Tag Storage
 * - HW_FMC_TAGVDW2Sn - Cache Tag Storage
 * - HW_FMC_TAGVDW3Sn - Cache Tag Storage
 * - HW_FMC_DATAW0SnU - Cache Data Storage (upper word)
 * - HW_FMC_DATAW0SnL - Cache Data Storage (lower word)
 * - HW_FMC_DATAW1SnU - Cache Data Storage (upper word)
 * - HW_FMC_DATAW1SnL - Cache Data Storage (lower word)
 * - HW_FMC_DATAW2SnU - Cache Data Storage (upper word)
 * - HW_FMC_DATAW2SnL - Cache Data Storage (lower word)
 * - HW_FMC_DATAW3SnU - Cache Data Storage (upper word)
 * - HW_FMC_DATAW3SnL - Cache Data Storage (lower word)
 *
 * - hw_fmc_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_FMC_BASE
#define HW_FMC_INSTANCE_COUNT (1U) //!< Number of instances of the FMC module.
#define REGS_FMC_BASE (0x4001F000U) //!< Base address for FMC.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FMC_PFAPR - Flash Access Protection Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FMC_PFAPR - Flash Access Protection Register (RW)
 *
 * Reset value: 0x00F8003FU
 */
typedef union _hw_fmc_pfapr
{
    uint32_t U;
    struct _hw_fmc_pfapr_bitfields
    {
        uint32_t M0AP : 2;             //!< [1:0] Master 0 Access Protection
        uint32_t M1AP : 2;             //!< [3:2] Master 1 Access Protection
        uint32_t M2AP : 2;             //!< [5:4] Master 2 Access Protection
        uint32_t M3AP : 2;             //!< [7:6] Master 3 Access Protection
        uint32_t M4AP : 2;             //!< [9:8] Master 4 Access Protection
        uint32_t M5AP : 2;             //!< [11:10] Master 5 Access Protection
        uint32_t M6AP : 2;             //!< [13:12] Master 6 Access Protection
        uint32_t M7AP : 2;             //!< [15:14] Master 7 Access Protection
        uint32_t M0PFD : 1;            //!< [16] Master 0 Prefetch Disable
        uint32_t M1PFD : 1;            //!< [17] Master 1 Prefetch Disable
        uint32_t M2PFD : 1;            //!< [18] Master 2 Prefetch Disable
        uint32_t M3PFD : 1;            //!< [19] Master 3 Prefetch Disable
        uint32_t M4PFD : 1;            //!< [20] Master 4 Prefetch Disable
        uint32_t M5PFD : 1;            //!< [21] Master 5 Prefetch Disable
        uint32_t M6PFD : 1;            //!< [22] Master 6 Prefetch Disable
        uint32_t M7PFD : 1;            //!< [23] Master 7 Prefetch Disable
        uint32_t RESERVED0 : 8;        //!< [31:24]
    } B;
} hw_fmc_pfapr_t;
#endif

/*!
 * @name Constants and macros for entire FMC_PFAPR register
 */
//@{
#define HW_FMC_PFAPR_ADDR        (REGS_FMC_BASE + 0x0U)

#ifndef __LANGUAGE_ASM__
#define HW_FMC_PFAPR             (*(__IO hw_fmc_pfapr_t *) HW_FMC_PFAPR_ADDR)
#define HW_FMC_PFAPR_RD()        (HW_FMC_PFAPR.U)
#define HW_FMC_PFAPR_WR(v)       (HW_FMC_PFAPR.U = (v))
#define HW_FMC_PFAPR_SET(v)      (HW_FMC_PFAPR_WR(HW_FMC_PFAPR_RD() |  (v)))
#define HW_FMC_PFAPR_CLR(v)      (HW_FMC_PFAPR_WR(HW_FMC_PFAPR_RD() & ~(v)))
#define HW_FMC_PFAPR_TOG(v)      (HW_FMC_PFAPR_WR(HW_FMC_PFAPR_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FMC_PFAPR bitfields
 */

/*!
 * @name Register FMC_PFAPR, field M0AP[1:0] (RW)
 *
 * This field controls whether read and write access to the flash are allowed
 * based on the logical master number of the requesting crossbar switch master.
 *
 * Values:
 * - 00 - No access may be performed by this master
 * - 01 - Only read accesses may be performed by this master
 * - 10 - Only write accesses may be performed by this master
 * - 11 - Both read and write accesses may be performed by this master
 */
//@{
#define BP_FMC_PFAPR_M0AP    (0U)          //!< Bit position for FMC_PFAPR_M0AP.
#define BM_FMC_PFAPR_M0AP    (0x00000003U) //!< Bit mask for FMC_PFAPR_M0AP.
#define BS_FMC_PFAPR_M0AP    (2U)          //!< Bit field size in bits for FMC_PFAPR_M0AP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFAPR_M0AP field.
#define BR_FMC_PFAPR_M0AP    (HW_FMC_PFAPR.B.M0AP)
#endif

//! @brief Format value for bitfield FMC_PFAPR_M0AP.
#define BF_FMC_PFAPR_M0AP(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFAPR_M0AP), uint32_t) & BM_FMC_PFAPR_M0AP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M0AP field to a new value.
#define BW_FMC_PFAPR_M0AP(v) (HW_FMC_PFAPR_WR((HW_FMC_PFAPR_RD() & ~BM_FMC_PFAPR_M0AP) | BF_FMC_PFAPR_M0AP(v)))
#endif
//@}

/*!
 * @name Register FMC_PFAPR, field M1AP[3:2] (RW)
 *
 * This field controls whether read and write access to the flash are allowed
 * based on the logical master number of the requesting crossbar switch master.
 *
 * Values:
 * - 00 - No access may be performed by this master
 * - 01 - Only read accesses may be performed by this master
 * - 10 - Only write accesses may be performed by this master
 * - 11 - Both read and write accesses may be performed by this master
 */
//@{
#define BP_FMC_PFAPR_M1AP    (2U)          //!< Bit position for FMC_PFAPR_M1AP.
#define BM_FMC_PFAPR_M1AP    (0x0000000CU) //!< Bit mask for FMC_PFAPR_M1AP.
#define BS_FMC_PFAPR_M1AP    (2U)          //!< Bit field size in bits for FMC_PFAPR_M1AP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFAPR_M1AP field.
#define BR_FMC_PFAPR_M1AP    (HW_FMC_PFAPR.B.M1AP)
#endif

//! @brief Format value for bitfield FMC_PFAPR_M1AP.
#define BF_FMC_PFAPR_M1AP(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFAPR_M1AP), uint32_t) & BM_FMC_PFAPR_M1AP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M1AP field to a new value.
#define BW_FMC_PFAPR_M1AP(v) (HW_FMC_PFAPR_WR((HW_FMC_PFAPR_RD() & ~BM_FMC_PFAPR_M1AP) | BF_FMC_PFAPR_M1AP(v)))
#endif
//@}

/*!
 * @name Register FMC_PFAPR, field M2AP[5:4] (RW)
 *
 * This field controls whether read and write access to the flash are allowed
 * based on the logical master number of the requesting crossbar switch master.
 *
 * Values:
 * - 00 - No access may be performed by this master
 * - 01 - Only read accesses may be performed by this master
 * - 10 - Only write accesses may be performed by this master
 * - 11 - Both read and write accesses may be performed by this master
 */
//@{
#define BP_FMC_PFAPR_M2AP    (4U)          //!< Bit position for FMC_PFAPR_M2AP.
#define BM_FMC_PFAPR_M2AP    (0x00000030U) //!< Bit mask for FMC_PFAPR_M2AP.
#define BS_FMC_PFAPR_M2AP    (2U)          //!< Bit field size in bits for FMC_PFAPR_M2AP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFAPR_M2AP field.
#define BR_FMC_PFAPR_M2AP    (HW_FMC_PFAPR.B.M2AP)
#endif

//! @brief Format value for bitfield FMC_PFAPR_M2AP.
#define BF_FMC_PFAPR_M2AP(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFAPR_M2AP), uint32_t) & BM_FMC_PFAPR_M2AP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M2AP field to a new value.
#define BW_FMC_PFAPR_M2AP(v) (HW_FMC_PFAPR_WR((HW_FMC_PFAPR_RD() & ~BM_FMC_PFAPR_M2AP) | BF_FMC_PFAPR_M2AP(v)))
#endif
//@}

/*!
 * @name Register FMC_PFAPR, field M3AP[7:6] (RW)
 *
 * This field controls whether read and write access to the flash are allowed
 * based on the logical master number of the requesting crossbar switch master.
 *
 * Values:
 * - 00 - No access may be performed by this master
 * - 01 - Only read accesses may be performed by this master
 * - 10 - Only write accesses may be performed by this master
 * - 11 - Both read and write accesses may be performed by this master
 */
//@{
#define BP_FMC_PFAPR_M3AP    (6U)          //!< Bit position for FMC_PFAPR_M3AP.
#define BM_FMC_PFAPR_M3AP    (0x000000C0U) //!< Bit mask for FMC_PFAPR_M3AP.
#define BS_FMC_PFAPR_M3AP    (2U)          //!< Bit field size in bits for FMC_PFAPR_M3AP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFAPR_M3AP field.
#define BR_FMC_PFAPR_M3AP    (HW_FMC_PFAPR.B.M3AP)
#endif

//! @brief Format value for bitfield FMC_PFAPR_M3AP.
#define BF_FMC_PFAPR_M3AP(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFAPR_M3AP), uint32_t) & BM_FMC_PFAPR_M3AP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M3AP field to a new value.
#define BW_FMC_PFAPR_M3AP(v) (HW_FMC_PFAPR_WR((HW_FMC_PFAPR_RD() & ~BM_FMC_PFAPR_M3AP) | BF_FMC_PFAPR_M3AP(v)))
#endif
//@}

/*!
 * @name Register FMC_PFAPR, field M4AP[9:8] (RW)
 *
 * This field controls whether read and write access to the flash are allowed
 * based on the logical master number of the requesting crossbar switch master.
 *
 * Values:
 * - 00 - No access may be performed by this master
 * - 01 - Only read accesses may be performed by this master
 * - 10 - Only write accesses may be performed by this master
 * - 11 - Both read and write accesses may be performed by this master
 */
//@{
#define BP_FMC_PFAPR_M4AP    (8U)          //!< Bit position for FMC_PFAPR_M4AP.
#define BM_FMC_PFAPR_M4AP    (0x00000300U) //!< Bit mask for FMC_PFAPR_M4AP.
#define BS_FMC_PFAPR_M4AP    (2U)          //!< Bit field size in bits for FMC_PFAPR_M4AP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFAPR_M4AP field.
#define BR_FMC_PFAPR_M4AP    (HW_FMC_PFAPR.B.M4AP)
#endif

//! @brief Format value for bitfield FMC_PFAPR_M4AP.
#define BF_FMC_PFAPR_M4AP(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFAPR_M4AP), uint32_t) & BM_FMC_PFAPR_M4AP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M4AP field to a new value.
#define BW_FMC_PFAPR_M4AP(v) (HW_FMC_PFAPR_WR((HW_FMC_PFAPR_RD() & ~BM_FMC_PFAPR_M4AP) | BF_FMC_PFAPR_M4AP(v)))
#endif
//@}

/*!
 * @name Register FMC_PFAPR, field M5AP[11:10] (RW)
 *
 * This field controls whether read and write access to the flash are allowed
 * based on the logical master number of the requesting crossbar switch master.
 *
 * Values:
 * - 00 - No access may be performed by this master
 * - 01 - Only read accesses may be performed by this master
 * - 10 - Only write accesses may be performed by this master
 * - 11 - Both read and write accesses may be performed by this master
 */
//@{
#define BP_FMC_PFAPR_M5AP    (10U)         //!< Bit position for FMC_PFAPR_M5AP.
#define BM_FMC_PFAPR_M5AP    (0x00000C00U) //!< Bit mask for FMC_PFAPR_M5AP.
#define BS_FMC_PFAPR_M5AP    (2U)          //!< Bit field size in bits for FMC_PFAPR_M5AP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFAPR_M5AP field.
#define BR_FMC_PFAPR_M5AP    (HW_FMC_PFAPR.B.M5AP)
#endif

//! @brief Format value for bitfield FMC_PFAPR_M5AP.
#define BF_FMC_PFAPR_M5AP(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFAPR_M5AP), uint32_t) & BM_FMC_PFAPR_M5AP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M5AP field to a new value.
#define BW_FMC_PFAPR_M5AP(v) (HW_FMC_PFAPR_WR((HW_FMC_PFAPR_RD() & ~BM_FMC_PFAPR_M5AP) | BF_FMC_PFAPR_M5AP(v)))
#endif
//@}

/*!
 * @name Register FMC_PFAPR, field M6AP[13:12] (RW)
 *
 * This field controls whether read and write access to the flash are allowed
 * based on the logical master number of the requesting crossbar switch master.
 *
 * Values:
 * - 00 - No access may be performed by this master
 * - 01 - Only read accesses may be performed by this master
 * - 10 - Only write accesses may be performed by this master
 * - 11 - Both read and write accesses may be performed by this master
 */
//@{
#define BP_FMC_PFAPR_M6AP    (12U)         //!< Bit position for FMC_PFAPR_M6AP.
#define BM_FMC_PFAPR_M6AP    (0x00003000U) //!< Bit mask for FMC_PFAPR_M6AP.
#define BS_FMC_PFAPR_M6AP    (2U)          //!< Bit field size in bits for FMC_PFAPR_M6AP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFAPR_M6AP field.
#define BR_FMC_PFAPR_M6AP    (HW_FMC_PFAPR.B.M6AP)
#endif

//! @brief Format value for bitfield FMC_PFAPR_M6AP.
#define BF_FMC_PFAPR_M6AP(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFAPR_M6AP), uint32_t) & BM_FMC_PFAPR_M6AP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M6AP field to a new value.
#define BW_FMC_PFAPR_M6AP(v) (HW_FMC_PFAPR_WR((HW_FMC_PFAPR_RD() & ~BM_FMC_PFAPR_M6AP) | BF_FMC_PFAPR_M6AP(v)))
#endif
//@}

/*!
 * @name Register FMC_PFAPR, field M7AP[15:14] (RW)
 *
 * This field controls whether read and write access to the flash are allowed
 * based on the logical master number of the requesting crossbar switch master.
 *
 * Values:
 * - 00 - No access may be performed by this master.
 * - 01 - Only read accesses may be performed by this master.
 * - 10 - Only write accesses may be performed by this master.
 * - 11 - Both read and write accesses may be performed by this master.
 */
//@{
#define BP_FMC_PFAPR_M7AP    (14U)         //!< Bit position for FMC_PFAPR_M7AP.
#define BM_FMC_PFAPR_M7AP    (0x0000C000U) //!< Bit mask for FMC_PFAPR_M7AP.
#define BS_FMC_PFAPR_M7AP    (2U)          //!< Bit field size in bits for FMC_PFAPR_M7AP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFAPR_M7AP field.
#define BR_FMC_PFAPR_M7AP    (HW_FMC_PFAPR.B.M7AP)
#endif

//! @brief Format value for bitfield FMC_PFAPR_M7AP.
#define BF_FMC_PFAPR_M7AP(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFAPR_M7AP), uint32_t) & BM_FMC_PFAPR_M7AP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M7AP field to a new value.
#define BW_FMC_PFAPR_M7AP(v) (HW_FMC_PFAPR_WR((HW_FMC_PFAPR_RD() & ~BM_FMC_PFAPR_M7AP) | BF_FMC_PFAPR_M7AP(v)))
#endif
//@}

/*!
 * @name Register FMC_PFAPR, field M0PFD[16] (RW)
 *
 * These bits control whether prefetching is enabled based on the logical number
 * of the requesting crossbar switch master. This field is further qualified by
 * the PFBnCR[BxDPE,BxIPE] bits.
 *
 * Values:
 * - 0 - Prefetching for this master is enabled.
 * - 1 - Prefetching for this master is disabled.
 */
//@{
#define BP_FMC_PFAPR_M0PFD   (16U)         //!< Bit position for FMC_PFAPR_M0PFD.
#define BM_FMC_PFAPR_M0PFD   (0x00010000U) //!< Bit mask for FMC_PFAPR_M0PFD.
#define BS_FMC_PFAPR_M0PFD   (1U)          //!< Bit field size in bits for FMC_PFAPR_M0PFD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFAPR_M0PFD field.
#define BR_FMC_PFAPR_M0PFD   (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR, BP_FMC_PFAPR_M0PFD))
#endif

//! @brief Format value for bitfield FMC_PFAPR_M0PFD.
#define BF_FMC_PFAPR_M0PFD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFAPR_M0PFD), uint32_t) & BM_FMC_PFAPR_M0PFD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M0PFD field to a new value.
#define BW_FMC_PFAPR_M0PFD(v) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR, BP_FMC_PFAPR_M0PFD) = (v))
#endif
//@}

/*!
 * @name Register FMC_PFAPR, field M1PFD[17] (RW)
 *
 * These bits control whether prefetching is enabled based on the logical number
 * of the requesting crossbar switch master. This field is further qualified by
 * the PFBnCR[BxDPE,BxIPE] bits.
 *
 * Values:
 * - 0 - Prefetching for this master is enabled.
 * - 1 - Prefetching for this master is disabled.
 */
//@{
#define BP_FMC_PFAPR_M1PFD   (17U)         //!< Bit position for FMC_PFAPR_M1PFD.
#define BM_FMC_PFAPR_M1PFD   (0x00020000U) //!< Bit mask for FMC_PFAPR_M1PFD.
#define BS_FMC_PFAPR_M1PFD   (1U)          //!< Bit field size in bits for FMC_PFAPR_M1PFD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFAPR_M1PFD field.
#define BR_FMC_PFAPR_M1PFD   (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR, BP_FMC_PFAPR_M1PFD))
#endif

//! @brief Format value for bitfield FMC_PFAPR_M1PFD.
#define BF_FMC_PFAPR_M1PFD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFAPR_M1PFD), uint32_t) & BM_FMC_PFAPR_M1PFD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M1PFD field to a new value.
#define BW_FMC_PFAPR_M1PFD(v) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR, BP_FMC_PFAPR_M1PFD) = (v))
#endif
//@}

/*!
 * @name Register FMC_PFAPR, field M2PFD[18] (RW)
 *
 * These bits control whether prefetching is enabled based on the logical number
 * of the requesting crossbar switch master. This field is further qualified by
 * the PFBnCR[BxDPE,BxIPE] bits.
 *
 * Values:
 * - 0 - Prefetching for this master is enabled.
 * - 1 - Prefetching for this master is disabled.
 */
//@{
#define BP_FMC_PFAPR_M2PFD   (18U)         //!< Bit position for FMC_PFAPR_M2PFD.
#define BM_FMC_PFAPR_M2PFD   (0x00040000U) //!< Bit mask for FMC_PFAPR_M2PFD.
#define BS_FMC_PFAPR_M2PFD   (1U)          //!< Bit field size in bits for FMC_PFAPR_M2PFD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFAPR_M2PFD field.
#define BR_FMC_PFAPR_M2PFD   (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR, BP_FMC_PFAPR_M2PFD))
#endif

//! @brief Format value for bitfield FMC_PFAPR_M2PFD.
#define BF_FMC_PFAPR_M2PFD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFAPR_M2PFD), uint32_t) & BM_FMC_PFAPR_M2PFD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M2PFD field to a new value.
#define BW_FMC_PFAPR_M2PFD(v) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR, BP_FMC_PFAPR_M2PFD) = (v))
#endif
//@}

/*!
 * @name Register FMC_PFAPR, field M3PFD[19] (RW)
 *
 * These bits control whether prefetching is enabled based on the logical number
 * of the requesting crossbar switch master. This field is further qualified by
 * the PFBnCR[BxDPE,BxIPE] bits.
 *
 * Values:
 * - 0 - Prefetching for this master is enabled.
 * - 1 - Prefetching for this master is disabled.
 */
//@{
#define BP_FMC_PFAPR_M3PFD   (19U)         //!< Bit position for FMC_PFAPR_M3PFD.
#define BM_FMC_PFAPR_M3PFD   (0x00080000U) //!< Bit mask for FMC_PFAPR_M3PFD.
#define BS_FMC_PFAPR_M3PFD   (1U)          //!< Bit field size in bits for FMC_PFAPR_M3PFD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFAPR_M3PFD field.
#define BR_FMC_PFAPR_M3PFD   (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR, BP_FMC_PFAPR_M3PFD))
#endif

//! @brief Format value for bitfield FMC_PFAPR_M3PFD.
#define BF_FMC_PFAPR_M3PFD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFAPR_M3PFD), uint32_t) & BM_FMC_PFAPR_M3PFD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M3PFD field to a new value.
#define BW_FMC_PFAPR_M3PFD(v) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR, BP_FMC_PFAPR_M3PFD) = (v))
#endif
//@}

/*!
 * @name Register FMC_PFAPR, field M4PFD[20] (RW)
 *
 * These bits control whether prefetching is enabled based on the logical number
 * of the requesting crossbar switch master. This field is further qualified by
 * the PFBnCR[BxDPE,BxIPE] bits.
 *
 * Values:
 * - 0 - Prefetching for this master is enabled.
 * - 1 - Prefetching for this master is disabled.
 */
//@{
#define BP_FMC_PFAPR_M4PFD   (20U)         //!< Bit position for FMC_PFAPR_M4PFD.
#define BM_FMC_PFAPR_M4PFD   (0x00100000U) //!< Bit mask for FMC_PFAPR_M4PFD.
#define BS_FMC_PFAPR_M4PFD   (1U)          //!< Bit field size in bits for FMC_PFAPR_M4PFD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFAPR_M4PFD field.
#define BR_FMC_PFAPR_M4PFD   (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR, BP_FMC_PFAPR_M4PFD))
#endif

//! @brief Format value for bitfield FMC_PFAPR_M4PFD.
#define BF_FMC_PFAPR_M4PFD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFAPR_M4PFD), uint32_t) & BM_FMC_PFAPR_M4PFD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M4PFD field to a new value.
#define BW_FMC_PFAPR_M4PFD(v) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR, BP_FMC_PFAPR_M4PFD) = (v))
#endif
//@}

/*!
 * @name Register FMC_PFAPR, field M5PFD[21] (RW)
 *
 * These bits control whether prefetching is enabled based on the logical number
 * of the requesting crossbar switch master. This field is further qualified by
 * the PFBnCR[BxDPE,BxIPE] bits.
 *
 * Values:
 * - 0 - Prefetching for this master is enabled.
 * - 1 - Prefetching for this master is disabled.
 */
//@{
#define BP_FMC_PFAPR_M5PFD   (21U)         //!< Bit position for FMC_PFAPR_M5PFD.
#define BM_FMC_PFAPR_M5PFD   (0x00200000U) //!< Bit mask for FMC_PFAPR_M5PFD.
#define BS_FMC_PFAPR_M5PFD   (1U)          //!< Bit field size in bits for FMC_PFAPR_M5PFD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFAPR_M5PFD field.
#define BR_FMC_PFAPR_M5PFD   (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR, BP_FMC_PFAPR_M5PFD))
#endif

//! @brief Format value for bitfield FMC_PFAPR_M5PFD.
#define BF_FMC_PFAPR_M5PFD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFAPR_M5PFD), uint32_t) & BM_FMC_PFAPR_M5PFD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M5PFD field to a new value.
#define BW_FMC_PFAPR_M5PFD(v) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR, BP_FMC_PFAPR_M5PFD) = (v))
#endif
//@}

/*!
 * @name Register FMC_PFAPR, field M6PFD[22] (RW)
 *
 * These bits control whether prefetching is enabled based on the logical number
 * of the requesting crossbar switch master. This field is further qualified by
 * the PFBnCR[BxDPE,BxIPE] bits.
 *
 * Values:
 * - 0 - Prefetching for this master is enabled.
 * - 1 - Prefetching for this master is disabled.
 */
//@{
#define BP_FMC_PFAPR_M6PFD   (22U)         //!< Bit position for FMC_PFAPR_M6PFD.
#define BM_FMC_PFAPR_M6PFD   (0x00400000U) //!< Bit mask for FMC_PFAPR_M6PFD.
#define BS_FMC_PFAPR_M6PFD   (1U)          //!< Bit field size in bits for FMC_PFAPR_M6PFD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFAPR_M6PFD field.
#define BR_FMC_PFAPR_M6PFD   (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR, BP_FMC_PFAPR_M6PFD))
#endif

//! @brief Format value for bitfield FMC_PFAPR_M6PFD.
#define BF_FMC_PFAPR_M6PFD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFAPR_M6PFD), uint32_t) & BM_FMC_PFAPR_M6PFD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M6PFD field to a new value.
#define BW_FMC_PFAPR_M6PFD(v) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR, BP_FMC_PFAPR_M6PFD) = (v))
#endif
//@}

/*!
 * @name Register FMC_PFAPR, field M7PFD[23] (RW)
 *
 * These bits control whether prefetching is enabled based on the logical number
 * of the requesting crossbar switch master. This field is further qualified by
 * the PFBnCR[BxDPE,BxIPE] bits.
 *
 * Values:
 * - 0 - Prefetching for this master is enabled.
 * - 1 - Prefetching for this master is disabled.
 */
//@{
#define BP_FMC_PFAPR_M7PFD   (23U)         //!< Bit position for FMC_PFAPR_M7PFD.
#define BM_FMC_PFAPR_M7PFD   (0x00800000U) //!< Bit mask for FMC_PFAPR_M7PFD.
#define BS_FMC_PFAPR_M7PFD   (1U)          //!< Bit field size in bits for FMC_PFAPR_M7PFD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFAPR_M7PFD field.
#define BR_FMC_PFAPR_M7PFD   (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR, BP_FMC_PFAPR_M7PFD))
#endif

//! @brief Format value for bitfield FMC_PFAPR_M7PFD.
#define BF_FMC_PFAPR_M7PFD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFAPR_M7PFD), uint32_t) & BM_FMC_PFAPR_M7PFD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M7PFD field to a new value.
#define BW_FMC_PFAPR_M7PFD(v) (BITBAND_ACCESS32(HW_FMC_PFAPR_ADDR, BP_FMC_PFAPR_M7PFD) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FMC_PFB0CR - Flash Bank 0 Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FMC_PFB0CR - Flash Bank 0 Control Register (RW)
 *
 * Reset value: 0x3004001FU
 */
typedef union _hw_fmc_pfb0cr
{
    uint32_t U;
    struct _hw_fmc_pfb0cr_bitfields
    {
        uint32_t B0SEBE : 1;           //!< [0] Bank 0 Single Entry Buffer Enable
        uint32_t B0IPE : 1;            //!< [1] Bank 0 Instruction Prefetch Enable
        uint32_t B0DPE : 1;            //!< [2] Bank 0 Data Prefetch Enable
        uint32_t B0ICE : 1;            //!< [3] Bank 0 Instruction Cache Enable
        uint32_t B0DCE : 1;            //!< [4] Bank 0 Data Cache Enable
        uint32_t CRCb : 3;             //!< [7:5] Cache Replacement Control
        uint32_t RESERVED0 : 9;        //!< [16:8]
        uint32_t B0MW : 2;             //!< [18:17] Bank 0 Memory Width
        uint32_t S_B_INV : 1;          //!< [19] Invalidate Prefetch Speculation Buffer
        uint32_t CINV_WAY : 4;         //!< [23:20] Cache Invalidate Way x
        uint32_t CLCK_WAY : 4;         //!< [27:24] Cache Lock Way x
        uint32_t B0RWSC : 4;           //!< [31:28] Bank 0 Read Wait State Control
    } B;
} hw_fmc_pfb0cr_t;
#endif

/*!
 * @name Constants and macros for entire FMC_PFB0CR register
 */
//@{
#define HW_FMC_PFB0CR_ADDR       (REGS_FMC_BASE + 0x4U)

#ifndef __LANGUAGE_ASM__
#define HW_FMC_PFB0CR            (*(__IO hw_fmc_pfb0cr_t *) HW_FMC_PFB0CR_ADDR)
#define HW_FMC_PFB0CR_RD()       (HW_FMC_PFB0CR.U)
#define HW_FMC_PFB0CR_WR(v)      (HW_FMC_PFB0CR.U = (v))
#define HW_FMC_PFB0CR_SET(v)     (HW_FMC_PFB0CR_WR(HW_FMC_PFB0CR_RD() |  (v)))
#define HW_FMC_PFB0CR_CLR(v)     (HW_FMC_PFB0CR_WR(HW_FMC_PFB0CR_RD() & ~(v)))
#define HW_FMC_PFB0CR_TOG(v)     (HW_FMC_PFB0CR_WR(HW_FMC_PFB0CR_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FMC_PFB0CR bitfields
 */

/*!
 * @name Register FMC_PFB0CR, field B0SEBE[0] (RW)
 *
 * This bit controls whether the single entry page buffer is enabled in response
 * to flash read accesses. Its operation is independent from bank 1's cache. A
 * high-to-low transition of this enable forces the page buffer to be invalidated.
 *
 * Values:
 * - 0 - Single entry buffer is disabled.
 * - 1 - Single entry buffer is enabled.
 */
//@{
#define BP_FMC_PFB0CR_B0SEBE (0U)          //!< Bit position for FMC_PFB0CR_B0SEBE.
#define BM_FMC_PFB0CR_B0SEBE (0x00000001U) //!< Bit mask for FMC_PFB0CR_B0SEBE.
#define BS_FMC_PFB0CR_B0SEBE (1U)          //!< Bit field size in bits for FMC_PFB0CR_B0SEBE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFB0CR_B0SEBE field.
#define BR_FMC_PFB0CR_B0SEBE (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR, BP_FMC_PFB0CR_B0SEBE))
#endif

//! @brief Format value for bitfield FMC_PFB0CR_B0SEBE.
#define BF_FMC_PFB0CR_B0SEBE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFB0CR_B0SEBE), uint32_t) & BM_FMC_PFB0CR_B0SEBE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the B0SEBE field to a new value.
#define BW_FMC_PFB0CR_B0SEBE(v) (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR, BP_FMC_PFB0CR_B0SEBE) = (v))
#endif
//@}

/*!
 * @name Register FMC_PFB0CR, field B0IPE[1] (RW)
 *
 * This bit controls whether prefetches (or speculative accesses) are initiated
 * in response to instruction fetches.
 *
 * Values:
 * - 0 - Do not prefetch in response to instruction fetches.
 * - 1 - Enable prefetches in response to instruction fetches.
 */
//@{
#define BP_FMC_PFB0CR_B0IPE  (1U)          //!< Bit position for FMC_PFB0CR_B0IPE.
#define BM_FMC_PFB0CR_B0IPE  (0x00000002U) //!< Bit mask for FMC_PFB0CR_B0IPE.
#define BS_FMC_PFB0CR_B0IPE  (1U)          //!< Bit field size in bits for FMC_PFB0CR_B0IPE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFB0CR_B0IPE field.
#define BR_FMC_PFB0CR_B0IPE  (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR, BP_FMC_PFB0CR_B0IPE))
#endif

//! @brief Format value for bitfield FMC_PFB0CR_B0IPE.
#define BF_FMC_PFB0CR_B0IPE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFB0CR_B0IPE), uint32_t) & BM_FMC_PFB0CR_B0IPE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the B0IPE field to a new value.
#define BW_FMC_PFB0CR_B0IPE(v) (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR, BP_FMC_PFB0CR_B0IPE) = (v))
#endif
//@}

/*!
 * @name Register FMC_PFB0CR, field B0DPE[2] (RW)
 *
 * This bit controls whether prefetches (or speculative accesses) are initiated
 * in response to data references.
 *
 * Values:
 * - 0 - Do not prefetch in response to data references.
 * - 1 - Enable prefetches in response to data references.
 */
//@{
#define BP_FMC_PFB0CR_B0DPE  (2U)          //!< Bit position for FMC_PFB0CR_B0DPE.
#define BM_FMC_PFB0CR_B0DPE  (0x00000004U) //!< Bit mask for FMC_PFB0CR_B0DPE.
#define BS_FMC_PFB0CR_B0DPE  (1U)          //!< Bit field size in bits for FMC_PFB0CR_B0DPE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFB0CR_B0DPE field.
#define BR_FMC_PFB0CR_B0DPE  (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR, BP_FMC_PFB0CR_B0DPE))
#endif

//! @brief Format value for bitfield FMC_PFB0CR_B0DPE.
#define BF_FMC_PFB0CR_B0DPE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFB0CR_B0DPE), uint32_t) & BM_FMC_PFB0CR_B0DPE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the B0DPE field to a new value.
#define BW_FMC_PFB0CR_B0DPE(v) (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR, BP_FMC_PFB0CR_B0DPE) = (v))
#endif
//@}

/*!
 * @name Register FMC_PFB0CR, field B0ICE[3] (RW)
 *
 * This bit controls whether instruction fetches are loaded into the cache.
 *
 * Values:
 * - 0 - Do not cache instruction fetches.
 * - 1 - Cache instruction fetches.
 */
//@{
#define BP_FMC_PFB0CR_B0ICE  (3U)          //!< Bit position for FMC_PFB0CR_B0ICE.
#define BM_FMC_PFB0CR_B0ICE  (0x00000008U) //!< Bit mask for FMC_PFB0CR_B0ICE.
#define BS_FMC_PFB0CR_B0ICE  (1U)          //!< Bit field size in bits for FMC_PFB0CR_B0ICE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFB0CR_B0ICE field.
#define BR_FMC_PFB0CR_B0ICE  (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR, BP_FMC_PFB0CR_B0ICE))
#endif

//! @brief Format value for bitfield FMC_PFB0CR_B0ICE.
#define BF_FMC_PFB0CR_B0ICE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFB0CR_B0ICE), uint32_t) & BM_FMC_PFB0CR_B0ICE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the B0ICE field to a new value.
#define BW_FMC_PFB0CR_B0ICE(v) (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR, BP_FMC_PFB0CR_B0ICE) = (v))
#endif
//@}

/*!
 * @name Register FMC_PFB0CR, field B0DCE[4] (RW)
 *
 * This bit controls whether data references are loaded into the cache.
 *
 * Values:
 * - 0 - Do not cache data references.
 * - 1 - Cache data references.
 */
//@{
#define BP_FMC_PFB0CR_B0DCE  (4U)          //!< Bit position for FMC_PFB0CR_B0DCE.
#define BM_FMC_PFB0CR_B0DCE  (0x00000010U) //!< Bit mask for FMC_PFB0CR_B0DCE.
#define BS_FMC_PFB0CR_B0DCE  (1U)          //!< Bit field size in bits for FMC_PFB0CR_B0DCE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFB0CR_B0DCE field.
#define BR_FMC_PFB0CR_B0DCE  (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR, BP_FMC_PFB0CR_B0DCE))
#endif

//! @brief Format value for bitfield FMC_PFB0CR_B0DCE.
#define BF_FMC_PFB0CR_B0DCE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFB0CR_B0DCE), uint32_t) & BM_FMC_PFB0CR_B0DCE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the B0DCE field to a new value.
#define BW_FMC_PFB0CR_B0DCE(v) (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR, BP_FMC_PFB0CR_B0DCE) = (v))
#endif
//@}

/*!
 * @name Register FMC_PFB0CR, field CRC[7:5] (RW)
 *
 * This 3-bit field defines the replacement algorithm for accesses that are
 * cached.
 *
 * Values:
 * - 000 - LRU replacement algorithm per set across all four ways
 * - 001 - Reserved
 * - 010 - Independent LRU with ways [0-1] for ifetches, [2-3] for data
 * - 011 - Independent LRU with ways [0-2] for ifetches, [3] for data
 * - 1xx - Reserved
 */
//@{
#define BP_FMC_PFB0CR_CRC    (5U)          //!< Bit position for FMC_PFB0CR_CRC.
#define BM_FMC_PFB0CR_CRC    (0x000000E0U) //!< Bit mask for FMC_PFB0CR_CRC.
#define BS_FMC_PFB0CR_CRC    (3U)          //!< Bit field size in bits for FMC_PFB0CR_CRC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFB0CR_CRC field.
#define BR_FMC_PFB0CR_CRC    (HW_FMC_PFB0CR.B.CRC)
#endif

//! @brief Format value for bitfield FMC_PFB0CR_CRC.
#define BF_FMC_PFB0CR_CRC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFB0CR_CRC), uint32_t) & BM_FMC_PFB0CR_CRC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CRC field to a new value.
#define BW_FMC_PFB0CR_CRC(v) (HW_FMC_PFB0CR_WR((HW_FMC_PFB0CR_RD() & ~BM_FMC_PFB0CR_CRC) | BF_FMC_PFB0CR_CRC(v)))
#endif
//@}

/*!
 * @name Register FMC_PFB0CR, field B0MW[18:17] (RO)
 *
 * This read-only field defines the width of the bank 0 memory.
 *
 * Values:
 * - 00 - 32 bits
 * - 01 - 64 bits
 * - 10 - 128 bits
 * - 11 - Reserved
 */
//@{
#define BP_FMC_PFB0CR_B0MW   (17U)         //!< Bit position for FMC_PFB0CR_B0MW.
#define BM_FMC_PFB0CR_B0MW   (0x00060000U) //!< Bit mask for FMC_PFB0CR_B0MW.
#define BS_FMC_PFB0CR_B0MW   (2U)          //!< Bit field size in bits for FMC_PFB0CR_B0MW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFB0CR_B0MW field.
#define BR_FMC_PFB0CR_B0MW   (HW_FMC_PFB0CR.B.B0MW)
#endif
//@}

/*!
 * @name Register FMC_PFB0CR, field S_B_INV[19] (WORZ)
 *
 * This bit determines if the FMC's prefetch speculation buffer and the single
 * entry page buffer are to be invalidated (cleared). When this bit is written,
 * the speculation buffer and single entry buffer are immediately cleared. This bit
 * always reads as zero.
 *
 * Values:
 * - 0 - Speculation buffer and single entry buffer are not affected.
 * - 1 - Invalidate (clear) speculation buffer and single entry buffer.
 */
//@{
#define BP_FMC_PFB0CR_S_B_INV (19U)        //!< Bit position for FMC_PFB0CR_S_B_INV.
#define BM_FMC_PFB0CR_S_B_INV (0x00080000U) //!< Bit mask for FMC_PFB0CR_S_B_INV.
#define BS_FMC_PFB0CR_S_B_INV (1U)         //!< Bit field size in bits for FMC_PFB0CR_S_B_INV.

//! @brief Format value for bitfield FMC_PFB0CR_S_B_INV.
#define BF_FMC_PFB0CR_S_B_INV(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFB0CR_S_B_INV), uint32_t) & BM_FMC_PFB0CR_S_B_INV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the S_B_INV field to a new value.
#define BW_FMC_PFB0CR_S_B_INV(v) (BITBAND_ACCESS32(HW_FMC_PFB0CR_ADDR, BP_FMC_PFB0CR_S_B_INV) = (v))
#endif
//@}

/*!
 * @name Register FMC_PFB0CR, field CINV_WAY[23:20] (WORZ)
 *
 * These bits determine if the given cache way is to be invalidated (cleared).
 * When a bit within this field is written, the corresponding cache way is
 * immediately invalidated: the way's tag, data, and valid contents are cleared. This
 * field always reads as zero. Cache invalidation takes precedence over locking.
 * The cache is invalidated by system reset. System software is required to
 * maintain memory coherency when any segment of the flash memory is programmed or
 * erased. Accordingly, cache invalidations must occur after a programming or erase
 * event is completed and before the new memory image is accessed. The bit setting
 * definitions are for each bit in the field.
 *
 * Values:
 * - 0 - No cache way invalidation for the corresponding cache
 * - 1 - Invalidate cache way for the corresponding cache: clear the tag, data,
 *     and vld bits of ways selected
 */
//@{
#define BP_FMC_PFB0CR_CINV_WAY (20U)       //!< Bit position for FMC_PFB0CR_CINV_WAY.
#define BM_FMC_PFB0CR_CINV_WAY (0x00F00000U) //!< Bit mask for FMC_PFB0CR_CINV_WAY.
#define BS_FMC_PFB0CR_CINV_WAY (4U)        //!< Bit field size in bits for FMC_PFB0CR_CINV_WAY.

//! @brief Format value for bitfield FMC_PFB0CR_CINV_WAY.
#define BF_FMC_PFB0CR_CINV_WAY(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFB0CR_CINV_WAY), uint32_t) & BM_FMC_PFB0CR_CINV_WAY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CINV_WAY field to a new value.
#define BW_FMC_PFB0CR_CINV_WAY(v) (HW_FMC_PFB0CR_WR((HW_FMC_PFB0CR_RD() & ~BM_FMC_PFB0CR_CINV_WAY) | BF_FMC_PFB0CR_CINV_WAY(v)))
#endif
//@}

/*!
 * @name Register FMC_PFB0CR, field CLCK_WAY[27:24] (RW)
 *
 * These bits determine if the given cache way is locked such that its contents
 * will not be displaced by future misses. The bit setting definitions are for
 * each bit in the field.
 *
 * Values:
 * - 0 - Cache way is unlocked and may be displaced
 * - 1 - Cache way is locked and its contents are not displaced
 */
//@{
#define BP_FMC_PFB0CR_CLCK_WAY (24U)       //!< Bit position for FMC_PFB0CR_CLCK_WAY.
#define BM_FMC_PFB0CR_CLCK_WAY (0x0F000000U) //!< Bit mask for FMC_PFB0CR_CLCK_WAY.
#define BS_FMC_PFB0CR_CLCK_WAY (4U)        //!< Bit field size in bits for FMC_PFB0CR_CLCK_WAY.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFB0CR_CLCK_WAY field.
#define BR_FMC_PFB0CR_CLCK_WAY (HW_FMC_PFB0CR.B.CLCK_WAY)
#endif

//! @brief Format value for bitfield FMC_PFB0CR_CLCK_WAY.
#define BF_FMC_PFB0CR_CLCK_WAY(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFB0CR_CLCK_WAY), uint32_t) & BM_FMC_PFB0CR_CLCK_WAY)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLCK_WAY field to a new value.
#define BW_FMC_PFB0CR_CLCK_WAY(v) (HW_FMC_PFB0CR_WR((HW_FMC_PFB0CR_RD() & ~BM_FMC_PFB0CR_CLCK_WAY) | BF_FMC_PFB0CR_CLCK_WAY(v)))
#endif
//@}

/*!
 * @name Register FMC_PFB0CR, field B0RWSC[31:28] (RO)
 *
 * This read-only field defines the number of wait states required to access the
 * bank 0 flash memory. The relationship between the read access time of the
 * flash array (expressed in system clock cycles) and RWSC is defined as: Access
 * time of flash array [system clocks] = RWSC + 1 The FMC automatically calculates
 * this value based on the ratio of the system clock speed to the flash clock
 * speed. For example, when this ratio is 4:1, the field's value is 3h.
 */
//@{
#define BP_FMC_PFB0CR_B0RWSC (28U)         //!< Bit position for FMC_PFB0CR_B0RWSC.
#define BM_FMC_PFB0CR_B0RWSC (0xF0000000U) //!< Bit mask for FMC_PFB0CR_B0RWSC.
#define BS_FMC_PFB0CR_B0RWSC (4U)          //!< Bit field size in bits for FMC_PFB0CR_B0RWSC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFB0CR_B0RWSC field.
#define BR_FMC_PFB0CR_B0RWSC (HW_FMC_PFB0CR.B.B0RWSC)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FMC_PFB1CR - Flash Bank 1 Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FMC_PFB1CR - Flash Bank 1 Control Register (RW)
 *
 * Reset value: 0x3004001FU
 *
 * This register has a format similar to that for PFB0CR, except it controls the
 * operation of flash bank 1, and the "global" cache control fields are empty.
 */
typedef union _hw_fmc_pfb1cr
{
    uint32_t U;
    struct _hw_fmc_pfb1cr_bitfields
    {
        uint32_t B1SEBE : 1;           //!< [0] Bank 1 Single Entry Buffer Enable
        uint32_t B1IPE : 1;            //!< [1] Bank 1 Instruction Prefetch Enable
        uint32_t B1DPE : 1;            //!< [2] Bank 1 Data Prefetch Enable
        uint32_t B1ICE : 1;            //!< [3] Bank 1 Instruction Cache Enable
        uint32_t B1DCE : 1;            //!< [4] Bank 1 Data Cache Enable
        uint32_t RESERVED0 : 12;       //!< [16:5]
        uint32_t B1MW : 2;             //!< [18:17] Bank 1 Memory Width
        uint32_t RESERVED1 : 9;        //!< [27:19]
        uint32_t B1RWSC : 4;           //!< [31:28] Bank 1 Read Wait State Control
    } B;
} hw_fmc_pfb1cr_t;
#endif

/*!
 * @name Constants and macros for entire FMC_PFB1CR register
 */
//@{
#define HW_FMC_PFB1CR_ADDR       (REGS_FMC_BASE + 0x8U)

#ifndef __LANGUAGE_ASM__
#define HW_FMC_PFB1CR            (*(__IO hw_fmc_pfb1cr_t *) HW_FMC_PFB1CR_ADDR)
#define HW_FMC_PFB1CR_RD()       (HW_FMC_PFB1CR.U)
#define HW_FMC_PFB1CR_WR(v)      (HW_FMC_PFB1CR.U = (v))
#define HW_FMC_PFB1CR_SET(v)     (HW_FMC_PFB1CR_WR(HW_FMC_PFB1CR_RD() |  (v)))
#define HW_FMC_PFB1CR_CLR(v)     (HW_FMC_PFB1CR_WR(HW_FMC_PFB1CR_RD() & ~(v)))
#define HW_FMC_PFB1CR_TOG(v)     (HW_FMC_PFB1CR_WR(HW_FMC_PFB1CR_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FMC_PFB1CR bitfields
 */

/*!
 * @name Register FMC_PFB1CR, field B1SEBE[0] (RW)
 *
 * This bit controls whether the single entry buffer is enabled in response to
 * flash read accesses. Its operation is independent from bank 0's cache. A
 * high-to-low transition of this enable forces the page buffer to be invalidated.
 *
 * Values:
 * - 0 - Single entry buffer is disabled.
 * - 1 - Single entry buffer is enabled.
 */
//@{
#define BP_FMC_PFB1CR_B1SEBE (0U)          //!< Bit position for FMC_PFB1CR_B1SEBE.
#define BM_FMC_PFB1CR_B1SEBE (0x00000001U) //!< Bit mask for FMC_PFB1CR_B1SEBE.
#define BS_FMC_PFB1CR_B1SEBE (1U)          //!< Bit field size in bits for FMC_PFB1CR_B1SEBE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFB1CR_B1SEBE field.
#define BR_FMC_PFB1CR_B1SEBE (BITBAND_ACCESS32(HW_FMC_PFB1CR_ADDR, BP_FMC_PFB1CR_B1SEBE))
#endif

//! @brief Format value for bitfield FMC_PFB1CR_B1SEBE.
#define BF_FMC_PFB1CR_B1SEBE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFB1CR_B1SEBE), uint32_t) & BM_FMC_PFB1CR_B1SEBE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the B1SEBE field to a new value.
#define BW_FMC_PFB1CR_B1SEBE(v) (BITBAND_ACCESS32(HW_FMC_PFB1CR_ADDR, BP_FMC_PFB1CR_B1SEBE) = (v))
#endif
//@}

/*!
 * @name Register FMC_PFB1CR, field B1IPE[1] (RW)
 *
 * This bit controls whether prefetches (or speculative accesses) are initiated
 * in response to instruction fetches.
 *
 * Values:
 * - 0 - Do not prefetch in response to instruction fetches.
 * - 1 - Enable prefetches in response to instruction fetches.
 */
//@{
#define BP_FMC_PFB1CR_B1IPE  (1U)          //!< Bit position for FMC_PFB1CR_B1IPE.
#define BM_FMC_PFB1CR_B1IPE  (0x00000002U) //!< Bit mask for FMC_PFB1CR_B1IPE.
#define BS_FMC_PFB1CR_B1IPE  (1U)          //!< Bit field size in bits for FMC_PFB1CR_B1IPE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFB1CR_B1IPE field.
#define BR_FMC_PFB1CR_B1IPE  (BITBAND_ACCESS32(HW_FMC_PFB1CR_ADDR, BP_FMC_PFB1CR_B1IPE))
#endif

//! @brief Format value for bitfield FMC_PFB1CR_B1IPE.
#define BF_FMC_PFB1CR_B1IPE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFB1CR_B1IPE), uint32_t) & BM_FMC_PFB1CR_B1IPE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the B1IPE field to a new value.
#define BW_FMC_PFB1CR_B1IPE(v) (BITBAND_ACCESS32(HW_FMC_PFB1CR_ADDR, BP_FMC_PFB1CR_B1IPE) = (v))
#endif
//@}

/*!
 * @name Register FMC_PFB1CR, field B1DPE[2] (RW)
 *
 * This bit controls whether prefetches (or speculative accesses) are initiated
 * in response to data references.
 *
 * Values:
 * - 0 - Do not prefetch in response to data references.
 * - 1 - Enable prefetches in response to data references.
 */
//@{
#define BP_FMC_PFB1CR_B1DPE  (2U)          //!< Bit position for FMC_PFB1CR_B1DPE.
#define BM_FMC_PFB1CR_B1DPE  (0x00000004U) //!< Bit mask for FMC_PFB1CR_B1DPE.
#define BS_FMC_PFB1CR_B1DPE  (1U)          //!< Bit field size in bits for FMC_PFB1CR_B1DPE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFB1CR_B1DPE field.
#define BR_FMC_PFB1CR_B1DPE  (BITBAND_ACCESS32(HW_FMC_PFB1CR_ADDR, BP_FMC_PFB1CR_B1DPE))
#endif

//! @brief Format value for bitfield FMC_PFB1CR_B1DPE.
#define BF_FMC_PFB1CR_B1DPE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFB1CR_B1DPE), uint32_t) & BM_FMC_PFB1CR_B1DPE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the B1DPE field to a new value.
#define BW_FMC_PFB1CR_B1DPE(v) (BITBAND_ACCESS32(HW_FMC_PFB1CR_ADDR, BP_FMC_PFB1CR_B1DPE) = (v))
#endif
//@}

/*!
 * @name Register FMC_PFB1CR, field B1ICE[3] (RW)
 *
 * This bit controls whether instruction fetches are loaded into the cache.
 *
 * Values:
 * - 0 - Do not cache instruction fetches.
 * - 1 - Cache instruction fetches.
 */
//@{
#define BP_FMC_PFB1CR_B1ICE  (3U)          //!< Bit position for FMC_PFB1CR_B1ICE.
#define BM_FMC_PFB1CR_B1ICE  (0x00000008U) //!< Bit mask for FMC_PFB1CR_B1ICE.
#define BS_FMC_PFB1CR_B1ICE  (1U)          //!< Bit field size in bits for FMC_PFB1CR_B1ICE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFB1CR_B1ICE field.
#define BR_FMC_PFB1CR_B1ICE  (BITBAND_ACCESS32(HW_FMC_PFB1CR_ADDR, BP_FMC_PFB1CR_B1ICE))
#endif

//! @brief Format value for bitfield FMC_PFB1CR_B1ICE.
#define BF_FMC_PFB1CR_B1ICE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFB1CR_B1ICE), uint32_t) & BM_FMC_PFB1CR_B1ICE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the B1ICE field to a new value.
#define BW_FMC_PFB1CR_B1ICE(v) (BITBAND_ACCESS32(HW_FMC_PFB1CR_ADDR, BP_FMC_PFB1CR_B1ICE) = (v))
#endif
//@}

/*!
 * @name Register FMC_PFB1CR, field B1DCE[4] (RW)
 *
 * This bit controls whether data references are loaded into the cache.
 *
 * Values:
 * - 0 - Do not cache data references.
 * - 1 - Cache data references.
 */
//@{
#define BP_FMC_PFB1CR_B1DCE  (4U)          //!< Bit position for FMC_PFB1CR_B1DCE.
#define BM_FMC_PFB1CR_B1DCE  (0x00000010U) //!< Bit mask for FMC_PFB1CR_B1DCE.
#define BS_FMC_PFB1CR_B1DCE  (1U)          //!< Bit field size in bits for FMC_PFB1CR_B1DCE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFB1CR_B1DCE field.
#define BR_FMC_PFB1CR_B1DCE  (BITBAND_ACCESS32(HW_FMC_PFB1CR_ADDR, BP_FMC_PFB1CR_B1DCE))
#endif

//! @brief Format value for bitfield FMC_PFB1CR_B1DCE.
#define BF_FMC_PFB1CR_B1DCE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_PFB1CR_B1DCE), uint32_t) & BM_FMC_PFB1CR_B1DCE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the B1DCE field to a new value.
#define BW_FMC_PFB1CR_B1DCE(v) (BITBAND_ACCESS32(HW_FMC_PFB1CR_ADDR, BP_FMC_PFB1CR_B1DCE) = (v))
#endif
//@}

/*!
 * @name Register FMC_PFB1CR, field B1MW[18:17] (RO)
 *
 * This read-only field defines the width of the bank 1 memory.
 *
 * Values:
 * - 00 - 32 bits
 * - 01 - 64 bits
 * - 10 - 128 bits
 * - 11 - Reserved
 */
//@{
#define BP_FMC_PFB1CR_B1MW   (17U)         //!< Bit position for FMC_PFB1CR_B1MW.
#define BM_FMC_PFB1CR_B1MW   (0x00060000U) //!< Bit mask for FMC_PFB1CR_B1MW.
#define BS_FMC_PFB1CR_B1MW   (2U)          //!< Bit field size in bits for FMC_PFB1CR_B1MW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFB1CR_B1MW field.
#define BR_FMC_PFB1CR_B1MW   (HW_FMC_PFB1CR.B.B1MW)
#endif
//@}

/*!
 * @name Register FMC_PFB1CR, field B1RWSC[31:28] (RO)
 *
 * This read-only field defines the number of wait states required to access the
 * bank 1 flash memory. The relationship between the read access time of the
 * flash array (expressed in system clock cycles) and RWSC is defined as: Access
 * time of flash array [system clocks] = RWSC + 1 The FMC automatically calculates
 * this value based on the ratio of the system clock speed to the flash clock
 * speed. For example, when this ratio is 4:1, the field's value is 3h.
 */
//@{
#define BP_FMC_PFB1CR_B1RWSC (28U)         //!< Bit position for FMC_PFB1CR_B1RWSC.
#define BM_FMC_PFB1CR_B1RWSC (0xF0000000U) //!< Bit mask for FMC_PFB1CR_B1RWSC.
#define BS_FMC_PFB1CR_B1RWSC (4U)          //!< Bit field size in bits for FMC_PFB1CR_B1RWSC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_PFB1CR_B1RWSC field.
#define BR_FMC_PFB1CR_B1RWSC (HW_FMC_PFB1CR.B.B1RWSC)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FMC_TAGVDW0Sn - Cache Tag Storage
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FMC_TAGVDW0Sn - Cache Tag Storage (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache is a 4-way, set-associative cache with 4 sets. The ways are
 * numbered 0-3 and the sets are numbered 0-3. In TAGVDWxSy, x denotes the way, and y
 * denotes the set. This section represents tag/vld information for all sets in the
 * indicated way.
 */
typedef union _hw_fmc_tagvdw0sn
{
    uint32_t U;
    struct _hw_fmc_tagvdw0sn_bitfields
    {
        uint32_t valid : 1;            //!< [0] 1-bit valid for cache entry
        uint32_t RESERVED0 : 4;        //!< [4:1]
        uint32_t tag : 14;             //!< [18:5] 14-bit tag for cache entry
        uint32_t RESERVED1 : 13;       //!< [31:19]
    } B;
} hw_fmc_tagvdw0sn_t;
#endif

/*!
 * @name Constants and macros for entire FMC_TAGVDW0Sn register
 */
//@{
#define HW_FMC_TAGVDW0Sn_COUNT (4U)

#define HW_FMC_TAGVDW0Sn_ADDR(n) (REGS_FMC_BASE + 0x100U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_FMC_TAGVDW0Sn(n)      (*(__IO hw_fmc_tagvdw0sn_t *) HW_FMC_TAGVDW0Sn_ADDR(n))
#define HW_FMC_TAGVDW0Sn_RD(n)   (HW_FMC_TAGVDW0Sn(n).U)
#define HW_FMC_TAGVDW0Sn_WR(n, v) (HW_FMC_TAGVDW0Sn(n).U = (v))
#define HW_FMC_TAGVDW0Sn_SET(n, v) (HW_FMC_TAGVDW0Sn_WR(n, HW_FMC_TAGVDW0Sn_RD(n) |  (v)))
#define HW_FMC_TAGVDW0Sn_CLR(n, v) (HW_FMC_TAGVDW0Sn_WR(n, HW_FMC_TAGVDW0Sn_RD(n) & ~(v)))
#define HW_FMC_TAGVDW0Sn_TOG(n, v) (HW_FMC_TAGVDW0Sn_WR(n, HW_FMC_TAGVDW0Sn_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FMC_TAGVDW0Sn bitfields
 */

/*!
 * @name Register FMC_TAGVDW0Sn, field valid[0] (RW)
 */
//@{
#define BP_FMC_TAGVDW0Sn_valid (0U)        //!< Bit position for FMC_TAGVDW0Sn_valid.
#define BM_FMC_TAGVDW0Sn_valid (0x00000001U) //!< Bit mask for FMC_TAGVDW0Sn_valid.
#define BS_FMC_TAGVDW0Sn_valid (1U)        //!< Bit field size in bits for FMC_TAGVDW0Sn_valid.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_TAGVDW0Sn_valid field.
#define BR_FMC_TAGVDW0Sn_valid(n) (BITBAND_ACCESS32(HW_FMC_TAGVDW0Sn_ADDR(n), BP_FMC_TAGVDW0Sn_valid))
#endif

//! @brief Format value for bitfield FMC_TAGVDW0Sn_valid.
#define BF_FMC_TAGVDW0Sn_valid(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_TAGVDW0Sn_valid), uint32_t) & BM_FMC_TAGVDW0Sn_valid)

#ifndef __LANGUAGE_ASM__
//! @brief Set the valid field to a new value.
#define BW_FMC_TAGVDW0Sn_valid(n, v) (BITBAND_ACCESS32(HW_FMC_TAGVDW0Sn_ADDR(n), BP_FMC_TAGVDW0Sn_valid) = (v))
#endif
//@}

/*!
 * @name Register FMC_TAGVDW0Sn, field tag[18:5] (RW)
 */
//@{
#define BP_FMC_TAGVDW0Sn_tag (5U)          //!< Bit position for FMC_TAGVDW0Sn_tag.
#define BM_FMC_TAGVDW0Sn_tag (0x0007FFE0U) //!< Bit mask for FMC_TAGVDW0Sn_tag.
#define BS_FMC_TAGVDW0Sn_tag (14U)         //!< Bit field size in bits for FMC_TAGVDW0Sn_tag.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_TAGVDW0Sn_tag field.
#define BR_FMC_TAGVDW0Sn_tag(n) (HW_FMC_TAGVDW0Sn(n).B.tag)
#endif

//! @brief Format value for bitfield FMC_TAGVDW0Sn_tag.
#define BF_FMC_TAGVDW0Sn_tag(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_TAGVDW0Sn_tag), uint32_t) & BM_FMC_TAGVDW0Sn_tag)

#ifndef __LANGUAGE_ASM__
//! @brief Set the tag field to a new value.
#define BW_FMC_TAGVDW0Sn_tag(n, v) (HW_FMC_TAGVDW0Sn_WR(n, (HW_FMC_TAGVDW0Sn_RD(n) & ~BM_FMC_TAGVDW0Sn_tag) | BF_FMC_TAGVDW0Sn_tag(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FMC_TAGVDW1Sn - Cache Tag Storage
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FMC_TAGVDW1Sn - Cache Tag Storage (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache is a 4-way, set-associative cache with 4 sets. The ways are
 * numbered 0-3 and the sets are numbered 0-3. In TAGVDWxSy, x denotes the way, and y
 * denotes the set. This section represents tag/vld information for all sets in the
 * indicated way.
 */
typedef union _hw_fmc_tagvdw1sn
{
    uint32_t U;
    struct _hw_fmc_tagvdw1sn_bitfields
    {
        uint32_t valid : 1;            //!< [0] 1-bit valid for cache entry
        uint32_t RESERVED0 : 4;        //!< [4:1]
        uint32_t tag : 14;             //!< [18:5] 14-bit tag for cache entry
        uint32_t RESERVED1 : 13;       //!< [31:19]
    } B;
} hw_fmc_tagvdw1sn_t;
#endif

/*!
 * @name Constants and macros for entire FMC_TAGVDW1Sn register
 */
//@{
#define HW_FMC_TAGVDW1Sn_COUNT (4U)

#define HW_FMC_TAGVDW1Sn_ADDR(n) (REGS_FMC_BASE + 0x110U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_FMC_TAGVDW1Sn(n)      (*(__IO hw_fmc_tagvdw1sn_t *) HW_FMC_TAGVDW1Sn_ADDR(n))
#define HW_FMC_TAGVDW1Sn_RD(n)   (HW_FMC_TAGVDW1Sn(n).U)
#define HW_FMC_TAGVDW1Sn_WR(n, v) (HW_FMC_TAGVDW1Sn(n).U = (v))
#define HW_FMC_TAGVDW1Sn_SET(n, v) (HW_FMC_TAGVDW1Sn_WR(n, HW_FMC_TAGVDW1Sn_RD(n) |  (v)))
#define HW_FMC_TAGVDW1Sn_CLR(n, v) (HW_FMC_TAGVDW1Sn_WR(n, HW_FMC_TAGVDW1Sn_RD(n) & ~(v)))
#define HW_FMC_TAGVDW1Sn_TOG(n, v) (HW_FMC_TAGVDW1Sn_WR(n, HW_FMC_TAGVDW1Sn_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FMC_TAGVDW1Sn bitfields
 */

/*!
 * @name Register FMC_TAGVDW1Sn, field valid[0] (RW)
 */
//@{
#define BP_FMC_TAGVDW1Sn_valid (0U)        //!< Bit position for FMC_TAGVDW1Sn_valid.
#define BM_FMC_TAGVDW1Sn_valid (0x00000001U) //!< Bit mask for FMC_TAGVDW1Sn_valid.
#define BS_FMC_TAGVDW1Sn_valid (1U)        //!< Bit field size in bits for FMC_TAGVDW1Sn_valid.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_TAGVDW1Sn_valid field.
#define BR_FMC_TAGVDW1Sn_valid(n) (BITBAND_ACCESS32(HW_FMC_TAGVDW1Sn_ADDR(n), BP_FMC_TAGVDW1Sn_valid))
#endif

//! @brief Format value for bitfield FMC_TAGVDW1Sn_valid.
#define BF_FMC_TAGVDW1Sn_valid(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_TAGVDW1Sn_valid), uint32_t) & BM_FMC_TAGVDW1Sn_valid)

#ifndef __LANGUAGE_ASM__
//! @brief Set the valid field to a new value.
#define BW_FMC_TAGVDW1Sn_valid(n, v) (BITBAND_ACCESS32(HW_FMC_TAGVDW1Sn_ADDR(n), BP_FMC_TAGVDW1Sn_valid) = (v))
#endif
//@}

/*!
 * @name Register FMC_TAGVDW1Sn, field tag[18:5] (RW)
 */
//@{
#define BP_FMC_TAGVDW1Sn_tag (5U)          //!< Bit position for FMC_TAGVDW1Sn_tag.
#define BM_FMC_TAGVDW1Sn_tag (0x0007FFE0U) //!< Bit mask for FMC_TAGVDW1Sn_tag.
#define BS_FMC_TAGVDW1Sn_tag (14U)         //!< Bit field size in bits for FMC_TAGVDW1Sn_tag.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_TAGVDW1Sn_tag field.
#define BR_FMC_TAGVDW1Sn_tag(n) (HW_FMC_TAGVDW1Sn(n).B.tag)
#endif

//! @brief Format value for bitfield FMC_TAGVDW1Sn_tag.
#define BF_FMC_TAGVDW1Sn_tag(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_TAGVDW1Sn_tag), uint32_t) & BM_FMC_TAGVDW1Sn_tag)

#ifndef __LANGUAGE_ASM__
//! @brief Set the tag field to a new value.
#define BW_FMC_TAGVDW1Sn_tag(n, v) (HW_FMC_TAGVDW1Sn_WR(n, (HW_FMC_TAGVDW1Sn_RD(n) & ~BM_FMC_TAGVDW1Sn_tag) | BF_FMC_TAGVDW1Sn_tag(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FMC_TAGVDW2Sn - Cache Tag Storage
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FMC_TAGVDW2Sn - Cache Tag Storage (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache is a 4-way, set-associative cache with 4 sets. The ways are
 * numbered 0-3 and the sets are numbered 0-3. In TAGVDWxSy, x denotes the way, and y
 * denotes the set. This section represents tag/vld information for all sets in the
 * indicated way.
 */
typedef union _hw_fmc_tagvdw2sn
{
    uint32_t U;
    struct _hw_fmc_tagvdw2sn_bitfields
    {
        uint32_t valid : 1;            //!< [0] 1-bit valid for cache entry
        uint32_t RESERVED0 : 4;        //!< [4:1]
        uint32_t tag : 14;             //!< [18:5] 14-bit tag for cache entry
        uint32_t RESERVED1 : 13;       //!< [31:19]
    } B;
} hw_fmc_tagvdw2sn_t;
#endif

/*!
 * @name Constants and macros for entire FMC_TAGVDW2Sn register
 */
//@{
#define HW_FMC_TAGVDW2Sn_COUNT (4U)

#define HW_FMC_TAGVDW2Sn_ADDR(n) (REGS_FMC_BASE + 0x120U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_FMC_TAGVDW2Sn(n)      (*(__IO hw_fmc_tagvdw2sn_t *) HW_FMC_TAGVDW2Sn_ADDR(n))
#define HW_FMC_TAGVDW2Sn_RD(n)   (HW_FMC_TAGVDW2Sn(n).U)
#define HW_FMC_TAGVDW2Sn_WR(n, v) (HW_FMC_TAGVDW2Sn(n).U = (v))
#define HW_FMC_TAGVDW2Sn_SET(n, v) (HW_FMC_TAGVDW2Sn_WR(n, HW_FMC_TAGVDW2Sn_RD(n) |  (v)))
#define HW_FMC_TAGVDW2Sn_CLR(n, v) (HW_FMC_TAGVDW2Sn_WR(n, HW_FMC_TAGVDW2Sn_RD(n) & ~(v)))
#define HW_FMC_TAGVDW2Sn_TOG(n, v) (HW_FMC_TAGVDW2Sn_WR(n, HW_FMC_TAGVDW2Sn_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FMC_TAGVDW2Sn bitfields
 */

/*!
 * @name Register FMC_TAGVDW2Sn, field valid[0] (RW)
 */
//@{
#define BP_FMC_TAGVDW2Sn_valid (0U)        //!< Bit position for FMC_TAGVDW2Sn_valid.
#define BM_FMC_TAGVDW2Sn_valid (0x00000001U) //!< Bit mask for FMC_TAGVDW2Sn_valid.
#define BS_FMC_TAGVDW2Sn_valid (1U)        //!< Bit field size in bits for FMC_TAGVDW2Sn_valid.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_TAGVDW2Sn_valid field.
#define BR_FMC_TAGVDW2Sn_valid(n) (BITBAND_ACCESS32(HW_FMC_TAGVDW2Sn_ADDR(n), BP_FMC_TAGVDW2Sn_valid))
#endif

//! @brief Format value for bitfield FMC_TAGVDW2Sn_valid.
#define BF_FMC_TAGVDW2Sn_valid(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_TAGVDW2Sn_valid), uint32_t) & BM_FMC_TAGVDW2Sn_valid)

#ifndef __LANGUAGE_ASM__
//! @brief Set the valid field to a new value.
#define BW_FMC_TAGVDW2Sn_valid(n, v) (BITBAND_ACCESS32(HW_FMC_TAGVDW2Sn_ADDR(n), BP_FMC_TAGVDW2Sn_valid) = (v))
#endif
//@}

/*!
 * @name Register FMC_TAGVDW2Sn, field tag[18:5] (RW)
 */
//@{
#define BP_FMC_TAGVDW2Sn_tag (5U)          //!< Bit position for FMC_TAGVDW2Sn_tag.
#define BM_FMC_TAGVDW2Sn_tag (0x0007FFE0U) //!< Bit mask for FMC_TAGVDW2Sn_tag.
#define BS_FMC_TAGVDW2Sn_tag (14U)         //!< Bit field size in bits for FMC_TAGVDW2Sn_tag.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_TAGVDW2Sn_tag field.
#define BR_FMC_TAGVDW2Sn_tag(n) (HW_FMC_TAGVDW2Sn(n).B.tag)
#endif

//! @brief Format value for bitfield FMC_TAGVDW2Sn_tag.
#define BF_FMC_TAGVDW2Sn_tag(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_TAGVDW2Sn_tag), uint32_t) & BM_FMC_TAGVDW2Sn_tag)

#ifndef __LANGUAGE_ASM__
//! @brief Set the tag field to a new value.
#define BW_FMC_TAGVDW2Sn_tag(n, v) (HW_FMC_TAGVDW2Sn_WR(n, (HW_FMC_TAGVDW2Sn_RD(n) & ~BM_FMC_TAGVDW2Sn_tag) | BF_FMC_TAGVDW2Sn_tag(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FMC_TAGVDW3Sn - Cache Tag Storage
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FMC_TAGVDW3Sn - Cache Tag Storage (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache is a 4-way, set-associative cache with 4 sets. The ways are
 * numbered 0-3 and the sets are numbered 0-3. In TAGVDWxSy, x denotes the way, and y
 * denotes the set. This section represents tag/vld information for all sets in the
 * indicated way.
 */
typedef union _hw_fmc_tagvdw3sn
{
    uint32_t U;
    struct _hw_fmc_tagvdw3sn_bitfields
    {
        uint32_t valid : 1;            //!< [0] 1-bit valid for cache entry
        uint32_t RESERVED0 : 4;        //!< [4:1]
        uint32_t tag : 14;             //!< [18:5] 14-bit tag for cache entry
        uint32_t RESERVED1 : 13;       //!< [31:19]
    } B;
} hw_fmc_tagvdw3sn_t;
#endif

/*!
 * @name Constants and macros for entire FMC_TAGVDW3Sn register
 */
//@{
#define HW_FMC_TAGVDW3Sn_COUNT (4U)

#define HW_FMC_TAGVDW3Sn_ADDR(n) (REGS_FMC_BASE + 0x130U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_FMC_TAGVDW3Sn(n)      (*(__IO hw_fmc_tagvdw3sn_t *) HW_FMC_TAGVDW3Sn_ADDR(n))
#define HW_FMC_TAGVDW3Sn_RD(n)   (HW_FMC_TAGVDW3Sn(n).U)
#define HW_FMC_TAGVDW3Sn_WR(n, v) (HW_FMC_TAGVDW3Sn(n).U = (v))
#define HW_FMC_TAGVDW3Sn_SET(n, v) (HW_FMC_TAGVDW3Sn_WR(n, HW_FMC_TAGVDW3Sn_RD(n) |  (v)))
#define HW_FMC_TAGVDW3Sn_CLR(n, v) (HW_FMC_TAGVDW3Sn_WR(n, HW_FMC_TAGVDW3Sn_RD(n) & ~(v)))
#define HW_FMC_TAGVDW3Sn_TOG(n, v) (HW_FMC_TAGVDW3Sn_WR(n, HW_FMC_TAGVDW3Sn_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FMC_TAGVDW3Sn bitfields
 */

/*!
 * @name Register FMC_TAGVDW3Sn, field valid[0] (RW)
 */
//@{
#define BP_FMC_TAGVDW3Sn_valid (0U)        //!< Bit position for FMC_TAGVDW3Sn_valid.
#define BM_FMC_TAGVDW3Sn_valid (0x00000001U) //!< Bit mask for FMC_TAGVDW3Sn_valid.
#define BS_FMC_TAGVDW3Sn_valid (1U)        //!< Bit field size in bits for FMC_TAGVDW3Sn_valid.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_TAGVDW3Sn_valid field.
#define BR_FMC_TAGVDW3Sn_valid(n) (BITBAND_ACCESS32(HW_FMC_TAGVDW3Sn_ADDR(n), BP_FMC_TAGVDW3Sn_valid))
#endif

//! @brief Format value for bitfield FMC_TAGVDW3Sn_valid.
#define BF_FMC_TAGVDW3Sn_valid(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_TAGVDW3Sn_valid), uint32_t) & BM_FMC_TAGVDW3Sn_valid)

#ifndef __LANGUAGE_ASM__
//! @brief Set the valid field to a new value.
#define BW_FMC_TAGVDW3Sn_valid(n, v) (BITBAND_ACCESS32(HW_FMC_TAGVDW3Sn_ADDR(n), BP_FMC_TAGVDW3Sn_valid) = (v))
#endif
//@}

/*!
 * @name Register FMC_TAGVDW3Sn, field tag[18:5] (RW)
 */
//@{
#define BP_FMC_TAGVDW3Sn_tag (5U)          //!< Bit position for FMC_TAGVDW3Sn_tag.
#define BM_FMC_TAGVDW3Sn_tag (0x0007FFE0U) //!< Bit mask for FMC_TAGVDW3Sn_tag.
#define BS_FMC_TAGVDW3Sn_tag (14U)         //!< Bit field size in bits for FMC_TAGVDW3Sn_tag.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_TAGVDW3Sn_tag field.
#define BR_FMC_TAGVDW3Sn_tag(n) (HW_FMC_TAGVDW3Sn(n).B.tag)
#endif

//! @brief Format value for bitfield FMC_TAGVDW3Sn_tag.
#define BF_FMC_TAGVDW3Sn_tag(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_TAGVDW3Sn_tag), uint32_t) & BM_FMC_TAGVDW3Sn_tag)

#ifndef __LANGUAGE_ASM__
//! @brief Set the tag field to a new value.
#define BW_FMC_TAGVDW3Sn_tag(n, v) (HW_FMC_TAGVDW3Sn_WR(n, (HW_FMC_TAGVDW3Sn_RD(n) & ~BM_FMC_TAGVDW3Sn_tag) | BF_FMC_TAGVDW3Sn_tag(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FMC_DATAW0SnU - Cache Data Storage (upper word)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FMC_DATAW0SnU - Cache Data Storage (upper word) (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache of 64-bit entries is a 4-way, set-associative cache with 4 sets.
 * The ways are numbered 0-3 and the sets are numbered 0-3. In DATAWxSyU and
 * DATAWxSyL, x denotes the way, y denotes the set, and U and L represent upper and
 * lower word, respectively. This section represents data for the upper word (bits
 * [63:32]) of all sets in the indicated way.
 */
typedef union _hw_fmc_dataw0snu
{
    uint32_t U;
    struct _hw_fmc_dataw0snu_bitfields
    {
        uint32_t data : 32;            //!< [31:0] Bits [63:32] of data entry
    } B;
} hw_fmc_dataw0snu_t;
#endif

/*!
 * @name Constants and macros for entire FMC_DATAW0SnU register
 */
//@{
#define HW_FMC_DATAW0SnU_COUNT (4U)

#define HW_FMC_DATAW0SnU_ADDR(n) (REGS_FMC_BASE + 0x200U + (0x8U * n))

#ifndef __LANGUAGE_ASM__
#define HW_FMC_DATAW0SnU(n)      (*(__IO hw_fmc_dataw0snu_t *) HW_FMC_DATAW0SnU_ADDR(n))
#define HW_FMC_DATAW0SnU_RD(n)   (HW_FMC_DATAW0SnU(n).U)
#define HW_FMC_DATAW0SnU_WR(n, v) (HW_FMC_DATAW0SnU(n).U = (v))
#define HW_FMC_DATAW0SnU_SET(n, v) (HW_FMC_DATAW0SnU_WR(n, HW_FMC_DATAW0SnU_RD(n) |  (v)))
#define HW_FMC_DATAW0SnU_CLR(n, v) (HW_FMC_DATAW0SnU_WR(n, HW_FMC_DATAW0SnU_RD(n) & ~(v)))
#define HW_FMC_DATAW0SnU_TOG(n, v) (HW_FMC_DATAW0SnU_WR(n, HW_FMC_DATAW0SnU_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FMC_DATAW0SnU bitfields
 */

/*!
 * @name Register FMC_DATAW0SnU, field data[31:0] (RW)
 */
//@{
#define BP_FMC_DATAW0SnU_data (0U)         //!< Bit position for FMC_DATAW0SnU_data.
#define BM_FMC_DATAW0SnU_data (0xFFFFFFFFU) //!< Bit mask for FMC_DATAW0SnU_data.
#define BS_FMC_DATAW0SnU_data (32U)        //!< Bit field size in bits for FMC_DATAW0SnU_data.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_DATAW0SnU_data field.
#define BR_FMC_DATAW0SnU_data(n) (HW_FMC_DATAW0SnU(n).U)
#endif

//! @brief Format value for bitfield FMC_DATAW0SnU_data.
#define BF_FMC_DATAW0SnU_data(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_DATAW0SnU_data), uint32_t) & BM_FMC_DATAW0SnU_data)

#ifndef __LANGUAGE_ASM__
//! @brief Set the data field to a new value.
#define BW_FMC_DATAW0SnU_data(n, v) (HW_FMC_DATAW0SnU_WR(n, v))
#endif
//@}
//-------------------------------------------------------------------------------------------
// HW_FMC_DATAW0SnL - Cache Data Storage (lower word)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FMC_DATAW0SnL - Cache Data Storage (lower word) (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache of 64-bit entries is a 4-way, set-associative cache with 4 sets.
 * The ways are numbered 0-3 and the sets are numbered 0-3. In DATAWxSyU and
 * DATAWxSyL, x denotes the way, y denotes the set, and U and L represent upper and
 * lower word, respectively. This section represents data for the lower word (bits
 * [31:0]) of all sets in the indicated way.
 */
typedef union _hw_fmc_dataw0snl
{
    uint32_t U;
    struct _hw_fmc_dataw0snl_bitfields
    {
        uint32_t data : 32;            //!< [31:0] Bits [31:0] of data entry
    } B;
} hw_fmc_dataw0snl_t;
#endif

/*!
 * @name Constants and macros for entire FMC_DATAW0SnL register
 */
//@{
#define HW_FMC_DATAW0SnL_COUNT (4U)

#define HW_FMC_DATAW0SnL_ADDR(n) (REGS_FMC_BASE + 0x204U + (0x8U * n))

#ifndef __LANGUAGE_ASM__
#define HW_FMC_DATAW0SnL(n)      (*(__IO hw_fmc_dataw0snl_t *) HW_FMC_DATAW0SnL_ADDR(n))
#define HW_FMC_DATAW0SnL_RD(n)   (HW_FMC_DATAW0SnL(n).U)
#define HW_FMC_DATAW0SnL_WR(n, v) (HW_FMC_DATAW0SnL(n).U = (v))
#define HW_FMC_DATAW0SnL_SET(n, v) (HW_FMC_DATAW0SnL_WR(n, HW_FMC_DATAW0SnL_RD(n) |  (v)))
#define HW_FMC_DATAW0SnL_CLR(n, v) (HW_FMC_DATAW0SnL_WR(n, HW_FMC_DATAW0SnL_RD(n) & ~(v)))
#define HW_FMC_DATAW0SnL_TOG(n, v) (HW_FMC_DATAW0SnL_WR(n, HW_FMC_DATAW0SnL_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FMC_DATAW0SnL bitfields
 */

/*!
 * @name Register FMC_DATAW0SnL, field data[31:0] (RW)
 */
//@{
#define BP_FMC_DATAW0SnL_data (0U)         //!< Bit position for FMC_DATAW0SnL_data.
#define BM_FMC_DATAW0SnL_data (0xFFFFFFFFU) //!< Bit mask for FMC_DATAW0SnL_data.
#define BS_FMC_DATAW0SnL_data (32U)        //!< Bit field size in bits for FMC_DATAW0SnL_data.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_DATAW0SnL_data field.
#define BR_FMC_DATAW0SnL_data(n) (HW_FMC_DATAW0SnL(n).U)
#endif

//! @brief Format value for bitfield FMC_DATAW0SnL_data.
#define BF_FMC_DATAW0SnL_data(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_DATAW0SnL_data), uint32_t) & BM_FMC_DATAW0SnL_data)

#ifndef __LANGUAGE_ASM__
//! @brief Set the data field to a new value.
#define BW_FMC_DATAW0SnL_data(n, v) (HW_FMC_DATAW0SnL_WR(n, v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FMC_DATAW1SnU - Cache Data Storage (upper word)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FMC_DATAW1SnU - Cache Data Storage (upper word) (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache of 64-bit entries is a 4-way, set-associative cache with 4 sets.
 * The ways are numbered 0-3 and the sets are numbered 0-3. In DATAWxSyU and
 * DATAWxSyL, x denotes the way, y denotes the set, and U and L represent upper and
 * lower word, respectively. This section represents data for the upper word (bits
 * [63:32]) of all sets in the indicated way.
 */
typedef union _hw_fmc_dataw1snu
{
    uint32_t U;
    struct _hw_fmc_dataw1snu_bitfields
    {
        uint32_t data : 32;            //!< [31:0] Bits [63:32] of data entry
    } B;
} hw_fmc_dataw1snu_t;
#endif

/*!
 * @name Constants and macros for entire FMC_DATAW1SnU register
 */
//@{
#define HW_FMC_DATAW1SnU_COUNT (4U)

#define HW_FMC_DATAW1SnU_ADDR(n) (REGS_FMC_BASE + 0x220U + (0x8U * n))

#ifndef __LANGUAGE_ASM__
#define HW_FMC_DATAW1SnU(n)      (*(__IO hw_fmc_dataw1snu_t *) HW_FMC_DATAW1SnU_ADDR(n))
#define HW_FMC_DATAW1SnU_RD(n)   (HW_FMC_DATAW1SnU(n).U)
#define HW_FMC_DATAW1SnU_WR(n, v) (HW_FMC_DATAW1SnU(n).U = (v))
#define HW_FMC_DATAW1SnU_SET(n, v) (HW_FMC_DATAW1SnU_WR(n, HW_FMC_DATAW1SnU_RD(n) |  (v)))
#define HW_FMC_DATAW1SnU_CLR(n, v) (HW_FMC_DATAW1SnU_WR(n, HW_FMC_DATAW1SnU_RD(n) & ~(v)))
#define HW_FMC_DATAW1SnU_TOG(n, v) (HW_FMC_DATAW1SnU_WR(n, HW_FMC_DATAW1SnU_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FMC_DATAW1SnU bitfields
 */

/*!
 * @name Register FMC_DATAW1SnU, field data[31:0] (RW)
 */
//@{
#define BP_FMC_DATAW1SnU_data (0U)         //!< Bit position for FMC_DATAW1SnU_data.
#define BM_FMC_DATAW1SnU_data (0xFFFFFFFFU) //!< Bit mask for FMC_DATAW1SnU_data.
#define BS_FMC_DATAW1SnU_data (32U)        //!< Bit field size in bits for FMC_DATAW1SnU_data.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_DATAW1SnU_data field.
#define BR_FMC_DATAW1SnU_data(n) (HW_FMC_DATAW1SnU(n).U)
#endif

//! @brief Format value for bitfield FMC_DATAW1SnU_data.
#define BF_FMC_DATAW1SnU_data(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_DATAW1SnU_data), uint32_t) & BM_FMC_DATAW1SnU_data)

#ifndef __LANGUAGE_ASM__
//! @brief Set the data field to a new value.
#define BW_FMC_DATAW1SnU_data(n, v) (HW_FMC_DATAW1SnU_WR(n, v))
#endif
//@}
//-------------------------------------------------------------------------------------------
// HW_FMC_DATAW1SnL - Cache Data Storage (lower word)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FMC_DATAW1SnL - Cache Data Storage (lower word) (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache of 64-bit entries is a 4-way, set-associative cache with 4 sets.
 * The ways are numbered 0-3 and the sets are numbered 0-3. In DATAWxSyU and
 * DATAWxSyL, x denotes the way, y denotes the set, and U and L represent upper and
 * lower word, respectively. This section represents data for the lower word (bits
 * [31:0]) of all sets in the indicated way.
 */
typedef union _hw_fmc_dataw1snl
{
    uint32_t U;
    struct _hw_fmc_dataw1snl_bitfields
    {
        uint32_t data : 32;            //!< [31:0] Bits [31:0] of data entry
    } B;
} hw_fmc_dataw1snl_t;
#endif

/*!
 * @name Constants and macros for entire FMC_DATAW1SnL register
 */
//@{
#define HW_FMC_DATAW1SnL_COUNT (4U)

#define HW_FMC_DATAW1SnL_ADDR(n) (REGS_FMC_BASE + 0x224U + (0x8U * n))

#ifndef __LANGUAGE_ASM__
#define HW_FMC_DATAW1SnL(n)      (*(__IO hw_fmc_dataw1snl_t *) HW_FMC_DATAW1SnL_ADDR(n))
#define HW_FMC_DATAW1SnL_RD(n)   (HW_FMC_DATAW1SnL(n).U)
#define HW_FMC_DATAW1SnL_WR(n, v) (HW_FMC_DATAW1SnL(n).U = (v))
#define HW_FMC_DATAW1SnL_SET(n, v) (HW_FMC_DATAW1SnL_WR(n, HW_FMC_DATAW1SnL_RD(n) |  (v)))
#define HW_FMC_DATAW1SnL_CLR(n, v) (HW_FMC_DATAW1SnL_WR(n, HW_FMC_DATAW1SnL_RD(n) & ~(v)))
#define HW_FMC_DATAW1SnL_TOG(n, v) (HW_FMC_DATAW1SnL_WR(n, HW_FMC_DATAW1SnL_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FMC_DATAW1SnL bitfields
 */

/*!
 * @name Register FMC_DATAW1SnL, field data[31:0] (RW)
 */
//@{
#define BP_FMC_DATAW1SnL_data (0U)         //!< Bit position for FMC_DATAW1SnL_data.
#define BM_FMC_DATAW1SnL_data (0xFFFFFFFFU) //!< Bit mask for FMC_DATAW1SnL_data.
#define BS_FMC_DATAW1SnL_data (32U)        //!< Bit field size in bits for FMC_DATAW1SnL_data.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_DATAW1SnL_data field.
#define BR_FMC_DATAW1SnL_data(n) (HW_FMC_DATAW1SnL(n).U)
#endif

//! @brief Format value for bitfield FMC_DATAW1SnL_data.
#define BF_FMC_DATAW1SnL_data(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_DATAW1SnL_data), uint32_t) & BM_FMC_DATAW1SnL_data)

#ifndef __LANGUAGE_ASM__
//! @brief Set the data field to a new value.
#define BW_FMC_DATAW1SnL_data(n, v) (HW_FMC_DATAW1SnL_WR(n, v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FMC_DATAW2SnU - Cache Data Storage (upper word)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FMC_DATAW2SnU - Cache Data Storage (upper word) (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache of 64-bit entries is a 4-way, set-associative cache with 4 sets.
 * The ways are numbered 0-3 and the sets are numbered 0-3. In DATAWxSyU and
 * DATAWxSyL, x denotes the way, y denotes the set, and U and L represent upper and
 * lower word, respectively. This section represents data for the upper word (bits
 * [63:32]) of all sets in the indicated way.
 */
typedef union _hw_fmc_dataw2snu
{
    uint32_t U;
    struct _hw_fmc_dataw2snu_bitfields
    {
        uint32_t data : 32;            //!< [31:0] Bits [63:32] of data entry
    } B;
} hw_fmc_dataw2snu_t;
#endif

/*!
 * @name Constants and macros for entire FMC_DATAW2SnU register
 */
//@{
#define HW_FMC_DATAW2SnU_COUNT (4U)

#define HW_FMC_DATAW2SnU_ADDR(n) (REGS_FMC_BASE + 0x240U + (0x8U * n))

#ifndef __LANGUAGE_ASM__
#define HW_FMC_DATAW2SnU(n)      (*(__IO hw_fmc_dataw2snu_t *) HW_FMC_DATAW2SnU_ADDR(n))
#define HW_FMC_DATAW2SnU_RD(n)   (HW_FMC_DATAW2SnU(n).U)
#define HW_FMC_DATAW2SnU_WR(n, v) (HW_FMC_DATAW2SnU(n).U = (v))
#define HW_FMC_DATAW2SnU_SET(n, v) (HW_FMC_DATAW2SnU_WR(n, HW_FMC_DATAW2SnU_RD(n) |  (v)))
#define HW_FMC_DATAW2SnU_CLR(n, v) (HW_FMC_DATAW2SnU_WR(n, HW_FMC_DATAW2SnU_RD(n) & ~(v)))
#define HW_FMC_DATAW2SnU_TOG(n, v) (HW_FMC_DATAW2SnU_WR(n, HW_FMC_DATAW2SnU_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FMC_DATAW2SnU bitfields
 */

/*!
 * @name Register FMC_DATAW2SnU, field data[31:0] (RW)
 */
//@{
#define BP_FMC_DATAW2SnU_data (0U)         //!< Bit position for FMC_DATAW2SnU_data.
#define BM_FMC_DATAW2SnU_data (0xFFFFFFFFU) //!< Bit mask for FMC_DATAW2SnU_data.
#define BS_FMC_DATAW2SnU_data (32U)        //!< Bit field size in bits for FMC_DATAW2SnU_data.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_DATAW2SnU_data field.
#define BR_FMC_DATAW2SnU_data(n) (HW_FMC_DATAW2SnU(n).U)
#endif

//! @brief Format value for bitfield FMC_DATAW2SnU_data.
#define BF_FMC_DATAW2SnU_data(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_DATAW2SnU_data), uint32_t) & BM_FMC_DATAW2SnU_data)

#ifndef __LANGUAGE_ASM__
//! @brief Set the data field to a new value.
#define BW_FMC_DATAW2SnU_data(n, v) (HW_FMC_DATAW2SnU_WR(n, v))
#endif
//@}
//-------------------------------------------------------------------------------------------
// HW_FMC_DATAW2SnL - Cache Data Storage (lower word)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FMC_DATAW2SnL - Cache Data Storage (lower word) (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache of 64-bit entries is a 4-way, set-associative cache with 4 sets.
 * The ways are numbered 0-3 and the sets are numbered 0-3. In DATAWxSyU and
 * DATAWxSyL, x denotes the way, y denotes the set, and U and L represent upper and
 * lower word, respectively. This section represents data for the lower word (bits
 * [31:0]) of all sets in the indicated way.
 */
typedef union _hw_fmc_dataw2snl
{
    uint32_t U;
    struct _hw_fmc_dataw2snl_bitfields
    {
        uint32_t data : 32;            //!< [31:0] Bits [31:0] of data entry
    } B;
} hw_fmc_dataw2snl_t;
#endif

/*!
 * @name Constants and macros for entire FMC_DATAW2SnL register
 */
//@{
#define HW_FMC_DATAW2SnL_COUNT (4U)

#define HW_FMC_DATAW2SnL_ADDR(n) (REGS_FMC_BASE + 0x244U + (0x8U * n))

#ifndef __LANGUAGE_ASM__
#define HW_FMC_DATAW2SnL(n)      (*(__IO hw_fmc_dataw2snl_t *) HW_FMC_DATAW2SnL_ADDR(n))
#define HW_FMC_DATAW2SnL_RD(n)   (HW_FMC_DATAW2SnL(n).U)
#define HW_FMC_DATAW2SnL_WR(n, v) (HW_FMC_DATAW2SnL(n).U = (v))
#define HW_FMC_DATAW2SnL_SET(n, v) (HW_FMC_DATAW2SnL_WR(n, HW_FMC_DATAW2SnL_RD(n) |  (v)))
#define HW_FMC_DATAW2SnL_CLR(n, v) (HW_FMC_DATAW2SnL_WR(n, HW_FMC_DATAW2SnL_RD(n) & ~(v)))
#define HW_FMC_DATAW2SnL_TOG(n, v) (HW_FMC_DATAW2SnL_WR(n, HW_FMC_DATAW2SnL_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FMC_DATAW2SnL bitfields
 */

/*!
 * @name Register FMC_DATAW2SnL, field data[31:0] (RW)
 */
//@{
#define BP_FMC_DATAW2SnL_data (0U)         //!< Bit position for FMC_DATAW2SnL_data.
#define BM_FMC_DATAW2SnL_data (0xFFFFFFFFU) //!< Bit mask for FMC_DATAW2SnL_data.
#define BS_FMC_DATAW2SnL_data (32U)        //!< Bit field size in bits for FMC_DATAW2SnL_data.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_DATAW2SnL_data field.
#define BR_FMC_DATAW2SnL_data(n) (HW_FMC_DATAW2SnL(n).U)
#endif

//! @brief Format value for bitfield FMC_DATAW2SnL_data.
#define BF_FMC_DATAW2SnL_data(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_DATAW2SnL_data), uint32_t) & BM_FMC_DATAW2SnL_data)

#ifndef __LANGUAGE_ASM__
//! @brief Set the data field to a new value.
#define BW_FMC_DATAW2SnL_data(n, v) (HW_FMC_DATAW2SnL_WR(n, v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_FMC_DATAW3SnU - Cache Data Storage (upper word)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FMC_DATAW3SnU - Cache Data Storage (upper word) (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache of 64-bit entries is a 4-way, set-associative cache with 4 sets.
 * The ways are numbered 0-3 and the sets are numbered 0-3. In DATAWxSyU and
 * DATAWxSyL, x denotes the way, y denotes the set, and U and L represent upper and
 * lower word, respectively. This section represents data for the upper word (bits
 * [63:32]) of all sets in the indicated way.
 */
typedef union _hw_fmc_dataw3snu
{
    uint32_t U;
    struct _hw_fmc_dataw3snu_bitfields
    {
        uint32_t data : 32;            //!< [31:0] Bits [63:32] of data entry
    } B;
} hw_fmc_dataw3snu_t;
#endif

/*!
 * @name Constants and macros for entire FMC_DATAW3SnU register
 */
//@{
#define HW_FMC_DATAW3SnU_COUNT (4U)

#define HW_FMC_DATAW3SnU_ADDR(n) (REGS_FMC_BASE + 0x260U + (0x8U * n))

#ifndef __LANGUAGE_ASM__
#define HW_FMC_DATAW3SnU(n)      (*(__IO hw_fmc_dataw3snu_t *) HW_FMC_DATAW3SnU_ADDR(n))
#define HW_FMC_DATAW3SnU_RD(n)   (HW_FMC_DATAW3SnU(n).U)
#define HW_FMC_DATAW3SnU_WR(n, v) (HW_FMC_DATAW3SnU(n).U = (v))
#define HW_FMC_DATAW3SnU_SET(n, v) (HW_FMC_DATAW3SnU_WR(n, HW_FMC_DATAW3SnU_RD(n) |  (v)))
#define HW_FMC_DATAW3SnU_CLR(n, v) (HW_FMC_DATAW3SnU_WR(n, HW_FMC_DATAW3SnU_RD(n) & ~(v)))
#define HW_FMC_DATAW3SnU_TOG(n, v) (HW_FMC_DATAW3SnU_WR(n, HW_FMC_DATAW3SnU_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FMC_DATAW3SnU bitfields
 */

/*!
 * @name Register FMC_DATAW3SnU, field data[31:0] (RW)
 */
//@{
#define BP_FMC_DATAW3SnU_data (0U)         //!< Bit position for FMC_DATAW3SnU_data.
#define BM_FMC_DATAW3SnU_data (0xFFFFFFFFU) //!< Bit mask for FMC_DATAW3SnU_data.
#define BS_FMC_DATAW3SnU_data (32U)        //!< Bit field size in bits for FMC_DATAW3SnU_data.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_DATAW3SnU_data field.
#define BR_FMC_DATAW3SnU_data(n) (HW_FMC_DATAW3SnU(n).U)
#endif

//! @brief Format value for bitfield FMC_DATAW3SnU_data.
#define BF_FMC_DATAW3SnU_data(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_DATAW3SnU_data), uint32_t) & BM_FMC_DATAW3SnU_data)

#ifndef __LANGUAGE_ASM__
//! @brief Set the data field to a new value.
#define BW_FMC_DATAW3SnU_data(n, v) (HW_FMC_DATAW3SnU_WR(n, v))
#endif
//@}
//-------------------------------------------------------------------------------------------
// HW_FMC_DATAW3SnL - Cache Data Storage (lower word)
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_FMC_DATAW3SnL - Cache Data Storage (lower word) (RW)
 *
 * Reset value: 0x00000000U
 *
 * The cache of 64-bit entries is a 4-way, set-associative cache with 4 sets.
 * The ways are numbered 0-3 and the sets are numbered 0-3. In DATAWxSyU and
 * DATAWxSyL, x denotes the way, y denotes the set, and U and L represent upper and
 * lower word, respectively. This section represents data for the lower word (bits
 * [31:0]) of all sets in the indicated way.
 */
typedef union _hw_fmc_dataw3snl
{
    uint32_t U;
    struct _hw_fmc_dataw3snl_bitfields
    {
        uint32_t data : 32;            //!< [31:0] Bits [31:0] of data entry
    } B;
} hw_fmc_dataw3snl_t;
#endif

/*!
 * @name Constants and macros for entire FMC_DATAW3SnL register
 */
//@{
#define HW_FMC_DATAW3SnL_COUNT (4U)

#define HW_FMC_DATAW3SnL_ADDR(n) (REGS_FMC_BASE + 0x264U + (0x8U * n))

#ifndef __LANGUAGE_ASM__
#define HW_FMC_DATAW3SnL(n)      (*(__IO hw_fmc_dataw3snl_t *) HW_FMC_DATAW3SnL_ADDR(n))
#define HW_FMC_DATAW3SnL_RD(n)   (HW_FMC_DATAW3SnL(n).U)
#define HW_FMC_DATAW3SnL_WR(n, v) (HW_FMC_DATAW3SnL(n).U = (v))
#define HW_FMC_DATAW3SnL_SET(n, v) (HW_FMC_DATAW3SnL_WR(n, HW_FMC_DATAW3SnL_RD(n) |  (v)))
#define HW_FMC_DATAW3SnL_CLR(n, v) (HW_FMC_DATAW3SnL_WR(n, HW_FMC_DATAW3SnL_RD(n) & ~(v)))
#define HW_FMC_DATAW3SnL_TOG(n, v) (HW_FMC_DATAW3SnL_WR(n, HW_FMC_DATAW3SnL_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual FMC_DATAW3SnL bitfields
 */

/*!
 * @name Register FMC_DATAW3SnL, field data[31:0] (RW)
 */
//@{
#define BP_FMC_DATAW3SnL_data (0U)         //!< Bit position for FMC_DATAW3SnL_data.
#define BM_FMC_DATAW3SnL_data (0xFFFFFFFFU) //!< Bit mask for FMC_DATAW3SnL_data.
#define BS_FMC_DATAW3SnL_data (32U)        //!< Bit field size in bits for FMC_DATAW3SnL_data.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the FMC_DATAW3SnL_data field.
#define BR_FMC_DATAW3SnL_data(n) (HW_FMC_DATAW3SnL(n).U)
#endif

//! @brief Format value for bitfield FMC_DATAW3SnL_data.
#define BF_FMC_DATAW3SnL_data(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_FMC_DATAW3SnL_data), uint32_t) & BM_FMC_DATAW3SnL_data)

#ifndef __LANGUAGE_ASM__
//! @brief Set the data field to a new value.
#define BW_FMC_DATAW3SnL_data(n, v) (HW_FMC_DATAW3SnL_WR(n, v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_fmc_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All FMC module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_fmc
{
    __IO hw_fmc_pfapr_t PFAPR;             //!< [0x0] Flash Access Protection Register
    __IO hw_fmc_pfb0cr_t PFB0CR;           //!< [0x4] Flash Bank 0 Control Register
    __IO hw_fmc_pfb1cr_t PFB1CR;           //!< [0x8] Flash Bank 1 Control Register
    uint8_t _reserved0[244];
    __IO hw_fmc_tagvdw0sn_t TAGVDW0Sn[4];  //!< [0x100] Cache Tag Storage
    __IO hw_fmc_tagvdw1sn_t TAGVDW1Sn[4];  //!< [0x110] Cache Tag Storage
    __IO hw_fmc_tagvdw2sn_t TAGVDW2Sn[4];  //!< [0x120] Cache Tag Storage
    __IO hw_fmc_tagvdw3sn_t TAGVDW3Sn[4];  //!< [0x130] Cache Tag Storage
    uint8_t _reserved1[192];
    struct {
        __IO hw_fmc_dataw0snu_t DATAW0SnU; //!< [0x200] Cache Data Storage (upper word)
        __IO hw_fmc_dataw0snl_t DATAW0SnL; //!< [0x204] Cache Data Storage (lower word)
    } DATAW0Sn[4];
    struct {
        __IO hw_fmc_dataw1snu_t DATAW1SnU; //!< [0x220] Cache Data Storage (upper word)
        __IO hw_fmc_dataw1snl_t DATAW1SnL; //!< [0x224] Cache Data Storage (lower word)
    } DATAW1Sn[4];
    struct {
        __IO hw_fmc_dataw2snu_t DATAW2SnU; //!< [0x240] Cache Data Storage (upper word)
        __IO hw_fmc_dataw2snl_t DATAW2SnL; //!< [0x244] Cache Data Storage (lower word)
    } DATAW2Sn[4];
    struct {
        __IO hw_fmc_dataw3snu_t DATAW3SnU; //!< [0x260] Cache Data Storage (upper word)
        __IO hw_fmc_dataw3snl_t DATAW3SnL; //!< [0x264] Cache Data Storage (lower word)
    } DATAW3Sn[4];
} hw_fmc_t;
#pragma pack()

//! @brief Macro to access all FMC registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_FMC</code>.
#define HW_FMC         (*(hw_fmc_t *) REGS_FMC_BASE)
#endif

#endif // __HW_FMC_REGISTERS_H__
// v22/130726/0.9
// EOF

