/*
 * Copyright (c) 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_AXBS_REGISTERS_H__
#define __HW_AXBS_REGISTERS_H__

#include "regs.h"

/*
 * MK64F12 AXBS
 *
 * Crossbar switch
 *
 * Registers defined in this header file:
 * - HW_AXBS_PRSn - Priority Registers Slave
 * - HW_AXBS_CRSn - Control Register
 * - HW_AXBS_MGPCR0 - Master General Purpose Control Register
 * - HW_AXBS_MGPCR1 - Master General Purpose Control Register
 * - HW_AXBS_MGPCR2 - Master General Purpose Control Register
 * - HW_AXBS_MGPCR3 - Master General Purpose Control Register
 * - HW_AXBS_MGPCR4 - Master General Purpose Control Register
 * - HW_AXBS_MGPCR5 - Master General Purpose Control Register
 *
 * - hw_axbs_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_AXBS_BASE
#define HW_AXBS_INSTANCE_COUNT (1U) //!< Number of instances of the AXBS module.
#define REGS_AXBS_BASE (0x40004000U) //!< Base address for AXBS.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AXBS_PRSn - Priority Registers Slave
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AXBS_PRSn - Priority Registers Slave (RW)
 *
 * Reset value: 0x00543210U
 *
 * The priority registers (PRSn) set the priority of each master port on a per
 * slave port basis and reside in each slave port. The priority register can be
 * accessed only with 32-bit accesses. After the CRSn[RO] bit is set, the PRSn
 * register can only be read; attempts to write to it have no effect on PRSn and
 * result in a bus-error response to the master initiating the write. Two available
 * masters must not be programmed with the same priority level. Attempts to
 * program two or more masters with the same priority level result in a bus-error
 * response and the PRSn is not updated. Valid values for the Mn priority fields
 * depend on which masters are available on the chip. This information can be found in
 * the chip-specific information for the crossbar. If the chip contains less
 * than five masters, values 0 to 3 are valid. Writing other values will result in
 * an error. If the chip contains five or more masters, valid values are 0 to n-1,
 * where n is the number of masters attached to the AXBS module. Other values
 * will result in an error.
 */
typedef union _hw_axbs_prsn
{
    uint32_t U;
    struct _hw_axbs_prsn_bitfields
    {
        uint32_t M0 : 3;               //!< [2:0] Master 0 Priority. Sets the arbitration
                                       //! priority for this port on the associated slave port.
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t M1 : 3;               //!< [6:4] Master 1 Priority. Sets the arbitration
                                       //! priority for this port on the associated slave port.
        uint32_t RESERVED1 : 1;        //!< [7]
        uint32_t M2 : 3;               //!< [10:8] Master 2 Priority. Sets the arbitration
                                       //! priority for this port on the associated slave port.
        uint32_t RESERVED2 : 1;        //!< [11]
        uint32_t M3 : 3;               //!< [14:12] Master 3 Priority. Sets the arbitration
                                       //! priority for this port on the associated slave port.
        uint32_t RESERVED3 : 1;        //!< [15]
        uint32_t M4 : 3;               //!< [18:16] Master 4 Priority. Sets the arbitration
                                       //! priority for this port on the associated slave port.
        uint32_t RESERVED4 : 1;        //!< [19]
        uint32_t M5 : 3;               //!< [22:20] Master 5 Priority. Sets the arbitration
                                       //! priority for this port on the associated slave port.
        uint32_t RESERVED5 : 9;        //!< [31:23]
    } B;
} hw_axbs_prsn_t;
#endif

/*!
 * @name Constants and macros for entire AXBS_PRSn register
 */
//@{
#define HW_AXBS_PRSn_COUNT (5U)

#define HW_AXBS_PRSn_ADDR(n)     (REGS_AXBS_BASE + 0x0U + (0x100U * n))

#ifndef __LANGUAGE_ASM__
#define HW_AXBS_PRSn(n)          (*(__IO hw_axbs_prsn_t *) HW_AXBS_PRSn_ADDR(n))
#define HW_AXBS_PRSn_RD(n)       (HW_AXBS_PRSn(n).U)
#define HW_AXBS_PRSn_WR(n, v)    (HW_AXBS_PRSn(n).U = (v))
#define HW_AXBS_PRSn_SET(n, v)   (HW_AXBS_PRSn_WR(n, HW_AXBS_PRSn_RD(n) |  (v)))
#define HW_AXBS_PRSn_CLR(n, v)   (HW_AXBS_PRSn_WR(n, HW_AXBS_PRSn_RD(n) & ~(v)))
#define HW_AXBS_PRSn_TOG(n, v)   (HW_AXBS_PRSn_WR(n, HW_AXBS_PRSn_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AXBS_PRSn bitfields
 */

/*!
 * @name Register AXBS_PRSn, field M0[2:0] (RW)
 *
 * Values:
 * - 000 - This master has level 1, or highest, priority when accessing the
 *     slave port.
 * - 001 - This master has level 2 priority when accessing the slave port.
 * - 010 - This master has level 3 priority when accessing the slave port.
 * - 011 - This master has level 4 priority when accessing the slave port.
 * - 100 - This master has level 5 priority when accessing the slave port.
 * - 101 - This master has level 6 priority when accessing the slave port.
 * - 110 - This master has level 7 priority when accessing the slave port.
 * - 111 - This master has level 8, or lowest, priority when accessing the slave
 *     port.
 */
//@{
#define BP_AXBS_PRSn_M0      (0U)          //!< Bit position for AXBS_PRSn_M0.
#define BM_AXBS_PRSn_M0      (0x00000007U) //!< Bit mask for AXBS_PRSn_M0.
#define BS_AXBS_PRSn_M0      (3U)          //!< Bit field size in bits for AXBS_PRSn_M0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AXBS_PRSn_M0 field.
#define BR_AXBS_PRSn_M0(n)   (HW_AXBS_PRSn(n).B.M0)
#endif

//! @brief Format value for bitfield AXBS_PRSn_M0.
#define BF_AXBS_PRSn_M0(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AXBS_PRSn_M0), uint32_t) & BM_AXBS_PRSn_M0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M0 field to a new value.
#define BW_AXBS_PRSn_M0(n, v) (HW_AXBS_PRSn_WR(n, (HW_AXBS_PRSn_RD(n) & ~BM_AXBS_PRSn_M0) | BF_AXBS_PRSn_M0(v)))
#endif
//@}

/*!
 * @name Register AXBS_PRSn, field M1[6:4] (RW)
 *
 * Values:
 * - 000 - This master has level 1, or highest, priority when accessing the
 *     slave port.
 * - 001 - This master has level 2 priority when accessing the slave port.
 * - 010 - This master has level 3 priority when accessing the slave port.
 * - 011 - This master has level 4 priority when accessing the slave port.
 * - 100 - This master has level 5 priority when accessing the slave port.
 * - 101 - This master has level 6 priority when accessing the slave port.
 * - 110 - This master has level 7 priority when accessing the slave port.
 * - 111 - This master has level 8, or lowest, priority when accessing the slave
 *     port.
 */
//@{
#define BP_AXBS_PRSn_M1      (4U)          //!< Bit position for AXBS_PRSn_M1.
#define BM_AXBS_PRSn_M1      (0x00000070U) //!< Bit mask for AXBS_PRSn_M1.
#define BS_AXBS_PRSn_M1      (3U)          //!< Bit field size in bits for AXBS_PRSn_M1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AXBS_PRSn_M1 field.
#define BR_AXBS_PRSn_M1(n)   (HW_AXBS_PRSn(n).B.M1)
#endif

//! @brief Format value for bitfield AXBS_PRSn_M1.
#define BF_AXBS_PRSn_M1(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AXBS_PRSn_M1), uint32_t) & BM_AXBS_PRSn_M1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M1 field to a new value.
#define BW_AXBS_PRSn_M1(n, v) (HW_AXBS_PRSn_WR(n, (HW_AXBS_PRSn_RD(n) & ~BM_AXBS_PRSn_M1) | BF_AXBS_PRSn_M1(v)))
#endif
//@}

/*!
 * @name Register AXBS_PRSn, field M2[10:8] (RW)
 *
 * Values:
 * - 000 - This master has level 1, or highest, priority when accessing the
 *     slave port.
 * - 001 - This master has level 2 priority when accessing the slave port.
 * - 010 - This master has level 3 priority when accessing the slave port.
 * - 011 - This master has level 4 priority when accessing the slave port.
 * - 100 - This master has level 5 priority when accessing the slave port.
 * - 101 - This master has level 6 priority when accessing the slave port.
 * - 110 - This master has level 7 priority when accessing the slave port.
 * - 111 - This master has level 8, or lowest, priority when accessing the slave
 *     port.
 */
//@{
#define BP_AXBS_PRSn_M2      (8U)          //!< Bit position for AXBS_PRSn_M2.
#define BM_AXBS_PRSn_M2      (0x00000700U) //!< Bit mask for AXBS_PRSn_M2.
#define BS_AXBS_PRSn_M2      (3U)          //!< Bit field size in bits for AXBS_PRSn_M2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AXBS_PRSn_M2 field.
#define BR_AXBS_PRSn_M2(n)   (HW_AXBS_PRSn(n).B.M2)
#endif

//! @brief Format value for bitfield AXBS_PRSn_M2.
#define BF_AXBS_PRSn_M2(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AXBS_PRSn_M2), uint32_t) & BM_AXBS_PRSn_M2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M2 field to a new value.
#define BW_AXBS_PRSn_M2(n, v) (HW_AXBS_PRSn_WR(n, (HW_AXBS_PRSn_RD(n) & ~BM_AXBS_PRSn_M2) | BF_AXBS_PRSn_M2(v)))
#endif
//@}

/*!
 * @name Register AXBS_PRSn, field M3[14:12] (RW)
 *
 * Values:
 * - 000 - This master has level 1, or highest, priority when accessing the
 *     slave port.
 * - 001 - This master has level 2 priority when accessing the slave port.
 * - 010 - This master has level 3 priority when accessing the slave port.
 * - 011 - This master has level 4 priority when accessing the slave port.
 * - 100 - This master has level 5 priority when accessing the slave port.
 * - 101 - This master has level 6 priority when accessing the slave port.
 * - 110 - This master has level 7 priority when accessing the slave port.
 * - 111 - This master has level 8, or lowest, priority when accessing the slave
 *     port.
 */
//@{
#define BP_AXBS_PRSn_M3      (12U)         //!< Bit position for AXBS_PRSn_M3.
#define BM_AXBS_PRSn_M3      (0x00007000U) //!< Bit mask for AXBS_PRSn_M3.
#define BS_AXBS_PRSn_M3      (3U)          //!< Bit field size in bits for AXBS_PRSn_M3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AXBS_PRSn_M3 field.
#define BR_AXBS_PRSn_M3(n)   (HW_AXBS_PRSn(n).B.M3)
#endif

//! @brief Format value for bitfield AXBS_PRSn_M3.
#define BF_AXBS_PRSn_M3(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AXBS_PRSn_M3), uint32_t) & BM_AXBS_PRSn_M3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M3 field to a new value.
#define BW_AXBS_PRSn_M3(n, v) (HW_AXBS_PRSn_WR(n, (HW_AXBS_PRSn_RD(n) & ~BM_AXBS_PRSn_M3) | BF_AXBS_PRSn_M3(v)))
#endif
//@}

/*!
 * @name Register AXBS_PRSn, field M4[18:16] (RW)
 *
 * Values:
 * - 000 - This master has level 1, or highest, priority when accessing the
 *     slave port.
 * - 001 - This master has level 2 priority when accessing the slave port.
 * - 010 - This master has level 3 priority when accessing the slave port.
 * - 011 - This master has level 4 priority when accessing the slave port.
 * - 100 - This master has level 5 priority when accessing the slave port.
 * - 101 - This master has level 6 priority when accessing the slave port.
 * - 110 - This master has level 7 priority when accessing the slave port.
 * - 111 - This master has level 8, or lowest, priority when accessing the slave
 *     port.
 */
//@{
#define BP_AXBS_PRSn_M4      (16U)         //!< Bit position for AXBS_PRSn_M4.
#define BM_AXBS_PRSn_M4      (0x00070000U) //!< Bit mask for AXBS_PRSn_M4.
#define BS_AXBS_PRSn_M4      (3U)          //!< Bit field size in bits for AXBS_PRSn_M4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AXBS_PRSn_M4 field.
#define BR_AXBS_PRSn_M4(n)   (HW_AXBS_PRSn(n).B.M4)
#endif

//! @brief Format value for bitfield AXBS_PRSn_M4.
#define BF_AXBS_PRSn_M4(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AXBS_PRSn_M4), uint32_t) & BM_AXBS_PRSn_M4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M4 field to a new value.
#define BW_AXBS_PRSn_M4(n, v) (HW_AXBS_PRSn_WR(n, (HW_AXBS_PRSn_RD(n) & ~BM_AXBS_PRSn_M4) | BF_AXBS_PRSn_M4(v)))
#endif
//@}

/*!
 * @name Register AXBS_PRSn, field M5[22:20] (RW)
 *
 * Values:
 * - 000 - This master has level 1, or highest, priority when accessing the
 *     slave port.
 * - 001 - This master has level 2 priority when accessing the slave port.
 * - 010 - This master has level 3 priority when accessing the slave port.
 * - 011 - This master has level 4 priority when accessing the slave port.
 * - 100 - This master has level 5 priority when accessing the slave port.
 * - 101 - This master has level 6 priority when accessing the slave port.
 * - 110 - This master has level 7 priority when accessing the slave port.
 * - 111 - This master has level 8, or lowest, priority when accessing the slave
 *     port.
 */
//@{
#define BP_AXBS_PRSn_M5      (20U)         //!< Bit position for AXBS_PRSn_M5.
#define BM_AXBS_PRSn_M5      (0x00700000U) //!< Bit mask for AXBS_PRSn_M5.
#define BS_AXBS_PRSn_M5      (3U)          //!< Bit field size in bits for AXBS_PRSn_M5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AXBS_PRSn_M5 field.
#define BR_AXBS_PRSn_M5(n)   (HW_AXBS_PRSn(n).B.M5)
#endif

//! @brief Format value for bitfield AXBS_PRSn_M5.
#define BF_AXBS_PRSn_M5(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AXBS_PRSn_M5), uint32_t) & BM_AXBS_PRSn_M5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M5 field to a new value.
#define BW_AXBS_PRSn_M5(n, v) (HW_AXBS_PRSn_WR(n, (HW_AXBS_PRSn_RD(n) & ~BM_AXBS_PRSn_M5) | BF_AXBS_PRSn_M5(v)))
#endif
//@}
//-------------------------------------------------------------------------------------------
// HW_AXBS_CRSn - Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AXBS_CRSn - Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * These registers control several features of each slave port and must be
 * accessed using 32-bit accesses. After CRSn[RO] is set, the PRSn can only be read;
 * attempts to write to it have no effect and result in an error response.
 */
typedef union _hw_axbs_crsn
{
    uint32_t U;
    struct _hw_axbs_crsn_bitfields
    {
        uint32_t PARK : 3;             //!< [2:0] Park
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t PCTL : 2;             //!< [5:4] Parking Control
        uint32_t RESERVED1 : 2;        //!< [7:6]
        uint32_t ARB : 2;              //!< [9:8] Arbitration Mode
        uint32_t RESERVED2 : 20;       //!< [29:10]
        uint32_t HLP : 1;              //!< [30] Halt Low Priority
        uint32_t RO : 1;               //!< [31] Read Only
    } B;
} hw_axbs_crsn_t;
#endif

/*!
 * @name Constants and macros for entire AXBS_CRSn register
 */
//@{
#define HW_AXBS_CRSn_COUNT (5U)

#define HW_AXBS_CRSn_ADDR(n)     (REGS_AXBS_BASE + 0x10U + (0x100U * n))

#ifndef __LANGUAGE_ASM__
#define HW_AXBS_CRSn(n)          (*(__IO hw_axbs_crsn_t *) HW_AXBS_CRSn_ADDR(n))
#define HW_AXBS_CRSn_RD(n)       (HW_AXBS_CRSn(n).U)
#define HW_AXBS_CRSn_WR(n, v)    (HW_AXBS_CRSn(n).U = (v))
#define HW_AXBS_CRSn_SET(n, v)   (HW_AXBS_CRSn_WR(n, HW_AXBS_CRSn_RD(n) |  (v)))
#define HW_AXBS_CRSn_CLR(n, v)   (HW_AXBS_CRSn_WR(n, HW_AXBS_CRSn_RD(n) & ~(v)))
#define HW_AXBS_CRSn_TOG(n, v)   (HW_AXBS_CRSn_WR(n, HW_AXBS_CRSn_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AXBS_CRSn bitfields
 */

/*!
 * @name Register AXBS_CRSn, field PARK[2:0] (RW)
 *
 * Determines which master port the current slave port parks on when no masters
 * are actively making requests and the PCTL bits are cleared. Select only master
 * ports that are present on the chip. Otherwise, undefined behavior might occur.
 *
 * Values:
 * - 000 - Park on master port M0
 * - 001 - Park on master port M1
 * - 010 - Park on master port M2
 * - 011 - Park on master port M3
 * - 100 - Park on master port M4
 * - 101 - Park on master port M5
 * - 110 - Park on master port M6
 * - 111 - Park on master port M7
 */
//@{
#define BP_AXBS_CRSn_PARK    (0U)          //!< Bit position for AXBS_CRSn_PARK.
#define BM_AXBS_CRSn_PARK    (0x00000007U) //!< Bit mask for AXBS_CRSn_PARK.
#define BS_AXBS_CRSn_PARK    (3U)          //!< Bit field size in bits for AXBS_CRSn_PARK.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AXBS_CRSn_PARK field.
#define BR_AXBS_CRSn_PARK(n) (HW_AXBS_CRSn(n).B.PARK)
#endif

//! @brief Format value for bitfield AXBS_CRSn_PARK.
#define BF_AXBS_CRSn_PARK(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AXBS_CRSn_PARK), uint32_t) & BM_AXBS_CRSn_PARK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PARK field to a new value.
#define BW_AXBS_CRSn_PARK(n, v) (HW_AXBS_CRSn_WR(n, (HW_AXBS_CRSn_RD(n) & ~BM_AXBS_CRSn_PARK) | BF_AXBS_CRSn_PARK(v)))
#endif
//@}

/*!
 * @name Register AXBS_CRSn, field PCTL[5:4] (RW)
 *
 * Determines the slave port's parking control. The low-power park feature
 * results in an overall power savings if the slave port is not saturated. However,
 * this forces an extra latency clock when any master tries to access the slave
 * port while not in use because it is not parked on any master.
 *
 * Values:
 * - 00 - When no master makes a request, the arbiter parks the slave port on
 *     the master port defined by the PARK field
 * - 01 - When no master makes a request, the arbiter parks the slave port on
 *     the last master to be in control of the slave port
 * - 10 - When no master makes a request, the slave port is not parked on a
 *     master and the arbiter drives all outputs to a constant safe state
 * - 11 - Reserved
 */
//@{
#define BP_AXBS_CRSn_PCTL    (4U)          //!< Bit position for AXBS_CRSn_PCTL.
#define BM_AXBS_CRSn_PCTL    (0x00000030U) //!< Bit mask for AXBS_CRSn_PCTL.
#define BS_AXBS_CRSn_PCTL    (2U)          //!< Bit field size in bits for AXBS_CRSn_PCTL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AXBS_CRSn_PCTL field.
#define BR_AXBS_CRSn_PCTL(n) (HW_AXBS_CRSn(n).B.PCTL)
#endif

//! @brief Format value for bitfield AXBS_CRSn_PCTL.
#define BF_AXBS_CRSn_PCTL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AXBS_CRSn_PCTL), uint32_t) & BM_AXBS_CRSn_PCTL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PCTL field to a new value.
#define BW_AXBS_CRSn_PCTL(n, v) (HW_AXBS_CRSn_WR(n, (HW_AXBS_CRSn_RD(n) & ~BM_AXBS_CRSn_PCTL) | BF_AXBS_CRSn_PCTL(v)))
#endif
//@}

/*!
 * @name Register AXBS_CRSn, field ARB[9:8] (RW)
 *
 * Selects the arbitration policy for the slave port.
 *
 * Values:
 * - 00 - Fixed priority
 * - 01 - Round-robin, or rotating, priority
 * - 10 - Reserved
 * - 11 - Reserved
 */
//@{
#define BP_AXBS_CRSn_ARB     (8U)          //!< Bit position for AXBS_CRSn_ARB.
#define BM_AXBS_CRSn_ARB     (0x00000300U) //!< Bit mask for AXBS_CRSn_ARB.
#define BS_AXBS_CRSn_ARB     (2U)          //!< Bit field size in bits for AXBS_CRSn_ARB.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AXBS_CRSn_ARB field.
#define BR_AXBS_CRSn_ARB(n)  (HW_AXBS_CRSn(n).B.ARB)
#endif

//! @brief Format value for bitfield AXBS_CRSn_ARB.
#define BF_AXBS_CRSn_ARB(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AXBS_CRSn_ARB), uint32_t) & BM_AXBS_CRSn_ARB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ARB field to a new value.
#define BW_AXBS_CRSn_ARB(n, v) (HW_AXBS_CRSn_WR(n, (HW_AXBS_CRSn_RD(n) & ~BM_AXBS_CRSn_ARB) | BF_AXBS_CRSn_ARB(v)))
#endif
//@}

/*!
 * @name Register AXBS_CRSn, field HLP[30] (RW)
 *
 * Sets the initial arbitration priority for low power mode requests . Setting
 * this bit will not affect the request for low power mode from attaining highest
 * priority once it has control of the slave ports.
 *
 * Values:
 * - 0 - The low power mode request has the highest priority for arbitration on
 *     this slave port
 * - 1 - The low power mode request has the lowest initial priority for
 *     arbitration on this slave port
 */
//@{
#define BP_AXBS_CRSn_HLP     (30U)         //!< Bit position for AXBS_CRSn_HLP.
#define BM_AXBS_CRSn_HLP     (0x40000000U) //!< Bit mask for AXBS_CRSn_HLP.
#define BS_AXBS_CRSn_HLP     (1U)          //!< Bit field size in bits for AXBS_CRSn_HLP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AXBS_CRSn_HLP field.
#define BR_AXBS_CRSn_HLP(n)  (BITBAND_ACCESS32(HW_AXBS_CRSn_ADDR(n), BP_AXBS_CRSn_HLP))
#endif

//! @brief Format value for bitfield AXBS_CRSn_HLP.
#define BF_AXBS_CRSn_HLP(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AXBS_CRSn_HLP), uint32_t) & BM_AXBS_CRSn_HLP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HLP field to a new value.
#define BW_AXBS_CRSn_HLP(n, v) (BITBAND_ACCESS32(HW_AXBS_CRSn_ADDR(n), BP_AXBS_CRSn_HLP) = (v))
#endif
//@}

/*!
 * @name Register AXBS_CRSn, field RO[31] (RW)
 *
 * Forces the slave port's CSRn and PRSn registers to be read-only. After set,
 * only a hardware reset clears it.
 *
 * Values:
 * - 0 - The slave port's registers are writeable
 * - 1 - The slave port's registers are read-only and cannot be written.
 *     Attempted writes have no effect on the registers and result in a bus error
 *     response.
 */
//@{
#define BP_AXBS_CRSn_RO      (31U)         //!< Bit position for AXBS_CRSn_RO.
#define BM_AXBS_CRSn_RO      (0x80000000U) //!< Bit mask for AXBS_CRSn_RO.
#define BS_AXBS_CRSn_RO      (1U)          //!< Bit field size in bits for AXBS_CRSn_RO.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AXBS_CRSn_RO field.
#define BR_AXBS_CRSn_RO(n)   (BITBAND_ACCESS32(HW_AXBS_CRSn_ADDR(n), BP_AXBS_CRSn_RO))
#endif

//! @brief Format value for bitfield AXBS_CRSn_RO.
#define BF_AXBS_CRSn_RO(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AXBS_CRSn_RO), uint32_t) & BM_AXBS_CRSn_RO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RO field to a new value.
#define BW_AXBS_CRSn_RO(n, v) (BITBAND_ACCESS32(HW_AXBS_CRSn_ADDR(n), BP_AXBS_CRSn_RO) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AXBS_MGPCR0 - Master General Purpose Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AXBS_MGPCR0 - Master General Purpose Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MGPCR controls only whether the master's undefined length burst accesses
 * are allowed to complete uninterrupted or whether they can be broken by
 * requests from higher priority masters. The MGPCR can be accessed only in Supervisor
 * mode with 32-bit accesses.
 */
typedef union _hw_axbs_mgpcr0
{
    uint32_t U;
    struct _hw_axbs_mgpcr0_bitfields
    {
        uint32_t AULB : 3;             //!< [2:0] Arbitrates On Undefined Length Bursts
        uint32_t RESERVED0 : 29;       //!< [31:3]
    } B;
} hw_axbs_mgpcr0_t;
#endif

/*!
 * @name Constants and macros for entire AXBS_MGPCR0 register
 */
//@{
#define HW_AXBS_MGPCR0_ADDR      (REGS_AXBS_BASE + 0x800U)

#ifndef __LANGUAGE_ASM__
#define HW_AXBS_MGPCR0           (*(__IO hw_axbs_mgpcr0_t *) HW_AXBS_MGPCR0_ADDR)
#define HW_AXBS_MGPCR0_RD()      (HW_AXBS_MGPCR0.U)
#define HW_AXBS_MGPCR0_WR(v)     (HW_AXBS_MGPCR0.U = (v))
#define HW_AXBS_MGPCR0_SET(v)    (HW_AXBS_MGPCR0_WR(HW_AXBS_MGPCR0_RD() |  (v)))
#define HW_AXBS_MGPCR0_CLR(v)    (HW_AXBS_MGPCR0_WR(HW_AXBS_MGPCR0_RD() & ~(v)))
#define HW_AXBS_MGPCR0_TOG(v)    (HW_AXBS_MGPCR0_WR(HW_AXBS_MGPCR0_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AXBS_MGPCR0 bitfields
 */

/*!
 * @name Register AXBS_MGPCR0, field AULB[2:0] (RW)
 *
 * Determines whether, and when, the crossbar switch arbitrates away the slave
 * port the master owns when the master is performing undefined length burst
 * accesses.
 *
 * Values:
 * - 000 - No arbitration is allowed during an undefined length burst
 * - 001 - Arbitration is allowed at any time during an undefined length burst
 * - 010 - Arbitration is allowed after four beats of an undefined length burst
 * - 011 - Arbitration is allowed after eight beats of an undefined length burst
 * - 100 - Arbitration is allowed after 16 beats of an undefined length burst
 * - 101 - Reserved
 * - 110 - Reserved
 * - 111 - Reserved
 */
//@{
#define BP_AXBS_MGPCR0_AULB  (0U)          //!< Bit position for AXBS_MGPCR0_AULB.
#define BM_AXBS_MGPCR0_AULB  (0x00000007U) //!< Bit mask for AXBS_MGPCR0_AULB.
#define BS_AXBS_MGPCR0_AULB  (3U)          //!< Bit field size in bits for AXBS_MGPCR0_AULB.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AXBS_MGPCR0_AULB field.
#define BR_AXBS_MGPCR0_AULB  (HW_AXBS_MGPCR0.B.AULB)
#endif

//! @brief Format value for bitfield AXBS_MGPCR0_AULB.
#define BF_AXBS_MGPCR0_AULB(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AXBS_MGPCR0_AULB), uint32_t) & BM_AXBS_MGPCR0_AULB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AULB field to a new value.
#define BW_AXBS_MGPCR0_AULB(v) (HW_AXBS_MGPCR0_WR((HW_AXBS_MGPCR0_RD() & ~BM_AXBS_MGPCR0_AULB) | BF_AXBS_MGPCR0_AULB(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AXBS_MGPCR1 - Master General Purpose Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AXBS_MGPCR1 - Master General Purpose Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MGPCR controls only whether the master's undefined length burst accesses
 * are allowed to complete uninterrupted or whether they can be broken by
 * requests from higher priority masters. The MGPCR can be accessed only in Supervisor
 * mode with 32-bit accesses.
 */
typedef union _hw_axbs_mgpcr1
{
    uint32_t U;
    struct _hw_axbs_mgpcr1_bitfields
    {
        uint32_t AULB : 3;             //!< [2:0] Arbitrates On Undefined Length Bursts
        uint32_t RESERVED0 : 29;       //!< [31:3]
    } B;
} hw_axbs_mgpcr1_t;
#endif

/*!
 * @name Constants and macros for entire AXBS_MGPCR1 register
 */
//@{
#define HW_AXBS_MGPCR1_ADDR      (REGS_AXBS_BASE + 0x900U)

#ifndef __LANGUAGE_ASM__
#define HW_AXBS_MGPCR1           (*(__IO hw_axbs_mgpcr1_t *) HW_AXBS_MGPCR1_ADDR)
#define HW_AXBS_MGPCR1_RD()      (HW_AXBS_MGPCR1.U)
#define HW_AXBS_MGPCR1_WR(v)     (HW_AXBS_MGPCR1.U = (v))
#define HW_AXBS_MGPCR1_SET(v)    (HW_AXBS_MGPCR1_WR(HW_AXBS_MGPCR1_RD() |  (v)))
#define HW_AXBS_MGPCR1_CLR(v)    (HW_AXBS_MGPCR1_WR(HW_AXBS_MGPCR1_RD() & ~(v)))
#define HW_AXBS_MGPCR1_TOG(v)    (HW_AXBS_MGPCR1_WR(HW_AXBS_MGPCR1_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AXBS_MGPCR1 bitfields
 */

/*!
 * @name Register AXBS_MGPCR1, field AULB[2:0] (RW)
 *
 * Determines whether, and when, the crossbar switch arbitrates away the slave
 * port the master owns when the master is performing undefined length burst
 * accesses.
 *
 * Values:
 * - 000 - No arbitration is allowed during an undefined length burst
 * - 001 - Arbitration is allowed at any time during an undefined length burst
 * - 010 - Arbitration is allowed after four beats of an undefined length burst
 * - 011 - Arbitration is allowed after eight beats of an undefined length burst
 * - 100 - Arbitration is allowed after 16 beats of an undefined length burst
 * - 101 - Reserved
 * - 110 - Reserved
 * - 111 - Reserved
 */
//@{
#define BP_AXBS_MGPCR1_AULB  (0U)          //!< Bit position for AXBS_MGPCR1_AULB.
#define BM_AXBS_MGPCR1_AULB  (0x00000007U) //!< Bit mask for AXBS_MGPCR1_AULB.
#define BS_AXBS_MGPCR1_AULB  (3U)          //!< Bit field size in bits for AXBS_MGPCR1_AULB.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AXBS_MGPCR1_AULB field.
#define BR_AXBS_MGPCR1_AULB  (HW_AXBS_MGPCR1.B.AULB)
#endif

//! @brief Format value for bitfield AXBS_MGPCR1_AULB.
#define BF_AXBS_MGPCR1_AULB(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AXBS_MGPCR1_AULB), uint32_t) & BM_AXBS_MGPCR1_AULB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AULB field to a new value.
#define BW_AXBS_MGPCR1_AULB(v) (HW_AXBS_MGPCR1_WR((HW_AXBS_MGPCR1_RD() & ~BM_AXBS_MGPCR1_AULB) | BF_AXBS_MGPCR1_AULB(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AXBS_MGPCR2 - Master General Purpose Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AXBS_MGPCR2 - Master General Purpose Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MGPCR controls only whether the master's undefined length burst accesses
 * are allowed to complete uninterrupted or whether they can be broken by
 * requests from higher priority masters. The MGPCR can be accessed only in Supervisor
 * mode with 32-bit accesses.
 */
typedef union _hw_axbs_mgpcr2
{
    uint32_t U;
    struct _hw_axbs_mgpcr2_bitfields
    {
        uint32_t AULB : 3;             //!< [2:0] Arbitrates On Undefined Length Bursts
        uint32_t RESERVED0 : 29;       //!< [31:3]
    } B;
} hw_axbs_mgpcr2_t;
#endif

/*!
 * @name Constants and macros for entire AXBS_MGPCR2 register
 */
//@{
#define HW_AXBS_MGPCR2_ADDR      (REGS_AXBS_BASE + 0xA00U)

#ifndef __LANGUAGE_ASM__
#define HW_AXBS_MGPCR2           (*(__IO hw_axbs_mgpcr2_t *) HW_AXBS_MGPCR2_ADDR)
#define HW_AXBS_MGPCR2_RD()      (HW_AXBS_MGPCR2.U)
#define HW_AXBS_MGPCR2_WR(v)     (HW_AXBS_MGPCR2.U = (v))
#define HW_AXBS_MGPCR2_SET(v)    (HW_AXBS_MGPCR2_WR(HW_AXBS_MGPCR2_RD() |  (v)))
#define HW_AXBS_MGPCR2_CLR(v)    (HW_AXBS_MGPCR2_WR(HW_AXBS_MGPCR2_RD() & ~(v)))
#define HW_AXBS_MGPCR2_TOG(v)    (HW_AXBS_MGPCR2_WR(HW_AXBS_MGPCR2_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AXBS_MGPCR2 bitfields
 */

/*!
 * @name Register AXBS_MGPCR2, field AULB[2:0] (RW)
 *
 * Determines whether, and when, the crossbar switch arbitrates away the slave
 * port the master owns when the master is performing undefined length burst
 * accesses.
 *
 * Values:
 * - 000 - No arbitration is allowed during an undefined length burst
 * - 001 - Arbitration is allowed at any time during an undefined length burst
 * - 010 - Arbitration is allowed after four beats of an undefined length burst
 * - 011 - Arbitration is allowed after eight beats of an undefined length burst
 * - 100 - Arbitration is allowed after 16 beats of an undefined length burst
 * - 101 - Reserved
 * - 110 - Reserved
 * - 111 - Reserved
 */
//@{
#define BP_AXBS_MGPCR2_AULB  (0U)          //!< Bit position for AXBS_MGPCR2_AULB.
#define BM_AXBS_MGPCR2_AULB  (0x00000007U) //!< Bit mask for AXBS_MGPCR2_AULB.
#define BS_AXBS_MGPCR2_AULB  (3U)          //!< Bit field size in bits for AXBS_MGPCR2_AULB.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AXBS_MGPCR2_AULB field.
#define BR_AXBS_MGPCR2_AULB  (HW_AXBS_MGPCR2.B.AULB)
#endif

//! @brief Format value for bitfield AXBS_MGPCR2_AULB.
#define BF_AXBS_MGPCR2_AULB(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AXBS_MGPCR2_AULB), uint32_t) & BM_AXBS_MGPCR2_AULB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AULB field to a new value.
#define BW_AXBS_MGPCR2_AULB(v) (HW_AXBS_MGPCR2_WR((HW_AXBS_MGPCR2_RD() & ~BM_AXBS_MGPCR2_AULB) | BF_AXBS_MGPCR2_AULB(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AXBS_MGPCR3 - Master General Purpose Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AXBS_MGPCR3 - Master General Purpose Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MGPCR controls only whether the master's undefined length burst accesses
 * are allowed to complete uninterrupted or whether they can be broken by
 * requests from higher priority masters. The MGPCR can be accessed only in Supervisor
 * mode with 32-bit accesses.
 */
typedef union _hw_axbs_mgpcr3
{
    uint32_t U;
    struct _hw_axbs_mgpcr3_bitfields
    {
        uint32_t AULB : 3;             //!< [2:0] Arbitrates On Undefined Length Bursts
        uint32_t RESERVED0 : 29;       //!< [31:3]
    } B;
} hw_axbs_mgpcr3_t;
#endif

/*!
 * @name Constants and macros for entire AXBS_MGPCR3 register
 */
//@{
#define HW_AXBS_MGPCR3_ADDR      (REGS_AXBS_BASE + 0xB00U)

#ifndef __LANGUAGE_ASM__
#define HW_AXBS_MGPCR3           (*(__IO hw_axbs_mgpcr3_t *) HW_AXBS_MGPCR3_ADDR)
#define HW_AXBS_MGPCR3_RD()      (HW_AXBS_MGPCR3.U)
#define HW_AXBS_MGPCR3_WR(v)     (HW_AXBS_MGPCR3.U = (v))
#define HW_AXBS_MGPCR3_SET(v)    (HW_AXBS_MGPCR3_WR(HW_AXBS_MGPCR3_RD() |  (v)))
#define HW_AXBS_MGPCR3_CLR(v)    (HW_AXBS_MGPCR3_WR(HW_AXBS_MGPCR3_RD() & ~(v)))
#define HW_AXBS_MGPCR3_TOG(v)    (HW_AXBS_MGPCR3_WR(HW_AXBS_MGPCR3_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AXBS_MGPCR3 bitfields
 */

/*!
 * @name Register AXBS_MGPCR3, field AULB[2:0] (RW)
 *
 * Determines whether, and when, the crossbar switch arbitrates away the slave
 * port the master owns when the master is performing undefined length burst
 * accesses.
 *
 * Values:
 * - 000 - No arbitration is allowed during an undefined length burst
 * - 001 - Arbitration is allowed at any time during an undefined length burst
 * - 010 - Arbitration is allowed after four beats of an undefined length burst
 * - 011 - Arbitration is allowed after eight beats of an undefined length burst
 * - 100 - Arbitration is allowed after 16 beats of an undefined length burst
 * - 101 - Reserved
 * - 110 - Reserved
 * - 111 - Reserved
 */
//@{
#define BP_AXBS_MGPCR3_AULB  (0U)          //!< Bit position for AXBS_MGPCR3_AULB.
#define BM_AXBS_MGPCR3_AULB  (0x00000007U) //!< Bit mask for AXBS_MGPCR3_AULB.
#define BS_AXBS_MGPCR3_AULB  (3U)          //!< Bit field size in bits for AXBS_MGPCR3_AULB.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AXBS_MGPCR3_AULB field.
#define BR_AXBS_MGPCR3_AULB  (HW_AXBS_MGPCR3.B.AULB)
#endif

//! @brief Format value for bitfield AXBS_MGPCR3_AULB.
#define BF_AXBS_MGPCR3_AULB(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AXBS_MGPCR3_AULB), uint32_t) & BM_AXBS_MGPCR3_AULB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AULB field to a new value.
#define BW_AXBS_MGPCR3_AULB(v) (HW_AXBS_MGPCR3_WR((HW_AXBS_MGPCR3_RD() & ~BM_AXBS_MGPCR3_AULB) | BF_AXBS_MGPCR3_AULB(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AXBS_MGPCR4 - Master General Purpose Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AXBS_MGPCR4 - Master General Purpose Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MGPCR controls only whether the master's undefined length burst accesses
 * are allowed to complete uninterrupted or whether they can be broken by
 * requests from higher priority masters. The MGPCR can be accessed only in Supervisor
 * mode with 32-bit accesses.
 */
typedef union _hw_axbs_mgpcr4
{
    uint32_t U;
    struct _hw_axbs_mgpcr4_bitfields
    {
        uint32_t AULB : 3;             //!< [2:0] Arbitrates On Undefined Length Bursts
        uint32_t RESERVED0 : 29;       //!< [31:3]
    } B;
} hw_axbs_mgpcr4_t;
#endif

/*!
 * @name Constants and macros for entire AXBS_MGPCR4 register
 */
//@{
#define HW_AXBS_MGPCR4_ADDR      (REGS_AXBS_BASE + 0xC00U)

#ifndef __LANGUAGE_ASM__
#define HW_AXBS_MGPCR4           (*(__IO hw_axbs_mgpcr4_t *) HW_AXBS_MGPCR4_ADDR)
#define HW_AXBS_MGPCR4_RD()      (HW_AXBS_MGPCR4.U)
#define HW_AXBS_MGPCR4_WR(v)     (HW_AXBS_MGPCR4.U = (v))
#define HW_AXBS_MGPCR4_SET(v)    (HW_AXBS_MGPCR4_WR(HW_AXBS_MGPCR4_RD() |  (v)))
#define HW_AXBS_MGPCR4_CLR(v)    (HW_AXBS_MGPCR4_WR(HW_AXBS_MGPCR4_RD() & ~(v)))
#define HW_AXBS_MGPCR4_TOG(v)    (HW_AXBS_MGPCR4_WR(HW_AXBS_MGPCR4_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AXBS_MGPCR4 bitfields
 */

/*!
 * @name Register AXBS_MGPCR4, field AULB[2:0] (RW)
 *
 * Determines whether, and when, the crossbar switch arbitrates away the slave
 * port the master owns when the master is performing undefined length burst
 * accesses.
 *
 * Values:
 * - 000 - No arbitration is allowed during an undefined length burst
 * - 001 - Arbitration is allowed at any time during an undefined length burst
 * - 010 - Arbitration is allowed after four beats of an undefined length burst
 * - 011 - Arbitration is allowed after eight beats of an undefined length burst
 * - 100 - Arbitration is allowed after 16 beats of an undefined length burst
 * - 101 - Reserved
 * - 110 - Reserved
 * - 111 - Reserved
 */
//@{
#define BP_AXBS_MGPCR4_AULB  (0U)          //!< Bit position for AXBS_MGPCR4_AULB.
#define BM_AXBS_MGPCR4_AULB  (0x00000007U) //!< Bit mask for AXBS_MGPCR4_AULB.
#define BS_AXBS_MGPCR4_AULB  (3U)          //!< Bit field size in bits for AXBS_MGPCR4_AULB.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AXBS_MGPCR4_AULB field.
#define BR_AXBS_MGPCR4_AULB  (HW_AXBS_MGPCR4.B.AULB)
#endif

//! @brief Format value for bitfield AXBS_MGPCR4_AULB.
#define BF_AXBS_MGPCR4_AULB(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AXBS_MGPCR4_AULB), uint32_t) & BM_AXBS_MGPCR4_AULB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AULB field to a new value.
#define BW_AXBS_MGPCR4_AULB(v) (HW_AXBS_MGPCR4_WR((HW_AXBS_MGPCR4_RD() & ~BM_AXBS_MGPCR4_AULB) | BF_AXBS_MGPCR4_AULB(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AXBS_MGPCR5 - Master General Purpose Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AXBS_MGPCR5 - Master General Purpose Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MGPCR controls only whether the master's undefined length burst accesses
 * are allowed to complete uninterrupted or whether they can be broken by
 * requests from higher priority masters. The MGPCR can be accessed only in Supervisor
 * mode with 32-bit accesses.
 */
typedef union _hw_axbs_mgpcr5
{
    uint32_t U;
    struct _hw_axbs_mgpcr5_bitfields
    {
        uint32_t AULB : 3;             //!< [2:0] Arbitrates On Undefined Length Bursts
        uint32_t RESERVED0 : 29;       //!< [31:3]
    } B;
} hw_axbs_mgpcr5_t;
#endif

/*!
 * @name Constants and macros for entire AXBS_MGPCR5 register
 */
//@{
#define HW_AXBS_MGPCR5_ADDR      (REGS_AXBS_BASE + 0xD00U)

#ifndef __LANGUAGE_ASM__
#define HW_AXBS_MGPCR5           (*(__IO hw_axbs_mgpcr5_t *) HW_AXBS_MGPCR5_ADDR)
#define HW_AXBS_MGPCR5_RD()      (HW_AXBS_MGPCR5.U)
#define HW_AXBS_MGPCR5_WR(v)     (HW_AXBS_MGPCR5.U = (v))
#define HW_AXBS_MGPCR5_SET(v)    (HW_AXBS_MGPCR5_WR(HW_AXBS_MGPCR5_RD() |  (v)))
#define HW_AXBS_MGPCR5_CLR(v)    (HW_AXBS_MGPCR5_WR(HW_AXBS_MGPCR5_RD() & ~(v)))
#define HW_AXBS_MGPCR5_TOG(v)    (HW_AXBS_MGPCR5_WR(HW_AXBS_MGPCR5_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AXBS_MGPCR5 bitfields
 */

/*!
 * @name Register AXBS_MGPCR5, field AULB[2:0] (RW)
 *
 * Determines whether, and when, the crossbar switch arbitrates away the slave
 * port the master owns when the master is performing undefined length burst
 * accesses.
 *
 * Values:
 * - 000 - No arbitration is allowed during an undefined length burst
 * - 001 - Arbitration is allowed at any time during an undefined length burst
 * - 010 - Arbitration is allowed after four beats of an undefined length burst
 * - 011 - Arbitration is allowed after eight beats of an undefined length burst
 * - 100 - Arbitration is allowed after 16 beats of an undefined length burst
 * - 101 - Reserved
 * - 110 - Reserved
 * - 111 - Reserved
 */
//@{
#define BP_AXBS_MGPCR5_AULB  (0U)          //!< Bit position for AXBS_MGPCR5_AULB.
#define BM_AXBS_MGPCR5_AULB  (0x00000007U) //!< Bit mask for AXBS_MGPCR5_AULB.
#define BS_AXBS_MGPCR5_AULB  (3U)          //!< Bit field size in bits for AXBS_MGPCR5_AULB.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AXBS_MGPCR5_AULB field.
#define BR_AXBS_MGPCR5_AULB  (HW_AXBS_MGPCR5.B.AULB)
#endif

//! @brief Format value for bitfield AXBS_MGPCR5_AULB.
#define BF_AXBS_MGPCR5_AULB(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AXBS_MGPCR5_AULB), uint32_t) & BM_AXBS_MGPCR5_AULB)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AULB field to a new value.
#define BW_AXBS_MGPCR5_AULB(v) (HW_AXBS_MGPCR5_WR((HW_AXBS_MGPCR5_RD() & ~BM_AXBS_MGPCR5_AULB) | BF_AXBS_MGPCR5_AULB(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_axbs_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All AXBS module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_axbs
{
    struct {
        __IO hw_axbs_prsn_t PRSn;          //!< [0x0] Priority Registers Slave
        uint8_t _reserved0[12];
        __IO hw_axbs_crsn_t CRSn;          //!< [0x10] Control Register
        uint8_t _reserved1[236];
    } SLAVE[5];
    uint8_t _reserved0[768];
    __IO hw_axbs_mgpcr0_t MGPCR0;          //!< [0x800] Master General Purpose Control Register
    uint8_t _reserved1[252];
    __IO hw_axbs_mgpcr1_t MGPCR1;          //!< [0x900] Master General Purpose Control Register
    uint8_t _reserved2[252];
    __IO hw_axbs_mgpcr2_t MGPCR2;          //!< [0xA00] Master General Purpose Control Register
    uint8_t _reserved3[252];
    __IO hw_axbs_mgpcr3_t MGPCR3;          //!< [0xB00] Master General Purpose Control Register
    uint8_t _reserved4[252];
    __IO hw_axbs_mgpcr4_t MGPCR4;          //!< [0xC00] Master General Purpose Control Register
    uint8_t _reserved5[252];
    __IO hw_axbs_mgpcr5_t MGPCR5;          //!< [0xD00] Master General Purpose Control Register
} hw_axbs_t;
#pragma pack()

//! @brief Macro to access all AXBS registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_AXBS</code>.
#define HW_AXBS        (*(hw_axbs_t *) REGS_AXBS_BASE)
#endif

#endif // __HW_AXBS_REGISTERS_H__
// v22/130726/0.9
// EOF

