/*
 * Copyright (c) 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_AIPS_REGISTERS_H__
#define __HW_AIPS_REGISTERS_H__

#include "regs.h"

/*
 * MK64F12 AIPS
 *
 * AIPS-Lite Bridge
 *
 * Registers defined in this header file:
 * - HW_AIPS_MPRA - Master Privilege Register A
 * - HW_AIPS_PACRA - Peripheral Access Control Register
 * - HW_AIPS_PACRB - Peripheral Access Control Register
 * - HW_AIPS_PACRC - Peripheral Access Control Register
 * - HW_AIPS_PACRD - Peripheral Access Control Register
 * - HW_AIPS_PACRE - Peripheral Access Control Register
 * - HW_AIPS_PACRF - Peripheral Access Control Register
 * - HW_AIPS_PACRG - Peripheral Access Control Register
 * - HW_AIPS_PACRH - Peripheral Access Control Register
 * - HW_AIPS_PACRI - Peripheral Access Control Register
 * - HW_AIPS_PACRJ - Peripheral Access Control Register
 * - HW_AIPS_PACRK - Peripheral Access Control Register
 * - HW_AIPS_PACRL - Peripheral Access Control Register
 * - HW_AIPS_PACRM - Peripheral Access Control Register
 * - HW_AIPS_PACRN - Peripheral Access Control Register
 * - HW_AIPS_PACRO - Peripheral Access Control Register
 * - HW_AIPS_PACRP - Peripheral Access Control Register
 * - HW_AIPS_PACRU - Peripheral Access Control Register
 *
 * - hw_aips_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_AIPS_BASE
#define HW_AIPS_INSTANCE_COUNT (2U) //!< Number of instances of the AIPS module.
#define HW_AIPS0 (0U) //!< Instance number for AIPS0.
#define HW_AIPS1 (1U) //!< Instance number for AIPS1.
#define REGS_AIPS0_BASE (0x40000000U) //!< Base address for AIPS0.
#define REGS_AIPS1_BASE (0x40080000U) //!< Base address for AIPS1.

//! @brief Table of base addresses for AIPS instances.
static const uint32_t __g_regs_AIPS_base_addresses[] = {
        REGS_AIPS0_BASE,
        REGS_AIPS1_BASE,
    };

//! @brief Get the base address of AIPS by instance number.
//! @param x AIPS instance number, from 0 through 1.
#define REGS_AIPS_BASE(x) (__g_regs_AIPS_base_addresses[(x)])

//! @brief Get the instance number given a base address.
//! @param b Base address for an instance of AIPS.
#define REGS_AIPS_INSTANCE(b) ((b) == REGS_AIPS0_BASE ? HW_AIPS0 : (b) == REGS_AIPS1_BASE ? HW_AIPS1 : 0)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AIPS_MPRA - Master Privilege Register A
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AIPS_MPRA - Master Privilege Register A (RW)
 *
 * Reset value: 0x77700000U
 *
 * The MPRA specifies identical 4-bit fields defining the access-privilege level
 * associated with a bus master to various peripherals on the chip. The register
 * provides one field per bus master. At reset, the default value loaded into
 * the MPRA fields is chip-specific. See the chip configuration details for the
 * value of a particular device. A register field that maps to an unimplemented
 * master or peripheral behaves as read-only-zero. Each master is assigned a logical
 * ID from 0 to 15. See the master logical ID assignment table in the
 * chip-specific AIPS information.
 */
typedef union _hw_aips_mpra
{
    uint32_t U;
    struct _hw_aips_mpra_bitfields
    {
        uint32_t RESERVED0 : 8;        //!< [7:0]
        uint32_t MPL5 : 1;             //!< [8] Master 5 Privilege Level
        uint32_t MTW5 : 1;             //!< [9] Master 5 Trusted For Writes
        uint32_t MTR5 : 1;             //!< [10] Master 5 Trusted For Read
        uint32_t RESERVED1 : 1;        //!< [11]
        uint32_t MPL4 : 1;             //!< [12] Master 4 Privilege Level
        uint32_t MTW4 : 1;             //!< [13] Master 4 Trusted For Writes
        uint32_t MTR4 : 1;             //!< [14] Master 4 Trusted For Read
        uint32_t RESERVED2 : 1;        //!< [15]
        uint32_t MPL3 : 1;             //!< [16] Master 3 Privilege Level
        uint32_t MTW3 : 1;             //!< [17] Master 3 Trusted For Writes
        uint32_t MTR3 : 1;             //!< [18] Master 3 Trusted For Read
        uint32_t RESERVED3 : 1;        //!< [19]
        uint32_t MPL2 : 1;             //!< [20] Master 2 Privilege Level
        uint32_t MTW2 : 1;             //!< [21] Master 2 Trusted For Writes
        uint32_t MTR2 : 1;             //!< [22] Master 2 Trusted For Read
        uint32_t RESERVED4 : 1;        //!< [23]
        uint32_t MPL1 : 1;             //!< [24] Master 1 Privilege Level
        uint32_t MTW1 : 1;             //!< [25] Master 1 Trusted for Writes
        uint32_t MTR1 : 1;             //!< [26] Master 1 Trusted for Read
        uint32_t RESERVED5 : 1;        //!< [27]
        uint32_t MPL0 : 1;             //!< [28] Master 0 Privilege Level
        uint32_t MTW0 : 1;             //!< [29] Master 0 Trusted For Writes
        uint32_t MTR0 : 1;             //!< [30] Master 0 Trusted For Read
        uint32_t RESERVED6 : 1;        //!< [31]
    } B;
} hw_aips_mpra_t;
#endif

/*!
 * @name Constants and macros for entire AIPS_MPRA register
 */
//@{
#define HW_AIPS_MPRA_ADDR(x)     (REGS_AIPS_BASE(x) + 0x0U)

#ifndef __LANGUAGE_ASM__
#define HW_AIPS_MPRA(x)          (*(__IO hw_aips_mpra_t *) HW_AIPS_MPRA_ADDR(x))
#define HW_AIPS_MPRA_RD(x)       (HW_AIPS_MPRA(x).U)
#define HW_AIPS_MPRA_WR(x, v)    (HW_AIPS_MPRA(x).U = (v))
#define HW_AIPS_MPRA_SET(x, v)   (HW_AIPS_MPRA_WR(x, HW_AIPS_MPRA_RD(x) |  (v)))
#define HW_AIPS_MPRA_CLR(x, v)   (HW_AIPS_MPRA_WR(x, HW_AIPS_MPRA_RD(x) & ~(v)))
#define HW_AIPS_MPRA_TOG(x, v)   (HW_AIPS_MPRA_WR(x, HW_AIPS_MPRA_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AIPS_MPRA bitfields
 */

/*!
 * @name Register AIPS_MPRA, field MPL5[8] (RW)
 *
 * Specifies how the privilege level of the master is determined.
 *
 * Values:
 * - 0 - Accesses from this master are forced to user-mode.
 * - 1 - Accesses from this master are not forced to user-mode.
 */
//@{
#define BP_AIPS_MPRA_MPL5    (8U)          //!< Bit position for AIPS_MPRA_MPL5.
#define BM_AIPS_MPRA_MPL5    (0x00000100U) //!< Bit mask for AIPS_MPRA_MPL5.
#define BS_AIPS_MPRA_MPL5    (1U)          //!< Bit field size in bits for AIPS_MPRA_MPL5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_MPRA_MPL5 field.
#define BR_AIPS_MPRA_MPL5(x) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MPL5))
#endif

//! @brief Format value for bitfield AIPS_MPRA_MPL5.
#define BF_AIPS_MPRA_MPL5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_MPRA_MPL5), uint32_t) & BM_AIPS_MPRA_MPL5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MPL5 field to a new value.
#define BW_AIPS_MPRA_MPL5(x, v) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MPL5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_MPRA, field MTW5[9] (RW)
 *
 * Determines whether the master is trusted for write accesses.
 *
 * Values:
 * - 0 - This master is not trusted for write accesses.
 * - 1 - This master is trusted for write accesses.
 */
//@{
#define BP_AIPS_MPRA_MTW5    (9U)          //!< Bit position for AIPS_MPRA_MTW5.
#define BM_AIPS_MPRA_MTW5    (0x00000200U) //!< Bit mask for AIPS_MPRA_MTW5.
#define BS_AIPS_MPRA_MTW5    (1U)          //!< Bit field size in bits for AIPS_MPRA_MTW5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_MPRA_MTW5 field.
#define BR_AIPS_MPRA_MTW5(x) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTW5))
#endif

//! @brief Format value for bitfield AIPS_MPRA_MTW5.
#define BF_AIPS_MPRA_MTW5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_MPRA_MTW5), uint32_t) & BM_AIPS_MPRA_MTW5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MTW5 field to a new value.
#define BW_AIPS_MPRA_MTW5(x, v) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTW5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_MPRA, field MTR5[10] (RW)
 *
 * Determines whether the master is trusted for read accesses.
 *
 * Values:
 * - 0 - This master is not trusted for read accesses.
 * - 1 - This master is trusted for read accesses.
 */
//@{
#define BP_AIPS_MPRA_MTR5    (10U)         //!< Bit position for AIPS_MPRA_MTR5.
#define BM_AIPS_MPRA_MTR5    (0x00000400U) //!< Bit mask for AIPS_MPRA_MTR5.
#define BS_AIPS_MPRA_MTR5    (1U)          //!< Bit field size in bits for AIPS_MPRA_MTR5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_MPRA_MTR5 field.
#define BR_AIPS_MPRA_MTR5(x) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTR5))
#endif

//! @brief Format value for bitfield AIPS_MPRA_MTR5.
#define BF_AIPS_MPRA_MTR5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_MPRA_MTR5), uint32_t) & BM_AIPS_MPRA_MTR5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MTR5 field to a new value.
#define BW_AIPS_MPRA_MTR5(x, v) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTR5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_MPRA, field MPL4[12] (RW)
 *
 * Specifies how the privilege level of the master is determined.
 *
 * Values:
 * - 0 - Accesses from this master are forced to user-mode.
 * - 1 - Accesses from this master are not forced to user-mode.
 */
//@{
#define BP_AIPS_MPRA_MPL4    (12U)         //!< Bit position for AIPS_MPRA_MPL4.
#define BM_AIPS_MPRA_MPL4    (0x00001000U) //!< Bit mask for AIPS_MPRA_MPL4.
#define BS_AIPS_MPRA_MPL4    (1U)          //!< Bit field size in bits for AIPS_MPRA_MPL4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_MPRA_MPL4 field.
#define BR_AIPS_MPRA_MPL4(x) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MPL4))
#endif

//! @brief Format value for bitfield AIPS_MPRA_MPL4.
#define BF_AIPS_MPRA_MPL4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_MPRA_MPL4), uint32_t) & BM_AIPS_MPRA_MPL4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MPL4 field to a new value.
#define BW_AIPS_MPRA_MPL4(x, v) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MPL4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_MPRA, field MTW4[13] (RW)
 *
 * Determines whether the master is trusted for write accesses.
 *
 * Values:
 * - 0 - This master is not trusted for write accesses.
 * - 1 - This master is trusted for write accesses.
 */
//@{
#define BP_AIPS_MPRA_MTW4    (13U)         //!< Bit position for AIPS_MPRA_MTW4.
#define BM_AIPS_MPRA_MTW4    (0x00002000U) //!< Bit mask for AIPS_MPRA_MTW4.
#define BS_AIPS_MPRA_MTW4    (1U)          //!< Bit field size in bits for AIPS_MPRA_MTW4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_MPRA_MTW4 field.
#define BR_AIPS_MPRA_MTW4(x) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTW4))
#endif

//! @brief Format value for bitfield AIPS_MPRA_MTW4.
#define BF_AIPS_MPRA_MTW4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_MPRA_MTW4), uint32_t) & BM_AIPS_MPRA_MTW4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MTW4 field to a new value.
#define BW_AIPS_MPRA_MTW4(x, v) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTW4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_MPRA, field MTR4[14] (RW)
 *
 * Determines whether the master is trusted for read accesses.
 *
 * Values:
 * - 0 - This master is not trusted for read accesses.
 * - 1 - This master is trusted for read accesses.
 */
//@{
#define BP_AIPS_MPRA_MTR4    (14U)         //!< Bit position for AIPS_MPRA_MTR4.
#define BM_AIPS_MPRA_MTR4    (0x00004000U) //!< Bit mask for AIPS_MPRA_MTR4.
#define BS_AIPS_MPRA_MTR4    (1U)          //!< Bit field size in bits for AIPS_MPRA_MTR4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_MPRA_MTR4 field.
#define BR_AIPS_MPRA_MTR4(x) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTR4))
#endif

//! @brief Format value for bitfield AIPS_MPRA_MTR4.
#define BF_AIPS_MPRA_MTR4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_MPRA_MTR4), uint32_t) & BM_AIPS_MPRA_MTR4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MTR4 field to a new value.
#define BW_AIPS_MPRA_MTR4(x, v) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTR4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_MPRA, field MPL3[16] (RW)
 *
 * Specifies how the privilege level of the master is determined.
 *
 * Values:
 * - 0 - Accesses from this master are forced to user-mode.
 * - 1 - Accesses from this master are not forced to user-mode.
 */
//@{
#define BP_AIPS_MPRA_MPL3    (16U)         //!< Bit position for AIPS_MPRA_MPL3.
#define BM_AIPS_MPRA_MPL3    (0x00010000U) //!< Bit mask for AIPS_MPRA_MPL3.
#define BS_AIPS_MPRA_MPL3    (1U)          //!< Bit field size in bits for AIPS_MPRA_MPL3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_MPRA_MPL3 field.
#define BR_AIPS_MPRA_MPL3(x) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MPL3))
#endif

//! @brief Format value for bitfield AIPS_MPRA_MPL3.
#define BF_AIPS_MPRA_MPL3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_MPRA_MPL3), uint32_t) & BM_AIPS_MPRA_MPL3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MPL3 field to a new value.
#define BW_AIPS_MPRA_MPL3(x, v) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MPL3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_MPRA, field MTW3[17] (RW)
 *
 * Determines whether the master is trusted for write accesses.
 *
 * Values:
 * - 0 - This master is not trusted for write accesses.
 * - 1 - This master is trusted for write accesses.
 */
//@{
#define BP_AIPS_MPRA_MTW3    (17U)         //!< Bit position for AIPS_MPRA_MTW3.
#define BM_AIPS_MPRA_MTW3    (0x00020000U) //!< Bit mask for AIPS_MPRA_MTW3.
#define BS_AIPS_MPRA_MTW3    (1U)          //!< Bit field size in bits for AIPS_MPRA_MTW3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_MPRA_MTW3 field.
#define BR_AIPS_MPRA_MTW3(x) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTW3))
#endif

//! @brief Format value for bitfield AIPS_MPRA_MTW3.
#define BF_AIPS_MPRA_MTW3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_MPRA_MTW3), uint32_t) & BM_AIPS_MPRA_MTW3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MTW3 field to a new value.
#define BW_AIPS_MPRA_MTW3(x, v) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTW3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_MPRA, field MTR3[18] (RW)
 *
 * Determines whether the master is trusted for read accesses.
 *
 * Values:
 * - 0 - This master is not trusted for read accesses.
 * - 1 - This master is trusted for read accesses.
 */
//@{
#define BP_AIPS_MPRA_MTR3    (18U)         //!< Bit position for AIPS_MPRA_MTR3.
#define BM_AIPS_MPRA_MTR3    (0x00040000U) //!< Bit mask for AIPS_MPRA_MTR3.
#define BS_AIPS_MPRA_MTR3    (1U)          //!< Bit field size in bits for AIPS_MPRA_MTR3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_MPRA_MTR3 field.
#define BR_AIPS_MPRA_MTR3(x) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTR3))
#endif

//! @brief Format value for bitfield AIPS_MPRA_MTR3.
#define BF_AIPS_MPRA_MTR3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_MPRA_MTR3), uint32_t) & BM_AIPS_MPRA_MTR3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MTR3 field to a new value.
#define BW_AIPS_MPRA_MTR3(x, v) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTR3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_MPRA, field MPL2[20] (RW)
 *
 * Specifies how the privilege level of the master is determined.
 *
 * Values:
 * - 0 - Accesses from this master are forced to user-mode.
 * - 1 - Accesses from this master are not forced to user-mode.
 */
//@{
#define BP_AIPS_MPRA_MPL2    (20U)         //!< Bit position for AIPS_MPRA_MPL2.
#define BM_AIPS_MPRA_MPL2    (0x00100000U) //!< Bit mask for AIPS_MPRA_MPL2.
#define BS_AIPS_MPRA_MPL2    (1U)          //!< Bit field size in bits for AIPS_MPRA_MPL2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_MPRA_MPL2 field.
#define BR_AIPS_MPRA_MPL2(x) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MPL2))
#endif

//! @brief Format value for bitfield AIPS_MPRA_MPL2.
#define BF_AIPS_MPRA_MPL2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_MPRA_MPL2), uint32_t) & BM_AIPS_MPRA_MPL2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MPL2 field to a new value.
#define BW_AIPS_MPRA_MPL2(x, v) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MPL2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_MPRA, field MTW2[21] (RW)
 *
 * Determines whether the master is trusted for write accesses.
 *
 * Values:
 * - 0 - This master is not trusted for write accesses.
 * - 1 - This master is trusted for write accesses.
 */
//@{
#define BP_AIPS_MPRA_MTW2    (21U)         //!< Bit position for AIPS_MPRA_MTW2.
#define BM_AIPS_MPRA_MTW2    (0x00200000U) //!< Bit mask for AIPS_MPRA_MTW2.
#define BS_AIPS_MPRA_MTW2    (1U)          //!< Bit field size in bits for AIPS_MPRA_MTW2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_MPRA_MTW2 field.
#define BR_AIPS_MPRA_MTW2(x) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTW2))
#endif

//! @brief Format value for bitfield AIPS_MPRA_MTW2.
#define BF_AIPS_MPRA_MTW2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_MPRA_MTW2), uint32_t) & BM_AIPS_MPRA_MTW2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MTW2 field to a new value.
#define BW_AIPS_MPRA_MTW2(x, v) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTW2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_MPRA, field MTR2[22] (RW)
 *
 * Determines whether the master is trusted for read accesses.
 *
 * Values:
 * - 0 - This master is not trusted for read accesses.
 * - 1 - This master is trusted for read accesses.
 */
//@{
#define BP_AIPS_MPRA_MTR2    (22U)         //!< Bit position for AIPS_MPRA_MTR2.
#define BM_AIPS_MPRA_MTR2    (0x00400000U) //!< Bit mask for AIPS_MPRA_MTR2.
#define BS_AIPS_MPRA_MTR2    (1U)          //!< Bit field size in bits for AIPS_MPRA_MTR2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_MPRA_MTR2 field.
#define BR_AIPS_MPRA_MTR2(x) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTR2))
#endif

//! @brief Format value for bitfield AIPS_MPRA_MTR2.
#define BF_AIPS_MPRA_MTR2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_MPRA_MTR2), uint32_t) & BM_AIPS_MPRA_MTR2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MTR2 field to a new value.
#define BW_AIPS_MPRA_MTR2(x, v) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTR2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_MPRA, field MPL1[24] (RW)
 *
 * Specifies how the privilege level of the master is determined.
 *
 * Values:
 * - 0 - Accesses from this master are forced to user-mode.
 * - 1 - Accesses from this master are not forced to user-mode.
 */
//@{
#define BP_AIPS_MPRA_MPL1    (24U)         //!< Bit position for AIPS_MPRA_MPL1.
#define BM_AIPS_MPRA_MPL1    (0x01000000U) //!< Bit mask for AIPS_MPRA_MPL1.
#define BS_AIPS_MPRA_MPL1    (1U)          //!< Bit field size in bits for AIPS_MPRA_MPL1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_MPRA_MPL1 field.
#define BR_AIPS_MPRA_MPL1(x) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MPL1))
#endif

//! @brief Format value for bitfield AIPS_MPRA_MPL1.
#define BF_AIPS_MPRA_MPL1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_MPRA_MPL1), uint32_t) & BM_AIPS_MPRA_MPL1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MPL1 field to a new value.
#define BW_AIPS_MPRA_MPL1(x, v) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MPL1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_MPRA, field MTW1[25] (RW)
 *
 * Determines whether the master is trusted for write accesses.
 *
 * Values:
 * - 0 - This master is not trusted for write accesses.
 * - 1 - This master is trusted for write accesses.
 */
//@{
#define BP_AIPS_MPRA_MTW1    (25U)         //!< Bit position for AIPS_MPRA_MTW1.
#define BM_AIPS_MPRA_MTW1    (0x02000000U) //!< Bit mask for AIPS_MPRA_MTW1.
#define BS_AIPS_MPRA_MTW1    (1U)          //!< Bit field size in bits for AIPS_MPRA_MTW1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_MPRA_MTW1 field.
#define BR_AIPS_MPRA_MTW1(x) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTW1))
#endif

//! @brief Format value for bitfield AIPS_MPRA_MTW1.
#define BF_AIPS_MPRA_MTW1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_MPRA_MTW1), uint32_t) & BM_AIPS_MPRA_MTW1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MTW1 field to a new value.
#define BW_AIPS_MPRA_MTW1(x, v) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTW1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_MPRA, field MTR1[26] (RW)
 *
 * Determines whether the master is trusted for read accesses.
 *
 * Values:
 * - 0 - This master is not trusted for read accesses.
 * - 1 - This master is trusted for read accesses.
 */
//@{
#define BP_AIPS_MPRA_MTR1    (26U)         //!< Bit position for AIPS_MPRA_MTR1.
#define BM_AIPS_MPRA_MTR1    (0x04000000U) //!< Bit mask for AIPS_MPRA_MTR1.
#define BS_AIPS_MPRA_MTR1    (1U)          //!< Bit field size in bits for AIPS_MPRA_MTR1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_MPRA_MTR1 field.
#define BR_AIPS_MPRA_MTR1(x) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTR1))
#endif

//! @brief Format value for bitfield AIPS_MPRA_MTR1.
#define BF_AIPS_MPRA_MTR1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_MPRA_MTR1), uint32_t) & BM_AIPS_MPRA_MTR1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MTR1 field to a new value.
#define BW_AIPS_MPRA_MTR1(x, v) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTR1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_MPRA, field MPL0[28] (RW)
 *
 * Specifies how the privilege level of the master is determined.
 *
 * Values:
 * - 0 - Accesses from this master are forced to user-mode.
 * - 1 - Accesses from this master are not forced to user-mode.
 */
//@{
#define BP_AIPS_MPRA_MPL0    (28U)         //!< Bit position for AIPS_MPRA_MPL0.
#define BM_AIPS_MPRA_MPL0    (0x10000000U) //!< Bit mask for AIPS_MPRA_MPL0.
#define BS_AIPS_MPRA_MPL0    (1U)          //!< Bit field size in bits for AIPS_MPRA_MPL0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_MPRA_MPL0 field.
#define BR_AIPS_MPRA_MPL0(x) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MPL0))
#endif

//! @brief Format value for bitfield AIPS_MPRA_MPL0.
#define BF_AIPS_MPRA_MPL0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_MPRA_MPL0), uint32_t) & BM_AIPS_MPRA_MPL0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MPL0 field to a new value.
#define BW_AIPS_MPRA_MPL0(x, v) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MPL0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_MPRA, field MTW0[29] (RW)
 *
 * Determines whether the master is trusted for write accesses.
 *
 * Values:
 * - 0 - This master is not trusted for write accesses.
 * - 1 - This master is trusted for write accesses.
 */
//@{
#define BP_AIPS_MPRA_MTW0    (29U)         //!< Bit position for AIPS_MPRA_MTW0.
#define BM_AIPS_MPRA_MTW0    (0x20000000U) //!< Bit mask for AIPS_MPRA_MTW0.
#define BS_AIPS_MPRA_MTW0    (1U)          //!< Bit field size in bits for AIPS_MPRA_MTW0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_MPRA_MTW0 field.
#define BR_AIPS_MPRA_MTW0(x) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTW0))
#endif

//! @brief Format value for bitfield AIPS_MPRA_MTW0.
#define BF_AIPS_MPRA_MTW0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_MPRA_MTW0), uint32_t) & BM_AIPS_MPRA_MTW0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MTW0 field to a new value.
#define BW_AIPS_MPRA_MTW0(x, v) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTW0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_MPRA, field MTR0[30] (RW)
 *
 * Determines whether the master is trusted for read accesses.
 *
 * Values:
 * - 0 - This master is not trusted for read accesses.
 * - 1 - This master is trusted for read accesses.
 */
//@{
#define BP_AIPS_MPRA_MTR0    (30U)         //!< Bit position for AIPS_MPRA_MTR0.
#define BM_AIPS_MPRA_MTR0    (0x40000000U) //!< Bit mask for AIPS_MPRA_MTR0.
#define BS_AIPS_MPRA_MTR0    (1U)          //!< Bit field size in bits for AIPS_MPRA_MTR0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_MPRA_MTR0 field.
#define BR_AIPS_MPRA_MTR0(x) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTR0))
#endif

//! @brief Format value for bitfield AIPS_MPRA_MTR0.
#define BF_AIPS_MPRA_MTR0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_MPRA_MTR0), uint32_t) & BM_AIPS_MPRA_MTR0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MTR0 field to a new value.
#define BW_AIPS_MPRA_MTR0(x, v) (BITBAND_ACCESS32(HW_AIPS_MPRA_ADDR(x), BP_AIPS_MPRA_MTR0) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AIPS_PACRA - Peripheral Access Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AIPS_PACRA - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x50004000U
 *
 * Each PACR register consists of eight 4-bit PACR fields. Each PACR field
 * defines the access levels for a particular peripheral. The mapping between a
 * peripheral and its PACR field is shown in the table below. The peripheral assignment
 * to each PACR is defined by the memory map slot that the peripheral is
 * assigned to. See this chip's memory map for the assignment of a particular
 * peripheral. The following table shows the location of each peripheral slot's PACR field
 * in the PACR registers. Offset Register [31:28] [27:24] [23:20] [19:16] [15:12]
 * [11:8] [7:4] [3:0] 0x20 PACRA PACR0 PACR1 PACR2 PACR3 PACR4 PACR5 PACR6 PACR7
 * 0x24 PACRB PACR8 PACR9 PACR10 PACR11 PACR12 PACR13 PACR14 PACR15 0x28 PACRC
 * PACR16 PACR17 PACR18 PACR19 PACR20 PACR21 PACR22 PACR23 0x2C PACRD PACR24
 * PACR25 PACR26 PACR27 PACR28 PACR29 PACR30 PACR31 0x30 Reserved 0x34 Reserved 0x38
 * Reserved 0x3C Reserved 0x40 PACRE PACR32 PACR33 PACR34 PACR35 PACR36 PACR37
 * PACR38 PACR39 0x44 PACRF PACR40 PACR41 PACR42 PACR43 PACR44 PACR45 PACR46 PACR47
 * 0x48 PACRG PACR48 PACR49 PACR50 PACR51 PACR52 PACR53 PACR54 PACR55 0x4C PACRH
 * PACR56 PACR57 PACR58 PACR59 PACR60 PACR61 PACR62 PACR63 0x50 PACRI PACR64
 * PACR65 PACR66 PACR67 PACR68 PACR69 PACR70 PACR71 0x54 PACRJ PACR72 PACR73 PACR74
 * PACR75 PACR76 PACR77 PACR78 PACR79 0x58 PACRK PACR80 PACR81 PACR82 PACR83
 * PACR84 PACR85 PACR86 PACR87 0x5C PACRL PACR88 PACR89 PACR90 PACR91 PACR92 PACR93
 * PACR94 PACR95 0x60 PACRM PACR96 PACR97 PACR98 PACR99 PACR100 PACR101 PACR102
 * PACR103 0x64 PACRN PACR104 PACR105 PACR106 PACR107 PACR108 PACR109 PACR110
 * PACR111 0x68 PACRO PACR112 PACR113 PACR114 PACR115 PACR116 PACR117 PACR118 PACR119
 * 0x6C PACRP PACR120 PACR121 PACR122 PACR123 PACR124 PACR125 PACR126 PACR127 0x80
 * PACRU PACR GBL0 PACR GBL1 Reserved The register field descriptions for PACR
 * A-D, which control peripheral slots 0-31, are shown below. The following
 * section, PACRPeripheral Access Control Register , shows the register field
 * descriptions for PACR E-P. All PACR registers are identical. They are divided into two
 * sections because they occupy two non-contiguous address spaces.
 */
typedef union _hw_aips_pacra
{
    uint32_t U;
    struct _hw_aips_pacra_bitfields
    {
        uint32_t TP7 : 1;              //!< [0] Trusted Protect
        uint32_t WP7 : 1;              //!< [1] Write Protect
        uint32_t SP7 : 1;              //!< [2] Supervisor Protect
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t TP6 : 1;              //!< [4] Trusted Protect
        uint32_t WP6 : 1;              //!< [5] Write Protect
        uint32_t SP6 : 1;              //!< [6] Supervisor Protect
        uint32_t RESERVED1 : 1;        //!< [7]
        uint32_t TP5 : 1;              //!< [8] Trusted Protect
        uint32_t WP5 : 1;              //!< [9] Write Protect
        uint32_t SP5 : 1;              //!< [10] Supervisor Protect
        uint32_t RESERVED2 : 1;        //!< [11]
        uint32_t TP4 : 1;              //!< [12] Trusted Protect
        uint32_t WP4 : 1;              //!< [13] Write Protect
        uint32_t SP4 : 1;              //!< [14] Supervisor Protect
        uint32_t RESERVED3 : 1;        //!< [15]
        uint32_t TP3 : 1;              //!< [16] Trusted Protect
        uint32_t WP3 : 1;              //!< [17] Write Protect
        uint32_t SP3 : 1;              //!< [18] Supervisor Protect
        uint32_t RESERVED4 : 1;        //!< [19]
        uint32_t TP2 : 1;              //!< [20] Trusted Protect
        uint32_t WP2 : 1;              //!< [21] Write Protect
        uint32_t SP2 : 1;              //!< [22] Supervisor Protect
        uint32_t RESERVED5 : 1;        //!< [23]
        uint32_t TP1 : 1;              //!< [24] Trusted Protect
        uint32_t WP1 : 1;              //!< [25] Write Protect
        uint32_t SP1 : 1;              //!< [26] Supervisor Protect
        uint32_t RESERVED6 : 1;        //!< [27]
        uint32_t TP0 : 1;              //!< [28] Trusted Protect
        uint32_t WP0 : 1;              //!< [29] Write Protect
        uint32_t SP0 : 1;              //!< [30] Supervisor Protect
        uint32_t RESERVED7 : 1;        //!< [31]
    } B;
} hw_aips_pacra_t;
#endif

/*!
 * @name Constants and macros for entire AIPS_PACRA register
 */
//@{
#define HW_AIPS_PACRA_ADDR(x)    (REGS_AIPS_BASE(x) + 0x20U)

#ifndef __LANGUAGE_ASM__
#define HW_AIPS_PACRA(x)         (*(__IO hw_aips_pacra_t *) HW_AIPS_PACRA_ADDR(x))
#define HW_AIPS_PACRA_RD(x)      (HW_AIPS_PACRA(x).U)
#define HW_AIPS_PACRA_WR(x, v)   (HW_AIPS_PACRA(x).U = (v))
#define HW_AIPS_PACRA_SET(x, v)  (HW_AIPS_PACRA_WR(x, HW_AIPS_PACRA_RD(x) |  (v)))
#define HW_AIPS_PACRA_CLR(x, v)  (HW_AIPS_PACRA_WR(x, HW_AIPS_PACRA_RD(x) & ~(v)))
#define HW_AIPS_PACRA_TOG(x, v)  (HW_AIPS_PACRA_WR(x, HW_AIPS_PACRA_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AIPS_PACRA bitfields
 */

/*!
 * @name Register AIPS_PACRA, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRA_TP7    (0U)          //!< Bit position for AIPS_PACRA_TP7.
#define BM_AIPS_PACRA_TP7    (0x00000001U) //!< Bit mask for AIPS_PACRA_TP7.
#define BS_AIPS_PACRA_TP7    (1U)          //!< Bit field size in bits for AIPS_PACRA_TP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_TP7 field.
#define BR_AIPS_PACRA_TP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_TP7))
#endif

//! @brief Format value for bitfield AIPS_PACRA_TP7.
#define BF_AIPS_PACRA_TP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_TP7), uint32_t) & BM_AIPS_PACRA_TP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP7 field to a new value.
#define BW_AIPS_PACRA_TP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_TP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRA_WP7    (1U)          //!< Bit position for AIPS_PACRA_WP7.
#define BM_AIPS_PACRA_WP7    (0x00000002U) //!< Bit mask for AIPS_PACRA_WP7.
#define BS_AIPS_PACRA_WP7    (1U)          //!< Bit field size in bits for AIPS_PACRA_WP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_WP7 field.
#define BR_AIPS_PACRA_WP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_WP7))
#endif

//! @brief Format value for bitfield AIPS_PACRA_WP7.
#define BF_AIPS_PACRA_WP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_WP7), uint32_t) & BM_AIPS_PACRA_WP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP7 field to a new value.
#define BW_AIPS_PACRA_WP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_WP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRA_SP7    (2U)          //!< Bit position for AIPS_PACRA_SP7.
#define BM_AIPS_PACRA_SP7    (0x00000004U) //!< Bit mask for AIPS_PACRA_SP7.
#define BS_AIPS_PACRA_SP7    (1U)          //!< Bit field size in bits for AIPS_PACRA_SP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_SP7 field.
#define BR_AIPS_PACRA_SP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_SP7))
#endif

//! @brief Format value for bitfield AIPS_PACRA_SP7.
#define BF_AIPS_PACRA_SP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_SP7), uint32_t) & BM_AIPS_PACRA_SP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP7 field to a new value.
#define BW_AIPS_PACRA_SP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_SP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRA_TP6    (4U)          //!< Bit position for AIPS_PACRA_TP6.
#define BM_AIPS_PACRA_TP6    (0x00000010U) //!< Bit mask for AIPS_PACRA_TP6.
#define BS_AIPS_PACRA_TP6    (1U)          //!< Bit field size in bits for AIPS_PACRA_TP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_TP6 field.
#define BR_AIPS_PACRA_TP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_TP6))
#endif

//! @brief Format value for bitfield AIPS_PACRA_TP6.
#define BF_AIPS_PACRA_TP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_TP6), uint32_t) & BM_AIPS_PACRA_TP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP6 field to a new value.
#define BW_AIPS_PACRA_TP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_TP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRA_WP6    (5U)          //!< Bit position for AIPS_PACRA_WP6.
#define BM_AIPS_PACRA_WP6    (0x00000020U) //!< Bit mask for AIPS_PACRA_WP6.
#define BS_AIPS_PACRA_WP6    (1U)          //!< Bit field size in bits for AIPS_PACRA_WP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_WP6 field.
#define BR_AIPS_PACRA_WP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_WP6))
#endif

//! @brief Format value for bitfield AIPS_PACRA_WP6.
#define BF_AIPS_PACRA_WP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_WP6), uint32_t) & BM_AIPS_PACRA_WP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP6 field to a new value.
#define BW_AIPS_PACRA_WP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_WP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRA_SP6    (6U)          //!< Bit position for AIPS_PACRA_SP6.
#define BM_AIPS_PACRA_SP6    (0x00000040U) //!< Bit mask for AIPS_PACRA_SP6.
#define BS_AIPS_PACRA_SP6    (1U)          //!< Bit field size in bits for AIPS_PACRA_SP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_SP6 field.
#define BR_AIPS_PACRA_SP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_SP6))
#endif

//! @brief Format value for bitfield AIPS_PACRA_SP6.
#define BF_AIPS_PACRA_SP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_SP6), uint32_t) & BM_AIPS_PACRA_SP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP6 field to a new value.
#define BW_AIPS_PACRA_SP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_SP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRA_TP5    (8U)          //!< Bit position for AIPS_PACRA_TP5.
#define BM_AIPS_PACRA_TP5    (0x00000100U) //!< Bit mask for AIPS_PACRA_TP5.
#define BS_AIPS_PACRA_TP5    (1U)          //!< Bit field size in bits for AIPS_PACRA_TP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_TP5 field.
#define BR_AIPS_PACRA_TP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_TP5))
#endif

//! @brief Format value for bitfield AIPS_PACRA_TP5.
#define BF_AIPS_PACRA_TP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_TP5), uint32_t) & BM_AIPS_PACRA_TP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP5 field to a new value.
#define BW_AIPS_PACRA_TP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_TP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRA_WP5    (9U)          //!< Bit position for AIPS_PACRA_WP5.
#define BM_AIPS_PACRA_WP5    (0x00000200U) //!< Bit mask for AIPS_PACRA_WP5.
#define BS_AIPS_PACRA_WP5    (1U)          //!< Bit field size in bits for AIPS_PACRA_WP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_WP5 field.
#define BR_AIPS_PACRA_WP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_WP5))
#endif

//! @brief Format value for bitfield AIPS_PACRA_WP5.
#define BF_AIPS_PACRA_WP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_WP5), uint32_t) & BM_AIPS_PACRA_WP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP5 field to a new value.
#define BW_AIPS_PACRA_WP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_WP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRA_SP5    (10U)         //!< Bit position for AIPS_PACRA_SP5.
#define BM_AIPS_PACRA_SP5    (0x00000400U) //!< Bit mask for AIPS_PACRA_SP5.
#define BS_AIPS_PACRA_SP5    (1U)          //!< Bit field size in bits for AIPS_PACRA_SP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_SP5 field.
#define BR_AIPS_PACRA_SP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_SP5))
#endif

//! @brief Format value for bitfield AIPS_PACRA_SP5.
#define BF_AIPS_PACRA_SP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_SP5), uint32_t) & BM_AIPS_PACRA_SP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP5 field to a new value.
#define BW_AIPS_PACRA_SP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_SP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRA_TP4    (12U)         //!< Bit position for AIPS_PACRA_TP4.
#define BM_AIPS_PACRA_TP4    (0x00001000U) //!< Bit mask for AIPS_PACRA_TP4.
#define BS_AIPS_PACRA_TP4    (1U)          //!< Bit field size in bits for AIPS_PACRA_TP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_TP4 field.
#define BR_AIPS_PACRA_TP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_TP4))
#endif

//! @brief Format value for bitfield AIPS_PACRA_TP4.
#define BF_AIPS_PACRA_TP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_TP4), uint32_t) & BM_AIPS_PACRA_TP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP4 field to a new value.
#define BW_AIPS_PACRA_TP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_TP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRA_WP4    (13U)         //!< Bit position for AIPS_PACRA_WP4.
#define BM_AIPS_PACRA_WP4    (0x00002000U) //!< Bit mask for AIPS_PACRA_WP4.
#define BS_AIPS_PACRA_WP4    (1U)          //!< Bit field size in bits for AIPS_PACRA_WP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_WP4 field.
#define BR_AIPS_PACRA_WP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_WP4))
#endif

//! @brief Format value for bitfield AIPS_PACRA_WP4.
#define BF_AIPS_PACRA_WP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_WP4), uint32_t) & BM_AIPS_PACRA_WP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP4 field to a new value.
#define BW_AIPS_PACRA_WP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_WP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRA_SP4    (14U)         //!< Bit position for AIPS_PACRA_SP4.
#define BM_AIPS_PACRA_SP4    (0x00004000U) //!< Bit mask for AIPS_PACRA_SP4.
#define BS_AIPS_PACRA_SP4    (1U)          //!< Bit field size in bits for AIPS_PACRA_SP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_SP4 field.
#define BR_AIPS_PACRA_SP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_SP4))
#endif

//! @brief Format value for bitfield AIPS_PACRA_SP4.
#define BF_AIPS_PACRA_SP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_SP4), uint32_t) & BM_AIPS_PACRA_SP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP4 field to a new value.
#define BW_AIPS_PACRA_SP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_SP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRA_TP3    (16U)         //!< Bit position for AIPS_PACRA_TP3.
#define BM_AIPS_PACRA_TP3    (0x00010000U) //!< Bit mask for AIPS_PACRA_TP3.
#define BS_AIPS_PACRA_TP3    (1U)          //!< Bit field size in bits for AIPS_PACRA_TP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_TP3 field.
#define BR_AIPS_PACRA_TP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_TP3))
#endif

//! @brief Format value for bitfield AIPS_PACRA_TP3.
#define BF_AIPS_PACRA_TP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_TP3), uint32_t) & BM_AIPS_PACRA_TP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP3 field to a new value.
#define BW_AIPS_PACRA_TP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_TP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRA_WP3    (17U)         //!< Bit position for AIPS_PACRA_WP3.
#define BM_AIPS_PACRA_WP3    (0x00020000U) //!< Bit mask for AIPS_PACRA_WP3.
#define BS_AIPS_PACRA_WP3    (1U)          //!< Bit field size in bits for AIPS_PACRA_WP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_WP3 field.
#define BR_AIPS_PACRA_WP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_WP3))
#endif

//! @brief Format value for bitfield AIPS_PACRA_WP3.
#define BF_AIPS_PACRA_WP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_WP3), uint32_t) & BM_AIPS_PACRA_WP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP3 field to a new value.
#define BW_AIPS_PACRA_WP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_WP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRA_SP3    (18U)         //!< Bit position for AIPS_PACRA_SP3.
#define BM_AIPS_PACRA_SP3    (0x00040000U) //!< Bit mask for AIPS_PACRA_SP3.
#define BS_AIPS_PACRA_SP3    (1U)          //!< Bit field size in bits for AIPS_PACRA_SP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_SP3 field.
#define BR_AIPS_PACRA_SP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_SP3))
#endif

//! @brief Format value for bitfield AIPS_PACRA_SP3.
#define BF_AIPS_PACRA_SP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_SP3), uint32_t) & BM_AIPS_PACRA_SP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP3 field to a new value.
#define BW_AIPS_PACRA_SP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_SP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRA_TP2    (20U)         //!< Bit position for AIPS_PACRA_TP2.
#define BM_AIPS_PACRA_TP2    (0x00100000U) //!< Bit mask for AIPS_PACRA_TP2.
#define BS_AIPS_PACRA_TP2    (1U)          //!< Bit field size in bits for AIPS_PACRA_TP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_TP2 field.
#define BR_AIPS_PACRA_TP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_TP2))
#endif

//! @brief Format value for bitfield AIPS_PACRA_TP2.
#define BF_AIPS_PACRA_TP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_TP2), uint32_t) & BM_AIPS_PACRA_TP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP2 field to a new value.
#define BW_AIPS_PACRA_TP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_TP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRA_WP2    (21U)         //!< Bit position for AIPS_PACRA_WP2.
#define BM_AIPS_PACRA_WP2    (0x00200000U) //!< Bit mask for AIPS_PACRA_WP2.
#define BS_AIPS_PACRA_WP2    (1U)          //!< Bit field size in bits for AIPS_PACRA_WP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_WP2 field.
#define BR_AIPS_PACRA_WP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_WP2))
#endif

//! @brief Format value for bitfield AIPS_PACRA_WP2.
#define BF_AIPS_PACRA_WP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_WP2), uint32_t) & BM_AIPS_PACRA_WP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP2 field to a new value.
#define BW_AIPS_PACRA_WP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_WP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRA_SP2    (22U)         //!< Bit position for AIPS_PACRA_SP2.
#define BM_AIPS_PACRA_SP2    (0x00400000U) //!< Bit mask for AIPS_PACRA_SP2.
#define BS_AIPS_PACRA_SP2    (1U)          //!< Bit field size in bits for AIPS_PACRA_SP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_SP2 field.
#define BR_AIPS_PACRA_SP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_SP2))
#endif

//! @brief Format value for bitfield AIPS_PACRA_SP2.
#define BF_AIPS_PACRA_SP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_SP2), uint32_t) & BM_AIPS_PACRA_SP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP2 field to a new value.
#define BW_AIPS_PACRA_SP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_SP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRA_TP1    (24U)         //!< Bit position for AIPS_PACRA_TP1.
#define BM_AIPS_PACRA_TP1    (0x01000000U) //!< Bit mask for AIPS_PACRA_TP1.
#define BS_AIPS_PACRA_TP1    (1U)          //!< Bit field size in bits for AIPS_PACRA_TP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_TP1 field.
#define BR_AIPS_PACRA_TP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_TP1))
#endif

//! @brief Format value for bitfield AIPS_PACRA_TP1.
#define BF_AIPS_PACRA_TP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_TP1), uint32_t) & BM_AIPS_PACRA_TP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP1 field to a new value.
#define BW_AIPS_PACRA_TP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_TP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRA_WP1    (25U)         //!< Bit position for AIPS_PACRA_WP1.
#define BM_AIPS_PACRA_WP1    (0x02000000U) //!< Bit mask for AIPS_PACRA_WP1.
#define BS_AIPS_PACRA_WP1    (1U)          //!< Bit field size in bits for AIPS_PACRA_WP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_WP1 field.
#define BR_AIPS_PACRA_WP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_WP1))
#endif

//! @brief Format value for bitfield AIPS_PACRA_WP1.
#define BF_AIPS_PACRA_WP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_WP1), uint32_t) & BM_AIPS_PACRA_WP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP1 field to a new value.
#define BW_AIPS_PACRA_WP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_WP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRA_SP1    (26U)         //!< Bit position for AIPS_PACRA_SP1.
#define BM_AIPS_PACRA_SP1    (0x04000000U) //!< Bit mask for AIPS_PACRA_SP1.
#define BS_AIPS_PACRA_SP1    (1U)          //!< Bit field size in bits for AIPS_PACRA_SP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_SP1 field.
#define BR_AIPS_PACRA_SP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_SP1))
#endif

//! @brief Format value for bitfield AIPS_PACRA_SP1.
#define BF_AIPS_PACRA_SP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_SP1), uint32_t) & BM_AIPS_PACRA_SP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP1 field to a new value.
#define BW_AIPS_PACRA_SP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_SP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRA_TP0    (28U)         //!< Bit position for AIPS_PACRA_TP0.
#define BM_AIPS_PACRA_TP0    (0x10000000U) //!< Bit mask for AIPS_PACRA_TP0.
#define BS_AIPS_PACRA_TP0    (1U)          //!< Bit field size in bits for AIPS_PACRA_TP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_TP0 field.
#define BR_AIPS_PACRA_TP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_TP0))
#endif

//! @brief Format value for bitfield AIPS_PACRA_TP0.
#define BF_AIPS_PACRA_TP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_TP0), uint32_t) & BM_AIPS_PACRA_TP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP0 field to a new value.
#define BW_AIPS_PACRA_TP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_TP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRA_WP0    (29U)         //!< Bit position for AIPS_PACRA_WP0.
#define BM_AIPS_PACRA_WP0    (0x20000000U) //!< Bit mask for AIPS_PACRA_WP0.
#define BS_AIPS_PACRA_WP0    (1U)          //!< Bit field size in bits for AIPS_PACRA_WP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_WP0 field.
#define BR_AIPS_PACRA_WP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_WP0))
#endif

//! @brief Format value for bitfield AIPS_PACRA_WP0.
#define BF_AIPS_PACRA_WP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_WP0), uint32_t) & BM_AIPS_PACRA_WP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP0 field to a new value.
#define BW_AIPS_PACRA_WP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_WP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRA, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRA_SP0    (30U)         //!< Bit position for AIPS_PACRA_SP0.
#define BM_AIPS_PACRA_SP0    (0x40000000U) //!< Bit mask for AIPS_PACRA_SP0.
#define BS_AIPS_PACRA_SP0    (1U)          //!< Bit field size in bits for AIPS_PACRA_SP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRA_SP0 field.
#define BR_AIPS_PACRA_SP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_SP0))
#endif

//! @brief Format value for bitfield AIPS_PACRA_SP0.
#define BF_AIPS_PACRA_SP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRA_SP0), uint32_t) & BM_AIPS_PACRA_SP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP0 field to a new value.
#define BW_AIPS_PACRA_SP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRA_ADDR(x), BP_AIPS_PACRA_SP0) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AIPS_PACRB - Peripheral Access Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AIPS_PACRB - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44004400U
 *
 * Each PACR register consists of eight 4-bit PACR fields. Each PACR field
 * defines the access levels for a particular peripheral. The mapping between a
 * peripheral and its PACR field is shown in the table below. The peripheral assignment
 * to each PACR is defined by the memory map slot that the peripheral is
 * assigned to. See this chip's memory map for the assignment of a particular
 * peripheral. The following table shows the location of each peripheral slot's PACR field
 * in the PACR registers. Offset Register [31:28] [27:24] [23:20] [19:16] [15:12]
 * [11:8] [7:4] [3:0] 0x20 PACRA PACR0 PACR1 PACR2 PACR3 PACR4 PACR5 PACR6 PACR7
 * 0x24 PACRB PACR8 PACR9 PACR10 PACR11 PACR12 PACR13 PACR14 PACR15 0x28 PACRC
 * PACR16 PACR17 PACR18 PACR19 PACR20 PACR21 PACR22 PACR23 0x2C PACRD PACR24
 * PACR25 PACR26 PACR27 PACR28 PACR29 PACR30 PACR31 0x30 Reserved 0x34 Reserved 0x38
 * Reserved 0x3C Reserved 0x40 PACRE PACR32 PACR33 PACR34 PACR35 PACR36 PACR37
 * PACR38 PACR39 0x44 PACRF PACR40 PACR41 PACR42 PACR43 PACR44 PACR45 PACR46 PACR47
 * 0x48 PACRG PACR48 PACR49 PACR50 PACR51 PACR52 PACR53 PACR54 PACR55 0x4C PACRH
 * PACR56 PACR57 PACR58 PACR59 PACR60 PACR61 PACR62 PACR63 0x50 PACRI PACR64
 * PACR65 PACR66 PACR67 PACR68 PACR69 PACR70 PACR71 0x54 PACRJ PACR72 PACR73 PACR74
 * PACR75 PACR76 PACR77 PACR78 PACR79 0x58 PACRK PACR80 PACR81 PACR82 PACR83
 * PACR84 PACR85 PACR86 PACR87 0x5C PACRL PACR88 PACR89 PACR90 PACR91 PACR92 PACR93
 * PACR94 PACR95 0x60 PACRM PACR96 PACR97 PACR98 PACR99 PACR100 PACR101 PACR102
 * PACR103 0x64 PACRN PACR104 PACR105 PACR106 PACR107 PACR108 PACR109 PACR110
 * PACR111 0x68 PACRO PACR112 PACR113 PACR114 PACR115 PACR116 PACR117 PACR118 PACR119
 * 0x6C PACRP PACR120 PACR121 PACR122 PACR123 PACR124 PACR125 PACR126 PACR127 0x80
 * PACRU PACR GBL0 PACR GBL1 Reserved The register field descriptions for PACR
 * A-D, which control peripheral slots 0-31, are shown below. The following
 * section, PACRPeripheral Access Control Register , shows the register field
 * descriptions for PACR E-P. All PACR registers are identical. They are divided into two
 * sections because they occupy two non-contiguous address spaces.
 */
typedef union _hw_aips_pacrb
{
    uint32_t U;
    struct _hw_aips_pacrb_bitfields
    {
        uint32_t TP7 : 1;              //!< [0] Trusted Protect
        uint32_t WP7 : 1;              //!< [1] Write Protect
        uint32_t SP7 : 1;              //!< [2] Supervisor Protect
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t TP6 : 1;              //!< [4] Trusted Protect
        uint32_t WP6 : 1;              //!< [5] Write Protect
        uint32_t SP6 : 1;              //!< [6] Supervisor Protect
        uint32_t RESERVED1 : 1;        //!< [7]
        uint32_t TP5 : 1;              //!< [8] Trusted Protect
        uint32_t WP5 : 1;              //!< [9] Write Protect
        uint32_t SP5 : 1;              //!< [10] Supervisor Protect
        uint32_t RESERVED2 : 1;        //!< [11]
        uint32_t TP4 : 1;              //!< [12] Trusted Protect
        uint32_t WP4 : 1;              //!< [13] Write Protect
        uint32_t SP4 : 1;              //!< [14] Supervisor Protect
        uint32_t RESERVED3 : 1;        //!< [15]
        uint32_t TP3 : 1;              //!< [16] Trusted Protect
        uint32_t WP3 : 1;              //!< [17] Write Protect
        uint32_t SP3 : 1;              //!< [18] Supervisor Protect
        uint32_t RESERVED4 : 1;        //!< [19]
        uint32_t TP2 : 1;              //!< [20] Trusted Protect
        uint32_t WP2 : 1;              //!< [21] Write Protect
        uint32_t SP2 : 1;              //!< [22] Supervisor Protect
        uint32_t RESERVED5 : 1;        //!< [23]
        uint32_t TP1 : 1;              //!< [24] Trusted Protect
        uint32_t WP1 : 1;              //!< [25] Write Protect
        uint32_t SP1 : 1;              //!< [26] Supervisor Protect
        uint32_t RESERVED6 : 1;        //!< [27]
        uint32_t TP0 : 1;              //!< [28] Trusted Protect
        uint32_t WP0 : 1;              //!< [29] Write Protect
        uint32_t SP0 : 1;              //!< [30] Supervisor Protect
        uint32_t RESERVED7 : 1;        //!< [31]
    } B;
} hw_aips_pacrb_t;
#endif

/*!
 * @name Constants and macros for entire AIPS_PACRB register
 */
//@{
#define HW_AIPS_PACRB_ADDR(x)    (REGS_AIPS_BASE(x) + 0x24U)

#ifndef __LANGUAGE_ASM__
#define HW_AIPS_PACRB(x)         (*(__IO hw_aips_pacrb_t *) HW_AIPS_PACRB_ADDR(x))
#define HW_AIPS_PACRB_RD(x)      (HW_AIPS_PACRB(x).U)
#define HW_AIPS_PACRB_WR(x, v)   (HW_AIPS_PACRB(x).U = (v))
#define HW_AIPS_PACRB_SET(x, v)  (HW_AIPS_PACRB_WR(x, HW_AIPS_PACRB_RD(x) |  (v)))
#define HW_AIPS_PACRB_CLR(x, v)  (HW_AIPS_PACRB_WR(x, HW_AIPS_PACRB_RD(x) & ~(v)))
#define HW_AIPS_PACRB_TOG(x, v)  (HW_AIPS_PACRB_WR(x, HW_AIPS_PACRB_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AIPS_PACRB bitfields
 */

/*!
 * @name Register AIPS_PACRB, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRB_TP7    (0U)          //!< Bit position for AIPS_PACRB_TP7.
#define BM_AIPS_PACRB_TP7    (0x00000001U) //!< Bit mask for AIPS_PACRB_TP7.
#define BS_AIPS_PACRB_TP7    (1U)          //!< Bit field size in bits for AIPS_PACRB_TP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_TP7 field.
#define BR_AIPS_PACRB_TP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_TP7))
#endif

//! @brief Format value for bitfield AIPS_PACRB_TP7.
#define BF_AIPS_PACRB_TP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_TP7), uint32_t) & BM_AIPS_PACRB_TP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP7 field to a new value.
#define BW_AIPS_PACRB_TP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_TP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRB_WP7    (1U)          //!< Bit position for AIPS_PACRB_WP7.
#define BM_AIPS_PACRB_WP7    (0x00000002U) //!< Bit mask for AIPS_PACRB_WP7.
#define BS_AIPS_PACRB_WP7    (1U)          //!< Bit field size in bits for AIPS_PACRB_WP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_WP7 field.
#define BR_AIPS_PACRB_WP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_WP7))
#endif

//! @brief Format value for bitfield AIPS_PACRB_WP7.
#define BF_AIPS_PACRB_WP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_WP7), uint32_t) & BM_AIPS_PACRB_WP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP7 field to a new value.
#define BW_AIPS_PACRB_WP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_WP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRB_SP7    (2U)          //!< Bit position for AIPS_PACRB_SP7.
#define BM_AIPS_PACRB_SP7    (0x00000004U) //!< Bit mask for AIPS_PACRB_SP7.
#define BS_AIPS_PACRB_SP7    (1U)          //!< Bit field size in bits for AIPS_PACRB_SP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_SP7 field.
#define BR_AIPS_PACRB_SP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_SP7))
#endif

//! @brief Format value for bitfield AIPS_PACRB_SP7.
#define BF_AIPS_PACRB_SP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_SP7), uint32_t) & BM_AIPS_PACRB_SP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP7 field to a new value.
#define BW_AIPS_PACRB_SP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_SP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRB_TP6    (4U)          //!< Bit position for AIPS_PACRB_TP6.
#define BM_AIPS_PACRB_TP6    (0x00000010U) //!< Bit mask for AIPS_PACRB_TP6.
#define BS_AIPS_PACRB_TP6    (1U)          //!< Bit field size in bits for AIPS_PACRB_TP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_TP6 field.
#define BR_AIPS_PACRB_TP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_TP6))
#endif

//! @brief Format value for bitfield AIPS_PACRB_TP6.
#define BF_AIPS_PACRB_TP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_TP6), uint32_t) & BM_AIPS_PACRB_TP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP6 field to a new value.
#define BW_AIPS_PACRB_TP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_TP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRB_WP6    (5U)          //!< Bit position for AIPS_PACRB_WP6.
#define BM_AIPS_PACRB_WP6    (0x00000020U) //!< Bit mask for AIPS_PACRB_WP6.
#define BS_AIPS_PACRB_WP6    (1U)          //!< Bit field size in bits for AIPS_PACRB_WP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_WP6 field.
#define BR_AIPS_PACRB_WP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_WP6))
#endif

//! @brief Format value for bitfield AIPS_PACRB_WP6.
#define BF_AIPS_PACRB_WP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_WP6), uint32_t) & BM_AIPS_PACRB_WP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP6 field to a new value.
#define BW_AIPS_PACRB_WP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_WP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRB_SP6    (6U)          //!< Bit position for AIPS_PACRB_SP6.
#define BM_AIPS_PACRB_SP6    (0x00000040U) //!< Bit mask for AIPS_PACRB_SP6.
#define BS_AIPS_PACRB_SP6    (1U)          //!< Bit field size in bits for AIPS_PACRB_SP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_SP6 field.
#define BR_AIPS_PACRB_SP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_SP6))
#endif

//! @brief Format value for bitfield AIPS_PACRB_SP6.
#define BF_AIPS_PACRB_SP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_SP6), uint32_t) & BM_AIPS_PACRB_SP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP6 field to a new value.
#define BW_AIPS_PACRB_SP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_SP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRB_TP5    (8U)          //!< Bit position for AIPS_PACRB_TP5.
#define BM_AIPS_PACRB_TP5    (0x00000100U) //!< Bit mask for AIPS_PACRB_TP5.
#define BS_AIPS_PACRB_TP5    (1U)          //!< Bit field size in bits for AIPS_PACRB_TP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_TP5 field.
#define BR_AIPS_PACRB_TP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_TP5))
#endif

//! @brief Format value for bitfield AIPS_PACRB_TP5.
#define BF_AIPS_PACRB_TP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_TP5), uint32_t) & BM_AIPS_PACRB_TP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP5 field to a new value.
#define BW_AIPS_PACRB_TP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_TP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRB_WP5    (9U)          //!< Bit position for AIPS_PACRB_WP5.
#define BM_AIPS_PACRB_WP5    (0x00000200U) //!< Bit mask for AIPS_PACRB_WP5.
#define BS_AIPS_PACRB_WP5    (1U)          //!< Bit field size in bits for AIPS_PACRB_WP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_WP5 field.
#define BR_AIPS_PACRB_WP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_WP5))
#endif

//! @brief Format value for bitfield AIPS_PACRB_WP5.
#define BF_AIPS_PACRB_WP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_WP5), uint32_t) & BM_AIPS_PACRB_WP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP5 field to a new value.
#define BW_AIPS_PACRB_WP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_WP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRB_SP5    (10U)         //!< Bit position for AIPS_PACRB_SP5.
#define BM_AIPS_PACRB_SP5    (0x00000400U) //!< Bit mask for AIPS_PACRB_SP5.
#define BS_AIPS_PACRB_SP5    (1U)          //!< Bit field size in bits for AIPS_PACRB_SP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_SP5 field.
#define BR_AIPS_PACRB_SP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_SP5))
#endif

//! @brief Format value for bitfield AIPS_PACRB_SP5.
#define BF_AIPS_PACRB_SP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_SP5), uint32_t) & BM_AIPS_PACRB_SP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP5 field to a new value.
#define BW_AIPS_PACRB_SP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_SP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRB_TP4    (12U)         //!< Bit position for AIPS_PACRB_TP4.
#define BM_AIPS_PACRB_TP4    (0x00001000U) //!< Bit mask for AIPS_PACRB_TP4.
#define BS_AIPS_PACRB_TP4    (1U)          //!< Bit field size in bits for AIPS_PACRB_TP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_TP4 field.
#define BR_AIPS_PACRB_TP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_TP4))
#endif

//! @brief Format value for bitfield AIPS_PACRB_TP4.
#define BF_AIPS_PACRB_TP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_TP4), uint32_t) & BM_AIPS_PACRB_TP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP4 field to a new value.
#define BW_AIPS_PACRB_TP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_TP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRB_WP4    (13U)         //!< Bit position for AIPS_PACRB_WP4.
#define BM_AIPS_PACRB_WP4    (0x00002000U) //!< Bit mask for AIPS_PACRB_WP4.
#define BS_AIPS_PACRB_WP4    (1U)          //!< Bit field size in bits for AIPS_PACRB_WP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_WP4 field.
#define BR_AIPS_PACRB_WP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_WP4))
#endif

//! @brief Format value for bitfield AIPS_PACRB_WP4.
#define BF_AIPS_PACRB_WP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_WP4), uint32_t) & BM_AIPS_PACRB_WP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP4 field to a new value.
#define BW_AIPS_PACRB_WP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_WP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRB_SP4    (14U)         //!< Bit position for AIPS_PACRB_SP4.
#define BM_AIPS_PACRB_SP4    (0x00004000U) //!< Bit mask for AIPS_PACRB_SP4.
#define BS_AIPS_PACRB_SP4    (1U)          //!< Bit field size in bits for AIPS_PACRB_SP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_SP4 field.
#define BR_AIPS_PACRB_SP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_SP4))
#endif

//! @brief Format value for bitfield AIPS_PACRB_SP4.
#define BF_AIPS_PACRB_SP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_SP4), uint32_t) & BM_AIPS_PACRB_SP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP4 field to a new value.
#define BW_AIPS_PACRB_SP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_SP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRB_TP3    (16U)         //!< Bit position for AIPS_PACRB_TP3.
#define BM_AIPS_PACRB_TP3    (0x00010000U) //!< Bit mask for AIPS_PACRB_TP3.
#define BS_AIPS_PACRB_TP3    (1U)          //!< Bit field size in bits for AIPS_PACRB_TP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_TP3 field.
#define BR_AIPS_PACRB_TP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_TP3))
#endif

//! @brief Format value for bitfield AIPS_PACRB_TP3.
#define BF_AIPS_PACRB_TP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_TP3), uint32_t) & BM_AIPS_PACRB_TP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP3 field to a new value.
#define BW_AIPS_PACRB_TP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_TP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRB_WP3    (17U)         //!< Bit position for AIPS_PACRB_WP3.
#define BM_AIPS_PACRB_WP3    (0x00020000U) //!< Bit mask for AIPS_PACRB_WP3.
#define BS_AIPS_PACRB_WP3    (1U)          //!< Bit field size in bits for AIPS_PACRB_WP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_WP3 field.
#define BR_AIPS_PACRB_WP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_WP3))
#endif

//! @brief Format value for bitfield AIPS_PACRB_WP3.
#define BF_AIPS_PACRB_WP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_WP3), uint32_t) & BM_AIPS_PACRB_WP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP3 field to a new value.
#define BW_AIPS_PACRB_WP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_WP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRB_SP3    (18U)         //!< Bit position for AIPS_PACRB_SP3.
#define BM_AIPS_PACRB_SP3    (0x00040000U) //!< Bit mask for AIPS_PACRB_SP3.
#define BS_AIPS_PACRB_SP3    (1U)          //!< Bit field size in bits for AIPS_PACRB_SP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_SP3 field.
#define BR_AIPS_PACRB_SP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_SP3))
#endif

//! @brief Format value for bitfield AIPS_PACRB_SP3.
#define BF_AIPS_PACRB_SP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_SP3), uint32_t) & BM_AIPS_PACRB_SP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP3 field to a new value.
#define BW_AIPS_PACRB_SP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_SP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRB_TP2    (20U)         //!< Bit position for AIPS_PACRB_TP2.
#define BM_AIPS_PACRB_TP2    (0x00100000U) //!< Bit mask for AIPS_PACRB_TP2.
#define BS_AIPS_PACRB_TP2    (1U)          //!< Bit field size in bits for AIPS_PACRB_TP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_TP2 field.
#define BR_AIPS_PACRB_TP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_TP2))
#endif

//! @brief Format value for bitfield AIPS_PACRB_TP2.
#define BF_AIPS_PACRB_TP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_TP2), uint32_t) & BM_AIPS_PACRB_TP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP2 field to a new value.
#define BW_AIPS_PACRB_TP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_TP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRB_WP2    (21U)         //!< Bit position for AIPS_PACRB_WP2.
#define BM_AIPS_PACRB_WP2    (0x00200000U) //!< Bit mask for AIPS_PACRB_WP2.
#define BS_AIPS_PACRB_WP2    (1U)          //!< Bit field size in bits for AIPS_PACRB_WP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_WP2 field.
#define BR_AIPS_PACRB_WP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_WP2))
#endif

//! @brief Format value for bitfield AIPS_PACRB_WP2.
#define BF_AIPS_PACRB_WP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_WP2), uint32_t) & BM_AIPS_PACRB_WP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP2 field to a new value.
#define BW_AIPS_PACRB_WP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_WP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRB_SP2    (22U)         //!< Bit position for AIPS_PACRB_SP2.
#define BM_AIPS_PACRB_SP2    (0x00400000U) //!< Bit mask for AIPS_PACRB_SP2.
#define BS_AIPS_PACRB_SP2    (1U)          //!< Bit field size in bits for AIPS_PACRB_SP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_SP2 field.
#define BR_AIPS_PACRB_SP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_SP2))
#endif

//! @brief Format value for bitfield AIPS_PACRB_SP2.
#define BF_AIPS_PACRB_SP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_SP2), uint32_t) & BM_AIPS_PACRB_SP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP2 field to a new value.
#define BW_AIPS_PACRB_SP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_SP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRB_TP1    (24U)         //!< Bit position for AIPS_PACRB_TP1.
#define BM_AIPS_PACRB_TP1    (0x01000000U) //!< Bit mask for AIPS_PACRB_TP1.
#define BS_AIPS_PACRB_TP1    (1U)          //!< Bit field size in bits for AIPS_PACRB_TP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_TP1 field.
#define BR_AIPS_PACRB_TP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_TP1))
#endif

//! @brief Format value for bitfield AIPS_PACRB_TP1.
#define BF_AIPS_PACRB_TP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_TP1), uint32_t) & BM_AIPS_PACRB_TP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP1 field to a new value.
#define BW_AIPS_PACRB_TP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_TP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRB_WP1    (25U)         //!< Bit position for AIPS_PACRB_WP1.
#define BM_AIPS_PACRB_WP1    (0x02000000U) //!< Bit mask for AIPS_PACRB_WP1.
#define BS_AIPS_PACRB_WP1    (1U)          //!< Bit field size in bits for AIPS_PACRB_WP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_WP1 field.
#define BR_AIPS_PACRB_WP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_WP1))
#endif

//! @brief Format value for bitfield AIPS_PACRB_WP1.
#define BF_AIPS_PACRB_WP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_WP1), uint32_t) & BM_AIPS_PACRB_WP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP1 field to a new value.
#define BW_AIPS_PACRB_WP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_WP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRB_SP1    (26U)         //!< Bit position for AIPS_PACRB_SP1.
#define BM_AIPS_PACRB_SP1    (0x04000000U) //!< Bit mask for AIPS_PACRB_SP1.
#define BS_AIPS_PACRB_SP1    (1U)          //!< Bit field size in bits for AIPS_PACRB_SP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_SP1 field.
#define BR_AIPS_PACRB_SP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_SP1))
#endif

//! @brief Format value for bitfield AIPS_PACRB_SP1.
#define BF_AIPS_PACRB_SP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_SP1), uint32_t) & BM_AIPS_PACRB_SP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP1 field to a new value.
#define BW_AIPS_PACRB_SP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_SP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRB_TP0    (28U)         //!< Bit position for AIPS_PACRB_TP0.
#define BM_AIPS_PACRB_TP0    (0x10000000U) //!< Bit mask for AIPS_PACRB_TP0.
#define BS_AIPS_PACRB_TP0    (1U)          //!< Bit field size in bits for AIPS_PACRB_TP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_TP0 field.
#define BR_AIPS_PACRB_TP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_TP0))
#endif

//! @brief Format value for bitfield AIPS_PACRB_TP0.
#define BF_AIPS_PACRB_TP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_TP0), uint32_t) & BM_AIPS_PACRB_TP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP0 field to a new value.
#define BW_AIPS_PACRB_TP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_TP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRB_WP0    (29U)         //!< Bit position for AIPS_PACRB_WP0.
#define BM_AIPS_PACRB_WP0    (0x20000000U) //!< Bit mask for AIPS_PACRB_WP0.
#define BS_AIPS_PACRB_WP0    (1U)          //!< Bit field size in bits for AIPS_PACRB_WP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_WP0 field.
#define BR_AIPS_PACRB_WP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_WP0))
#endif

//! @brief Format value for bitfield AIPS_PACRB_WP0.
#define BF_AIPS_PACRB_WP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_WP0), uint32_t) & BM_AIPS_PACRB_WP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP0 field to a new value.
#define BW_AIPS_PACRB_WP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_WP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRB, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRB_SP0    (30U)         //!< Bit position for AIPS_PACRB_SP0.
#define BM_AIPS_PACRB_SP0    (0x40000000U) //!< Bit mask for AIPS_PACRB_SP0.
#define BS_AIPS_PACRB_SP0    (1U)          //!< Bit field size in bits for AIPS_PACRB_SP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRB_SP0 field.
#define BR_AIPS_PACRB_SP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_SP0))
#endif

//! @brief Format value for bitfield AIPS_PACRB_SP0.
#define BF_AIPS_PACRB_SP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRB_SP0), uint32_t) & BM_AIPS_PACRB_SP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP0 field to a new value.
#define BW_AIPS_PACRB_SP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRB_ADDR(x), BP_AIPS_PACRB_SP0) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AIPS_PACRC - Peripheral Access Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AIPS_PACRC - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * Each PACR register consists of eight 4-bit PACR fields. Each PACR field
 * defines the access levels for a particular peripheral. The mapping between a
 * peripheral and its PACR field is shown in the table below. The peripheral assignment
 * to each PACR is defined by the memory map slot that the peripheral is
 * assigned to. See this chip's memory map for the assignment of a particular
 * peripheral. The following table shows the location of each peripheral slot's PACR field
 * in the PACR registers. Offset Register [31:28] [27:24] [23:20] [19:16] [15:12]
 * [11:8] [7:4] [3:0] 0x20 PACRA PACR0 PACR1 PACR2 PACR3 PACR4 PACR5 PACR6 PACR7
 * 0x24 PACRB PACR8 PACR9 PACR10 PACR11 PACR12 PACR13 PACR14 PACR15 0x28 PACRC
 * PACR16 PACR17 PACR18 PACR19 PACR20 PACR21 PACR22 PACR23 0x2C PACRD PACR24
 * PACR25 PACR26 PACR27 PACR28 PACR29 PACR30 PACR31 0x30 Reserved 0x34 Reserved 0x38
 * Reserved 0x3C Reserved 0x40 PACRE PACR32 PACR33 PACR34 PACR35 PACR36 PACR37
 * PACR38 PACR39 0x44 PACRF PACR40 PACR41 PACR42 PACR43 PACR44 PACR45 PACR46 PACR47
 * 0x48 PACRG PACR48 PACR49 PACR50 PACR51 PACR52 PACR53 PACR54 PACR55 0x4C PACRH
 * PACR56 PACR57 PACR58 PACR59 PACR60 PACR61 PACR62 PACR63 0x50 PACRI PACR64
 * PACR65 PACR66 PACR67 PACR68 PACR69 PACR70 PACR71 0x54 PACRJ PACR72 PACR73 PACR74
 * PACR75 PACR76 PACR77 PACR78 PACR79 0x58 PACRK PACR80 PACR81 PACR82 PACR83
 * PACR84 PACR85 PACR86 PACR87 0x5C PACRL PACR88 PACR89 PACR90 PACR91 PACR92 PACR93
 * PACR94 PACR95 0x60 PACRM PACR96 PACR97 PACR98 PACR99 PACR100 PACR101 PACR102
 * PACR103 0x64 PACRN PACR104 PACR105 PACR106 PACR107 PACR108 PACR109 PACR110
 * PACR111 0x68 PACRO PACR112 PACR113 PACR114 PACR115 PACR116 PACR117 PACR118 PACR119
 * 0x6C PACRP PACR120 PACR121 PACR122 PACR123 PACR124 PACR125 PACR126 PACR127 0x80
 * PACRU PACR GBL0 PACR GBL1 Reserved The register field descriptions for PACR
 * A-D, which control peripheral slots 0-31, are shown below. The following
 * section, PACRPeripheral Access Control Register , shows the register field
 * descriptions for PACR E-P. All PACR registers are identical. They are divided into two
 * sections because they occupy two non-contiguous address spaces.
 */
typedef union _hw_aips_pacrc
{
    uint32_t U;
    struct _hw_aips_pacrc_bitfields
    {
        uint32_t TP7 : 1;              //!< [0] Trusted Protect
        uint32_t WP7 : 1;              //!< [1] Write Protect
        uint32_t SP7 : 1;              //!< [2] Supervisor Protect
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t TP6 : 1;              //!< [4] Trusted Protect
        uint32_t WP6 : 1;              //!< [5] Write Protect
        uint32_t SP6 : 1;              //!< [6] Supervisor Protect
        uint32_t RESERVED1 : 1;        //!< [7]
        uint32_t TP5 : 1;              //!< [8] Trusted Protect
        uint32_t WP5 : 1;              //!< [9] Write Protect
        uint32_t SP5 : 1;              //!< [10] Supervisor Protect
        uint32_t RESERVED2 : 1;        //!< [11]
        uint32_t TP4 : 1;              //!< [12] Trusted Protect
        uint32_t WP4 : 1;              //!< [13] Write Protect
        uint32_t SP4 : 1;              //!< [14] Supervisor Protect
        uint32_t RESERVED3 : 1;        //!< [15]
        uint32_t TP3 : 1;              //!< [16] Trusted Protect
        uint32_t WP3 : 1;              //!< [17] Write Protect
        uint32_t SP3 : 1;              //!< [18] Supervisor Protect
        uint32_t RESERVED4 : 1;        //!< [19]
        uint32_t TP2 : 1;              //!< [20] Trusted Protect
        uint32_t WP2 : 1;              //!< [21] Write Protect
        uint32_t SP2 : 1;              //!< [22] Supervisor Protect
        uint32_t RESERVED5 : 1;        //!< [23]
        uint32_t TP1 : 1;              //!< [24] Trusted Protect
        uint32_t WP1 : 1;              //!< [25] Write Protect
        uint32_t SP1 : 1;              //!< [26] Supervisor Protect
        uint32_t RESERVED6 : 1;        //!< [27]
        uint32_t TP0 : 1;              //!< [28] Trusted Protect
        uint32_t WP0 : 1;              //!< [29] Write Protect
        uint32_t SP0 : 1;              //!< [30] Supervisor Protect
        uint32_t RESERVED7 : 1;        //!< [31]
    } B;
} hw_aips_pacrc_t;
#endif

/*!
 * @name Constants and macros for entire AIPS_PACRC register
 */
//@{
#define HW_AIPS_PACRC_ADDR(x)    (REGS_AIPS_BASE(x) + 0x28U)

#ifndef __LANGUAGE_ASM__
#define HW_AIPS_PACRC(x)         (*(__IO hw_aips_pacrc_t *) HW_AIPS_PACRC_ADDR(x))
#define HW_AIPS_PACRC_RD(x)      (HW_AIPS_PACRC(x).U)
#define HW_AIPS_PACRC_WR(x, v)   (HW_AIPS_PACRC(x).U = (v))
#define HW_AIPS_PACRC_SET(x, v)  (HW_AIPS_PACRC_WR(x, HW_AIPS_PACRC_RD(x) |  (v)))
#define HW_AIPS_PACRC_CLR(x, v)  (HW_AIPS_PACRC_WR(x, HW_AIPS_PACRC_RD(x) & ~(v)))
#define HW_AIPS_PACRC_TOG(x, v)  (HW_AIPS_PACRC_WR(x, HW_AIPS_PACRC_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AIPS_PACRC bitfields
 */

/*!
 * @name Register AIPS_PACRC, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRC_TP7    (0U)          //!< Bit position for AIPS_PACRC_TP7.
#define BM_AIPS_PACRC_TP7    (0x00000001U) //!< Bit mask for AIPS_PACRC_TP7.
#define BS_AIPS_PACRC_TP7    (1U)          //!< Bit field size in bits for AIPS_PACRC_TP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_TP7 field.
#define BR_AIPS_PACRC_TP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_TP7))
#endif

//! @brief Format value for bitfield AIPS_PACRC_TP7.
#define BF_AIPS_PACRC_TP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_TP7), uint32_t) & BM_AIPS_PACRC_TP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP7 field to a new value.
#define BW_AIPS_PACRC_TP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_TP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRC_WP7    (1U)          //!< Bit position for AIPS_PACRC_WP7.
#define BM_AIPS_PACRC_WP7    (0x00000002U) //!< Bit mask for AIPS_PACRC_WP7.
#define BS_AIPS_PACRC_WP7    (1U)          //!< Bit field size in bits for AIPS_PACRC_WP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_WP7 field.
#define BR_AIPS_PACRC_WP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_WP7))
#endif

//! @brief Format value for bitfield AIPS_PACRC_WP7.
#define BF_AIPS_PACRC_WP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_WP7), uint32_t) & BM_AIPS_PACRC_WP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP7 field to a new value.
#define BW_AIPS_PACRC_WP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_WP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRC_SP7    (2U)          //!< Bit position for AIPS_PACRC_SP7.
#define BM_AIPS_PACRC_SP7    (0x00000004U) //!< Bit mask for AIPS_PACRC_SP7.
#define BS_AIPS_PACRC_SP7    (1U)          //!< Bit field size in bits for AIPS_PACRC_SP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_SP7 field.
#define BR_AIPS_PACRC_SP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_SP7))
#endif

//! @brief Format value for bitfield AIPS_PACRC_SP7.
#define BF_AIPS_PACRC_SP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_SP7), uint32_t) & BM_AIPS_PACRC_SP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP7 field to a new value.
#define BW_AIPS_PACRC_SP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_SP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRC_TP6    (4U)          //!< Bit position for AIPS_PACRC_TP6.
#define BM_AIPS_PACRC_TP6    (0x00000010U) //!< Bit mask for AIPS_PACRC_TP6.
#define BS_AIPS_PACRC_TP6    (1U)          //!< Bit field size in bits for AIPS_PACRC_TP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_TP6 field.
#define BR_AIPS_PACRC_TP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_TP6))
#endif

//! @brief Format value for bitfield AIPS_PACRC_TP6.
#define BF_AIPS_PACRC_TP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_TP6), uint32_t) & BM_AIPS_PACRC_TP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP6 field to a new value.
#define BW_AIPS_PACRC_TP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_TP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRC_WP6    (5U)          //!< Bit position for AIPS_PACRC_WP6.
#define BM_AIPS_PACRC_WP6    (0x00000020U) //!< Bit mask for AIPS_PACRC_WP6.
#define BS_AIPS_PACRC_WP6    (1U)          //!< Bit field size in bits for AIPS_PACRC_WP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_WP6 field.
#define BR_AIPS_PACRC_WP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_WP6))
#endif

//! @brief Format value for bitfield AIPS_PACRC_WP6.
#define BF_AIPS_PACRC_WP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_WP6), uint32_t) & BM_AIPS_PACRC_WP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP6 field to a new value.
#define BW_AIPS_PACRC_WP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_WP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRC_SP6    (6U)          //!< Bit position for AIPS_PACRC_SP6.
#define BM_AIPS_PACRC_SP6    (0x00000040U) //!< Bit mask for AIPS_PACRC_SP6.
#define BS_AIPS_PACRC_SP6    (1U)          //!< Bit field size in bits for AIPS_PACRC_SP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_SP6 field.
#define BR_AIPS_PACRC_SP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_SP6))
#endif

//! @brief Format value for bitfield AIPS_PACRC_SP6.
#define BF_AIPS_PACRC_SP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_SP6), uint32_t) & BM_AIPS_PACRC_SP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP6 field to a new value.
#define BW_AIPS_PACRC_SP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_SP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRC_TP5    (8U)          //!< Bit position for AIPS_PACRC_TP5.
#define BM_AIPS_PACRC_TP5    (0x00000100U) //!< Bit mask for AIPS_PACRC_TP5.
#define BS_AIPS_PACRC_TP5    (1U)          //!< Bit field size in bits for AIPS_PACRC_TP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_TP5 field.
#define BR_AIPS_PACRC_TP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_TP5))
#endif

//! @brief Format value for bitfield AIPS_PACRC_TP5.
#define BF_AIPS_PACRC_TP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_TP5), uint32_t) & BM_AIPS_PACRC_TP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP5 field to a new value.
#define BW_AIPS_PACRC_TP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_TP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRC_WP5    (9U)          //!< Bit position for AIPS_PACRC_WP5.
#define BM_AIPS_PACRC_WP5    (0x00000200U) //!< Bit mask for AIPS_PACRC_WP5.
#define BS_AIPS_PACRC_WP5    (1U)          //!< Bit field size in bits for AIPS_PACRC_WP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_WP5 field.
#define BR_AIPS_PACRC_WP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_WP5))
#endif

//! @brief Format value for bitfield AIPS_PACRC_WP5.
#define BF_AIPS_PACRC_WP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_WP5), uint32_t) & BM_AIPS_PACRC_WP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP5 field to a new value.
#define BW_AIPS_PACRC_WP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_WP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRC_SP5    (10U)         //!< Bit position for AIPS_PACRC_SP5.
#define BM_AIPS_PACRC_SP5    (0x00000400U) //!< Bit mask for AIPS_PACRC_SP5.
#define BS_AIPS_PACRC_SP5    (1U)          //!< Bit field size in bits for AIPS_PACRC_SP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_SP5 field.
#define BR_AIPS_PACRC_SP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_SP5))
#endif

//! @brief Format value for bitfield AIPS_PACRC_SP5.
#define BF_AIPS_PACRC_SP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_SP5), uint32_t) & BM_AIPS_PACRC_SP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP5 field to a new value.
#define BW_AIPS_PACRC_SP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_SP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRC_TP4    (12U)         //!< Bit position for AIPS_PACRC_TP4.
#define BM_AIPS_PACRC_TP4    (0x00001000U) //!< Bit mask for AIPS_PACRC_TP4.
#define BS_AIPS_PACRC_TP4    (1U)          //!< Bit field size in bits for AIPS_PACRC_TP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_TP4 field.
#define BR_AIPS_PACRC_TP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_TP4))
#endif

//! @brief Format value for bitfield AIPS_PACRC_TP4.
#define BF_AIPS_PACRC_TP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_TP4), uint32_t) & BM_AIPS_PACRC_TP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP4 field to a new value.
#define BW_AIPS_PACRC_TP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_TP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRC_WP4    (13U)         //!< Bit position for AIPS_PACRC_WP4.
#define BM_AIPS_PACRC_WP4    (0x00002000U) //!< Bit mask for AIPS_PACRC_WP4.
#define BS_AIPS_PACRC_WP4    (1U)          //!< Bit field size in bits for AIPS_PACRC_WP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_WP4 field.
#define BR_AIPS_PACRC_WP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_WP4))
#endif

//! @brief Format value for bitfield AIPS_PACRC_WP4.
#define BF_AIPS_PACRC_WP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_WP4), uint32_t) & BM_AIPS_PACRC_WP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP4 field to a new value.
#define BW_AIPS_PACRC_WP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_WP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRC_SP4    (14U)         //!< Bit position for AIPS_PACRC_SP4.
#define BM_AIPS_PACRC_SP4    (0x00004000U) //!< Bit mask for AIPS_PACRC_SP4.
#define BS_AIPS_PACRC_SP4    (1U)          //!< Bit field size in bits for AIPS_PACRC_SP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_SP4 field.
#define BR_AIPS_PACRC_SP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_SP4))
#endif

//! @brief Format value for bitfield AIPS_PACRC_SP4.
#define BF_AIPS_PACRC_SP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_SP4), uint32_t) & BM_AIPS_PACRC_SP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP4 field to a new value.
#define BW_AIPS_PACRC_SP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_SP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRC_TP3    (16U)         //!< Bit position for AIPS_PACRC_TP3.
#define BM_AIPS_PACRC_TP3    (0x00010000U) //!< Bit mask for AIPS_PACRC_TP3.
#define BS_AIPS_PACRC_TP3    (1U)          //!< Bit field size in bits for AIPS_PACRC_TP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_TP3 field.
#define BR_AIPS_PACRC_TP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_TP3))
#endif

//! @brief Format value for bitfield AIPS_PACRC_TP3.
#define BF_AIPS_PACRC_TP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_TP3), uint32_t) & BM_AIPS_PACRC_TP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP3 field to a new value.
#define BW_AIPS_PACRC_TP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_TP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRC_WP3    (17U)         //!< Bit position for AIPS_PACRC_WP3.
#define BM_AIPS_PACRC_WP3    (0x00020000U) //!< Bit mask for AIPS_PACRC_WP3.
#define BS_AIPS_PACRC_WP3    (1U)          //!< Bit field size in bits for AIPS_PACRC_WP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_WP3 field.
#define BR_AIPS_PACRC_WP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_WP3))
#endif

//! @brief Format value for bitfield AIPS_PACRC_WP3.
#define BF_AIPS_PACRC_WP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_WP3), uint32_t) & BM_AIPS_PACRC_WP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP3 field to a new value.
#define BW_AIPS_PACRC_WP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_WP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRC_SP3    (18U)         //!< Bit position for AIPS_PACRC_SP3.
#define BM_AIPS_PACRC_SP3    (0x00040000U) //!< Bit mask for AIPS_PACRC_SP3.
#define BS_AIPS_PACRC_SP3    (1U)          //!< Bit field size in bits for AIPS_PACRC_SP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_SP3 field.
#define BR_AIPS_PACRC_SP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_SP3))
#endif

//! @brief Format value for bitfield AIPS_PACRC_SP3.
#define BF_AIPS_PACRC_SP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_SP3), uint32_t) & BM_AIPS_PACRC_SP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP3 field to a new value.
#define BW_AIPS_PACRC_SP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_SP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRC_TP2    (20U)         //!< Bit position for AIPS_PACRC_TP2.
#define BM_AIPS_PACRC_TP2    (0x00100000U) //!< Bit mask for AIPS_PACRC_TP2.
#define BS_AIPS_PACRC_TP2    (1U)          //!< Bit field size in bits for AIPS_PACRC_TP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_TP2 field.
#define BR_AIPS_PACRC_TP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_TP2))
#endif

//! @brief Format value for bitfield AIPS_PACRC_TP2.
#define BF_AIPS_PACRC_TP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_TP2), uint32_t) & BM_AIPS_PACRC_TP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP2 field to a new value.
#define BW_AIPS_PACRC_TP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_TP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRC_WP2    (21U)         //!< Bit position for AIPS_PACRC_WP2.
#define BM_AIPS_PACRC_WP2    (0x00200000U) //!< Bit mask for AIPS_PACRC_WP2.
#define BS_AIPS_PACRC_WP2    (1U)          //!< Bit field size in bits for AIPS_PACRC_WP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_WP2 field.
#define BR_AIPS_PACRC_WP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_WP2))
#endif

//! @brief Format value for bitfield AIPS_PACRC_WP2.
#define BF_AIPS_PACRC_WP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_WP2), uint32_t) & BM_AIPS_PACRC_WP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP2 field to a new value.
#define BW_AIPS_PACRC_WP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_WP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRC_SP2    (22U)         //!< Bit position for AIPS_PACRC_SP2.
#define BM_AIPS_PACRC_SP2    (0x00400000U) //!< Bit mask for AIPS_PACRC_SP2.
#define BS_AIPS_PACRC_SP2    (1U)          //!< Bit field size in bits for AIPS_PACRC_SP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_SP2 field.
#define BR_AIPS_PACRC_SP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_SP2))
#endif

//! @brief Format value for bitfield AIPS_PACRC_SP2.
#define BF_AIPS_PACRC_SP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_SP2), uint32_t) & BM_AIPS_PACRC_SP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP2 field to a new value.
#define BW_AIPS_PACRC_SP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_SP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRC_TP1    (24U)         //!< Bit position for AIPS_PACRC_TP1.
#define BM_AIPS_PACRC_TP1    (0x01000000U) //!< Bit mask for AIPS_PACRC_TP1.
#define BS_AIPS_PACRC_TP1    (1U)          //!< Bit field size in bits for AIPS_PACRC_TP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_TP1 field.
#define BR_AIPS_PACRC_TP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_TP1))
#endif

//! @brief Format value for bitfield AIPS_PACRC_TP1.
#define BF_AIPS_PACRC_TP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_TP1), uint32_t) & BM_AIPS_PACRC_TP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP1 field to a new value.
#define BW_AIPS_PACRC_TP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_TP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRC_WP1    (25U)         //!< Bit position for AIPS_PACRC_WP1.
#define BM_AIPS_PACRC_WP1    (0x02000000U) //!< Bit mask for AIPS_PACRC_WP1.
#define BS_AIPS_PACRC_WP1    (1U)          //!< Bit field size in bits for AIPS_PACRC_WP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_WP1 field.
#define BR_AIPS_PACRC_WP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_WP1))
#endif

//! @brief Format value for bitfield AIPS_PACRC_WP1.
#define BF_AIPS_PACRC_WP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_WP1), uint32_t) & BM_AIPS_PACRC_WP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP1 field to a new value.
#define BW_AIPS_PACRC_WP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_WP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRC_SP1    (26U)         //!< Bit position for AIPS_PACRC_SP1.
#define BM_AIPS_PACRC_SP1    (0x04000000U) //!< Bit mask for AIPS_PACRC_SP1.
#define BS_AIPS_PACRC_SP1    (1U)          //!< Bit field size in bits for AIPS_PACRC_SP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_SP1 field.
#define BR_AIPS_PACRC_SP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_SP1))
#endif

//! @brief Format value for bitfield AIPS_PACRC_SP1.
#define BF_AIPS_PACRC_SP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_SP1), uint32_t) & BM_AIPS_PACRC_SP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP1 field to a new value.
#define BW_AIPS_PACRC_SP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_SP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRC_TP0    (28U)         //!< Bit position for AIPS_PACRC_TP0.
#define BM_AIPS_PACRC_TP0    (0x10000000U) //!< Bit mask for AIPS_PACRC_TP0.
#define BS_AIPS_PACRC_TP0    (1U)          //!< Bit field size in bits for AIPS_PACRC_TP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_TP0 field.
#define BR_AIPS_PACRC_TP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_TP0))
#endif

//! @brief Format value for bitfield AIPS_PACRC_TP0.
#define BF_AIPS_PACRC_TP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_TP0), uint32_t) & BM_AIPS_PACRC_TP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP0 field to a new value.
#define BW_AIPS_PACRC_TP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_TP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRC_WP0    (29U)         //!< Bit position for AIPS_PACRC_WP0.
#define BM_AIPS_PACRC_WP0    (0x20000000U) //!< Bit mask for AIPS_PACRC_WP0.
#define BS_AIPS_PACRC_WP0    (1U)          //!< Bit field size in bits for AIPS_PACRC_WP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_WP0 field.
#define BR_AIPS_PACRC_WP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_WP0))
#endif

//! @brief Format value for bitfield AIPS_PACRC_WP0.
#define BF_AIPS_PACRC_WP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_WP0), uint32_t) & BM_AIPS_PACRC_WP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP0 field to a new value.
#define BW_AIPS_PACRC_WP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_WP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRC, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRC_SP0    (30U)         //!< Bit position for AIPS_PACRC_SP0.
#define BM_AIPS_PACRC_SP0    (0x40000000U) //!< Bit mask for AIPS_PACRC_SP0.
#define BS_AIPS_PACRC_SP0    (1U)          //!< Bit field size in bits for AIPS_PACRC_SP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRC_SP0 field.
#define BR_AIPS_PACRC_SP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_SP0))
#endif

//! @brief Format value for bitfield AIPS_PACRC_SP0.
#define BF_AIPS_PACRC_SP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRC_SP0), uint32_t) & BM_AIPS_PACRC_SP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP0 field to a new value.
#define BW_AIPS_PACRC_SP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRC_ADDR(x), BP_AIPS_PACRC_SP0) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AIPS_PACRD - Peripheral Access Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AIPS_PACRD - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x00000004U
 *
 * Each PACR register consists of eight 4-bit PACR fields. Each PACR field
 * defines the access levels for a particular peripheral. The mapping between a
 * peripheral and its PACR field is shown in the table below. The peripheral assignment
 * to each PACR is defined by the memory map slot that the peripheral is
 * assigned to. See this chip's memory map for the assignment of a particular
 * peripheral. The following table shows the location of each peripheral slot's PACR field
 * in the PACR registers. Offset Register [31:28] [27:24] [23:20] [19:16] [15:12]
 * [11:8] [7:4] [3:0] 0x20 PACRA PACR0 PACR1 PACR2 PACR3 PACR4 PACR5 PACR6 PACR7
 * 0x24 PACRB PACR8 PACR9 PACR10 PACR11 PACR12 PACR13 PACR14 PACR15 0x28 PACRC
 * PACR16 PACR17 PACR18 PACR19 PACR20 PACR21 PACR22 PACR23 0x2C PACRD PACR24
 * PACR25 PACR26 PACR27 PACR28 PACR29 PACR30 PACR31 0x30 Reserved 0x34 Reserved 0x38
 * Reserved 0x3C Reserved 0x40 PACRE PACR32 PACR33 PACR34 PACR35 PACR36 PACR37
 * PACR38 PACR39 0x44 PACRF PACR40 PACR41 PACR42 PACR43 PACR44 PACR45 PACR46 PACR47
 * 0x48 PACRG PACR48 PACR49 PACR50 PACR51 PACR52 PACR53 PACR54 PACR55 0x4C PACRH
 * PACR56 PACR57 PACR58 PACR59 PACR60 PACR61 PACR62 PACR63 0x50 PACRI PACR64
 * PACR65 PACR66 PACR67 PACR68 PACR69 PACR70 PACR71 0x54 PACRJ PACR72 PACR73 PACR74
 * PACR75 PACR76 PACR77 PACR78 PACR79 0x58 PACRK PACR80 PACR81 PACR82 PACR83
 * PACR84 PACR85 PACR86 PACR87 0x5C PACRL PACR88 PACR89 PACR90 PACR91 PACR92 PACR93
 * PACR94 PACR95 0x60 PACRM PACR96 PACR97 PACR98 PACR99 PACR100 PACR101 PACR102
 * PACR103 0x64 PACRN PACR104 PACR105 PACR106 PACR107 PACR108 PACR109 PACR110
 * PACR111 0x68 PACRO PACR112 PACR113 PACR114 PACR115 PACR116 PACR117 PACR118 PACR119
 * 0x6C PACRP PACR120 PACR121 PACR122 PACR123 PACR124 PACR125 PACR126 PACR127 0x80
 * PACRU PACR GBL0 PACR GBL1 Reserved The register field descriptions for PACR
 * A-D, which control peripheral slots 0-31, are shown below. The following
 * section, PACRPeripheral Access Control Register , shows the register field
 * descriptions for PACR E-P. All PACR registers are identical. They are divided into two
 * sections because they occupy two non-contiguous address spaces.
 */
typedef union _hw_aips_pacrd
{
    uint32_t U;
    struct _hw_aips_pacrd_bitfields
    {
        uint32_t TP7 : 1;              //!< [0] Trusted Protect
        uint32_t WP7 : 1;              //!< [1] Write Protect
        uint32_t SP7 : 1;              //!< [2] Supervisor Protect
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t TP6 : 1;              //!< [4] Trusted Protect
        uint32_t WP6 : 1;              //!< [5] Write Protect
        uint32_t SP6 : 1;              //!< [6] Supervisor Protect
        uint32_t RESERVED1 : 1;        //!< [7]
        uint32_t TP5 : 1;              //!< [8] Trusted Protect
        uint32_t WP5 : 1;              //!< [9] Write Protect
        uint32_t SP5 : 1;              //!< [10] Supervisor Protect
        uint32_t RESERVED2 : 1;        //!< [11]
        uint32_t TP4 : 1;              //!< [12] Trusted Protect
        uint32_t WP4 : 1;              //!< [13] Write Protect
        uint32_t SP4 : 1;              //!< [14] Supervisor Protect
        uint32_t RESERVED3 : 1;        //!< [15]
        uint32_t TP3 : 1;              //!< [16] Trusted Protect
        uint32_t WP3 : 1;              //!< [17] Write Protect
        uint32_t SP3 : 1;              //!< [18] Supervisor Protect
        uint32_t RESERVED4 : 1;        //!< [19]
        uint32_t TP2 : 1;              //!< [20] Trusted Protect
        uint32_t WP2 : 1;              //!< [21] Write Protect
        uint32_t SP2 : 1;              //!< [22] Supervisor Protect
        uint32_t RESERVED5 : 1;        //!< [23]
        uint32_t TP1 : 1;              //!< [24] Trusted Protect
        uint32_t WP1 : 1;              //!< [25] Write Protect
        uint32_t SP1 : 1;              //!< [26] Supervisor Protect
        uint32_t RESERVED6 : 1;        //!< [27]
        uint32_t TP0 : 1;              //!< [28] Trusted Protect
        uint32_t WP0 : 1;              //!< [29] Write Protect
        uint32_t SP0 : 1;              //!< [30] Supervisor Protect
        uint32_t RESERVED7 : 1;        //!< [31]
    } B;
} hw_aips_pacrd_t;
#endif

/*!
 * @name Constants and macros for entire AIPS_PACRD register
 */
//@{
#define HW_AIPS_PACRD_ADDR(x)    (REGS_AIPS_BASE(x) + 0x2CU)

#ifndef __LANGUAGE_ASM__
#define HW_AIPS_PACRD(x)         (*(__IO hw_aips_pacrd_t *) HW_AIPS_PACRD_ADDR(x))
#define HW_AIPS_PACRD_RD(x)      (HW_AIPS_PACRD(x).U)
#define HW_AIPS_PACRD_WR(x, v)   (HW_AIPS_PACRD(x).U = (v))
#define HW_AIPS_PACRD_SET(x, v)  (HW_AIPS_PACRD_WR(x, HW_AIPS_PACRD_RD(x) |  (v)))
#define HW_AIPS_PACRD_CLR(x, v)  (HW_AIPS_PACRD_WR(x, HW_AIPS_PACRD_RD(x) & ~(v)))
#define HW_AIPS_PACRD_TOG(x, v)  (HW_AIPS_PACRD_WR(x, HW_AIPS_PACRD_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AIPS_PACRD bitfields
 */

/*!
 * @name Register AIPS_PACRD, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRD_TP7    (0U)          //!< Bit position for AIPS_PACRD_TP7.
#define BM_AIPS_PACRD_TP7    (0x00000001U) //!< Bit mask for AIPS_PACRD_TP7.
#define BS_AIPS_PACRD_TP7    (1U)          //!< Bit field size in bits for AIPS_PACRD_TP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_TP7 field.
#define BR_AIPS_PACRD_TP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_TP7))
#endif

//! @brief Format value for bitfield AIPS_PACRD_TP7.
#define BF_AIPS_PACRD_TP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_TP7), uint32_t) & BM_AIPS_PACRD_TP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP7 field to a new value.
#define BW_AIPS_PACRD_TP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_TP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRD_WP7    (1U)          //!< Bit position for AIPS_PACRD_WP7.
#define BM_AIPS_PACRD_WP7    (0x00000002U) //!< Bit mask for AIPS_PACRD_WP7.
#define BS_AIPS_PACRD_WP7    (1U)          //!< Bit field size in bits for AIPS_PACRD_WP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_WP7 field.
#define BR_AIPS_PACRD_WP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_WP7))
#endif

//! @brief Format value for bitfield AIPS_PACRD_WP7.
#define BF_AIPS_PACRD_WP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_WP7), uint32_t) & BM_AIPS_PACRD_WP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP7 field to a new value.
#define BW_AIPS_PACRD_WP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_WP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRD_SP7    (2U)          //!< Bit position for AIPS_PACRD_SP7.
#define BM_AIPS_PACRD_SP7    (0x00000004U) //!< Bit mask for AIPS_PACRD_SP7.
#define BS_AIPS_PACRD_SP7    (1U)          //!< Bit field size in bits for AIPS_PACRD_SP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_SP7 field.
#define BR_AIPS_PACRD_SP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_SP7))
#endif

//! @brief Format value for bitfield AIPS_PACRD_SP7.
#define BF_AIPS_PACRD_SP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_SP7), uint32_t) & BM_AIPS_PACRD_SP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP7 field to a new value.
#define BW_AIPS_PACRD_SP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_SP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRD_TP6    (4U)          //!< Bit position for AIPS_PACRD_TP6.
#define BM_AIPS_PACRD_TP6    (0x00000010U) //!< Bit mask for AIPS_PACRD_TP6.
#define BS_AIPS_PACRD_TP6    (1U)          //!< Bit field size in bits for AIPS_PACRD_TP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_TP6 field.
#define BR_AIPS_PACRD_TP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_TP6))
#endif

//! @brief Format value for bitfield AIPS_PACRD_TP6.
#define BF_AIPS_PACRD_TP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_TP6), uint32_t) & BM_AIPS_PACRD_TP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP6 field to a new value.
#define BW_AIPS_PACRD_TP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_TP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRD_WP6    (5U)          //!< Bit position for AIPS_PACRD_WP6.
#define BM_AIPS_PACRD_WP6    (0x00000020U) //!< Bit mask for AIPS_PACRD_WP6.
#define BS_AIPS_PACRD_WP6    (1U)          //!< Bit field size in bits for AIPS_PACRD_WP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_WP6 field.
#define BR_AIPS_PACRD_WP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_WP6))
#endif

//! @brief Format value for bitfield AIPS_PACRD_WP6.
#define BF_AIPS_PACRD_WP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_WP6), uint32_t) & BM_AIPS_PACRD_WP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP6 field to a new value.
#define BW_AIPS_PACRD_WP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_WP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRD_SP6    (6U)          //!< Bit position for AIPS_PACRD_SP6.
#define BM_AIPS_PACRD_SP6    (0x00000040U) //!< Bit mask for AIPS_PACRD_SP6.
#define BS_AIPS_PACRD_SP6    (1U)          //!< Bit field size in bits for AIPS_PACRD_SP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_SP6 field.
#define BR_AIPS_PACRD_SP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_SP6))
#endif

//! @brief Format value for bitfield AIPS_PACRD_SP6.
#define BF_AIPS_PACRD_SP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_SP6), uint32_t) & BM_AIPS_PACRD_SP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP6 field to a new value.
#define BW_AIPS_PACRD_SP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_SP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRD_TP5    (8U)          //!< Bit position for AIPS_PACRD_TP5.
#define BM_AIPS_PACRD_TP5    (0x00000100U) //!< Bit mask for AIPS_PACRD_TP5.
#define BS_AIPS_PACRD_TP5    (1U)          //!< Bit field size in bits for AIPS_PACRD_TP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_TP5 field.
#define BR_AIPS_PACRD_TP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_TP5))
#endif

//! @brief Format value for bitfield AIPS_PACRD_TP5.
#define BF_AIPS_PACRD_TP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_TP5), uint32_t) & BM_AIPS_PACRD_TP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP5 field to a new value.
#define BW_AIPS_PACRD_TP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_TP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRD_WP5    (9U)          //!< Bit position for AIPS_PACRD_WP5.
#define BM_AIPS_PACRD_WP5    (0x00000200U) //!< Bit mask for AIPS_PACRD_WP5.
#define BS_AIPS_PACRD_WP5    (1U)          //!< Bit field size in bits for AIPS_PACRD_WP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_WP5 field.
#define BR_AIPS_PACRD_WP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_WP5))
#endif

//! @brief Format value for bitfield AIPS_PACRD_WP5.
#define BF_AIPS_PACRD_WP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_WP5), uint32_t) & BM_AIPS_PACRD_WP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP5 field to a new value.
#define BW_AIPS_PACRD_WP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_WP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRD_SP5    (10U)         //!< Bit position for AIPS_PACRD_SP5.
#define BM_AIPS_PACRD_SP5    (0x00000400U) //!< Bit mask for AIPS_PACRD_SP5.
#define BS_AIPS_PACRD_SP5    (1U)          //!< Bit field size in bits for AIPS_PACRD_SP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_SP5 field.
#define BR_AIPS_PACRD_SP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_SP5))
#endif

//! @brief Format value for bitfield AIPS_PACRD_SP5.
#define BF_AIPS_PACRD_SP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_SP5), uint32_t) & BM_AIPS_PACRD_SP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP5 field to a new value.
#define BW_AIPS_PACRD_SP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_SP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRD_TP4    (12U)         //!< Bit position for AIPS_PACRD_TP4.
#define BM_AIPS_PACRD_TP4    (0x00001000U) //!< Bit mask for AIPS_PACRD_TP4.
#define BS_AIPS_PACRD_TP4    (1U)          //!< Bit field size in bits for AIPS_PACRD_TP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_TP4 field.
#define BR_AIPS_PACRD_TP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_TP4))
#endif

//! @brief Format value for bitfield AIPS_PACRD_TP4.
#define BF_AIPS_PACRD_TP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_TP4), uint32_t) & BM_AIPS_PACRD_TP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP4 field to a new value.
#define BW_AIPS_PACRD_TP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_TP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRD_WP4    (13U)         //!< Bit position for AIPS_PACRD_WP4.
#define BM_AIPS_PACRD_WP4    (0x00002000U) //!< Bit mask for AIPS_PACRD_WP4.
#define BS_AIPS_PACRD_WP4    (1U)          //!< Bit field size in bits for AIPS_PACRD_WP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_WP4 field.
#define BR_AIPS_PACRD_WP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_WP4))
#endif

//! @brief Format value for bitfield AIPS_PACRD_WP4.
#define BF_AIPS_PACRD_WP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_WP4), uint32_t) & BM_AIPS_PACRD_WP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP4 field to a new value.
#define BW_AIPS_PACRD_WP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_WP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRD_SP4    (14U)         //!< Bit position for AIPS_PACRD_SP4.
#define BM_AIPS_PACRD_SP4    (0x00004000U) //!< Bit mask for AIPS_PACRD_SP4.
#define BS_AIPS_PACRD_SP4    (1U)          //!< Bit field size in bits for AIPS_PACRD_SP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_SP4 field.
#define BR_AIPS_PACRD_SP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_SP4))
#endif

//! @brief Format value for bitfield AIPS_PACRD_SP4.
#define BF_AIPS_PACRD_SP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_SP4), uint32_t) & BM_AIPS_PACRD_SP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP4 field to a new value.
#define BW_AIPS_PACRD_SP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_SP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRD_TP3    (16U)         //!< Bit position for AIPS_PACRD_TP3.
#define BM_AIPS_PACRD_TP3    (0x00010000U) //!< Bit mask for AIPS_PACRD_TP3.
#define BS_AIPS_PACRD_TP3    (1U)          //!< Bit field size in bits for AIPS_PACRD_TP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_TP3 field.
#define BR_AIPS_PACRD_TP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_TP3))
#endif

//! @brief Format value for bitfield AIPS_PACRD_TP3.
#define BF_AIPS_PACRD_TP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_TP3), uint32_t) & BM_AIPS_PACRD_TP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP3 field to a new value.
#define BW_AIPS_PACRD_TP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_TP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRD_WP3    (17U)         //!< Bit position for AIPS_PACRD_WP3.
#define BM_AIPS_PACRD_WP3    (0x00020000U) //!< Bit mask for AIPS_PACRD_WP3.
#define BS_AIPS_PACRD_WP3    (1U)          //!< Bit field size in bits for AIPS_PACRD_WP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_WP3 field.
#define BR_AIPS_PACRD_WP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_WP3))
#endif

//! @brief Format value for bitfield AIPS_PACRD_WP3.
#define BF_AIPS_PACRD_WP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_WP3), uint32_t) & BM_AIPS_PACRD_WP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP3 field to a new value.
#define BW_AIPS_PACRD_WP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_WP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRD_SP3    (18U)         //!< Bit position for AIPS_PACRD_SP3.
#define BM_AIPS_PACRD_SP3    (0x00040000U) //!< Bit mask for AIPS_PACRD_SP3.
#define BS_AIPS_PACRD_SP3    (1U)          //!< Bit field size in bits for AIPS_PACRD_SP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_SP3 field.
#define BR_AIPS_PACRD_SP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_SP3))
#endif

//! @brief Format value for bitfield AIPS_PACRD_SP3.
#define BF_AIPS_PACRD_SP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_SP3), uint32_t) & BM_AIPS_PACRD_SP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP3 field to a new value.
#define BW_AIPS_PACRD_SP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_SP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRD_TP2    (20U)         //!< Bit position for AIPS_PACRD_TP2.
#define BM_AIPS_PACRD_TP2    (0x00100000U) //!< Bit mask for AIPS_PACRD_TP2.
#define BS_AIPS_PACRD_TP2    (1U)          //!< Bit field size in bits for AIPS_PACRD_TP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_TP2 field.
#define BR_AIPS_PACRD_TP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_TP2))
#endif

//! @brief Format value for bitfield AIPS_PACRD_TP2.
#define BF_AIPS_PACRD_TP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_TP2), uint32_t) & BM_AIPS_PACRD_TP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP2 field to a new value.
#define BW_AIPS_PACRD_TP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_TP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRD_WP2    (21U)         //!< Bit position for AIPS_PACRD_WP2.
#define BM_AIPS_PACRD_WP2    (0x00200000U) //!< Bit mask for AIPS_PACRD_WP2.
#define BS_AIPS_PACRD_WP2    (1U)          //!< Bit field size in bits for AIPS_PACRD_WP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_WP2 field.
#define BR_AIPS_PACRD_WP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_WP2))
#endif

//! @brief Format value for bitfield AIPS_PACRD_WP2.
#define BF_AIPS_PACRD_WP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_WP2), uint32_t) & BM_AIPS_PACRD_WP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP2 field to a new value.
#define BW_AIPS_PACRD_WP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_WP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRD_SP2    (22U)         //!< Bit position for AIPS_PACRD_SP2.
#define BM_AIPS_PACRD_SP2    (0x00400000U) //!< Bit mask for AIPS_PACRD_SP2.
#define BS_AIPS_PACRD_SP2    (1U)          //!< Bit field size in bits for AIPS_PACRD_SP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_SP2 field.
#define BR_AIPS_PACRD_SP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_SP2))
#endif

//! @brief Format value for bitfield AIPS_PACRD_SP2.
#define BF_AIPS_PACRD_SP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_SP2), uint32_t) & BM_AIPS_PACRD_SP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP2 field to a new value.
#define BW_AIPS_PACRD_SP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_SP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRD_TP1    (24U)         //!< Bit position for AIPS_PACRD_TP1.
#define BM_AIPS_PACRD_TP1    (0x01000000U) //!< Bit mask for AIPS_PACRD_TP1.
#define BS_AIPS_PACRD_TP1    (1U)          //!< Bit field size in bits for AIPS_PACRD_TP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_TP1 field.
#define BR_AIPS_PACRD_TP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_TP1))
#endif

//! @brief Format value for bitfield AIPS_PACRD_TP1.
#define BF_AIPS_PACRD_TP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_TP1), uint32_t) & BM_AIPS_PACRD_TP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP1 field to a new value.
#define BW_AIPS_PACRD_TP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_TP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRD_WP1    (25U)         //!< Bit position for AIPS_PACRD_WP1.
#define BM_AIPS_PACRD_WP1    (0x02000000U) //!< Bit mask for AIPS_PACRD_WP1.
#define BS_AIPS_PACRD_WP1    (1U)          //!< Bit field size in bits for AIPS_PACRD_WP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_WP1 field.
#define BR_AIPS_PACRD_WP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_WP1))
#endif

//! @brief Format value for bitfield AIPS_PACRD_WP1.
#define BF_AIPS_PACRD_WP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_WP1), uint32_t) & BM_AIPS_PACRD_WP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP1 field to a new value.
#define BW_AIPS_PACRD_WP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_WP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRD_SP1    (26U)         //!< Bit position for AIPS_PACRD_SP1.
#define BM_AIPS_PACRD_SP1    (0x04000000U) //!< Bit mask for AIPS_PACRD_SP1.
#define BS_AIPS_PACRD_SP1    (1U)          //!< Bit field size in bits for AIPS_PACRD_SP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_SP1 field.
#define BR_AIPS_PACRD_SP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_SP1))
#endif

//! @brief Format value for bitfield AIPS_PACRD_SP1.
#define BF_AIPS_PACRD_SP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_SP1), uint32_t) & BM_AIPS_PACRD_SP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP1 field to a new value.
#define BW_AIPS_PACRD_SP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_SP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRD_TP0    (28U)         //!< Bit position for AIPS_PACRD_TP0.
#define BM_AIPS_PACRD_TP0    (0x10000000U) //!< Bit mask for AIPS_PACRD_TP0.
#define BS_AIPS_PACRD_TP0    (1U)          //!< Bit field size in bits for AIPS_PACRD_TP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_TP0 field.
#define BR_AIPS_PACRD_TP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_TP0))
#endif

//! @brief Format value for bitfield AIPS_PACRD_TP0.
#define BF_AIPS_PACRD_TP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_TP0), uint32_t) & BM_AIPS_PACRD_TP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP0 field to a new value.
#define BW_AIPS_PACRD_TP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_TP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRD_WP0    (29U)         //!< Bit position for AIPS_PACRD_WP0.
#define BM_AIPS_PACRD_WP0    (0x20000000U) //!< Bit mask for AIPS_PACRD_WP0.
#define BS_AIPS_PACRD_WP0    (1U)          //!< Bit field size in bits for AIPS_PACRD_WP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_WP0 field.
#define BR_AIPS_PACRD_WP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_WP0))
#endif

//! @brief Format value for bitfield AIPS_PACRD_WP0.
#define BF_AIPS_PACRD_WP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_WP0), uint32_t) & BM_AIPS_PACRD_WP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP0 field to a new value.
#define BW_AIPS_PACRD_WP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_WP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRD, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRD_SP0    (30U)         //!< Bit position for AIPS_PACRD_SP0.
#define BM_AIPS_PACRD_SP0    (0x40000000U) //!< Bit mask for AIPS_PACRD_SP0.
#define BS_AIPS_PACRD_SP0    (1U)          //!< Bit field size in bits for AIPS_PACRD_SP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRD_SP0 field.
#define BR_AIPS_PACRD_SP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_SP0))
#endif

//! @brief Format value for bitfield AIPS_PACRD_SP0.
#define BF_AIPS_PACRD_SP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRD_SP0), uint32_t) & BM_AIPS_PACRD_SP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP0 field to a new value.
#define BW_AIPS_PACRD_SP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRD_ADDR(x), BP_AIPS_PACRD_SP0) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AIPS_PACRE - Peripheral Access Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AIPS_PACRE - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
typedef union _hw_aips_pacre
{
    uint32_t U;
    struct _hw_aips_pacre_bitfields
    {
        uint32_t TP7 : 1;              //!< [0] Trusted Protect
        uint32_t WP7 : 1;              //!< [1] Write Protect
        uint32_t SP7 : 1;              //!< [2] Supervisor Protect
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t TP6 : 1;              //!< [4] Trusted Protect
        uint32_t WP6 : 1;              //!< [5] Write Protect
        uint32_t SP6 : 1;              //!< [6] Supervisor Protect
        uint32_t RESERVED1 : 1;        //!< [7]
        uint32_t TP5 : 1;              //!< [8] Trusted Protect
        uint32_t WP5 : 1;              //!< [9] Write Protect
        uint32_t SP5 : 1;              //!< [10] Supervisor Protect
        uint32_t RESERVED2 : 1;        //!< [11]
        uint32_t TP4 : 1;              //!< [12] Trusted Protect
        uint32_t WP4 : 1;              //!< [13] Write Protect
        uint32_t SP4 : 1;              //!< [14] Supervisor Protect
        uint32_t RESERVED3 : 1;        //!< [15]
        uint32_t TP3 : 1;              //!< [16] Trusted Protect
        uint32_t WP3 : 1;              //!< [17] Write Protect
        uint32_t SP3 : 1;              //!< [18] Supervisor Protect
        uint32_t RESERVED4 : 1;        //!< [19]
        uint32_t TP2 : 1;              //!< [20] Trusted Protect
        uint32_t WP2 : 1;              //!< [21] Write Protect
        uint32_t SP2 : 1;              //!< [22] Supervisor Protect
        uint32_t RESERVED5 : 1;        //!< [23]
        uint32_t TP1 : 1;              //!< [24] Trusted Protect
        uint32_t WP1 : 1;              //!< [25] Write Protect
        uint32_t SP1 : 1;              //!< [26] Supervisor Protect
        uint32_t RESERVED6 : 1;        //!< [27]
        uint32_t TP0 : 1;              //!< [28] Trusted Protect
        uint32_t WP0 : 1;              //!< [29] Write Protect
        uint32_t SP0 : 1;              //!< [30] Supervisor Protect
        uint32_t RESERVED7 : 1;        //!< [31]
    } B;
} hw_aips_pacre_t;
#endif

/*!
 * @name Constants and macros for entire AIPS_PACRE register
 */
//@{
#define HW_AIPS_PACRE_ADDR(x)    (REGS_AIPS_BASE(x) + 0x40U)

#ifndef __LANGUAGE_ASM__
#define HW_AIPS_PACRE(x)         (*(__IO hw_aips_pacre_t *) HW_AIPS_PACRE_ADDR(x))
#define HW_AIPS_PACRE_RD(x)      (HW_AIPS_PACRE(x).U)
#define HW_AIPS_PACRE_WR(x, v)   (HW_AIPS_PACRE(x).U = (v))
#define HW_AIPS_PACRE_SET(x, v)  (HW_AIPS_PACRE_WR(x, HW_AIPS_PACRE_RD(x) |  (v)))
#define HW_AIPS_PACRE_CLR(x, v)  (HW_AIPS_PACRE_WR(x, HW_AIPS_PACRE_RD(x) & ~(v)))
#define HW_AIPS_PACRE_TOG(x, v)  (HW_AIPS_PACRE_WR(x, HW_AIPS_PACRE_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AIPS_PACRE bitfields
 */

/*!
 * @name Register AIPS_PACRE, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRE_TP7    (0U)          //!< Bit position for AIPS_PACRE_TP7.
#define BM_AIPS_PACRE_TP7    (0x00000001U) //!< Bit mask for AIPS_PACRE_TP7.
#define BS_AIPS_PACRE_TP7    (1U)          //!< Bit field size in bits for AIPS_PACRE_TP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_TP7 field.
#define BR_AIPS_PACRE_TP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_TP7))
#endif

//! @brief Format value for bitfield AIPS_PACRE_TP7.
#define BF_AIPS_PACRE_TP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_TP7), uint32_t) & BM_AIPS_PACRE_TP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP7 field to a new value.
#define BW_AIPS_PACRE_TP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_TP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRE_WP7    (1U)          //!< Bit position for AIPS_PACRE_WP7.
#define BM_AIPS_PACRE_WP7    (0x00000002U) //!< Bit mask for AIPS_PACRE_WP7.
#define BS_AIPS_PACRE_WP7    (1U)          //!< Bit field size in bits for AIPS_PACRE_WP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_WP7 field.
#define BR_AIPS_PACRE_WP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_WP7))
#endif

//! @brief Format value for bitfield AIPS_PACRE_WP7.
#define BF_AIPS_PACRE_WP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_WP7), uint32_t) & BM_AIPS_PACRE_WP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP7 field to a new value.
#define BW_AIPS_PACRE_WP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_WP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRE_SP7    (2U)          //!< Bit position for AIPS_PACRE_SP7.
#define BM_AIPS_PACRE_SP7    (0x00000004U) //!< Bit mask for AIPS_PACRE_SP7.
#define BS_AIPS_PACRE_SP7    (1U)          //!< Bit field size in bits for AIPS_PACRE_SP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_SP7 field.
#define BR_AIPS_PACRE_SP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_SP7))
#endif

//! @brief Format value for bitfield AIPS_PACRE_SP7.
#define BF_AIPS_PACRE_SP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_SP7), uint32_t) & BM_AIPS_PACRE_SP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP7 field to a new value.
#define BW_AIPS_PACRE_SP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_SP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRE_TP6    (4U)          //!< Bit position for AIPS_PACRE_TP6.
#define BM_AIPS_PACRE_TP6    (0x00000010U) //!< Bit mask for AIPS_PACRE_TP6.
#define BS_AIPS_PACRE_TP6    (1U)          //!< Bit field size in bits for AIPS_PACRE_TP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_TP6 field.
#define BR_AIPS_PACRE_TP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_TP6))
#endif

//! @brief Format value for bitfield AIPS_PACRE_TP6.
#define BF_AIPS_PACRE_TP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_TP6), uint32_t) & BM_AIPS_PACRE_TP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP6 field to a new value.
#define BW_AIPS_PACRE_TP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_TP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRE_WP6    (5U)          //!< Bit position for AIPS_PACRE_WP6.
#define BM_AIPS_PACRE_WP6    (0x00000020U) //!< Bit mask for AIPS_PACRE_WP6.
#define BS_AIPS_PACRE_WP6    (1U)          //!< Bit field size in bits for AIPS_PACRE_WP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_WP6 field.
#define BR_AIPS_PACRE_WP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_WP6))
#endif

//! @brief Format value for bitfield AIPS_PACRE_WP6.
#define BF_AIPS_PACRE_WP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_WP6), uint32_t) & BM_AIPS_PACRE_WP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP6 field to a new value.
#define BW_AIPS_PACRE_WP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_WP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRE_SP6    (6U)          //!< Bit position for AIPS_PACRE_SP6.
#define BM_AIPS_PACRE_SP6    (0x00000040U) //!< Bit mask for AIPS_PACRE_SP6.
#define BS_AIPS_PACRE_SP6    (1U)          //!< Bit field size in bits for AIPS_PACRE_SP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_SP6 field.
#define BR_AIPS_PACRE_SP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_SP6))
#endif

//! @brief Format value for bitfield AIPS_PACRE_SP6.
#define BF_AIPS_PACRE_SP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_SP6), uint32_t) & BM_AIPS_PACRE_SP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP6 field to a new value.
#define BW_AIPS_PACRE_SP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_SP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRE_TP5    (8U)          //!< Bit position for AIPS_PACRE_TP5.
#define BM_AIPS_PACRE_TP5    (0x00000100U) //!< Bit mask for AIPS_PACRE_TP5.
#define BS_AIPS_PACRE_TP5    (1U)          //!< Bit field size in bits for AIPS_PACRE_TP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_TP5 field.
#define BR_AIPS_PACRE_TP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_TP5))
#endif

//! @brief Format value for bitfield AIPS_PACRE_TP5.
#define BF_AIPS_PACRE_TP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_TP5), uint32_t) & BM_AIPS_PACRE_TP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP5 field to a new value.
#define BW_AIPS_PACRE_TP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_TP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRE_WP5    (9U)          //!< Bit position for AIPS_PACRE_WP5.
#define BM_AIPS_PACRE_WP5    (0x00000200U) //!< Bit mask for AIPS_PACRE_WP5.
#define BS_AIPS_PACRE_WP5    (1U)          //!< Bit field size in bits for AIPS_PACRE_WP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_WP5 field.
#define BR_AIPS_PACRE_WP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_WP5))
#endif

//! @brief Format value for bitfield AIPS_PACRE_WP5.
#define BF_AIPS_PACRE_WP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_WP5), uint32_t) & BM_AIPS_PACRE_WP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP5 field to a new value.
#define BW_AIPS_PACRE_WP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_WP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRE_SP5    (10U)         //!< Bit position for AIPS_PACRE_SP5.
#define BM_AIPS_PACRE_SP5    (0x00000400U) //!< Bit mask for AIPS_PACRE_SP5.
#define BS_AIPS_PACRE_SP5    (1U)          //!< Bit field size in bits for AIPS_PACRE_SP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_SP5 field.
#define BR_AIPS_PACRE_SP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_SP5))
#endif

//! @brief Format value for bitfield AIPS_PACRE_SP5.
#define BF_AIPS_PACRE_SP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_SP5), uint32_t) & BM_AIPS_PACRE_SP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP5 field to a new value.
#define BW_AIPS_PACRE_SP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_SP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRE_TP4    (12U)         //!< Bit position for AIPS_PACRE_TP4.
#define BM_AIPS_PACRE_TP4    (0x00001000U) //!< Bit mask for AIPS_PACRE_TP4.
#define BS_AIPS_PACRE_TP4    (1U)          //!< Bit field size in bits for AIPS_PACRE_TP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_TP4 field.
#define BR_AIPS_PACRE_TP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_TP4))
#endif

//! @brief Format value for bitfield AIPS_PACRE_TP4.
#define BF_AIPS_PACRE_TP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_TP4), uint32_t) & BM_AIPS_PACRE_TP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP4 field to a new value.
#define BW_AIPS_PACRE_TP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_TP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRE_WP4    (13U)         //!< Bit position for AIPS_PACRE_WP4.
#define BM_AIPS_PACRE_WP4    (0x00002000U) //!< Bit mask for AIPS_PACRE_WP4.
#define BS_AIPS_PACRE_WP4    (1U)          //!< Bit field size in bits for AIPS_PACRE_WP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_WP4 field.
#define BR_AIPS_PACRE_WP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_WP4))
#endif

//! @brief Format value for bitfield AIPS_PACRE_WP4.
#define BF_AIPS_PACRE_WP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_WP4), uint32_t) & BM_AIPS_PACRE_WP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP4 field to a new value.
#define BW_AIPS_PACRE_WP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_WP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRE_SP4    (14U)         //!< Bit position for AIPS_PACRE_SP4.
#define BM_AIPS_PACRE_SP4    (0x00004000U) //!< Bit mask for AIPS_PACRE_SP4.
#define BS_AIPS_PACRE_SP4    (1U)          //!< Bit field size in bits for AIPS_PACRE_SP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_SP4 field.
#define BR_AIPS_PACRE_SP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_SP4))
#endif

//! @brief Format value for bitfield AIPS_PACRE_SP4.
#define BF_AIPS_PACRE_SP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_SP4), uint32_t) & BM_AIPS_PACRE_SP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP4 field to a new value.
#define BW_AIPS_PACRE_SP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_SP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRE_TP3    (16U)         //!< Bit position for AIPS_PACRE_TP3.
#define BM_AIPS_PACRE_TP3    (0x00010000U) //!< Bit mask for AIPS_PACRE_TP3.
#define BS_AIPS_PACRE_TP3    (1U)          //!< Bit field size in bits for AIPS_PACRE_TP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_TP3 field.
#define BR_AIPS_PACRE_TP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_TP3))
#endif

//! @brief Format value for bitfield AIPS_PACRE_TP3.
#define BF_AIPS_PACRE_TP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_TP3), uint32_t) & BM_AIPS_PACRE_TP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP3 field to a new value.
#define BW_AIPS_PACRE_TP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_TP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRE_WP3    (17U)         //!< Bit position for AIPS_PACRE_WP3.
#define BM_AIPS_PACRE_WP3    (0x00020000U) //!< Bit mask for AIPS_PACRE_WP3.
#define BS_AIPS_PACRE_WP3    (1U)          //!< Bit field size in bits for AIPS_PACRE_WP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_WP3 field.
#define BR_AIPS_PACRE_WP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_WP3))
#endif

//! @brief Format value for bitfield AIPS_PACRE_WP3.
#define BF_AIPS_PACRE_WP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_WP3), uint32_t) & BM_AIPS_PACRE_WP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP3 field to a new value.
#define BW_AIPS_PACRE_WP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_WP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRE_SP3    (18U)         //!< Bit position for AIPS_PACRE_SP3.
#define BM_AIPS_PACRE_SP3    (0x00040000U) //!< Bit mask for AIPS_PACRE_SP3.
#define BS_AIPS_PACRE_SP3    (1U)          //!< Bit field size in bits for AIPS_PACRE_SP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_SP3 field.
#define BR_AIPS_PACRE_SP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_SP3))
#endif

//! @brief Format value for bitfield AIPS_PACRE_SP3.
#define BF_AIPS_PACRE_SP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_SP3), uint32_t) & BM_AIPS_PACRE_SP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP3 field to a new value.
#define BW_AIPS_PACRE_SP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_SP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRE_TP2    (20U)         //!< Bit position for AIPS_PACRE_TP2.
#define BM_AIPS_PACRE_TP2    (0x00100000U) //!< Bit mask for AIPS_PACRE_TP2.
#define BS_AIPS_PACRE_TP2    (1U)          //!< Bit field size in bits for AIPS_PACRE_TP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_TP2 field.
#define BR_AIPS_PACRE_TP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_TP2))
#endif

//! @brief Format value for bitfield AIPS_PACRE_TP2.
#define BF_AIPS_PACRE_TP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_TP2), uint32_t) & BM_AIPS_PACRE_TP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP2 field to a new value.
#define BW_AIPS_PACRE_TP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_TP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRE_WP2    (21U)         //!< Bit position for AIPS_PACRE_WP2.
#define BM_AIPS_PACRE_WP2    (0x00200000U) //!< Bit mask for AIPS_PACRE_WP2.
#define BS_AIPS_PACRE_WP2    (1U)          //!< Bit field size in bits for AIPS_PACRE_WP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_WP2 field.
#define BR_AIPS_PACRE_WP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_WP2))
#endif

//! @brief Format value for bitfield AIPS_PACRE_WP2.
#define BF_AIPS_PACRE_WP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_WP2), uint32_t) & BM_AIPS_PACRE_WP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP2 field to a new value.
#define BW_AIPS_PACRE_WP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_WP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRE_SP2    (22U)         //!< Bit position for AIPS_PACRE_SP2.
#define BM_AIPS_PACRE_SP2    (0x00400000U) //!< Bit mask for AIPS_PACRE_SP2.
#define BS_AIPS_PACRE_SP2    (1U)          //!< Bit field size in bits for AIPS_PACRE_SP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_SP2 field.
#define BR_AIPS_PACRE_SP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_SP2))
#endif

//! @brief Format value for bitfield AIPS_PACRE_SP2.
#define BF_AIPS_PACRE_SP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_SP2), uint32_t) & BM_AIPS_PACRE_SP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP2 field to a new value.
#define BW_AIPS_PACRE_SP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_SP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRE_TP1    (24U)         //!< Bit position for AIPS_PACRE_TP1.
#define BM_AIPS_PACRE_TP1    (0x01000000U) //!< Bit mask for AIPS_PACRE_TP1.
#define BS_AIPS_PACRE_TP1    (1U)          //!< Bit field size in bits for AIPS_PACRE_TP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_TP1 field.
#define BR_AIPS_PACRE_TP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_TP1))
#endif

//! @brief Format value for bitfield AIPS_PACRE_TP1.
#define BF_AIPS_PACRE_TP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_TP1), uint32_t) & BM_AIPS_PACRE_TP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP1 field to a new value.
#define BW_AIPS_PACRE_TP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_TP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRE_WP1    (25U)         //!< Bit position for AIPS_PACRE_WP1.
#define BM_AIPS_PACRE_WP1    (0x02000000U) //!< Bit mask for AIPS_PACRE_WP1.
#define BS_AIPS_PACRE_WP1    (1U)          //!< Bit field size in bits for AIPS_PACRE_WP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_WP1 field.
#define BR_AIPS_PACRE_WP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_WP1))
#endif

//! @brief Format value for bitfield AIPS_PACRE_WP1.
#define BF_AIPS_PACRE_WP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_WP1), uint32_t) & BM_AIPS_PACRE_WP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP1 field to a new value.
#define BW_AIPS_PACRE_WP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_WP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRE_SP1    (26U)         //!< Bit position for AIPS_PACRE_SP1.
#define BM_AIPS_PACRE_SP1    (0x04000000U) //!< Bit mask for AIPS_PACRE_SP1.
#define BS_AIPS_PACRE_SP1    (1U)          //!< Bit field size in bits for AIPS_PACRE_SP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_SP1 field.
#define BR_AIPS_PACRE_SP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_SP1))
#endif

//! @brief Format value for bitfield AIPS_PACRE_SP1.
#define BF_AIPS_PACRE_SP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_SP1), uint32_t) & BM_AIPS_PACRE_SP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP1 field to a new value.
#define BW_AIPS_PACRE_SP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_SP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRE_TP0    (28U)         //!< Bit position for AIPS_PACRE_TP0.
#define BM_AIPS_PACRE_TP0    (0x10000000U) //!< Bit mask for AIPS_PACRE_TP0.
#define BS_AIPS_PACRE_TP0    (1U)          //!< Bit field size in bits for AIPS_PACRE_TP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_TP0 field.
#define BR_AIPS_PACRE_TP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_TP0))
#endif

//! @brief Format value for bitfield AIPS_PACRE_TP0.
#define BF_AIPS_PACRE_TP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_TP0), uint32_t) & BM_AIPS_PACRE_TP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP0 field to a new value.
#define BW_AIPS_PACRE_TP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_TP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRE_WP0    (29U)         //!< Bit position for AIPS_PACRE_WP0.
#define BM_AIPS_PACRE_WP0    (0x20000000U) //!< Bit mask for AIPS_PACRE_WP0.
#define BS_AIPS_PACRE_WP0    (1U)          //!< Bit field size in bits for AIPS_PACRE_WP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_WP0 field.
#define BR_AIPS_PACRE_WP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_WP0))
#endif

//! @brief Format value for bitfield AIPS_PACRE_WP0.
#define BF_AIPS_PACRE_WP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_WP0), uint32_t) & BM_AIPS_PACRE_WP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP0 field to a new value.
#define BW_AIPS_PACRE_WP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_WP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRE, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRE_SP0    (30U)         //!< Bit position for AIPS_PACRE_SP0.
#define BM_AIPS_PACRE_SP0    (0x40000000U) //!< Bit mask for AIPS_PACRE_SP0.
#define BS_AIPS_PACRE_SP0    (1U)          //!< Bit field size in bits for AIPS_PACRE_SP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRE_SP0 field.
#define BR_AIPS_PACRE_SP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_SP0))
#endif

//! @brief Format value for bitfield AIPS_PACRE_SP0.
#define BF_AIPS_PACRE_SP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRE_SP0), uint32_t) & BM_AIPS_PACRE_SP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP0 field to a new value.
#define BW_AIPS_PACRE_SP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRE_ADDR(x), BP_AIPS_PACRE_SP0) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AIPS_PACRF - Peripheral Access Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AIPS_PACRF - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
typedef union _hw_aips_pacrf
{
    uint32_t U;
    struct _hw_aips_pacrf_bitfields
    {
        uint32_t TP7 : 1;              //!< [0] Trusted Protect
        uint32_t WP7 : 1;              //!< [1] Write Protect
        uint32_t SP7 : 1;              //!< [2] Supervisor Protect
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t TP6 : 1;              //!< [4] Trusted Protect
        uint32_t WP6 : 1;              //!< [5] Write Protect
        uint32_t SP6 : 1;              //!< [6] Supervisor Protect
        uint32_t RESERVED1 : 1;        //!< [7]
        uint32_t TP5 : 1;              //!< [8] Trusted Protect
        uint32_t WP5 : 1;              //!< [9] Write Protect
        uint32_t SP5 : 1;              //!< [10] Supervisor Protect
        uint32_t RESERVED2 : 1;        //!< [11]
        uint32_t TP4 : 1;              //!< [12] Trusted Protect
        uint32_t WP4 : 1;              //!< [13] Write Protect
        uint32_t SP4 : 1;              //!< [14] Supervisor Protect
        uint32_t RESERVED3 : 1;        //!< [15]
        uint32_t TP3 : 1;              //!< [16] Trusted Protect
        uint32_t WP3 : 1;              //!< [17] Write Protect
        uint32_t SP3 : 1;              //!< [18] Supervisor Protect
        uint32_t RESERVED4 : 1;        //!< [19]
        uint32_t TP2 : 1;              //!< [20] Trusted Protect
        uint32_t WP2 : 1;              //!< [21] Write Protect
        uint32_t SP2 : 1;              //!< [22] Supervisor Protect
        uint32_t RESERVED5 : 1;        //!< [23]
        uint32_t TP1 : 1;              //!< [24] Trusted Protect
        uint32_t WP1 : 1;              //!< [25] Write Protect
        uint32_t SP1 : 1;              //!< [26] Supervisor Protect
        uint32_t RESERVED6 : 1;        //!< [27]
        uint32_t TP0 : 1;              //!< [28] Trusted Protect
        uint32_t WP0 : 1;              //!< [29] Write Protect
        uint32_t SP0 : 1;              //!< [30] Supervisor Protect
        uint32_t RESERVED7 : 1;        //!< [31]
    } B;
} hw_aips_pacrf_t;
#endif

/*!
 * @name Constants and macros for entire AIPS_PACRF register
 */
//@{
#define HW_AIPS_PACRF_ADDR(x)    (REGS_AIPS_BASE(x) + 0x44U)

#ifndef __LANGUAGE_ASM__
#define HW_AIPS_PACRF(x)         (*(__IO hw_aips_pacrf_t *) HW_AIPS_PACRF_ADDR(x))
#define HW_AIPS_PACRF_RD(x)      (HW_AIPS_PACRF(x).U)
#define HW_AIPS_PACRF_WR(x, v)   (HW_AIPS_PACRF(x).U = (v))
#define HW_AIPS_PACRF_SET(x, v)  (HW_AIPS_PACRF_WR(x, HW_AIPS_PACRF_RD(x) |  (v)))
#define HW_AIPS_PACRF_CLR(x, v)  (HW_AIPS_PACRF_WR(x, HW_AIPS_PACRF_RD(x) & ~(v)))
#define HW_AIPS_PACRF_TOG(x, v)  (HW_AIPS_PACRF_WR(x, HW_AIPS_PACRF_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AIPS_PACRF bitfields
 */

/*!
 * @name Register AIPS_PACRF, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRF_TP7    (0U)          //!< Bit position for AIPS_PACRF_TP7.
#define BM_AIPS_PACRF_TP7    (0x00000001U) //!< Bit mask for AIPS_PACRF_TP7.
#define BS_AIPS_PACRF_TP7    (1U)          //!< Bit field size in bits for AIPS_PACRF_TP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_TP7 field.
#define BR_AIPS_PACRF_TP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_TP7))
#endif

//! @brief Format value for bitfield AIPS_PACRF_TP7.
#define BF_AIPS_PACRF_TP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_TP7), uint32_t) & BM_AIPS_PACRF_TP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP7 field to a new value.
#define BW_AIPS_PACRF_TP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_TP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRF_WP7    (1U)          //!< Bit position for AIPS_PACRF_WP7.
#define BM_AIPS_PACRF_WP7    (0x00000002U) //!< Bit mask for AIPS_PACRF_WP7.
#define BS_AIPS_PACRF_WP7    (1U)          //!< Bit field size in bits for AIPS_PACRF_WP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_WP7 field.
#define BR_AIPS_PACRF_WP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_WP7))
#endif

//! @brief Format value for bitfield AIPS_PACRF_WP7.
#define BF_AIPS_PACRF_WP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_WP7), uint32_t) & BM_AIPS_PACRF_WP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP7 field to a new value.
#define BW_AIPS_PACRF_WP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_WP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRF_SP7    (2U)          //!< Bit position for AIPS_PACRF_SP7.
#define BM_AIPS_PACRF_SP7    (0x00000004U) //!< Bit mask for AIPS_PACRF_SP7.
#define BS_AIPS_PACRF_SP7    (1U)          //!< Bit field size in bits for AIPS_PACRF_SP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_SP7 field.
#define BR_AIPS_PACRF_SP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_SP7))
#endif

//! @brief Format value for bitfield AIPS_PACRF_SP7.
#define BF_AIPS_PACRF_SP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_SP7), uint32_t) & BM_AIPS_PACRF_SP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP7 field to a new value.
#define BW_AIPS_PACRF_SP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_SP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRF_TP6    (4U)          //!< Bit position for AIPS_PACRF_TP6.
#define BM_AIPS_PACRF_TP6    (0x00000010U) //!< Bit mask for AIPS_PACRF_TP6.
#define BS_AIPS_PACRF_TP6    (1U)          //!< Bit field size in bits for AIPS_PACRF_TP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_TP6 field.
#define BR_AIPS_PACRF_TP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_TP6))
#endif

//! @brief Format value for bitfield AIPS_PACRF_TP6.
#define BF_AIPS_PACRF_TP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_TP6), uint32_t) & BM_AIPS_PACRF_TP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP6 field to a new value.
#define BW_AIPS_PACRF_TP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_TP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRF_WP6    (5U)          //!< Bit position for AIPS_PACRF_WP6.
#define BM_AIPS_PACRF_WP6    (0x00000020U) //!< Bit mask for AIPS_PACRF_WP6.
#define BS_AIPS_PACRF_WP6    (1U)          //!< Bit field size in bits for AIPS_PACRF_WP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_WP6 field.
#define BR_AIPS_PACRF_WP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_WP6))
#endif

//! @brief Format value for bitfield AIPS_PACRF_WP6.
#define BF_AIPS_PACRF_WP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_WP6), uint32_t) & BM_AIPS_PACRF_WP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP6 field to a new value.
#define BW_AIPS_PACRF_WP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_WP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRF_SP6    (6U)          //!< Bit position for AIPS_PACRF_SP6.
#define BM_AIPS_PACRF_SP6    (0x00000040U) //!< Bit mask for AIPS_PACRF_SP6.
#define BS_AIPS_PACRF_SP6    (1U)          //!< Bit field size in bits for AIPS_PACRF_SP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_SP6 field.
#define BR_AIPS_PACRF_SP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_SP6))
#endif

//! @brief Format value for bitfield AIPS_PACRF_SP6.
#define BF_AIPS_PACRF_SP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_SP6), uint32_t) & BM_AIPS_PACRF_SP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP6 field to a new value.
#define BW_AIPS_PACRF_SP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_SP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRF_TP5    (8U)          //!< Bit position for AIPS_PACRF_TP5.
#define BM_AIPS_PACRF_TP5    (0x00000100U) //!< Bit mask for AIPS_PACRF_TP5.
#define BS_AIPS_PACRF_TP5    (1U)          //!< Bit field size in bits for AIPS_PACRF_TP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_TP5 field.
#define BR_AIPS_PACRF_TP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_TP5))
#endif

//! @brief Format value for bitfield AIPS_PACRF_TP5.
#define BF_AIPS_PACRF_TP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_TP5), uint32_t) & BM_AIPS_PACRF_TP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP5 field to a new value.
#define BW_AIPS_PACRF_TP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_TP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRF_WP5    (9U)          //!< Bit position for AIPS_PACRF_WP5.
#define BM_AIPS_PACRF_WP5    (0x00000200U) //!< Bit mask for AIPS_PACRF_WP5.
#define BS_AIPS_PACRF_WP5    (1U)          //!< Bit field size in bits for AIPS_PACRF_WP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_WP5 field.
#define BR_AIPS_PACRF_WP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_WP5))
#endif

//! @brief Format value for bitfield AIPS_PACRF_WP5.
#define BF_AIPS_PACRF_WP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_WP5), uint32_t) & BM_AIPS_PACRF_WP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP5 field to a new value.
#define BW_AIPS_PACRF_WP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_WP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRF_SP5    (10U)         //!< Bit position for AIPS_PACRF_SP5.
#define BM_AIPS_PACRF_SP5    (0x00000400U) //!< Bit mask for AIPS_PACRF_SP5.
#define BS_AIPS_PACRF_SP5    (1U)          //!< Bit field size in bits for AIPS_PACRF_SP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_SP5 field.
#define BR_AIPS_PACRF_SP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_SP5))
#endif

//! @brief Format value for bitfield AIPS_PACRF_SP5.
#define BF_AIPS_PACRF_SP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_SP5), uint32_t) & BM_AIPS_PACRF_SP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP5 field to a new value.
#define BW_AIPS_PACRF_SP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_SP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRF_TP4    (12U)         //!< Bit position for AIPS_PACRF_TP4.
#define BM_AIPS_PACRF_TP4    (0x00001000U) //!< Bit mask for AIPS_PACRF_TP4.
#define BS_AIPS_PACRF_TP4    (1U)          //!< Bit field size in bits for AIPS_PACRF_TP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_TP4 field.
#define BR_AIPS_PACRF_TP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_TP4))
#endif

//! @brief Format value for bitfield AIPS_PACRF_TP4.
#define BF_AIPS_PACRF_TP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_TP4), uint32_t) & BM_AIPS_PACRF_TP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP4 field to a new value.
#define BW_AIPS_PACRF_TP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_TP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRF_WP4    (13U)         //!< Bit position for AIPS_PACRF_WP4.
#define BM_AIPS_PACRF_WP4    (0x00002000U) //!< Bit mask for AIPS_PACRF_WP4.
#define BS_AIPS_PACRF_WP4    (1U)          //!< Bit field size in bits for AIPS_PACRF_WP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_WP4 field.
#define BR_AIPS_PACRF_WP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_WP4))
#endif

//! @brief Format value for bitfield AIPS_PACRF_WP4.
#define BF_AIPS_PACRF_WP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_WP4), uint32_t) & BM_AIPS_PACRF_WP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP4 field to a new value.
#define BW_AIPS_PACRF_WP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_WP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRF_SP4    (14U)         //!< Bit position for AIPS_PACRF_SP4.
#define BM_AIPS_PACRF_SP4    (0x00004000U) //!< Bit mask for AIPS_PACRF_SP4.
#define BS_AIPS_PACRF_SP4    (1U)          //!< Bit field size in bits for AIPS_PACRF_SP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_SP4 field.
#define BR_AIPS_PACRF_SP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_SP4))
#endif

//! @brief Format value for bitfield AIPS_PACRF_SP4.
#define BF_AIPS_PACRF_SP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_SP4), uint32_t) & BM_AIPS_PACRF_SP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP4 field to a new value.
#define BW_AIPS_PACRF_SP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_SP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRF_TP3    (16U)         //!< Bit position for AIPS_PACRF_TP3.
#define BM_AIPS_PACRF_TP3    (0x00010000U) //!< Bit mask for AIPS_PACRF_TP3.
#define BS_AIPS_PACRF_TP3    (1U)          //!< Bit field size in bits for AIPS_PACRF_TP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_TP3 field.
#define BR_AIPS_PACRF_TP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_TP3))
#endif

//! @brief Format value for bitfield AIPS_PACRF_TP3.
#define BF_AIPS_PACRF_TP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_TP3), uint32_t) & BM_AIPS_PACRF_TP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP3 field to a new value.
#define BW_AIPS_PACRF_TP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_TP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRF_WP3    (17U)         //!< Bit position for AIPS_PACRF_WP3.
#define BM_AIPS_PACRF_WP3    (0x00020000U) //!< Bit mask for AIPS_PACRF_WP3.
#define BS_AIPS_PACRF_WP3    (1U)          //!< Bit field size in bits for AIPS_PACRF_WP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_WP3 field.
#define BR_AIPS_PACRF_WP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_WP3))
#endif

//! @brief Format value for bitfield AIPS_PACRF_WP3.
#define BF_AIPS_PACRF_WP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_WP3), uint32_t) & BM_AIPS_PACRF_WP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP3 field to a new value.
#define BW_AIPS_PACRF_WP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_WP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRF_SP3    (18U)         //!< Bit position for AIPS_PACRF_SP3.
#define BM_AIPS_PACRF_SP3    (0x00040000U) //!< Bit mask for AIPS_PACRF_SP3.
#define BS_AIPS_PACRF_SP3    (1U)          //!< Bit field size in bits for AIPS_PACRF_SP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_SP3 field.
#define BR_AIPS_PACRF_SP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_SP3))
#endif

//! @brief Format value for bitfield AIPS_PACRF_SP3.
#define BF_AIPS_PACRF_SP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_SP3), uint32_t) & BM_AIPS_PACRF_SP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP3 field to a new value.
#define BW_AIPS_PACRF_SP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_SP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRF_TP2    (20U)         //!< Bit position for AIPS_PACRF_TP2.
#define BM_AIPS_PACRF_TP2    (0x00100000U) //!< Bit mask for AIPS_PACRF_TP2.
#define BS_AIPS_PACRF_TP2    (1U)          //!< Bit field size in bits for AIPS_PACRF_TP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_TP2 field.
#define BR_AIPS_PACRF_TP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_TP2))
#endif

//! @brief Format value for bitfield AIPS_PACRF_TP2.
#define BF_AIPS_PACRF_TP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_TP2), uint32_t) & BM_AIPS_PACRF_TP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP2 field to a new value.
#define BW_AIPS_PACRF_TP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_TP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRF_WP2    (21U)         //!< Bit position for AIPS_PACRF_WP2.
#define BM_AIPS_PACRF_WP2    (0x00200000U) //!< Bit mask for AIPS_PACRF_WP2.
#define BS_AIPS_PACRF_WP2    (1U)          //!< Bit field size in bits for AIPS_PACRF_WP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_WP2 field.
#define BR_AIPS_PACRF_WP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_WP2))
#endif

//! @brief Format value for bitfield AIPS_PACRF_WP2.
#define BF_AIPS_PACRF_WP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_WP2), uint32_t) & BM_AIPS_PACRF_WP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP2 field to a new value.
#define BW_AIPS_PACRF_WP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_WP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRF_SP2    (22U)         //!< Bit position for AIPS_PACRF_SP2.
#define BM_AIPS_PACRF_SP2    (0x00400000U) //!< Bit mask for AIPS_PACRF_SP2.
#define BS_AIPS_PACRF_SP2    (1U)          //!< Bit field size in bits for AIPS_PACRF_SP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_SP2 field.
#define BR_AIPS_PACRF_SP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_SP2))
#endif

//! @brief Format value for bitfield AIPS_PACRF_SP2.
#define BF_AIPS_PACRF_SP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_SP2), uint32_t) & BM_AIPS_PACRF_SP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP2 field to a new value.
#define BW_AIPS_PACRF_SP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_SP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRF_TP1    (24U)         //!< Bit position for AIPS_PACRF_TP1.
#define BM_AIPS_PACRF_TP1    (0x01000000U) //!< Bit mask for AIPS_PACRF_TP1.
#define BS_AIPS_PACRF_TP1    (1U)          //!< Bit field size in bits for AIPS_PACRF_TP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_TP1 field.
#define BR_AIPS_PACRF_TP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_TP1))
#endif

//! @brief Format value for bitfield AIPS_PACRF_TP1.
#define BF_AIPS_PACRF_TP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_TP1), uint32_t) & BM_AIPS_PACRF_TP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP1 field to a new value.
#define BW_AIPS_PACRF_TP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_TP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRF_WP1    (25U)         //!< Bit position for AIPS_PACRF_WP1.
#define BM_AIPS_PACRF_WP1    (0x02000000U) //!< Bit mask for AIPS_PACRF_WP1.
#define BS_AIPS_PACRF_WP1    (1U)          //!< Bit field size in bits for AIPS_PACRF_WP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_WP1 field.
#define BR_AIPS_PACRF_WP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_WP1))
#endif

//! @brief Format value for bitfield AIPS_PACRF_WP1.
#define BF_AIPS_PACRF_WP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_WP1), uint32_t) & BM_AIPS_PACRF_WP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP1 field to a new value.
#define BW_AIPS_PACRF_WP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_WP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRF_SP1    (26U)         //!< Bit position for AIPS_PACRF_SP1.
#define BM_AIPS_PACRF_SP1    (0x04000000U) //!< Bit mask for AIPS_PACRF_SP1.
#define BS_AIPS_PACRF_SP1    (1U)          //!< Bit field size in bits for AIPS_PACRF_SP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_SP1 field.
#define BR_AIPS_PACRF_SP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_SP1))
#endif

//! @brief Format value for bitfield AIPS_PACRF_SP1.
#define BF_AIPS_PACRF_SP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_SP1), uint32_t) & BM_AIPS_PACRF_SP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP1 field to a new value.
#define BW_AIPS_PACRF_SP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_SP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRF_TP0    (28U)         //!< Bit position for AIPS_PACRF_TP0.
#define BM_AIPS_PACRF_TP0    (0x10000000U) //!< Bit mask for AIPS_PACRF_TP0.
#define BS_AIPS_PACRF_TP0    (1U)          //!< Bit field size in bits for AIPS_PACRF_TP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_TP0 field.
#define BR_AIPS_PACRF_TP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_TP0))
#endif

//! @brief Format value for bitfield AIPS_PACRF_TP0.
#define BF_AIPS_PACRF_TP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_TP0), uint32_t) & BM_AIPS_PACRF_TP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP0 field to a new value.
#define BW_AIPS_PACRF_TP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_TP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRF_WP0    (29U)         //!< Bit position for AIPS_PACRF_WP0.
#define BM_AIPS_PACRF_WP0    (0x20000000U) //!< Bit mask for AIPS_PACRF_WP0.
#define BS_AIPS_PACRF_WP0    (1U)          //!< Bit field size in bits for AIPS_PACRF_WP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_WP0 field.
#define BR_AIPS_PACRF_WP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_WP0))
#endif

//! @brief Format value for bitfield AIPS_PACRF_WP0.
#define BF_AIPS_PACRF_WP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_WP0), uint32_t) & BM_AIPS_PACRF_WP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP0 field to a new value.
#define BW_AIPS_PACRF_WP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_WP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRF, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRF_SP0    (30U)         //!< Bit position for AIPS_PACRF_SP0.
#define BM_AIPS_PACRF_SP0    (0x40000000U) //!< Bit mask for AIPS_PACRF_SP0.
#define BS_AIPS_PACRF_SP0    (1U)          //!< Bit field size in bits for AIPS_PACRF_SP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRF_SP0 field.
#define BR_AIPS_PACRF_SP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_SP0))
#endif

//! @brief Format value for bitfield AIPS_PACRF_SP0.
#define BF_AIPS_PACRF_SP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRF_SP0), uint32_t) & BM_AIPS_PACRF_SP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP0 field to a new value.
#define BW_AIPS_PACRF_SP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRF_ADDR(x), BP_AIPS_PACRF_SP0) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AIPS_PACRG - Peripheral Access Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AIPS_PACRG - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
typedef union _hw_aips_pacrg
{
    uint32_t U;
    struct _hw_aips_pacrg_bitfields
    {
        uint32_t TP7 : 1;              //!< [0] Trusted Protect
        uint32_t WP7 : 1;              //!< [1] Write Protect
        uint32_t SP7 : 1;              //!< [2] Supervisor Protect
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t TP6 : 1;              //!< [4] Trusted Protect
        uint32_t WP6 : 1;              //!< [5] Write Protect
        uint32_t SP6 : 1;              //!< [6] Supervisor Protect
        uint32_t RESERVED1 : 1;        //!< [7]
        uint32_t TP5 : 1;              //!< [8] Trusted Protect
        uint32_t WP5 : 1;              //!< [9] Write Protect
        uint32_t SP5 : 1;              //!< [10] Supervisor Protect
        uint32_t RESERVED2 : 1;        //!< [11]
        uint32_t TP4 : 1;              //!< [12] Trusted Protect
        uint32_t WP4 : 1;              //!< [13] Write Protect
        uint32_t SP4 : 1;              //!< [14] Supervisor Protect
        uint32_t RESERVED3 : 1;        //!< [15]
        uint32_t TP3 : 1;              //!< [16] Trusted Protect
        uint32_t WP3 : 1;              //!< [17] Write Protect
        uint32_t SP3 : 1;              //!< [18] Supervisor Protect
        uint32_t RESERVED4 : 1;        //!< [19]
        uint32_t TP2 : 1;              //!< [20] Trusted Protect
        uint32_t WP2 : 1;              //!< [21] Write Protect
        uint32_t SP2 : 1;              //!< [22] Supervisor Protect
        uint32_t RESERVED5 : 1;        //!< [23]
        uint32_t TP1 : 1;              //!< [24] Trusted Protect
        uint32_t WP1 : 1;              //!< [25] Write Protect
        uint32_t SP1 : 1;              //!< [26] Supervisor Protect
        uint32_t RESERVED6 : 1;        //!< [27]
        uint32_t TP0 : 1;              //!< [28] Trusted Protect
        uint32_t WP0 : 1;              //!< [29] Write Protect
        uint32_t SP0 : 1;              //!< [30] Supervisor Protect
        uint32_t RESERVED7 : 1;        //!< [31]
    } B;
} hw_aips_pacrg_t;
#endif

/*!
 * @name Constants and macros for entire AIPS_PACRG register
 */
//@{
#define HW_AIPS_PACRG_ADDR(x)    (REGS_AIPS_BASE(x) + 0x48U)

#ifndef __LANGUAGE_ASM__
#define HW_AIPS_PACRG(x)         (*(__IO hw_aips_pacrg_t *) HW_AIPS_PACRG_ADDR(x))
#define HW_AIPS_PACRG_RD(x)      (HW_AIPS_PACRG(x).U)
#define HW_AIPS_PACRG_WR(x, v)   (HW_AIPS_PACRG(x).U = (v))
#define HW_AIPS_PACRG_SET(x, v)  (HW_AIPS_PACRG_WR(x, HW_AIPS_PACRG_RD(x) |  (v)))
#define HW_AIPS_PACRG_CLR(x, v)  (HW_AIPS_PACRG_WR(x, HW_AIPS_PACRG_RD(x) & ~(v)))
#define HW_AIPS_PACRG_TOG(x, v)  (HW_AIPS_PACRG_WR(x, HW_AIPS_PACRG_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AIPS_PACRG bitfields
 */

/*!
 * @name Register AIPS_PACRG, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRG_TP7    (0U)          //!< Bit position for AIPS_PACRG_TP7.
#define BM_AIPS_PACRG_TP7    (0x00000001U) //!< Bit mask for AIPS_PACRG_TP7.
#define BS_AIPS_PACRG_TP7    (1U)          //!< Bit field size in bits for AIPS_PACRG_TP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_TP7 field.
#define BR_AIPS_PACRG_TP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_TP7))
#endif

//! @brief Format value for bitfield AIPS_PACRG_TP7.
#define BF_AIPS_PACRG_TP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_TP7), uint32_t) & BM_AIPS_PACRG_TP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP7 field to a new value.
#define BW_AIPS_PACRG_TP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_TP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRG_WP7    (1U)          //!< Bit position for AIPS_PACRG_WP7.
#define BM_AIPS_PACRG_WP7    (0x00000002U) //!< Bit mask for AIPS_PACRG_WP7.
#define BS_AIPS_PACRG_WP7    (1U)          //!< Bit field size in bits for AIPS_PACRG_WP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_WP7 field.
#define BR_AIPS_PACRG_WP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_WP7))
#endif

//! @brief Format value for bitfield AIPS_PACRG_WP7.
#define BF_AIPS_PACRG_WP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_WP7), uint32_t) & BM_AIPS_PACRG_WP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP7 field to a new value.
#define BW_AIPS_PACRG_WP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_WP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRG_SP7    (2U)          //!< Bit position for AIPS_PACRG_SP7.
#define BM_AIPS_PACRG_SP7    (0x00000004U) //!< Bit mask for AIPS_PACRG_SP7.
#define BS_AIPS_PACRG_SP7    (1U)          //!< Bit field size in bits for AIPS_PACRG_SP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_SP7 field.
#define BR_AIPS_PACRG_SP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_SP7))
#endif

//! @brief Format value for bitfield AIPS_PACRG_SP7.
#define BF_AIPS_PACRG_SP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_SP7), uint32_t) & BM_AIPS_PACRG_SP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP7 field to a new value.
#define BW_AIPS_PACRG_SP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_SP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRG_TP6    (4U)          //!< Bit position for AIPS_PACRG_TP6.
#define BM_AIPS_PACRG_TP6    (0x00000010U) //!< Bit mask for AIPS_PACRG_TP6.
#define BS_AIPS_PACRG_TP6    (1U)          //!< Bit field size in bits for AIPS_PACRG_TP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_TP6 field.
#define BR_AIPS_PACRG_TP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_TP6))
#endif

//! @brief Format value for bitfield AIPS_PACRG_TP6.
#define BF_AIPS_PACRG_TP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_TP6), uint32_t) & BM_AIPS_PACRG_TP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP6 field to a new value.
#define BW_AIPS_PACRG_TP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_TP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRG_WP6    (5U)          //!< Bit position for AIPS_PACRG_WP6.
#define BM_AIPS_PACRG_WP6    (0x00000020U) //!< Bit mask for AIPS_PACRG_WP6.
#define BS_AIPS_PACRG_WP6    (1U)          //!< Bit field size in bits for AIPS_PACRG_WP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_WP6 field.
#define BR_AIPS_PACRG_WP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_WP6))
#endif

//! @brief Format value for bitfield AIPS_PACRG_WP6.
#define BF_AIPS_PACRG_WP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_WP6), uint32_t) & BM_AIPS_PACRG_WP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP6 field to a new value.
#define BW_AIPS_PACRG_WP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_WP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRG_SP6    (6U)          //!< Bit position for AIPS_PACRG_SP6.
#define BM_AIPS_PACRG_SP6    (0x00000040U) //!< Bit mask for AIPS_PACRG_SP6.
#define BS_AIPS_PACRG_SP6    (1U)          //!< Bit field size in bits for AIPS_PACRG_SP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_SP6 field.
#define BR_AIPS_PACRG_SP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_SP6))
#endif

//! @brief Format value for bitfield AIPS_PACRG_SP6.
#define BF_AIPS_PACRG_SP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_SP6), uint32_t) & BM_AIPS_PACRG_SP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP6 field to a new value.
#define BW_AIPS_PACRG_SP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_SP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRG_TP5    (8U)          //!< Bit position for AIPS_PACRG_TP5.
#define BM_AIPS_PACRG_TP5    (0x00000100U) //!< Bit mask for AIPS_PACRG_TP5.
#define BS_AIPS_PACRG_TP5    (1U)          //!< Bit field size in bits for AIPS_PACRG_TP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_TP5 field.
#define BR_AIPS_PACRG_TP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_TP5))
#endif

//! @brief Format value for bitfield AIPS_PACRG_TP5.
#define BF_AIPS_PACRG_TP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_TP5), uint32_t) & BM_AIPS_PACRG_TP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP5 field to a new value.
#define BW_AIPS_PACRG_TP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_TP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRG_WP5    (9U)          //!< Bit position for AIPS_PACRG_WP5.
#define BM_AIPS_PACRG_WP5    (0x00000200U) //!< Bit mask for AIPS_PACRG_WP5.
#define BS_AIPS_PACRG_WP5    (1U)          //!< Bit field size in bits for AIPS_PACRG_WP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_WP5 field.
#define BR_AIPS_PACRG_WP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_WP5))
#endif

//! @brief Format value for bitfield AIPS_PACRG_WP5.
#define BF_AIPS_PACRG_WP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_WP5), uint32_t) & BM_AIPS_PACRG_WP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP5 field to a new value.
#define BW_AIPS_PACRG_WP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_WP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRG_SP5    (10U)         //!< Bit position for AIPS_PACRG_SP5.
#define BM_AIPS_PACRG_SP5    (0x00000400U) //!< Bit mask for AIPS_PACRG_SP5.
#define BS_AIPS_PACRG_SP5    (1U)          //!< Bit field size in bits for AIPS_PACRG_SP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_SP5 field.
#define BR_AIPS_PACRG_SP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_SP5))
#endif

//! @brief Format value for bitfield AIPS_PACRG_SP5.
#define BF_AIPS_PACRG_SP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_SP5), uint32_t) & BM_AIPS_PACRG_SP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP5 field to a new value.
#define BW_AIPS_PACRG_SP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_SP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRG_TP4    (12U)         //!< Bit position for AIPS_PACRG_TP4.
#define BM_AIPS_PACRG_TP4    (0x00001000U) //!< Bit mask for AIPS_PACRG_TP4.
#define BS_AIPS_PACRG_TP4    (1U)          //!< Bit field size in bits for AIPS_PACRG_TP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_TP4 field.
#define BR_AIPS_PACRG_TP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_TP4))
#endif

//! @brief Format value for bitfield AIPS_PACRG_TP4.
#define BF_AIPS_PACRG_TP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_TP4), uint32_t) & BM_AIPS_PACRG_TP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP4 field to a new value.
#define BW_AIPS_PACRG_TP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_TP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRG_WP4    (13U)         //!< Bit position for AIPS_PACRG_WP4.
#define BM_AIPS_PACRG_WP4    (0x00002000U) //!< Bit mask for AIPS_PACRG_WP4.
#define BS_AIPS_PACRG_WP4    (1U)          //!< Bit field size in bits for AIPS_PACRG_WP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_WP4 field.
#define BR_AIPS_PACRG_WP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_WP4))
#endif

//! @brief Format value for bitfield AIPS_PACRG_WP4.
#define BF_AIPS_PACRG_WP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_WP4), uint32_t) & BM_AIPS_PACRG_WP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP4 field to a new value.
#define BW_AIPS_PACRG_WP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_WP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRG_SP4    (14U)         //!< Bit position for AIPS_PACRG_SP4.
#define BM_AIPS_PACRG_SP4    (0x00004000U) //!< Bit mask for AIPS_PACRG_SP4.
#define BS_AIPS_PACRG_SP4    (1U)          //!< Bit field size in bits for AIPS_PACRG_SP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_SP4 field.
#define BR_AIPS_PACRG_SP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_SP4))
#endif

//! @brief Format value for bitfield AIPS_PACRG_SP4.
#define BF_AIPS_PACRG_SP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_SP4), uint32_t) & BM_AIPS_PACRG_SP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP4 field to a new value.
#define BW_AIPS_PACRG_SP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_SP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRG_TP3    (16U)         //!< Bit position for AIPS_PACRG_TP3.
#define BM_AIPS_PACRG_TP3    (0x00010000U) //!< Bit mask for AIPS_PACRG_TP3.
#define BS_AIPS_PACRG_TP3    (1U)          //!< Bit field size in bits for AIPS_PACRG_TP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_TP3 field.
#define BR_AIPS_PACRG_TP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_TP3))
#endif

//! @brief Format value for bitfield AIPS_PACRG_TP3.
#define BF_AIPS_PACRG_TP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_TP3), uint32_t) & BM_AIPS_PACRG_TP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP3 field to a new value.
#define BW_AIPS_PACRG_TP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_TP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRG_WP3    (17U)         //!< Bit position for AIPS_PACRG_WP3.
#define BM_AIPS_PACRG_WP3    (0x00020000U) //!< Bit mask for AIPS_PACRG_WP3.
#define BS_AIPS_PACRG_WP3    (1U)          //!< Bit field size in bits for AIPS_PACRG_WP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_WP3 field.
#define BR_AIPS_PACRG_WP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_WP3))
#endif

//! @brief Format value for bitfield AIPS_PACRG_WP3.
#define BF_AIPS_PACRG_WP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_WP3), uint32_t) & BM_AIPS_PACRG_WP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP3 field to a new value.
#define BW_AIPS_PACRG_WP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_WP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRG_SP3    (18U)         //!< Bit position for AIPS_PACRG_SP3.
#define BM_AIPS_PACRG_SP3    (0x00040000U) //!< Bit mask for AIPS_PACRG_SP3.
#define BS_AIPS_PACRG_SP3    (1U)          //!< Bit field size in bits for AIPS_PACRG_SP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_SP3 field.
#define BR_AIPS_PACRG_SP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_SP3))
#endif

//! @brief Format value for bitfield AIPS_PACRG_SP3.
#define BF_AIPS_PACRG_SP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_SP3), uint32_t) & BM_AIPS_PACRG_SP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP3 field to a new value.
#define BW_AIPS_PACRG_SP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_SP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRG_TP2    (20U)         //!< Bit position for AIPS_PACRG_TP2.
#define BM_AIPS_PACRG_TP2    (0x00100000U) //!< Bit mask for AIPS_PACRG_TP2.
#define BS_AIPS_PACRG_TP2    (1U)          //!< Bit field size in bits for AIPS_PACRG_TP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_TP2 field.
#define BR_AIPS_PACRG_TP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_TP2))
#endif

//! @brief Format value for bitfield AIPS_PACRG_TP2.
#define BF_AIPS_PACRG_TP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_TP2), uint32_t) & BM_AIPS_PACRG_TP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP2 field to a new value.
#define BW_AIPS_PACRG_TP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_TP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRG_WP2    (21U)         //!< Bit position for AIPS_PACRG_WP2.
#define BM_AIPS_PACRG_WP2    (0x00200000U) //!< Bit mask for AIPS_PACRG_WP2.
#define BS_AIPS_PACRG_WP2    (1U)          //!< Bit field size in bits for AIPS_PACRG_WP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_WP2 field.
#define BR_AIPS_PACRG_WP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_WP2))
#endif

//! @brief Format value for bitfield AIPS_PACRG_WP2.
#define BF_AIPS_PACRG_WP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_WP2), uint32_t) & BM_AIPS_PACRG_WP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP2 field to a new value.
#define BW_AIPS_PACRG_WP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_WP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRG_SP2    (22U)         //!< Bit position for AIPS_PACRG_SP2.
#define BM_AIPS_PACRG_SP2    (0x00400000U) //!< Bit mask for AIPS_PACRG_SP2.
#define BS_AIPS_PACRG_SP2    (1U)          //!< Bit field size in bits for AIPS_PACRG_SP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_SP2 field.
#define BR_AIPS_PACRG_SP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_SP2))
#endif

//! @brief Format value for bitfield AIPS_PACRG_SP2.
#define BF_AIPS_PACRG_SP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_SP2), uint32_t) & BM_AIPS_PACRG_SP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP2 field to a new value.
#define BW_AIPS_PACRG_SP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_SP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRG_TP1    (24U)         //!< Bit position for AIPS_PACRG_TP1.
#define BM_AIPS_PACRG_TP1    (0x01000000U) //!< Bit mask for AIPS_PACRG_TP1.
#define BS_AIPS_PACRG_TP1    (1U)          //!< Bit field size in bits for AIPS_PACRG_TP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_TP1 field.
#define BR_AIPS_PACRG_TP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_TP1))
#endif

//! @brief Format value for bitfield AIPS_PACRG_TP1.
#define BF_AIPS_PACRG_TP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_TP1), uint32_t) & BM_AIPS_PACRG_TP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP1 field to a new value.
#define BW_AIPS_PACRG_TP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_TP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRG_WP1    (25U)         //!< Bit position for AIPS_PACRG_WP1.
#define BM_AIPS_PACRG_WP1    (0x02000000U) //!< Bit mask for AIPS_PACRG_WP1.
#define BS_AIPS_PACRG_WP1    (1U)          //!< Bit field size in bits for AIPS_PACRG_WP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_WP1 field.
#define BR_AIPS_PACRG_WP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_WP1))
#endif

//! @brief Format value for bitfield AIPS_PACRG_WP1.
#define BF_AIPS_PACRG_WP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_WP1), uint32_t) & BM_AIPS_PACRG_WP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP1 field to a new value.
#define BW_AIPS_PACRG_WP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_WP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRG_SP1    (26U)         //!< Bit position for AIPS_PACRG_SP1.
#define BM_AIPS_PACRG_SP1    (0x04000000U) //!< Bit mask for AIPS_PACRG_SP1.
#define BS_AIPS_PACRG_SP1    (1U)          //!< Bit field size in bits for AIPS_PACRG_SP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_SP1 field.
#define BR_AIPS_PACRG_SP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_SP1))
#endif

//! @brief Format value for bitfield AIPS_PACRG_SP1.
#define BF_AIPS_PACRG_SP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_SP1), uint32_t) & BM_AIPS_PACRG_SP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP1 field to a new value.
#define BW_AIPS_PACRG_SP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_SP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRG_TP0    (28U)         //!< Bit position for AIPS_PACRG_TP0.
#define BM_AIPS_PACRG_TP0    (0x10000000U) //!< Bit mask for AIPS_PACRG_TP0.
#define BS_AIPS_PACRG_TP0    (1U)          //!< Bit field size in bits for AIPS_PACRG_TP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_TP0 field.
#define BR_AIPS_PACRG_TP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_TP0))
#endif

//! @brief Format value for bitfield AIPS_PACRG_TP0.
#define BF_AIPS_PACRG_TP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_TP0), uint32_t) & BM_AIPS_PACRG_TP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP0 field to a new value.
#define BW_AIPS_PACRG_TP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_TP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRG_WP0    (29U)         //!< Bit position for AIPS_PACRG_WP0.
#define BM_AIPS_PACRG_WP0    (0x20000000U) //!< Bit mask for AIPS_PACRG_WP0.
#define BS_AIPS_PACRG_WP0    (1U)          //!< Bit field size in bits for AIPS_PACRG_WP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_WP0 field.
#define BR_AIPS_PACRG_WP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_WP0))
#endif

//! @brief Format value for bitfield AIPS_PACRG_WP0.
#define BF_AIPS_PACRG_WP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_WP0), uint32_t) & BM_AIPS_PACRG_WP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP0 field to a new value.
#define BW_AIPS_PACRG_WP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_WP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRG, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRG_SP0    (30U)         //!< Bit position for AIPS_PACRG_SP0.
#define BM_AIPS_PACRG_SP0    (0x40000000U) //!< Bit mask for AIPS_PACRG_SP0.
#define BS_AIPS_PACRG_SP0    (1U)          //!< Bit field size in bits for AIPS_PACRG_SP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRG_SP0 field.
#define BR_AIPS_PACRG_SP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_SP0))
#endif

//! @brief Format value for bitfield AIPS_PACRG_SP0.
#define BF_AIPS_PACRG_SP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRG_SP0), uint32_t) & BM_AIPS_PACRG_SP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP0 field to a new value.
#define BW_AIPS_PACRG_SP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRG_ADDR(x), BP_AIPS_PACRG_SP0) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AIPS_PACRH - Peripheral Access Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AIPS_PACRH - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
typedef union _hw_aips_pacrh
{
    uint32_t U;
    struct _hw_aips_pacrh_bitfields
    {
        uint32_t TP7 : 1;              //!< [0] Trusted Protect
        uint32_t WP7 : 1;              //!< [1] Write Protect
        uint32_t SP7 : 1;              //!< [2] Supervisor Protect
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t TP6 : 1;              //!< [4] Trusted Protect
        uint32_t WP6 : 1;              //!< [5] Write Protect
        uint32_t SP6 : 1;              //!< [6] Supervisor Protect
        uint32_t RESERVED1 : 1;        //!< [7]
        uint32_t TP5 : 1;              //!< [8] Trusted Protect
        uint32_t WP5 : 1;              //!< [9] Write Protect
        uint32_t SP5 : 1;              //!< [10] Supervisor Protect
        uint32_t RESERVED2 : 1;        //!< [11]
        uint32_t TP4 : 1;              //!< [12] Trusted Protect
        uint32_t WP4 : 1;              //!< [13] Write Protect
        uint32_t SP4 : 1;              //!< [14] Supervisor Protect
        uint32_t RESERVED3 : 1;        //!< [15]
        uint32_t TP3 : 1;              //!< [16] Trusted Protect
        uint32_t WP3 : 1;              //!< [17] Write Protect
        uint32_t SP3 : 1;              //!< [18] Supervisor Protect
        uint32_t RESERVED4 : 1;        //!< [19]
        uint32_t TP2 : 1;              //!< [20] Trusted Protect
        uint32_t WP2 : 1;              //!< [21] Write Protect
        uint32_t SP2 : 1;              //!< [22] Supervisor Protect
        uint32_t RESERVED5 : 1;        //!< [23]
        uint32_t TP1 : 1;              //!< [24] Trusted Protect
        uint32_t WP1 : 1;              //!< [25] Write Protect
        uint32_t SP1 : 1;              //!< [26] Supervisor Protect
        uint32_t RESERVED6 : 1;        //!< [27]
        uint32_t TP0 : 1;              //!< [28] Trusted Protect
        uint32_t WP0 : 1;              //!< [29] Write Protect
        uint32_t SP0 : 1;              //!< [30] Supervisor Protect
        uint32_t RESERVED7 : 1;        //!< [31]
    } B;
} hw_aips_pacrh_t;
#endif

/*!
 * @name Constants and macros for entire AIPS_PACRH register
 */
//@{
#define HW_AIPS_PACRH_ADDR(x)    (REGS_AIPS_BASE(x) + 0x4CU)

#ifndef __LANGUAGE_ASM__
#define HW_AIPS_PACRH(x)         (*(__IO hw_aips_pacrh_t *) HW_AIPS_PACRH_ADDR(x))
#define HW_AIPS_PACRH_RD(x)      (HW_AIPS_PACRH(x).U)
#define HW_AIPS_PACRH_WR(x, v)   (HW_AIPS_PACRH(x).U = (v))
#define HW_AIPS_PACRH_SET(x, v)  (HW_AIPS_PACRH_WR(x, HW_AIPS_PACRH_RD(x) |  (v)))
#define HW_AIPS_PACRH_CLR(x, v)  (HW_AIPS_PACRH_WR(x, HW_AIPS_PACRH_RD(x) & ~(v)))
#define HW_AIPS_PACRH_TOG(x, v)  (HW_AIPS_PACRH_WR(x, HW_AIPS_PACRH_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AIPS_PACRH bitfields
 */

/*!
 * @name Register AIPS_PACRH, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRH_TP7    (0U)          //!< Bit position for AIPS_PACRH_TP7.
#define BM_AIPS_PACRH_TP7    (0x00000001U) //!< Bit mask for AIPS_PACRH_TP7.
#define BS_AIPS_PACRH_TP7    (1U)          //!< Bit field size in bits for AIPS_PACRH_TP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_TP7 field.
#define BR_AIPS_PACRH_TP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_TP7))
#endif

//! @brief Format value for bitfield AIPS_PACRH_TP7.
#define BF_AIPS_PACRH_TP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_TP7), uint32_t) & BM_AIPS_PACRH_TP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP7 field to a new value.
#define BW_AIPS_PACRH_TP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_TP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRH_WP7    (1U)          //!< Bit position for AIPS_PACRH_WP7.
#define BM_AIPS_PACRH_WP7    (0x00000002U) //!< Bit mask for AIPS_PACRH_WP7.
#define BS_AIPS_PACRH_WP7    (1U)          //!< Bit field size in bits for AIPS_PACRH_WP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_WP7 field.
#define BR_AIPS_PACRH_WP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_WP7))
#endif

//! @brief Format value for bitfield AIPS_PACRH_WP7.
#define BF_AIPS_PACRH_WP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_WP7), uint32_t) & BM_AIPS_PACRH_WP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP7 field to a new value.
#define BW_AIPS_PACRH_WP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_WP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRH_SP7    (2U)          //!< Bit position for AIPS_PACRH_SP7.
#define BM_AIPS_PACRH_SP7    (0x00000004U) //!< Bit mask for AIPS_PACRH_SP7.
#define BS_AIPS_PACRH_SP7    (1U)          //!< Bit field size in bits for AIPS_PACRH_SP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_SP7 field.
#define BR_AIPS_PACRH_SP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_SP7))
#endif

//! @brief Format value for bitfield AIPS_PACRH_SP7.
#define BF_AIPS_PACRH_SP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_SP7), uint32_t) & BM_AIPS_PACRH_SP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP7 field to a new value.
#define BW_AIPS_PACRH_SP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_SP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRH_TP6    (4U)          //!< Bit position for AIPS_PACRH_TP6.
#define BM_AIPS_PACRH_TP6    (0x00000010U) //!< Bit mask for AIPS_PACRH_TP6.
#define BS_AIPS_PACRH_TP6    (1U)          //!< Bit field size in bits for AIPS_PACRH_TP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_TP6 field.
#define BR_AIPS_PACRH_TP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_TP6))
#endif

//! @brief Format value for bitfield AIPS_PACRH_TP6.
#define BF_AIPS_PACRH_TP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_TP6), uint32_t) & BM_AIPS_PACRH_TP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP6 field to a new value.
#define BW_AIPS_PACRH_TP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_TP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRH_WP6    (5U)          //!< Bit position for AIPS_PACRH_WP6.
#define BM_AIPS_PACRH_WP6    (0x00000020U) //!< Bit mask for AIPS_PACRH_WP6.
#define BS_AIPS_PACRH_WP6    (1U)          //!< Bit field size in bits for AIPS_PACRH_WP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_WP6 field.
#define BR_AIPS_PACRH_WP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_WP6))
#endif

//! @brief Format value for bitfield AIPS_PACRH_WP6.
#define BF_AIPS_PACRH_WP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_WP6), uint32_t) & BM_AIPS_PACRH_WP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP6 field to a new value.
#define BW_AIPS_PACRH_WP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_WP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRH_SP6    (6U)          //!< Bit position for AIPS_PACRH_SP6.
#define BM_AIPS_PACRH_SP6    (0x00000040U) //!< Bit mask for AIPS_PACRH_SP6.
#define BS_AIPS_PACRH_SP6    (1U)          //!< Bit field size in bits for AIPS_PACRH_SP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_SP6 field.
#define BR_AIPS_PACRH_SP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_SP6))
#endif

//! @brief Format value for bitfield AIPS_PACRH_SP6.
#define BF_AIPS_PACRH_SP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_SP6), uint32_t) & BM_AIPS_PACRH_SP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP6 field to a new value.
#define BW_AIPS_PACRH_SP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_SP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRH_TP5    (8U)          //!< Bit position for AIPS_PACRH_TP5.
#define BM_AIPS_PACRH_TP5    (0x00000100U) //!< Bit mask for AIPS_PACRH_TP5.
#define BS_AIPS_PACRH_TP5    (1U)          //!< Bit field size in bits for AIPS_PACRH_TP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_TP5 field.
#define BR_AIPS_PACRH_TP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_TP5))
#endif

//! @brief Format value for bitfield AIPS_PACRH_TP5.
#define BF_AIPS_PACRH_TP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_TP5), uint32_t) & BM_AIPS_PACRH_TP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP5 field to a new value.
#define BW_AIPS_PACRH_TP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_TP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRH_WP5    (9U)          //!< Bit position for AIPS_PACRH_WP5.
#define BM_AIPS_PACRH_WP5    (0x00000200U) //!< Bit mask for AIPS_PACRH_WP5.
#define BS_AIPS_PACRH_WP5    (1U)          //!< Bit field size in bits for AIPS_PACRH_WP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_WP5 field.
#define BR_AIPS_PACRH_WP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_WP5))
#endif

//! @brief Format value for bitfield AIPS_PACRH_WP5.
#define BF_AIPS_PACRH_WP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_WP5), uint32_t) & BM_AIPS_PACRH_WP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP5 field to a new value.
#define BW_AIPS_PACRH_WP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_WP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRH_SP5    (10U)         //!< Bit position for AIPS_PACRH_SP5.
#define BM_AIPS_PACRH_SP5    (0x00000400U) //!< Bit mask for AIPS_PACRH_SP5.
#define BS_AIPS_PACRH_SP5    (1U)          //!< Bit field size in bits for AIPS_PACRH_SP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_SP5 field.
#define BR_AIPS_PACRH_SP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_SP5))
#endif

//! @brief Format value for bitfield AIPS_PACRH_SP5.
#define BF_AIPS_PACRH_SP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_SP5), uint32_t) & BM_AIPS_PACRH_SP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP5 field to a new value.
#define BW_AIPS_PACRH_SP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_SP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRH_TP4    (12U)         //!< Bit position for AIPS_PACRH_TP4.
#define BM_AIPS_PACRH_TP4    (0x00001000U) //!< Bit mask for AIPS_PACRH_TP4.
#define BS_AIPS_PACRH_TP4    (1U)          //!< Bit field size in bits for AIPS_PACRH_TP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_TP4 field.
#define BR_AIPS_PACRH_TP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_TP4))
#endif

//! @brief Format value for bitfield AIPS_PACRH_TP4.
#define BF_AIPS_PACRH_TP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_TP4), uint32_t) & BM_AIPS_PACRH_TP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP4 field to a new value.
#define BW_AIPS_PACRH_TP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_TP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRH_WP4    (13U)         //!< Bit position for AIPS_PACRH_WP4.
#define BM_AIPS_PACRH_WP4    (0x00002000U) //!< Bit mask for AIPS_PACRH_WP4.
#define BS_AIPS_PACRH_WP4    (1U)          //!< Bit field size in bits for AIPS_PACRH_WP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_WP4 field.
#define BR_AIPS_PACRH_WP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_WP4))
#endif

//! @brief Format value for bitfield AIPS_PACRH_WP4.
#define BF_AIPS_PACRH_WP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_WP4), uint32_t) & BM_AIPS_PACRH_WP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP4 field to a new value.
#define BW_AIPS_PACRH_WP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_WP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRH_SP4    (14U)         //!< Bit position for AIPS_PACRH_SP4.
#define BM_AIPS_PACRH_SP4    (0x00004000U) //!< Bit mask for AIPS_PACRH_SP4.
#define BS_AIPS_PACRH_SP4    (1U)          //!< Bit field size in bits for AIPS_PACRH_SP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_SP4 field.
#define BR_AIPS_PACRH_SP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_SP4))
#endif

//! @brief Format value for bitfield AIPS_PACRH_SP4.
#define BF_AIPS_PACRH_SP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_SP4), uint32_t) & BM_AIPS_PACRH_SP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP4 field to a new value.
#define BW_AIPS_PACRH_SP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_SP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRH_TP3    (16U)         //!< Bit position for AIPS_PACRH_TP3.
#define BM_AIPS_PACRH_TP3    (0x00010000U) //!< Bit mask for AIPS_PACRH_TP3.
#define BS_AIPS_PACRH_TP3    (1U)          //!< Bit field size in bits for AIPS_PACRH_TP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_TP3 field.
#define BR_AIPS_PACRH_TP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_TP3))
#endif

//! @brief Format value for bitfield AIPS_PACRH_TP3.
#define BF_AIPS_PACRH_TP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_TP3), uint32_t) & BM_AIPS_PACRH_TP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP3 field to a new value.
#define BW_AIPS_PACRH_TP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_TP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRH_WP3    (17U)         //!< Bit position for AIPS_PACRH_WP3.
#define BM_AIPS_PACRH_WP3    (0x00020000U) //!< Bit mask for AIPS_PACRH_WP3.
#define BS_AIPS_PACRH_WP3    (1U)          //!< Bit field size in bits for AIPS_PACRH_WP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_WP3 field.
#define BR_AIPS_PACRH_WP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_WP3))
#endif

//! @brief Format value for bitfield AIPS_PACRH_WP3.
#define BF_AIPS_PACRH_WP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_WP3), uint32_t) & BM_AIPS_PACRH_WP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP3 field to a new value.
#define BW_AIPS_PACRH_WP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_WP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRH_SP3    (18U)         //!< Bit position for AIPS_PACRH_SP3.
#define BM_AIPS_PACRH_SP3    (0x00040000U) //!< Bit mask for AIPS_PACRH_SP3.
#define BS_AIPS_PACRH_SP3    (1U)          //!< Bit field size in bits for AIPS_PACRH_SP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_SP3 field.
#define BR_AIPS_PACRH_SP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_SP3))
#endif

//! @brief Format value for bitfield AIPS_PACRH_SP3.
#define BF_AIPS_PACRH_SP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_SP3), uint32_t) & BM_AIPS_PACRH_SP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP3 field to a new value.
#define BW_AIPS_PACRH_SP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_SP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRH_TP2    (20U)         //!< Bit position for AIPS_PACRH_TP2.
#define BM_AIPS_PACRH_TP2    (0x00100000U) //!< Bit mask for AIPS_PACRH_TP2.
#define BS_AIPS_PACRH_TP2    (1U)          //!< Bit field size in bits for AIPS_PACRH_TP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_TP2 field.
#define BR_AIPS_PACRH_TP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_TP2))
#endif

//! @brief Format value for bitfield AIPS_PACRH_TP2.
#define BF_AIPS_PACRH_TP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_TP2), uint32_t) & BM_AIPS_PACRH_TP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP2 field to a new value.
#define BW_AIPS_PACRH_TP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_TP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRH_WP2    (21U)         //!< Bit position for AIPS_PACRH_WP2.
#define BM_AIPS_PACRH_WP2    (0x00200000U) //!< Bit mask for AIPS_PACRH_WP2.
#define BS_AIPS_PACRH_WP2    (1U)          //!< Bit field size in bits for AIPS_PACRH_WP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_WP2 field.
#define BR_AIPS_PACRH_WP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_WP2))
#endif

//! @brief Format value for bitfield AIPS_PACRH_WP2.
#define BF_AIPS_PACRH_WP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_WP2), uint32_t) & BM_AIPS_PACRH_WP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP2 field to a new value.
#define BW_AIPS_PACRH_WP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_WP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRH_SP2    (22U)         //!< Bit position for AIPS_PACRH_SP2.
#define BM_AIPS_PACRH_SP2    (0x00400000U) //!< Bit mask for AIPS_PACRH_SP2.
#define BS_AIPS_PACRH_SP2    (1U)          //!< Bit field size in bits for AIPS_PACRH_SP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_SP2 field.
#define BR_AIPS_PACRH_SP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_SP2))
#endif

//! @brief Format value for bitfield AIPS_PACRH_SP2.
#define BF_AIPS_PACRH_SP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_SP2), uint32_t) & BM_AIPS_PACRH_SP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP2 field to a new value.
#define BW_AIPS_PACRH_SP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_SP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRH_TP1    (24U)         //!< Bit position for AIPS_PACRH_TP1.
#define BM_AIPS_PACRH_TP1    (0x01000000U) //!< Bit mask for AIPS_PACRH_TP1.
#define BS_AIPS_PACRH_TP1    (1U)          //!< Bit field size in bits for AIPS_PACRH_TP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_TP1 field.
#define BR_AIPS_PACRH_TP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_TP1))
#endif

//! @brief Format value for bitfield AIPS_PACRH_TP1.
#define BF_AIPS_PACRH_TP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_TP1), uint32_t) & BM_AIPS_PACRH_TP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP1 field to a new value.
#define BW_AIPS_PACRH_TP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_TP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRH_WP1    (25U)         //!< Bit position for AIPS_PACRH_WP1.
#define BM_AIPS_PACRH_WP1    (0x02000000U) //!< Bit mask for AIPS_PACRH_WP1.
#define BS_AIPS_PACRH_WP1    (1U)          //!< Bit field size in bits for AIPS_PACRH_WP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_WP1 field.
#define BR_AIPS_PACRH_WP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_WP1))
#endif

//! @brief Format value for bitfield AIPS_PACRH_WP1.
#define BF_AIPS_PACRH_WP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_WP1), uint32_t) & BM_AIPS_PACRH_WP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP1 field to a new value.
#define BW_AIPS_PACRH_WP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_WP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRH_SP1    (26U)         //!< Bit position for AIPS_PACRH_SP1.
#define BM_AIPS_PACRH_SP1    (0x04000000U) //!< Bit mask for AIPS_PACRH_SP1.
#define BS_AIPS_PACRH_SP1    (1U)          //!< Bit field size in bits for AIPS_PACRH_SP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_SP1 field.
#define BR_AIPS_PACRH_SP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_SP1))
#endif

//! @brief Format value for bitfield AIPS_PACRH_SP1.
#define BF_AIPS_PACRH_SP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_SP1), uint32_t) & BM_AIPS_PACRH_SP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP1 field to a new value.
#define BW_AIPS_PACRH_SP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_SP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRH_TP0    (28U)         //!< Bit position for AIPS_PACRH_TP0.
#define BM_AIPS_PACRH_TP0    (0x10000000U) //!< Bit mask for AIPS_PACRH_TP0.
#define BS_AIPS_PACRH_TP0    (1U)          //!< Bit field size in bits for AIPS_PACRH_TP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_TP0 field.
#define BR_AIPS_PACRH_TP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_TP0))
#endif

//! @brief Format value for bitfield AIPS_PACRH_TP0.
#define BF_AIPS_PACRH_TP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_TP0), uint32_t) & BM_AIPS_PACRH_TP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP0 field to a new value.
#define BW_AIPS_PACRH_TP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_TP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRH_WP0    (29U)         //!< Bit position for AIPS_PACRH_WP0.
#define BM_AIPS_PACRH_WP0    (0x20000000U) //!< Bit mask for AIPS_PACRH_WP0.
#define BS_AIPS_PACRH_WP0    (1U)          //!< Bit field size in bits for AIPS_PACRH_WP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_WP0 field.
#define BR_AIPS_PACRH_WP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_WP0))
#endif

//! @brief Format value for bitfield AIPS_PACRH_WP0.
#define BF_AIPS_PACRH_WP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_WP0), uint32_t) & BM_AIPS_PACRH_WP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP0 field to a new value.
#define BW_AIPS_PACRH_WP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_WP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRH, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRH_SP0    (30U)         //!< Bit position for AIPS_PACRH_SP0.
#define BM_AIPS_PACRH_SP0    (0x40000000U) //!< Bit mask for AIPS_PACRH_SP0.
#define BS_AIPS_PACRH_SP0    (1U)          //!< Bit field size in bits for AIPS_PACRH_SP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRH_SP0 field.
#define BR_AIPS_PACRH_SP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_SP0))
#endif

//! @brief Format value for bitfield AIPS_PACRH_SP0.
#define BF_AIPS_PACRH_SP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRH_SP0), uint32_t) & BM_AIPS_PACRH_SP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP0 field to a new value.
#define BW_AIPS_PACRH_SP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRH_ADDR(x), BP_AIPS_PACRH_SP0) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AIPS_PACRI - Peripheral Access Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AIPS_PACRI - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
typedef union _hw_aips_pacri
{
    uint32_t U;
    struct _hw_aips_pacri_bitfields
    {
        uint32_t TP7 : 1;              //!< [0] Trusted Protect
        uint32_t WP7 : 1;              //!< [1] Write Protect
        uint32_t SP7 : 1;              //!< [2] Supervisor Protect
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t TP6 : 1;              //!< [4] Trusted Protect
        uint32_t WP6 : 1;              //!< [5] Write Protect
        uint32_t SP6 : 1;              //!< [6] Supervisor Protect
        uint32_t RESERVED1 : 1;        //!< [7]
        uint32_t TP5 : 1;              //!< [8] Trusted Protect
        uint32_t WP5 : 1;              //!< [9] Write Protect
        uint32_t SP5 : 1;              //!< [10] Supervisor Protect
        uint32_t RESERVED2 : 1;        //!< [11]
        uint32_t TP4 : 1;              //!< [12] Trusted Protect
        uint32_t WP4 : 1;              //!< [13] Write Protect
        uint32_t SP4 : 1;              //!< [14] Supervisor Protect
        uint32_t RESERVED3 : 1;        //!< [15]
        uint32_t TP3 : 1;              //!< [16] Trusted Protect
        uint32_t WP3 : 1;              //!< [17] Write Protect
        uint32_t SP3 : 1;              //!< [18] Supervisor Protect
        uint32_t RESERVED4 : 1;        //!< [19]
        uint32_t TP2 : 1;              //!< [20] Trusted Protect
        uint32_t WP2 : 1;              //!< [21] Write Protect
        uint32_t SP2 : 1;              //!< [22] Supervisor Protect
        uint32_t RESERVED5 : 1;        //!< [23]
        uint32_t TP1 : 1;              //!< [24] Trusted Protect
        uint32_t WP1 : 1;              //!< [25] Write Protect
        uint32_t SP1 : 1;              //!< [26] Supervisor Protect
        uint32_t RESERVED6 : 1;        //!< [27]
        uint32_t TP0 : 1;              //!< [28] Trusted Protect
        uint32_t WP0 : 1;              //!< [29] Write Protect
        uint32_t SP0 : 1;              //!< [30] Supervisor Protect
        uint32_t RESERVED7 : 1;        //!< [31]
    } B;
} hw_aips_pacri_t;
#endif

/*!
 * @name Constants and macros for entire AIPS_PACRI register
 */
//@{
#define HW_AIPS_PACRI_ADDR(x)    (REGS_AIPS_BASE(x) + 0x50U)

#ifndef __LANGUAGE_ASM__
#define HW_AIPS_PACRI(x)         (*(__IO hw_aips_pacri_t *) HW_AIPS_PACRI_ADDR(x))
#define HW_AIPS_PACRI_RD(x)      (HW_AIPS_PACRI(x).U)
#define HW_AIPS_PACRI_WR(x, v)   (HW_AIPS_PACRI(x).U = (v))
#define HW_AIPS_PACRI_SET(x, v)  (HW_AIPS_PACRI_WR(x, HW_AIPS_PACRI_RD(x) |  (v)))
#define HW_AIPS_PACRI_CLR(x, v)  (HW_AIPS_PACRI_WR(x, HW_AIPS_PACRI_RD(x) & ~(v)))
#define HW_AIPS_PACRI_TOG(x, v)  (HW_AIPS_PACRI_WR(x, HW_AIPS_PACRI_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AIPS_PACRI bitfields
 */

/*!
 * @name Register AIPS_PACRI, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRI_TP7    (0U)          //!< Bit position for AIPS_PACRI_TP7.
#define BM_AIPS_PACRI_TP7    (0x00000001U) //!< Bit mask for AIPS_PACRI_TP7.
#define BS_AIPS_PACRI_TP7    (1U)          //!< Bit field size in bits for AIPS_PACRI_TP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_TP7 field.
#define BR_AIPS_PACRI_TP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_TP7))
#endif

//! @brief Format value for bitfield AIPS_PACRI_TP7.
#define BF_AIPS_PACRI_TP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_TP7), uint32_t) & BM_AIPS_PACRI_TP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP7 field to a new value.
#define BW_AIPS_PACRI_TP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_TP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRI_WP7    (1U)          //!< Bit position for AIPS_PACRI_WP7.
#define BM_AIPS_PACRI_WP7    (0x00000002U) //!< Bit mask for AIPS_PACRI_WP7.
#define BS_AIPS_PACRI_WP7    (1U)          //!< Bit field size in bits for AIPS_PACRI_WP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_WP7 field.
#define BR_AIPS_PACRI_WP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_WP7))
#endif

//! @brief Format value for bitfield AIPS_PACRI_WP7.
#define BF_AIPS_PACRI_WP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_WP7), uint32_t) & BM_AIPS_PACRI_WP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP7 field to a new value.
#define BW_AIPS_PACRI_WP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_WP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRI_SP7    (2U)          //!< Bit position for AIPS_PACRI_SP7.
#define BM_AIPS_PACRI_SP7    (0x00000004U) //!< Bit mask for AIPS_PACRI_SP7.
#define BS_AIPS_PACRI_SP7    (1U)          //!< Bit field size in bits for AIPS_PACRI_SP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_SP7 field.
#define BR_AIPS_PACRI_SP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_SP7))
#endif

//! @brief Format value for bitfield AIPS_PACRI_SP7.
#define BF_AIPS_PACRI_SP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_SP7), uint32_t) & BM_AIPS_PACRI_SP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP7 field to a new value.
#define BW_AIPS_PACRI_SP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_SP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRI_TP6    (4U)          //!< Bit position for AIPS_PACRI_TP6.
#define BM_AIPS_PACRI_TP6    (0x00000010U) //!< Bit mask for AIPS_PACRI_TP6.
#define BS_AIPS_PACRI_TP6    (1U)          //!< Bit field size in bits for AIPS_PACRI_TP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_TP6 field.
#define BR_AIPS_PACRI_TP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_TP6))
#endif

//! @brief Format value for bitfield AIPS_PACRI_TP6.
#define BF_AIPS_PACRI_TP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_TP6), uint32_t) & BM_AIPS_PACRI_TP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP6 field to a new value.
#define BW_AIPS_PACRI_TP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_TP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRI_WP6    (5U)          //!< Bit position for AIPS_PACRI_WP6.
#define BM_AIPS_PACRI_WP6    (0x00000020U) //!< Bit mask for AIPS_PACRI_WP6.
#define BS_AIPS_PACRI_WP6    (1U)          //!< Bit field size in bits for AIPS_PACRI_WP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_WP6 field.
#define BR_AIPS_PACRI_WP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_WP6))
#endif

//! @brief Format value for bitfield AIPS_PACRI_WP6.
#define BF_AIPS_PACRI_WP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_WP6), uint32_t) & BM_AIPS_PACRI_WP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP6 field to a new value.
#define BW_AIPS_PACRI_WP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_WP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRI_SP6    (6U)          //!< Bit position for AIPS_PACRI_SP6.
#define BM_AIPS_PACRI_SP6    (0x00000040U) //!< Bit mask for AIPS_PACRI_SP6.
#define BS_AIPS_PACRI_SP6    (1U)          //!< Bit field size in bits for AIPS_PACRI_SP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_SP6 field.
#define BR_AIPS_PACRI_SP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_SP6))
#endif

//! @brief Format value for bitfield AIPS_PACRI_SP6.
#define BF_AIPS_PACRI_SP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_SP6), uint32_t) & BM_AIPS_PACRI_SP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP6 field to a new value.
#define BW_AIPS_PACRI_SP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_SP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRI_TP5    (8U)          //!< Bit position for AIPS_PACRI_TP5.
#define BM_AIPS_PACRI_TP5    (0x00000100U) //!< Bit mask for AIPS_PACRI_TP5.
#define BS_AIPS_PACRI_TP5    (1U)          //!< Bit field size in bits for AIPS_PACRI_TP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_TP5 field.
#define BR_AIPS_PACRI_TP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_TP5))
#endif

//! @brief Format value for bitfield AIPS_PACRI_TP5.
#define BF_AIPS_PACRI_TP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_TP5), uint32_t) & BM_AIPS_PACRI_TP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP5 field to a new value.
#define BW_AIPS_PACRI_TP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_TP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRI_WP5    (9U)          //!< Bit position for AIPS_PACRI_WP5.
#define BM_AIPS_PACRI_WP5    (0x00000200U) //!< Bit mask for AIPS_PACRI_WP5.
#define BS_AIPS_PACRI_WP5    (1U)          //!< Bit field size in bits for AIPS_PACRI_WP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_WP5 field.
#define BR_AIPS_PACRI_WP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_WP5))
#endif

//! @brief Format value for bitfield AIPS_PACRI_WP5.
#define BF_AIPS_PACRI_WP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_WP5), uint32_t) & BM_AIPS_PACRI_WP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP5 field to a new value.
#define BW_AIPS_PACRI_WP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_WP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRI_SP5    (10U)         //!< Bit position for AIPS_PACRI_SP5.
#define BM_AIPS_PACRI_SP5    (0x00000400U) //!< Bit mask for AIPS_PACRI_SP5.
#define BS_AIPS_PACRI_SP5    (1U)          //!< Bit field size in bits for AIPS_PACRI_SP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_SP5 field.
#define BR_AIPS_PACRI_SP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_SP5))
#endif

//! @brief Format value for bitfield AIPS_PACRI_SP5.
#define BF_AIPS_PACRI_SP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_SP5), uint32_t) & BM_AIPS_PACRI_SP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP5 field to a new value.
#define BW_AIPS_PACRI_SP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_SP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRI_TP4    (12U)         //!< Bit position for AIPS_PACRI_TP4.
#define BM_AIPS_PACRI_TP4    (0x00001000U) //!< Bit mask for AIPS_PACRI_TP4.
#define BS_AIPS_PACRI_TP4    (1U)          //!< Bit field size in bits for AIPS_PACRI_TP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_TP4 field.
#define BR_AIPS_PACRI_TP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_TP4))
#endif

//! @brief Format value for bitfield AIPS_PACRI_TP4.
#define BF_AIPS_PACRI_TP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_TP4), uint32_t) & BM_AIPS_PACRI_TP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP4 field to a new value.
#define BW_AIPS_PACRI_TP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_TP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRI_WP4    (13U)         //!< Bit position for AIPS_PACRI_WP4.
#define BM_AIPS_PACRI_WP4    (0x00002000U) //!< Bit mask for AIPS_PACRI_WP4.
#define BS_AIPS_PACRI_WP4    (1U)          //!< Bit field size in bits for AIPS_PACRI_WP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_WP4 field.
#define BR_AIPS_PACRI_WP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_WP4))
#endif

//! @brief Format value for bitfield AIPS_PACRI_WP4.
#define BF_AIPS_PACRI_WP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_WP4), uint32_t) & BM_AIPS_PACRI_WP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP4 field to a new value.
#define BW_AIPS_PACRI_WP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_WP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRI_SP4    (14U)         //!< Bit position for AIPS_PACRI_SP4.
#define BM_AIPS_PACRI_SP4    (0x00004000U) //!< Bit mask for AIPS_PACRI_SP4.
#define BS_AIPS_PACRI_SP4    (1U)          //!< Bit field size in bits for AIPS_PACRI_SP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_SP4 field.
#define BR_AIPS_PACRI_SP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_SP4))
#endif

//! @brief Format value for bitfield AIPS_PACRI_SP4.
#define BF_AIPS_PACRI_SP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_SP4), uint32_t) & BM_AIPS_PACRI_SP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP4 field to a new value.
#define BW_AIPS_PACRI_SP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_SP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRI_TP3    (16U)         //!< Bit position for AIPS_PACRI_TP3.
#define BM_AIPS_PACRI_TP3    (0x00010000U) //!< Bit mask for AIPS_PACRI_TP3.
#define BS_AIPS_PACRI_TP3    (1U)          //!< Bit field size in bits for AIPS_PACRI_TP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_TP3 field.
#define BR_AIPS_PACRI_TP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_TP3))
#endif

//! @brief Format value for bitfield AIPS_PACRI_TP3.
#define BF_AIPS_PACRI_TP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_TP3), uint32_t) & BM_AIPS_PACRI_TP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP3 field to a new value.
#define BW_AIPS_PACRI_TP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_TP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRI_WP3    (17U)         //!< Bit position for AIPS_PACRI_WP3.
#define BM_AIPS_PACRI_WP3    (0x00020000U) //!< Bit mask for AIPS_PACRI_WP3.
#define BS_AIPS_PACRI_WP3    (1U)          //!< Bit field size in bits for AIPS_PACRI_WP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_WP3 field.
#define BR_AIPS_PACRI_WP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_WP3))
#endif

//! @brief Format value for bitfield AIPS_PACRI_WP3.
#define BF_AIPS_PACRI_WP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_WP3), uint32_t) & BM_AIPS_PACRI_WP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP3 field to a new value.
#define BW_AIPS_PACRI_WP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_WP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRI_SP3    (18U)         //!< Bit position for AIPS_PACRI_SP3.
#define BM_AIPS_PACRI_SP3    (0x00040000U) //!< Bit mask for AIPS_PACRI_SP3.
#define BS_AIPS_PACRI_SP3    (1U)          //!< Bit field size in bits for AIPS_PACRI_SP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_SP3 field.
#define BR_AIPS_PACRI_SP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_SP3))
#endif

//! @brief Format value for bitfield AIPS_PACRI_SP3.
#define BF_AIPS_PACRI_SP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_SP3), uint32_t) & BM_AIPS_PACRI_SP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP3 field to a new value.
#define BW_AIPS_PACRI_SP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_SP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRI_TP2    (20U)         //!< Bit position for AIPS_PACRI_TP2.
#define BM_AIPS_PACRI_TP2    (0x00100000U) //!< Bit mask for AIPS_PACRI_TP2.
#define BS_AIPS_PACRI_TP2    (1U)          //!< Bit field size in bits for AIPS_PACRI_TP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_TP2 field.
#define BR_AIPS_PACRI_TP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_TP2))
#endif

//! @brief Format value for bitfield AIPS_PACRI_TP2.
#define BF_AIPS_PACRI_TP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_TP2), uint32_t) & BM_AIPS_PACRI_TP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP2 field to a new value.
#define BW_AIPS_PACRI_TP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_TP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRI_WP2    (21U)         //!< Bit position for AIPS_PACRI_WP2.
#define BM_AIPS_PACRI_WP2    (0x00200000U) //!< Bit mask for AIPS_PACRI_WP2.
#define BS_AIPS_PACRI_WP2    (1U)          //!< Bit field size in bits for AIPS_PACRI_WP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_WP2 field.
#define BR_AIPS_PACRI_WP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_WP2))
#endif

//! @brief Format value for bitfield AIPS_PACRI_WP2.
#define BF_AIPS_PACRI_WP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_WP2), uint32_t) & BM_AIPS_PACRI_WP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP2 field to a new value.
#define BW_AIPS_PACRI_WP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_WP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRI_SP2    (22U)         //!< Bit position for AIPS_PACRI_SP2.
#define BM_AIPS_PACRI_SP2    (0x00400000U) //!< Bit mask for AIPS_PACRI_SP2.
#define BS_AIPS_PACRI_SP2    (1U)          //!< Bit field size in bits for AIPS_PACRI_SP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_SP2 field.
#define BR_AIPS_PACRI_SP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_SP2))
#endif

//! @brief Format value for bitfield AIPS_PACRI_SP2.
#define BF_AIPS_PACRI_SP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_SP2), uint32_t) & BM_AIPS_PACRI_SP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP2 field to a new value.
#define BW_AIPS_PACRI_SP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_SP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRI_TP1    (24U)         //!< Bit position for AIPS_PACRI_TP1.
#define BM_AIPS_PACRI_TP1    (0x01000000U) //!< Bit mask for AIPS_PACRI_TP1.
#define BS_AIPS_PACRI_TP1    (1U)          //!< Bit field size in bits for AIPS_PACRI_TP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_TP1 field.
#define BR_AIPS_PACRI_TP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_TP1))
#endif

//! @brief Format value for bitfield AIPS_PACRI_TP1.
#define BF_AIPS_PACRI_TP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_TP1), uint32_t) & BM_AIPS_PACRI_TP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP1 field to a new value.
#define BW_AIPS_PACRI_TP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_TP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRI_WP1    (25U)         //!< Bit position for AIPS_PACRI_WP1.
#define BM_AIPS_PACRI_WP1    (0x02000000U) //!< Bit mask for AIPS_PACRI_WP1.
#define BS_AIPS_PACRI_WP1    (1U)          //!< Bit field size in bits for AIPS_PACRI_WP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_WP1 field.
#define BR_AIPS_PACRI_WP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_WP1))
#endif

//! @brief Format value for bitfield AIPS_PACRI_WP1.
#define BF_AIPS_PACRI_WP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_WP1), uint32_t) & BM_AIPS_PACRI_WP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP1 field to a new value.
#define BW_AIPS_PACRI_WP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_WP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRI_SP1    (26U)         //!< Bit position for AIPS_PACRI_SP1.
#define BM_AIPS_PACRI_SP1    (0x04000000U) //!< Bit mask for AIPS_PACRI_SP1.
#define BS_AIPS_PACRI_SP1    (1U)          //!< Bit field size in bits for AIPS_PACRI_SP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_SP1 field.
#define BR_AIPS_PACRI_SP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_SP1))
#endif

//! @brief Format value for bitfield AIPS_PACRI_SP1.
#define BF_AIPS_PACRI_SP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_SP1), uint32_t) & BM_AIPS_PACRI_SP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP1 field to a new value.
#define BW_AIPS_PACRI_SP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_SP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRI_TP0    (28U)         //!< Bit position for AIPS_PACRI_TP0.
#define BM_AIPS_PACRI_TP0    (0x10000000U) //!< Bit mask for AIPS_PACRI_TP0.
#define BS_AIPS_PACRI_TP0    (1U)          //!< Bit field size in bits for AIPS_PACRI_TP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_TP0 field.
#define BR_AIPS_PACRI_TP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_TP0))
#endif

//! @brief Format value for bitfield AIPS_PACRI_TP0.
#define BF_AIPS_PACRI_TP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_TP0), uint32_t) & BM_AIPS_PACRI_TP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP0 field to a new value.
#define BW_AIPS_PACRI_TP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_TP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRI_WP0    (29U)         //!< Bit position for AIPS_PACRI_WP0.
#define BM_AIPS_PACRI_WP0    (0x20000000U) //!< Bit mask for AIPS_PACRI_WP0.
#define BS_AIPS_PACRI_WP0    (1U)          //!< Bit field size in bits for AIPS_PACRI_WP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_WP0 field.
#define BR_AIPS_PACRI_WP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_WP0))
#endif

//! @brief Format value for bitfield AIPS_PACRI_WP0.
#define BF_AIPS_PACRI_WP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_WP0), uint32_t) & BM_AIPS_PACRI_WP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP0 field to a new value.
#define BW_AIPS_PACRI_WP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_WP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRI, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRI_SP0    (30U)         //!< Bit position for AIPS_PACRI_SP0.
#define BM_AIPS_PACRI_SP0    (0x40000000U) //!< Bit mask for AIPS_PACRI_SP0.
#define BS_AIPS_PACRI_SP0    (1U)          //!< Bit field size in bits for AIPS_PACRI_SP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRI_SP0 field.
#define BR_AIPS_PACRI_SP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_SP0))
#endif

//! @brief Format value for bitfield AIPS_PACRI_SP0.
#define BF_AIPS_PACRI_SP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRI_SP0), uint32_t) & BM_AIPS_PACRI_SP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP0 field to a new value.
#define BW_AIPS_PACRI_SP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRI_ADDR(x), BP_AIPS_PACRI_SP0) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AIPS_PACRJ - Peripheral Access Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AIPS_PACRJ - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
typedef union _hw_aips_pacrj
{
    uint32_t U;
    struct _hw_aips_pacrj_bitfields
    {
        uint32_t TP7 : 1;              //!< [0] Trusted Protect
        uint32_t WP7 : 1;              //!< [1] Write Protect
        uint32_t SP7 : 1;              //!< [2] Supervisor Protect
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t TP6 : 1;              //!< [4] Trusted Protect
        uint32_t WP6 : 1;              //!< [5] Write Protect
        uint32_t SP6 : 1;              //!< [6] Supervisor Protect
        uint32_t RESERVED1 : 1;        //!< [7]
        uint32_t TP5 : 1;              //!< [8] Trusted Protect
        uint32_t WP5 : 1;              //!< [9] Write Protect
        uint32_t SP5 : 1;              //!< [10] Supervisor Protect
        uint32_t RESERVED2 : 1;        //!< [11]
        uint32_t TP4 : 1;              //!< [12] Trusted Protect
        uint32_t WP4 : 1;              //!< [13] Write Protect
        uint32_t SP4 : 1;              //!< [14] Supervisor Protect
        uint32_t RESERVED3 : 1;        //!< [15]
        uint32_t TP3 : 1;              //!< [16] Trusted Protect
        uint32_t WP3 : 1;              //!< [17] Write Protect
        uint32_t SP3 : 1;              //!< [18] Supervisor Protect
        uint32_t RESERVED4 : 1;        //!< [19]
        uint32_t TP2 : 1;              //!< [20] Trusted Protect
        uint32_t WP2 : 1;              //!< [21] Write Protect
        uint32_t SP2 : 1;              //!< [22] Supervisor Protect
        uint32_t RESERVED5 : 1;        //!< [23]
        uint32_t TP1 : 1;              //!< [24] Trusted Protect
        uint32_t WP1 : 1;              //!< [25] Write Protect
        uint32_t SP1 : 1;              //!< [26] Supervisor Protect
        uint32_t RESERVED6 : 1;        //!< [27]
        uint32_t TP0 : 1;              //!< [28] Trusted Protect
        uint32_t WP0 : 1;              //!< [29] Write Protect
        uint32_t SP0 : 1;              //!< [30] Supervisor Protect
        uint32_t RESERVED7 : 1;        //!< [31]
    } B;
} hw_aips_pacrj_t;
#endif

/*!
 * @name Constants and macros for entire AIPS_PACRJ register
 */
//@{
#define HW_AIPS_PACRJ_ADDR(x)    (REGS_AIPS_BASE(x) + 0x54U)

#ifndef __LANGUAGE_ASM__
#define HW_AIPS_PACRJ(x)         (*(__IO hw_aips_pacrj_t *) HW_AIPS_PACRJ_ADDR(x))
#define HW_AIPS_PACRJ_RD(x)      (HW_AIPS_PACRJ(x).U)
#define HW_AIPS_PACRJ_WR(x, v)   (HW_AIPS_PACRJ(x).U = (v))
#define HW_AIPS_PACRJ_SET(x, v)  (HW_AIPS_PACRJ_WR(x, HW_AIPS_PACRJ_RD(x) |  (v)))
#define HW_AIPS_PACRJ_CLR(x, v)  (HW_AIPS_PACRJ_WR(x, HW_AIPS_PACRJ_RD(x) & ~(v)))
#define HW_AIPS_PACRJ_TOG(x, v)  (HW_AIPS_PACRJ_WR(x, HW_AIPS_PACRJ_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AIPS_PACRJ bitfields
 */

/*!
 * @name Register AIPS_PACRJ, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRJ_TP7    (0U)          //!< Bit position for AIPS_PACRJ_TP7.
#define BM_AIPS_PACRJ_TP7    (0x00000001U) //!< Bit mask for AIPS_PACRJ_TP7.
#define BS_AIPS_PACRJ_TP7    (1U)          //!< Bit field size in bits for AIPS_PACRJ_TP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_TP7 field.
#define BR_AIPS_PACRJ_TP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_TP7))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_TP7.
#define BF_AIPS_PACRJ_TP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_TP7), uint32_t) & BM_AIPS_PACRJ_TP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP7 field to a new value.
#define BW_AIPS_PACRJ_TP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_TP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRJ_WP7    (1U)          //!< Bit position for AIPS_PACRJ_WP7.
#define BM_AIPS_PACRJ_WP7    (0x00000002U) //!< Bit mask for AIPS_PACRJ_WP7.
#define BS_AIPS_PACRJ_WP7    (1U)          //!< Bit field size in bits for AIPS_PACRJ_WP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_WP7 field.
#define BR_AIPS_PACRJ_WP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_WP7))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_WP7.
#define BF_AIPS_PACRJ_WP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_WP7), uint32_t) & BM_AIPS_PACRJ_WP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP7 field to a new value.
#define BW_AIPS_PACRJ_WP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_WP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRJ_SP7    (2U)          //!< Bit position for AIPS_PACRJ_SP7.
#define BM_AIPS_PACRJ_SP7    (0x00000004U) //!< Bit mask for AIPS_PACRJ_SP7.
#define BS_AIPS_PACRJ_SP7    (1U)          //!< Bit field size in bits for AIPS_PACRJ_SP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_SP7 field.
#define BR_AIPS_PACRJ_SP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_SP7))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_SP7.
#define BF_AIPS_PACRJ_SP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_SP7), uint32_t) & BM_AIPS_PACRJ_SP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP7 field to a new value.
#define BW_AIPS_PACRJ_SP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_SP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRJ_TP6    (4U)          //!< Bit position for AIPS_PACRJ_TP6.
#define BM_AIPS_PACRJ_TP6    (0x00000010U) //!< Bit mask for AIPS_PACRJ_TP6.
#define BS_AIPS_PACRJ_TP6    (1U)          //!< Bit field size in bits for AIPS_PACRJ_TP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_TP6 field.
#define BR_AIPS_PACRJ_TP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_TP6))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_TP6.
#define BF_AIPS_PACRJ_TP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_TP6), uint32_t) & BM_AIPS_PACRJ_TP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP6 field to a new value.
#define BW_AIPS_PACRJ_TP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_TP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRJ_WP6    (5U)          //!< Bit position for AIPS_PACRJ_WP6.
#define BM_AIPS_PACRJ_WP6    (0x00000020U) //!< Bit mask for AIPS_PACRJ_WP6.
#define BS_AIPS_PACRJ_WP6    (1U)          //!< Bit field size in bits for AIPS_PACRJ_WP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_WP6 field.
#define BR_AIPS_PACRJ_WP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_WP6))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_WP6.
#define BF_AIPS_PACRJ_WP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_WP6), uint32_t) & BM_AIPS_PACRJ_WP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP6 field to a new value.
#define BW_AIPS_PACRJ_WP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_WP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRJ_SP6    (6U)          //!< Bit position for AIPS_PACRJ_SP6.
#define BM_AIPS_PACRJ_SP6    (0x00000040U) //!< Bit mask for AIPS_PACRJ_SP6.
#define BS_AIPS_PACRJ_SP6    (1U)          //!< Bit field size in bits for AIPS_PACRJ_SP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_SP6 field.
#define BR_AIPS_PACRJ_SP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_SP6))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_SP6.
#define BF_AIPS_PACRJ_SP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_SP6), uint32_t) & BM_AIPS_PACRJ_SP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP6 field to a new value.
#define BW_AIPS_PACRJ_SP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_SP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRJ_TP5    (8U)          //!< Bit position for AIPS_PACRJ_TP5.
#define BM_AIPS_PACRJ_TP5    (0x00000100U) //!< Bit mask for AIPS_PACRJ_TP5.
#define BS_AIPS_PACRJ_TP5    (1U)          //!< Bit field size in bits for AIPS_PACRJ_TP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_TP5 field.
#define BR_AIPS_PACRJ_TP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_TP5))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_TP5.
#define BF_AIPS_PACRJ_TP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_TP5), uint32_t) & BM_AIPS_PACRJ_TP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP5 field to a new value.
#define BW_AIPS_PACRJ_TP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_TP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRJ_WP5    (9U)          //!< Bit position for AIPS_PACRJ_WP5.
#define BM_AIPS_PACRJ_WP5    (0x00000200U) //!< Bit mask for AIPS_PACRJ_WP5.
#define BS_AIPS_PACRJ_WP5    (1U)          //!< Bit field size in bits for AIPS_PACRJ_WP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_WP5 field.
#define BR_AIPS_PACRJ_WP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_WP5))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_WP5.
#define BF_AIPS_PACRJ_WP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_WP5), uint32_t) & BM_AIPS_PACRJ_WP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP5 field to a new value.
#define BW_AIPS_PACRJ_WP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_WP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRJ_SP5    (10U)         //!< Bit position for AIPS_PACRJ_SP5.
#define BM_AIPS_PACRJ_SP5    (0x00000400U) //!< Bit mask for AIPS_PACRJ_SP5.
#define BS_AIPS_PACRJ_SP5    (1U)          //!< Bit field size in bits for AIPS_PACRJ_SP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_SP5 field.
#define BR_AIPS_PACRJ_SP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_SP5))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_SP5.
#define BF_AIPS_PACRJ_SP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_SP5), uint32_t) & BM_AIPS_PACRJ_SP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP5 field to a new value.
#define BW_AIPS_PACRJ_SP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_SP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRJ_TP4    (12U)         //!< Bit position for AIPS_PACRJ_TP4.
#define BM_AIPS_PACRJ_TP4    (0x00001000U) //!< Bit mask for AIPS_PACRJ_TP4.
#define BS_AIPS_PACRJ_TP4    (1U)          //!< Bit field size in bits for AIPS_PACRJ_TP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_TP4 field.
#define BR_AIPS_PACRJ_TP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_TP4))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_TP4.
#define BF_AIPS_PACRJ_TP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_TP4), uint32_t) & BM_AIPS_PACRJ_TP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP4 field to a new value.
#define BW_AIPS_PACRJ_TP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_TP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRJ_WP4    (13U)         //!< Bit position for AIPS_PACRJ_WP4.
#define BM_AIPS_PACRJ_WP4    (0x00002000U) //!< Bit mask for AIPS_PACRJ_WP4.
#define BS_AIPS_PACRJ_WP4    (1U)          //!< Bit field size in bits for AIPS_PACRJ_WP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_WP4 field.
#define BR_AIPS_PACRJ_WP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_WP4))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_WP4.
#define BF_AIPS_PACRJ_WP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_WP4), uint32_t) & BM_AIPS_PACRJ_WP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP4 field to a new value.
#define BW_AIPS_PACRJ_WP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_WP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRJ_SP4    (14U)         //!< Bit position for AIPS_PACRJ_SP4.
#define BM_AIPS_PACRJ_SP4    (0x00004000U) //!< Bit mask for AIPS_PACRJ_SP4.
#define BS_AIPS_PACRJ_SP4    (1U)          //!< Bit field size in bits for AIPS_PACRJ_SP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_SP4 field.
#define BR_AIPS_PACRJ_SP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_SP4))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_SP4.
#define BF_AIPS_PACRJ_SP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_SP4), uint32_t) & BM_AIPS_PACRJ_SP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP4 field to a new value.
#define BW_AIPS_PACRJ_SP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_SP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRJ_TP3    (16U)         //!< Bit position for AIPS_PACRJ_TP3.
#define BM_AIPS_PACRJ_TP3    (0x00010000U) //!< Bit mask for AIPS_PACRJ_TP3.
#define BS_AIPS_PACRJ_TP3    (1U)          //!< Bit field size in bits for AIPS_PACRJ_TP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_TP3 field.
#define BR_AIPS_PACRJ_TP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_TP3))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_TP3.
#define BF_AIPS_PACRJ_TP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_TP3), uint32_t) & BM_AIPS_PACRJ_TP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP3 field to a new value.
#define BW_AIPS_PACRJ_TP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_TP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRJ_WP3    (17U)         //!< Bit position for AIPS_PACRJ_WP3.
#define BM_AIPS_PACRJ_WP3    (0x00020000U) //!< Bit mask for AIPS_PACRJ_WP3.
#define BS_AIPS_PACRJ_WP3    (1U)          //!< Bit field size in bits for AIPS_PACRJ_WP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_WP3 field.
#define BR_AIPS_PACRJ_WP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_WP3))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_WP3.
#define BF_AIPS_PACRJ_WP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_WP3), uint32_t) & BM_AIPS_PACRJ_WP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP3 field to a new value.
#define BW_AIPS_PACRJ_WP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_WP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRJ_SP3    (18U)         //!< Bit position for AIPS_PACRJ_SP3.
#define BM_AIPS_PACRJ_SP3    (0x00040000U) //!< Bit mask for AIPS_PACRJ_SP3.
#define BS_AIPS_PACRJ_SP3    (1U)          //!< Bit field size in bits for AIPS_PACRJ_SP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_SP3 field.
#define BR_AIPS_PACRJ_SP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_SP3))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_SP3.
#define BF_AIPS_PACRJ_SP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_SP3), uint32_t) & BM_AIPS_PACRJ_SP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP3 field to a new value.
#define BW_AIPS_PACRJ_SP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_SP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRJ_TP2    (20U)         //!< Bit position for AIPS_PACRJ_TP2.
#define BM_AIPS_PACRJ_TP2    (0x00100000U) //!< Bit mask for AIPS_PACRJ_TP2.
#define BS_AIPS_PACRJ_TP2    (1U)          //!< Bit field size in bits for AIPS_PACRJ_TP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_TP2 field.
#define BR_AIPS_PACRJ_TP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_TP2))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_TP2.
#define BF_AIPS_PACRJ_TP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_TP2), uint32_t) & BM_AIPS_PACRJ_TP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP2 field to a new value.
#define BW_AIPS_PACRJ_TP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_TP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRJ_WP2    (21U)         //!< Bit position for AIPS_PACRJ_WP2.
#define BM_AIPS_PACRJ_WP2    (0x00200000U) //!< Bit mask for AIPS_PACRJ_WP2.
#define BS_AIPS_PACRJ_WP2    (1U)          //!< Bit field size in bits for AIPS_PACRJ_WP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_WP2 field.
#define BR_AIPS_PACRJ_WP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_WP2))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_WP2.
#define BF_AIPS_PACRJ_WP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_WP2), uint32_t) & BM_AIPS_PACRJ_WP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP2 field to a new value.
#define BW_AIPS_PACRJ_WP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_WP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRJ_SP2    (22U)         //!< Bit position for AIPS_PACRJ_SP2.
#define BM_AIPS_PACRJ_SP2    (0x00400000U) //!< Bit mask for AIPS_PACRJ_SP2.
#define BS_AIPS_PACRJ_SP2    (1U)          //!< Bit field size in bits for AIPS_PACRJ_SP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_SP2 field.
#define BR_AIPS_PACRJ_SP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_SP2))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_SP2.
#define BF_AIPS_PACRJ_SP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_SP2), uint32_t) & BM_AIPS_PACRJ_SP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP2 field to a new value.
#define BW_AIPS_PACRJ_SP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_SP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRJ_TP1    (24U)         //!< Bit position for AIPS_PACRJ_TP1.
#define BM_AIPS_PACRJ_TP1    (0x01000000U) //!< Bit mask for AIPS_PACRJ_TP1.
#define BS_AIPS_PACRJ_TP1    (1U)          //!< Bit field size in bits for AIPS_PACRJ_TP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_TP1 field.
#define BR_AIPS_PACRJ_TP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_TP1))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_TP1.
#define BF_AIPS_PACRJ_TP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_TP1), uint32_t) & BM_AIPS_PACRJ_TP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP1 field to a new value.
#define BW_AIPS_PACRJ_TP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_TP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRJ_WP1    (25U)         //!< Bit position for AIPS_PACRJ_WP1.
#define BM_AIPS_PACRJ_WP1    (0x02000000U) //!< Bit mask for AIPS_PACRJ_WP1.
#define BS_AIPS_PACRJ_WP1    (1U)          //!< Bit field size in bits for AIPS_PACRJ_WP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_WP1 field.
#define BR_AIPS_PACRJ_WP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_WP1))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_WP1.
#define BF_AIPS_PACRJ_WP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_WP1), uint32_t) & BM_AIPS_PACRJ_WP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP1 field to a new value.
#define BW_AIPS_PACRJ_WP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_WP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRJ_SP1    (26U)         //!< Bit position for AIPS_PACRJ_SP1.
#define BM_AIPS_PACRJ_SP1    (0x04000000U) //!< Bit mask for AIPS_PACRJ_SP1.
#define BS_AIPS_PACRJ_SP1    (1U)          //!< Bit field size in bits for AIPS_PACRJ_SP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_SP1 field.
#define BR_AIPS_PACRJ_SP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_SP1))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_SP1.
#define BF_AIPS_PACRJ_SP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_SP1), uint32_t) & BM_AIPS_PACRJ_SP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP1 field to a new value.
#define BW_AIPS_PACRJ_SP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_SP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRJ_TP0    (28U)         //!< Bit position for AIPS_PACRJ_TP0.
#define BM_AIPS_PACRJ_TP0    (0x10000000U) //!< Bit mask for AIPS_PACRJ_TP0.
#define BS_AIPS_PACRJ_TP0    (1U)          //!< Bit field size in bits for AIPS_PACRJ_TP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_TP0 field.
#define BR_AIPS_PACRJ_TP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_TP0))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_TP0.
#define BF_AIPS_PACRJ_TP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_TP0), uint32_t) & BM_AIPS_PACRJ_TP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP0 field to a new value.
#define BW_AIPS_PACRJ_TP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_TP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRJ_WP0    (29U)         //!< Bit position for AIPS_PACRJ_WP0.
#define BM_AIPS_PACRJ_WP0    (0x20000000U) //!< Bit mask for AIPS_PACRJ_WP0.
#define BS_AIPS_PACRJ_WP0    (1U)          //!< Bit field size in bits for AIPS_PACRJ_WP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_WP0 field.
#define BR_AIPS_PACRJ_WP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_WP0))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_WP0.
#define BF_AIPS_PACRJ_WP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_WP0), uint32_t) & BM_AIPS_PACRJ_WP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP0 field to a new value.
#define BW_AIPS_PACRJ_WP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_WP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRJ, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRJ_SP0    (30U)         //!< Bit position for AIPS_PACRJ_SP0.
#define BM_AIPS_PACRJ_SP0    (0x40000000U) //!< Bit mask for AIPS_PACRJ_SP0.
#define BS_AIPS_PACRJ_SP0    (1U)          //!< Bit field size in bits for AIPS_PACRJ_SP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRJ_SP0 field.
#define BR_AIPS_PACRJ_SP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_SP0))
#endif

//! @brief Format value for bitfield AIPS_PACRJ_SP0.
#define BF_AIPS_PACRJ_SP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRJ_SP0), uint32_t) & BM_AIPS_PACRJ_SP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP0 field to a new value.
#define BW_AIPS_PACRJ_SP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRJ_ADDR(x), BP_AIPS_PACRJ_SP0) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AIPS_PACRK - Peripheral Access Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AIPS_PACRK - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
typedef union _hw_aips_pacrk
{
    uint32_t U;
    struct _hw_aips_pacrk_bitfields
    {
        uint32_t TP7 : 1;              //!< [0] Trusted Protect
        uint32_t WP7 : 1;              //!< [1] Write Protect
        uint32_t SP7 : 1;              //!< [2] Supervisor Protect
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t TP6 : 1;              //!< [4] Trusted Protect
        uint32_t WP6 : 1;              //!< [5] Write Protect
        uint32_t SP6 : 1;              //!< [6] Supervisor Protect
        uint32_t RESERVED1 : 1;        //!< [7]
        uint32_t TP5 : 1;              //!< [8] Trusted Protect
        uint32_t WP5 : 1;              //!< [9] Write Protect
        uint32_t SP5 : 1;              //!< [10] Supervisor Protect
        uint32_t RESERVED2 : 1;        //!< [11]
        uint32_t TP4 : 1;              //!< [12] Trusted Protect
        uint32_t WP4 : 1;              //!< [13] Write Protect
        uint32_t SP4 : 1;              //!< [14] Supervisor Protect
        uint32_t RESERVED3 : 1;        //!< [15]
        uint32_t TP3 : 1;              //!< [16] Trusted Protect
        uint32_t WP3 : 1;              //!< [17] Write Protect
        uint32_t SP3 : 1;              //!< [18] Supervisor Protect
        uint32_t RESERVED4 : 1;        //!< [19]
        uint32_t TP2 : 1;              //!< [20] Trusted Protect
        uint32_t WP2 : 1;              //!< [21] Write Protect
        uint32_t SP2 : 1;              //!< [22] Supervisor Protect
        uint32_t RESERVED5 : 1;        //!< [23]
        uint32_t TP1 : 1;              //!< [24] Trusted Protect
        uint32_t WP1 : 1;              //!< [25] Write Protect
        uint32_t SP1 : 1;              //!< [26] Supervisor Protect
        uint32_t RESERVED6 : 1;        //!< [27]
        uint32_t TP0 : 1;              //!< [28] Trusted Protect
        uint32_t WP0 : 1;              //!< [29] Write Protect
        uint32_t SP0 : 1;              //!< [30] Supervisor Protect
        uint32_t RESERVED7 : 1;        //!< [31]
    } B;
} hw_aips_pacrk_t;
#endif

/*!
 * @name Constants and macros for entire AIPS_PACRK register
 */
//@{
#define HW_AIPS_PACRK_ADDR(x)    (REGS_AIPS_BASE(x) + 0x58U)

#ifndef __LANGUAGE_ASM__
#define HW_AIPS_PACRK(x)         (*(__IO hw_aips_pacrk_t *) HW_AIPS_PACRK_ADDR(x))
#define HW_AIPS_PACRK_RD(x)      (HW_AIPS_PACRK(x).U)
#define HW_AIPS_PACRK_WR(x, v)   (HW_AIPS_PACRK(x).U = (v))
#define HW_AIPS_PACRK_SET(x, v)  (HW_AIPS_PACRK_WR(x, HW_AIPS_PACRK_RD(x) |  (v)))
#define HW_AIPS_PACRK_CLR(x, v)  (HW_AIPS_PACRK_WR(x, HW_AIPS_PACRK_RD(x) & ~(v)))
#define HW_AIPS_PACRK_TOG(x, v)  (HW_AIPS_PACRK_WR(x, HW_AIPS_PACRK_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AIPS_PACRK bitfields
 */

/*!
 * @name Register AIPS_PACRK, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRK_TP7    (0U)          //!< Bit position for AIPS_PACRK_TP7.
#define BM_AIPS_PACRK_TP7    (0x00000001U) //!< Bit mask for AIPS_PACRK_TP7.
#define BS_AIPS_PACRK_TP7    (1U)          //!< Bit field size in bits for AIPS_PACRK_TP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_TP7 field.
#define BR_AIPS_PACRK_TP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_TP7))
#endif

//! @brief Format value for bitfield AIPS_PACRK_TP7.
#define BF_AIPS_PACRK_TP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_TP7), uint32_t) & BM_AIPS_PACRK_TP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP7 field to a new value.
#define BW_AIPS_PACRK_TP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_TP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRK_WP7    (1U)          //!< Bit position for AIPS_PACRK_WP7.
#define BM_AIPS_PACRK_WP7    (0x00000002U) //!< Bit mask for AIPS_PACRK_WP7.
#define BS_AIPS_PACRK_WP7    (1U)          //!< Bit field size in bits for AIPS_PACRK_WP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_WP7 field.
#define BR_AIPS_PACRK_WP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_WP7))
#endif

//! @brief Format value for bitfield AIPS_PACRK_WP7.
#define BF_AIPS_PACRK_WP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_WP7), uint32_t) & BM_AIPS_PACRK_WP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP7 field to a new value.
#define BW_AIPS_PACRK_WP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_WP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRK_SP7    (2U)          //!< Bit position for AIPS_PACRK_SP7.
#define BM_AIPS_PACRK_SP7    (0x00000004U) //!< Bit mask for AIPS_PACRK_SP7.
#define BS_AIPS_PACRK_SP7    (1U)          //!< Bit field size in bits for AIPS_PACRK_SP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_SP7 field.
#define BR_AIPS_PACRK_SP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_SP7))
#endif

//! @brief Format value for bitfield AIPS_PACRK_SP7.
#define BF_AIPS_PACRK_SP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_SP7), uint32_t) & BM_AIPS_PACRK_SP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP7 field to a new value.
#define BW_AIPS_PACRK_SP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_SP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRK_TP6    (4U)          //!< Bit position for AIPS_PACRK_TP6.
#define BM_AIPS_PACRK_TP6    (0x00000010U) //!< Bit mask for AIPS_PACRK_TP6.
#define BS_AIPS_PACRK_TP6    (1U)          //!< Bit field size in bits for AIPS_PACRK_TP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_TP6 field.
#define BR_AIPS_PACRK_TP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_TP6))
#endif

//! @brief Format value for bitfield AIPS_PACRK_TP6.
#define BF_AIPS_PACRK_TP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_TP6), uint32_t) & BM_AIPS_PACRK_TP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP6 field to a new value.
#define BW_AIPS_PACRK_TP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_TP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRK_WP6    (5U)          //!< Bit position for AIPS_PACRK_WP6.
#define BM_AIPS_PACRK_WP6    (0x00000020U) //!< Bit mask for AIPS_PACRK_WP6.
#define BS_AIPS_PACRK_WP6    (1U)          //!< Bit field size in bits for AIPS_PACRK_WP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_WP6 field.
#define BR_AIPS_PACRK_WP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_WP6))
#endif

//! @brief Format value for bitfield AIPS_PACRK_WP6.
#define BF_AIPS_PACRK_WP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_WP6), uint32_t) & BM_AIPS_PACRK_WP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP6 field to a new value.
#define BW_AIPS_PACRK_WP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_WP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRK_SP6    (6U)          //!< Bit position for AIPS_PACRK_SP6.
#define BM_AIPS_PACRK_SP6    (0x00000040U) //!< Bit mask for AIPS_PACRK_SP6.
#define BS_AIPS_PACRK_SP6    (1U)          //!< Bit field size in bits for AIPS_PACRK_SP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_SP6 field.
#define BR_AIPS_PACRK_SP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_SP6))
#endif

//! @brief Format value for bitfield AIPS_PACRK_SP6.
#define BF_AIPS_PACRK_SP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_SP6), uint32_t) & BM_AIPS_PACRK_SP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP6 field to a new value.
#define BW_AIPS_PACRK_SP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_SP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRK_TP5    (8U)          //!< Bit position for AIPS_PACRK_TP5.
#define BM_AIPS_PACRK_TP5    (0x00000100U) //!< Bit mask for AIPS_PACRK_TP5.
#define BS_AIPS_PACRK_TP5    (1U)          //!< Bit field size in bits for AIPS_PACRK_TP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_TP5 field.
#define BR_AIPS_PACRK_TP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_TP5))
#endif

//! @brief Format value for bitfield AIPS_PACRK_TP5.
#define BF_AIPS_PACRK_TP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_TP5), uint32_t) & BM_AIPS_PACRK_TP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP5 field to a new value.
#define BW_AIPS_PACRK_TP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_TP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRK_WP5    (9U)          //!< Bit position for AIPS_PACRK_WP5.
#define BM_AIPS_PACRK_WP5    (0x00000200U) //!< Bit mask for AIPS_PACRK_WP5.
#define BS_AIPS_PACRK_WP5    (1U)          //!< Bit field size in bits for AIPS_PACRK_WP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_WP5 field.
#define BR_AIPS_PACRK_WP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_WP5))
#endif

//! @brief Format value for bitfield AIPS_PACRK_WP5.
#define BF_AIPS_PACRK_WP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_WP5), uint32_t) & BM_AIPS_PACRK_WP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP5 field to a new value.
#define BW_AIPS_PACRK_WP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_WP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRK_SP5    (10U)         //!< Bit position for AIPS_PACRK_SP5.
#define BM_AIPS_PACRK_SP5    (0x00000400U) //!< Bit mask for AIPS_PACRK_SP5.
#define BS_AIPS_PACRK_SP5    (1U)          //!< Bit field size in bits for AIPS_PACRK_SP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_SP5 field.
#define BR_AIPS_PACRK_SP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_SP5))
#endif

//! @brief Format value for bitfield AIPS_PACRK_SP5.
#define BF_AIPS_PACRK_SP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_SP5), uint32_t) & BM_AIPS_PACRK_SP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP5 field to a new value.
#define BW_AIPS_PACRK_SP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_SP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRK_TP4    (12U)         //!< Bit position for AIPS_PACRK_TP4.
#define BM_AIPS_PACRK_TP4    (0x00001000U) //!< Bit mask for AIPS_PACRK_TP4.
#define BS_AIPS_PACRK_TP4    (1U)          //!< Bit field size in bits for AIPS_PACRK_TP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_TP4 field.
#define BR_AIPS_PACRK_TP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_TP4))
#endif

//! @brief Format value for bitfield AIPS_PACRK_TP4.
#define BF_AIPS_PACRK_TP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_TP4), uint32_t) & BM_AIPS_PACRK_TP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP4 field to a new value.
#define BW_AIPS_PACRK_TP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_TP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRK_WP4    (13U)         //!< Bit position for AIPS_PACRK_WP4.
#define BM_AIPS_PACRK_WP4    (0x00002000U) //!< Bit mask for AIPS_PACRK_WP4.
#define BS_AIPS_PACRK_WP4    (1U)          //!< Bit field size in bits for AIPS_PACRK_WP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_WP4 field.
#define BR_AIPS_PACRK_WP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_WP4))
#endif

//! @brief Format value for bitfield AIPS_PACRK_WP4.
#define BF_AIPS_PACRK_WP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_WP4), uint32_t) & BM_AIPS_PACRK_WP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP4 field to a new value.
#define BW_AIPS_PACRK_WP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_WP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRK_SP4    (14U)         //!< Bit position for AIPS_PACRK_SP4.
#define BM_AIPS_PACRK_SP4    (0x00004000U) //!< Bit mask for AIPS_PACRK_SP4.
#define BS_AIPS_PACRK_SP4    (1U)          //!< Bit field size in bits for AIPS_PACRK_SP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_SP4 field.
#define BR_AIPS_PACRK_SP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_SP4))
#endif

//! @brief Format value for bitfield AIPS_PACRK_SP4.
#define BF_AIPS_PACRK_SP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_SP4), uint32_t) & BM_AIPS_PACRK_SP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP4 field to a new value.
#define BW_AIPS_PACRK_SP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_SP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRK_TP3    (16U)         //!< Bit position for AIPS_PACRK_TP3.
#define BM_AIPS_PACRK_TP3    (0x00010000U) //!< Bit mask for AIPS_PACRK_TP3.
#define BS_AIPS_PACRK_TP3    (1U)          //!< Bit field size in bits for AIPS_PACRK_TP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_TP3 field.
#define BR_AIPS_PACRK_TP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_TP3))
#endif

//! @brief Format value for bitfield AIPS_PACRK_TP3.
#define BF_AIPS_PACRK_TP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_TP3), uint32_t) & BM_AIPS_PACRK_TP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP3 field to a new value.
#define BW_AIPS_PACRK_TP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_TP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRK_WP3    (17U)         //!< Bit position for AIPS_PACRK_WP3.
#define BM_AIPS_PACRK_WP3    (0x00020000U) //!< Bit mask for AIPS_PACRK_WP3.
#define BS_AIPS_PACRK_WP3    (1U)          //!< Bit field size in bits for AIPS_PACRK_WP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_WP3 field.
#define BR_AIPS_PACRK_WP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_WP3))
#endif

//! @brief Format value for bitfield AIPS_PACRK_WP3.
#define BF_AIPS_PACRK_WP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_WP3), uint32_t) & BM_AIPS_PACRK_WP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP3 field to a new value.
#define BW_AIPS_PACRK_WP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_WP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRK_SP3    (18U)         //!< Bit position for AIPS_PACRK_SP3.
#define BM_AIPS_PACRK_SP3    (0x00040000U) //!< Bit mask for AIPS_PACRK_SP3.
#define BS_AIPS_PACRK_SP3    (1U)          //!< Bit field size in bits for AIPS_PACRK_SP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_SP3 field.
#define BR_AIPS_PACRK_SP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_SP3))
#endif

//! @brief Format value for bitfield AIPS_PACRK_SP3.
#define BF_AIPS_PACRK_SP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_SP3), uint32_t) & BM_AIPS_PACRK_SP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP3 field to a new value.
#define BW_AIPS_PACRK_SP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_SP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRK_TP2    (20U)         //!< Bit position for AIPS_PACRK_TP2.
#define BM_AIPS_PACRK_TP2    (0x00100000U) //!< Bit mask for AIPS_PACRK_TP2.
#define BS_AIPS_PACRK_TP2    (1U)          //!< Bit field size in bits for AIPS_PACRK_TP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_TP2 field.
#define BR_AIPS_PACRK_TP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_TP2))
#endif

//! @brief Format value for bitfield AIPS_PACRK_TP2.
#define BF_AIPS_PACRK_TP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_TP2), uint32_t) & BM_AIPS_PACRK_TP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP2 field to a new value.
#define BW_AIPS_PACRK_TP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_TP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRK_WP2    (21U)         //!< Bit position for AIPS_PACRK_WP2.
#define BM_AIPS_PACRK_WP2    (0x00200000U) //!< Bit mask for AIPS_PACRK_WP2.
#define BS_AIPS_PACRK_WP2    (1U)          //!< Bit field size in bits for AIPS_PACRK_WP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_WP2 field.
#define BR_AIPS_PACRK_WP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_WP2))
#endif

//! @brief Format value for bitfield AIPS_PACRK_WP2.
#define BF_AIPS_PACRK_WP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_WP2), uint32_t) & BM_AIPS_PACRK_WP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP2 field to a new value.
#define BW_AIPS_PACRK_WP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_WP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRK_SP2    (22U)         //!< Bit position for AIPS_PACRK_SP2.
#define BM_AIPS_PACRK_SP2    (0x00400000U) //!< Bit mask for AIPS_PACRK_SP2.
#define BS_AIPS_PACRK_SP2    (1U)          //!< Bit field size in bits for AIPS_PACRK_SP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_SP2 field.
#define BR_AIPS_PACRK_SP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_SP2))
#endif

//! @brief Format value for bitfield AIPS_PACRK_SP2.
#define BF_AIPS_PACRK_SP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_SP2), uint32_t) & BM_AIPS_PACRK_SP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP2 field to a new value.
#define BW_AIPS_PACRK_SP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_SP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRK_TP1    (24U)         //!< Bit position for AIPS_PACRK_TP1.
#define BM_AIPS_PACRK_TP1    (0x01000000U) //!< Bit mask for AIPS_PACRK_TP1.
#define BS_AIPS_PACRK_TP1    (1U)          //!< Bit field size in bits for AIPS_PACRK_TP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_TP1 field.
#define BR_AIPS_PACRK_TP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_TP1))
#endif

//! @brief Format value for bitfield AIPS_PACRK_TP1.
#define BF_AIPS_PACRK_TP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_TP1), uint32_t) & BM_AIPS_PACRK_TP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP1 field to a new value.
#define BW_AIPS_PACRK_TP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_TP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRK_WP1    (25U)         //!< Bit position for AIPS_PACRK_WP1.
#define BM_AIPS_PACRK_WP1    (0x02000000U) //!< Bit mask for AIPS_PACRK_WP1.
#define BS_AIPS_PACRK_WP1    (1U)          //!< Bit field size in bits for AIPS_PACRK_WP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_WP1 field.
#define BR_AIPS_PACRK_WP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_WP1))
#endif

//! @brief Format value for bitfield AIPS_PACRK_WP1.
#define BF_AIPS_PACRK_WP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_WP1), uint32_t) & BM_AIPS_PACRK_WP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP1 field to a new value.
#define BW_AIPS_PACRK_WP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_WP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRK_SP1    (26U)         //!< Bit position for AIPS_PACRK_SP1.
#define BM_AIPS_PACRK_SP1    (0x04000000U) //!< Bit mask for AIPS_PACRK_SP1.
#define BS_AIPS_PACRK_SP1    (1U)          //!< Bit field size in bits for AIPS_PACRK_SP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_SP1 field.
#define BR_AIPS_PACRK_SP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_SP1))
#endif

//! @brief Format value for bitfield AIPS_PACRK_SP1.
#define BF_AIPS_PACRK_SP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_SP1), uint32_t) & BM_AIPS_PACRK_SP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP1 field to a new value.
#define BW_AIPS_PACRK_SP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_SP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRK_TP0    (28U)         //!< Bit position for AIPS_PACRK_TP0.
#define BM_AIPS_PACRK_TP0    (0x10000000U) //!< Bit mask for AIPS_PACRK_TP0.
#define BS_AIPS_PACRK_TP0    (1U)          //!< Bit field size in bits for AIPS_PACRK_TP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_TP0 field.
#define BR_AIPS_PACRK_TP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_TP0))
#endif

//! @brief Format value for bitfield AIPS_PACRK_TP0.
#define BF_AIPS_PACRK_TP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_TP0), uint32_t) & BM_AIPS_PACRK_TP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP0 field to a new value.
#define BW_AIPS_PACRK_TP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_TP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRK_WP0    (29U)         //!< Bit position for AIPS_PACRK_WP0.
#define BM_AIPS_PACRK_WP0    (0x20000000U) //!< Bit mask for AIPS_PACRK_WP0.
#define BS_AIPS_PACRK_WP0    (1U)          //!< Bit field size in bits for AIPS_PACRK_WP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_WP0 field.
#define BR_AIPS_PACRK_WP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_WP0))
#endif

//! @brief Format value for bitfield AIPS_PACRK_WP0.
#define BF_AIPS_PACRK_WP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_WP0), uint32_t) & BM_AIPS_PACRK_WP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP0 field to a new value.
#define BW_AIPS_PACRK_WP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_WP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRK, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRK_SP0    (30U)         //!< Bit position for AIPS_PACRK_SP0.
#define BM_AIPS_PACRK_SP0    (0x40000000U) //!< Bit mask for AIPS_PACRK_SP0.
#define BS_AIPS_PACRK_SP0    (1U)          //!< Bit field size in bits for AIPS_PACRK_SP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRK_SP0 field.
#define BR_AIPS_PACRK_SP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_SP0))
#endif

//! @brief Format value for bitfield AIPS_PACRK_SP0.
#define BF_AIPS_PACRK_SP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRK_SP0), uint32_t) & BM_AIPS_PACRK_SP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP0 field to a new value.
#define BW_AIPS_PACRK_SP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRK_ADDR(x), BP_AIPS_PACRK_SP0) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AIPS_PACRL - Peripheral Access Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AIPS_PACRL - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
typedef union _hw_aips_pacrl
{
    uint32_t U;
    struct _hw_aips_pacrl_bitfields
    {
        uint32_t TP7 : 1;              //!< [0] Trusted Protect
        uint32_t WP7 : 1;              //!< [1] Write Protect
        uint32_t SP7 : 1;              //!< [2] Supervisor Protect
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t TP6 : 1;              //!< [4] Trusted Protect
        uint32_t WP6 : 1;              //!< [5] Write Protect
        uint32_t SP6 : 1;              //!< [6] Supervisor Protect
        uint32_t RESERVED1 : 1;        //!< [7]
        uint32_t TP5 : 1;              //!< [8] Trusted Protect
        uint32_t WP5 : 1;              //!< [9] Write Protect
        uint32_t SP5 : 1;              //!< [10] Supervisor Protect
        uint32_t RESERVED2 : 1;        //!< [11]
        uint32_t TP4 : 1;              //!< [12] Trusted Protect
        uint32_t WP4 : 1;              //!< [13] Write Protect
        uint32_t SP4 : 1;              //!< [14] Supervisor Protect
        uint32_t RESERVED3 : 1;        //!< [15]
        uint32_t TP3 : 1;              //!< [16] Trusted Protect
        uint32_t WP3 : 1;              //!< [17] Write Protect
        uint32_t SP3 : 1;              //!< [18] Supervisor Protect
        uint32_t RESERVED4 : 1;        //!< [19]
        uint32_t TP2 : 1;              //!< [20] Trusted Protect
        uint32_t WP2 : 1;              //!< [21] Write Protect
        uint32_t SP2 : 1;              //!< [22] Supervisor Protect
        uint32_t RESERVED5 : 1;        //!< [23]
        uint32_t TP1 : 1;              //!< [24] Trusted Protect
        uint32_t WP1 : 1;              //!< [25] Write Protect
        uint32_t SP1 : 1;              //!< [26] Supervisor Protect
        uint32_t RESERVED6 : 1;        //!< [27]
        uint32_t TP0 : 1;              //!< [28] Trusted Protect
        uint32_t WP0 : 1;              //!< [29] Write Protect
        uint32_t SP0 : 1;              //!< [30] Supervisor Protect
        uint32_t RESERVED7 : 1;        //!< [31]
    } B;
} hw_aips_pacrl_t;
#endif

/*!
 * @name Constants and macros for entire AIPS_PACRL register
 */
//@{
#define HW_AIPS_PACRL_ADDR(x)    (REGS_AIPS_BASE(x) + 0x5CU)

#ifndef __LANGUAGE_ASM__
#define HW_AIPS_PACRL(x)         (*(__IO hw_aips_pacrl_t *) HW_AIPS_PACRL_ADDR(x))
#define HW_AIPS_PACRL_RD(x)      (HW_AIPS_PACRL(x).U)
#define HW_AIPS_PACRL_WR(x, v)   (HW_AIPS_PACRL(x).U = (v))
#define HW_AIPS_PACRL_SET(x, v)  (HW_AIPS_PACRL_WR(x, HW_AIPS_PACRL_RD(x) |  (v)))
#define HW_AIPS_PACRL_CLR(x, v)  (HW_AIPS_PACRL_WR(x, HW_AIPS_PACRL_RD(x) & ~(v)))
#define HW_AIPS_PACRL_TOG(x, v)  (HW_AIPS_PACRL_WR(x, HW_AIPS_PACRL_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AIPS_PACRL bitfields
 */

/*!
 * @name Register AIPS_PACRL, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRL_TP7    (0U)          //!< Bit position for AIPS_PACRL_TP7.
#define BM_AIPS_PACRL_TP7    (0x00000001U) //!< Bit mask for AIPS_PACRL_TP7.
#define BS_AIPS_PACRL_TP7    (1U)          //!< Bit field size in bits for AIPS_PACRL_TP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_TP7 field.
#define BR_AIPS_PACRL_TP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_TP7))
#endif

//! @brief Format value for bitfield AIPS_PACRL_TP7.
#define BF_AIPS_PACRL_TP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_TP7), uint32_t) & BM_AIPS_PACRL_TP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP7 field to a new value.
#define BW_AIPS_PACRL_TP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_TP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRL_WP7    (1U)          //!< Bit position for AIPS_PACRL_WP7.
#define BM_AIPS_PACRL_WP7    (0x00000002U) //!< Bit mask for AIPS_PACRL_WP7.
#define BS_AIPS_PACRL_WP7    (1U)          //!< Bit field size in bits for AIPS_PACRL_WP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_WP7 field.
#define BR_AIPS_PACRL_WP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_WP7))
#endif

//! @brief Format value for bitfield AIPS_PACRL_WP7.
#define BF_AIPS_PACRL_WP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_WP7), uint32_t) & BM_AIPS_PACRL_WP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP7 field to a new value.
#define BW_AIPS_PACRL_WP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_WP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRL_SP7    (2U)          //!< Bit position for AIPS_PACRL_SP7.
#define BM_AIPS_PACRL_SP7    (0x00000004U) //!< Bit mask for AIPS_PACRL_SP7.
#define BS_AIPS_PACRL_SP7    (1U)          //!< Bit field size in bits for AIPS_PACRL_SP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_SP7 field.
#define BR_AIPS_PACRL_SP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_SP7))
#endif

//! @brief Format value for bitfield AIPS_PACRL_SP7.
#define BF_AIPS_PACRL_SP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_SP7), uint32_t) & BM_AIPS_PACRL_SP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP7 field to a new value.
#define BW_AIPS_PACRL_SP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_SP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRL_TP6    (4U)          //!< Bit position for AIPS_PACRL_TP6.
#define BM_AIPS_PACRL_TP6    (0x00000010U) //!< Bit mask for AIPS_PACRL_TP6.
#define BS_AIPS_PACRL_TP6    (1U)          //!< Bit field size in bits for AIPS_PACRL_TP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_TP6 field.
#define BR_AIPS_PACRL_TP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_TP6))
#endif

//! @brief Format value for bitfield AIPS_PACRL_TP6.
#define BF_AIPS_PACRL_TP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_TP6), uint32_t) & BM_AIPS_PACRL_TP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP6 field to a new value.
#define BW_AIPS_PACRL_TP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_TP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRL_WP6    (5U)          //!< Bit position for AIPS_PACRL_WP6.
#define BM_AIPS_PACRL_WP6    (0x00000020U) //!< Bit mask for AIPS_PACRL_WP6.
#define BS_AIPS_PACRL_WP6    (1U)          //!< Bit field size in bits for AIPS_PACRL_WP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_WP6 field.
#define BR_AIPS_PACRL_WP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_WP6))
#endif

//! @brief Format value for bitfield AIPS_PACRL_WP6.
#define BF_AIPS_PACRL_WP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_WP6), uint32_t) & BM_AIPS_PACRL_WP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP6 field to a new value.
#define BW_AIPS_PACRL_WP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_WP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRL_SP6    (6U)          //!< Bit position for AIPS_PACRL_SP6.
#define BM_AIPS_PACRL_SP6    (0x00000040U) //!< Bit mask for AIPS_PACRL_SP6.
#define BS_AIPS_PACRL_SP6    (1U)          //!< Bit field size in bits for AIPS_PACRL_SP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_SP6 field.
#define BR_AIPS_PACRL_SP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_SP6))
#endif

//! @brief Format value for bitfield AIPS_PACRL_SP6.
#define BF_AIPS_PACRL_SP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_SP6), uint32_t) & BM_AIPS_PACRL_SP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP6 field to a new value.
#define BW_AIPS_PACRL_SP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_SP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRL_TP5    (8U)          //!< Bit position for AIPS_PACRL_TP5.
#define BM_AIPS_PACRL_TP5    (0x00000100U) //!< Bit mask for AIPS_PACRL_TP5.
#define BS_AIPS_PACRL_TP5    (1U)          //!< Bit field size in bits for AIPS_PACRL_TP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_TP5 field.
#define BR_AIPS_PACRL_TP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_TP5))
#endif

//! @brief Format value for bitfield AIPS_PACRL_TP5.
#define BF_AIPS_PACRL_TP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_TP5), uint32_t) & BM_AIPS_PACRL_TP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP5 field to a new value.
#define BW_AIPS_PACRL_TP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_TP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRL_WP5    (9U)          //!< Bit position for AIPS_PACRL_WP5.
#define BM_AIPS_PACRL_WP5    (0x00000200U) //!< Bit mask for AIPS_PACRL_WP5.
#define BS_AIPS_PACRL_WP5    (1U)          //!< Bit field size in bits for AIPS_PACRL_WP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_WP5 field.
#define BR_AIPS_PACRL_WP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_WP5))
#endif

//! @brief Format value for bitfield AIPS_PACRL_WP5.
#define BF_AIPS_PACRL_WP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_WP5), uint32_t) & BM_AIPS_PACRL_WP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP5 field to a new value.
#define BW_AIPS_PACRL_WP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_WP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRL_SP5    (10U)         //!< Bit position for AIPS_PACRL_SP5.
#define BM_AIPS_PACRL_SP5    (0x00000400U) //!< Bit mask for AIPS_PACRL_SP5.
#define BS_AIPS_PACRL_SP5    (1U)          //!< Bit field size in bits for AIPS_PACRL_SP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_SP5 field.
#define BR_AIPS_PACRL_SP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_SP5))
#endif

//! @brief Format value for bitfield AIPS_PACRL_SP5.
#define BF_AIPS_PACRL_SP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_SP5), uint32_t) & BM_AIPS_PACRL_SP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP5 field to a new value.
#define BW_AIPS_PACRL_SP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_SP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRL_TP4    (12U)         //!< Bit position for AIPS_PACRL_TP4.
#define BM_AIPS_PACRL_TP4    (0x00001000U) //!< Bit mask for AIPS_PACRL_TP4.
#define BS_AIPS_PACRL_TP4    (1U)          //!< Bit field size in bits for AIPS_PACRL_TP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_TP4 field.
#define BR_AIPS_PACRL_TP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_TP4))
#endif

//! @brief Format value for bitfield AIPS_PACRL_TP4.
#define BF_AIPS_PACRL_TP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_TP4), uint32_t) & BM_AIPS_PACRL_TP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP4 field to a new value.
#define BW_AIPS_PACRL_TP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_TP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRL_WP4    (13U)         //!< Bit position for AIPS_PACRL_WP4.
#define BM_AIPS_PACRL_WP4    (0x00002000U) //!< Bit mask for AIPS_PACRL_WP4.
#define BS_AIPS_PACRL_WP4    (1U)          //!< Bit field size in bits for AIPS_PACRL_WP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_WP4 field.
#define BR_AIPS_PACRL_WP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_WP4))
#endif

//! @brief Format value for bitfield AIPS_PACRL_WP4.
#define BF_AIPS_PACRL_WP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_WP4), uint32_t) & BM_AIPS_PACRL_WP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP4 field to a new value.
#define BW_AIPS_PACRL_WP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_WP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRL_SP4    (14U)         //!< Bit position for AIPS_PACRL_SP4.
#define BM_AIPS_PACRL_SP4    (0x00004000U) //!< Bit mask for AIPS_PACRL_SP4.
#define BS_AIPS_PACRL_SP4    (1U)          //!< Bit field size in bits for AIPS_PACRL_SP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_SP4 field.
#define BR_AIPS_PACRL_SP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_SP4))
#endif

//! @brief Format value for bitfield AIPS_PACRL_SP4.
#define BF_AIPS_PACRL_SP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_SP4), uint32_t) & BM_AIPS_PACRL_SP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP4 field to a new value.
#define BW_AIPS_PACRL_SP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_SP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRL_TP3    (16U)         //!< Bit position for AIPS_PACRL_TP3.
#define BM_AIPS_PACRL_TP3    (0x00010000U) //!< Bit mask for AIPS_PACRL_TP3.
#define BS_AIPS_PACRL_TP3    (1U)          //!< Bit field size in bits for AIPS_PACRL_TP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_TP3 field.
#define BR_AIPS_PACRL_TP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_TP3))
#endif

//! @brief Format value for bitfield AIPS_PACRL_TP3.
#define BF_AIPS_PACRL_TP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_TP3), uint32_t) & BM_AIPS_PACRL_TP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP3 field to a new value.
#define BW_AIPS_PACRL_TP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_TP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRL_WP3    (17U)         //!< Bit position for AIPS_PACRL_WP3.
#define BM_AIPS_PACRL_WP3    (0x00020000U) //!< Bit mask for AIPS_PACRL_WP3.
#define BS_AIPS_PACRL_WP3    (1U)          //!< Bit field size in bits for AIPS_PACRL_WP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_WP3 field.
#define BR_AIPS_PACRL_WP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_WP3))
#endif

//! @brief Format value for bitfield AIPS_PACRL_WP3.
#define BF_AIPS_PACRL_WP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_WP3), uint32_t) & BM_AIPS_PACRL_WP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP3 field to a new value.
#define BW_AIPS_PACRL_WP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_WP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRL_SP3    (18U)         //!< Bit position for AIPS_PACRL_SP3.
#define BM_AIPS_PACRL_SP3    (0x00040000U) //!< Bit mask for AIPS_PACRL_SP3.
#define BS_AIPS_PACRL_SP3    (1U)          //!< Bit field size in bits for AIPS_PACRL_SP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_SP3 field.
#define BR_AIPS_PACRL_SP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_SP3))
#endif

//! @brief Format value for bitfield AIPS_PACRL_SP3.
#define BF_AIPS_PACRL_SP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_SP3), uint32_t) & BM_AIPS_PACRL_SP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP3 field to a new value.
#define BW_AIPS_PACRL_SP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_SP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRL_TP2    (20U)         //!< Bit position for AIPS_PACRL_TP2.
#define BM_AIPS_PACRL_TP2    (0x00100000U) //!< Bit mask for AIPS_PACRL_TP2.
#define BS_AIPS_PACRL_TP2    (1U)          //!< Bit field size in bits for AIPS_PACRL_TP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_TP2 field.
#define BR_AIPS_PACRL_TP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_TP2))
#endif

//! @brief Format value for bitfield AIPS_PACRL_TP2.
#define BF_AIPS_PACRL_TP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_TP2), uint32_t) & BM_AIPS_PACRL_TP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP2 field to a new value.
#define BW_AIPS_PACRL_TP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_TP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRL_WP2    (21U)         //!< Bit position for AIPS_PACRL_WP2.
#define BM_AIPS_PACRL_WP2    (0x00200000U) //!< Bit mask for AIPS_PACRL_WP2.
#define BS_AIPS_PACRL_WP2    (1U)          //!< Bit field size in bits for AIPS_PACRL_WP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_WP2 field.
#define BR_AIPS_PACRL_WP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_WP2))
#endif

//! @brief Format value for bitfield AIPS_PACRL_WP2.
#define BF_AIPS_PACRL_WP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_WP2), uint32_t) & BM_AIPS_PACRL_WP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP2 field to a new value.
#define BW_AIPS_PACRL_WP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_WP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRL_SP2    (22U)         //!< Bit position for AIPS_PACRL_SP2.
#define BM_AIPS_PACRL_SP2    (0x00400000U) //!< Bit mask for AIPS_PACRL_SP2.
#define BS_AIPS_PACRL_SP2    (1U)          //!< Bit field size in bits for AIPS_PACRL_SP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_SP2 field.
#define BR_AIPS_PACRL_SP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_SP2))
#endif

//! @brief Format value for bitfield AIPS_PACRL_SP2.
#define BF_AIPS_PACRL_SP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_SP2), uint32_t) & BM_AIPS_PACRL_SP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP2 field to a new value.
#define BW_AIPS_PACRL_SP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_SP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRL_TP1    (24U)         //!< Bit position for AIPS_PACRL_TP1.
#define BM_AIPS_PACRL_TP1    (0x01000000U) //!< Bit mask for AIPS_PACRL_TP1.
#define BS_AIPS_PACRL_TP1    (1U)          //!< Bit field size in bits for AIPS_PACRL_TP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_TP1 field.
#define BR_AIPS_PACRL_TP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_TP1))
#endif

//! @brief Format value for bitfield AIPS_PACRL_TP1.
#define BF_AIPS_PACRL_TP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_TP1), uint32_t) & BM_AIPS_PACRL_TP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP1 field to a new value.
#define BW_AIPS_PACRL_TP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_TP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRL_WP1    (25U)         //!< Bit position for AIPS_PACRL_WP1.
#define BM_AIPS_PACRL_WP1    (0x02000000U) //!< Bit mask for AIPS_PACRL_WP1.
#define BS_AIPS_PACRL_WP1    (1U)          //!< Bit field size in bits for AIPS_PACRL_WP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_WP1 field.
#define BR_AIPS_PACRL_WP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_WP1))
#endif

//! @brief Format value for bitfield AIPS_PACRL_WP1.
#define BF_AIPS_PACRL_WP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_WP1), uint32_t) & BM_AIPS_PACRL_WP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP1 field to a new value.
#define BW_AIPS_PACRL_WP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_WP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRL_SP1    (26U)         //!< Bit position for AIPS_PACRL_SP1.
#define BM_AIPS_PACRL_SP1    (0x04000000U) //!< Bit mask for AIPS_PACRL_SP1.
#define BS_AIPS_PACRL_SP1    (1U)          //!< Bit field size in bits for AIPS_PACRL_SP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_SP1 field.
#define BR_AIPS_PACRL_SP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_SP1))
#endif

//! @brief Format value for bitfield AIPS_PACRL_SP1.
#define BF_AIPS_PACRL_SP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_SP1), uint32_t) & BM_AIPS_PACRL_SP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP1 field to a new value.
#define BW_AIPS_PACRL_SP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_SP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRL_TP0    (28U)         //!< Bit position for AIPS_PACRL_TP0.
#define BM_AIPS_PACRL_TP0    (0x10000000U) //!< Bit mask for AIPS_PACRL_TP0.
#define BS_AIPS_PACRL_TP0    (1U)          //!< Bit field size in bits for AIPS_PACRL_TP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_TP0 field.
#define BR_AIPS_PACRL_TP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_TP0))
#endif

//! @brief Format value for bitfield AIPS_PACRL_TP0.
#define BF_AIPS_PACRL_TP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_TP0), uint32_t) & BM_AIPS_PACRL_TP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP0 field to a new value.
#define BW_AIPS_PACRL_TP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_TP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRL_WP0    (29U)         //!< Bit position for AIPS_PACRL_WP0.
#define BM_AIPS_PACRL_WP0    (0x20000000U) //!< Bit mask for AIPS_PACRL_WP0.
#define BS_AIPS_PACRL_WP0    (1U)          //!< Bit field size in bits for AIPS_PACRL_WP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_WP0 field.
#define BR_AIPS_PACRL_WP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_WP0))
#endif

//! @brief Format value for bitfield AIPS_PACRL_WP0.
#define BF_AIPS_PACRL_WP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_WP0), uint32_t) & BM_AIPS_PACRL_WP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP0 field to a new value.
#define BW_AIPS_PACRL_WP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_WP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRL, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRL_SP0    (30U)         //!< Bit position for AIPS_PACRL_SP0.
#define BM_AIPS_PACRL_SP0    (0x40000000U) //!< Bit mask for AIPS_PACRL_SP0.
#define BS_AIPS_PACRL_SP0    (1U)          //!< Bit field size in bits for AIPS_PACRL_SP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRL_SP0 field.
#define BR_AIPS_PACRL_SP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_SP0))
#endif

//! @brief Format value for bitfield AIPS_PACRL_SP0.
#define BF_AIPS_PACRL_SP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRL_SP0), uint32_t) & BM_AIPS_PACRL_SP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP0 field to a new value.
#define BW_AIPS_PACRL_SP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRL_ADDR(x), BP_AIPS_PACRL_SP0) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AIPS_PACRM - Peripheral Access Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AIPS_PACRM - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
typedef union _hw_aips_pacrm
{
    uint32_t U;
    struct _hw_aips_pacrm_bitfields
    {
        uint32_t TP7 : 1;              //!< [0] Trusted Protect
        uint32_t WP7 : 1;              //!< [1] Write Protect
        uint32_t SP7 : 1;              //!< [2] Supervisor Protect
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t TP6 : 1;              //!< [4] Trusted Protect
        uint32_t WP6 : 1;              //!< [5] Write Protect
        uint32_t SP6 : 1;              //!< [6] Supervisor Protect
        uint32_t RESERVED1 : 1;        //!< [7]
        uint32_t TP5 : 1;              //!< [8] Trusted Protect
        uint32_t WP5 : 1;              //!< [9] Write Protect
        uint32_t SP5 : 1;              //!< [10] Supervisor Protect
        uint32_t RESERVED2 : 1;        //!< [11]
        uint32_t TP4 : 1;              //!< [12] Trusted Protect
        uint32_t WP4 : 1;              //!< [13] Write Protect
        uint32_t SP4 : 1;              //!< [14] Supervisor Protect
        uint32_t RESERVED3 : 1;        //!< [15]
        uint32_t TP3 : 1;              //!< [16] Trusted Protect
        uint32_t WP3 : 1;              //!< [17] Write Protect
        uint32_t SP3 : 1;              //!< [18] Supervisor Protect
        uint32_t RESERVED4 : 1;        //!< [19]
        uint32_t TP2 : 1;              //!< [20] Trusted Protect
        uint32_t WP2 : 1;              //!< [21] Write Protect
        uint32_t SP2 : 1;              //!< [22] Supervisor Protect
        uint32_t RESERVED5 : 1;        //!< [23]
        uint32_t TP1 : 1;              //!< [24] Trusted Protect
        uint32_t WP1 : 1;              //!< [25] Write Protect
        uint32_t SP1 : 1;              //!< [26] Supervisor Protect
        uint32_t RESERVED6 : 1;        //!< [27]
        uint32_t TP0 : 1;              //!< [28] Trusted Protect
        uint32_t WP0 : 1;              //!< [29] Write Protect
        uint32_t SP0 : 1;              //!< [30] Supervisor Protect
        uint32_t RESERVED7 : 1;        //!< [31]
    } B;
} hw_aips_pacrm_t;
#endif

/*!
 * @name Constants and macros for entire AIPS_PACRM register
 */
//@{
#define HW_AIPS_PACRM_ADDR(x)    (REGS_AIPS_BASE(x) + 0x60U)

#ifndef __LANGUAGE_ASM__
#define HW_AIPS_PACRM(x)         (*(__IO hw_aips_pacrm_t *) HW_AIPS_PACRM_ADDR(x))
#define HW_AIPS_PACRM_RD(x)      (HW_AIPS_PACRM(x).U)
#define HW_AIPS_PACRM_WR(x, v)   (HW_AIPS_PACRM(x).U = (v))
#define HW_AIPS_PACRM_SET(x, v)  (HW_AIPS_PACRM_WR(x, HW_AIPS_PACRM_RD(x) |  (v)))
#define HW_AIPS_PACRM_CLR(x, v)  (HW_AIPS_PACRM_WR(x, HW_AIPS_PACRM_RD(x) & ~(v)))
#define HW_AIPS_PACRM_TOG(x, v)  (HW_AIPS_PACRM_WR(x, HW_AIPS_PACRM_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AIPS_PACRM bitfields
 */

/*!
 * @name Register AIPS_PACRM, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRM_TP7    (0U)          //!< Bit position for AIPS_PACRM_TP7.
#define BM_AIPS_PACRM_TP7    (0x00000001U) //!< Bit mask for AIPS_PACRM_TP7.
#define BS_AIPS_PACRM_TP7    (1U)          //!< Bit field size in bits for AIPS_PACRM_TP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_TP7 field.
#define BR_AIPS_PACRM_TP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_TP7))
#endif

//! @brief Format value for bitfield AIPS_PACRM_TP7.
#define BF_AIPS_PACRM_TP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_TP7), uint32_t) & BM_AIPS_PACRM_TP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP7 field to a new value.
#define BW_AIPS_PACRM_TP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_TP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRM_WP7    (1U)          //!< Bit position for AIPS_PACRM_WP7.
#define BM_AIPS_PACRM_WP7    (0x00000002U) //!< Bit mask for AIPS_PACRM_WP7.
#define BS_AIPS_PACRM_WP7    (1U)          //!< Bit field size in bits for AIPS_PACRM_WP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_WP7 field.
#define BR_AIPS_PACRM_WP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_WP7))
#endif

//! @brief Format value for bitfield AIPS_PACRM_WP7.
#define BF_AIPS_PACRM_WP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_WP7), uint32_t) & BM_AIPS_PACRM_WP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP7 field to a new value.
#define BW_AIPS_PACRM_WP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_WP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRM_SP7    (2U)          //!< Bit position for AIPS_PACRM_SP7.
#define BM_AIPS_PACRM_SP7    (0x00000004U) //!< Bit mask for AIPS_PACRM_SP7.
#define BS_AIPS_PACRM_SP7    (1U)          //!< Bit field size in bits for AIPS_PACRM_SP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_SP7 field.
#define BR_AIPS_PACRM_SP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_SP7))
#endif

//! @brief Format value for bitfield AIPS_PACRM_SP7.
#define BF_AIPS_PACRM_SP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_SP7), uint32_t) & BM_AIPS_PACRM_SP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP7 field to a new value.
#define BW_AIPS_PACRM_SP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_SP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRM_TP6    (4U)          //!< Bit position for AIPS_PACRM_TP6.
#define BM_AIPS_PACRM_TP6    (0x00000010U) //!< Bit mask for AIPS_PACRM_TP6.
#define BS_AIPS_PACRM_TP6    (1U)          //!< Bit field size in bits for AIPS_PACRM_TP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_TP6 field.
#define BR_AIPS_PACRM_TP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_TP6))
#endif

//! @brief Format value for bitfield AIPS_PACRM_TP6.
#define BF_AIPS_PACRM_TP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_TP6), uint32_t) & BM_AIPS_PACRM_TP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP6 field to a new value.
#define BW_AIPS_PACRM_TP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_TP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRM_WP6    (5U)          //!< Bit position for AIPS_PACRM_WP6.
#define BM_AIPS_PACRM_WP6    (0x00000020U) //!< Bit mask for AIPS_PACRM_WP6.
#define BS_AIPS_PACRM_WP6    (1U)          //!< Bit field size in bits for AIPS_PACRM_WP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_WP6 field.
#define BR_AIPS_PACRM_WP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_WP6))
#endif

//! @brief Format value for bitfield AIPS_PACRM_WP6.
#define BF_AIPS_PACRM_WP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_WP6), uint32_t) & BM_AIPS_PACRM_WP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP6 field to a new value.
#define BW_AIPS_PACRM_WP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_WP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRM_SP6    (6U)          //!< Bit position for AIPS_PACRM_SP6.
#define BM_AIPS_PACRM_SP6    (0x00000040U) //!< Bit mask for AIPS_PACRM_SP6.
#define BS_AIPS_PACRM_SP6    (1U)          //!< Bit field size in bits for AIPS_PACRM_SP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_SP6 field.
#define BR_AIPS_PACRM_SP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_SP6))
#endif

//! @brief Format value for bitfield AIPS_PACRM_SP6.
#define BF_AIPS_PACRM_SP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_SP6), uint32_t) & BM_AIPS_PACRM_SP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP6 field to a new value.
#define BW_AIPS_PACRM_SP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_SP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRM_TP5    (8U)          //!< Bit position for AIPS_PACRM_TP5.
#define BM_AIPS_PACRM_TP5    (0x00000100U) //!< Bit mask for AIPS_PACRM_TP5.
#define BS_AIPS_PACRM_TP5    (1U)          //!< Bit field size in bits for AIPS_PACRM_TP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_TP5 field.
#define BR_AIPS_PACRM_TP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_TP5))
#endif

//! @brief Format value for bitfield AIPS_PACRM_TP5.
#define BF_AIPS_PACRM_TP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_TP5), uint32_t) & BM_AIPS_PACRM_TP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP5 field to a new value.
#define BW_AIPS_PACRM_TP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_TP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRM_WP5    (9U)          //!< Bit position for AIPS_PACRM_WP5.
#define BM_AIPS_PACRM_WP5    (0x00000200U) //!< Bit mask for AIPS_PACRM_WP5.
#define BS_AIPS_PACRM_WP5    (1U)          //!< Bit field size in bits for AIPS_PACRM_WP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_WP5 field.
#define BR_AIPS_PACRM_WP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_WP5))
#endif

//! @brief Format value for bitfield AIPS_PACRM_WP5.
#define BF_AIPS_PACRM_WP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_WP5), uint32_t) & BM_AIPS_PACRM_WP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP5 field to a new value.
#define BW_AIPS_PACRM_WP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_WP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRM_SP5    (10U)         //!< Bit position for AIPS_PACRM_SP5.
#define BM_AIPS_PACRM_SP5    (0x00000400U) //!< Bit mask for AIPS_PACRM_SP5.
#define BS_AIPS_PACRM_SP5    (1U)          //!< Bit field size in bits for AIPS_PACRM_SP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_SP5 field.
#define BR_AIPS_PACRM_SP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_SP5))
#endif

//! @brief Format value for bitfield AIPS_PACRM_SP5.
#define BF_AIPS_PACRM_SP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_SP5), uint32_t) & BM_AIPS_PACRM_SP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP5 field to a new value.
#define BW_AIPS_PACRM_SP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_SP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRM_TP4    (12U)         //!< Bit position for AIPS_PACRM_TP4.
#define BM_AIPS_PACRM_TP4    (0x00001000U) //!< Bit mask for AIPS_PACRM_TP4.
#define BS_AIPS_PACRM_TP4    (1U)          //!< Bit field size in bits for AIPS_PACRM_TP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_TP4 field.
#define BR_AIPS_PACRM_TP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_TP4))
#endif

//! @brief Format value for bitfield AIPS_PACRM_TP4.
#define BF_AIPS_PACRM_TP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_TP4), uint32_t) & BM_AIPS_PACRM_TP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP4 field to a new value.
#define BW_AIPS_PACRM_TP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_TP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRM_WP4    (13U)         //!< Bit position for AIPS_PACRM_WP4.
#define BM_AIPS_PACRM_WP4    (0x00002000U) //!< Bit mask for AIPS_PACRM_WP4.
#define BS_AIPS_PACRM_WP4    (1U)          //!< Bit field size in bits for AIPS_PACRM_WP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_WP4 field.
#define BR_AIPS_PACRM_WP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_WP4))
#endif

//! @brief Format value for bitfield AIPS_PACRM_WP4.
#define BF_AIPS_PACRM_WP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_WP4), uint32_t) & BM_AIPS_PACRM_WP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP4 field to a new value.
#define BW_AIPS_PACRM_WP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_WP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRM_SP4    (14U)         //!< Bit position for AIPS_PACRM_SP4.
#define BM_AIPS_PACRM_SP4    (0x00004000U) //!< Bit mask for AIPS_PACRM_SP4.
#define BS_AIPS_PACRM_SP4    (1U)          //!< Bit field size in bits for AIPS_PACRM_SP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_SP4 field.
#define BR_AIPS_PACRM_SP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_SP4))
#endif

//! @brief Format value for bitfield AIPS_PACRM_SP4.
#define BF_AIPS_PACRM_SP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_SP4), uint32_t) & BM_AIPS_PACRM_SP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP4 field to a new value.
#define BW_AIPS_PACRM_SP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_SP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRM_TP3    (16U)         //!< Bit position for AIPS_PACRM_TP3.
#define BM_AIPS_PACRM_TP3    (0x00010000U) //!< Bit mask for AIPS_PACRM_TP3.
#define BS_AIPS_PACRM_TP3    (1U)          //!< Bit field size in bits for AIPS_PACRM_TP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_TP3 field.
#define BR_AIPS_PACRM_TP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_TP3))
#endif

//! @brief Format value for bitfield AIPS_PACRM_TP3.
#define BF_AIPS_PACRM_TP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_TP3), uint32_t) & BM_AIPS_PACRM_TP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP3 field to a new value.
#define BW_AIPS_PACRM_TP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_TP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRM_WP3    (17U)         //!< Bit position for AIPS_PACRM_WP3.
#define BM_AIPS_PACRM_WP3    (0x00020000U) //!< Bit mask for AIPS_PACRM_WP3.
#define BS_AIPS_PACRM_WP3    (1U)          //!< Bit field size in bits for AIPS_PACRM_WP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_WP3 field.
#define BR_AIPS_PACRM_WP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_WP3))
#endif

//! @brief Format value for bitfield AIPS_PACRM_WP3.
#define BF_AIPS_PACRM_WP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_WP3), uint32_t) & BM_AIPS_PACRM_WP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP3 field to a new value.
#define BW_AIPS_PACRM_WP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_WP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRM_SP3    (18U)         //!< Bit position for AIPS_PACRM_SP3.
#define BM_AIPS_PACRM_SP3    (0x00040000U) //!< Bit mask for AIPS_PACRM_SP3.
#define BS_AIPS_PACRM_SP3    (1U)          //!< Bit field size in bits for AIPS_PACRM_SP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_SP3 field.
#define BR_AIPS_PACRM_SP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_SP3))
#endif

//! @brief Format value for bitfield AIPS_PACRM_SP3.
#define BF_AIPS_PACRM_SP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_SP3), uint32_t) & BM_AIPS_PACRM_SP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP3 field to a new value.
#define BW_AIPS_PACRM_SP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_SP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRM_TP2    (20U)         //!< Bit position for AIPS_PACRM_TP2.
#define BM_AIPS_PACRM_TP2    (0x00100000U) //!< Bit mask for AIPS_PACRM_TP2.
#define BS_AIPS_PACRM_TP2    (1U)          //!< Bit field size in bits for AIPS_PACRM_TP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_TP2 field.
#define BR_AIPS_PACRM_TP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_TP2))
#endif

//! @brief Format value for bitfield AIPS_PACRM_TP2.
#define BF_AIPS_PACRM_TP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_TP2), uint32_t) & BM_AIPS_PACRM_TP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP2 field to a new value.
#define BW_AIPS_PACRM_TP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_TP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRM_WP2    (21U)         //!< Bit position for AIPS_PACRM_WP2.
#define BM_AIPS_PACRM_WP2    (0x00200000U) //!< Bit mask for AIPS_PACRM_WP2.
#define BS_AIPS_PACRM_WP2    (1U)          //!< Bit field size in bits for AIPS_PACRM_WP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_WP2 field.
#define BR_AIPS_PACRM_WP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_WP2))
#endif

//! @brief Format value for bitfield AIPS_PACRM_WP2.
#define BF_AIPS_PACRM_WP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_WP2), uint32_t) & BM_AIPS_PACRM_WP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP2 field to a new value.
#define BW_AIPS_PACRM_WP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_WP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRM_SP2    (22U)         //!< Bit position for AIPS_PACRM_SP2.
#define BM_AIPS_PACRM_SP2    (0x00400000U) //!< Bit mask for AIPS_PACRM_SP2.
#define BS_AIPS_PACRM_SP2    (1U)          //!< Bit field size in bits for AIPS_PACRM_SP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_SP2 field.
#define BR_AIPS_PACRM_SP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_SP2))
#endif

//! @brief Format value for bitfield AIPS_PACRM_SP2.
#define BF_AIPS_PACRM_SP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_SP2), uint32_t) & BM_AIPS_PACRM_SP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP2 field to a new value.
#define BW_AIPS_PACRM_SP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_SP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRM_TP1    (24U)         //!< Bit position for AIPS_PACRM_TP1.
#define BM_AIPS_PACRM_TP1    (0x01000000U) //!< Bit mask for AIPS_PACRM_TP1.
#define BS_AIPS_PACRM_TP1    (1U)          //!< Bit field size in bits for AIPS_PACRM_TP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_TP1 field.
#define BR_AIPS_PACRM_TP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_TP1))
#endif

//! @brief Format value for bitfield AIPS_PACRM_TP1.
#define BF_AIPS_PACRM_TP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_TP1), uint32_t) & BM_AIPS_PACRM_TP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP1 field to a new value.
#define BW_AIPS_PACRM_TP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_TP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRM_WP1    (25U)         //!< Bit position for AIPS_PACRM_WP1.
#define BM_AIPS_PACRM_WP1    (0x02000000U) //!< Bit mask for AIPS_PACRM_WP1.
#define BS_AIPS_PACRM_WP1    (1U)          //!< Bit field size in bits for AIPS_PACRM_WP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_WP1 field.
#define BR_AIPS_PACRM_WP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_WP1))
#endif

//! @brief Format value for bitfield AIPS_PACRM_WP1.
#define BF_AIPS_PACRM_WP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_WP1), uint32_t) & BM_AIPS_PACRM_WP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP1 field to a new value.
#define BW_AIPS_PACRM_WP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_WP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRM_SP1    (26U)         //!< Bit position for AIPS_PACRM_SP1.
#define BM_AIPS_PACRM_SP1    (0x04000000U) //!< Bit mask for AIPS_PACRM_SP1.
#define BS_AIPS_PACRM_SP1    (1U)          //!< Bit field size in bits for AIPS_PACRM_SP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_SP1 field.
#define BR_AIPS_PACRM_SP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_SP1))
#endif

//! @brief Format value for bitfield AIPS_PACRM_SP1.
#define BF_AIPS_PACRM_SP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_SP1), uint32_t) & BM_AIPS_PACRM_SP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP1 field to a new value.
#define BW_AIPS_PACRM_SP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_SP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRM_TP0    (28U)         //!< Bit position for AIPS_PACRM_TP0.
#define BM_AIPS_PACRM_TP0    (0x10000000U) //!< Bit mask for AIPS_PACRM_TP0.
#define BS_AIPS_PACRM_TP0    (1U)          //!< Bit field size in bits for AIPS_PACRM_TP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_TP0 field.
#define BR_AIPS_PACRM_TP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_TP0))
#endif

//! @brief Format value for bitfield AIPS_PACRM_TP0.
#define BF_AIPS_PACRM_TP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_TP0), uint32_t) & BM_AIPS_PACRM_TP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP0 field to a new value.
#define BW_AIPS_PACRM_TP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_TP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRM_WP0    (29U)         //!< Bit position for AIPS_PACRM_WP0.
#define BM_AIPS_PACRM_WP0    (0x20000000U) //!< Bit mask for AIPS_PACRM_WP0.
#define BS_AIPS_PACRM_WP0    (1U)          //!< Bit field size in bits for AIPS_PACRM_WP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_WP0 field.
#define BR_AIPS_PACRM_WP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_WP0))
#endif

//! @brief Format value for bitfield AIPS_PACRM_WP0.
#define BF_AIPS_PACRM_WP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_WP0), uint32_t) & BM_AIPS_PACRM_WP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP0 field to a new value.
#define BW_AIPS_PACRM_WP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_WP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRM, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRM_SP0    (30U)         //!< Bit position for AIPS_PACRM_SP0.
#define BM_AIPS_PACRM_SP0    (0x40000000U) //!< Bit mask for AIPS_PACRM_SP0.
#define BS_AIPS_PACRM_SP0    (1U)          //!< Bit field size in bits for AIPS_PACRM_SP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRM_SP0 field.
#define BR_AIPS_PACRM_SP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_SP0))
#endif

//! @brief Format value for bitfield AIPS_PACRM_SP0.
#define BF_AIPS_PACRM_SP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRM_SP0), uint32_t) & BM_AIPS_PACRM_SP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP0 field to a new value.
#define BW_AIPS_PACRM_SP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRM_ADDR(x), BP_AIPS_PACRM_SP0) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AIPS_PACRN - Peripheral Access Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AIPS_PACRN - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
typedef union _hw_aips_pacrn
{
    uint32_t U;
    struct _hw_aips_pacrn_bitfields
    {
        uint32_t TP7 : 1;              //!< [0] Trusted Protect
        uint32_t WP7 : 1;              //!< [1] Write Protect
        uint32_t SP7 : 1;              //!< [2] Supervisor Protect
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t TP6 : 1;              //!< [4] Trusted Protect
        uint32_t WP6 : 1;              //!< [5] Write Protect
        uint32_t SP6 : 1;              //!< [6] Supervisor Protect
        uint32_t RESERVED1 : 1;        //!< [7]
        uint32_t TP5 : 1;              //!< [8] Trusted Protect
        uint32_t WP5 : 1;              //!< [9] Write Protect
        uint32_t SP5 : 1;              //!< [10] Supervisor Protect
        uint32_t RESERVED2 : 1;        //!< [11]
        uint32_t TP4 : 1;              //!< [12] Trusted Protect
        uint32_t WP4 : 1;              //!< [13] Write Protect
        uint32_t SP4 : 1;              //!< [14] Supervisor Protect
        uint32_t RESERVED3 : 1;        //!< [15]
        uint32_t TP3 : 1;              //!< [16] Trusted Protect
        uint32_t WP3 : 1;              //!< [17] Write Protect
        uint32_t SP3 : 1;              //!< [18] Supervisor Protect
        uint32_t RESERVED4 : 1;        //!< [19]
        uint32_t TP2 : 1;              //!< [20] Trusted Protect
        uint32_t WP2 : 1;              //!< [21] Write Protect
        uint32_t SP2 : 1;              //!< [22] Supervisor Protect
        uint32_t RESERVED5 : 1;        //!< [23]
        uint32_t TP1 : 1;              //!< [24] Trusted Protect
        uint32_t WP1 : 1;              //!< [25] Write Protect
        uint32_t SP1 : 1;              //!< [26] Supervisor Protect
        uint32_t RESERVED6 : 1;        //!< [27]
        uint32_t TP0 : 1;              //!< [28] Trusted Protect
        uint32_t WP0 : 1;              //!< [29] Write Protect
        uint32_t SP0 : 1;              //!< [30] Supervisor Protect
        uint32_t RESERVED7 : 1;        //!< [31]
    } B;
} hw_aips_pacrn_t;
#endif

/*!
 * @name Constants and macros for entire AIPS_PACRN register
 */
//@{
#define HW_AIPS_PACRN_ADDR(x)    (REGS_AIPS_BASE(x) + 0x64U)

#ifndef __LANGUAGE_ASM__
#define HW_AIPS_PACRN(x)         (*(__IO hw_aips_pacrn_t *) HW_AIPS_PACRN_ADDR(x))
#define HW_AIPS_PACRN_RD(x)      (HW_AIPS_PACRN(x).U)
#define HW_AIPS_PACRN_WR(x, v)   (HW_AIPS_PACRN(x).U = (v))
#define HW_AIPS_PACRN_SET(x, v)  (HW_AIPS_PACRN_WR(x, HW_AIPS_PACRN_RD(x) |  (v)))
#define HW_AIPS_PACRN_CLR(x, v)  (HW_AIPS_PACRN_WR(x, HW_AIPS_PACRN_RD(x) & ~(v)))
#define HW_AIPS_PACRN_TOG(x, v)  (HW_AIPS_PACRN_WR(x, HW_AIPS_PACRN_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AIPS_PACRN bitfields
 */

/*!
 * @name Register AIPS_PACRN, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRN_TP7    (0U)          //!< Bit position for AIPS_PACRN_TP7.
#define BM_AIPS_PACRN_TP7    (0x00000001U) //!< Bit mask for AIPS_PACRN_TP7.
#define BS_AIPS_PACRN_TP7    (1U)          //!< Bit field size in bits for AIPS_PACRN_TP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_TP7 field.
#define BR_AIPS_PACRN_TP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_TP7))
#endif

//! @brief Format value for bitfield AIPS_PACRN_TP7.
#define BF_AIPS_PACRN_TP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_TP7), uint32_t) & BM_AIPS_PACRN_TP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP7 field to a new value.
#define BW_AIPS_PACRN_TP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_TP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRN_WP7    (1U)          //!< Bit position for AIPS_PACRN_WP7.
#define BM_AIPS_PACRN_WP7    (0x00000002U) //!< Bit mask for AIPS_PACRN_WP7.
#define BS_AIPS_PACRN_WP7    (1U)          //!< Bit field size in bits for AIPS_PACRN_WP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_WP7 field.
#define BR_AIPS_PACRN_WP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_WP7))
#endif

//! @brief Format value for bitfield AIPS_PACRN_WP7.
#define BF_AIPS_PACRN_WP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_WP7), uint32_t) & BM_AIPS_PACRN_WP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP7 field to a new value.
#define BW_AIPS_PACRN_WP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_WP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRN_SP7    (2U)          //!< Bit position for AIPS_PACRN_SP7.
#define BM_AIPS_PACRN_SP7    (0x00000004U) //!< Bit mask for AIPS_PACRN_SP7.
#define BS_AIPS_PACRN_SP7    (1U)          //!< Bit field size in bits for AIPS_PACRN_SP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_SP7 field.
#define BR_AIPS_PACRN_SP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_SP7))
#endif

//! @brief Format value for bitfield AIPS_PACRN_SP7.
#define BF_AIPS_PACRN_SP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_SP7), uint32_t) & BM_AIPS_PACRN_SP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP7 field to a new value.
#define BW_AIPS_PACRN_SP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_SP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRN_TP6    (4U)          //!< Bit position for AIPS_PACRN_TP6.
#define BM_AIPS_PACRN_TP6    (0x00000010U) //!< Bit mask for AIPS_PACRN_TP6.
#define BS_AIPS_PACRN_TP6    (1U)          //!< Bit field size in bits for AIPS_PACRN_TP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_TP6 field.
#define BR_AIPS_PACRN_TP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_TP6))
#endif

//! @brief Format value for bitfield AIPS_PACRN_TP6.
#define BF_AIPS_PACRN_TP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_TP6), uint32_t) & BM_AIPS_PACRN_TP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP6 field to a new value.
#define BW_AIPS_PACRN_TP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_TP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRN_WP6    (5U)          //!< Bit position for AIPS_PACRN_WP6.
#define BM_AIPS_PACRN_WP6    (0x00000020U) //!< Bit mask for AIPS_PACRN_WP6.
#define BS_AIPS_PACRN_WP6    (1U)          //!< Bit field size in bits for AIPS_PACRN_WP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_WP6 field.
#define BR_AIPS_PACRN_WP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_WP6))
#endif

//! @brief Format value for bitfield AIPS_PACRN_WP6.
#define BF_AIPS_PACRN_WP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_WP6), uint32_t) & BM_AIPS_PACRN_WP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP6 field to a new value.
#define BW_AIPS_PACRN_WP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_WP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRN_SP6    (6U)          //!< Bit position for AIPS_PACRN_SP6.
#define BM_AIPS_PACRN_SP6    (0x00000040U) //!< Bit mask for AIPS_PACRN_SP6.
#define BS_AIPS_PACRN_SP6    (1U)          //!< Bit field size in bits for AIPS_PACRN_SP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_SP6 field.
#define BR_AIPS_PACRN_SP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_SP6))
#endif

//! @brief Format value for bitfield AIPS_PACRN_SP6.
#define BF_AIPS_PACRN_SP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_SP6), uint32_t) & BM_AIPS_PACRN_SP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP6 field to a new value.
#define BW_AIPS_PACRN_SP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_SP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRN_TP5    (8U)          //!< Bit position for AIPS_PACRN_TP5.
#define BM_AIPS_PACRN_TP5    (0x00000100U) //!< Bit mask for AIPS_PACRN_TP5.
#define BS_AIPS_PACRN_TP5    (1U)          //!< Bit field size in bits for AIPS_PACRN_TP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_TP5 field.
#define BR_AIPS_PACRN_TP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_TP5))
#endif

//! @brief Format value for bitfield AIPS_PACRN_TP5.
#define BF_AIPS_PACRN_TP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_TP5), uint32_t) & BM_AIPS_PACRN_TP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP5 field to a new value.
#define BW_AIPS_PACRN_TP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_TP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRN_WP5    (9U)          //!< Bit position for AIPS_PACRN_WP5.
#define BM_AIPS_PACRN_WP5    (0x00000200U) //!< Bit mask for AIPS_PACRN_WP5.
#define BS_AIPS_PACRN_WP5    (1U)          //!< Bit field size in bits for AIPS_PACRN_WP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_WP5 field.
#define BR_AIPS_PACRN_WP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_WP5))
#endif

//! @brief Format value for bitfield AIPS_PACRN_WP5.
#define BF_AIPS_PACRN_WP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_WP5), uint32_t) & BM_AIPS_PACRN_WP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP5 field to a new value.
#define BW_AIPS_PACRN_WP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_WP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRN_SP5    (10U)         //!< Bit position for AIPS_PACRN_SP5.
#define BM_AIPS_PACRN_SP5    (0x00000400U) //!< Bit mask for AIPS_PACRN_SP5.
#define BS_AIPS_PACRN_SP5    (1U)          //!< Bit field size in bits for AIPS_PACRN_SP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_SP5 field.
#define BR_AIPS_PACRN_SP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_SP5))
#endif

//! @brief Format value for bitfield AIPS_PACRN_SP5.
#define BF_AIPS_PACRN_SP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_SP5), uint32_t) & BM_AIPS_PACRN_SP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP5 field to a new value.
#define BW_AIPS_PACRN_SP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_SP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRN_TP4    (12U)         //!< Bit position for AIPS_PACRN_TP4.
#define BM_AIPS_PACRN_TP4    (0x00001000U) //!< Bit mask for AIPS_PACRN_TP4.
#define BS_AIPS_PACRN_TP4    (1U)          //!< Bit field size in bits for AIPS_PACRN_TP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_TP4 field.
#define BR_AIPS_PACRN_TP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_TP4))
#endif

//! @brief Format value for bitfield AIPS_PACRN_TP4.
#define BF_AIPS_PACRN_TP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_TP4), uint32_t) & BM_AIPS_PACRN_TP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP4 field to a new value.
#define BW_AIPS_PACRN_TP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_TP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRN_WP4    (13U)         //!< Bit position for AIPS_PACRN_WP4.
#define BM_AIPS_PACRN_WP4    (0x00002000U) //!< Bit mask for AIPS_PACRN_WP4.
#define BS_AIPS_PACRN_WP4    (1U)          //!< Bit field size in bits for AIPS_PACRN_WP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_WP4 field.
#define BR_AIPS_PACRN_WP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_WP4))
#endif

//! @brief Format value for bitfield AIPS_PACRN_WP4.
#define BF_AIPS_PACRN_WP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_WP4), uint32_t) & BM_AIPS_PACRN_WP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP4 field to a new value.
#define BW_AIPS_PACRN_WP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_WP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRN_SP4    (14U)         //!< Bit position for AIPS_PACRN_SP4.
#define BM_AIPS_PACRN_SP4    (0x00004000U) //!< Bit mask for AIPS_PACRN_SP4.
#define BS_AIPS_PACRN_SP4    (1U)          //!< Bit field size in bits for AIPS_PACRN_SP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_SP4 field.
#define BR_AIPS_PACRN_SP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_SP4))
#endif

//! @brief Format value for bitfield AIPS_PACRN_SP4.
#define BF_AIPS_PACRN_SP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_SP4), uint32_t) & BM_AIPS_PACRN_SP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP4 field to a new value.
#define BW_AIPS_PACRN_SP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_SP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRN_TP3    (16U)         //!< Bit position for AIPS_PACRN_TP3.
#define BM_AIPS_PACRN_TP3    (0x00010000U) //!< Bit mask for AIPS_PACRN_TP3.
#define BS_AIPS_PACRN_TP3    (1U)          //!< Bit field size in bits for AIPS_PACRN_TP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_TP3 field.
#define BR_AIPS_PACRN_TP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_TP3))
#endif

//! @brief Format value for bitfield AIPS_PACRN_TP3.
#define BF_AIPS_PACRN_TP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_TP3), uint32_t) & BM_AIPS_PACRN_TP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP3 field to a new value.
#define BW_AIPS_PACRN_TP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_TP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRN_WP3    (17U)         //!< Bit position for AIPS_PACRN_WP3.
#define BM_AIPS_PACRN_WP3    (0x00020000U) //!< Bit mask for AIPS_PACRN_WP3.
#define BS_AIPS_PACRN_WP3    (1U)          //!< Bit field size in bits for AIPS_PACRN_WP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_WP3 field.
#define BR_AIPS_PACRN_WP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_WP3))
#endif

//! @brief Format value for bitfield AIPS_PACRN_WP3.
#define BF_AIPS_PACRN_WP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_WP3), uint32_t) & BM_AIPS_PACRN_WP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP3 field to a new value.
#define BW_AIPS_PACRN_WP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_WP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRN_SP3    (18U)         //!< Bit position for AIPS_PACRN_SP3.
#define BM_AIPS_PACRN_SP3    (0x00040000U) //!< Bit mask for AIPS_PACRN_SP3.
#define BS_AIPS_PACRN_SP3    (1U)          //!< Bit field size in bits for AIPS_PACRN_SP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_SP3 field.
#define BR_AIPS_PACRN_SP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_SP3))
#endif

//! @brief Format value for bitfield AIPS_PACRN_SP3.
#define BF_AIPS_PACRN_SP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_SP3), uint32_t) & BM_AIPS_PACRN_SP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP3 field to a new value.
#define BW_AIPS_PACRN_SP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_SP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRN_TP2    (20U)         //!< Bit position for AIPS_PACRN_TP2.
#define BM_AIPS_PACRN_TP2    (0x00100000U) //!< Bit mask for AIPS_PACRN_TP2.
#define BS_AIPS_PACRN_TP2    (1U)          //!< Bit field size in bits for AIPS_PACRN_TP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_TP2 field.
#define BR_AIPS_PACRN_TP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_TP2))
#endif

//! @brief Format value for bitfield AIPS_PACRN_TP2.
#define BF_AIPS_PACRN_TP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_TP2), uint32_t) & BM_AIPS_PACRN_TP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP2 field to a new value.
#define BW_AIPS_PACRN_TP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_TP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRN_WP2    (21U)         //!< Bit position for AIPS_PACRN_WP2.
#define BM_AIPS_PACRN_WP2    (0x00200000U) //!< Bit mask for AIPS_PACRN_WP2.
#define BS_AIPS_PACRN_WP2    (1U)          //!< Bit field size in bits for AIPS_PACRN_WP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_WP2 field.
#define BR_AIPS_PACRN_WP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_WP2))
#endif

//! @brief Format value for bitfield AIPS_PACRN_WP2.
#define BF_AIPS_PACRN_WP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_WP2), uint32_t) & BM_AIPS_PACRN_WP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP2 field to a new value.
#define BW_AIPS_PACRN_WP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_WP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRN_SP2    (22U)         //!< Bit position for AIPS_PACRN_SP2.
#define BM_AIPS_PACRN_SP2    (0x00400000U) //!< Bit mask for AIPS_PACRN_SP2.
#define BS_AIPS_PACRN_SP2    (1U)          //!< Bit field size in bits for AIPS_PACRN_SP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_SP2 field.
#define BR_AIPS_PACRN_SP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_SP2))
#endif

//! @brief Format value for bitfield AIPS_PACRN_SP2.
#define BF_AIPS_PACRN_SP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_SP2), uint32_t) & BM_AIPS_PACRN_SP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP2 field to a new value.
#define BW_AIPS_PACRN_SP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_SP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRN_TP1    (24U)         //!< Bit position for AIPS_PACRN_TP1.
#define BM_AIPS_PACRN_TP1    (0x01000000U) //!< Bit mask for AIPS_PACRN_TP1.
#define BS_AIPS_PACRN_TP1    (1U)          //!< Bit field size in bits for AIPS_PACRN_TP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_TP1 field.
#define BR_AIPS_PACRN_TP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_TP1))
#endif

//! @brief Format value for bitfield AIPS_PACRN_TP1.
#define BF_AIPS_PACRN_TP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_TP1), uint32_t) & BM_AIPS_PACRN_TP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP1 field to a new value.
#define BW_AIPS_PACRN_TP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_TP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRN_WP1    (25U)         //!< Bit position for AIPS_PACRN_WP1.
#define BM_AIPS_PACRN_WP1    (0x02000000U) //!< Bit mask for AIPS_PACRN_WP1.
#define BS_AIPS_PACRN_WP1    (1U)          //!< Bit field size in bits for AIPS_PACRN_WP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_WP1 field.
#define BR_AIPS_PACRN_WP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_WP1))
#endif

//! @brief Format value for bitfield AIPS_PACRN_WP1.
#define BF_AIPS_PACRN_WP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_WP1), uint32_t) & BM_AIPS_PACRN_WP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP1 field to a new value.
#define BW_AIPS_PACRN_WP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_WP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRN_SP1    (26U)         //!< Bit position for AIPS_PACRN_SP1.
#define BM_AIPS_PACRN_SP1    (0x04000000U) //!< Bit mask for AIPS_PACRN_SP1.
#define BS_AIPS_PACRN_SP1    (1U)          //!< Bit field size in bits for AIPS_PACRN_SP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_SP1 field.
#define BR_AIPS_PACRN_SP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_SP1))
#endif

//! @brief Format value for bitfield AIPS_PACRN_SP1.
#define BF_AIPS_PACRN_SP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_SP1), uint32_t) & BM_AIPS_PACRN_SP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP1 field to a new value.
#define BW_AIPS_PACRN_SP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_SP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRN_TP0    (28U)         //!< Bit position for AIPS_PACRN_TP0.
#define BM_AIPS_PACRN_TP0    (0x10000000U) //!< Bit mask for AIPS_PACRN_TP0.
#define BS_AIPS_PACRN_TP0    (1U)          //!< Bit field size in bits for AIPS_PACRN_TP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_TP0 field.
#define BR_AIPS_PACRN_TP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_TP0))
#endif

//! @brief Format value for bitfield AIPS_PACRN_TP0.
#define BF_AIPS_PACRN_TP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_TP0), uint32_t) & BM_AIPS_PACRN_TP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP0 field to a new value.
#define BW_AIPS_PACRN_TP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_TP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRN_WP0    (29U)         //!< Bit position for AIPS_PACRN_WP0.
#define BM_AIPS_PACRN_WP0    (0x20000000U) //!< Bit mask for AIPS_PACRN_WP0.
#define BS_AIPS_PACRN_WP0    (1U)          //!< Bit field size in bits for AIPS_PACRN_WP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_WP0 field.
#define BR_AIPS_PACRN_WP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_WP0))
#endif

//! @brief Format value for bitfield AIPS_PACRN_WP0.
#define BF_AIPS_PACRN_WP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_WP0), uint32_t) & BM_AIPS_PACRN_WP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP0 field to a new value.
#define BW_AIPS_PACRN_WP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_WP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRN, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRN_SP0    (30U)         //!< Bit position for AIPS_PACRN_SP0.
#define BM_AIPS_PACRN_SP0    (0x40000000U) //!< Bit mask for AIPS_PACRN_SP0.
#define BS_AIPS_PACRN_SP0    (1U)          //!< Bit field size in bits for AIPS_PACRN_SP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRN_SP0 field.
#define BR_AIPS_PACRN_SP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_SP0))
#endif

//! @brief Format value for bitfield AIPS_PACRN_SP0.
#define BF_AIPS_PACRN_SP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRN_SP0), uint32_t) & BM_AIPS_PACRN_SP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP0 field to a new value.
#define BW_AIPS_PACRN_SP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRN_ADDR(x), BP_AIPS_PACRN_SP0) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AIPS_PACRO - Peripheral Access Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AIPS_PACRO - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
typedef union _hw_aips_pacro
{
    uint32_t U;
    struct _hw_aips_pacro_bitfields
    {
        uint32_t TP7 : 1;              //!< [0] Trusted Protect
        uint32_t WP7 : 1;              //!< [1] Write Protect
        uint32_t SP7 : 1;              //!< [2] Supervisor Protect
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t TP6 : 1;              //!< [4] Trusted Protect
        uint32_t WP6 : 1;              //!< [5] Write Protect
        uint32_t SP6 : 1;              //!< [6] Supervisor Protect
        uint32_t RESERVED1 : 1;        //!< [7]
        uint32_t TP5 : 1;              //!< [8] Trusted Protect
        uint32_t WP5 : 1;              //!< [9] Write Protect
        uint32_t SP5 : 1;              //!< [10] Supervisor Protect
        uint32_t RESERVED2 : 1;        //!< [11]
        uint32_t TP4 : 1;              //!< [12] Trusted Protect
        uint32_t WP4 : 1;              //!< [13] Write Protect
        uint32_t SP4 : 1;              //!< [14] Supervisor Protect
        uint32_t RESERVED3 : 1;        //!< [15]
        uint32_t TP3 : 1;              //!< [16] Trusted Protect
        uint32_t WP3 : 1;              //!< [17] Write Protect
        uint32_t SP3 : 1;              //!< [18] Supervisor Protect
        uint32_t RESERVED4 : 1;        //!< [19]
        uint32_t TP2 : 1;              //!< [20] Trusted Protect
        uint32_t WP2 : 1;              //!< [21] Write Protect
        uint32_t SP2 : 1;              //!< [22] Supervisor Protect
        uint32_t RESERVED5 : 1;        //!< [23]
        uint32_t TP1 : 1;              //!< [24] Trusted Protect
        uint32_t WP1 : 1;              //!< [25] Write Protect
        uint32_t SP1 : 1;              //!< [26] Supervisor Protect
        uint32_t RESERVED6 : 1;        //!< [27]
        uint32_t TP0 : 1;              //!< [28] Trusted Protect
        uint32_t WP0 : 1;              //!< [29] Write Protect
        uint32_t SP0 : 1;              //!< [30] Supervisor Protect
        uint32_t RESERVED7 : 1;        //!< [31]
    } B;
} hw_aips_pacro_t;
#endif

/*!
 * @name Constants and macros for entire AIPS_PACRO register
 */
//@{
#define HW_AIPS_PACRO_ADDR(x)    (REGS_AIPS_BASE(x) + 0x68U)

#ifndef __LANGUAGE_ASM__
#define HW_AIPS_PACRO(x)         (*(__IO hw_aips_pacro_t *) HW_AIPS_PACRO_ADDR(x))
#define HW_AIPS_PACRO_RD(x)      (HW_AIPS_PACRO(x).U)
#define HW_AIPS_PACRO_WR(x, v)   (HW_AIPS_PACRO(x).U = (v))
#define HW_AIPS_PACRO_SET(x, v)  (HW_AIPS_PACRO_WR(x, HW_AIPS_PACRO_RD(x) |  (v)))
#define HW_AIPS_PACRO_CLR(x, v)  (HW_AIPS_PACRO_WR(x, HW_AIPS_PACRO_RD(x) & ~(v)))
#define HW_AIPS_PACRO_TOG(x, v)  (HW_AIPS_PACRO_WR(x, HW_AIPS_PACRO_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AIPS_PACRO bitfields
 */

/*!
 * @name Register AIPS_PACRO, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRO_TP7    (0U)          //!< Bit position for AIPS_PACRO_TP7.
#define BM_AIPS_PACRO_TP7    (0x00000001U) //!< Bit mask for AIPS_PACRO_TP7.
#define BS_AIPS_PACRO_TP7    (1U)          //!< Bit field size in bits for AIPS_PACRO_TP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_TP7 field.
#define BR_AIPS_PACRO_TP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_TP7))
#endif

//! @brief Format value for bitfield AIPS_PACRO_TP7.
#define BF_AIPS_PACRO_TP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_TP7), uint32_t) & BM_AIPS_PACRO_TP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP7 field to a new value.
#define BW_AIPS_PACRO_TP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_TP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRO_WP7    (1U)          //!< Bit position for AIPS_PACRO_WP7.
#define BM_AIPS_PACRO_WP7    (0x00000002U) //!< Bit mask for AIPS_PACRO_WP7.
#define BS_AIPS_PACRO_WP7    (1U)          //!< Bit field size in bits for AIPS_PACRO_WP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_WP7 field.
#define BR_AIPS_PACRO_WP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_WP7))
#endif

//! @brief Format value for bitfield AIPS_PACRO_WP7.
#define BF_AIPS_PACRO_WP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_WP7), uint32_t) & BM_AIPS_PACRO_WP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP7 field to a new value.
#define BW_AIPS_PACRO_WP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_WP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRO_SP7    (2U)          //!< Bit position for AIPS_PACRO_SP7.
#define BM_AIPS_PACRO_SP7    (0x00000004U) //!< Bit mask for AIPS_PACRO_SP7.
#define BS_AIPS_PACRO_SP7    (1U)          //!< Bit field size in bits for AIPS_PACRO_SP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_SP7 field.
#define BR_AIPS_PACRO_SP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_SP7))
#endif

//! @brief Format value for bitfield AIPS_PACRO_SP7.
#define BF_AIPS_PACRO_SP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_SP7), uint32_t) & BM_AIPS_PACRO_SP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP7 field to a new value.
#define BW_AIPS_PACRO_SP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_SP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRO_TP6    (4U)          //!< Bit position for AIPS_PACRO_TP6.
#define BM_AIPS_PACRO_TP6    (0x00000010U) //!< Bit mask for AIPS_PACRO_TP6.
#define BS_AIPS_PACRO_TP6    (1U)          //!< Bit field size in bits for AIPS_PACRO_TP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_TP6 field.
#define BR_AIPS_PACRO_TP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_TP6))
#endif

//! @brief Format value for bitfield AIPS_PACRO_TP6.
#define BF_AIPS_PACRO_TP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_TP6), uint32_t) & BM_AIPS_PACRO_TP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP6 field to a new value.
#define BW_AIPS_PACRO_TP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_TP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRO_WP6    (5U)          //!< Bit position for AIPS_PACRO_WP6.
#define BM_AIPS_PACRO_WP6    (0x00000020U) //!< Bit mask for AIPS_PACRO_WP6.
#define BS_AIPS_PACRO_WP6    (1U)          //!< Bit field size in bits for AIPS_PACRO_WP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_WP6 field.
#define BR_AIPS_PACRO_WP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_WP6))
#endif

//! @brief Format value for bitfield AIPS_PACRO_WP6.
#define BF_AIPS_PACRO_WP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_WP6), uint32_t) & BM_AIPS_PACRO_WP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP6 field to a new value.
#define BW_AIPS_PACRO_WP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_WP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRO_SP6    (6U)          //!< Bit position for AIPS_PACRO_SP6.
#define BM_AIPS_PACRO_SP6    (0x00000040U) //!< Bit mask for AIPS_PACRO_SP6.
#define BS_AIPS_PACRO_SP6    (1U)          //!< Bit field size in bits for AIPS_PACRO_SP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_SP6 field.
#define BR_AIPS_PACRO_SP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_SP6))
#endif

//! @brief Format value for bitfield AIPS_PACRO_SP6.
#define BF_AIPS_PACRO_SP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_SP6), uint32_t) & BM_AIPS_PACRO_SP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP6 field to a new value.
#define BW_AIPS_PACRO_SP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_SP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRO_TP5    (8U)          //!< Bit position for AIPS_PACRO_TP5.
#define BM_AIPS_PACRO_TP5    (0x00000100U) //!< Bit mask for AIPS_PACRO_TP5.
#define BS_AIPS_PACRO_TP5    (1U)          //!< Bit field size in bits for AIPS_PACRO_TP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_TP5 field.
#define BR_AIPS_PACRO_TP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_TP5))
#endif

//! @brief Format value for bitfield AIPS_PACRO_TP5.
#define BF_AIPS_PACRO_TP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_TP5), uint32_t) & BM_AIPS_PACRO_TP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP5 field to a new value.
#define BW_AIPS_PACRO_TP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_TP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRO_WP5    (9U)          //!< Bit position for AIPS_PACRO_WP5.
#define BM_AIPS_PACRO_WP5    (0x00000200U) //!< Bit mask for AIPS_PACRO_WP5.
#define BS_AIPS_PACRO_WP5    (1U)          //!< Bit field size in bits for AIPS_PACRO_WP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_WP5 field.
#define BR_AIPS_PACRO_WP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_WP5))
#endif

//! @brief Format value for bitfield AIPS_PACRO_WP5.
#define BF_AIPS_PACRO_WP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_WP5), uint32_t) & BM_AIPS_PACRO_WP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP5 field to a new value.
#define BW_AIPS_PACRO_WP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_WP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRO_SP5    (10U)         //!< Bit position for AIPS_PACRO_SP5.
#define BM_AIPS_PACRO_SP5    (0x00000400U) //!< Bit mask for AIPS_PACRO_SP5.
#define BS_AIPS_PACRO_SP5    (1U)          //!< Bit field size in bits for AIPS_PACRO_SP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_SP5 field.
#define BR_AIPS_PACRO_SP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_SP5))
#endif

//! @brief Format value for bitfield AIPS_PACRO_SP5.
#define BF_AIPS_PACRO_SP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_SP5), uint32_t) & BM_AIPS_PACRO_SP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP5 field to a new value.
#define BW_AIPS_PACRO_SP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_SP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRO_TP4    (12U)         //!< Bit position for AIPS_PACRO_TP4.
#define BM_AIPS_PACRO_TP4    (0x00001000U) //!< Bit mask for AIPS_PACRO_TP4.
#define BS_AIPS_PACRO_TP4    (1U)          //!< Bit field size in bits for AIPS_PACRO_TP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_TP4 field.
#define BR_AIPS_PACRO_TP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_TP4))
#endif

//! @brief Format value for bitfield AIPS_PACRO_TP4.
#define BF_AIPS_PACRO_TP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_TP4), uint32_t) & BM_AIPS_PACRO_TP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP4 field to a new value.
#define BW_AIPS_PACRO_TP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_TP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRO_WP4    (13U)         //!< Bit position for AIPS_PACRO_WP4.
#define BM_AIPS_PACRO_WP4    (0x00002000U) //!< Bit mask for AIPS_PACRO_WP4.
#define BS_AIPS_PACRO_WP4    (1U)          //!< Bit field size in bits for AIPS_PACRO_WP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_WP4 field.
#define BR_AIPS_PACRO_WP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_WP4))
#endif

//! @brief Format value for bitfield AIPS_PACRO_WP4.
#define BF_AIPS_PACRO_WP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_WP4), uint32_t) & BM_AIPS_PACRO_WP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP4 field to a new value.
#define BW_AIPS_PACRO_WP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_WP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRO_SP4    (14U)         //!< Bit position for AIPS_PACRO_SP4.
#define BM_AIPS_PACRO_SP4    (0x00004000U) //!< Bit mask for AIPS_PACRO_SP4.
#define BS_AIPS_PACRO_SP4    (1U)          //!< Bit field size in bits for AIPS_PACRO_SP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_SP4 field.
#define BR_AIPS_PACRO_SP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_SP4))
#endif

//! @brief Format value for bitfield AIPS_PACRO_SP4.
#define BF_AIPS_PACRO_SP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_SP4), uint32_t) & BM_AIPS_PACRO_SP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP4 field to a new value.
#define BW_AIPS_PACRO_SP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_SP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRO_TP3    (16U)         //!< Bit position for AIPS_PACRO_TP3.
#define BM_AIPS_PACRO_TP3    (0x00010000U) //!< Bit mask for AIPS_PACRO_TP3.
#define BS_AIPS_PACRO_TP3    (1U)          //!< Bit field size in bits for AIPS_PACRO_TP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_TP3 field.
#define BR_AIPS_PACRO_TP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_TP3))
#endif

//! @brief Format value for bitfield AIPS_PACRO_TP3.
#define BF_AIPS_PACRO_TP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_TP3), uint32_t) & BM_AIPS_PACRO_TP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP3 field to a new value.
#define BW_AIPS_PACRO_TP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_TP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRO_WP3    (17U)         //!< Bit position for AIPS_PACRO_WP3.
#define BM_AIPS_PACRO_WP3    (0x00020000U) //!< Bit mask for AIPS_PACRO_WP3.
#define BS_AIPS_PACRO_WP3    (1U)          //!< Bit field size in bits for AIPS_PACRO_WP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_WP3 field.
#define BR_AIPS_PACRO_WP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_WP3))
#endif

//! @brief Format value for bitfield AIPS_PACRO_WP3.
#define BF_AIPS_PACRO_WP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_WP3), uint32_t) & BM_AIPS_PACRO_WP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP3 field to a new value.
#define BW_AIPS_PACRO_WP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_WP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRO_SP3    (18U)         //!< Bit position for AIPS_PACRO_SP3.
#define BM_AIPS_PACRO_SP3    (0x00040000U) //!< Bit mask for AIPS_PACRO_SP3.
#define BS_AIPS_PACRO_SP3    (1U)          //!< Bit field size in bits for AIPS_PACRO_SP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_SP3 field.
#define BR_AIPS_PACRO_SP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_SP3))
#endif

//! @brief Format value for bitfield AIPS_PACRO_SP3.
#define BF_AIPS_PACRO_SP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_SP3), uint32_t) & BM_AIPS_PACRO_SP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP3 field to a new value.
#define BW_AIPS_PACRO_SP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_SP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRO_TP2    (20U)         //!< Bit position for AIPS_PACRO_TP2.
#define BM_AIPS_PACRO_TP2    (0x00100000U) //!< Bit mask for AIPS_PACRO_TP2.
#define BS_AIPS_PACRO_TP2    (1U)          //!< Bit field size in bits for AIPS_PACRO_TP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_TP2 field.
#define BR_AIPS_PACRO_TP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_TP2))
#endif

//! @brief Format value for bitfield AIPS_PACRO_TP2.
#define BF_AIPS_PACRO_TP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_TP2), uint32_t) & BM_AIPS_PACRO_TP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP2 field to a new value.
#define BW_AIPS_PACRO_TP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_TP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRO_WP2    (21U)         //!< Bit position for AIPS_PACRO_WP2.
#define BM_AIPS_PACRO_WP2    (0x00200000U) //!< Bit mask for AIPS_PACRO_WP2.
#define BS_AIPS_PACRO_WP2    (1U)          //!< Bit field size in bits for AIPS_PACRO_WP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_WP2 field.
#define BR_AIPS_PACRO_WP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_WP2))
#endif

//! @brief Format value for bitfield AIPS_PACRO_WP2.
#define BF_AIPS_PACRO_WP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_WP2), uint32_t) & BM_AIPS_PACRO_WP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP2 field to a new value.
#define BW_AIPS_PACRO_WP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_WP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRO_SP2    (22U)         //!< Bit position for AIPS_PACRO_SP2.
#define BM_AIPS_PACRO_SP2    (0x00400000U) //!< Bit mask for AIPS_PACRO_SP2.
#define BS_AIPS_PACRO_SP2    (1U)          //!< Bit field size in bits for AIPS_PACRO_SP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_SP2 field.
#define BR_AIPS_PACRO_SP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_SP2))
#endif

//! @brief Format value for bitfield AIPS_PACRO_SP2.
#define BF_AIPS_PACRO_SP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_SP2), uint32_t) & BM_AIPS_PACRO_SP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP2 field to a new value.
#define BW_AIPS_PACRO_SP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_SP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRO_TP1    (24U)         //!< Bit position for AIPS_PACRO_TP1.
#define BM_AIPS_PACRO_TP1    (0x01000000U) //!< Bit mask for AIPS_PACRO_TP1.
#define BS_AIPS_PACRO_TP1    (1U)          //!< Bit field size in bits for AIPS_PACRO_TP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_TP1 field.
#define BR_AIPS_PACRO_TP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_TP1))
#endif

//! @brief Format value for bitfield AIPS_PACRO_TP1.
#define BF_AIPS_PACRO_TP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_TP1), uint32_t) & BM_AIPS_PACRO_TP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP1 field to a new value.
#define BW_AIPS_PACRO_TP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_TP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRO_WP1    (25U)         //!< Bit position for AIPS_PACRO_WP1.
#define BM_AIPS_PACRO_WP1    (0x02000000U) //!< Bit mask for AIPS_PACRO_WP1.
#define BS_AIPS_PACRO_WP1    (1U)          //!< Bit field size in bits for AIPS_PACRO_WP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_WP1 field.
#define BR_AIPS_PACRO_WP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_WP1))
#endif

//! @brief Format value for bitfield AIPS_PACRO_WP1.
#define BF_AIPS_PACRO_WP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_WP1), uint32_t) & BM_AIPS_PACRO_WP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP1 field to a new value.
#define BW_AIPS_PACRO_WP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_WP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRO_SP1    (26U)         //!< Bit position for AIPS_PACRO_SP1.
#define BM_AIPS_PACRO_SP1    (0x04000000U) //!< Bit mask for AIPS_PACRO_SP1.
#define BS_AIPS_PACRO_SP1    (1U)          //!< Bit field size in bits for AIPS_PACRO_SP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_SP1 field.
#define BR_AIPS_PACRO_SP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_SP1))
#endif

//! @brief Format value for bitfield AIPS_PACRO_SP1.
#define BF_AIPS_PACRO_SP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_SP1), uint32_t) & BM_AIPS_PACRO_SP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP1 field to a new value.
#define BW_AIPS_PACRO_SP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_SP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRO_TP0    (28U)         //!< Bit position for AIPS_PACRO_TP0.
#define BM_AIPS_PACRO_TP0    (0x10000000U) //!< Bit mask for AIPS_PACRO_TP0.
#define BS_AIPS_PACRO_TP0    (1U)          //!< Bit field size in bits for AIPS_PACRO_TP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_TP0 field.
#define BR_AIPS_PACRO_TP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_TP0))
#endif

//! @brief Format value for bitfield AIPS_PACRO_TP0.
#define BF_AIPS_PACRO_TP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_TP0), uint32_t) & BM_AIPS_PACRO_TP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP0 field to a new value.
#define BW_AIPS_PACRO_TP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_TP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRO_WP0    (29U)         //!< Bit position for AIPS_PACRO_WP0.
#define BM_AIPS_PACRO_WP0    (0x20000000U) //!< Bit mask for AIPS_PACRO_WP0.
#define BS_AIPS_PACRO_WP0    (1U)          //!< Bit field size in bits for AIPS_PACRO_WP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_WP0 field.
#define BR_AIPS_PACRO_WP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_WP0))
#endif

//! @brief Format value for bitfield AIPS_PACRO_WP0.
#define BF_AIPS_PACRO_WP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_WP0), uint32_t) & BM_AIPS_PACRO_WP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP0 field to a new value.
#define BW_AIPS_PACRO_WP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_WP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRO, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRO_SP0    (30U)         //!< Bit position for AIPS_PACRO_SP0.
#define BM_AIPS_PACRO_SP0    (0x40000000U) //!< Bit mask for AIPS_PACRO_SP0.
#define BS_AIPS_PACRO_SP0    (1U)          //!< Bit field size in bits for AIPS_PACRO_SP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRO_SP0 field.
#define BR_AIPS_PACRO_SP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_SP0))
#endif

//! @brief Format value for bitfield AIPS_PACRO_SP0.
#define BF_AIPS_PACRO_SP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRO_SP0), uint32_t) & BM_AIPS_PACRO_SP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP0 field to a new value.
#define BW_AIPS_PACRO_SP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRO_ADDR(x), BP_AIPS_PACRO_SP0) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AIPS_PACRP - Peripheral Access Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AIPS_PACRP - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
typedef union _hw_aips_pacrp
{
    uint32_t U;
    struct _hw_aips_pacrp_bitfields
    {
        uint32_t TP7 : 1;              //!< [0] Trusted Protect
        uint32_t WP7 : 1;              //!< [1] Write Protect
        uint32_t SP7 : 1;              //!< [2] Supervisor Protect
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t TP6 : 1;              //!< [4] Trusted Protect
        uint32_t WP6 : 1;              //!< [5] Write Protect
        uint32_t SP6 : 1;              //!< [6] Supervisor Protect
        uint32_t RESERVED1 : 1;        //!< [7]
        uint32_t TP5 : 1;              //!< [8] Trusted Protect
        uint32_t WP5 : 1;              //!< [9] Write Protect
        uint32_t SP5 : 1;              //!< [10] Supervisor Protect
        uint32_t RESERVED2 : 1;        //!< [11]
        uint32_t TP4 : 1;              //!< [12] Trusted Protect
        uint32_t WP4 : 1;              //!< [13] Write Protect
        uint32_t SP4 : 1;              //!< [14] Supervisor Protect
        uint32_t RESERVED3 : 1;        //!< [15]
        uint32_t TP3 : 1;              //!< [16] Trusted Protect
        uint32_t WP3 : 1;              //!< [17] Write Protect
        uint32_t SP3 : 1;              //!< [18] Supervisor Protect
        uint32_t RESERVED4 : 1;        //!< [19]
        uint32_t TP2 : 1;              //!< [20] Trusted Protect
        uint32_t WP2 : 1;              //!< [21] Write Protect
        uint32_t SP2 : 1;              //!< [22] Supervisor Protect
        uint32_t RESERVED5 : 1;        //!< [23]
        uint32_t TP1 : 1;              //!< [24] Trusted Protect
        uint32_t WP1 : 1;              //!< [25] Write Protect
        uint32_t SP1 : 1;              //!< [26] Supervisor Protect
        uint32_t RESERVED6 : 1;        //!< [27]
        uint32_t TP0 : 1;              //!< [28] Trusted Protect
        uint32_t WP0 : 1;              //!< [29] Write Protect
        uint32_t SP0 : 1;              //!< [30] Supervisor Protect
        uint32_t RESERVED7 : 1;        //!< [31]
    } B;
} hw_aips_pacrp_t;
#endif

/*!
 * @name Constants and macros for entire AIPS_PACRP register
 */
//@{
#define HW_AIPS_PACRP_ADDR(x)    (REGS_AIPS_BASE(x) + 0x6CU)

#ifndef __LANGUAGE_ASM__
#define HW_AIPS_PACRP(x)         (*(__IO hw_aips_pacrp_t *) HW_AIPS_PACRP_ADDR(x))
#define HW_AIPS_PACRP_RD(x)      (HW_AIPS_PACRP(x).U)
#define HW_AIPS_PACRP_WR(x, v)   (HW_AIPS_PACRP(x).U = (v))
#define HW_AIPS_PACRP_SET(x, v)  (HW_AIPS_PACRP_WR(x, HW_AIPS_PACRP_RD(x) |  (v)))
#define HW_AIPS_PACRP_CLR(x, v)  (HW_AIPS_PACRP_WR(x, HW_AIPS_PACRP_RD(x) & ~(v)))
#define HW_AIPS_PACRP_TOG(x, v)  (HW_AIPS_PACRP_WR(x, HW_AIPS_PACRP_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AIPS_PACRP bitfields
 */

/*!
 * @name Register AIPS_PACRP, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRP_TP7    (0U)          //!< Bit position for AIPS_PACRP_TP7.
#define BM_AIPS_PACRP_TP7    (0x00000001U) //!< Bit mask for AIPS_PACRP_TP7.
#define BS_AIPS_PACRP_TP7    (1U)          //!< Bit field size in bits for AIPS_PACRP_TP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_TP7 field.
#define BR_AIPS_PACRP_TP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_TP7))
#endif

//! @brief Format value for bitfield AIPS_PACRP_TP7.
#define BF_AIPS_PACRP_TP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_TP7), uint32_t) & BM_AIPS_PACRP_TP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP7 field to a new value.
#define BW_AIPS_PACRP_TP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_TP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRP_WP7    (1U)          //!< Bit position for AIPS_PACRP_WP7.
#define BM_AIPS_PACRP_WP7    (0x00000002U) //!< Bit mask for AIPS_PACRP_WP7.
#define BS_AIPS_PACRP_WP7    (1U)          //!< Bit field size in bits for AIPS_PACRP_WP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_WP7 field.
#define BR_AIPS_PACRP_WP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_WP7))
#endif

//! @brief Format value for bitfield AIPS_PACRP_WP7.
#define BF_AIPS_PACRP_WP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_WP7), uint32_t) & BM_AIPS_PACRP_WP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP7 field to a new value.
#define BW_AIPS_PACRP_WP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_WP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRP_SP7    (2U)          //!< Bit position for AIPS_PACRP_SP7.
#define BM_AIPS_PACRP_SP7    (0x00000004U) //!< Bit mask for AIPS_PACRP_SP7.
#define BS_AIPS_PACRP_SP7    (1U)          //!< Bit field size in bits for AIPS_PACRP_SP7.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_SP7 field.
#define BR_AIPS_PACRP_SP7(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_SP7))
#endif

//! @brief Format value for bitfield AIPS_PACRP_SP7.
#define BF_AIPS_PACRP_SP7(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_SP7), uint32_t) & BM_AIPS_PACRP_SP7)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP7 field to a new value.
#define BW_AIPS_PACRP_SP7(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_SP7) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRP_TP6    (4U)          //!< Bit position for AIPS_PACRP_TP6.
#define BM_AIPS_PACRP_TP6    (0x00000010U) //!< Bit mask for AIPS_PACRP_TP6.
#define BS_AIPS_PACRP_TP6    (1U)          //!< Bit field size in bits for AIPS_PACRP_TP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_TP6 field.
#define BR_AIPS_PACRP_TP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_TP6))
#endif

//! @brief Format value for bitfield AIPS_PACRP_TP6.
#define BF_AIPS_PACRP_TP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_TP6), uint32_t) & BM_AIPS_PACRP_TP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP6 field to a new value.
#define BW_AIPS_PACRP_TP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_TP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRP_WP6    (5U)          //!< Bit position for AIPS_PACRP_WP6.
#define BM_AIPS_PACRP_WP6    (0x00000020U) //!< Bit mask for AIPS_PACRP_WP6.
#define BS_AIPS_PACRP_WP6    (1U)          //!< Bit field size in bits for AIPS_PACRP_WP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_WP6 field.
#define BR_AIPS_PACRP_WP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_WP6))
#endif

//! @brief Format value for bitfield AIPS_PACRP_WP6.
#define BF_AIPS_PACRP_WP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_WP6), uint32_t) & BM_AIPS_PACRP_WP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP6 field to a new value.
#define BW_AIPS_PACRP_WP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_WP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRP_SP6    (6U)          //!< Bit position for AIPS_PACRP_SP6.
#define BM_AIPS_PACRP_SP6    (0x00000040U) //!< Bit mask for AIPS_PACRP_SP6.
#define BS_AIPS_PACRP_SP6    (1U)          //!< Bit field size in bits for AIPS_PACRP_SP6.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_SP6 field.
#define BR_AIPS_PACRP_SP6(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_SP6))
#endif

//! @brief Format value for bitfield AIPS_PACRP_SP6.
#define BF_AIPS_PACRP_SP6(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_SP6), uint32_t) & BM_AIPS_PACRP_SP6)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP6 field to a new value.
#define BW_AIPS_PACRP_SP6(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_SP6) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRP_TP5    (8U)          //!< Bit position for AIPS_PACRP_TP5.
#define BM_AIPS_PACRP_TP5    (0x00000100U) //!< Bit mask for AIPS_PACRP_TP5.
#define BS_AIPS_PACRP_TP5    (1U)          //!< Bit field size in bits for AIPS_PACRP_TP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_TP5 field.
#define BR_AIPS_PACRP_TP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_TP5))
#endif

//! @brief Format value for bitfield AIPS_PACRP_TP5.
#define BF_AIPS_PACRP_TP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_TP5), uint32_t) & BM_AIPS_PACRP_TP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP5 field to a new value.
#define BW_AIPS_PACRP_TP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_TP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRP_WP5    (9U)          //!< Bit position for AIPS_PACRP_WP5.
#define BM_AIPS_PACRP_WP5    (0x00000200U) //!< Bit mask for AIPS_PACRP_WP5.
#define BS_AIPS_PACRP_WP5    (1U)          //!< Bit field size in bits for AIPS_PACRP_WP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_WP5 field.
#define BR_AIPS_PACRP_WP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_WP5))
#endif

//! @brief Format value for bitfield AIPS_PACRP_WP5.
#define BF_AIPS_PACRP_WP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_WP5), uint32_t) & BM_AIPS_PACRP_WP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP5 field to a new value.
#define BW_AIPS_PACRP_WP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_WP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRP_SP5    (10U)         //!< Bit position for AIPS_PACRP_SP5.
#define BM_AIPS_PACRP_SP5    (0x00000400U) //!< Bit mask for AIPS_PACRP_SP5.
#define BS_AIPS_PACRP_SP5    (1U)          //!< Bit field size in bits for AIPS_PACRP_SP5.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_SP5 field.
#define BR_AIPS_PACRP_SP5(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_SP5))
#endif

//! @brief Format value for bitfield AIPS_PACRP_SP5.
#define BF_AIPS_PACRP_SP5(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_SP5), uint32_t) & BM_AIPS_PACRP_SP5)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP5 field to a new value.
#define BW_AIPS_PACRP_SP5(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_SP5) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRP_TP4    (12U)         //!< Bit position for AIPS_PACRP_TP4.
#define BM_AIPS_PACRP_TP4    (0x00001000U) //!< Bit mask for AIPS_PACRP_TP4.
#define BS_AIPS_PACRP_TP4    (1U)          //!< Bit field size in bits for AIPS_PACRP_TP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_TP4 field.
#define BR_AIPS_PACRP_TP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_TP4))
#endif

//! @brief Format value for bitfield AIPS_PACRP_TP4.
#define BF_AIPS_PACRP_TP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_TP4), uint32_t) & BM_AIPS_PACRP_TP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP4 field to a new value.
#define BW_AIPS_PACRP_TP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_TP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRP_WP4    (13U)         //!< Bit position for AIPS_PACRP_WP4.
#define BM_AIPS_PACRP_WP4    (0x00002000U) //!< Bit mask for AIPS_PACRP_WP4.
#define BS_AIPS_PACRP_WP4    (1U)          //!< Bit field size in bits for AIPS_PACRP_WP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_WP4 field.
#define BR_AIPS_PACRP_WP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_WP4))
#endif

//! @brief Format value for bitfield AIPS_PACRP_WP4.
#define BF_AIPS_PACRP_WP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_WP4), uint32_t) & BM_AIPS_PACRP_WP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP4 field to a new value.
#define BW_AIPS_PACRP_WP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_WP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRP_SP4    (14U)         //!< Bit position for AIPS_PACRP_SP4.
#define BM_AIPS_PACRP_SP4    (0x00004000U) //!< Bit mask for AIPS_PACRP_SP4.
#define BS_AIPS_PACRP_SP4    (1U)          //!< Bit field size in bits for AIPS_PACRP_SP4.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_SP4 field.
#define BR_AIPS_PACRP_SP4(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_SP4))
#endif

//! @brief Format value for bitfield AIPS_PACRP_SP4.
#define BF_AIPS_PACRP_SP4(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_SP4), uint32_t) & BM_AIPS_PACRP_SP4)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP4 field to a new value.
#define BW_AIPS_PACRP_SP4(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_SP4) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRP_TP3    (16U)         //!< Bit position for AIPS_PACRP_TP3.
#define BM_AIPS_PACRP_TP3    (0x00010000U) //!< Bit mask for AIPS_PACRP_TP3.
#define BS_AIPS_PACRP_TP3    (1U)          //!< Bit field size in bits for AIPS_PACRP_TP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_TP3 field.
#define BR_AIPS_PACRP_TP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_TP3))
#endif

//! @brief Format value for bitfield AIPS_PACRP_TP3.
#define BF_AIPS_PACRP_TP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_TP3), uint32_t) & BM_AIPS_PACRP_TP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP3 field to a new value.
#define BW_AIPS_PACRP_TP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_TP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRP_WP3    (17U)         //!< Bit position for AIPS_PACRP_WP3.
#define BM_AIPS_PACRP_WP3    (0x00020000U) //!< Bit mask for AIPS_PACRP_WP3.
#define BS_AIPS_PACRP_WP3    (1U)          //!< Bit field size in bits for AIPS_PACRP_WP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_WP3 field.
#define BR_AIPS_PACRP_WP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_WP3))
#endif

//! @brief Format value for bitfield AIPS_PACRP_WP3.
#define BF_AIPS_PACRP_WP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_WP3), uint32_t) & BM_AIPS_PACRP_WP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP3 field to a new value.
#define BW_AIPS_PACRP_WP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_WP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRP_SP3    (18U)         //!< Bit position for AIPS_PACRP_SP3.
#define BM_AIPS_PACRP_SP3    (0x00040000U) //!< Bit mask for AIPS_PACRP_SP3.
#define BS_AIPS_PACRP_SP3    (1U)          //!< Bit field size in bits for AIPS_PACRP_SP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_SP3 field.
#define BR_AIPS_PACRP_SP3(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_SP3))
#endif

//! @brief Format value for bitfield AIPS_PACRP_SP3.
#define BF_AIPS_PACRP_SP3(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_SP3), uint32_t) & BM_AIPS_PACRP_SP3)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP3 field to a new value.
#define BW_AIPS_PACRP_SP3(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_SP3) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRP_TP2    (20U)         //!< Bit position for AIPS_PACRP_TP2.
#define BM_AIPS_PACRP_TP2    (0x00100000U) //!< Bit mask for AIPS_PACRP_TP2.
#define BS_AIPS_PACRP_TP2    (1U)          //!< Bit field size in bits for AIPS_PACRP_TP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_TP2 field.
#define BR_AIPS_PACRP_TP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_TP2))
#endif

//! @brief Format value for bitfield AIPS_PACRP_TP2.
#define BF_AIPS_PACRP_TP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_TP2), uint32_t) & BM_AIPS_PACRP_TP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP2 field to a new value.
#define BW_AIPS_PACRP_TP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_TP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRP_WP2    (21U)         //!< Bit position for AIPS_PACRP_WP2.
#define BM_AIPS_PACRP_WP2    (0x00200000U) //!< Bit mask for AIPS_PACRP_WP2.
#define BS_AIPS_PACRP_WP2    (1U)          //!< Bit field size in bits for AIPS_PACRP_WP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_WP2 field.
#define BR_AIPS_PACRP_WP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_WP2))
#endif

//! @brief Format value for bitfield AIPS_PACRP_WP2.
#define BF_AIPS_PACRP_WP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_WP2), uint32_t) & BM_AIPS_PACRP_WP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP2 field to a new value.
#define BW_AIPS_PACRP_WP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_WP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRP_SP2    (22U)         //!< Bit position for AIPS_PACRP_SP2.
#define BM_AIPS_PACRP_SP2    (0x00400000U) //!< Bit mask for AIPS_PACRP_SP2.
#define BS_AIPS_PACRP_SP2    (1U)          //!< Bit field size in bits for AIPS_PACRP_SP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_SP2 field.
#define BR_AIPS_PACRP_SP2(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_SP2))
#endif

//! @brief Format value for bitfield AIPS_PACRP_SP2.
#define BF_AIPS_PACRP_SP2(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_SP2), uint32_t) & BM_AIPS_PACRP_SP2)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP2 field to a new value.
#define BW_AIPS_PACRP_SP2(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_SP2) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRP_TP1    (24U)         //!< Bit position for AIPS_PACRP_TP1.
#define BM_AIPS_PACRP_TP1    (0x01000000U) //!< Bit mask for AIPS_PACRP_TP1.
#define BS_AIPS_PACRP_TP1    (1U)          //!< Bit field size in bits for AIPS_PACRP_TP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_TP1 field.
#define BR_AIPS_PACRP_TP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_TP1))
#endif

//! @brief Format value for bitfield AIPS_PACRP_TP1.
#define BF_AIPS_PACRP_TP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_TP1), uint32_t) & BM_AIPS_PACRP_TP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP1 field to a new value.
#define BW_AIPS_PACRP_TP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_TP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRP_WP1    (25U)         //!< Bit position for AIPS_PACRP_WP1.
#define BM_AIPS_PACRP_WP1    (0x02000000U) //!< Bit mask for AIPS_PACRP_WP1.
#define BS_AIPS_PACRP_WP1    (1U)          //!< Bit field size in bits for AIPS_PACRP_WP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_WP1 field.
#define BR_AIPS_PACRP_WP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_WP1))
#endif

//! @brief Format value for bitfield AIPS_PACRP_WP1.
#define BF_AIPS_PACRP_WP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_WP1), uint32_t) & BM_AIPS_PACRP_WP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP1 field to a new value.
#define BW_AIPS_PACRP_WP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_WP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRP_SP1    (26U)         //!< Bit position for AIPS_PACRP_SP1.
#define BM_AIPS_PACRP_SP1    (0x04000000U) //!< Bit mask for AIPS_PACRP_SP1.
#define BS_AIPS_PACRP_SP1    (1U)          //!< Bit field size in bits for AIPS_PACRP_SP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_SP1 field.
#define BR_AIPS_PACRP_SP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_SP1))
#endif

//! @brief Format value for bitfield AIPS_PACRP_SP1.
#define BF_AIPS_PACRP_SP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_SP1), uint32_t) & BM_AIPS_PACRP_SP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP1 field to a new value.
#define BW_AIPS_PACRP_SP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_SP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRP_TP0    (28U)         //!< Bit position for AIPS_PACRP_TP0.
#define BM_AIPS_PACRP_TP0    (0x10000000U) //!< Bit mask for AIPS_PACRP_TP0.
#define BS_AIPS_PACRP_TP0    (1U)          //!< Bit field size in bits for AIPS_PACRP_TP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_TP0 field.
#define BR_AIPS_PACRP_TP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_TP0))
#endif

//! @brief Format value for bitfield AIPS_PACRP_TP0.
#define BF_AIPS_PACRP_TP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_TP0), uint32_t) & BM_AIPS_PACRP_TP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP0 field to a new value.
#define BW_AIPS_PACRP_TP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_TP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRP_WP0    (29U)         //!< Bit position for AIPS_PACRP_WP0.
#define BM_AIPS_PACRP_WP0    (0x20000000U) //!< Bit mask for AIPS_PACRP_WP0.
#define BS_AIPS_PACRP_WP0    (1U)          //!< Bit field size in bits for AIPS_PACRP_WP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_WP0 field.
#define BR_AIPS_PACRP_WP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_WP0))
#endif

//! @brief Format value for bitfield AIPS_PACRP_WP0.
#define BF_AIPS_PACRP_WP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_WP0), uint32_t) & BM_AIPS_PACRP_WP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP0 field to a new value.
#define BW_AIPS_PACRP_WP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_WP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRP, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRP_SP0    (30U)         //!< Bit position for AIPS_PACRP_SP0.
#define BM_AIPS_PACRP_SP0    (0x40000000U) //!< Bit mask for AIPS_PACRP_SP0.
#define BS_AIPS_PACRP_SP0    (1U)          //!< Bit field size in bits for AIPS_PACRP_SP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRP_SP0 field.
#define BR_AIPS_PACRP_SP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_SP0))
#endif

//! @brief Format value for bitfield AIPS_PACRP_SP0.
#define BF_AIPS_PACRP_SP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRP_SP0), uint32_t) & BM_AIPS_PACRP_SP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP0 field to a new value.
#define BW_AIPS_PACRP_SP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRP_ADDR(x), BP_AIPS_PACRP_SP0) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_AIPS_PACRU - Peripheral Access Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_AIPS_PACRU - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44000000U
 *
 * PACRU defines the access levels for the two global spaces.
 */
typedef union _hw_aips_pacru
{
    uint32_t U;
    struct _hw_aips_pacru_bitfields
    {
        uint32_t RESERVED0 : 24;       //!< [23:0]
        uint32_t TP1 : 1;              //!< [24] Trusted Protect
        uint32_t WP1 : 1;              //!< [25] Write Protect
        uint32_t SP1 : 1;              //!< [26] Supervisor Protect
        uint32_t RESERVED1 : 1;        //!< [27]
        uint32_t TP0 : 1;              //!< [28] Trusted Protect
        uint32_t WP0 : 1;              //!< [29] Write Protect
        uint32_t SP0 : 1;              //!< [30] Supervisor Protect
        uint32_t RESERVED2 : 1;        //!< [31]
    } B;
} hw_aips_pacru_t;
#endif

/*!
 * @name Constants and macros for entire AIPS_PACRU register
 */
//@{
#define HW_AIPS_PACRU_ADDR(x)    (REGS_AIPS_BASE(x) + 0x80U)

#ifndef __LANGUAGE_ASM__
#define HW_AIPS_PACRU(x)         (*(__IO hw_aips_pacru_t *) HW_AIPS_PACRU_ADDR(x))
#define HW_AIPS_PACRU_RD(x)      (HW_AIPS_PACRU(x).U)
#define HW_AIPS_PACRU_WR(x, v)   (HW_AIPS_PACRU(x).U = (v))
#define HW_AIPS_PACRU_SET(x, v)  (HW_AIPS_PACRU_WR(x, HW_AIPS_PACRU_RD(x) |  (v)))
#define HW_AIPS_PACRU_CLR(x, v)  (HW_AIPS_PACRU_WR(x, HW_AIPS_PACRU_RD(x) & ~(v)))
#define HW_AIPS_PACRU_TOG(x, v)  (HW_AIPS_PACRU_WR(x, HW_AIPS_PACRU_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual AIPS_PACRU bitfields
 */

/*!
 * @name Register AIPS_PACRU, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRU_TP1    (24U)         //!< Bit position for AIPS_PACRU_TP1.
#define BM_AIPS_PACRU_TP1    (0x01000000U) //!< Bit mask for AIPS_PACRU_TP1.
#define BS_AIPS_PACRU_TP1    (1U)          //!< Bit field size in bits for AIPS_PACRU_TP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRU_TP1 field.
#define BR_AIPS_PACRU_TP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRU_ADDR(x), BP_AIPS_PACRU_TP1))
#endif

//! @brief Format value for bitfield AIPS_PACRU_TP1.
#define BF_AIPS_PACRU_TP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRU_TP1), uint32_t) & BM_AIPS_PACRU_TP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP1 field to a new value.
#define BW_AIPS_PACRU_TP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRU_ADDR(x), BP_AIPS_PACRU_TP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRU, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRU_WP1    (25U)         //!< Bit position for AIPS_PACRU_WP1.
#define BM_AIPS_PACRU_WP1    (0x02000000U) //!< Bit mask for AIPS_PACRU_WP1.
#define BS_AIPS_PACRU_WP1    (1U)          //!< Bit field size in bits for AIPS_PACRU_WP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRU_WP1 field.
#define BR_AIPS_PACRU_WP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRU_ADDR(x), BP_AIPS_PACRU_WP1))
#endif

//! @brief Format value for bitfield AIPS_PACRU_WP1.
#define BF_AIPS_PACRU_WP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRU_WP1), uint32_t) & BM_AIPS_PACRU_WP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP1 field to a new value.
#define BW_AIPS_PACRU_WP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRU_ADDR(x), BP_AIPS_PACRU_WP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRU, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRU_SP1    (26U)         //!< Bit position for AIPS_PACRU_SP1.
#define BM_AIPS_PACRU_SP1    (0x04000000U) //!< Bit mask for AIPS_PACRU_SP1.
#define BS_AIPS_PACRU_SP1    (1U)          //!< Bit field size in bits for AIPS_PACRU_SP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRU_SP1 field.
#define BR_AIPS_PACRU_SP1(x) (BITBAND_ACCESS32(HW_AIPS_PACRU_ADDR(x), BP_AIPS_PACRU_SP1))
#endif

//! @brief Format value for bitfield AIPS_PACRU_SP1.
#define BF_AIPS_PACRU_SP1(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRU_SP1), uint32_t) & BM_AIPS_PACRU_SP1)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP1 field to a new value.
#define BW_AIPS_PACRU_SP1(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRU_ADDR(x), BP_AIPS_PACRU_SP1) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRU, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0 - Accesses from an untrusted master are allowed.
 * - 1 - Accesses from an untrusted master are not allowed.
 */
//@{
#define BP_AIPS_PACRU_TP0    (28U)         //!< Bit position for AIPS_PACRU_TP0.
#define BM_AIPS_PACRU_TP0    (0x10000000U) //!< Bit mask for AIPS_PACRU_TP0.
#define BS_AIPS_PACRU_TP0    (1U)          //!< Bit field size in bits for AIPS_PACRU_TP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRU_TP0 field.
#define BR_AIPS_PACRU_TP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRU_ADDR(x), BP_AIPS_PACRU_TP0))
#endif

//! @brief Format value for bitfield AIPS_PACRU_TP0.
#define BF_AIPS_PACRU_TP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRU_TP0), uint32_t) & BM_AIPS_PACRU_TP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TP0 field to a new value.
#define BW_AIPS_PACRU_TP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRU_ADDR(x), BP_AIPS_PACRU_TP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRU, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0 - This peripheral allows write accesses.
 * - 1 - This peripheral is write protected.
 */
//@{
#define BP_AIPS_PACRU_WP0    (29U)         //!< Bit position for AIPS_PACRU_WP0.
#define BM_AIPS_PACRU_WP0    (0x20000000U) //!< Bit mask for AIPS_PACRU_WP0.
#define BS_AIPS_PACRU_WP0    (1U)          //!< Bit field size in bits for AIPS_PACRU_WP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRU_WP0 field.
#define BR_AIPS_PACRU_WP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRU_ADDR(x), BP_AIPS_PACRU_WP0))
#endif

//! @brief Format value for bitfield AIPS_PACRU_WP0.
#define BF_AIPS_PACRU_WP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRU_WP0), uint32_t) & BM_AIPS_PACRU_WP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WP0 field to a new value.
#define BW_AIPS_PACRU_WP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRU_ADDR(x), BP_AIPS_PACRU_WP0) = (v))
#endif
//@}

/*!
 * @name Register AIPS_PACRU, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 1 - This peripheral requires supervisor privilege level for accesses.
 */
//@{
#define BP_AIPS_PACRU_SP0    (30U)         //!< Bit position for AIPS_PACRU_SP0.
#define BM_AIPS_PACRU_SP0    (0x40000000U) //!< Bit mask for AIPS_PACRU_SP0.
#define BS_AIPS_PACRU_SP0    (1U)          //!< Bit field size in bits for AIPS_PACRU_SP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the AIPS_PACRU_SP0 field.
#define BR_AIPS_PACRU_SP0(x) (BITBAND_ACCESS32(HW_AIPS_PACRU_ADDR(x), BP_AIPS_PACRU_SP0))
#endif

//! @brief Format value for bitfield AIPS_PACRU_SP0.
#define BF_AIPS_PACRU_SP0(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_AIPS_PACRU_SP0), uint32_t) & BM_AIPS_PACRU_SP0)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SP0 field to a new value.
#define BW_AIPS_PACRU_SP0(x, v) (BITBAND_ACCESS32(HW_AIPS_PACRU_ADDR(x), BP_AIPS_PACRU_SP0) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_aips_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All AIPS module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_aips
{
    __IO hw_aips_mpra_t MPRA;              //!< [0x0] Master Privilege Register A
    uint8_t _reserved0[28];
    __IO hw_aips_pacra_t PACRA;            //!< [0x20] Peripheral Access Control Register
    __IO hw_aips_pacrb_t PACRB;            //!< [0x24] Peripheral Access Control Register
    __IO hw_aips_pacrc_t PACRC;            //!< [0x28] Peripheral Access Control Register
    __IO hw_aips_pacrd_t PACRD;            //!< [0x2C] Peripheral Access Control Register
    uint8_t _reserved1[16];
    __IO hw_aips_pacre_t PACRE;            //!< [0x40] Peripheral Access Control Register
    __IO hw_aips_pacrf_t PACRF;            //!< [0x44] Peripheral Access Control Register
    __IO hw_aips_pacrg_t PACRG;            //!< [0x48] Peripheral Access Control Register
    __IO hw_aips_pacrh_t PACRH;            //!< [0x4C] Peripheral Access Control Register
    __IO hw_aips_pacri_t PACRI;            //!< [0x50] Peripheral Access Control Register
    __IO hw_aips_pacrj_t PACRJ;            //!< [0x54] Peripheral Access Control Register
    __IO hw_aips_pacrk_t PACRK;            //!< [0x58] Peripheral Access Control Register
    __IO hw_aips_pacrl_t PACRL;            //!< [0x5C] Peripheral Access Control Register
    __IO hw_aips_pacrm_t PACRM;            //!< [0x60] Peripheral Access Control Register
    __IO hw_aips_pacrn_t PACRN;            //!< [0x64] Peripheral Access Control Register
    __IO hw_aips_pacro_t PACRO;            //!< [0x68] Peripheral Access Control Register
    __IO hw_aips_pacrp_t PACRP;            //!< [0x6C] Peripheral Access Control Register
    uint8_t _reserved2[16];
    __IO hw_aips_pacru_t PACRU;            //!< [0x80] Peripheral Access Control Register
} hw_aips_t;
#pragma pack()

//! @brief Macro to access all AIPS registers.
//! @param x AIPS instance number.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_AIPS(0)</code>.
#define HW_AIPS(x)     (*(hw_aips_t *) REGS_AIPS_BASE(x))
#endif

#endif // __HW_AIPS_REGISTERS_H__
// v22/130726/0.9
// EOF

