/*
 * Copyright (c) 2013 - 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of Freescale Semiconductor, Inc. nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef __FSL_SIM_FEATURES_H__
#define __FSL_SIM_FEATURES_H__

#if (defined(CPU_MKL25Z32VFM4) || defined(CPU_MKL25Z64VFM4) || defined(CPU_MKL25Z128VFM4) || \
     defined(CPU_MKL25Z32VFT4) || defined(CPU_MKL25Z64VFT4) || defined(CPU_MKL25Z128VFT4) || \
     defined(CPU_MKL25Z32VLH4) || defined(CPU_MKL25Z64VLH4) || defined(CPU_MKL25Z128VLH4) || \
     defined(CPU_MKL25Z32VLK4) || defined(CPU_MKL25Z64VLK4) || defined(CPU_MKL25Z128VLK4))
    #define FSL_FEATURE_SIM_USBFS_USE_SPECIAL_DIVIDER (0)
    #define FSL_FEATURE_SIM_PLLCLK_USE_SPECIAL_DIVIDER (1)

    #define FSL_FEATURE_SIM_OPT_HAS_RAMSIZE (0)
    #define FSL_FEATURE_SIM_OPT_HAS_CMTUARTPAD (0)
    #define FSL_FEATURE_SIM_OPT_HAS_PTD7PAD (0)
    #define FSL_FEATURE_SIM_OPT_HAS_FBSL (0)
    #define FSL_FEATURE_SIM_OPT_HAS_PCR (0)
    #define FSL_FEATURE_SIM_OPT_HAS_MCC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_ODE (1)
    #define FSL_FEATURE_SIM_OPT_UART_COUNT (2)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM (0)
    #define FSL_FEATURE_SIM_OPT_FTM_TRIGGER_COUNT (0)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM0_TRIGGER (0)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM3_TRIGGER (0)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM1_CHANNELS (0)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM2_CHANNELS (0)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM3_CHANNELS (0)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM2_CHANNEL1 (0)
    #define FSL_FEATURE_SIM_OPT_FTM0_FAULT_COUNT (0)
    #define FSL_FEATURE_SIM_OPT_HAS_TPM (1)

    #define FSL_FEATURE_SIM_OPT_HAS_NFCSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_ESDHCSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_SDHCSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_LCDCSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_TIMESRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_RMIISRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_USBSRC (1)
    #define FSL_FEATURE_SIM_OPT_HAS_USBFSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_USBHSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_UART0SRC (1)
    #define FSL_FEATURE_SIM_OPT_HAS_TPMSRC (1)
    #define FSL_FEATURE_SIM_OPT_HAS_TRACE_CLKSEL (0)

    #define FSL_FEATURE_SIM_DIVIDER_HAS_OUTDIV2 (0)
    #define FSL_FEATURE_SIM_DIVIDER_HAS_OUTDIV3 (0)
    #define FSL_FEATURE_SIM_DIVIDER_HAS_USBDIV (0)
    #define FSL_FEATURE_SIM_DIVIDER_HAS_USBFSDIV (0)
    #define FSL_FEATURE_SIM_DIVIDER_HAS_USBHSDIV (0)

    #define FSL_FEATURE_SIM_SDID_HAS_FAMILYID (0)
    #define FSL_FEATURE_SIM_SDID_HAS_SUBFAMID (1)
    #define FSL_FEATURE_SIM_SDID_HAS_SERIESID (1)
    #define FSL_FEATURE_SIM_SDID_HAS_DIEID (1)
    #define FSL_FEATURE_SIM_SDID_HAS_SRAMSIZE (1)

    #define FSL_FEATURE_SIM_FCFG_HAS_FLASHDOZE (1)
    #define FSL_FEATURE_SIM_FCFG_HAS_FLASHDIS (1)
    #define FSL_FEATURE_SIM_FCFG_HAS_FTFDIS (0)
    #define FSL_FEATURE_SIM_FCFG_HAS_NVMSIZE (0)
    #define FSL_FEATURE_SIM_FCFG_HAS_EESIZE (0)
    #define FSL_FEATURE_SIM_FCFG_HAS_DEPART (0)
    #define FSL_FEATURE_SIM_FCFG_HAS_MAXADDR0 (1)
    #define FSL_FEATURE_SIM_FCFG_HAS_MAXADDR1 (0)
    #define FSL_FEATURE_SIM_FCFG_HAS_MAXADDR01 (0)
    #define FSL_FEATURE_SIM_FCFG_HAS_MAXADDR23 (0)
    #define FSL_FEATURE_SIM_FCFG_HAS_PFLSH (0)

#elif (defined(CPU_MK70FN1M0VMJ12) || defined(CPU_MK70FX512VMJ12) || \
       defined(CPU_MK70FN1M0VMJ15) || defined(CPU_MK70FX512VMJ15))
    #define FSL_FEATURE_SIM_USBFS_USE_SPECIAL_DIVIDER (0)
    #define FSL_FEATURE_SIM_PLLCLK_USE_SPECIAL_DIVIDER (0)

    #define FSL_FEATURE_SIM_OPT_HAS_RAMSIZE (1)
    #define FSL_FEATURE_SIM_OPT_HAS_CMTUARTPAD (1)
    #define FSL_FEATURE_SIM_OPT_HAS_PTD7PAD (0)
    #define FSL_FEATURE_SIM_OPT_HAS_FBSL (1)
    #define FSL_FEATURE_SIM_OPT_HAS_PCR (1)
    #define FSL_FEATURE_SIM_OPT_HAS_MCC (1)
    #define FSL_FEATURE_SIM_OPT_HAS_ODE (0)
    #define FSL_FEATURE_SIM_OPT_UART_COUNT (2)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM (1)
    #define FSL_FEATURE_SIM_OPT_FTM_TRIGGER_COUNT (2)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM0_TRIGGER (1)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM3_TRIGGER (1)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM1_CHANNELS (1)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM2_CHANNELS (1)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM3_CHANNELS (0)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM2_CHANNEL1 (0)
    #define FSL_FEATURE_SIM_OPT_FTM0_FAULT_COUNT (4)
    #define FSL_FEATURE_SIM_OPT_HAS_TPM (0)

    #define FSL_FEATURE_SIM_OPT_HAS_NFCSRC (1)
    #define FSL_FEATURE_SIM_OPT_HAS_ESDHCSRC (1)
    #define FSL_FEATURE_SIM_OPT_HAS_SDHCSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_LCDCSRC (1)
    #define FSL_FEATURE_SIM_OPT_HAS_TIMESRC (1)
    #define FSL_FEATURE_SIM_OPT_HAS_RMIISRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_USBSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_USBFSRC (1)
    #define FSL_FEATURE_SIM_OPT_HAS_USBHSRC (1)
    #define FSL_FEATURE_SIM_OPT_HAS_UART0SRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_TPMSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_TRACE_CLKSEL (1)

    #define FSL_FEATURE_SIM_DIVIDER_HAS_OUTDIV2 (1)
    #define FSL_FEATURE_SIM_DIVIDER_HAS_OUTDIV3 (1)
    #define FSL_FEATURE_SIM_DIVIDER_HAS_USBDIV (0)
    #define FSL_FEATURE_SIM_DIVIDER_HAS_USBFSDIV (1)
    #define FSL_FEATURE_SIM_DIVIDER_HAS_USBHSDIV (1)

    #define FSL_FEATURE_SIM_SDID_HAS_FAMILYID (0)
    #define FSL_FEATURE_SIM_SDID_HAS_SUBFAMID (0)
    #define FSL_FEATURE_SIM_SDID_HAS_SERIESID (0)
    #define FSL_FEATURE_SIM_SDID_HAS_DIEID (0)
    #define FSL_FEATURE_SIM_SDID_HAS_SRAMSIZE (0)

    #define FSL_FEATURE_SIM_FCFG_HAS_FLASHDOZE (0)
    #define FSL_FEATURE_SIM_FCFG_HAS_FLASHDIS (0)
    #define FSL_FEATURE_SIM_FCFG_HAS_FTFDIS (1)
    #define FSL_FEATURE_SIM_FCFG_HAS_NVMSIZE (1)
    #define FSL_FEATURE_SIM_FCFG_HAS_EESIZE (1)
    #define FSL_FEATURE_SIM_FCFG_HAS_DEPART (1)
    #define FSL_FEATURE_SIM_FCFG_HAS_MAXADDR0 (0)
    #define FSL_FEATURE_SIM_FCFG_HAS_MAXADDR1 (0)
    #define FSL_FEATURE_SIM_FCFG_HAS_MAXADDR01 (1)
    #define FSL_FEATURE_SIM_FCFG_HAS_MAXADDR23 (1)
    #define FSL_FEATURE_SIM_FCFG_HAS_PFLSH (0)

#elif  (defined(CPU_MK64FN1M0VMD12))
    #define FSL_FEATURE_SIM_USBFS_USE_SPECIAL_DIVIDER (1)
    #define FSL_FEATURE_SIM_PLLCLK_USE_SPECIAL_DIVIDER (0)

    #define FSL_FEATURE_SIM_OPT_HAS_RAMSIZE (1)
    #define FSL_FEATURE_SIM_OPT_HAS_CMTUARTPAD (0)
    #define FSL_FEATURE_SIM_OPT_HAS_PTD7PAD (1)
    #define FSL_FEATURE_SIM_OPT_HAS_FBSL (1)
    #define FSL_FEATURE_SIM_OPT_HAS_PCR (0)
    #define FSL_FEATURE_SIM_OPT_HAS_MCC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_ODE (0)
    #define FSL_FEATURE_SIM_OPT_UART_COUNT (2)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM (1)
    #define FSL_FEATURE_SIM_OPT_FTM_TRIGGER_COUNT (2)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM0_TRIGGER (1)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM3_TRIGGER (1)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM1_CHANNELS (1)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM2_CHANNELS (1)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM3_CHANNELS (0)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM2_CHANNEL1 (0)
    #define FSL_FEATURE_SIM_OPT_FTM0_FAULT_COUNT (3)
    #define FSL_FEATURE_SIM_OPT_HAS_TPM (0)

    #define FSL_FEATURE_SIM_OPT_HAS_NFCSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_ESDHCSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_SDHCSRC (1)
    #define FSL_FEATURE_SIM_OPT_HAS_LCDCSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_TIMESRC (1)
    #define FSL_FEATURE_SIM_OPT_HAS_RMIISRC (1)
    #define FSL_FEATURE_SIM_OPT_HAS_USBSRC (1)
    #define FSL_FEATURE_SIM_OPT_HAS_USBFSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_USBHSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_UART0SRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_TPMSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_TRACE_CLKSEL (1)

    #define FSL_FEATURE_SIM_DIVIDER_HAS_OUTDIV2 (1)
    #define FSL_FEATURE_SIM_DIVIDER_HAS_OUTDIV3 (1)
    #define FSL_FEATURE_SIM_DIVIDER_HAS_USBDIV (1)
    #define FSL_FEATURE_SIM_DIVIDER_HAS_USBFSDIV (0)
    #define FSL_FEATURE_SIM_DIVIDER_HAS_USBHSDIV (0)

    #define FSL_FEATURE_SIM_SDID_HAS_FAMILYID (1)
    #define FSL_FEATURE_SIM_SDID_HAS_SUBFAMID (1)
    #define FSL_FEATURE_SIM_SDID_HAS_SERIESID (1)
    #define FSL_FEATURE_SIM_SDID_HAS_DIEID (1)
    #define FSL_FEATURE_SIM_SDID_HAS_SRAMSIZE (0)

    #define FSL_FEATURE_SIM_FCFG_HAS_FLASHDOZE (1)
    #define FSL_FEATURE_SIM_FCFG_HAS_FLASHDIS (1)
    #define FSL_FEATURE_SIM_FCFG_HAS_FTFDIS (0)
    #define FSL_FEATURE_SIM_FCFG_HAS_NVMSIZE (1)
    #define FSL_FEATURE_SIM_FCFG_HAS_EESIZE (1)
    #define FSL_FEATURE_SIM_FCFG_HAS_DEPART (1)
    #define FSL_FEATURE_SIM_FCFG_HAS_MAXADDR0 (1)
    #define FSL_FEATURE_SIM_FCFG_HAS_MAXADDR1 (1)
    #define FSL_FEATURE_SIM_FCFG_HAS_MAXADDR01 (0)
    #define FSL_FEATURE_SIM_FCFG_HAS_MAXADDR23 (0)
    #define FSL_FEATURE_SIM_FCFG_HAS_PFLSH (1)

#elif  (defined(CPU_MK22FN512VDC12))
    #define FSL_FEATURE_SIM_USBFS_USE_SPECIAL_DIVIDER (0)
    #define FSL_FEATURE_SIM_PLLCLK_USE_SPECIAL_DIVIDER (0)

    #define FSL_FEATURE_SIM_OPT_HAS_RAMSIZE (1)
    #define FSL_FEATURE_SIM_OPT_HAS_CMTUARTPAD (0)
    #define FSL_FEATURE_SIM_OPT_HAS_PTD7PAD (0)
    #define FSL_FEATURE_SIM_OPT_HAS_FBSL (1)
    #define FSL_FEATURE_SIM_OPT_HAS_PCR (0)
    #define FSL_FEATURE_SIM_OPT_HAS_MCC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_ODE (0)
    #define FSL_FEATURE_SIM_OPT_UART_COUNT (2)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM (1)
    #define FSL_FEATURE_SIM_OPT_FTM_TRIGGER_COUNT (2)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM0_TRIGGER (1)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM3_TRIGGER (1)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM1_CHANNELS (1)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM2_CHANNELS (1)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM3_CHANNELS (0)
    #define FSL_FEATURE_SIM_OPT_HAS_FTM2_CHANNEL1 (0)
    #define FSL_FEATURE_SIM_OPT_FTM0_FAULT_COUNT (2)
    #define FSL_FEATURE_SIM_OPT_HAS_TPM (0)

    #define FSL_FEATURE_SIM_OPT_HAS_NFCSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_ESDHCSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_SDHCSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_LCDCSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_TIMESRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_RMIISRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_USBSRC (1)
    #define FSL_FEATURE_SIM_OPT_HAS_USBFSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_USBHSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_UART0SRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_TPMSRC (0)
    #define FSL_FEATURE_SIM_OPT_HAS_TRACE_CLKSEL (1)

    #define FSL_FEATURE_SIM_DIVIDER_HAS_OUTDIV2 (1)
    #define FSL_FEATURE_SIM_DIVIDER_HAS_OUTDIV3 (1)
    #define FSL_FEATURE_SIM_DIVIDER_HAS_USBDIV (1)
    #define FSL_FEATURE_SIM_DIVIDER_HAS_USBFSDIV (0)
    #define FSL_FEATURE_SIM_DIVIDER_HAS_USBHSDIV (0)

    #define FSL_FEATURE_SIM_SDID_HAS_FAMILYID (1)
    #define FSL_FEATURE_SIM_SDID_HAS_SUBFAMID (1)
    #define FSL_FEATURE_SIM_SDID_HAS_SERIESID (1)
    #define FSL_FEATURE_SIM_SDID_HAS_DIEID (1)
    #define FSL_FEATURE_SIM_SDID_HAS_SRAMSIZE (0)

    #define FSL_FEATURE_SIM_FCFG_HAS_FLASHDOZE (1)
    #define FSL_FEATURE_SIM_FCFG_HAS_FLASHDIS (1)
    #define FSL_FEATURE_SIM_FCFG_HAS_FTFDIS (0)
    #define FSL_FEATURE_SIM_FCFG_HAS_NVMSIZE (0)
    #define FSL_FEATURE_SIM_FCFG_HAS_EESIZE (0)
    #define FSL_FEATURE_SIM_FCFG_HAS_DEPART (0)

    #define FSL_FEATURE_SIM_FCFG_HAS_MAXADDR0 (1)
    #define FSL_FEATURE_SIM_FCFG_HAS_MAXADDR1 (1)
    #define FSL_FEATURE_SIM_FCFG_HAS_MAXADDR01 (0)
    #define FSL_FEATURE_SIM_FCFG_HAS_MAXADDR23 (0)
    #define FSL_FEATURE_SIM_FCFG_HAS_PFLSH (0)

#else
    #error "No valid CPU defined"
#endif

#endif /* __FSL_SIM_FEATURES_H__*/
/*******************************************************************************
 * EOF
 ******************************************************************************/


