/*
 * Copyright (c) 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_SDHC_REGISTERS_H__
#define __HW_SDHC_REGISTERS_H__

#include "regs.h"

/*
 * MK64F12 SDHC
 *
 * Secured Digital Host Controller
 *
 * Registers defined in this header file:
 * - HW_SDHC_DSADDR - DMA System Address register
 * - HW_SDHC_BLKATTR - Block Attributes register
 * - HW_SDHC_CMDARG - Command Argument register
 * - HW_SDHC_XFERTYP - Transfer Type register
 * - HW_SDHC_CMDRSP0 - Command Response 0
 * - HW_SDHC_CMDRSP1 - Command Response 1
 * - HW_SDHC_CMDRSP2 - Command Response 2
 * - HW_SDHC_CMDRSP3 - Command Response 3
 * - HW_SDHC_DATPORT - Buffer Data Port register
 * - HW_SDHC_PRSSTAT - Present State register
 * - HW_SDHC_PROCTL - Protocol Control register
 * - HW_SDHC_SYSCTL - System Control register
 * - HW_SDHC_IRQSTAT - Interrupt Status register
 * - HW_SDHC_IRQSTATEN - Interrupt Status Enable register
 * - HW_SDHC_IRQSIGEN - Interrupt Signal Enable register
 * - HW_SDHC_AC12ERR - Auto CMD12 Error Status Register
 * - HW_SDHC_HTCAPBLT - Host Controller Capabilities
 * - HW_SDHC_WML - Watermark Level Register
 * - HW_SDHC_FEVT - Force Event register
 * - HW_SDHC_ADMAES - ADMA Error Status register
 * - HW_SDHC_ADSADDR - ADMA System Addressregister
 * - HW_SDHC_VENDOR - Vendor Specific register
 * - HW_SDHC_MMCBOOT - MMC Boot register
 * - HW_SDHC_HOSTVER - Host Controller Version
 *
 * - hw_sdhc_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_SDHC_BASE
#define HW_SDHC_INSTANCE_COUNT (1U) //!< Number of instances of the SDHC module.
#define REGS_SDHC_BASE (0x400B1000U) //!< Base address for SDHC.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_DSADDR - DMA System Address register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_DSADDR - DMA System Address register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register contains the physical system memory address used for DMA
 * transfers.
 */
typedef union _hw_sdhc_dsaddr
{
    uint32_t U;
    struct _hw_sdhc_dsaddr_bitfields
    {
        uint32_t RESERVED0 : 2;        //!< [1:0]
        uint32_t DSADDR : 30;          //!< [31:2] DMA System Address
    } B;
} hw_sdhc_dsaddr_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_DSADDR register
 */
//@{
#define HW_SDHC_DSADDR_ADDR      (REGS_SDHC_BASE + 0x0U)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_DSADDR           (*(__IO hw_sdhc_dsaddr_t *) HW_SDHC_DSADDR_ADDR)
#define HW_SDHC_DSADDR_RD()      (HW_SDHC_DSADDR.U)
#define HW_SDHC_DSADDR_WR(v)     (HW_SDHC_DSADDR.U = (v))
#define HW_SDHC_DSADDR_SET(v)    (HW_SDHC_DSADDR_WR(HW_SDHC_DSADDR_RD() |  (v)))
#define HW_SDHC_DSADDR_CLR(v)    (HW_SDHC_DSADDR_WR(HW_SDHC_DSADDR_RD() & ~(v)))
#define HW_SDHC_DSADDR_TOG(v)    (HW_SDHC_DSADDR_WR(HW_SDHC_DSADDR_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SDHC_DSADDR bitfields
 */

/*!
 * @name Register SDHC_DSADDR, field DSADDR[31:2] (RW)
 *
 * Contains the 32-bit system memory address for a DMA transfer. Because the
 * address must be word (4 bytes) align, the least 2 bits are reserved, always 0.
 * When the SDHC stops a DMA transfer, this register points to the system address
 * of the next contiguous data position. It can be accessed only when no
 * transaction is executing, that is, after a transaction has stopped. Read operation
 * during transfers may return an invalid value. The host driver shall initialize
 * this register before starting a DMA transaction. After DMA has stopped, the
 * system address of the next contiguous data position can be read from this register.
 * This register is protected during a data transfer. When data lines are
 * active, write to this register is ignored. The host driver shall wait, until
 * PRSSTAT[DLA] is cleared, before writing to this register. The SDHC internal DMA does
 * not support a virtual memory system. It supports only continuous physical
 * memory access. And due to AHB burst limitations, if the burst must cross the 1 KB
 * boundary, SDHC will automatically change SEQ burst type to NSEQ. Because this
 * register supports dynamic address reflecting, when IRQSTAT[TC] bit is set, it
 * automatically alters the value of internal address counter, so SW cannot
 * change this register when IRQSTAT[TC] is set.
 */
//@{
#define BP_SDHC_DSADDR_DSADDR (2U)         //!< Bit position for SDHC_DSADDR_DSADDR.
#define BM_SDHC_DSADDR_DSADDR (0xFFFFFFFCU) //!< Bit mask for SDHC_DSADDR_DSADDR.
#define BS_SDHC_DSADDR_DSADDR (30U)        //!< Bit field size in bits for SDHC_DSADDR_DSADDR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_DSADDR_DSADDR field.
#define BR_SDHC_DSADDR_DSADDR (HW_SDHC_DSADDR.B.DSADDR)
#endif

//! @brief Format value for bitfield SDHC_DSADDR_DSADDR.
#define BF_SDHC_DSADDR_DSADDR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_DSADDR_DSADDR), uint32_t) & BM_SDHC_DSADDR_DSADDR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DSADDR field to a new value.
#define BW_SDHC_DSADDR_DSADDR(v) (HW_SDHC_DSADDR_WR((HW_SDHC_DSADDR_RD() & ~BM_SDHC_DSADDR_DSADDR) | BF_SDHC_DSADDR_DSADDR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_BLKATTR - Block Attributes register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_BLKATTR - Block Attributes register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register is used to configure the number of data blocks and the number
 * of bytes in each block.
 */
typedef union _hw_sdhc_blkattr
{
    uint32_t U;
    struct _hw_sdhc_blkattr_bitfields
    {
        uint32_t BLKSIZE : 13;         //!< [12:0] Transfer Block Size
        uint32_t RESERVED0 : 3;        //!< [15:13]
        uint32_t BLKCNT : 16;          //!< [31:16] Blocks Count For Current Transfer
    } B;
} hw_sdhc_blkattr_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_BLKATTR register
 */
//@{
#define HW_SDHC_BLKATTR_ADDR     (REGS_SDHC_BASE + 0x4U)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_BLKATTR          (*(__IO hw_sdhc_blkattr_t *) HW_SDHC_BLKATTR_ADDR)
#define HW_SDHC_BLKATTR_RD()     (HW_SDHC_BLKATTR.U)
#define HW_SDHC_BLKATTR_WR(v)    (HW_SDHC_BLKATTR.U = (v))
#define HW_SDHC_BLKATTR_SET(v)   (HW_SDHC_BLKATTR_WR(HW_SDHC_BLKATTR_RD() |  (v)))
#define HW_SDHC_BLKATTR_CLR(v)   (HW_SDHC_BLKATTR_WR(HW_SDHC_BLKATTR_RD() & ~(v)))
#define HW_SDHC_BLKATTR_TOG(v)   (HW_SDHC_BLKATTR_WR(HW_SDHC_BLKATTR_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SDHC_BLKATTR bitfields
 */

/*!
 * @name Register SDHC_BLKATTR, field BLKSIZE[12:0] (RW)
 *
 * Specifies the block size for block data transfers. Values ranging from 1 byte
 * up to the maximum buffer size can be set. It can be accessed only when no
 * transaction is executing, that is, after a transaction has stopped. Read
 * operations during transfers may return an invalid value, and write operations will be
 * ignored.
 *
 * Values:
 * - 0 - No data transfer.
 * - 1 - 1 Byte
 * - 10 - 2 Bytes
 * - 11 - 3 Bytes
 * - 100 - 4 Bytes
 * - 111111111 - 511 Bytes
 * - 1000000000 - 512 Bytes
 * - 100000000000 - 2048 Bytes
 * - 1000000000000 - 4096 Bytes
 */
//@{
#define BP_SDHC_BLKATTR_BLKSIZE (0U)       //!< Bit position for SDHC_BLKATTR_BLKSIZE.
#define BM_SDHC_BLKATTR_BLKSIZE (0x00001FFFU) //!< Bit mask for SDHC_BLKATTR_BLKSIZE.
#define BS_SDHC_BLKATTR_BLKSIZE (13U)      //!< Bit field size in bits for SDHC_BLKATTR_BLKSIZE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_BLKATTR_BLKSIZE field.
#define BR_SDHC_BLKATTR_BLKSIZE (HW_SDHC_BLKATTR.B.BLKSIZE)
#endif

//! @brief Format value for bitfield SDHC_BLKATTR_BLKSIZE.
#define BF_SDHC_BLKATTR_BLKSIZE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_BLKATTR_BLKSIZE), uint32_t) & BM_SDHC_BLKATTR_BLKSIZE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BLKSIZE field to a new value.
#define BW_SDHC_BLKATTR_BLKSIZE(v) (HW_SDHC_BLKATTR_WR((HW_SDHC_BLKATTR_RD() & ~BM_SDHC_BLKATTR_BLKSIZE) | BF_SDHC_BLKATTR_BLKSIZE(v)))
#endif
//@}

/*!
 * @name Register SDHC_BLKATTR, field BLKCNT[31:16] (RW)
 *
 * This register is enabled when XFERTYP[BCEN] is set to 1 and is valid only for
 * multiple block transfers. For single block transfer, this register will
 * always read as 1. The host driver shall set this register to a value between 1 and
 * the maximum block count. The SDHC decrements the block count after each block
 * transfer and stops when the count reaches zero. Setting the block count to 0
 * results in no data blocks being transferred. This register must be accessed
 * only when no transaction is executing, that is, after transactions are stopped.
 * During data transfer, read operations on this register may return an invalid
 * value and write operations are ignored. When saving transfer content as a result
 * of a suspend command, the number of blocks yet to be transferred can be
 * determined by reading this register. The reading of this register must be applied
 * after transfer is paused by stop at block gap operation and before sending the
 * command marked as suspend. This is because when suspend command is sent out,
 * SDHC will regard the current transfer as aborted and change BLKCNT back to its
 * original value instead of keeping the dynamical indicator of remained block
 * count. When restoring transfer content prior to issuing a resume command, the
 * host driver shall restore the previously saved block count. Although the BLKCNT
 * field is 0 after reset, the read of reset value is 0x1. This is because when
 * XFERTYP[MSBSEL] is 0, indicating a single block transfer, the read value of
 * BLKCNT is always 1.
 *
 * Values:
 * - 0 - Stop count.
 * - 1 - 1 block
 * - 10 - 2 blocks
 * - 1111111111111111 - 65535 blocks
 */
//@{
#define BP_SDHC_BLKATTR_BLKCNT (16U)       //!< Bit position for SDHC_BLKATTR_BLKCNT.
#define BM_SDHC_BLKATTR_BLKCNT (0xFFFF0000U) //!< Bit mask for SDHC_BLKATTR_BLKCNT.
#define BS_SDHC_BLKATTR_BLKCNT (16U)       //!< Bit field size in bits for SDHC_BLKATTR_BLKCNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_BLKATTR_BLKCNT field.
#define BR_SDHC_BLKATTR_BLKCNT (HW_SDHC_BLKATTR.B.BLKCNT)
#endif

//! @brief Format value for bitfield SDHC_BLKATTR_BLKCNT.
#define BF_SDHC_BLKATTR_BLKCNT(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_BLKATTR_BLKCNT), uint32_t) & BM_SDHC_BLKATTR_BLKCNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BLKCNT field to a new value.
#define BW_SDHC_BLKATTR_BLKCNT(v) (HW_SDHC_BLKATTR_WR((HW_SDHC_BLKATTR_RD() & ~BM_SDHC_BLKATTR_BLKCNT) | BF_SDHC_BLKATTR_BLKCNT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_CMDARG - Command Argument register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_CMDARG - Command Argument register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register contains the SD/MMC command argument.
 */
typedef union _hw_sdhc_cmdarg
{
    uint32_t U;
    struct _hw_sdhc_cmdarg_bitfields
    {
        uint32_t CMDARG : 32;          //!< [31:0] Command Argument
    } B;
} hw_sdhc_cmdarg_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_CMDARG register
 */
//@{
#define HW_SDHC_CMDARG_ADDR      (REGS_SDHC_BASE + 0x8U)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_CMDARG           (*(__IO hw_sdhc_cmdarg_t *) HW_SDHC_CMDARG_ADDR)
#define HW_SDHC_CMDARG_RD()      (HW_SDHC_CMDARG.U)
#define HW_SDHC_CMDARG_WR(v)     (HW_SDHC_CMDARG.U = (v))
#define HW_SDHC_CMDARG_SET(v)    (HW_SDHC_CMDARG_WR(HW_SDHC_CMDARG_RD() |  (v)))
#define HW_SDHC_CMDARG_CLR(v)    (HW_SDHC_CMDARG_WR(HW_SDHC_CMDARG_RD() & ~(v)))
#define HW_SDHC_CMDARG_TOG(v)    (HW_SDHC_CMDARG_WR(HW_SDHC_CMDARG_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SDHC_CMDARG bitfields
 */

/*!
 * @name Register SDHC_CMDARG, field CMDARG[31:0] (RW)
 *
 * The SD/MMC command argument is specified as bits 39-8 of the command format
 * in the SD or MMC specification. This register is write protected when
 * PRSSTAT[CDIHB0] is set.
 */
//@{
#define BP_SDHC_CMDARG_CMDARG (0U)         //!< Bit position for SDHC_CMDARG_CMDARG.
#define BM_SDHC_CMDARG_CMDARG (0xFFFFFFFFU) //!< Bit mask for SDHC_CMDARG_CMDARG.
#define BS_SDHC_CMDARG_CMDARG (32U)        //!< Bit field size in bits for SDHC_CMDARG_CMDARG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_CMDARG_CMDARG field.
#define BR_SDHC_CMDARG_CMDARG (HW_SDHC_CMDARG.U)
#endif

//! @brief Format value for bitfield SDHC_CMDARG_CMDARG.
#define BF_SDHC_CMDARG_CMDARG(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_CMDARG_CMDARG), uint32_t) & BM_SDHC_CMDARG_CMDARG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CMDARG field to a new value.
#define BW_SDHC_CMDARG_CMDARG(v) (HW_SDHC_CMDARG_WR(v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_XFERTYP - Transfer Type register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_XFERTYP - Transfer Type register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register is used to control the operation of data transfers. The host
 * driver shall set this register before issuing a command followed by a data
 * transfer, or before issuing a resume command. To prevent data loss, the SDHC
 * prevents writing to the bits that are involved in the data transfer of this
 * register, when data transfer is active. These bits are DPSEL, MBSEL, DTDSEL, AC12EN,
 * BCEN, and DMAEN. The host driver shall check PRSSTAT[CDIHB] and PRSSTAT[CIHB]
 * before writing to this register. When PRSSTAT[CDIHB] is set, any attempt to
 * send a command with data by writing to this register is ignored; when
 * PRSSTAT[CIHB] bit is set, any write to this register is ignored. On sending commands with
 * data transfer involved, it is mandatory that the block size is nonzero.
 * Besides, block count must also be nonzero, or indicated as single block transfer
 * (bit 5 of this register is 0 when written), or block count is disabled (bit 1 of
 * this register is 0 when written), otherwise SDHC will ignore the sending of
 * this command and do nothing. For write command, with all above restrictions, it
 * is also mandatory that the write protect switch is not active (WPSPL bit of
 * Present State Register is 1), otherwise SDHC will also ignore the command. If
 * the commands with data transfer does not receive the response in 64 clock
 * cycles, that is, response time-out, SDHC will regard the external device does not
 * accept the command and abort the data transfer. In this scenario, the driver
 * must issue the command again to retry the transfer. It is also possible that,
 * for some reason, the card responds to the command but SDHC does not receive the
 * response, and if it is internal DMA (either simple DMA or ADMA) read
 * operation, the external system memory is over-written by the internal DMA with data
 * sent back from the card. The following table shows the summary of how register
 * settings determine the type of data transfer. Transfer Type register setting for
 * various transfer types Multi/Single block select Block count enable Block
 * count Function 0 Don't care Don't care Single transfer 1 0 Don't care Infinite
 * transfer 1 1 Positive number Multiple transfer 1 1 Zero No data transfer The
 * following table shows the relationship between XFERTYP[CICEN] and XFERTYP[CCCEN],
 * in regards to XFERTYP[RSPTYP] as well as the name of the response type.
 * Relationship between parameters and the name of the response type Response type
 * (RSPTYP) Index check enable (CICEN) CRC check enable (CCCEN) Name of response
 * type 00 0 0 No Response 01 0 1 IR2 10 0 0 R3,R4 10 1 1 R1,R5,R6 11 1 1 R1b,R5b In
 * the SDIO specification, response type notation for R5b is not defined. R5
 * includes R5b in the SDIO specification. But R5b is defined in this specification
 * to specify that the SDHC will check the busy status after receiving a
 * response. For example, usually CMD52 is used with R5, but the I/O abort command shall
 * be used with R5b. The CRC field for R3 and R4 is expected to be all 1 bits.
 * The CRC check shall be disabled for these response types.
 */
typedef union _hw_sdhc_xfertyp
{
    uint32_t U;
    struct _hw_sdhc_xfertyp_bitfields
    {
        uint32_t DMAEN : 1;            //!< [0] DMA Enable
        uint32_t BCEN : 1;             //!< [1] Block Count Enable
        uint32_t AC12EN : 1;           //!< [2] Auto CMD12 Enable
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t DTDSEL : 1;           //!< [4] Data Transfer Direction Select
        uint32_t MSBSEL : 1;           //!< [5] Multi/Single Block Select
        uint32_t RESERVED1 : 10;       //!< [15:6]
        uint32_t RSPTYP : 2;           //!< [17:16] Response Type Select
        uint32_t RESERVED2 : 1;        //!< [18]
        uint32_t CCCEN : 1;            //!< [19] Command CRC Check Enable
        uint32_t CICEN : 1;            //!< [20] Command Index Check Enable
        uint32_t DPSEL : 1;            //!< [21] Data Present Select
        uint32_t CMDTYP : 2;           //!< [23:22] Command Type
        uint32_t CMDINX : 6;           //!< [29:24] Command Index
        uint32_t RESERVED3 : 2;        //!< [31:30]
    } B;
} hw_sdhc_xfertyp_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_XFERTYP register
 */
//@{
#define HW_SDHC_XFERTYP_ADDR     (REGS_SDHC_BASE + 0xCU)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_XFERTYP          (*(__IO hw_sdhc_xfertyp_t *) HW_SDHC_XFERTYP_ADDR)
#define HW_SDHC_XFERTYP_RD()     (HW_SDHC_XFERTYP.U)
#define HW_SDHC_XFERTYP_WR(v)    (HW_SDHC_XFERTYP.U = (v))
#define HW_SDHC_XFERTYP_SET(v)   (HW_SDHC_XFERTYP_WR(HW_SDHC_XFERTYP_RD() |  (v)))
#define HW_SDHC_XFERTYP_CLR(v)   (HW_SDHC_XFERTYP_WR(HW_SDHC_XFERTYP_RD() & ~(v)))
#define HW_SDHC_XFERTYP_TOG(v)   (HW_SDHC_XFERTYP_WR(HW_SDHC_XFERTYP_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SDHC_XFERTYP bitfields
 */

/*!
 * @name Register SDHC_XFERTYP, field DMAEN[0] (RW)
 *
 * Enables DMA functionality. If this bit is set to 1, a DMA operation shall
 * begin when the host driver sets the DPSEL bit of this register. Whether the
 * simple DMA, or the advanced DMA, is active depends on PROCTL[DMAS].
 *
 * Values:
 * - 0 - Disable
 * - 1 - Enable
 */
//@{
#define BP_SDHC_XFERTYP_DMAEN (0U)         //!< Bit position for SDHC_XFERTYP_DMAEN.
#define BM_SDHC_XFERTYP_DMAEN (0x00000001U) //!< Bit mask for SDHC_XFERTYP_DMAEN.
#define BS_SDHC_XFERTYP_DMAEN (1U)         //!< Bit field size in bits for SDHC_XFERTYP_DMAEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_XFERTYP_DMAEN field.
#define BR_SDHC_XFERTYP_DMAEN (BITBAND_ACCESS32(HW_SDHC_XFERTYP_ADDR, BP_SDHC_XFERTYP_DMAEN))
#endif

//! @brief Format value for bitfield SDHC_XFERTYP_DMAEN.
#define BF_SDHC_XFERTYP_DMAEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_XFERTYP_DMAEN), uint32_t) & BM_SDHC_XFERTYP_DMAEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMAEN field to a new value.
#define BW_SDHC_XFERTYP_DMAEN(v) (BITBAND_ACCESS32(HW_SDHC_XFERTYP_ADDR, BP_SDHC_XFERTYP_DMAEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_XFERTYP, field BCEN[1] (RW)
 *
 * Used to enable the Block Count register, which is only relevant for multiple
 * block transfers. When this bit is 0, the internal counter for block is
 * disabled, which is useful in executing an infinite transfer.
 *
 * Values:
 * - 0 - Disable
 * - 1 - Enable
 */
//@{
#define BP_SDHC_XFERTYP_BCEN (1U)          //!< Bit position for SDHC_XFERTYP_BCEN.
#define BM_SDHC_XFERTYP_BCEN (0x00000002U) //!< Bit mask for SDHC_XFERTYP_BCEN.
#define BS_SDHC_XFERTYP_BCEN (1U)          //!< Bit field size in bits for SDHC_XFERTYP_BCEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_XFERTYP_BCEN field.
#define BR_SDHC_XFERTYP_BCEN (BITBAND_ACCESS32(HW_SDHC_XFERTYP_ADDR, BP_SDHC_XFERTYP_BCEN))
#endif

//! @brief Format value for bitfield SDHC_XFERTYP_BCEN.
#define BF_SDHC_XFERTYP_BCEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_XFERTYP_BCEN), uint32_t) & BM_SDHC_XFERTYP_BCEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BCEN field to a new value.
#define BW_SDHC_XFERTYP_BCEN(v) (BITBAND_ACCESS32(HW_SDHC_XFERTYP_ADDR, BP_SDHC_XFERTYP_BCEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_XFERTYP, field AC12EN[2] (RW)
 *
 * Multiple block transfers for memory require a CMD12 to stop the transaction.
 * When this bit is set to 1, the SDHC will issue a CMD12 automatically when the
 * last block transfer has completed. The host driver shall not set this bit to
 * issue commands that do not require CMD12 to stop a multiple block data
 * transfer. In particular, secure commands defined in File Security Specification (see
 * reference list) do not require CMD12. In single block transfer, the SDHC will
 * ignore this bit whether it is set or not.
 *
 * Values:
 * - 0 - Disable
 * - 1 - Enable
 */
//@{
#define BP_SDHC_XFERTYP_AC12EN (2U)        //!< Bit position for SDHC_XFERTYP_AC12EN.
#define BM_SDHC_XFERTYP_AC12EN (0x00000004U) //!< Bit mask for SDHC_XFERTYP_AC12EN.
#define BS_SDHC_XFERTYP_AC12EN (1U)        //!< Bit field size in bits for SDHC_XFERTYP_AC12EN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_XFERTYP_AC12EN field.
#define BR_SDHC_XFERTYP_AC12EN (BITBAND_ACCESS32(HW_SDHC_XFERTYP_ADDR, BP_SDHC_XFERTYP_AC12EN))
#endif

//! @brief Format value for bitfield SDHC_XFERTYP_AC12EN.
#define BF_SDHC_XFERTYP_AC12EN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_XFERTYP_AC12EN), uint32_t) & BM_SDHC_XFERTYP_AC12EN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AC12EN field to a new value.
#define BW_SDHC_XFERTYP_AC12EN(v) (BITBAND_ACCESS32(HW_SDHC_XFERTYP_ADDR, BP_SDHC_XFERTYP_AC12EN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_XFERTYP, field DTDSEL[4] (RW)
 *
 * Defines the direction of DAT line data transfers. The bit is set to 1 by the
 * host driver to transfer data from the SD card to the SDHC and is set to 0 for
 * all other commands.
 *
 * Values:
 * - 0 - Write host to card.
 * - 1 - Read card to host.
 */
//@{
#define BP_SDHC_XFERTYP_DTDSEL (4U)        //!< Bit position for SDHC_XFERTYP_DTDSEL.
#define BM_SDHC_XFERTYP_DTDSEL (0x00000010U) //!< Bit mask for SDHC_XFERTYP_DTDSEL.
#define BS_SDHC_XFERTYP_DTDSEL (1U)        //!< Bit field size in bits for SDHC_XFERTYP_DTDSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_XFERTYP_DTDSEL field.
#define BR_SDHC_XFERTYP_DTDSEL (BITBAND_ACCESS32(HW_SDHC_XFERTYP_ADDR, BP_SDHC_XFERTYP_DTDSEL))
#endif

//! @brief Format value for bitfield SDHC_XFERTYP_DTDSEL.
#define BF_SDHC_XFERTYP_DTDSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_XFERTYP_DTDSEL), uint32_t) & BM_SDHC_XFERTYP_DTDSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DTDSEL field to a new value.
#define BW_SDHC_XFERTYP_DTDSEL(v) (BITBAND_ACCESS32(HW_SDHC_XFERTYP_ADDR, BP_SDHC_XFERTYP_DTDSEL) = (v))
#endif
//@}

/*!
 * @name Register SDHC_XFERTYP, field MSBSEL[5] (RW)
 *
 * Enables multiple block DAT line data transfers. For any other commands, this
 * bit shall be set to 0. If this bit is 0, it is not necessary to set the block
 * count register.
 *
 * Values:
 * - 0 - Single block.
 * - 1 - Multiple blocks.
 */
//@{
#define BP_SDHC_XFERTYP_MSBSEL (5U)        //!< Bit position for SDHC_XFERTYP_MSBSEL.
#define BM_SDHC_XFERTYP_MSBSEL (0x00000020U) //!< Bit mask for SDHC_XFERTYP_MSBSEL.
#define BS_SDHC_XFERTYP_MSBSEL (1U)        //!< Bit field size in bits for SDHC_XFERTYP_MSBSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_XFERTYP_MSBSEL field.
#define BR_SDHC_XFERTYP_MSBSEL (BITBAND_ACCESS32(HW_SDHC_XFERTYP_ADDR, BP_SDHC_XFERTYP_MSBSEL))
#endif

//! @brief Format value for bitfield SDHC_XFERTYP_MSBSEL.
#define BF_SDHC_XFERTYP_MSBSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_XFERTYP_MSBSEL), uint32_t) & BM_SDHC_XFERTYP_MSBSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MSBSEL field to a new value.
#define BW_SDHC_XFERTYP_MSBSEL(v) (BITBAND_ACCESS32(HW_SDHC_XFERTYP_ADDR, BP_SDHC_XFERTYP_MSBSEL) = (v))
#endif
//@}

/*!
 * @name Register SDHC_XFERTYP, field RSPTYP[17:16] (RW)
 *
 * Values:
 * - 00 - No response.
 * - 01 - Response length 136.
 * - 10 - Response length 48.
 * - 11 - Response length 48, check busy after response.
 */
//@{
#define BP_SDHC_XFERTYP_RSPTYP (16U)       //!< Bit position for SDHC_XFERTYP_RSPTYP.
#define BM_SDHC_XFERTYP_RSPTYP (0x00030000U) //!< Bit mask for SDHC_XFERTYP_RSPTYP.
#define BS_SDHC_XFERTYP_RSPTYP (2U)        //!< Bit field size in bits for SDHC_XFERTYP_RSPTYP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_XFERTYP_RSPTYP field.
#define BR_SDHC_XFERTYP_RSPTYP (HW_SDHC_XFERTYP.B.RSPTYP)
#endif

//! @brief Format value for bitfield SDHC_XFERTYP_RSPTYP.
#define BF_SDHC_XFERTYP_RSPTYP(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_XFERTYP_RSPTYP), uint32_t) & BM_SDHC_XFERTYP_RSPTYP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RSPTYP field to a new value.
#define BW_SDHC_XFERTYP_RSPTYP(v) (HW_SDHC_XFERTYP_WR((HW_SDHC_XFERTYP_RD() & ~BM_SDHC_XFERTYP_RSPTYP) | BF_SDHC_XFERTYP_RSPTYP(v)))
#endif
//@}

/*!
 * @name Register SDHC_XFERTYP, field CCCEN[19] (RW)
 *
 * If this bit is set to 1, the SDHC shall check the CRC field in the response.
 * If an error is detected, it is reported as a Command CRC Error. If this bit is
 * set to 0, the CRC field is not checked. The number of bits checked by the CRC
 * field value changes according to the length of the response.
 *
 * Values:
 * - 0 - Disable
 * - 1 - Enable
 */
//@{
#define BP_SDHC_XFERTYP_CCCEN (19U)        //!< Bit position for SDHC_XFERTYP_CCCEN.
#define BM_SDHC_XFERTYP_CCCEN (0x00080000U) //!< Bit mask for SDHC_XFERTYP_CCCEN.
#define BS_SDHC_XFERTYP_CCCEN (1U)         //!< Bit field size in bits for SDHC_XFERTYP_CCCEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_XFERTYP_CCCEN field.
#define BR_SDHC_XFERTYP_CCCEN (BITBAND_ACCESS32(HW_SDHC_XFERTYP_ADDR, BP_SDHC_XFERTYP_CCCEN))
#endif

//! @brief Format value for bitfield SDHC_XFERTYP_CCCEN.
#define BF_SDHC_XFERTYP_CCCEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_XFERTYP_CCCEN), uint32_t) & BM_SDHC_XFERTYP_CCCEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CCCEN field to a new value.
#define BW_SDHC_XFERTYP_CCCEN(v) (BITBAND_ACCESS32(HW_SDHC_XFERTYP_ADDR, BP_SDHC_XFERTYP_CCCEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_XFERTYP, field CICEN[20] (RW)
 *
 * If this bit is set to 1, the SDHC will check the index field in the response
 * to see if it has the same value as the command index. If it is not, it is
 * reported as a command index error. If this bit is set to 0, the index field is not
 * checked.
 *
 * Values:
 * - 0 - Disable
 * - 1 - Enable
 */
//@{
#define BP_SDHC_XFERTYP_CICEN (20U)        //!< Bit position for SDHC_XFERTYP_CICEN.
#define BM_SDHC_XFERTYP_CICEN (0x00100000U) //!< Bit mask for SDHC_XFERTYP_CICEN.
#define BS_SDHC_XFERTYP_CICEN (1U)         //!< Bit field size in bits for SDHC_XFERTYP_CICEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_XFERTYP_CICEN field.
#define BR_SDHC_XFERTYP_CICEN (BITBAND_ACCESS32(HW_SDHC_XFERTYP_ADDR, BP_SDHC_XFERTYP_CICEN))
#endif

//! @brief Format value for bitfield SDHC_XFERTYP_CICEN.
#define BF_SDHC_XFERTYP_CICEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_XFERTYP_CICEN), uint32_t) & BM_SDHC_XFERTYP_CICEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CICEN field to a new value.
#define BW_SDHC_XFERTYP_CICEN(v) (BITBAND_ACCESS32(HW_SDHC_XFERTYP_ADDR, BP_SDHC_XFERTYP_CICEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_XFERTYP, field DPSEL[21] (RW)
 *
 * This bit is set to 1 to indicate that data is present and shall be
 * transferred using the DAT line. It is set to 0 for the following: Commands using only
 * the CMD line, for example: CMD52. Commands with no data transfer, but using the
 * busy signal on DAT[0] line, R1b or R5b, for example: CMD38. In resume command,
 * this bit shall be set, and other bits in this register shall be set the same
 * as when the transfer was initially launched. When the Write Protect switch is
 * on, that is, the WPSPL bit is active as 0, any command with a write operation
 * will be ignored. That is to say, when this bit is set, while the DTDSEL bit is
 * 0, writes to the register Transfer Type are ignored.
 *
 * Values:
 * - 0 - No data present.
 * - 1 - Data present.
 */
//@{
#define BP_SDHC_XFERTYP_DPSEL (21U)        //!< Bit position for SDHC_XFERTYP_DPSEL.
#define BM_SDHC_XFERTYP_DPSEL (0x00200000U) //!< Bit mask for SDHC_XFERTYP_DPSEL.
#define BS_SDHC_XFERTYP_DPSEL (1U)         //!< Bit field size in bits for SDHC_XFERTYP_DPSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_XFERTYP_DPSEL field.
#define BR_SDHC_XFERTYP_DPSEL (BITBAND_ACCESS32(HW_SDHC_XFERTYP_ADDR, BP_SDHC_XFERTYP_DPSEL))
#endif

//! @brief Format value for bitfield SDHC_XFERTYP_DPSEL.
#define BF_SDHC_XFERTYP_DPSEL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_XFERTYP_DPSEL), uint32_t) & BM_SDHC_XFERTYP_DPSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DPSEL field to a new value.
#define BW_SDHC_XFERTYP_DPSEL(v) (BITBAND_ACCESS32(HW_SDHC_XFERTYP_ADDR, BP_SDHC_XFERTYP_DPSEL) = (v))
#endif
//@}

/*!
 * @name Register SDHC_XFERTYP, field CMDTYP[23:22] (RW)
 *
 * There are three types of special commands: suspend, resume, and abort. These
 * bits shall be set to 00b for all other commands. Suspend command: If the
 * suspend command succeeds, the SDHC shall assume that the card bus has been released
 * and that it is possible to issue the next command which uses the DAT line.
 * Because the SDHC does not monitor the content of command response, it does not
 * know if the suspend command succeeded or not. It is the host driver's
 * responsibility to check the status of the suspend command and send another command
 * marked as suspend to inform the SDHC that a suspend command was successfully
 * issued. After the end bit of command is sent, the SDHC deasserts read wait for read
 * transactions and stops checking busy for write transactions. In 4-bit mode,
 * the interrupt cycle starts. If the suspend command fails, the SDHC will
 * maintain its current state, and the host driver shall restart the transfer by setting
 * PROCTL[CREQ]. Resume command: The host driver restarts the data transfer by
 * restoring the registers saved before sending the suspend command and then sends
 * the resume command. The SDHC will check for a pending busy state before
 * starting write transfers. Abort command: If this command is set when executing a
 * read transfer, the SDHC will stop reads to the buffer. If this command is set
 * when executing a write transfer, the SDHC will stop driving the DAT line. After
 * issuing the abort command, the host driver must issue a software reset (abort
 * transaction).
 *
 * Values:
 * - 00 - Normal other commands.
 * - 01 - Suspend CMD52 for writing bus suspend in CCCR.
 * - 10 - Resume CMD52 for writing function select in CCCR.
 * - 11 - Abort CMD12, CMD52 for writing I/O abort in CCCR.
 */
//@{
#define BP_SDHC_XFERTYP_CMDTYP (22U)       //!< Bit position for SDHC_XFERTYP_CMDTYP.
#define BM_SDHC_XFERTYP_CMDTYP (0x00C00000U) //!< Bit mask for SDHC_XFERTYP_CMDTYP.
#define BS_SDHC_XFERTYP_CMDTYP (2U)        //!< Bit field size in bits for SDHC_XFERTYP_CMDTYP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_XFERTYP_CMDTYP field.
#define BR_SDHC_XFERTYP_CMDTYP (HW_SDHC_XFERTYP.B.CMDTYP)
#endif

//! @brief Format value for bitfield SDHC_XFERTYP_CMDTYP.
#define BF_SDHC_XFERTYP_CMDTYP(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_XFERTYP_CMDTYP), uint32_t) & BM_SDHC_XFERTYP_CMDTYP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CMDTYP field to a new value.
#define BW_SDHC_XFERTYP_CMDTYP(v) (HW_SDHC_XFERTYP_WR((HW_SDHC_XFERTYP_RD() & ~BM_SDHC_XFERTYP_CMDTYP) | BF_SDHC_XFERTYP_CMDTYP(v)))
#endif
//@}

/*!
 * @name Register SDHC_XFERTYP, field CMDINX[29:24] (RW)
 *
 * These bits shall be set to the command number that is specified in bits 45-40
 * of the command-format in the SD Memory Card Physical Layer Specification and
 * SDIO Card Specification.
 */
//@{
#define BP_SDHC_XFERTYP_CMDINX (24U)       //!< Bit position for SDHC_XFERTYP_CMDINX.
#define BM_SDHC_XFERTYP_CMDINX (0x3F000000U) //!< Bit mask for SDHC_XFERTYP_CMDINX.
#define BS_SDHC_XFERTYP_CMDINX (6U)        //!< Bit field size in bits for SDHC_XFERTYP_CMDINX.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_XFERTYP_CMDINX field.
#define BR_SDHC_XFERTYP_CMDINX (HW_SDHC_XFERTYP.B.CMDINX)
#endif

//! @brief Format value for bitfield SDHC_XFERTYP_CMDINX.
#define BF_SDHC_XFERTYP_CMDINX(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_XFERTYP_CMDINX), uint32_t) & BM_SDHC_XFERTYP_CMDINX)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CMDINX field to a new value.
#define BW_SDHC_XFERTYP_CMDINX(v) (HW_SDHC_XFERTYP_WR((HW_SDHC_XFERTYP_RD() & ~BM_SDHC_XFERTYP_CMDINX) | BF_SDHC_XFERTYP_CMDINX(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_CMDRSP0 - Command Response 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_CMDRSP0 - Command Response 0 (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register is used to store part 0 of the response bits from the card.
 */
typedef union _hw_sdhc_cmdrsp0
{
    uint32_t U;
    struct _hw_sdhc_cmdrsp0_bitfields
    {
        uint32_t CMDRSP0 : 32;         //!< [31:0] Command Response 0
    } B;
} hw_sdhc_cmdrsp0_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_CMDRSP0 register
 */
//@{
#define HW_SDHC_CMDRSP0_ADDR     (REGS_SDHC_BASE + 0x10U)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_CMDRSP0          (*(__I hw_sdhc_cmdrsp0_t *) HW_SDHC_CMDRSP0_ADDR)
#define HW_SDHC_CMDRSP0_RD()     (HW_SDHC_CMDRSP0.U)
#endif
//@}

/*
 * Constants & macros for individual SDHC_CMDRSP0 bitfields
 */

/*!
 * @name Register SDHC_CMDRSP0, field CMDRSP0[31:0] (RO)
 */
//@{
#define BP_SDHC_CMDRSP0_CMDRSP0 (0U)       //!< Bit position for SDHC_CMDRSP0_CMDRSP0.
#define BM_SDHC_CMDRSP0_CMDRSP0 (0xFFFFFFFFU) //!< Bit mask for SDHC_CMDRSP0_CMDRSP0.
#define BS_SDHC_CMDRSP0_CMDRSP0 (32U)      //!< Bit field size in bits for SDHC_CMDRSP0_CMDRSP0.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_CMDRSP0_CMDRSP0 field.
#define BR_SDHC_CMDRSP0_CMDRSP0 (HW_SDHC_CMDRSP0.U)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_CMDRSP1 - Command Response 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_CMDRSP1 - Command Response 1 (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register is used to store part 1 of the response bits from the card.
 */
typedef union _hw_sdhc_cmdrsp1
{
    uint32_t U;
    struct _hw_sdhc_cmdrsp1_bitfields
    {
        uint32_t CMDRSP1 : 32;         //!< [31:0] Command Response 1
    } B;
} hw_sdhc_cmdrsp1_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_CMDRSP1 register
 */
//@{
#define HW_SDHC_CMDRSP1_ADDR     (REGS_SDHC_BASE + 0x14U)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_CMDRSP1          (*(__I hw_sdhc_cmdrsp1_t *) HW_SDHC_CMDRSP1_ADDR)
#define HW_SDHC_CMDRSP1_RD()     (HW_SDHC_CMDRSP1.U)
#endif
//@}

/*
 * Constants & macros for individual SDHC_CMDRSP1 bitfields
 */

/*!
 * @name Register SDHC_CMDRSP1, field CMDRSP1[31:0] (RO)
 */
//@{
#define BP_SDHC_CMDRSP1_CMDRSP1 (0U)       //!< Bit position for SDHC_CMDRSP1_CMDRSP1.
#define BM_SDHC_CMDRSP1_CMDRSP1 (0xFFFFFFFFU) //!< Bit mask for SDHC_CMDRSP1_CMDRSP1.
#define BS_SDHC_CMDRSP1_CMDRSP1 (32U)      //!< Bit field size in bits for SDHC_CMDRSP1_CMDRSP1.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_CMDRSP1_CMDRSP1 field.
#define BR_SDHC_CMDRSP1_CMDRSP1 (HW_SDHC_CMDRSP1.U)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_CMDRSP2 - Command Response 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_CMDRSP2 - Command Response 2 (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register is used to store part 2 of the response bits from the card.
 */
typedef union _hw_sdhc_cmdrsp2
{
    uint32_t U;
    struct _hw_sdhc_cmdrsp2_bitfields
    {
        uint32_t CMDRSP2 : 32;         //!< [31:0] Command Response 2
    } B;
} hw_sdhc_cmdrsp2_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_CMDRSP2 register
 */
//@{
#define HW_SDHC_CMDRSP2_ADDR     (REGS_SDHC_BASE + 0x18U)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_CMDRSP2          (*(__I hw_sdhc_cmdrsp2_t *) HW_SDHC_CMDRSP2_ADDR)
#define HW_SDHC_CMDRSP2_RD()     (HW_SDHC_CMDRSP2.U)
#endif
//@}

/*
 * Constants & macros for individual SDHC_CMDRSP2 bitfields
 */

/*!
 * @name Register SDHC_CMDRSP2, field CMDRSP2[31:0] (RO)
 */
//@{
#define BP_SDHC_CMDRSP2_CMDRSP2 (0U)       //!< Bit position for SDHC_CMDRSP2_CMDRSP2.
#define BM_SDHC_CMDRSP2_CMDRSP2 (0xFFFFFFFFU) //!< Bit mask for SDHC_CMDRSP2_CMDRSP2.
#define BS_SDHC_CMDRSP2_CMDRSP2 (32U)      //!< Bit field size in bits for SDHC_CMDRSP2_CMDRSP2.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_CMDRSP2_CMDRSP2 field.
#define BR_SDHC_CMDRSP2_CMDRSP2 (HW_SDHC_CMDRSP2.U)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_CMDRSP3 - Command Response 3
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_CMDRSP3 - Command Response 3 (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register is used to store part 3 of the response bits from the card. The
 * following table describes the mapping of command responses from the SD bus to
 * command response registers for each response type. In the table, R[ ] refers
 * to a bit range within the response data as transmitted on the SD bus. Response
 * bit definition for each response type Response type Meaning of response
 * Response field Response register R1,R1b (normal response) Card status R[39:8]
 * CMDRSP0 R1b (Auto CMD12 response) Card status for auto CMD12 R[39:8] CMDRSP3 R2
 * (CID, CSD register) CID/CSD register [127:8] R[127:8] {CMDRSP3[23:0], CMDRSP2,
 * CMDRSP1, CMDRSP0} R3 (OCR register) OCR register for memory R[39:8] CMDRSP0 R4
 * (OCR register) OCR register for I/O etc. R[39:8] CMDRSP0 R5, R5b SDIO response
 * R[39:8] CMDRSP0 R6 (Publish RCA) New published RCA[31:16] and card
 * status[15:0] R[39:9] CMDRSP0 This table shows that most responses with a length of 48
 * (R[47:0]) have 32-bit of the response data (R[39:8]) stored in the CMDRSP0
 * register. Responses of type R1b (auto CMD12 responses) have response data bits
 * (R[39:8]) stored in the CMDRSP3 register. Responses with length 136 (R[135:0]) have
 * 120-bit of the response data (R[127:8]) stored in the CMDRSP0, 1, 2, and 3
 * registers. To be able to read the response status efficiently, the SDHC stores
 * only a part of the response data in the command response registers. This
 * enables the host driver to efficiently read 32-bit of response data in one read
 * cycle on a 32-bit bus system. Parts of the response, the index field and the CRC,
 * are checked by the SDHC, as specified by XFERTYP[CICEN] and XFERTYP[CCCEN],
 * and generate an error interrupt if any error is detected. The bit range for the
 * CRC check depends on the response length. If the response length is 48, the
 * SDHC will check R[47:1], and if the response length is 136 the SDHC will check
 * R[119:1]. Because the SDHC may have a multiple block data transfer executing
 * concurrently with a CMD_wo_DAT command, the SDHC stores the auto CMD12 response
 * in the CMDRSP3 register. The CMD_wo_DAT response is stored in CMDRSP0. This
 * allows the SDHC to avoid overwriting the Auto CMD12 response with the CMD_wo_DAT
 * and vice versa. When the SDHC modifies part of the command response
 * registers, as shown in the table above, it preserves the unmodified bits.
 */
typedef union _hw_sdhc_cmdrsp3
{
    uint32_t U;
    struct _hw_sdhc_cmdrsp3_bitfields
    {
        uint32_t CMDRSP3 : 32;         //!< [31:0] Command Response 3
    } B;
} hw_sdhc_cmdrsp3_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_CMDRSP3 register
 */
//@{
#define HW_SDHC_CMDRSP3_ADDR     (REGS_SDHC_BASE + 0x1CU)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_CMDRSP3          (*(__I hw_sdhc_cmdrsp3_t *) HW_SDHC_CMDRSP3_ADDR)
#define HW_SDHC_CMDRSP3_RD()     (HW_SDHC_CMDRSP3.U)
#endif
//@}

/*
 * Constants & macros for individual SDHC_CMDRSP3 bitfields
 */

/*!
 * @name Register SDHC_CMDRSP3, field CMDRSP3[31:0] (RO)
 */
//@{
#define BP_SDHC_CMDRSP3_CMDRSP3 (0U)       //!< Bit position for SDHC_CMDRSP3_CMDRSP3.
#define BM_SDHC_CMDRSP3_CMDRSP3 (0xFFFFFFFFU) //!< Bit mask for SDHC_CMDRSP3_CMDRSP3.
#define BS_SDHC_CMDRSP3_CMDRSP3 (32U)      //!< Bit field size in bits for SDHC_CMDRSP3_CMDRSP3.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_CMDRSP3_CMDRSP3 field.
#define BR_SDHC_CMDRSP3_CMDRSP3 (HW_SDHC_CMDRSP3.U)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_DATPORT - Buffer Data Port register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_DATPORT - Buffer Data Port register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This is a 32-bit data port register used to access the internal buffer and it
 * cannot be updated in Idle mode.
 */
typedef union _hw_sdhc_datport
{
    uint32_t U;
    struct _hw_sdhc_datport_bitfields
    {
        uint32_t DATCONT : 32;         //!< [31:0] Data Content
    } B;
} hw_sdhc_datport_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_DATPORT register
 */
//@{
#define HW_SDHC_DATPORT_ADDR     (REGS_SDHC_BASE + 0x20U)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_DATPORT          (*(__IO hw_sdhc_datport_t *) HW_SDHC_DATPORT_ADDR)
#define HW_SDHC_DATPORT_RD()     (HW_SDHC_DATPORT.U)
#define HW_SDHC_DATPORT_WR(v)    (HW_SDHC_DATPORT.U = (v))
#define HW_SDHC_DATPORT_SET(v)   (HW_SDHC_DATPORT_WR(HW_SDHC_DATPORT_RD() |  (v)))
#define HW_SDHC_DATPORT_CLR(v)   (HW_SDHC_DATPORT_WR(HW_SDHC_DATPORT_RD() & ~(v)))
#define HW_SDHC_DATPORT_TOG(v)   (HW_SDHC_DATPORT_WR(HW_SDHC_DATPORT_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SDHC_DATPORT bitfields
 */

/*!
 * @name Register SDHC_DATPORT, field DATCONT[31:0] (RW)
 *
 * The Buffer Data Port register is for 32-bit data access by the CPU or the
 * external DMA. When the internal DMA is enabled, any write to this register is
 * ignored, and any read from this register will always yield 0s.
 */
//@{
#define BP_SDHC_DATPORT_DATCONT (0U)       //!< Bit position for SDHC_DATPORT_DATCONT.
#define BM_SDHC_DATPORT_DATCONT (0xFFFFFFFFU) //!< Bit mask for SDHC_DATPORT_DATCONT.
#define BS_SDHC_DATPORT_DATCONT (32U)      //!< Bit field size in bits for SDHC_DATPORT_DATCONT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_DATPORT_DATCONT field.
#define BR_SDHC_DATPORT_DATCONT (HW_SDHC_DATPORT.U)
#endif

//! @brief Format value for bitfield SDHC_DATPORT_DATCONT.
#define BF_SDHC_DATPORT_DATCONT(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_DATPORT_DATCONT), uint32_t) & BM_SDHC_DATPORT_DATCONT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DATCONT field to a new value.
#define BW_SDHC_DATPORT_DATCONT(v) (HW_SDHC_DATPORT_WR(v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_PRSSTAT - Present State register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_PRSSTAT - Present State register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The host driver can get status of the SDHC from this 32-bit read-only
 * register. The host driver can issue CMD0, CMD12, CMD13 (for memory) and CMD52 (for
 * SDIO) when the DAT lines are busy during a data transfer. These commands can be
 * issued when Command Inhibit (CIHB) is set to zero. Other commands shall be
 * issued when Command Inhibit (CDIHB) is set to zero. Possible changes to the SD
 * Physical Specification may add other commands to this list in the future.
 */
typedef union _hw_sdhc_prsstat
{
    uint32_t U;
    struct _hw_sdhc_prsstat_bitfields
    {
        uint32_t CIHB : 1;             //!< [0] Command Inhibit (CMD)
        uint32_t CDIHB : 1;            //!< [1] Command Inhibit (DAT)
        uint32_t DLA : 1;              //!< [2] Data Line Active
        uint32_t SDSTB : 1;            //!< [3] SD Clock Stable
        uint32_t IPGOFF : 1;           //!< [4] Bus Clock Gated Off Internally
        uint32_t HCKOFF : 1;           //!< [5] System Clock Gated Off Internally
        uint32_t PEROFF : 1;           //!< [6] SDHC clock Gated Off Internally
        uint32_t SDOFF : 1;            //!< [7] SD Clock Gated Off Internally
        uint32_t WTA : 1;              //!< [8] Write Transfer Active
        uint32_t RTA : 1;              //!< [9] Read Transfer Active
        uint32_t BWEN : 1;             //!< [10] Buffer Write Enable
        uint32_t BREN : 1;             //!< [11] Buffer Read Enable
        uint32_t RESERVED0 : 4;        //!< [15:12]
        uint32_t CINS : 1;             //!< [16] Card Inserted
        uint32_t RESERVED1 : 6;        //!< [22:17]
        uint32_t CLSL : 1;             //!< [23] CMD Line Signal Level
        uint32_t DLSL : 8;             //!< [31:24] DAT Line Signal Level
    } B;
} hw_sdhc_prsstat_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_PRSSTAT register
 */
//@{
#define HW_SDHC_PRSSTAT_ADDR     (REGS_SDHC_BASE + 0x24U)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_PRSSTAT          (*(__I hw_sdhc_prsstat_t *) HW_SDHC_PRSSTAT_ADDR)
#define HW_SDHC_PRSSTAT_RD()     (HW_SDHC_PRSSTAT.U)
#endif
//@}

/*
 * Constants & macros for individual SDHC_PRSSTAT bitfields
 */

/*!
 * @name Register SDHC_PRSSTAT, field CIHB[0] (RO)
 *
 * If this status bit is 0, it indicates that the CMD line is not in use and the
 * SDHC can issue a SD/MMC Command using the CMD line. This bit is set also
 * immediately after the Transfer Type register is written. This bit is cleared when
 * the command response is received. Even if the CDIHB bit is set to 1, Commands
 * using only the CMD line can be issued if this bit is 0. Changing from 1 to 0
 * generates a command complete interrupt in the interrupt status register. If the
 * SDHC cannot issue the command because of a command conflict error (see
 * command CRC error) or because of a command not issued by auto CMD12 error, this bit
 * will remain 1 and the command complete is not set. The status of issuing an
 * auto CMD12 does not show on this bit.
 *
 * Values:
 * - 0 - Can issue command using only CMD line.
 * - 1 - Cannot issue command.
 */
//@{
#define BP_SDHC_PRSSTAT_CIHB (0U)          //!< Bit position for SDHC_PRSSTAT_CIHB.
#define BM_SDHC_PRSSTAT_CIHB (0x00000001U) //!< Bit mask for SDHC_PRSSTAT_CIHB.
#define BS_SDHC_PRSSTAT_CIHB (1U)          //!< Bit field size in bits for SDHC_PRSSTAT_CIHB.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PRSSTAT_CIHB field.
#define BR_SDHC_PRSSTAT_CIHB (BITBAND_ACCESS32(HW_SDHC_PRSSTAT_ADDR, BP_SDHC_PRSSTAT_CIHB))
#endif
//@}

/*!
 * @name Register SDHC_PRSSTAT, field CDIHB[1] (RO)
 *
 * This status bit is generated if either the DLA or the RTA is set to 1. If
 * this bit is 0, it indicates that the SDHC can issue the next SD/MMC Command.
 * Commands with a busy signal belong to CDIHB, for example, R1b, R5b type. Except in
 * the case when the command busy is finished, changing from 1 to 0 generates a
 * transfer complete interrupt in the Interrupt Status register. The SD host
 * driver can save registers for a suspend transaction after this bit has changed
 * from 1 to 0.
 *
 * Values:
 * - 0 - Can issue command which uses the DAT line.
 * - 1 - Cannot issue command which uses the DAT line.
 */
//@{
#define BP_SDHC_PRSSTAT_CDIHB (1U)         //!< Bit position for SDHC_PRSSTAT_CDIHB.
#define BM_SDHC_PRSSTAT_CDIHB (0x00000002U) //!< Bit mask for SDHC_PRSSTAT_CDIHB.
#define BS_SDHC_PRSSTAT_CDIHB (1U)         //!< Bit field size in bits for SDHC_PRSSTAT_CDIHB.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PRSSTAT_CDIHB field.
#define BR_SDHC_PRSSTAT_CDIHB (BITBAND_ACCESS32(HW_SDHC_PRSSTAT_ADDR, BP_SDHC_PRSSTAT_CDIHB))
#endif
//@}

/*!
 * @name Register SDHC_PRSSTAT, field DLA[2] (RO)
 *
 * Indicates whether one of the DAT lines on the SD bus is in use. In the case
 * of read transactions: This status indicates whether a read transfer is
 * executing on the SD bus. Changes in this value from 1 to 0, between data blocks,
 * generates a block gap event interrupt in the Interrupt Status register. This bit
 * will be set in either of the following cases: After the end bit of the read
 * command. When writing a 1 to PROCTL[CREQ] to restart a read transfer. This bit
 * will be cleared in either of the following cases: When the end bit of the last
 * data block is sent from the SD bus to the SDHC. When the read wait state is
 * stopped by a suspend command and the DAT2 line is released. The SDHC will wait at
 * the next block gap by driving read wait at the start of the interrupt cycle.
 * If the read wait signal is already driven (data buffer cannot receive data),
 * the SDHC can wait for a current block gap by continuing to drive the read wait
 * signal. It is necessary to support read wait to use the suspend / resume
 * function. This bit will remain 1 during read wait. In the case of write
 * transactions: This status indicates that a write transfer is executing on the SD bus.
 * Changes in this value from 1 to 0 generate a transfer complete interrupt in the
 * interrupt status register. This bit will be set in either of the following
 * cases: After the end bit of the write command. When writing to 1 to PROCTL[CREQ] to
 * continue a write transfer. This bit will be cleared in either of the
 * following cases: When the SD card releases write busy of the last data block, the SDHC
 * will also detect if the output is not busy. If the SD card does not drive the
 * busy signal after the CRC status is received, the SDHC shall assume the card
 * drive "Not busy". When the SD card releases write busy, prior to waiting for
 * write transfer, and as a result of a stop at block gap request. In the case of
 * command with busy pending: This status indicates that a busy state follows the
 * command and the data line is in use. This bit will be cleared when the DAT0
 * line is released.
 *
 * Values:
 * - 0 - DAT line inactive.
 * - 1 - DAT line active.
 */
//@{
#define BP_SDHC_PRSSTAT_DLA  (2U)          //!< Bit position for SDHC_PRSSTAT_DLA.
#define BM_SDHC_PRSSTAT_DLA  (0x00000004U) //!< Bit mask for SDHC_PRSSTAT_DLA.
#define BS_SDHC_PRSSTAT_DLA  (1U)          //!< Bit field size in bits for SDHC_PRSSTAT_DLA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PRSSTAT_DLA field.
#define BR_SDHC_PRSSTAT_DLA  (BITBAND_ACCESS32(HW_SDHC_PRSSTAT_ADDR, BP_SDHC_PRSSTAT_DLA))
#endif
//@}

/*!
 * @name Register SDHC_PRSSTAT, field SDSTB[3] (RO)
 *
 * Indicates that the internal card clock is stable. This bit is for the host
 * driver to poll clock status when changing the clock frequency. It is recommended
 * to clear SYSCTL[SDCLKEN] to remove glitch on the card clock when the
 * frequency is changing.
 *
 * Values:
 * - 0 - Clock is changing frequency and not stable.
 * - 1 - Clock is stable.
 */
//@{
#define BP_SDHC_PRSSTAT_SDSTB (3U)         //!< Bit position for SDHC_PRSSTAT_SDSTB.
#define BM_SDHC_PRSSTAT_SDSTB (0x00000008U) //!< Bit mask for SDHC_PRSSTAT_SDSTB.
#define BS_SDHC_PRSSTAT_SDSTB (1U)         //!< Bit field size in bits for SDHC_PRSSTAT_SDSTB.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PRSSTAT_SDSTB field.
#define BR_SDHC_PRSSTAT_SDSTB (BITBAND_ACCESS32(HW_SDHC_PRSSTAT_ADDR, BP_SDHC_PRSSTAT_SDSTB))
#endif
//@}

/*!
 * @name Register SDHC_PRSSTAT, field IPGOFF[4] (RO)
 *
 * Indicates that the bus clock is internally gated off. This bit is for the
 * host driver to debug.
 *
 * Values:
 * - 0 - Bus clock is active.
 * - 1 - Bus clock is gated off.
 */
//@{
#define BP_SDHC_PRSSTAT_IPGOFF (4U)        //!< Bit position for SDHC_PRSSTAT_IPGOFF.
#define BM_SDHC_PRSSTAT_IPGOFF (0x00000010U) //!< Bit mask for SDHC_PRSSTAT_IPGOFF.
#define BS_SDHC_PRSSTAT_IPGOFF (1U)        //!< Bit field size in bits for SDHC_PRSSTAT_IPGOFF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PRSSTAT_IPGOFF field.
#define BR_SDHC_PRSSTAT_IPGOFF (BITBAND_ACCESS32(HW_SDHC_PRSSTAT_ADDR, BP_SDHC_PRSSTAT_IPGOFF))
#endif
//@}

/*!
 * @name Register SDHC_PRSSTAT, field HCKOFF[5] (RO)
 *
 * Indicates that the system clock is internally gated off. This bit is for the
 * host driver to debug during a data transfer.
 *
 * Values:
 * - 0 - System clock is active.
 * - 1 - System clock is gated off.
 */
//@{
#define BP_SDHC_PRSSTAT_HCKOFF (5U)        //!< Bit position for SDHC_PRSSTAT_HCKOFF.
#define BM_SDHC_PRSSTAT_HCKOFF (0x00000020U) //!< Bit mask for SDHC_PRSSTAT_HCKOFF.
#define BS_SDHC_PRSSTAT_HCKOFF (1U)        //!< Bit field size in bits for SDHC_PRSSTAT_HCKOFF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PRSSTAT_HCKOFF field.
#define BR_SDHC_PRSSTAT_HCKOFF (BITBAND_ACCESS32(HW_SDHC_PRSSTAT_ADDR, BP_SDHC_PRSSTAT_HCKOFF))
#endif
//@}

/*!
 * @name Register SDHC_PRSSTAT, field PEROFF[6] (RO)
 *
 * Indicates that the is internally gated off. This bit is for the host driver
 * to debug transaction on the SD bus. When INITA bit is set, SDHC sending 80
 * clock cycles to the card, SDCLKEN must be 1 to enable the output card clock,
 * otherwise the will never be gate off, so and will be always active. SDHC clock SDHC
 * clock SDHC clock bus clock
 *
 * Values:
 * - 0 - SDHC clock is active.
 * - 1 - SDHC clock is gated off.
 */
//@{
#define BP_SDHC_PRSSTAT_PEROFF (6U)        //!< Bit position for SDHC_PRSSTAT_PEROFF.
#define BM_SDHC_PRSSTAT_PEROFF (0x00000040U) //!< Bit mask for SDHC_PRSSTAT_PEROFF.
#define BS_SDHC_PRSSTAT_PEROFF (1U)        //!< Bit field size in bits for SDHC_PRSSTAT_PEROFF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PRSSTAT_PEROFF field.
#define BR_SDHC_PRSSTAT_PEROFF (BITBAND_ACCESS32(HW_SDHC_PRSSTAT_ADDR, BP_SDHC_PRSSTAT_PEROFF))
#endif
//@}

/*!
 * @name Register SDHC_PRSSTAT, field SDOFF[7] (RO)
 *
 * Indicates that the SD clock is internally gated off, because of buffer
 * over/under-run or read pause without read wait assertion, or the driver has cleared
 * SYSCTL[SDCLKEN] to stop the SD clock. This bit is for the host driver to debug
 * data transaction on the SD bus.
 *
 * Values:
 * - 0 - SD clock is active.
 * - 1 - SD clock is gated off.
 */
//@{
#define BP_SDHC_PRSSTAT_SDOFF (7U)         //!< Bit position for SDHC_PRSSTAT_SDOFF.
#define BM_SDHC_PRSSTAT_SDOFF (0x00000080U) //!< Bit mask for SDHC_PRSSTAT_SDOFF.
#define BS_SDHC_PRSSTAT_SDOFF (1U)         //!< Bit field size in bits for SDHC_PRSSTAT_SDOFF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PRSSTAT_SDOFF field.
#define BR_SDHC_PRSSTAT_SDOFF (BITBAND_ACCESS32(HW_SDHC_PRSSTAT_ADDR, BP_SDHC_PRSSTAT_SDOFF))
#endif
//@}

/*!
 * @name Register SDHC_PRSSTAT, field WTA[8] (RO)
 *
 * Indicates that a write transfer is active. If this bit is 0, it means no
 * valid write data exists in the SDHC. This bit is set in either of the following
 * cases: After the end bit of the write command. When writing 1 to PROCTL[CREQ] to
 * restart a write transfer. This bit is cleared in either of the following
 * cases: After getting the CRC status of the last data block as specified by the
 * transfer count (single and multiple). After getting the CRC status of any block
 * where data transmission is about to be stopped by a stop at block gap request.
 * During a write transaction, a block gap event interrupt is generated when this
 * bit is changed to 0, as result of the stop at block gap request being set.
 * This status is useful for the host driver in determining when to issue commands
 * during write busy state.
 *
 * Values:
 * - 0 - No valid data.
 * - 1 - Transferring data.
 */
//@{
#define BP_SDHC_PRSSTAT_WTA  (8U)          //!< Bit position for SDHC_PRSSTAT_WTA.
#define BM_SDHC_PRSSTAT_WTA  (0x00000100U) //!< Bit mask for SDHC_PRSSTAT_WTA.
#define BS_SDHC_PRSSTAT_WTA  (1U)          //!< Bit field size in bits for SDHC_PRSSTAT_WTA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PRSSTAT_WTA field.
#define BR_SDHC_PRSSTAT_WTA  (BITBAND_ACCESS32(HW_SDHC_PRSSTAT_ADDR, BP_SDHC_PRSSTAT_WTA))
#endif
//@}

/*!
 * @name Register SDHC_PRSSTAT, field RTA[9] (RO)
 *
 * Used for detecting completion of a read transfer. This bit is set for either
 * of the following conditions: After the end bit of the read command. When
 * writing a 1 to PROCTL[CREQ] to restart a read transfer. A transfer complete
 * interrupt is generated when this bit changes to 0. This bit is cleared for either of
 * the following conditions: When the last data block as specified by block
 * length is transferred to the system, that is, all data are read away from SDHC
 * internal buffer. When all valid data blocks have been transferred from SDHC
 * internal buffer to the system and no current block transfers are being sent as a
 * result of the stop at block gap request being set to 1.
 *
 * Values:
 * - 0 - No valid data.
 * - 1 - Transferring data.
 */
//@{
#define BP_SDHC_PRSSTAT_RTA  (9U)          //!< Bit position for SDHC_PRSSTAT_RTA.
#define BM_SDHC_PRSSTAT_RTA  (0x00000200U) //!< Bit mask for SDHC_PRSSTAT_RTA.
#define BS_SDHC_PRSSTAT_RTA  (1U)          //!< Bit field size in bits for SDHC_PRSSTAT_RTA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PRSSTAT_RTA field.
#define BR_SDHC_PRSSTAT_RTA  (BITBAND_ACCESS32(HW_SDHC_PRSSTAT_ADDR, BP_SDHC_PRSSTAT_RTA))
#endif
//@}

/*!
 * @name Register SDHC_PRSSTAT, field BWEN[10] (RO)
 *
 * Used for non-DMA write transfers. The SDHC can implement multiple buffers to
 * transfer data efficiently. This read-only flag indicates whether space is
 * available for write data. If this bit is 1, valid data greater than the watermark
 * level can be written to the buffer. This read-only flag indicates whether
 * space is available for write data.
 *
 * Values:
 * - 0 - Write disable, the buffer can hold valid data less than the write
 *     watermark level.
 * - 1 - Write enable, the buffer can hold valid data greater than the write
 *     watermark level.
 */
//@{
#define BP_SDHC_PRSSTAT_BWEN (10U)         //!< Bit position for SDHC_PRSSTAT_BWEN.
#define BM_SDHC_PRSSTAT_BWEN (0x00000400U) //!< Bit mask for SDHC_PRSSTAT_BWEN.
#define BS_SDHC_PRSSTAT_BWEN (1U)          //!< Bit field size in bits for SDHC_PRSSTAT_BWEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PRSSTAT_BWEN field.
#define BR_SDHC_PRSSTAT_BWEN (BITBAND_ACCESS32(HW_SDHC_PRSSTAT_ADDR, BP_SDHC_PRSSTAT_BWEN))
#endif
//@}

/*!
 * @name Register SDHC_PRSSTAT, field BREN[11] (RO)
 *
 * Used for non-DMA read transfers. The SDHC may implement multiple buffers to
 * transfer data efficiently. This read-only flag indicates that valid data exists
 * in the host side buffer. If this bit is high, valid data greater than the
 * watermark level exist in the buffer. This read-only flag indicates that valid
 * data exists in the host side buffer.
 *
 * Values:
 * - 0 - Read disable, valid data less than the watermark level exist in the
 *     buffer.
 * - 1 - Read enable, valid data greater than the watermark level exist in the
 *     buffer.
 */
//@{
#define BP_SDHC_PRSSTAT_BREN (11U)         //!< Bit position for SDHC_PRSSTAT_BREN.
#define BM_SDHC_PRSSTAT_BREN (0x00000800U) //!< Bit mask for SDHC_PRSSTAT_BREN.
#define BS_SDHC_PRSSTAT_BREN (1U)          //!< Bit field size in bits for SDHC_PRSSTAT_BREN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PRSSTAT_BREN field.
#define BR_SDHC_PRSSTAT_BREN (BITBAND_ACCESS32(HW_SDHC_PRSSTAT_ADDR, BP_SDHC_PRSSTAT_BREN))
#endif
//@}

/*!
 * @name Register SDHC_PRSSTAT, field CINS[16] (RO)
 *
 * Indicates whether a card has been inserted. The SDHC debounces this signal so
 * that the host driver will not need to wait for it to stabilize. Changing from
 * a 0 to 1 generates a card insertion interrupt in the Interrupt Status
 * register. Changing from a 1 to 0 generates a card removal interrupt in the Interrupt
 * Status register. A write to the force event register does not effect this bit.
 * SYSCTL[RSTA] does not effect this bit. A software reset does not effect this
 * bit.
 *
 * Values:
 * - 0 - Power on reset or no card.
 * - 1 - Card inserted.
 */
//@{
#define BP_SDHC_PRSSTAT_CINS (16U)         //!< Bit position for SDHC_PRSSTAT_CINS.
#define BM_SDHC_PRSSTAT_CINS (0x00010000U) //!< Bit mask for SDHC_PRSSTAT_CINS.
#define BS_SDHC_PRSSTAT_CINS (1U)          //!< Bit field size in bits for SDHC_PRSSTAT_CINS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PRSSTAT_CINS field.
#define BR_SDHC_PRSSTAT_CINS (BITBAND_ACCESS32(HW_SDHC_PRSSTAT_ADDR, BP_SDHC_PRSSTAT_CINS))
#endif
//@}

/*!
 * @name Register SDHC_PRSSTAT, field CLSL[23] (RO)
 *
 * Used to check the CMD line level to recover from errors, and for debugging.
 * The reset value is effected by the external pullup/pulldown resistor, by
 * default, the read value of this bit after reset is 1b, when the command line is
 * pulled up.
 */
//@{
#define BP_SDHC_PRSSTAT_CLSL (23U)         //!< Bit position for SDHC_PRSSTAT_CLSL.
#define BM_SDHC_PRSSTAT_CLSL (0x00800000U) //!< Bit mask for SDHC_PRSSTAT_CLSL.
#define BS_SDHC_PRSSTAT_CLSL (1U)          //!< Bit field size in bits for SDHC_PRSSTAT_CLSL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PRSSTAT_CLSL field.
#define BR_SDHC_PRSSTAT_CLSL (BITBAND_ACCESS32(HW_SDHC_PRSSTAT_ADDR, BP_SDHC_PRSSTAT_CLSL))
#endif
//@}

/*!
 * @name Register SDHC_PRSSTAT, field DLSL[31:24] (RO)
 *
 * Used to check the DAT line level to recover from errors, and for debugging.
 * This is especially useful in detecting the busy signal level from DAT[0]. The
 * reset value is effected by the external pullup/pulldown resistors. By default,
 * the read value of this field after reset is 8'b11110111, when DAT[3] is pulled
 * down and the other lines are pulled up.
 */
//@{
#define BP_SDHC_PRSSTAT_DLSL (24U)         //!< Bit position for SDHC_PRSSTAT_DLSL.
#define BM_SDHC_PRSSTAT_DLSL (0xFF000000U) //!< Bit mask for SDHC_PRSSTAT_DLSL.
#define BS_SDHC_PRSSTAT_DLSL (8U)          //!< Bit field size in bits for SDHC_PRSSTAT_DLSL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PRSSTAT_DLSL field.
#define BR_SDHC_PRSSTAT_DLSL (HW_SDHC_PRSSTAT.B.DLSL)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_PROCTL - Protocol Control register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_PROCTL - Protocol Control register (RW)
 *
 * Reset value: 0x00000020U
 *
 * There are three cases to restart the transfer after stop at the block gap.
 * Which case is appropriate depends on whether the SDHC issues a suspend command
 * or the SD card accepts the suspend command: If the host driver does not issue a
 * suspend command, the continue request shall be used to restart the transfer.
 * If the host driver issues a suspend command and the SD card accepts it, a
 * resume command shall be used to restart the transfer. If the host driver issues a
 * suspend command and the SD card does not accept it, the continue request shall
 * be used to restart the transfer. Any time stop at block gap request stops the
 * data transfer, the host driver shall wait for a transfer complete (in the
 * interrupt status register), before attempting to restart the transfer. When
 * restarting the data transfer by continue request, the host driver shall clear the
 * stop at block gap request before or simultaneously.
 */
typedef union _hw_sdhc_proctl
{
    uint32_t U;
    struct _hw_sdhc_proctl_bitfields
    {
        uint32_t LCTL : 1;             //!< [0] LED Control
        uint32_t DTW : 2;              //!< [2:1] Data Transfer Width
        uint32_t D3CD : 1;             //!< [3] DAT3 As Card Detection Pin
        uint32_t EMODE : 2;            //!< [5:4] Endian Mode
        uint32_t CDTL : 1;             //!< [6] Card Detect Test Level
        uint32_t CDSS : 1;             //!< [7] Card Detect Signal Selection
        uint32_t DMAS : 2;             //!< [9:8] DMA Select
        uint32_t RESERVED0 : 6;        //!< [15:10]
        uint32_t SABGREQ : 1;          //!< [16] Stop At Block Gap Request
        uint32_t CREQ : 1;             //!< [17] Continue Request
        uint32_t RWCTL : 1;            //!< [18] Read Wait Control
        uint32_t IABG : 1;             //!< [19] Interrupt At Block Gap
        uint32_t RESERVED1 : 4;        //!< [23:20]
        uint32_t WECINT : 1;           //!< [24] Wakeup Event Enable On Card Interrupt
        uint32_t WECINS : 1;           //!< [25] Wakeup Event Enable On SD Card
                                       //! Insertion
        uint32_t WECRM : 1;            //!< [26] Wakeup Event Enable On SD Card Removal
        uint32_t RESERVED2 : 5;        //!< [31:27]
    } B;
} hw_sdhc_proctl_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_PROCTL register
 */
//@{
#define HW_SDHC_PROCTL_ADDR      (REGS_SDHC_BASE + 0x28U)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_PROCTL           (*(__IO hw_sdhc_proctl_t *) HW_SDHC_PROCTL_ADDR)
#define HW_SDHC_PROCTL_RD()      (HW_SDHC_PROCTL.U)
#define HW_SDHC_PROCTL_WR(v)     (HW_SDHC_PROCTL.U = (v))
#define HW_SDHC_PROCTL_SET(v)    (HW_SDHC_PROCTL_WR(HW_SDHC_PROCTL_RD() |  (v)))
#define HW_SDHC_PROCTL_CLR(v)    (HW_SDHC_PROCTL_WR(HW_SDHC_PROCTL_RD() & ~(v)))
#define HW_SDHC_PROCTL_TOG(v)    (HW_SDHC_PROCTL_WR(HW_SDHC_PROCTL_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SDHC_PROCTL bitfields
 */

/*!
 * @name Register SDHC_PROCTL, field LCTL[0] (RW)
 *
 * This bit, fully controlled by the host driver, is used to caution the user
 * not to remove the card while the card is being accessed. If the software is
 * going to issue multiple SD commands, this bit can be set during all these
 * transactions. It is not necessary to change for each transaction. When the software
 * issues multiple SD commands, setting the bit once before the first command is
 * sufficient: it is not necessary to reset the bit between commands.
 *
 * Values:
 * - 0 - LED off.
 * - 1 - LED on.
 */
//@{
#define BP_SDHC_PROCTL_LCTL  (0U)          //!< Bit position for SDHC_PROCTL_LCTL.
#define BM_SDHC_PROCTL_LCTL  (0x00000001U) //!< Bit mask for SDHC_PROCTL_LCTL.
#define BS_SDHC_PROCTL_LCTL  (1U)          //!< Bit field size in bits for SDHC_PROCTL_LCTL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PROCTL_LCTL field.
#define BR_SDHC_PROCTL_LCTL  (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_LCTL))
#endif

//! @brief Format value for bitfield SDHC_PROCTL_LCTL.
#define BF_SDHC_PROCTL_LCTL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_PROCTL_LCTL), uint32_t) & BM_SDHC_PROCTL_LCTL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LCTL field to a new value.
#define BW_SDHC_PROCTL_LCTL(v) (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_LCTL) = (v))
#endif
//@}

/*!
 * @name Register SDHC_PROCTL, field DTW[2:1] (RW)
 *
 * Selects the data width of the SD bus for a data transfer. The host driver
 * shall set it to match the data width of the card. Possible data transfer width is
 * 1-bit, 4-bits or 8-bits.
 *
 * Values:
 * - 00 - 1-bit mode
 * - 01 - 4-bit mode
 * - 10 - 8-bit mode
 * - 11 - Reserved
 */
//@{
#define BP_SDHC_PROCTL_DTW   (1U)          //!< Bit position for SDHC_PROCTL_DTW.
#define BM_SDHC_PROCTL_DTW   (0x00000006U) //!< Bit mask for SDHC_PROCTL_DTW.
#define BS_SDHC_PROCTL_DTW   (2U)          //!< Bit field size in bits for SDHC_PROCTL_DTW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PROCTL_DTW field.
#define BR_SDHC_PROCTL_DTW   (HW_SDHC_PROCTL.B.DTW)
#endif

//! @brief Format value for bitfield SDHC_PROCTL_DTW.
#define BF_SDHC_PROCTL_DTW(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_PROCTL_DTW), uint32_t) & BM_SDHC_PROCTL_DTW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DTW field to a new value.
#define BW_SDHC_PROCTL_DTW(v) (HW_SDHC_PROCTL_WR((HW_SDHC_PROCTL_RD() & ~BM_SDHC_PROCTL_DTW) | BF_SDHC_PROCTL_DTW(v)))
#endif
//@}

/*!
 * @name Register SDHC_PROCTL, field D3CD[3] (RW)
 *
 * If this bit is set, DAT3 should be pulled down to act as a card detection
 * pin. Be cautious when using this feature, because DAT3 is also a chip-select for
 * the SPI mode. A pulldown on this pin and CMD0 may set the card into the SPI
 * mode, which the SDHC does not support. Note: Keep this bit set if SDIO interrupt
 * is used.
 *
 * Values:
 * - 0 - DAT3 does not monitor card Insertion.
 * - 1 - DAT3 as card detection pin.
 */
//@{
#define BP_SDHC_PROCTL_D3CD  (3U)          //!< Bit position for SDHC_PROCTL_D3CD.
#define BM_SDHC_PROCTL_D3CD  (0x00000008U) //!< Bit mask for SDHC_PROCTL_D3CD.
#define BS_SDHC_PROCTL_D3CD  (1U)          //!< Bit field size in bits for SDHC_PROCTL_D3CD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PROCTL_D3CD field.
#define BR_SDHC_PROCTL_D3CD  (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_D3CD))
#endif

//! @brief Format value for bitfield SDHC_PROCTL_D3CD.
#define BF_SDHC_PROCTL_D3CD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_PROCTL_D3CD), uint32_t) & BM_SDHC_PROCTL_D3CD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the D3CD field to a new value.
#define BW_SDHC_PROCTL_D3CD(v) (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_D3CD) = (v))
#endif
//@}

/*!
 * @name Register SDHC_PROCTL, field EMODE[5:4] (RW)
 *
 * The SDHC supports all four endian modes in data transfer.
 *
 * Values:
 * - 00 - Big endian mode
 * - 01 - Half word big endian mode
 * - 10 - Little endian mode
 * - 11 - Reserved
 */
//@{
#define BP_SDHC_PROCTL_EMODE (4U)          //!< Bit position for SDHC_PROCTL_EMODE.
#define BM_SDHC_PROCTL_EMODE (0x00000030U) //!< Bit mask for SDHC_PROCTL_EMODE.
#define BS_SDHC_PROCTL_EMODE (2U)          //!< Bit field size in bits for SDHC_PROCTL_EMODE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PROCTL_EMODE field.
#define BR_SDHC_PROCTL_EMODE (HW_SDHC_PROCTL.B.EMODE)
#endif

//! @brief Format value for bitfield SDHC_PROCTL_EMODE.
#define BF_SDHC_PROCTL_EMODE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_PROCTL_EMODE), uint32_t) & BM_SDHC_PROCTL_EMODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EMODE field to a new value.
#define BW_SDHC_PROCTL_EMODE(v) (HW_SDHC_PROCTL_WR((HW_SDHC_PROCTL_RD() & ~BM_SDHC_PROCTL_EMODE) | BF_SDHC_PROCTL_EMODE(v)))
#endif
//@}

/*!
 * @name Register SDHC_PROCTL, field CDTL[6] (RW)
 *
 * Enabled while the CDSS is set to 1 and it indicates card insertion.
 *
 * Values:
 * - 0 - Card detect test level is 0, no card inserted.
 * - 1 - Card detect test level is 1, card inserted.
 */
//@{
#define BP_SDHC_PROCTL_CDTL  (6U)          //!< Bit position for SDHC_PROCTL_CDTL.
#define BM_SDHC_PROCTL_CDTL  (0x00000040U) //!< Bit mask for SDHC_PROCTL_CDTL.
#define BS_SDHC_PROCTL_CDTL  (1U)          //!< Bit field size in bits for SDHC_PROCTL_CDTL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PROCTL_CDTL field.
#define BR_SDHC_PROCTL_CDTL  (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_CDTL))
#endif

//! @brief Format value for bitfield SDHC_PROCTL_CDTL.
#define BF_SDHC_PROCTL_CDTL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_PROCTL_CDTL), uint32_t) & BM_SDHC_PROCTL_CDTL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CDTL field to a new value.
#define BW_SDHC_PROCTL_CDTL(v) (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_CDTL) = (v))
#endif
//@}

/*!
 * @name Register SDHC_PROCTL, field CDSS[7] (RW)
 *
 * Selects the source for the card detection.
 *
 * Values:
 * - 0 - Card detection level is selected for normal purpose.
 * - 1 - Card detection test level is selected for test purpose.
 */
//@{
#define BP_SDHC_PROCTL_CDSS  (7U)          //!< Bit position for SDHC_PROCTL_CDSS.
#define BM_SDHC_PROCTL_CDSS  (0x00000080U) //!< Bit mask for SDHC_PROCTL_CDSS.
#define BS_SDHC_PROCTL_CDSS  (1U)          //!< Bit field size in bits for SDHC_PROCTL_CDSS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PROCTL_CDSS field.
#define BR_SDHC_PROCTL_CDSS  (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_CDSS))
#endif

//! @brief Format value for bitfield SDHC_PROCTL_CDSS.
#define BF_SDHC_PROCTL_CDSS(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_PROCTL_CDSS), uint32_t) & BM_SDHC_PROCTL_CDSS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CDSS field to a new value.
#define BW_SDHC_PROCTL_CDSS(v) (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_CDSS) = (v))
#endif
//@}

/*!
 * @name Register SDHC_PROCTL, field DMAS[9:8] (RW)
 *
 * This field is valid while DMA (SDMA or ADMA) is enabled and selects the DMA
 * operation.
 *
 * Values:
 * - 00 - No DMA or simple DMA is selected.
 * - 01 - ADMA1 is selected.
 * - 10 - ADMA2 is selected.
 * - 11 - Reserved
 */
//@{
#define BP_SDHC_PROCTL_DMAS  (8U)          //!< Bit position for SDHC_PROCTL_DMAS.
#define BM_SDHC_PROCTL_DMAS  (0x00000300U) //!< Bit mask for SDHC_PROCTL_DMAS.
#define BS_SDHC_PROCTL_DMAS  (2U)          //!< Bit field size in bits for SDHC_PROCTL_DMAS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PROCTL_DMAS field.
#define BR_SDHC_PROCTL_DMAS  (HW_SDHC_PROCTL.B.DMAS)
#endif

//! @brief Format value for bitfield SDHC_PROCTL_DMAS.
#define BF_SDHC_PROCTL_DMAS(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_PROCTL_DMAS), uint32_t) & BM_SDHC_PROCTL_DMAS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMAS field to a new value.
#define BW_SDHC_PROCTL_DMAS(v) (HW_SDHC_PROCTL_WR((HW_SDHC_PROCTL_RD() & ~BM_SDHC_PROCTL_DMAS) | BF_SDHC_PROCTL_DMAS(v)))
#endif
//@}

/*!
 * @name Register SDHC_PROCTL, field SABGREQ[16] (RW)
 *
 * Used to stop executing a transaction at the next block gap for both DMA and
 * non-DMA transfers. Until the IRQSTATEN[TCSEN] is set to 1, indicating a
 * transfer completion, the host driver shall leave this bit set to 1. Clearing both
 * PROCTL[SABGREQ] and PROCTL[CREQ] does not cause the transaction to restart. Read
 * Wait is used to stop the read transaction at the block gap. The SDHC will
 * honor the PROCTL[SABGREQ] for write transfers, but for read transfers it requires
 * that SDIO card support read wait. Therefore, the host driver shall not set
 * this bit during read transfers unless the SDIO card supports read wait and has
 * set PROCTL[RWCTL] to 1, otherwise the SDHC will stop the SD bus clock to pause
 * the read operation during block gap. In the case of write transfers in which
 * the host driver writes data to the data port register, the host driver shall set
 * this bit after all block data is written. If this bit is set to 1, the host
 * driver shall not write data to the Data Port register after a block is sent.
 * Once this bit is set, the host driver shall not clear this bit before
 * IRQSTATEN[TCSEN] is set, otherwise the SDHC's behavior is undefined. This bit effects
 * PRSSTAT[RTA], PRSSTAT[WTA], and PRSSTAT[CDIHB].
 *
 * Values:
 * - 0 - Transfer
 * - 1 - Stop
 */
//@{
#define BP_SDHC_PROCTL_SABGREQ (16U)       //!< Bit position for SDHC_PROCTL_SABGREQ.
#define BM_SDHC_PROCTL_SABGREQ (0x00010000U) //!< Bit mask for SDHC_PROCTL_SABGREQ.
#define BS_SDHC_PROCTL_SABGREQ (1U)        //!< Bit field size in bits for SDHC_PROCTL_SABGREQ.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PROCTL_SABGREQ field.
#define BR_SDHC_PROCTL_SABGREQ (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_SABGREQ))
#endif

//! @brief Format value for bitfield SDHC_PROCTL_SABGREQ.
#define BF_SDHC_PROCTL_SABGREQ(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_PROCTL_SABGREQ), uint32_t) & BM_SDHC_PROCTL_SABGREQ)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SABGREQ field to a new value.
#define BW_SDHC_PROCTL_SABGREQ(v) (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_SABGREQ) = (v))
#endif
//@}

/*!
 * @name Register SDHC_PROCTL, field CREQ[17] (RW)
 *
 * Used to restart a transaction which was stopped using the PROCTL[SABGREQ].
 * When a suspend operation is not accepted by the card, it is also by setting this
 * bit to restart the paused transfer. To cancel stop at the block gap, set
 * PROCTL[SABGREQ] to 0 and set this bit to 1 to restart the transfer. The SDHC
 * automatically clears this bit, therefore it is not necessary for the host driver to
 * set this bit to 0. If both PROCTL[SABGREQ] and this bit are 1, the continue
 * request is ignored.
 *
 * Values:
 * - 0 - No effect.
 * - 1 - Restart
 */
//@{
#define BP_SDHC_PROCTL_CREQ  (17U)         //!< Bit position for SDHC_PROCTL_CREQ.
#define BM_SDHC_PROCTL_CREQ  (0x00020000U) //!< Bit mask for SDHC_PROCTL_CREQ.
#define BS_SDHC_PROCTL_CREQ  (1U)          //!< Bit field size in bits for SDHC_PROCTL_CREQ.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PROCTL_CREQ field.
#define BR_SDHC_PROCTL_CREQ  (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_CREQ))
#endif

//! @brief Format value for bitfield SDHC_PROCTL_CREQ.
#define BF_SDHC_PROCTL_CREQ(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_PROCTL_CREQ), uint32_t) & BM_SDHC_PROCTL_CREQ)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CREQ field to a new value.
#define BW_SDHC_PROCTL_CREQ(v) (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_CREQ) = (v))
#endif
//@}

/*!
 * @name Register SDHC_PROCTL, field RWCTL[18] (RW)
 *
 * The read wait function is optional for SDIO cards. If the card supports read
 * wait, set this bit to enable use of the read wait protocol to stop read data
 * using the DAT[2] line. Otherwise, the SDHC has to stop the SD Clock to hold
 * read data, which restricts commands generation. When the host driver detects an
 * SDIO card insertion, it shall set this bit according to the CCCR of the card.
 * If the card does not support read wait, this bit shall never be set to 1,
 * otherwise DAT line conflicts may occur. If this bit is set to 0, stop at block gap
 * during read operation is also supported, but the SDHC will stop the SD Clock
 * to pause reading operation.
 *
 * Values:
 * - 0 - Disable read wait control, and stop SD clock at block gap when SABGREQ
 *     is set.
 * - 1 - Enable read wait control, and assert read wait without stopping SD
 *     clock at block gap when SABGREQ bit is set.
 */
//@{
#define BP_SDHC_PROCTL_RWCTL (18U)         //!< Bit position for SDHC_PROCTL_RWCTL.
#define BM_SDHC_PROCTL_RWCTL (0x00040000U) //!< Bit mask for SDHC_PROCTL_RWCTL.
#define BS_SDHC_PROCTL_RWCTL (1U)          //!< Bit field size in bits for SDHC_PROCTL_RWCTL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PROCTL_RWCTL field.
#define BR_SDHC_PROCTL_RWCTL (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_RWCTL))
#endif

//! @brief Format value for bitfield SDHC_PROCTL_RWCTL.
#define BF_SDHC_PROCTL_RWCTL(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_PROCTL_RWCTL), uint32_t) & BM_SDHC_PROCTL_RWCTL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RWCTL field to a new value.
#define BW_SDHC_PROCTL_RWCTL(v) (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_RWCTL) = (v))
#endif
//@}

/*!
 * @name Register SDHC_PROCTL, field IABG[19] (RW)
 *
 * Valid only in 4-bit mode, of the SDIO card, and selects a sample point in the
 * interrupt cycle. Setting to 1 enables interrupt detection at the block gap
 * for a multiple block transfer. Setting to 0 disables interrupt detection during
 * a multiple block transfer. If the SDIO card can't signal an interrupt during a
 * multiple block transfer, this bit must be set to 0 to avoid an inadvertent
 * interrupt. When the host driver detects an SDIO card insertion, it shall set
 * this bit according to the CCCR of the card.
 *
 * Values:
 * - 0 - Disabled
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_PROCTL_IABG  (19U)         //!< Bit position for SDHC_PROCTL_IABG.
#define BM_SDHC_PROCTL_IABG  (0x00080000U) //!< Bit mask for SDHC_PROCTL_IABG.
#define BS_SDHC_PROCTL_IABG  (1U)          //!< Bit field size in bits for SDHC_PROCTL_IABG.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PROCTL_IABG field.
#define BR_SDHC_PROCTL_IABG  (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_IABG))
#endif

//! @brief Format value for bitfield SDHC_PROCTL_IABG.
#define BF_SDHC_PROCTL_IABG(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_PROCTL_IABG), uint32_t) & BM_SDHC_PROCTL_IABG)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IABG field to a new value.
#define BW_SDHC_PROCTL_IABG(v) (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_IABG) = (v))
#endif
//@}

/*!
 * @name Register SDHC_PROCTL, field WECINT[24] (RW)
 *
 * Enables a wakeup event, via IRQSTAT[CINT]. This bit can be set to 1 if FN_WUS
 * (Wake Up Support) in CIS is set to 1. When this bit is set, the card
 * interrupt status and the SDHC interrupt can be asserted without SD_CLK toggling. When
 * the wakeup feature is not enabled, the SD_CLK must be active to assert the
 * card interrupt status and the SDHC interrupt.
 *
 * Values:
 * - 0 - Disabled
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_PROCTL_WECINT (24U)        //!< Bit position for SDHC_PROCTL_WECINT.
#define BM_SDHC_PROCTL_WECINT (0x01000000U) //!< Bit mask for SDHC_PROCTL_WECINT.
#define BS_SDHC_PROCTL_WECINT (1U)         //!< Bit field size in bits for SDHC_PROCTL_WECINT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PROCTL_WECINT field.
#define BR_SDHC_PROCTL_WECINT (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_WECINT))
#endif

//! @brief Format value for bitfield SDHC_PROCTL_WECINT.
#define BF_SDHC_PROCTL_WECINT(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_PROCTL_WECINT), uint32_t) & BM_SDHC_PROCTL_WECINT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WECINT field to a new value.
#define BW_SDHC_PROCTL_WECINT(v) (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_WECINT) = (v))
#endif
//@}

/*!
 * @name Register SDHC_PROCTL, field WECINS[25] (RW)
 *
 * Enables a wakeup event, via IRQSTAT[CINS]. FN_WUS (Wake Up Support) in CIS
 * does not effect this bit. When this bit is set, IRQSTATEN[CINSEN] and the SDHC
 * interrupt can be asserted without SD_CLK toggling. When the wakeup feature is
 * not enabled, the SD_CLK must be active to assert IRQSTATEN[CINSEN] and the SDHC
 * interrupt.
 *
 * Values:
 * - 0 - Disabled
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_PROCTL_WECINS (25U)        //!< Bit position for SDHC_PROCTL_WECINS.
#define BM_SDHC_PROCTL_WECINS (0x02000000U) //!< Bit mask for SDHC_PROCTL_WECINS.
#define BS_SDHC_PROCTL_WECINS (1U)         //!< Bit field size in bits for SDHC_PROCTL_WECINS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PROCTL_WECINS field.
#define BR_SDHC_PROCTL_WECINS (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_WECINS))
#endif

//! @brief Format value for bitfield SDHC_PROCTL_WECINS.
#define BF_SDHC_PROCTL_WECINS(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_PROCTL_WECINS), uint32_t) & BM_SDHC_PROCTL_WECINS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WECINS field to a new value.
#define BW_SDHC_PROCTL_WECINS(v) (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_WECINS) = (v))
#endif
//@}

/*!
 * @name Register SDHC_PROCTL, field WECRM[26] (RW)
 *
 * Enables a wakeup event, via IRQSTAT[CRM]. FN_WUS (Wake Up Support) in CIS
 * does not effect this bit. When this bit is set, IRQSTAT[CRM] and the SDHC
 * interrupt can be asserted without SD_CLK toggling. When the wakeup feature is not
 * enabled, the SD_CLK must be active to assert IRQSTAT[CRM] and the SDHC interrupt.
 *
 * Values:
 * - 0 - Disabled
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_PROCTL_WECRM (26U)         //!< Bit position for SDHC_PROCTL_WECRM.
#define BM_SDHC_PROCTL_WECRM (0x04000000U) //!< Bit mask for SDHC_PROCTL_WECRM.
#define BS_SDHC_PROCTL_WECRM (1U)          //!< Bit field size in bits for SDHC_PROCTL_WECRM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_PROCTL_WECRM field.
#define BR_SDHC_PROCTL_WECRM (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_WECRM))
#endif

//! @brief Format value for bitfield SDHC_PROCTL_WECRM.
#define BF_SDHC_PROCTL_WECRM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_PROCTL_WECRM), uint32_t) & BM_SDHC_PROCTL_WECRM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WECRM field to a new value.
#define BW_SDHC_PROCTL_WECRM(v) (BITBAND_ACCESS32(HW_SDHC_PROCTL_ADDR, BP_SDHC_PROCTL_WECRM) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_SYSCTL - System Control register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_SYSCTL - System Control register (RW)
 *
 * Reset value: 0x00008008U
 */
typedef union _hw_sdhc_sysctl
{
    uint32_t U;
    struct _hw_sdhc_sysctl_bitfields
    {
        uint32_t IPGEN : 1;            //!< [0] IPG Clock Enable
        uint32_t HCKEN : 1;            //!< [1] System Clock Enable
        uint32_t PEREN : 1;            //!< [2] Peripheral Clock Enable
        uint32_t SDCLKEN : 1;          //!< [3] SD Clock Enable
        uint32_t DVS : 4;              //!< [7:4] Divisor
        uint32_t SDCLKFS : 8;          //!< [15:8] SDCLK Frequency Select
        uint32_t DTOCV : 4;            //!< [19:16] Data Timeout Counter Value
        uint32_t RESERVED0 : 4;        //!< [23:20]
        uint32_t RSTA : 1;             //!< [24] Software Reset For ALL
        uint32_t RSTC : 1;             //!< [25] Software Reset For CMD Line
        uint32_t RSTD : 1;             //!< [26] Software Reset For DAT Line
        uint32_t INITA : 1;            //!< [27] Initialization Active
        uint32_t RESERVED1 : 4;        //!< [31:28]
    } B;
} hw_sdhc_sysctl_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_SYSCTL register
 */
//@{
#define HW_SDHC_SYSCTL_ADDR      (REGS_SDHC_BASE + 0x2CU)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_SYSCTL           (*(__IO hw_sdhc_sysctl_t *) HW_SDHC_SYSCTL_ADDR)
#define HW_SDHC_SYSCTL_RD()      (HW_SDHC_SYSCTL.U)
#define HW_SDHC_SYSCTL_WR(v)     (HW_SDHC_SYSCTL.U = (v))
#define HW_SDHC_SYSCTL_SET(v)    (HW_SDHC_SYSCTL_WR(HW_SDHC_SYSCTL_RD() |  (v)))
#define HW_SDHC_SYSCTL_CLR(v)    (HW_SDHC_SYSCTL_WR(HW_SDHC_SYSCTL_RD() & ~(v)))
#define HW_SDHC_SYSCTL_TOG(v)    (HW_SDHC_SYSCTL_WR(HW_SDHC_SYSCTL_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SDHC_SYSCTL bitfields
 */

/*!
 * @name Register SDHC_SYSCTL, field IPGEN[0] (RW)
 *
 * If this bit is set, bus clock will always be active and no automatic gating
 * is applied. The bus clock will be internally gated off, if none of the
 * following factors are met: The cmd part is reset, or Data part is reset, or Soft
 * reset, or The cmd is about to send, or Clock divisor is just updated, or Continue
 * request is just set, or This bit is set, or Card insertion is detected, or Card
 * removal is detected, or Card external interrupt is detected, or The SDHC
 * clock is not gated off The bus clock will not be auto gated off if the SDHC clock
 * is not gated off. So clearing only this bit has no effect unless the PEREN bit
 * is also cleared.
 *
 * Values:
 * - 0 - Bus clock will be internally gated off.
 * - 1 - Bus clock will not be automatically gated off.
 */
//@{
#define BP_SDHC_SYSCTL_IPGEN (0U)          //!< Bit position for SDHC_SYSCTL_IPGEN.
#define BM_SDHC_SYSCTL_IPGEN (0x00000001U) //!< Bit mask for SDHC_SYSCTL_IPGEN.
#define BS_SDHC_SYSCTL_IPGEN (1U)          //!< Bit field size in bits for SDHC_SYSCTL_IPGEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_SYSCTL_IPGEN field.
#define BR_SDHC_SYSCTL_IPGEN (BITBAND_ACCESS32(HW_SDHC_SYSCTL_ADDR, BP_SDHC_SYSCTL_IPGEN))
#endif

//! @brief Format value for bitfield SDHC_SYSCTL_IPGEN.
#define BF_SDHC_SYSCTL_IPGEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_SYSCTL_IPGEN), uint32_t) & BM_SDHC_SYSCTL_IPGEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IPGEN field to a new value.
#define BW_SDHC_SYSCTL_IPGEN(v) (BITBAND_ACCESS32(HW_SDHC_SYSCTL_ADDR, BP_SDHC_SYSCTL_IPGEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_SYSCTL, field HCKEN[1] (RW)
 *
 * If this bit is set, system clock will always be active and no automatic
 * gating is applied. When this bit is cleared, system clock will be automatically off
 * when no data transfer is on the SD bus.
 *
 * Values:
 * - 0 - System clock will be internally gated off.
 * - 1 - System clock will not be automatically gated off.
 */
//@{
#define BP_SDHC_SYSCTL_HCKEN (1U)          //!< Bit position for SDHC_SYSCTL_HCKEN.
#define BM_SDHC_SYSCTL_HCKEN (0x00000002U) //!< Bit mask for SDHC_SYSCTL_HCKEN.
#define BS_SDHC_SYSCTL_HCKEN (1U)          //!< Bit field size in bits for SDHC_SYSCTL_HCKEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_SYSCTL_HCKEN field.
#define BR_SDHC_SYSCTL_HCKEN (BITBAND_ACCESS32(HW_SDHC_SYSCTL_ADDR, BP_SDHC_SYSCTL_HCKEN))
#endif

//! @brief Format value for bitfield SDHC_SYSCTL_HCKEN.
#define BF_SDHC_SYSCTL_HCKEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_SYSCTL_HCKEN), uint32_t) & BM_SDHC_SYSCTL_HCKEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the HCKEN field to a new value.
#define BW_SDHC_SYSCTL_HCKEN(v) (BITBAND_ACCESS32(HW_SDHC_SYSCTL_ADDR, BP_SDHC_SYSCTL_HCKEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_SYSCTL, field PEREN[2] (RW)
 *
 * If this bit is set, SDHC clock will always be active and no automatic gating
 * is applied. Thus the SDCLK is active except for when auto gating-off during
 * buffer danger (buffer about to over-run or under-run). When this bit is cleared,
 * the SDHC clock will be automatically off whenever there is no transaction on
 * the SD bus. Because this bit is only a feature enabling bit, clearing this bit
 * does not stop SDCLK immediately. The SDHC clock will be internally gated off,
 * if none of the following factors are met: The cmd part is reset, or Data part
 * is reset, or A soft reset, or The cmd is about to send, or Clock divisor is
 * just updated, or Continue request is just set, or This bit is set, or Card
 * insertion is detected, or Card removal is detected, or Card external interrupt is
 * detected, or 80 clocks for initialization phase is ongoing
 *
 * Values:
 * - 0 - SDHC clock will be internally gated off.
 * - 1 - SDHC clock will not be automatically gated off.
 */
//@{
#define BP_SDHC_SYSCTL_PEREN (2U)          //!< Bit position for SDHC_SYSCTL_PEREN.
#define BM_SDHC_SYSCTL_PEREN (0x00000004U) //!< Bit mask for SDHC_SYSCTL_PEREN.
#define BS_SDHC_SYSCTL_PEREN (1U)          //!< Bit field size in bits for SDHC_SYSCTL_PEREN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_SYSCTL_PEREN field.
#define BR_SDHC_SYSCTL_PEREN (BITBAND_ACCESS32(HW_SDHC_SYSCTL_ADDR, BP_SDHC_SYSCTL_PEREN))
#endif

//! @brief Format value for bitfield SDHC_SYSCTL_PEREN.
#define BF_SDHC_SYSCTL_PEREN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_SYSCTL_PEREN), uint32_t) & BM_SDHC_SYSCTL_PEREN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PEREN field to a new value.
#define BW_SDHC_SYSCTL_PEREN(v) (BITBAND_ACCESS32(HW_SDHC_SYSCTL_ADDR, BP_SDHC_SYSCTL_PEREN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_SYSCTL, field SDCLKEN[3] (RW)
 *
 * The host controller shall stop SDCLK when writing this bit to 0. SDCLK
 * frequency can be changed when this bit is 0. Then, the host controller shall
 * maintain the same clock frequency until SDCLK is stopped (stop at SDCLK = 0). If the
 * IRQSTAT[CINS] is cleared, this bit must be cleared by the host driver to save
 * power.
 */
//@{
#define BP_SDHC_SYSCTL_SDCLKEN (3U)        //!< Bit position for SDHC_SYSCTL_SDCLKEN.
#define BM_SDHC_SYSCTL_SDCLKEN (0x00000008U) //!< Bit mask for SDHC_SYSCTL_SDCLKEN.
#define BS_SDHC_SYSCTL_SDCLKEN (1U)        //!< Bit field size in bits for SDHC_SYSCTL_SDCLKEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_SYSCTL_SDCLKEN field.
#define BR_SDHC_SYSCTL_SDCLKEN (BITBAND_ACCESS32(HW_SDHC_SYSCTL_ADDR, BP_SDHC_SYSCTL_SDCLKEN))
#endif

//! @brief Format value for bitfield SDHC_SYSCTL_SDCLKEN.
#define BF_SDHC_SYSCTL_SDCLKEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_SYSCTL_SDCLKEN), uint32_t) & BM_SDHC_SYSCTL_SDCLKEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SDCLKEN field to a new value.
#define BW_SDHC_SYSCTL_SDCLKEN(v) (BITBAND_ACCESS32(HW_SDHC_SYSCTL_ADDR, BP_SDHC_SYSCTL_SDCLKEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_SYSCTL, field DVS[7:4] (RW)
 *
 * Used to provide a more exact divisor to generate the desired SD clock
 * frequency. Note the divider can even support odd divisor without deterioration of
 * duty cycle. The setting are as following:
 *
 * Values:
 * - 0 - Divisor by 1.
 * - 1 - Divisor by 2.
 * - 1110 - Divisor by 15.
 * - 1111 - Divisor by 16.
 */
//@{
#define BP_SDHC_SYSCTL_DVS   (4U)          //!< Bit position for SDHC_SYSCTL_DVS.
#define BM_SDHC_SYSCTL_DVS   (0x000000F0U) //!< Bit mask for SDHC_SYSCTL_DVS.
#define BS_SDHC_SYSCTL_DVS   (4U)          //!< Bit field size in bits for SDHC_SYSCTL_DVS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_SYSCTL_DVS field.
#define BR_SDHC_SYSCTL_DVS   (HW_SDHC_SYSCTL.B.DVS)
#endif

//! @brief Format value for bitfield SDHC_SYSCTL_DVS.
#define BF_SDHC_SYSCTL_DVS(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_SYSCTL_DVS), uint32_t) & BM_SDHC_SYSCTL_DVS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DVS field to a new value.
#define BW_SDHC_SYSCTL_DVS(v) (HW_SDHC_SYSCTL_WR((HW_SDHC_SYSCTL_RD() & ~BM_SDHC_SYSCTL_DVS) | BF_SDHC_SYSCTL_DVS(v)))
#endif
//@}

/*!
 * @name Register SDHC_SYSCTL, field SDCLKFS[15:8] (RW)
 *
 * Used to select the frequency of the SDCLK pin. The frequency is not
 * programmed directly. Rather this register holds the prescaler (this register) and
 * divisor (next register) of the base clock frequency register. Setting 00h bypasses
 * the frequency prescaler of the SD Clock. Multiple bits must not be set, or the
 * behavior of this prescaler is undefined. The two default divider values can
 * be calculated by the frequency of SDHC clock and the following divisor bits.
 * The frequency of SDCLK is set by the following formula: Clock frequency = (Base
 * clock) / (prescaler x divisor) For example, if the base clock frequency is 96
 * MHz, and the target frequency is 25 MHz, then choosing the prescaler value of
 * 01h and divisor value of 1h will yield 24 MHz, which is the nearest frequency
 * less than or equal to the target. Similarly, to approach a clock value of 400
 * kHz, the prescaler value of 08h and divisor value of eh yields the exact clock
 * value of 400 kHz. The reset value of this field is 80h, so if the input base
 * clock ( SDHC clock ) is about 96 MHz, the default SD clock after reset is 375
 * kHz. According to the SD Physical Specification Version 1.1 and the SDIO Card
 * Specification Version 1.2, the maximum SD clock frequency is 50 MHz and shall
 * never exceed this limit. Only the following settings are allowed:
 *
 * Values:
 * - 1 - Base clock divided by 2.
 * - 10 - Base clock divided by 4.
 * - 100 - Base clock divided by 8.
 * - 1000 - Base clock divided by 16.
 * - 10000 - Base clock divided by 32.
 * - 100000 - Base clock divided by 64.
 * - 1000000 - Base clock divided by 128.
 * - 10000000 - Base clock divided by 256.
 */
//@{
#define BP_SDHC_SYSCTL_SDCLKFS (8U)        //!< Bit position for SDHC_SYSCTL_SDCLKFS.
#define BM_SDHC_SYSCTL_SDCLKFS (0x0000FF00U) //!< Bit mask for SDHC_SYSCTL_SDCLKFS.
#define BS_SDHC_SYSCTL_SDCLKFS (8U)        //!< Bit field size in bits for SDHC_SYSCTL_SDCLKFS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_SYSCTL_SDCLKFS field.
#define BR_SDHC_SYSCTL_SDCLKFS (HW_SDHC_SYSCTL.B.SDCLKFS)
#endif

//! @brief Format value for bitfield SDHC_SYSCTL_SDCLKFS.
#define BF_SDHC_SYSCTL_SDCLKFS(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_SYSCTL_SDCLKFS), uint32_t) & BM_SDHC_SYSCTL_SDCLKFS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SDCLKFS field to a new value.
#define BW_SDHC_SYSCTL_SDCLKFS(v) (HW_SDHC_SYSCTL_WR((HW_SDHC_SYSCTL_RD() & ~BM_SDHC_SYSCTL_SDCLKFS) | BF_SDHC_SYSCTL_SDCLKFS(v)))
#endif
//@}

/*!
 * @name Register SDHC_SYSCTL, field DTOCV[19:16] (RW)
 *
 * Determines the interval by which DAT line timeouts are detected. See
 * IRQSTAT[DTOE] for information on factors that dictate time-out generation. Time-out
 * clock frequency will be generated by dividing the base clock SDCLK value by this
 * value. The host driver can clear IRQSTATEN[DTOESEN] to prevent inadvertent
 * time-out events.
 *
 * Values:
 * - 0000 - SDCLK x 2 13
 * - 0001 - SDCLK x 2 14
 * - 1110 - SDCLK x 2 27
 * - 1111 - Reserved
 */
//@{
#define BP_SDHC_SYSCTL_DTOCV (16U)         //!< Bit position for SDHC_SYSCTL_DTOCV.
#define BM_SDHC_SYSCTL_DTOCV (0x000F0000U) //!< Bit mask for SDHC_SYSCTL_DTOCV.
#define BS_SDHC_SYSCTL_DTOCV (4U)          //!< Bit field size in bits for SDHC_SYSCTL_DTOCV.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_SYSCTL_DTOCV field.
#define BR_SDHC_SYSCTL_DTOCV (HW_SDHC_SYSCTL.B.DTOCV)
#endif

//! @brief Format value for bitfield SDHC_SYSCTL_DTOCV.
#define BF_SDHC_SYSCTL_DTOCV(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_SYSCTL_DTOCV), uint32_t) & BM_SDHC_SYSCTL_DTOCV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DTOCV field to a new value.
#define BW_SDHC_SYSCTL_DTOCV(v) (HW_SDHC_SYSCTL_WR((HW_SDHC_SYSCTL_RD() & ~BM_SDHC_SYSCTL_DTOCV) | BF_SDHC_SYSCTL_DTOCV(v)))
#endif
//@}

/*!
 * @name Register SDHC_SYSCTL, field RSTA[24] (WORZ)
 *
 * Effects the entire host controller except for the card detection circuit.
 * Register bits of type ROC, RW, RW1C, RWAC are cleared. During its initialization,
 * the host driver shall set this bit to 1 to reset the SDHC. The SDHC shall
 * reset this bit to 0 when the capabilities registers are valid and the host driver
 * can read them. Additional use of software reset for all does not affect the
 * value of the capabilities registers. After this bit is set, it is recommended
 * that the host driver reset the external card and reinitialize it.
 *
 * Values:
 * - 0 - No reset.
 * - 1 - Reset.
 */
//@{
#define BP_SDHC_SYSCTL_RSTA  (24U)         //!< Bit position for SDHC_SYSCTL_RSTA.
#define BM_SDHC_SYSCTL_RSTA  (0x01000000U) //!< Bit mask for SDHC_SYSCTL_RSTA.
#define BS_SDHC_SYSCTL_RSTA  (1U)          //!< Bit field size in bits for SDHC_SYSCTL_RSTA.

//! @brief Format value for bitfield SDHC_SYSCTL_RSTA.
#define BF_SDHC_SYSCTL_RSTA(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_SYSCTL_RSTA), uint32_t) & BM_SDHC_SYSCTL_RSTA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RSTA field to a new value.
#define BW_SDHC_SYSCTL_RSTA(v) (BITBAND_ACCESS32(HW_SDHC_SYSCTL_ADDR, BP_SDHC_SYSCTL_RSTA) = (v))
#endif
//@}

/*!
 * @name Register SDHC_SYSCTL, field RSTC[25] (WORZ)
 *
 * Only part of the command circuit is reset. The following registers and bits
 * are cleared by this bit: PRSSTAT[CIHB] IRQSTAT[CC]
 *
 * Values:
 * - 0 - No reset.
 * - 1 - Reset.
 */
//@{
#define BP_SDHC_SYSCTL_RSTC  (25U)         //!< Bit position for SDHC_SYSCTL_RSTC.
#define BM_SDHC_SYSCTL_RSTC  (0x02000000U) //!< Bit mask for SDHC_SYSCTL_RSTC.
#define BS_SDHC_SYSCTL_RSTC  (1U)          //!< Bit field size in bits for SDHC_SYSCTL_RSTC.

//! @brief Format value for bitfield SDHC_SYSCTL_RSTC.
#define BF_SDHC_SYSCTL_RSTC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_SYSCTL_RSTC), uint32_t) & BM_SDHC_SYSCTL_RSTC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RSTC field to a new value.
#define BW_SDHC_SYSCTL_RSTC(v) (BITBAND_ACCESS32(HW_SDHC_SYSCTL_ADDR, BP_SDHC_SYSCTL_RSTC) = (v))
#endif
//@}

/*!
 * @name Register SDHC_SYSCTL, field RSTD[26] (WORZ)
 *
 * Only part of the data circuit is reset. DMA circuit is also reset. The
 * following registers and bits are cleared by this bit: Data Port register Buffer Is
 * Cleared And Initialized.Present State register Buffer Read Enable Buffer Write
 * Enable Read Transfer Active Write Transfer Active DAT Line Active Command
 * Inhibit (DAT) Protocol Control register Continue Request Stop At Block Gap Request
 * Interrupt Status register Buffer Read Ready Buffer Write Ready DMA Interrupt
 * Block Gap Event Transfer Complete
 *
 * Values:
 * - 0 - No reset.
 * - 1 - Reset.
 */
//@{
#define BP_SDHC_SYSCTL_RSTD  (26U)         //!< Bit position for SDHC_SYSCTL_RSTD.
#define BM_SDHC_SYSCTL_RSTD  (0x04000000U) //!< Bit mask for SDHC_SYSCTL_RSTD.
#define BS_SDHC_SYSCTL_RSTD  (1U)          //!< Bit field size in bits for SDHC_SYSCTL_RSTD.

//! @brief Format value for bitfield SDHC_SYSCTL_RSTD.
#define BF_SDHC_SYSCTL_RSTD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_SYSCTL_RSTD), uint32_t) & BM_SDHC_SYSCTL_RSTD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RSTD field to a new value.
#define BW_SDHC_SYSCTL_RSTD(v) (BITBAND_ACCESS32(HW_SDHC_SYSCTL_ADDR, BP_SDHC_SYSCTL_RSTD) = (v))
#endif
//@}

/*!
 * @name Register SDHC_SYSCTL, field INITA[27] (RW)
 *
 * When this bit is set, 80 SD-clocks are sent to the card. After the 80 clocks
 * are sent, this bit is self-cleared. This bit is very useful during the card
 * power-up period when 74 SD-clocks are needed and the clock auto gating feature
 * is enabled. Writing 1 to this bit when this bit is already 1 has no effect.
 * Writing 0 to this bit at any time has no effect. When either of the PRSSTAT[CIHB]
 * and PRSSTAT[CDIHB] bits are set, writing 1 to this bit is ignored, that is,
 * when command line or data lines are active, write to this bit is not allowed.
 * On the otherhand, when this bit is set, that is, during intialization active
 * period, it is allowed to issue command, and the command bit stream will appear
 * on the CMD pad after all 80 clock cycles are done. So when this command ends,
 * the driver can make sure the 80 clock cycles are sent out. This is very useful
 * when the driver needs send 80 cycles to the card and does not want to wait
 * till this bit is self-cleared.
 */
//@{
#define BP_SDHC_SYSCTL_INITA (27U)         //!< Bit position for SDHC_SYSCTL_INITA.
#define BM_SDHC_SYSCTL_INITA (0x08000000U) //!< Bit mask for SDHC_SYSCTL_INITA.
#define BS_SDHC_SYSCTL_INITA (1U)          //!< Bit field size in bits for SDHC_SYSCTL_INITA.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_SYSCTL_INITA field.
#define BR_SDHC_SYSCTL_INITA (BITBAND_ACCESS32(HW_SDHC_SYSCTL_ADDR, BP_SDHC_SYSCTL_INITA))
#endif

//! @brief Format value for bitfield SDHC_SYSCTL_INITA.
#define BF_SDHC_SYSCTL_INITA(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_SYSCTL_INITA), uint32_t) & BM_SDHC_SYSCTL_INITA)

#ifndef __LANGUAGE_ASM__
//! @brief Set the INITA field to a new value.
#define BW_SDHC_SYSCTL_INITA(v) (BITBAND_ACCESS32(HW_SDHC_SYSCTL_ADDR, BP_SDHC_SYSCTL_INITA) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_IRQSTAT - Interrupt Status register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_IRQSTAT - Interrupt Status register (RW)
 *
 * Reset value: 0x00000000U
 *
 * An interrupt is generated when the Normal Interrupt Signal Enable is enabled
 * and at least one of the status bits is set to 1. For all bits, writing 1 to a
 * bit clears it; writing to 0 keeps the bit unchanged. More than one status can
 * be cleared with a single register write. For Card Interrupt, before writing 1
 * to clear, it is required that the card stops asserting the interrupt, meaning
 * that when the Card Driver services the interrupt condition, otherwise the CINT
 * bit will be asserted again. The table below shows the relationship between
 * the CTOE and the CC bits. SDHC status for CTOE/CC bit combinations Command
 * complete Command timeout error Meaning of the status 0 0 X X 1 Response not
 * received within 64 SDCLK cycles 1 0 Response received The table below shows the
 * relationship between the Transfer Complete and the Data Timeout Error. SDHC status
 * for data timeout error/transfer complete bit combinations Transfer complete
 * Data timeout error Meaning of the status 0 0 X 0 1 Timeout occurred during
 * transfer 1 X Data transfer complete The table below shows the relationship between
 * the command CRC Error (CCE) and Command Timeout Error (CTOE). SDHC status for
 * CCE/CTOE Bit Combinations Command complete Command timeout error Meaning of
 * the status 0 0 No error 0 1 Response timeout error 1 0 Response CRC error 1 1
 * CMD line conflict
 */
typedef union _hw_sdhc_irqstat
{
    uint32_t U;
    struct _hw_sdhc_irqstat_bitfields
    {
        uint32_t CC : 1;               //!< [0] Command Complete
        uint32_t TC : 1;               //!< [1] Transfer Complete
        uint32_t BGE : 1;              //!< [2] Block Gap Event
        uint32_t DINT : 1;             //!< [3] DMA Interrupt
        uint32_t BWR : 1;              //!< [4] Buffer Write Ready
        uint32_t BRR : 1;              //!< [5] Buffer Read Ready
        uint32_t CINS : 1;             //!< [6] Card Insertion
        uint32_t CRM : 1;              //!< [7] Card Removal
        uint32_t CINT : 1;             //!< [8] Card Interrupt
        uint32_t RESERVED0 : 7;        //!< [15:9]
        uint32_t CTOE : 1;             //!< [16] Command Timeout Error
        uint32_t CCE : 1;              //!< [17] Command CRC Error
        uint32_t CEBE : 1;             //!< [18] Command End Bit Error
        uint32_t CIE : 1;              //!< [19] Command Index Error
        uint32_t DTOE : 1;             //!< [20] Data Timeout Error
        uint32_t DCE : 1;              //!< [21] Data CRC Error
        uint32_t DEBE : 1;             //!< [22] Data End Bit Error
        uint32_t RESERVED1 : 1;        //!< [23]
        uint32_t AC12E : 1;            //!< [24] Auto CMD12 Error
        uint32_t RESERVED2 : 3;        //!< [27:25]
        uint32_t DMAE : 1;             //!< [28] DMA Error
        uint32_t RESERVED3 : 3;        //!< [31:29]
    } B;
} hw_sdhc_irqstat_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_IRQSTAT register
 */
//@{
#define HW_SDHC_IRQSTAT_ADDR     (REGS_SDHC_BASE + 0x30U)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_IRQSTAT          (*(__IO hw_sdhc_irqstat_t *) HW_SDHC_IRQSTAT_ADDR)
#define HW_SDHC_IRQSTAT_RD()     (HW_SDHC_IRQSTAT.U)
#define HW_SDHC_IRQSTAT_WR(v)    (HW_SDHC_IRQSTAT.U = (v))
#define HW_SDHC_IRQSTAT_SET(v)   (HW_SDHC_IRQSTAT_WR(HW_SDHC_IRQSTAT_RD() |  (v)))
#define HW_SDHC_IRQSTAT_CLR(v)   (HW_SDHC_IRQSTAT_WR(HW_SDHC_IRQSTAT_RD() & ~(v)))
#define HW_SDHC_IRQSTAT_TOG(v)   (HW_SDHC_IRQSTAT_WR(HW_SDHC_IRQSTAT_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SDHC_IRQSTAT bitfields
 */

/*!
 * @name Register SDHC_IRQSTAT, field CC[0] (W1C)
 *
 * This bit is set when you receive the end bit of the command response, except
 * Auto CMD12. See PRSSTAT[CIHB].
 *
 * Values:
 * - 0 - Command not complete.
 * - 1 - Command complete.
 */
//@{
#define BP_SDHC_IRQSTAT_CC   (0U)          //!< Bit position for SDHC_IRQSTAT_CC.
#define BM_SDHC_IRQSTAT_CC   (0x00000001U) //!< Bit mask for SDHC_IRQSTAT_CC.
#define BS_SDHC_IRQSTAT_CC   (1U)          //!< Bit field size in bits for SDHC_IRQSTAT_CC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTAT_CC field.
#define BR_SDHC_IRQSTAT_CC   (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_CC))
#endif

//! @brief Format value for bitfield SDHC_IRQSTAT_CC.
#define BF_SDHC_IRQSTAT_CC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTAT_CC), uint32_t) & BM_SDHC_IRQSTAT_CC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CC field to a new value.
#define BW_SDHC_IRQSTAT_CC(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_CC) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTAT, field TC[1] (W1C)
 *
 * This bit is set when a read or write transfer is completed. In the case of a
 * read transaction: This bit is set at the falling edge of the read transfer
 * active status. There are two cases in which this interrupt is generated. The
 * first is when a data transfer is completed as specified by the data length, after
 * the last data has been read to the host system. The second is when data has
 * stopped at the block gap and completed the data transfer by setting
 * PROCTL[SABGREQ], after valid data has been read to the host system. In the case of a write
 * transaction: This bit is set at the falling edge of the DAT line active
 * status. There are two cases in which this interrupt is generated. The first is when
 * the last data is written to the SD card as specified by the data length and
 * the busy signal is released. The second is when data transfers are stopped at
 * the block gap, by setting PROCTL[SABGREQ], and the data transfers are
 * completed,after valid data is written to the SD card and the busy signal released.
 *
 * Values:
 * - 0 - Transfer not complete.
 * - 1 - Transfer complete.
 */
//@{
#define BP_SDHC_IRQSTAT_TC   (1U)          //!< Bit position for SDHC_IRQSTAT_TC.
#define BM_SDHC_IRQSTAT_TC   (0x00000002U) //!< Bit mask for SDHC_IRQSTAT_TC.
#define BS_SDHC_IRQSTAT_TC   (1U)          //!< Bit field size in bits for SDHC_IRQSTAT_TC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTAT_TC field.
#define BR_SDHC_IRQSTAT_TC   (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_TC))
#endif

//! @brief Format value for bitfield SDHC_IRQSTAT_TC.
#define BF_SDHC_IRQSTAT_TC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTAT_TC), uint32_t) & BM_SDHC_IRQSTAT_TC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TC field to a new value.
#define BW_SDHC_IRQSTAT_TC(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_TC) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTAT, field BGE[2] (W1C)
 *
 * If PROCTL[SABGREQ] is set, this bit is set when a read or write transaction
 * is stopped at a block gap. If PROCTL[SABGREQ] is not set to 1, this bit is not
 * set to 1. In the case of a read transaction: This bit is set at the falling
 * edge of the DAT line active status, when the transaction is stopped at SD Bus
 * timing. The read wait must be supported in order to use this function. In the
 * case of write transaction: This bit is set at the falling edge of write transfer
 * active status, after getting CRC status at SD bus timing.
 *
 * Values:
 * - 0 - No block gap event.
 * - 1 - Transaction stopped at block gap.
 */
//@{
#define BP_SDHC_IRQSTAT_BGE  (2U)          //!< Bit position for SDHC_IRQSTAT_BGE.
#define BM_SDHC_IRQSTAT_BGE  (0x00000004U) //!< Bit mask for SDHC_IRQSTAT_BGE.
#define BS_SDHC_IRQSTAT_BGE  (1U)          //!< Bit field size in bits for SDHC_IRQSTAT_BGE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTAT_BGE field.
#define BR_SDHC_IRQSTAT_BGE  (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_BGE))
#endif

//! @brief Format value for bitfield SDHC_IRQSTAT_BGE.
#define BF_SDHC_IRQSTAT_BGE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTAT_BGE), uint32_t) & BM_SDHC_IRQSTAT_BGE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BGE field to a new value.
#define BW_SDHC_IRQSTAT_BGE(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_BGE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTAT, field DINT[3] (W1C)
 *
 * Occurs only when the internal DMA finishes the data transfer successfully.
 * Whenever errors occur during data transfer, this bit will not be set. Instead,
 * the DMAE bit will be set. Either Simple DMA or ADMA finishes data transferring,
 * this bit will be set.
 *
 * Values:
 * - 0 - No DMA Interrupt.
 * - 1 - DMA Interrupt is generated.
 */
//@{
#define BP_SDHC_IRQSTAT_DINT (3U)          //!< Bit position for SDHC_IRQSTAT_DINT.
#define BM_SDHC_IRQSTAT_DINT (0x00000008U) //!< Bit mask for SDHC_IRQSTAT_DINT.
#define BS_SDHC_IRQSTAT_DINT (1U)          //!< Bit field size in bits for SDHC_IRQSTAT_DINT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTAT_DINT field.
#define BR_SDHC_IRQSTAT_DINT (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_DINT))
#endif

//! @brief Format value for bitfield SDHC_IRQSTAT_DINT.
#define BF_SDHC_IRQSTAT_DINT(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTAT_DINT), uint32_t) & BM_SDHC_IRQSTAT_DINT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DINT field to a new value.
#define BW_SDHC_IRQSTAT_DINT(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_DINT) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTAT, field BWR[4] (W1C)
 *
 * This status bit is set if the Buffer Write Enable bit, in the Present State
 * register, changes from 0 to 1. See the Buffer Write Enable bit in the Present
 * State register for additional information.
 *
 * Values:
 * - 0 - Not ready to write buffer.
 * - 1 - Ready to write buffer.
 */
//@{
#define BP_SDHC_IRQSTAT_BWR  (4U)          //!< Bit position for SDHC_IRQSTAT_BWR.
#define BM_SDHC_IRQSTAT_BWR  (0x00000010U) //!< Bit mask for SDHC_IRQSTAT_BWR.
#define BS_SDHC_IRQSTAT_BWR  (1U)          //!< Bit field size in bits for SDHC_IRQSTAT_BWR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTAT_BWR field.
#define BR_SDHC_IRQSTAT_BWR  (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_BWR))
#endif

//! @brief Format value for bitfield SDHC_IRQSTAT_BWR.
#define BF_SDHC_IRQSTAT_BWR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTAT_BWR), uint32_t) & BM_SDHC_IRQSTAT_BWR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BWR field to a new value.
#define BW_SDHC_IRQSTAT_BWR(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_BWR) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTAT, field BRR[5] (W1C)
 *
 * This status bit is set if the Buffer Read Enable bit, in the Present State
 * register, changes from 0 to 1. See the Buffer Read Enable bit in the Present
 * State register for additional information.
 *
 * Values:
 * - 0 - Not ready to read buffer.
 * - 1 - Ready to read buffer.
 */
//@{
#define BP_SDHC_IRQSTAT_BRR  (5U)          //!< Bit position for SDHC_IRQSTAT_BRR.
#define BM_SDHC_IRQSTAT_BRR  (0x00000020U) //!< Bit mask for SDHC_IRQSTAT_BRR.
#define BS_SDHC_IRQSTAT_BRR  (1U)          //!< Bit field size in bits for SDHC_IRQSTAT_BRR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTAT_BRR field.
#define BR_SDHC_IRQSTAT_BRR  (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_BRR))
#endif

//! @brief Format value for bitfield SDHC_IRQSTAT_BRR.
#define BF_SDHC_IRQSTAT_BRR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTAT_BRR), uint32_t) & BM_SDHC_IRQSTAT_BRR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BRR field to a new value.
#define BW_SDHC_IRQSTAT_BRR(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_BRR) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTAT, field CINS[6] (W1C)
 *
 * This status bit is set if the Card Inserted bit in the Present State register
 * changes from 0 to 1. When the host driver writes this bit to 1 to clear this
 * status, the status of the Card Inserted in the Present State register must be
 * confirmed. Because the card state may possibly be changed when the host driver
 * clears this bit and the interrupt event may not be generated. When this bit
 * is cleared, it will be set again if a card is inserted. To leave it cleared,
 * clear the Card Inserted Status Enable bit in Interrupt Status Enable register.
 *
 * Values:
 * - 0 - Card state unstable or removed.
 * - 1 - Card inserted.
 */
//@{
#define BP_SDHC_IRQSTAT_CINS (6U)          //!< Bit position for SDHC_IRQSTAT_CINS.
#define BM_SDHC_IRQSTAT_CINS (0x00000040U) //!< Bit mask for SDHC_IRQSTAT_CINS.
#define BS_SDHC_IRQSTAT_CINS (1U)          //!< Bit field size in bits for SDHC_IRQSTAT_CINS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTAT_CINS field.
#define BR_SDHC_IRQSTAT_CINS (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_CINS))
#endif

//! @brief Format value for bitfield SDHC_IRQSTAT_CINS.
#define BF_SDHC_IRQSTAT_CINS(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTAT_CINS), uint32_t) & BM_SDHC_IRQSTAT_CINS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CINS field to a new value.
#define BW_SDHC_IRQSTAT_CINS(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_CINS) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTAT, field CRM[7] (W1C)
 *
 * This status bit is set if the Card Inserted bit in the Present State register
 * changes from 1 to 0. When the host driver writes this bit to 1 to clear this
 * status, the status of the Card Inserted in the Present State register must be
 * confirmed. Because the card state may possibly be changed when the host driver
 * clears this bit and the interrupt event may not be generated. When this bit
 * is cleared, it will be set again if no card is inserted. To leave it cleared,
 * clear the Card Removal Status Enable bit in Interrupt Status Enable register.
 *
 * Values:
 * - 0 - Card state unstable or inserted.
 * - 1 - Card removed.
 */
//@{
#define BP_SDHC_IRQSTAT_CRM  (7U)          //!< Bit position for SDHC_IRQSTAT_CRM.
#define BM_SDHC_IRQSTAT_CRM  (0x00000080U) //!< Bit mask for SDHC_IRQSTAT_CRM.
#define BS_SDHC_IRQSTAT_CRM  (1U)          //!< Bit field size in bits for SDHC_IRQSTAT_CRM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTAT_CRM field.
#define BR_SDHC_IRQSTAT_CRM  (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_CRM))
#endif

//! @brief Format value for bitfield SDHC_IRQSTAT_CRM.
#define BF_SDHC_IRQSTAT_CRM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTAT_CRM), uint32_t) & BM_SDHC_IRQSTAT_CRM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CRM field to a new value.
#define BW_SDHC_IRQSTAT_CRM(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_CRM) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTAT, field CINT[8] (W1C)
 *
 * This status bit is set when an interrupt signal is detected from the external
 * card. In 1-bit mode, the SDHC will detect the Card Interrupt without the SD
 * Clock to support wakeup. In 4-bit mode, the card interrupt signal is sampled
 * during the interrupt cycle, so the interrupt from card can only be sampled
 * during interrupt cycle, introducing some delay between the interrupt signal from
 * the SDIO card and the interrupt to the host system. Writing this bit to 1 can
 * clear this bit, but as the interrupt factor from the SDIO card does not clear,
 * this bit is set again. To clear this bit, it is required to reset the interrupt
 * factor from the external card followed by a writing 1 to this bit. When this
 * status has been set, and the host driver needs to service this interrupt, the
 * Card Interrupt Signal Enable in the Interrupt Signal Enable register should be
 * 0 to stop driving the interrupt signal to the host system. After completion
 * of the card interrupt service (it must reset the interrupt factors in the SDIO
 * card and the interrupt signal may not be asserted), write 1 to clear this bit,
 * set the Card Interrupt Signal Enable to 1, and start sampling the interrupt
 * signal again.
 *
 * Values:
 * - 0 - No Card Interrupt.
 * - 1 - Generate Card Interrupt.
 */
//@{
#define BP_SDHC_IRQSTAT_CINT (8U)          //!< Bit position for SDHC_IRQSTAT_CINT.
#define BM_SDHC_IRQSTAT_CINT (0x00000100U) //!< Bit mask for SDHC_IRQSTAT_CINT.
#define BS_SDHC_IRQSTAT_CINT (1U)          //!< Bit field size in bits for SDHC_IRQSTAT_CINT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTAT_CINT field.
#define BR_SDHC_IRQSTAT_CINT (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_CINT))
#endif

//! @brief Format value for bitfield SDHC_IRQSTAT_CINT.
#define BF_SDHC_IRQSTAT_CINT(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTAT_CINT), uint32_t) & BM_SDHC_IRQSTAT_CINT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CINT field to a new value.
#define BW_SDHC_IRQSTAT_CINT(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_CINT) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTAT, field CTOE[16] (W1C)
 *
 * Occurs only if no response is returned within 64 SDCLK cycles from the end
 * bit of the command. If the SDHC detects a CMD line conflict, in which case a
 * Command CRC Error shall also be set, this bit shall be set without waiting for 64
 * SDCLK cycles. This is because the command will be aborted by the SDHC.
 *
 * Values:
 * - 0 - No error.
 * - 1 - Time out.
 */
//@{
#define BP_SDHC_IRQSTAT_CTOE (16U)         //!< Bit position for SDHC_IRQSTAT_CTOE.
#define BM_SDHC_IRQSTAT_CTOE (0x00010000U) //!< Bit mask for SDHC_IRQSTAT_CTOE.
#define BS_SDHC_IRQSTAT_CTOE (1U)          //!< Bit field size in bits for SDHC_IRQSTAT_CTOE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTAT_CTOE field.
#define BR_SDHC_IRQSTAT_CTOE (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_CTOE))
#endif

//! @brief Format value for bitfield SDHC_IRQSTAT_CTOE.
#define BF_SDHC_IRQSTAT_CTOE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTAT_CTOE), uint32_t) & BM_SDHC_IRQSTAT_CTOE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CTOE field to a new value.
#define BW_SDHC_IRQSTAT_CTOE(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_CTOE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTAT, field CCE[17] (W1C)
 *
 * Command CRC Error is generated in two cases. If a response is returned and
 * the Command Timeout Error is set to 0, indicating no time-out, this bit is set
 * when detecting a CRC error in the command response. The SDHC detects a CMD line
 * conflict by monitoring the CMD line when a command is issued. If the SDHC
 * drives the CMD line to 1, but detects 0 on the CMD line at the next SDCLK edge,
 * then the SDHC shall abort the command (Stop driving CMD line) and set this bit
 * to 1. The Command Timeout Error shall also be set to 1 to distinguish CMD line
 * conflict.
 *
 * Values:
 * - 0 - No error.
 * - 1 - CRC Error generated.
 */
//@{
#define BP_SDHC_IRQSTAT_CCE  (17U)         //!< Bit position for SDHC_IRQSTAT_CCE.
#define BM_SDHC_IRQSTAT_CCE  (0x00020000U) //!< Bit mask for SDHC_IRQSTAT_CCE.
#define BS_SDHC_IRQSTAT_CCE  (1U)          //!< Bit field size in bits for SDHC_IRQSTAT_CCE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTAT_CCE field.
#define BR_SDHC_IRQSTAT_CCE  (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_CCE))
#endif

//! @brief Format value for bitfield SDHC_IRQSTAT_CCE.
#define BF_SDHC_IRQSTAT_CCE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTAT_CCE), uint32_t) & BM_SDHC_IRQSTAT_CCE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CCE field to a new value.
#define BW_SDHC_IRQSTAT_CCE(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_CCE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTAT, field CEBE[18] (W1C)
 *
 * Occurs when detecting that the end bit of a command response is 0.
 *
 * Values:
 * - 0 - No error.
 * - 1 - End Bit Error generated.
 */
//@{
#define BP_SDHC_IRQSTAT_CEBE (18U)         //!< Bit position for SDHC_IRQSTAT_CEBE.
#define BM_SDHC_IRQSTAT_CEBE (0x00040000U) //!< Bit mask for SDHC_IRQSTAT_CEBE.
#define BS_SDHC_IRQSTAT_CEBE (1U)          //!< Bit field size in bits for SDHC_IRQSTAT_CEBE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTAT_CEBE field.
#define BR_SDHC_IRQSTAT_CEBE (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_CEBE))
#endif

//! @brief Format value for bitfield SDHC_IRQSTAT_CEBE.
#define BF_SDHC_IRQSTAT_CEBE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTAT_CEBE), uint32_t) & BM_SDHC_IRQSTAT_CEBE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CEBE field to a new value.
#define BW_SDHC_IRQSTAT_CEBE(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_CEBE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTAT, field CIE[19] (W1C)
 *
 * Occurs if a Command Index error occurs in the command response.
 *
 * Values:
 * - 0 - No error.
 * - 1 - Error.
 */
//@{
#define BP_SDHC_IRQSTAT_CIE  (19U)         //!< Bit position for SDHC_IRQSTAT_CIE.
#define BM_SDHC_IRQSTAT_CIE  (0x00080000U) //!< Bit mask for SDHC_IRQSTAT_CIE.
#define BS_SDHC_IRQSTAT_CIE  (1U)          //!< Bit field size in bits for SDHC_IRQSTAT_CIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTAT_CIE field.
#define BR_SDHC_IRQSTAT_CIE  (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_CIE))
#endif

//! @brief Format value for bitfield SDHC_IRQSTAT_CIE.
#define BF_SDHC_IRQSTAT_CIE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTAT_CIE), uint32_t) & BM_SDHC_IRQSTAT_CIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CIE field to a new value.
#define BW_SDHC_IRQSTAT_CIE(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_CIE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTAT, field DTOE[20] (W1C)
 *
 * Occurs when detecting one of following time-out conditions. Busy time-out for
 * R1b,R5b type Busy time-out after Write CRC status Read Data time-out
 *
 * Values:
 * - 0 - No error.
 * - 1 - Time out.
 */
//@{
#define BP_SDHC_IRQSTAT_DTOE (20U)         //!< Bit position for SDHC_IRQSTAT_DTOE.
#define BM_SDHC_IRQSTAT_DTOE (0x00100000U) //!< Bit mask for SDHC_IRQSTAT_DTOE.
#define BS_SDHC_IRQSTAT_DTOE (1U)          //!< Bit field size in bits for SDHC_IRQSTAT_DTOE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTAT_DTOE field.
#define BR_SDHC_IRQSTAT_DTOE (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_DTOE))
#endif

//! @brief Format value for bitfield SDHC_IRQSTAT_DTOE.
#define BF_SDHC_IRQSTAT_DTOE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTAT_DTOE), uint32_t) & BM_SDHC_IRQSTAT_DTOE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DTOE field to a new value.
#define BW_SDHC_IRQSTAT_DTOE(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_DTOE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTAT, field DCE[21] (W1C)
 *
 * Occurs when detecting a CRC error when transferring read data, which uses the
 * DAT line, or when detecting the Write CRC status having a value other than
 * 010.
 *
 * Values:
 * - 0 - No error.
 * - 1 - Error.
 */
//@{
#define BP_SDHC_IRQSTAT_DCE  (21U)         //!< Bit position for SDHC_IRQSTAT_DCE.
#define BM_SDHC_IRQSTAT_DCE  (0x00200000U) //!< Bit mask for SDHC_IRQSTAT_DCE.
#define BS_SDHC_IRQSTAT_DCE  (1U)          //!< Bit field size in bits for SDHC_IRQSTAT_DCE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTAT_DCE field.
#define BR_SDHC_IRQSTAT_DCE  (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_DCE))
#endif

//! @brief Format value for bitfield SDHC_IRQSTAT_DCE.
#define BF_SDHC_IRQSTAT_DCE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTAT_DCE), uint32_t) & BM_SDHC_IRQSTAT_DCE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DCE field to a new value.
#define BW_SDHC_IRQSTAT_DCE(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_DCE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTAT, field DEBE[22] (W1C)
 *
 * Occurs either when detecting 0 at the end bit position of read data, which
 * uses the DAT line, or at the end bit position of the CRC.
 *
 * Values:
 * - 0 - No error.
 * - 1 - Error.
 */
//@{
#define BP_SDHC_IRQSTAT_DEBE (22U)         //!< Bit position for SDHC_IRQSTAT_DEBE.
#define BM_SDHC_IRQSTAT_DEBE (0x00400000U) //!< Bit mask for SDHC_IRQSTAT_DEBE.
#define BS_SDHC_IRQSTAT_DEBE (1U)          //!< Bit field size in bits for SDHC_IRQSTAT_DEBE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTAT_DEBE field.
#define BR_SDHC_IRQSTAT_DEBE (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_DEBE))
#endif

//! @brief Format value for bitfield SDHC_IRQSTAT_DEBE.
#define BF_SDHC_IRQSTAT_DEBE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTAT_DEBE), uint32_t) & BM_SDHC_IRQSTAT_DEBE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DEBE field to a new value.
#define BW_SDHC_IRQSTAT_DEBE(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_DEBE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTAT, field AC12E[24] (W1C)
 *
 * Occurs when detecting that one of the bits in the Auto CMD12 Error Status
 * register has changed from 0 to 1. This bit is set to 1, not only when the errors
 * in Auto CMD12 occur, but also when the Auto CMD12 is not executed due to the
 * previous command error.
 *
 * Values:
 * - 0 - No error.
 * - 1 - Error.
 */
//@{
#define BP_SDHC_IRQSTAT_AC12E (24U)        //!< Bit position for SDHC_IRQSTAT_AC12E.
#define BM_SDHC_IRQSTAT_AC12E (0x01000000U) //!< Bit mask for SDHC_IRQSTAT_AC12E.
#define BS_SDHC_IRQSTAT_AC12E (1U)         //!< Bit field size in bits for SDHC_IRQSTAT_AC12E.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTAT_AC12E field.
#define BR_SDHC_IRQSTAT_AC12E (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_AC12E))
#endif

//! @brief Format value for bitfield SDHC_IRQSTAT_AC12E.
#define BF_SDHC_IRQSTAT_AC12E(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTAT_AC12E), uint32_t) & BM_SDHC_IRQSTAT_AC12E)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AC12E field to a new value.
#define BW_SDHC_IRQSTAT_AC12E(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_AC12E) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTAT, field DMAE[28] (W1C)
 *
 * Occurs when an Internal DMA transfer has failed. This bit is set to 1, when
 * some error occurs in the data transfer. This error can be caused by either
 * Simple DMA or ADMA, depending on which DMA is in use. The value in DMA System
 * Address register is the next fetch address where the error occurs. Because any
 * error corrupts the whole data block, the host driver shall restart the transfer
 * from the corrupted block boundary. The address of the block boundary can be
 * calculated either from the current DSADDR value or from the remaining number of
 * blocks and the block size.
 *
 * Values:
 * - 0 - No error.
 * - 1 - Error.
 */
//@{
#define BP_SDHC_IRQSTAT_DMAE (28U)         //!< Bit position for SDHC_IRQSTAT_DMAE.
#define BM_SDHC_IRQSTAT_DMAE (0x10000000U) //!< Bit mask for SDHC_IRQSTAT_DMAE.
#define BS_SDHC_IRQSTAT_DMAE (1U)          //!< Bit field size in bits for SDHC_IRQSTAT_DMAE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTAT_DMAE field.
#define BR_SDHC_IRQSTAT_DMAE (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_DMAE))
#endif

//! @brief Format value for bitfield SDHC_IRQSTAT_DMAE.
#define BF_SDHC_IRQSTAT_DMAE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTAT_DMAE), uint32_t) & BM_SDHC_IRQSTAT_DMAE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMAE field to a new value.
#define BW_SDHC_IRQSTAT_DMAE(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTAT_ADDR, BP_SDHC_IRQSTAT_DMAE) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_IRQSTATEN - Interrupt Status Enable register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_IRQSTATEN - Interrupt Status Enable register (RW)
 *
 * Reset value: 0x117F013FU
 *
 * Setting the bits in this register to 1 enables the corresponding interrupt
 * status to be set by the specified event. If any bit is cleared, the
 * corresponding interrupt status bit is also cleared, that is, when the bit in this register
 * is cleared, the corresponding bit in interrupt status register is always 0.
 * Depending on PROCTL[IABG] bit setting, SDHC may be programmed to sample the
 * card interrupt signal during the interrupt period and hold its value in the
 * flip-flop. There will be some delays on the card interrupt, asserted from the card,
 * to the time the host system is informed. To detect a CMD line conflict, the
 * host driver must set both IRQSTATEN[CTOESEN] and IRQSTATEN[CCESEN] to 1.
 */
typedef union _hw_sdhc_irqstaten
{
    uint32_t U;
    struct _hw_sdhc_irqstaten_bitfields
    {
        uint32_t CCSEN : 1;            //!< [0] Command Complete Status Enable
        uint32_t TCSEN : 1;            //!< [1] Transfer Complete Status Enable
        uint32_t BGESEN : 1;           //!< [2] Block Gap Event Status Enable
        uint32_t DINTSEN : 1;          //!< [3] DMA Interrupt Status Enable
        uint32_t BWRSEN : 1;           //!< [4] Buffer Write Ready Status Enable
        uint32_t BRRSEN : 1;           //!< [5] Buffer Read Ready Status Enable
        uint32_t CINSEN : 1;           //!< [6] Card Insertion Status Enable
        uint32_t CRMSEN : 1;           //!< [7] Card Removal Status Enable
        uint32_t CINTSEN : 1;          //!< [8] Card Interrupt Status Enable
        uint32_t RESERVED0 : 7;        //!< [15:9]
        uint32_t CTOESEN : 1;          //!< [16] Command Timeout Error Status Enable
        uint32_t CCESEN : 1;           //!< [17] Command CRC Error Status Enable
        uint32_t CEBESEN : 1;          //!< [18] Command End Bit Error Status Enable
        uint32_t CIESEN : 1;           //!< [19] Command Index Error Status Enable
        uint32_t DTOESEN : 1;          //!< [20] Data Timeout Error Status Enable
        uint32_t DCESEN : 1;           //!< [21] Data CRC Error Status Enable
        uint32_t DEBESEN : 1;          //!< [22] Data End Bit Error Status Enable
        uint32_t RESERVED1 : 1;        //!< [23]
        uint32_t AC12ESEN : 1;         //!< [24] Auto CMD12 Error Status Enable
        uint32_t RESERVED2 : 3;        //!< [27:25]
        uint32_t DMAESEN : 1;          //!< [28] DMA Error Status Enable
        uint32_t RESERVED3 : 3;        //!< [31:29]
    } B;
} hw_sdhc_irqstaten_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_IRQSTATEN register
 */
//@{
#define HW_SDHC_IRQSTATEN_ADDR   (REGS_SDHC_BASE + 0x34U)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_IRQSTATEN        (*(__IO hw_sdhc_irqstaten_t *) HW_SDHC_IRQSTATEN_ADDR)
#define HW_SDHC_IRQSTATEN_RD()   (HW_SDHC_IRQSTATEN.U)
#define HW_SDHC_IRQSTATEN_WR(v)  (HW_SDHC_IRQSTATEN.U = (v))
#define HW_SDHC_IRQSTATEN_SET(v) (HW_SDHC_IRQSTATEN_WR(HW_SDHC_IRQSTATEN_RD() |  (v)))
#define HW_SDHC_IRQSTATEN_CLR(v) (HW_SDHC_IRQSTATEN_WR(HW_SDHC_IRQSTATEN_RD() & ~(v)))
#define HW_SDHC_IRQSTATEN_TOG(v) (HW_SDHC_IRQSTATEN_WR(HW_SDHC_IRQSTATEN_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SDHC_IRQSTATEN bitfields
 */

/*!
 * @name Register SDHC_IRQSTATEN, field CCSEN[0] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSTATEN_CCSEN (0U)       //!< Bit position for SDHC_IRQSTATEN_CCSEN.
#define BM_SDHC_IRQSTATEN_CCSEN (0x00000001U) //!< Bit mask for SDHC_IRQSTATEN_CCSEN.
#define BS_SDHC_IRQSTATEN_CCSEN (1U)       //!< Bit field size in bits for SDHC_IRQSTATEN_CCSEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTATEN_CCSEN field.
#define BR_SDHC_IRQSTATEN_CCSEN (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_CCSEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSTATEN_CCSEN.
#define BF_SDHC_IRQSTATEN_CCSEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTATEN_CCSEN), uint32_t) & BM_SDHC_IRQSTATEN_CCSEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CCSEN field to a new value.
#define BW_SDHC_IRQSTATEN_CCSEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_CCSEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTATEN, field TCSEN[1] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSTATEN_TCSEN (1U)       //!< Bit position for SDHC_IRQSTATEN_TCSEN.
#define BM_SDHC_IRQSTATEN_TCSEN (0x00000002U) //!< Bit mask for SDHC_IRQSTATEN_TCSEN.
#define BS_SDHC_IRQSTATEN_TCSEN (1U)       //!< Bit field size in bits for SDHC_IRQSTATEN_TCSEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTATEN_TCSEN field.
#define BR_SDHC_IRQSTATEN_TCSEN (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_TCSEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSTATEN_TCSEN.
#define BF_SDHC_IRQSTATEN_TCSEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTATEN_TCSEN), uint32_t) & BM_SDHC_IRQSTATEN_TCSEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TCSEN field to a new value.
#define BW_SDHC_IRQSTATEN_TCSEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_TCSEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTATEN, field BGESEN[2] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSTATEN_BGESEN (2U)      //!< Bit position for SDHC_IRQSTATEN_BGESEN.
#define BM_SDHC_IRQSTATEN_BGESEN (0x00000004U) //!< Bit mask for SDHC_IRQSTATEN_BGESEN.
#define BS_SDHC_IRQSTATEN_BGESEN (1U)      //!< Bit field size in bits for SDHC_IRQSTATEN_BGESEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTATEN_BGESEN field.
#define BR_SDHC_IRQSTATEN_BGESEN (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_BGESEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSTATEN_BGESEN.
#define BF_SDHC_IRQSTATEN_BGESEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTATEN_BGESEN), uint32_t) & BM_SDHC_IRQSTATEN_BGESEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BGESEN field to a new value.
#define BW_SDHC_IRQSTATEN_BGESEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_BGESEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTATEN, field DINTSEN[3] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSTATEN_DINTSEN (3U)     //!< Bit position for SDHC_IRQSTATEN_DINTSEN.
#define BM_SDHC_IRQSTATEN_DINTSEN (0x00000008U) //!< Bit mask for SDHC_IRQSTATEN_DINTSEN.
#define BS_SDHC_IRQSTATEN_DINTSEN (1U)     //!< Bit field size in bits for SDHC_IRQSTATEN_DINTSEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTATEN_DINTSEN field.
#define BR_SDHC_IRQSTATEN_DINTSEN (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_DINTSEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSTATEN_DINTSEN.
#define BF_SDHC_IRQSTATEN_DINTSEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTATEN_DINTSEN), uint32_t) & BM_SDHC_IRQSTATEN_DINTSEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DINTSEN field to a new value.
#define BW_SDHC_IRQSTATEN_DINTSEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_DINTSEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTATEN, field BWRSEN[4] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSTATEN_BWRSEN (4U)      //!< Bit position for SDHC_IRQSTATEN_BWRSEN.
#define BM_SDHC_IRQSTATEN_BWRSEN (0x00000010U) //!< Bit mask for SDHC_IRQSTATEN_BWRSEN.
#define BS_SDHC_IRQSTATEN_BWRSEN (1U)      //!< Bit field size in bits for SDHC_IRQSTATEN_BWRSEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTATEN_BWRSEN field.
#define BR_SDHC_IRQSTATEN_BWRSEN (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_BWRSEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSTATEN_BWRSEN.
#define BF_SDHC_IRQSTATEN_BWRSEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTATEN_BWRSEN), uint32_t) & BM_SDHC_IRQSTATEN_BWRSEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BWRSEN field to a new value.
#define BW_SDHC_IRQSTATEN_BWRSEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_BWRSEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTATEN, field BRRSEN[5] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSTATEN_BRRSEN (5U)      //!< Bit position for SDHC_IRQSTATEN_BRRSEN.
#define BM_SDHC_IRQSTATEN_BRRSEN (0x00000020U) //!< Bit mask for SDHC_IRQSTATEN_BRRSEN.
#define BS_SDHC_IRQSTATEN_BRRSEN (1U)      //!< Bit field size in bits for SDHC_IRQSTATEN_BRRSEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTATEN_BRRSEN field.
#define BR_SDHC_IRQSTATEN_BRRSEN (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_BRRSEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSTATEN_BRRSEN.
#define BF_SDHC_IRQSTATEN_BRRSEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTATEN_BRRSEN), uint32_t) & BM_SDHC_IRQSTATEN_BRRSEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BRRSEN field to a new value.
#define BW_SDHC_IRQSTATEN_BRRSEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_BRRSEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTATEN, field CINSEN[6] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSTATEN_CINSEN (6U)      //!< Bit position for SDHC_IRQSTATEN_CINSEN.
#define BM_SDHC_IRQSTATEN_CINSEN (0x00000040U) //!< Bit mask for SDHC_IRQSTATEN_CINSEN.
#define BS_SDHC_IRQSTATEN_CINSEN (1U)      //!< Bit field size in bits for SDHC_IRQSTATEN_CINSEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTATEN_CINSEN field.
#define BR_SDHC_IRQSTATEN_CINSEN (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_CINSEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSTATEN_CINSEN.
#define BF_SDHC_IRQSTATEN_CINSEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTATEN_CINSEN), uint32_t) & BM_SDHC_IRQSTATEN_CINSEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CINSEN field to a new value.
#define BW_SDHC_IRQSTATEN_CINSEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_CINSEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTATEN, field CRMSEN[7] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSTATEN_CRMSEN (7U)      //!< Bit position for SDHC_IRQSTATEN_CRMSEN.
#define BM_SDHC_IRQSTATEN_CRMSEN (0x00000080U) //!< Bit mask for SDHC_IRQSTATEN_CRMSEN.
#define BS_SDHC_IRQSTATEN_CRMSEN (1U)      //!< Bit field size in bits for SDHC_IRQSTATEN_CRMSEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTATEN_CRMSEN field.
#define BR_SDHC_IRQSTATEN_CRMSEN (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_CRMSEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSTATEN_CRMSEN.
#define BF_SDHC_IRQSTATEN_CRMSEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTATEN_CRMSEN), uint32_t) & BM_SDHC_IRQSTATEN_CRMSEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CRMSEN field to a new value.
#define BW_SDHC_IRQSTATEN_CRMSEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_CRMSEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTATEN, field CINTSEN[8] (RW)
 *
 * If this bit is set to 0, the SDHC will clear the interrupt request to the
 * system. The card interrupt detection is stopped when this bit is cleared and
 * restarted when this bit is set to 1. The host driver must clear the this bit
 * before servicing the card interrupt and must set this bit again after all interrupt
 * requests from the card are cleared to prevent inadvertent interrupts.
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSTATEN_CINTSEN (8U)     //!< Bit position for SDHC_IRQSTATEN_CINTSEN.
#define BM_SDHC_IRQSTATEN_CINTSEN (0x00000100U) //!< Bit mask for SDHC_IRQSTATEN_CINTSEN.
#define BS_SDHC_IRQSTATEN_CINTSEN (1U)     //!< Bit field size in bits for SDHC_IRQSTATEN_CINTSEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTATEN_CINTSEN field.
#define BR_SDHC_IRQSTATEN_CINTSEN (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_CINTSEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSTATEN_CINTSEN.
#define BF_SDHC_IRQSTATEN_CINTSEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTATEN_CINTSEN), uint32_t) & BM_SDHC_IRQSTATEN_CINTSEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CINTSEN field to a new value.
#define BW_SDHC_IRQSTATEN_CINTSEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_CINTSEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTATEN, field CTOESEN[16] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSTATEN_CTOESEN (16U)    //!< Bit position for SDHC_IRQSTATEN_CTOESEN.
#define BM_SDHC_IRQSTATEN_CTOESEN (0x00010000U) //!< Bit mask for SDHC_IRQSTATEN_CTOESEN.
#define BS_SDHC_IRQSTATEN_CTOESEN (1U)     //!< Bit field size in bits for SDHC_IRQSTATEN_CTOESEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTATEN_CTOESEN field.
#define BR_SDHC_IRQSTATEN_CTOESEN (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_CTOESEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSTATEN_CTOESEN.
#define BF_SDHC_IRQSTATEN_CTOESEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTATEN_CTOESEN), uint32_t) & BM_SDHC_IRQSTATEN_CTOESEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CTOESEN field to a new value.
#define BW_SDHC_IRQSTATEN_CTOESEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_CTOESEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTATEN, field CCESEN[17] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSTATEN_CCESEN (17U)     //!< Bit position for SDHC_IRQSTATEN_CCESEN.
#define BM_SDHC_IRQSTATEN_CCESEN (0x00020000U) //!< Bit mask for SDHC_IRQSTATEN_CCESEN.
#define BS_SDHC_IRQSTATEN_CCESEN (1U)      //!< Bit field size in bits for SDHC_IRQSTATEN_CCESEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTATEN_CCESEN field.
#define BR_SDHC_IRQSTATEN_CCESEN (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_CCESEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSTATEN_CCESEN.
#define BF_SDHC_IRQSTATEN_CCESEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTATEN_CCESEN), uint32_t) & BM_SDHC_IRQSTATEN_CCESEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CCESEN field to a new value.
#define BW_SDHC_IRQSTATEN_CCESEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_CCESEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTATEN, field CEBESEN[18] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSTATEN_CEBESEN (18U)    //!< Bit position for SDHC_IRQSTATEN_CEBESEN.
#define BM_SDHC_IRQSTATEN_CEBESEN (0x00040000U) //!< Bit mask for SDHC_IRQSTATEN_CEBESEN.
#define BS_SDHC_IRQSTATEN_CEBESEN (1U)     //!< Bit field size in bits for SDHC_IRQSTATEN_CEBESEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTATEN_CEBESEN field.
#define BR_SDHC_IRQSTATEN_CEBESEN (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_CEBESEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSTATEN_CEBESEN.
#define BF_SDHC_IRQSTATEN_CEBESEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTATEN_CEBESEN), uint32_t) & BM_SDHC_IRQSTATEN_CEBESEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CEBESEN field to a new value.
#define BW_SDHC_IRQSTATEN_CEBESEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_CEBESEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTATEN, field CIESEN[19] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSTATEN_CIESEN (19U)     //!< Bit position for SDHC_IRQSTATEN_CIESEN.
#define BM_SDHC_IRQSTATEN_CIESEN (0x00080000U) //!< Bit mask for SDHC_IRQSTATEN_CIESEN.
#define BS_SDHC_IRQSTATEN_CIESEN (1U)      //!< Bit field size in bits for SDHC_IRQSTATEN_CIESEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTATEN_CIESEN field.
#define BR_SDHC_IRQSTATEN_CIESEN (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_CIESEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSTATEN_CIESEN.
#define BF_SDHC_IRQSTATEN_CIESEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTATEN_CIESEN), uint32_t) & BM_SDHC_IRQSTATEN_CIESEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CIESEN field to a new value.
#define BW_SDHC_IRQSTATEN_CIESEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_CIESEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTATEN, field DTOESEN[20] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSTATEN_DTOESEN (20U)    //!< Bit position for SDHC_IRQSTATEN_DTOESEN.
#define BM_SDHC_IRQSTATEN_DTOESEN (0x00100000U) //!< Bit mask for SDHC_IRQSTATEN_DTOESEN.
#define BS_SDHC_IRQSTATEN_DTOESEN (1U)     //!< Bit field size in bits for SDHC_IRQSTATEN_DTOESEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTATEN_DTOESEN field.
#define BR_SDHC_IRQSTATEN_DTOESEN (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_DTOESEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSTATEN_DTOESEN.
#define BF_SDHC_IRQSTATEN_DTOESEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTATEN_DTOESEN), uint32_t) & BM_SDHC_IRQSTATEN_DTOESEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DTOESEN field to a new value.
#define BW_SDHC_IRQSTATEN_DTOESEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_DTOESEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTATEN, field DCESEN[21] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSTATEN_DCESEN (21U)     //!< Bit position for SDHC_IRQSTATEN_DCESEN.
#define BM_SDHC_IRQSTATEN_DCESEN (0x00200000U) //!< Bit mask for SDHC_IRQSTATEN_DCESEN.
#define BS_SDHC_IRQSTATEN_DCESEN (1U)      //!< Bit field size in bits for SDHC_IRQSTATEN_DCESEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTATEN_DCESEN field.
#define BR_SDHC_IRQSTATEN_DCESEN (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_DCESEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSTATEN_DCESEN.
#define BF_SDHC_IRQSTATEN_DCESEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTATEN_DCESEN), uint32_t) & BM_SDHC_IRQSTATEN_DCESEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DCESEN field to a new value.
#define BW_SDHC_IRQSTATEN_DCESEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_DCESEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTATEN, field DEBESEN[22] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSTATEN_DEBESEN (22U)    //!< Bit position for SDHC_IRQSTATEN_DEBESEN.
#define BM_SDHC_IRQSTATEN_DEBESEN (0x00400000U) //!< Bit mask for SDHC_IRQSTATEN_DEBESEN.
#define BS_SDHC_IRQSTATEN_DEBESEN (1U)     //!< Bit field size in bits for SDHC_IRQSTATEN_DEBESEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTATEN_DEBESEN field.
#define BR_SDHC_IRQSTATEN_DEBESEN (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_DEBESEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSTATEN_DEBESEN.
#define BF_SDHC_IRQSTATEN_DEBESEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTATEN_DEBESEN), uint32_t) & BM_SDHC_IRQSTATEN_DEBESEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DEBESEN field to a new value.
#define BW_SDHC_IRQSTATEN_DEBESEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_DEBESEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTATEN, field AC12ESEN[24] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSTATEN_AC12ESEN (24U)   //!< Bit position for SDHC_IRQSTATEN_AC12ESEN.
#define BM_SDHC_IRQSTATEN_AC12ESEN (0x01000000U) //!< Bit mask for SDHC_IRQSTATEN_AC12ESEN.
#define BS_SDHC_IRQSTATEN_AC12ESEN (1U)    //!< Bit field size in bits for SDHC_IRQSTATEN_AC12ESEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTATEN_AC12ESEN field.
#define BR_SDHC_IRQSTATEN_AC12ESEN (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_AC12ESEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSTATEN_AC12ESEN.
#define BF_SDHC_IRQSTATEN_AC12ESEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTATEN_AC12ESEN), uint32_t) & BM_SDHC_IRQSTATEN_AC12ESEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AC12ESEN field to a new value.
#define BW_SDHC_IRQSTATEN_AC12ESEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_AC12ESEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSTATEN, field DMAESEN[28] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSTATEN_DMAESEN (28U)    //!< Bit position for SDHC_IRQSTATEN_DMAESEN.
#define BM_SDHC_IRQSTATEN_DMAESEN (0x10000000U) //!< Bit mask for SDHC_IRQSTATEN_DMAESEN.
#define BS_SDHC_IRQSTATEN_DMAESEN (1U)     //!< Bit field size in bits for SDHC_IRQSTATEN_DMAESEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSTATEN_DMAESEN field.
#define BR_SDHC_IRQSTATEN_DMAESEN (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_DMAESEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSTATEN_DMAESEN.
#define BF_SDHC_IRQSTATEN_DMAESEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSTATEN_DMAESEN), uint32_t) & BM_SDHC_IRQSTATEN_DMAESEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMAESEN field to a new value.
#define BW_SDHC_IRQSTATEN_DMAESEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSTATEN_ADDR, BP_SDHC_IRQSTATEN_DMAESEN) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_IRQSIGEN - Interrupt Signal Enable register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_IRQSIGEN - Interrupt Signal Enable register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register is used to select which interrupt status is indicated to the
 * host system as the interrupt. All of these status bits share the same interrupt
 * line. Setting any of these bits to 1 enables interrupt generation. The
 * corresponding status register bit will generate an interrupt when the corresponding
 * interrupt signal enable bit is set.
 */
typedef union _hw_sdhc_irqsigen
{
    uint32_t U;
    struct _hw_sdhc_irqsigen_bitfields
    {
        uint32_t CCIEN : 1;            //!< [0] Command Complete Interrupt Enable
        uint32_t TCIEN : 1;            //!< [1] Transfer Complete Interrupt Enable
        uint32_t BGEIEN : 1;           //!< [2] Block Gap Event Interrupt Enable
        uint32_t DINTIEN : 1;          //!< [3] DMA Interrupt Enable
        uint32_t BWRIEN : 1;           //!< [4] Buffer Write Ready Interrupt Enable
        uint32_t BRRIEN : 1;           //!< [5] Buffer Read Ready Interrupt Enable
        uint32_t CINSIEN : 1;          //!< [6] Card Insertion Interrupt Enable
        uint32_t CRMIEN : 1;           //!< [7] Card Removal Interrupt Enable
        uint32_t CINTIEN : 1;          //!< [8] Card Interrupt Enable
        uint32_t RESERVED0 : 7;        //!< [15:9]
        uint32_t CTOEIEN : 1;          //!< [16] Command Timeout Error Interrupt Enable
        uint32_t CCEIEN : 1;           //!< [17] Command CRC Error Interrupt Enable
        uint32_t CEBEIEN : 1;          //!< [18] Command End Bit Error Interrupt Enable
        uint32_t CIEIEN : 1;           //!< [19] Command Index Error Interrupt Enable
        uint32_t DTOEIEN : 1;          //!< [20] Data Timeout Error Interrupt Enable
        uint32_t DCEIEN : 1;           //!< [21] Data CRC Error Interrupt Enable
        uint32_t DEBEIEN : 1;          //!< [22] Data End Bit Error Interrupt Enable
        uint32_t RESERVED1 : 1;        //!< [23]
        uint32_t AC12EIEN : 1;         //!< [24] Auto CMD12 Error Interrupt Enable
        uint32_t RESERVED2 : 3;        //!< [27:25]
        uint32_t DMAEIEN : 1;          //!< [28] DMA Error Interrupt Enable
        uint32_t RESERVED3 : 3;        //!< [31:29]
    } B;
} hw_sdhc_irqsigen_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_IRQSIGEN register
 */
//@{
#define HW_SDHC_IRQSIGEN_ADDR    (REGS_SDHC_BASE + 0x38U)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_IRQSIGEN         (*(__IO hw_sdhc_irqsigen_t *) HW_SDHC_IRQSIGEN_ADDR)
#define HW_SDHC_IRQSIGEN_RD()    (HW_SDHC_IRQSIGEN.U)
#define HW_SDHC_IRQSIGEN_WR(v)   (HW_SDHC_IRQSIGEN.U = (v))
#define HW_SDHC_IRQSIGEN_SET(v)  (HW_SDHC_IRQSIGEN_WR(HW_SDHC_IRQSIGEN_RD() |  (v)))
#define HW_SDHC_IRQSIGEN_CLR(v)  (HW_SDHC_IRQSIGEN_WR(HW_SDHC_IRQSIGEN_RD() & ~(v)))
#define HW_SDHC_IRQSIGEN_TOG(v)  (HW_SDHC_IRQSIGEN_WR(HW_SDHC_IRQSIGEN_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SDHC_IRQSIGEN bitfields
 */

/*!
 * @name Register SDHC_IRQSIGEN, field CCIEN[0] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSIGEN_CCIEN (0U)        //!< Bit position for SDHC_IRQSIGEN_CCIEN.
#define BM_SDHC_IRQSIGEN_CCIEN (0x00000001U) //!< Bit mask for SDHC_IRQSIGEN_CCIEN.
#define BS_SDHC_IRQSIGEN_CCIEN (1U)        //!< Bit field size in bits for SDHC_IRQSIGEN_CCIEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSIGEN_CCIEN field.
#define BR_SDHC_IRQSIGEN_CCIEN (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_CCIEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSIGEN_CCIEN.
#define BF_SDHC_IRQSIGEN_CCIEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSIGEN_CCIEN), uint32_t) & BM_SDHC_IRQSIGEN_CCIEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CCIEN field to a new value.
#define BW_SDHC_IRQSIGEN_CCIEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_CCIEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSIGEN, field TCIEN[1] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSIGEN_TCIEN (1U)        //!< Bit position for SDHC_IRQSIGEN_TCIEN.
#define BM_SDHC_IRQSIGEN_TCIEN (0x00000002U) //!< Bit mask for SDHC_IRQSIGEN_TCIEN.
#define BS_SDHC_IRQSIGEN_TCIEN (1U)        //!< Bit field size in bits for SDHC_IRQSIGEN_TCIEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSIGEN_TCIEN field.
#define BR_SDHC_IRQSIGEN_TCIEN (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_TCIEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSIGEN_TCIEN.
#define BF_SDHC_IRQSIGEN_TCIEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSIGEN_TCIEN), uint32_t) & BM_SDHC_IRQSIGEN_TCIEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TCIEN field to a new value.
#define BW_SDHC_IRQSIGEN_TCIEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_TCIEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSIGEN, field BGEIEN[2] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSIGEN_BGEIEN (2U)       //!< Bit position for SDHC_IRQSIGEN_BGEIEN.
#define BM_SDHC_IRQSIGEN_BGEIEN (0x00000004U) //!< Bit mask for SDHC_IRQSIGEN_BGEIEN.
#define BS_SDHC_IRQSIGEN_BGEIEN (1U)       //!< Bit field size in bits for SDHC_IRQSIGEN_BGEIEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSIGEN_BGEIEN field.
#define BR_SDHC_IRQSIGEN_BGEIEN (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_BGEIEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSIGEN_BGEIEN.
#define BF_SDHC_IRQSIGEN_BGEIEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSIGEN_BGEIEN), uint32_t) & BM_SDHC_IRQSIGEN_BGEIEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BGEIEN field to a new value.
#define BW_SDHC_IRQSIGEN_BGEIEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_BGEIEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSIGEN, field DINTIEN[3] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSIGEN_DINTIEN (3U)      //!< Bit position for SDHC_IRQSIGEN_DINTIEN.
#define BM_SDHC_IRQSIGEN_DINTIEN (0x00000008U) //!< Bit mask for SDHC_IRQSIGEN_DINTIEN.
#define BS_SDHC_IRQSIGEN_DINTIEN (1U)      //!< Bit field size in bits for SDHC_IRQSIGEN_DINTIEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSIGEN_DINTIEN field.
#define BR_SDHC_IRQSIGEN_DINTIEN (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_DINTIEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSIGEN_DINTIEN.
#define BF_SDHC_IRQSIGEN_DINTIEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSIGEN_DINTIEN), uint32_t) & BM_SDHC_IRQSIGEN_DINTIEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DINTIEN field to a new value.
#define BW_SDHC_IRQSIGEN_DINTIEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_DINTIEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSIGEN, field BWRIEN[4] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSIGEN_BWRIEN (4U)       //!< Bit position for SDHC_IRQSIGEN_BWRIEN.
#define BM_SDHC_IRQSIGEN_BWRIEN (0x00000010U) //!< Bit mask for SDHC_IRQSIGEN_BWRIEN.
#define BS_SDHC_IRQSIGEN_BWRIEN (1U)       //!< Bit field size in bits for SDHC_IRQSIGEN_BWRIEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSIGEN_BWRIEN field.
#define BR_SDHC_IRQSIGEN_BWRIEN (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_BWRIEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSIGEN_BWRIEN.
#define BF_SDHC_IRQSIGEN_BWRIEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSIGEN_BWRIEN), uint32_t) & BM_SDHC_IRQSIGEN_BWRIEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BWRIEN field to a new value.
#define BW_SDHC_IRQSIGEN_BWRIEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_BWRIEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSIGEN, field BRRIEN[5] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSIGEN_BRRIEN (5U)       //!< Bit position for SDHC_IRQSIGEN_BRRIEN.
#define BM_SDHC_IRQSIGEN_BRRIEN (0x00000020U) //!< Bit mask for SDHC_IRQSIGEN_BRRIEN.
#define BS_SDHC_IRQSIGEN_BRRIEN (1U)       //!< Bit field size in bits for SDHC_IRQSIGEN_BRRIEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSIGEN_BRRIEN field.
#define BR_SDHC_IRQSIGEN_BRRIEN (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_BRRIEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSIGEN_BRRIEN.
#define BF_SDHC_IRQSIGEN_BRRIEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSIGEN_BRRIEN), uint32_t) & BM_SDHC_IRQSIGEN_BRRIEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BRRIEN field to a new value.
#define BW_SDHC_IRQSIGEN_BRRIEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_BRRIEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSIGEN, field CINSIEN[6] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSIGEN_CINSIEN (6U)      //!< Bit position for SDHC_IRQSIGEN_CINSIEN.
#define BM_SDHC_IRQSIGEN_CINSIEN (0x00000040U) //!< Bit mask for SDHC_IRQSIGEN_CINSIEN.
#define BS_SDHC_IRQSIGEN_CINSIEN (1U)      //!< Bit field size in bits for SDHC_IRQSIGEN_CINSIEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSIGEN_CINSIEN field.
#define BR_SDHC_IRQSIGEN_CINSIEN (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_CINSIEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSIGEN_CINSIEN.
#define BF_SDHC_IRQSIGEN_CINSIEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSIGEN_CINSIEN), uint32_t) & BM_SDHC_IRQSIGEN_CINSIEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CINSIEN field to a new value.
#define BW_SDHC_IRQSIGEN_CINSIEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_CINSIEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSIGEN, field CRMIEN[7] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSIGEN_CRMIEN (7U)       //!< Bit position for SDHC_IRQSIGEN_CRMIEN.
#define BM_SDHC_IRQSIGEN_CRMIEN (0x00000080U) //!< Bit mask for SDHC_IRQSIGEN_CRMIEN.
#define BS_SDHC_IRQSIGEN_CRMIEN (1U)       //!< Bit field size in bits for SDHC_IRQSIGEN_CRMIEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSIGEN_CRMIEN field.
#define BR_SDHC_IRQSIGEN_CRMIEN (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_CRMIEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSIGEN_CRMIEN.
#define BF_SDHC_IRQSIGEN_CRMIEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSIGEN_CRMIEN), uint32_t) & BM_SDHC_IRQSIGEN_CRMIEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CRMIEN field to a new value.
#define BW_SDHC_IRQSIGEN_CRMIEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_CRMIEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSIGEN, field CINTIEN[8] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSIGEN_CINTIEN (8U)      //!< Bit position for SDHC_IRQSIGEN_CINTIEN.
#define BM_SDHC_IRQSIGEN_CINTIEN (0x00000100U) //!< Bit mask for SDHC_IRQSIGEN_CINTIEN.
#define BS_SDHC_IRQSIGEN_CINTIEN (1U)      //!< Bit field size in bits for SDHC_IRQSIGEN_CINTIEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSIGEN_CINTIEN field.
#define BR_SDHC_IRQSIGEN_CINTIEN (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_CINTIEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSIGEN_CINTIEN.
#define BF_SDHC_IRQSIGEN_CINTIEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSIGEN_CINTIEN), uint32_t) & BM_SDHC_IRQSIGEN_CINTIEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CINTIEN field to a new value.
#define BW_SDHC_IRQSIGEN_CINTIEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_CINTIEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSIGEN, field CTOEIEN[16] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSIGEN_CTOEIEN (16U)     //!< Bit position for SDHC_IRQSIGEN_CTOEIEN.
#define BM_SDHC_IRQSIGEN_CTOEIEN (0x00010000U) //!< Bit mask for SDHC_IRQSIGEN_CTOEIEN.
#define BS_SDHC_IRQSIGEN_CTOEIEN (1U)      //!< Bit field size in bits for SDHC_IRQSIGEN_CTOEIEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSIGEN_CTOEIEN field.
#define BR_SDHC_IRQSIGEN_CTOEIEN (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_CTOEIEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSIGEN_CTOEIEN.
#define BF_SDHC_IRQSIGEN_CTOEIEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSIGEN_CTOEIEN), uint32_t) & BM_SDHC_IRQSIGEN_CTOEIEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CTOEIEN field to a new value.
#define BW_SDHC_IRQSIGEN_CTOEIEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_CTOEIEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSIGEN, field CCEIEN[17] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSIGEN_CCEIEN (17U)      //!< Bit position for SDHC_IRQSIGEN_CCEIEN.
#define BM_SDHC_IRQSIGEN_CCEIEN (0x00020000U) //!< Bit mask for SDHC_IRQSIGEN_CCEIEN.
#define BS_SDHC_IRQSIGEN_CCEIEN (1U)       //!< Bit field size in bits for SDHC_IRQSIGEN_CCEIEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSIGEN_CCEIEN field.
#define BR_SDHC_IRQSIGEN_CCEIEN (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_CCEIEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSIGEN_CCEIEN.
#define BF_SDHC_IRQSIGEN_CCEIEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSIGEN_CCEIEN), uint32_t) & BM_SDHC_IRQSIGEN_CCEIEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CCEIEN field to a new value.
#define BW_SDHC_IRQSIGEN_CCEIEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_CCEIEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSIGEN, field CEBEIEN[18] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSIGEN_CEBEIEN (18U)     //!< Bit position for SDHC_IRQSIGEN_CEBEIEN.
#define BM_SDHC_IRQSIGEN_CEBEIEN (0x00040000U) //!< Bit mask for SDHC_IRQSIGEN_CEBEIEN.
#define BS_SDHC_IRQSIGEN_CEBEIEN (1U)      //!< Bit field size in bits for SDHC_IRQSIGEN_CEBEIEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSIGEN_CEBEIEN field.
#define BR_SDHC_IRQSIGEN_CEBEIEN (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_CEBEIEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSIGEN_CEBEIEN.
#define BF_SDHC_IRQSIGEN_CEBEIEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSIGEN_CEBEIEN), uint32_t) & BM_SDHC_IRQSIGEN_CEBEIEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CEBEIEN field to a new value.
#define BW_SDHC_IRQSIGEN_CEBEIEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_CEBEIEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSIGEN, field CIEIEN[19] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSIGEN_CIEIEN (19U)      //!< Bit position for SDHC_IRQSIGEN_CIEIEN.
#define BM_SDHC_IRQSIGEN_CIEIEN (0x00080000U) //!< Bit mask for SDHC_IRQSIGEN_CIEIEN.
#define BS_SDHC_IRQSIGEN_CIEIEN (1U)       //!< Bit field size in bits for SDHC_IRQSIGEN_CIEIEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSIGEN_CIEIEN field.
#define BR_SDHC_IRQSIGEN_CIEIEN (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_CIEIEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSIGEN_CIEIEN.
#define BF_SDHC_IRQSIGEN_CIEIEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSIGEN_CIEIEN), uint32_t) & BM_SDHC_IRQSIGEN_CIEIEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CIEIEN field to a new value.
#define BW_SDHC_IRQSIGEN_CIEIEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_CIEIEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSIGEN, field DTOEIEN[20] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSIGEN_DTOEIEN (20U)     //!< Bit position for SDHC_IRQSIGEN_DTOEIEN.
#define BM_SDHC_IRQSIGEN_DTOEIEN (0x00100000U) //!< Bit mask for SDHC_IRQSIGEN_DTOEIEN.
#define BS_SDHC_IRQSIGEN_DTOEIEN (1U)      //!< Bit field size in bits for SDHC_IRQSIGEN_DTOEIEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSIGEN_DTOEIEN field.
#define BR_SDHC_IRQSIGEN_DTOEIEN (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_DTOEIEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSIGEN_DTOEIEN.
#define BF_SDHC_IRQSIGEN_DTOEIEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSIGEN_DTOEIEN), uint32_t) & BM_SDHC_IRQSIGEN_DTOEIEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DTOEIEN field to a new value.
#define BW_SDHC_IRQSIGEN_DTOEIEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_DTOEIEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSIGEN, field DCEIEN[21] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSIGEN_DCEIEN (21U)      //!< Bit position for SDHC_IRQSIGEN_DCEIEN.
#define BM_SDHC_IRQSIGEN_DCEIEN (0x00200000U) //!< Bit mask for SDHC_IRQSIGEN_DCEIEN.
#define BS_SDHC_IRQSIGEN_DCEIEN (1U)       //!< Bit field size in bits for SDHC_IRQSIGEN_DCEIEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSIGEN_DCEIEN field.
#define BR_SDHC_IRQSIGEN_DCEIEN (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_DCEIEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSIGEN_DCEIEN.
#define BF_SDHC_IRQSIGEN_DCEIEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSIGEN_DCEIEN), uint32_t) & BM_SDHC_IRQSIGEN_DCEIEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DCEIEN field to a new value.
#define BW_SDHC_IRQSIGEN_DCEIEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_DCEIEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSIGEN, field DEBEIEN[22] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSIGEN_DEBEIEN (22U)     //!< Bit position for SDHC_IRQSIGEN_DEBEIEN.
#define BM_SDHC_IRQSIGEN_DEBEIEN (0x00400000U) //!< Bit mask for SDHC_IRQSIGEN_DEBEIEN.
#define BS_SDHC_IRQSIGEN_DEBEIEN (1U)      //!< Bit field size in bits for SDHC_IRQSIGEN_DEBEIEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSIGEN_DEBEIEN field.
#define BR_SDHC_IRQSIGEN_DEBEIEN (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_DEBEIEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSIGEN_DEBEIEN.
#define BF_SDHC_IRQSIGEN_DEBEIEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSIGEN_DEBEIEN), uint32_t) & BM_SDHC_IRQSIGEN_DEBEIEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DEBEIEN field to a new value.
#define BW_SDHC_IRQSIGEN_DEBEIEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_DEBEIEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSIGEN, field AC12EIEN[24] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSIGEN_AC12EIEN (24U)    //!< Bit position for SDHC_IRQSIGEN_AC12EIEN.
#define BM_SDHC_IRQSIGEN_AC12EIEN (0x01000000U) //!< Bit mask for SDHC_IRQSIGEN_AC12EIEN.
#define BS_SDHC_IRQSIGEN_AC12EIEN (1U)     //!< Bit field size in bits for SDHC_IRQSIGEN_AC12EIEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSIGEN_AC12EIEN field.
#define BR_SDHC_IRQSIGEN_AC12EIEN (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_AC12EIEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSIGEN_AC12EIEN.
#define BF_SDHC_IRQSIGEN_AC12EIEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSIGEN_AC12EIEN), uint32_t) & BM_SDHC_IRQSIGEN_AC12EIEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AC12EIEN field to a new value.
#define BW_SDHC_IRQSIGEN_AC12EIEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_AC12EIEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_IRQSIGEN, field DMAEIEN[28] (RW)
 *
 * Values:
 * - 0 - Masked
 * - 1 - Enabled
 */
//@{
#define BP_SDHC_IRQSIGEN_DMAEIEN (28U)     //!< Bit position for SDHC_IRQSIGEN_DMAEIEN.
#define BM_SDHC_IRQSIGEN_DMAEIEN (0x10000000U) //!< Bit mask for SDHC_IRQSIGEN_DMAEIEN.
#define BS_SDHC_IRQSIGEN_DMAEIEN (1U)      //!< Bit field size in bits for SDHC_IRQSIGEN_DMAEIEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_IRQSIGEN_DMAEIEN field.
#define BR_SDHC_IRQSIGEN_DMAEIEN (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_DMAEIEN))
#endif

//! @brief Format value for bitfield SDHC_IRQSIGEN_DMAEIEN.
#define BF_SDHC_IRQSIGEN_DMAEIEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_IRQSIGEN_DMAEIEN), uint32_t) & BM_SDHC_IRQSIGEN_DMAEIEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMAEIEN field to a new value.
#define BW_SDHC_IRQSIGEN_DMAEIEN(v) (BITBAND_ACCESS32(HW_SDHC_IRQSIGEN_ADDR, BP_SDHC_IRQSIGEN_DMAEIEN) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_AC12ERR - Auto CMD12 Error Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_AC12ERR - Auto CMD12 Error Status Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * When the AC12ESEN bit in the Status register is set, the host driver shall
 * check this register to identify what kind of error the Auto CMD12 indicated.
 * This register is valid only when the Auto CMD12 Error status bit is set. The
 * following table shows the relationship between the Auto CMGD12 CRC error and the
 * Auto CMD12 command timeout error. Relationship between Command CRC Error and
 * Command Timeout Error For Auto CMD12 Auto CMD12 CRC error Auto CMD12 timeout
 * error Type of error 0 0 No error 0 1 Response timeout error 1 0 Response CRC
 * error 1 1 CMD line conflict Changes in Auto CMD12 Error Status register can be
 * classified in three scenarios: When the SDHC is going to issue an Auto CMD12: Set
 * bit 0 to 1 if the Auto CMD12 can't be issued due to an error in the previous
 * command. Set bit 0 to 0 if the auto CMD12 is issued. At the end bit of an auto
 * CMD12 response: Check errors corresponding to bits 1-4. Set bits 1-4
 * corresponding to detected errors. Clear bits 1-4 corresponding to detected errors.
 * Before reading the Auto CMD12 error status bit 7: Set bit 7 to 1 if there is a
 * command that can't be issued. Clear bit 7 if there is no command to issue. The
 * timing for generating the auto CMD12 error and writing to the command register
 * are asynchronous. After that, bit 7 shall be sampled when the driver is not
 * writing to the command register. So it is suggested to read this register only
 * when IRQSTAT[AC12E] is set. An Auto CMD12 error interrupt is generated when one
 * of the error bits (0-4) is set to 1. The command not issued by auto CMD12
 * error does not generate an interrupt.
 */
typedef union _hw_sdhc_ac12err
{
    uint32_t U;
    struct _hw_sdhc_ac12err_bitfields
    {
        uint32_t AC12NE : 1;           //!< [0] Auto CMD12 Not Executed
        uint32_t AC12TOE : 1;          //!< [1] Auto CMD12 Timeout Error
        uint32_t AC12EBE : 1;          //!< [2] Auto CMD12 End Bit Error
        uint32_t AC12CE : 1;           //!< [3] Auto CMD12 CRC Error
        uint32_t AC12IE : 1;           //!< [4] Auto CMD12 Index Error
        uint32_t RESERVED0 : 2;        //!< [6:5]
        uint32_t CNIBAC12E : 1;        //!< [7] Command Not Issued By Auto CMD12
                                       //! Error
        uint32_t RESERVED1 : 24;       //!< [31:8]
    } B;
} hw_sdhc_ac12err_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_AC12ERR register
 */
//@{
#define HW_SDHC_AC12ERR_ADDR     (REGS_SDHC_BASE + 0x3CU)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_AC12ERR          (*(__I hw_sdhc_ac12err_t *) HW_SDHC_AC12ERR_ADDR)
#define HW_SDHC_AC12ERR_RD()     (HW_SDHC_AC12ERR.U)
#endif
//@}

/*
 * Constants & macros for individual SDHC_AC12ERR bitfields
 */

/*!
 * @name Register SDHC_AC12ERR, field AC12NE[0] (RO)
 *
 * If memory multiple block data transfer is not started, due to a command
 * error, this bit is not set because it is not necessary to issue an auto CMD12.
 * Setting this bit to 1 means the SDHC cannot issue the auto CMD12 to stop a memory
 * multiple block data transfer due to some error. If this bit is set to 1, other
 * error status bits (1-4) have no meaning.
 *
 * Values:
 * - 0 - Executed.
 * - 1 - Not executed.
 */
//@{
#define BP_SDHC_AC12ERR_AC12NE (0U)        //!< Bit position for SDHC_AC12ERR_AC12NE.
#define BM_SDHC_AC12ERR_AC12NE (0x00000001U) //!< Bit mask for SDHC_AC12ERR_AC12NE.
#define BS_SDHC_AC12ERR_AC12NE (1U)        //!< Bit field size in bits for SDHC_AC12ERR_AC12NE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_AC12ERR_AC12NE field.
#define BR_SDHC_AC12ERR_AC12NE (BITBAND_ACCESS32(HW_SDHC_AC12ERR_ADDR, BP_SDHC_AC12ERR_AC12NE))
#endif
//@}

/*!
 * @name Register SDHC_AC12ERR, field AC12TOE[1] (RO)
 *
 * Occurs if no response is returned within 64 SDCLK cycles from the end bit of
 * the command. If this bit is set to 1, the other error status bits (2-4) have
 * no meaning.
 *
 * Values:
 * - 0 - No error.
 * - 1 - Time out.
 */
//@{
#define BP_SDHC_AC12ERR_AC12TOE (1U)       //!< Bit position for SDHC_AC12ERR_AC12TOE.
#define BM_SDHC_AC12ERR_AC12TOE (0x00000002U) //!< Bit mask for SDHC_AC12ERR_AC12TOE.
#define BS_SDHC_AC12ERR_AC12TOE (1U)       //!< Bit field size in bits for SDHC_AC12ERR_AC12TOE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_AC12ERR_AC12TOE field.
#define BR_SDHC_AC12ERR_AC12TOE (BITBAND_ACCESS32(HW_SDHC_AC12ERR_ADDR, BP_SDHC_AC12ERR_AC12TOE))
#endif
//@}

/*!
 * @name Register SDHC_AC12ERR, field AC12EBE[2] (RO)
 *
 * Occurs when detecting that the end bit of command response is 0 which must be
 * 1.
 *
 * Values:
 * - 0 - No error.
 * - 1 - End bit error generated.
 */
//@{
#define BP_SDHC_AC12ERR_AC12EBE (2U)       //!< Bit position for SDHC_AC12ERR_AC12EBE.
#define BM_SDHC_AC12ERR_AC12EBE (0x00000004U) //!< Bit mask for SDHC_AC12ERR_AC12EBE.
#define BS_SDHC_AC12ERR_AC12EBE (1U)       //!< Bit field size in bits for SDHC_AC12ERR_AC12EBE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_AC12ERR_AC12EBE field.
#define BR_SDHC_AC12ERR_AC12EBE (BITBAND_ACCESS32(HW_SDHC_AC12ERR_ADDR, BP_SDHC_AC12ERR_AC12EBE))
#endif
//@}

/*!
 * @name Register SDHC_AC12ERR, field AC12CE[3] (RO)
 *
 * Occurs when detecting a CRC error in the command response.
 *
 * Values:
 * - 0 - No CRC error.
 * - 1 - CRC error met in Auto CMD12 response.
 */
//@{
#define BP_SDHC_AC12ERR_AC12CE (3U)        //!< Bit position for SDHC_AC12ERR_AC12CE.
#define BM_SDHC_AC12ERR_AC12CE (0x00000008U) //!< Bit mask for SDHC_AC12ERR_AC12CE.
#define BS_SDHC_AC12ERR_AC12CE (1U)        //!< Bit field size in bits for SDHC_AC12ERR_AC12CE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_AC12ERR_AC12CE field.
#define BR_SDHC_AC12ERR_AC12CE (BITBAND_ACCESS32(HW_SDHC_AC12ERR_ADDR, BP_SDHC_AC12ERR_AC12CE))
#endif
//@}

/*!
 * @name Register SDHC_AC12ERR, field AC12IE[4] (RO)
 *
 * Occurs if the command index error occurs in response to a command.
 *
 * Values:
 * - 0 - No error.
 * - 1 - Error, the CMD index in response is not CMD12.
 */
//@{
#define BP_SDHC_AC12ERR_AC12IE (4U)        //!< Bit position for SDHC_AC12ERR_AC12IE.
#define BM_SDHC_AC12ERR_AC12IE (0x00000010U) //!< Bit mask for SDHC_AC12ERR_AC12IE.
#define BS_SDHC_AC12ERR_AC12IE (1U)        //!< Bit field size in bits for SDHC_AC12ERR_AC12IE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_AC12ERR_AC12IE field.
#define BR_SDHC_AC12ERR_AC12IE (BITBAND_ACCESS32(HW_SDHC_AC12ERR_ADDR, BP_SDHC_AC12ERR_AC12IE))
#endif
//@}

/*!
 * @name Register SDHC_AC12ERR, field CNIBAC12E[7] (RO)
 *
 * Setting this bit to 1 means CMD_wo_DAT is not executed due to an auto CMD12
 * error (D04-D01) in this register.
 *
 * Values:
 * - 0 - No error.
 * - 1 - Not issued.
 */
//@{
#define BP_SDHC_AC12ERR_CNIBAC12E (7U)     //!< Bit position for SDHC_AC12ERR_CNIBAC12E.
#define BM_SDHC_AC12ERR_CNIBAC12E (0x00000080U) //!< Bit mask for SDHC_AC12ERR_CNIBAC12E.
#define BS_SDHC_AC12ERR_CNIBAC12E (1U)     //!< Bit field size in bits for SDHC_AC12ERR_CNIBAC12E.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_AC12ERR_CNIBAC12E field.
#define BR_SDHC_AC12ERR_CNIBAC12E (BITBAND_ACCESS32(HW_SDHC_AC12ERR_ADDR, BP_SDHC_AC12ERR_CNIBAC12E))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_HTCAPBLT - Host Controller Capabilities
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_HTCAPBLT - Host Controller Capabilities (RO)
 *
 * Reset value: 0x07F30000U
 *
 * This register provides the host driver with information specific to the SDHC
 * implementation. The value in this register is the power-on-reset value, and
 * does not change with a software reset. Any write to this register is ignored.
 */
typedef union _hw_sdhc_htcapblt
{
    uint32_t U;
    struct _hw_sdhc_htcapblt_bitfields
    {
        uint32_t RESERVED0 : 16;       //!< [15:0]
        uint32_t MBL : 3;              //!< [18:16] Max Block Length
        uint32_t RESERVED1 : 1;        //!< [19]
        uint32_t ADMAS : 1;            //!< [20] ADMA Support
        uint32_t HSS : 1;              //!< [21] High Speed Support
        uint32_t DMAS : 1;             //!< [22] DMA Support
        uint32_t SRS : 1;              //!< [23] Suspend/Resume Support
        uint32_t VS33 : 1;             //!< [24] Voltage Support 3.3 V
        uint32_t RESERVED2 : 7;        //!< [31:25]
    } B;
} hw_sdhc_htcapblt_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_HTCAPBLT register
 */
//@{
#define HW_SDHC_HTCAPBLT_ADDR    (REGS_SDHC_BASE + 0x40U)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_HTCAPBLT         (*(__I hw_sdhc_htcapblt_t *) HW_SDHC_HTCAPBLT_ADDR)
#define HW_SDHC_HTCAPBLT_RD()    (HW_SDHC_HTCAPBLT.U)
#endif
//@}

/*
 * Constants & macros for individual SDHC_HTCAPBLT bitfields
 */

/*!
 * @name Register SDHC_HTCAPBLT, field MBL[18:16] (RO)
 *
 * This value indicates the maximum block size that the host driver can read and
 * write to the buffer in the SDHC. The buffer shall transfer block size without
 * wait cycles.
 *
 * Values:
 * - 000 - 512 bytes
 * - 001 - 1024 bytes
 * - 010 - 2048 bytes
 * - 011 - 4096 bytes
 */
//@{
#define BP_SDHC_HTCAPBLT_MBL (16U)         //!< Bit position for SDHC_HTCAPBLT_MBL.
#define BM_SDHC_HTCAPBLT_MBL (0x00070000U) //!< Bit mask for SDHC_HTCAPBLT_MBL.
#define BS_SDHC_HTCAPBLT_MBL (3U)          //!< Bit field size in bits for SDHC_HTCAPBLT_MBL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_HTCAPBLT_MBL field.
#define BR_SDHC_HTCAPBLT_MBL (HW_SDHC_HTCAPBLT.B.MBL)
#endif
//@}

/*!
 * @name Register SDHC_HTCAPBLT, field ADMAS[20] (RO)
 *
 * This bit indicates whether the SDHC supports the ADMA feature.
 *
 * Values:
 * - 0 - Advanced DMA not supported.
 * - 1 - Advanced DMA supported.
 */
//@{
#define BP_SDHC_HTCAPBLT_ADMAS (20U)       //!< Bit position for SDHC_HTCAPBLT_ADMAS.
#define BM_SDHC_HTCAPBLT_ADMAS (0x00100000U) //!< Bit mask for SDHC_HTCAPBLT_ADMAS.
#define BS_SDHC_HTCAPBLT_ADMAS (1U)        //!< Bit field size in bits for SDHC_HTCAPBLT_ADMAS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_HTCAPBLT_ADMAS field.
#define BR_SDHC_HTCAPBLT_ADMAS (BITBAND_ACCESS32(HW_SDHC_HTCAPBLT_ADDR, BP_SDHC_HTCAPBLT_ADMAS))
#endif
//@}

/*!
 * @name Register SDHC_HTCAPBLT, field HSS[21] (RO)
 *
 * This bit indicates whether the SDHC supports high speed mode and the host
 * system can supply a SD Clock frequency from 25 MHz to 50 MHz.
 *
 * Values:
 * - 0 - High speed not supported.
 * - 1 - High speed supported.
 */
//@{
#define BP_SDHC_HTCAPBLT_HSS (21U)         //!< Bit position for SDHC_HTCAPBLT_HSS.
#define BM_SDHC_HTCAPBLT_HSS (0x00200000U) //!< Bit mask for SDHC_HTCAPBLT_HSS.
#define BS_SDHC_HTCAPBLT_HSS (1U)          //!< Bit field size in bits for SDHC_HTCAPBLT_HSS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_HTCAPBLT_HSS field.
#define BR_SDHC_HTCAPBLT_HSS (BITBAND_ACCESS32(HW_SDHC_HTCAPBLT_ADDR, BP_SDHC_HTCAPBLT_HSS))
#endif
//@}

/*!
 * @name Register SDHC_HTCAPBLT, field DMAS[22] (RO)
 *
 * This bit indicates whether the SDHC is capable of using the internal DMA to
 * transfer data between system memory and the data buffer directly.
 *
 * Values:
 * - 0 - DMA not supported.
 * - 1 - DMA supported.
 */
//@{
#define BP_SDHC_HTCAPBLT_DMAS (22U)        //!< Bit position for SDHC_HTCAPBLT_DMAS.
#define BM_SDHC_HTCAPBLT_DMAS (0x00400000U) //!< Bit mask for SDHC_HTCAPBLT_DMAS.
#define BS_SDHC_HTCAPBLT_DMAS (1U)         //!< Bit field size in bits for SDHC_HTCAPBLT_DMAS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_HTCAPBLT_DMAS field.
#define BR_SDHC_HTCAPBLT_DMAS (BITBAND_ACCESS32(HW_SDHC_HTCAPBLT_ADDR, BP_SDHC_HTCAPBLT_DMAS))
#endif
//@}

/*!
 * @name Register SDHC_HTCAPBLT, field SRS[23] (RO)
 *
 * This bit indicates whether the SDHC supports suspend / resume functionality.
 * If this bit is 0, the suspend and resume mechanism, as well as the read Wwait,
 * are not supported, and the host driver shall not issue either suspend or
 * resume commands.
 *
 * Values:
 * - 0 - Not supported.
 * - 1 - Supported.
 */
//@{
#define BP_SDHC_HTCAPBLT_SRS (23U)         //!< Bit position for SDHC_HTCAPBLT_SRS.
#define BM_SDHC_HTCAPBLT_SRS (0x00800000U) //!< Bit mask for SDHC_HTCAPBLT_SRS.
#define BS_SDHC_HTCAPBLT_SRS (1U)          //!< Bit field size in bits for SDHC_HTCAPBLT_SRS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_HTCAPBLT_SRS field.
#define BR_SDHC_HTCAPBLT_SRS (BITBAND_ACCESS32(HW_SDHC_HTCAPBLT_ADDR, BP_SDHC_HTCAPBLT_SRS))
#endif
//@}

/*!
 * @name Register SDHC_HTCAPBLT, field VS33[24] (RO)
 *
 * This bit shall depend on the host system ability.
 *
 * Values:
 * - 0 - 3.3 V not supported.
 * - 1 - 3.3 V supported.
 */
//@{
#define BP_SDHC_HTCAPBLT_VS33 (24U)        //!< Bit position for SDHC_HTCAPBLT_VS33.
#define BM_SDHC_HTCAPBLT_VS33 (0x01000000U) //!< Bit mask for SDHC_HTCAPBLT_VS33.
#define BS_SDHC_HTCAPBLT_VS33 (1U)         //!< Bit field size in bits for SDHC_HTCAPBLT_VS33.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_HTCAPBLT_VS33 field.
#define BR_SDHC_HTCAPBLT_VS33 (BITBAND_ACCESS32(HW_SDHC_HTCAPBLT_ADDR, BP_SDHC_HTCAPBLT_VS33))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_WML - Watermark Level Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_WML - Watermark Level Register (RW)
 *
 * Reset value: 0x00100010U
 *
 * Both write and read watermark levels (FIFO threshold) are configurable. There
 * value can range from 1 to 128 words. Both write and read burst lengths are
 * also configurable. There value can range from 1 to 31 words.
 */
typedef union _hw_sdhc_wml
{
    uint32_t U;
    struct _hw_sdhc_wml_bitfields
    {
        uint32_t RDWML : 8;            //!< [7:0] Read Watermark Level
        uint32_t RESERVED0 : 8;        //!< [15:8]
        uint32_t WRWML : 8;            //!< [23:16] Write Watermark Level
        uint32_t RESERVED1 : 8;        //!< [31:24]
    } B;
} hw_sdhc_wml_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_WML register
 */
//@{
#define HW_SDHC_WML_ADDR         (REGS_SDHC_BASE + 0x44U)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_WML              (*(__IO hw_sdhc_wml_t *) HW_SDHC_WML_ADDR)
#define HW_SDHC_WML_RD()         (HW_SDHC_WML.U)
#define HW_SDHC_WML_WR(v)        (HW_SDHC_WML.U = (v))
#define HW_SDHC_WML_SET(v)       (HW_SDHC_WML_WR(HW_SDHC_WML_RD() |  (v)))
#define HW_SDHC_WML_CLR(v)       (HW_SDHC_WML_WR(HW_SDHC_WML_RD() & ~(v)))
#define HW_SDHC_WML_TOG(v)       (HW_SDHC_WML_WR(HW_SDHC_WML_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SDHC_WML bitfields
 */

/*!
 * @name Register SDHC_WML, field RDWML[7:0] (RW)
 *
 * The number of words used as the watermark level (FIFO threshold) in a DMA
 * read operation. Also the number of words as a sequence of read bursts in
 * back-to-back mode. The maximum legal value for the read water mark level is 128.
 */
//@{
#define BP_SDHC_WML_RDWML    (0U)          //!< Bit position for SDHC_WML_RDWML.
#define BM_SDHC_WML_RDWML    (0x000000FFU) //!< Bit mask for SDHC_WML_RDWML.
#define BS_SDHC_WML_RDWML    (8U)          //!< Bit field size in bits for SDHC_WML_RDWML.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_WML_RDWML field.
#define BR_SDHC_WML_RDWML    (HW_SDHC_WML.B.RDWML)
#endif

//! @brief Format value for bitfield SDHC_WML_RDWML.
#define BF_SDHC_WML_RDWML(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_WML_RDWML), uint32_t) & BM_SDHC_WML_RDWML)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RDWML field to a new value.
#define BW_SDHC_WML_RDWML(v) (HW_SDHC_WML_WR((HW_SDHC_WML_RD() & ~BM_SDHC_WML_RDWML) | BF_SDHC_WML_RDWML(v)))
#endif
//@}

/*!
 * @name Register SDHC_WML, field WRWML[23:16] (RW)
 *
 * The number of words used as the watermark level (FIFO threshold) in a DMA
 * write operation. Also the number of words as a sequence of write bursts in
 * back-to-back mode. The maximum legal value for the write watermark level is 128.
 */
//@{
#define BP_SDHC_WML_WRWML    (16U)         //!< Bit position for SDHC_WML_WRWML.
#define BM_SDHC_WML_WRWML    (0x00FF0000U) //!< Bit mask for SDHC_WML_WRWML.
#define BS_SDHC_WML_WRWML    (8U)          //!< Bit field size in bits for SDHC_WML_WRWML.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_WML_WRWML field.
#define BR_SDHC_WML_WRWML    (HW_SDHC_WML.B.WRWML)
#endif

//! @brief Format value for bitfield SDHC_WML_WRWML.
#define BF_SDHC_WML_WRWML(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_WML_WRWML), uint32_t) & BM_SDHC_WML_WRWML)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WRWML field to a new value.
#define BW_SDHC_WML_WRWML(v) (HW_SDHC_WML_WR((HW_SDHC_WML_RD() & ~BM_SDHC_WML_WRWML) | BF_SDHC_WML_WRWML(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_FEVT - Force Event register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_FEVT - Force Event register (WO)
 *
 * Reset value: 0x00000000U
 *
 * The Force Event (FEVT) register is not a physically implemented register.
 * Rather, it is an address at which the Interrupt Status register can be written if
 * the corresponding bit of the Interrupt Status Enable register is set. This
 * register is a write only register and writing 0 to it has no effect. Writing 1
 * to this register actually sets the corresponding bit of Interrupt Status
 * register. A read from this register always results in 0's. To change the
 * corresponding status bits in the interrupt status register, make sure to set
 * SYSCTL[IPGEN] so that bus clock is always active. Forcing a card interrupt will generate a
 * short pulse on the DAT[1] line, and the driver may treat this interrupt as a
 * normal interrupt. The interrupt service routine may skip polling the card
 * interrupt factor as the interrupt is selfcleared.
 */
typedef union _hw_sdhc_fevt
{
    uint32_t U;
    struct _hw_sdhc_fevt_bitfields
    {
        uint32_t AC12NE : 1;           //!< [0] Force Event Auto Command 12 Not Executed
        uint32_t AC12TOE : 1;          //!< [1] Force Event Auto Command 12 Time Out
                                       //! Error
        uint32_t AC12CE : 1;           //!< [2] Force Event Auto Command 12 CRC Error
        uint32_t AC12EBE : 1;          //!< [3] Force Event Auto Command 12 End Bit
                                       //! Error
        uint32_t AC12IE : 1;           //!< [4] Force Event Auto Command 12 Index Error
        uint32_t RESERVED0 : 2;        //!< [6:5]
        uint32_t CNIBAC12E : 1;        //!< [7] Force Event Command Not Executed By
                                       //! Auto Command 12 Error
        uint32_t RESERVED1 : 8;        //!< [15:8]
        uint32_t CTOE : 1;             //!< [16] Force Event Command Time Out Error
        uint32_t CCE : 1;              //!< [17] Force Event Command CRC Error
        uint32_t CEBE : 1;             //!< [18] Force Event Command End Bit Error
        uint32_t CIE : 1;              //!< [19] Force Event Command Index Error
        uint32_t DTOE : 1;             //!< [20] Force Event Data Time Out Error
        uint32_t DCE : 1;              //!< [21] Force Event Data CRC Error
        uint32_t DEBE : 1;             //!< [22] Force Event Data End Bit Error
        uint32_t RESERVED2 : 1;        //!< [23]
        uint32_t AC12E : 1;            //!< [24] Force Event Auto Command 12 Error
        uint32_t RESERVED3 : 3;        //!< [27:25]
        uint32_t DMAE : 1;             //!< [28] Force Event DMA Error
        uint32_t RESERVED4 : 2;        //!< [30:29]
        uint32_t CINT : 1;             //!< [31] Force Event Card Interrupt
    } B;
} hw_sdhc_fevt_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_FEVT register
 */
//@{
#define HW_SDHC_FEVT_ADDR        (REGS_SDHC_BASE + 0x50U)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_FEVT             (*(__O hw_sdhc_fevt_t *) HW_SDHC_FEVT_ADDR)
#define HW_SDHC_FEVT_RD()        (HW_SDHC_FEVT.U)
#define HW_SDHC_FEVT_WR(v)       (HW_SDHC_FEVT.U = (v))
#endif
//@}

/*
 * Constants & macros for individual SDHC_FEVT bitfields
 */

/*!
 * @name Register SDHC_FEVT, field AC12NE[0] (WORZ)
 *
 * Forces AC12ERR[AC12NE] to be set.
 */
//@{
#define BP_SDHC_FEVT_AC12NE  (0U)          //!< Bit position for SDHC_FEVT_AC12NE.
#define BM_SDHC_FEVT_AC12NE  (0x00000001U) //!< Bit mask for SDHC_FEVT_AC12NE.
#define BS_SDHC_FEVT_AC12NE  (1U)          //!< Bit field size in bits for SDHC_FEVT_AC12NE.

//! @brief Format value for bitfield SDHC_FEVT_AC12NE.
#define BF_SDHC_FEVT_AC12NE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_FEVT_AC12NE), uint32_t) & BM_SDHC_FEVT_AC12NE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AC12NE field to a new value.
#define BW_SDHC_FEVT_AC12NE(v) (BITBAND_ACCESS32(HW_SDHC_FEVT_ADDR, BP_SDHC_FEVT_AC12NE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_FEVT, field AC12TOE[1] (WORZ)
 *
 * Forces AC12ERR[AC12TOE] to be set.
 */
//@{
#define BP_SDHC_FEVT_AC12TOE (1U)          //!< Bit position for SDHC_FEVT_AC12TOE.
#define BM_SDHC_FEVT_AC12TOE (0x00000002U) //!< Bit mask for SDHC_FEVT_AC12TOE.
#define BS_SDHC_FEVT_AC12TOE (1U)          //!< Bit field size in bits for SDHC_FEVT_AC12TOE.

//! @brief Format value for bitfield SDHC_FEVT_AC12TOE.
#define BF_SDHC_FEVT_AC12TOE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_FEVT_AC12TOE), uint32_t) & BM_SDHC_FEVT_AC12TOE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AC12TOE field to a new value.
#define BW_SDHC_FEVT_AC12TOE(v) (BITBAND_ACCESS32(HW_SDHC_FEVT_ADDR, BP_SDHC_FEVT_AC12TOE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_FEVT, field AC12CE[2] (WORZ)
 *
 * Forces AC12ERR[AC12CE] to be set.
 */
//@{
#define BP_SDHC_FEVT_AC12CE  (2U)          //!< Bit position for SDHC_FEVT_AC12CE.
#define BM_SDHC_FEVT_AC12CE  (0x00000004U) //!< Bit mask for SDHC_FEVT_AC12CE.
#define BS_SDHC_FEVT_AC12CE  (1U)          //!< Bit field size in bits for SDHC_FEVT_AC12CE.

//! @brief Format value for bitfield SDHC_FEVT_AC12CE.
#define BF_SDHC_FEVT_AC12CE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_FEVT_AC12CE), uint32_t) & BM_SDHC_FEVT_AC12CE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AC12CE field to a new value.
#define BW_SDHC_FEVT_AC12CE(v) (BITBAND_ACCESS32(HW_SDHC_FEVT_ADDR, BP_SDHC_FEVT_AC12CE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_FEVT, field AC12EBE[3] (WORZ)
 *
 * Forces AC12ERR[AC12EBE] to be set.
 */
//@{
#define BP_SDHC_FEVT_AC12EBE (3U)          //!< Bit position for SDHC_FEVT_AC12EBE.
#define BM_SDHC_FEVT_AC12EBE (0x00000008U) //!< Bit mask for SDHC_FEVT_AC12EBE.
#define BS_SDHC_FEVT_AC12EBE (1U)          //!< Bit field size in bits for SDHC_FEVT_AC12EBE.

//! @brief Format value for bitfield SDHC_FEVT_AC12EBE.
#define BF_SDHC_FEVT_AC12EBE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_FEVT_AC12EBE), uint32_t) & BM_SDHC_FEVT_AC12EBE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AC12EBE field to a new value.
#define BW_SDHC_FEVT_AC12EBE(v) (BITBAND_ACCESS32(HW_SDHC_FEVT_ADDR, BP_SDHC_FEVT_AC12EBE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_FEVT, field AC12IE[4] (WORZ)
 *
 * Forces AC12ERR[AC12IE] to be set.
 */
//@{
#define BP_SDHC_FEVT_AC12IE  (4U)          //!< Bit position for SDHC_FEVT_AC12IE.
#define BM_SDHC_FEVT_AC12IE  (0x00000010U) //!< Bit mask for SDHC_FEVT_AC12IE.
#define BS_SDHC_FEVT_AC12IE  (1U)          //!< Bit field size in bits for SDHC_FEVT_AC12IE.

//! @brief Format value for bitfield SDHC_FEVT_AC12IE.
#define BF_SDHC_FEVT_AC12IE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_FEVT_AC12IE), uint32_t) & BM_SDHC_FEVT_AC12IE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AC12IE field to a new value.
#define BW_SDHC_FEVT_AC12IE(v) (BITBAND_ACCESS32(HW_SDHC_FEVT_ADDR, BP_SDHC_FEVT_AC12IE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_FEVT, field CNIBAC12E[7] (WORZ)
 *
 * Forces AC12ERR[CNIBAC12E] to be set.
 */
//@{
#define BP_SDHC_FEVT_CNIBAC12E (7U)        //!< Bit position for SDHC_FEVT_CNIBAC12E.
#define BM_SDHC_FEVT_CNIBAC12E (0x00000080U) //!< Bit mask for SDHC_FEVT_CNIBAC12E.
#define BS_SDHC_FEVT_CNIBAC12E (1U)        //!< Bit field size in bits for SDHC_FEVT_CNIBAC12E.

//! @brief Format value for bitfield SDHC_FEVT_CNIBAC12E.
#define BF_SDHC_FEVT_CNIBAC12E(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_FEVT_CNIBAC12E), uint32_t) & BM_SDHC_FEVT_CNIBAC12E)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CNIBAC12E field to a new value.
#define BW_SDHC_FEVT_CNIBAC12E(v) (BITBAND_ACCESS32(HW_SDHC_FEVT_ADDR, BP_SDHC_FEVT_CNIBAC12E) = (v))
#endif
//@}

/*!
 * @name Register SDHC_FEVT, field CTOE[16] (WORZ)
 *
 * Forces IRQSTAT[CTOE] to be set.
 */
//@{
#define BP_SDHC_FEVT_CTOE    (16U)         //!< Bit position for SDHC_FEVT_CTOE.
#define BM_SDHC_FEVT_CTOE    (0x00010000U) //!< Bit mask for SDHC_FEVT_CTOE.
#define BS_SDHC_FEVT_CTOE    (1U)          //!< Bit field size in bits for SDHC_FEVT_CTOE.

//! @brief Format value for bitfield SDHC_FEVT_CTOE.
#define BF_SDHC_FEVT_CTOE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_FEVT_CTOE), uint32_t) & BM_SDHC_FEVT_CTOE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CTOE field to a new value.
#define BW_SDHC_FEVT_CTOE(v) (BITBAND_ACCESS32(HW_SDHC_FEVT_ADDR, BP_SDHC_FEVT_CTOE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_FEVT, field CCE[17] (WORZ)
 *
 * Forces IRQSTAT[CCE] to be set.
 */
//@{
#define BP_SDHC_FEVT_CCE     (17U)         //!< Bit position for SDHC_FEVT_CCE.
#define BM_SDHC_FEVT_CCE     (0x00020000U) //!< Bit mask for SDHC_FEVT_CCE.
#define BS_SDHC_FEVT_CCE     (1U)          //!< Bit field size in bits for SDHC_FEVT_CCE.

//! @brief Format value for bitfield SDHC_FEVT_CCE.
#define BF_SDHC_FEVT_CCE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_FEVT_CCE), uint32_t) & BM_SDHC_FEVT_CCE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CCE field to a new value.
#define BW_SDHC_FEVT_CCE(v)  (BITBAND_ACCESS32(HW_SDHC_FEVT_ADDR, BP_SDHC_FEVT_CCE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_FEVT, field CEBE[18] (WORZ)
 *
 * Forces IRQSTAT[CEBE] to be set.
 */
//@{
#define BP_SDHC_FEVT_CEBE    (18U)         //!< Bit position for SDHC_FEVT_CEBE.
#define BM_SDHC_FEVT_CEBE    (0x00040000U) //!< Bit mask for SDHC_FEVT_CEBE.
#define BS_SDHC_FEVT_CEBE    (1U)          //!< Bit field size in bits for SDHC_FEVT_CEBE.

//! @brief Format value for bitfield SDHC_FEVT_CEBE.
#define BF_SDHC_FEVT_CEBE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_FEVT_CEBE), uint32_t) & BM_SDHC_FEVT_CEBE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CEBE field to a new value.
#define BW_SDHC_FEVT_CEBE(v) (BITBAND_ACCESS32(HW_SDHC_FEVT_ADDR, BP_SDHC_FEVT_CEBE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_FEVT, field CIE[19] (WORZ)
 *
 * Forces IRQSTAT[CCE] to be set.
 */
//@{
#define BP_SDHC_FEVT_CIE     (19U)         //!< Bit position for SDHC_FEVT_CIE.
#define BM_SDHC_FEVT_CIE     (0x00080000U) //!< Bit mask for SDHC_FEVT_CIE.
#define BS_SDHC_FEVT_CIE     (1U)          //!< Bit field size in bits for SDHC_FEVT_CIE.

//! @brief Format value for bitfield SDHC_FEVT_CIE.
#define BF_SDHC_FEVT_CIE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_FEVT_CIE), uint32_t) & BM_SDHC_FEVT_CIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CIE field to a new value.
#define BW_SDHC_FEVT_CIE(v)  (BITBAND_ACCESS32(HW_SDHC_FEVT_ADDR, BP_SDHC_FEVT_CIE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_FEVT, field DTOE[20] (WORZ)
 *
 * Forces IRQSTAT[DTOE] to be set.
 */
//@{
#define BP_SDHC_FEVT_DTOE    (20U)         //!< Bit position for SDHC_FEVT_DTOE.
#define BM_SDHC_FEVT_DTOE    (0x00100000U) //!< Bit mask for SDHC_FEVT_DTOE.
#define BS_SDHC_FEVT_DTOE    (1U)          //!< Bit field size in bits for SDHC_FEVT_DTOE.

//! @brief Format value for bitfield SDHC_FEVT_DTOE.
#define BF_SDHC_FEVT_DTOE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_FEVT_DTOE), uint32_t) & BM_SDHC_FEVT_DTOE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DTOE field to a new value.
#define BW_SDHC_FEVT_DTOE(v) (BITBAND_ACCESS32(HW_SDHC_FEVT_ADDR, BP_SDHC_FEVT_DTOE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_FEVT, field DCE[21] (WORZ)
 *
 * Forces IRQSTAT[DCE] to be set.
 */
//@{
#define BP_SDHC_FEVT_DCE     (21U)         //!< Bit position for SDHC_FEVT_DCE.
#define BM_SDHC_FEVT_DCE     (0x00200000U) //!< Bit mask for SDHC_FEVT_DCE.
#define BS_SDHC_FEVT_DCE     (1U)          //!< Bit field size in bits for SDHC_FEVT_DCE.

//! @brief Format value for bitfield SDHC_FEVT_DCE.
#define BF_SDHC_FEVT_DCE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_FEVT_DCE), uint32_t) & BM_SDHC_FEVT_DCE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DCE field to a new value.
#define BW_SDHC_FEVT_DCE(v)  (BITBAND_ACCESS32(HW_SDHC_FEVT_ADDR, BP_SDHC_FEVT_DCE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_FEVT, field DEBE[22] (WORZ)
 *
 * Forces IRQSTAT[DEBE] to be set.
 */
//@{
#define BP_SDHC_FEVT_DEBE    (22U)         //!< Bit position for SDHC_FEVT_DEBE.
#define BM_SDHC_FEVT_DEBE    (0x00400000U) //!< Bit mask for SDHC_FEVT_DEBE.
#define BS_SDHC_FEVT_DEBE    (1U)          //!< Bit field size in bits for SDHC_FEVT_DEBE.

//! @brief Format value for bitfield SDHC_FEVT_DEBE.
#define BF_SDHC_FEVT_DEBE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_FEVT_DEBE), uint32_t) & BM_SDHC_FEVT_DEBE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DEBE field to a new value.
#define BW_SDHC_FEVT_DEBE(v) (BITBAND_ACCESS32(HW_SDHC_FEVT_ADDR, BP_SDHC_FEVT_DEBE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_FEVT, field AC12E[24] (WORZ)
 *
 * Forces IRQSTAT[AC12E] to be set.
 */
//@{
#define BP_SDHC_FEVT_AC12E   (24U)         //!< Bit position for SDHC_FEVT_AC12E.
#define BM_SDHC_FEVT_AC12E   (0x01000000U) //!< Bit mask for SDHC_FEVT_AC12E.
#define BS_SDHC_FEVT_AC12E   (1U)          //!< Bit field size in bits for SDHC_FEVT_AC12E.

//! @brief Format value for bitfield SDHC_FEVT_AC12E.
#define BF_SDHC_FEVT_AC12E(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_FEVT_AC12E), uint32_t) & BM_SDHC_FEVT_AC12E)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AC12E field to a new value.
#define BW_SDHC_FEVT_AC12E(v) (BITBAND_ACCESS32(HW_SDHC_FEVT_ADDR, BP_SDHC_FEVT_AC12E) = (v))
#endif
//@}

/*!
 * @name Register SDHC_FEVT, field DMAE[28] (WORZ)
 *
 * Forces the DMAE bit of Interrupt Status Register to be set.
 */
//@{
#define BP_SDHC_FEVT_DMAE    (28U)         //!< Bit position for SDHC_FEVT_DMAE.
#define BM_SDHC_FEVT_DMAE    (0x10000000U) //!< Bit mask for SDHC_FEVT_DMAE.
#define BS_SDHC_FEVT_DMAE    (1U)          //!< Bit field size in bits for SDHC_FEVT_DMAE.

//! @brief Format value for bitfield SDHC_FEVT_DMAE.
#define BF_SDHC_FEVT_DMAE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_FEVT_DMAE), uint32_t) & BM_SDHC_FEVT_DMAE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DMAE field to a new value.
#define BW_SDHC_FEVT_DMAE(v) (BITBAND_ACCESS32(HW_SDHC_FEVT_ADDR, BP_SDHC_FEVT_DMAE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_FEVT, field CINT[31] (WORZ)
 *
 * Writing 1 to this bit generates a short low-level pulse on the internal
 * DAT[1] line, as if a self-clearing interrupt was received from the external card.
 * If enabled, the CINT bit will be set and the interrupt service routine may
 * treat this interrupt as a normal interrupt from the external card.
 */
//@{
#define BP_SDHC_FEVT_CINT    (31U)         //!< Bit position for SDHC_FEVT_CINT.
#define BM_SDHC_FEVT_CINT    (0x80000000U) //!< Bit mask for SDHC_FEVT_CINT.
#define BS_SDHC_FEVT_CINT    (1U)          //!< Bit field size in bits for SDHC_FEVT_CINT.

//! @brief Format value for bitfield SDHC_FEVT_CINT.
#define BF_SDHC_FEVT_CINT(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_FEVT_CINT), uint32_t) & BM_SDHC_FEVT_CINT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CINT field to a new value.
#define BW_SDHC_FEVT_CINT(v) (BITBAND_ACCESS32(HW_SDHC_FEVT_ADDR, BP_SDHC_FEVT_CINT) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_ADMAES - ADMA Error Status register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_ADMAES - ADMA Error Status register (RO)
 *
 * Reset value: 0x00000000U
 *
 * When an ADMA error interrupt has occurred, the ADMA Error States field in
 * this register holds the ADMA state and the ADMA System Address register holds the
 * address around the error descriptor. For recovering from this error, the host
 * driver requires the ADMA state to identify the error descriptor address as
 * follows: ST_STOP: Previous location set in the ADMA System Address register is
 * the error descriptor address. ST_FDS: Current location set in the ADMA System
 * Address register is the error descriptor address. ST_CADR: This state is never
 * set because it only increments the descriptor pointer and doesn't generate an
 * ADMA error. ST_TFR: Previous location set in the ADMA System Address register
 * is the error descriptor address. In case of a write operation, the host driver
 * must use the ACMD22 to get the number of the written block, rather than using
 * this information, because unwritten data may exist in the host controller.
 * The host controller generates the ADMA error interrupt when it detects invalid
 * descriptor data (valid = 0) in the ST_FDS state. The host driver can
 * distinguish this error by reading the valid bit of the error descriptor. ADMA Error
 * State coding D01-D00 ADMA Error State when error has occurred Contents of ADMA
 * System Address register 00 ST_STOP (Stop DMA) Holds the address of the next
 * executable descriptor command 01 ST_FDS (fetch descriptor) Holds the valid
 * descriptor address 10 ST_CADR (change address) No ADMA error is generated 11 ST_TFR
 * (Transfer Data) Holds the address of the next executable descriptor command
 */
typedef union _hw_sdhc_admaes
{
    uint32_t U;
    struct _hw_sdhc_admaes_bitfields
    {
        uint32_t ADMAES : 2;           //!< [1:0] ADMA Error State (When ADMA Error Is
                                       //! Occurred.)
        uint32_t ADMALME : 1;          //!< [2] ADMA Length Mismatch Error
        uint32_t ADMADCE : 1;          //!< [3] ADMA Descriptor Error
        uint32_t RESERVED0 : 28;       //!< [31:4]
    } B;
} hw_sdhc_admaes_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_ADMAES register
 */
//@{
#define HW_SDHC_ADMAES_ADDR      (REGS_SDHC_BASE + 0x54U)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_ADMAES           (*(__I hw_sdhc_admaes_t *) HW_SDHC_ADMAES_ADDR)
#define HW_SDHC_ADMAES_RD()      (HW_SDHC_ADMAES.U)
#endif
//@}

/*
 * Constants & macros for individual SDHC_ADMAES bitfields
 */

/*!
 * @name Register SDHC_ADMAES, field ADMAES[1:0] (RO)
 *
 * Indicates the state of the ADMA when an error has occurred during an ADMA
 * data transfer.
 */
//@{
#define BP_SDHC_ADMAES_ADMAES (0U)         //!< Bit position for SDHC_ADMAES_ADMAES.
#define BM_SDHC_ADMAES_ADMAES (0x00000003U) //!< Bit mask for SDHC_ADMAES_ADMAES.
#define BS_SDHC_ADMAES_ADMAES (2U)         //!< Bit field size in bits for SDHC_ADMAES_ADMAES.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_ADMAES_ADMAES field.
#define BR_SDHC_ADMAES_ADMAES (HW_SDHC_ADMAES.B.ADMAES)
#endif
//@}

/*!
 * @name Register SDHC_ADMAES, field ADMALME[2] (RO)
 *
 * This error occurs in the following 2 cases: While the block count enable is
 * being set, the total data length specified by the descriptor table is different
 * from that specified by the block count and block length. Total data length
 * can not be divided by the block length.
 *
 * Values:
 * - 0 - No error.
 * - 1 - Error.
 */
//@{
#define BP_SDHC_ADMAES_ADMALME (2U)        //!< Bit position for SDHC_ADMAES_ADMALME.
#define BM_SDHC_ADMAES_ADMALME (0x00000004U) //!< Bit mask for SDHC_ADMAES_ADMALME.
#define BS_SDHC_ADMAES_ADMALME (1U)        //!< Bit field size in bits for SDHC_ADMAES_ADMALME.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_ADMAES_ADMALME field.
#define BR_SDHC_ADMAES_ADMALME (BITBAND_ACCESS32(HW_SDHC_ADMAES_ADDR, BP_SDHC_ADMAES_ADMALME))
#endif
//@}

/*!
 * @name Register SDHC_ADMAES, field ADMADCE[3] (RO)
 *
 * This error occurs when an invalid descriptor is fetched by ADMA.
 *
 * Values:
 * - 0 - No error.
 * - 1 - Error.
 */
//@{
#define BP_SDHC_ADMAES_ADMADCE (3U)        //!< Bit position for SDHC_ADMAES_ADMADCE.
#define BM_SDHC_ADMAES_ADMADCE (0x00000008U) //!< Bit mask for SDHC_ADMAES_ADMADCE.
#define BS_SDHC_ADMAES_ADMADCE (1U)        //!< Bit field size in bits for SDHC_ADMAES_ADMADCE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_ADMAES_ADMADCE field.
#define BR_SDHC_ADMAES_ADMADCE (BITBAND_ACCESS32(HW_SDHC_ADMAES_ADDR, BP_SDHC_ADMAES_ADMADCE))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_ADSADDR - ADMA System Addressregister
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_ADSADDR - ADMA System Addressregister (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register contains the physical system memory address used for ADMA
 * transfers.
 */
typedef union _hw_sdhc_adsaddr
{
    uint32_t U;
    struct _hw_sdhc_adsaddr_bitfields
    {
        uint32_t RESERVED0 : 2;        //!< [1:0]
        uint32_t ADSADDR : 30;         //!< [31:2] ADMA System Address
    } B;
} hw_sdhc_adsaddr_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_ADSADDR register
 */
//@{
#define HW_SDHC_ADSADDR_ADDR     (REGS_SDHC_BASE + 0x58U)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_ADSADDR          (*(__IO hw_sdhc_adsaddr_t *) HW_SDHC_ADSADDR_ADDR)
#define HW_SDHC_ADSADDR_RD()     (HW_SDHC_ADSADDR.U)
#define HW_SDHC_ADSADDR_WR(v)    (HW_SDHC_ADSADDR.U = (v))
#define HW_SDHC_ADSADDR_SET(v)   (HW_SDHC_ADSADDR_WR(HW_SDHC_ADSADDR_RD() |  (v)))
#define HW_SDHC_ADSADDR_CLR(v)   (HW_SDHC_ADSADDR_WR(HW_SDHC_ADSADDR_RD() & ~(v)))
#define HW_SDHC_ADSADDR_TOG(v)   (HW_SDHC_ADSADDR_WR(HW_SDHC_ADSADDR_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SDHC_ADSADDR bitfields
 */

/*!
 * @name Register SDHC_ADSADDR, field ADSADDR[31:2] (RW)
 *
 * Holds the word address of the executing command in the descriptor table. At
 * the start of ADMA, the host driver shall set the start address of the
 * Descriptor table. The ADMA engine increments this register address whenever fetching a
 * descriptor command. When the ADMA is stopped at the block gap, this register
 * indicates the address of the next executable descriptor command. When the ADMA
 * error interrupt is generated, this register shall hold the valid descriptor
 * address depending on the ADMA state. The lower 2 bits of this register is tied
 * to '0' so the ADMA address is always word-aligned. Because this register
 * supports dynamic address reflecting, when TC bit is set, it automatically alters the
 * value of internal address counter, so SW cannot change this register when TC
 * bit is set.
 */
//@{
#define BP_SDHC_ADSADDR_ADSADDR (2U)       //!< Bit position for SDHC_ADSADDR_ADSADDR.
#define BM_SDHC_ADSADDR_ADSADDR (0xFFFFFFFCU) //!< Bit mask for SDHC_ADSADDR_ADSADDR.
#define BS_SDHC_ADSADDR_ADSADDR (30U)      //!< Bit field size in bits for SDHC_ADSADDR_ADSADDR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_ADSADDR_ADSADDR field.
#define BR_SDHC_ADSADDR_ADSADDR (HW_SDHC_ADSADDR.B.ADSADDR)
#endif

//! @brief Format value for bitfield SDHC_ADSADDR_ADSADDR.
#define BF_SDHC_ADSADDR_ADSADDR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_ADSADDR_ADSADDR), uint32_t) & BM_SDHC_ADSADDR_ADSADDR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ADSADDR field to a new value.
#define BW_SDHC_ADSADDR_ADSADDR(v) (HW_SDHC_ADSADDR_WR((HW_SDHC_ADSADDR_RD() & ~BM_SDHC_ADSADDR_ADSADDR) | BF_SDHC_ADSADDR_ADSADDR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_VENDOR - Vendor Specific register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_VENDOR - Vendor Specific register (RW)
 *
 * Reset value: 0x00000001U
 *
 * This register contains the vendor-specific control/status register.
 */
typedef union _hw_sdhc_vendor
{
    uint32_t U;
    struct _hw_sdhc_vendor_bitfields
    {
        uint32_t EXTDMAEN : 1;         //!< [0] External DMA Request Enable
        uint32_t EXBLKNU : 1;          //!< [1] Exact Block Number Block Read Enable
                                       //! For SDIO CMD53
        uint32_t RESERVED0 : 14;       //!< [15:2]
        uint32_t INTSTVAL : 8;         //!< [23:16] Internal State Value
        uint32_t RESERVED1 : 8;        //!< [31:24]
    } B;
} hw_sdhc_vendor_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_VENDOR register
 */
//@{
#define HW_SDHC_VENDOR_ADDR      (REGS_SDHC_BASE + 0xC0U)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_VENDOR           (*(__IO hw_sdhc_vendor_t *) HW_SDHC_VENDOR_ADDR)
#define HW_SDHC_VENDOR_RD()      (HW_SDHC_VENDOR.U)
#define HW_SDHC_VENDOR_WR(v)     (HW_SDHC_VENDOR.U = (v))
#define HW_SDHC_VENDOR_SET(v)    (HW_SDHC_VENDOR_WR(HW_SDHC_VENDOR_RD() |  (v)))
#define HW_SDHC_VENDOR_CLR(v)    (HW_SDHC_VENDOR_WR(HW_SDHC_VENDOR_RD() & ~(v)))
#define HW_SDHC_VENDOR_TOG(v)    (HW_SDHC_VENDOR_WR(HW_SDHC_VENDOR_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SDHC_VENDOR bitfields
 */

/*!
 * @name Register SDHC_VENDOR, field EXTDMAEN[0] (RW)
 *
 * Enables the request to external DMA. When the internal DMA (either simple DMA
 * or advanced DMA) is not in use, and this bit is set, SDHC will send out DMA
 * request when the internal buffer is ready. This bit is particularly useful when
 * transferring data by CPU polling mode, and it is not allowed to send out the
 * external DMA request. By default, this bit is set.
 *
 * Values:
 * - 0 - In any scenario, SDHC does not send out the external DMA request.
 * - 1 - When internal DMA is not active, the external DMA request will be sent
 *     out.
 */
//@{
#define BP_SDHC_VENDOR_EXTDMAEN (0U)       //!< Bit position for SDHC_VENDOR_EXTDMAEN.
#define BM_SDHC_VENDOR_EXTDMAEN (0x00000001U) //!< Bit mask for SDHC_VENDOR_EXTDMAEN.
#define BS_SDHC_VENDOR_EXTDMAEN (1U)       //!< Bit field size in bits for SDHC_VENDOR_EXTDMAEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_VENDOR_EXTDMAEN field.
#define BR_SDHC_VENDOR_EXTDMAEN (BITBAND_ACCESS32(HW_SDHC_VENDOR_ADDR, BP_SDHC_VENDOR_EXTDMAEN))
#endif

//! @brief Format value for bitfield SDHC_VENDOR_EXTDMAEN.
#define BF_SDHC_VENDOR_EXTDMAEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_VENDOR_EXTDMAEN), uint32_t) & BM_SDHC_VENDOR_EXTDMAEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EXTDMAEN field to a new value.
#define BW_SDHC_VENDOR_EXTDMAEN(v) (BITBAND_ACCESS32(HW_SDHC_VENDOR_ADDR, BP_SDHC_VENDOR_EXTDMAEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_VENDOR, field EXBLKNU[1] (RW)
 *
 * This bit must be set before S/W issues CMD53 multi-block read with exact
 * block number. This bit must not be set if the CMD53 multi-block read is not exact
 * block number.
 *
 * Values:
 * - 0 - None exact block read.
 * - 1 - Exact block read for SDIO CMD53.
 */
//@{
#define BP_SDHC_VENDOR_EXBLKNU (1U)        //!< Bit position for SDHC_VENDOR_EXBLKNU.
#define BM_SDHC_VENDOR_EXBLKNU (0x00000002U) //!< Bit mask for SDHC_VENDOR_EXBLKNU.
#define BS_SDHC_VENDOR_EXBLKNU (1U)        //!< Bit field size in bits for SDHC_VENDOR_EXBLKNU.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_VENDOR_EXBLKNU field.
#define BR_SDHC_VENDOR_EXBLKNU (BITBAND_ACCESS32(HW_SDHC_VENDOR_ADDR, BP_SDHC_VENDOR_EXBLKNU))
#endif

//! @brief Format value for bitfield SDHC_VENDOR_EXBLKNU.
#define BF_SDHC_VENDOR_EXBLKNU(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_VENDOR_EXBLKNU), uint32_t) & BM_SDHC_VENDOR_EXBLKNU)

#ifndef __LANGUAGE_ASM__
//! @brief Set the EXBLKNU field to a new value.
#define BW_SDHC_VENDOR_EXBLKNU(v) (BITBAND_ACCESS32(HW_SDHC_VENDOR_ADDR, BP_SDHC_VENDOR_EXBLKNU) = (v))
#endif
//@}

/*!
 * @name Register SDHC_VENDOR, field INTSTVAL[23:16] (RO)
 *
 * Internal state value, reflecting the corresponding state value selected by
 * Debug Select field. This field is read-only and write to this field does not
 * have effect.
 */
//@{
#define BP_SDHC_VENDOR_INTSTVAL (16U)      //!< Bit position for SDHC_VENDOR_INTSTVAL.
#define BM_SDHC_VENDOR_INTSTVAL (0x00FF0000U) //!< Bit mask for SDHC_VENDOR_INTSTVAL.
#define BS_SDHC_VENDOR_INTSTVAL (8U)       //!< Bit field size in bits for SDHC_VENDOR_INTSTVAL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_VENDOR_INTSTVAL field.
#define BR_SDHC_VENDOR_INTSTVAL (HW_SDHC_VENDOR.B.INTSTVAL)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_MMCBOOT - MMC Boot register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_MMCBOOT - MMC Boot register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register contains the MMC fast boot control register.
 */
typedef union _hw_sdhc_mmcboot
{
    uint32_t U;
    struct _hw_sdhc_mmcboot_bitfields
    {
        uint32_t DTOCVACK : 4;         //!< [3:0] Boot ACK Time Out Counter Value
        uint32_t BOOTACK : 1;          //!< [4] Boot Ack Mode Select
        uint32_t BOOTMODE : 1;         //!< [5] Boot Mode Select
        uint32_t BOOTEN : 1;           //!< [6] Boot Mode Enable
        uint32_t AUTOSABGEN : 1;       //!< [7]
        uint32_t RESERVED0 : 8;        //!< [15:8]
        uint32_t BOOTBLKCNT : 16;      //!< [31:16]
    } B;
} hw_sdhc_mmcboot_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_MMCBOOT register
 */
//@{
#define HW_SDHC_MMCBOOT_ADDR     (REGS_SDHC_BASE + 0xC4U)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_MMCBOOT          (*(__IO hw_sdhc_mmcboot_t *) HW_SDHC_MMCBOOT_ADDR)
#define HW_SDHC_MMCBOOT_RD()     (HW_SDHC_MMCBOOT.U)
#define HW_SDHC_MMCBOOT_WR(v)    (HW_SDHC_MMCBOOT.U = (v))
#define HW_SDHC_MMCBOOT_SET(v)   (HW_SDHC_MMCBOOT_WR(HW_SDHC_MMCBOOT_RD() |  (v)))
#define HW_SDHC_MMCBOOT_CLR(v)   (HW_SDHC_MMCBOOT_WR(HW_SDHC_MMCBOOT_RD() & ~(v)))
#define HW_SDHC_MMCBOOT_TOG(v)   (HW_SDHC_MMCBOOT_WR(HW_SDHC_MMCBOOT_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual SDHC_MMCBOOT bitfields
 */

/*!
 * @name Register SDHC_MMCBOOT, field DTOCVACK[3:0] (RW)
 *
 * Values:
 * - 0000 - SDCLK x 2^8
 * - 0001 - SDCLK x 2^9
 * - 0010 - SDCLK x 2^10
 * - 0011 - SDCLK x 2^11
 * - 0100 - SDCLK x 2^12
 * - 0101 - SDCLK x 2^13
 * - 0110 - SDCLK x 2^14
 * - 0111 - SDCLK x 2^15
 * - 1110 - SDCLK x 2^22
 * - 1111 - Reserved
 */
//@{
#define BP_SDHC_MMCBOOT_DTOCVACK (0U)      //!< Bit position for SDHC_MMCBOOT_DTOCVACK.
#define BM_SDHC_MMCBOOT_DTOCVACK (0x0000000FU) //!< Bit mask for SDHC_MMCBOOT_DTOCVACK.
#define BS_SDHC_MMCBOOT_DTOCVACK (4U)      //!< Bit field size in bits for SDHC_MMCBOOT_DTOCVACK.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_MMCBOOT_DTOCVACK field.
#define BR_SDHC_MMCBOOT_DTOCVACK (HW_SDHC_MMCBOOT.B.DTOCVACK)
#endif

//! @brief Format value for bitfield SDHC_MMCBOOT_DTOCVACK.
#define BF_SDHC_MMCBOOT_DTOCVACK(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_MMCBOOT_DTOCVACK), uint32_t) & BM_SDHC_MMCBOOT_DTOCVACK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DTOCVACK field to a new value.
#define BW_SDHC_MMCBOOT_DTOCVACK(v) (HW_SDHC_MMCBOOT_WR((HW_SDHC_MMCBOOT_RD() & ~BM_SDHC_MMCBOOT_DTOCVACK) | BF_SDHC_MMCBOOT_DTOCVACK(v)))
#endif
//@}

/*!
 * @name Register SDHC_MMCBOOT, field BOOTACK[4] (RW)
 *
 * Values:
 * - 0 - No ack.
 * - 1 - Ack.
 */
//@{
#define BP_SDHC_MMCBOOT_BOOTACK (4U)       //!< Bit position for SDHC_MMCBOOT_BOOTACK.
#define BM_SDHC_MMCBOOT_BOOTACK (0x00000010U) //!< Bit mask for SDHC_MMCBOOT_BOOTACK.
#define BS_SDHC_MMCBOOT_BOOTACK (1U)       //!< Bit field size in bits for SDHC_MMCBOOT_BOOTACK.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_MMCBOOT_BOOTACK field.
#define BR_SDHC_MMCBOOT_BOOTACK (BITBAND_ACCESS32(HW_SDHC_MMCBOOT_ADDR, BP_SDHC_MMCBOOT_BOOTACK))
#endif

//! @brief Format value for bitfield SDHC_MMCBOOT_BOOTACK.
#define BF_SDHC_MMCBOOT_BOOTACK(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_MMCBOOT_BOOTACK), uint32_t) & BM_SDHC_MMCBOOT_BOOTACK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BOOTACK field to a new value.
#define BW_SDHC_MMCBOOT_BOOTACK(v) (BITBAND_ACCESS32(HW_SDHC_MMCBOOT_ADDR, BP_SDHC_MMCBOOT_BOOTACK) = (v))
#endif
//@}

/*!
 * @name Register SDHC_MMCBOOT, field BOOTMODE[5] (RW)
 *
 * Values:
 * - 0 - Normal boot.
 * - 1 - Alternative boot.
 */
//@{
#define BP_SDHC_MMCBOOT_BOOTMODE (5U)      //!< Bit position for SDHC_MMCBOOT_BOOTMODE.
#define BM_SDHC_MMCBOOT_BOOTMODE (0x00000020U) //!< Bit mask for SDHC_MMCBOOT_BOOTMODE.
#define BS_SDHC_MMCBOOT_BOOTMODE (1U)      //!< Bit field size in bits for SDHC_MMCBOOT_BOOTMODE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_MMCBOOT_BOOTMODE field.
#define BR_SDHC_MMCBOOT_BOOTMODE (BITBAND_ACCESS32(HW_SDHC_MMCBOOT_ADDR, BP_SDHC_MMCBOOT_BOOTMODE))
#endif

//! @brief Format value for bitfield SDHC_MMCBOOT_BOOTMODE.
#define BF_SDHC_MMCBOOT_BOOTMODE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_MMCBOOT_BOOTMODE), uint32_t) & BM_SDHC_MMCBOOT_BOOTMODE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BOOTMODE field to a new value.
#define BW_SDHC_MMCBOOT_BOOTMODE(v) (BITBAND_ACCESS32(HW_SDHC_MMCBOOT_ADDR, BP_SDHC_MMCBOOT_BOOTMODE) = (v))
#endif
//@}

/*!
 * @name Register SDHC_MMCBOOT, field BOOTEN[6] (RW)
 *
 * Values:
 * - 0 - Fast boot disable.
 * - 1 - Fast boot enable.
 */
//@{
#define BP_SDHC_MMCBOOT_BOOTEN (6U)        //!< Bit position for SDHC_MMCBOOT_BOOTEN.
#define BM_SDHC_MMCBOOT_BOOTEN (0x00000040U) //!< Bit mask for SDHC_MMCBOOT_BOOTEN.
#define BS_SDHC_MMCBOOT_BOOTEN (1U)        //!< Bit field size in bits for SDHC_MMCBOOT_BOOTEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_MMCBOOT_BOOTEN field.
#define BR_SDHC_MMCBOOT_BOOTEN (BITBAND_ACCESS32(HW_SDHC_MMCBOOT_ADDR, BP_SDHC_MMCBOOT_BOOTEN))
#endif

//! @brief Format value for bitfield SDHC_MMCBOOT_BOOTEN.
#define BF_SDHC_MMCBOOT_BOOTEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_MMCBOOT_BOOTEN), uint32_t) & BM_SDHC_MMCBOOT_BOOTEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BOOTEN field to a new value.
#define BW_SDHC_MMCBOOT_BOOTEN(v) (BITBAND_ACCESS32(HW_SDHC_MMCBOOT_ADDR, BP_SDHC_MMCBOOT_BOOTEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_MMCBOOT, field AUTOSABGEN[7] (RW)
 *
 * When boot, enable auto stop at block gap function. This function will be
 * triggered, and host will stop at block gap when received card block cnt is equal
 * to BOOTBLKCNT.
 */
//@{
#define BP_SDHC_MMCBOOT_AUTOSABGEN (7U)    //!< Bit position for SDHC_MMCBOOT_AUTOSABGEN.
#define BM_SDHC_MMCBOOT_AUTOSABGEN (0x00000080U) //!< Bit mask for SDHC_MMCBOOT_AUTOSABGEN.
#define BS_SDHC_MMCBOOT_AUTOSABGEN (1U)    //!< Bit field size in bits for SDHC_MMCBOOT_AUTOSABGEN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_MMCBOOT_AUTOSABGEN field.
#define BR_SDHC_MMCBOOT_AUTOSABGEN (BITBAND_ACCESS32(HW_SDHC_MMCBOOT_ADDR, BP_SDHC_MMCBOOT_AUTOSABGEN))
#endif

//! @brief Format value for bitfield SDHC_MMCBOOT_AUTOSABGEN.
#define BF_SDHC_MMCBOOT_AUTOSABGEN(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_MMCBOOT_AUTOSABGEN), uint32_t) & BM_SDHC_MMCBOOT_AUTOSABGEN)

#ifndef __LANGUAGE_ASM__
//! @brief Set the AUTOSABGEN field to a new value.
#define BW_SDHC_MMCBOOT_AUTOSABGEN(v) (BITBAND_ACCESS32(HW_SDHC_MMCBOOT_ADDR, BP_SDHC_MMCBOOT_AUTOSABGEN) = (v))
#endif
//@}

/*!
 * @name Register SDHC_MMCBOOT, field BOOTBLKCNT[31:16] (RW)
 *
 * Defines the stop at block gap value of automatic mode. When received card
 * block cnt is equal to BOOTBLKCNT and AUTOSABGEN is 1, then stop at block gap.
 */
//@{
#define BP_SDHC_MMCBOOT_BOOTBLKCNT (16U)   //!< Bit position for SDHC_MMCBOOT_BOOTBLKCNT.
#define BM_SDHC_MMCBOOT_BOOTBLKCNT (0xFFFF0000U) //!< Bit mask for SDHC_MMCBOOT_BOOTBLKCNT.
#define BS_SDHC_MMCBOOT_BOOTBLKCNT (16U)   //!< Bit field size in bits for SDHC_MMCBOOT_BOOTBLKCNT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_MMCBOOT_BOOTBLKCNT field.
#define BR_SDHC_MMCBOOT_BOOTBLKCNT (HW_SDHC_MMCBOOT.B.BOOTBLKCNT)
#endif

//! @brief Format value for bitfield SDHC_MMCBOOT_BOOTBLKCNT.
#define BF_SDHC_MMCBOOT_BOOTBLKCNT(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_SDHC_MMCBOOT_BOOTBLKCNT), uint32_t) & BM_SDHC_MMCBOOT_BOOTBLKCNT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BOOTBLKCNT field to a new value.
#define BW_SDHC_MMCBOOT_BOOTBLKCNT(v) (HW_SDHC_MMCBOOT_WR((HW_SDHC_MMCBOOT_RD() & ~BM_SDHC_MMCBOOT_BOOTBLKCNT) | BF_SDHC_MMCBOOT_BOOTBLKCNT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_SDHC_HOSTVER - Host Controller Version
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_SDHC_HOSTVER - Host Controller Version (RO)
 *
 * Reset value: 0x00001201U
 *
 * This register contains the vendor host controller version information. All
 * bits are read only and will read the same as the power-reset value.
 */
typedef union _hw_sdhc_hostver
{
    uint32_t U;
    struct _hw_sdhc_hostver_bitfields
    {
        uint32_t SVN : 8;              //!< [7:0] Specification Version Number
        uint32_t VVN : 8;              //!< [15:8] Vendor Version Number
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_sdhc_hostver_t;
#endif

/*!
 * @name Constants and macros for entire SDHC_HOSTVER register
 */
//@{
#define HW_SDHC_HOSTVER_ADDR     (REGS_SDHC_BASE + 0xFCU)

#ifndef __LANGUAGE_ASM__
#define HW_SDHC_HOSTVER          (*(__I hw_sdhc_hostver_t *) HW_SDHC_HOSTVER_ADDR)
#define HW_SDHC_HOSTVER_RD()     (HW_SDHC_HOSTVER.U)
#endif
//@}

/*
 * Constants & macros for individual SDHC_HOSTVER bitfields
 */

/*!
 * @name Register SDHC_HOSTVER, field SVN[7:0] (RO)
 *
 * These status bits indicate the host controller specification version.
 *
 * Values:
 * - 1 - SD host specification version 2.0, supports test event register and
 *     ADMA.
 */
//@{
#define BP_SDHC_HOSTVER_SVN  (0U)          //!< Bit position for SDHC_HOSTVER_SVN.
#define BM_SDHC_HOSTVER_SVN  (0x000000FFU) //!< Bit mask for SDHC_HOSTVER_SVN.
#define BS_SDHC_HOSTVER_SVN  (8U)          //!< Bit field size in bits for SDHC_HOSTVER_SVN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_HOSTVER_SVN field.
#define BR_SDHC_HOSTVER_SVN  (HW_SDHC_HOSTVER.B.SVN)
#endif
//@}

/*!
 * @name Register SDHC_HOSTVER, field VVN[15:8] (RO)
 *
 * These status bits are reserved for the vendor version number. The host driver
 * shall not use this status.
 *
 * Values:
 * - 0 - Freescale SDHC version 1.0
 * - 10000 - Freescale SDHC version 2.0
 * - 10001 - Freescale SDHC version 2.1
 * - 10010 - Freescale SDHC version 2.2
 */
//@{
#define BP_SDHC_HOSTVER_VVN  (8U)          //!< Bit position for SDHC_HOSTVER_VVN.
#define BM_SDHC_HOSTVER_VVN  (0x0000FF00U) //!< Bit mask for SDHC_HOSTVER_VVN.
#define BS_SDHC_HOSTVER_VVN  (8U)          //!< Bit field size in bits for SDHC_HOSTVER_VVN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the SDHC_HOSTVER_VVN field.
#define BR_SDHC_HOSTVER_VVN  (HW_SDHC_HOSTVER.B.VVN)
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_sdhc_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All SDHC module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_sdhc
{
    __IO hw_sdhc_dsaddr_t DSADDR;          //!< [0x0] DMA System Address register
    __IO hw_sdhc_blkattr_t BLKATTR;        //!< [0x4] Block Attributes register
    __IO hw_sdhc_cmdarg_t CMDARG;          //!< [0x8] Command Argument register
    __IO hw_sdhc_xfertyp_t XFERTYP;        //!< [0xC] Transfer Type register
    __I hw_sdhc_cmdrsp0_t CMDRSP0;         //!< [0x10] Command Response 0
    __I hw_sdhc_cmdrsp1_t CMDRSP1;         //!< [0x14] Command Response 1
    __I hw_sdhc_cmdrsp2_t CMDRSP2;         //!< [0x18] Command Response 2
    __I hw_sdhc_cmdrsp3_t CMDRSP3;         //!< [0x1C] Command Response 3
    __IO hw_sdhc_datport_t DATPORT;        //!< [0x20] Buffer Data Port register
    __I hw_sdhc_prsstat_t PRSSTAT;         //!< [0x24] Present State register
    __IO hw_sdhc_proctl_t PROCTL;          //!< [0x28] Protocol Control register
    __IO hw_sdhc_sysctl_t SYSCTL;          //!< [0x2C] System Control register
    __IO hw_sdhc_irqstat_t IRQSTAT;        //!< [0x30] Interrupt Status register
    __IO hw_sdhc_irqstaten_t IRQSTATEN;    //!< [0x34] Interrupt Status Enable register
    __IO hw_sdhc_irqsigen_t IRQSIGEN;      //!< [0x38] Interrupt Signal Enable register
    __I hw_sdhc_ac12err_t AC12ERR;         //!< [0x3C] Auto CMD12 Error Status Register
    __I hw_sdhc_htcapblt_t HTCAPBLT;       //!< [0x40] Host Controller Capabilities
    __IO hw_sdhc_wml_t WML;                //!< [0x44] Watermark Level Register
    uint8_t _reserved0[8];
    __O hw_sdhc_fevt_t FEVT;               //!< [0x50] Force Event register
    __I hw_sdhc_admaes_t ADMAES;           //!< [0x54] ADMA Error Status register
    __IO hw_sdhc_adsaddr_t ADSADDR;        //!< [0x58] ADMA System Addressregister
    uint8_t _reserved1[100];
    __IO hw_sdhc_vendor_t VENDOR;          //!< [0xC0] Vendor Specific register
    __IO hw_sdhc_mmcboot_t MMCBOOT;        //!< [0xC4] MMC Boot register
    uint8_t _reserved2[52];
    __I hw_sdhc_hostver_t HOSTVER;         //!< [0xFC] Host Controller Version
} hw_sdhc_t;
#pragma pack()

//! @brief Macro to access all SDHC registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_SDHC</code>.
#define HW_SDHC        (*(hw_sdhc_t *) REGS_SDHC_BASE)
#endif

#endif // __HW_SDHC_REGISTERS_H__
// v22/130726/0.9
// EOF

