/*
 * Copyright (c) 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_RTC_REGISTERS_H__
#define __HW_RTC_REGISTERS_H__

#include "regs.h"

/*
 * MK64F12 RTC
 *
 * Secure Real Time Clock
 *
 * Registers defined in this header file:
 * - HW_RTC_TSR - RTC Time Seconds Register
 * - HW_RTC_TPR - RTC Time Prescaler Register
 * - HW_RTC_TAR - RTC Time Alarm Register
 * - HW_RTC_TCR - RTC Time Compensation Register
 * - HW_RTC_CR - RTC Control Register
 * - HW_RTC_SR - RTC Status Register
 * - HW_RTC_LR - RTC Lock Register
 * - HW_RTC_IER - RTC Interrupt Enable Register
 * - HW_RTC_WAR - RTC Write Access Register
 * - HW_RTC_RAR - RTC Read Access Register
 *
 * - hw_rtc_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_RTC_BASE
#define HW_RTC_INSTANCE_COUNT (1U) //!< Number of instances of the RTC module.
#define REGS_RTC_BASE (0x4003D000U) //!< Base address for RTC.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_RTC_TSR - RTC Time Seconds Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_RTC_TSR - RTC Time Seconds Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_rtc_tsr
{
    uint32_t U;
    struct _hw_rtc_tsr_bitfields
    {
        uint32_t TSR : 32;             //!< [31:0] Time Seconds Register
    } B;
} hw_rtc_tsr_t;
#endif

/*!
 * @name Constants and macros for entire RTC_TSR register
 */
//@{
#define HW_RTC_TSR_ADDR          (REGS_RTC_BASE + 0x0U)

#ifndef __LANGUAGE_ASM__
#define HW_RTC_TSR               (*(__IO hw_rtc_tsr_t *) HW_RTC_TSR_ADDR)
#define HW_RTC_TSR_RD()          (HW_RTC_TSR.U)
#define HW_RTC_TSR_WR(v)         (HW_RTC_TSR.U = (v))
#define HW_RTC_TSR_SET(v)        (HW_RTC_TSR_WR(HW_RTC_TSR_RD() |  (v)))
#define HW_RTC_TSR_CLR(v)        (HW_RTC_TSR_WR(HW_RTC_TSR_RD() & ~(v)))
#define HW_RTC_TSR_TOG(v)        (HW_RTC_TSR_WR(HW_RTC_TSR_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual RTC_TSR bitfields
 */

/*!
 * @name Register RTC_TSR, field TSR[31:0] (RW)
 *
 * When the time counter is enabled, the TSR is read only and increments once a
 * second provided SR[TOF] or SR[TIF] are not set. The time counter will read as
 * zero when SR[TOF] or SR[TIF] are set. When the time counter is disabled, the
 * TSR can be read or written. Writing to the TSR when the time counter is
 * disabled will clear the SR[TOF] and/or the SR[TIF]. Writing to TSR with zero is
 * supported, but not recommended because TSR will read as zero when SR[TIF] or
 * SR[TOF] are set (indicating the time is invalid).
 */
//@{
#define BP_RTC_TSR_TSR       (0U)          //!< Bit position for RTC_TSR_TSR.
#define BM_RTC_TSR_TSR       (0xFFFFFFFFU) //!< Bit mask for RTC_TSR_TSR.
#define BS_RTC_TSR_TSR       (32U)         //!< Bit field size in bits for RTC_TSR_TSR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_TSR_TSR field.
#define BR_RTC_TSR_TSR       (HW_RTC_TSR.U)
#endif

//! @brief Format value for bitfield RTC_TSR_TSR.
#define BF_RTC_TSR_TSR(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_TSR_TSR), uint32_t) & BM_RTC_TSR_TSR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TSR field to a new value.
#define BW_RTC_TSR_TSR(v)    (HW_RTC_TSR_WR(v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_RTC_TPR - RTC Time Prescaler Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_RTC_TPR - RTC Time Prescaler Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_rtc_tpr
{
    uint32_t U;
    struct _hw_rtc_tpr_bitfields
    {
        uint32_t TPR : 16;             //!< [15:0] Time Prescaler Register
        uint32_t RESERVED0 : 16;       //!< [31:16]
    } B;
} hw_rtc_tpr_t;
#endif

/*!
 * @name Constants and macros for entire RTC_TPR register
 */
//@{
#define HW_RTC_TPR_ADDR          (REGS_RTC_BASE + 0x4U)

#ifndef __LANGUAGE_ASM__
#define HW_RTC_TPR               (*(__IO hw_rtc_tpr_t *) HW_RTC_TPR_ADDR)
#define HW_RTC_TPR_RD()          (HW_RTC_TPR.U)
#define HW_RTC_TPR_WR(v)         (HW_RTC_TPR.U = (v))
#define HW_RTC_TPR_SET(v)        (HW_RTC_TPR_WR(HW_RTC_TPR_RD() |  (v)))
#define HW_RTC_TPR_CLR(v)        (HW_RTC_TPR_WR(HW_RTC_TPR_RD() & ~(v)))
#define HW_RTC_TPR_TOG(v)        (HW_RTC_TPR_WR(HW_RTC_TPR_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual RTC_TPR bitfields
 */

/*!
 * @name Register RTC_TPR, field TPR[15:0] (RW)
 *
 * When the time counter is enabled, the TPR is read only and increments every
 * 32.768 kHz clock cycle. The time counter will read as zero when SR[TOF] or
 * SR[TIF] are set. When the time counter is disabled, the TPR can be read or
 * written. The TSR[TSR] increments when bit 14 of the TPR transitions from a logic one
 * to a logic zero.
 */
//@{
#define BP_RTC_TPR_TPR       (0U)          //!< Bit position for RTC_TPR_TPR.
#define BM_RTC_TPR_TPR       (0x0000FFFFU) //!< Bit mask for RTC_TPR_TPR.
#define BS_RTC_TPR_TPR       (16U)         //!< Bit field size in bits for RTC_TPR_TPR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_TPR_TPR field.
#define BR_RTC_TPR_TPR       (HW_RTC_TPR.B.TPR)
#endif

//! @brief Format value for bitfield RTC_TPR_TPR.
#define BF_RTC_TPR_TPR(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_TPR_TPR), uint32_t) & BM_RTC_TPR_TPR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TPR field to a new value.
#define BW_RTC_TPR_TPR(v)    (HW_RTC_TPR_WR((HW_RTC_TPR_RD() & ~BM_RTC_TPR_TPR) | BF_RTC_TPR_TPR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_RTC_TAR - RTC Time Alarm Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_RTC_TAR - RTC Time Alarm Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_rtc_tar
{
    uint32_t U;
    struct _hw_rtc_tar_bitfields
    {
        uint32_t TAR : 32;             //!< [31:0] Time Alarm Register
    } B;
} hw_rtc_tar_t;
#endif

/*!
 * @name Constants and macros for entire RTC_TAR register
 */
//@{
#define HW_RTC_TAR_ADDR          (REGS_RTC_BASE + 0x8U)

#ifndef __LANGUAGE_ASM__
#define HW_RTC_TAR               (*(__IO hw_rtc_tar_t *) HW_RTC_TAR_ADDR)
#define HW_RTC_TAR_RD()          (HW_RTC_TAR.U)
#define HW_RTC_TAR_WR(v)         (HW_RTC_TAR.U = (v))
#define HW_RTC_TAR_SET(v)        (HW_RTC_TAR_WR(HW_RTC_TAR_RD() |  (v)))
#define HW_RTC_TAR_CLR(v)        (HW_RTC_TAR_WR(HW_RTC_TAR_RD() & ~(v)))
#define HW_RTC_TAR_TOG(v)        (HW_RTC_TAR_WR(HW_RTC_TAR_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual RTC_TAR bitfields
 */

/*!
 * @name Register RTC_TAR, field TAR[31:0] (RW)
 *
 * When the time counter is enabled, the SR[TAF] is set whenever the TAR[TAR]
 * equals the TSR[TSR] and the TSR[TSR] increments. Writing to the TAR clears the
 * SR[TAF].
 */
//@{
#define BP_RTC_TAR_TAR       (0U)          //!< Bit position for RTC_TAR_TAR.
#define BM_RTC_TAR_TAR       (0xFFFFFFFFU) //!< Bit mask for RTC_TAR_TAR.
#define BS_RTC_TAR_TAR       (32U)         //!< Bit field size in bits for RTC_TAR_TAR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_TAR_TAR field.
#define BR_RTC_TAR_TAR       (HW_RTC_TAR.U)
#endif

//! @brief Format value for bitfield RTC_TAR_TAR.
#define BF_RTC_TAR_TAR(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_TAR_TAR), uint32_t) & BM_RTC_TAR_TAR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TAR field to a new value.
#define BW_RTC_TAR_TAR(v)    (HW_RTC_TAR_WR(v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_RTC_TCR - RTC Time Compensation Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_RTC_TCR - RTC Time Compensation Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_rtc_tcr
{
    uint32_t U;
    struct _hw_rtc_tcr_bitfields
    {
        uint32_t TCR : 8;              //!< [7:0] Time Compensation Register
        uint32_t CIR : 8;              //!< [15:8] Compensation Interval Register
        uint32_t TCV : 8;              //!< [23:16] Time Compensation Value
        uint32_t CIC : 8;              //!< [31:24] Compensation Interval Counter
    } B;
} hw_rtc_tcr_t;
#endif

/*!
 * @name Constants and macros for entire RTC_TCR register
 */
//@{
#define HW_RTC_TCR_ADDR          (REGS_RTC_BASE + 0xCU)

#ifndef __LANGUAGE_ASM__
#define HW_RTC_TCR               (*(__IO hw_rtc_tcr_t *) HW_RTC_TCR_ADDR)
#define HW_RTC_TCR_RD()          (HW_RTC_TCR.U)
#define HW_RTC_TCR_WR(v)         (HW_RTC_TCR.U = (v))
#define HW_RTC_TCR_SET(v)        (HW_RTC_TCR_WR(HW_RTC_TCR_RD() |  (v)))
#define HW_RTC_TCR_CLR(v)        (HW_RTC_TCR_WR(HW_RTC_TCR_RD() & ~(v)))
#define HW_RTC_TCR_TOG(v)        (HW_RTC_TCR_WR(HW_RTC_TCR_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual RTC_TCR bitfields
 */

/*!
 * @name Register RTC_TCR, field TCR[7:0] (RW)
 *
 * Configures the number of 32.768 kHz clock cycles in each second. This
 * register is double buffered and writes do not take affect until the end of the
 * current compensation interval.
 *
 * Values:
 * - 10000000 - Time Prescaler Register overflows every 32896 clock cycles.
 * - 11111111 - Time Prescaler Register overflows every 32769 clock cycles.
 * - 0 - Time Prescaler Register overflows every 32768 clock cycles.
 * - 1 - Time Prescaler Register overflows every 32767 clock cycles.
 * - 1111111 - Time Prescaler Register overflows every 32641 clock cycles.
 */
//@{
#define BP_RTC_TCR_TCR       (0U)          //!< Bit position for RTC_TCR_TCR.
#define BM_RTC_TCR_TCR       (0x000000FFU) //!< Bit mask for RTC_TCR_TCR.
#define BS_RTC_TCR_TCR       (8U)          //!< Bit field size in bits for RTC_TCR_TCR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_TCR_TCR field.
#define BR_RTC_TCR_TCR       (HW_RTC_TCR.B.TCR)
#endif

//! @brief Format value for bitfield RTC_TCR_TCR.
#define BF_RTC_TCR_TCR(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_TCR_TCR), uint32_t) & BM_RTC_TCR_TCR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TCR field to a new value.
#define BW_RTC_TCR_TCR(v)    (HW_RTC_TCR_WR((HW_RTC_TCR_RD() & ~BM_RTC_TCR_TCR) | BF_RTC_TCR_TCR(v)))
#endif
//@}

/*!
 * @name Register RTC_TCR, field CIR[15:8] (RW)
 *
 * Configures the compensation interval in seconds from 1 to 256 to control how
 * frequently the TCR should adjust the number of 32.768 kHz cycles in each
 * second. The value written should be one less than the number of seconds. For
 * example, write zero to configure for a compensation interval of one second. This
 * register is double buffered and writes do not take affect until the end of the
 * current compensation interval.
 */
//@{
#define BP_RTC_TCR_CIR       (8U)          //!< Bit position for RTC_TCR_CIR.
#define BM_RTC_TCR_CIR       (0x0000FF00U) //!< Bit mask for RTC_TCR_CIR.
#define BS_RTC_TCR_CIR       (8U)          //!< Bit field size in bits for RTC_TCR_CIR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_TCR_CIR field.
#define BR_RTC_TCR_CIR       (HW_RTC_TCR.B.CIR)
#endif

//! @brief Format value for bitfield RTC_TCR_CIR.
#define BF_RTC_TCR_CIR(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_TCR_CIR), uint32_t) & BM_RTC_TCR_CIR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CIR field to a new value.
#define BW_RTC_TCR_CIR(v)    (HW_RTC_TCR_WR((HW_RTC_TCR_RD() & ~BM_RTC_TCR_CIR) | BF_RTC_TCR_CIR(v)))
#endif
//@}

/*!
 * @name Register RTC_TCR, field TCV[23:16] (RO)
 *
 * Current value used by the compensation logic for the present second interval.
 * Updated once a second if the CIC equals 0 with the contents of the TCR field.
 * If the CIC does not equal zero then it is loaded with zero (compensation is
 * not enabled for that second increment).
 */
//@{
#define BP_RTC_TCR_TCV       (16U)         //!< Bit position for RTC_TCR_TCV.
#define BM_RTC_TCR_TCV       (0x00FF0000U) //!< Bit mask for RTC_TCR_TCV.
#define BS_RTC_TCR_TCV       (8U)          //!< Bit field size in bits for RTC_TCR_TCV.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_TCR_TCV field.
#define BR_RTC_TCR_TCV       (HW_RTC_TCR.B.TCV)
#endif
//@}

/*!
 * @name Register RTC_TCR, field CIC[31:24] (RO)
 *
 * Current value of the compensation interval counter. If the compensation
 * interval counter equals zero then it is loaded with the contents of the CIR. If the
 * CIC does not equal zero then it is decremented once a second.
 */
//@{
#define BP_RTC_TCR_CIC       (24U)         //!< Bit position for RTC_TCR_CIC.
#define BM_RTC_TCR_CIC       (0xFF000000U) //!< Bit mask for RTC_TCR_CIC.
#define BS_RTC_TCR_CIC       (8U)          //!< Bit field size in bits for RTC_TCR_CIC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_TCR_CIC field.
#define BR_RTC_TCR_CIC       (HW_RTC_TCR.B.CIC)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_RTC_CR - RTC Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_RTC_CR - RTC Control Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_rtc_cr
{
    uint32_t U;
    struct _hw_rtc_cr_bitfields
    {
        uint32_t SWR : 1;              //!< [0] Software Reset
        uint32_t WPE : 1;              //!< [1] Wakeup Pin Enable
        uint32_t SUP : 1;              //!< [2] Supervisor Access
        uint32_t UM : 1;               //!< [3] Update Mode
        uint32_t WPS : 1;              //!< [4] Wakeup Pin Select
        uint32_t RESERVED0 : 3;        //!< [7:5]
        uint32_t OSCE : 1;             //!< [8] Oscillator Enable
        uint32_t CLKO : 1;             //!< [9] Clock Output
        uint32_t SC16P : 1;            //!< [10] Oscillator 16pF Load Configure
        uint32_t SC8P : 1;             //!< [11] Oscillator 8pF Load Configure
        uint32_t SC4P : 1;             //!< [12] Oscillator 4pF Load Configure
        uint32_t SC2P : 1;             //!< [13] Oscillator 2pF Load Configure
        uint32_t RESERVED1 : 18;       //!< [31:14]
    } B;
} hw_rtc_cr_t;
#endif

/*!
 * @name Constants and macros for entire RTC_CR register
 */
//@{
#define HW_RTC_CR_ADDR           (REGS_RTC_BASE + 0x10U)

#ifndef __LANGUAGE_ASM__
#define HW_RTC_CR                (*(__IO hw_rtc_cr_t *) HW_RTC_CR_ADDR)
#define HW_RTC_CR_RD()           (HW_RTC_CR.U)
#define HW_RTC_CR_WR(v)          (HW_RTC_CR.U = (v))
#define HW_RTC_CR_SET(v)         (HW_RTC_CR_WR(HW_RTC_CR_RD() |  (v)))
#define HW_RTC_CR_CLR(v)         (HW_RTC_CR_WR(HW_RTC_CR_RD() & ~(v)))
#define HW_RTC_CR_TOG(v)         (HW_RTC_CR_WR(HW_RTC_CR_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual RTC_CR bitfields
 */

/*!
 * @name Register RTC_CR, field SWR[0] (RW)
 *
 * Values:
 * - 0 - No effect.
 * - 1 - Resets all RTC registers except for the SWR bit and the RTC_WAR and
 *     RTC_RAR registers . The SWR bit is cleared by VBAT POR and by software
 *     explicitly clearing it.
 */
//@{
#define BP_RTC_CR_SWR        (0U)          //!< Bit position for RTC_CR_SWR.
#define BM_RTC_CR_SWR        (0x00000001U) //!< Bit mask for RTC_CR_SWR.
#define BS_RTC_CR_SWR        (1U)          //!< Bit field size in bits for RTC_CR_SWR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_CR_SWR field.
#define BR_RTC_CR_SWR        (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_SWR))
#endif

//! @brief Format value for bitfield RTC_CR_SWR.
#define BF_RTC_CR_SWR(v)     (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_CR_SWR), uint32_t) & BM_RTC_CR_SWR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SWR field to a new value.
#define BW_RTC_CR_SWR(v)     (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_SWR) = (v))
#endif
//@}

/*!
 * @name Register RTC_CR, field WPE[1] (RW)
 *
 * The wakeup pin is optional and not available on all devices.
 *
 * Values:
 * - 0 - Wakeup pin is disabled.
 * - 1 - Wakeup pin is enabled and wakeup pin asserts if the RTC interrupt
 *     asserts or the wakeup pin is turned on.
 */
//@{
#define BP_RTC_CR_WPE        (1U)          //!< Bit position for RTC_CR_WPE.
#define BM_RTC_CR_WPE        (0x00000002U) //!< Bit mask for RTC_CR_WPE.
#define BS_RTC_CR_WPE        (1U)          //!< Bit field size in bits for RTC_CR_WPE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_CR_WPE field.
#define BR_RTC_CR_WPE        (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_WPE))
#endif

//! @brief Format value for bitfield RTC_CR_WPE.
#define BF_RTC_CR_WPE(v)     (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_CR_WPE), uint32_t) & BM_RTC_CR_WPE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WPE field to a new value.
#define BW_RTC_CR_WPE(v)     (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_WPE) = (v))
#endif
//@}

/*!
 * @name Register RTC_CR, field SUP[2] (RW)
 *
 * Values:
 * - 0 - Non-supervisor mode write accesses are not supported and generate a bus
 *     error.
 * - 1 - Non-supervisor mode write accesses are supported.
 */
//@{
#define BP_RTC_CR_SUP        (2U)          //!< Bit position for RTC_CR_SUP.
#define BM_RTC_CR_SUP        (0x00000004U) //!< Bit mask for RTC_CR_SUP.
#define BS_RTC_CR_SUP        (1U)          //!< Bit field size in bits for RTC_CR_SUP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_CR_SUP field.
#define BR_RTC_CR_SUP        (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_SUP))
#endif

//! @brief Format value for bitfield RTC_CR_SUP.
#define BF_RTC_CR_SUP(v)     (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_CR_SUP), uint32_t) & BM_RTC_CR_SUP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SUP field to a new value.
#define BW_RTC_CR_SUP(v)     (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_SUP) = (v))
#endif
//@}

/*!
 * @name Register RTC_CR, field UM[3] (RW)
 *
 * Allows SR[TCE] to be written even when the Status Register is locked. When
 * set, the SR[TCE] can always be written if the SR[TIF] or SR[TOF] are set or if
 * the SR[TCE] is clear.
 *
 * Values:
 * - 0 - Registers cannot be written when locked.
 * - 1 - Registers can be written when locked under limited conditions.
 */
//@{
#define BP_RTC_CR_UM         (3U)          //!< Bit position for RTC_CR_UM.
#define BM_RTC_CR_UM         (0x00000008U) //!< Bit mask for RTC_CR_UM.
#define BS_RTC_CR_UM         (1U)          //!< Bit field size in bits for RTC_CR_UM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_CR_UM field.
#define BR_RTC_CR_UM         (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_UM))
#endif

//! @brief Format value for bitfield RTC_CR_UM.
#define BF_RTC_CR_UM(v)      (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_CR_UM), uint32_t) & BM_RTC_CR_UM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the UM field to a new value.
#define BW_RTC_CR_UM(v)      (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_UM) = (v))
#endif
//@}

/*!
 * @name Register RTC_CR, field WPS[4] (RW)
 *
 * The wakeup pin is optional and not available on all devices.
 *
 * Values:
 * - 0 - Wakeup pin asserts (active low, open drain) if the RTC interrupt
 *     asserts or the wakeup pin is turned on.
 * - 1 - Wakeup pin instead outputs the RTC 32kHz clock, provided the wakeup pin
 *     is turned on and the 32kHz clock is output to other peripherals.
 */
//@{
#define BP_RTC_CR_WPS        (4U)          //!< Bit position for RTC_CR_WPS.
#define BM_RTC_CR_WPS        (0x00000010U) //!< Bit mask for RTC_CR_WPS.
#define BS_RTC_CR_WPS        (1U)          //!< Bit field size in bits for RTC_CR_WPS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_CR_WPS field.
#define BR_RTC_CR_WPS        (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_WPS))
#endif

//! @brief Format value for bitfield RTC_CR_WPS.
#define BF_RTC_CR_WPS(v)     (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_CR_WPS), uint32_t) & BM_RTC_CR_WPS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WPS field to a new value.
#define BW_RTC_CR_WPS(v)     (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_WPS) = (v))
#endif
//@}

/*!
 * @name Register RTC_CR, field OSCE[8] (RW)
 *
 * Values:
 * - 0 - 32.768 kHz oscillator is disabled.
 * - 1 - 32.768 kHz oscillator is enabled. After setting this bit, wait the
 *     oscillator startup time before enabling the time counter to allow the 32.768
 *     kHz clock time to stabilize.
 */
//@{
#define BP_RTC_CR_OSCE       (8U)          //!< Bit position for RTC_CR_OSCE.
#define BM_RTC_CR_OSCE       (0x00000100U) //!< Bit mask for RTC_CR_OSCE.
#define BS_RTC_CR_OSCE       (1U)          //!< Bit field size in bits for RTC_CR_OSCE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_CR_OSCE field.
#define BR_RTC_CR_OSCE       (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_OSCE))
#endif

//! @brief Format value for bitfield RTC_CR_OSCE.
#define BF_RTC_CR_OSCE(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_CR_OSCE), uint32_t) & BM_RTC_CR_OSCE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the OSCE field to a new value.
#define BW_RTC_CR_OSCE(v)    (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_OSCE) = (v))
#endif
//@}

/*!
 * @name Register RTC_CR, field CLKO[9] (RW)
 *
 * Values:
 * - 0 - The 32 kHz clock is output to other peripherals.
 * - 1 - The 32 kHz clock is not output to other peripherals.
 */
//@{
#define BP_RTC_CR_CLKO       (9U)          //!< Bit position for RTC_CR_CLKO.
#define BM_RTC_CR_CLKO       (0x00000200U) //!< Bit mask for RTC_CR_CLKO.
#define BS_RTC_CR_CLKO       (1U)          //!< Bit field size in bits for RTC_CR_CLKO.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_CR_CLKO field.
#define BR_RTC_CR_CLKO       (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_CLKO))
#endif

//! @brief Format value for bitfield RTC_CR_CLKO.
#define BF_RTC_CR_CLKO(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_CR_CLKO), uint32_t) & BM_RTC_CR_CLKO)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CLKO field to a new value.
#define BW_RTC_CR_CLKO(v)    (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_CLKO) = (v))
#endif
//@}

/*!
 * @name Register RTC_CR, field SC16P[10] (RW)
 *
 * Values:
 * - 0 - Disable the load.
 * - 1 - Enable the additional load.
 */
//@{
#define BP_RTC_CR_SC16P      (10U)         //!< Bit position for RTC_CR_SC16P.
#define BM_RTC_CR_SC16P      (0x00000400U) //!< Bit mask for RTC_CR_SC16P.
#define BS_RTC_CR_SC16P      (1U)          //!< Bit field size in bits for RTC_CR_SC16P.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_CR_SC16P field.
#define BR_RTC_CR_SC16P      (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_SC16P))
#endif

//! @brief Format value for bitfield RTC_CR_SC16P.
#define BF_RTC_CR_SC16P(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_CR_SC16P), uint32_t) & BM_RTC_CR_SC16P)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SC16P field to a new value.
#define BW_RTC_CR_SC16P(v)   (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_SC16P) = (v))
#endif
//@}

/*!
 * @name Register RTC_CR, field SC8P[11] (RW)
 *
 * Values:
 * - 0 - Disable the load.
 * - 1 - Enable the additional load.
 */
//@{
#define BP_RTC_CR_SC8P       (11U)         //!< Bit position for RTC_CR_SC8P.
#define BM_RTC_CR_SC8P       (0x00000800U) //!< Bit mask for RTC_CR_SC8P.
#define BS_RTC_CR_SC8P       (1U)          //!< Bit field size in bits for RTC_CR_SC8P.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_CR_SC8P field.
#define BR_RTC_CR_SC8P       (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_SC8P))
#endif

//! @brief Format value for bitfield RTC_CR_SC8P.
#define BF_RTC_CR_SC8P(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_CR_SC8P), uint32_t) & BM_RTC_CR_SC8P)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SC8P field to a new value.
#define BW_RTC_CR_SC8P(v)    (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_SC8P) = (v))
#endif
//@}

/*!
 * @name Register RTC_CR, field SC4P[12] (RW)
 *
 * Values:
 * - 0 - Disable the load.
 * - 1 - Enable the additional load.
 */
//@{
#define BP_RTC_CR_SC4P       (12U)         //!< Bit position for RTC_CR_SC4P.
#define BM_RTC_CR_SC4P       (0x00001000U) //!< Bit mask for RTC_CR_SC4P.
#define BS_RTC_CR_SC4P       (1U)          //!< Bit field size in bits for RTC_CR_SC4P.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_CR_SC4P field.
#define BR_RTC_CR_SC4P       (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_SC4P))
#endif

//! @brief Format value for bitfield RTC_CR_SC4P.
#define BF_RTC_CR_SC4P(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_CR_SC4P), uint32_t) & BM_RTC_CR_SC4P)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SC4P field to a new value.
#define BW_RTC_CR_SC4P(v)    (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_SC4P) = (v))
#endif
//@}

/*!
 * @name Register RTC_CR, field SC2P[13] (RW)
 *
 * Values:
 * - 0 - Disable the load.
 * - 1 - Enable the additional load.
 */
//@{
#define BP_RTC_CR_SC2P       (13U)         //!< Bit position for RTC_CR_SC2P.
#define BM_RTC_CR_SC2P       (0x00002000U) //!< Bit mask for RTC_CR_SC2P.
#define BS_RTC_CR_SC2P       (1U)          //!< Bit field size in bits for RTC_CR_SC2P.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_CR_SC2P field.
#define BR_RTC_CR_SC2P       (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_SC2P))
#endif

//! @brief Format value for bitfield RTC_CR_SC2P.
#define BF_RTC_CR_SC2P(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_CR_SC2P), uint32_t) & BM_RTC_CR_SC2P)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SC2P field to a new value.
#define BW_RTC_CR_SC2P(v)    (BITBAND_ACCESS32(HW_RTC_CR_ADDR, BP_RTC_CR_SC2P) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_RTC_SR - RTC Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_RTC_SR - RTC Status Register (RW)
 *
 * Reset value: 0x00000001U
 */
typedef union _hw_rtc_sr
{
    uint32_t U;
    struct _hw_rtc_sr_bitfields
    {
        uint32_t TIF : 1;              //!< [0] Time Invalid Flag
        uint32_t TOF : 1;              //!< [1] Time Overflow Flag
        uint32_t TAF : 1;              //!< [2] Time Alarm Flag
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t TCE : 1;              //!< [4] Time Counter Enable
        uint32_t RESERVED1 : 27;       //!< [31:5]
    } B;
} hw_rtc_sr_t;
#endif

/*!
 * @name Constants and macros for entire RTC_SR register
 */
//@{
#define HW_RTC_SR_ADDR           (REGS_RTC_BASE + 0x14U)

#ifndef __LANGUAGE_ASM__
#define HW_RTC_SR                (*(__IO hw_rtc_sr_t *) HW_RTC_SR_ADDR)
#define HW_RTC_SR_RD()           (HW_RTC_SR.U)
#define HW_RTC_SR_WR(v)          (HW_RTC_SR.U = (v))
#define HW_RTC_SR_SET(v)         (HW_RTC_SR_WR(HW_RTC_SR_RD() |  (v)))
#define HW_RTC_SR_CLR(v)         (HW_RTC_SR_WR(HW_RTC_SR_RD() & ~(v)))
#define HW_RTC_SR_TOG(v)         (HW_RTC_SR_WR(HW_RTC_SR_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual RTC_SR bitfields
 */

/*!
 * @name Register RTC_SR, field TIF[0] (RO)
 *
 * The time invalid flag is set on VBAT POR or software reset. The TSR and TPR
 * do not increment and read as zero when this bit is set. This bit is cleared by
 * writing the TSR register when the time counter is disabled.
 *
 * Values:
 * - 0 - Time is valid.
 * - 1 - Time is invalid and time counter is read as zero.
 */
//@{
#define BP_RTC_SR_TIF        (0U)          //!< Bit position for RTC_SR_TIF.
#define BM_RTC_SR_TIF        (0x00000001U) //!< Bit mask for RTC_SR_TIF.
#define BS_RTC_SR_TIF        (1U)          //!< Bit field size in bits for RTC_SR_TIF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_SR_TIF field.
#define BR_RTC_SR_TIF        (BITBAND_ACCESS32(HW_RTC_SR_ADDR, BP_RTC_SR_TIF))
#endif
//@}

/*!
 * @name Register RTC_SR, field TOF[1] (RO)
 *
 * Time overflow flag is set when the time counter is enabled and overflows. The
 * TSR and TPR do not increment and read as zero when this bit is set. This bit
 * is cleared by writing the TSR register when the time counter is disabled.
 *
 * Values:
 * - 0 - Time overflow has not occurred.
 * - 1 - Time overflow has occurred and time counter is read as zero.
 */
//@{
#define BP_RTC_SR_TOF        (1U)          //!< Bit position for RTC_SR_TOF.
#define BM_RTC_SR_TOF        (0x00000002U) //!< Bit mask for RTC_SR_TOF.
#define BS_RTC_SR_TOF        (1U)          //!< Bit field size in bits for RTC_SR_TOF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_SR_TOF field.
#define BR_RTC_SR_TOF        (BITBAND_ACCESS32(HW_RTC_SR_ADDR, BP_RTC_SR_TOF))
#endif
//@}

/*!
 * @name Register RTC_SR, field TAF[2] (RO)
 *
 * Time alarm flag is set when the TAR[TAR] equals the TSR[TSR] and the TSR[TSR]
 * increments. This bit is cleared by writing the TAR register.
 *
 * Values:
 * - 0 - Time alarm has not occurred.
 * - 1 - Time alarm has occurred.
 */
//@{
#define BP_RTC_SR_TAF        (2U)          //!< Bit position for RTC_SR_TAF.
#define BM_RTC_SR_TAF        (0x00000004U) //!< Bit mask for RTC_SR_TAF.
#define BS_RTC_SR_TAF        (1U)          //!< Bit field size in bits for RTC_SR_TAF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_SR_TAF field.
#define BR_RTC_SR_TAF        (BITBAND_ACCESS32(HW_RTC_SR_ADDR, BP_RTC_SR_TAF))
#endif
//@}

/*!
 * @name Register RTC_SR, field TCE[4] (RW)
 *
 * When time counter is disabled the TSR register and TPR register are
 * writeable, but do not increment. When time counter is enabled the TSR register and TPR
 * register are not writeable, but increment.
 *
 * Values:
 * - 0 - Time counter is disabled.
 * - 1 - Time counter is enabled.
 */
//@{
#define BP_RTC_SR_TCE        (4U)          //!< Bit position for RTC_SR_TCE.
#define BM_RTC_SR_TCE        (0x00000010U) //!< Bit mask for RTC_SR_TCE.
#define BS_RTC_SR_TCE        (1U)          //!< Bit field size in bits for RTC_SR_TCE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_SR_TCE field.
#define BR_RTC_SR_TCE        (BITBAND_ACCESS32(HW_RTC_SR_ADDR, BP_RTC_SR_TCE))
#endif

//! @brief Format value for bitfield RTC_SR_TCE.
#define BF_RTC_SR_TCE(v)     (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_SR_TCE), uint32_t) & BM_RTC_SR_TCE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TCE field to a new value.
#define BW_RTC_SR_TCE(v)     (BITBAND_ACCESS32(HW_RTC_SR_ADDR, BP_RTC_SR_TCE) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_RTC_LR - RTC Lock Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_RTC_LR - RTC Lock Register (RW)
 *
 * Reset value: 0x000000FFU
 */
typedef union _hw_rtc_lr
{
    uint32_t U;
    struct _hw_rtc_lr_bitfields
    {
        uint32_t RESERVED0 : 3;        //!< [2:0]
        uint32_t TCL : 1;              //!< [3] Time Compensation Lock
        uint32_t CRL : 1;              //!< [4] Control Register Lock
        uint32_t SRL : 1;              //!< [5] Status Register Lock
        uint32_t LRL : 1;              //!< [6] Lock Register Lock
        uint32_t RESERVED1 : 25;       //!< [31:7]
    } B;
} hw_rtc_lr_t;
#endif

/*!
 * @name Constants and macros for entire RTC_LR register
 */
//@{
#define HW_RTC_LR_ADDR           (REGS_RTC_BASE + 0x18U)

#ifndef __LANGUAGE_ASM__
#define HW_RTC_LR                (*(__IO hw_rtc_lr_t *) HW_RTC_LR_ADDR)
#define HW_RTC_LR_RD()           (HW_RTC_LR.U)
#define HW_RTC_LR_WR(v)          (HW_RTC_LR.U = (v))
#define HW_RTC_LR_SET(v)         (HW_RTC_LR_WR(HW_RTC_LR_RD() |  (v)))
#define HW_RTC_LR_CLR(v)         (HW_RTC_LR_WR(HW_RTC_LR_RD() & ~(v)))
#define HW_RTC_LR_TOG(v)         (HW_RTC_LR_WR(HW_RTC_LR_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual RTC_LR bitfields
 */

/*!
 * @name Register RTC_LR, field TCL[3] (RW)
 *
 * After being cleared, this bit can be set only by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Time Compensation Register is locked and writes are ignored.
 * - 1 - Time Compensation Register is not locked and writes complete as normal.
 */
//@{
#define BP_RTC_LR_TCL        (3U)          //!< Bit position for RTC_LR_TCL.
#define BM_RTC_LR_TCL        (0x00000008U) //!< Bit mask for RTC_LR_TCL.
#define BS_RTC_LR_TCL        (1U)          //!< Bit field size in bits for RTC_LR_TCL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_LR_TCL field.
#define BR_RTC_LR_TCL        (BITBAND_ACCESS32(HW_RTC_LR_ADDR, BP_RTC_LR_TCL))
#endif

//! @brief Format value for bitfield RTC_LR_TCL.
#define BF_RTC_LR_TCL(v)     (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_LR_TCL), uint32_t) & BM_RTC_LR_TCL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TCL field to a new value.
#define BW_RTC_LR_TCL(v)     (BITBAND_ACCESS32(HW_RTC_LR_ADDR, BP_RTC_LR_TCL) = (v))
#endif
//@}

/*!
 * @name Register RTC_LR, field CRL[4] (RW)
 *
 * After being cleared, this bit can only be set by VBAT POR.
 *
 * Values:
 * - 0 - Control Register is locked and writes are ignored.
 * - 1 - Control Register is not locked and writes complete as normal.
 */
//@{
#define BP_RTC_LR_CRL        (4U)          //!< Bit position for RTC_LR_CRL.
#define BM_RTC_LR_CRL        (0x00000010U) //!< Bit mask for RTC_LR_CRL.
#define BS_RTC_LR_CRL        (1U)          //!< Bit field size in bits for RTC_LR_CRL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_LR_CRL field.
#define BR_RTC_LR_CRL        (BITBAND_ACCESS32(HW_RTC_LR_ADDR, BP_RTC_LR_CRL))
#endif

//! @brief Format value for bitfield RTC_LR_CRL.
#define BF_RTC_LR_CRL(v)     (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_LR_CRL), uint32_t) & BM_RTC_LR_CRL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CRL field to a new value.
#define BW_RTC_LR_CRL(v)     (BITBAND_ACCESS32(HW_RTC_LR_ADDR, BP_RTC_LR_CRL) = (v))
#endif
//@}

/*!
 * @name Register RTC_LR, field SRL[5] (RW)
 *
 * After being cleared, this bit can be set only by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Status Register is locked and writes are ignored.
 * - 1 - Status Register is not locked and writes complete as normal.
 */
//@{
#define BP_RTC_LR_SRL        (5U)          //!< Bit position for RTC_LR_SRL.
#define BM_RTC_LR_SRL        (0x00000020U) //!< Bit mask for RTC_LR_SRL.
#define BS_RTC_LR_SRL        (1U)          //!< Bit field size in bits for RTC_LR_SRL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_LR_SRL field.
#define BR_RTC_LR_SRL        (BITBAND_ACCESS32(HW_RTC_LR_ADDR, BP_RTC_LR_SRL))
#endif

//! @brief Format value for bitfield RTC_LR_SRL.
#define BF_RTC_LR_SRL(v)     (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_LR_SRL), uint32_t) & BM_RTC_LR_SRL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SRL field to a new value.
#define BW_RTC_LR_SRL(v)     (BITBAND_ACCESS32(HW_RTC_LR_ADDR, BP_RTC_LR_SRL) = (v))
#endif
//@}

/*!
 * @name Register RTC_LR, field LRL[6] (RW)
 *
 * After being cleared, this bit can be set only by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Lock Register is locked and writes are ignored.
 * - 1 - Lock Register is not locked and writes complete as normal.
 */
//@{
#define BP_RTC_LR_LRL        (6U)          //!< Bit position for RTC_LR_LRL.
#define BM_RTC_LR_LRL        (0x00000040U) //!< Bit mask for RTC_LR_LRL.
#define BS_RTC_LR_LRL        (1U)          //!< Bit field size in bits for RTC_LR_LRL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_LR_LRL field.
#define BR_RTC_LR_LRL        (BITBAND_ACCESS32(HW_RTC_LR_ADDR, BP_RTC_LR_LRL))
#endif

//! @brief Format value for bitfield RTC_LR_LRL.
#define BF_RTC_LR_LRL(v)     (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_LR_LRL), uint32_t) & BM_RTC_LR_LRL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LRL field to a new value.
#define BW_RTC_LR_LRL(v)     (BITBAND_ACCESS32(HW_RTC_LR_ADDR, BP_RTC_LR_LRL) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_RTC_IER - RTC Interrupt Enable Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_RTC_IER - RTC Interrupt Enable Register (RW)
 *
 * Reset value: 0x00000007U
 */
typedef union _hw_rtc_ier
{
    uint32_t U;
    struct _hw_rtc_ier_bitfields
    {
        uint32_t TIIE : 1;             //!< [0] Time Invalid Interrupt Enable
        uint32_t TOIE : 1;             //!< [1] Time Overflow Interrupt Enable
        uint32_t TAIE : 1;             //!< [2] Time Alarm Interrupt Enable
        uint32_t RESERVED0 : 1;        //!< [3]
        uint32_t TSIE : 1;             //!< [4] Time Seconds Interrupt Enable
        uint32_t RESERVED1 : 2;        //!< [6:5]
        uint32_t WPON : 1;             //!< [7] Wakeup Pin On
        uint32_t RESERVED2 : 24;       //!< [31:8]
    } B;
} hw_rtc_ier_t;
#endif

/*!
 * @name Constants and macros for entire RTC_IER register
 */
//@{
#define HW_RTC_IER_ADDR          (REGS_RTC_BASE + 0x1CU)

#ifndef __LANGUAGE_ASM__
#define HW_RTC_IER               (*(__IO hw_rtc_ier_t *) HW_RTC_IER_ADDR)
#define HW_RTC_IER_RD()          (HW_RTC_IER.U)
#define HW_RTC_IER_WR(v)         (HW_RTC_IER.U = (v))
#define HW_RTC_IER_SET(v)        (HW_RTC_IER_WR(HW_RTC_IER_RD() |  (v)))
#define HW_RTC_IER_CLR(v)        (HW_RTC_IER_WR(HW_RTC_IER_RD() & ~(v)))
#define HW_RTC_IER_TOG(v)        (HW_RTC_IER_WR(HW_RTC_IER_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual RTC_IER bitfields
 */

/*!
 * @name Register RTC_IER, field TIIE[0] (RW)
 *
 * Values:
 * - 0 - Time invalid flag does not generate an interrupt.
 * - 1 - Time invalid flag does generate an interrupt.
 */
//@{
#define BP_RTC_IER_TIIE      (0U)          //!< Bit position for RTC_IER_TIIE.
#define BM_RTC_IER_TIIE      (0x00000001U) //!< Bit mask for RTC_IER_TIIE.
#define BS_RTC_IER_TIIE      (1U)          //!< Bit field size in bits for RTC_IER_TIIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_IER_TIIE field.
#define BR_RTC_IER_TIIE      (BITBAND_ACCESS32(HW_RTC_IER_ADDR, BP_RTC_IER_TIIE))
#endif

//! @brief Format value for bitfield RTC_IER_TIIE.
#define BF_RTC_IER_TIIE(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_IER_TIIE), uint32_t) & BM_RTC_IER_TIIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TIIE field to a new value.
#define BW_RTC_IER_TIIE(v)   (BITBAND_ACCESS32(HW_RTC_IER_ADDR, BP_RTC_IER_TIIE) = (v))
#endif
//@}

/*!
 * @name Register RTC_IER, field TOIE[1] (RW)
 *
 * Values:
 * - 0 - Time overflow flag does not generate an interrupt.
 * - 1 - Time overflow flag does generate an interrupt.
 */
//@{
#define BP_RTC_IER_TOIE      (1U)          //!< Bit position for RTC_IER_TOIE.
#define BM_RTC_IER_TOIE      (0x00000002U) //!< Bit mask for RTC_IER_TOIE.
#define BS_RTC_IER_TOIE      (1U)          //!< Bit field size in bits for RTC_IER_TOIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_IER_TOIE field.
#define BR_RTC_IER_TOIE      (BITBAND_ACCESS32(HW_RTC_IER_ADDR, BP_RTC_IER_TOIE))
#endif

//! @brief Format value for bitfield RTC_IER_TOIE.
#define BF_RTC_IER_TOIE(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_IER_TOIE), uint32_t) & BM_RTC_IER_TOIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TOIE field to a new value.
#define BW_RTC_IER_TOIE(v)   (BITBAND_ACCESS32(HW_RTC_IER_ADDR, BP_RTC_IER_TOIE) = (v))
#endif
//@}

/*!
 * @name Register RTC_IER, field TAIE[2] (RW)
 *
 * Values:
 * - 0 - Time alarm flag does not generate an interrupt.
 * - 1 - Time alarm flag does generate an interrupt.
 */
//@{
#define BP_RTC_IER_TAIE      (2U)          //!< Bit position for RTC_IER_TAIE.
#define BM_RTC_IER_TAIE      (0x00000004U) //!< Bit mask for RTC_IER_TAIE.
#define BS_RTC_IER_TAIE      (1U)          //!< Bit field size in bits for RTC_IER_TAIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_IER_TAIE field.
#define BR_RTC_IER_TAIE      (BITBAND_ACCESS32(HW_RTC_IER_ADDR, BP_RTC_IER_TAIE))
#endif

//! @brief Format value for bitfield RTC_IER_TAIE.
#define BF_RTC_IER_TAIE(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_IER_TAIE), uint32_t) & BM_RTC_IER_TAIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TAIE field to a new value.
#define BW_RTC_IER_TAIE(v)   (BITBAND_ACCESS32(HW_RTC_IER_ADDR, BP_RTC_IER_TAIE) = (v))
#endif
//@}

/*!
 * @name Register RTC_IER, field TSIE[4] (RW)
 *
 * The seconds interrupt is an edge-sensitive interrupt with a dedicated
 * interrupt vector. It is generated once a second and requires no software overhead
 * (there is no corresponding status flag to clear).
 *
 * Values:
 * - 0 - Seconds interrupt is disabled.
 * - 1 - Seconds interrupt is enabled.
 */
//@{
#define BP_RTC_IER_TSIE      (4U)          //!< Bit position for RTC_IER_TSIE.
#define BM_RTC_IER_TSIE      (0x00000010U) //!< Bit mask for RTC_IER_TSIE.
#define BS_RTC_IER_TSIE      (1U)          //!< Bit field size in bits for RTC_IER_TSIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_IER_TSIE field.
#define BR_RTC_IER_TSIE      (BITBAND_ACCESS32(HW_RTC_IER_ADDR, BP_RTC_IER_TSIE))
#endif

//! @brief Format value for bitfield RTC_IER_TSIE.
#define BF_RTC_IER_TSIE(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_IER_TSIE), uint32_t) & BM_RTC_IER_TSIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TSIE field to a new value.
#define BW_RTC_IER_TSIE(v)   (BITBAND_ACCESS32(HW_RTC_IER_ADDR, BP_RTC_IER_TSIE) = (v))
#endif
//@}

/*!
 * @name Register RTC_IER, field WPON[7] (RW)
 *
 * The wakeup pin is optional and not available on all devices. Whenever the
 * wakeup pin is enabled and this bit is set, the wakeup pin will assert.
 *
 * Values:
 * - 0 - No effect.
 * - 1 - If the wakeup pin is enabled, then the wakeup pin will assert.
 */
//@{
#define BP_RTC_IER_WPON      (7U)          //!< Bit position for RTC_IER_WPON.
#define BM_RTC_IER_WPON      (0x00000080U) //!< Bit mask for RTC_IER_WPON.
#define BS_RTC_IER_WPON      (1U)          //!< Bit field size in bits for RTC_IER_WPON.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_IER_WPON field.
#define BR_RTC_IER_WPON      (BITBAND_ACCESS32(HW_RTC_IER_ADDR, BP_RTC_IER_WPON))
#endif

//! @brief Format value for bitfield RTC_IER_WPON.
#define BF_RTC_IER_WPON(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_IER_WPON), uint32_t) & BM_RTC_IER_WPON)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WPON field to a new value.
#define BW_RTC_IER_WPON(v)   (BITBAND_ACCESS32(HW_RTC_IER_ADDR, BP_RTC_IER_WPON) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_RTC_WAR - RTC Write Access Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_RTC_WAR - RTC Write Access Register (RW)
 *
 * Reset value: 0x000000FFU
 */
typedef union _hw_rtc_war
{
    uint32_t U;
    struct _hw_rtc_war_bitfields
    {
        uint32_t TSRW : 1;             //!< [0] Time Seconds Register Write
        uint32_t TPRW : 1;             //!< [1] Time Prescaler Register Write
        uint32_t TARW : 1;             //!< [2] Time Alarm Register Write
        uint32_t TCRW : 1;             //!< [3] Time Compensation Register Write
        uint32_t CRW : 1;              //!< [4] Control Register Write
        uint32_t SRW : 1;              //!< [5] Status Register Write
        uint32_t LRW : 1;              //!< [6] Lock Register Write
        uint32_t IERW : 1;             //!< [7] Interrupt Enable Register Write
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_rtc_war_t;
#endif

/*!
 * @name Constants and macros for entire RTC_WAR register
 */
//@{
#define HW_RTC_WAR_ADDR          (REGS_RTC_BASE + 0x800U)

#ifndef __LANGUAGE_ASM__
#define HW_RTC_WAR               (*(__IO hw_rtc_war_t *) HW_RTC_WAR_ADDR)
#define HW_RTC_WAR_RD()          (HW_RTC_WAR.U)
#define HW_RTC_WAR_WR(v)         (HW_RTC_WAR.U = (v))
#define HW_RTC_WAR_SET(v)        (HW_RTC_WAR_WR(HW_RTC_WAR_RD() |  (v)))
#define HW_RTC_WAR_CLR(v)        (HW_RTC_WAR_WR(HW_RTC_WAR_RD() & ~(v)))
#define HW_RTC_WAR_TOG(v)        (HW_RTC_WAR_WR(HW_RTC_WAR_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual RTC_WAR bitfields
 */

/*!
 * @name Register RTC_WAR, field TSRW[0] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Writes to the Time Seconds Register are ignored.
 * - 1 - Writes to the Time Seconds Register complete as normal.
 */
//@{
#define BP_RTC_WAR_TSRW      (0U)          //!< Bit position for RTC_WAR_TSRW.
#define BM_RTC_WAR_TSRW      (0x00000001U) //!< Bit mask for RTC_WAR_TSRW.
#define BS_RTC_WAR_TSRW      (1U)          //!< Bit field size in bits for RTC_WAR_TSRW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_WAR_TSRW field.
#define BR_RTC_WAR_TSRW      (BITBAND_ACCESS32(HW_RTC_WAR_ADDR, BP_RTC_WAR_TSRW))
#endif

//! @brief Format value for bitfield RTC_WAR_TSRW.
#define BF_RTC_WAR_TSRW(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_WAR_TSRW), uint32_t) & BM_RTC_WAR_TSRW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TSRW field to a new value.
#define BW_RTC_WAR_TSRW(v)   (BITBAND_ACCESS32(HW_RTC_WAR_ADDR, BP_RTC_WAR_TSRW) = (v))
#endif
//@}

/*!
 * @name Register RTC_WAR, field TPRW[1] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Writes to the Time Prescaler Register are ignored.
 * - 1 - Writes to the Time Prescaler Register complete as normal.
 */
//@{
#define BP_RTC_WAR_TPRW      (1U)          //!< Bit position for RTC_WAR_TPRW.
#define BM_RTC_WAR_TPRW      (0x00000002U) //!< Bit mask for RTC_WAR_TPRW.
#define BS_RTC_WAR_TPRW      (1U)          //!< Bit field size in bits for RTC_WAR_TPRW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_WAR_TPRW field.
#define BR_RTC_WAR_TPRW      (BITBAND_ACCESS32(HW_RTC_WAR_ADDR, BP_RTC_WAR_TPRW))
#endif

//! @brief Format value for bitfield RTC_WAR_TPRW.
#define BF_RTC_WAR_TPRW(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_WAR_TPRW), uint32_t) & BM_RTC_WAR_TPRW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TPRW field to a new value.
#define BW_RTC_WAR_TPRW(v)   (BITBAND_ACCESS32(HW_RTC_WAR_ADDR, BP_RTC_WAR_TPRW) = (v))
#endif
//@}

/*!
 * @name Register RTC_WAR, field TARW[2] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Writes to the Time Alarm Register are ignored.
 * - 1 - Writes to the Time Alarm Register complete as normal.
 */
//@{
#define BP_RTC_WAR_TARW      (2U)          //!< Bit position for RTC_WAR_TARW.
#define BM_RTC_WAR_TARW      (0x00000004U) //!< Bit mask for RTC_WAR_TARW.
#define BS_RTC_WAR_TARW      (1U)          //!< Bit field size in bits for RTC_WAR_TARW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_WAR_TARW field.
#define BR_RTC_WAR_TARW      (BITBAND_ACCESS32(HW_RTC_WAR_ADDR, BP_RTC_WAR_TARW))
#endif

//! @brief Format value for bitfield RTC_WAR_TARW.
#define BF_RTC_WAR_TARW(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_WAR_TARW), uint32_t) & BM_RTC_WAR_TARW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TARW field to a new value.
#define BW_RTC_WAR_TARW(v)   (BITBAND_ACCESS32(HW_RTC_WAR_ADDR, BP_RTC_WAR_TARW) = (v))
#endif
//@}

/*!
 * @name Register RTC_WAR, field TCRW[3] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Writes to the Time Compensation Register are ignored.
 * - 1 - Writes to the Time Compensation Register complete as normal.
 */
//@{
#define BP_RTC_WAR_TCRW      (3U)          //!< Bit position for RTC_WAR_TCRW.
#define BM_RTC_WAR_TCRW      (0x00000008U) //!< Bit mask for RTC_WAR_TCRW.
#define BS_RTC_WAR_TCRW      (1U)          //!< Bit field size in bits for RTC_WAR_TCRW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_WAR_TCRW field.
#define BR_RTC_WAR_TCRW      (BITBAND_ACCESS32(HW_RTC_WAR_ADDR, BP_RTC_WAR_TCRW))
#endif

//! @brief Format value for bitfield RTC_WAR_TCRW.
#define BF_RTC_WAR_TCRW(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_WAR_TCRW), uint32_t) & BM_RTC_WAR_TCRW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TCRW field to a new value.
#define BW_RTC_WAR_TCRW(v)   (BITBAND_ACCESS32(HW_RTC_WAR_ADDR, BP_RTC_WAR_TCRW) = (v))
#endif
//@}

/*!
 * @name Register RTC_WAR, field CRW[4] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Writes to the Control Register are ignored.
 * - 1 - Writes to the Control Register complete as normal.
 */
//@{
#define BP_RTC_WAR_CRW       (4U)          //!< Bit position for RTC_WAR_CRW.
#define BM_RTC_WAR_CRW       (0x00000010U) //!< Bit mask for RTC_WAR_CRW.
#define BS_RTC_WAR_CRW       (1U)          //!< Bit field size in bits for RTC_WAR_CRW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_WAR_CRW field.
#define BR_RTC_WAR_CRW       (BITBAND_ACCESS32(HW_RTC_WAR_ADDR, BP_RTC_WAR_CRW))
#endif

//! @brief Format value for bitfield RTC_WAR_CRW.
#define BF_RTC_WAR_CRW(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_WAR_CRW), uint32_t) & BM_RTC_WAR_CRW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CRW field to a new value.
#define BW_RTC_WAR_CRW(v)    (BITBAND_ACCESS32(HW_RTC_WAR_ADDR, BP_RTC_WAR_CRW) = (v))
#endif
//@}

/*!
 * @name Register RTC_WAR, field SRW[5] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Writes to the Status Register are ignored.
 * - 1 - Writes to the Status Register complete as normal.
 */
//@{
#define BP_RTC_WAR_SRW       (5U)          //!< Bit position for RTC_WAR_SRW.
#define BM_RTC_WAR_SRW       (0x00000020U) //!< Bit mask for RTC_WAR_SRW.
#define BS_RTC_WAR_SRW       (1U)          //!< Bit field size in bits for RTC_WAR_SRW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_WAR_SRW field.
#define BR_RTC_WAR_SRW       (BITBAND_ACCESS32(HW_RTC_WAR_ADDR, BP_RTC_WAR_SRW))
#endif

//! @brief Format value for bitfield RTC_WAR_SRW.
#define BF_RTC_WAR_SRW(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_WAR_SRW), uint32_t) & BM_RTC_WAR_SRW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SRW field to a new value.
#define BW_RTC_WAR_SRW(v)    (BITBAND_ACCESS32(HW_RTC_WAR_ADDR, BP_RTC_WAR_SRW) = (v))
#endif
//@}

/*!
 * @name Register RTC_WAR, field LRW[6] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Writes to the Lock Register are ignored.
 * - 1 - Writes to the Lock Register complete as normal.
 */
//@{
#define BP_RTC_WAR_LRW       (6U)          //!< Bit position for RTC_WAR_LRW.
#define BM_RTC_WAR_LRW       (0x00000040U) //!< Bit mask for RTC_WAR_LRW.
#define BS_RTC_WAR_LRW       (1U)          //!< Bit field size in bits for RTC_WAR_LRW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_WAR_LRW field.
#define BR_RTC_WAR_LRW       (BITBAND_ACCESS32(HW_RTC_WAR_ADDR, BP_RTC_WAR_LRW))
#endif

//! @brief Format value for bitfield RTC_WAR_LRW.
#define BF_RTC_WAR_LRW(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_WAR_LRW), uint32_t) & BM_RTC_WAR_LRW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LRW field to a new value.
#define BW_RTC_WAR_LRW(v)    (BITBAND_ACCESS32(HW_RTC_WAR_ADDR, BP_RTC_WAR_LRW) = (v))
#endif
//@}

/*!
 * @name Register RTC_WAR, field IERW[7] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Writes to the Interupt Enable Register are ignored.
 * - 1 - Writes to the Interrupt Enable Register complete as normal.
 */
//@{
#define BP_RTC_WAR_IERW      (7U)          //!< Bit position for RTC_WAR_IERW.
#define BM_RTC_WAR_IERW      (0x00000080U) //!< Bit mask for RTC_WAR_IERW.
#define BS_RTC_WAR_IERW      (1U)          //!< Bit field size in bits for RTC_WAR_IERW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_WAR_IERW field.
#define BR_RTC_WAR_IERW      (BITBAND_ACCESS32(HW_RTC_WAR_ADDR, BP_RTC_WAR_IERW))
#endif

//! @brief Format value for bitfield RTC_WAR_IERW.
#define BF_RTC_WAR_IERW(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_WAR_IERW), uint32_t) & BM_RTC_WAR_IERW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IERW field to a new value.
#define BW_RTC_WAR_IERW(v)   (BITBAND_ACCESS32(HW_RTC_WAR_ADDR, BP_RTC_WAR_IERW) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_RTC_RAR - RTC Read Access Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_RTC_RAR - RTC Read Access Register (RW)
 *
 * Reset value: 0x000000FFU
 */
typedef union _hw_rtc_rar
{
    uint32_t U;
    struct _hw_rtc_rar_bitfields
    {
        uint32_t TSRR : 1;             //!< [0] Time Seconds Register Read
        uint32_t TPRR : 1;             //!< [1] Time Prescaler Register Read
        uint32_t TARR : 1;             //!< [2] Time Alarm Register Read
        uint32_t TCRR : 1;             //!< [3] Time Compensation Register Read
        uint32_t CRR : 1;              //!< [4] Control Register Read
        uint32_t SRR : 1;              //!< [5] Status Register Read
        uint32_t LRR : 1;              //!< [6] Lock Register Read
        uint32_t IERR : 1;             //!< [7] Interrupt Enable Register Read
        uint32_t RESERVED0 : 24;       //!< [31:8]
    } B;
} hw_rtc_rar_t;
#endif

/*!
 * @name Constants and macros for entire RTC_RAR register
 */
//@{
#define HW_RTC_RAR_ADDR          (REGS_RTC_BASE + 0x804U)

#ifndef __LANGUAGE_ASM__
#define HW_RTC_RAR               (*(__IO hw_rtc_rar_t *) HW_RTC_RAR_ADDR)
#define HW_RTC_RAR_RD()          (HW_RTC_RAR.U)
#define HW_RTC_RAR_WR(v)         (HW_RTC_RAR.U = (v))
#define HW_RTC_RAR_SET(v)        (HW_RTC_RAR_WR(HW_RTC_RAR_RD() |  (v)))
#define HW_RTC_RAR_CLR(v)        (HW_RTC_RAR_WR(HW_RTC_RAR_RD() & ~(v)))
#define HW_RTC_RAR_TOG(v)        (HW_RTC_RAR_WR(HW_RTC_RAR_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual RTC_RAR bitfields
 */

/*!
 * @name Register RTC_RAR, field TSRR[0] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Reads to the Time Seconds Register are ignored.
 * - 1 - Reads to the Time Seconds Register complete as normal.
 */
//@{
#define BP_RTC_RAR_TSRR      (0U)          //!< Bit position for RTC_RAR_TSRR.
#define BM_RTC_RAR_TSRR      (0x00000001U) //!< Bit mask for RTC_RAR_TSRR.
#define BS_RTC_RAR_TSRR      (1U)          //!< Bit field size in bits for RTC_RAR_TSRR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_RAR_TSRR field.
#define BR_RTC_RAR_TSRR      (BITBAND_ACCESS32(HW_RTC_RAR_ADDR, BP_RTC_RAR_TSRR))
#endif

//! @brief Format value for bitfield RTC_RAR_TSRR.
#define BF_RTC_RAR_TSRR(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_RAR_TSRR), uint32_t) & BM_RTC_RAR_TSRR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TSRR field to a new value.
#define BW_RTC_RAR_TSRR(v)   (BITBAND_ACCESS32(HW_RTC_RAR_ADDR, BP_RTC_RAR_TSRR) = (v))
#endif
//@}

/*!
 * @name Register RTC_RAR, field TPRR[1] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Reads to the Time Pprescaler Register are ignored.
 * - 1 - Reads to the Time Prescaler Register complete as normal.
 */
//@{
#define BP_RTC_RAR_TPRR      (1U)          //!< Bit position for RTC_RAR_TPRR.
#define BM_RTC_RAR_TPRR      (0x00000002U) //!< Bit mask for RTC_RAR_TPRR.
#define BS_RTC_RAR_TPRR      (1U)          //!< Bit field size in bits for RTC_RAR_TPRR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_RAR_TPRR field.
#define BR_RTC_RAR_TPRR      (BITBAND_ACCESS32(HW_RTC_RAR_ADDR, BP_RTC_RAR_TPRR))
#endif

//! @brief Format value for bitfield RTC_RAR_TPRR.
#define BF_RTC_RAR_TPRR(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_RAR_TPRR), uint32_t) & BM_RTC_RAR_TPRR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TPRR field to a new value.
#define BW_RTC_RAR_TPRR(v)   (BITBAND_ACCESS32(HW_RTC_RAR_ADDR, BP_RTC_RAR_TPRR) = (v))
#endif
//@}

/*!
 * @name Register RTC_RAR, field TARR[2] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Reads to the Time Alarm Register are ignored.
 * - 1 - Reads to the Time Alarm Register complete as normal.
 */
//@{
#define BP_RTC_RAR_TARR      (2U)          //!< Bit position for RTC_RAR_TARR.
#define BM_RTC_RAR_TARR      (0x00000004U) //!< Bit mask for RTC_RAR_TARR.
#define BS_RTC_RAR_TARR      (1U)          //!< Bit field size in bits for RTC_RAR_TARR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_RAR_TARR field.
#define BR_RTC_RAR_TARR      (BITBAND_ACCESS32(HW_RTC_RAR_ADDR, BP_RTC_RAR_TARR))
#endif

//! @brief Format value for bitfield RTC_RAR_TARR.
#define BF_RTC_RAR_TARR(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_RAR_TARR), uint32_t) & BM_RTC_RAR_TARR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TARR field to a new value.
#define BW_RTC_RAR_TARR(v)   (BITBAND_ACCESS32(HW_RTC_RAR_ADDR, BP_RTC_RAR_TARR) = (v))
#endif
//@}

/*!
 * @name Register RTC_RAR, field TCRR[3] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Reads to the Time Compensation Register are ignored.
 * - 1 - Reads to the Time Compensation Register complete as normal.
 */
//@{
#define BP_RTC_RAR_TCRR      (3U)          //!< Bit position for RTC_RAR_TCRR.
#define BM_RTC_RAR_TCRR      (0x00000008U) //!< Bit mask for RTC_RAR_TCRR.
#define BS_RTC_RAR_TCRR      (1U)          //!< Bit field size in bits for RTC_RAR_TCRR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_RAR_TCRR field.
#define BR_RTC_RAR_TCRR      (BITBAND_ACCESS32(HW_RTC_RAR_ADDR, BP_RTC_RAR_TCRR))
#endif

//! @brief Format value for bitfield RTC_RAR_TCRR.
#define BF_RTC_RAR_TCRR(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_RAR_TCRR), uint32_t) & BM_RTC_RAR_TCRR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TCRR field to a new value.
#define BW_RTC_RAR_TCRR(v)   (BITBAND_ACCESS32(HW_RTC_RAR_ADDR, BP_RTC_RAR_TCRR) = (v))
#endif
//@}

/*!
 * @name Register RTC_RAR, field CRR[4] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Reads to the Control Register are ignored.
 * - 1 - Reads to the Control Register complete as normal.
 */
//@{
#define BP_RTC_RAR_CRR       (4U)          //!< Bit position for RTC_RAR_CRR.
#define BM_RTC_RAR_CRR       (0x00000010U) //!< Bit mask for RTC_RAR_CRR.
#define BS_RTC_RAR_CRR       (1U)          //!< Bit field size in bits for RTC_RAR_CRR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_RAR_CRR field.
#define BR_RTC_RAR_CRR       (BITBAND_ACCESS32(HW_RTC_RAR_ADDR, BP_RTC_RAR_CRR))
#endif

//! @brief Format value for bitfield RTC_RAR_CRR.
#define BF_RTC_RAR_CRR(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_RAR_CRR), uint32_t) & BM_RTC_RAR_CRR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the CRR field to a new value.
#define BW_RTC_RAR_CRR(v)    (BITBAND_ACCESS32(HW_RTC_RAR_ADDR, BP_RTC_RAR_CRR) = (v))
#endif
//@}

/*!
 * @name Register RTC_RAR, field SRR[5] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Reads to the Status Register are ignored.
 * - 1 - Reads to the Status Register complete as normal.
 */
//@{
#define BP_RTC_RAR_SRR       (5U)          //!< Bit position for RTC_RAR_SRR.
#define BM_RTC_RAR_SRR       (0x00000020U) //!< Bit mask for RTC_RAR_SRR.
#define BS_RTC_RAR_SRR       (1U)          //!< Bit field size in bits for RTC_RAR_SRR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_RAR_SRR field.
#define BR_RTC_RAR_SRR       (BITBAND_ACCESS32(HW_RTC_RAR_ADDR, BP_RTC_RAR_SRR))
#endif

//! @brief Format value for bitfield RTC_RAR_SRR.
#define BF_RTC_RAR_SRR(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_RAR_SRR), uint32_t) & BM_RTC_RAR_SRR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SRR field to a new value.
#define BW_RTC_RAR_SRR(v)    (BITBAND_ACCESS32(HW_RTC_RAR_ADDR, BP_RTC_RAR_SRR) = (v))
#endif
//@}

/*!
 * @name Register RTC_RAR, field LRR[6] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Reads to the Lock Register are ignored.
 * - 1 - Reads to the Lock Register complete as normal.
 */
//@{
#define BP_RTC_RAR_LRR       (6U)          //!< Bit position for RTC_RAR_LRR.
#define BM_RTC_RAR_LRR       (0x00000040U) //!< Bit mask for RTC_RAR_LRR.
#define BS_RTC_RAR_LRR       (1U)          //!< Bit field size in bits for RTC_RAR_LRR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_RAR_LRR field.
#define BR_RTC_RAR_LRR       (BITBAND_ACCESS32(HW_RTC_RAR_ADDR, BP_RTC_RAR_LRR))
#endif

//! @brief Format value for bitfield RTC_RAR_LRR.
#define BF_RTC_RAR_LRR(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_RAR_LRR), uint32_t) & BM_RTC_RAR_LRR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the LRR field to a new value.
#define BW_RTC_RAR_LRR(v)    (BITBAND_ACCESS32(HW_RTC_RAR_ADDR, BP_RTC_RAR_LRR) = (v))
#endif
//@}

/*!
 * @name Register RTC_RAR, field IERR[7] (RW)
 *
 * After being cleared, this bit is set only by system reset. It is not affected
 * by VBAT POR or software reset.
 *
 * Values:
 * - 0 - Reads to the Interrupt Enable Register are ignored.
 * - 1 - Reads to the Interrupt Enable Register complete as normal.
 */
//@{
#define BP_RTC_RAR_IERR      (7U)          //!< Bit position for RTC_RAR_IERR.
#define BM_RTC_RAR_IERR      (0x00000080U) //!< Bit mask for RTC_RAR_IERR.
#define BS_RTC_RAR_IERR      (1U)          //!< Bit field size in bits for RTC_RAR_IERR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the RTC_RAR_IERR field.
#define BR_RTC_RAR_IERR      (BITBAND_ACCESS32(HW_RTC_RAR_ADDR, BP_RTC_RAR_IERR))
#endif

//! @brief Format value for bitfield RTC_RAR_IERR.
#define BF_RTC_RAR_IERR(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_RTC_RAR_IERR), uint32_t) & BM_RTC_RAR_IERR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the IERR field to a new value.
#define BW_RTC_RAR_IERR(v)   (BITBAND_ACCESS32(HW_RTC_RAR_ADDR, BP_RTC_RAR_IERR) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_rtc_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All RTC module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_rtc
{
    __IO hw_rtc_tsr_t TSR;                 //!< [0x0] RTC Time Seconds Register
    __IO hw_rtc_tpr_t TPR;                 //!< [0x4] RTC Time Prescaler Register
    __IO hw_rtc_tar_t TAR;                 //!< [0x8] RTC Time Alarm Register
    __IO hw_rtc_tcr_t TCR;                 //!< [0xC] RTC Time Compensation Register
    __IO hw_rtc_cr_t CR;                   //!< [0x10] RTC Control Register
    __IO hw_rtc_sr_t SR;                   //!< [0x14] RTC Status Register
    __IO hw_rtc_lr_t LR;                   //!< [0x18] RTC Lock Register
    __IO hw_rtc_ier_t IER;                 //!< [0x1C] RTC Interrupt Enable Register
    uint8_t _reserved0[2016];
    __IO hw_rtc_war_t WAR;                 //!< [0x800] RTC Write Access Register
    __IO hw_rtc_rar_t RAR;                 //!< [0x804] RTC Read Access Register
} hw_rtc_t;
#pragma pack()

//! @brief Macro to access all RTC registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_RTC</code>.
#define HW_RTC         (*(hw_rtc_t *) REGS_RTC_BASE)
#endif

#endif // __HW_RTC_REGISTERS_H__
// v22/130726/0.9
// EOF

