/*
 * Copyright (c) 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_MPU_REGISTERS_H__
#define __HW_MPU_REGISTERS_H__

#include "regs.h"

/*
 * MK64F12 MPU
 *
 * Memory protection unit
 *
 * Registers defined in this header file:
 * - HW_MPU_CESR - Control/Error Status Register
 * - HW_MPU_EARn - Error Address Register, slave port n
 * - HW_MPU_EDRn - Error Detail Register, slave port n
 * - HW_MPU_RGDn_WORD0 - Region Descriptor n, Word 0
 * - HW_MPU_RGDn_WORD1 - Region Descriptor n, Word 1
 * - HW_MPU_RGDn_WORD2 - Region Descriptor n, Word 2
 * - HW_MPU_RGDn_WORD3 - Region Descriptor n, Word 3
 * - HW_MPU_RGDAACn - Region Descriptor Alternate Access Control n
 *
 * - hw_mpu_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_MPU_BASE
#define HW_MPU_INSTANCE_COUNT (1U) //!< Number of instances of the MPU module.
#define REGS_MPU_BASE (0x4000D000U) //!< Base address for MPU.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MPU_CESR - Control/Error Status Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MPU_CESR - Control/Error Status Register (RW)
 *
 * Reset value: 0x00815101U
 */
typedef union _hw_mpu_cesr
{
    uint32_t U;
    struct _hw_mpu_cesr_bitfields
    {
        uint32_t VLD : 1;              //!< [0] Valid
        uint32_t RESERVED0 : 7;        //!< [7:1]
        uint32_t NRGD : 4;             //!< [11:8] Number Of Region Descriptors
        uint32_t NSP : 4;              //!< [15:12] Number Of Slave Ports
        uint32_t HRL : 4;              //!< [19:16] Hardware Revision Level
        uint32_t RESERVED1 : 7;        //!< [26:20]
        uint32_t SPERR : 5;            //!< [31:27] Slave Port n Error
    } B;
} hw_mpu_cesr_t;
#endif

/*!
 * @name Constants and macros for entire MPU_CESR register
 */
//@{
#define HW_MPU_CESR_ADDR         (REGS_MPU_BASE + 0x0U)

#ifndef __LANGUAGE_ASM__
#define HW_MPU_CESR              (*(__IO hw_mpu_cesr_t *) HW_MPU_CESR_ADDR)
#define HW_MPU_CESR_RD()         (HW_MPU_CESR.U)
#define HW_MPU_CESR_WR(v)        (HW_MPU_CESR.U = (v))
#define HW_MPU_CESR_SET(v)       (HW_MPU_CESR_WR(HW_MPU_CESR_RD() |  (v)))
#define HW_MPU_CESR_CLR(v)       (HW_MPU_CESR_WR(HW_MPU_CESR_RD() & ~(v)))
#define HW_MPU_CESR_TOG(v)       (HW_MPU_CESR_WR(HW_MPU_CESR_RD() ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual MPU_CESR bitfields
 */

/*!
 * @name Register MPU_CESR, field VLD[0] (RW)
 *
 * Global enable/disable for the MPU.
 *
 * Values:
 * - 0 - MPU is disabled. All accesses from all bus masters are allowed.
 * - 1 - MPU is enabled
 */
//@{
#define BP_MPU_CESR_VLD      (0U)          //!< Bit position for MPU_CESR_VLD.
#define BM_MPU_CESR_VLD      (0x00000001U) //!< Bit mask for MPU_CESR_VLD.
#define BS_MPU_CESR_VLD      (1U)          //!< Bit field size in bits for MPU_CESR_VLD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_CESR_VLD field.
#define BR_MPU_CESR_VLD      (BITBAND_ACCESS32(HW_MPU_CESR_ADDR, BP_MPU_CESR_VLD))
#endif

//! @brief Format value for bitfield MPU_CESR_VLD.
#define BF_MPU_CESR_VLD(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_CESR_VLD), uint32_t) & BM_MPU_CESR_VLD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VLD field to a new value.
#define BW_MPU_CESR_VLD(v)   (BITBAND_ACCESS32(HW_MPU_CESR_ADDR, BP_MPU_CESR_VLD) = (v))
#endif
//@}

/*!
 * @name Register MPU_CESR, field NRGD[11:8] (RO)
 *
 * Indicates the number of region descriptors implemented in the MPU.
 *
 * Values:
 * - 0000 - 8 region descriptors
 * - 0001 - 12 region descriptors
 * - 0010 - 16 region descriptors
 */
//@{
#define BP_MPU_CESR_NRGD     (8U)          //!< Bit position for MPU_CESR_NRGD.
#define BM_MPU_CESR_NRGD     (0x00000F00U) //!< Bit mask for MPU_CESR_NRGD.
#define BS_MPU_CESR_NRGD     (4U)          //!< Bit field size in bits for MPU_CESR_NRGD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_CESR_NRGD field.
#define BR_MPU_CESR_NRGD     (HW_MPU_CESR.B.NRGD)
#endif
//@}

/*!
 * @name Register MPU_CESR, field NSP[15:12] (RO)
 *
 * Specifies the number of slave ports connected to the MPU.
 */
//@{
#define BP_MPU_CESR_NSP      (12U)         //!< Bit position for MPU_CESR_NSP.
#define BM_MPU_CESR_NSP      (0x0000F000U) //!< Bit mask for MPU_CESR_NSP.
#define BS_MPU_CESR_NSP      (4U)          //!< Bit field size in bits for MPU_CESR_NSP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_CESR_NSP field.
#define BR_MPU_CESR_NSP      (HW_MPU_CESR.B.NSP)
#endif
//@}

/*!
 * @name Register MPU_CESR, field HRL[19:16] (RO)
 *
 * Specifies the MPU's hardware and definition revision level. It can be read by
 * software to determine the functional definition of the module.
 */
//@{
#define BP_MPU_CESR_HRL      (16U)         //!< Bit position for MPU_CESR_HRL.
#define BM_MPU_CESR_HRL      (0x000F0000U) //!< Bit mask for MPU_CESR_HRL.
#define BS_MPU_CESR_HRL      (4U)          //!< Bit field size in bits for MPU_CESR_HRL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_CESR_HRL field.
#define BR_MPU_CESR_HRL      (HW_MPU_CESR.B.HRL)
#endif
//@}

/*!
 * @name Register MPU_CESR, field SPERR[31:27] (W1C)
 *
 * Indicates a captured error in EARn and EDRn. This bit is set when the
 * hardware detects an error and records the faulting address and attributes. It is
 * cleared by writing one to it. If another error is captured at the exact same cycle
 * as the write, the flag remains set. A find-first-one instruction or
 * equivalent can detect the presence of a captured error. The following shows the
 * correspondence between the bit number and slave port number: Bit 31 corresponds to
 * slave port 0. Bit 30 corresponds to slave port 1. Bit 29 corresponds to slave
 * port 2. Bit 28 corresponds to slave port 3. Bit 27 corresponds to slave port 4.
 *
 * Values:
 * - 0 - No error has occurred for slave port n.
 * - 1 - An error has occurred for slave port n.
 */
//@{
#define BP_MPU_CESR_SPERR    (27U)         //!< Bit position for MPU_CESR_SPERR.
#define BM_MPU_CESR_SPERR    (0xF8000000U) //!< Bit mask for MPU_CESR_SPERR.
#define BS_MPU_CESR_SPERR    (5U)          //!< Bit field size in bits for MPU_CESR_SPERR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_CESR_SPERR field.
#define BR_MPU_CESR_SPERR    (HW_MPU_CESR.B.SPERR)
#endif

//! @brief Format value for bitfield MPU_CESR_SPERR.
#define BF_MPU_CESR_SPERR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_CESR_SPERR), uint32_t) & BM_MPU_CESR_SPERR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SPERR field to a new value.
#define BW_MPU_CESR_SPERR(v) (HW_MPU_CESR_WR((HW_MPU_CESR_RD() & ~BM_MPU_CESR_SPERR) | BF_MPU_CESR_SPERR(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MPU_EARn - Error Address Register, slave port n
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MPU_EARn - Error Address Register, slave port n (RO)
 *
 * Reset value: 0x00000000U
 *
 * When the MPU detects an access error on slave port n, the 32-bit reference
 * address is captured in this read-only register and the corresponding bit in
 * CESR[SPERR] set. Additional information about the faulting access is captured in
 * the corresponding EDRn at the same time. This register and the corresponding
 * EDRn contain the most recent access error; there are no hardware interlocks with
 * CESR[SPERR], as the error registers are always loaded upon the occurrence of
 * each protection violation.
 */
typedef union _hw_mpu_earn
{
    uint32_t U;
    struct _hw_mpu_earn_bitfields
    {
        uint32_t EADDR : 32;           //!< [31:0] Error Address
    } B;
} hw_mpu_earn_t;
#endif

/*!
 * @name Constants and macros for entire MPU_EARn register
 */
//@{
#define HW_MPU_EARn_COUNT (5U)

#define HW_MPU_EARn_ADDR(n)      (REGS_MPU_BASE + 0x10U + (0x8U * n))

#ifndef __LANGUAGE_ASM__
#define HW_MPU_EARn(n)           (*(__I hw_mpu_earn_t *) HW_MPU_EARn_ADDR(n))
#define HW_MPU_EARn_RD(n)        (HW_MPU_EARn(n).U)
#endif
//@}

/*
 * Constants & macros for individual MPU_EARn bitfields
 */

/*!
 * @name Register MPU_EARn, field EADDR[31:0] (RO)
 *
 * Indicates the reference address from slave port n that generated the access
 * error
 */
//@{
#define BP_MPU_EARn_EADDR    (0U)          //!< Bit position for MPU_EARn_EADDR.
#define BM_MPU_EARn_EADDR    (0xFFFFFFFFU) //!< Bit mask for MPU_EARn_EADDR.
#define BS_MPU_EARn_EADDR    (32U)         //!< Bit field size in bits for MPU_EARn_EADDR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_EARn_EADDR field.
#define BR_MPU_EARn_EADDR(n) (HW_MPU_EARn(n).U)
#endif
//@}
//-------------------------------------------------------------------------------------------
// HW_MPU_EDRn - Error Detail Register, slave port n
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MPU_EDRn - Error Detail Register, slave port n (RO)
 *
 * Reset value: 0x00000000U
 *
 * When the MPU detects an access error on slave port n, 32 bits of error detail
 * are captured in this read-only register and the corresponding bit in
 * CESR[SPERR] is set. Information on the faulting address is captured in the
 * corresponding EARn register at the same time. This register and the corresponding EARn
 * register contain the most recent access error; there are no hardware interlocks
 * with CESR[SPERR] as the error registers are always loaded upon the occurrence
 * of each protection violation.
 */
typedef union _hw_mpu_edrn
{
    uint32_t U;
    struct _hw_mpu_edrn_bitfields
    {
        uint32_t ERW : 1;              //!< [0] Error Read/Write
        uint32_t EATTR : 3;            //!< [3:1] Error Attributes
        uint32_t EMN : 4;              //!< [7:4] Error Master Number
        uint32_t EPID : 8;             //!< [15:8] Error Process Identification
        uint32_t EACD : 16;            //!< [31:16] Error Access Control Detail
    } B;
} hw_mpu_edrn_t;
#endif

/*!
 * @name Constants and macros for entire MPU_EDRn register
 */
//@{
#define HW_MPU_EDRn_COUNT (5U)

#define HW_MPU_EDRn_ADDR(n)      (REGS_MPU_BASE + 0x14U + (0x8U * n))

#ifndef __LANGUAGE_ASM__
#define HW_MPU_EDRn(n)           (*(__I hw_mpu_edrn_t *) HW_MPU_EDRn_ADDR(n))
#define HW_MPU_EDRn_RD(n)        (HW_MPU_EDRn(n).U)
#endif
//@}

/*
 * Constants & macros for individual MPU_EDRn bitfields
 */

/*!
 * @name Register MPU_EDRn, field ERW[0] (RO)
 *
 * Indicates the access type of the faulting reference.
 *
 * Values:
 * - 0 - Read
 * - 1 - Write
 */
//@{
#define BP_MPU_EDRn_ERW      (0U)          //!< Bit position for MPU_EDRn_ERW.
#define BM_MPU_EDRn_ERW      (0x00000001U) //!< Bit mask for MPU_EDRn_ERW.
#define BS_MPU_EDRn_ERW      (1U)          //!< Bit field size in bits for MPU_EDRn_ERW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_EDRn_ERW field.
#define BR_MPU_EDRn_ERW(n)   (BITBAND_ACCESS32(HW_MPU_EDRn_ADDR(n), BP_MPU_EDRn_ERW))
#endif
//@}

/*!
 * @name Register MPU_EDRn, field EATTR[3:1] (RO)
 *
 * Indicates attribute information about the faulting reference. All other
 * encodings are reserved.
 *
 * Values:
 * - 000 - User mode, instruction access
 * - 001 - User mode, data access
 * - 010 - Supervisor mode, instruction access
 * - 011 - Supervisor mode, data access
 */
//@{
#define BP_MPU_EDRn_EATTR    (1U)          //!< Bit position for MPU_EDRn_EATTR.
#define BM_MPU_EDRn_EATTR    (0x0000000EU) //!< Bit mask for MPU_EDRn_EATTR.
#define BS_MPU_EDRn_EATTR    (3U)          //!< Bit field size in bits for MPU_EDRn_EATTR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_EDRn_EATTR field.
#define BR_MPU_EDRn_EATTR(n) (HW_MPU_EDRn(n).B.EATTR)
#endif
//@}

/*!
 * @name Register MPU_EDRn, field EMN[7:4] (RO)
 *
 * Indicates the bus master that generated the access error.
 */
//@{
#define BP_MPU_EDRn_EMN      (4U)          //!< Bit position for MPU_EDRn_EMN.
#define BM_MPU_EDRn_EMN      (0x000000F0U) //!< Bit mask for MPU_EDRn_EMN.
#define BS_MPU_EDRn_EMN      (4U)          //!< Bit field size in bits for MPU_EDRn_EMN.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_EDRn_EMN field.
#define BR_MPU_EDRn_EMN(n)   (HW_MPU_EDRn(n).B.EMN)
#endif
//@}

/*!
 * @name Register MPU_EDRn, field EPID[15:8] (RO)
 *
 * Records the process identifier of the faulting reference. The process
 * identifier is typically driven only by processor cores; for other bus masters, this
 * field is cleared.
 */
//@{
#define BP_MPU_EDRn_EPID     (8U)          //!< Bit position for MPU_EDRn_EPID.
#define BM_MPU_EDRn_EPID     (0x0000FF00U) //!< Bit mask for MPU_EDRn_EPID.
#define BS_MPU_EDRn_EPID     (8U)          //!< Bit field size in bits for MPU_EDRn_EPID.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_EDRn_EPID field.
#define BR_MPU_EDRn_EPID(n)  (HW_MPU_EDRn(n).B.EPID)
#endif
//@}

/*!
 * @name Register MPU_EDRn, field EACD[31:16] (RO)
 *
 * Indicates the region descriptor with the access error. If EDRn contains a
 * captured error and EACD is cleared, an access did not hit in any region
 * descriptor. If only a single EACD bit is set, the protection error was caused by a
 * single non-overlapping region descriptor. If two or more EACD bits are set, the
 * protection error was caused by an overlapping set of region descriptors.
 */
//@{
#define BP_MPU_EDRn_EACD     (16U)         //!< Bit position for MPU_EDRn_EACD.
#define BM_MPU_EDRn_EACD     (0xFFFF0000U) //!< Bit mask for MPU_EDRn_EACD.
#define BS_MPU_EDRn_EACD     (16U)         //!< Bit field size in bits for MPU_EDRn_EACD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_EDRn_EACD field.
#define BR_MPU_EDRn_EACD(n)  (HW_MPU_EDRn(n).B.EACD)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MPU_RGDn_WORD0 - Region Descriptor n, Word 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MPU_RGDn_WORD0 - Region Descriptor n, Word 0 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The first word of the region descriptor defines the 0-modulo-32 byte start
 * address of the memory region. Writes to this register clear the region
 * descriptor's valid bit (RGDn_WORD3[VLD]).
 */
typedef union _hw_mpu_rgdn_word0
{
    uint32_t U;
    struct _hw_mpu_rgdn_word0_bitfields
    {
        uint32_t RESERVED0 : 5;        //!< [4:0]
        uint32_t SRTADDR : 27;         //!< [31:5] Start Address
    } B;
} hw_mpu_rgdn_word0_t;
#endif

/*!
 * @name Constants and macros for entire MPU_RGDn_WORD0 register
 */
//@{
#define HW_MPU_RGDn_WORD0_COUNT (12U)

#define HW_MPU_RGDn_WORD0_ADDR(n) (REGS_MPU_BASE + 0x400U + (0x10U * n))

#ifndef __LANGUAGE_ASM__
#define HW_MPU_RGDn_WORD0(n)     (*(__IO hw_mpu_rgdn_word0_t *) HW_MPU_RGDn_WORD0_ADDR(n))
#define HW_MPU_RGDn_WORD0_RD(n)  (HW_MPU_RGDn_WORD0(n).U)
#define HW_MPU_RGDn_WORD0_WR(n, v) (HW_MPU_RGDn_WORD0(n).U = (v))
#define HW_MPU_RGDn_WORD0_SET(n, v) (HW_MPU_RGDn_WORD0_WR(n, HW_MPU_RGDn_WORD0_RD(n) |  (v)))
#define HW_MPU_RGDn_WORD0_CLR(n, v) (HW_MPU_RGDn_WORD0_WR(n, HW_MPU_RGDn_WORD0_RD(n) & ~(v)))
#define HW_MPU_RGDn_WORD0_TOG(n, v) (HW_MPU_RGDn_WORD0_WR(n, HW_MPU_RGDn_WORD0_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual MPU_RGDn_WORD0 bitfields
 */

/*!
 * @name Register MPU_RGDn_WORD0, field SRTADDR[31:5] (RW)
 *
 * Defines the most significant bits of the 0-modulo-32 byte start address of
 * the memory region.
 */
//@{
#define BP_MPU_RGDn_WORD0_SRTADDR (5U)     //!< Bit position for MPU_RGDn_WORD0_SRTADDR.
#define BM_MPU_RGDn_WORD0_SRTADDR (0xFFFFFFE0U) //!< Bit mask for MPU_RGDn_WORD0_SRTADDR.
#define BS_MPU_RGDn_WORD0_SRTADDR (27U)    //!< Bit field size in bits for MPU_RGDn_WORD0_SRTADDR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD0_SRTADDR field.
#define BR_MPU_RGDn_WORD0_SRTADDR(n) (HW_MPU_RGDn_WORD0(n).B.SRTADDR)
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD0_SRTADDR.
#define BF_MPU_RGDn_WORD0_SRTADDR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD0_SRTADDR), uint32_t) & BM_MPU_RGDn_WORD0_SRTADDR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SRTADDR field to a new value.
#define BW_MPU_RGDn_WORD0_SRTADDR(n, v) (HW_MPU_RGDn_WORD0_WR(n, (HW_MPU_RGDn_WORD0_RD(n) & ~BM_MPU_RGDn_WORD0_SRTADDR) | BF_MPU_RGDn_WORD0_SRTADDR(v)))
#endif
//@}
//-------------------------------------------------------------------------------------------
// HW_MPU_RGDn_WORD1 - Region Descriptor n, Word 1
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MPU_RGDn_WORD1 - Region Descriptor n, Word 1 (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * The second word of the region descriptor defines the 31-modulo-32 byte end
 * address of the memory region. Writes to this register clear the region
 * descriptor's valid bit (RGDn_WORD3[VLD]).
 */
typedef union _hw_mpu_rgdn_word1
{
    uint32_t U;
    struct _hw_mpu_rgdn_word1_bitfields
    {
        uint32_t RESERVED0 : 5;        //!< [4:0]
        uint32_t ENDADDR : 27;         //!< [31:5] End Address
    } B;
} hw_mpu_rgdn_word1_t;
#endif

/*!
 * @name Constants and macros for entire MPU_RGDn_WORD1 register
 */
//@{
#define HW_MPU_RGDn_WORD1_COUNT (12U)

#define HW_MPU_RGDn_WORD1_ADDR(n) (REGS_MPU_BASE + 0x404U + (0x10U * n))

#ifndef __LANGUAGE_ASM__
#define HW_MPU_RGDn_WORD1(n)     (*(__IO hw_mpu_rgdn_word1_t *) HW_MPU_RGDn_WORD1_ADDR(n))
#define HW_MPU_RGDn_WORD1_RD(n)  (HW_MPU_RGDn_WORD1(n).U)
#define HW_MPU_RGDn_WORD1_WR(n, v) (HW_MPU_RGDn_WORD1(n).U = (v))
#define HW_MPU_RGDn_WORD1_SET(n, v) (HW_MPU_RGDn_WORD1_WR(n, HW_MPU_RGDn_WORD1_RD(n) |  (v)))
#define HW_MPU_RGDn_WORD1_CLR(n, v) (HW_MPU_RGDn_WORD1_WR(n, HW_MPU_RGDn_WORD1_RD(n) & ~(v)))
#define HW_MPU_RGDn_WORD1_TOG(n, v) (HW_MPU_RGDn_WORD1_WR(n, HW_MPU_RGDn_WORD1_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual MPU_RGDn_WORD1 bitfields
 */

/*!
 * @name Register MPU_RGDn_WORD1, field ENDADDR[31:5] (RW)
 *
 * Defines the most significant bits of the 31-modulo-32 byte end address of the
 * memory region. The MPU does not verify that ENDADDR >= SRTADDR.
 */
//@{
#define BP_MPU_RGDn_WORD1_ENDADDR (5U)     //!< Bit position for MPU_RGDn_WORD1_ENDADDR.
#define BM_MPU_RGDn_WORD1_ENDADDR (0xFFFFFFE0U) //!< Bit mask for MPU_RGDn_WORD1_ENDADDR.
#define BS_MPU_RGDn_WORD1_ENDADDR (27U)    //!< Bit field size in bits for MPU_RGDn_WORD1_ENDADDR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD1_ENDADDR field.
#define BR_MPU_RGDn_WORD1_ENDADDR(n) (HW_MPU_RGDn_WORD1(n).B.ENDADDR)
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD1_ENDADDR.
#define BF_MPU_RGDn_WORD1_ENDADDR(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD1_ENDADDR), uint32_t) & BM_MPU_RGDn_WORD1_ENDADDR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the ENDADDR field to a new value.
#define BW_MPU_RGDn_WORD1_ENDADDR(n, v) (HW_MPU_RGDn_WORD1_WR(n, (HW_MPU_RGDn_WORD1_RD(n) & ~BM_MPU_RGDn_WORD1_ENDADDR) | BF_MPU_RGDn_WORD1_ENDADDR(v)))
#endif
//@}
//-------------------------------------------------------------------------------------------
// HW_MPU_RGDn_WORD2 - Region Descriptor n, Word 2
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MPU_RGDn_WORD2 - Region Descriptor n, Word 2 (RW)
 *
 * Reset value: 0x0061F7DFU
 *
 * The third word of the region descriptor defines the access control rights of
 * the memory region. The access control privileges depend on two broad
 * classifications of bus masters: Bus masters 0-3 have a 5-bit field defining separate
 * privilege rights for user and supervisor mode accesses, as well as the optional
 * inclusion of a process identification field within the definition. Bus masters
 * 4-7 are limited to separate read and write permissions. For the privilege
 * rights of bus masters 0-3, there are three flags associated with this function:
 * Read (r) refers to accessing the referenced memory address using an operand
 * (data) fetch Write (w) refers to updating the referenced memory address using a
 * store (data) instruction Execute (x) refers to reading the referenced memory
 * address using an instruction fetch Writes to RGDn_WORD2 clear the region
 * descriptor's valid bit (RGDn_WORD3[VLD]). If only updating the access controls, write
 * to RGDAACn instead because stores to these locations do not affect the
 * descriptor's valid bit.
 */
typedef union _hw_mpu_rgdn_word2
{
    uint32_t U;
    struct _hw_mpu_rgdn_word2_bitfields
    {
        uint32_t M0UM : 3;             //!< [2:0] Bus Master 0 User Mode Access Control
        uint32_t M0SM : 2;             //!< [4:3] Bus Master 0 Supervisor Mode Access
                                       //! Control
        uint32_t M0PE : 1;             //!< [5] Bus Master 0 Process Identifier enable
        uint32_t M1UM : 3;             //!< [8:6] Bus Master 1 User Mode Access Control
        uint32_t M1SM : 2;             //!< [10:9] Bus Master 1 Supervisor Mode Access
                                       //! Control
        uint32_t M1PE : 1;             //!< [11] Bus Master 1 Process Identifier enable
        uint32_t M2UM : 3;             //!< [14:12] Bus Master 2 User Mode Access control
        uint32_t M2SM : 2;             //!< [16:15] Bus Master 2 Supervisor Mode Access
                                       //! Control
        uint32_t M2PE : 1;             //!< [17] Bus Master 2 Process Identifier Enable
        uint32_t M3UM : 3;             //!< [20:18] Bus Master 3 User Mode Access Control
        uint32_t M3SM : 2;             //!< [22:21] Bus Master 3 Supervisor Mode Access
                                       //! Control
        uint32_t M3PE : 1;             //!< [23] Bus Master 3 Process Identifier Enable
        uint32_t M4WE : 1;             //!< [24] Bus Master 4 Write Enable
        uint32_t M4RE : 1;             //!< [25] Bus Master 4 Read Enable
        uint32_t M5WE : 1;             //!< [26] Bus Master 5 Write Enable
        uint32_t M5RE : 1;             //!< [27] Bus Master 5 Read Enable
        uint32_t M6WE : 1;             //!< [28] Bus Master 6 Write Enable
        uint32_t M6RE : 1;             //!< [29] Bus Master 6 Read Enable
        uint32_t M7WE : 1;             //!< [30] Bus Master 7 Write Enable
        uint32_t M7RE : 1;             //!< [31] Bus Master 7 Read Enable
    } B;
} hw_mpu_rgdn_word2_t;
#endif

/*!
 * @name Constants and macros for entire MPU_RGDn_WORD2 register
 */
//@{
#define HW_MPU_RGDn_WORD2_COUNT (12U)

#define HW_MPU_RGDn_WORD2_ADDR(n) (REGS_MPU_BASE + 0x408U + (0x10U * n))

#ifndef __LANGUAGE_ASM__
#define HW_MPU_RGDn_WORD2(n)     (*(__IO hw_mpu_rgdn_word2_t *) HW_MPU_RGDn_WORD2_ADDR(n))
#define HW_MPU_RGDn_WORD2_RD(n)  (HW_MPU_RGDn_WORD2(n).U)
#define HW_MPU_RGDn_WORD2_WR(n, v) (HW_MPU_RGDn_WORD2(n).U = (v))
#define HW_MPU_RGDn_WORD2_SET(n, v) (HW_MPU_RGDn_WORD2_WR(n, HW_MPU_RGDn_WORD2_RD(n) |  (v)))
#define HW_MPU_RGDn_WORD2_CLR(n, v) (HW_MPU_RGDn_WORD2_WR(n, HW_MPU_RGDn_WORD2_RD(n) & ~(v)))
#define HW_MPU_RGDn_WORD2_TOG(n, v) (HW_MPU_RGDn_WORD2_WR(n, HW_MPU_RGDn_WORD2_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual MPU_RGDn_WORD2 bitfields
 */

/*!
 * @name Register MPU_RGDn_WORD2, field M0UM[2:0] (RW)
 *
 * See M3UM description.
 */
//@{
#define BP_MPU_RGDn_WORD2_M0UM (0U)        //!< Bit position for MPU_RGDn_WORD2_M0UM.
#define BM_MPU_RGDn_WORD2_M0UM (0x00000007U) //!< Bit mask for MPU_RGDn_WORD2_M0UM.
#define BS_MPU_RGDn_WORD2_M0UM (3U)        //!< Bit field size in bits for MPU_RGDn_WORD2_M0UM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD2_M0UM field.
#define BR_MPU_RGDn_WORD2_M0UM(n) (HW_MPU_RGDn_WORD2(n).B.M0UM)
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD2_M0UM.
#define BF_MPU_RGDn_WORD2_M0UM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD2_M0UM), uint32_t) & BM_MPU_RGDn_WORD2_M0UM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M0UM field to a new value.
#define BW_MPU_RGDn_WORD2_M0UM(n, v) (HW_MPU_RGDn_WORD2_WR(n, (HW_MPU_RGDn_WORD2_RD(n) & ~BM_MPU_RGDn_WORD2_M0UM) | BF_MPU_RGDn_WORD2_M0UM(v)))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD2, field M0SM[4:3] (RW)
 *
 * See M3SM description.
 */
//@{
#define BP_MPU_RGDn_WORD2_M0SM (3U)        //!< Bit position for MPU_RGDn_WORD2_M0SM.
#define BM_MPU_RGDn_WORD2_M0SM (0x00000018U) //!< Bit mask for MPU_RGDn_WORD2_M0SM.
#define BS_MPU_RGDn_WORD2_M0SM (2U)        //!< Bit field size in bits for MPU_RGDn_WORD2_M0SM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD2_M0SM field.
#define BR_MPU_RGDn_WORD2_M0SM(n) (HW_MPU_RGDn_WORD2(n).B.M0SM)
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD2_M0SM.
#define BF_MPU_RGDn_WORD2_M0SM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD2_M0SM), uint32_t) & BM_MPU_RGDn_WORD2_M0SM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M0SM field to a new value.
#define BW_MPU_RGDn_WORD2_M0SM(n, v) (HW_MPU_RGDn_WORD2_WR(n, (HW_MPU_RGDn_WORD2_RD(n) & ~BM_MPU_RGDn_WORD2_M0SM) | BF_MPU_RGDn_WORD2_M0SM(v)))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD2, field M0PE[5] (RW)
 *
 * See M0PE description.
 */
//@{
#define BP_MPU_RGDn_WORD2_M0PE (5U)        //!< Bit position for MPU_RGDn_WORD2_M0PE.
#define BM_MPU_RGDn_WORD2_M0PE (0x00000020U) //!< Bit mask for MPU_RGDn_WORD2_M0PE.
#define BS_MPU_RGDn_WORD2_M0PE (1U)        //!< Bit field size in bits for MPU_RGDn_WORD2_M0PE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD2_M0PE field.
#define BR_MPU_RGDn_WORD2_M0PE(n) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M0PE))
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD2_M0PE.
#define BF_MPU_RGDn_WORD2_M0PE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD2_M0PE), uint32_t) & BM_MPU_RGDn_WORD2_M0PE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M0PE field to a new value.
#define BW_MPU_RGDn_WORD2_M0PE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M0PE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD2, field M1UM[8:6] (RW)
 *
 * See M3UM description.
 */
//@{
#define BP_MPU_RGDn_WORD2_M1UM (6U)        //!< Bit position for MPU_RGDn_WORD2_M1UM.
#define BM_MPU_RGDn_WORD2_M1UM (0x000001C0U) //!< Bit mask for MPU_RGDn_WORD2_M1UM.
#define BS_MPU_RGDn_WORD2_M1UM (3U)        //!< Bit field size in bits for MPU_RGDn_WORD2_M1UM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD2_M1UM field.
#define BR_MPU_RGDn_WORD2_M1UM(n) (HW_MPU_RGDn_WORD2(n).B.M1UM)
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD2_M1UM.
#define BF_MPU_RGDn_WORD2_M1UM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD2_M1UM), uint32_t) & BM_MPU_RGDn_WORD2_M1UM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M1UM field to a new value.
#define BW_MPU_RGDn_WORD2_M1UM(n, v) (HW_MPU_RGDn_WORD2_WR(n, (HW_MPU_RGDn_WORD2_RD(n) & ~BM_MPU_RGDn_WORD2_M1UM) | BF_MPU_RGDn_WORD2_M1UM(v)))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD2, field M1SM[10:9] (RW)
 *
 * See M3SM description.
 */
//@{
#define BP_MPU_RGDn_WORD2_M1SM (9U)        //!< Bit position for MPU_RGDn_WORD2_M1SM.
#define BM_MPU_RGDn_WORD2_M1SM (0x00000600U) //!< Bit mask for MPU_RGDn_WORD2_M1SM.
#define BS_MPU_RGDn_WORD2_M1SM (2U)        //!< Bit field size in bits for MPU_RGDn_WORD2_M1SM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD2_M1SM field.
#define BR_MPU_RGDn_WORD2_M1SM(n) (HW_MPU_RGDn_WORD2(n).B.M1SM)
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD2_M1SM.
#define BF_MPU_RGDn_WORD2_M1SM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD2_M1SM), uint32_t) & BM_MPU_RGDn_WORD2_M1SM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M1SM field to a new value.
#define BW_MPU_RGDn_WORD2_M1SM(n, v) (HW_MPU_RGDn_WORD2_WR(n, (HW_MPU_RGDn_WORD2_RD(n) & ~BM_MPU_RGDn_WORD2_M1SM) | BF_MPU_RGDn_WORD2_M1SM(v)))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD2, field M1PE[11] (RW)
 *
 * See M3PE description.
 */
//@{
#define BP_MPU_RGDn_WORD2_M1PE (11U)       //!< Bit position for MPU_RGDn_WORD2_M1PE.
#define BM_MPU_RGDn_WORD2_M1PE (0x00000800U) //!< Bit mask for MPU_RGDn_WORD2_M1PE.
#define BS_MPU_RGDn_WORD2_M1PE (1U)        //!< Bit field size in bits for MPU_RGDn_WORD2_M1PE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD2_M1PE field.
#define BR_MPU_RGDn_WORD2_M1PE(n) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M1PE))
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD2_M1PE.
#define BF_MPU_RGDn_WORD2_M1PE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD2_M1PE), uint32_t) & BM_MPU_RGDn_WORD2_M1PE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M1PE field to a new value.
#define BW_MPU_RGDn_WORD2_M1PE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M1PE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD2, field M2UM[14:12] (RW)
 *
 * See M3UM description.
 */
//@{
#define BP_MPU_RGDn_WORD2_M2UM (12U)       //!< Bit position for MPU_RGDn_WORD2_M2UM.
#define BM_MPU_RGDn_WORD2_M2UM (0x00007000U) //!< Bit mask for MPU_RGDn_WORD2_M2UM.
#define BS_MPU_RGDn_WORD2_M2UM (3U)        //!< Bit field size in bits for MPU_RGDn_WORD2_M2UM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD2_M2UM field.
#define BR_MPU_RGDn_WORD2_M2UM(n) (HW_MPU_RGDn_WORD2(n).B.M2UM)
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD2_M2UM.
#define BF_MPU_RGDn_WORD2_M2UM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD2_M2UM), uint32_t) & BM_MPU_RGDn_WORD2_M2UM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M2UM field to a new value.
#define BW_MPU_RGDn_WORD2_M2UM(n, v) (HW_MPU_RGDn_WORD2_WR(n, (HW_MPU_RGDn_WORD2_RD(n) & ~BM_MPU_RGDn_WORD2_M2UM) | BF_MPU_RGDn_WORD2_M2UM(v)))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD2, field M2SM[16:15] (RW)
 *
 * See M3SM description.
 */
//@{
#define BP_MPU_RGDn_WORD2_M2SM (15U)       //!< Bit position for MPU_RGDn_WORD2_M2SM.
#define BM_MPU_RGDn_WORD2_M2SM (0x00018000U) //!< Bit mask for MPU_RGDn_WORD2_M2SM.
#define BS_MPU_RGDn_WORD2_M2SM (2U)        //!< Bit field size in bits for MPU_RGDn_WORD2_M2SM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD2_M2SM field.
#define BR_MPU_RGDn_WORD2_M2SM(n) (HW_MPU_RGDn_WORD2(n).B.M2SM)
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD2_M2SM.
#define BF_MPU_RGDn_WORD2_M2SM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD2_M2SM), uint32_t) & BM_MPU_RGDn_WORD2_M2SM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M2SM field to a new value.
#define BW_MPU_RGDn_WORD2_M2SM(n, v) (HW_MPU_RGDn_WORD2_WR(n, (HW_MPU_RGDn_WORD2_RD(n) & ~BM_MPU_RGDn_WORD2_M2SM) | BF_MPU_RGDn_WORD2_M2SM(v)))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD2, field M2PE[17] (RW)
 *
 * See M3PE description.
 */
//@{
#define BP_MPU_RGDn_WORD2_M2PE (17U)       //!< Bit position for MPU_RGDn_WORD2_M2PE.
#define BM_MPU_RGDn_WORD2_M2PE (0x00020000U) //!< Bit mask for MPU_RGDn_WORD2_M2PE.
#define BS_MPU_RGDn_WORD2_M2PE (1U)        //!< Bit field size in bits for MPU_RGDn_WORD2_M2PE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD2_M2PE field.
#define BR_MPU_RGDn_WORD2_M2PE(n) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M2PE))
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD2_M2PE.
#define BF_MPU_RGDn_WORD2_M2PE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD2_M2PE), uint32_t) & BM_MPU_RGDn_WORD2_M2PE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M2PE field to a new value.
#define BW_MPU_RGDn_WORD2_M2PE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M2PE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD2, field M3UM[20:18] (RW)
 *
 * Defines the access controls for bus master 3 in User mode. M3UM consists of
 * three independent bits, enabling read (r), write (w), and execute (x)
 * permissions.
 *
 * Values:
 * - 0 - An attempted access of that mode may be terminated with an access error
 *     (if not allowed by another descriptor) and the access not performed.
 * - 1 - Allows the given access type to occur
 */
//@{
#define BP_MPU_RGDn_WORD2_M3UM (18U)       //!< Bit position for MPU_RGDn_WORD2_M3UM.
#define BM_MPU_RGDn_WORD2_M3UM (0x001C0000U) //!< Bit mask for MPU_RGDn_WORD2_M3UM.
#define BS_MPU_RGDn_WORD2_M3UM (3U)        //!< Bit field size in bits for MPU_RGDn_WORD2_M3UM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD2_M3UM field.
#define BR_MPU_RGDn_WORD2_M3UM(n) (HW_MPU_RGDn_WORD2(n).B.M3UM)
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD2_M3UM.
#define BF_MPU_RGDn_WORD2_M3UM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD2_M3UM), uint32_t) & BM_MPU_RGDn_WORD2_M3UM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M3UM field to a new value.
#define BW_MPU_RGDn_WORD2_M3UM(n, v) (HW_MPU_RGDn_WORD2_WR(n, (HW_MPU_RGDn_WORD2_RD(n) & ~BM_MPU_RGDn_WORD2_M3UM) | BF_MPU_RGDn_WORD2_M3UM(v)))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD2, field M3SM[22:21] (RW)
 *
 * Defines the access controls for bus master 3 in Supervisor mode.
 *
 * Values:
 * - 00 - r/w/x; read, write and execute allowed
 * - 01 - r/x; read and execute allowed, but no write
 * - 10 - r/w; read and write allowed, but no execute
 * - 11 - Same as User mode defined in M3UM
 */
//@{
#define BP_MPU_RGDn_WORD2_M3SM (21U)       //!< Bit position for MPU_RGDn_WORD2_M3SM.
#define BM_MPU_RGDn_WORD2_M3SM (0x00600000U) //!< Bit mask for MPU_RGDn_WORD2_M3SM.
#define BS_MPU_RGDn_WORD2_M3SM (2U)        //!< Bit field size in bits for MPU_RGDn_WORD2_M3SM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD2_M3SM field.
#define BR_MPU_RGDn_WORD2_M3SM(n) (HW_MPU_RGDn_WORD2(n).B.M3SM)
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD2_M3SM.
#define BF_MPU_RGDn_WORD2_M3SM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD2_M3SM), uint32_t) & BM_MPU_RGDn_WORD2_M3SM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M3SM field to a new value.
#define BW_MPU_RGDn_WORD2_M3SM(n, v) (HW_MPU_RGDn_WORD2_WR(n, (HW_MPU_RGDn_WORD2_RD(n) & ~BM_MPU_RGDn_WORD2_M3SM) | BF_MPU_RGDn_WORD2_M3SM(v)))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD2, field M3PE[23] (RW)
 *
 * Values:
 * - 0 - Do not include the process identifier in the evaluation
 * - 1 - Include the process identifier and mask (RGDn_WORD3) in the region hit
 *     evaluation
 */
//@{
#define BP_MPU_RGDn_WORD2_M3PE (23U)       //!< Bit position for MPU_RGDn_WORD2_M3PE.
#define BM_MPU_RGDn_WORD2_M3PE (0x00800000U) //!< Bit mask for MPU_RGDn_WORD2_M3PE.
#define BS_MPU_RGDn_WORD2_M3PE (1U)        //!< Bit field size in bits for MPU_RGDn_WORD2_M3PE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD2_M3PE field.
#define BR_MPU_RGDn_WORD2_M3PE(n) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M3PE))
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD2_M3PE.
#define BF_MPU_RGDn_WORD2_M3PE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD2_M3PE), uint32_t) & BM_MPU_RGDn_WORD2_M3PE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M3PE field to a new value.
#define BW_MPU_RGDn_WORD2_M3PE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M3PE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD2, field M4WE[24] (RW)
 *
 * Values:
 * - 0 - Bus master 4 writes terminate with an access error and the write is not
 *     performed
 * - 1 - Bus master 4 writes allowed
 */
//@{
#define BP_MPU_RGDn_WORD2_M4WE (24U)       //!< Bit position for MPU_RGDn_WORD2_M4WE.
#define BM_MPU_RGDn_WORD2_M4WE (0x01000000U) //!< Bit mask for MPU_RGDn_WORD2_M4WE.
#define BS_MPU_RGDn_WORD2_M4WE (1U)        //!< Bit field size in bits for MPU_RGDn_WORD2_M4WE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD2_M4WE field.
#define BR_MPU_RGDn_WORD2_M4WE(n) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M4WE))
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD2_M4WE.
#define BF_MPU_RGDn_WORD2_M4WE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD2_M4WE), uint32_t) & BM_MPU_RGDn_WORD2_M4WE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M4WE field to a new value.
#define BW_MPU_RGDn_WORD2_M4WE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M4WE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD2, field M4RE[25] (RW)
 *
 * Values:
 * - 0 - Bus master 4 reads terminate with an access error and the read is not
 *     performed
 * - 1 - Bus master 4 reads allowed
 */
//@{
#define BP_MPU_RGDn_WORD2_M4RE (25U)       //!< Bit position for MPU_RGDn_WORD2_M4RE.
#define BM_MPU_RGDn_WORD2_M4RE (0x02000000U) //!< Bit mask for MPU_RGDn_WORD2_M4RE.
#define BS_MPU_RGDn_WORD2_M4RE (1U)        //!< Bit field size in bits for MPU_RGDn_WORD2_M4RE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD2_M4RE field.
#define BR_MPU_RGDn_WORD2_M4RE(n) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M4RE))
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD2_M4RE.
#define BF_MPU_RGDn_WORD2_M4RE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD2_M4RE), uint32_t) & BM_MPU_RGDn_WORD2_M4RE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M4RE field to a new value.
#define BW_MPU_RGDn_WORD2_M4RE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M4RE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD2, field M5WE[26] (RW)
 *
 * Values:
 * - 0 - Bus master 5 writes terminate with an access error and the write is not
 *     performed
 * - 1 - Bus master 5 writes allowed
 */
//@{
#define BP_MPU_RGDn_WORD2_M5WE (26U)       //!< Bit position for MPU_RGDn_WORD2_M5WE.
#define BM_MPU_RGDn_WORD2_M5WE (0x04000000U) //!< Bit mask for MPU_RGDn_WORD2_M5WE.
#define BS_MPU_RGDn_WORD2_M5WE (1U)        //!< Bit field size in bits for MPU_RGDn_WORD2_M5WE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD2_M5WE field.
#define BR_MPU_RGDn_WORD2_M5WE(n) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M5WE))
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD2_M5WE.
#define BF_MPU_RGDn_WORD2_M5WE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD2_M5WE), uint32_t) & BM_MPU_RGDn_WORD2_M5WE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M5WE field to a new value.
#define BW_MPU_RGDn_WORD2_M5WE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M5WE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD2, field M5RE[27] (RW)
 *
 * Values:
 * - 0 - Bus master 5 reads terminate with an access error and the read is not
 *     performed
 * - 1 - Bus master 5 reads allowed
 */
//@{
#define BP_MPU_RGDn_WORD2_M5RE (27U)       //!< Bit position for MPU_RGDn_WORD2_M5RE.
#define BM_MPU_RGDn_WORD2_M5RE (0x08000000U) //!< Bit mask for MPU_RGDn_WORD2_M5RE.
#define BS_MPU_RGDn_WORD2_M5RE (1U)        //!< Bit field size in bits for MPU_RGDn_WORD2_M5RE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD2_M5RE field.
#define BR_MPU_RGDn_WORD2_M5RE(n) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M5RE))
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD2_M5RE.
#define BF_MPU_RGDn_WORD2_M5RE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD2_M5RE), uint32_t) & BM_MPU_RGDn_WORD2_M5RE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M5RE field to a new value.
#define BW_MPU_RGDn_WORD2_M5RE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M5RE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD2, field M6WE[28] (RW)
 *
 * Values:
 * - 0 - Bus master 6 writes terminate with an access error and the write is not
 *     performed
 * - 1 - Bus master 6 writes allowed
 */
//@{
#define BP_MPU_RGDn_WORD2_M6WE (28U)       //!< Bit position for MPU_RGDn_WORD2_M6WE.
#define BM_MPU_RGDn_WORD2_M6WE (0x10000000U) //!< Bit mask for MPU_RGDn_WORD2_M6WE.
#define BS_MPU_RGDn_WORD2_M6WE (1U)        //!< Bit field size in bits for MPU_RGDn_WORD2_M6WE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD2_M6WE field.
#define BR_MPU_RGDn_WORD2_M6WE(n) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M6WE))
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD2_M6WE.
#define BF_MPU_RGDn_WORD2_M6WE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD2_M6WE), uint32_t) & BM_MPU_RGDn_WORD2_M6WE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M6WE field to a new value.
#define BW_MPU_RGDn_WORD2_M6WE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M6WE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD2, field M6RE[29] (RW)
 *
 * Values:
 * - 0 - Bus master 6 reads terminate with an access error and the read is not
 *     performed
 * - 1 - Bus master 6 reads allowed
 */
//@{
#define BP_MPU_RGDn_WORD2_M6RE (29U)       //!< Bit position for MPU_RGDn_WORD2_M6RE.
#define BM_MPU_RGDn_WORD2_M6RE (0x20000000U) //!< Bit mask for MPU_RGDn_WORD2_M6RE.
#define BS_MPU_RGDn_WORD2_M6RE (1U)        //!< Bit field size in bits for MPU_RGDn_WORD2_M6RE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD2_M6RE field.
#define BR_MPU_RGDn_WORD2_M6RE(n) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M6RE))
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD2_M6RE.
#define BF_MPU_RGDn_WORD2_M6RE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD2_M6RE), uint32_t) & BM_MPU_RGDn_WORD2_M6RE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M6RE field to a new value.
#define BW_MPU_RGDn_WORD2_M6RE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M6RE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD2, field M7WE[30] (RW)
 *
 * Values:
 * - 0 - Bus master 7 writes terminate with an access error and the write is not
 *     performed
 * - 1 - Bus master 7 writes allowed
 */
//@{
#define BP_MPU_RGDn_WORD2_M7WE (30U)       //!< Bit position for MPU_RGDn_WORD2_M7WE.
#define BM_MPU_RGDn_WORD2_M7WE (0x40000000U) //!< Bit mask for MPU_RGDn_WORD2_M7WE.
#define BS_MPU_RGDn_WORD2_M7WE (1U)        //!< Bit field size in bits for MPU_RGDn_WORD2_M7WE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD2_M7WE field.
#define BR_MPU_RGDn_WORD2_M7WE(n) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M7WE))
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD2_M7WE.
#define BF_MPU_RGDn_WORD2_M7WE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD2_M7WE), uint32_t) & BM_MPU_RGDn_WORD2_M7WE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M7WE field to a new value.
#define BW_MPU_RGDn_WORD2_M7WE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M7WE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD2, field M7RE[31] (RW)
 *
 * Values:
 * - 0 - Bus master 7 reads terminate with an access error and the read is not
 *     performed
 * - 1 - Bus master 7 reads allowed
 */
//@{
#define BP_MPU_RGDn_WORD2_M7RE (31U)       //!< Bit position for MPU_RGDn_WORD2_M7RE.
#define BM_MPU_RGDn_WORD2_M7RE (0x80000000U) //!< Bit mask for MPU_RGDn_WORD2_M7RE.
#define BS_MPU_RGDn_WORD2_M7RE (1U)        //!< Bit field size in bits for MPU_RGDn_WORD2_M7RE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD2_M7RE field.
#define BR_MPU_RGDn_WORD2_M7RE(n) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M7RE))
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD2_M7RE.
#define BF_MPU_RGDn_WORD2_M7RE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD2_M7RE), uint32_t) & BM_MPU_RGDn_WORD2_M7RE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M7RE field to a new value.
#define BW_MPU_RGDn_WORD2_M7RE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD2_ADDR(n), BP_MPU_RGDn_WORD2_M7RE) = (v))
#endif
//@}
//-------------------------------------------------------------------------------------------
// HW_MPU_RGDn_WORD3 - Region Descriptor n, Word 3
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MPU_RGDn_WORD3 - Region Descriptor n, Word 3 (RW)
 *
 * Reset value: 0x00000001U
 *
 * The fourth word of the region descriptor contains the optional process
 * identifier and mask, plus the region descriptor's valid bit.
 */
typedef union _hw_mpu_rgdn_word3
{
    uint32_t U;
    struct _hw_mpu_rgdn_word3_bitfields
    {
        uint32_t VLD : 1;              //!< [0] Valid
        uint32_t RESERVED0 : 15;       //!< [15:1]
        uint32_t PIDMASK : 8;          //!< [23:16] Process Identifier Mask
        uint32_t PID : 8;              //!< [31:24] Process Identifier
    } B;
} hw_mpu_rgdn_word3_t;
#endif

/*!
 * @name Constants and macros for entire MPU_RGDn_WORD3 register
 */
//@{
#define HW_MPU_RGDn_WORD3_COUNT (12U)

#define HW_MPU_RGDn_WORD3_ADDR(n) (REGS_MPU_BASE + 0x40CU + (0x10U * n))

#ifndef __LANGUAGE_ASM__
#define HW_MPU_RGDn_WORD3(n)     (*(__IO hw_mpu_rgdn_word3_t *) HW_MPU_RGDn_WORD3_ADDR(n))
#define HW_MPU_RGDn_WORD3_RD(n)  (HW_MPU_RGDn_WORD3(n).U)
#define HW_MPU_RGDn_WORD3_WR(n, v) (HW_MPU_RGDn_WORD3(n).U = (v))
#define HW_MPU_RGDn_WORD3_SET(n, v) (HW_MPU_RGDn_WORD3_WR(n, HW_MPU_RGDn_WORD3_RD(n) |  (v)))
#define HW_MPU_RGDn_WORD3_CLR(n, v) (HW_MPU_RGDn_WORD3_WR(n, HW_MPU_RGDn_WORD3_RD(n) & ~(v)))
#define HW_MPU_RGDn_WORD3_TOG(n, v) (HW_MPU_RGDn_WORD3_WR(n, HW_MPU_RGDn_WORD3_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual MPU_RGDn_WORD3 bitfields
 */

/*!
 * @name Register MPU_RGDn_WORD3, field VLD[0] (RW)
 *
 * Signals the region descriptor is valid. Any write to RGDn_WORD0-2 clears this
 * bit.
 *
 * Values:
 * - 0 - Region descriptor is invalid
 * - 1 - Region descriptor is valid
 */
//@{
#define BP_MPU_RGDn_WORD3_VLD (0U)         //!< Bit position for MPU_RGDn_WORD3_VLD.
#define BM_MPU_RGDn_WORD3_VLD (0x00000001U) //!< Bit mask for MPU_RGDn_WORD3_VLD.
#define BS_MPU_RGDn_WORD3_VLD (1U)         //!< Bit field size in bits for MPU_RGDn_WORD3_VLD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD3_VLD field.
#define BR_MPU_RGDn_WORD3_VLD(n) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD3_ADDR(n), BP_MPU_RGDn_WORD3_VLD))
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD3_VLD.
#define BF_MPU_RGDn_WORD3_VLD(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD3_VLD), uint32_t) & BM_MPU_RGDn_WORD3_VLD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the VLD field to a new value.
#define BW_MPU_RGDn_WORD3_VLD(n, v) (BITBAND_ACCESS32(HW_MPU_RGDn_WORD3_ADDR(n), BP_MPU_RGDn_WORD3_VLD) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD3, field PIDMASK[23:16] (RW)
 *
 * Provides a masking capability so that multiple process identifiers can be
 * included as part of the region hit determination. If a bit in PIDMASK is set,
 * then the corresponding PID bit is ignored in the comparison. This field and PID
 * are included in the region hit determination if RGDn_WORD2[MxPE] is set. For
 * more information on the handling of the PID and PIDMASK, see "Access Evaluation
 * - Hit Determination."
 */
//@{
#define BP_MPU_RGDn_WORD3_PIDMASK (16U)    //!< Bit position for MPU_RGDn_WORD3_PIDMASK.
#define BM_MPU_RGDn_WORD3_PIDMASK (0x00FF0000U) //!< Bit mask for MPU_RGDn_WORD3_PIDMASK.
#define BS_MPU_RGDn_WORD3_PIDMASK (8U)     //!< Bit field size in bits for MPU_RGDn_WORD3_PIDMASK.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD3_PIDMASK field.
#define BR_MPU_RGDn_WORD3_PIDMASK(n) (HW_MPU_RGDn_WORD3(n).B.PIDMASK)
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD3_PIDMASK.
#define BF_MPU_RGDn_WORD3_PIDMASK(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD3_PIDMASK), uint32_t) & BM_MPU_RGDn_WORD3_PIDMASK)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PIDMASK field to a new value.
#define BW_MPU_RGDn_WORD3_PIDMASK(n, v) (HW_MPU_RGDn_WORD3_WR(n, (HW_MPU_RGDn_WORD3_RD(n) & ~BM_MPU_RGDn_WORD3_PIDMASK) | BF_MPU_RGDn_WORD3_PIDMASK(v)))
#endif
//@}

/*!
 * @name Register MPU_RGDn_WORD3, field PID[31:24] (RW)
 *
 * Specifies the process identifier that is included in the region hit
 * determination if RGDn_WORD2[MxPE] is set. PIDMASK can mask individual bits in this
 * field.
 */
//@{
#define BP_MPU_RGDn_WORD3_PID (24U)        //!< Bit position for MPU_RGDn_WORD3_PID.
#define BM_MPU_RGDn_WORD3_PID (0xFF000000U) //!< Bit mask for MPU_RGDn_WORD3_PID.
#define BS_MPU_RGDn_WORD3_PID (8U)         //!< Bit field size in bits for MPU_RGDn_WORD3_PID.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDn_WORD3_PID field.
#define BR_MPU_RGDn_WORD3_PID(n) (HW_MPU_RGDn_WORD3(n).B.PID)
#endif

//! @brief Format value for bitfield MPU_RGDn_WORD3_PID.
#define BF_MPU_RGDn_WORD3_PID(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDn_WORD3_PID), uint32_t) & BM_MPU_RGDn_WORD3_PID)

#ifndef __LANGUAGE_ASM__
//! @brief Set the PID field to a new value.
#define BW_MPU_RGDn_WORD3_PID(n, v) (HW_MPU_RGDn_WORD3_WR(n, (HW_MPU_RGDn_WORD3_RD(n) & ~BM_MPU_RGDn_WORD3_PID) | BF_MPU_RGDn_WORD3_PID(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_MPU_RGDAACn - Region Descriptor Alternate Access Control n
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_MPU_RGDAACn - Region Descriptor Alternate Access Control n (RW)
 *
 * Reset value: 0x0061F7DFU
 *
 * Because software may adjust only the access controls within a region
 * descriptor (RGDn_WORD2) as different tasks execute, an alternate programming view of
 * this 32-bit entity is available. Writing to this register does not affect the
 * descriptor's valid bit.
 */
typedef union _hw_mpu_rgdaacn
{
    uint32_t U;
    struct _hw_mpu_rgdaacn_bitfields
    {
        uint32_t M0UM : 3;             //!< [2:0] Bus Master 0 User Mode Access Control
        uint32_t M0SM : 2;             //!< [4:3] Bus Master 0 Supervisor Mode Access
                                       //! Control
        uint32_t M0PE : 1;             //!< [5] Bus Master 0 Process Identifier Enable
        uint32_t M1UM : 3;             //!< [8:6] Bus Master 1 User Mode Access Control
        uint32_t M1SM : 2;             //!< [10:9] Bus Master 1 Supervisor Mode Access
                                       //! Control
        uint32_t M1PE : 1;             //!< [11] Bus Master 1 Process Identifier Enable
        uint32_t M2UM : 3;             //!< [14:12] Bus Master 2 User Mode Access Control
        uint32_t M2SM : 2;             //!< [16:15] Bus Master 2 Supervisor Mode Access
                                       //! Control
        uint32_t M2PE : 1;             //!< [17] Bus Master 2 Process Identifier Enable
        uint32_t M3UM : 3;             //!< [20:18] Bus Master 3 User Mode Access Control
        uint32_t M3SM : 2;             //!< [22:21] Bus Master 3 Supervisor Mode Access
                                       //! Control
        uint32_t M3PE : 1;             //!< [23] Bus Master 3 Process Identifier Enable
        uint32_t M4WE : 1;             //!< [24] Bus Master 4 Write Enable
        uint32_t M4RE : 1;             //!< [25] Bus Master 4 Read Enable
        uint32_t M5WE : 1;             //!< [26] Bus Master 5 Write Enable
        uint32_t M5RE : 1;             //!< [27] Bus Master 5 Read Enable
        uint32_t M6WE : 1;             //!< [28] Bus Master 6 Write Enable
        uint32_t M6RE : 1;             //!< [29] Bus Master 6 Read Enable
        uint32_t M7WE : 1;             //!< [30] Bus Master 7 Write Enable
        uint32_t M7RE : 1;             //!< [31] Bus Master 7 Read Enable
    } B;
} hw_mpu_rgdaacn_t;
#endif

/*!
 * @name Constants and macros for entire MPU_RGDAACn register
 */
//@{
#define HW_MPU_RGDAACn_COUNT (12U)

#define HW_MPU_RGDAACn_ADDR(n)   (REGS_MPU_BASE + 0x800U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_MPU_RGDAACn(n)        (*(__IO hw_mpu_rgdaacn_t *) HW_MPU_RGDAACn_ADDR(n))
#define HW_MPU_RGDAACn_RD(n)     (HW_MPU_RGDAACn(n).U)
#define HW_MPU_RGDAACn_WR(n, v)  (HW_MPU_RGDAACn(n).U = (v))
#define HW_MPU_RGDAACn_SET(n, v) (HW_MPU_RGDAACn_WR(n, HW_MPU_RGDAACn_RD(n) |  (v)))
#define HW_MPU_RGDAACn_CLR(n, v) (HW_MPU_RGDAACn_WR(n, HW_MPU_RGDAACn_RD(n) & ~(v)))
#define HW_MPU_RGDAACn_TOG(n, v) (HW_MPU_RGDAACn_WR(n, HW_MPU_RGDAACn_RD(n) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual MPU_RGDAACn bitfields
 */

/*!
 * @name Register MPU_RGDAACn, field M0UM[2:0] (RW)
 *
 * See M3UM description.
 */
//@{
#define BP_MPU_RGDAACn_M0UM  (0U)          //!< Bit position for MPU_RGDAACn_M0UM.
#define BM_MPU_RGDAACn_M0UM  (0x00000007U) //!< Bit mask for MPU_RGDAACn_M0UM.
#define BS_MPU_RGDAACn_M0UM  (3U)          //!< Bit field size in bits for MPU_RGDAACn_M0UM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDAACn_M0UM field.
#define BR_MPU_RGDAACn_M0UM(n) (HW_MPU_RGDAACn(n).B.M0UM)
#endif

//! @brief Format value for bitfield MPU_RGDAACn_M0UM.
#define BF_MPU_RGDAACn_M0UM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDAACn_M0UM), uint32_t) & BM_MPU_RGDAACn_M0UM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M0UM field to a new value.
#define BW_MPU_RGDAACn_M0UM(n, v) (HW_MPU_RGDAACn_WR(n, (HW_MPU_RGDAACn_RD(n) & ~BM_MPU_RGDAACn_M0UM) | BF_MPU_RGDAACn_M0UM(v)))
#endif
//@}

/*!
 * @name Register MPU_RGDAACn, field M0SM[4:3] (RW)
 *
 * See M3SM description.
 */
//@{
#define BP_MPU_RGDAACn_M0SM  (3U)          //!< Bit position for MPU_RGDAACn_M0SM.
#define BM_MPU_RGDAACn_M0SM  (0x00000018U) //!< Bit mask for MPU_RGDAACn_M0SM.
#define BS_MPU_RGDAACn_M0SM  (2U)          //!< Bit field size in bits for MPU_RGDAACn_M0SM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDAACn_M0SM field.
#define BR_MPU_RGDAACn_M0SM(n) (HW_MPU_RGDAACn(n).B.M0SM)
#endif

//! @brief Format value for bitfield MPU_RGDAACn_M0SM.
#define BF_MPU_RGDAACn_M0SM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDAACn_M0SM), uint32_t) & BM_MPU_RGDAACn_M0SM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M0SM field to a new value.
#define BW_MPU_RGDAACn_M0SM(n, v) (HW_MPU_RGDAACn_WR(n, (HW_MPU_RGDAACn_RD(n) & ~BM_MPU_RGDAACn_M0SM) | BF_MPU_RGDAACn_M0SM(v)))
#endif
//@}

/*!
 * @name Register MPU_RGDAACn, field M0PE[5] (RW)
 *
 * See M3PE description.
 */
//@{
#define BP_MPU_RGDAACn_M0PE  (5U)          //!< Bit position for MPU_RGDAACn_M0PE.
#define BM_MPU_RGDAACn_M0PE  (0x00000020U) //!< Bit mask for MPU_RGDAACn_M0PE.
#define BS_MPU_RGDAACn_M0PE  (1U)          //!< Bit field size in bits for MPU_RGDAACn_M0PE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDAACn_M0PE field.
#define BR_MPU_RGDAACn_M0PE(n) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M0PE))
#endif

//! @brief Format value for bitfield MPU_RGDAACn_M0PE.
#define BF_MPU_RGDAACn_M0PE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDAACn_M0PE), uint32_t) & BM_MPU_RGDAACn_M0PE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M0PE field to a new value.
#define BW_MPU_RGDAACn_M0PE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M0PE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDAACn, field M1UM[8:6] (RW)
 *
 * See M3UM description.
 */
//@{
#define BP_MPU_RGDAACn_M1UM  (6U)          //!< Bit position for MPU_RGDAACn_M1UM.
#define BM_MPU_RGDAACn_M1UM  (0x000001C0U) //!< Bit mask for MPU_RGDAACn_M1UM.
#define BS_MPU_RGDAACn_M1UM  (3U)          //!< Bit field size in bits for MPU_RGDAACn_M1UM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDAACn_M1UM field.
#define BR_MPU_RGDAACn_M1UM(n) (HW_MPU_RGDAACn(n).B.M1UM)
#endif

//! @brief Format value for bitfield MPU_RGDAACn_M1UM.
#define BF_MPU_RGDAACn_M1UM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDAACn_M1UM), uint32_t) & BM_MPU_RGDAACn_M1UM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M1UM field to a new value.
#define BW_MPU_RGDAACn_M1UM(n, v) (HW_MPU_RGDAACn_WR(n, (HW_MPU_RGDAACn_RD(n) & ~BM_MPU_RGDAACn_M1UM) | BF_MPU_RGDAACn_M1UM(v)))
#endif
//@}

/*!
 * @name Register MPU_RGDAACn, field M1SM[10:9] (RW)
 *
 * See M3SM description.
 */
//@{
#define BP_MPU_RGDAACn_M1SM  (9U)          //!< Bit position for MPU_RGDAACn_M1SM.
#define BM_MPU_RGDAACn_M1SM  (0x00000600U) //!< Bit mask for MPU_RGDAACn_M1SM.
#define BS_MPU_RGDAACn_M1SM  (2U)          //!< Bit field size in bits for MPU_RGDAACn_M1SM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDAACn_M1SM field.
#define BR_MPU_RGDAACn_M1SM(n) (HW_MPU_RGDAACn(n).B.M1SM)
#endif

//! @brief Format value for bitfield MPU_RGDAACn_M1SM.
#define BF_MPU_RGDAACn_M1SM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDAACn_M1SM), uint32_t) & BM_MPU_RGDAACn_M1SM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M1SM field to a new value.
#define BW_MPU_RGDAACn_M1SM(n, v) (HW_MPU_RGDAACn_WR(n, (HW_MPU_RGDAACn_RD(n) & ~BM_MPU_RGDAACn_M1SM) | BF_MPU_RGDAACn_M1SM(v)))
#endif
//@}

/*!
 * @name Register MPU_RGDAACn, field M1PE[11] (RW)
 *
 * See M3PE description.
 */
//@{
#define BP_MPU_RGDAACn_M1PE  (11U)         //!< Bit position for MPU_RGDAACn_M1PE.
#define BM_MPU_RGDAACn_M1PE  (0x00000800U) //!< Bit mask for MPU_RGDAACn_M1PE.
#define BS_MPU_RGDAACn_M1PE  (1U)          //!< Bit field size in bits for MPU_RGDAACn_M1PE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDAACn_M1PE field.
#define BR_MPU_RGDAACn_M1PE(n) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M1PE))
#endif

//! @brief Format value for bitfield MPU_RGDAACn_M1PE.
#define BF_MPU_RGDAACn_M1PE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDAACn_M1PE), uint32_t) & BM_MPU_RGDAACn_M1PE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M1PE field to a new value.
#define BW_MPU_RGDAACn_M1PE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M1PE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDAACn, field M2UM[14:12] (RW)
 *
 * See M3UM description.
 */
//@{
#define BP_MPU_RGDAACn_M2UM  (12U)         //!< Bit position for MPU_RGDAACn_M2UM.
#define BM_MPU_RGDAACn_M2UM  (0x00007000U) //!< Bit mask for MPU_RGDAACn_M2UM.
#define BS_MPU_RGDAACn_M2UM  (3U)          //!< Bit field size in bits for MPU_RGDAACn_M2UM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDAACn_M2UM field.
#define BR_MPU_RGDAACn_M2UM(n) (HW_MPU_RGDAACn(n).B.M2UM)
#endif

//! @brief Format value for bitfield MPU_RGDAACn_M2UM.
#define BF_MPU_RGDAACn_M2UM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDAACn_M2UM), uint32_t) & BM_MPU_RGDAACn_M2UM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M2UM field to a new value.
#define BW_MPU_RGDAACn_M2UM(n, v) (HW_MPU_RGDAACn_WR(n, (HW_MPU_RGDAACn_RD(n) & ~BM_MPU_RGDAACn_M2UM) | BF_MPU_RGDAACn_M2UM(v)))
#endif
//@}

/*!
 * @name Register MPU_RGDAACn, field M2SM[16:15] (RW)
 *
 * See M3SM description.
 */
//@{
#define BP_MPU_RGDAACn_M2SM  (15U)         //!< Bit position for MPU_RGDAACn_M2SM.
#define BM_MPU_RGDAACn_M2SM  (0x00018000U) //!< Bit mask for MPU_RGDAACn_M2SM.
#define BS_MPU_RGDAACn_M2SM  (2U)          //!< Bit field size in bits for MPU_RGDAACn_M2SM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDAACn_M2SM field.
#define BR_MPU_RGDAACn_M2SM(n) (HW_MPU_RGDAACn(n).B.M2SM)
#endif

//! @brief Format value for bitfield MPU_RGDAACn_M2SM.
#define BF_MPU_RGDAACn_M2SM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDAACn_M2SM), uint32_t) & BM_MPU_RGDAACn_M2SM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M2SM field to a new value.
#define BW_MPU_RGDAACn_M2SM(n, v) (HW_MPU_RGDAACn_WR(n, (HW_MPU_RGDAACn_RD(n) & ~BM_MPU_RGDAACn_M2SM) | BF_MPU_RGDAACn_M2SM(v)))
#endif
//@}

/*!
 * @name Register MPU_RGDAACn, field M2PE[17] (RW)
 *
 * See M3PE description.
 */
//@{
#define BP_MPU_RGDAACn_M2PE  (17U)         //!< Bit position for MPU_RGDAACn_M2PE.
#define BM_MPU_RGDAACn_M2PE  (0x00020000U) //!< Bit mask for MPU_RGDAACn_M2PE.
#define BS_MPU_RGDAACn_M2PE  (1U)          //!< Bit field size in bits for MPU_RGDAACn_M2PE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDAACn_M2PE field.
#define BR_MPU_RGDAACn_M2PE(n) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M2PE))
#endif

//! @brief Format value for bitfield MPU_RGDAACn_M2PE.
#define BF_MPU_RGDAACn_M2PE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDAACn_M2PE), uint32_t) & BM_MPU_RGDAACn_M2PE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M2PE field to a new value.
#define BW_MPU_RGDAACn_M2PE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M2PE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDAACn, field M3UM[20:18] (RW)
 *
 * Defines the access controls for bus master 3 in user mode. M3UM consists of
 * three independent bits, enabling read (r), write (w), and execute (x)
 * permissions.
 *
 * Values:
 * - 0 - An attempted access of that mode may be terminated with an access error
 *     (if not allowed by another descriptor) and the access not performed.
 * - 1 - Allows the given access type to occur
 */
//@{
#define BP_MPU_RGDAACn_M3UM  (18U)         //!< Bit position for MPU_RGDAACn_M3UM.
#define BM_MPU_RGDAACn_M3UM  (0x001C0000U) //!< Bit mask for MPU_RGDAACn_M3UM.
#define BS_MPU_RGDAACn_M3UM  (3U)          //!< Bit field size in bits for MPU_RGDAACn_M3UM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDAACn_M3UM field.
#define BR_MPU_RGDAACn_M3UM(n) (HW_MPU_RGDAACn(n).B.M3UM)
#endif

//! @brief Format value for bitfield MPU_RGDAACn_M3UM.
#define BF_MPU_RGDAACn_M3UM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDAACn_M3UM), uint32_t) & BM_MPU_RGDAACn_M3UM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M3UM field to a new value.
#define BW_MPU_RGDAACn_M3UM(n, v) (HW_MPU_RGDAACn_WR(n, (HW_MPU_RGDAACn_RD(n) & ~BM_MPU_RGDAACn_M3UM) | BF_MPU_RGDAACn_M3UM(v)))
#endif
//@}

/*!
 * @name Register MPU_RGDAACn, field M3SM[22:21] (RW)
 *
 * Defines the access controls for bus master 3 in Supervisor mode.
 *
 * Values:
 * - 00 - r/w/x; read, write and execute allowed
 * - 01 - r/x; read and execute allowed, but no write
 * - 10 - r/w; read and write allowed, but no execute
 * - 11 - Same as User mode defined in M3UM
 */
//@{
#define BP_MPU_RGDAACn_M3SM  (21U)         //!< Bit position for MPU_RGDAACn_M3SM.
#define BM_MPU_RGDAACn_M3SM  (0x00600000U) //!< Bit mask for MPU_RGDAACn_M3SM.
#define BS_MPU_RGDAACn_M3SM  (2U)          //!< Bit field size in bits for MPU_RGDAACn_M3SM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDAACn_M3SM field.
#define BR_MPU_RGDAACn_M3SM(n) (HW_MPU_RGDAACn(n).B.M3SM)
#endif

//! @brief Format value for bitfield MPU_RGDAACn_M3SM.
#define BF_MPU_RGDAACn_M3SM(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDAACn_M3SM), uint32_t) & BM_MPU_RGDAACn_M3SM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M3SM field to a new value.
#define BW_MPU_RGDAACn_M3SM(n, v) (HW_MPU_RGDAACn_WR(n, (HW_MPU_RGDAACn_RD(n) & ~BM_MPU_RGDAACn_M3SM) | BF_MPU_RGDAACn_M3SM(v)))
#endif
//@}

/*!
 * @name Register MPU_RGDAACn, field M3PE[23] (RW)
 *
 * Values:
 * - 0 - Do not include the process identifier in the evaluation
 * - 1 - Include the process identifier and mask (RGDn.RGDAAC) in the region hit
 *     evaluation
 */
//@{
#define BP_MPU_RGDAACn_M3PE  (23U)         //!< Bit position for MPU_RGDAACn_M3PE.
#define BM_MPU_RGDAACn_M3PE  (0x00800000U) //!< Bit mask for MPU_RGDAACn_M3PE.
#define BS_MPU_RGDAACn_M3PE  (1U)          //!< Bit field size in bits for MPU_RGDAACn_M3PE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDAACn_M3PE field.
#define BR_MPU_RGDAACn_M3PE(n) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M3PE))
#endif

//! @brief Format value for bitfield MPU_RGDAACn_M3PE.
#define BF_MPU_RGDAACn_M3PE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDAACn_M3PE), uint32_t) & BM_MPU_RGDAACn_M3PE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M3PE field to a new value.
#define BW_MPU_RGDAACn_M3PE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M3PE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDAACn, field M4WE[24] (RW)
 *
 * Values:
 * - 0 - Bus master 4 writes terminate with an access error and the write is not
 *     performed
 * - 1 - Bus master 4 writes allowed
 */
//@{
#define BP_MPU_RGDAACn_M4WE  (24U)         //!< Bit position for MPU_RGDAACn_M4WE.
#define BM_MPU_RGDAACn_M4WE  (0x01000000U) //!< Bit mask for MPU_RGDAACn_M4WE.
#define BS_MPU_RGDAACn_M4WE  (1U)          //!< Bit field size in bits for MPU_RGDAACn_M4WE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDAACn_M4WE field.
#define BR_MPU_RGDAACn_M4WE(n) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M4WE))
#endif

//! @brief Format value for bitfield MPU_RGDAACn_M4WE.
#define BF_MPU_RGDAACn_M4WE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDAACn_M4WE), uint32_t) & BM_MPU_RGDAACn_M4WE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M4WE field to a new value.
#define BW_MPU_RGDAACn_M4WE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M4WE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDAACn, field M4RE[25] (RW)
 *
 * Values:
 * - 0 - Bus master 4 reads terminate with an access error and the read is not
 *     performed
 * - 1 - Bus master 4 reads allowed
 */
//@{
#define BP_MPU_RGDAACn_M4RE  (25U)         //!< Bit position for MPU_RGDAACn_M4RE.
#define BM_MPU_RGDAACn_M4RE  (0x02000000U) //!< Bit mask for MPU_RGDAACn_M4RE.
#define BS_MPU_RGDAACn_M4RE  (1U)          //!< Bit field size in bits for MPU_RGDAACn_M4RE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDAACn_M4RE field.
#define BR_MPU_RGDAACn_M4RE(n) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M4RE))
#endif

//! @brief Format value for bitfield MPU_RGDAACn_M4RE.
#define BF_MPU_RGDAACn_M4RE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDAACn_M4RE), uint32_t) & BM_MPU_RGDAACn_M4RE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M4RE field to a new value.
#define BW_MPU_RGDAACn_M4RE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M4RE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDAACn, field M5WE[26] (RW)
 *
 * Values:
 * - 0 - Bus master 5 writes terminate with an access error and the write is not
 *     performed
 * - 1 - Bus master 5 writes allowed
 */
//@{
#define BP_MPU_RGDAACn_M5WE  (26U)         //!< Bit position for MPU_RGDAACn_M5WE.
#define BM_MPU_RGDAACn_M5WE  (0x04000000U) //!< Bit mask for MPU_RGDAACn_M5WE.
#define BS_MPU_RGDAACn_M5WE  (1U)          //!< Bit field size in bits for MPU_RGDAACn_M5WE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDAACn_M5WE field.
#define BR_MPU_RGDAACn_M5WE(n) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M5WE))
#endif

//! @brief Format value for bitfield MPU_RGDAACn_M5WE.
#define BF_MPU_RGDAACn_M5WE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDAACn_M5WE), uint32_t) & BM_MPU_RGDAACn_M5WE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M5WE field to a new value.
#define BW_MPU_RGDAACn_M5WE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M5WE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDAACn, field M5RE[27] (RW)
 *
 * Values:
 * - 0 - Bus master 5 reads terminate with an access error and the read is not
 *     performed
 * - 1 - Bus master 5 reads allowed
 */
//@{
#define BP_MPU_RGDAACn_M5RE  (27U)         //!< Bit position for MPU_RGDAACn_M5RE.
#define BM_MPU_RGDAACn_M5RE  (0x08000000U) //!< Bit mask for MPU_RGDAACn_M5RE.
#define BS_MPU_RGDAACn_M5RE  (1U)          //!< Bit field size in bits for MPU_RGDAACn_M5RE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDAACn_M5RE field.
#define BR_MPU_RGDAACn_M5RE(n) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M5RE))
#endif

//! @brief Format value for bitfield MPU_RGDAACn_M5RE.
#define BF_MPU_RGDAACn_M5RE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDAACn_M5RE), uint32_t) & BM_MPU_RGDAACn_M5RE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M5RE field to a new value.
#define BW_MPU_RGDAACn_M5RE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M5RE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDAACn, field M6WE[28] (RW)
 *
 * Values:
 * - 0 - Bus master 6 writes terminate with an access error and the write is not
 *     performed
 * - 1 - Bus master 6 writes allowed
 */
//@{
#define BP_MPU_RGDAACn_M6WE  (28U)         //!< Bit position for MPU_RGDAACn_M6WE.
#define BM_MPU_RGDAACn_M6WE  (0x10000000U) //!< Bit mask for MPU_RGDAACn_M6WE.
#define BS_MPU_RGDAACn_M6WE  (1U)          //!< Bit field size in bits for MPU_RGDAACn_M6WE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDAACn_M6WE field.
#define BR_MPU_RGDAACn_M6WE(n) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M6WE))
#endif

//! @brief Format value for bitfield MPU_RGDAACn_M6WE.
#define BF_MPU_RGDAACn_M6WE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDAACn_M6WE), uint32_t) & BM_MPU_RGDAACn_M6WE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M6WE field to a new value.
#define BW_MPU_RGDAACn_M6WE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M6WE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDAACn, field M6RE[29] (RW)
 *
 * Values:
 * - 0 - Bus master 6 reads terminate with an access error and the read is not
 *     performed
 * - 1 - Bus master 6 reads allowed
 */
//@{
#define BP_MPU_RGDAACn_M6RE  (29U)         //!< Bit position for MPU_RGDAACn_M6RE.
#define BM_MPU_RGDAACn_M6RE  (0x20000000U) //!< Bit mask for MPU_RGDAACn_M6RE.
#define BS_MPU_RGDAACn_M6RE  (1U)          //!< Bit field size in bits for MPU_RGDAACn_M6RE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDAACn_M6RE field.
#define BR_MPU_RGDAACn_M6RE(n) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M6RE))
#endif

//! @brief Format value for bitfield MPU_RGDAACn_M6RE.
#define BF_MPU_RGDAACn_M6RE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDAACn_M6RE), uint32_t) & BM_MPU_RGDAACn_M6RE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M6RE field to a new value.
#define BW_MPU_RGDAACn_M6RE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M6RE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDAACn, field M7WE[30] (RW)
 *
 * Values:
 * - 0 - Bus master 7 writes terminate with an access error and the write is not
 *     performed
 * - 1 - Bus master 7 writes allowed
 */
//@{
#define BP_MPU_RGDAACn_M7WE  (30U)         //!< Bit position for MPU_RGDAACn_M7WE.
#define BM_MPU_RGDAACn_M7WE  (0x40000000U) //!< Bit mask for MPU_RGDAACn_M7WE.
#define BS_MPU_RGDAACn_M7WE  (1U)          //!< Bit field size in bits for MPU_RGDAACn_M7WE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDAACn_M7WE field.
#define BR_MPU_RGDAACn_M7WE(n) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M7WE))
#endif

//! @brief Format value for bitfield MPU_RGDAACn_M7WE.
#define BF_MPU_RGDAACn_M7WE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDAACn_M7WE), uint32_t) & BM_MPU_RGDAACn_M7WE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M7WE field to a new value.
#define BW_MPU_RGDAACn_M7WE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M7WE) = (v))
#endif
//@}

/*!
 * @name Register MPU_RGDAACn, field M7RE[31] (RW)
 *
 * Values:
 * - 0 - Bus master 7 reads terminate with an access error and the read is not
 *     performed
 * - 1 - Bus master 7 reads allowed
 */
//@{
#define BP_MPU_RGDAACn_M7RE  (31U)         //!< Bit position for MPU_RGDAACn_M7RE.
#define BM_MPU_RGDAACn_M7RE  (0x80000000U) //!< Bit mask for MPU_RGDAACn_M7RE.
#define BS_MPU_RGDAACn_M7RE  (1U)          //!< Bit field size in bits for MPU_RGDAACn_M7RE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the MPU_RGDAACn_M7RE field.
#define BR_MPU_RGDAACn_M7RE(n) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M7RE))
#endif

//! @brief Format value for bitfield MPU_RGDAACn_M7RE.
#define BF_MPU_RGDAACn_M7RE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_MPU_RGDAACn_M7RE), uint32_t) & BM_MPU_RGDAACn_M7RE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the M7RE field to a new value.
#define BW_MPU_RGDAACn_M7RE(n, v) (BITBAND_ACCESS32(HW_MPU_RGDAACn_ADDR(n), BP_MPU_RGDAACn_M7RE) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_mpu_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All MPU module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_mpu
{
    __IO hw_mpu_cesr_t CESR;               //!< [0x0] Control/Error Status Register
    uint8_t _reserved0[12];
    struct {
        __I hw_mpu_earn_t EARn;            //!< [0x10] Error Address Register, slave port n
        __I hw_mpu_edrn_t EDRn;            //!< [0x14] Error Detail Register, slave port n
    } SP[5];
    uint8_t _reserved1[968];
    struct {
        __IO hw_mpu_rgdn_word0_t RGDn_WORD0; //!< [0x400] Region Descriptor n, Word 0
        __IO hw_mpu_rgdn_word1_t RGDn_WORD1; //!< [0x404] Region Descriptor n, Word 1
        __IO hw_mpu_rgdn_word2_t RGDn_WORD2; //!< [0x408] Region Descriptor n, Word 2
        __IO hw_mpu_rgdn_word3_t RGDn_WORD3; //!< [0x40C] Region Descriptor n, Word 3
    } RGD[12];
    uint8_t _reserved2[832];
    __IO hw_mpu_rgdaacn_t RGDAACn[12];     //!< [0x800] Region Descriptor Alternate Access Control n
} hw_mpu_t;
#pragma pack()

//! @brief Macro to access all MPU registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_MPU</code>.
#define HW_MPU         (*(hw_mpu_t *) REGS_MPU_BASE)
#endif

#endif // __HW_MPU_REGISTERS_H__
// v22/130726/0.9
// EOF

