/*
 * Copyright (c) 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_I2S_REGISTERS_H__
#define __HW_I2S_REGISTERS_H__

#include "regs.h"

/*
 * MK64F12 I2S
 *
 * Inter-IC Sound / Synchronous Audio Interface
 *
 * Registers defined in this header file:
 * - HW_I2S_TCSR - SAI Transmit Control Register
 * - HW_I2S_TCR1 - SAI Transmit Configuration 1 Register
 * - HW_I2S_TCR2 - SAI Transmit Configuration 2 Register
 * - HW_I2S_TCR3 - SAI Transmit Configuration 3 Register
 * - HW_I2S_TCR4 - SAI Transmit Configuration 4 Register
 * - HW_I2S_TCR5 - SAI Transmit Configuration 5 Register
 * - HW_I2S_TDRn - SAI Transmit Data Register
 * - HW_I2S_TFRn - SAI Transmit FIFO Register
 * - HW_I2S_TMR - SAI Transmit Mask Register
 * - HW_I2S_RCSR - SAI Receive Control Register
 * - HW_I2S_RCR1 - SAI Receive Configuration 1 Register
 * - HW_I2S_RCR2 - SAI Receive Configuration 2 Register
 * - HW_I2S_RCR3 - SAI Receive Configuration 3 Register
 * - HW_I2S_RCR4 - SAI Receive Configuration 4 Register
 * - HW_I2S_RCR5 - SAI Receive Configuration 5 Register
 * - HW_I2S_RDRn - SAI Receive Data Register
 * - HW_I2S_RFRn - SAI Receive FIFO Register
 * - HW_I2S_RMR - SAI Receive Mask Register
 * - HW_I2S_MCR - SAI MCLK Control Register
 * - HW_I2S_MDR - SAI MCLK Divide Register
 *
 * - hw_i2s_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_I2S_BASE
#define HW_I2S_INSTANCE_COUNT (1U) //!< Number of instances of the I2S module.
#define HW_I2S0 (0U) //!< Instance number for I2S0.
#define REGS_I2S0_BASE (0x4002F000U) //!< Base address for I2S0.

//! @brief Table of base addresses for I2S instances.
static const uint32_t __g_regs_I2S_base_addresses[] = {
        REGS_I2S0_BASE,
    };

//! @brief Get the base address of I2S by instance number.
//! @param x I2S instance number, from 0 through 0.
#define REGS_I2S_BASE(x) (__g_regs_I2S_base_addresses[(x)])

//! @brief Get the instance number given a base address.
//! @param b Base address for an instance of I2S.
#define REGS_I2S_INSTANCE(b) ((b) == REGS_I2S0_BASE ? HW_I2S0 : 0)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2S_TCSR - SAI Transmit Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2S_TCSR - SAI Transmit Control Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_i2s_tcsr
{
    uint32_t U;
    struct _hw_i2s_tcsr_bitfields
    {
        uint32_t FRDE : 1;             //!< [0] FIFO Request DMA Enable
        uint32_t FWDE : 1;             //!< [1] FIFO Warning DMA Enable
        uint32_t RESERVED0 : 6;        //!< [7:2]
        uint32_t FRIE : 1;             //!< [8] FIFO Request Interrupt Enable
        uint32_t FWIE : 1;             //!< [9] FIFO Warning Interrupt Enable
        uint32_t FEIE : 1;             //!< [10] FIFO Error Interrupt Enable
        uint32_t SEIE : 1;             //!< [11] Sync Error Interrupt Enable
        uint32_t WSIE : 1;             //!< [12] Word Start Interrupt Enable
        uint32_t RESERVED1 : 3;        //!< [15:13]
        uint32_t FRF : 1;              //!< [16] FIFO Request Flag
        uint32_t FWF : 1;              //!< [17] FIFO Warning Flag
        uint32_t FEF : 1;              //!< [18] FIFO Error Flag
        uint32_t SEF : 1;              //!< [19] Sync Error Flag
        uint32_t WSF : 1;              //!< [20] Word Start Flag
        uint32_t RESERVED2 : 3;        //!< [23:21]
        uint32_t SR : 1;               //!< [24] Software Reset
        uint32_t FR : 1;               //!< [25] FIFO Reset
        uint32_t RESERVED3 : 2;        //!< [27:26]
        uint32_t BCE : 1;              //!< [28] Bit Clock Enable
        uint32_t DBGE : 1;             //!< [29] Debug Enable
        uint32_t STOPE : 1;            //!< [30] Stop Enable
        uint32_t TE : 1;               //!< [31] Transmitter Enable
    } B;
} hw_i2s_tcsr_t;
#endif

/*!
 * @name Constants and macros for entire I2S_TCSR register
 */
//@{
#define HW_I2S_TCSR_ADDR(x)      (REGS_I2S_BASE(x) + 0x0U)

#ifndef __LANGUAGE_ASM__
#define HW_I2S_TCSR(x)           (*(__IO hw_i2s_tcsr_t *) HW_I2S_TCSR_ADDR(x))
#define HW_I2S_TCSR_RD(x)        (HW_I2S_TCSR(x).U)
#define HW_I2S_TCSR_WR(x, v)     (HW_I2S_TCSR(x).U = (v))
#define HW_I2S_TCSR_SET(x, v)    (HW_I2S_TCSR_WR(x, HW_I2S_TCSR_RD(x) |  (v)))
#define HW_I2S_TCSR_CLR(x, v)    (HW_I2S_TCSR_WR(x, HW_I2S_TCSR_RD(x) & ~(v)))
#define HW_I2S_TCSR_TOG(x, v)    (HW_I2S_TCSR_WR(x, HW_I2S_TCSR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2S_TCSR bitfields
 */

/*!
 * @name Register I2S_TCSR, field FRDE[0] (RW)
 *
 * Enables/disables DMA requests.
 *
 * Values:
 * - 0 - Disables the DMA request.
 * - 1 - Enables the DMA request.
 */
//@{
#define BP_I2S_TCSR_FRDE     (0U)          //!< Bit position for I2S_TCSR_FRDE.
#define BM_I2S_TCSR_FRDE     (0x00000001U) //!< Bit mask for I2S_TCSR_FRDE.
#define BS_I2S_TCSR_FRDE     (1U)          //!< Bit field size in bits for I2S_TCSR_FRDE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCSR_FRDE field.
#define BR_I2S_TCSR_FRDE(x)  (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_FRDE))
#endif

//! @brief Format value for bitfield I2S_TCSR_FRDE.
#define BF_I2S_TCSR_FRDE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCSR_FRDE), uint32_t) & BM_I2S_TCSR_FRDE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FRDE field to a new value.
#define BW_I2S_TCSR_FRDE(x, v) (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_FRDE) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCSR, field FWDE[1] (RW)
 *
 * Enables/disables DMA requests.
 *
 * Values:
 * - 0 - Disables the DMA request.
 * - 1 - Enables the DMA request.
 */
//@{
#define BP_I2S_TCSR_FWDE     (1U)          //!< Bit position for I2S_TCSR_FWDE.
#define BM_I2S_TCSR_FWDE     (0x00000002U) //!< Bit mask for I2S_TCSR_FWDE.
#define BS_I2S_TCSR_FWDE     (1U)          //!< Bit field size in bits for I2S_TCSR_FWDE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCSR_FWDE field.
#define BR_I2S_TCSR_FWDE(x)  (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_FWDE))
#endif

//! @brief Format value for bitfield I2S_TCSR_FWDE.
#define BF_I2S_TCSR_FWDE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCSR_FWDE), uint32_t) & BM_I2S_TCSR_FWDE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FWDE field to a new value.
#define BW_I2S_TCSR_FWDE(x, v) (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_FWDE) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCSR, field FRIE[8] (RW)
 *
 * Enables/disables FIFO request interrupts.
 *
 * Values:
 * - 0 - Disables the interrupt.
 * - 1 - Enables the interrupt.
 */
//@{
#define BP_I2S_TCSR_FRIE     (8U)          //!< Bit position for I2S_TCSR_FRIE.
#define BM_I2S_TCSR_FRIE     (0x00000100U) //!< Bit mask for I2S_TCSR_FRIE.
#define BS_I2S_TCSR_FRIE     (1U)          //!< Bit field size in bits for I2S_TCSR_FRIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCSR_FRIE field.
#define BR_I2S_TCSR_FRIE(x)  (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_FRIE))
#endif

//! @brief Format value for bitfield I2S_TCSR_FRIE.
#define BF_I2S_TCSR_FRIE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCSR_FRIE), uint32_t) & BM_I2S_TCSR_FRIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FRIE field to a new value.
#define BW_I2S_TCSR_FRIE(x, v) (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_FRIE) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCSR, field FWIE[9] (RW)
 *
 * Enables/disables FIFO warning interrupts.
 *
 * Values:
 * - 0 - Disables the interrupt.
 * - 1 - Enables the interrupt.
 */
//@{
#define BP_I2S_TCSR_FWIE     (9U)          //!< Bit position for I2S_TCSR_FWIE.
#define BM_I2S_TCSR_FWIE     (0x00000200U) //!< Bit mask for I2S_TCSR_FWIE.
#define BS_I2S_TCSR_FWIE     (1U)          //!< Bit field size in bits for I2S_TCSR_FWIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCSR_FWIE field.
#define BR_I2S_TCSR_FWIE(x)  (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_FWIE))
#endif

//! @brief Format value for bitfield I2S_TCSR_FWIE.
#define BF_I2S_TCSR_FWIE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCSR_FWIE), uint32_t) & BM_I2S_TCSR_FWIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FWIE field to a new value.
#define BW_I2S_TCSR_FWIE(x, v) (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_FWIE) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCSR, field FEIE[10] (RW)
 *
 * Enables/disables FIFO error interrupts.
 *
 * Values:
 * - 0 - Disables the interrupt.
 * - 1 - Enables the interrupt.
 */
//@{
#define BP_I2S_TCSR_FEIE     (10U)         //!< Bit position for I2S_TCSR_FEIE.
#define BM_I2S_TCSR_FEIE     (0x00000400U) //!< Bit mask for I2S_TCSR_FEIE.
#define BS_I2S_TCSR_FEIE     (1U)          //!< Bit field size in bits for I2S_TCSR_FEIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCSR_FEIE field.
#define BR_I2S_TCSR_FEIE(x)  (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_FEIE))
#endif

//! @brief Format value for bitfield I2S_TCSR_FEIE.
#define BF_I2S_TCSR_FEIE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCSR_FEIE), uint32_t) & BM_I2S_TCSR_FEIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FEIE field to a new value.
#define BW_I2S_TCSR_FEIE(x, v) (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_FEIE) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCSR, field SEIE[11] (RW)
 *
 * Enables/disables sync error interrupts.
 *
 * Values:
 * - 0 - Disables interrupt.
 * - 1 - Enables interrupt.
 */
//@{
#define BP_I2S_TCSR_SEIE     (11U)         //!< Bit position for I2S_TCSR_SEIE.
#define BM_I2S_TCSR_SEIE     (0x00000800U) //!< Bit mask for I2S_TCSR_SEIE.
#define BS_I2S_TCSR_SEIE     (1U)          //!< Bit field size in bits for I2S_TCSR_SEIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCSR_SEIE field.
#define BR_I2S_TCSR_SEIE(x)  (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_SEIE))
#endif

//! @brief Format value for bitfield I2S_TCSR_SEIE.
#define BF_I2S_TCSR_SEIE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCSR_SEIE), uint32_t) & BM_I2S_TCSR_SEIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SEIE field to a new value.
#define BW_I2S_TCSR_SEIE(x, v) (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_SEIE) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCSR, field WSIE[12] (RW)
 *
 * Enables/disables word start interrupts.
 *
 * Values:
 * - 0 - Disables interrupt.
 * - 1 - Enables interrupt.
 */
//@{
#define BP_I2S_TCSR_WSIE     (12U)         //!< Bit position for I2S_TCSR_WSIE.
#define BM_I2S_TCSR_WSIE     (0x00001000U) //!< Bit mask for I2S_TCSR_WSIE.
#define BS_I2S_TCSR_WSIE     (1U)          //!< Bit field size in bits for I2S_TCSR_WSIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCSR_WSIE field.
#define BR_I2S_TCSR_WSIE(x)  (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_WSIE))
#endif

//! @brief Format value for bitfield I2S_TCSR_WSIE.
#define BF_I2S_TCSR_WSIE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCSR_WSIE), uint32_t) & BM_I2S_TCSR_WSIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WSIE field to a new value.
#define BW_I2S_TCSR_WSIE(x, v) (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_WSIE) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCSR, field FRF[16] (RO)
 *
 * Indicates that the number of words in an enabled transmit channel FIFO is
 * less than or equal to the transmit FIFO watermark.
 *
 * Values:
 * - 0 - Transmit FIFO watermark has not been reached.
 * - 1 - Transmit FIFO watermark has been reached.
 */
//@{
#define BP_I2S_TCSR_FRF      (16U)         //!< Bit position for I2S_TCSR_FRF.
#define BM_I2S_TCSR_FRF      (0x00010000U) //!< Bit mask for I2S_TCSR_FRF.
#define BS_I2S_TCSR_FRF      (1U)          //!< Bit field size in bits for I2S_TCSR_FRF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCSR_FRF field.
#define BR_I2S_TCSR_FRF(x)   (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_FRF))
#endif
//@}

/*!
 * @name Register I2S_TCSR, field FWF[17] (RO)
 *
 * Indicates that an enabled transmit FIFO is empty.
 *
 * Values:
 * - 0 - No enabled transmit FIFO is empty.
 * - 1 - Enabled transmit FIFO is empty.
 */
//@{
#define BP_I2S_TCSR_FWF      (17U)         //!< Bit position for I2S_TCSR_FWF.
#define BM_I2S_TCSR_FWF      (0x00020000U) //!< Bit mask for I2S_TCSR_FWF.
#define BS_I2S_TCSR_FWF      (1U)          //!< Bit field size in bits for I2S_TCSR_FWF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCSR_FWF field.
#define BR_I2S_TCSR_FWF(x)   (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_FWF))
#endif
//@}

/*!
 * @name Register I2S_TCSR, field FEF[18] (W1C)
 *
 * Indicates that an enabled transmit FIFO has underrun. Write a logic 1 to this
 * field to clear this flag.
 *
 * Values:
 * - 0 - Transmit underrun not detected.
 * - 1 - Transmit underrun detected.
 */
//@{
#define BP_I2S_TCSR_FEF      (18U)         //!< Bit position for I2S_TCSR_FEF.
#define BM_I2S_TCSR_FEF      (0x00040000U) //!< Bit mask for I2S_TCSR_FEF.
#define BS_I2S_TCSR_FEF      (1U)          //!< Bit field size in bits for I2S_TCSR_FEF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCSR_FEF field.
#define BR_I2S_TCSR_FEF(x)   (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_FEF))
#endif

//! @brief Format value for bitfield I2S_TCSR_FEF.
#define BF_I2S_TCSR_FEF(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCSR_FEF), uint32_t) & BM_I2S_TCSR_FEF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FEF field to a new value.
#define BW_I2S_TCSR_FEF(x, v) (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_FEF) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCSR, field SEF[19] (W1C)
 *
 * Indicates that an error in the externally-generated frame sync has been
 * detected. Write a logic 1 to this field to clear this flag.
 *
 * Values:
 * - 0 - Sync error not detected.
 * - 1 - Frame sync error detected.
 */
//@{
#define BP_I2S_TCSR_SEF      (19U)         //!< Bit position for I2S_TCSR_SEF.
#define BM_I2S_TCSR_SEF      (0x00080000U) //!< Bit mask for I2S_TCSR_SEF.
#define BS_I2S_TCSR_SEF      (1U)          //!< Bit field size in bits for I2S_TCSR_SEF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCSR_SEF field.
#define BR_I2S_TCSR_SEF(x)   (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_SEF))
#endif

//! @brief Format value for bitfield I2S_TCSR_SEF.
#define BF_I2S_TCSR_SEF(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCSR_SEF), uint32_t) & BM_I2S_TCSR_SEF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SEF field to a new value.
#define BW_I2S_TCSR_SEF(x, v) (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_SEF) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCSR, field WSF[20] (W1C)
 *
 * Indicates that the start of the configured word has been detected. Write a
 * logic 1 to this field to clear this flag.
 *
 * Values:
 * - 0 - Start of word not detected.
 * - 1 - Start of word detected.
 */
//@{
#define BP_I2S_TCSR_WSF      (20U)         //!< Bit position for I2S_TCSR_WSF.
#define BM_I2S_TCSR_WSF      (0x00100000U) //!< Bit mask for I2S_TCSR_WSF.
#define BS_I2S_TCSR_WSF      (1U)          //!< Bit field size in bits for I2S_TCSR_WSF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCSR_WSF field.
#define BR_I2S_TCSR_WSF(x)   (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_WSF))
#endif

//! @brief Format value for bitfield I2S_TCSR_WSF.
#define BF_I2S_TCSR_WSF(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCSR_WSF), uint32_t) & BM_I2S_TCSR_WSF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WSF field to a new value.
#define BW_I2S_TCSR_WSF(x, v) (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_WSF) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCSR, field SR[24] (RW)
 *
 * When set, resets the internal transmitter logic including the FIFO pointers.
 * Software-visible registers are not affected, except for the status registers.
 *
 * Values:
 * - 0 - No effect.
 * - 1 - Software reset.
 */
//@{
#define BP_I2S_TCSR_SR       (24U)         //!< Bit position for I2S_TCSR_SR.
#define BM_I2S_TCSR_SR       (0x01000000U) //!< Bit mask for I2S_TCSR_SR.
#define BS_I2S_TCSR_SR       (1U)          //!< Bit field size in bits for I2S_TCSR_SR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCSR_SR field.
#define BR_I2S_TCSR_SR(x)    (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_SR))
#endif

//! @brief Format value for bitfield I2S_TCSR_SR.
#define BF_I2S_TCSR_SR(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCSR_SR), uint32_t) & BM_I2S_TCSR_SR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SR field to a new value.
#define BW_I2S_TCSR_SR(x, v) (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_SR) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCSR, field FR[25] (WORZ)
 *
 * Resets the FIFO pointers. Reading this field will always return zero. FIFO
 * pointers should only be reset when the transmitter is disabled or the FIFO error
 * flag is set.
 *
 * Values:
 * - 0 - No effect.
 * - 1 - FIFO reset.
 */
//@{
#define BP_I2S_TCSR_FR       (25U)         //!< Bit position for I2S_TCSR_FR.
#define BM_I2S_TCSR_FR       (0x02000000U) //!< Bit mask for I2S_TCSR_FR.
#define BS_I2S_TCSR_FR       (1U)          //!< Bit field size in bits for I2S_TCSR_FR.

//! @brief Format value for bitfield I2S_TCSR_FR.
#define BF_I2S_TCSR_FR(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCSR_FR), uint32_t) & BM_I2S_TCSR_FR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FR field to a new value.
#define BW_I2S_TCSR_FR(x, v) (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_FR) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCSR, field BCE[28] (RW)
 *
 * Enables the transmit bit clock, separately from the TE. This field is
 * automatically set whenever TE is set. When software clears this field, the transmit
 * bit clock remains enabled, and this bit remains set, until the end of the
 * current frame.
 *
 * Values:
 * - 0 - Transmit bit clock is disabled.
 * - 1 - Transmit bit clock is enabled.
 */
//@{
#define BP_I2S_TCSR_BCE      (28U)         //!< Bit position for I2S_TCSR_BCE.
#define BM_I2S_TCSR_BCE      (0x10000000U) //!< Bit mask for I2S_TCSR_BCE.
#define BS_I2S_TCSR_BCE      (1U)          //!< Bit field size in bits for I2S_TCSR_BCE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCSR_BCE field.
#define BR_I2S_TCSR_BCE(x)   (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_BCE))
#endif

//! @brief Format value for bitfield I2S_TCSR_BCE.
#define BF_I2S_TCSR_BCE(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCSR_BCE), uint32_t) & BM_I2S_TCSR_BCE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BCE field to a new value.
#define BW_I2S_TCSR_BCE(x, v) (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_BCE) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCSR, field DBGE[29] (RW)
 *
 * Enables/disables transmitter operation in Debug mode. The transmit bit clock
 * is not affected by debug mode.
 *
 * Values:
 * - 0 - Transmitter is disabled in Debug mode, after completing the current
 *     frame.
 * - 1 - Transmitter is enabled in Debug mode.
 */
//@{
#define BP_I2S_TCSR_DBGE     (29U)         //!< Bit position for I2S_TCSR_DBGE.
#define BM_I2S_TCSR_DBGE     (0x20000000U) //!< Bit mask for I2S_TCSR_DBGE.
#define BS_I2S_TCSR_DBGE     (1U)          //!< Bit field size in bits for I2S_TCSR_DBGE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCSR_DBGE field.
#define BR_I2S_TCSR_DBGE(x)  (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_DBGE))
#endif

//! @brief Format value for bitfield I2S_TCSR_DBGE.
#define BF_I2S_TCSR_DBGE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCSR_DBGE), uint32_t) & BM_I2S_TCSR_DBGE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DBGE field to a new value.
#define BW_I2S_TCSR_DBGE(x, v) (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_DBGE) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCSR, field STOPE[30] (RW)
 *
 * Configures transmitter operation in Stop mode. This field is ignored and the
 * transmitter is disabled in all low-leakage stop modes.
 *
 * Values:
 * - 0 - Transmitter disabled in Stop mode.
 * - 1 - Transmitter enabled in Stop mode.
 */
//@{
#define BP_I2S_TCSR_STOPE    (30U)         //!< Bit position for I2S_TCSR_STOPE.
#define BM_I2S_TCSR_STOPE    (0x40000000U) //!< Bit mask for I2S_TCSR_STOPE.
#define BS_I2S_TCSR_STOPE    (1U)          //!< Bit field size in bits for I2S_TCSR_STOPE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCSR_STOPE field.
#define BR_I2S_TCSR_STOPE(x) (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_STOPE))
#endif

//! @brief Format value for bitfield I2S_TCSR_STOPE.
#define BF_I2S_TCSR_STOPE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCSR_STOPE), uint32_t) & BM_I2S_TCSR_STOPE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the STOPE field to a new value.
#define BW_I2S_TCSR_STOPE(x, v) (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_STOPE) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCSR, field TE[31] (RW)
 *
 * Enables/disables the transmitter. When software clears this field, the
 * transmitter remains enabled, and this bit remains set, until the end of the current
 * frame.
 *
 * Values:
 * - 0 - Transmitter is disabled.
 * - 1 - Transmitter is enabled, or transmitter has been disabled and has not
 *     yet reached end of frame.
 */
//@{
#define BP_I2S_TCSR_TE       (31U)         //!< Bit position for I2S_TCSR_TE.
#define BM_I2S_TCSR_TE       (0x80000000U) //!< Bit mask for I2S_TCSR_TE.
#define BS_I2S_TCSR_TE       (1U)          //!< Bit field size in bits for I2S_TCSR_TE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCSR_TE field.
#define BR_I2S_TCSR_TE(x)    (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_TE))
#endif

//! @brief Format value for bitfield I2S_TCSR_TE.
#define BF_I2S_TCSR_TE(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCSR_TE), uint32_t) & BM_I2S_TCSR_TE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TE field to a new value.
#define BW_I2S_TCSR_TE(x, v) (BITBAND_ACCESS32(HW_I2S_TCSR_ADDR(x), BP_I2S_TCSR_TE) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2S_TCR1 - SAI Transmit Configuration 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2S_TCR1 - SAI Transmit Configuration 1 Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_i2s_tcr1
{
    uint32_t U;
    struct _hw_i2s_tcr1_bitfields
    {
        uint32_t TFW : 3;              //!< [2:0] Transmit FIFO Watermark
        uint32_t RESERVED0 : 29;       //!< [31:3]
    } B;
} hw_i2s_tcr1_t;
#endif

/*!
 * @name Constants and macros for entire I2S_TCR1 register
 */
//@{
#define HW_I2S_TCR1_ADDR(x)      (REGS_I2S_BASE(x) + 0x4U)

#ifndef __LANGUAGE_ASM__
#define HW_I2S_TCR1(x)           (*(__IO hw_i2s_tcr1_t *) HW_I2S_TCR1_ADDR(x))
#define HW_I2S_TCR1_RD(x)        (HW_I2S_TCR1(x).U)
#define HW_I2S_TCR1_WR(x, v)     (HW_I2S_TCR1(x).U = (v))
#define HW_I2S_TCR1_SET(x, v)    (HW_I2S_TCR1_WR(x, HW_I2S_TCR1_RD(x) |  (v)))
#define HW_I2S_TCR1_CLR(x, v)    (HW_I2S_TCR1_WR(x, HW_I2S_TCR1_RD(x) & ~(v)))
#define HW_I2S_TCR1_TOG(x, v)    (HW_I2S_TCR1_WR(x, HW_I2S_TCR1_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2S_TCR1 bitfields
 */

/*!
 * @name Register I2S_TCR1, field TFW[2:0] (RW)
 *
 * Configures the watermark level for all enabled transmit channels.
 */
//@{
#define BP_I2S_TCR1_TFW      (0U)          //!< Bit position for I2S_TCR1_TFW.
#define BM_I2S_TCR1_TFW      (0x00000007U) //!< Bit mask for I2S_TCR1_TFW.
#define BS_I2S_TCR1_TFW      (3U)          //!< Bit field size in bits for I2S_TCR1_TFW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCR1_TFW field.
#define BR_I2S_TCR1_TFW(x)   (HW_I2S_TCR1(x).B.TFW)
#endif

//! @brief Format value for bitfield I2S_TCR1_TFW.
#define BF_I2S_TCR1_TFW(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCR1_TFW), uint32_t) & BM_I2S_TCR1_TFW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TFW field to a new value.
#define BW_I2S_TCR1_TFW(x, v) (HW_I2S_TCR1_WR(x, (HW_I2S_TCR1_RD(x) & ~BM_I2S_TCR1_TFW) | BF_I2S_TCR1_TFW(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2S_TCR2 - SAI Transmit Configuration 2 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2S_TCR2 - SAI Transmit Configuration 2 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register must not be altered when TCSR[TE] is set.
 */
typedef union _hw_i2s_tcr2
{
    uint32_t U;
    struct _hw_i2s_tcr2_bitfields
    {
        uint32_t DIV : 8;              //!< [7:0] Bit Clock Divide
        uint32_t RESERVED0 : 16;       //!< [23:8]
        uint32_t BCD : 1;              //!< [24] Bit Clock Direction
        uint32_t BCP : 1;              //!< [25] Bit Clock Polarity
        uint32_t MSEL : 2;             //!< [27:26] MCLK Select
        uint32_t BCI : 1;              //!< [28] Bit Clock Input
        uint32_t BCS : 1;              //!< [29] Bit Clock Swap
        uint32_t SYNC : 2;             //!< [31:30] Synchronous Mode
    } B;
} hw_i2s_tcr2_t;
#endif

/*!
 * @name Constants and macros for entire I2S_TCR2 register
 */
//@{
#define HW_I2S_TCR2_ADDR(x)      (REGS_I2S_BASE(x) + 0x8U)

#ifndef __LANGUAGE_ASM__
#define HW_I2S_TCR2(x)           (*(__IO hw_i2s_tcr2_t *) HW_I2S_TCR2_ADDR(x))
#define HW_I2S_TCR2_RD(x)        (HW_I2S_TCR2(x).U)
#define HW_I2S_TCR2_WR(x, v)     (HW_I2S_TCR2(x).U = (v))
#define HW_I2S_TCR2_SET(x, v)    (HW_I2S_TCR2_WR(x, HW_I2S_TCR2_RD(x) |  (v)))
#define HW_I2S_TCR2_CLR(x, v)    (HW_I2S_TCR2_WR(x, HW_I2S_TCR2_RD(x) & ~(v)))
#define HW_I2S_TCR2_TOG(x, v)    (HW_I2S_TCR2_WR(x, HW_I2S_TCR2_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2S_TCR2 bitfields
 */

/*!
 * @name Register I2S_TCR2, field DIV[7:0] (RW)
 *
 * Divides down the audio master clock to generate the bit clock when configured
 * for an internal bit clock. The division value is (DIV + 1) * 2.
 */
//@{
#define BP_I2S_TCR2_DIV      (0U)          //!< Bit position for I2S_TCR2_DIV.
#define BM_I2S_TCR2_DIV      (0x000000FFU) //!< Bit mask for I2S_TCR2_DIV.
#define BS_I2S_TCR2_DIV      (8U)          //!< Bit field size in bits for I2S_TCR2_DIV.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCR2_DIV field.
#define BR_I2S_TCR2_DIV(x)   (HW_I2S_TCR2(x).B.DIV)
#endif

//! @brief Format value for bitfield I2S_TCR2_DIV.
#define BF_I2S_TCR2_DIV(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCR2_DIV), uint32_t) & BM_I2S_TCR2_DIV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DIV field to a new value.
#define BW_I2S_TCR2_DIV(x, v) (HW_I2S_TCR2_WR(x, (HW_I2S_TCR2_RD(x) & ~BM_I2S_TCR2_DIV) | BF_I2S_TCR2_DIV(v)))
#endif
//@}

/*!
 * @name Register I2S_TCR2, field BCD[24] (RW)
 *
 * Configures the direction of the bit clock.
 *
 * Values:
 * - 0 - Bit clock is generated externally in Slave mode.
 * - 1 - Bit clock is generated internally in Master mode.
 */
//@{
#define BP_I2S_TCR2_BCD      (24U)         //!< Bit position for I2S_TCR2_BCD.
#define BM_I2S_TCR2_BCD      (0x01000000U) //!< Bit mask for I2S_TCR2_BCD.
#define BS_I2S_TCR2_BCD      (1U)          //!< Bit field size in bits for I2S_TCR2_BCD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCR2_BCD field.
#define BR_I2S_TCR2_BCD(x)   (BITBAND_ACCESS32(HW_I2S_TCR2_ADDR(x), BP_I2S_TCR2_BCD))
#endif

//! @brief Format value for bitfield I2S_TCR2_BCD.
#define BF_I2S_TCR2_BCD(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCR2_BCD), uint32_t) & BM_I2S_TCR2_BCD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BCD field to a new value.
#define BW_I2S_TCR2_BCD(x, v) (BITBAND_ACCESS32(HW_I2S_TCR2_ADDR(x), BP_I2S_TCR2_BCD) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCR2, field BCP[25] (RW)
 *
 * Configures the polarity of the bit clock.
 *
 * Values:
 * - 0 - Bit clock is active high with drive outputs on rising edge and sample
 *     inputs on falling edge.
 * - 1 - Bit clock is active low with drive outputs on falling edge and sample
 *     inputs on rising edge.
 */
//@{
#define BP_I2S_TCR2_BCP      (25U)         //!< Bit position for I2S_TCR2_BCP.
#define BM_I2S_TCR2_BCP      (0x02000000U) //!< Bit mask for I2S_TCR2_BCP.
#define BS_I2S_TCR2_BCP      (1U)          //!< Bit field size in bits for I2S_TCR2_BCP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCR2_BCP field.
#define BR_I2S_TCR2_BCP(x)   (BITBAND_ACCESS32(HW_I2S_TCR2_ADDR(x), BP_I2S_TCR2_BCP))
#endif

//! @brief Format value for bitfield I2S_TCR2_BCP.
#define BF_I2S_TCR2_BCP(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCR2_BCP), uint32_t) & BM_I2S_TCR2_BCP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BCP field to a new value.
#define BW_I2S_TCR2_BCP(x, v) (BITBAND_ACCESS32(HW_I2S_TCR2_ADDR(x), BP_I2S_TCR2_BCP) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCR2, field MSEL[27:26] (RW)
 *
 * Selects the audio Master Clock option used to generate an internally
 * generated bit clock. This field has no effect when configured for an externally
 * generated bit clock. Depending on the device, some Master Clock options might not be
 * available. See the chip configuration details for the availability and
 * chip-specific meaning of each option.
 *
 * Values:
 * - 00 - Bus Clock selected.
 * - 01 - Master Clock (MCLK) 1 option selected.
 * - 10 - Master Clock (MCLK) 2 option selected.
 * - 11 - Master Clock (MCLK) 3 option selected.
 */
//@{
#define BP_I2S_TCR2_MSEL     (26U)         //!< Bit position for I2S_TCR2_MSEL.
#define BM_I2S_TCR2_MSEL     (0x0C000000U) //!< Bit mask for I2S_TCR2_MSEL.
#define BS_I2S_TCR2_MSEL     (2U)          //!< Bit field size in bits for I2S_TCR2_MSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCR2_MSEL field.
#define BR_I2S_TCR2_MSEL(x)  (HW_I2S_TCR2(x).B.MSEL)
#endif

//! @brief Format value for bitfield I2S_TCR2_MSEL.
#define BF_I2S_TCR2_MSEL(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCR2_MSEL), uint32_t) & BM_I2S_TCR2_MSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MSEL field to a new value.
#define BW_I2S_TCR2_MSEL(x, v) (HW_I2S_TCR2_WR(x, (HW_I2S_TCR2_RD(x) & ~BM_I2S_TCR2_MSEL) | BF_I2S_TCR2_MSEL(v)))
#endif
//@}

/*!
 * @name Register I2S_TCR2, field BCI[28] (RW)
 *
 * When this field is set and using an internally generated bit clock in either
 * synchronous or asynchronous mode, the bit clock actually used by the
 * transmitter is delayed by the pad output delay (the transmitter is clocked by the pad
 * input as if the clock was externally generated). This has the effect of
 * decreasing the data input setup time, but increasing the data output valid time. The
 * slave mode timing from the datasheet should be used for the transmitter when
 * this bit is set. In synchronous mode, this bit allows the transmitter to use
 * the slave mode timing from the datasheet, while the receiver uses the master
 * mode timing. This field has no effect when configured for an externally generated
 * bit clock or when synchronous to another SAI peripheral .
 *
 * Values:
 * - 0 - No effect.
 * - 1 - Internal logic is clocked as if bit clock was externally generated.
 */
//@{
#define BP_I2S_TCR2_BCI      (28U)         //!< Bit position for I2S_TCR2_BCI.
#define BM_I2S_TCR2_BCI      (0x10000000U) //!< Bit mask for I2S_TCR2_BCI.
#define BS_I2S_TCR2_BCI      (1U)          //!< Bit field size in bits for I2S_TCR2_BCI.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCR2_BCI field.
#define BR_I2S_TCR2_BCI(x)   (BITBAND_ACCESS32(HW_I2S_TCR2_ADDR(x), BP_I2S_TCR2_BCI))
#endif

//! @brief Format value for bitfield I2S_TCR2_BCI.
#define BF_I2S_TCR2_BCI(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCR2_BCI), uint32_t) & BM_I2S_TCR2_BCI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BCI field to a new value.
#define BW_I2S_TCR2_BCI(x, v) (BITBAND_ACCESS32(HW_I2S_TCR2_ADDR(x), BP_I2S_TCR2_BCI) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCR2, field BCS[29] (RW)
 *
 * This field swaps the bit clock used by the transmitter. When the transmitter
 * is configured in asynchronous mode and this bit is set, the transmitter is
 * clocked by the receiver bit clock (SAI_RX_BCLK). This allows the transmitter and
 * receiver to share the same bit clock, but the transmitter continues to use the
 * transmit frame sync (SAI_TX_SYNC). When the transmitter is configured in
 * synchronous mode, the transmitter BCS field and receiver BCS field must be set to
 * the same value. When both are set, the transmitter and receiver are both
 * clocked by the transmitter bit clock (SAI_TX_BCLK) but use the receiver frame sync
 * (SAI_RX_SYNC). This field has no effect when synchronous to another SAI
 * peripheral.
 *
 * Values:
 * - 0 - Use the normal bit clock source.
 * - 1 - Swap the bit clock source.
 */
//@{
#define BP_I2S_TCR2_BCS      (29U)         //!< Bit position for I2S_TCR2_BCS.
#define BM_I2S_TCR2_BCS      (0x20000000U) //!< Bit mask for I2S_TCR2_BCS.
#define BS_I2S_TCR2_BCS      (1U)          //!< Bit field size in bits for I2S_TCR2_BCS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCR2_BCS field.
#define BR_I2S_TCR2_BCS(x)   (BITBAND_ACCESS32(HW_I2S_TCR2_ADDR(x), BP_I2S_TCR2_BCS))
#endif

//! @brief Format value for bitfield I2S_TCR2_BCS.
#define BF_I2S_TCR2_BCS(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCR2_BCS), uint32_t) & BM_I2S_TCR2_BCS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BCS field to a new value.
#define BW_I2S_TCR2_BCS(x, v) (BITBAND_ACCESS32(HW_I2S_TCR2_ADDR(x), BP_I2S_TCR2_BCS) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCR2, field SYNC[31:30] (RW)
 *
 * Configures between asynchronous and synchronous modes of operation. When
 * configured for a synchronous mode of operation, the receiver or other SAI
 * peripheral must be configured for asynchronous operation.
 *
 * Values:
 * - 00 - Asynchronous mode.
 * - 01 - Synchronous with receiver.
 * - 10 - Synchronous with another SAI transmitter.
 * - 11 - Synchronous with another SAI receiver.
 */
//@{
#define BP_I2S_TCR2_SYNC     (30U)         //!< Bit position for I2S_TCR2_SYNC.
#define BM_I2S_TCR2_SYNC     (0xC0000000U) //!< Bit mask for I2S_TCR2_SYNC.
#define BS_I2S_TCR2_SYNC     (2U)          //!< Bit field size in bits for I2S_TCR2_SYNC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCR2_SYNC field.
#define BR_I2S_TCR2_SYNC(x)  (HW_I2S_TCR2(x).B.SYNC)
#endif

//! @brief Format value for bitfield I2S_TCR2_SYNC.
#define BF_I2S_TCR2_SYNC(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCR2_SYNC), uint32_t) & BM_I2S_TCR2_SYNC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SYNC field to a new value.
#define BW_I2S_TCR2_SYNC(x, v) (HW_I2S_TCR2_WR(x, (HW_I2S_TCR2_RD(x) & ~BM_I2S_TCR2_SYNC) | BF_I2S_TCR2_SYNC(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2S_TCR3 - SAI Transmit Configuration 3 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2S_TCR3 - SAI Transmit Configuration 3 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register must not be altered when TCSR[TE] is set.
 */
typedef union _hw_i2s_tcr3
{
    uint32_t U;
    struct _hw_i2s_tcr3_bitfields
    {
        uint32_t WDFL : 5;             //!< [4:0] Word Flag Configuration
        uint32_t RESERVED0 : 11;       //!< [15:5]
        uint32_t TCE : 2;              //!< [17:16] Transmit Channel Enable
        uint32_t RESERVED1 : 14;       //!< [31:18]
    } B;
} hw_i2s_tcr3_t;
#endif

/*!
 * @name Constants and macros for entire I2S_TCR3 register
 */
//@{
#define HW_I2S_TCR3_ADDR(x)      (REGS_I2S_BASE(x) + 0xCU)

#ifndef __LANGUAGE_ASM__
#define HW_I2S_TCR3(x)           (*(__IO hw_i2s_tcr3_t *) HW_I2S_TCR3_ADDR(x))
#define HW_I2S_TCR3_RD(x)        (HW_I2S_TCR3(x).U)
#define HW_I2S_TCR3_WR(x, v)     (HW_I2S_TCR3(x).U = (v))
#define HW_I2S_TCR3_SET(x, v)    (HW_I2S_TCR3_WR(x, HW_I2S_TCR3_RD(x) |  (v)))
#define HW_I2S_TCR3_CLR(x, v)    (HW_I2S_TCR3_WR(x, HW_I2S_TCR3_RD(x) & ~(v)))
#define HW_I2S_TCR3_TOG(x, v)    (HW_I2S_TCR3_WR(x, HW_I2S_TCR3_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2S_TCR3 bitfields
 */

/*!
 * @name Register I2S_TCR3, field WDFL[4:0] (RW)
 *
 * Configures which word sets the start of word flag. The value written must be
 * one less than the word number. For example, writing 0 configures the first
 * word in the frame. When configured to a value greater than TCR4[FRSZ], then the
 * start of word flag is never set.
 */
//@{
#define BP_I2S_TCR3_WDFL     (0U)          //!< Bit position for I2S_TCR3_WDFL.
#define BM_I2S_TCR3_WDFL     (0x0000001FU) //!< Bit mask for I2S_TCR3_WDFL.
#define BS_I2S_TCR3_WDFL     (5U)          //!< Bit field size in bits for I2S_TCR3_WDFL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCR3_WDFL field.
#define BR_I2S_TCR3_WDFL(x)  (HW_I2S_TCR3(x).B.WDFL)
#endif

//! @brief Format value for bitfield I2S_TCR3_WDFL.
#define BF_I2S_TCR3_WDFL(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCR3_WDFL), uint32_t) & BM_I2S_TCR3_WDFL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WDFL field to a new value.
#define BW_I2S_TCR3_WDFL(x, v) (HW_I2S_TCR3_WR(x, (HW_I2S_TCR3_RD(x) & ~BM_I2S_TCR3_WDFL) | BF_I2S_TCR3_WDFL(v)))
#endif
//@}

/*!
 * @name Register I2S_TCR3, field TCE[17:16] (RW)
 *
 * Enables the corresponding data channel for transmit operation. A channel must
 * be enabled before its FIFO is accessed.
 *
 * Values:
 * - 0 - Transmit data channel N is disabled.
 * - 1 - Transmit data channel N is enabled.
 */
//@{
#define BP_I2S_TCR3_TCE      (16U)         //!< Bit position for I2S_TCR3_TCE.
#define BM_I2S_TCR3_TCE      (0x00030000U) //!< Bit mask for I2S_TCR3_TCE.
#define BS_I2S_TCR3_TCE      (2U)          //!< Bit field size in bits for I2S_TCR3_TCE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCR3_TCE field.
#define BR_I2S_TCR3_TCE(x)   (HW_I2S_TCR3(x).B.TCE)
#endif

//! @brief Format value for bitfield I2S_TCR3_TCE.
#define BF_I2S_TCR3_TCE(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCR3_TCE), uint32_t) & BM_I2S_TCR3_TCE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TCE field to a new value.
#define BW_I2S_TCR3_TCE(x, v) (HW_I2S_TCR3_WR(x, (HW_I2S_TCR3_RD(x) & ~BM_I2S_TCR3_TCE) | BF_I2S_TCR3_TCE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2S_TCR4 - SAI Transmit Configuration 4 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2S_TCR4 - SAI Transmit Configuration 4 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register must not be altered when TCSR[TE] is set.
 */
typedef union _hw_i2s_tcr4
{
    uint32_t U;
    struct _hw_i2s_tcr4_bitfields
    {
        uint32_t FSD : 1;              //!< [0] Frame Sync Direction
        uint32_t FSP : 1;              //!< [1] Frame Sync Polarity
        uint32_t RESERVED0 : 1;        //!< [2]
        uint32_t FSE : 1;              //!< [3] Frame Sync Early
        uint32_t MF : 1;               //!< [4] MSB First
        uint32_t RESERVED1 : 3;        //!< [7:5]
        uint32_t SYWD : 5;             //!< [12:8] Sync Width
        uint32_t RESERVED2 : 3;        //!< [15:13]
        uint32_t FRSZ : 5;             //!< [20:16] Frame size
        uint32_t RESERVED3 : 11;       //!< [31:21]
    } B;
} hw_i2s_tcr4_t;
#endif

/*!
 * @name Constants and macros for entire I2S_TCR4 register
 */
//@{
#define HW_I2S_TCR4_ADDR(x)      (REGS_I2S_BASE(x) + 0x10U)

#ifndef __LANGUAGE_ASM__
#define HW_I2S_TCR4(x)           (*(__IO hw_i2s_tcr4_t *) HW_I2S_TCR4_ADDR(x))
#define HW_I2S_TCR4_RD(x)        (HW_I2S_TCR4(x).U)
#define HW_I2S_TCR4_WR(x, v)     (HW_I2S_TCR4(x).U = (v))
#define HW_I2S_TCR4_SET(x, v)    (HW_I2S_TCR4_WR(x, HW_I2S_TCR4_RD(x) |  (v)))
#define HW_I2S_TCR4_CLR(x, v)    (HW_I2S_TCR4_WR(x, HW_I2S_TCR4_RD(x) & ~(v)))
#define HW_I2S_TCR4_TOG(x, v)    (HW_I2S_TCR4_WR(x, HW_I2S_TCR4_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2S_TCR4 bitfields
 */

/*!
 * @name Register I2S_TCR4, field FSD[0] (RW)
 *
 * Configures the direction of the frame sync.
 *
 * Values:
 * - 0 - Frame sync is generated externally in Slave mode.
 * - 1 - Frame sync is generated internally in Master mode.
 */
//@{
#define BP_I2S_TCR4_FSD      (0U)          //!< Bit position for I2S_TCR4_FSD.
#define BM_I2S_TCR4_FSD      (0x00000001U) //!< Bit mask for I2S_TCR4_FSD.
#define BS_I2S_TCR4_FSD      (1U)          //!< Bit field size in bits for I2S_TCR4_FSD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCR4_FSD field.
#define BR_I2S_TCR4_FSD(x)   (BITBAND_ACCESS32(HW_I2S_TCR4_ADDR(x), BP_I2S_TCR4_FSD))
#endif

//! @brief Format value for bitfield I2S_TCR4_FSD.
#define BF_I2S_TCR4_FSD(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCR4_FSD), uint32_t) & BM_I2S_TCR4_FSD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FSD field to a new value.
#define BW_I2S_TCR4_FSD(x, v) (BITBAND_ACCESS32(HW_I2S_TCR4_ADDR(x), BP_I2S_TCR4_FSD) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCR4, field FSP[1] (RW)
 *
 * Configures the polarity of the frame sync.
 *
 * Values:
 * - 0 - Frame sync is active high.
 * - 1 - Frame sync is active low.
 */
//@{
#define BP_I2S_TCR4_FSP      (1U)          //!< Bit position for I2S_TCR4_FSP.
#define BM_I2S_TCR4_FSP      (0x00000002U) //!< Bit mask for I2S_TCR4_FSP.
#define BS_I2S_TCR4_FSP      (1U)          //!< Bit field size in bits for I2S_TCR4_FSP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCR4_FSP field.
#define BR_I2S_TCR4_FSP(x)   (BITBAND_ACCESS32(HW_I2S_TCR4_ADDR(x), BP_I2S_TCR4_FSP))
#endif

//! @brief Format value for bitfield I2S_TCR4_FSP.
#define BF_I2S_TCR4_FSP(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCR4_FSP), uint32_t) & BM_I2S_TCR4_FSP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FSP field to a new value.
#define BW_I2S_TCR4_FSP(x, v) (BITBAND_ACCESS32(HW_I2S_TCR4_ADDR(x), BP_I2S_TCR4_FSP) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCR4, field FSE[3] (RW)
 *
 * Values:
 * - 0 - Frame sync asserts with the first bit of the frame.
 * - 1 - Frame sync asserts one bit before the first bit of the frame.
 */
//@{
#define BP_I2S_TCR4_FSE      (3U)          //!< Bit position for I2S_TCR4_FSE.
#define BM_I2S_TCR4_FSE      (0x00000008U) //!< Bit mask for I2S_TCR4_FSE.
#define BS_I2S_TCR4_FSE      (1U)          //!< Bit field size in bits for I2S_TCR4_FSE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCR4_FSE field.
#define BR_I2S_TCR4_FSE(x)   (BITBAND_ACCESS32(HW_I2S_TCR4_ADDR(x), BP_I2S_TCR4_FSE))
#endif

//! @brief Format value for bitfield I2S_TCR4_FSE.
#define BF_I2S_TCR4_FSE(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCR4_FSE), uint32_t) & BM_I2S_TCR4_FSE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FSE field to a new value.
#define BW_I2S_TCR4_FSE(x, v) (BITBAND_ACCESS32(HW_I2S_TCR4_ADDR(x), BP_I2S_TCR4_FSE) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCR4, field MF[4] (RW)
 *
 * Configures whether the LSB or the MSB is transmitted first.
 *
 * Values:
 * - 0 - LSB is transmitted first.
 * - 1 - MSB is transmitted first.
 */
//@{
#define BP_I2S_TCR4_MF       (4U)          //!< Bit position for I2S_TCR4_MF.
#define BM_I2S_TCR4_MF       (0x00000010U) //!< Bit mask for I2S_TCR4_MF.
#define BS_I2S_TCR4_MF       (1U)          //!< Bit field size in bits for I2S_TCR4_MF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCR4_MF field.
#define BR_I2S_TCR4_MF(x)    (BITBAND_ACCESS32(HW_I2S_TCR4_ADDR(x), BP_I2S_TCR4_MF))
#endif

//! @brief Format value for bitfield I2S_TCR4_MF.
#define BF_I2S_TCR4_MF(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCR4_MF), uint32_t) & BM_I2S_TCR4_MF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MF field to a new value.
#define BW_I2S_TCR4_MF(x, v) (BITBAND_ACCESS32(HW_I2S_TCR4_ADDR(x), BP_I2S_TCR4_MF) = (v))
#endif
//@}

/*!
 * @name Register I2S_TCR4, field SYWD[12:8] (RW)
 *
 * Configures the length of the frame sync in number of bit clocks. The value
 * written must be one less than the number of bit clocks. For example, write 0 for
 * the frame sync to assert for one bit clock only. The sync width cannot be
 * configured longer than the first word of the frame.
 */
//@{
#define BP_I2S_TCR4_SYWD     (8U)          //!< Bit position for I2S_TCR4_SYWD.
#define BM_I2S_TCR4_SYWD     (0x00001F00U) //!< Bit mask for I2S_TCR4_SYWD.
#define BS_I2S_TCR4_SYWD     (5U)          //!< Bit field size in bits for I2S_TCR4_SYWD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCR4_SYWD field.
#define BR_I2S_TCR4_SYWD(x)  (HW_I2S_TCR4(x).B.SYWD)
#endif

//! @brief Format value for bitfield I2S_TCR4_SYWD.
#define BF_I2S_TCR4_SYWD(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCR4_SYWD), uint32_t) & BM_I2S_TCR4_SYWD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SYWD field to a new value.
#define BW_I2S_TCR4_SYWD(x, v) (HW_I2S_TCR4_WR(x, (HW_I2S_TCR4_RD(x) & ~BM_I2S_TCR4_SYWD) | BF_I2S_TCR4_SYWD(v)))
#endif
//@}

/*!
 * @name Register I2S_TCR4, field FRSZ[20:16] (RW)
 *
 * Configures the number of words in each frame. The value written must be one
 * less than the number of words in the frame. For example, write 0 for one word
 * per frame. The maximum supported frame size is 32 words.
 */
//@{
#define BP_I2S_TCR4_FRSZ     (16U)         //!< Bit position for I2S_TCR4_FRSZ.
#define BM_I2S_TCR4_FRSZ     (0x001F0000U) //!< Bit mask for I2S_TCR4_FRSZ.
#define BS_I2S_TCR4_FRSZ     (5U)          //!< Bit field size in bits for I2S_TCR4_FRSZ.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCR4_FRSZ field.
#define BR_I2S_TCR4_FRSZ(x)  (HW_I2S_TCR4(x).B.FRSZ)
#endif

//! @brief Format value for bitfield I2S_TCR4_FRSZ.
#define BF_I2S_TCR4_FRSZ(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCR4_FRSZ), uint32_t) & BM_I2S_TCR4_FRSZ)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FRSZ field to a new value.
#define BW_I2S_TCR4_FRSZ(x, v) (HW_I2S_TCR4_WR(x, (HW_I2S_TCR4_RD(x) & ~BM_I2S_TCR4_FRSZ) | BF_I2S_TCR4_FRSZ(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2S_TCR5 - SAI Transmit Configuration 5 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2S_TCR5 - SAI Transmit Configuration 5 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register must not be altered when TCSR[TE] is set.
 */
typedef union _hw_i2s_tcr5
{
    uint32_t U;
    struct _hw_i2s_tcr5_bitfields
    {
        uint32_t RESERVED0 : 8;        //!< [7:0]
        uint32_t FBT : 5;              //!< [12:8] First Bit Shifted
        uint32_t RESERVED1 : 3;        //!< [15:13]
        uint32_t W0W : 5;              //!< [20:16] Word 0 Width
        uint32_t RESERVED2 : 3;        //!< [23:21]
        uint32_t WNW : 5;              //!< [28:24] Word N Width
        uint32_t RESERVED3 : 3;        //!< [31:29]
    } B;
} hw_i2s_tcr5_t;
#endif

/*!
 * @name Constants and macros for entire I2S_TCR5 register
 */
//@{
#define HW_I2S_TCR5_ADDR(x)      (REGS_I2S_BASE(x) + 0x14U)

#ifndef __LANGUAGE_ASM__
#define HW_I2S_TCR5(x)           (*(__IO hw_i2s_tcr5_t *) HW_I2S_TCR5_ADDR(x))
#define HW_I2S_TCR5_RD(x)        (HW_I2S_TCR5(x).U)
#define HW_I2S_TCR5_WR(x, v)     (HW_I2S_TCR5(x).U = (v))
#define HW_I2S_TCR5_SET(x, v)    (HW_I2S_TCR5_WR(x, HW_I2S_TCR5_RD(x) |  (v)))
#define HW_I2S_TCR5_CLR(x, v)    (HW_I2S_TCR5_WR(x, HW_I2S_TCR5_RD(x) & ~(v)))
#define HW_I2S_TCR5_TOG(x, v)    (HW_I2S_TCR5_WR(x, HW_I2S_TCR5_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2S_TCR5 bitfields
 */

/*!
 * @name Register I2S_TCR5, field FBT[12:8] (RW)
 *
 * Configures the bit index for the first bit transmitted for each word in the
 * frame. If configured for MSB First, the index of the next bit transmitted is
 * one less than the current bit transmitted. If configured for LSB First, the
 * index of the next bit transmitted is one more than the current bit transmitted.
 * The value written must be greater than or equal to the word width when
 * configured for MSB First. The value written must be less than or equal to 31-word width
 * when configured for LSB First.
 */
//@{
#define BP_I2S_TCR5_FBT      (8U)          //!< Bit position for I2S_TCR5_FBT.
#define BM_I2S_TCR5_FBT      (0x00001F00U) //!< Bit mask for I2S_TCR5_FBT.
#define BS_I2S_TCR5_FBT      (5U)          //!< Bit field size in bits for I2S_TCR5_FBT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCR5_FBT field.
#define BR_I2S_TCR5_FBT(x)   (HW_I2S_TCR5(x).B.FBT)
#endif

//! @brief Format value for bitfield I2S_TCR5_FBT.
#define BF_I2S_TCR5_FBT(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCR5_FBT), uint32_t) & BM_I2S_TCR5_FBT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FBT field to a new value.
#define BW_I2S_TCR5_FBT(x, v) (HW_I2S_TCR5_WR(x, (HW_I2S_TCR5_RD(x) & ~BM_I2S_TCR5_FBT) | BF_I2S_TCR5_FBT(v)))
#endif
//@}

/*!
 * @name Register I2S_TCR5, field W0W[20:16] (RW)
 *
 * Configures the number of bits in the first word in each frame. The value
 * written must be one less than the number of bits in the first word. Word width of
 * less than 8 bits is not supported if there is only one word per frame.
 */
//@{
#define BP_I2S_TCR5_W0W      (16U)         //!< Bit position for I2S_TCR5_W0W.
#define BM_I2S_TCR5_W0W      (0x001F0000U) //!< Bit mask for I2S_TCR5_W0W.
#define BS_I2S_TCR5_W0W      (5U)          //!< Bit field size in bits for I2S_TCR5_W0W.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCR5_W0W field.
#define BR_I2S_TCR5_W0W(x)   (HW_I2S_TCR5(x).B.W0W)
#endif

//! @brief Format value for bitfield I2S_TCR5_W0W.
#define BF_I2S_TCR5_W0W(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCR5_W0W), uint32_t) & BM_I2S_TCR5_W0W)

#ifndef __LANGUAGE_ASM__
//! @brief Set the W0W field to a new value.
#define BW_I2S_TCR5_W0W(x, v) (HW_I2S_TCR5_WR(x, (HW_I2S_TCR5_RD(x) & ~BM_I2S_TCR5_W0W) | BF_I2S_TCR5_W0W(v)))
#endif
//@}

/*!
 * @name Register I2S_TCR5, field WNW[28:24] (RW)
 *
 * Configures the number of bits in each word, for each word except the first in
 * the frame. The value written must be one less than the number of bits per
 * word. Word width of less than 8 bits is not supported.
 */
//@{
#define BP_I2S_TCR5_WNW      (24U)         //!< Bit position for I2S_TCR5_WNW.
#define BM_I2S_TCR5_WNW      (0x1F000000U) //!< Bit mask for I2S_TCR5_WNW.
#define BS_I2S_TCR5_WNW      (5U)          //!< Bit field size in bits for I2S_TCR5_WNW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TCR5_WNW field.
#define BR_I2S_TCR5_WNW(x)   (HW_I2S_TCR5(x).B.WNW)
#endif

//! @brief Format value for bitfield I2S_TCR5_WNW.
#define BF_I2S_TCR5_WNW(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TCR5_WNW), uint32_t) & BM_I2S_TCR5_WNW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WNW field to a new value.
#define BW_I2S_TCR5_WNW(x, v) (HW_I2S_TCR5_WR(x, (HW_I2S_TCR5_RD(x) & ~BM_I2S_TCR5_WNW) | BF_I2S_TCR5_WNW(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2S_TDRn - SAI Transmit Data Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2S_TDRn - SAI Transmit Data Register (WORZ)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_i2s_tdrn
{
    uint32_t U;
    struct _hw_i2s_tdrn_bitfields
    {
        uint32_t TDR : 32;             //!< [31:0] Transmit Data Register
    } B;
} hw_i2s_tdrn_t;
#endif

/*!
 * @name Constants and macros for entire I2S_TDRn register
 */
//@{
#define HW_I2S_TDRn_COUNT (2U)

#define HW_I2S_TDRn_ADDR(x, n)   (REGS_I2S_BASE(x) + 0x20U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_I2S_TDRn(x, n)        (*(__O hw_i2s_tdrn_t *) HW_I2S_TDRn_ADDR(x, n))
#define HW_I2S_TDRn_RD(x, n)     (HW_I2S_TDRn(x, n).U)
#define HW_I2S_TDRn_WR(x, n, v)  (HW_I2S_TDRn(x, n).U = (v))
#endif
//@}

/*
 * Constants & macros for individual I2S_TDRn bitfields
 */

/*!
 * @name Register I2S_TDRn, field TDR[31:0] (WORZ)
 *
 * The corresponding TCR3[TCE] bit must be set before accessing the channel's
 * transmit data register. Writes to this register when the transmit FIFO is not
 * full will push the data written into the transmit data FIFO. Writes to this
 * register when the transmit FIFO is full are ignored.
 */
//@{
#define BP_I2S_TDRn_TDR      (0U)          //!< Bit position for I2S_TDRn_TDR.
#define BM_I2S_TDRn_TDR      (0xFFFFFFFFU) //!< Bit mask for I2S_TDRn_TDR.
#define BS_I2S_TDRn_TDR      (32U)         //!< Bit field size in bits for I2S_TDRn_TDR.

//! @brief Format value for bitfield I2S_TDRn_TDR.
#define BF_I2S_TDRn_TDR(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TDRn_TDR), uint32_t) & BM_I2S_TDRn_TDR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TDR field to a new value.
#define BW_I2S_TDRn_TDR(x, n, v) (HW_I2S_TDRn_WR(x, n, v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2S_TFRn - SAI Transmit FIFO Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2S_TFRn - SAI Transmit FIFO Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The MSB of the read and write pointers is used to distinguish between FIFO
 * full and empty conditions. If the read and write pointers are identical, then
 * the FIFO is empty. If the read and write pointers are identical except for the
 * MSB, then the FIFO is full.
 */
typedef union _hw_i2s_tfrn
{
    uint32_t U;
    struct _hw_i2s_tfrn_bitfields
    {
        uint32_t RFP : 4;              //!< [3:0] Read FIFO Pointer
        uint32_t RESERVED0 : 12;       //!< [15:4]
        uint32_t WFP : 4;              //!< [19:16] Write FIFO Pointer
        uint32_t RESERVED1 : 12;       //!< [31:20]
    } B;
} hw_i2s_tfrn_t;
#endif

/*!
 * @name Constants and macros for entire I2S_TFRn register
 */
//@{
#define HW_I2S_TFRn_COUNT (2U)

#define HW_I2S_TFRn_ADDR(x, n)   (REGS_I2S_BASE(x) + 0x40U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_I2S_TFRn(x, n)        (*(__I hw_i2s_tfrn_t *) HW_I2S_TFRn_ADDR(x, n))
#define HW_I2S_TFRn_RD(x, n)     (HW_I2S_TFRn(x, n).U)
#endif
//@}

/*
 * Constants & macros for individual I2S_TFRn bitfields
 */

/*!
 * @name Register I2S_TFRn, field RFP[3:0] (RO)
 *
 * FIFO read pointer for transmit data channel.
 */
//@{
#define BP_I2S_TFRn_RFP      (0U)          //!< Bit position for I2S_TFRn_RFP.
#define BM_I2S_TFRn_RFP      (0x0000000FU) //!< Bit mask for I2S_TFRn_RFP.
#define BS_I2S_TFRn_RFP      (4U)          //!< Bit field size in bits for I2S_TFRn_RFP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TFRn_RFP field.
#define BR_I2S_TFRn_RFP(x, n) (HW_I2S_TFRn(x, n).B.RFP)
#endif
//@}

/*!
 * @name Register I2S_TFRn, field WFP[19:16] (RO)
 *
 * FIFO write pointer for transmit data channel.
 */
//@{
#define BP_I2S_TFRn_WFP      (16U)         //!< Bit position for I2S_TFRn_WFP.
#define BM_I2S_TFRn_WFP      (0x000F0000U) //!< Bit mask for I2S_TFRn_WFP.
#define BS_I2S_TFRn_WFP      (4U)          //!< Bit field size in bits for I2S_TFRn_WFP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TFRn_WFP field.
#define BR_I2S_TFRn_WFP(x, n) (HW_I2S_TFRn(x, n).B.WFP)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2S_TMR - SAI Transmit Mask Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2S_TMR - SAI Transmit Mask Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register is double-buffered and updates: When TCSR[TE] is first set At
 * the end of each frame. This allows the masked words in each frame to change
 * from frame to frame.
 */
typedef union _hw_i2s_tmr
{
    uint32_t U;
    struct _hw_i2s_tmr_bitfields
    {
        uint32_t TWM : 32;             //!< [31:0] Transmit Word Mask
    } B;
} hw_i2s_tmr_t;
#endif

/*!
 * @name Constants and macros for entire I2S_TMR register
 */
//@{
#define HW_I2S_TMR_ADDR(x)       (REGS_I2S_BASE(x) + 0x60U)

#ifndef __LANGUAGE_ASM__
#define HW_I2S_TMR(x)            (*(__IO hw_i2s_tmr_t *) HW_I2S_TMR_ADDR(x))
#define HW_I2S_TMR_RD(x)         (HW_I2S_TMR(x).U)
#define HW_I2S_TMR_WR(x, v)      (HW_I2S_TMR(x).U = (v))
#define HW_I2S_TMR_SET(x, v)     (HW_I2S_TMR_WR(x, HW_I2S_TMR_RD(x) |  (v)))
#define HW_I2S_TMR_CLR(x, v)     (HW_I2S_TMR_WR(x, HW_I2S_TMR_RD(x) & ~(v)))
#define HW_I2S_TMR_TOG(x, v)     (HW_I2S_TMR_WR(x, HW_I2S_TMR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2S_TMR bitfields
 */

/*!
 * @name Register I2S_TMR, field TWM[31:0] (RW)
 *
 * Configures whether the transmit word is masked (transmit data pin tristated
 * and transmit data not read from FIFO) for the corresponding word in the frame.
 *
 * Values:
 * - 0 - Word N is enabled.
 * - 1 - Word N is masked. The transmit data pins are tri-stated when masked.
 */
//@{
#define BP_I2S_TMR_TWM       (0U)          //!< Bit position for I2S_TMR_TWM.
#define BM_I2S_TMR_TWM       (0xFFFFFFFFU) //!< Bit mask for I2S_TMR_TWM.
#define BS_I2S_TMR_TWM       (32U)         //!< Bit field size in bits for I2S_TMR_TWM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_TMR_TWM field.
#define BR_I2S_TMR_TWM(x)    (HW_I2S_TMR(x).U)
#endif

//! @brief Format value for bitfield I2S_TMR_TWM.
#define BF_I2S_TMR_TWM(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_TMR_TWM), uint32_t) & BM_I2S_TMR_TWM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the TWM field to a new value.
#define BW_I2S_TMR_TWM(x, v) (HW_I2S_TMR_WR(x, v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2S_RCSR - SAI Receive Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2S_RCSR - SAI Receive Control Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_i2s_rcsr
{
    uint32_t U;
    struct _hw_i2s_rcsr_bitfields
    {
        uint32_t FRDE : 1;             //!< [0] FIFO Request DMA Enable
        uint32_t FWDE : 1;             //!< [1] FIFO Warning DMA Enable
        uint32_t RESERVED0 : 6;        //!< [7:2]
        uint32_t FRIE : 1;             //!< [8] FIFO Request Interrupt Enable
        uint32_t FWIE : 1;             //!< [9] FIFO Warning Interrupt Enable
        uint32_t FEIE : 1;             //!< [10] FIFO Error Interrupt Enable
        uint32_t SEIE : 1;             //!< [11] Sync Error Interrupt Enable
        uint32_t WSIE : 1;             //!< [12] Word Start Interrupt Enable
        uint32_t RESERVED1 : 3;        //!< [15:13]
        uint32_t FRF : 1;              //!< [16] FIFO Request Flag
        uint32_t FWF : 1;              //!< [17] FIFO Warning Flag
        uint32_t FEF : 1;              //!< [18] FIFO Error Flag
        uint32_t SEF : 1;              //!< [19] Sync Error Flag
        uint32_t WSF : 1;              //!< [20] Word Start Flag
        uint32_t RESERVED2 : 3;        //!< [23:21]
        uint32_t SR : 1;               //!< [24] Software Reset
        uint32_t FR : 1;               //!< [25] FIFO Reset
        uint32_t RESERVED3 : 2;        //!< [27:26]
        uint32_t BCE : 1;              //!< [28] Bit Clock Enable
        uint32_t DBGE : 1;             //!< [29] Debug Enable
        uint32_t STOPE : 1;            //!< [30] Stop Enable
        uint32_t RE : 1;               //!< [31] Receiver Enable
    } B;
} hw_i2s_rcsr_t;
#endif

/*!
 * @name Constants and macros for entire I2S_RCSR register
 */
//@{
#define HW_I2S_RCSR_ADDR(x)      (REGS_I2S_BASE(x) + 0x80U)

#ifndef __LANGUAGE_ASM__
#define HW_I2S_RCSR(x)           (*(__IO hw_i2s_rcsr_t *) HW_I2S_RCSR_ADDR(x))
#define HW_I2S_RCSR_RD(x)        (HW_I2S_RCSR(x).U)
#define HW_I2S_RCSR_WR(x, v)     (HW_I2S_RCSR(x).U = (v))
#define HW_I2S_RCSR_SET(x, v)    (HW_I2S_RCSR_WR(x, HW_I2S_RCSR_RD(x) |  (v)))
#define HW_I2S_RCSR_CLR(x, v)    (HW_I2S_RCSR_WR(x, HW_I2S_RCSR_RD(x) & ~(v)))
#define HW_I2S_RCSR_TOG(x, v)    (HW_I2S_RCSR_WR(x, HW_I2S_RCSR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2S_RCSR bitfields
 */

/*!
 * @name Register I2S_RCSR, field FRDE[0] (RW)
 *
 * Enables/disables DMA requests.
 *
 * Values:
 * - 0 - Disables the DMA request.
 * - 1 - Enables the DMA request.
 */
//@{
#define BP_I2S_RCSR_FRDE     (0U)          //!< Bit position for I2S_RCSR_FRDE.
#define BM_I2S_RCSR_FRDE     (0x00000001U) //!< Bit mask for I2S_RCSR_FRDE.
#define BS_I2S_RCSR_FRDE     (1U)          //!< Bit field size in bits for I2S_RCSR_FRDE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCSR_FRDE field.
#define BR_I2S_RCSR_FRDE(x)  (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_FRDE))
#endif

//! @brief Format value for bitfield I2S_RCSR_FRDE.
#define BF_I2S_RCSR_FRDE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCSR_FRDE), uint32_t) & BM_I2S_RCSR_FRDE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FRDE field to a new value.
#define BW_I2S_RCSR_FRDE(x, v) (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_FRDE) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCSR, field FWDE[1] (RW)
 *
 * Enables/disables DMA requests.
 *
 * Values:
 * - 0 - Disables the DMA request.
 * - 1 - Enables the DMA request.
 */
//@{
#define BP_I2S_RCSR_FWDE     (1U)          //!< Bit position for I2S_RCSR_FWDE.
#define BM_I2S_RCSR_FWDE     (0x00000002U) //!< Bit mask for I2S_RCSR_FWDE.
#define BS_I2S_RCSR_FWDE     (1U)          //!< Bit field size in bits for I2S_RCSR_FWDE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCSR_FWDE field.
#define BR_I2S_RCSR_FWDE(x)  (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_FWDE))
#endif

//! @brief Format value for bitfield I2S_RCSR_FWDE.
#define BF_I2S_RCSR_FWDE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCSR_FWDE), uint32_t) & BM_I2S_RCSR_FWDE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FWDE field to a new value.
#define BW_I2S_RCSR_FWDE(x, v) (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_FWDE) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCSR, field FRIE[8] (RW)
 *
 * Enables/disables FIFO request interrupts.
 *
 * Values:
 * - 0 - Disables the interrupt.
 * - 1 - Enables the interrupt.
 */
//@{
#define BP_I2S_RCSR_FRIE     (8U)          //!< Bit position for I2S_RCSR_FRIE.
#define BM_I2S_RCSR_FRIE     (0x00000100U) //!< Bit mask for I2S_RCSR_FRIE.
#define BS_I2S_RCSR_FRIE     (1U)          //!< Bit field size in bits for I2S_RCSR_FRIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCSR_FRIE field.
#define BR_I2S_RCSR_FRIE(x)  (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_FRIE))
#endif

//! @brief Format value for bitfield I2S_RCSR_FRIE.
#define BF_I2S_RCSR_FRIE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCSR_FRIE), uint32_t) & BM_I2S_RCSR_FRIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FRIE field to a new value.
#define BW_I2S_RCSR_FRIE(x, v) (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_FRIE) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCSR, field FWIE[9] (RW)
 *
 * Enables/disables FIFO warning interrupts.
 *
 * Values:
 * - 0 - Disables the interrupt.
 * - 1 - Enables the interrupt.
 */
//@{
#define BP_I2S_RCSR_FWIE     (9U)          //!< Bit position for I2S_RCSR_FWIE.
#define BM_I2S_RCSR_FWIE     (0x00000200U) //!< Bit mask for I2S_RCSR_FWIE.
#define BS_I2S_RCSR_FWIE     (1U)          //!< Bit field size in bits for I2S_RCSR_FWIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCSR_FWIE field.
#define BR_I2S_RCSR_FWIE(x)  (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_FWIE))
#endif

//! @brief Format value for bitfield I2S_RCSR_FWIE.
#define BF_I2S_RCSR_FWIE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCSR_FWIE), uint32_t) & BM_I2S_RCSR_FWIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FWIE field to a new value.
#define BW_I2S_RCSR_FWIE(x, v) (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_FWIE) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCSR, field FEIE[10] (RW)
 *
 * Enables/disables FIFO error interrupts.
 *
 * Values:
 * - 0 - Disables the interrupt.
 * - 1 - Enables the interrupt.
 */
//@{
#define BP_I2S_RCSR_FEIE     (10U)         //!< Bit position for I2S_RCSR_FEIE.
#define BM_I2S_RCSR_FEIE     (0x00000400U) //!< Bit mask for I2S_RCSR_FEIE.
#define BS_I2S_RCSR_FEIE     (1U)          //!< Bit field size in bits for I2S_RCSR_FEIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCSR_FEIE field.
#define BR_I2S_RCSR_FEIE(x)  (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_FEIE))
#endif

//! @brief Format value for bitfield I2S_RCSR_FEIE.
#define BF_I2S_RCSR_FEIE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCSR_FEIE), uint32_t) & BM_I2S_RCSR_FEIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FEIE field to a new value.
#define BW_I2S_RCSR_FEIE(x, v) (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_FEIE) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCSR, field SEIE[11] (RW)
 *
 * Enables/disables sync error interrupts.
 *
 * Values:
 * - 0 - Disables interrupt.
 * - 1 - Enables interrupt.
 */
//@{
#define BP_I2S_RCSR_SEIE     (11U)         //!< Bit position for I2S_RCSR_SEIE.
#define BM_I2S_RCSR_SEIE     (0x00000800U) //!< Bit mask for I2S_RCSR_SEIE.
#define BS_I2S_RCSR_SEIE     (1U)          //!< Bit field size in bits for I2S_RCSR_SEIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCSR_SEIE field.
#define BR_I2S_RCSR_SEIE(x)  (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_SEIE))
#endif

//! @brief Format value for bitfield I2S_RCSR_SEIE.
#define BF_I2S_RCSR_SEIE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCSR_SEIE), uint32_t) & BM_I2S_RCSR_SEIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SEIE field to a new value.
#define BW_I2S_RCSR_SEIE(x, v) (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_SEIE) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCSR, field WSIE[12] (RW)
 *
 * Enables/disables word start interrupts.
 *
 * Values:
 * - 0 - Disables interrupt.
 * - 1 - Enables interrupt.
 */
//@{
#define BP_I2S_RCSR_WSIE     (12U)         //!< Bit position for I2S_RCSR_WSIE.
#define BM_I2S_RCSR_WSIE     (0x00001000U) //!< Bit mask for I2S_RCSR_WSIE.
#define BS_I2S_RCSR_WSIE     (1U)          //!< Bit field size in bits for I2S_RCSR_WSIE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCSR_WSIE field.
#define BR_I2S_RCSR_WSIE(x)  (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_WSIE))
#endif

//! @brief Format value for bitfield I2S_RCSR_WSIE.
#define BF_I2S_RCSR_WSIE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCSR_WSIE), uint32_t) & BM_I2S_RCSR_WSIE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WSIE field to a new value.
#define BW_I2S_RCSR_WSIE(x, v) (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_WSIE) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCSR, field FRF[16] (RO)
 *
 * Indicates that the number of words in an enabled receive channel FIFO is
 * greater than the receive FIFO watermark.
 *
 * Values:
 * - 0 - Receive FIFO watermark not reached.
 * - 1 - Receive FIFO watermark has been reached.
 */
//@{
#define BP_I2S_RCSR_FRF      (16U)         //!< Bit position for I2S_RCSR_FRF.
#define BM_I2S_RCSR_FRF      (0x00010000U) //!< Bit mask for I2S_RCSR_FRF.
#define BS_I2S_RCSR_FRF      (1U)          //!< Bit field size in bits for I2S_RCSR_FRF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCSR_FRF field.
#define BR_I2S_RCSR_FRF(x)   (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_FRF))
#endif
//@}

/*!
 * @name Register I2S_RCSR, field FWF[17] (RO)
 *
 * Indicates that an enabled receive FIFO is full.
 *
 * Values:
 * - 0 - No enabled receive FIFO is full.
 * - 1 - Enabled receive FIFO is full.
 */
//@{
#define BP_I2S_RCSR_FWF      (17U)         //!< Bit position for I2S_RCSR_FWF.
#define BM_I2S_RCSR_FWF      (0x00020000U) //!< Bit mask for I2S_RCSR_FWF.
#define BS_I2S_RCSR_FWF      (1U)          //!< Bit field size in bits for I2S_RCSR_FWF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCSR_FWF field.
#define BR_I2S_RCSR_FWF(x)   (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_FWF))
#endif
//@}

/*!
 * @name Register I2S_RCSR, field FEF[18] (W1C)
 *
 * Indicates that an enabled receive FIFO has overflowed. Write a logic 1 to
 * this field to clear this flag.
 *
 * Values:
 * - 0 - Receive overflow not detected.
 * - 1 - Receive overflow detected.
 */
//@{
#define BP_I2S_RCSR_FEF      (18U)         //!< Bit position for I2S_RCSR_FEF.
#define BM_I2S_RCSR_FEF      (0x00040000U) //!< Bit mask for I2S_RCSR_FEF.
#define BS_I2S_RCSR_FEF      (1U)          //!< Bit field size in bits for I2S_RCSR_FEF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCSR_FEF field.
#define BR_I2S_RCSR_FEF(x)   (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_FEF))
#endif

//! @brief Format value for bitfield I2S_RCSR_FEF.
#define BF_I2S_RCSR_FEF(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCSR_FEF), uint32_t) & BM_I2S_RCSR_FEF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FEF field to a new value.
#define BW_I2S_RCSR_FEF(x, v) (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_FEF) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCSR, field SEF[19] (W1C)
 *
 * Indicates that an error in the externally-generated frame sync has been
 * detected. Write a logic 1 to this field to clear this flag.
 *
 * Values:
 * - 0 - Sync error not detected.
 * - 1 - Frame sync error detected.
 */
//@{
#define BP_I2S_RCSR_SEF      (19U)         //!< Bit position for I2S_RCSR_SEF.
#define BM_I2S_RCSR_SEF      (0x00080000U) //!< Bit mask for I2S_RCSR_SEF.
#define BS_I2S_RCSR_SEF      (1U)          //!< Bit field size in bits for I2S_RCSR_SEF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCSR_SEF field.
#define BR_I2S_RCSR_SEF(x)   (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_SEF))
#endif

//! @brief Format value for bitfield I2S_RCSR_SEF.
#define BF_I2S_RCSR_SEF(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCSR_SEF), uint32_t) & BM_I2S_RCSR_SEF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SEF field to a new value.
#define BW_I2S_RCSR_SEF(x, v) (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_SEF) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCSR, field WSF[20] (W1C)
 *
 * Indicates that the start of the configured word has been detected. Write a
 * logic 1 to this field to clear this flag.
 *
 * Values:
 * - 0 - Start of word not detected.
 * - 1 - Start of word detected.
 */
//@{
#define BP_I2S_RCSR_WSF      (20U)         //!< Bit position for I2S_RCSR_WSF.
#define BM_I2S_RCSR_WSF      (0x00100000U) //!< Bit mask for I2S_RCSR_WSF.
#define BS_I2S_RCSR_WSF      (1U)          //!< Bit field size in bits for I2S_RCSR_WSF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCSR_WSF field.
#define BR_I2S_RCSR_WSF(x)   (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_WSF))
#endif

//! @brief Format value for bitfield I2S_RCSR_WSF.
#define BF_I2S_RCSR_WSF(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCSR_WSF), uint32_t) & BM_I2S_RCSR_WSF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WSF field to a new value.
#define BW_I2S_RCSR_WSF(x, v) (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_WSF) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCSR, field SR[24] (RW)
 *
 * Resets the internal receiver logic including the FIFO pointers.
 * Software-visible registers are not affected, except for the status registers.
 *
 * Values:
 * - 0 - No effect.
 * - 1 - Software reset.
 */
//@{
#define BP_I2S_RCSR_SR       (24U)         //!< Bit position for I2S_RCSR_SR.
#define BM_I2S_RCSR_SR       (0x01000000U) //!< Bit mask for I2S_RCSR_SR.
#define BS_I2S_RCSR_SR       (1U)          //!< Bit field size in bits for I2S_RCSR_SR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCSR_SR field.
#define BR_I2S_RCSR_SR(x)    (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_SR))
#endif

//! @brief Format value for bitfield I2S_RCSR_SR.
#define BF_I2S_RCSR_SR(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCSR_SR), uint32_t) & BM_I2S_RCSR_SR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SR field to a new value.
#define BW_I2S_RCSR_SR(x, v) (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_SR) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCSR, field FR[25] (WORZ)
 *
 * Resets the FIFO pointers. Reading this field will always return zero. FIFO
 * pointers should only be reset when the receiver is disabled or the FIFO error
 * flag is set.
 *
 * Values:
 * - 0 - No effect.
 * - 1 - FIFO reset.
 */
//@{
#define BP_I2S_RCSR_FR       (25U)         //!< Bit position for I2S_RCSR_FR.
#define BM_I2S_RCSR_FR       (0x02000000U) //!< Bit mask for I2S_RCSR_FR.
#define BS_I2S_RCSR_FR       (1U)          //!< Bit field size in bits for I2S_RCSR_FR.

//! @brief Format value for bitfield I2S_RCSR_FR.
#define BF_I2S_RCSR_FR(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCSR_FR), uint32_t) & BM_I2S_RCSR_FR)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FR field to a new value.
#define BW_I2S_RCSR_FR(x, v) (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_FR) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCSR, field BCE[28] (RW)
 *
 * Enables the receive bit clock, separately from RE. This field is
 * automatically set whenever RE is set. When software clears this field, the receive bit
 * clock remains enabled, and this field remains set, until the end of the current
 * frame.
 *
 * Values:
 * - 0 - Receive bit clock is disabled.
 * - 1 - Receive bit clock is enabled.
 */
//@{
#define BP_I2S_RCSR_BCE      (28U)         //!< Bit position for I2S_RCSR_BCE.
#define BM_I2S_RCSR_BCE      (0x10000000U) //!< Bit mask for I2S_RCSR_BCE.
#define BS_I2S_RCSR_BCE      (1U)          //!< Bit field size in bits for I2S_RCSR_BCE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCSR_BCE field.
#define BR_I2S_RCSR_BCE(x)   (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_BCE))
#endif

//! @brief Format value for bitfield I2S_RCSR_BCE.
#define BF_I2S_RCSR_BCE(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCSR_BCE), uint32_t) & BM_I2S_RCSR_BCE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BCE field to a new value.
#define BW_I2S_RCSR_BCE(x, v) (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_BCE) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCSR, field DBGE[29] (RW)
 *
 * Enables/disables receiver operation in Debug mode. The receive bit clock is
 * not affected by Debug mode.
 *
 * Values:
 * - 0 - Receiver is disabled in Debug mode, after completing the current frame.
 * - 1 - Receiver is enabled in Debug mode.
 */
//@{
#define BP_I2S_RCSR_DBGE     (29U)         //!< Bit position for I2S_RCSR_DBGE.
#define BM_I2S_RCSR_DBGE     (0x20000000U) //!< Bit mask for I2S_RCSR_DBGE.
#define BS_I2S_RCSR_DBGE     (1U)          //!< Bit field size in bits for I2S_RCSR_DBGE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCSR_DBGE field.
#define BR_I2S_RCSR_DBGE(x)  (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_DBGE))
#endif

//! @brief Format value for bitfield I2S_RCSR_DBGE.
#define BF_I2S_RCSR_DBGE(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCSR_DBGE), uint32_t) & BM_I2S_RCSR_DBGE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DBGE field to a new value.
#define BW_I2S_RCSR_DBGE(x, v) (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_DBGE) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCSR, field STOPE[30] (RW)
 *
 * Configures receiver operation in Stop mode. This bit is ignored and the
 * receiver is disabled in all low-leakage stop modes.
 *
 * Values:
 * - 0 - Receiver disabled in Stop mode.
 * - 1 - Receiver enabled in Stop mode.
 */
//@{
#define BP_I2S_RCSR_STOPE    (30U)         //!< Bit position for I2S_RCSR_STOPE.
#define BM_I2S_RCSR_STOPE    (0x40000000U) //!< Bit mask for I2S_RCSR_STOPE.
#define BS_I2S_RCSR_STOPE    (1U)          //!< Bit field size in bits for I2S_RCSR_STOPE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCSR_STOPE field.
#define BR_I2S_RCSR_STOPE(x) (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_STOPE))
#endif

//! @brief Format value for bitfield I2S_RCSR_STOPE.
#define BF_I2S_RCSR_STOPE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCSR_STOPE), uint32_t) & BM_I2S_RCSR_STOPE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the STOPE field to a new value.
#define BW_I2S_RCSR_STOPE(x, v) (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_STOPE) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCSR, field RE[31] (RW)
 *
 * Enables/disables the receiver. When software clears this field, the receiver
 * remains enabled, and this bit remains set, until the end of the current frame.
 *
 * Values:
 * - 0 - Receiver is disabled.
 * - 1 - Receiver is enabled, or receiver has been disabled and has not yet
 *     reached end of frame.
 */
//@{
#define BP_I2S_RCSR_RE       (31U)         //!< Bit position for I2S_RCSR_RE.
#define BM_I2S_RCSR_RE       (0x80000000U) //!< Bit mask for I2S_RCSR_RE.
#define BS_I2S_RCSR_RE       (1U)          //!< Bit field size in bits for I2S_RCSR_RE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCSR_RE field.
#define BR_I2S_RCSR_RE(x)    (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_RE))
#endif

//! @brief Format value for bitfield I2S_RCSR_RE.
#define BF_I2S_RCSR_RE(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCSR_RE), uint32_t) & BM_I2S_RCSR_RE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RE field to a new value.
#define BW_I2S_RCSR_RE(x, v) (BITBAND_ACCESS32(HW_I2S_RCSR_ADDR(x), BP_I2S_RCSR_RE) = (v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2S_RCR1 - SAI Receive Configuration 1 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2S_RCR1 - SAI Receive Configuration 1 Register (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_i2s_rcr1
{
    uint32_t U;
    struct _hw_i2s_rcr1_bitfields
    {
        uint32_t RFW : 3;              //!< [2:0] Receive FIFO Watermark
        uint32_t RESERVED0 : 29;       //!< [31:3]
    } B;
} hw_i2s_rcr1_t;
#endif

/*!
 * @name Constants and macros for entire I2S_RCR1 register
 */
//@{
#define HW_I2S_RCR1_ADDR(x)      (REGS_I2S_BASE(x) + 0x84U)

#ifndef __LANGUAGE_ASM__
#define HW_I2S_RCR1(x)           (*(__IO hw_i2s_rcr1_t *) HW_I2S_RCR1_ADDR(x))
#define HW_I2S_RCR1_RD(x)        (HW_I2S_RCR1(x).U)
#define HW_I2S_RCR1_WR(x, v)     (HW_I2S_RCR1(x).U = (v))
#define HW_I2S_RCR1_SET(x, v)    (HW_I2S_RCR1_WR(x, HW_I2S_RCR1_RD(x) |  (v)))
#define HW_I2S_RCR1_CLR(x, v)    (HW_I2S_RCR1_WR(x, HW_I2S_RCR1_RD(x) & ~(v)))
#define HW_I2S_RCR1_TOG(x, v)    (HW_I2S_RCR1_WR(x, HW_I2S_RCR1_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2S_RCR1 bitfields
 */

/*!
 * @name Register I2S_RCR1, field RFW[2:0] (RW)
 *
 * Configures the watermark level for all enabled receiver channels.
 */
//@{
#define BP_I2S_RCR1_RFW      (0U)          //!< Bit position for I2S_RCR1_RFW.
#define BM_I2S_RCR1_RFW      (0x00000007U) //!< Bit mask for I2S_RCR1_RFW.
#define BS_I2S_RCR1_RFW      (3U)          //!< Bit field size in bits for I2S_RCR1_RFW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCR1_RFW field.
#define BR_I2S_RCR1_RFW(x)   (HW_I2S_RCR1(x).B.RFW)
#endif

//! @brief Format value for bitfield I2S_RCR1_RFW.
#define BF_I2S_RCR1_RFW(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCR1_RFW), uint32_t) & BM_I2S_RCR1_RFW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RFW field to a new value.
#define BW_I2S_RCR1_RFW(x, v) (HW_I2S_RCR1_WR(x, (HW_I2S_RCR1_RD(x) & ~BM_I2S_RCR1_RFW) | BF_I2S_RCR1_RFW(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2S_RCR2 - SAI Receive Configuration 2 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2S_RCR2 - SAI Receive Configuration 2 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register must not be altered when RCSR[RE] is set.
 */
typedef union _hw_i2s_rcr2
{
    uint32_t U;
    struct _hw_i2s_rcr2_bitfields
    {
        uint32_t DIV : 8;              //!< [7:0] Bit Clock Divide
        uint32_t RESERVED0 : 16;       //!< [23:8]
        uint32_t BCD : 1;              //!< [24] Bit Clock Direction
        uint32_t BCP : 1;              //!< [25] Bit Clock Polarity
        uint32_t MSEL : 2;             //!< [27:26] MCLK Select
        uint32_t BCI : 1;              //!< [28] Bit Clock Input
        uint32_t BCS : 1;              //!< [29] Bit Clock Swap
        uint32_t SYNC : 2;             //!< [31:30] Synchronous Mode
    } B;
} hw_i2s_rcr2_t;
#endif

/*!
 * @name Constants and macros for entire I2S_RCR2 register
 */
//@{
#define HW_I2S_RCR2_ADDR(x)      (REGS_I2S_BASE(x) + 0x88U)

#ifndef __LANGUAGE_ASM__
#define HW_I2S_RCR2(x)           (*(__IO hw_i2s_rcr2_t *) HW_I2S_RCR2_ADDR(x))
#define HW_I2S_RCR2_RD(x)        (HW_I2S_RCR2(x).U)
#define HW_I2S_RCR2_WR(x, v)     (HW_I2S_RCR2(x).U = (v))
#define HW_I2S_RCR2_SET(x, v)    (HW_I2S_RCR2_WR(x, HW_I2S_RCR2_RD(x) |  (v)))
#define HW_I2S_RCR2_CLR(x, v)    (HW_I2S_RCR2_WR(x, HW_I2S_RCR2_RD(x) & ~(v)))
#define HW_I2S_RCR2_TOG(x, v)    (HW_I2S_RCR2_WR(x, HW_I2S_RCR2_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2S_RCR2 bitfields
 */

/*!
 * @name Register I2S_RCR2, field DIV[7:0] (RW)
 *
 * Divides down the audio master clock to generate the bit clock when configured
 * for an internal bit clock. The division value is (DIV + 1) * 2.
 */
//@{
#define BP_I2S_RCR2_DIV      (0U)          //!< Bit position for I2S_RCR2_DIV.
#define BM_I2S_RCR2_DIV      (0x000000FFU) //!< Bit mask for I2S_RCR2_DIV.
#define BS_I2S_RCR2_DIV      (8U)          //!< Bit field size in bits for I2S_RCR2_DIV.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCR2_DIV field.
#define BR_I2S_RCR2_DIV(x)   (HW_I2S_RCR2(x).B.DIV)
#endif

//! @brief Format value for bitfield I2S_RCR2_DIV.
#define BF_I2S_RCR2_DIV(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCR2_DIV), uint32_t) & BM_I2S_RCR2_DIV)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DIV field to a new value.
#define BW_I2S_RCR2_DIV(x, v) (HW_I2S_RCR2_WR(x, (HW_I2S_RCR2_RD(x) & ~BM_I2S_RCR2_DIV) | BF_I2S_RCR2_DIV(v)))
#endif
//@}

/*!
 * @name Register I2S_RCR2, field BCD[24] (RW)
 *
 * Configures the direction of the bit clock.
 *
 * Values:
 * - 0 - Bit clock is generated externally in Slave mode.
 * - 1 - Bit clock is generated internally in Master mode.
 */
//@{
#define BP_I2S_RCR2_BCD      (24U)         //!< Bit position for I2S_RCR2_BCD.
#define BM_I2S_RCR2_BCD      (0x01000000U) //!< Bit mask for I2S_RCR2_BCD.
#define BS_I2S_RCR2_BCD      (1U)          //!< Bit field size in bits for I2S_RCR2_BCD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCR2_BCD field.
#define BR_I2S_RCR2_BCD(x)   (BITBAND_ACCESS32(HW_I2S_RCR2_ADDR(x), BP_I2S_RCR2_BCD))
#endif

//! @brief Format value for bitfield I2S_RCR2_BCD.
#define BF_I2S_RCR2_BCD(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCR2_BCD), uint32_t) & BM_I2S_RCR2_BCD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BCD field to a new value.
#define BW_I2S_RCR2_BCD(x, v) (BITBAND_ACCESS32(HW_I2S_RCR2_ADDR(x), BP_I2S_RCR2_BCD) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCR2, field BCP[25] (RW)
 *
 * Configures the polarity of the bit clock.
 *
 * Values:
 * - 0 - Bit Clock is active high with drive outputs on rising edge and sample
 *     inputs on falling edge.
 * - 1 - Bit Clock is active low with drive outputs on falling edge and sample
 *     inputs on rising edge.
 */
//@{
#define BP_I2S_RCR2_BCP      (25U)         //!< Bit position for I2S_RCR2_BCP.
#define BM_I2S_RCR2_BCP      (0x02000000U) //!< Bit mask for I2S_RCR2_BCP.
#define BS_I2S_RCR2_BCP      (1U)          //!< Bit field size in bits for I2S_RCR2_BCP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCR2_BCP field.
#define BR_I2S_RCR2_BCP(x)   (BITBAND_ACCESS32(HW_I2S_RCR2_ADDR(x), BP_I2S_RCR2_BCP))
#endif

//! @brief Format value for bitfield I2S_RCR2_BCP.
#define BF_I2S_RCR2_BCP(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCR2_BCP), uint32_t) & BM_I2S_RCR2_BCP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BCP field to a new value.
#define BW_I2S_RCR2_BCP(x, v) (BITBAND_ACCESS32(HW_I2S_RCR2_ADDR(x), BP_I2S_RCR2_BCP) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCR2, field MSEL[27:26] (RW)
 *
 * Selects the audio Master Clock option used to generate an internally
 * generated bit clock. This field has no effect when configured for an externally
 * generated bit clock. Depending on the device, some Master Clock options might not be
 * available. See the chip configuration details for the availability and
 * chip-specific meaning of each option.
 *
 * Values:
 * - 00 - Bus Clock selected.
 * - 01 - Master Clock (MCLK) 1 option selected.
 * - 10 - Master Clock (MCLK) 2 option selected.
 * - 11 - Master Clock (MCLK) 3 option selected.
 */
//@{
#define BP_I2S_RCR2_MSEL     (26U)         //!< Bit position for I2S_RCR2_MSEL.
#define BM_I2S_RCR2_MSEL     (0x0C000000U) //!< Bit mask for I2S_RCR2_MSEL.
#define BS_I2S_RCR2_MSEL     (2U)          //!< Bit field size in bits for I2S_RCR2_MSEL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCR2_MSEL field.
#define BR_I2S_RCR2_MSEL(x)  (HW_I2S_RCR2(x).B.MSEL)
#endif

//! @brief Format value for bitfield I2S_RCR2_MSEL.
#define BF_I2S_RCR2_MSEL(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCR2_MSEL), uint32_t) & BM_I2S_RCR2_MSEL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MSEL field to a new value.
#define BW_I2S_RCR2_MSEL(x, v) (HW_I2S_RCR2_WR(x, (HW_I2S_RCR2_RD(x) & ~BM_I2S_RCR2_MSEL) | BF_I2S_RCR2_MSEL(v)))
#endif
//@}

/*!
 * @name Register I2S_RCR2, field BCI[28] (RW)
 *
 * When this field is set and using an internally generated bit clock in either
 * synchronous or asynchronous mode, the bit clock actually used by the receiver
 * is delayed by the pad output delay (the receiver is clocked by the pad input
 * as if the clock was externally generated). This has the effect of decreasing
 * the data input setup time, but increasing the data output valid time. The slave
 * mode timing from the datasheet should be used for the receiver when this bit
 * is set. In synchronous mode, this bit allows the receiver to use the slave mode
 * timing from the datasheet, while the transmitter uses the master mode timing.
 * This field has no effect when configured for an externally generated bit
 * clock or when synchronous to another SAI peripheral .
 *
 * Values:
 * - 0 - No effect.
 * - 1 - Internal logic is clocked as if bit clock was externally generated.
 */
//@{
#define BP_I2S_RCR2_BCI      (28U)         //!< Bit position for I2S_RCR2_BCI.
#define BM_I2S_RCR2_BCI      (0x10000000U) //!< Bit mask for I2S_RCR2_BCI.
#define BS_I2S_RCR2_BCI      (1U)          //!< Bit field size in bits for I2S_RCR2_BCI.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCR2_BCI field.
#define BR_I2S_RCR2_BCI(x)   (BITBAND_ACCESS32(HW_I2S_RCR2_ADDR(x), BP_I2S_RCR2_BCI))
#endif

//! @brief Format value for bitfield I2S_RCR2_BCI.
#define BF_I2S_RCR2_BCI(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCR2_BCI), uint32_t) & BM_I2S_RCR2_BCI)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BCI field to a new value.
#define BW_I2S_RCR2_BCI(x, v) (BITBAND_ACCESS32(HW_I2S_RCR2_ADDR(x), BP_I2S_RCR2_BCI) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCR2, field BCS[29] (RW)
 *
 * This field swaps the bit clock used by the receiver. When the receiver is
 * configured in asynchronous mode and this bit is set, the receiver is clocked by
 * the transmitter bit clock (SAI_TX_BCLK). This allows the transmitter and
 * receiver to share the same bit clock, but the receiver continues to use the receiver
 * frame sync (SAI_RX_SYNC). When the receiver is configured in synchronous
 * mode, the transmitter BCS field and receiver BCS field must be set to the same
 * value. When both are set, the transmitter and receiver are both clocked by the
 * receiver bit clock (SAI_RX_BCLK) but use the transmitter frame sync
 * (SAI_TX_SYNC). This field has no effect when synchronous to another SAI peripheral.
 *
 * Values:
 * - 0 - Use the normal bit clock source.
 * - 1 - Swap the bit clock source.
 */
//@{
#define BP_I2S_RCR2_BCS      (29U)         //!< Bit position for I2S_RCR2_BCS.
#define BM_I2S_RCR2_BCS      (0x20000000U) //!< Bit mask for I2S_RCR2_BCS.
#define BS_I2S_RCR2_BCS      (1U)          //!< Bit field size in bits for I2S_RCR2_BCS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCR2_BCS field.
#define BR_I2S_RCR2_BCS(x)   (BITBAND_ACCESS32(HW_I2S_RCR2_ADDR(x), BP_I2S_RCR2_BCS))
#endif

//! @brief Format value for bitfield I2S_RCR2_BCS.
#define BF_I2S_RCR2_BCS(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCR2_BCS), uint32_t) & BM_I2S_RCR2_BCS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the BCS field to a new value.
#define BW_I2S_RCR2_BCS(x, v) (BITBAND_ACCESS32(HW_I2S_RCR2_ADDR(x), BP_I2S_RCR2_BCS) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCR2, field SYNC[31:30] (RW)
 *
 * Configures between asynchronous and synchronous modes of operation. When
 * configured for a synchronous mode of operation, the transmitter or other SAI
 * peripheral must be configured for asynchronous operation.
 *
 * Values:
 * - 00 - Asynchronous mode.
 * - 01 - Synchronous with transmitter.
 * - 10 - Synchronous with another SAI receiver.
 * - 11 - Synchronous with another SAI transmitter.
 */
//@{
#define BP_I2S_RCR2_SYNC     (30U)         //!< Bit position for I2S_RCR2_SYNC.
#define BM_I2S_RCR2_SYNC     (0xC0000000U) //!< Bit mask for I2S_RCR2_SYNC.
#define BS_I2S_RCR2_SYNC     (2U)          //!< Bit field size in bits for I2S_RCR2_SYNC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCR2_SYNC field.
#define BR_I2S_RCR2_SYNC(x)  (HW_I2S_RCR2(x).B.SYNC)
#endif

//! @brief Format value for bitfield I2S_RCR2_SYNC.
#define BF_I2S_RCR2_SYNC(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCR2_SYNC), uint32_t) & BM_I2S_RCR2_SYNC)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SYNC field to a new value.
#define BW_I2S_RCR2_SYNC(x, v) (HW_I2S_RCR2_WR(x, (HW_I2S_RCR2_RD(x) & ~BM_I2S_RCR2_SYNC) | BF_I2S_RCR2_SYNC(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2S_RCR3 - SAI Receive Configuration 3 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2S_RCR3 - SAI Receive Configuration 3 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register must not be altered when RCSR[RE] is set.
 */
typedef union _hw_i2s_rcr3
{
    uint32_t U;
    struct _hw_i2s_rcr3_bitfields
    {
        uint32_t WDFL : 5;             //!< [4:0] Word Flag Configuration
        uint32_t RESERVED0 : 11;       //!< [15:5]
        uint32_t RCE : 2;              //!< [17:16] Receive Channel Enable
        uint32_t RESERVED1 : 14;       //!< [31:18]
    } B;
} hw_i2s_rcr3_t;
#endif

/*!
 * @name Constants and macros for entire I2S_RCR3 register
 */
//@{
#define HW_I2S_RCR3_ADDR(x)      (REGS_I2S_BASE(x) + 0x8CU)

#ifndef __LANGUAGE_ASM__
#define HW_I2S_RCR3(x)           (*(__IO hw_i2s_rcr3_t *) HW_I2S_RCR3_ADDR(x))
#define HW_I2S_RCR3_RD(x)        (HW_I2S_RCR3(x).U)
#define HW_I2S_RCR3_WR(x, v)     (HW_I2S_RCR3(x).U = (v))
#define HW_I2S_RCR3_SET(x, v)    (HW_I2S_RCR3_WR(x, HW_I2S_RCR3_RD(x) |  (v)))
#define HW_I2S_RCR3_CLR(x, v)    (HW_I2S_RCR3_WR(x, HW_I2S_RCR3_RD(x) & ~(v)))
#define HW_I2S_RCR3_TOG(x, v)    (HW_I2S_RCR3_WR(x, HW_I2S_RCR3_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2S_RCR3 bitfields
 */

/*!
 * @name Register I2S_RCR3, field WDFL[4:0] (RW)
 *
 * Configures which word the start of word flag is set. The value written should
 * be one less than the word number (for example, write zero to configure for
 * the first word in the frame). When configured to a value greater than the Frame
 * Size field, then the start of word flag is never set.
 */
//@{
#define BP_I2S_RCR3_WDFL     (0U)          //!< Bit position for I2S_RCR3_WDFL.
#define BM_I2S_RCR3_WDFL     (0x0000001FU) //!< Bit mask for I2S_RCR3_WDFL.
#define BS_I2S_RCR3_WDFL     (5U)          //!< Bit field size in bits for I2S_RCR3_WDFL.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCR3_WDFL field.
#define BR_I2S_RCR3_WDFL(x)  (HW_I2S_RCR3(x).B.WDFL)
#endif

//! @brief Format value for bitfield I2S_RCR3_WDFL.
#define BF_I2S_RCR3_WDFL(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCR3_WDFL), uint32_t) & BM_I2S_RCR3_WDFL)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WDFL field to a new value.
#define BW_I2S_RCR3_WDFL(x, v) (HW_I2S_RCR3_WR(x, (HW_I2S_RCR3_RD(x) & ~BM_I2S_RCR3_WDFL) | BF_I2S_RCR3_WDFL(v)))
#endif
//@}

/*!
 * @name Register I2S_RCR3, field RCE[17:16] (RW)
 *
 * Enables the corresponding data channel for receive operation. A channel must
 * be enabled before its FIFO is accessed.
 *
 * Values:
 * - 0 - Receive data channel N is disabled.
 * - 1 - Receive data channel N is enabled.
 */
//@{
#define BP_I2S_RCR3_RCE      (16U)         //!< Bit position for I2S_RCR3_RCE.
#define BM_I2S_RCR3_RCE      (0x00030000U) //!< Bit mask for I2S_RCR3_RCE.
#define BS_I2S_RCR3_RCE      (2U)          //!< Bit field size in bits for I2S_RCR3_RCE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCR3_RCE field.
#define BR_I2S_RCR3_RCE(x)   (HW_I2S_RCR3(x).B.RCE)
#endif

//! @brief Format value for bitfield I2S_RCR3_RCE.
#define BF_I2S_RCR3_RCE(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCR3_RCE), uint32_t) & BM_I2S_RCR3_RCE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RCE field to a new value.
#define BW_I2S_RCR3_RCE(x, v) (HW_I2S_RCR3_WR(x, (HW_I2S_RCR3_RD(x) & ~BM_I2S_RCR3_RCE) | BF_I2S_RCR3_RCE(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2S_RCR4 - SAI Receive Configuration 4 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2S_RCR4 - SAI Receive Configuration 4 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register must not be altered when RCSR[RE] is set.
 */
typedef union _hw_i2s_rcr4
{
    uint32_t U;
    struct _hw_i2s_rcr4_bitfields
    {
        uint32_t FSD : 1;              //!< [0] Frame Sync Direction
        uint32_t FSP : 1;              //!< [1] Frame Sync Polarity
        uint32_t RESERVED0 : 1;        //!< [2]
        uint32_t FSE : 1;              //!< [3] Frame Sync Early
        uint32_t MF : 1;               //!< [4] MSB First
        uint32_t RESERVED1 : 3;        //!< [7:5]
        uint32_t SYWD : 5;             //!< [12:8] Sync Width
        uint32_t RESERVED2 : 3;        //!< [15:13]
        uint32_t FRSZ : 5;             //!< [20:16] Frame Size
        uint32_t RESERVED3 : 11;       //!< [31:21]
    } B;
} hw_i2s_rcr4_t;
#endif

/*!
 * @name Constants and macros for entire I2S_RCR4 register
 */
//@{
#define HW_I2S_RCR4_ADDR(x)      (REGS_I2S_BASE(x) + 0x90U)

#ifndef __LANGUAGE_ASM__
#define HW_I2S_RCR4(x)           (*(__IO hw_i2s_rcr4_t *) HW_I2S_RCR4_ADDR(x))
#define HW_I2S_RCR4_RD(x)        (HW_I2S_RCR4(x).U)
#define HW_I2S_RCR4_WR(x, v)     (HW_I2S_RCR4(x).U = (v))
#define HW_I2S_RCR4_SET(x, v)    (HW_I2S_RCR4_WR(x, HW_I2S_RCR4_RD(x) |  (v)))
#define HW_I2S_RCR4_CLR(x, v)    (HW_I2S_RCR4_WR(x, HW_I2S_RCR4_RD(x) & ~(v)))
#define HW_I2S_RCR4_TOG(x, v)    (HW_I2S_RCR4_WR(x, HW_I2S_RCR4_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2S_RCR4 bitfields
 */

/*!
 * @name Register I2S_RCR4, field FSD[0] (RW)
 *
 * Configures the direction of the frame sync.
 *
 * Values:
 * - 0 - Frame Sync is generated externally in Slave mode.
 * - 1 - Frame Sync is generated internally in Master mode.
 */
//@{
#define BP_I2S_RCR4_FSD      (0U)          //!< Bit position for I2S_RCR4_FSD.
#define BM_I2S_RCR4_FSD      (0x00000001U) //!< Bit mask for I2S_RCR4_FSD.
#define BS_I2S_RCR4_FSD      (1U)          //!< Bit field size in bits for I2S_RCR4_FSD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCR4_FSD field.
#define BR_I2S_RCR4_FSD(x)   (BITBAND_ACCESS32(HW_I2S_RCR4_ADDR(x), BP_I2S_RCR4_FSD))
#endif

//! @brief Format value for bitfield I2S_RCR4_FSD.
#define BF_I2S_RCR4_FSD(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCR4_FSD), uint32_t) & BM_I2S_RCR4_FSD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FSD field to a new value.
#define BW_I2S_RCR4_FSD(x, v) (BITBAND_ACCESS32(HW_I2S_RCR4_ADDR(x), BP_I2S_RCR4_FSD) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCR4, field FSP[1] (RW)
 *
 * Configures the polarity of the frame sync.
 *
 * Values:
 * - 0 - Frame sync is active high.
 * - 1 - Frame sync is active low.
 */
//@{
#define BP_I2S_RCR4_FSP      (1U)          //!< Bit position for I2S_RCR4_FSP.
#define BM_I2S_RCR4_FSP      (0x00000002U) //!< Bit mask for I2S_RCR4_FSP.
#define BS_I2S_RCR4_FSP      (1U)          //!< Bit field size in bits for I2S_RCR4_FSP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCR4_FSP field.
#define BR_I2S_RCR4_FSP(x)   (BITBAND_ACCESS32(HW_I2S_RCR4_ADDR(x), BP_I2S_RCR4_FSP))
#endif

//! @brief Format value for bitfield I2S_RCR4_FSP.
#define BF_I2S_RCR4_FSP(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCR4_FSP), uint32_t) & BM_I2S_RCR4_FSP)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FSP field to a new value.
#define BW_I2S_RCR4_FSP(x, v) (BITBAND_ACCESS32(HW_I2S_RCR4_ADDR(x), BP_I2S_RCR4_FSP) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCR4, field FSE[3] (RW)
 *
 * Values:
 * - 0 - Frame sync asserts with the first bit of the frame.
 * - 1 - Frame sync asserts one bit before the first bit of the frame.
 */
//@{
#define BP_I2S_RCR4_FSE      (3U)          //!< Bit position for I2S_RCR4_FSE.
#define BM_I2S_RCR4_FSE      (0x00000008U) //!< Bit mask for I2S_RCR4_FSE.
#define BS_I2S_RCR4_FSE      (1U)          //!< Bit field size in bits for I2S_RCR4_FSE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCR4_FSE field.
#define BR_I2S_RCR4_FSE(x)   (BITBAND_ACCESS32(HW_I2S_RCR4_ADDR(x), BP_I2S_RCR4_FSE))
#endif

//! @brief Format value for bitfield I2S_RCR4_FSE.
#define BF_I2S_RCR4_FSE(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCR4_FSE), uint32_t) & BM_I2S_RCR4_FSE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FSE field to a new value.
#define BW_I2S_RCR4_FSE(x, v) (BITBAND_ACCESS32(HW_I2S_RCR4_ADDR(x), BP_I2S_RCR4_FSE) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCR4, field MF[4] (RW)
 *
 * Configures whether the LSB or the MSB is received first.
 *
 * Values:
 * - 0 - LSB is received first.
 * - 1 - MSB is received first.
 */
//@{
#define BP_I2S_RCR4_MF       (4U)          //!< Bit position for I2S_RCR4_MF.
#define BM_I2S_RCR4_MF       (0x00000010U) //!< Bit mask for I2S_RCR4_MF.
#define BS_I2S_RCR4_MF       (1U)          //!< Bit field size in bits for I2S_RCR4_MF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCR4_MF field.
#define BR_I2S_RCR4_MF(x)    (BITBAND_ACCESS32(HW_I2S_RCR4_ADDR(x), BP_I2S_RCR4_MF))
#endif

//! @brief Format value for bitfield I2S_RCR4_MF.
#define BF_I2S_RCR4_MF(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCR4_MF), uint32_t) & BM_I2S_RCR4_MF)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MF field to a new value.
#define BW_I2S_RCR4_MF(x, v) (BITBAND_ACCESS32(HW_I2S_RCR4_ADDR(x), BP_I2S_RCR4_MF) = (v))
#endif
//@}

/*!
 * @name Register I2S_RCR4, field SYWD[12:8] (RW)
 *
 * Configures the length of the frame sync in number of bit clocks. The value
 * written must be one less than the number of bit clocks. For example, write 0 for
 * the frame sync to assert for one bit clock only. The sync width cannot be
 * configured longer than the first word of the frame.
 */
//@{
#define BP_I2S_RCR4_SYWD     (8U)          //!< Bit position for I2S_RCR4_SYWD.
#define BM_I2S_RCR4_SYWD     (0x00001F00U) //!< Bit mask for I2S_RCR4_SYWD.
#define BS_I2S_RCR4_SYWD     (5U)          //!< Bit field size in bits for I2S_RCR4_SYWD.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCR4_SYWD field.
#define BR_I2S_RCR4_SYWD(x)  (HW_I2S_RCR4(x).B.SYWD)
#endif

//! @brief Format value for bitfield I2S_RCR4_SYWD.
#define BF_I2S_RCR4_SYWD(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCR4_SYWD), uint32_t) & BM_I2S_RCR4_SYWD)

#ifndef __LANGUAGE_ASM__
//! @brief Set the SYWD field to a new value.
#define BW_I2S_RCR4_SYWD(x, v) (HW_I2S_RCR4_WR(x, (HW_I2S_RCR4_RD(x) & ~BM_I2S_RCR4_SYWD) | BF_I2S_RCR4_SYWD(v)))
#endif
//@}

/*!
 * @name Register I2S_RCR4, field FRSZ[20:16] (RW)
 *
 * Configures the number of words in each frame. The value written must be one
 * less than the number of words in the frame. For example, write 0 for one word
 * per frame. The maximum supported frame size is 32 words.
 */
//@{
#define BP_I2S_RCR4_FRSZ     (16U)         //!< Bit position for I2S_RCR4_FRSZ.
#define BM_I2S_RCR4_FRSZ     (0x001F0000U) //!< Bit mask for I2S_RCR4_FRSZ.
#define BS_I2S_RCR4_FRSZ     (5U)          //!< Bit field size in bits for I2S_RCR4_FRSZ.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCR4_FRSZ field.
#define BR_I2S_RCR4_FRSZ(x)  (HW_I2S_RCR4(x).B.FRSZ)
#endif

//! @brief Format value for bitfield I2S_RCR4_FRSZ.
#define BF_I2S_RCR4_FRSZ(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCR4_FRSZ), uint32_t) & BM_I2S_RCR4_FRSZ)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FRSZ field to a new value.
#define BW_I2S_RCR4_FRSZ(x, v) (HW_I2S_RCR4_WR(x, (HW_I2S_RCR4_RD(x) & ~BM_I2S_RCR4_FRSZ) | BF_I2S_RCR4_FRSZ(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2S_RCR5 - SAI Receive Configuration 5 Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2S_RCR5 - SAI Receive Configuration 5 Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register must not be altered when RCSR[RE] is set.
 */
typedef union _hw_i2s_rcr5
{
    uint32_t U;
    struct _hw_i2s_rcr5_bitfields
    {
        uint32_t RESERVED0 : 8;        //!< [7:0]
        uint32_t FBT : 5;              //!< [12:8] First Bit Shifted
        uint32_t RESERVED1 : 3;        //!< [15:13]
        uint32_t W0W : 5;              //!< [20:16] Word 0 Width
        uint32_t RESERVED2 : 3;        //!< [23:21]
        uint32_t WNW : 5;              //!< [28:24] Word N Width
        uint32_t RESERVED3 : 3;        //!< [31:29]
    } B;
} hw_i2s_rcr5_t;
#endif

/*!
 * @name Constants and macros for entire I2S_RCR5 register
 */
//@{
#define HW_I2S_RCR5_ADDR(x)      (REGS_I2S_BASE(x) + 0x94U)

#ifndef __LANGUAGE_ASM__
#define HW_I2S_RCR5(x)           (*(__IO hw_i2s_rcr5_t *) HW_I2S_RCR5_ADDR(x))
#define HW_I2S_RCR5_RD(x)        (HW_I2S_RCR5(x).U)
#define HW_I2S_RCR5_WR(x, v)     (HW_I2S_RCR5(x).U = (v))
#define HW_I2S_RCR5_SET(x, v)    (HW_I2S_RCR5_WR(x, HW_I2S_RCR5_RD(x) |  (v)))
#define HW_I2S_RCR5_CLR(x, v)    (HW_I2S_RCR5_WR(x, HW_I2S_RCR5_RD(x) & ~(v)))
#define HW_I2S_RCR5_TOG(x, v)    (HW_I2S_RCR5_WR(x, HW_I2S_RCR5_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2S_RCR5 bitfields
 */

/*!
 * @name Register I2S_RCR5, field FBT[12:8] (RW)
 *
 * Configures the bit index for the first bit received for each word in the
 * frame. If configured for MSB First, the index of the next bit received is one less
 * than the current bit received. If configured for LSB First, the index of the
 * next bit received is one more than the current bit received. The value written
 * must be greater than or equal to the word width when configured for MSB
 * First. The value written must be less than or equal to 31-word width when
 * configured for LSB First.
 */
//@{
#define BP_I2S_RCR5_FBT      (8U)          //!< Bit position for I2S_RCR5_FBT.
#define BM_I2S_RCR5_FBT      (0x00001F00U) //!< Bit mask for I2S_RCR5_FBT.
#define BS_I2S_RCR5_FBT      (5U)          //!< Bit field size in bits for I2S_RCR5_FBT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCR5_FBT field.
#define BR_I2S_RCR5_FBT(x)   (HW_I2S_RCR5(x).B.FBT)
#endif

//! @brief Format value for bitfield I2S_RCR5_FBT.
#define BF_I2S_RCR5_FBT(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCR5_FBT), uint32_t) & BM_I2S_RCR5_FBT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FBT field to a new value.
#define BW_I2S_RCR5_FBT(x, v) (HW_I2S_RCR5_WR(x, (HW_I2S_RCR5_RD(x) & ~BM_I2S_RCR5_FBT) | BF_I2S_RCR5_FBT(v)))
#endif
//@}

/*!
 * @name Register I2S_RCR5, field W0W[20:16] (RW)
 *
 * Configures the number of bits in the first word in each frame. The value
 * written must be one less than the number of bits in the first word. Word width of
 * less than 8 bits is not supported if there is only one word per frame.
 */
//@{
#define BP_I2S_RCR5_W0W      (16U)         //!< Bit position for I2S_RCR5_W0W.
#define BM_I2S_RCR5_W0W      (0x001F0000U) //!< Bit mask for I2S_RCR5_W0W.
#define BS_I2S_RCR5_W0W      (5U)          //!< Bit field size in bits for I2S_RCR5_W0W.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCR5_W0W field.
#define BR_I2S_RCR5_W0W(x)   (HW_I2S_RCR5(x).B.W0W)
#endif

//! @brief Format value for bitfield I2S_RCR5_W0W.
#define BF_I2S_RCR5_W0W(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCR5_W0W), uint32_t) & BM_I2S_RCR5_W0W)

#ifndef __LANGUAGE_ASM__
//! @brief Set the W0W field to a new value.
#define BW_I2S_RCR5_W0W(x, v) (HW_I2S_RCR5_WR(x, (HW_I2S_RCR5_RD(x) & ~BM_I2S_RCR5_W0W) | BF_I2S_RCR5_W0W(v)))
#endif
//@}

/*!
 * @name Register I2S_RCR5, field WNW[28:24] (RW)
 *
 * Configures the number of bits in each word, for each word except the first in
 * the frame. The value written must be one less than the number of bits per
 * word. Word width of less than 8 bits is not supported.
 */
//@{
#define BP_I2S_RCR5_WNW      (24U)         //!< Bit position for I2S_RCR5_WNW.
#define BM_I2S_RCR5_WNW      (0x1F000000U) //!< Bit mask for I2S_RCR5_WNW.
#define BS_I2S_RCR5_WNW      (5U)          //!< Bit field size in bits for I2S_RCR5_WNW.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RCR5_WNW field.
#define BR_I2S_RCR5_WNW(x)   (HW_I2S_RCR5(x).B.WNW)
#endif

//! @brief Format value for bitfield I2S_RCR5_WNW.
#define BF_I2S_RCR5_WNW(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RCR5_WNW), uint32_t) & BM_I2S_RCR5_WNW)

#ifndef __LANGUAGE_ASM__
//! @brief Set the WNW field to a new value.
#define BW_I2S_RCR5_WNW(x, v) (HW_I2S_RCR5_WR(x, (HW_I2S_RCR5_RD(x) & ~BM_I2S_RCR5_WNW) | BF_I2S_RCR5_WNW(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2S_RDRn - SAI Receive Data Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2S_RDRn - SAI Receive Data Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * Reading this register introduces one additional peripheral clock wait state
 * on each read.
 */
typedef union _hw_i2s_rdrn
{
    uint32_t U;
    struct _hw_i2s_rdrn_bitfields
    {
        uint32_t RDR : 32;             //!< [31:0] Receive Data Register
    } B;
} hw_i2s_rdrn_t;
#endif

/*!
 * @name Constants and macros for entire I2S_RDRn register
 */
//@{
#define HW_I2S_RDRn_COUNT (2U)

#define HW_I2S_RDRn_ADDR(x, n)   (REGS_I2S_BASE(x) + 0xA0U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_I2S_RDRn(x, n)        (*(__I hw_i2s_rdrn_t *) HW_I2S_RDRn_ADDR(x, n))
#define HW_I2S_RDRn_RD(x, n)     (HW_I2S_RDRn(x, n).U)
#endif
//@}

/*
 * Constants & macros for individual I2S_RDRn bitfields
 */

/*!
 * @name Register I2S_RDRn, field RDR[31:0] (RO)
 *
 * The corresponding RCR3[RCE] bit must be set before accessing the channel's
 * receive data register. Reads from this register when the receive FIFO is not
 * empty will return the data from the top of the receive FIFO. Reads from this
 * register when the receive FIFO is empty are ignored.
 */
//@{
#define BP_I2S_RDRn_RDR      (0U)          //!< Bit position for I2S_RDRn_RDR.
#define BM_I2S_RDRn_RDR      (0xFFFFFFFFU) //!< Bit mask for I2S_RDRn_RDR.
#define BS_I2S_RDRn_RDR      (32U)         //!< Bit field size in bits for I2S_RDRn_RDR.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RDRn_RDR field.
#define BR_I2S_RDRn_RDR(x, n) (HW_I2S_RDRn(x, n).U)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2S_RFRn - SAI Receive FIFO Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2S_RFRn - SAI Receive FIFO Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The MSB of the read and write pointers is used to distinguish between FIFO
 * full and empty conditions. If the read and write pointers are identical, then
 * the FIFO is empty. If the read and write pointers are identical except for the
 * MSB, then the FIFO is full.
 */
typedef union _hw_i2s_rfrn
{
    uint32_t U;
    struct _hw_i2s_rfrn_bitfields
    {
        uint32_t RFP : 4;              //!< [3:0] Read FIFO Pointer
        uint32_t RESERVED0 : 12;       //!< [15:4]
        uint32_t WFP : 4;              //!< [19:16] Write FIFO Pointer
        uint32_t RESERVED1 : 12;       //!< [31:20]
    } B;
} hw_i2s_rfrn_t;
#endif

/*!
 * @name Constants and macros for entire I2S_RFRn register
 */
//@{
#define HW_I2S_RFRn_COUNT (2U)

#define HW_I2S_RFRn_ADDR(x, n)   (REGS_I2S_BASE(x) + 0xC0U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_I2S_RFRn(x, n)        (*(__I hw_i2s_rfrn_t *) HW_I2S_RFRn_ADDR(x, n))
#define HW_I2S_RFRn_RD(x, n)     (HW_I2S_RFRn(x, n).U)
#endif
//@}

/*
 * Constants & macros for individual I2S_RFRn bitfields
 */

/*!
 * @name Register I2S_RFRn, field RFP[3:0] (RO)
 *
 * FIFO read pointer for receive data channel.
 */
//@{
#define BP_I2S_RFRn_RFP      (0U)          //!< Bit position for I2S_RFRn_RFP.
#define BM_I2S_RFRn_RFP      (0x0000000FU) //!< Bit mask for I2S_RFRn_RFP.
#define BS_I2S_RFRn_RFP      (4U)          //!< Bit field size in bits for I2S_RFRn_RFP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RFRn_RFP field.
#define BR_I2S_RFRn_RFP(x, n) (HW_I2S_RFRn(x, n).B.RFP)
#endif
//@}

/*!
 * @name Register I2S_RFRn, field WFP[19:16] (RO)
 *
 * FIFO write pointer for receive data channel.
 */
//@{
#define BP_I2S_RFRn_WFP      (16U)         //!< Bit position for I2S_RFRn_WFP.
#define BM_I2S_RFRn_WFP      (0x000F0000U) //!< Bit mask for I2S_RFRn_WFP.
#define BS_I2S_RFRn_WFP      (4U)          //!< Bit field size in bits for I2S_RFRn_WFP.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RFRn_WFP field.
#define BR_I2S_RFRn_WFP(x, n) (HW_I2S_RFRn(x, n).B.WFP)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2S_RMR - SAI Receive Mask Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2S_RMR - SAI Receive Mask Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register is double-buffered and updates: When RCSR[RE] is first set At
 * the end of each frame This allows the masked words in each frame to change from
 * frame to frame.
 */
typedef union _hw_i2s_rmr
{
    uint32_t U;
    struct _hw_i2s_rmr_bitfields
    {
        uint32_t RWM : 32;             //!< [31:0] Receive Word Mask
    } B;
} hw_i2s_rmr_t;
#endif

/*!
 * @name Constants and macros for entire I2S_RMR register
 */
//@{
#define HW_I2S_RMR_ADDR(x)       (REGS_I2S_BASE(x) + 0xE0U)

#ifndef __LANGUAGE_ASM__
#define HW_I2S_RMR(x)            (*(__IO hw_i2s_rmr_t *) HW_I2S_RMR_ADDR(x))
#define HW_I2S_RMR_RD(x)         (HW_I2S_RMR(x).U)
#define HW_I2S_RMR_WR(x, v)      (HW_I2S_RMR(x).U = (v))
#define HW_I2S_RMR_SET(x, v)     (HW_I2S_RMR_WR(x, HW_I2S_RMR_RD(x) |  (v)))
#define HW_I2S_RMR_CLR(x, v)     (HW_I2S_RMR_WR(x, HW_I2S_RMR_RD(x) & ~(v)))
#define HW_I2S_RMR_TOG(x, v)     (HW_I2S_RMR_WR(x, HW_I2S_RMR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2S_RMR bitfields
 */

/*!
 * @name Register I2S_RMR, field RWM[31:0] (RW)
 *
 * Configures whether the receive word is masked (received data ignored and not
 * written to receive FIFO) for the corresponding word in the frame.
 *
 * Values:
 * - 0 - Word N is enabled.
 * - 1 - Word N is masked.
 */
//@{
#define BP_I2S_RMR_RWM       (0U)          //!< Bit position for I2S_RMR_RWM.
#define BM_I2S_RMR_RWM       (0xFFFFFFFFU) //!< Bit mask for I2S_RMR_RWM.
#define BS_I2S_RMR_RWM       (32U)         //!< Bit field size in bits for I2S_RMR_RWM.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_RMR_RWM field.
#define BR_I2S_RMR_RWM(x)    (HW_I2S_RMR(x).U)
#endif

//! @brief Format value for bitfield I2S_RMR_RWM.
#define BF_I2S_RMR_RWM(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_RMR_RWM), uint32_t) & BM_I2S_RMR_RWM)

#ifndef __LANGUAGE_ASM__
//! @brief Set the RWM field to a new value.
#define BW_I2S_RMR_RWM(x, v) (HW_I2S_RMR_WR(x, v))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2S_MCR - SAI MCLK Control Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2S_MCR - SAI MCLK Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MCLK Control Register (MCR) controls the clock source and direction of
 * the audio master clock.
 */
typedef union _hw_i2s_mcr
{
    uint32_t U;
    struct _hw_i2s_mcr_bitfields
    {
        uint32_t RESERVED0 : 24;       //!< [23:0]
        uint32_t MICS : 2;             //!< [25:24] MCLK Input Clock Select
        uint32_t RESERVED1 : 4;        //!< [29:26]
        uint32_t MOE : 1;              //!< [30] MCLK Output Enable
        uint32_t DUF : 1;              //!< [31] Divider Update Flag
    } B;
} hw_i2s_mcr_t;
#endif

/*!
 * @name Constants and macros for entire I2S_MCR register
 */
//@{
#define HW_I2S_MCR_ADDR(x)       (REGS_I2S_BASE(x) + 0x100U)

#ifndef __LANGUAGE_ASM__
#define HW_I2S_MCR(x)            (*(__IO hw_i2s_mcr_t *) HW_I2S_MCR_ADDR(x))
#define HW_I2S_MCR_RD(x)         (HW_I2S_MCR(x).U)
#define HW_I2S_MCR_WR(x, v)      (HW_I2S_MCR(x).U = (v))
#define HW_I2S_MCR_SET(x, v)     (HW_I2S_MCR_WR(x, HW_I2S_MCR_RD(x) |  (v)))
#define HW_I2S_MCR_CLR(x, v)     (HW_I2S_MCR_WR(x, HW_I2S_MCR_RD(x) & ~(v)))
#define HW_I2S_MCR_TOG(x, v)     (HW_I2S_MCR_WR(x, HW_I2S_MCR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2S_MCR bitfields
 */

/*!
 * @name Register I2S_MCR, field MICS[25:24] (RW)
 *
 * Selects the clock input to the MCLK divider. This field cannot be changed
 * while the MCLK divider is enabled. See the chip configuration details for
 * information about the connections to these inputs.
 *
 * Values:
 * - 00 - MCLK divider input clock 0 selected.
 * - 01 - MCLK divider input clock 1 selected.
 * - 10 - MCLK divider input clock 2 selected.
 * - 11 - MCLK divider input clock 3 selected.
 */
//@{
#define BP_I2S_MCR_MICS      (24U)         //!< Bit position for I2S_MCR_MICS.
#define BM_I2S_MCR_MICS      (0x03000000U) //!< Bit mask for I2S_MCR_MICS.
#define BS_I2S_MCR_MICS      (2U)          //!< Bit field size in bits for I2S_MCR_MICS.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_MCR_MICS field.
#define BR_I2S_MCR_MICS(x)   (HW_I2S_MCR(x).B.MICS)
#endif

//! @brief Format value for bitfield I2S_MCR_MICS.
#define BF_I2S_MCR_MICS(v)   (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_MCR_MICS), uint32_t) & BM_I2S_MCR_MICS)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MICS field to a new value.
#define BW_I2S_MCR_MICS(x, v) (HW_I2S_MCR_WR(x, (HW_I2S_MCR_RD(x) & ~BM_I2S_MCR_MICS) | BF_I2S_MCR_MICS(v)))
#endif
//@}

/*!
 * @name Register I2S_MCR, field MOE[30] (RW)
 *
 * Enables the MCLK divider and configures the MCLK signal pin as an output.
 * When software clears this field, it remains set until the MCLK divider is fully
 * disabled.
 *
 * Values:
 * - 0 - MCLK signal pin is configured as an input that bypasses the MCLK
 *     divider.
 * - 1 - MCLK signal pin is configured as an output from the MCLK divider and
 *     the MCLK divider is enabled.
 */
//@{
#define BP_I2S_MCR_MOE       (30U)         //!< Bit position for I2S_MCR_MOE.
#define BM_I2S_MCR_MOE       (0x40000000U) //!< Bit mask for I2S_MCR_MOE.
#define BS_I2S_MCR_MOE       (1U)          //!< Bit field size in bits for I2S_MCR_MOE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_MCR_MOE field.
#define BR_I2S_MCR_MOE(x)    (BITBAND_ACCESS32(HW_I2S_MCR_ADDR(x), BP_I2S_MCR_MOE))
#endif

//! @brief Format value for bitfield I2S_MCR_MOE.
#define BF_I2S_MCR_MOE(v)    (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_MCR_MOE), uint32_t) & BM_I2S_MCR_MOE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the MOE field to a new value.
#define BW_I2S_MCR_MOE(x, v) (BITBAND_ACCESS32(HW_I2S_MCR_ADDR(x), BP_I2S_MCR_MOE) = (v))
#endif
//@}

/*!
 * @name Register I2S_MCR, field DUF[31] (RO)
 *
 * Provides the status of on-the-fly updates to the MCLK divider ratio.
 *
 * Values:
 * - 0 - MCLK divider ratio is not being updated currently.
 * - 1 - MCLK divider ratio is updating on-the-fly. Further updates to the MCLK
 *     divider ratio are blocked while this flag remains set.
 */
//@{
#define BP_I2S_MCR_DUF       (31U)         //!< Bit position for I2S_MCR_DUF.
#define BM_I2S_MCR_DUF       (0x80000000U) //!< Bit mask for I2S_MCR_DUF.
#define BS_I2S_MCR_DUF       (1U)          //!< Bit field size in bits for I2S_MCR_DUF.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_MCR_DUF field.
#define BR_I2S_MCR_DUF(x)    (BITBAND_ACCESS32(HW_I2S_MCR_ADDR(x), BP_I2S_MCR_DUF))
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_I2S_MDR - SAI MCLK Divide Register
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_I2S_MDR - SAI MCLK Divide Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MCLK Divide Register (MDR) configures the MCLK divide ratio. Although the
 * MDR can be changed when the MCLK divider clock is enabled, additional writes
 * to the MDR are blocked while MCR[DUF] is set. Writes to the MDR when the MCLK
 * divided clock is disabled do not set MCR[DUF].
 */
typedef union _hw_i2s_mdr
{
    uint32_t U;
    struct _hw_i2s_mdr_bitfields
    {
        uint32_t DIVIDE : 12;          //!< [11:0] MCLK Divide
        uint32_t FRACT : 8;            //!< [19:12] MCLK Fraction
        uint32_t RESERVED0 : 12;       //!< [31:20]
    } B;
} hw_i2s_mdr_t;
#endif

/*!
 * @name Constants and macros for entire I2S_MDR register
 */
//@{
#define HW_I2S_MDR_ADDR(x)       (REGS_I2S_BASE(x) + 0x104U)

#ifndef __LANGUAGE_ASM__
#define HW_I2S_MDR(x)            (*(__IO hw_i2s_mdr_t *) HW_I2S_MDR_ADDR(x))
#define HW_I2S_MDR_RD(x)         (HW_I2S_MDR(x).U)
#define HW_I2S_MDR_WR(x, v)      (HW_I2S_MDR(x).U = (v))
#define HW_I2S_MDR_SET(x, v)     (HW_I2S_MDR_WR(x, HW_I2S_MDR_RD(x) |  (v)))
#define HW_I2S_MDR_CLR(x, v)     (HW_I2S_MDR_WR(x, HW_I2S_MDR_RD(x) & ~(v)))
#define HW_I2S_MDR_TOG(x, v)     (HW_I2S_MDR_WR(x, HW_I2S_MDR_RD(x) ^  (v)))
#endif
//@}

/*
 * Constants & macros for individual I2S_MDR bitfields
 */

/*!
 * @name Register I2S_MDR, field DIVIDE[11:0] (RW)
 *
 * Sets the MCLK divide ratio such that: MCLK output = MCLK input * ( (FRACT +
 * 1) / (DIVIDE + 1) ). FRACT must be set equal or less than the value in the
 * DIVIDE field.
 */
//@{
#define BP_I2S_MDR_DIVIDE    (0U)          //!< Bit position for I2S_MDR_DIVIDE.
#define BM_I2S_MDR_DIVIDE    (0x00000FFFU) //!< Bit mask for I2S_MDR_DIVIDE.
#define BS_I2S_MDR_DIVIDE    (12U)         //!< Bit field size in bits for I2S_MDR_DIVIDE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_MDR_DIVIDE field.
#define BR_I2S_MDR_DIVIDE(x) (HW_I2S_MDR(x).B.DIVIDE)
#endif

//! @brief Format value for bitfield I2S_MDR_DIVIDE.
#define BF_I2S_MDR_DIVIDE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_MDR_DIVIDE), uint32_t) & BM_I2S_MDR_DIVIDE)

#ifndef __LANGUAGE_ASM__
//! @brief Set the DIVIDE field to a new value.
#define BW_I2S_MDR_DIVIDE(x, v) (HW_I2S_MDR_WR(x, (HW_I2S_MDR_RD(x) & ~BM_I2S_MDR_DIVIDE) | BF_I2S_MDR_DIVIDE(v)))
#endif
//@}

/*!
 * @name Register I2S_MDR, field FRACT[19:12] (RW)
 *
 * Sets the MCLK divide ratio such that: MCLK output = MCLK input * ( (FRACT +
 * 1) / (DIVIDE + 1) ). FRACT must be set equal or less than the value in the
 * DIVIDE field.
 */
//@{
#define BP_I2S_MDR_FRACT     (12U)         //!< Bit position for I2S_MDR_FRACT.
#define BM_I2S_MDR_FRACT     (0x000FF000U) //!< Bit mask for I2S_MDR_FRACT.
#define BS_I2S_MDR_FRACT     (8U)          //!< Bit field size in bits for I2S_MDR_FRACT.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the I2S_MDR_FRACT field.
#define BR_I2S_MDR_FRACT(x)  (HW_I2S_MDR(x).B.FRACT)
#endif

//! @brief Format value for bitfield I2S_MDR_FRACT.
#define BF_I2S_MDR_FRACT(v)  (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_I2S_MDR_FRACT), uint32_t) & BM_I2S_MDR_FRACT)

#ifndef __LANGUAGE_ASM__
//! @brief Set the FRACT field to a new value.
#define BW_I2S_MDR_FRACT(x, v) (HW_I2S_MDR_WR(x, (HW_I2S_MDR_RD(x) & ~BM_I2S_MDR_FRACT) | BF_I2S_MDR_FRACT(v)))
#endif
//@}

//-------------------------------------------------------------------------------------------
// hw_i2s_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All I2S module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_i2s
{
    __IO hw_i2s_tcsr_t TCSR;               //!< [0x0] SAI Transmit Control Register
    __IO hw_i2s_tcr1_t TCR1;               //!< [0x4] SAI Transmit Configuration 1 Register
    __IO hw_i2s_tcr2_t TCR2;               //!< [0x8] SAI Transmit Configuration 2 Register
    __IO hw_i2s_tcr3_t TCR3;               //!< [0xC] SAI Transmit Configuration 3 Register
    __IO hw_i2s_tcr4_t TCR4;               //!< [0x10] SAI Transmit Configuration 4 Register
    __IO hw_i2s_tcr5_t TCR5;               //!< [0x14] SAI Transmit Configuration 5 Register
    uint8_t _reserved0[8];
    __O hw_i2s_tdrn_t TDRn[2];             //!< [0x20] SAI Transmit Data Register
    uint8_t _reserved1[24];
    __I hw_i2s_tfrn_t TFRn[2];             //!< [0x40] SAI Transmit FIFO Register
    uint8_t _reserved2[24];
    __IO hw_i2s_tmr_t TMR;                 //!< [0x60] SAI Transmit Mask Register
    uint8_t _reserved3[28];
    __IO hw_i2s_rcsr_t RCSR;               //!< [0x80] SAI Receive Control Register
    __IO hw_i2s_rcr1_t RCR1;               //!< [0x84] SAI Receive Configuration 1 Register
    __IO hw_i2s_rcr2_t RCR2;               //!< [0x88] SAI Receive Configuration 2 Register
    __IO hw_i2s_rcr3_t RCR3;               //!< [0x8C] SAI Receive Configuration 3 Register
    __IO hw_i2s_rcr4_t RCR4;               //!< [0x90] SAI Receive Configuration 4 Register
    __IO hw_i2s_rcr5_t RCR5;               //!< [0x94] SAI Receive Configuration 5 Register
    uint8_t _reserved4[8];
    __I hw_i2s_rdrn_t RDRn[2];             //!< [0xA0] SAI Receive Data Register
    uint8_t _reserved5[24];
    __I hw_i2s_rfrn_t RFRn[2];             //!< [0xC0] SAI Receive FIFO Register
    uint8_t _reserved6[24];
    __IO hw_i2s_rmr_t RMR;                 //!< [0xE0] SAI Receive Mask Register
    uint8_t _reserved7[28];
    __IO hw_i2s_mcr_t MCR;                 //!< [0x100] SAI MCLK Control Register
    __IO hw_i2s_mdr_t MDR;                 //!< [0x104] SAI MCLK Divide Register
} hw_i2s_t;
#pragma pack()

//! @brief Macro to access all I2S registers.
//! @param x I2S instance number.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_I2S(0)</code>.
#define HW_I2S(x)      (*(hw_i2s_t *) REGS_I2S_BASE(x))
#endif

#endif // __HW_I2S_REGISTERS_H__
// v22/130726/0.9
// EOF

