/*
 * Copyright (c) 2014, Freescale Semiconductor, Inc.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL FREESCALE BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 */
/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_CAU_REGISTERS_H__
#define __HW_CAU_REGISTERS_H__

#include "regs.h"

/*
 * MK64F12 CAU
 *
 * Memory Mapped Cryptographic Acceleration Unit (MMCAU)
 *
 * Registers defined in this header file:
 * - HW_CAU_DIRECT - Direct access register 0
 * - HW_CAU_LDR_CASR - Status register  - Load Register command
 * - HW_CAU_LDR_CAA - Accumulator register - Load Register command
 * - HW_CAU_LDR_CA - General Purpose Register 0 - Load Register command
 * - HW_CAU_STR_CASR - Status register  - Store Register command
 * - HW_CAU_STR_CAA - Accumulator register - Store Register command
 * - HW_CAU_STR_CA - General Purpose Register 0 - Store Register command
 * - HW_CAU_ADR_CASR - Status register  - Add Register command
 * - HW_CAU_ADR_CAA - Accumulator register - Add to register command
 * - HW_CAU_ADR_CA - General Purpose Register 0 - Add to register command
 * - HW_CAU_RADR_CASR - Status register  - Reverse and Add to Register command
 * - HW_CAU_RADR_CAA - Accumulator register - Reverse and Add to Register command
 * - HW_CAU_RADR_CA - General Purpose Register 0 - Reverse and Add to Register command
 * - HW_CAU_XOR_CASR - Status register  - Exclusive Or command
 * - HW_CAU_XOR_CAA - Accumulator register - Exclusive Or command
 * - HW_CAU_XOR_CA - General Purpose Register 0 - Exclusive Or command
 * - HW_CAU_ROTL_CASR - Status register  - Rotate Left command
 * - HW_CAU_ROTL_CAA - Accumulator register - Rotate Left command
 * - HW_CAU_ROTL_CA - General Purpose Register 0 - Rotate Left command
 * - HW_CAU_AESC_CASR - Status register  - AES Column Operation command
 * - HW_CAU_AESC_CAA - Accumulator register - AES Column Operation command
 * - HW_CAU_AESC_CA - General Purpose Register 0 - AES Column Operation command
 * - HW_CAU_AESIC_CASR - Status register  - AES Inverse Column Operation command
 * - HW_CAU_AESIC_CAA - Accumulator register - AES Inverse Column Operation command
 * - HW_CAU_AESIC_CA - General Purpose Register 0 - AES Inverse Column Operation command
 *
 * - hw_cau_t - Struct containing all module registers.
 */

//! @name Module base addresses
//@{
#ifndef REGS_CAU_BASE
#define HW_CAU_INSTANCE_COUNT (1U) //!< Number of instances of the CAU module.
#define REGS_CAU_BASE (0xE0081000U) //!< Base address for CAU.
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_CAU_DIRECT - Direct access register 0
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_DIRECT - Direct access register 0 (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_direct
{
    uint32_t U;
    struct _hw_cau_direct_bitfields
    {
        uint32_t RESERVED0 : 32;       //!< [31:0]
    } B;
} hw_cau_direct_t;
#endif

/*!
 * @name Constants and macros for entire CAU_DIRECT register
 */
//@{
#define HW_CAU_DIRECT_COUNT (16U)

#define HW_CAU_DIRECT_ADDR(n)    (REGS_CAU_BASE + 0x0U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_CAU_DIRECT(n)         (*(__O hw_cau_direct_t *) HW_CAU_DIRECT_ADDR(n))
#define HW_CAU_DIRECT_WR(n, v)   (HW_CAU_DIRECT(n).U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_DIRECT bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_CAU_LDR_CASR - Status register  - Load Register command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_LDR_CASR - Status register  - Load Register command (WO)
 *
 * Reset value: 0x20000000U
 */
typedef union _hw_cau_ldr_casr
{
    uint32_t U;
    struct _hw_cau_ldr_casr_bitfields
    {
        uint32_t IC : 1;               //!< [0]
        uint32_t DPE : 1;              //!< [1]
        uint32_t RESERVED0 : 26;       //!< [27:2]
        uint32_t VER : 4;              //!< [31:28] CAU version
    } B;
} hw_cau_ldr_casr_t;
#endif

/*!
 * @name Constants and macros for entire CAU_LDR_CASR register
 */
//@{
#define HW_CAU_LDR_CASR_ADDR     (REGS_CAU_BASE + 0x840U)

#ifndef __LANGUAGE_ASM__
#define HW_CAU_LDR_CASR          (*(__O hw_cau_ldr_casr_t *) HW_CAU_LDR_CASR_ADDR)
#define HW_CAU_LDR_CASR_WR(v)    (HW_CAU_LDR_CASR.U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_LDR_CASR bitfields
 */

/*!
 * @name Register CAU_LDR_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0 - No illegal commands issued
 * - 1 - Illegal command issued
 */
//@{
#define BP_CAU_LDR_CASR_IC   (0U)          //!< Bit position for CAU_LDR_CASR_IC.
#define BM_CAU_LDR_CASR_IC   (0x00000001U) //!< Bit mask for CAU_LDR_CASR_IC.
#define BS_CAU_LDR_CASR_IC   (1U)          //!< Bit field size in bits for CAU_LDR_CASR_IC.

//! @brief Format value for bitfield CAU_LDR_CASR_IC.
#define BF_CAU_LDR_CASR_IC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_LDR_CASR_IC), uint32_t) & BM_CAU_LDR_CASR_IC)
//@}

/*!
 * @name Register CAU_LDR_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0 - No error detected
 * - 1 - DES key parity error detected
 */
//@{
#define BP_CAU_LDR_CASR_DPE  (1U)          //!< Bit position for CAU_LDR_CASR_DPE.
#define BM_CAU_LDR_CASR_DPE  (0x00000002U) //!< Bit mask for CAU_LDR_CASR_DPE.
#define BS_CAU_LDR_CASR_DPE  (1U)          //!< Bit field size in bits for CAU_LDR_CASR_DPE.

//! @brief Format value for bitfield CAU_LDR_CASR_DPE.
#define BF_CAU_LDR_CASR_DPE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_LDR_CASR_DPE), uint32_t) & BM_CAU_LDR_CASR_DPE)
//@}

/*!
 * @name Register CAU_LDR_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0001 - Initial CAU version
 * - 0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
//@{
#define BP_CAU_LDR_CASR_VER  (28U)         //!< Bit position for CAU_LDR_CASR_VER.
#define BM_CAU_LDR_CASR_VER  (0xF0000000U) //!< Bit mask for CAU_LDR_CASR_VER.
#define BS_CAU_LDR_CASR_VER  (4U)          //!< Bit field size in bits for CAU_LDR_CASR_VER.

//! @brief Format value for bitfield CAU_LDR_CASR_VER.
#define BF_CAU_LDR_CASR_VER(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_LDR_CASR_VER), uint32_t) & BM_CAU_LDR_CASR_VER)
//@}

//-------------------------------------------------------------------------------------------
// HW_CAU_LDR_CAA - Accumulator register - Load Register command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_LDR_CAA - Accumulator register - Load Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_ldr_caa
{
    uint32_t U;
    struct _hw_cau_ldr_caa_bitfields
    {
        uint32_t RESERVED0 : 32;       //!< [31:0]
    } B;
} hw_cau_ldr_caa_t;
#endif

/*!
 * @name Constants and macros for entire CAU_LDR_CAA register
 */
//@{
#define HW_CAU_LDR_CAA_ADDR      (REGS_CAU_BASE + 0x844U)

#ifndef __LANGUAGE_ASM__
#define HW_CAU_LDR_CAA           (*(__O hw_cau_ldr_caa_t *) HW_CAU_LDR_CAA_ADDR)
#define HW_CAU_LDR_CAA_WR(v)     (HW_CAU_LDR_CAA.U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_LDR_CAA bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_CAU_LDR_CA - General Purpose Register 0 - Load Register command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_LDR_CA - General Purpose Register 0 - Load Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_ldr_ca
{
    uint32_t U;
    struct _hw_cau_ldr_ca_bitfields
    {
        uint32_t RESERVED0 : 32;       //!< [31:0]
    } B;
} hw_cau_ldr_ca_t;
#endif

/*!
 * @name Constants and macros for entire CAU_LDR_CA register
 */
//@{
#define HW_CAU_LDR_CA_COUNT (9U)

#define HW_CAU_LDR_CA_ADDR(n)    (REGS_CAU_BASE + 0x848U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_CAU_LDR_CA(n)         (*(__O hw_cau_ldr_ca_t *) HW_CAU_LDR_CA_ADDR(n))
#define HW_CAU_LDR_CA_WR(n, v)   (HW_CAU_LDR_CA(n).U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_LDR_CA bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_CAU_STR_CASR - Status register  - Store Register command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_STR_CASR - Status register  - Store Register command (RO)
 *
 * Reset value: 0x20000000U
 */
typedef union _hw_cau_str_casr
{
    uint32_t U;
    struct _hw_cau_str_casr_bitfields
    {
        uint32_t IC : 1;               //!< [0]
        uint32_t DPE : 1;              //!< [1]
        uint32_t RESERVED0 : 26;       //!< [27:2]
        uint32_t VER : 4;              //!< [31:28] CAU version
    } B;
} hw_cau_str_casr_t;
#endif

/*!
 * @name Constants and macros for entire CAU_STR_CASR register
 */
//@{
#define HW_CAU_STR_CASR_ADDR     (REGS_CAU_BASE + 0x880U)

#ifndef __LANGUAGE_ASM__
#define HW_CAU_STR_CASR          (*(__I hw_cau_str_casr_t *) HW_CAU_STR_CASR_ADDR)
#define HW_CAU_STR_CASR_RD()     (HW_CAU_STR_CASR.U)
#endif
//@}

/*
 * Constants & macros for individual CAU_STR_CASR bitfields
 */

/*!
 * @name Register CAU_STR_CASR, field IC[0] (RO)
 *
 * Values:
 * - 0 - No illegal commands issued
 * - 1 - Illegal command issued
 */
//@{
#define BP_CAU_STR_CASR_IC   (0U)          //!< Bit position for CAU_STR_CASR_IC.
#define BM_CAU_STR_CASR_IC   (0x00000001U) //!< Bit mask for CAU_STR_CASR_IC.
#define BS_CAU_STR_CASR_IC   (1U)          //!< Bit field size in bits for CAU_STR_CASR_IC.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the CAU_STR_CASR_IC field.
#define BR_CAU_STR_CASR_IC   (BITBAND_ACCESS32(HW_CAU_STR_CASR_ADDR, BP_CAU_STR_CASR_IC))
#endif
//@}

/*!
 * @name Register CAU_STR_CASR, field DPE[1] (RO)
 *
 * Values:
 * - 0 - No error detected
 * - 1 - DES key parity error detected
 */
//@{
#define BP_CAU_STR_CASR_DPE  (1U)          //!< Bit position for CAU_STR_CASR_DPE.
#define BM_CAU_STR_CASR_DPE  (0x00000002U) //!< Bit mask for CAU_STR_CASR_DPE.
#define BS_CAU_STR_CASR_DPE  (1U)          //!< Bit field size in bits for CAU_STR_CASR_DPE.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the CAU_STR_CASR_DPE field.
#define BR_CAU_STR_CASR_DPE  (BITBAND_ACCESS32(HW_CAU_STR_CASR_ADDR, BP_CAU_STR_CASR_DPE))
#endif
//@}

/*!
 * @name Register CAU_STR_CASR, field VER[31:28] (RO)
 *
 * Values:
 * - 0001 - Initial CAU version
 * - 0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
//@{
#define BP_CAU_STR_CASR_VER  (28U)         //!< Bit position for CAU_STR_CASR_VER.
#define BM_CAU_STR_CASR_VER  (0xF0000000U) //!< Bit mask for CAU_STR_CASR_VER.
#define BS_CAU_STR_CASR_VER  (4U)          //!< Bit field size in bits for CAU_STR_CASR_VER.

#ifndef __LANGUAGE_ASM__
//! @brief Read current value of the CAU_STR_CASR_VER field.
#define BR_CAU_STR_CASR_VER  (HW_CAU_STR_CASR.B.VER)
#endif
//@}

//-------------------------------------------------------------------------------------------
// HW_CAU_STR_CAA - Accumulator register - Store Register command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_STR_CAA - Accumulator register - Store Register command (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_str_caa
{
    uint32_t U;
    struct _hw_cau_str_caa_bitfields
    {
        uint32_t RESERVED0 : 32;       //!< [31:0]
    } B;
} hw_cau_str_caa_t;
#endif

/*!
 * @name Constants and macros for entire CAU_STR_CAA register
 */
//@{
#define HW_CAU_STR_CAA_ADDR      (REGS_CAU_BASE + 0x884U)

#ifndef __LANGUAGE_ASM__
#define HW_CAU_STR_CAA           (*(__I hw_cau_str_caa_t *) HW_CAU_STR_CAA_ADDR)
#define HW_CAU_STR_CAA_RD()      (HW_CAU_STR_CAA.U)
#endif
//@}

/*
 * Constants & macros for individual CAU_STR_CAA bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_CAU_STR_CA - General Purpose Register 0 - Store Register command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_STR_CA - General Purpose Register 0 - Store Register command (RO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_str_ca
{
    uint32_t U;
    struct _hw_cau_str_ca_bitfields
    {
        uint32_t RESERVED0 : 32;       //!< [31:0]
    } B;
} hw_cau_str_ca_t;
#endif

/*!
 * @name Constants and macros for entire CAU_STR_CA register
 */
//@{
#define HW_CAU_STR_CA_COUNT (9U)

#define HW_CAU_STR_CA_ADDR(n)    (REGS_CAU_BASE + 0x888U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_CAU_STR_CA(n)         (*(__I hw_cau_str_ca_t *) HW_CAU_STR_CA_ADDR(n))
#define HW_CAU_STR_CA_RD(n)      (HW_CAU_STR_CA(n).U)
#endif
//@}

/*
 * Constants & macros for individual CAU_STR_CA bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_CAU_ADR_CASR - Status register  - Add Register command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_ADR_CASR - Status register  - Add Register command (WO)
 *
 * Reset value: 0x20000000U
 */
typedef union _hw_cau_adr_casr
{
    uint32_t U;
    struct _hw_cau_adr_casr_bitfields
    {
        uint32_t IC : 1;               //!< [0]
        uint32_t DPE : 1;              //!< [1]
        uint32_t RESERVED0 : 26;       //!< [27:2]
        uint32_t VER : 4;              //!< [31:28] CAU version
    } B;
} hw_cau_adr_casr_t;
#endif

/*!
 * @name Constants and macros for entire CAU_ADR_CASR register
 */
//@{
#define HW_CAU_ADR_CASR_ADDR     (REGS_CAU_BASE + 0x8C0U)

#ifndef __LANGUAGE_ASM__
#define HW_CAU_ADR_CASR          (*(__O hw_cau_adr_casr_t *) HW_CAU_ADR_CASR_ADDR)
#define HW_CAU_ADR_CASR_WR(v)    (HW_CAU_ADR_CASR.U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_ADR_CASR bitfields
 */

/*!
 * @name Register CAU_ADR_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0 - No illegal commands issued
 * - 1 - Illegal command issued
 */
//@{
#define BP_CAU_ADR_CASR_IC   (0U)          //!< Bit position for CAU_ADR_CASR_IC.
#define BM_CAU_ADR_CASR_IC   (0x00000001U) //!< Bit mask for CAU_ADR_CASR_IC.
#define BS_CAU_ADR_CASR_IC   (1U)          //!< Bit field size in bits for CAU_ADR_CASR_IC.

//! @brief Format value for bitfield CAU_ADR_CASR_IC.
#define BF_CAU_ADR_CASR_IC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_ADR_CASR_IC), uint32_t) & BM_CAU_ADR_CASR_IC)
//@}

/*!
 * @name Register CAU_ADR_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0 - No error detected
 * - 1 - DES key parity error detected
 */
//@{
#define BP_CAU_ADR_CASR_DPE  (1U)          //!< Bit position for CAU_ADR_CASR_DPE.
#define BM_CAU_ADR_CASR_DPE  (0x00000002U) //!< Bit mask for CAU_ADR_CASR_DPE.
#define BS_CAU_ADR_CASR_DPE  (1U)          //!< Bit field size in bits for CAU_ADR_CASR_DPE.

//! @brief Format value for bitfield CAU_ADR_CASR_DPE.
#define BF_CAU_ADR_CASR_DPE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_ADR_CASR_DPE), uint32_t) & BM_CAU_ADR_CASR_DPE)
//@}

/*!
 * @name Register CAU_ADR_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0001 - Initial CAU version
 * - 0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
//@{
#define BP_CAU_ADR_CASR_VER  (28U)         //!< Bit position for CAU_ADR_CASR_VER.
#define BM_CAU_ADR_CASR_VER  (0xF0000000U) //!< Bit mask for CAU_ADR_CASR_VER.
#define BS_CAU_ADR_CASR_VER  (4U)          //!< Bit field size in bits for CAU_ADR_CASR_VER.

//! @brief Format value for bitfield CAU_ADR_CASR_VER.
#define BF_CAU_ADR_CASR_VER(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_ADR_CASR_VER), uint32_t) & BM_CAU_ADR_CASR_VER)
//@}

//-------------------------------------------------------------------------------------------
// HW_CAU_ADR_CAA - Accumulator register - Add to register command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_ADR_CAA - Accumulator register - Add to register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_adr_caa
{
    uint32_t U;
    struct _hw_cau_adr_caa_bitfields
    {
        uint32_t RESERVED0 : 32;       //!< [31:0]
    } B;
} hw_cau_adr_caa_t;
#endif

/*!
 * @name Constants and macros for entire CAU_ADR_CAA register
 */
//@{
#define HW_CAU_ADR_CAA_ADDR      (REGS_CAU_BASE + 0x8C4U)

#ifndef __LANGUAGE_ASM__
#define HW_CAU_ADR_CAA           (*(__O hw_cau_adr_caa_t *) HW_CAU_ADR_CAA_ADDR)
#define HW_CAU_ADR_CAA_WR(v)     (HW_CAU_ADR_CAA.U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_ADR_CAA bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_CAU_ADR_CA - General Purpose Register 0 - Add to register command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_ADR_CA - General Purpose Register 0 - Add to register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_adr_ca
{
    uint32_t U;
    struct _hw_cau_adr_ca_bitfields
    {
        uint32_t RESERVED0 : 32;       //!< [31:0]
    } B;
} hw_cau_adr_ca_t;
#endif

/*!
 * @name Constants and macros for entire CAU_ADR_CA register
 */
//@{
#define HW_CAU_ADR_CA_COUNT (9U)

#define HW_CAU_ADR_CA_ADDR(n)    (REGS_CAU_BASE + 0x8C8U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_CAU_ADR_CA(n)         (*(__O hw_cau_adr_ca_t *) HW_CAU_ADR_CA_ADDR(n))
#define HW_CAU_ADR_CA_WR(n, v)   (HW_CAU_ADR_CA(n).U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_ADR_CA bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_CAU_RADR_CASR - Status register  - Reverse and Add to Register command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_RADR_CASR - Status register  - Reverse and Add to Register command (WO)
 *
 * Reset value: 0x20000000U
 */
typedef union _hw_cau_radr_casr
{
    uint32_t U;
    struct _hw_cau_radr_casr_bitfields
    {
        uint32_t IC : 1;               //!< [0]
        uint32_t DPE : 1;              //!< [1]
        uint32_t RESERVED0 : 26;       //!< [27:2]
        uint32_t VER : 4;              //!< [31:28] CAU version
    } B;
} hw_cau_radr_casr_t;
#endif

/*!
 * @name Constants and macros for entire CAU_RADR_CASR register
 */
//@{
#define HW_CAU_RADR_CASR_ADDR    (REGS_CAU_BASE + 0x900U)

#ifndef __LANGUAGE_ASM__
#define HW_CAU_RADR_CASR         (*(__O hw_cau_radr_casr_t *) HW_CAU_RADR_CASR_ADDR)
#define HW_CAU_RADR_CASR_WR(v)   (HW_CAU_RADR_CASR.U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_RADR_CASR bitfields
 */

/*!
 * @name Register CAU_RADR_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0 - No illegal commands issued
 * - 1 - Illegal command issued
 */
//@{
#define BP_CAU_RADR_CASR_IC  (0U)          //!< Bit position for CAU_RADR_CASR_IC.
#define BM_CAU_RADR_CASR_IC  (0x00000001U) //!< Bit mask for CAU_RADR_CASR_IC.
#define BS_CAU_RADR_CASR_IC  (1U)          //!< Bit field size in bits for CAU_RADR_CASR_IC.

//! @brief Format value for bitfield CAU_RADR_CASR_IC.
#define BF_CAU_RADR_CASR_IC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_RADR_CASR_IC), uint32_t) & BM_CAU_RADR_CASR_IC)
//@}

/*!
 * @name Register CAU_RADR_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0 - No error detected
 * - 1 - DES key parity error detected
 */
//@{
#define BP_CAU_RADR_CASR_DPE (1U)          //!< Bit position for CAU_RADR_CASR_DPE.
#define BM_CAU_RADR_CASR_DPE (0x00000002U) //!< Bit mask for CAU_RADR_CASR_DPE.
#define BS_CAU_RADR_CASR_DPE (1U)          //!< Bit field size in bits for CAU_RADR_CASR_DPE.

//! @brief Format value for bitfield CAU_RADR_CASR_DPE.
#define BF_CAU_RADR_CASR_DPE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_RADR_CASR_DPE), uint32_t) & BM_CAU_RADR_CASR_DPE)
//@}

/*!
 * @name Register CAU_RADR_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0001 - Initial CAU version
 * - 0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
//@{
#define BP_CAU_RADR_CASR_VER (28U)         //!< Bit position for CAU_RADR_CASR_VER.
#define BM_CAU_RADR_CASR_VER (0xF0000000U) //!< Bit mask for CAU_RADR_CASR_VER.
#define BS_CAU_RADR_CASR_VER (4U)          //!< Bit field size in bits for CAU_RADR_CASR_VER.

//! @brief Format value for bitfield CAU_RADR_CASR_VER.
#define BF_CAU_RADR_CASR_VER(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_RADR_CASR_VER), uint32_t) & BM_CAU_RADR_CASR_VER)
//@}

//-------------------------------------------------------------------------------------------
// HW_CAU_RADR_CAA - Accumulator register - Reverse and Add to Register command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_RADR_CAA - Accumulator register - Reverse and Add to Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_radr_caa
{
    uint32_t U;
    struct _hw_cau_radr_caa_bitfields
    {
        uint32_t RESERVED0 : 32;       //!< [31:0]
    } B;
} hw_cau_radr_caa_t;
#endif

/*!
 * @name Constants and macros for entire CAU_RADR_CAA register
 */
//@{
#define HW_CAU_RADR_CAA_ADDR     (REGS_CAU_BASE + 0x904U)

#ifndef __LANGUAGE_ASM__
#define HW_CAU_RADR_CAA          (*(__O hw_cau_radr_caa_t *) HW_CAU_RADR_CAA_ADDR)
#define HW_CAU_RADR_CAA_WR(v)    (HW_CAU_RADR_CAA.U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_RADR_CAA bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_CAU_RADR_CA - General Purpose Register 0 - Reverse and Add to Register command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_RADR_CA - General Purpose Register 0 - Reverse and Add to Register command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_radr_ca
{
    uint32_t U;
    struct _hw_cau_radr_ca_bitfields
    {
        uint32_t RESERVED0 : 32;       //!< [31:0]
    } B;
} hw_cau_radr_ca_t;
#endif

/*!
 * @name Constants and macros for entire CAU_RADR_CA register
 */
//@{
#define HW_CAU_RADR_CA_COUNT (9U)

#define HW_CAU_RADR_CA_ADDR(n)   (REGS_CAU_BASE + 0x908U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_CAU_RADR_CA(n)        (*(__O hw_cau_radr_ca_t *) HW_CAU_RADR_CA_ADDR(n))
#define HW_CAU_RADR_CA_WR(n, v)  (HW_CAU_RADR_CA(n).U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_RADR_CA bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_CAU_XOR_CASR - Status register  - Exclusive Or command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_XOR_CASR - Status register  - Exclusive Or command (WO)
 *
 * Reset value: 0x20000000U
 */
typedef union _hw_cau_xor_casr
{
    uint32_t U;
    struct _hw_cau_xor_casr_bitfields
    {
        uint32_t IC : 1;               //!< [0]
        uint32_t DPE : 1;              //!< [1]
        uint32_t RESERVED0 : 26;       //!< [27:2]
        uint32_t VER : 4;              //!< [31:28] CAU version
    } B;
} hw_cau_xor_casr_t;
#endif

/*!
 * @name Constants and macros for entire CAU_XOR_CASR register
 */
//@{
#define HW_CAU_XOR_CASR_ADDR     (REGS_CAU_BASE + 0x980U)

#ifndef __LANGUAGE_ASM__
#define HW_CAU_XOR_CASR          (*(__O hw_cau_xor_casr_t *) HW_CAU_XOR_CASR_ADDR)
#define HW_CAU_XOR_CASR_WR(v)    (HW_CAU_XOR_CASR.U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_XOR_CASR bitfields
 */

/*!
 * @name Register CAU_XOR_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0 - No illegal commands issued
 * - 1 - Illegal command issued
 */
//@{
#define BP_CAU_XOR_CASR_IC   (0U)          //!< Bit position for CAU_XOR_CASR_IC.
#define BM_CAU_XOR_CASR_IC   (0x00000001U) //!< Bit mask for CAU_XOR_CASR_IC.
#define BS_CAU_XOR_CASR_IC   (1U)          //!< Bit field size in bits for CAU_XOR_CASR_IC.

//! @brief Format value for bitfield CAU_XOR_CASR_IC.
#define BF_CAU_XOR_CASR_IC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_XOR_CASR_IC), uint32_t) & BM_CAU_XOR_CASR_IC)
//@}

/*!
 * @name Register CAU_XOR_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0 - No error detected
 * - 1 - DES key parity error detected
 */
//@{
#define BP_CAU_XOR_CASR_DPE  (1U)          //!< Bit position for CAU_XOR_CASR_DPE.
#define BM_CAU_XOR_CASR_DPE  (0x00000002U) //!< Bit mask for CAU_XOR_CASR_DPE.
#define BS_CAU_XOR_CASR_DPE  (1U)          //!< Bit field size in bits for CAU_XOR_CASR_DPE.

//! @brief Format value for bitfield CAU_XOR_CASR_DPE.
#define BF_CAU_XOR_CASR_DPE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_XOR_CASR_DPE), uint32_t) & BM_CAU_XOR_CASR_DPE)
//@}

/*!
 * @name Register CAU_XOR_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0001 - Initial CAU version
 * - 0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
//@{
#define BP_CAU_XOR_CASR_VER  (28U)         //!< Bit position for CAU_XOR_CASR_VER.
#define BM_CAU_XOR_CASR_VER  (0xF0000000U) //!< Bit mask for CAU_XOR_CASR_VER.
#define BS_CAU_XOR_CASR_VER  (4U)          //!< Bit field size in bits for CAU_XOR_CASR_VER.

//! @brief Format value for bitfield CAU_XOR_CASR_VER.
#define BF_CAU_XOR_CASR_VER(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_XOR_CASR_VER), uint32_t) & BM_CAU_XOR_CASR_VER)
//@}

//-------------------------------------------------------------------------------------------
// HW_CAU_XOR_CAA - Accumulator register - Exclusive Or command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_XOR_CAA - Accumulator register - Exclusive Or command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_xor_caa
{
    uint32_t U;
    struct _hw_cau_xor_caa_bitfields
    {
        uint32_t RESERVED0 : 32;       //!< [31:0]
    } B;
} hw_cau_xor_caa_t;
#endif

/*!
 * @name Constants and macros for entire CAU_XOR_CAA register
 */
//@{
#define HW_CAU_XOR_CAA_ADDR      (REGS_CAU_BASE + 0x984U)

#ifndef __LANGUAGE_ASM__
#define HW_CAU_XOR_CAA           (*(__O hw_cau_xor_caa_t *) HW_CAU_XOR_CAA_ADDR)
#define HW_CAU_XOR_CAA_WR(v)     (HW_CAU_XOR_CAA.U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_XOR_CAA bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_CAU_XOR_CA - General Purpose Register 0 - Exclusive Or command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_XOR_CA - General Purpose Register 0 - Exclusive Or command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_xor_ca
{
    uint32_t U;
    struct _hw_cau_xor_ca_bitfields
    {
        uint32_t RESERVED0 : 32;       //!< [31:0]
    } B;
} hw_cau_xor_ca_t;
#endif

/*!
 * @name Constants and macros for entire CAU_XOR_CA register
 */
//@{
#define HW_CAU_XOR_CA_COUNT (9U)

#define HW_CAU_XOR_CA_ADDR(n)    (REGS_CAU_BASE + 0x988U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_CAU_XOR_CA(n)         (*(__O hw_cau_xor_ca_t *) HW_CAU_XOR_CA_ADDR(n))
#define HW_CAU_XOR_CA_WR(n, v)   (HW_CAU_XOR_CA(n).U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_XOR_CA bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_CAU_ROTL_CASR - Status register  - Rotate Left command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_ROTL_CASR - Status register  - Rotate Left command (WO)
 *
 * Reset value: 0x20000000U
 */
typedef union _hw_cau_rotl_casr
{
    uint32_t U;
    struct _hw_cau_rotl_casr_bitfields
    {
        uint32_t IC : 1;               //!< [0]
        uint32_t DPE : 1;              //!< [1]
        uint32_t RESERVED0 : 26;       //!< [27:2]
        uint32_t VER : 4;              //!< [31:28] CAU version
    } B;
} hw_cau_rotl_casr_t;
#endif

/*!
 * @name Constants and macros for entire CAU_ROTL_CASR register
 */
//@{
#define HW_CAU_ROTL_CASR_ADDR    (REGS_CAU_BASE + 0x9C0U)

#ifndef __LANGUAGE_ASM__
#define HW_CAU_ROTL_CASR         (*(__O hw_cau_rotl_casr_t *) HW_CAU_ROTL_CASR_ADDR)
#define HW_CAU_ROTL_CASR_WR(v)   (HW_CAU_ROTL_CASR.U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_ROTL_CASR bitfields
 */

/*!
 * @name Register CAU_ROTL_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0 - No illegal commands issued
 * - 1 - Illegal command issued
 */
//@{
#define BP_CAU_ROTL_CASR_IC  (0U)          //!< Bit position for CAU_ROTL_CASR_IC.
#define BM_CAU_ROTL_CASR_IC  (0x00000001U) //!< Bit mask for CAU_ROTL_CASR_IC.
#define BS_CAU_ROTL_CASR_IC  (1U)          //!< Bit field size in bits for CAU_ROTL_CASR_IC.

//! @brief Format value for bitfield CAU_ROTL_CASR_IC.
#define BF_CAU_ROTL_CASR_IC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_ROTL_CASR_IC), uint32_t) & BM_CAU_ROTL_CASR_IC)
//@}

/*!
 * @name Register CAU_ROTL_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0 - No error detected
 * - 1 - DES key parity error detected
 */
//@{
#define BP_CAU_ROTL_CASR_DPE (1U)          //!< Bit position for CAU_ROTL_CASR_DPE.
#define BM_CAU_ROTL_CASR_DPE (0x00000002U) //!< Bit mask for CAU_ROTL_CASR_DPE.
#define BS_CAU_ROTL_CASR_DPE (1U)          //!< Bit field size in bits for CAU_ROTL_CASR_DPE.

//! @brief Format value for bitfield CAU_ROTL_CASR_DPE.
#define BF_CAU_ROTL_CASR_DPE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_ROTL_CASR_DPE), uint32_t) & BM_CAU_ROTL_CASR_DPE)
//@}

/*!
 * @name Register CAU_ROTL_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0001 - Initial CAU version
 * - 0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
//@{
#define BP_CAU_ROTL_CASR_VER (28U)         //!< Bit position for CAU_ROTL_CASR_VER.
#define BM_CAU_ROTL_CASR_VER (0xF0000000U) //!< Bit mask for CAU_ROTL_CASR_VER.
#define BS_CAU_ROTL_CASR_VER (4U)          //!< Bit field size in bits for CAU_ROTL_CASR_VER.

//! @brief Format value for bitfield CAU_ROTL_CASR_VER.
#define BF_CAU_ROTL_CASR_VER(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_ROTL_CASR_VER), uint32_t) & BM_CAU_ROTL_CASR_VER)
//@}

//-------------------------------------------------------------------------------------------
// HW_CAU_ROTL_CAA - Accumulator register - Rotate Left command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_ROTL_CAA - Accumulator register - Rotate Left command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_rotl_caa
{
    uint32_t U;
    struct _hw_cau_rotl_caa_bitfields
    {
        uint32_t RESERVED0 : 32;       //!< [31:0]
    } B;
} hw_cau_rotl_caa_t;
#endif

/*!
 * @name Constants and macros for entire CAU_ROTL_CAA register
 */
//@{
#define HW_CAU_ROTL_CAA_ADDR     (REGS_CAU_BASE + 0x9C4U)

#ifndef __LANGUAGE_ASM__
#define HW_CAU_ROTL_CAA          (*(__O hw_cau_rotl_caa_t *) HW_CAU_ROTL_CAA_ADDR)
#define HW_CAU_ROTL_CAA_WR(v)    (HW_CAU_ROTL_CAA.U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_ROTL_CAA bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_CAU_ROTL_CA - General Purpose Register 0 - Rotate Left command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_ROTL_CA - General Purpose Register 0 - Rotate Left command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_rotl_ca
{
    uint32_t U;
    struct _hw_cau_rotl_ca_bitfields
    {
        uint32_t RESERVED0 : 32;       //!< [31:0]
    } B;
} hw_cau_rotl_ca_t;
#endif

/*!
 * @name Constants and macros for entire CAU_ROTL_CA register
 */
//@{
#define HW_CAU_ROTL_CA_COUNT (9U)

#define HW_CAU_ROTL_CA_ADDR(n)   (REGS_CAU_BASE + 0x9C8U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_CAU_ROTL_CA(n)        (*(__O hw_cau_rotl_ca_t *) HW_CAU_ROTL_CA_ADDR(n))
#define HW_CAU_ROTL_CA_WR(n, v)  (HW_CAU_ROTL_CA(n).U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_ROTL_CA bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_CAU_AESC_CASR - Status register  - AES Column Operation command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_AESC_CASR - Status register  - AES Column Operation command (WO)
 *
 * Reset value: 0x20000000U
 */
typedef union _hw_cau_aesc_casr
{
    uint32_t U;
    struct _hw_cau_aesc_casr_bitfields
    {
        uint32_t IC : 1;               //!< [0]
        uint32_t DPE : 1;              //!< [1]
        uint32_t RESERVED0 : 26;       //!< [27:2]
        uint32_t VER : 4;              //!< [31:28] CAU version
    } B;
} hw_cau_aesc_casr_t;
#endif

/*!
 * @name Constants and macros for entire CAU_AESC_CASR register
 */
//@{
#define HW_CAU_AESC_CASR_ADDR    (REGS_CAU_BASE + 0xB00U)

#ifndef __LANGUAGE_ASM__
#define HW_CAU_AESC_CASR         (*(__O hw_cau_aesc_casr_t *) HW_CAU_AESC_CASR_ADDR)
#define HW_CAU_AESC_CASR_WR(v)   (HW_CAU_AESC_CASR.U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_AESC_CASR bitfields
 */

/*!
 * @name Register CAU_AESC_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0 - No illegal commands issued
 * - 1 - Illegal command issued
 */
//@{
#define BP_CAU_AESC_CASR_IC  (0U)          //!< Bit position for CAU_AESC_CASR_IC.
#define BM_CAU_AESC_CASR_IC  (0x00000001U) //!< Bit mask for CAU_AESC_CASR_IC.
#define BS_CAU_AESC_CASR_IC  (1U)          //!< Bit field size in bits for CAU_AESC_CASR_IC.

//! @brief Format value for bitfield CAU_AESC_CASR_IC.
#define BF_CAU_AESC_CASR_IC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_AESC_CASR_IC), uint32_t) & BM_CAU_AESC_CASR_IC)
//@}

/*!
 * @name Register CAU_AESC_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0 - No error detected
 * - 1 - DES key parity error detected
 */
//@{
#define BP_CAU_AESC_CASR_DPE (1U)          //!< Bit position for CAU_AESC_CASR_DPE.
#define BM_CAU_AESC_CASR_DPE (0x00000002U) //!< Bit mask for CAU_AESC_CASR_DPE.
#define BS_CAU_AESC_CASR_DPE (1U)          //!< Bit field size in bits for CAU_AESC_CASR_DPE.

//! @brief Format value for bitfield CAU_AESC_CASR_DPE.
#define BF_CAU_AESC_CASR_DPE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_AESC_CASR_DPE), uint32_t) & BM_CAU_AESC_CASR_DPE)
//@}

/*!
 * @name Register CAU_AESC_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0001 - Initial CAU version
 * - 0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
//@{
#define BP_CAU_AESC_CASR_VER (28U)         //!< Bit position for CAU_AESC_CASR_VER.
#define BM_CAU_AESC_CASR_VER (0xF0000000U) //!< Bit mask for CAU_AESC_CASR_VER.
#define BS_CAU_AESC_CASR_VER (4U)          //!< Bit field size in bits for CAU_AESC_CASR_VER.

//! @brief Format value for bitfield CAU_AESC_CASR_VER.
#define BF_CAU_AESC_CASR_VER(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_AESC_CASR_VER), uint32_t) & BM_CAU_AESC_CASR_VER)
//@}

//-------------------------------------------------------------------------------------------
// HW_CAU_AESC_CAA - Accumulator register - AES Column Operation command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_AESC_CAA - Accumulator register - AES Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesc_caa
{
    uint32_t U;
    struct _hw_cau_aesc_caa_bitfields
    {
        uint32_t RESERVED0 : 32;       //!< [31:0]
    } B;
} hw_cau_aesc_caa_t;
#endif

/*!
 * @name Constants and macros for entire CAU_AESC_CAA register
 */
//@{
#define HW_CAU_AESC_CAA_ADDR     (REGS_CAU_BASE + 0xB04U)

#ifndef __LANGUAGE_ASM__
#define HW_CAU_AESC_CAA          (*(__O hw_cau_aesc_caa_t *) HW_CAU_AESC_CAA_ADDR)
#define HW_CAU_AESC_CAA_WR(v)    (HW_CAU_AESC_CAA.U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_AESC_CAA bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_CAU_AESC_CA - General Purpose Register 0 - AES Column Operation command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_AESC_CA - General Purpose Register 0 - AES Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesc_ca
{
    uint32_t U;
    struct _hw_cau_aesc_ca_bitfields
    {
        uint32_t RESERVED0 : 32;       //!< [31:0]
    } B;
} hw_cau_aesc_ca_t;
#endif

/*!
 * @name Constants and macros for entire CAU_AESC_CA register
 */
//@{
#define HW_CAU_AESC_CA_COUNT (9U)

#define HW_CAU_AESC_CA_ADDR(n)   (REGS_CAU_BASE + 0xB08U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_CAU_AESC_CA(n)        (*(__O hw_cau_aesc_ca_t *) HW_CAU_AESC_CA_ADDR(n))
#define HW_CAU_AESC_CA_WR(n, v)  (HW_CAU_AESC_CA(n).U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_AESC_CA bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_CAU_AESIC_CASR - Status register  - AES Inverse Column Operation command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_AESIC_CASR - Status register  - AES Inverse Column Operation command (WO)
 *
 * Reset value: 0x20000000U
 */
typedef union _hw_cau_aesic_casr
{
    uint32_t U;
    struct _hw_cau_aesic_casr_bitfields
    {
        uint32_t IC : 1;               //!< [0]
        uint32_t DPE : 1;              //!< [1]
        uint32_t RESERVED0 : 26;       //!< [27:2]
        uint32_t VER : 4;              //!< [31:28] CAU version
    } B;
} hw_cau_aesic_casr_t;
#endif

/*!
 * @name Constants and macros for entire CAU_AESIC_CASR register
 */
//@{
#define HW_CAU_AESIC_CASR_ADDR   (REGS_CAU_BASE + 0xB40U)

#ifndef __LANGUAGE_ASM__
#define HW_CAU_AESIC_CASR        (*(__O hw_cau_aesic_casr_t *) HW_CAU_AESIC_CASR_ADDR)
#define HW_CAU_AESIC_CASR_WR(v)  (HW_CAU_AESIC_CASR.U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_AESIC_CASR bitfields
 */

/*!
 * @name Register CAU_AESIC_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0 - No illegal commands issued
 * - 1 - Illegal command issued
 */
//@{
#define BP_CAU_AESIC_CASR_IC (0U)          //!< Bit position for CAU_AESIC_CASR_IC.
#define BM_CAU_AESIC_CASR_IC (0x00000001U) //!< Bit mask for CAU_AESIC_CASR_IC.
#define BS_CAU_AESIC_CASR_IC (1U)          //!< Bit field size in bits for CAU_AESIC_CASR_IC.

//! @brief Format value for bitfield CAU_AESIC_CASR_IC.
#define BF_CAU_AESIC_CASR_IC(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_AESIC_CASR_IC), uint32_t) & BM_CAU_AESIC_CASR_IC)
//@}

/*!
 * @name Register CAU_AESIC_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0 - No error detected
 * - 1 - DES key parity error detected
 */
//@{
#define BP_CAU_AESIC_CASR_DPE (1U)         //!< Bit position for CAU_AESIC_CASR_DPE.
#define BM_CAU_AESIC_CASR_DPE (0x00000002U) //!< Bit mask for CAU_AESIC_CASR_DPE.
#define BS_CAU_AESIC_CASR_DPE (1U)         //!< Bit field size in bits for CAU_AESIC_CASR_DPE.

//! @brief Format value for bitfield CAU_AESIC_CASR_DPE.
#define BF_CAU_AESIC_CASR_DPE(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_AESIC_CASR_DPE), uint32_t) & BM_CAU_AESIC_CASR_DPE)
//@}

/*!
 * @name Register CAU_AESIC_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0001 - Initial CAU version
 * - 0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
//@{
#define BP_CAU_AESIC_CASR_VER (28U)        //!< Bit position for CAU_AESIC_CASR_VER.
#define BM_CAU_AESIC_CASR_VER (0xF0000000U) //!< Bit mask for CAU_AESIC_CASR_VER.
#define BS_CAU_AESIC_CASR_VER (4U)         //!< Bit field size in bits for CAU_AESIC_CASR_VER.

//! @brief Format value for bitfield CAU_AESIC_CASR_VER.
#define BF_CAU_AESIC_CASR_VER(v) (__REG_VALUE_TYPE((__REG_VALUE_TYPE((v), uint32_t) << BP_CAU_AESIC_CASR_VER), uint32_t) & BM_CAU_AESIC_CASR_VER)
//@}

//-------------------------------------------------------------------------------------------
// HW_CAU_AESIC_CAA - Accumulator register - AES Inverse Column Operation command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_AESIC_CAA - Accumulator register - AES Inverse Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesic_caa
{
    uint32_t U;
    struct _hw_cau_aesic_caa_bitfields
    {
        uint32_t RESERVED0 : 32;       //!< [31:0]
    } B;
} hw_cau_aesic_caa_t;
#endif

/*!
 * @name Constants and macros for entire CAU_AESIC_CAA register
 */
//@{
#define HW_CAU_AESIC_CAA_ADDR    (REGS_CAU_BASE + 0xB44U)

#ifndef __LANGUAGE_ASM__
#define HW_CAU_AESIC_CAA         (*(__O hw_cau_aesic_caa_t *) HW_CAU_AESIC_CAA_ADDR)
#define HW_CAU_AESIC_CAA_WR(v)   (HW_CAU_AESIC_CAA.U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_AESIC_CAA bitfields
 */

//-------------------------------------------------------------------------------------------
// HW_CAU_AESIC_CA - General Purpose Register 0 - AES Inverse Column Operation command
//-------------------------------------------------------------------------------------------

#ifndef __LANGUAGE_ASM__
/*!
 * @brief HW_CAU_AESIC_CA - General Purpose Register 0 - AES Inverse Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_cau_aesic_ca
{
    uint32_t U;
    struct _hw_cau_aesic_ca_bitfields
    {
        uint32_t RESERVED0 : 32;       //!< [31:0]
    } B;
} hw_cau_aesic_ca_t;
#endif

/*!
 * @name Constants and macros for entire CAU_AESIC_CA register
 */
//@{
#define HW_CAU_AESIC_CA_COUNT (9U)

#define HW_CAU_AESIC_CA_ADDR(n)  (REGS_CAU_BASE + 0xB48U + (0x4U * n))

#ifndef __LANGUAGE_ASM__
#define HW_CAU_AESIC_CA(n)       (*(__O hw_cau_aesic_ca_t *) HW_CAU_AESIC_CA_ADDR(n))
#define HW_CAU_AESIC_CA_WR(n, v) (HW_CAU_AESIC_CA(n).U = (v))
#endif
//@}

/*
 * Constants & macros for individual CAU_AESIC_CA bitfields
 */

//-------------------------------------------------------------------------------------------
// hw_cau_t - module struct
//-------------------------------------------------------------------------------------------
/*!
 * @brief All CAU module registers.
 */
#ifndef __LANGUAGE_ASM__
#pragma pack(1)
typedef struct _hw_cau
{
    __O hw_cau_direct_t DIRECT[16];        //!< [0x0] Direct access register 0
    uint8_t _reserved0[2048];
    __O hw_cau_ldr_casr_t LDR_CASR;        //!< [0x840] Status register  - Load Register command
    __O hw_cau_ldr_caa_t LDR_CAA;          //!< [0x844] Accumulator register - Load Register command
    __O hw_cau_ldr_ca_t LDR_CA[9];         //!< [0x848] General Purpose Register 0 - Load Register command
    uint8_t _reserved1[20];
    __I hw_cau_str_casr_t STR_CASR;        //!< [0x880] Status register  - Store Register command
    __I hw_cau_str_caa_t STR_CAA;          //!< [0x884] Accumulator register - Store Register command
    __I hw_cau_str_ca_t STR_CA[9];         //!< [0x888] General Purpose Register 0 - Store Register command
    uint8_t _reserved2[20];
    __O hw_cau_adr_casr_t ADR_CASR;        //!< [0x8C0] Status register  - Add Register command
    __O hw_cau_adr_caa_t ADR_CAA;          //!< [0x8C4] Accumulator register - Add to register command
    __O hw_cau_adr_ca_t ADR_CA[9];         //!< [0x8C8] General Purpose Register 0 - Add to register command
    uint8_t _reserved3[20];
    __O hw_cau_radr_casr_t RADR_CASR;      //!< [0x900] Status register  - Reverse and Add to Register command
    __O hw_cau_radr_caa_t RADR_CAA;        //!< [0x904] Accumulator register - Reverse and Add to Register command
    __O hw_cau_radr_ca_t RADR_CA[9];       //!< [0x908] General Purpose Register 0 - Reverse and Add to Register command
    uint8_t _reserved4[84];
    __O hw_cau_xor_casr_t XOR_CASR;        //!< [0x980] Status register  - Exclusive Or command
    __O hw_cau_xor_caa_t XOR_CAA;          //!< [0x984] Accumulator register - Exclusive Or command
    __O hw_cau_xor_ca_t XOR_CA[9];         //!< [0x988] General Purpose Register 0 - Exclusive Or command
    uint8_t _reserved5[20];
    __O hw_cau_rotl_casr_t ROTL_CASR;      //!< [0x9C0] Status register  - Rotate Left command
    __O hw_cau_rotl_caa_t ROTL_CAA;        //!< [0x9C4] Accumulator register - Rotate Left command
    __O hw_cau_rotl_ca_t ROTL_CA[9];       //!< [0x9C8] General Purpose Register 0 - Rotate Left command
    uint8_t _reserved6[276];
    __O hw_cau_aesc_casr_t AESC_CASR;      //!< [0xB00] Status register  - AES Column Operation command
    __O hw_cau_aesc_caa_t AESC_CAA;        //!< [0xB04] Accumulator register - AES Column Operation command
    __O hw_cau_aesc_ca_t AESC_CA[9];       //!< [0xB08] General Purpose Register 0 - AES Column Operation command
    uint8_t _reserved7[20];
    __O hw_cau_aesic_casr_t AESIC_CASR;    //!< [0xB40] Status register  - AES Inverse Column Operation command
    __O hw_cau_aesic_caa_t AESIC_CAA;      //!< [0xB44] Accumulator register - AES Inverse Column Operation command
    __O hw_cau_aesic_ca_t AESIC_CA[9];     //!< [0xB48] General Purpose Register 0 - AES Inverse Column Operation command
} hw_cau_t;
#pragma pack()

//! @brief Macro to access all CAU registers.
//! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
//!     use the '&' operator, like <code>&HW_CAU</code>.
#define HW_CAU         (*(hw_cau_t *) REGS_CAU_BASE)
#endif

#endif // __HW_CAU_REGISTERS_H__
// v22/130726/0.9
// EOF

