#include "mbed.h"
#include "EthernetInterface.h"
#include "C12832_lcd.h"
#include "PubSubClient.h"

C12832_LCD lcd;
Serial pc(USBTX, USBRX);

char* serverIpAddr = "192.168.2.111";  /*Sever ip address*/
int port = 1883; /*Sever Port*/
void callback(char* topic, char* payload, unsigned int len); /*Callback function prototype*/
PubSubClient mqtt(serverIpAddr, port, callback);
EthernetInterface  eth;

void callback(char* topic, char* payload, unsigned int len)
{
    lcd.printf("Topic: %s\r\n", topic);
    lcd.printf("Payload: %s\r\n\r\n", payload);
    //Send incoming payloads back to topic "/mbed".
    mqtt.publish("mbed", payload, len);
}

int main() {

    eth.init(); //Use DHCP
    eth.connect();
    lcd.cls();
    lcd.locate(0,3);
    pc.printf("IP Address is %s\n", eth.getIPAddress());
    
    pc.printf("MQTTClient Tester");
    
    
    char clientID[] = "mbed";   /*Client nanme show for MQTT server*/
    char pub_topic[] = "mbed";   /*Publish to topic : "/mbed" */
    char sub_topic[] = "mirror";   /*Subscribe to topic : "/mirror" */
    
    if(!mqtt.connect(clientID)){
        pc.printf("\r\nConnect to server failed ..\r\n");
        return -1;
    }
    
    pc.printf("\r\nConnect to server sucessed ..\r\n");
    
    mqtt.publish(pub_topic, "Hello here is mbed...");
    mqtt.subscribe(sub_topic);
       
    
   pc.printf("#### End of the test.. ####");
      
   //eth.disconnect();
    
    while(1) {
    mqtt.loop();
    }
}