#include "mbed.h"
#include "ShiftBrite.h"


ShiftBrite::ShiftBrite(PinName latch, PinName enable,SPI& spi) : _spi(spi), _latch(latch), _enable(enable) {
    //Recomended Calabration levels for Brightness
    blue_level = green_level = 100;
    red_level = 120;    //red has a larger range of brightness than the others
    init();
}

void ShiftBrite::init(void) {
    
    Brightness(red_level,green_level,blue_level);
    
    _spi.format(16,0);
    _spi.frequency(500000);
    _red = 255;        //White
    _green = 255;
    _blue = 255;
}

void ShiftBrite::Write(int red,int green,int blue) {  //can hold up to 10 bits for each color
    _red = red;
    _green = green;
    _blue = blue;
    
    unsigned int low_color=0;
    unsigned int high_color=0;
    
    high_color=((_blue&0x3FF)<<4)|((_red&0x3C0)>>6);  //00bb bbbb bbbb rrrr
    low_color=(((_red&0x3F)<<10)|_green);     //rrrr rrgg gggg gggg
    
    
    _spi.write(high_color);
    _spi.write(low_color);
    
    _enable=1; //resync PWM counters - might flash without this with fast color updates
    _latch=1;
    wait(.000015);
    _latch=0;
    _enable=0;
    wait(.005);
    
}

//Change Brightness scaling levels
void ShiftBrite::Brightness(int redLevel,int greenLevel,int blueLevel) { // Levels can be 50..1023
    //Command for Brightness
    unsigned int Init_Command = 0x40000000;
    
    Init_Command = Init_Command|(blueLevel<<20)|(redLevel<<10)|greenLevel;
    _spi.write(Init_Command >> 16&0xFFFF);
    _spi.write(Init_Command &0xFFFF);
    
    wait(.000015);
    _latch=1;
    _enable =1;
    wait(.000015);
    _latch=0;
    _enable=0;
    

}
