//project_client_original
#include "mbed.h"
#include "EthernetInterface.h"
#include "C12832.h"

C12832 lcd(D11, D13, D12, D7, D10);
DigitalOut red(LED_RED);
DigitalOut green(LED_GREEN);
DigitalOut blue(LED_BLUE);

static const char* SERVER_IP = "192.168.1.1";
static const char* CLIENT_IP = "192.168.1.2";
static const char* MASK = "255.255.255.0";
static const char* GATEWAY = "192.168.1.1";
EthernetInterface eth;
//init 3 thread
Thread *transmitter;
Thread *receiver;
Thread *init;
void transmit(void const *args);
void receive(void const *args);
void init_eth(void const *args);
int n;
char counter[4]= {3,2,1,4};
char counter1[4]= {0};
//init eth point
void init_eth(void const *args)
{
    eth.init(CLIENT_IP, MASK, GATEWAY);
    int num=eth.connect();
    if(num!=-1) {
        transmitter= new Thread(transmit);
        receiver=new Thread(receive);
    }
}
//transmit function send information 
void transmit(void const *args)
{
    Endpoint server;
    UDPSocket sock;
    sock.init();
    server.set_address(SERVER_IP, 6503);
    while(1) {
        sock.sendTo(server, counter, sizeof(counter));
        lcd.locate(0,3);
        lcd.printf("send %d,%d,%d,%d",counter[0],counter[1],counter[2],counter[3]);
        wait(3);
    }
}
//receive function receive to array "counter1"
void receive(void const *args)
{
    UDPSocket server;
    Endpoint client;
    server.bind(6500);
    while(1) {
        client.set_address(CLIENT_IP,6500);
        n = server.receiveFrom(client, counter1, sizeof(counter1));
        lcd.locate(0,15);
        lcd.printf("receive %d,%d,%d,%d",counter1[0],counter1[1],counter1[2],counter1[3]);
        if(counter1[3]==0) {
            if (counter1[0]==0&&counter1[1]==0&&counter1[2]==1) {
                red =0;
                green=1;
                blue=1;
            } else if (counter1[0]==0&&counter1[1]==1&&counter1[2]==0) {
                green =0;
                red =1;
                blue =1;
            } else if(counter1[0]==1&&counter1[1]==0&&counter1[2]==0) {
                blue = 0;
                red =1;
                green =1;
            }
        }
    }
}
    int main() {
        blue =1;
        red =1;
        green =1;
        init=new Thread(init_eth);
        while (true) {
        }
    }