/* 
 Read from MH-Z14A CO2 Sensor by serial and show data to PC throw the softserial
 for LPC1768
 MH-Z14A Datasheet https://www.compel.ru/item-pdf/2ef21253651a5e4838151c427769e7b6/pn/winsen~mh-z14a-ndir-co2-sensor.pdf

*/

#include "mbed.h"
#include "SoftSerial.h" // by Erick Olieman https://os.mbed.com/users/Sissors/code/SoftSerial/

SoftSerial pc(p13,p14); //Tx,Rx to USB serial
Serial co2sensor(USBTX, USBRX); //Tx,Rx to mh-z14 CO2 sensor

int main() {
    
    pc.baud(9600);
    co2sensor.baud(9600); 
    
    char command[] = { 0xff , 0x01 , 0x86 , 0 , 0 , 0 , 0 , 0 , 0x79 }; //command of Read CO2 concentration
    char responds[9];
    
    
    while( co2sensor.readable() ) // throw received data away
        responds[0] = co2sensor.getc();
    while( pc.readable() ) // throw received data away
        responds[0] = pc.getc();
        
    long time=0;
   
    while(1) {
        
        //send command
        for( int i=0 ; i<9 ; i++ ) {
            while( co2sensor.writeable() == 0 );   //wait for writable a data
            co2sensor.putc( command[i] );
        }
        
        //receve responds
        unsigned char csm=0;    //clear check sum
        for( int i=0 ; i<9 ; i++ )  //clear responds variable
            responds[i] = 0;
        pc.printf("responds:");
        int i=0;
        for( int timeout = 0 ; timeout < 10000 ; timeout++ ) {        

            if( co2sensor.readable() ) {
                responds[i] = co2sensor.getc(  );
                pc.printf("%x ",responds[i]);
            
                if( responds[0] == 0xff ) {  // wether the first data is 0xff 
                    // sdd check sum
                    csm += responds[i];
                    timeout = 0;
                    i++;
                    if( i>8 )
                        break; // received all data
                }
            }
        }
        
        //check the check sum and show to PC
        csm -= responds[8];
        csm = ( 0xff - csm );
        if( responds[8] == csm ) {  // compare with check sum 
            pc.printf("csm:%x CO2:%dppm temp:%dC stat:%d," , csm , responds[2]*256 + responds[3] , responds[4]-40 , responds[5]);
            pc.printf("%d,%d,%d,%d\r" , time , responds[2]*256 + responds[3] , responds[4]-40 , responds[5]);
        }
        
        wait(1);
        time++;

    }
}
