#include "mbed.h"
#include "HYT.h"
#include "TextLCD.h"


TextLCD lcd(p15, p16, p17, p18, p19, p20);
Serial              pc(USBTX, USBRX);
Ticker              timeKeeping;
HYT                 SENSOR (p9, p10); // sda, scl
// HYT sensor polling cycle
void dataUpdate(void)
{
    SENSOR.MRCommand();
    wait(3);
    SENSOR.DFCommand();
}

void secondsCallback(void) {
    pc.printf("Humidity level: %.1f\r\n%", SENSOR.humidity);
    pc.printf("Temperature level: %.1f\r\n%", SENSOR.temperature);
    pc.printf("-------------------------------\r\n%", SENSOR.temperature);
    lcd.locate(1,0);
    lcd.printf("Humidity level: %.1f\r\n%", SENSOR.humidity);
}


char ReadT;
char ReadH;
DigitalOut TV(LED1);
DigitalOut TC1(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);


int main()
{
    timeKeeping.attach(&secondsCallback, 3.0f);

    while(1) {

        dataUpdate();
        ReadT = SENSOR.temperature;
        ReadH = SENSOR.humidity;
                if (ReadT < 25 && ReadH > 60){
            pc.printf(" Heating mode \r\n%");

                TV = 1;
                TC1 = 0;
            }
            else if (ReadT < 25 && ReadH < 50){
            pc.printf("Heating & Humidification \r\n%");
                TV = 1;
                TC1 =1;
            }
            else if (ReadT > 25 && ReadT <32  && ReadH >50){
            pc.printf(" Keep working \r\n%");
            }
            else{
            pc.printf(" Turn off \r\n%");
            TV = 0;
            TC1 = 0;
            }
    }
}
