#include "mbed.h"
#include "arm_math.h"
#include <stdio.h>
#include <string.h>
#include "datos.h"

#define NUM_TAPS              15
#define NUM_STAGES            3
float inDataFloat[frameLength];
float outDataFloat[frameLength];
float valorRMSFloat;
float valorRMSSinFiltro;
float valorRMSSinFiltroConvertido;
float valorRMSConvertido;
float meanSinFiltro;
float meanTrasFiltro;

Serial pc(USBTX, USBRX); // tx, rx

float  salida[frameLength];

const float32_t iirCoeffs32[NUM_TAPS] = {0.04475,-2.2348e-08,-0.044751,1.8954,-0.91178,0.04475,0.089501,0.04475,1.9116,-0.94211,0.04475,-0.089501,0.04475,1.9588,-0.96799 };


static float32_t iirStateF32[4*NUM_STAGES];

arm_biquad_casd_df1_inst_f32 S;

/// Tocar funciones de abajo

void init_procesado()
{
    arm_biquad_cascade_df1_init_f32(&S, NUM_STAGES, (float32_t *)&iirCoeffs32[0], &iirStateF32[0]);
}

void procesarfloat(float *inData,float *outData,int32_t length)
{
    arm_mean_f32(inData, length, &meanSinFiltro);
    arm_rms_f32(inData, length, &valorRMSSinFiltro);
    valorRMSSinFiltroConvertido = valorRMSSinFiltro*3.3f;

    arm_biquad_cascade_df1_f32(&S, inData, outData, length);

    arm_rms_f32(outData, length, &valorRMSFloat);
    valorRMSConvertido = valorRMSFloat*3.3f;
    arm_mean_f32(outData, length, &meanTrasFiltro);
}

// PROGRAMA PRINCIPAL
int main()
{
    pc.baud(115200);
    init_procesado();
    procesarfloat(datos,salida,frameLength);
    pc.printf("*******************************entrada\n");
    for (int n=0; n<frameLength; n++) {
        pc.printf("%f\n",datos[n]);
    }
    pc.printf("********************************salida\n");
    for (int n=0; n<frameLength; n++) {
        pc.printf("%f\n",salida[n]);
    }
    while(1) {
        wait(1000);
    }


}













