#include "mbed.h"


Serial pc(USBTX, USBRX); // tx, rx

#define muestras 100

struct Vectores {
    float  vectorA[muestras];
    float  vectorB[muestras];
} vectores;

struct Medidas {
    float  rms;
    float  media;
    float vpp;
} medidas;

AnalogIn analog_value(A0);
DigitalOut sal1(A1);
DigitalOut sal2(A2);
DigitalOut sal3(A3);
DigitalOut sal4(A4);
DigitalOut sal5(A5);
InterruptIn boton(USER_BUTTON);

int contador=0;
int flag=1;

void captura()
{
    float meas;
    if(flag==0){
        meas = analog_value.read(); // Converts and read the analog input value (value from 0.0 to 1.0)
        vectores.vectorA[contador] = meas; // Change the value to be in the 0 to 3300 range} 
        contador++;
        if(contador==muestras) {
            contador=0;
            flag=1;   
        }
    }
}

void flip()
{
    flag=0;
}

int main()
{
    sal1=0;
    sal2=0;
    sal3=0;
    sal4=0;
    sal5=0;

    Ticker timerCaptura;
    pc.printf("comienzo\n\r");
    timerCaptura.attach_us(&captura,400);
    boton.rise(&flip);
    while(1) {
        if(flag==1) {
            flag=2;
            pc.printf("ComienzoBuffer\n\r");
            for(int n=0;n<muestras;n++){
                pc.printf("%f\n\r",vectores.vectorA[n]);
                }
                pc.printf("FinBuffer\n\r");
        }
    }
}