#include "mbed.h"
#include "DS1820.h"

PwmOut coolerAndFans(D4);
PwmOut coolerAndPump(D5);
PwmOut radiator(D3);
PwmOut coffeeMaker(PA_0);

DigitalOut myled(LED1);
DigitalIn isOn(D6);

int main() {
    DS1820  ds1820(D2);    // substitute D8 with actual mbed pin name connected to the DS1820 data pin    
    ds1820.begin();
    bool wentDown = false;
    float temperature;
    radiator.period_ms(10);
    radiator.pulsewidth_ms(1);
    coolerAndFans.period_ms(10);
    coolerAndFans.pulsewidth_ms(1);
    coolerAndPump.period_ms(10);
    coolerAndPump.pulsewidth_ms(1);
    coffeeMaker.period_ms(10);
    coffeeMaker.pulsewidth_ms(1); 
    
    while(1) {
        myled = !myled;
        printf("temperature is %3.1f, and read is %d\n", ds1820.read(), isOn.read());
        temperature = ds1820.read();
        
        if(temperature >= 2 && wentDown)
            wentDown = false;
        
        if(isOn.read()){
            coolerAndFans.write(1);
            coolerAndPump.write(1);
            radiator.write(1);
            coffeeMaker.write(1);
            wait(1*60*7);
        }
        else{
            radiator.write(0);
            coffeeMaker.write(0);
            if(temperature >= 0 && !wentDown)
            {
                coolerAndPump.write(1);
                coolerAndFans.write(1);
            }
            else{
                wentDown = true;
                coolerAndPump.write(0);
                coolerAndFans.write(0);
            }
            radiator.write(0);
            coffeeMaker.write(0);
        }
        ds1820.startConversion();   // start temperature conversion

        wait(1);
    }
}
