// Sweep the motor speed from full-speed reverse (-1.0) to full speed forwards (1.0)
#include "mbed.h"
#include "ultrasonic.h"
#include "Motor.h"
#include "rtos.h"

Serial pc(USBTX, USBRX);
Motor leftWheel(p21, p20, p19);
Motor rightWheel(p22, p15, p14); // pwm, fwd, rev
float speed = 0.5;  
char input;

void dist(int distance) {
    //pc.printf("Distance %d mm\r\n", distance);
    if (distance < 200) {
        leftWheel.speed(0);
        rightWheel.speed(0);
    }
}

ultrasonic sonar(p6, p7, .1, 1, &dist);

void motor_thread(void const *args) {
    while(1) {
        if (pc.readable()) {
            input = pc.getc();

            switch (input) {
                case 'f':
                    leftWheel.speed(speed);
                    rightWheel.speed(speed);
                    break;            
            
                case 'b':
                    leftWheel.speed(-1 * speed);
                    rightWheel.speed(-1 * speed);
                    break;
            
                case 'l':
                    leftWheel.speed(-.4);
                    rightWheel.speed( .4);
                    wait(1.1); //Turn left 90deg
                    leftWheel.speed(0);
                    rightWheel.speed(0);
                    break;
            
                case 'r':  
                    leftWheel.speed(.4);
                    rightWheel.speed(-.4);
                    wait(1.1); //Turn right 90deg
                    leftWheel.speed(0);
                    rightWheel.speed(0);  
                    break;
                
                 case 's':   
                    leftWheel.speed(0);
                    rightWheel.speed(0);  
                    break;
                
                default:
                    break;
            }
        }
    }
}

int main() {
    pc.baud(115200);
    pc.printf("hello\n");
    Thread motor_t(motor_thread);
    sonar.startUpdates();
    while(1) {
        sonar.checkDistance();
    }   
}
