#include "Led_Lcd.h"
#include "LCD_DISCO_F429ZI.h"

LCD_DISCO_F429ZI lcd;

Led_Lcd::Led_Lcd(unsigned char ucColumnNo){    
    ucColumnNumber = ucColumnNo;
    
    lcd.Clear(LCD_COLOR_BLACK);
    lcd.SetFont(&Font24);
    lcd.SetBackColor(LCD_COLOR_RED);
 
    for (unsigned char ucLedCounter = 0; ucLedCounter < LED_COUNT; ucLedCounter++){
        DrawLed(ucLedCounter, RELEASED);
    }
}

void Led_Lcd::DrawLed(unsigned char ucLedNumber, LedState eLedState){
    char cBuffer[1];
    lcd.SetTextColor(LCD_COLOR_GREEN);
    lcd.DrawRect(80*ucColumnNumber,80*ucLedNumber,80,80);
    if (eLedState == PRESSED){
        lcd.SetTextColor(LCD_COLOR_GREEN);
    }
    else{
        lcd.SetTextColor(LCD_COLOR_BLUE);
    }
    lcd.FillRect(2+80*ucColumnNumber,2+80*ucLedNumber,77,77);
    sprintf(cBuffer,"%u",ucLedNumber);
    lcd.SetTextColor(LCD_COLOR_WHITE);
    lcd.DisplayStringAt(1+80*ucColumnNumber,1+80*ucLedNumber,(uint8_t *)&cBuffer, LEFT_MODE);
}

void Led_Lcd::On(unsigned char ucLedNo){
            DrawLed(ucLedNo, PRESSED);    
}

void Led_Lcd::Off(unsigned char ucLedNo){
            DrawLed(ucLedNo, RELEASED);    
}

void Led_Lcd::Led_Board(unsigned char ucLedNo){
     for (unsigned char ucLedCounter = 0; ucLedCounter < LED_COUNT; ucLedCounter++){
       if (ucLedCounter == ucLedNo)
        {
            On(ucLedCounter);
        }   
        else
        {
            Off(ucLedCounter);    
        }
    }
}
