/* FsHandler.cpp */
#include "mbed.h"
#include "FsHandler.h"
//#define DEBUG
#include "hl_debug.h"
#include "pwm_tone.h"

PwmOut Buzzer1(D5);
PwmOut Buzzer2(D6);
PwmOut Buzzer3(D11);
PwmOut Buzzer4(D12);

float C_3 = 1000000/Do3,
       Cs_3 = 1000000/Do3s,
       D_3 = 1000000/Re3,
       Ds_3 = 1000000/Re3s,
       E_3 = 1000000/Mi3,
       F_3 = 1000000/Fa3,
       Fs_3 = 1000000/Fa3s,
       G_3 = 1000000/So3,
       Gs_3 = 1000000/So3s,
       A_3 = 1000000/La3,
       As_3 = 1000000/La3s,
       B_3 = 1000000/Ti3,
       C_4 = 1000000/Do4,
       Cs_4 = 1000000/Do4s,
       D_4 = 1000000/Re4,
       Ds_4 = 1000000/Re4s,
       E_4 = 1000000/Mi4,
       F_4 = 1000000/Fa4,
       Fs_4 = 1000000/Fa4s,
       G_4 = 1000000/So4,
       Gs_4 = 1000000/So4s,
       A_4 = 1000000/La4,
       As_4 = 1000000/La4s,
       B_4 = 1000000/Ti4,
       C_5 = 1000000/Do5,
       Cs_5 = 1000000/Do5s,
       D_5 = 1000000/Re5,
       Ds_5 = 1000000/Re5s,
       E_5 = 1000000/Mi5,
       F_5 = 1000000/Fa5,
       Fs_5 = 1000000/Fa5s,
       G_5 = 1000000/So5,
       Gs_5 = 1000000/So5s,
       A_5 = 1000000/La5,
       As_5 = 1000000/La5s,
       B_5 = 1000000/Ti5,
       C_6 = 1000000/Do6,
       Cs_6 = 1000000/Do6s,
       D_6 = 1000000/Re6,
       Ds_6 = 1000000/Re6s,
       E_6 = 1000000/Mi6,
       F_6 = 1000000/Fa6,
       Fs_6 = 1000000/Fa6s,
       G_6 = 1000000/So6,
       Gs_6 = 1000000/So6s,
       A_6 = 1000000/La6,
       As_6 = 1000000/La6s,
       B_6 = 1000000/Ti6;
                             
int mario1[80] = {E_5,E_5,0,E_5,0,C_5,E_5,0,
                G_5,0,0,0,G_4,0,0,0,
                C_5,0,0,G_4,0,0,E_4,0,
                E_4,A_4,0,B_4,0,As_4,A_4,0,
                G_4,E_5,G_5,0,A_5,0,F_5,G_5,
                0,E_5,0,C_5,D_5,B_4,0,0,
                C_5,0,0,G_4,0,0,E_4,0,
                E_4,A_4,0,B_4,0,As_4,A_4,0,
                G_4,E_5,G_5,0,A_5,0,F_5,G_5,
                0,E_5,0,C_5,D_5,B_4,0,0
                }; 
int mario2[80] = {Fs_4,F_4,0,F_4,0,F_4,F_4,0,
                G_4,0,0,0,0,0,0,0,
                E_4,0,0,E_4,0,0,C_4,0,
                C_4,C_4,0,D_4,0,Cs_4,C_4,0,
                C_4,G_4,B_4,0,C_5,0,A_4,B_4,
                0,G_4,0,E_4,F_4,D_4,0,0,
                E_4,0,0,E_4,0,0,C_4,0,
                C_4,C_4,0,D_4,0,Cs_4,C_4,0,
                C_4,G_4,B_4,0,C_5,0,A_4,B_4,
                0,G_4,0,E_4,F_4,D_4,0,0
                };
int mario3[80] = {B_4,B_4,0,B_4,0,B_4,B_4,0,
                E_5,0,0,0,E_5,0,0,0,
                E_5,0,0,C_4,0,0,A_4,0,
                A_4,D_5,0,E_5,0,Ds_5,D_5,0,
                C_5,A_5,C_6,0,D_6,0,B_5,C_6,
                0,A_5,0,F_5,G_5,E_5,0,0,
                E_5,0,0,C_5,0,0,A_4,0,
                A_4,D_5,0,E_5,0,Ds_5,D_5,0,
                C_5,A_5,C_6,0,D_6,0,B_5,C_6,
                0,A_5,0,F_5,G_5,E_5,0,0
                };

//int love1[512] = {G_4,0,0,0,0,0,0,0,0,0,0,0,B_4,0,0,G_4,F_4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,E_4,0,0,0,0,0,0,0,0,0,0,0,C_5,0,0,G_4,D_4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,C_5,0,0,0,0,0,0,0,0,0,0,0,C_5,B_4,A_4,0,G_4,0,0,B_4,B_4,0,0,0,0,0,0,0,0,0,0,0,A_4,0,0,0,0,0,0,0,0,0,0,0,A_4,0,0,G_4,G_4,0,0,0,0,0,0,0,0,0,0,0,B_4,0,C_5,B_4,G_4,0,0,0,0,0,0,0,0,0,0,0,0,B_4,C_5,B_4,A_4,0,0,0,0,0,0,0,0,0,0,0,0,A_4,B_4,A_4,D_4,0,0,0,0,0,0,0,0,0,0,0,0,C_5,C_5,B_4,B_4,0,0,0,0,0,0,0,0,0,0,0,0,B_4,C_5,B_4,G_4,0,G_4,0,G_4,0,0,0,0,0,0,0,B_4,0,C_5,B_4,A_4,0,A_4,0,A_4,0,0,0,0,0,0,0,0,A_4,B_4,A_4,D_4,0,0,0,0,0,0,0,0,0,0,0,0,0,A_4,B_4,A_4,G_4,0,0,0,0,0,0,0,F_4,0,0,0,F_4,0,0,0,E_4,0,E_4,0,0,0,G_4,0,C_5,0,0,0,0,0,0,0,D_4,0,D_4,0,0,0,G_4,0,B_4,0,0,0,0,0,0,0,A_4,A_4,A_4,0,B_4,0,B_4,0,C_5,C_5,C_5,0,B_4,A_4,B_4,0,0,0,0,0,0,0,F_4,0,0,0,F_4,0,0,0,E_4,0,E_4,0,0,0,G_4,0,C_5,0,0,0,0,0,0,0,D_4,0,D_4,0,0,0,G_4,0,B_4,0,0,0,0,0,0,0,A_4,A_4,A_4,0,B_4,0,B_4,0,C_5,C_5,C_5,0,B_4,A_4,G_4,0,0,0,0,0,0,0,0,0,0,0,0,B_4,C_5,B_4,G_4,0,0,0,0,0,0,0,0,0,0,0,B_4,C_5,B_4,A_4,0,0,0,0,0,0,0,0,0,0,0,0,A_4,B_4,A_4,D_4,0,D_4,0,D_4,0,0,0,0,0,0,0,0,C_5,C_5,B_4,B_4,0,0,0,0,0,0,0,0,0,0,0,B_4,C_5,B_4,G_4,0,0,0,0,0,0,0,0,0,0,0,B_4,C_5,B_4,A_4,0,0,0,0,0,0,0,0,0,0,0,0,A_4,B_4,A_4,D_4,0,0,0,0,0,0,0,0,0,0,0,A_4,0,B_4,A_4,G_4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
//int love2[512] = {G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,D_3,0,0,0,D_3,0,0,0,D_3,0,0,0,D_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,D_3,0,0,0,D_3,0,0,0,D_3,0,0,0,D_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,D_3,0,0,0,D_3,0,0,0,D_3,0,0,0,D_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,D_3,0,0,0,D_3,0,0,0,D_3,0,0,0,D_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,C_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0};
//int love3[512] = {B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,E_3,0,0,0,E_3,0,0,0,E_3,0,0,0,E_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,E_3,0,0,0,E_3,0,0,0,E_3,0,0,0,E_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,E_3,0,0,0,E_3,0,0,0,E_3,0,0,0,E_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,E_3,0,0,0,E_3,0,0,0,E_3,0,0,0,E_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,Fs_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0,B_3,0,0,0};
//int love4[512] = {D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,G_3,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,A_3,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0,D_4,0,0,0};
                
int tones_num = 80;
int love_num = 512;

static int matchstrings(const char* one, const char* two)
{
    int m = 0;
    
    for (m = 0; m < min(strlen(one), strlen(two)) ; m++) {
        if (one[m] != two[m])
            return m;
    }
    return m;
}

std::map<const char*, const char*> HTTPFsRequestHandler::m_fsMap;
 
HTTPFsRequestHandler::HTTPFsRequestHandler(const char* rootPath, const char* localPath, HTTPConnection::HTTPMessage& Msg, TCPSocketConnection& Tcp)
    : HTTPRequestHandler(Msg, Tcp)
{
    m_rootPath = rootPath;
    m_localPath = localPath;
    
    string myPath = m_rootPath + m_localPath;
    
    //  Now replace the virtual root path with a mounted device path
    std::map<const char*, const char*>::iterator it;
    const char *bestMatch = NULL;
    const char *bestMatchExchange = NULL;
    int match_ind = -1;
    for (it = m_fsMap.begin() ; it != m_fsMap.end() ; it++) {
        //  find best match (if the given logical path is containted in the root
        int s = matchstrings(myPath.c_str(), it->second);
        INFO("Matching Root %s with handler %s results in %d identical characters\n", myPath.c_str(), it->second, s);
        if ((s == strlen(it->second)) && (s > match_ind)) {
            match_ind = s;
            bestMatch = it->first;
            bestMatchExchange = it->second;
        }
    }

    if (bestMatch != NULL) {
        m_rootPath = bestMatch;
        m_localPath = string(myPath).substr(strlen(bestMatchExchange));
    }
            
    handleRequest();
}

HTTPFsRequestHandler::~HTTPFsRequestHandler()
{
}

std::map<int, EthernetInterface*> HTTPFsRequestHandler::m_eth_list;

int HTTPFsRequestHandler::handleGetRequest()
{
    HTTPHeaders headers;
    EthernetInterface test_eth;
    int retval = 0;   //success
    
    if( std::string::npos != msg.uri.find("get_netinfo.cgi") )
    {
        char buf[256];
                
        sprintf(buf, "NetinfoCallback({\"mac\":\"%s\",\"ip\":\"%s\",\"sn\":\"%s\",\"gw\":\"%s\",\"temp\":\"%s\"});"
                    ,m_eth_list[0]->getMACAddress(),m_eth_list[0]->getIPAddress(),m_eth_list[0]->getNetworkMask(),m_eth_list[0]->getGateway());
                
        tcp.send(buf, strlen(buf));
    }
    
    else if( std::string::npos != msg.uri.find("get_ain.cgi") )
    {        
        char buf[256];
        
        //sprintf(buf, "AinCallback({\"ain_v0\":\"%.3f\",\"ain_v1\":\"%.3f\"});",ain0.read()*100, ain1.read()*100);
                
        tcp.send(buf, strlen(buf));
    }
    
    else //read html pages
    {
        if (m_localPath.length() > 4) 
            getStandardHeaders(headers, m_localPath.substr(m_localPath.length()-4).c_str());
        else
            getStandardHeaders(headers);
        
        INFO("Handling Get Request (root = %s, local = %s).", m_rootPath.c_str(), m_localPath.c_str());
        
        std::string reqPath;
    
        //  Check if we received a directory with the local bath
        if ((m_localPath.length() == 0) || (m_localPath.substr( m_localPath.length()-1, 1) == "/")) {
            //  yes, we shall append the default page name
            m_localPath += "index.html";
        }
        
        reqPath = m_rootPath + m_localPath;
        
        INFO("Mapping \"%s\" to \"%s\"", msg.uri.c_str(), reqPath.c_str());
            
        FILE *fp = fopen(reqPath.c_str(), "r");
        if (fp != NULL) {
            char * pBuffer = NULL;
            int sz = 8192;
            while( pBuffer == NULL) {
                sz /= 2;
                pBuffer = (char*)malloc(sz);
                if (sz < 128)
                    error ("OutOfMemory");
            }
            
            //  File was found and can be returned
        
            //  first determine the size
            fseek(fp, 0, SEEK_END);
            long size = ftell(fp);
            fseek(fp, 0, SEEK_SET);
        
            startResponse(200, size);
            while(!feof(fp) && !ferror(fp)) {
                int cnt = fread(pBuffer, 1, sz , fp);
                if (cnt < 0)
                    cnt = 0;
                processResponse(cnt, pBuffer);
            }
            delete pBuffer;
            endResponse();
            fclose(fp);
        }
        else {
            retval = 404;
            ERR("Requested file was not found !");
        }
    }
    
    return retval;
}

int HTTPFsRequestHandler::handlePostRequest()
{
    int pin = 0;
    int i;
    
    if( std::string::npos != msg.uri.find("set_LED.cgi") )
    {
        pin = get_http_param_value("pin");
        if(pin==0)   Tune(Buzzer1, C_4, 4);
        else if(pin==1) Tune(Buzzer1, Cs_4, 4);
        else if(pin==2) Tune(Buzzer1, D_4, 4);
        else if(pin==3) Tune(Buzzer1, Ds_4, 4);
        else if(pin==4) Tune(Buzzer1, E_4, 4);
        else if(pin==5) Tune(Buzzer1, F_4, 4);
        else if(pin==6) Tune(Buzzer1, Fs_4, 4);
        else if(pin==7) Tune(Buzzer1, G_4, 4);
        else if(pin==8) Tune(Buzzer1, Gs_4, 4);
        else if(pin==9) Tune(Buzzer1, A_4, 4);
        else if(pin==10) Tune(Buzzer1, As_4, 4);
        else if(pin==11) Tune(Buzzer1, B_4, 4);
        else if(pin==12) Tune(Buzzer1, C_5, 4);
        else if(pin==13) Tune(Buzzer1, Cs_5, 4);
        else if(pin==14) Tune(Buzzer1, D_5, 4);
        else if(pin==15) Tune(Buzzer1, Ds_5, 4);
        else if(pin==16) Tune(Buzzer1, E_5, 4);
        else if(pin==17) Tune(Buzzer1, F_5, 4);
        else if(pin==18) Tune(Buzzer1, Fs_5, 4);
        else if(pin==19) Tune(Buzzer1, G_5, 4);
        else if(pin==20) Tune(Buzzer1, Gs_5, 4);
        else if(pin==21) Tune(Buzzer1, A_5, 4);
        else if(pin==22) Tune(Buzzer1, As_5, 4);
        else if(pin==23) Tune(Buzzer1, B_5, 4);
        else
        {
            WARN("Wrong pin number");
        }   
        
        return 0;
    } 
    else if( std::string::npos != msg.uri.find("set_AUTO.cgi") )
    {
        pin = get_http_param_value("pin");
        if(pin==0)   
        {
            for(i=0; i<tones_num; i++)
            {
                Auto_tunes(Buzzer1, mario1[i], 1); // Auto performance
                Auto_tunes(Buzzer2, mario2[i], 1); // Auto performance
                Auto_tunes(Buzzer3, mario3[i], 1); // Auto performance
                Stop_tunes(Buzzer1);
                Stop_tunes(Buzzer2);
                Stop_tunes(Buzzer3);
            }
        }
        else if(pin == 1)
        {
            for(i=0; i<love_num; i++)
            {
                //Auto_tunes(Buzzer1, love1[i], 1); // Auto performance
                //Auto_tunes(Buzzer2, love2[i], 1); // Auto performance
                //Auto_tunes(Buzzer3, love3[i], 1); // Auto performance
                //Auto_tunes(Buzzer4, love4[i], 1); // Auto performance
                Stop_tunes(Buzzer1);
                Stop_tunes(Buzzer2);
                Stop_tunes(Buzzer3);
                Stop_tunes(Buzzer4);
            }
        }
        else if(pin == 99)
        {
            ;
        }    
        else
        {
            WARN("Wrong pin number");
        }   
        
        return 0;
    }   
    else
    {
           return 404;
    }
}

int HTTPFsRequestHandler::handlePutRequest()
{
    return 404;
}

uint32_t HTTPFsRequestHandler::get_http_param_value(char* param_name)
{
    uint8_t * name = 0;
    uint8_t * pos2;
    uint16_t len = 0;
    char value[10];
    uint32_t ret = 0;
    
    //msg.attri
    if((name = (uint8_t *)strstr(msg.attri, param_name)))
    {
        name += strlen(param_name) + 1;
        pos2 = (uint8_t*)strstr((char*)name, "&");
        if(!pos2)
        {
            pos2 = name + strlen((char*)name);
        }
        len = pos2 - name;
        
        if(len)
        {
            strncpy(value, (char*)name, len);
            ret = atoi(value);
        }
    }
    return ret;
}


