/**
 ******************************************************************************
 * @project Servo Motor example
 * @author  Justin Kim
 * @version V1.0.0
 * @date    08-APR-2016
 * @brief   Main program body
*******************************************************************************
**/

/* Includes ------------------------------------------------------------------*/
#include "mbed.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
Serial pc(USBTX, USBRX);
PwmOut motor(P9);

/* Private function prototypes -----------------------------------------------*/

/* Private functions ---------------------------------------------------------*/
/**
   * @brief     Main Function
   * @param     None
   * @retval    None
   */
int main(void)
{
    char ch;
    float speed = 0.0;
    pc.baud(115200);
    motor.period_us(1000000/490);
    pc.printf("Hello Motor World!\n\r");
            
    while(1)
    {
        if( pc.readable())
        {
            ch=pc.getc();
            pc.printf("%c",ch);
            
            if( ch == '+' )
            {
                speed = speed + 0.01;
                motor.write(speed);
                pc.printf("forward\r\n");
            }
            else if( ch == '-' )
            {
                speed = speed - 0.01;
                motor.write(speed);
                pc.printf("back\r\n");
            }
            else if( ch == '*' )
            { 
                speed = 0.55;
                motor.write(speed);
                pc.printf("stop\r\n");
            }
            
            if( speed < 0.55 ) 
            {
                speed = 0.55;
                motor.write(speed);
            }
            else if ( speed > 1.0 ) 
            {
                speed = 1.0;
                motor.write(speed);
            }
            pc.printf("speed %.3f\r\n", speed);
        }
    }
}
