#include "mbed.h"
#include "EthernetInterface.h"
#include "FsHandler.h"
#include "HTTPServer.h"
#include "SDFileSystem.h"

Serial pc(USBTX, USBRX);

SPI spi(PA_7, PA_6, PA_5); // mosi, miso, sclk
EthernetInterface eth(&spi, PB_6, PA_9);//scs(PB_6), nRESET(PA_9); // reset pin is dummy, don't affect any pin of WIZ550io
SDFileSystem local(PA_7, PA_6, PA_5, PB_5, "local");//PB_3, PB_2, PB_1, PB_0

HTTPServer  svr;

char ip_addr[] = "192.168.0.111";
char subnet_mask[] = "255.255.255.0";
char gateway_addr[] = "192.168.0.1";
uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0xff, 0xff, 0x10};

double duty;

int main()
{
    HTTPFsRequestHandler::mount_eth(&eth);
    HTTPFsRequestHandler::mount("/local/", "/");
    svr.addHandler<HTTPFsRequestHandler>("/");

    eth.init(mac_addr, ip_addr, subnet_mask, gateway_addr); //Not Use DHCP

    printf("Check Ethernet Link\r\n");
    while(1) //Wait link up
    {
        printf(".");
        if(eth.link() == true) 
            break;
    }
    printf("Link up\r\n");

    wait(3);
    
    eth.connect();
    
    printf("Server IP Address is %s\r\n", eth.getIPAddress());

    if (!svr.start(80, &eth)) {

        error("Server not starting !");
        exit(0);
    }

    while(1) {
        svr.poll();
    }
}
