/**
 ******************************************************************************
 * @project  mbed project 
 * @author  Justin Kim
 * @version V1.0.0
 * @date    00-AUG-2015
 * @brief   Main program body
*******************************************************************************
**/
/* Includes ------------------------------------------------------------------*/
#include "mbed.h"
#include "HMC5883L.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
DigitalOut  myled_R1(PC_1);
DigitalOut  myled_R2(PC_0);
DigitalOut  myled_R3(PA_2);
DigitalOut  myled_R4(PA_1);
DigitalOut  myled_G1(PA_0);
DigitalOut  myled_G2(PC_6);
DigitalOut  myled_G3(PC_7);
DigitalOut  myled_G4(PC_4);
DigitalOut  myled_Y1(PA_5);
DigitalOut  myled_Y2(PA_8);
DigitalOut  myled_Y3(PA_7);
DigitalOut  myled_Y4(PA_6);

Serial pc(USBTX,USBRX);    // default baud rate: 9600
HMC5883L hmc5883l;   
 
double Heading;
float DataBuf[3] ={0};

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
/**
   * @brief     Main Function
   * @param  None
   * @retval    None
   */
int main(void)
{
    hmc5883l.init();
    
    while(1) 
    {        
        Heading = hmc5883l.getHeading();
        
        pc.printf(" _______________\r\n");
        pc.printf("| Heading: %.1f   \r\n", Heading);
        pc.printf("|_______________\r\n\r\n");
        
        hmc5883l.readMagData(DataBuf);
        
        pc.printf(" _______________\r\n");
        pc.printf("| MagXout: %.1f   \r\n", DataBuf[0]);
        pc.printf("| MagYout: %.1f   \r\n", DataBuf[1]);
        pc.printf("| MagZout: %.1f   \r\n", DataBuf[2]);
        pc.printf("|_______________\r\n\r\n");
        
        if(225>Heading && Heading>135)
        {
            myled_R1 = 0;
            myled_R2 = 0;
            myled_R3 = 0;
            myled_R4 = 0;
            myled_G1 = 1;
            myled_G2 = 1;
            myled_G3 = 1;
            myled_G4 = 1;
            myled_Y1 = 0;
            myled_Y2 = 0;
            myled_Y3 = 0;
            myled_Y4 = 0;        
        }
        
        else if(135>Heading && Heading>0)
        {
            myled_R1 = 1;
            myled_R2 = 1;
            myled_R3 = 1;
            myled_R4 = 1;
            myled_G1 = 0;
            myled_G2 = 0;
            myled_G3 = 0;
            myled_G4 = 0;
            myled_Y1 = 0;
            myled_Y2 = 0;
            myled_Y3 = 0;
            myled_Y4 = 0;     
        }
        else if(360>Heading && Heading>225)
        {
            myled_R1 = 0;
            myled_R2 = 0;
            myled_R3 = 0;
            myled_R4 = 0;
            myled_G1 = 0;
            myled_G2 = 0;
            myled_G3 = 0;
            myled_G4 = 0;
            myled_Y1 = 1;
            myled_Y2 = 1;
            myled_Y3 = 1;
            myled_Y4 = 1;     
        }
    }
}
 
