#include "mbed.h"
#include "Adafruit_ST7735.h"
#include "SDFileSystem.h"

#define BUTTON_NONE 0
#define BUTTON_DOWN 1
#define BUTTON_RIGHT 2
#define BUTTON_SELECT 3
#define BUTTON_UP 4
#define BUTTON_LEFT 5

#define BUFFPIXEL 20
SDFileSystem sd(PB_3, PB_2, PB_1, PB_0, "SD"); // the pinout on the mbed
Adafruit_ST7735 tft(D11, D12, D13, D10, D8, D9); // MOSI, MISO, SCLK, SSEL, TFT_DC, TFT_RST
AnalogIn joystick(A3);

uint8_t readButton(void);
void bmpDraw(char *filename, uint8_t x, uint8_t y);

void main(void)
{
    uint8_t buttonhistory = 0;
    
    // Initialize 1.8" TFT
    tft.initR(INITR_BLACKTAB);   // initialize a ST7735S chip, black tab

    printf("OK!\r\n");
    tft.fillScreen(ST7735_BLACK);

    while(1)
    {
        uint8_t b = readButton();
        tft.setTextSize(3);
        if (b == BUTTON_DOWN) {
            tft.setTextColor(ST7735_RED);
            tft.setCursor(0, 10);
            tft.printf("Down ");
            buttonhistory |= 1;
        }
        if (b == BUTTON_LEFT) {
            tft.setTextColor(ST7735_YELLOW);
            tft.setCursor(0, 35);
             tft.printf("Left ");
            buttonhistory |= 2;
        }
        if (b == BUTTON_UP) {
            tft.setTextColor(ST7735_GREEN);
            tft.setCursor(0, 60);
            tft.printf("Up"); 
            buttonhistory |= 4;
        }
        if (b == BUTTON_RIGHT) {
            tft.setTextColor(ST7735_BLUE);
            tft.setCursor(0, 85);
            tft.printf("Right");
            buttonhistory |= 8;
        }
        if ((b == BUTTON_SELECT) && (buttonhistory == 0xF)) {
            tft.setTextColor(ST7735_MAGENTA);
            tft.setCursor(0, 110);
            tft.printf("SELECT");
            buttonhistory |= 8;
            wait_ms(2000);
            printf("Initializing SD card...\r\n");
//            if(tft.BMP_16(0, 0, "/SD/parrot.bmp"))
                printf("a\r\n");
                tft.DrawBitmapFile("/SD/parrot.bmp");
//            else
                printf("b\r\n");
        }
        wait_ms(100);
    }
}

uint8_t readButton(void) {
    float a = joystick.read();
      
    a *= 5.0;
          
    printf("Button read analog = %f\r\n",a);
    if (a < 0.2) return BUTTON_DOWN;
    if (a < 1.0) return BUTTON_RIGHT;
    if (a < 1.7) return BUTTON_SELECT;
    if (a < 2.6) return BUTTON_UP;
    if (a < 4.6) return BUTTON_LEFT;
    else return BUTTON_NONE;
}
