#include "mbed.h"
#include "Adafruit_ST7735.h"

#define BUTTON_NONE 0
#define BUTTON_DOWN 1
#define BUTTON_RIGHT 2
#define BUTTON_SELECT 3
#define BUTTON_UP 4
#define BUTTON_LEFT 5

Adafruit_ST7735 tft(D11, D12, D13, D10, D8, D9); // MOSI, MISO, SCLK, SSEL, TFT_DC, TFT_RST
AnalogIn joystick(A3);

uint8_t readButton(void);
void rotateLine(void);
void rotateText(void);
void rotatePixel(void);
void rotateFastline(void);
void rotateDrawrect(void);
void rotateFillrect(void);
void rotateDrawcircle(void);
void rotateFillcircle(void);
void rotateTriangle(void);
void rotateFillTriangle(void);
void rotateRoundRect(void);
void rotateFillRoundRect(void);
void rotateChar(void);
void rotateString(void);

int main(void)
{    
    printf("Hello! Adafruit ST7735 rotation test\r\n");

    // Use this initializer if you're using a 1.8" TFT
    tft.initR(INITR_BLACKTAB);   // initialize a ST7735S chip, black tab

    // Use this initializer (uncomment) if you're using a 1.44" TFT
    //tft.initR(INITR_144GREENTAB);   // initialize a ST7735S chip, black tab

    printf("init\r\n");

    tft.setTextWrap(false); // Allow text to run off right edge
    tft.fillScreen(ST7735_BLACK);
  
    printf("This is a test of the rotation capabilities of the TFT library!\r\n");
    printf("Press <SEND> (or type a character) to advance\r\n");

    while(1)
    {        
        rotateLine();
        rotateText();
        rotatePixel();
        rotateFastline();
        rotateDrawrect();
        rotateFillrect();
        rotateDrawcircle();
        rotateFillcircle();
        rotateTriangle();
        rotateFillTriangle();
        rotateRoundRect();
        rotateFillRoundRect();
        rotateChar();
        rotateString();
    }
}

void rotateLine(void) {
    
    uint8_t a = 0, b;
    
    b = readButton();
    
    for (uint8_t i=0; i<4; i++) {
        a = 1;
        tft.fillScreen(ST7735_BLACK);
    
        tft.drawLine(tft.width()/2, tft.height()/2, 0, 0, ST7735_RED);
        while (a){
        b = readButton();
        if(b==BUTTON_SELECT)
        a = 0;
        }
        
        tft.setRotation(tft.getRotation()+1);
    }
}

void rotateText(void) {
    uint8_t a = 0, b;
    
    b = readButton();
    
    for (uint8_t i=0; i<4; i++) {
        a = 1;
        tft.fillScreen(ST7735_BLACK);
    
        tft.setCursor(0, 30);
        tft.setTextColor(ST7735_RED);
        tft.setTextSize(1);
        tft.printf("Hello World!\r\n");
        tft.setTextColor(ST7735_YELLOW);
        tft.setTextSize(2);
        tft.printf("Hello World!\r\n");
        tft.setTextColor(ST7735_GREEN);
        tft.setTextSize(3);
        tft.printf("Hello World!\r\n");
        while (a){
        b = readButton();
        if(b==BUTTON_SELECT)
        a = 0;
        }        
        tft.setRotation(tft.getRotation()+1);
    }
}

void rotatePixel(void) {
    uint8_t a = 0, b;
    
    b = readButton();
    
    for (uint8_t i=0; i<4; i++) {
        a = 1;
        tft.fillScreen(ST7735_BLACK);
    
        tft.drawPixel(10,20, ST7735_WHITE);
        while (a){
        b = readButton();
        if(b==BUTTON_SELECT)
        a = 0;
        }
    
        tft.setRotation(tft.getRotation()+1);
    }
}

void rotateFastline(void) {
    uint8_t a = 0, b;
    
    b = readButton();
    
    for (uint8_t i=0; i<4; i++) {
        a = 1;
        tft.fillScreen(ST7735_BLACK);
    
        tft.drawFastHLine(0, 20, tft.width(), ST7735_RED);
        tft.drawFastVLine(20, 0, tft.height(), ST7735_BLUE);
    
        while (a){
        b = readButton();
        if(b==BUTTON_SELECT)
        a = 0;
        }
    
        tft.setRotation(tft.getRotation()+1);
    }
}

void rotateDrawrect(void) {
    uint8_t a = 0, b;
    
    b = readButton();
    
    for (uint8_t i=0; i<4; i++) {
        a = 1;
        tft.fillScreen(ST7735_BLACK);
    
        tft.drawRect(10, 20, 10, 20, ST7735_GREEN);
     
        while (a){
        b = readButton();
        if(b==BUTTON_SELECT)
        a = 0;
        }
    
        tft.setRotation(tft.getRotation()+1);
    }
}

void rotateFillrect(void) {
    uint8_t a = 0,b;
    
    b = readButton();
    
    for (uint8_t i=0; i<4; i++) {
        a = 1;
        tft.fillScreen(ST7735_BLACK);
    
        tft.fillRect(10, 20, 10, 20, ST7735_GREEN);
     
        while (a){
        b = readButton();
        if(b==BUTTON_SELECT)
        a = 0;
        }
    
        tft.setRotation(tft.getRotation()+1);
    }
}

void rotateDrawcircle(void) {
    uint8_t a = 0, b;
    
    b = readButton();
    
    for (uint8_t i=0; i<4; i++) {
        a = 1;
        tft.fillScreen(ST7735_BLACK);
    
        tft.drawCircle(10, 30, 10, ST7735_YELLOW);
     
        while (a){
        b = readButton();
        if(b==BUTTON_SELECT)
        a = 0;
        }
        
        tft.setRotation(tft.getRotation()+1);
    }
}

void rotateFillcircle(void) {
    uint8_t a = 0, b;
    
    b = readButton();
    
    for (uint8_t i=0; i<4; i++) {
        a = 1;
        tft.fillScreen(ST7735_BLACK);
    
        tft.fillCircle(10, 30, 10, ST7735_YELLOW);
    
        while (a){
        b = readButton();
        if(b==BUTTON_SELECT)
        a = 0;
        }
    
        tft.setRotation(tft.getRotation()+1);
    }
}

void rotateTriangle(void) {
    uint8_t a = 0, b;
    
    b = readButton();
    
    for (uint8_t i=0; i<4; i++) {
        a = 1;
        tft.fillScreen(ST7735_BLACK);
        tft.drawTriangle(20, 10, 10, 30, 30, 30, ST7735_GREEN);
        while (a){
        b = readButton();
        if(b==BUTTON_SELECT)
        a = 0;
        }
    
        tft.setRotation(tft.getRotation()+1);
    }
}

void rotateFillTriangle(void) {
  uint8_t a = 0, b;
  
  b = readButton();
  
  for (uint8_t i=0; i<4; i++) {
    a = 1;
    tft.fillScreen(ST7735_BLACK);
    tft.fillTriangle(20, 10, 10, 30, 30, 30, ST7735_RED);
        while (a){
        b = readButton();
        if(b==BUTTON_SELECT)
        a = 0;
        }

    tft.setRotation(tft.getRotation()+1);
  }
}

void rotateRoundRect(void) {
    uint8_t a = 0, b;
    
    b = readButton();
    
    for (uint8_t i=0; i<4; i++) {
        a = 1;
        tft.fillScreen(ST7735_BLACK);
        tft.drawRoundRect(20, 10, 25, 15, 5, ST7735_BLUE);
        while (a){
        b = readButton();
        if(b==BUTTON_SELECT)
        a = 0;
        }
    
        tft.setRotation(tft.getRotation()+1);
    }
}

void rotateFillRoundRect(void) {
    uint8_t a = 0, b;
    
    b = readButton();
    
    for (uint8_t i=0; i<4; i++) {
        a = 1;
        tft.fillScreen(ST7735_BLACK);
    
        tft.fillRoundRect(20, 10, 25, 15, 5, ST7735_CYAN);
        while (a){
        b = readButton();
        if(b==BUTTON_SELECT)
        a = 0;
        }
        
        tft.setRotation(tft.getRotation()+1);
    }
}

void rotateChar(void) {
    uint8_t a = 0, b;
    
    b = readButton();
    
    for (uint8_t i=0; i<4; i++) {
        a = 1;
        tft.fillScreen(ST7735_BLACK);
    
        tft.drawChar(25, 15, 'A', ST7735_WHITE, ST7735_WHITE, 1);
        while (a){
        b = readButton();
        if(b==BUTTON_SELECT)
        a = 0;
        }
    
        tft.setRotation(tft.getRotation()+1);
    }
}

void rotateString(void) {
    uint8_t a = 0, b;
    
    b = readButton();
    
    for (uint8_t i=0; i<4; i++) {
        a = 1;
        tft.fillScreen(ST7735_BLACK);
    
        tft.setCursor(8, 25);
        tft.setTextSize(1);
        tft.setTextColor(ST7735_WHITE);
        tft.printf("Adafruit Industries");        
        while (a){
        b = readButton();
        if(b==BUTTON_SELECT)
        a = 0;
        }
    
        tft.setRotation(tft.getRotation()+1);
    }
}

uint8_t readButton(void) {
    float a = joystick.read();
      
    a *= 5.0;
          
    printf("Button read analog = %f\r\n",a);
    if (a < 0.2) return BUTTON_DOWN;
    if (a < 1.0) return BUTTON_RIGHT;
    if (a < 1.7) return BUTTON_SELECT;
    if (a < 2.6) return BUTTON_UP;
    if (a < 4.6) return BUTTON_LEFT;
    else return BUTTON_NONE;
}

