#include "mbed.h"
#include "rtos.h"

Serial      pc(USBTX, USBRX);

DigitalOut redled(LED_RED);
DigitalOut greled(LED_GREEN);
DigitalOut bluled(LED_BLUE);
DigitalOut useled(LED_USER);

InterruptIn irq_data(P2_14);                                      // <--- Leave this line, blink_thread() won't run

SPI         spi_data(P10_14, P10_15, P10_12, P10_13);   // SPI0   // <--- Leave these two lines, nothing runs
RawSerial   uart_data(P8_14, P8_15);                    // UART4  // <-'


Thread h_task1_thread (osPriorityRealtime, 20480L, NULL);
Thread h_task2_thread (osPriorityHigh, 20480L, NULL);
Thread h_task3_thread (osPriorityNormal, 20480L, NULL);
Thread h_task4_thread (osPriorityLow, 20480L, NULL);
Thread h_blink_thread (osPriorityNormal, 20480L, NULL);

void blink_thread () {
    useled = 1;
    while (true) {
        Thread::signal_wait(0x1);
        useled = !useled;
    }
}

int main() {
    h_blink_thread.start(blink_thread);
    
    while(1) {
        bluled = 1;
        wait(0.2);
        bluled = 0;
        wait(0.2);
        h_blink_thread.signal_set(0x1);
    }
}
