#include "mbed.h"
#include <string>
#include "parse.h"
#include "sense.h"
#include "TextLCD.h"
#include "FXOS8700CQ.h"
#include <math.h>
#include "Dht11.h"
FXOS8700CQ fxos(PTE25,PTE24,FXOS8700CQ_SLAVE_ADDR1);
TextLCD lcd(PTC5,PTC7,D13,D12,D11,D10,TextLCD::LCD16x2);
Serial pc(USBTX, USBRX);
InterruptIn gearUp(PTA4);
InterruptIn gearDown(PTC6);
DigitalIn Nswitch(D7);
Serial blue(PTC15,PTC14);
Ticker display;
Ticker Wifi;
Ticker lean;
Ticker BLE;
Ticker th;
Dht11 sense(D3);
char rx[40];
Serial esp8266(PTC4,PTC3);
//DigitalOut myled(PTB22);
//DigitalOut myled3(PTB21);
info* currInfo = (info*) malloc(sizeof(struct info));
volatile bool flag = false;
long y = 0;
void gUp();
void gDown();
void updateDisplay();
void updateWifi();
void updateangle();
void onBluetoothReceived();
void flushBuff();
void updateTempH();

void onBluetoothReceived(void) {
        if(blue.readable()){
            //myled = !myled
            //pc.printf("Interrupt!\r\n");
            if(blue.readable()) blue.gets(rx,39);
            flushBuff();
            //pc.puts("Passed\r\n");
            //pc.puts("\n");
            //pc.puts(rx);
            //if(rx[0] == '['){
                //pc.puts(rx);
            //}
            //else
               //rx[0] = '\0';
        }
}

int main() 
{   
    initializeStruct(currInfo);
    th.attach(&updateTempH,5);
    lean.attach(&updateangle,.5);
    Wifi.attach(&updateWifi,1);
    BLE.attach(&onBluetoothReceived,.5);
    display.attach(&updateDisplay,.1);
    SetGear(currInfo,Nswitch);
    gearUp.rise(&gUp);
    gearDown.rise(&gDown);
    rx[0] = '\0';
    int status;
    currInfo->x = 0;
    //info* currInfo = (info*) malloc(sizeof(struct info));
    blue.attach(&onBluetoothReceived, Serial::RxIrq);
    blue.baud(115200);
    pc.baud(115200);
    esp8266.baud(115200);
    pc.printf("start!");
    // echo back characters and toggle the LED
    while (1) 
    {
        //pc.printf("%f %f %f %d \r\n",currInfo->x,currInfo->y,currInfo->speed,currInfo->gear);
        status = parse(rx,currInfo);
     }
}

void gUp(){
    currInfo->crash = 1;
    pc.printf("CRASH %d",currInfo->crash);
    if(currInfo->gear == 6)
        return;
    else if(currInfo->gear == 0){
        currInfo->gear = 2;
        return;
    }
    else
        currInfo->gear++;    
}

void gDown(){
    currInfo->crash = 0;
    if(currInfo->gear == 0)
        currInfo->gear++;
    else if(currInfo->gear == 1)
        return;
    else
        currInfo->gear--;    
}

void updateDisplay(){
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Angle: %d",currInfo->lean);
    lcd.locate(0,1);
    lcd.printf("m/s:%.2f G:%d",currInfo->speed,currInfo->gear);
}
void updateWifi(){     //[,WIFI,hr,temp,humidity,x,y,speed,lean,accel,gear,]
       esp8266.printf("[,WIFI,%d,%d,%d,%f,%f,%f,%d,%d,%d,%d,]",currInfo->hr,currInfo->temp,currInfo->humidity,currInfo->x,currInfo->y,currInfo->speed,currInfo->lean,currInfo->accel,currInfo->gear,currInfo->crash);
       //pc.printf("[,WIFI,%d,%d,%d,%f,%f,%f,%d,%d,%d,%d,]\r\n",currInfo->hr,currInfo->temp,currInfo->humidity,currInfo->x,currInfo->y,currInfo->speed,currInfo->lean,currInfo->accel,currInfo->gear,currInfo->crash);
}

float prevx = 0, prevy = 0, prevz = 0;
void updateangle(){
    SRAWDATA accdata,magdata;
    float ax,ay,az,mx,my,mz,axf,ayf,xh,yh;
    double xangle,yangle,zangle,heading;
    fxos.enable();
    fxos.get_data(&accdata,&magdata);
    ax = accdata.x;
    ay = accdata.y;
    az = accdata.z;
    //pc.printf("%f %f %f\r\n",ax,ay,az);
    xangle = atan2(ax, (sqrt(ay*ay + az*az)));
    xangle *= 180; xangle /= 3.141592;
    if(prevx - ax > 6144){
        currInfo->crash = 1;
    }
    currInfo->lean = (int)xangle;
    currInfo->accel = (float)((ax/4096)*9.8);
    //pc.printf("%d",currInfo->lean);
    prevx = ax;
    prevy = ay;
    prevz = az;
}
void flushBuff(){
    char temp = 0;
    while(blue.readable()){
        temp = blue.getc();
    }
    return;
}
void updateTempH(){
    sense.read();
    currInfo->temp = sense.getFahrenheit();
    currInfo->temp = currInfo->temp;
    currInfo->humidity = sense.getHumidity();
    currInfo->humidity = currInfo->humidity;
}