/*
 *
 * Made by Jurica Resetar @ aconno
 * More info @ aconno.de
 * All right reserved
 *
 */

#include "service_macros.h"

#define MAC_ADDR_SIZE_B (6)

extern const int advDataSize;

class MACService{
    public:
        const static uint16_t SERVICE_UUID = 0xA000;
        const static uint16_t ADV_DATA_UUID = 0xA001;
        const static uint16_t MAC_CHAR_UUID = 0xA002;

        MACService(BLEDevice &_ble, uint8_t *mac, uint8_t *initAdvData) : ble(_ble),
                MAC(MAC_CHAR_UUID, mac),
                advData(ADV_DATA_UUID, initAdvData, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY)
                {
                // Add characteristic in table
                GattCharacteristic *charTable[] = {&MAC, &advData};
                GattService MACService(SERVICE_UUID, charTable,
                    sizeof(charTable)/sizeof(GattCharacteristic *));
                ble.addService(MACService); // Add service in the BLE
        }
        inline void updateMacAddress(uint8_t  *MacAddress){
            ble.gattServer().write(MAC.getValueHandle(),
            MacAddress, MAC_ADDR_SIZE_B);
        }
        
        CHARACTERISTIC_A(ReadOnly, uint8_t, 25, advData, AdvData);
    
    private:
        BLEDevice &ble;
        // Create new characteristic
        ReadOnlyArrayGattCharacteristic<uint8_t, MAC_ADDR_SIZE_B> MAC;
};
