/**
 * Made by Jurica Resetar @ aconno
 * ResetarJurica@gmail.com
 * More info @ aconno.de
 *
 */

#ifndef __ACONNO_CONFIG_H__
#define __ACONNO_CONFIG_H__

/* Change these values bellow for iBeacon parameters setup */
#define UUID_INIT    0x00, 0x11, 0x22, 0x33, 	\
					 0x44, 0x55, 0x66, 0x77, 	\
					 0x88, 0x99, 0xAA, 0xBB,	\
					 0xCC, 0xDD, 0xEE, 0xFF
#define MAJOR 		(0xBABA)
#define MINOR 		(0xADDE)
#define RSSI_INIT	(-1)

#define UPDATE_SENSORS_TIME_MS			(1000)
#define V0 0.50    /* In volts */
#define TC 0.01    /* In volts */
#define VCC (3.6)
#define VALUE_TO_PERCENTAGE (100)
#define WAKEUP_TIME_DELAY_MS (150)
#define APPLICATION_ID (0xCF170059)

#define ADC_REFERENCE    (3.6f)    /* adc reference voltage */
#define ADC_RESOLUTION   (1024)    /* 10-bit adc            */

#define I2C_DATA (p19)
#define I2C_CLK  (p20)
#define SPI_MISO (p5)
#define SPI_MOSI (p3)
#define SPI_SCLK (p4)

#define DEBUG_PRINT     	(1)
#define SLEEP_TIME      	(0.150)          /* Sleep time in seconds 		*/
#define WAKE_UP_TIME    	(1)          /* Awake time in ms 			*/
#define ADV_INTERVAL    	(1000)           /* Advertising interval in ms 	*/
#define CALIBRATION_STEPS 	(20)
#define TX_POWER_DB      	(4)
#define INVERT_AXES			(1)

#endif // __ACONNO_CONFIG_H__
