/**
 * U-Blox SARA nb-iot module class
 * Made by Jurica Resetar @ aconno
 * More info @ aconno.de
 */

#ifndef __U_BLOX_SARA_H__
#define __U_BLOX_SARA_H__

#include "mbed.h"
#include "udp.h"

#define CUSTOM_BOARD            (1)

class UBloxSara
{
	public:
		UBloxSara(ATCmdParser *at, Udp udp);
		bool setup();
		void sendCommand(char *command);
		void sendUdpMsg(char *msg, char *flags = "");
		uint8_t connectNB();
		void checkNetworkStatus(char *response);
	private:
		ATCmdParser *_at;
		Udp _udp;
	protected:
};

#endif // __U_BLOX_SARA_H__
