/**
 * aconno helpers header
 */

#ifndef __ACONNO_HELPERS_H__
#define __ACONNO_HELPERS_H__

#include "gnss.h"

#define CHECK_TALKER(s) 		((buffer[3] == s[0]) && (buffer[4] == s[1]) && (buffer[5] == s[2]))

/**
 * Standard integer to string function
 * @param  num  	Integer to convert
 * @param  str  	Pointer to the buffer
 * @param  base 	Number's base
 * @return      	Pointer to the output string
 */

extern "C" char* itoa(int num, char* str, int base);

/**
 * Standard string reverse function
 * @param str 		Pointer to the string
 */
void reverse(char *str);

bool getGPSData(char *location, GnssSerial *gnss, uint32_t timeoutS = 0);

#endif	//
